{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GTcpWrapperConnection@ can be used to wrap a t'GI.Gio.Objects.IOStream.IOStream' that is
-- based on a t'GI.Gio.Objects.Socket.Socket', but which is not actually a
-- t'GI.Gio.Objects.SocketConnection.SocketConnection'. This is used by t'GI.Gio.Objects.SocketClient.SocketClient' so
-- that it can always return a t'GI.Gio.Objects.SocketConnection.SocketConnection', even when the
-- connection it has actually created is not directly a
-- t'GI.Gio.Objects.SocketConnection.SocketConnection'.
-- 
-- /Since: 2.28/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.TcpWrapperConnection
    ( 

-- * Exported types
    TcpWrapperConnection(..)                ,
    IsTcpWrapperConnection                  ,
    toTcpWrapperConnection                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearPending]("GI.Gio.Objects.IOStream#g:method:clearPending"), [close]("GI.Gio.Objects.IOStream#g:method:close"), [closeAsync]("GI.Gio.Objects.IOStream#g:method:closeAsync"), [closeFinish]("GI.Gio.Objects.IOStream#g:method:closeFinish"), [connect]("GI.Gio.Objects.SocketConnection#g:method:connect"), [connectAsync]("GI.Gio.Objects.SocketConnection#g:method:connectAsync"), [connectFinish]("GI.Gio.Objects.SocketConnection#g:method:connectFinish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hasPending]("GI.Gio.Objects.IOStream#g:method:hasPending"), [isClosed]("GI.Gio.Objects.IOStream#g:method:isClosed"), [isConnected]("GI.Gio.Objects.SocketConnection#g:method:isConnected"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [spliceAsync]("GI.Gio.Objects.IOStream#g:method:spliceAsync"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaseIoStream]("GI.Gio.Objects.TcpWrapperConnection#g:method:getBaseIoStream"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getGracefulDisconnect]("GI.Gio.Objects.TcpConnection#g:method:getGracefulDisconnect"), [getInputStream]("GI.Gio.Objects.IOStream#g:method:getInputStream"), [getLocalAddress]("GI.Gio.Objects.SocketConnection#g:method:getLocalAddress"), [getOutputStream]("GI.Gio.Objects.IOStream#g:method:getOutputStream"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRemoteAddress]("GI.Gio.Objects.SocketConnection#g:method:getRemoteAddress"), [getSocket]("GI.Gio.Objects.SocketConnection#g:method:getSocket").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setGracefulDisconnect]("GI.Gio.Objects.TcpConnection#g:method:setGracefulDisconnect"), [setPending]("GI.Gio.Objects.IOStream#g:method:setPending"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveTcpWrapperConnectionMethod       ,
#endif

-- ** getBaseIoStream #method:getBaseIoStream#

#if defined(ENABLE_OVERLOADING)
    TcpWrapperConnectionGetBaseIoStreamMethodInfo,
#endif
    tcpWrapperConnectionGetBaseIoStream     ,


-- ** new #method:new#

    tcpWrapperConnectionNew                 ,




 -- * Properties


-- ** baseIoStream #attr:baseIoStream#
-- | The wrapped t'GI.Gio.Objects.IOStream.IOStream'.
-- 
-- /Since: 2.28/

#if defined(ENABLE_OVERLOADING)
    TcpWrapperConnectionBaseIoStreamPropertyInfo,
#endif
    constructTcpWrapperConnectionBaseIoStream,
    getTcpWrapperConnectionBaseIoStream     ,
#if defined(ENABLE_OVERLOADING)
    tcpWrapperConnectionBaseIoStream        ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Flags as GLib.Flags
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DatagramBased as Gio.DatagramBased
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketControlMessage as Gio.SocketControlMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.TcpConnection as Gio.TcpConnection
import {-# SOURCE #-} qualified GI.Gio.Structs.InputMessage as Gio.InputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.InputVector as Gio.InputVector
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputMessage as Gio.OutputMessage
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.Socket as Gio.Socket
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketConnection as Gio.SocketConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.TcpConnection as Gio.TcpConnection

#endif

-- | Memory-managed wrapper type.
newtype TcpWrapperConnection = TcpWrapperConnection (SP.ManagedPtr TcpWrapperConnection)
    deriving (Eq)

instance SP.ManagedPtrNewtype TcpWrapperConnection where
    toManagedPtr (TcpWrapperConnection p) = p

foreign import ccall "g_tcp_wrapper_connection_get_type"
    c_g_tcp_wrapper_connection_get_type :: IO B.Types.GType

instance B.Types.TypedObject TcpWrapperConnection where
    glibType = c_g_tcp_wrapper_connection_get_type

instance B.Types.GObject TcpWrapperConnection

-- | Type class for types which can be safely cast to t'TcpWrapperConnection', for instance with `toTcpWrapperConnection`.
class (SP.GObject o, O.IsDescendantOf TcpWrapperConnection o) => IsTcpWrapperConnection o
instance (SP.GObject o, O.IsDescendantOf TcpWrapperConnection o) => IsTcpWrapperConnection o

instance O.HasParentTypes TcpWrapperConnection
type instance O.ParentTypes TcpWrapperConnection = '[Gio.TcpConnection.TcpConnection, Gio.SocketConnection.SocketConnection, Gio.IOStream.IOStream, GObject.Object.Object]

-- | Cast to t'TcpWrapperConnection', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toTcpWrapperConnection :: (MIO.MonadIO m, IsTcpWrapperConnection o) => o -> m TcpWrapperConnection
toTcpWrapperConnection = MIO.liftIO . B.ManagedPtr.unsafeCastTo TcpWrapperConnection

-- | Convert t'TcpWrapperConnection' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TcpWrapperConnection) where
    gvalueGType_ = c_g_tcp_wrapper_connection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TcpWrapperConnection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TcpWrapperConnection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TcpWrapperConnection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTcpWrapperConnectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTcpWrapperConnectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTcpWrapperConnectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTcpWrapperConnectionMethod "clearPending" o = Gio.IOStream.IOStreamClearPendingMethodInfo
    ResolveTcpWrapperConnectionMethod "close" o = Gio.IOStream.IOStreamCloseMethodInfo
    ResolveTcpWrapperConnectionMethod "closeAsync" o = Gio.IOStream.IOStreamCloseAsyncMethodInfo
    ResolveTcpWrapperConnectionMethod "closeFinish" o = Gio.IOStream.IOStreamCloseFinishMethodInfo
    ResolveTcpWrapperConnectionMethod "connect" o = Gio.SocketConnection.SocketConnectionConnectMethodInfo
    ResolveTcpWrapperConnectionMethod "connectAsync" o = Gio.SocketConnection.SocketConnectionConnectAsyncMethodInfo
    ResolveTcpWrapperConnectionMethod "connectFinish" o = Gio.SocketConnection.SocketConnectionConnectFinishMethodInfo
    ResolveTcpWrapperConnectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTcpWrapperConnectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTcpWrapperConnectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTcpWrapperConnectionMethod "hasPending" o = Gio.IOStream.IOStreamHasPendingMethodInfo
    ResolveTcpWrapperConnectionMethod "isClosed" o = Gio.IOStream.IOStreamIsClosedMethodInfo
    ResolveTcpWrapperConnectionMethod "isConnected" o = Gio.SocketConnection.SocketConnectionIsConnectedMethodInfo
    ResolveTcpWrapperConnectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTcpWrapperConnectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTcpWrapperConnectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTcpWrapperConnectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTcpWrapperConnectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTcpWrapperConnectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTcpWrapperConnectionMethod "spliceAsync" o = Gio.IOStream.IOStreamSpliceAsyncMethodInfo
    ResolveTcpWrapperConnectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTcpWrapperConnectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTcpWrapperConnectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTcpWrapperConnectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTcpWrapperConnectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTcpWrapperConnectionMethod "getBaseIoStream" o = TcpWrapperConnectionGetBaseIoStreamMethodInfo
    ResolveTcpWrapperConnectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTcpWrapperConnectionMethod "getGracefulDisconnect" o = Gio.TcpConnection.TcpConnectionGetGracefulDisconnectMethodInfo
    ResolveTcpWrapperConnectionMethod "getInputStream" o = Gio.IOStream.IOStreamGetInputStreamMethodInfo
    ResolveTcpWrapperConnectionMethod "getLocalAddress" o = Gio.SocketConnection.SocketConnectionGetLocalAddressMethodInfo
    ResolveTcpWrapperConnectionMethod "getOutputStream" o = Gio.IOStream.IOStreamGetOutputStreamMethodInfo
    ResolveTcpWrapperConnectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTcpWrapperConnectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTcpWrapperConnectionMethod "getRemoteAddress" o = Gio.SocketConnection.SocketConnectionGetRemoteAddressMethodInfo
    ResolveTcpWrapperConnectionMethod "getSocket" o = Gio.SocketConnection.SocketConnectionGetSocketMethodInfo
    ResolveTcpWrapperConnectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTcpWrapperConnectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTcpWrapperConnectionMethod "setGracefulDisconnect" o = Gio.TcpConnection.TcpConnectionSetGracefulDisconnectMethodInfo
    ResolveTcpWrapperConnectionMethod "setPending" o = Gio.IOStream.IOStreamSetPendingMethodInfo
    ResolveTcpWrapperConnectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTcpWrapperConnectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTcpWrapperConnectionMethod t TcpWrapperConnection, O.OverloadedMethod info TcpWrapperConnection p) => OL.IsLabel t (TcpWrapperConnection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTcpWrapperConnectionMethod t TcpWrapperConnection, O.OverloadedMethod info TcpWrapperConnection p, R.HasField t TcpWrapperConnection p) => R.HasField t TcpWrapperConnection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTcpWrapperConnectionMethod t TcpWrapperConnection, O.OverloadedMethodInfo info TcpWrapperConnection) => OL.IsLabel t (O.MethodProxy info TcpWrapperConnection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "base-io-stream"
   -- Type: TInterface (Name {namespace = "Gio", name = "IOStream"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@base-io-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' tcpWrapperConnection #baseIoStream
-- @
getTcpWrapperConnectionBaseIoStream :: (MonadIO m, IsTcpWrapperConnection o) => o -> m Gio.IOStream.IOStream
getTcpWrapperConnectionBaseIoStream obj = MIO.liftIO $ checkUnexpectedNothing "getTcpWrapperConnectionBaseIoStream" $ B.Properties.getObjectPropertyObject obj "base-io-stream" Gio.IOStream.IOStream

-- | Construct a t'GValueConstruct' with valid value for the “@base-io-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTcpWrapperConnectionBaseIoStream :: (IsTcpWrapperConnection o, MIO.MonadIO m, Gio.IOStream.IsIOStream a) => a -> m (GValueConstruct o)
constructTcpWrapperConnectionBaseIoStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "base-io-stream" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TcpWrapperConnectionBaseIoStreamPropertyInfo
instance AttrInfo TcpWrapperConnectionBaseIoStreamPropertyInfo where
    type AttrAllowedOps TcpWrapperConnectionBaseIoStreamPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TcpWrapperConnectionBaseIoStreamPropertyInfo = IsTcpWrapperConnection
    type AttrSetTypeConstraint TcpWrapperConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IsIOStream
    type AttrTransferTypeConstraint TcpWrapperConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IsIOStream
    type AttrTransferType TcpWrapperConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IOStream
    type AttrGetType TcpWrapperConnectionBaseIoStreamPropertyInfo = Gio.IOStream.IOStream
    type AttrLabel TcpWrapperConnectionBaseIoStreamPropertyInfo = "base-io-stream"
    type AttrOrigin TcpWrapperConnectionBaseIoStreamPropertyInfo = TcpWrapperConnection
    attrGet = getTcpWrapperConnectionBaseIoStream
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.IOStream.IOStream v
    attrConstruct = constructTcpWrapperConnectionBaseIoStream
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TcpWrapperConnection.baseIoStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TcpWrapperConnection.html#g:attr:baseIoStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TcpWrapperConnection
type instance O.AttributeList TcpWrapperConnection = TcpWrapperConnectionAttributeList
type TcpWrapperConnectionAttributeList = ('[ '("baseIoStream", TcpWrapperConnectionBaseIoStreamPropertyInfo), '("closed", Gio.IOStream.IOStreamClosedPropertyInfo), '("gracefulDisconnect", Gio.TcpConnection.TcpConnectionGracefulDisconnectPropertyInfo), '("inputStream", Gio.IOStream.IOStreamInputStreamPropertyInfo), '("outputStream", Gio.IOStream.IOStreamOutputStreamPropertyInfo), '("socket", Gio.SocketConnection.SocketConnectionSocketPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
tcpWrapperConnectionBaseIoStream :: AttrLabelProxy "baseIoStream"
tcpWrapperConnectionBaseIoStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TcpWrapperConnection = TcpWrapperConnectionSignalList
type TcpWrapperConnectionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TcpWrapperConnection::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "base_io_stream"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "IOStream" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GIOStream to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "socket"
--           , argType = TInterface Name { namespace = "Gio" , name = "Socket" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GSocket associated with @base_io_stream"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "TcpWrapperConnection" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tcp_wrapper_connection_new" g_tcp_wrapper_connection_new :: 
    Ptr Gio.IOStream.IOStream ->            -- base_io_stream : TInterface (Name {namespace = "Gio", name = "IOStream"})
    Ptr Gio.Socket.Socket ->                -- socket : TInterface (Name {namespace = "Gio", name = "Socket"})
    IO (Ptr TcpWrapperConnection)

-- | Wraps /@baseIoStream@/ and /@socket@/ together as a t'GI.Gio.Objects.SocketConnection.SocketConnection'.
-- 
-- /Since: 2.28/
tcpWrapperConnectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.IOStream.IsIOStream a, Gio.Socket.IsSocket b) =>
    a
    -- ^ /@baseIoStream@/: the t'GI.Gio.Objects.IOStream.IOStream' to wrap
    -> b
    -- ^ /@socket@/: the t'GI.Gio.Objects.Socket.Socket' associated with /@baseIoStream@/
    -> m TcpWrapperConnection
    -- ^ __Returns:__ the new t'GI.Gio.Objects.SocketConnection.SocketConnection'.
tcpWrapperConnectionNew baseIoStream socket = liftIO $ do
    baseIoStream' <- unsafeManagedPtrCastPtr baseIoStream
    socket' <- unsafeManagedPtrCastPtr socket
    result <- g_tcp_wrapper_connection_new baseIoStream' socket'
    checkUnexpectedReturnNULL "tcpWrapperConnectionNew" result
    result' <- (wrapObject TcpWrapperConnection) result
    touchManagedPtr baseIoStream
    touchManagedPtr socket
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TcpWrapperConnection::get_base_io_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "conn"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "TcpWrapperConnection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTcpWrapperConnection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "IOStream" })
-- throws : False
-- Skip return : False

foreign import ccall "g_tcp_wrapper_connection_get_base_io_stream" g_tcp_wrapper_connection_get_base_io_stream :: 
    Ptr TcpWrapperConnection ->             -- conn : TInterface (Name {namespace = "Gio", name = "TcpWrapperConnection"})
    IO (Ptr Gio.IOStream.IOStream)

-- | Gets /@conn@/\'s base t'GI.Gio.Objects.IOStream.IOStream'
tcpWrapperConnectionGetBaseIoStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsTcpWrapperConnection a) =>
    a
    -- ^ /@conn@/: a t'GI.Gio.Objects.TcpWrapperConnection.TcpWrapperConnection'
    -> m Gio.IOStream.IOStream
    -- ^ __Returns:__ /@conn@/\'s base t'GI.Gio.Objects.IOStream.IOStream'
tcpWrapperConnectionGetBaseIoStream conn = liftIO $ do
    conn' <- unsafeManagedPtrCastPtr conn
    result <- g_tcp_wrapper_connection_get_base_io_stream conn'
    checkUnexpectedReturnNULL "tcpWrapperConnectionGetBaseIoStream" result
    result' <- (newObject Gio.IOStream.IOStream) result
    touchManagedPtr conn
    return result'

#if defined(ENABLE_OVERLOADING)
data TcpWrapperConnectionGetBaseIoStreamMethodInfo
instance (signature ~ (m Gio.IOStream.IOStream), MonadIO m, IsTcpWrapperConnection a) => O.OverloadedMethod TcpWrapperConnectionGetBaseIoStreamMethodInfo a signature where
    overloadedMethod = tcpWrapperConnectionGetBaseIoStream

instance O.OverloadedMethodInfo TcpWrapperConnectionGetBaseIoStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.TcpWrapperConnection.tcpWrapperConnectionGetBaseIoStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-TcpWrapperConnection.html#v:tcpWrapperConnectionGetBaseIoStream"
        })


#endif


