/* nibbles-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nibbles-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2023-2024 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 */
/* designed for Gtk 4, link with libgtk-4-dev or gtk4-devel */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gee.h>
#include "libgnome-games-support.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>

#define NIBBLES_WINDOW_COUNTDOWN_TIME 3
#define NIBBLES_PROGRAM_NAME _ ("Nibbles")
#define NIBBLES_GAME_MAX_LEVEL 26
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_VIEW_WIDTH ((guint8) 92)
#define NIBBLES_VIEW_HEIGHT ((guint8) 66)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SETUP_SCREEN_USUAL,
	SETUP_SCREEN_SPEED,
	SETUP_SCREEN_CONTROLS,
	SETUP_SCREEN_GAME
} SetupScreen;

#define TYPE_SETUP_SCREEN (setup_screen_get_type ())

#define TYPE_ARE_YOU_SURE_WINDOW (are_you_sure_window_get_type ())
#define ARE_YOU_SURE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindow))
#define ARE_YOU_SURE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindowClass))
#define IS_ARE_YOU_SURE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARE_YOU_SURE_WINDOW))
#define IS_ARE_YOU_SURE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARE_YOU_SURE_WINDOW))
#define ARE_YOU_SURE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindowClass))

typedef struct _AreYouSureWindow AreYouSureWindow;
typedef struct _AreYouSureWindowClass AreYouSureWindowClass;
typedef struct _AreYouSureWindowPrivate AreYouSureWindowPrivate;
typedef void (*AreYouSureWindowAreYouSureResultFunction) (gboolean yes, gpointer user_data);
enum  {
	ARE_YOU_SURE_WINDOW_0_PROPERTY,
	ARE_YOU_SURE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* are_you_sure_window_properties[ARE_YOU_SURE_WINDOW_NUM_PROPERTIES];
typedef struct _Block3Data Block3Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NIBBLES_WINDOW (nibbles_window_get_type ())
#define NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_WINDOW, NibblesWindow))
#define NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_WINDOW, NibblesWindowClass))
#define IS_NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_WINDOW))
#define IS_NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_WINDOW))
#define NIBBLES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_WINDOW, NibblesWindowClass))

typedef struct _NibblesWindow NibblesWindow;
typedef struct _NibblesWindowClass NibblesWindowClass;
typedef struct _NibblesWindowPrivate NibblesWindowPrivate;

#define TYPE_PLAYERS (players_get_type ())
#define PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYERS, Players))
#define PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYERS, PlayersClass))
#define IS_PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYERS))
#define IS_PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYERS))
#define PLAYERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYERS, PlayersClass))

typedef struct _Players Players;
typedef struct _PlayersClass PlayersClass;

#define TYPE_SPEED (speed_get_type ())
#define SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SPEED, Speed))
#define SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SPEED, SpeedClass))
#define IS_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SPEED))
#define IS_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SPEED))
#define SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SPEED, SpeedClass))

typedef struct _Speed Speed;
typedef struct _SpeedClass SpeedClass;

#define TYPE_BOARD_PROGRESS (board_progress_get_type ())
#define BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_PROGRESS, BoardProgress))
#define BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_PROGRESS, BoardProgressClass))
#define IS_BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_PROGRESS))
#define IS_BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_PROGRESS))
#define BOARD_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_PROGRESS, BoardProgressClass))

typedef struct _BoardProgress BoardProgress;
typedef struct _BoardProgressClass BoardProgressClass;

#define TYPE_CONTROLS (controls_get_type ())
#define CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS, Controls))
#define CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS, ControlsClass))
#define IS_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS))
#define IS_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS))
#define CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS, ControlsClass))

typedef struct _Controls Controls;
typedef struct _ControlsClass ControlsClass;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_TRANSPARENT_CONTAINER (transparent_container_get_type ())
#define TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainer))
#define TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))
#define IS_TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPARENT_CONTAINER))
#define IS_TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPARENT_CONTAINER))
#define TRANSPARENT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))

typedef struct _TransparentContainer TransparentContainer;
typedef struct _TransparentContainerClass TransparentContainerClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_SOUND (sound_get_type ())
#define SOUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOUND, Sound))
#define SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOUND, SoundClass))
#define IS_SOUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOUND))
#define IS_SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOUND))
#define SOUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOUND, SoundClass))

typedef struct _Sound Sound;
typedef struct _SoundClass SoundClass;

#define NIBBLES_WINDOW_TYPE_DELEGATE_STACK (nibbles_window_delegate_stack_get_type ())
#define NIBBLES_WINDOW_DELEGATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStack))
#define NIBBLES_WINDOW_DELEGATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStackClass))
#define NIBBLES_WINDOW_IS_DELEGATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK))
#define NIBBLES_WINDOW_IS_DELEGATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_WINDOW_TYPE_DELEGATE_STACK))
#define NIBBLES_WINDOW_DELEGATE_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStackClass))

typedef struct _NibblesWindowDelegateStack NibblesWindowDelegateStack;
typedef struct _NibblesWindowDelegateStackClass NibblesWindowDelegateStackClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_WINDOW_0_PROPERTY,
	NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY,
	NIBBLES_WINDOW_PROGRESS_PROPERTY,
	NIBBLES_WINDOW_START_SCREEN_PROPERTY,
	NIBBLES_WINDOW_GAME_PAUSED_PROPERTY,
	NIBBLES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* nibbles_window_properties[NIBBLES_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _nibbles_window_delegate_stack_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_unref (var), NULL)))

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;
typedef enum  {
	NIBBLES_GAME_ESTATUS_GAMEOVER,
	NIBBLES_GAME_ESTATUS_VICTORY,
	NIBBLES_GAME_ESTATUS_NEWROUND
} NibblesGameeStatus;

#define NIBBLES_GAME_TYPE_ESTATUS (nibbles_game_estatus_get_type ())
typedef struct _NibblesWindowDelegateStackPrivate NibblesWindowDelegateStackPrivate;

#define NIBBLES_WINDOW_DELEGATE_STACK_TYPE_NODE (nibbles_window_delegate_stack_node_get_type ())
typedef struct _NibblesWindowDelegateStackNode NibblesWindowDelegateStackNode;
typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
#define _nibbles_window_delegate_stack_node_free0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_node_free (var), NULL)))

#define NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR (nibbles_window_delegate_stack_delegate_stack_iterator_get_type ())
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIterator))
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIteratorClass))
#define NIBBLES_WINDOW_DELEGATE_STACK_IS_DELEGATE_STACK_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR))
#define NIBBLES_WINDOW_DELEGATE_STACK_IS_DELEGATE_STACK_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR))
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIteratorClass))

typedef struct _NibblesWindowDelegateStackDelegateStackIterator NibblesWindowDelegateStackDelegateStackIterator;
typedef struct _NibblesWindowDelegateStackDelegateStackIteratorClass NibblesWindowDelegateStackDelegateStackIteratorClass;
typedef struct _NibblesWindowDelegateStackDelegateStackIteratorPrivate NibblesWindowDelegateStackDelegateStackIteratorPrivate;
typedef struct _NibblesWindowDelegateStackParamSpecDelegateStackIterator NibblesWindowDelegateStackParamSpecDelegateStackIterator;
typedef struct _NibblesWindowParamSpecDelegateStack NibblesWindowParamSpecDelegateStack;
#define _nibbles_window_delegate_stack_delegate_stack_iterator_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_delegate_stack_iterator_unref (var), NULL)))
typedef gint (*NibblesViewCountdownActiveFunction) (gpointer user_data);

#define TYPE_FIRST_RUN (first_run_get_type ())
#define FIRST_RUN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FIRST_RUN, FirstRun))
#define FIRST_RUN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FIRST_RUN, FirstRunClass))
#define IS_FIRST_RUN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FIRST_RUN))
#define IS_FIRST_RUN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FIRST_RUN))
#define FIRST_RUN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FIRST_RUN, FirstRunClass))

typedef struct _FirstRun FirstRun;
typedef struct _FirstRunClass FirstRunClass;
typedef struct _FirstRunPrivate FirstRunPrivate;
enum  {
	FIRST_RUN_0_PROPERTY,
	FIRST_RUN_NUM_PROPERTIES
};
static GParamSpec* first_run_properties[FIRST_RUN_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AreYouSureWindow {
	GtkWindow parent_instance;
	AreYouSureWindowPrivate * priv;
};

struct _AreYouSureWindowClass {
	GtkWindowClass parent_class;
};

struct _AreYouSureWindowPrivate {
	GtkLabel* line_one;
	GtkLabel* line_two;
	GtkButton* button_no;
	GtkButton* button_yes;
	AreYouSureWindowAreYouSureResultFunction result_function;
	gpointer result_function_target;
	GDestroyNotify result_function_target_destroy_notify;
};

struct _Block3Data {
	int _ref_count_;
	AreYouSureWindow* self;
	AreYouSureWindowAreYouSureResultFunction result_function;
	gpointer result_function_target;
};

struct _NibblesWindow {
	AdwApplicationWindow parent_instance;
	NibblesWindowPrivate * priv;
};

struct _NibblesWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _NibblesWindowPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	AdwHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GtkMenuButton* hamburger_menu;
	Players* players;
	Speed* speed;
	BoardProgress* board_progress;
	Controls* controls;
	GtkStack* statusbar_stack;
	Scoreboard* scoreboard;
	NibblesView* view;
	GtkBox* game_box;
	Sound* sound;
	NibblesWindowDelegateStack* keypress_handlers;
	NibblesGame* game;
	gint _cli_start_level;
	gint _progress;
	SetupScreen _start_screen;
	GamesScoresContext* scores_context;
	GeeLinkedList* scorecats;
	GSimpleAction* new_game_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	GSimpleAction* start_game_action;
	guint countdown_id;
	gint seconds;
	gboolean dialog_visible;
	GeeArrayList* overlay_members;
	gboolean end_of_game;
};

struct _Block4Data {
	int _ref_count_;
	NibblesWindow* self;
	AdwAlertDialog* dialog;
};

struct _Block5Data {
	int _ref_count_;
	NibblesWindow* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block6Data {
	int _ref_count_;
	NibblesWindow* self;
	gboolean should_unpause;
	gulong id;
};

struct _Block7Data {
	int _ref_count_;
	NibblesWindow* self;
	GtkButton* button;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint _progress;
	gint* levels_uncompleated;
	gint levels_uncompleated_length1;
	gint _levels_uncompleated_size_;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _NibblesWindowDelegateStack {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesWindowDelegateStackPrivate * priv;
};

struct _NibblesWindowDelegateStackClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesWindowDelegateStack *self);
};

struct _NibblesWindowDelegateStackNode {
	KeypressHandlerFunction keypress_handler;
	gpointer keypress_handler_target;
	NibblesWindowDelegateStackNode* pNext;
};

struct _NibblesWindowDelegateStackPrivate {
	NibblesWindowDelegateStackNode* pHead;
};

struct _NibblesWindowDelegateStackDelegateStackIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesWindowDelegateStackDelegateStackIteratorPrivate * priv;
};

struct _NibblesWindowDelegateStackDelegateStackIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesWindowDelegateStackDelegateStackIterator *self);
};

struct _NibblesWindowDelegateStackDelegateStackIteratorPrivate {
	NibblesWindowDelegateStackNode* pIterator;
	gboolean first_next;
};

struct _NibblesWindowDelegateStackParamSpecDelegateStackIterator {
	GParamSpec parent_instance;
};

struct _NibblesWindowParamSpecDelegateStack {
	GParamSpec parent_instance;
};

struct _FirstRun {
	GtkBox parent_instance;
	FirstRunPrivate * priv;
};

struct _FirstRunClass {
	GtkBoxClass parent_class;
};

struct _FirstRunPrivate {
	GtkButton* button;
};

static gint AreYouSureWindow_private_offset;
static gpointer are_you_sure_window_parent_class = NULL;
static gint NibblesWindow_private_offset;
static gpointer nibbles_window_parent_class = NULL;
static gint NibblesWindowDelegateStack_private_offset;
static gpointer nibbles_window_delegate_stack_parent_class = NULL;
static gint NibblesWindowDelegateStackDelegateStackIterator_private_offset;
static gpointer nibbles_window_delegate_stack_delegate_stack_iterator_parent_class = NULL;
static gint FirstRun_private_offset;
static gpointer first_run_parent_class = NULL;

VALA_EXTERN GType setup_screen_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType are_you_sure_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AreYouSureWindow, g_object_unref)
VALA_EXTERN AreYouSureWindow* are_you_sure_window_new (GtkWindow* w,
                                           const gchar* line1,
                                           const gchar* line2,
                                           AreYouSureWindowAreYouSureResultFunction result_function,
                                           gpointer result_function_target);
VALA_EXTERN AreYouSureWindow* are_you_sure_window_construct (GType object_type,
                                                 GtkWindow* w,
                                                 const gchar* line1,
                                                 const gchar* line2,
                                                 AreYouSureWindowAreYouSureResultFunction result_function,
                                                 gpointer result_function_target);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda49_ (Block3Data* _data3_);
static gboolean ___lambda49__gtk_window_close_request (GtkWindow* _sender,
                                                gpointer self);
static void __lambda50_ (Block3Data* _data3_);
static void ___lambda50__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda51_ (Block3Data* _data3_);
static void ___lambda51__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void are_you_sure_window_finalize (GObject * obj);
static GType are_you_sure_window_get_type_once (void);
VALA_EXTERN GType nibbles_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindow, g_object_unref)
VALA_EXTERN GType players_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Players, g_object_unref)
VALA_EXTERN GType speed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Speed, g_object_unref)
VALA_EXTERN GType board_progress_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardProgress, g_object_unref)
VALA_EXTERN GType controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Controls, g_object_unref)
VALA_EXTERN GType scoreboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scoreboard, g_object_unref)
VALA_EXTERN GType transparent_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransparentContainer, g_object_unref)
VALA_EXTERN GType nibbles_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesView, g_object_unref)
VALA_EXTERN GType sound_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sound, g_object_unref)
static gpointer nibbles_window_delegate_stack_ref (gpointer instance);
static void nibbles_window_delegate_stack_unref (gpointer instance);
static GParamSpec* nibbles_window_param_spec_delegate_stack (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_window_value_set_delegate_stack (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_window_value_take_delegate_stack (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_window_value_get_delegate_stack (const GValue* value) G_GNUC_UNUSED ;
static GType nibbles_window_delegate_stack_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindowDelegateStack, nibbles_window_delegate_stack_unref)
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
static void nibbles_window_new_game_cb (NibblesWindow* self);
static void _nibbles_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void nibbles_window_pause_cb (NibblesWindow* self);
static void _nibbles_window_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void nibbles_window_scores_cb (NibblesWindow* self);
static void _nibbles_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static inline void nibbles_window_next_screen_cb (NibblesWindow* self);
static void _nibbles_window_next_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void nibbles_window_start_game (NibblesWindow* self);
static void _nibbles_window_start_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void nibbles_window_back_cb (NibblesWindow* self);
static void _nibbles_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static NibblesWindowDelegateStack* nibbles_window_delegate_stack_new (void);
static NibblesWindowDelegateStack* nibbles_window_delegate_stack_construct (GType object_type);
static void nibbles_window_overlay_add (NibblesWindow* self,
                                 GtkWidget* widget);
static gboolean nibbles_window_overlay_remove_all (NibblesWindow* self);
VALA_EXTERN NibblesWindow* nibbles_window_new (gint cli_start_level,
                                   SetupScreen start_screen);
VALA_EXTERN NibblesWindow* nibbles_window_construct (GType object_type,
                                         gint cli_start_level,
                                         SetupScreen start_screen);
VALA_EXTERN void nibbles_window_on_shutdown (NibblesWindow* self);
VALA_EXTERN gint nibbles_game_get_speed (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_fakes (NibblesGame* self);
static gboolean nibbles_window_countdown_cb (NibblesWindow* self);
VALA_EXTERN void nibbles_view_redraw (NibblesView* self,
                          gboolean AnimateStep);
VALA_EXTERN void nibbles_game_start (NibblesGame* self,
                         gboolean add_initial_bonus);
VALA_EXTERN gboolean nibbles_game_get_paused (NibblesGame* self);
static void nibbles_window_set_pause_button_label (NibblesWindow* self,
                                            gboolean paused);
VALA_EXTERN void nibbles_game_reset (NibblesGame* self,
                         gint start_level);
static gint nibbles_window_get_start_level (NibblesWindow* self);
VALA_EXTERN void nibbles_game_new_level (NibblesGame* self,
                             gint level_id);
VALA_EXTERN gint nibbles_game_get_current_level (NibblesGame* self);
VALA_EXTERN void scoreboard_clear (Scoreboard* self);
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
VALA_EXTERN void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name);
VALA_EXTERN gchar* nibbles_view_colorval_name_untranslated (gint colorval);
VALA_EXTERN void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
VALA_EXTERN void nibbles_game_add_worms (NibblesGame* self);
static void nibbles_window_show_game_view (NibblesWindow* self);
static void nibbles_window_start_game_with_countdown (NibblesWindow* self);
static gboolean _nibbles_window_countdown_cb_gsource_func (gpointer self);
static void nibbles_window_restart_game (NibblesWindow* self);
static void nibbles_window_show_new_game_screen (NibblesWindow* self,
                                          gboolean after_first_run);
static void nibbles_window_show_new_game_dialog (NibblesWindow* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN gboolean nibbles_game_get_is_running (NibblesGame* self);
VALA_EXTERN void nibbles_game_stop (NibblesGame* self);
static void __lambda36_ (NibblesWindow* self,
                  const gchar* response);
static void ___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void __lambda37_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void nibbles_game_set_paused (NibblesGame* self,
                              gboolean value);
static void nibbles_window_settings_changed_cb (NibblesWindow* self,
                                         const gchar* key);
VALA_EXTERN void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
VALA_EXTERN void sound_set_muted (Sound* self,
                      gboolean muted);
VALA_EXTERN void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
VALA_EXTERN void nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                              gboolean value);
VALA_EXTERN void nibbles_view_redraw_all (NibblesView* self);
static void nibbles_window_worm_settings_changed_cb (NibblesWindow* self,
                                              GSettings* changed_worm_settings,
                                              const gchar* key);
VALA_EXTERN gint nibbles_game_get_numworms (NibblesGame* self);
VALA_EXTERN void worm_properties_set_color (WormProperties* self,
                                gint value);
VALA_EXTERN void worm_properties_set_up (WormProperties* self,
                             guint value);
VALA_EXTERN void worm_properties_set_down (WormProperties* self,
                               guint value);
VALA_EXTERN void worm_properties_set_left (WormProperties* self,
                               guint value);
VALA_EXTERN void worm_properties_set_right (WormProperties* self,
                                guint value);
VALA_EXTERN void worm_properties_set_raw_up (WormProperties* self,
                                 gint value);
VALA_EXTERN gint worm_properties_get_raw_up (WormProperties* self);
static gint nibbles_window_get_raw_key (NibblesWindow* self,
                                 guint keyval);
VALA_EXTERN guint worm_properties_get_up (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_down (WormProperties* self,
                                   gint value);
VALA_EXTERN gint worm_properties_get_raw_down (WormProperties* self);
VALA_EXTERN guint worm_properties_get_down (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_left (WormProperties* self,
                                   gint value);
VALA_EXTERN gint worm_properties_get_raw_left (WormProperties* self);
VALA_EXTERN guint worm_properties_get_left (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_right (WormProperties* self,
                                    gint value);
VALA_EXTERN gint worm_properties_get_raw_right (WormProperties* self);
VALA_EXTERN guint worm_properties_get_right (WormProperties* self);
VALA_EXTERN gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_window_update_start_game_action (NibblesWindow* self);
static void nibbles_window_show_board_progress_screen (NibblesWindow* self);
static void nibbles_window_show_speed_screen (NibblesWindow* self);
static void nibbles_window_leave_speed_screen (NibblesWindow* self);
static void nibbles_window_show_controls_screen (NibblesWindow* self);
static void nibbles_window_set_headerbar_title (NibblesWindow* self,
                                         const gchar* title);
VALA_EXTERN void board_progress_get_values (BoardProgress* self,
                                gint* progress,
                                gint* level);
VALA_EXTERN void nibbles_game_set_progress (NibblesGame* self,
                                gint value);
VALA_EXTERN void nibbles_game_set_start_level (NibblesGame* self,
                                   gint value);
VALA_EXTERN void players_get_values (Players* self,
                         gint* players_number,
                         gint* number_of_ais);
VALA_EXTERN void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
VALA_EXTERN void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
VALA_EXTERN void speed_get_values (Speed* self,
                       gint* speed,
                       gboolean* fakes);
VALA_EXTERN void controls_clean (Controls* self);
VALA_EXTERN void nibbles_game_create_worms (NibblesGame* self,
                                GeeArrayList* worm_settings);
VALA_EXTERN void controls_prepare (Controls* self,
                       GeeLinkedList* worms,
                       GeeHashMap* worms_props,
                       GeeList* worm_settings);
static GamesScoresCategory* nibbles_window_category_request (NibblesWindow* self,
                                                      const gchar* key);
static guint nibbles_window_category_speed (NibblesWindow* self,
                                     GamesScoresCategory* c);
static void nibbles_window_create_scores (NibblesWindow* self);
static GamesScoresCategory* _nibbles_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                  gpointer self);
static gboolean __lambda39_ (NibblesWindow* self,
                      GamesScoresCategory* a,
                      GamesScoresCategory* b);
static gboolean ___lambda39__games_scores_context_is_lower_order_category_func (GamesScoresCategory* a,
                                                                         GamesScoresCategory* b,
                                                                         gpointer self);
static GamesScoresCategory* nibbles_window_get_scores_category (NibblesWindow* self,
                                                         gint speed,
                                                         gboolean fakes);
static void nibbles_window_log_score_cb (NibblesWindow* self,
                                  gint score,
                                  gint level_reached);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void nibbles_window_game_over (NibblesWindow* self,
                               gint score,
                               glong lowest_high_score,
                               gint level_reached);
VALA_EXTERN gboolean nibbles_game_get_skip_score (NibblesGame* self);
static void __lambda40_ (Block5Data* _data5_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda38_ (Block6Data* _data6_);
static void ___lambda38__games_scores_context_dialog_closed (GamesScoresContext* _sender,
                                                      gpointer self);
static void nibbles_window_level_completed_cb (NibblesWindow* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda41_ (NibblesWindow* self);
static void ___lambda41__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda42_ (Block7Data* _data7_);
static gboolean ___lambda42__gsource_func (gpointer self);
VALA_EXTERN gint nibbles_game_get_progress (NibblesGame* self);
VALA_EXTERN GType nibbles_game_estatus_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NibblesGameeStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                                      const NibblesGameeStatus * s2);
static gint nibbles_window_countdown_active (NibblesWindow* self);
static gint nibbles_window_get_cli_start_level (NibblesWindow* self);
static void nibbles_window_set_cli_start_level (NibblesWindow* self,
                                         gint value);
VALA_EXTERN gint nibbles_window_get_progress (NibblesWindow* self);
VALA_EXTERN void nibbles_window_set_progress (NibblesWindow* self,
                                  gint value);
static SetupScreen nibbles_window_get_start_screen (NibblesWindow* self);
static void nibbles_window_set_start_screen (NibblesWindow* self,
                                      SetupScreen value);
VALA_EXTERN gboolean nibbles_window_get_game_paused (NibblesWindow* self);
static void nibbles_window_set_game_paused (NibblesWindow* self,
                                     gboolean value);
static GType nibbles_window_delegate_stack_node_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NibblesWindowDelegateStackNode* nibbles_window_delegate_stack_node_dup (const NibblesWindowDelegateStackNode* self);
static void nibbles_window_delegate_stack_node_free (NibblesWindowDelegateStackNode* self);
static void nibbles_window_delegate_stack_node_copy (const NibblesWindowDelegateStackNode* self,
                                              NibblesWindowDelegateStackNode* dest);
static void nibbles_window_delegate_stack_node_destroy (NibblesWindowDelegateStackNode* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NibblesWindowDelegateStackNode, nibbles_window_delegate_stack_node_destroy)
static void nibbles_window_delegate_stack_push (NibblesWindowDelegateStack* self,
                                         KeypressHandlerFunction handler,
                                         gpointer handler_target);
static gboolean nibbles_window_delegate_stack_pop (NibblesWindowDelegateStack* self);
static void nibbles_window_delegate_stack_remove (NibblesWindowDelegateStack* self,
                                           KeypressHandlerFunction handler,
                                           gpointer handler_target);
static gpointer nibbles_window_delegate_stack_delegate_stack_iterator_ref (gpointer instance);
static void nibbles_window_delegate_stack_delegate_stack_iterator_unref (gpointer instance);
static GParamSpec* nibbles_window_delegate_stack_param_spec_delegate_stack_iterator (const gchar* name,
                                                                              const gchar* nick,
                                                                              const gchar* blurb,
                                                                              GType object_type,
                                                                              GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_window_delegate_stack_value_set_delegate_stack_iterator (GValue* value,
                                                                      gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_window_delegate_stack_value_take_delegate_stack_iterator (GValue* value,
                                                                       gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_window_delegate_stack_value_get_delegate_stack_iterator (const GValue* value) G_GNUC_UNUSED ;
VALA_EXTERN GType nibbles_window_delegate_stack_delegate_stack_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindowDelegateStackDelegateStackIterator, nibbles_window_delegate_stack_delegate_stack_iterator_unref)
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_iterator (NibblesWindowDelegateStack* self);
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_delegate_stack_iterator_new (NibblesWindowDelegateStack* p);
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_delegate_stack_iterator_construct (GType object_type,
                                                                                                                  NibblesWindowDelegateStack* p);
static gboolean nibbles_window_delegate_stack_delegate_stack_iterator_next (NibblesWindowDelegateStackDelegateStackIterator* self);
static KeypressHandlerFunction nibbles_window_delegate_stack_delegate_stack_iterator_get (NibblesWindowDelegateStackDelegateStackIterator* self,
                                                                                   gpointer* result_target);
static void nibbles_window_delegate_stack_delegate_stack_iterator_finalize (NibblesWindowDelegateStackDelegateStackIterator * obj);
static GType nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once (void);
static void nibbles_window_delegate_stack_finalize (NibblesWindowDelegateStack * obj);
static GType nibbles_window_delegate_stack_get_type_once (void);
static GObject * nibbles_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _nibbles_window_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self);
static void _nibbles_window_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self);
static void _nibbles_window___lambda43_ (NibblesWindow* self);
static void __nibbles_window___lambda43__gtk_popover_closed (GtkPopover* _sender,
                                                      gpointer self);
static gboolean _nibbles_window___lambda44_ (NibblesWindow* self,
                                      GtkEventControllerKey* controller,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType state);
static gboolean __nibbles_window___lambda44__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self);
static void _nibbles_window___lambda45_ (NibblesWindow* self);
static void __nibbles_window___lambda45__gtk_event_controller_key_im_update (GtkEventControllerKey* _sender,
                                                                      gpointer self);
VALA_EXTERN Sound* sound_new (gboolean is_muted);
VALA_EXTERN Sound* sound_construct (GType object_type,
                        gboolean is_muted);
VALA_EXTERN NibblesGame* nibbles_game_new (gint start_level,
                               gint speed,
                               gint gamedelay,
                               gboolean fakes,
                               gboolean three_dimensional_view,
                               guint8 width,
                               guint8 height,
                               gboolean no_random);
VALA_EXTERN NibblesGame* nibbles_game_construct (GType object_type,
                                     gint start_level,
                                     gint speed,
                                     gint gamedelay,
                                     gboolean fakes,
                                     gboolean three_dimensional_view,
                                     guint8 width,
                                     guint8 height,
                                     gboolean no_random);
static void _nibbles_window_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                          gint score,
                                                          gint level_reached,
                                                          gpointer self);
static void _nibbles_window_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                                      gpointer self);
VALA_EXTERN void sound_connect_signal (Sound* self,
                           NibblesGame* game);
static gchar* _nibbles_window___lambda46_ (NibblesWindow* self);
static gchar* __nibbles_window___lambda46__nibbles_game_get_pkgdatadir (NibblesGame* _sender,
                                                                 gpointer self);
static gboolean _nibbles_window___lambda47_ (NibblesWindow* self,
                                      KeypressHandlerFunction handler,
                                      gpointer handler_target);
static gboolean __nibbles_window___lambda47__nibbles_game_add_keypress_handler (NibblesGame* _sender,
                                                                         KeypressHandlerFunction keypress_handler,
                                                                         gpointer keypress_handler_target,
                                                                         gpointer self);
static gint _nibbles_window_countdown_active_nibbles_view_countdown_active_function (gpointer self);
VALA_EXTERN NibblesView* nibbles_view_new (NibblesGame* game,
                               NibblesViewCountdownActiveFunction countdown_active,
                               gpointer countdown_active_target);
VALA_EXTERN NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game,
                                     NibblesViewCountdownActiveFunction countdown_active,
                                     gpointer countdown_active_target);
VALA_EXTERN void players_set_values (Players* self,
                         gint players_number,
                         gint number_of_ais);
VALA_EXTERN void board_progress_set_values (BoardProgress* self,
                                gint progress,
                                gint level);
VALA_EXTERN void speed_set_values (Speed* self,
                       gint speed,
                       gboolean fakes);
static void _nibbles_window___lambda48_ (NibblesWindow* self,
                                  KeypressHandlerFunction handler,
                                  gpointer handler_target);
static void __nibbles_window___lambda48__controls_add_keypress_handler (Controls* _sender,
                                                                 KeypressHandlerFunction handler,
                                                                 gpointer handler_target,
                                                                 gpointer self);
VALA_EXTERN GType first_run_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FirstRun, g_object_unref)
VALA_EXTERN FirstRun* first_run_new (void);
VALA_EXTERN FirstRun* first_run_construct (GType object_type);
static void nibbles_window_finalize (GObject * obj);
static GType nibbles_window_get_type_once (void);
static void _vala_nibbles_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_nibbles_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static GObject * first_run_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void first_run_finalize (GObject * obj);
static GType first_run_get_type_once (void);

static const GActionEntry NIBBLES_WINDOW_menu_entries[6] = {{"new-game", _nibbles_window_new_game_cb_gsimple_action_activate_callback}, {"pause", _nibbles_window_pause_cb_gsimple_action_activate_callback}, {"scores", _nibbles_window_scores_cb_gsimple_action_activate_callback}, {"next-screen", _nibbles_window_next_screen_cb_gsimple_action_activate_callback}, {"start-game", _nibbles_window_start_game_gsimple_action_activate_callback}, {"back", _nibbles_window_back_cb_gsimple_action_activate_callback}};

 G_GNUC_NO_INLINE static GType
setup_screen_get_type_once (void)
{
	static const GEnumValue values[] = {{SETUP_SCREEN_USUAL, "SETUP_SCREEN_USUAL", "usual"}, {SETUP_SCREEN_SPEED, "SETUP_SCREEN_SPEED", "speed"}, {SETUP_SCREEN_CONTROLS, "SETUP_SCREEN_CONTROLS", "controls"}, {SETUP_SCREEN_GAME, "SETUP_SCREEN_GAME", "game"}, {0, NULL, NULL}};
	GType setup_screen_type_id;
	setup_screen_type_id = g_enum_register_static ("SetupScreen", values);
	return setup_screen_type_id;
}

GType
setup_screen_get_type (void)
{
	static gsize setup_screen_type_id__once = 0;
	if (g_once_init_enter (&setup_screen_type_id__once)) {
		GType setup_screen_type_id;
		setup_screen_type_id = setup_screen_get_type_once ();
		g_once_init_leave (&setup_screen_type_id__once, setup_screen_type_id);
	}
	return setup_screen_type_id__once;
}

static inline gpointer
are_you_sure_window_get_instance_private (AreYouSureWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AreYouSureWindow_private_offset);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AreYouSureWindow* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda49_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	gboolean result;
	self = _data3_->self;
	_data3_->result_function (FALSE, _data3_->result_function_target);
	result = FALSE;
	return result;
}

static gboolean
___lambda49__gtk_window_close_request (GtkWindow* _sender,
                                       gpointer self)
{
	gboolean result;
	result = __lambda49_ (self);
	return result;
}

static void
__lambda50_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	self = _data3_->self;
	_data3_->result_function (FALSE, _data3_->result_function_target);
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda50__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda50_ (self);
}

static void
__lambda51_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	self = _data3_->self;
	_data3_->result_function (TRUE, _data3_->result_function_target);
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda51__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda51_ (self);
}

AreYouSureWindow*
are_you_sure_window_construct (GType object_type,
                               GtkWindow* w,
                               const gchar* line1,
                               const gchar* line2,
                               AreYouSureWindowAreYouSureResultFunction result_function,
                               gpointer result_function_target)
{
	AreYouSureWindow * self = NULL;
	Block3Data* _data3_;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_val_if_fail (w != NULL, NULL);
	g_return_val_if_fail (line1 != NULL, NULL);
	g_return_val_if_fail (line2 != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->result_function = result_function;
	_data3_->result_function_target = result_function_target;
	self = (AreYouSureWindow*) g_object_new (object_type, NULL);
	_data3_->self = g_object_ref (self);
	gtk_window_set_transient_for ((GtkWindow*) self, w);
	_tmp0_ = self->priv->line_one;
	gtk_label_set_label (_tmp0_, line1);
	_tmp1_ = self->priv->line_two;
	gtk_label_set_label (_tmp1_, line2);
	(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
	self->priv->result_function = NULL;
	self->priv->result_function_target = NULL;
	self->priv->result_function_target_destroy_notify = NULL;
	self->priv->result_function = (AreYouSureWindowAreYouSureResultFunction) _data3_->result_function;
	self->priv->result_function_target = _data3_->result_function_target;
	self->priv->result_function_target_destroy_notify = NULL;
	g_signal_connect_data ((GtkWindow*) self, "close-request", (GCallback) ___lambda49__gtk_window_close_request, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp2_ = self->priv->button_no;
	g_signal_connect_data (_tmp2_, "clicked", (GCallback) ___lambda50__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp3_ = self->priv->button_yes;
	g_signal_connect_data (_tmp3_, "clicked", (GCallback) ___lambda51__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

AreYouSureWindow*
are_you_sure_window_new (GtkWindow* w,
                         const gchar* line1,
                         const gchar* line2,
                         AreYouSureWindowAreYouSureResultFunction result_function,
                         gpointer result_function_target)
{
	return are_you_sure_window_construct (TYPE_ARE_YOU_SURE_WINDOW, w, line1, line2, result_function, result_function_target);
}

static void
are_you_sure_window_class_init (AreYouSureWindowClass * klass,
                                gpointer klass_data)
{
	are_you_sure_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AreYouSureWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = are_you_sure_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/are-you-sure.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "line_one", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, line_one));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "line_two", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, line_two));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_no", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, button_no));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_yes", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, button_yes));
}

static void
are_you_sure_window_instance_init (AreYouSureWindow * self,
                                   gpointer klass)
{
	self->priv = are_you_sure_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
are_you_sure_window_finalize (GObject * obj)
{
	AreYouSureWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindow);
	(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
	self->priv->result_function = NULL;
	self->priv->result_function_target = NULL;
	self->priv->result_function_target_destroy_notify = NULL;
	G_OBJECT_CLASS (are_you_sure_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
are_you_sure_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AreYouSureWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) are_you_sure_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AreYouSureWindow), 0, (GInstanceInitFunc) are_you_sure_window_instance_init, NULL };
	GType are_you_sure_window_type_id;
	are_you_sure_window_type_id = g_type_register_static (gtk_window_get_type (), "AreYouSureWindow", &g_define_type_info, 0);
	AreYouSureWindow_private_offset = g_type_add_instance_private (are_you_sure_window_type_id, sizeof (AreYouSureWindowPrivate));
	return are_you_sure_window_type_id;
}

GType
are_you_sure_window_get_type (void)
{
	static gsize are_you_sure_window_type_id__once = 0;
	if (g_once_init_enter (&are_you_sure_window_type_id__once)) {
		GType are_you_sure_window_type_id;
		are_you_sure_window_type_id = are_you_sure_window_get_type_once ();
		g_once_init_leave (&are_you_sure_window_type_id__once, are_you_sure_window_type_id);
	}
	return are_you_sure_window_type_id__once;
}

static inline gpointer
nibbles_window_get_instance_private (NibblesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindow_private_offset);
}

static void
_nibbles_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	nibbles_window_new_game_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	nibbles_window_pause_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	nibbles_window_scores_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_next_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	nibbles_window_next_screen_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_start_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	nibbles_window_start_game ((NibblesWindow*) self);
}

static void
_nibbles_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	nibbles_window_back_cb ((NibblesWindow*) self);
}

static void
nibbles_window_overlay_add (NibblesWindow* self,
                            GtkWidget* widget)
{
	GeeArrayList* _tmp0_;
	GtkOverlay* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->overlay_members;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, widget);
	_tmp1_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp1_, widget);
}

static gboolean
nibbles_window_overlay_remove_all (NibblesWindow* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->overlay_members;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	} else {
		{
			gint i = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp3_ = self->priv->overlay_members;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			i = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GtkOverlay* _tmp8_;
					GeeArrayList* _tmp9_;
					gpointer _tmp10_;
					GtkWidget* _tmp11_;
					GeeArrayList* _tmp12_;
					gpointer _tmp13_;
					GtkWidget* _tmp14_;
					if (!_tmp6_) {
						gint _tmp7_;
						i = i - 1;
						_tmp7_ = i;
					}
					_tmp6_ = FALSE;
					if (!(i > 0)) {
						break;
					}
					_tmp8_ = self->priv->overlay;
					_tmp9_ = self->priv->overlay_members;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, i - 1);
					_tmp11_ = (GtkWidget*) _tmp10_;
					gtk_overlay_remove_overlay (_tmp8_, _tmp11_);
					_g_object_unref0 (_tmp11_);
					_tmp12_ = self->priv->overlay_members;
					_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp12_, i - 1);
					_tmp14_ = (GtkWidget*) _tmp13_;
					_g_object_unref0 (_tmp14_);
				}
			}
		}
		result = TRUE;
		return result;
	}
}

NibblesWindow*
nibbles_window_construct (GType object_type,
                          gint cli_start_level,
                          SetupScreen start_screen)
{
	NibblesWindow * self = NULL;
	self = (NibblesWindow*) g_object_new (object_type, "cli-start-level", cli_start_level, "start-screen", start_screen, NULL);
	return self;
}

NibblesWindow*
nibbles_window_new (gint cli_start_level,
                    SetupScreen start_screen)
{
	return nibbles_window_construct (TYPE_NIBBLES_WINDOW, cli_start_level, start_screen);
}

void
nibbles_window_on_shutdown (NibblesWindow* self)
{
	GSettings* _tmp0_;
	gint window_width = 0;
	gint window_height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	NibblesGame* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GSettings* _tmp12_;
	NibblesGame* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GSettings* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	window_width = _tmp1_;
	window_height = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "window-width", window_width);
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, "window-height", window_height);
	_tmp5_ = self->priv->settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp5_, "window-is-maximized", _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->game;
	_tmp10_ = nibbles_game_get_speed (_tmp9_);
	_tmp11_ = _tmp10_;
	g_settings_set_int (_tmp8_, "speed", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->game;
	_tmp14_ = nibbles_game_get_fakes (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_boolean (_tmp12_, "fakes", _tmp15_);
	_tmp16_ = self->priv->settings;
	g_settings_apply (_tmp16_);
}

static gboolean
nibbles_window_countdown_cb (NibblesWindow* self)
{
	gint _tmp0_;
	NibblesView* _tmp1_;
	NibblesGame* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->seconds;
	self->priv->seconds = _tmp0_ - 1;
	_tmp1_ = self->priv->view;
	nibbles_view_redraw (_tmp1_, FALSE);
	_tmp2_ = self->priv->game;
	g_signal_emit_by_name (_tmp2_, "play-sound", "gobble");
	if (self->priv->seconds == 0) {
		GtkStack* _tmp3_;
		NibblesGame* _tmp4_;
		GSimpleAction* _tmp5_;
		_tmp3_ = self->priv->statusbar_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "scoreboard");
		_tmp4_ = self->priv->game;
		nibbles_game_start (_tmp4_, TRUE);
		_tmp5_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp5_, TRUE);
		self->priv->countdown_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
_scoreboard_update_g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
	scoreboard_update ((Scoreboard*) self);
}

static void
nibbles_window_start_game (NibblesWindow* self)
{
	GSettings* _tmp0_;
	NibblesGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	NibblesGame* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NibblesGame* _tmp7_;
	NibblesGame* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Scoreboard* _tmp11_;
	NibblesGame* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		nibbles_window_set_pause_button_label (self, FALSE);
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_window_get_start_level (self);
	_tmp6_ = _tmp5_;
	nibbles_game_reset (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->game;
	_tmp8_ = self->priv->game;
	_tmp9_ = nibbles_game_get_current_level (_tmp8_);
	_tmp10_ = _tmp9_;
	nibbles_game_new_level (_tmp7_, _tmp10_);
	_tmp11_ = self->priv->scoreboard;
	scoreboard_clear (_tmp11_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp12_;
		GeeLinkedList* _tmp13_;
		GeeLinkedList* _tmp14_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _worm_index = 0;
		_tmp12_ = self->priv->game;
		_tmp13_ = nibbles_game_get_worms (_tmp12_);
		_tmp14_ = _tmp13_;
		_worm_list = _tmp14_;
		_tmp15_ = _worm_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_worm_size = _tmp17_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp20_;
			gpointer _tmp21_;
			gint color = 0;
			NibblesGame* _tmp22_;
			GeeHashMap* _tmp23_;
			GeeHashMap* _tmp24_;
			Worm* _tmp25_;
			gpointer _tmp26_;
			WormProperties* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			Scoreboard* _tmp31_;
			Worm* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			Worm* _tmp35_;
			Scoreboard* _tmp36_;
			Worm* _tmp37_;
			Scoreboard* _tmp38_;
			_worm_index = _worm_index + 1;
			_tmp18_ = _worm_index;
			_tmp19_ = _worm_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _worm_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _worm_index);
			worm = (Worm*) _tmp21_;
			_tmp22_ = self->priv->game;
			_tmp23_ = nibbles_game_get_worm_props (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = worm;
			_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
			_tmp27_ = (WormProperties*) _tmp26_;
			_tmp28_ = worm_properties_get_color (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_g_object_unref0 (_tmp27_);
			color = _tmp30_;
			_tmp31_ = self->priv->scoreboard;
			_tmp32_ = worm;
			_tmp33_ = nibbles_view_colorval_name_untranslated (color);
			_tmp34_ = _tmp33_;
			scoreboard_register (_tmp31_, _tmp32_, _tmp34_);
			_g_free0 (_tmp34_);
			_tmp35_ = worm;
			_tmp36_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
			_tmp37_ = worm;
			_tmp38_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
			_g_object_unref0 (worm);
		}
	}
	_tmp39_ = self->priv->game;
	nibbles_game_add_worms (_tmp39_);
	nibbles_window_show_game_view (self);
	nibbles_window_start_game_with_countdown (self);
}

static gboolean
_nibbles_window_countdown_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_window_countdown_cb ((NibblesWindow*) self);
	return result;
}

static void
nibbles_window_start_game_with_countdown (NibblesWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	NibblesView* _tmp2_;
	NibblesGame* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	self->priv->seconds = NIBBLES_WINDOW_COUNTDOWN_TIME;
	_tmp2_ = self->priv->view;
	nibbles_view_redraw (_tmp2_, FALSE);
	_tmp3_ = self->priv->game;
	g_signal_emit_by_name (_tmp3_, "play-sound", "gobble");
	self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_window_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
nibbles_window_restart_game (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NibblesGame* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
	_tmp3_ = _tmp2_;
	nibbles_game_new_level (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->game;
	nibbles_game_add_worms (_tmp4_);
	nibbles_window_start_game_with_countdown (self);
}

static void
nibbles_window_new_game_cb (NibblesWindow* self)
{
	gchar* child_name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	child_name = _tmp2_;
	_tmp3_ = child_name;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if ((((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("first-run")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("number_of_players"))))) || (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("board-progress"))))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("speed"))))) {
		switch (0) {
			default:
			{
				nibbles_window_next_screen_cb (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				nibbles_window_start_game (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_window_overlay_remove_all (self);
				if (self->priv->end_of_game) {
					NibblesView* _tmp7_;
					_tmp7_ = self->priv->view;
					gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
					self->priv->end_of_game = FALSE;
					nibbles_window_show_new_game_screen (self, FALSE);
				} else {
					if (!self->priv->dialog_visible) {
						nibbles_window_show_new_game_dialog (self);
					}
				}
				break;
			}
		}
	}
	_g_free0 (child_name);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NibblesWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda36_ (NibblesWindow* self,
             const gchar* response)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (response != NULL);
	self->priv->dialog_visible = FALSE;
	if (g_strcmp0 (response, "new-game") == 0) {
		nibbles_window_show_new_game_screen (self, FALSE);
	}
	if (g_strcmp0 (response, "new-game") != 0) {
		NibblesGame* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = nibbles_game_get_paused (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesView* _tmp5_;
		if (self->priv->seconds == 0) {
			NibblesGame* _tmp4_;
			_tmp4_ = self->priv->game;
			nibbles_game_start (_tmp4_, FALSE);
		} else {
			self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_window_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp5_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
}

static void
___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda36_ ((NibblesWindow*) self, response);
}

static void
__lambda37_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	NibblesWindow* self;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	adw_alert_dialog_choose_finish (_data4_->dialog, res);
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ (self, source_object, res);
	block4_data_unref (self);
}

static void
nibbles_window_show_new_game_dialog (NibblesWindow* self)
{
	Block4Data* _data4_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	AdwAlertDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	if (self->priv->countdown_id != ((guint) 0)) {
		g_source_remove (self->priv->countdown_id);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	_tmp4_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("New Game?"), _ ("If you start a new game, the current one will be lost"));
	g_object_ref_sink (_tmp4_);
	_data4_->dialog = _tmp4_;
	adw_alert_dialog_add_response (_data4_->dialog, "cancel", _ ("_Cancel"));
	adw_alert_dialog_add_response (_data4_->dialog, "new-game", _ ("_New Game"));
	adw_alert_dialog_set_response_appearance (_data4_->dialog, "new-game", ADW_RESPONSE_DESTRUCTIVE);
	g_signal_connect_object (_data4_->dialog, "response", (GCallback) ___lambda36__adw_alert_dialog_response, self, 0);
	adw_alert_dialog_choose (_data4_->dialog, (GtkWidget*) self, NULL, ___lambda37__gasync_ready_callback, block4_data_ref (_data4_));
	self->priv->dialog_visible = TRUE;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
nibbles_window_pause_cb (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_;
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		NibblesGame* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		NibblesGame* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp1_ = self->priv->game;
		_tmp2_ = self->priv->game;
		_tmp3_ = nibbles_game_get_is_running (_tmp2_);
		_tmp4_ = _tmp3_;
		nibbles_game_set_paused (_tmp1_, _tmp4_);
		_tmp5_ = self->priv->game;
		_tmp6_ = nibbles_game_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		nibbles_window_set_pause_button_label (self, _tmp7_);
		_tmp8_ = self->priv->game;
		_tmp9_ = nibbles_game_get_paused (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			GtkStack* _tmp11_;
			_tmp11_ = self->priv->statusbar_stack;
			gtk_stack_set_visible_child_name (_tmp11_, "paused");
		} else {
			GtkStack* _tmp12_;
			NibblesView* _tmp13_;
			_tmp12_ = self->priv->statusbar_stack;
			gtk_stack_set_visible_child_name (_tmp12_, "scoreboard");
			_tmp13_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp13_);
		}
	}
}

static void
nibbles_window_set_pause_button_label (NibblesWindow* self,
                                       gboolean paused)
{
	g_return_if_fail (self != NULL);
	if (paused) {
		GtkButton* _tmp0_;
		GtkButton* _tmp1_;
		_tmp0_ = self->priv->pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _ ("Resume"));
		_tmp1_ = self->priv->pause_button;
		gtk_button_set_icon_name (_tmp1_, "media-playback-start-symbolic");
	} else {
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		_tmp2_ = self->priv->pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Pause"));
		_tmp3_ = self->priv->pause_button;
		gtk_button_set_icon_name (_tmp3_, "media-playback-pause-symbolic");
	}
}

static void
nibbles_window_settings_changed_cb (NibblesWindow* self,
                                    const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->game;
				_tmp4_ = self->priv->settings;
				nibbles_game_set_speed (_tmp3_, g_settings_get_int (_tmp4_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("sound")))) {
		switch (0) {
			default:
			{
				Sound* _tmp5_;
				GSettings* _tmp6_;
				_tmp5_ = self->priv->sound;
				_tmp6_ = self->priv->settings;
				sound_set_muted (_tmp5_, !g_settings_get_boolean (_tmp6_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("fakes")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp7_;
				GSettings* _tmp8_;
				_tmp7_ = self->priv->game;
				_tmp8_ = self->priv->settings;
				nibbles_game_set_fakes (_tmp7_, g_settings_get_boolean (_tmp8_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("three-dimensional-view")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp9_;
				GSettings* _tmp10_;
				NibblesView* _tmp11_;
				_tmp9_ = self->priv->game;
				_tmp10_ = self->priv->settings;
				nibbles_game_set_three_dimensional_view (_tmp9_, g_settings_get_boolean (_tmp10_, key));
				_tmp11_ = self->priv->view;
				if (NULL != _tmp11_) {
					NibblesView* _tmp12_;
					_tmp12_ = self->priv->view;
					nibbles_view_redraw_all (_tmp12_);
				}
				break;
			}
		}
	}
}

static void
nibbles_window_worm_settings_changed_cb (NibblesWindow* self,
                                         GSettings* changed_worm_settings,
                                         const gchar* key)
{
	NibblesGame* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint id = 0;
	GeeArrayList* _tmp6_;
	NibblesGame* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Worm* worm = NULL;
	NibblesGame* _tmp10_;
	GeeLinkedList* _tmp11_;
	GeeLinkedList* _tmp12_;
	gpointer _tmp13_;
	WormProperties* properties = NULL;
	NibblesGame* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	Worm* _tmp17_;
	gpointer _tmp18_;
	const gchar* _tmp19_;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	static GQuark _tmp20_label2 = 0;
	static GQuark _tmp20_label3 = 0;
	static GQuark _tmp20_label4 = 0;
	static GQuark _tmp20_label5 = 0;
	static GQuark _tmp20_label6 = 0;
	static GQuark _tmp20_label7 = 0;
	static GQuark _tmp20_label8 = 0;
	NibblesGame* _tmp59_;
	GeeHashMap* _tmp60_;
	GeeHashMap* _tmp61_;
	Worm* _tmp62_;
	WormProperties* _tmp63_;
	NibblesGame* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_worm_settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = self->priv->worm_settings;
	_vala_assert (_tmp5_ != NULL, "worm_settings != null");
	_tmp6_ = self->priv->worm_settings;
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp6_, changed_worm_settings);
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_numworms (_tmp7_);
	_tmp9_ = _tmp8_;
	if (id >= _tmp9_) {
		return;
	}
	_tmp10_ = self->priv->game;
	_tmp11_ = nibbles_game_get_worms (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, id);
	worm = (Worm*) _tmp13_;
	_tmp14_ = self->priv->game;
	_tmp15_ = nibbles_game_get_worm_props (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = worm;
	_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
	properties = (WormProperties*) _tmp18_;
	_tmp19_ = key;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("color")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp22_;
				_tmp22_ = properties;
				worm_properties_set_color (_tmp22_, g_settings_get_enum (changed_worm_settings, "color"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("key-up")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp23_;
				_tmp23_ = properties;
				worm_properties_set_up (_tmp23_, (guint) g_settings_get_int (changed_worm_settings, "key-up"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("key-down")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp24_;
				_tmp24_ = properties;
				worm_properties_set_down (_tmp24_, (guint) g_settings_get_int (changed_worm_settings, "key-down"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("key-left")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp25_;
				_tmp25_ = properties;
				worm_properties_set_left (_tmp25_, (guint) g_settings_get_int (changed_worm_settings, "key-left"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("key-right")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp26_;
				_tmp26_ = properties;
				worm_properties_set_right (_tmp26_, (guint) g_settings_get_int (changed_worm_settings, "key-right"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("key-up-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp27_;
				WormProperties* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp27_ = properties;
				worm_properties_set_raw_up (_tmp27_, g_settings_get_int (changed_worm_settings, "key-up-raw"));
				_tmp28_ = properties;
				_tmp29_ = worm_properties_get_raw_up (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ < 0) {
					WormProperties* _tmp31_;
					WormProperties* _tmp32_;
					guint _tmp33_;
					guint _tmp34_;
					_tmp31_ = properties;
					_tmp32_ = properties;
					_tmp33_ = worm_properties_get_up (_tmp32_);
					_tmp34_ = _tmp33_;
					worm_properties_set_raw_up (_tmp31_, nibbles_window_get_raw_key (self, _tmp34_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label6) ? _tmp20_label6 : (_tmp20_label6 = g_quark_from_static_string ("key-down-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp35_;
				WormProperties* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				_tmp35_ = properties;
				worm_properties_set_raw_down (_tmp35_, g_settings_get_int (changed_worm_settings, "key-down-raw"));
				_tmp36_ = properties;
				_tmp37_ = worm_properties_get_raw_down (_tmp36_);
				_tmp38_ = _tmp37_;
				if (_tmp38_ < 0) {
					WormProperties* _tmp39_;
					WormProperties* _tmp40_;
					guint _tmp41_;
					guint _tmp42_;
					_tmp39_ = properties;
					_tmp40_ = properties;
					_tmp41_ = worm_properties_get_down (_tmp40_);
					_tmp42_ = _tmp41_;
					worm_properties_set_raw_down (_tmp39_, nibbles_window_get_raw_key (self, _tmp42_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label7) ? _tmp20_label7 : (_tmp20_label7 = g_quark_from_static_string ("key-left-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp43_;
				WormProperties* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				_tmp43_ = properties;
				worm_properties_set_raw_left (_tmp43_, g_settings_get_int (changed_worm_settings, "key-left-raw"));
				_tmp44_ = properties;
				_tmp45_ = worm_properties_get_raw_left (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_ < 0) {
					WormProperties* _tmp47_;
					WormProperties* _tmp48_;
					guint _tmp49_;
					guint _tmp50_;
					_tmp47_ = properties;
					_tmp48_ = properties;
					_tmp49_ = worm_properties_get_left (_tmp48_);
					_tmp50_ = _tmp49_;
					worm_properties_set_raw_left (_tmp47_, nibbles_window_get_raw_key (self, _tmp50_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label8) ? _tmp20_label8 : (_tmp20_label8 = g_quark_from_static_string ("key-right-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp51_;
				WormProperties* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				_tmp51_ = properties;
				worm_properties_set_raw_right (_tmp51_, g_settings_get_int (changed_worm_settings, "key-right-raw"));
				_tmp52_ = properties;
				_tmp53_ = worm_properties_get_raw_right (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ < 0) {
					WormProperties* _tmp55_;
					WormProperties* _tmp56_;
					guint _tmp57_;
					guint _tmp58_;
					_tmp55_ = properties;
					_tmp56_ = properties;
					_tmp57_ = worm_properties_get_right (_tmp56_);
					_tmp58_ = _tmp57_;
					worm_properties_set_raw_right (_tmp55_, nibbles_window_get_raw_key (self, _tmp58_));
				}
				break;
			}
		}
	}
	_tmp59_ = self->priv->game;
	_tmp60_ = nibbles_game_get_worm_props (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = worm;
	_tmp63_ = properties;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, _tmp62_, _tmp63_);
	_tmp64_ = self->priv->game;
	_tmp65_ = nibbles_game_get_numhumans (_tmp64_);
	_tmp66_ = _tmp65_;
	if (id < _tmp66_) {
		nibbles_window_update_start_game_action (self);
	}
	_g_object_unref0 (properties);
	_g_object_unref0 (worm);
}

static gint
nibbles_window_get_raw_key (NibblesWindow* self,
                            guint keyval)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkDisplay* _tmp0_;
	GdkKeymapKey* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gdk_display_get_default ();
	_tmp3_ = gdk_display_map_keyval (_tmp0_, keyval, &_tmp1_, &_tmp2_);
	keys = (g_free (keys), NULL);
	keys = _tmp1_;
	keys_length1 = _tmp2_;
	_keys_size_ = keys_length1;
	if (_tmp3_) {
		GdkKeymapKey* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = keys;
		_tmp4__length1 = keys_length1;
		if (_tmp4__length1 > 0) {
			GdkKeymapKey* _tmp5_;
			gint _tmp5__length1;
			GdkKeymapKey _tmp6_;
			_tmp5_ = keys;
			_tmp5__length1 = keys_length1;
			_tmp6_ = _tmp5_[0];
			result = (gint) _tmp6_.keycode;
			keys = (g_free (keys), NULL);
			return result;
		}
	}
	result = -1;
	keys = (g_free (keys), NULL);
	return result;
}

static inline void
nibbles_window_next_screen_cb (NibblesWindow* self)
{
	gchar* child_name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	child_name = _tmp2_;
	_tmp3_ = child_name;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("first-run")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_new_game_screen (self, TRUE);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_board_progress_screen (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("board_progress")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_speed_screen (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				nibbles_window_leave_speed_screen (self);
				nibbles_window_show_controls_screen (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_free0 (child_name);
				return;
			}
		}
	}
	_g_free0 (child_name);
}

static void
nibbles_window_set_headerbar_title (NibblesWindow* self,
                                    const gchar* title)
{
	AdwHeaderBar* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = adw_header_bar_get_title_widget (_tmp0_);
	if (_tmp1_ == NULL) {
		AdwHeaderBar* _tmp2_;
		AdwWindowTitle* _tmp3_;
		AdwWindowTitle* _tmp4_;
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = (AdwWindowTitle*) adw_window_title_new (title, "");
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		adw_header_bar_set_title_widget (_tmp2_, (GtkWidget*) _tmp4_);
		_g_object_unref0 (_tmp4_);
	} else {
		AdwHeaderBar* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = self->priv->headerbar;
		_tmp6_ = adw_header_bar_get_title_widget (_tmp5_);
		adw_window_title_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_window_title_get_type (), AdwWindowTitle), title);
	}
}

static void
nibbles_window_show_new_game_screen (NibblesWindow* self,
                                     gboolean after_first_run)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkStack* _tmp11_;
	GtkStack* _tmp12_;
	g_return_if_fail (self != NULL);
	if (self->priv->countdown_id != ((guint) 0)) {
		g_source_remove (self->priv->countdown_id);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	nibbles_window_set_headerbar_title (self, NIBBLES_PROGRAM_NAME);
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_tmp5_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	_tmp7_ = self->priv->new_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = self->priv->pause_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
	if (after_first_run) {
		GtkStack* _tmp9_;
		_tmp9_ = self->priv->main_stack;
		gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	} else {
		GtkStack* _tmp10_;
		_tmp10_ = self->priv->main_stack;
		gtk_stack_set_transition_type (_tmp10_, GTK_STACK_TRANSITION_TYPE_NONE);
	}
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "number_of_players");
	_tmp12_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp12_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
}

static void
nibbles_window_show_speed_screen (NibblesWindow* self)
{
	gint progress = 0;
	gint level = 0;
	BoardProgress* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_progress;
	board_progress_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	progress = _tmp1_;
	level = _tmp2_;
	if (progress == 0) {
		level = 1;
	}
	_tmp3_ = self->priv->game;
	nibbles_game_set_progress (_tmp3_, progress);
	_tmp4_ = self->priv->game;
	nibbles_game_set_start_level (_tmp4_, level);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, "progress", progress);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "start-level", level);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "speed");
}

static void
nibbles_window_show_board_progress_screen (NibblesWindow* self)
{
	gint numhumans = 0;
	gint numai = 0;
	Players* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->players;
	players_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	numhumans = _tmp1_;
	numai = _tmp2_;
	_tmp3_ = self->priv->game;
	nibbles_game_set_numhumans (_tmp3_, numhumans);
	_tmp4_ = self->priv->game;
	nibbles_game_set_numai (_tmp4_, numai);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, "players", numhumans);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "ai", numai);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "board_progress");
}

static void
nibbles_window_leave_speed_screen (NibblesWindow* self)
{
	gint game_speed = 0;
	gboolean fakes = FALSE;
	Speed* _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->speed;
	speed_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	game_speed = _tmp1_;
	fakes = _tmp2_;
	_tmp3_ = self->priv->game;
	nibbles_game_set_speed (_tmp3_, game_speed);
	_tmp4_ = self->priv->game;
	nibbles_game_set_fakes (_tmp4_, fakes);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, "speed", game_speed);
	_tmp6_ = self->priv->settings;
	g_settings_set_boolean (_tmp6_, "fakes", fakes);
}

static void
nibbles_window_show_controls_screen (NibblesWindow* self)
{
	Controls* _tmp0_;
	NibblesGame* _tmp1_;
	GeeArrayList* _tmp2_;
	Controls* _tmp3_;
	NibblesGame* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeLinkedList* _tmp6_;
	NibblesGame* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeArrayList* _tmp10_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->controls;
	controls_clean (_tmp0_);
	_tmp1_ = self->priv->game;
	_tmp2_ = self->priv->worm_settings;
	nibbles_game_create_worms (_tmp1_, _tmp2_);
	nibbles_window_update_start_game_action (self);
	_tmp3_ = self->priv->controls;
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_game_get_worms (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_worm_props (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->worm_settings;
	controls_prepare (_tmp3_, _tmp6_, _tmp9_, (GeeList*) _tmp10_);
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "controls");
}

static void
nibbles_window_update_start_game_action (NibblesWindow* self)
{
	GHashTable* keys = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSimpleAction* _tmp112_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	keys = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				NibblesGame* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				WormProperties* worm_prop = NULL;
				NibblesGame* _tmp8_;
				GeeHashMap* _tmp9_;
				GeeHashMap* _tmp10_;
				NibblesGame* _tmp11_;
				GeeLinkedList* _tmp12_;
				GeeLinkedList* _tmp13_;
				gpointer _tmp14_;
				Worm* _tmp15_;
				gpointer _tmp16_;
				WormProperties* _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				WormProperties* _tmp31_;
				guint _tmp32_;
				guint _tmp33_;
				GHashTable* _tmp96_;
				WormProperties* _tmp97_;
				guint _tmp98_;
				guint _tmp99_;
				GHashTable* _tmp100_;
				WormProperties* _tmp101_;
				guint _tmp102_;
				guint _tmp103_;
				GHashTable* _tmp104_;
				WormProperties* _tmp105_;
				guint _tmp106_;
				guint _tmp107_;
				GHashTable* _tmp108_;
				WormProperties* _tmp109_;
				guint _tmp110_;
				guint _tmp111_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->game;
				_tmp6_ = nibbles_game_get_numhumans (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->game;
				_tmp9_ = nibbles_game_get_worm_props (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = self->priv->game;
				_tmp12_ = nibbles_game_get_worms (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, i);
				_tmp15_ = (Worm*) _tmp14_;
				_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp15_);
				_tmp17_ = (WormProperties*) _tmp16_;
				_g_object_unref0 (_tmp15_);
				worm_prop = _tmp17_;
				_tmp31_ = worm_prop;
				_tmp32_ = worm_properties_get_up (_tmp31_);
				_tmp33_ = _tmp32_;
				if (_tmp33_ == ((guint) 0)) {
					_tmp30_ = TRUE;
				} else {
					WormProperties* _tmp34_;
					guint _tmp35_;
					guint _tmp36_;
					_tmp34_ = worm_prop;
					_tmp35_ = worm_properties_get_down (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp30_ = _tmp36_ == ((guint) 0);
				}
				if (_tmp30_) {
					_tmp29_ = TRUE;
				} else {
					WormProperties* _tmp37_;
					guint _tmp38_;
					guint _tmp39_;
					_tmp37_ = worm_prop;
					_tmp38_ = worm_properties_get_left (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp29_ = _tmp39_ == ((guint) 0);
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					WormProperties* _tmp40_;
					guint _tmp41_;
					guint _tmp42_;
					_tmp40_ = worm_prop;
					_tmp41_ = worm_properties_get_right (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp28_ = _tmp42_ == ((guint) 0);
				}
				if (_tmp28_) {
					_tmp27_ = TRUE;
				} else {
					WormProperties* _tmp43_;
					guint _tmp44_;
					guint _tmp45_;
					WormProperties* _tmp46_;
					guint _tmp47_;
					guint _tmp48_;
					_tmp43_ = worm_prop;
					_tmp44_ = worm_properties_get_up (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = worm_prop;
					_tmp47_ = worm_properties_get_down (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp27_ = _tmp45_ == _tmp48_;
				}
				if (_tmp27_) {
					_tmp26_ = TRUE;
				} else {
					WormProperties* _tmp49_;
					guint _tmp50_;
					guint _tmp51_;
					WormProperties* _tmp52_;
					guint _tmp53_;
					guint _tmp54_;
					_tmp49_ = worm_prop;
					_tmp50_ = worm_properties_get_up (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = worm_prop;
					_tmp53_ = worm_properties_get_left (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp26_ = _tmp51_ == _tmp54_;
				}
				if (_tmp26_) {
					_tmp25_ = TRUE;
				} else {
					WormProperties* _tmp55_;
					guint _tmp56_;
					guint _tmp57_;
					WormProperties* _tmp58_;
					guint _tmp59_;
					guint _tmp60_;
					_tmp55_ = worm_prop;
					_tmp56_ = worm_properties_get_up (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = worm_prop;
					_tmp59_ = worm_properties_get_right (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp25_ = _tmp57_ == _tmp60_;
				}
				if (_tmp25_) {
					_tmp24_ = TRUE;
				} else {
					WormProperties* _tmp61_;
					guint _tmp62_;
					guint _tmp63_;
					WormProperties* _tmp64_;
					guint _tmp65_;
					guint _tmp66_;
					_tmp61_ = worm_prop;
					_tmp62_ = worm_properties_get_down (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = worm_prop;
					_tmp65_ = worm_properties_get_left (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp24_ = _tmp63_ == _tmp66_;
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					WormProperties* _tmp67_;
					guint _tmp68_;
					guint _tmp69_;
					WormProperties* _tmp70_;
					guint _tmp71_;
					guint _tmp72_;
					_tmp67_ = worm_prop;
					_tmp68_ = worm_properties_get_down (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = worm_prop;
					_tmp71_ = worm_properties_get_right (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp23_ = _tmp69_ == _tmp72_;
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					WormProperties* _tmp73_;
					guint _tmp74_;
					guint _tmp75_;
					WormProperties* _tmp76_;
					guint _tmp77_;
					guint _tmp78_;
					_tmp73_ = worm_prop;
					_tmp74_ = worm_properties_get_right (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = worm_prop;
					_tmp77_ = worm_properties_get_left (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp22_ = _tmp75_ == _tmp78_;
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					GHashTable* _tmp79_;
					WormProperties* _tmp80_;
					guint _tmp81_;
					guint _tmp82_;
					_tmp79_ = keys;
					_tmp80_ = worm_prop;
					_tmp81_ = worm_properties_get_up (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp21_ = g_hash_table_contains (_tmp79_, (gpointer) ((guintptr) _tmp82_));
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					GHashTable* _tmp83_;
					WormProperties* _tmp84_;
					guint _tmp85_;
					guint _tmp86_;
					_tmp83_ = keys;
					_tmp84_ = worm_prop;
					_tmp85_ = worm_properties_get_down (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp20_ = g_hash_table_contains (_tmp83_, (gpointer) ((guintptr) _tmp86_));
				}
				if (_tmp20_) {
					_tmp19_ = TRUE;
				} else {
					GHashTable* _tmp87_;
					WormProperties* _tmp88_;
					guint _tmp89_;
					guint _tmp90_;
					_tmp87_ = keys;
					_tmp88_ = worm_prop;
					_tmp89_ = worm_properties_get_left (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp19_ = g_hash_table_contains (_tmp87_, (gpointer) ((guintptr) _tmp90_));
				}
				if (_tmp19_) {
					_tmp18_ = TRUE;
				} else {
					GHashTable* _tmp91_;
					WormProperties* _tmp92_;
					guint _tmp93_;
					guint _tmp94_;
					_tmp91_ = keys;
					_tmp92_ = worm_prop;
					_tmp93_ = worm_properties_get_right (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp18_ = g_hash_table_contains (_tmp91_, (gpointer) ((guintptr) _tmp94_));
				}
				if (_tmp18_) {
					GSimpleAction* _tmp95_;
					_tmp95_ = self->priv->start_game_action;
					g_simple_action_set_enabled (_tmp95_, FALSE);
					_g_object_unref0 (worm_prop);
					_g_hash_table_unref0 (keys);
					return;
				}
				_tmp96_ = keys;
				_tmp97_ = worm_prop;
				_tmp98_ = worm_properties_get_up (_tmp97_);
				_tmp99_ = _tmp98_;
				g_hash_table_add (_tmp96_, (gpointer) ((guintptr) _tmp99_));
				_tmp100_ = keys;
				_tmp101_ = worm_prop;
				_tmp102_ = worm_properties_get_down (_tmp101_);
				_tmp103_ = _tmp102_;
				g_hash_table_add (_tmp100_, (gpointer) ((guintptr) _tmp103_));
				_tmp104_ = keys;
				_tmp105_ = worm_prop;
				_tmp106_ = worm_properties_get_left (_tmp105_);
				_tmp107_ = _tmp106_;
				g_hash_table_add (_tmp104_, (gpointer) ((guintptr) _tmp107_));
				_tmp108_ = keys;
				_tmp109_ = worm_prop;
				_tmp110_ = worm_properties_get_right (_tmp109_);
				_tmp111_ = _tmp110_;
				g_hash_table_add (_tmp108_, (gpointer) ((guintptr) _tmp111_));
				_g_object_unref0 (worm_prop);
			}
		}
	}
	_tmp112_ = self->priv->start_game_action;
	g_simple_action_set_enabled (_tmp112_, TRUE);
	_g_hash_table_unref0 (keys);
}

static void
nibbles_window_show_game_view (NibblesWindow* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	NibblesGame* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	NibblesView* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->pause_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_current_level (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_ ("Level %d"), _tmp4_);
	_tmp6_ = _tmp5_;
	nibbles_window_set_headerbar_title (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "game_box");
	_tmp8_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp8_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_tmp9_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, TRUE);
}

static void
nibbles_window_back_cb (NibblesWindow* self)
{
	GtkStack* _tmp0_;
	gchar* child_name = NULL;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	static GQuark _tmp6_label4 = 0;
	static GQuark _tmp6_label5 = 0;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	child_name = _tmp3_;
	_tmp4_ = child_name;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first-run")))) {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("board_progress")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp8_;
				_tmp8_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp9_;
				_tmp9_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp9_, "board_progress");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp10_;
				_tmp10_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp10_, "speed");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_window_new_game_cb (self);
				break;
			}
		}
	}
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_g_free0 (child_name);
}

static GamesScoresCategory*
nibbles_window_category_request (NibblesWindow* self,
                                 const gchar* key)
{
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _cat_index = 0;
		_tmp0_ = self->priv->scorecats;
		_cat_list = _tmp0_;
		_tmp1_ = _cat_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_cat_size = _tmp3_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			GamesScoresCategory* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_cat_index = _cat_index + 1;
			_tmp4_ = _cat_index;
			_tmp5_ = _cat_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _cat_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _cat_index);
			cat = (GamesScoresCategory*) _tmp7_;
			_tmp8_ = cat;
			_tmp9_ = games_scores_category_get_key (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (key, _tmp10_) == 0) {
				result = cat;
				return result;
			}
			_g_object_unref0 (cat);
		}
	}
	result = NULL;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static guint
nibbles_window_category_speed (NibblesWindow* self,
                               GamesScoresCategory* c)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (c != NULL, 0U);
	_tmp1_ = games_scores_category_get_key (c);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ >= 8) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = games_scores_category_get_key (c);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) 8);
		_tmp8_ = _tmp7_;
		_tmp0_ = g_strcmp0 (_tmp8_, "beginner") == 0;
		_g_free0 (_tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (guint) 4;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp10_ = games_scores_category_get_key (c);
		_tmp11_ = _tmp10_;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ >= 4) {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp14_ = games_scores_category_get_key (c);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_slice (_tmp15_, (glong) 0, (glong) 4);
			_tmp17_ = _tmp16_;
			_tmp9_ = g_strcmp0 (_tmp17_, "slow") == 0;
			_g_free0 (_tmp17_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			result = (guint) 3;
			return result;
		} else {
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp19_ = games_scores_category_get_key (c);
			_tmp20_ = _tmp19_;
			_tmp21_ = strlen (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_ >= 6) {
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				_tmp23_ = games_scores_category_get_key (c);
				_tmp24_ = _tmp23_;
				_tmp25_ = string_slice (_tmp24_, (glong) 0, (glong) 6);
				_tmp26_ = _tmp25_;
				_tmp18_ = g_strcmp0 (_tmp26_, "medium") == 0;
				_g_free0 (_tmp26_);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				result = (guint) 2;
				return result;
			} else {
				gboolean _tmp27_ = FALSE;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				_tmp28_ = games_scores_category_get_key (c);
				_tmp29_ = _tmp28_;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_ >= 4) {
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp32_ = games_scores_category_get_key (c);
					_tmp33_ = _tmp32_;
					_tmp34_ = string_slice (_tmp33_, (glong) 0, (glong) 4);
					_tmp35_ = _tmp34_;
					_tmp27_ = g_strcmp0 (_tmp35_, "fast") == 0;
					_g_free0 (_tmp35_);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					result = (guint) 1;
					return result;
				} else {
					result = (guint) 0;
					return result;
				}
			}
		}
	}
}

static GamesScoresCategory*
_nibbles_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self)
{
	GamesScoresCategory* result;
	result = nibbles_window_category_request ((NibblesWindow*) self, category_key);
	return result;
}

static gboolean
__lambda39_ (NibblesWindow* self,
             GamesScoresCategory* a,
             GamesScoresCategory* b)
{
	guint a_speed = 0U;
	guint b_speed = 0U;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	a_speed = nibbles_window_category_speed (self, a);
	b_speed = nibbles_window_category_speed (self, b);
	if ((-a_speed) < (-b_speed)) {
		result = TRUE;
		return result;
	} else {
		if ((-a_speed) > (-b_speed)) {
			result = FALSE;
			return result;
		} else {
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			_tmp0_ = self->priv->scorecats;
			_tmp1_ = self->priv->scorecats;
			result = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, a) < gee_abstract_list_index_of ((GeeAbstractList*) _tmp1_, b);
			return result;
		}
	}
}

static gboolean
___lambda39__games_scores_context_is_lower_order_category_func (GamesScoresCategory* a,
                                                                GamesScoresCategory* b,
                                                                gpointer self)
{
	gboolean result;
	result = __lambda39_ ((NibblesWindow*) self, a, b);
	return result;
}

static void
nibbles_window_create_scores (NibblesWindow* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GamesScoresCategory* _tmp2_;
	GamesScoresCategory* _tmp3_;
	GeeLinkedList* _tmp4_;
	GamesScoresCategory* _tmp5_;
	GamesScoresCategory* _tmp6_;
	GeeLinkedList* _tmp7_;
	GamesScoresCategory* _tmp8_;
	GamesScoresCategory* _tmp9_;
	GeeLinkedList* _tmp10_;
	GamesScoresCategory* _tmp11_;
	GamesScoresCategory* _tmp12_;
	GeeLinkedList* _tmp13_;
	GamesScoresCategory* _tmp14_;
	GamesScoresCategory* _tmp15_;
	GeeLinkedList* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GamesScoresCategory* _tmp18_;
	GeeLinkedList* _tmp19_;
	GamesScoresCategory* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GeeLinkedList* _tmp22_;
	GamesScoresCategory* _tmp23_;
	GamesScoresCategory* _tmp24_;
	GamesScoresContext* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_linked_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->scorecats);
	self->priv->scorecats = _tmp0_;
	_tmp1_ = self->priv->scorecats;
	_tmp2_ = games_scores_category_new ("beginner", _ ("Beginner"));
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->scorecats;
	_tmp5_ = games_scores_category_new ("slow", _ ("Slow"));
	_tmp6_ = _tmp5_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->scorecats;
	_tmp8_ = games_scores_category_new ("medium", _ ("Medium"));
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->scorecats;
	_tmp11_ = games_scores_category_new ("fast", _ ("Fast"));
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->scorecats;
	_tmp14_ = games_scores_category_new ("beginner-fakes", _ ("Beginner with Fakes"));
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = self->priv->scorecats;
	_tmp17_ = games_scores_category_new ("slow-fakes", _ ("Slow with Fakes"));
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->scorecats;
	_tmp20_ = games_scores_category_new ("medium-fakes", _ ("Medium with Fakes"));
	_tmp21_ = _tmp20_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->scorecats;
	_tmp23_ = games_scores_category_new ("fast-fakes", _ ("Fast with Fakes"));
	_tmp24_ = _tmp23_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = games_scores_context_new ("gnome-nibbles", _ ("Difficulty Level:"), (GtkWindow*) self, _nibbles_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "org.gnome.Nibbles", ___lambda39__games_scores_context_is_lower_order_category_func, self);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp25_;
}

static GamesScoresCategory*
nibbles_window_get_scores_category (NibblesWindow* self,
                                    gint speed,
                                    gboolean fakes)
{
	gchar* key = NULL;
	GeeLinkedList* _tmp18_;
	gpointer _tmp19_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	key = NULL;
	switch (speed) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fast");
			_g_free0 (key);
			key = _tmp0_;
			break;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("medium");
			_g_free0 (key);
			key = _tmp1_;
			break;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("slow");
			_g_free0 (key);
			key = _tmp2_;
			break;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("beginner");
			_g_free0 (key);
			key = _tmp3_;
			break;
		}
		default:
		break;
	}
	if (fakes) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = key;
		_tmp5_ = g_strconcat (_tmp4_, "-fakes", NULL);
		_g_free0 (key);
		key = _tmp5_;
	}
	{
		GeeLinkedList* _cat_list = NULL;
		GeeLinkedList* _tmp6_;
		gint _cat_size = 0;
		GeeLinkedList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _cat_index = 0;
		_tmp6_ = self->priv->scorecats;
		_cat_list = _tmp6_;
		_tmp7_ = _cat_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_cat_size = _tmp9_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			GamesScoresCategory* cat = NULL;
			GeeLinkedList* _tmp12_;
			gpointer _tmp13_;
			const gchar* _tmp14_;
			GamesScoresCategory* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_cat_index = _cat_index + 1;
			_tmp10_ = _cat_index;
			_tmp11_ = _cat_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _cat_list;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _cat_index);
			cat = (GamesScoresCategory*) _tmp13_;
			_tmp14_ = key;
			_tmp15_ = cat;
			_tmp16_ = games_scores_category_get_key (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp14_, _tmp17_) == 0) {
				result = cat;
				_g_free0 (key);
				return result;
			}
			_g_object_unref0 (cat);
		}
	}
	_tmp18_ = self->priv->scorecats;
	_tmp19_ = gee_linked_list_first (_tmp18_);
	result = (GamesScoresCategory*) _tmp19_;
	_g_free0 (key);
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NibblesWindow* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda40_ (Block5Data* _data5_,
             GObject* object,
             GAsyncResult* _result_)
{
	NibblesWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("nibbles-window.vala:1124: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	nibbles_window_game_over (self, _data5_->score, _data5_->lowest_high_score, _data5_->level_reached);
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ (self, source_object, res);
	block5_data_unref (self);
}

static void
nibbles_window_log_score_cb (NibblesWindow* self,
                             gint score,
                             gint level_reached)
{
	Block5Data* _data5_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp3_;
	NibblesGame* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NibblesGame* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GamesScoresCategory* _tmp10_;
	GamesScoresCategory* _tmp11_;
	GeeList* _tmp12_;
	GeeList* _tmp13_;
	glong _tmp14_ = 0L;
	GeeList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	NibblesGame* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	NibblesGame* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GamesScoresContext* _tmp29_;
	NibblesGame* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	NibblesGame* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	GamesScoresCategory* _tmp36_;
	GamesScoresCategory* _tmp37_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->score = score;
	_data5_->level_reached = level_reached;
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->scores_context;
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_game_get_speed (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_fakes (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = nibbles_window_get_scores_category (self, _tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = games_scores_context_get_high_scores (_tmp3_, _tmp11_, 10);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	scores = _tmp13_;
	_tmp15_ = scores;
	_tmp16_ = gee_collection_get_size ((GeeCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 10) {
		GeeList* _tmp18_;
		gpointer _tmp19_;
		GamesScoresScore* _tmp20_;
		glong _tmp21_;
		glong _tmp22_;
		_tmp18_ = scores;
		_tmp19_ = gee_list_last (_tmp18_);
		_tmp20_ = (GamesScoresScore*) _tmp19_;
		_tmp21_ = games_scores_score_get_score (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp14_ = _tmp22_;
		_g_object_unref0 (_tmp20_);
	} else {
		_tmp14_ = (glong) -1;
	}
	_data5_->lowest_high_score = _tmp14_;
	_tmp23_ = self->priv->game;
	_tmp24_ = nibbles_game_get_numhumans (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ < 1) {
		nibbles_window_game_over (self, _data5_->score, _data5_->lowest_high_score, _data5_->level_reached);
		_g_object_unref0 (scores);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp26_ = self->priv->game;
	_tmp27_ = nibbles_game_get_skip_score (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		nibbles_window_game_over (self, _data5_->score, _data5_->lowest_high_score, _data5_->level_reached);
		_g_object_unref0 (scores);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp29_ = self->priv->scores_context;
	_tmp30_ = self->priv->game;
	_tmp31_ = nibbles_game_get_speed (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->game;
	_tmp34_ = nibbles_game_get_fakes (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = nibbles_window_get_scores_category (self, _tmp32_, _tmp35_);
	_tmp37_ = _tmp36_;
	games_scores_context_add_score (_tmp29_, (glong) _data5_->score, _tmp37_, NULL, ___lambda40__gasync_ready_callback, block5_data_ref (_data5_));
	_g_object_unref0 (_tmp37_);
	_g_object_unref0 (scores);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NibblesWindow* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda38_ (Block6Data* _data6_)
{
	NibblesWindow* self;
	GamesScoresContext* _tmp1_;
	self = _data6_->self;
	if (_data6_->should_unpause) {
		GSimpleAction* _tmp0_;
		_tmp0_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp0_, "activate", NULL);
	}
	_tmp1_ = self->priv->scores_context;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data6_->id);
}

static void
___lambda38__games_scores_context_dialog_closed (GamesScoresContext* _sender,
                                                 gpointer self)
{
	__lambda38_ (self);
}

static void
nibbles_window_scores_cb (NibblesWindow* self)
{
	Block6Data* _data6_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesScoresContext* _tmp4_;
	GamesScoresContext* _tmp5_;
	gulong _tmp6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		_data6_->should_unpause = TRUE;
	}
	_tmp4_ = self->priv->scores_context;
	games_scores_context_present_dialog (_tmp4_);
	_data6_->id = (gulong) 0;
	_tmp5_ = self->priv->scores_context;
	_tmp6_ = g_signal_connect_data (_tmp5_, "dialog-closed", (GCallback) ___lambda38__games_scores_context_dialog_closed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_data6_->id = _tmp6_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NibblesWindow* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->button);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda41_ (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	NibblesView* _tmp5_;
	nibbles_window_overlay_remove_all (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Level %d"), _tmp2_);
	_tmp4_ = _tmp3_;
	nibbles_window_set_headerbar_title (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
	nibbles_window_restart_game (self);
}

static void
___lambda41__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda41_ ((NibblesWindow*) self);
}

static gboolean
__lambda42_ (Block7Data* _data7_)
{
	NibblesWindow* self;
	GtkButton* _tmp0_;
	gboolean result;
	self = _data7_->self;
	_tmp0_ = _data7_->button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda42__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda42_ (self);
	return result;
}

static void
nibbles_window_level_completed_cb (NibblesWindow* self)
{
	Block7Data* _data7_;
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NibblesView* _tmp3_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GtkLabel* label = NULL;
	NibblesGame* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	PangoAttrList* _tmp17_;
	PangoAttrList* _tmp18_;
	GtkLabel* _tmp22_;
	PangoAttrList* _tmp23_;
	PangoAttrList* _tmp24_;
	PangoAttribute* _tmp25_;
	GtkLabel* _tmp26_;
	PangoAttrList* _tmp27_;
	PangoAttrList* _tmp28_;
	PangoAttribute* _tmp29_;
	GtkLabel* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GtkButton* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkButton* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkLabel* _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NIBBLES_GAME_MAX_LEVEL) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp3_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_current_level (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (_ ("Level %d Completed!"), _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	label = _tmp12_;
	_tmp13_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_CENTER);
	_tmp14_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	_tmp15_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 150);
	_tmp16_ = label;
	_tmp17_ = gtk_label_get_attributes (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == NULL) {
		GtkLabel* _tmp19_;
		PangoAttrList* _tmp20_;
		PangoAttrList* _tmp21_;
		_tmp19_ = label;
		_tmp20_ = pango_attr_list_new ();
		_tmp21_ = _tmp20_;
		gtk_label_set_attributes (_tmp19_, _tmp21_);
		_pango_attr_list_unref0 (_tmp21_);
	}
	_tmp22_ = label;
	_tmp23_ = gtk_label_get_attributes (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
	pango_attr_list_insert (_tmp24_, _tmp25_);
	_tmp26_ = label;
	_tmp27_ = gtk_label_get_attributes (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp28_, _tmp29_);
	_tmp30_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp30_, TRUE);
	_tmp31_ = (GtkButton*) gtk_button_new_with_label (_ ("_Next Level"));
	g_object_ref_sink (_tmp31_);
	_data7_->button = _tmp31_;
	_tmp32_ = _data7_->button;
	gtk_button_set_use_underline (_tmp32_, TRUE);
	_tmp33_ = _data7_->button;
	g_object_set ((GtkWidget*) _tmp33_, "width-request", 116, NULL);
	_tmp34_ = _data7_->button;
	g_object_set ((GtkWidget*) _tmp34_, "height-request", 34, NULL);
	_tmp35_ = _data7_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_CENTER);
	_tmp36_ = _data7_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp36_, GTK_ALIGN_END);
	_tmp37_ = _data7_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp37_, 100);
	_tmp38_ = _data7_->button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp38_, "suggested-action");
	_tmp39_ = _data7_->button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp39_, "pill");
	_tmp40_ = _data7_->button;
	g_signal_connect_object (_tmp40_, "clicked", (GCallback) ___lambda41__gtk_button_clicked, self, 0);
	_tmp41_ = label;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp41_);
	_tmp42_ = _data7_->button;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp42_);
	_tmp43_ = _data7_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp43_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda42__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	_g_object_unref0 (label);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gboolean
_nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                             const NibblesGameeStatus * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
nibbles_window_game_over (NibblesWindow* self,
                          gint score,
                          glong lowest_high_score,
                          gint level_reached)
{
	gboolean is_high_score = FALSE;
	gboolean is_game_won = FALSE;
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp12_ = NULL;
	GtkLabel* game_over_label = NULL;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	PangoAttrList* _tmp18_;
	PangoAttrList* _tmp19_;
	GtkLabel* _tmp23_;
	PangoAttrList* _tmp24_;
	PangoAttrList* _tmp25_;
	PangoAttribute* _tmp26_;
	GtkLabel* _tmp27_;
	PangoAttrList* _tmp28_;
	PangoAttrList* _tmp29_;
	PangoAttribute* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* msg_label = NULL;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	PangoAttrList* _tmp37_;
	PangoAttrList* _tmp38_;
	GtkLabel* _tmp42_;
	PangoAttrList* _tmp43_;
	PangoAttrList* _tmp44_;
	PangoAttribute* _tmp45_;
	GtkLabel* _tmp46_;
	PangoAttrList* _tmp47_;
	PangoAttrList* _tmp48_;
	PangoAttribute* _tmp49_;
	GtkLabel* _tmp50_;
	gchar* score_string = NULL;
	gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	GtkLabel* score_label = NULL;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GtkLabel* _tmp58_;
	GtkLabel* _tmp59_;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	glong points_left = 0L;
	GtkLabel* points_left_label = NULL;
	gchar* _tmp65_;
	gchar* _tmp66_;
	GtkLabel* _tmp67_;
	GtkLabel* _tmp68_;
	GtkLabel* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkButton* play_again_button = NULL;
	GtkButton* _tmp73_;
	GtkButton* _tmp74_;
	GtkButton* _tmp75_;
	GtkButton* _tmp76_;
	GtkButton* _tmp77_;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* _tmp80_;
	GtkButton* _tmp81_;
	GtkLabel* _tmp82_;
	NibblesGame* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gboolean _tmp88_ = FALSE;
	NibblesGame* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	GtkButton* _tmp93_;
	GtkButton* _tmp94_;
	NibblesView* _tmp95_;
	GSimpleAction* _tmp96_;
	GSimpleAction* _tmp97_;
	GSimpleAction* _tmp98_;
	g_return_if_fail (self != NULL);
	is_high_score = ((glong) score) > lowest_high_score;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_progress (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		is_game_won = level_reached > NIBBLES_GAME_MAX_LEVEL;
	} else {
		NibblesGame* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = nibbles_game_get_progress (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == 1) {
			NibblesGame* _tmp6_;
			gint* _tmp7_;
			gint _tmp7__length1;
			_tmp6_ = self->priv->game;
			_tmp7_ = _tmp6_->levels_uncompleated;
			_tmp7__length1 = _tmp6_->levels_uncompleated_length1;
			is_game_won = _tmp7__length1 == 0;
		} else {
			NibblesGame* _tmp8_;
			NibblesGameeStatus* _tmp9_;
			NibblesGameeStatus* _tmp10_;
			NibblesGameeStatus _tmp11_;
			_tmp8_ = self->priv->game;
			_tmp9_ = nibbles_game_get_game_status (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = NIBBLES_GAME_ESTATUS_VICTORY;
			is_game_won = _nibbles_game_estatus_equal (_tmp10_, &_tmp11_) == TRUE;
			_g_free0 (_tmp10_);
		}
	}
	if (is_game_won) {
		_tmp12_ = _ ("Congratulations!");
	} else {
		_tmp12_ = _ ("Game Over!");
	}
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	g_object_ref_sink (_tmp13_);
	game_over_label = _tmp13_;
	_tmp14_ = game_over_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_CENTER);
	_tmp15_ = game_over_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	_tmp16_ = game_over_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 150);
	_tmp17_ = game_over_label;
	_tmp18_ = gtk_label_get_attributes (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		GtkLabel* _tmp20_;
		PangoAttrList* _tmp21_;
		PangoAttrList* _tmp22_;
		_tmp20_ = game_over_label;
		_tmp21_ = pango_attr_list_new ();
		_tmp22_ = _tmp21_;
		gtk_label_set_attributes (_tmp20_, _tmp22_);
		_pango_attr_list_unref0 (_tmp22_);
	}
	_tmp23_ = game_over_label;
	_tmp24_ = gtk_label_get_attributes (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = pango_attr_scale_new (PANGO_SCALE_XX_LARGE * 2);
	pango_attr_list_insert (_tmp25_, _tmp26_);
	_tmp27_ = game_over_label;
	_tmp28_ = gtk_label_get_attributes (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp29_, _tmp30_);
	_tmp31_ = game_over_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = (GtkLabel*) gtk_label_new (_ ("You have completed the game."));
	g_object_ref_sink (_tmp32_);
	msg_label = _tmp32_;
	_tmp33_ = msg_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
	_tmp34_ = msg_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp34_, GTK_ALIGN_START);
	_tmp35_ = msg_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp35_, gtk_widget_get_height ((GtkWidget*) self) / 3);
	_tmp36_ = msg_label;
	_tmp37_ = gtk_label_get_attributes (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ == NULL) {
		GtkLabel* _tmp39_;
		PangoAttrList* _tmp40_;
		PangoAttrList* _tmp41_;
		_tmp39_ = msg_label;
		_tmp40_ = pango_attr_list_new ();
		_tmp41_ = _tmp40_;
		gtk_label_set_attributes (_tmp39_, _tmp41_);
		_pango_attr_list_unref0 (_tmp41_);
	}
	_tmp42_ = msg_label;
	_tmp43_ = gtk_label_get_attributes (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
	pango_attr_list_insert (_tmp44_, _tmp45_);
	_tmp46_ = msg_label;
	_tmp47_ = gtk_label_get_attributes (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp48_, _tmp49_);
	_tmp50_ = msg_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp50_, TRUE);
	_tmp51_ = g_strdup (ngettext ("%d Point", "%d Points", (gulong) score));
	score_string = _tmp51_;
	_tmp52_ = score_string;
	_tmp53_ = g_strdup_printf (_tmp52_, score);
	_g_free0 (score_string);
	score_string = _tmp53_;
	_tmp54_ = score_string;
	_tmp55_ = string_to_string (_tmp54_);
	_tmp56_ = g_strconcat ("<b>", _tmp55_, "</b>", NULL);
	_tmp57_ = _tmp56_;
	_tmp58_ = (GtkLabel*) gtk_label_new (_tmp57_);
	g_object_ref_sink (_tmp58_);
	_tmp59_ = _tmp58_;
	_g_free0 (_tmp57_);
	score_label = _tmp59_;
	_tmp60_ = score_label;
	gtk_label_set_use_markup (_tmp60_, TRUE);
	_tmp61_ = score_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp61_, GTK_ALIGN_CENTER);
	_tmp62_ = score_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp62_, GTK_ALIGN_START);
	_tmp63_ = score_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp63_, (gtk_widget_get_height ((GtkWidget*) self) / 3) + 80);
	_tmp64_ = score_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp64_, TRUE);
	points_left = (lowest_high_score + 1) - score;
	_tmp65_ = g_strdup_printf (_ ("(%ld more points to reach the leaderboard)"), points_left);
	_tmp66_ = _tmp65_;
	_tmp67_ = (GtkLabel*) gtk_label_new (_tmp66_);
	g_object_ref_sink (_tmp67_);
	_tmp68_ = _tmp67_;
	_g_free0 (_tmp66_);
	points_left_label = _tmp68_;
	_tmp69_ = points_left_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp69_, GTK_ALIGN_CENTER);
	_tmp70_ = points_left_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp70_, GTK_ALIGN_START);
	_tmp71_ = points_left_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp71_, (gtk_widget_get_height ((GtkWidget*) self) / 3) + 100);
	_tmp72_ = points_left_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp72_, TRUE);
	_tmp73_ = (GtkButton*) gtk_button_new_with_label (_ ("_Play Again"));
	g_object_ref_sink (_tmp73_);
	play_again_button = _tmp73_;
	_tmp74_ = play_again_button;
	gtk_button_set_use_underline (_tmp74_, TRUE);
	_tmp75_ = play_again_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp75_, GTK_ALIGN_CENTER);
	_tmp76_ = play_again_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp76_, GTK_ALIGN_END);
	_tmp77_ = play_again_button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp77_, 100);
	_tmp78_ = play_again_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp78_, "win.new-game");
	_tmp79_ = play_again_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp79_, "suggested-action");
	_tmp80_ = play_again_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp80_, "pill");
	_tmp81_ = play_again_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp81_, TRUE);
	_tmp82_ = game_over_label;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp82_);
	if (is_game_won) {
		GtkLabel* _tmp83_;
		_tmp83_ = msg_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp83_);
	}
	_tmp84_ = self->priv->game;
	_tmp85_ = nibbles_game_get_numhumans (_tmp84_);
	_tmp86_ = _tmp85_;
	if (_tmp86_ == 1) {
		GtkLabel* _tmp87_;
		_tmp87_ = score_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp87_);
	}
	_tmp89_ = self->priv->game;
	_tmp90_ = nibbles_game_get_numhumans (_tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_ == 1) {
		_tmp88_ = !is_high_score;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		GtkLabel* _tmp92_;
		_tmp92_ = points_left_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp92_);
	}
	_tmp93_ = play_again_button;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp93_);
	_tmp94_ = play_again_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp94_);
	_tmp95_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp95_, FALSE);
	self->priv->end_of_game = TRUE;
	_tmp96_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp96_, TRUE);
	_tmp97_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp97_, FALSE);
	_tmp98_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp98_, FALSE);
	_g_object_unref0 (play_again_button);
	_g_object_unref0 (points_left_label);
	_g_object_unref0 (score_label);
	_g_free0 (score_string);
	_g_object_unref0 (msg_label);
	_g_object_unref0 (game_over_label);
}

static gint
nibbles_window_countdown_active (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->seconds;
	return result;
}

static gint
nibbles_window_get_cli_start_level (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cli_start_level;
	return result;
}

static void
nibbles_window_set_cli_start_level (NibblesWindow* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_cli_start_level (self);
	if (old_value != value) {
		self->priv->_cli_start_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY]);
	}
}

static gint
nibbles_window_get_start_level (NibblesWindow* self)
{
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_cli_start_level;
	if (_tmp1_ == 0) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		_tmp0_ = g_settings_get_int (_tmp2_, "start-level");
	} else {
		gint _tmp3_;
		_tmp3_ = self->priv->_cli_start_level;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

gint
nibbles_window_get_progress (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_progress;
	return result;
}

void
nibbles_window_set_progress (NibblesWindow* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_PROGRESS_PROPERTY]);
	}
}

static SetupScreen
nibbles_window_get_start_screen (NibblesWindow* self)
{
	SetupScreen result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start_screen;
	return result;
}

static void
nibbles_window_set_start_screen (NibblesWindow* self,
                                 SetupScreen value)
{
	SetupScreen old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_start_screen (self);
	if (old_value != value) {
		self->priv->_start_screen = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_START_SCREEN_PROPERTY]);
	}
}

gboolean
nibbles_window_get_game_paused (NibblesWindow* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	NibblesGame* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = nibbles_game_get_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
nibbles_window_set_game_paused (NibblesWindow* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_GAME_PAUSED_PROPERTY]);
}

static inline gpointer
nibbles_window_delegate_stack_get_instance_private (NibblesWindowDelegateStack* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindowDelegateStack_private_offset);
}

static gpointer
_nibbles_window_delegate_stack_node_dup0 (gpointer self)
{
	return self ? nibbles_window_delegate_stack_node_dup (self) : NULL;
}

static void
nibbles_window_delegate_stack_push (NibblesWindowDelegateStack* self,
                                    KeypressHandlerFunction handler,
                                    gpointer handler_target)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pHead;
	if (_tmp0_ == NULL) {
		NibblesWindowDelegateStackNode _tmp1_ = {0};
		NibblesWindowDelegateStackNode _tmp2_;
		NibblesWindowDelegateStackNode* _tmp3_;
		_tmp1_.keypress_handler = handler;
		_tmp1_.keypress_handler_target = handler_target;
		_nibbles_window_delegate_stack_node_free0 (_tmp1_.pNext);
		_tmp1_.pNext = NULL;
		_tmp2_ = _tmp1_;
		_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (&_tmp2_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp3_;
		nibbles_window_delegate_stack_node_destroy (&_tmp2_);
	} else {
		NibblesWindowDelegateStackNode* _tmp4_;
		NibblesWindowDelegateStackNode* _tmp5_;
		NibblesWindowDelegateStackNode _tmp6_ = {0};
		NibblesWindowDelegateStackNode _tmp7_;
		NibblesWindowDelegateStackNode* _tmp8_;
		_tmp4_ = self->priv->pHead;
		_tmp5_ = _nibbles_window_delegate_stack_node_dup0 (_tmp4_);
		_tmp6_.keypress_handler = handler;
		_tmp6_.keypress_handler_target = handler_target;
		_nibbles_window_delegate_stack_node_free0 (_tmp6_.pNext);
		_tmp6_.pNext = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _nibbles_window_delegate_stack_node_dup0 (&_tmp7_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp8_;
		nibbles_window_delegate_stack_node_destroy (&_tmp7_);
	}
}

static gboolean
nibbles_window_delegate_stack_pop (NibblesWindowDelegateStack* self)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pHead;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	} else {
		NibblesWindowDelegateStackNode* _tmp1_;
		NibblesWindowDelegateStackNode* _tmp2_;
		NibblesWindowDelegateStackNode* _tmp3_;
		_tmp1_ = self->priv->pHead;
		_tmp2_ = (*_tmp1_).pNext;
		_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (_tmp2_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp3_;
		result = TRUE;
		return result;
	}
}

static void
nibbles_window_delegate_stack_remove (NibblesWindowDelegateStack* self,
                                      KeypressHandlerFunction handler,
                                      gpointer handler_target)
{
	gboolean _tmp0_ = FALSE;
	NibblesWindowDelegateStackNode* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->pHead;
	if (_tmp1_ != NULL) {
		NibblesWindowDelegateStackNode* _tmp2_;
		KeypressHandlerFunction _tmp3_;
		gpointer _tmp3__target;
		_tmp2_ = self->priv->pHead;
		_tmp3_ = (*_tmp2_).keypress_handler;
		_tmp3__target = (*_tmp2_).keypress_handler_target;
		_tmp0_ = _tmp3_ == handler;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesWindowDelegateStackNode* _tmp4_;
		NibblesWindowDelegateStackNode* _tmp5_;
		NibblesWindowDelegateStackNode* _tmp6_;
		_tmp4_ = self->priv->pHead;
		_tmp5_ = (*_tmp4_).pNext;
		_tmp6_ = _nibbles_window_delegate_stack_node_dup0 (_tmp5_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp6_;
	} else {
		gboolean _tmp7_ = FALSE;
		NibblesWindowDelegateStackNode* _tmp8_;
		_tmp8_ = self->priv->pHead;
		if (_tmp8_ != NULL) {
			NibblesWindowDelegateStackNode* _tmp9_;
			NibblesWindowDelegateStackNode* _tmp10_;
			_tmp9_ = self->priv->pHead;
			_tmp10_ = (*_tmp9_).pNext;
			_tmp7_ = _tmp10_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			NibblesWindowDelegateStackNode* pTrail = NULL;
			NibblesWindowDelegateStackNode* _tmp11_;
			NibblesWindowDelegateStackNode* _tmp12_;
			_tmp11_ = self->priv->pHead;
			_tmp12_ = _nibbles_window_delegate_stack_node_dup0 (_tmp11_);
			pTrail = _tmp12_;
			{
				NibblesWindowDelegateStackNode* p = NULL;
				NibblesWindowDelegateStackNode* _tmp13_;
				NibblesWindowDelegateStackNode* _tmp14_;
				NibblesWindowDelegateStackNode* _tmp15_;
				_tmp13_ = pTrail;
				_tmp14_ = (*_tmp13_).pNext;
				_tmp15_ = _nibbles_window_delegate_stack_node_dup0 (_tmp14_);
				p = _tmp15_;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						NibblesWindowDelegateStackNode* _tmp17_;
						NibblesWindowDelegateStackNode* _tmp18_;
						KeypressHandlerFunction _tmp19_;
						gpointer _tmp19__target;
						if (!_tmp16_) {
						}
						_tmp16_ = FALSE;
						_tmp17_ = p;
						if (!(_tmp17_ != NULL)) {
							break;
						}
						_tmp18_ = p;
						_tmp19_ = (*_tmp18_).keypress_handler;
						_tmp19__target = (*_tmp18_).keypress_handler_target;
						if (_tmp19_ == handler) {
							NibblesWindowDelegateStackNode* _tmp20_;
							NibblesWindowDelegateStackNode* _tmp21_;
							NibblesWindowDelegateStackNode* _tmp22_;
							NibblesWindowDelegateStackNode* _tmp23_;
							_tmp20_ = pTrail;
							_tmp21_ = p;
							_tmp22_ = (*_tmp21_).pNext;
							_tmp23_ = _nibbles_window_delegate_stack_node_dup0 (_tmp22_);
							_nibbles_window_delegate_stack_node_free0 ((*_tmp20_).pNext);
							(*_tmp20_).pNext = _tmp23_;
							break;
						} else {
							NibblesWindowDelegateStackNode* _tmp24_;
							NibblesWindowDelegateStackNode* _tmp25_;
							NibblesWindowDelegateStackNode* _tmp26_;
							NibblesWindowDelegateStackNode* _tmp27_;
							NibblesWindowDelegateStackNode* _tmp28_;
							_tmp24_ = p;
							_tmp25_ = _nibbles_window_delegate_stack_node_dup0 (_tmp24_);
							_nibbles_window_delegate_stack_node_free0 (pTrail);
							pTrail = _tmp25_;
							_tmp26_ = p;
							_tmp27_ = (*_tmp26_).pNext;
							_tmp28_ = _nibbles_window_delegate_stack_node_dup0 (_tmp27_);
							_nibbles_window_delegate_stack_node_free0 (p);
							p = _tmp28_;
						}
					}
				}
				_nibbles_window_delegate_stack_node_free0 (p);
			}
			_nibbles_window_delegate_stack_node_free0 (pTrail);
		}
	}
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_iterator (NibblesWindowDelegateStack* self)
{
	NibblesWindowDelegateStackDelegateStackIterator* _tmp0_;
	NibblesWindowDelegateStackDelegateStackIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = nibbles_window_delegate_stack_delegate_stack_iterator_new (self);
	result = _tmp0_;
	return result;
}

static NibblesWindowDelegateStack*
nibbles_window_delegate_stack_construct (GType object_type)
{
	NibblesWindowDelegateStack* self = NULL;
	self = (NibblesWindowDelegateStack*) g_type_create_instance (object_type);
	return self;
}

static NibblesWindowDelegateStack*
nibbles_window_delegate_stack_new (void)
{
	return nibbles_window_delegate_stack_construct (NIBBLES_WINDOW_TYPE_DELEGATE_STACK);
}

static inline gpointer
nibbles_window_delegate_stack_delegate_stack_iterator_get_instance_private (NibblesWindowDelegateStackDelegateStackIterator* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindowDelegateStackDelegateStackIterator_private_offset);
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_delegate_stack_iterator_construct (GType object_type,
                                                                 NibblesWindowDelegateStack* p)
{
	NibblesWindowDelegateStackDelegateStackIterator* self = NULL;
	NibblesWindowDelegateStackNode* _tmp0_;
	NibblesWindowDelegateStackNode* _tmp1_;
	g_return_val_if_fail (p != NULL, NULL);
	self = (NibblesWindowDelegateStackDelegateStackIterator*) g_type_create_instance (object_type);
	_tmp0_ = p->priv->pHead;
	_tmp1_ = _nibbles_window_delegate_stack_node_dup0 (_tmp0_);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
	self->priv->pIterator = _tmp1_;
	self->priv->first_next = TRUE;
	return self;
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_delegate_stack_iterator_new (NibblesWindowDelegateStack* p)
{
	return nibbles_window_delegate_stack_delegate_stack_iterator_construct (NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, p);
}

static gboolean
nibbles_window_delegate_stack_delegate_stack_iterator_next (NibblesWindowDelegateStackDelegateStackIterator* self)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pIterator;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	} else {
		if (self->priv->first_next) {
			self->priv->first_next = !self->priv->first_next;
			result = TRUE;
			return result;
		} else {
			NibblesWindowDelegateStackNode* _tmp1_;
			NibblesWindowDelegateStackNode* _tmp2_;
			NibblesWindowDelegateStackNode* _tmp3_;
			NibblesWindowDelegateStackNode* _tmp4_;
			_tmp1_ = self->priv->pIterator;
			_tmp2_ = (*_tmp1_).pNext;
			_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (_tmp2_);
			_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
			self->priv->pIterator = _tmp3_;
			_tmp4_ = self->priv->pIterator;
			result = _tmp4_ != NULL;
			return result;
		}
	}
}

static KeypressHandlerFunction
nibbles_window_delegate_stack_delegate_stack_iterator_get (NibblesWindowDelegateStackDelegateStackIterator* self,
                                                           gpointer* result_target)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	KeypressHandlerFunction _tmp1_;
	gpointer _tmp1__target;
	KeypressHandlerFunction _tmp2_;
	gpointer _tmp2__target;
	KeypressHandlerFunction result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pIterator;
	_tmp1_ = (*_tmp0_).keypress_handler;
	_tmp1__target = (*_tmp0_).keypress_handler_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_copy_value (const GValue* src_value,
                                                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_window_delegate_stack_delegate_stack_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_window_delegate_stack_value_delegate_stack_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_window_delegate_stack_value_delegate_stack_iterator_collect_value (GValue* value,
                                                                           guint n_collect_values,
                                                                           GTypeCValue* collect_values,
                                                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesWindowDelegateStackDelegateStackIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_window_delegate_stack_delegate_stack_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_window_delegate_stack_value_delegate_stack_iterator_lcopy_value (const GValue* value,
                                                                         guint n_collect_values,
                                                                         GTypeCValue* collect_values,
                                                                         guint collect_flags)
{
	NibblesWindowDelegateStackDelegateStackIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_window_delegate_stack_delegate_stack_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_window_delegate_stack_param_spec_delegate_stack_iterator (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags)
{
	NibblesWindowDelegateStackParamSpecDelegateStackIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_window_delegate_stack_value_get_delegate_stack_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_window_delegate_stack_value_set_delegate_stack_iterator (GValue* value,
                                                                 gpointer v_object)
{
	NibblesWindowDelegateStackDelegateStackIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_window_delegate_stack_delegate_stack_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (old);
	}
}

static void
nibbles_window_delegate_stack_value_take_delegate_stack_iterator (GValue* value,
                                                                  gpointer v_object)
{
	NibblesWindowDelegateStackDelegateStackIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (old);
	}
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_class_init (NibblesWindowDelegateStackDelegateStackIteratorClass * klass,
                                                                  gpointer klass_data)
{
	nibbles_window_delegate_stack_delegate_stack_iterator_parent_class = g_type_class_peek_parent (klass);
	((NibblesWindowDelegateStackDelegateStackIteratorClass *) klass)->finalize = nibbles_window_delegate_stack_delegate_stack_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesWindowDelegateStackDelegateStackIterator_private_offset);
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_instance_init (NibblesWindowDelegateStackDelegateStackIterator * self,
                                                                     gpointer klass)
{
	self->priv = nibbles_window_delegate_stack_delegate_stack_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_finalize (NibblesWindowDelegateStackDelegateStackIterator * obj)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIterator);
	g_signal_handlers_destroy (self);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_window_delegate_stack_value_delegate_stack_iterator_init, nibbles_window_delegate_stack_value_delegate_stack_iterator_free_value, nibbles_window_delegate_stack_value_delegate_stack_iterator_copy_value, nibbles_window_delegate_stack_value_delegate_stack_iterator_peek_pointer, "p", nibbles_window_delegate_stack_value_delegate_stack_iterator_collect_value, "p", nibbles_window_delegate_stack_value_delegate_stack_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowDelegateStackDelegateStackIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_delegate_stack_delegate_stack_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindowDelegateStackDelegateStackIterator), 0, (GInstanceInitFunc) nibbles_window_delegate_stack_delegate_stack_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
	nibbles_window_delegate_stack_delegate_stack_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesWindowDelegateStackDelegateStackIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesWindowDelegateStackDelegateStackIterator_private_offset = g_type_add_instance_private (nibbles_window_delegate_stack_delegate_stack_iterator_type_id, sizeof (NibblesWindowDelegateStackDelegateStackIteratorPrivate));
	return nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
}

GType
nibbles_window_delegate_stack_delegate_stack_iterator_get_type (void)
{
	static gsize nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once)) {
		GType nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
		nibbles_window_delegate_stack_delegate_stack_iterator_type_id = nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once, nibbles_window_delegate_stack_delegate_stack_iterator_type_id);
	}
	return nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once;
}

static gpointer
nibbles_window_delegate_stack_delegate_stack_iterator_ref (gpointer instance)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_unref (gpointer instance)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
nibbles_window_delegate_stack_node_copy (const NibblesWindowDelegateStackNode* self,
                                         NibblesWindowDelegateStackNode* dest)
{
	KeypressHandlerFunction _tmp0_;
	gpointer _tmp0__target;
	NibblesWindowDelegateStackNode* _tmp1_;
	NibblesWindowDelegateStackNode* _tmp2_;
	_tmp0_ = (*self).keypress_handler;
	_tmp0__target = (*self).keypress_handler_target;
	(*dest).keypress_handler = _tmp0_;
	(*dest).keypress_handler_target = _tmp0__target;
	_tmp1_ = (*self).pNext;
	_tmp2_ = _nibbles_window_delegate_stack_node_dup0 (_tmp1_);
	_nibbles_window_delegate_stack_node_free0 ((*dest).pNext);
	(*dest).pNext = _tmp2_;
}

static void
nibbles_window_delegate_stack_node_destroy (NibblesWindowDelegateStackNode* self)
{
	_nibbles_window_delegate_stack_node_free0 ((*self).pNext);
}

static NibblesWindowDelegateStackNode*
nibbles_window_delegate_stack_node_dup (const NibblesWindowDelegateStackNode* self)
{
	NibblesWindowDelegateStackNode* dup;
	dup = g_new0 (NibblesWindowDelegateStackNode, 1);
	nibbles_window_delegate_stack_node_copy (self, dup);
	return dup;
}

static void
nibbles_window_delegate_stack_node_free (NibblesWindowDelegateStackNode* self)
{
	nibbles_window_delegate_stack_node_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_node_get_type_once (void)
{
	GType nibbles_window_delegate_stack_node_type_id;
	nibbles_window_delegate_stack_node_type_id = g_boxed_type_register_static ("NibblesWindowDelegateStackNode", (GBoxedCopyFunc) nibbles_window_delegate_stack_node_dup, (GBoxedFreeFunc) nibbles_window_delegate_stack_node_free);
	return nibbles_window_delegate_stack_node_type_id;
}

static GType
nibbles_window_delegate_stack_node_get_type (void)
{
	static gsize nibbles_window_delegate_stack_node_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_node_type_id__once)) {
		GType nibbles_window_delegate_stack_node_type_id;
		nibbles_window_delegate_stack_node_type_id = nibbles_window_delegate_stack_node_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_node_type_id__once, nibbles_window_delegate_stack_node_type_id);
	}
	return nibbles_window_delegate_stack_node_type_id__once;
}

static void
nibbles_window_value_delegate_stack_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_window_value_delegate_stack_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_window_delegate_stack_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_window_value_delegate_stack_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_window_delegate_stack_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_window_value_delegate_stack_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_window_value_delegate_stack_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesWindowDelegateStack * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_window_delegate_stack_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_window_value_delegate_stack_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	NibblesWindowDelegateStack ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_window_delegate_stack_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_window_param_spec_delegate_stack (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	NibblesWindowParamSpecDelegateStack* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_WINDOW_TYPE_DELEGATE_STACK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_window_value_get_delegate_stack (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_window_value_set_delegate_stack (GValue* value,
                                         gpointer v_object)
{
	NibblesWindowDelegateStack * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_window_delegate_stack_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_unref (old);
	}
}

static void
nibbles_window_value_take_delegate_stack (GValue* value,
                                          gpointer v_object)
{
	NibblesWindowDelegateStack * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_unref (old);
	}
}

static void
nibbles_window_delegate_stack_class_init (NibblesWindowDelegateStackClass * klass,
                                          gpointer klass_data)
{
	nibbles_window_delegate_stack_parent_class = g_type_class_peek_parent (klass);
	((NibblesWindowDelegateStackClass *) klass)->finalize = nibbles_window_delegate_stack_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesWindowDelegateStack_private_offset);
}

static void
nibbles_window_delegate_stack_instance_init (NibblesWindowDelegateStack * self,
                                             gpointer klass)
{
	self->priv = nibbles_window_delegate_stack_get_instance_private (self);
	self->priv->pHead = NULL;
	self->ref_count = 1;
}

static void
nibbles_window_delegate_stack_finalize (NibblesWindowDelegateStack * obj)
{
	NibblesWindowDelegateStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStack);
	g_signal_handlers_destroy (self);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_window_value_delegate_stack_init, nibbles_window_value_delegate_stack_free_value, nibbles_window_value_delegate_stack_copy_value, nibbles_window_value_delegate_stack_peek_pointer, "p", nibbles_window_value_delegate_stack_collect_value, "p", nibbles_window_value_delegate_stack_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowDelegateStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_delegate_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindowDelegateStack), 0, (GInstanceInitFunc) nibbles_window_delegate_stack_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_window_delegate_stack_type_id;
	nibbles_window_delegate_stack_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesWindowDelegateStack", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesWindowDelegateStack_private_offset = g_type_add_instance_private (nibbles_window_delegate_stack_type_id, sizeof (NibblesWindowDelegateStackPrivate));
	return nibbles_window_delegate_stack_type_id;
}

static GType
nibbles_window_delegate_stack_get_type (void)
{
	static gsize nibbles_window_delegate_stack_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_type_id__once)) {
		GType nibbles_window_delegate_stack_type_id;
		nibbles_window_delegate_stack_type_id = nibbles_window_delegate_stack_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_type_id__once, nibbles_window_delegate_stack_type_id);
	}
	return nibbles_window_delegate_stack_type_id__once;
}

static gpointer
nibbles_window_delegate_stack_ref (gpointer instance)
{
	NibblesWindowDelegateStack * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_window_delegate_stack_unref (gpointer instance)
{
	NibblesWindowDelegateStack * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_WINDOW_DELEGATE_STACK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_nibbles_window_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                        const gchar* key,
                                                        gpointer self)
{
	nibbles_window_settings_changed_cb ((NibblesWindow*) self, key);
}

static void
_nibbles_window_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self)
{
	nibbles_window_worm_settings_changed_cb ((NibblesWindow*) self, _sender, key);
}

static void
_nibbles_window___lambda43_ (NibblesWindow* self)
{
	NibblesView* _tmp0_;
	_tmp0_ = self->priv->view;
	if (NULL != _tmp0_) {
		NibblesView* _tmp1_;
		_tmp1_ = self->priv->view;
		gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp1_);
	}
}

static void
__nibbles_window___lambda43__gtk_popover_closed (GtkPopover* _sender,
                                                 gpointer self)
{
	_nibbles_window___lambda43_ ((NibblesWindow*) self);
}

static gboolean
_nibbles_window___lambda44_ (NibblesWindow* self,
                             GtkEventControllerKey* controller,
                             guint keyval,
                             guint keycode,
                             GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (controller != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	if (g_strcmp0 ((const gchar*) _tmp0_, "F1") == 0) {
		if ((state & GDK_CONTROL_MASK) > 0) {
			g_action_group_activate_action ((GActionGroup*) self, "show-help-overlay", NULL);
		} else {
			if ((state & GDK_SHIFT_MASK) > 0) {
				GtkApplication* _tmp2_;
				GtkApplication* _tmp3_;
				_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
				_tmp3_ = _tmp2_;
				g_action_group_activate_action ((GActionGroup*) _tmp3_, "about", NULL);
			} else {
				if ((state & GDK_SHIFT_MASK) == 0) {
					GtkApplication* _tmp4_;
					GtkApplication* _tmp5_;
					_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
					_tmp5_ = _tmp4_;
					g_action_group_activate_action ((GActionGroup*) _tmp5_, "help", NULL);
				} else {
					result = FALSE;
					return result;
				}
			}
		}
		result = TRUE;
		return result;
	} else {
		NibblesWindowDelegateStack* handlers_to_remove = NULL;
		NibblesWindowDelegateStack* _tmp6_;
		_tmp6_ = nibbles_window_delegate_stack_new ();
		handlers_to_remove = _tmp6_;
		{
			NibblesWindowDelegateStackDelegateStackIterator* _handler_it = NULL;
			NibblesWindowDelegateStack* _tmp7_;
			NibblesWindowDelegateStackDelegateStackIterator* _tmp8_;
			_tmp7_ = self->priv->keypress_handlers;
			_tmp8_ = nibbles_window_delegate_stack_iterator (_tmp7_);
			_handler_it = _tmp8_;
			while (TRUE) {
				NibblesWindowDelegateStackDelegateStackIterator* _tmp9_;
				KeypressHandlerFunction handler = NULL;
				NibblesWindowDelegateStackDelegateStackIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				KeypressHandlerFunction _tmp12_;
				gpointer handler_target;
				gboolean remove_handler = FALSE;
				gboolean r = FALSE;
				KeypressHandlerFunction _tmp13_;
				gpointer _tmp13__target;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_;
				_tmp9_ = _handler_it;
				if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp9_)) {
					break;
				}
				_tmp10_ = _handler_it;
				_tmp12_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp10_, &_tmp11_);
				handler = _tmp12_;
				handler_target = _tmp11_;
				_tmp13_ = handler;
				_tmp13__target = handler_target;
				_tmp15_ = _tmp13_ (keyval, keycode, &_tmp14_, _tmp13__target);
				remove_handler = _tmp14_;
				r = _tmp15_;
				if (remove_handler) {
					NibblesWindowDelegateStack* _tmp16_;
					KeypressHandlerFunction _tmp17_;
					gpointer _tmp17__target;
					_tmp16_ = handlers_to_remove;
					_tmp17_ = handler;
					_tmp17__target = handler_target;
					nibbles_window_delegate_stack_push (_tmp16_, _tmp17_, _tmp17__target);
				}
				if (r) {
					{
						NibblesWindowDelegateStackDelegateStackIterator* _h_it = NULL;
						NibblesWindowDelegateStack* _tmp18_;
						NibblesWindowDelegateStackDelegateStackIterator* _tmp19_;
						_tmp18_ = handlers_to_remove;
						_tmp19_ = nibbles_window_delegate_stack_iterator (_tmp18_);
						_h_it = _tmp19_;
						while (TRUE) {
							NibblesWindowDelegateStackDelegateStackIterator* _tmp20_;
							KeypressHandlerFunction h = NULL;
							NibblesWindowDelegateStackDelegateStackIterator* _tmp21_;
							gpointer _tmp22_ = NULL;
							KeypressHandlerFunction _tmp23_;
							gpointer h_target;
							NibblesWindowDelegateStack* _tmp24_;
							KeypressHandlerFunction _tmp25_;
							gpointer _tmp25__target;
							_tmp20_ = _h_it;
							if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp20_)) {
								break;
							}
							_tmp21_ = _h_it;
							_tmp23_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp21_, &_tmp22_);
							h = _tmp23_;
							h_target = _tmp22_;
							_tmp24_ = self->priv->keypress_handlers;
							_tmp25_ = h;
							_tmp25__target = h_target;
							nibbles_window_delegate_stack_remove (_tmp24_, _tmp25_, _tmp25__target);
						}
						_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_h_it);
					}
					result = r;
					_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
					_nibbles_window_delegate_stack_unref0 (handlers_to_remove);
					return result;
				}
			}
			_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
		}
		{
			NibblesWindowDelegateStackDelegateStackIterator* _handler_it = NULL;
			NibblesWindowDelegateStack* _tmp26_;
			NibblesWindowDelegateStackDelegateStackIterator* _tmp27_;
			_tmp26_ = handlers_to_remove;
			_tmp27_ = nibbles_window_delegate_stack_iterator (_tmp26_);
			_handler_it = _tmp27_;
			while (TRUE) {
				NibblesWindowDelegateStackDelegateStackIterator* _tmp28_;
				KeypressHandlerFunction handler = NULL;
				NibblesWindowDelegateStackDelegateStackIterator* _tmp29_;
				gpointer _tmp30_ = NULL;
				KeypressHandlerFunction _tmp31_;
				gpointer handler_target;
				NibblesWindowDelegateStack* _tmp32_;
				KeypressHandlerFunction _tmp33_;
				gpointer _tmp33__target;
				_tmp28_ = _handler_it;
				if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp28_)) {
					break;
				}
				_tmp29_ = _handler_it;
				_tmp31_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp29_, &_tmp30_);
				handler = _tmp31_;
				handler_target = _tmp30_;
				_tmp32_ = self->priv->keypress_handlers;
				_tmp33_ = handler;
				_tmp33__target = handler_target;
				nibbles_window_delegate_stack_remove (_tmp32_, _tmp33_, _tmp33__target);
			}
			_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
		}
		result = FALSE;
		_nibbles_window_delegate_stack_unref0 (handlers_to_remove);
		return result;
	}
}

static gboolean
__nibbles_window___lambda44__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state,
                                                                   gpointer self)
{
	gboolean result;
	result = _nibbles_window___lambda44_ ((NibblesWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_nibbles_window___lambda45_ (NibblesWindow* self)
{
	_vala_assert (FALSE, "false");
}

static void
__nibbles_window___lambda45__gtk_event_controller_key_im_update (GtkEventControllerKey* _sender,
                                                                 gpointer self)
{
	_nibbles_window___lambda45_ ((NibblesWindow*) self);
}

static void
_nibbles_window_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                     gint score,
                                                     gint level_reached,
                                                     gpointer self)
{
	nibbles_window_log_score_cb ((NibblesWindow*) self, score, level_reached);
}

static void
_nibbles_window_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                                 gpointer self)
{
	nibbles_window_level_completed_cb ((NibblesWindow*) self);
}

static gchar*
_nibbles_window___lambda46_ (NibblesWindow* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (PKGDATADIR);
	result = _tmp0_;
	return result;
}

static gchar*
__nibbles_window___lambda46__nibbles_game_get_pkgdatadir (NibblesGame* _sender,
                                                          gpointer self)
{
	gchar* result;
	result = _nibbles_window___lambda46_ ((NibblesWindow*) self);
	return result;
}

static gboolean
_nibbles_window___lambda47_ (NibblesWindow* self,
                             KeypressHandlerFunction handler,
                             gpointer handler_target)
{
	gboolean result;
	if (handler != NULL) {
		NibblesWindowDelegateStack* _tmp0_;
		_tmp0_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_push (_tmp0_, handler, handler_target);
	} else {
		NibblesWindowDelegateStack* _tmp1_;
		_tmp1_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_pop (_tmp1_);
	}
	result = TRUE;
	return result;
}

static gboolean
__nibbles_window___lambda47__nibbles_game_add_keypress_handler (NibblesGame* _sender,
                                                                KeypressHandlerFunction keypress_handler,
                                                                gpointer keypress_handler_target,
                                                                gpointer self)
{
	gboolean result;
	result = _nibbles_window___lambda47_ ((NibblesWindow*) self, keypress_handler, keypress_handler_target);
	return result;
}

static gint
_nibbles_window_countdown_active_nibbles_view_countdown_active_function (gpointer self)
{
	gint result;
	result = nibbles_window_countdown_active ((NibblesWindow*) self);
	return result;
}

static void
_nibbles_window___lambda48_ (NibblesWindow* self,
                             KeypressHandlerFunction handler,
                             gpointer handler_target)
{
	if (handler != NULL) {
		NibblesWindowDelegateStack* _tmp0_;
		_tmp0_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_push (_tmp0_, handler, handler_target);
	} else {
		NibblesWindowDelegateStack* _tmp1_;
		_tmp1_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_pop (_tmp1_);
	}
}

static void
__nibbles_window___lambda48__controls_add_keypress_handler (Controls* _sender,
                                                            KeypressHandlerFunction handler,
                                                            gpointer handler_target,
                                                            gpointer self)
{
	_nibbles_window___lambda48_ ((NibblesWindow*) self, handler, handler_target);
}

static GObject *
nibbles_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NibblesWindow * self;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GAction* _tmp11_;
	GAction* _tmp12_;
	GSettings* _tmp13_;
	GAction* _tmp14_;
	GAction* _tmp15_;
	GeeArrayList* _tmp16_;
	GtkMenuButton* _tmp27_;
	GtkPopover* _tmp28_;
	GSettings* _tmp29_;
	GSettings* _tmp30_;
	GSettings* _tmp31_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp32_;
	GtkEventControllerKey* _tmp33_;
	GtkEventControllerKey* _tmp34_;
	GtkEventControllerKey* _tmp35_;
	GtkEventController* _tmp36_;
	gboolean three_dimensional_view = FALSE;
	GSettings* _tmp37_;
	GSettings* _tmp38_;
	Sound* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	GSettings* _tmp42_;
	GSettings* _tmp43_;
	NibblesGame* _tmp44_;
	NibblesGame* _tmp45_;
	NibblesGame* _tmp46_;
	Sound* _tmp47_;
	NibblesGame* _tmp48_;
	NibblesGame* _tmp49_;
	NibblesGame* _tmp50_;
	NibblesGame* _tmp51_;
	NibblesView* _tmp52_;
	NibblesView* _tmp53_;
	NibblesView* _tmp54_;
	GtkBox* _tmp55_;
	NibblesView* _tmp56_;
	NibblesView* _tmp57_;
	NibblesGame* _tmp58_;
	GSettings* _tmp59_;
	gint numai = 0;
	GSettings* _tmp60_;
	NibblesGame* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	NibblesGame* _tmp70_;
	Players* _tmp71_;
	NibblesGame* _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	BoardProgress* _tmp75_;
	GSettings* _tmp76_;
	GSettings* _tmp77_;
	Speed* _tmp78_;
	GSettings* _tmp79_;
	GSettings* _tmp80_;
	Controls* _tmp81_;
	SetupScreen _tmp82_;
	parent_class = G_OBJECT_CLASS (nibbles_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_WINDOW, NibblesWindow);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_WINDOW_menu_entries, (gint) G_N_ELEMENTS (NIBBLES_WINDOW_menu_entries), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp5_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "start-game");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->start_game_action);
	self->priv->start_game_action = _tmp7_;
	_tmp8_ = g_settings_new ("org.gnome.Nibbles");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp8_;
	_tmp9_ = self->priv->settings;
	g_signal_connect_object (_tmp9_, "changed", (GCallback) _nibbles_window_settings_changed_cb_g_settings_changed, self, 0);
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_create_action (_tmp10_, "sound");
	_tmp12_ = _tmp11_;
	g_action_map_add_action ((GActionMap*) self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_create_action (_tmp13_, "three-dimensional-view");
	_tmp15_ = _tmp14_;
	g_action_map_add_action ((GActionMap*) self, _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = gee_array_list_new (g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar* name = NULL;
				gchar* _tmp19_;
				GeeArrayList* _tmp20_;
				const gchar* _tmp21_;
				GSettings* _tmp22_;
				GSettings* _tmp23_;
				GeeArrayList* _tmp24_;
				gpointer _tmp25_;
				GSettings* _tmp26_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp19_ = g_strdup_printf ("org.gnome.Nibbles.worm%d", i);
				name = _tmp19_;
				_tmp20_ = self->priv->worm_settings;
				_tmp21_ = name;
				_tmp22_ = g_settings_new (_tmp21_);
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp23_);
				_g_object_unref0 (_tmp23_);
				_tmp24_ = self->priv->worm_settings;
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, i);
				_tmp26_ = (GSettings*) _tmp25_;
				g_signal_connect_object (_tmp26_, "changed", (GCallback) _nibbles_window_worm_settings_changed_cb_g_settings_changed, self, 0);
				_g_object_unref0 (_tmp26_);
				_g_free0 (name);
			}
		}
	}
	_tmp27_ = self->priv->hamburger_menu;
	_tmp28_ = gtk_menu_button_get_popover (_tmp27_);
	g_signal_connect_object (_tmp28_, "closed", (GCallback) __nibbles_window___lambda43__gtk_popover_closed, self, 0);
	_tmp29_ = self->priv->settings;
	_tmp30_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp29_, "window-width"), g_settings_get_int (_tmp30_, "window-height"));
	_tmp31_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp31_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp32_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp32_;
	_tmp33_ = key_controller;
	g_signal_connect_object (_tmp33_, "key-pressed", (GCallback) __nibbles_window___lambda44__gtk_event_controller_key_key_pressed, self, 0);
	_tmp34_ = key_controller;
	g_signal_connect_object (_tmp34_, "im-update", (GCallback) __nibbles_window___lambda45__gtk_event_controller_key_im_update, self, 0);
	_tmp35_ = key_controller;
	_tmp36_ = _g_object_ref0 ((GtkEventController*) _tmp35_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp36_);
	_tmp37_ = self->priv->settings;
	three_dimensional_view = g_settings_get_boolean (_tmp37_, "three-dimensional-view");
	_tmp38_ = self->priv->settings;
	_tmp39_ = sound_new (!g_settings_get_boolean (_tmp38_, "sound"));
	_g_object_unref0 (self->priv->sound);
	self->priv->sound = _tmp39_;
	_tmp40_ = nibbles_window_get_start_level (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->settings;
	_tmp43_ = self->priv->settings;
	_tmp44_ = nibbles_game_new (_tmp41_, g_settings_get_int (_tmp42_, "speed"), 35, g_settings_get_boolean (_tmp43_, "fakes"), three_dimensional_view, NIBBLES_VIEW_WIDTH, NIBBLES_VIEW_HEIGHT, FALSE);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp44_;
	_tmp45_ = self->priv->game;
	g_signal_connect_object (_tmp45_, "log-score", (GCallback) _nibbles_window_log_score_cb_nibbles_game_log_score, self, 0);
	_tmp46_ = self->priv->game;
	g_signal_connect_object (_tmp46_, "level-completed", (GCallback) _nibbles_window_level_completed_cb_nibbles_game_level_completed, self, 0);
	_tmp47_ = self->priv->sound;
	_tmp48_ = self->priv->game;
	sound_connect_signal (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->game;
	g_signal_connect_object (_tmp49_, "get-pkgdatadir", (GCallback) __nibbles_window___lambda46__nibbles_game_get_pkgdatadir, self, 0);
	_tmp50_ = self->priv->game;
	g_signal_connect_object (_tmp50_, "add-keypress-handler", (GCallback) __nibbles_window___lambda47__nibbles_game_add_keypress_handler, self, 0);
	_tmp51_ = self->priv->game;
	_tmp52_ = nibbles_view_new (_tmp51_, _nibbles_window_countdown_active_nibbles_view_countdown_active_function, self);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp52_;
	_tmp53_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp53_, TRUE);
	_tmp54_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp54_, TRUE);
	_tmp55_ = self->priv->game_box;
	_tmp56_ = self->priv->view;
	gtk_box_prepend (_tmp55_, (GtkWidget*) _tmp56_);
	_tmp57_ = self->priv->view;
	gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp57_);
	_tmp58_ = self->priv->game;
	_tmp59_ = self->priv->settings;
	nibbles_game_set_numhumans (_tmp58_, g_settings_get_int (_tmp59_, "players"));
	_tmp60_ = self->priv->settings;
	numai = g_settings_get_int (_tmp60_, "ai");
	_tmp61_ = self->priv->game;
	_tmp62_ = nibbles_game_get_numhumans (_tmp61_);
	_tmp63_ = _tmp62_;
	if ((numai + _tmp63_) > NIBBLES_GAME_MAX_WORMS) {
		NibblesGame* _tmp64_;
		GSettings* _tmp65_;
		NibblesGame* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		GSettings* _tmp69_;
		_tmp64_ = self->priv->game;
		nibbles_game_set_numhumans (_tmp64_, 1);
		numai = 5;
		_tmp65_ = self->priv->settings;
		_tmp66_ = self->priv->game;
		_tmp67_ = nibbles_game_get_numhumans (_tmp66_);
		_tmp68_ = _tmp67_;
		g_settings_set_int (_tmp65_, "players", _tmp68_);
		_tmp69_ = self->priv->settings;
		g_settings_set_int (_tmp69_, "ai", numai);
	}
	_tmp70_ = self->priv->game;
	nibbles_game_set_numai (_tmp70_, numai);
	_tmp71_ = self->priv->players;
	_tmp72_ = self->priv->game;
	_tmp73_ = nibbles_game_get_numhumans (_tmp72_);
	_tmp74_ = _tmp73_;
	players_set_values (_tmp71_, _tmp74_, numai);
	_tmp75_ = self->priv->board_progress;
	_tmp76_ = self->priv->settings;
	_tmp77_ = self->priv->settings;
	board_progress_set_values (_tmp75_, g_settings_get_int (_tmp76_, "progress"), g_settings_get_int (_tmp77_, "start-level"));
	_tmp78_ = self->priv->speed;
	_tmp79_ = self->priv->settings;
	_tmp80_ = self->priv->settings;
	speed_set_values (_tmp78_, g_settings_get_int (_tmp79_, "speed"), g_settings_get_boolean (_tmp80_, "fakes"));
	_tmp81_ = self->priv->controls;
	g_signal_connect_object (_tmp81_, "add-keypress-handler", (GCallback) __nibbles_window___lambda48__controls_add_keypress_handler, self, 0);
	_tmp82_ = self->priv->_start_screen;
	if (_tmp82_ == SETUP_SCREEN_GAME) {
		NibblesGame* _tmp83_;
		GSettings* _tmp84_;
		NibblesGame* _tmp85_;
		GSettings* _tmp86_;
		NibblesGame* _tmp87_;
		GSettings* _tmp88_;
		NibblesGame* _tmp89_;
		GSettings* _tmp90_;
		NibblesGame* _tmp91_;
		GeeArrayList* _tmp92_;
		_tmp83_ = self->priv->game;
		_tmp84_ = self->priv->settings;
		nibbles_game_set_numhumans (_tmp83_, g_settings_get_int (_tmp84_, "players"));
		_tmp85_ = self->priv->game;
		_tmp86_ = self->priv->settings;
		nibbles_game_set_numai (_tmp85_, g_settings_get_int (_tmp86_, "ai"));
		_tmp87_ = self->priv->game;
		_tmp88_ = self->priv->settings;
		nibbles_game_set_speed (_tmp87_, g_settings_get_int (_tmp88_, "speed"));
		_tmp89_ = self->priv->game;
		_tmp90_ = self->priv->settings;
		nibbles_game_set_fakes (_tmp89_, g_settings_get_boolean (_tmp90_, "fakes"));
		_tmp91_ = self->priv->game;
		_tmp92_ = self->priv->worm_settings;
		nibbles_game_create_worms (_tmp91_, _tmp92_);
		nibbles_window_start_game (self);
	} else {
		SetupScreen _tmp93_;
		_tmp93_ = self->priv->_start_screen;
		if (_tmp93_ == SETUP_SCREEN_CONTROLS) {
			NibblesGame* _tmp94_;
			GSettings* _tmp95_;
			NibblesGame* _tmp96_;
			GSettings* _tmp97_;
			NibblesGame* _tmp98_;
			GSettings* _tmp99_;
			NibblesGame* _tmp100_;
			GSettings* _tmp101_;
			_tmp94_ = self->priv->game;
			_tmp95_ = self->priv->settings;
			nibbles_game_set_numhumans (_tmp94_, g_settings_get_int (_tmp95_, "players"));
			_tmp96_ = self->priv->game;
			_tmp97_ = self->priv->settings;
			nibbles_game_set_numai (_tmp96_, g_settings_get_int (_tmp97_, "ai"));
			_tmp98_ = self->priv->game;
			_tmp99_ = self->priv->settings;
			nibbles_game_set_speed (_tmp98_, g_settings_get_int (_tmp99_, "speed"));
			_tmp100_ = self->priv->game;
			_tmp101_ = self->priv->settings;
			nibbles_game_set_fakes (_tmp100_, g_settings_get_boolean (_tmp101_, "fakes"));
			nibbles_window_show_controls_screen (self);
		} else {
			SetupScreen _tmp102_;
			_tmp102_ = self->priv->_start_screen;
			if (_tmp102_ == SETUP_SCREEN_SPEED) {
				NibblesGame* _tmp103_;
				GSettings* _tmp104_;
				NibblesGame* _tmp105_;
				GSettings* _tmp106_;
				GtkStack* _tmp107_;
				_tmp103_ = self->priv->game;
				_tmp104_ = self->priv->settings;
				nibbles_game_set_numhumans (_tmp103_, g_settings_get_int (_tmp104_, "players"));
				_tmp105_ = self->priv->game;
				_tmp106_ = self->priv->settings;
				nibbles_game_set_numai (_tmp105_, g_settings_get_int (_tmp106_, "ai"));
				_tmp107_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp107_, "speed");
			} else {
				GSettings* _tmp108_;
				_tmp108_ = self->priv->settings;
				if (g_settings_get_boolean (_tmp108_, "first-run")) {
					FirstRun* first_run_panel = NULL;
					FirstRun* _tmp109_;
					FirstRun* _tmp110_;
					GtkStack* _tmp111_;
					FirstRun* _tmp112_;
					GSimpleAction* _tmp113_;
					GSimpleAction* _tmp114_;
					GSimpleAction* _tmp115_;
					GtkStack* _tmp116_;
					FirstRun* _tmp117_;
					_tmp109_ = first_run_new ();
					g_object_ref_sink (_tmp109_);
					first_run_panel = _tmp109_;
					_tmp110_ = first_run_panel;
					gtk_widget_set_visible ((GtkWidget*) _tmp110_, TRUE);
					_tmp111_ = self->priv->main_stack;
					_tmp112_ = first_run_panel;
					gtk_stack_add_named (_tmp111_, (GtkWidget*) _tmp112_, "first-run");
					_tmp113_ = self->priv->new_game_action;
					g_simple_action_set_enabled (_tmp113_, TRUE);
					_tmp114_ = self->priv->pause_action;
					g_simple_action_set_enabled (_tmp114_, FALSE);
					_tmp115_ = self->priv->back_action;
					g_simple_action_set_enabled (_tmp115_, FALSE);
					_tmp116_ = self->priv->main_stack;
					_tmp117_ = first_run_panel;
					gtk_stack_set_visible_child (_tmp116_, (GtkWidget*) _tmp117_);
					_g_object_unref0 (first_run_panel);
				} else {
					nibbles_window_show_new_game_screen (self, FALSE);
				}
			}
		}
	}
	nibbles_window_create_scores (self);
	_g_object_unref0 (key_controller);
	return obj;
}

static void
nibbles_window_class_init (NibblesWindowClass * klass,
                           gpointer klass_data)
{
	nibbles_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = nibbles_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = nibbles_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY] = g_param_spec_int ("cli-start-level", "cli-start-level", "cli-start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_PROGRESS_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_PROGRESS_PROPERTY] = g_param_spec_int ("progress", "progress", "progress", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_START_SCREEN_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_START_SCREEN_PROPERTY] = g_param_spec_enum ("start-screen", "start-screen", "start-screen", TYPE_SETUP_SCREEN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_GAME_PAUSED_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("game-paused", "game-paused", "game-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/nibbles-adw.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_button", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, pause_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_menu", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, hamburger_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, players));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "speed", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, speed));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "board_progress", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, board_progress));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, controls));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "statusbar_stack", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, statusbar_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scoreboard", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, scoreboard));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, game_box));
}

static void
nibbles_window_instance_init (NibblesWindow * self,
                              gpointer klass)
{
	NibblesWindowDelegateStack* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = nibbles_window_get_instance_private (self);
	_tmp0_ = nibbles_window_delegate_stack_new ();
	self->priv->keypress_handlers = _tmp0_;
	self->priv->game = NULL;
	self->priv->countdown_id = (guint) 0;
	self->priv->seconds = 0;
	self->priv->dialog_visible = FALSE;
	_tmp1_ = gee_array_list_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->overlay_members = _tmp1_;
	self->priv->end_of_game = FALSE;
	g_type_ensure (TYPE_PLAYERS);
	g_type_ensure (TYPE_SPEED);
	g_type_ensure (TYPE_BOARD_PROGRESS);
	g_type_ensure (TYPE_CONTROLS);
	g_type_ensure (TYPE_SCOREBOARD);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
nibbles_window_finalize (GObject * obj)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_WINDOW, NibblesWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->sound);
	_nibbles_window_delegate_stack_unref0 (self->priv->keypress_handlers);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->scorecats);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->back_action);
	_g_object_unref0 (self->priv->start_game_action);
	_g_object_unref0 (self->priv->overlay_members);
	G_OBJECT_CLASS (nibbles_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindow), 0, (GInstanceInitFunc) nibbles_window_instance_init, NULL };
	GType nibbles_window_type_id;
	nibbles_window_type_id = g_type_register_static (adw_application_window_get_type (), "NibblesWindow", &g_define_type_info, 0);
	NibblesWindow_private_offset = g_type_add_instance_private (nibbles_window_type_id, sizeof (NibblesWindowPrivate));
	return nibbles_window_type_id;
}

GType
nibbles_window_get_type (void)
{
	static gsize nibbles_window_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_type_id__once)) {
		GType nibbles_window_type_id;
		nibbles_window_type_id = nibbles_window_get_type_once ();
		g_once_init_leave (&nibbles_window_type_id__once, nibbles_window_type_id);
	}
	return nibbles_window_type_id__once;
}

static void
_vala_nibbles_window_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_WINDOW, NibblesWindow);
	switch (property_id) {
		case NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_window_get_cli_start_level (self));
		break;
		case NIBBLES_WINDOW_PROGRESS_PROPERTY:
		g_value_set_int (value, nibbles_window_get_progress (self));
		break;
		case NIBBLES_WINDOW_START_SCREEN_PROPERTY:
		g_value_set_enum (value, nibbles_window_get_start_screen (self));
		break;
		case NIBBLES_WINDOW_GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, nibbles_window_get_game_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nibbles_window_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_WINDOW, NibblesWindow);
	switch (property_id) {
		case NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY:
		nibbles_window_set_cli_start_level (self, g_value_get_int (value));
		break;
		case NIBBLES_WINDOW_PROGRESS_PROPERTY:
		nibbles_window_set_progress (self, g_value_get_int (value));
		break;
		case NIBBLES_WINDOW_START_SCREEN_PROPERTY:
		nibbles_window_set_start_screen (self, g_value_get_enum (value));
		break;
		case NIBBLES_WINDOW_GAME_PAUSED_PROPERTY:
		nibbles_window_set_game_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
first_run_get_instance_private (FirstRun* self)
{
	return G_STRUCT_MEMBER_P (self, FirstRun_private_offset);
}

FirstRun*
first_run_construct (GType object_type)
{
	FirstRun * self = NULL;
	self = (FirstRun*) g_object_new (object_type, NULL);
	return self;
}

FirstRun*
first_run_new (void)
{
	return first_run_construct (TYPE_FIRST_RUN);
}

static GObject *
first_run_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FirstRun * self;
	GtkButton* _tmp0_;
	parent_class = G_OBJECT_CLASS (first_run_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FIRST_RUN, FirstRun);
	_tmp0_ = self->priv->button;
	if (gtk_widget_has_css_class ((GtkWidget*) _tmp0_, "play")) {
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		_tmp1_ = self->priv->button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp1_, "play");
		_tmp2_ = self->priv->button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "pill");
	}
	return obj;
}

static void
first_run_class_init (FirstRunClass * klass,
                      gpointer klass_data)
{
	first_run_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FirstRun_private_offset);
	G_OBJECT_CLASS (klass)->constructor = first_run_constructor;
	G_OBJECT_CLASS (klass)->finalize = first_run_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/first-run-adw.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button", FALSE, FirstRun_private_offset + G_STRUCT_OFFSET (FirstRunPrivate, button));
}

static void
first_run_instance_init (FirstRun * self,
                         gpointer klass)
{
	self->priv = first_run_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
first_run_finalize (GObject * obj)
{
	FirstRun * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FIRST_RUN, FirstRun);
	G_OBJECT_CLASS (first_run_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
first_run_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FirstRunClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) first_run_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FirstRun), 0, (GInstanceInitFunc) first_run_instance_init, NULL };
	GType first_run_type_id;
	first_run_type_id = g_type_register_static (gtk_box_get_type (), "FirstRun", &g_define_type_info, 0);
	FirstRun_private_offset = g_type_add_instance_private (first_run_type_id, sizeof (FirstRunPrivate));
	return first_run_type_id;
}

GType
first_run_get_type (void)
{
	static gsize first_run_type_id__once = 0;
	if (g_once_init_enter (&first_run_type_id__once)) {
		GType first_run_type_id;
		first_run_type_id = first_run_get_type_once ();
		g_once_init_leave (&first_run_type_id__once, first_run_type_id);
	}
	return first_run_type_id__once;
}

