/* history.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from history.vala, do not modify */

/* SPDX-FileCopyrightText: 2010-2025 Mahjongg Contributors*/
/* SPDX-FileCopyrightText: 2010-2013 Robert Ancell*/
/* SPDX-License-Identifier: GPL-2.0-or-later*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define HISTORY_TYPE_ITERATOR (history_iterator_get_type ())
#define HISTORY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HISTORY_TYPE_ITERATOR, HistoryIterator))
#define HISTORY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HISTORY_TYPE_ITERATOR, HistoryIteratorClass))
#define HISTORY_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HISTORY_TYPE_ITERATOR))
#define HISTORY_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HISTORY_TYPE_ITERATOR))
#define HISTORY_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HISTORY_TYPE_ITERATOR, HistoryIteratorClass))

typedef struct _HistoryIterator HistoryIterator;
typedef struct _HistoryIteratorClass HistoryIteratorClass;
typedef struct _HistoryIteratorPrivate HistoryIteratorPrivate;
#define _history_unref0(var) ((var == NULL) ? NULL : (var = (history_unref (var), NULL)))
typedef struct _HistoryParamSpecIterator HistoryParamSpecIterator;
typedef struct _ParamSpecHistory ParamSpecHistory;
enum  {
	HISTORY_ENTRY_0_PROPERTY,
	HISTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* history_entry_properties[HISTORY_ENTRY_NUM_PROPERTIES];

struct _History {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryPrivate * priv;
	gchar* filename;
};

struct _HistoryClass {
	GTypeClass parent_class;
	void (*finalize) (History *self);
};

struct _HistoryPrivate {
	HistoryEntry** entries;
	gint entries_length1;
	gint _entries_size_;
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	gchar* name;
	guint duration;
	gchar* player;
	guint rank;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

struct _HistoryIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HistoryIteratorPrivate * priv;
};

struct _HistoryIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (HistoryIterator *self);
};

struct _HistoryIteratorPrivate {
	gint index;
	History* history;
};

struct _HistoryParamSpecIterator {
	GParamSpec parent_instance;
};

struct _ParamSpecHistory {
	GParamSpec parent_instance;
};

static gint History_private_offset;
static gpointer history_parent_class = NULL;
static gint HistoryIterator_private_offset;
static gpointer history_iterator_parent_class = NULL;
static gpointer history_entry_parent_class = NULL;

VALA_EXTERN gpointer history_ref (gpointer instance);
VALA_EXTERN void history_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_history (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_history (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_history (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_history (const GValue* value);
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, history_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
VALA_EXTERN void history_load (History* self);
VALA_EXTERN HistoryEntry* history_entry_new (GDateTime* date,
                                 const gchar* name,
                                 guint duration,
                                 const gchar* player);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       GDateTime* date,
                                       const gchar* name,
                                       guint duration,
                                       const gchar* player);
static void _vala_array_add12 (HistoryEntry** * array,
                        gint* length,
                        gint* size,
                        HistoryEntry* value);
VALA_EXTERN void history_save (History* self);
VALA_EXTERN HistoryEntry* history_add (History* self,
                           GDateTime* date,
                           const gchar* name,
                           guint duration,
                           const gchar* player);
static void _vala_array_add13 (HistoryEntry** * array,
                        gint* length,
                        gint* size,
                        HistoryEntry* value);
VALA_EXTERN void history_clear (History* self);
VALA_EXTERN gpointer history_iterator_ref (gpointer instance);
VALA_EXTERN void history_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* history_param_spec_iterator (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void history_value_set_iterator (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void history_value_take_iterator (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer history_value_get_iterator (const GValue* value);
VALA_EXTERN GType history_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryIterator, history_iterator_unref)
VALA_EXTERN HistoryIterator* history_iterator (History* self);
VALA_EXTERN HistoryIterator* history_iterator_new (History* history);
VALA_EXTERN HistoryIterator* history_iterator_construct (GType object_type,
                                             History* history);
VALA_EXTERN gint history_get_length (History* self);
VALA_EXTERN gboolean history_iterator_next (HistoryIterator* self);
VALA_EXTERN HistoryEntry* history_iterator_get (HistoryIterator* self);
static void history_iterator_finalize (HistoryIterator * obj);
static GType history_iterator_get_type_once (void);
static void history_finalize (History * obj);
static GType history_get_type_once (void);
static void history_entry_finalize (GObject * obj);
static GType history_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
history_get_instance_private (History* self)
{
	return G_STRUCT_MEMBER_P (self, History_private_offset);
}

History*
history_construct (GType object_type,
                   const gchar* filename)
{
	History* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (History*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->filename);
	self->filename = _tmp0_;
	return self;
}

History*
history_new (const gchar* filename)
{
	return history_construct (TYPE_HISTORY, filename);
}

static void
_vala_array_add12 (HistoryEntry** * array,
                   gint* length,
                   gint* size,
                   HistoryEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (HistoryEntry*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
history_load (History* self)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->filename;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("history.vala:24: Failed to load history: %s", _tmp5_);
		}
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = contents;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp8_;
		line_collection_length1 = _vala_array_length (_tmp7_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			const gchar* line = NULL;
			line = line_collection[line_it];
			{
				gchar** tokens = NULL;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gchar** _tmp11_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				GDateTime* date = NULL;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				GDateTime* _tmp15_;
				GDateTime* _tmp16_;
				gchar* name = NULL;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gint duration = 0;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				gchar* player = NULL;
				gchar** _tmp22_;
				gint _tmp22__length1;
				GDateTime* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				HistoryEntry* _tmp31_;
				_tmp9_ = line;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 4);
				tokens = _tmp11_;
				tokens_length1 = _vala_array_length (_tmp10_);
				_tokens_size_ = tokens_length1;
				_tmp12_ = tokens;
				_tmp12__length1 = tokens_length1;
				if (_tmp12__length1 < 3) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp13_ = tokens;
				_tmp13__length1 = tokens_length1;
				_tmp14_ = _tmp13_[0];
				_tmp15_ = g_date_time_new_from_iso8601 (_tmp14_, NULL);
				date = _tmp15_;
				_tmp16_ = date;
				if (_tmp16_ == NULL) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp17_ = tokens;
				_tmp17__length1 = tokens_length1;
				_tmp18_ = _tmp17_[1];
				_tmp19_ = g_strdup (_tmp18_);
				name = _tmp19_;
				_tmp20_ = tokens;
				_tmp20__length1 = tokens_length1;
				_tmp21_ = _tmp20_[2];
				duration = atoi (_tmp21_);
				_tmp22_ = tokens;
				_tmp22__length1 = tokens_length1;
				if (_tmp22__length1 >= 4) {
					gchar** _tmp23_;
					gint _tmp23__length1;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp23_ = tokens;
					_tmp23__length1 = tokens_length1;
					_tmp24_ = _tmp23_[3];
					_tmp25_ = g_strdup (_tmp24_);
					_g_free0 (player);
					player = _tmp25_;
				} else {
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tmp26_ = g_get_real_name ();
					_tmp27_ = g_strdup (_tmp26_);
					_g_free0 (player);
					player = _tmp27_;
				}
				_tmp28_ = date;
				_tmp29_ = name;
				_tmp30_ = player;
				_tmp31_ = history_entry_new (_tmp28_, _tmp29_, (guint) duration, _tmp30_);
				_vala_array_add12 (&self->priv->entries, &self->priv->entries_length1, &self->priv->_entries_size_, _tmp31_);
				_g_free0 (player);
				_g_free0 (name);
				_g_date_time_unref0 (date);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (contents);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
history_save (History* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	HistoryEntry** _tmp1_;
	gint _tmp1__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->entries;
	_tmp1__length1 = self->priv->entries_length1;
	{
		HistoryEntry** entry_collection = NULL;
		gint entry_collection_length1 = 0;
		gint _entry_collection_size_ = 0;
		gint entry_it = 0;
		entry_collection = _tmp1_;
		entry_collection_length1 = _tmp1__length1;
		for (entry_it = 0; entry_it < entry_collection_length1; entry_it = entry_it + 1) {
			HistoryEntry* entry = NULL;
			entry = entry_collection[entry_it];
			{
				gchar* line = NULL;
				HistoryEntry* _tmp2_;
				GDateTime* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				HistoryEntry* _tmp6_;
				const gchar* _tmp7_;
				HistoryEntry* _tmp8_;
				HistoryEntry* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GString* _tmp13_;
				const gchar* _tmp14_;
				_tmp2_ = entry;
				_tmp3_ = _tmp2_->date;
				_tmp4_ = g_date_time_to_string (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = entry;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = entry;
				_tmp9_ = entry;
				_tmp10_ = _tmp9_->player;
				_tmp11_ = g_strdup_printf ("%s %s %u %s\n", _tmp5_, _tmp7_, _tmp8_->duration, _tmp10_);
				_tmp12_ = _tmp11_;
				_g_free0 (_tmp5_);
				line = _tmp12_;
				_tmp13_ = builder;
				_tmp14_ = line;
				g_string_append (_tmp13_, _tmp14_);
				_g_free0 (line);
			}
		}
	}
	{
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		GString* _tmp19_;
		const gchar* _tmp20_;
		_tmp15_ = self->filename;
		_tmp16_ = g_path_get_dirname (_tmp15_);
		_tmp17_ = _tmp16_;
		g_mkdir_with_parents (_tmp17_, 0775);
		_g_free0 (_tmp17_);
		_tmp18_ = self->filename;
		_tmp19_ = builder;
		_tmp20_ = _tmp19_->str;
		g_file_set_contents (_tmp18_, _tmp20_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_string_free0 (builder);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("history.vala:60: Failed to save history: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_string_free0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_string_free0 (builder);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add13 (HistoryEntry** * array,
                   gint* length,
                   gint* size,
                   HistoryEntry* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (HistoryEntry*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

HistoryEntry*
history_add (History* self,
             GDateTime* date,
             const gchar* name,
             guint duration,
             const gchar* player)
{
	HistoryEntry* entry = NULL;
	HistoryEntry* _tmp0_;
	HistoryEntry* _tmp1_;
	HistoryEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	_tmp0_ = history_entry_new (date, name, duration, player);
	entry = _tmp0_;
	_tmp1_ = _g_object_ref0 (entry);
	_vala_array_add13 (&self->priv->entries, &self->priv->entries_length1, &self->priv->_entries_size_, _tmp1_);
	history_save (self);
	result = entry;
	return result;
}

void
history_clear (History* self)
{
	g_return_if_fail (self != NULL);
	self->priv->entries = (_vala_array_free (self->priv->entries, self->priv->entries_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->entries = NULL;
	self->priv->entries_length1 = 0;
	self->priv->_entries_size_ = self->priv->entries_length1;
	history_save (self);
}

HistoryIterator*
history_iterator (History* self)
{
	HistoryIterator* _tmp0_;
	HistoryIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = history_iterator_new (self);
	result = _tmp0_;
	return result;
}

gint
history_get_length (History* self)
{
	gint result;
	HistoryEntry** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->entries;
	_tmp0__length1 = self->priv->entries_length1;
	result = _tmp0__length1;
	return result;
}

static inline gpointer
history_iterator_get_instance_private (HistoryIterator* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryIterator_private_offset);
}

static gpointer
_history_ref0 (gpointer self)
{
	return self ? history_ref (self) : NULL;
}

HistoryIterator*
history_iterator_construct (GType object_type,
                            History* history)
{
	HistoryIterator* self = NULL;
	History* _tmp0_;
	g_return_val_if_fail (history != NULL, NULL);
	self = (HistoryIterator*) g_type_create_instance (object_type);
	_tmp0_ = _history_ref0 (history);
	_history_unref0 (self->priv->history);
	self->priv->history = _tmp0_;
	return self;
}

HistoryIterator*
history_iterator_new (History* history)
{
	return history_iterator_construct (HISTORY_TYPE_ITERATOR, history);
}

gboolean
history_iterator_next (HistoryIterator* self)
{
	History* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->history;
	_tmp1_ = history_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = self->priv->index < _tmp2_;
	return result;
}

HistoryEntry*
history_iterator_get (HistoryIterator* self)
{
	History* _tmp0_;
	HistoryEntry** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	HistoryEntry* _tmp3_;
	HistoryEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->history;
	_tmp1_ = _tmp0_->priv->entries;
	_tmp1__length1 = _tmp0_->priv->entries_length1;
	_tmp2_ = self->priv->index;
	self->priv->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}

static void
history_value_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
history_value_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		history_iterator_unref (value->data[0].v_pointer);
	}
}

static void
history_value_iterator_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
history_value_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
history_value_iterator_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HistoryIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
history_value_iterator_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	HistoryIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
history_param_spec_iterator (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	HistoryParamSpecIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, HISTORY_TYPE_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
history_value_get_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HISTORY_TYPE_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

void
history_value_set_iterator (GValue* value,
                            gpointer v_object)
{
	HistoryIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HISTORY_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, HISTORY_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_iterator_unref (old);
	}
}

void
history_value_take_iterator (GValue* value,
                             gpointer v_object)
{
	HistoryIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HISTORY_TYPE_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, HISTORY_TYPE_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_iterator_unref (old);
	}
}

static void
history_iterator_class_init (HistoryIteratorClass * klass,
                             gpointer klass_data)
{
	history_iterator_parent_class = g_type_class_peek_parent (klass);
	((HistoryIteratorClass *) klass)->finalize = history_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &HistoryIterator_private_offset);
}

static void
history_iterator_instance_init (HistoryIterator * self,
                                gpointer klass)
{
	self->priv = history_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
history_iterator_finalize (HistoryIterator * obj)
{
	HistoryIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, HISTORY_TYPE_ITERATOR, HistoryIterator);
	g_signal_handlers_destroy (self);
	_history_unref0 (self->priv->history);
}

static GType
history_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { history_value_iterator_init, history_value_iterator_free_value, history_value_iterator_copy_value, history_value_iterator_peek_pointer, "p", history_value_iterator_collect_value, "p", history_value_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HistoryIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryIterator), 0, (GInstanceInitFunc) history_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType history_iterator_type_id;
	history_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HistoryIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	HistoryIterator_private_offset = g_type_add_instance_private (history_iterator_type_id, sizeof (HistoryIteratorPrivate));
	return history_iterator_type_id;
}

GType
history_iterator_get_type (void)
{
	static volatile gsize history_iterator_type_id__once = 0;
	if (g_once_init_enter (&history_iterator_type_id__once)) {
		GType history_iterator_type_id;
		history_iterator_type_id = history_iterator_get_type_once ();
		g_once_init_leave (&history_iterator_type_id__once, history_iterator_type_id);
	}
	return history_iterator_type_id__once;
}

gpointer
history_iterator_ref (gpointer instance)
{
	HistoryIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
history_iterator_unref (gpointer instance)
{
	HistoryIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_history_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_history_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		history_unref (value->data[0].v_pointer);
	}
}

static void
value_history_copy_value (const GValue* src_value,
                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = history_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_history_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_history_collect_value (GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		History * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = history_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_history_lcopy_value (const GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
	History ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = history_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_history (const gchar* name,
                    const gchar* nick,
                    const gchar* blurb,
                    GType object_type,
                    GParamFlags flags)
{
	ParamSpecHistory* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HISTORY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_history (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY), NULL);
	return value->data[0].v_pointer;
}

void
value_set_history (GValue* value,
                   gpointer v_object)
{
	History * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		history_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}

void
value_take_history (GValue* value,
                    gpointer v_object)
{
	History * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HISTORY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HISTORY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		history_unref (old);
	}
}

static void
history_class_init (HistoryClass * klass,
                    gpointer klass_data)
{
	history_parent_class = g_type_class_peek_parent (klass);
	((HistoryClass *) klass)->finalize = history_finalize;
	g_type_class_adjust_private_offset (klass, &History_private_offset);
}

static void
history_instance_init (History * self,
                       gpointer klass)
{
	self->priv = history_get_instance_private (self);
	self->ref_count = 1;
}

static void
history_finalize (History * obj)
{
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY, History);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filename);
	self->priv->entries = (_vala_array_free (self->priv->entries, self->priv->entries_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GType
history_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_history_init, value_history_free_value, value_history_copy_value, value_history_peek_pointer, "p", value_history_collect_value, "p", value_history_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType history_type_id;
	history_type_id = g_type_register_fundamental (g_type_fundamental_next (), "History", &g_define_type_info, &g_define_type_fundamental_info, 0);
	History_private_offset = g_type_add_instance_private (history_type_id, sizeof (HistoryPrivate));
	return history_type_id;
}

GType
history_get_type (void)
{
	static volatile gsize history_type_id__once = 0;
	if (g_once_init_enter (&history_type_id__once)) {
		GType history_type_id;
		history_type_id = history_get_type_once ();
		g_once_init_leave (&history_type_id__once, history_type_id);
	}
	return history_type_id__once;
}

gpointer
history_ref (gpointer instance)
{
	History * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
history_unref (gpointer instance)
{
	History * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HISTORY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

HistoryEntry*
history_entry_construct (GType object_type,
                         GDateTime* date,
                         const gchar* name,
                         guint duration,
                         const gchar* player)
{
	HistoryEntry * self = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	self = (HistoryEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_date_time_ref0 (date);
	_g_date_time_unref0 (self->date);
	self->date = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	self->duration = duration;
	_tmp2_ = g_strdup (player);
	_g_free0 (self->player);
	self->player = _tmp2_;
	return self;
}

HistoryEntry*
history_entry_new (GDateTime* date,
                   const gchar* name,
                   guint duration,
                   const gchar* player)
{
	return history_entry_construct (TYPE_HISTORY_ENTRY, date, name, duration, player);
}

static void
history_entry_class_init (HistoryEntryClass * klass,
                          gpointer klass_data)
{
	history_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = history_entry_finalize;
}

static void
history_entry_instance_init (HistoryEntry * self,
                             gpointer klass)
{
}

static void
history_entry_finalize (GObject * obj)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_date_time_unref0 (self->date);
	_g_free0 (self->name);
	_g_free0 (self->player);
	G_OBJECT_CLASS (history_entry_parent_class)->finalize (obj);
}

static GType
history_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, NULL };
	GType history_entry_type_id;
	history_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "HistoryEntry", &g_define_type_info, 0);
	return history_entry_type_id;
}

GType
history_entry_get_type (void)
{
	static volatile gsize history_entry_type_id__once = 0;
	if (g_once_init_enter (&history_entry_type_id__once)) {
		GType history_entry_type_id;
		history_entry_type_id = history_entry_get_type_once ();
		g_once_init_leave (&history_entry_type_id__once, history_entry_type_id);
	}
	return history_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

