/* unt-provider.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from unt-provider.vala, do not modify */

#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	UN_CURRENCY_PROVIDER_0_PROPERTY,
	UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY,
	UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY,
	UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY,
	UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY,
	UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY,
	UN_CURRENCY_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* un_currency_provider_properties[UN_CURRENCY_PROVIDER_NUM_PROPERTIES];
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static gpointer un_currency_provider_parent_class = NULL;

static GDateTime* un_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                                 const gchar* date);
static gboolean un_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base);
static GType un_currency_provider_get_type_once (void);
static void _vala_un_currency_provider_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GDateTime*
un_currency_provider_real_parse_date (AbstractCurrencyProvider* base,
                                      const gchar* date)
{
	UnCurrencyProvider * self;
	gchar** array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint array_length1;
	gint _array_size_;
	gint year = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gint month = 0;
	gint day = 0;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	GTimeZone* _tmp12_;
	GTimeZone* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* result;
	self = (UnCurrencyProvider*) base;
	if (date == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = _tmp0_ = g_strsplit (date, " ", 0);
	array = _tmp1_;
	array_length1 = _vala_array_length (_tmp0_);
	_array_size_ = array_length1;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	_tmp3_ = _tmp2_[2];
	year = atoi (_tmp3_);
	month = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar** _tmp6_;
				gint _tmp6__length1;
				const gchar* _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				const gchar* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp6_ = ((AbstractCurrencyProvider*) self)->MONTHS_ABBREVIATED;
				_tmp6__length1 = ((AbstractCurrencyProvider*) self)->MONTHS_ABBREVIATED_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = array;
				_tmp8__length1 = array_length1;
				_tmp9_ = _tmp8_[1];
				if (g_strcmp0 (_tmp7_, _tmp9_) == 0) {
					month = i + 1;
					break;
				}
			}
		}
	}
	_tmp10_ = array;
	_tmp10__length1 = array_length1;
	_tmp11_ = _tmp10_[0];
	day = atoi (_tmp11_);
	_tmp12_ = g_time_zone_new_local ();
	_tmp13_ = _tmp12_;
	_tmp14_ = g_date_time_new (_tmp13_, year, month, day, 0, 0, (gdouble) 0);
	_tmp15_ = _tmp14_;
	_g_time_zone_unref0 (_tmp13_);
	result = _tmp15_;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gboolean
un_currency_provider_real_do_load_rates (AbstractCurrencyProvider* base)
{
	UnCurrencyProvider * self;
	Currency* usd_currency = NULL;
	Currency* _tmp0_;
	Currency* _tmp1_;
	gchar* data = NULL;
	gchar** lines = NULL;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint lines_length1;
	gint _lines_size_;
	gboolean in_data = FALSE;
	Number* usd_rate = NULL;
	Currency* _tmp12_;
	Number* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = abstract_currency_provider_get_base_currency ((AbstractCurrencyProvider*) self);
	usd_currency = _tmp0_;
	_tmp1_ = usd_currency;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (usd_currency);
		return result;
	}
	{
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp2_ = abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error0_);
		_g_free0 (data);
		data = _tmp5_;
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("unt-provider.vala:46: Failed to read exchange rates: %s", _tmp7_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (data);
		_g_object_unref0 (usd_currency);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_free0 (data);
		_g_object_unref0 (usd_currency);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = data;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "\r\n", 0);
	lines = _tmp11_;
	lines_length1 = _vala_array_length (_tmp10_);
	_lines_size_ = lines_length1;
	in_data = FALSE;
	_tmp12_ = usd_currency;
	_tmp13_ = currency_get_value (_tmp12_);
	usd_rate = _tmp13_;
	_tmp14_ = lines;
	_tmp14__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp14_;
		line_collection_length1 = _tmp14__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp15_;
			gchar* line = NULL;
			_tmp15_ = g_strdup (line_collection[line_it]);
			line = _tmp15_;
			{
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar** tokens = NULL;
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_;
				gint tokens_length1;
				gint _tokens_size_;
				gint value_index = 0;
				gint date_index = 0;
				gint symbol_index = 0;
				gboolean _tmp22_ = FALSE;
				gchar** _tmp23_;
				gint _tmp23__length1;
				_tmp16_ = line;
				_tmp17_ = string_chug (_tmp16_);
				_g_free0 (line);
				line = _tmp17_;
				_tmp18_ = line;
				if (g_strcmp0 (_tmp18_, "") == 0) {
					if (!in_data) {
						in_data = TRUE;
						_g_free0 (line);
						continue;
					} else {
						_g_free0 (line);
						break;
					}
				}
				if (!in_data) {
					_g_free0 (line);
					continue;
				}
				_tmp19_ = line;
				_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "\t", 0);
				tokens = _tmp21_;
				tokens_length1 = _vala_array_length (_tmp20_);
				_tokens_size_ = tokens_length1;
				value_index = 4;
				date_index = 3;
				symbol_index = 2;
				_tmp23_ = tokens;
				_tmp23__length1 = tokens_length1;
				if (value_index <= _tmp23__length1) {
					gchar** _tmp24_;
					gint _tmp24__length1;
					_tmp24_ = tokens;
					_tmp24__length1 = tokens_length1;
					_tmp22_ = symbol_index <= _tmp24__length1;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					gchar* name = NULL;
					gchar** _tmp25_;
					gint _tmp25__length1;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* value = NULL;
					gchar** _tmp28_;
					gint _tmp28__length1;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					gboolean _tmp31_ = FALSE;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					const gchar* _tmp34_;
					_tmp25_ = tokens;
					_tmp25__length1 = tokens_length1;
					_tmp26_ = _tmp25_[symbol_index];
					_tmp27_ = g_strdup (_tmp26_);
					name = _tmp27_;
					_tmp28_ = tokens;
					_tmp28__length1 = tokens_length1;
					_tmp29_ = _tmp28_[value_index];
					_tmp30_ = string_chug (_tmp29_);
					value = _tmp30_;
					_tmp34_ = name;
					if (_tmp34_ != NULL) {
						const gchar* _tmp35_;
						_tmp35_ = value;
						_tmp33_ = _tmp35_ != NULL;
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						const gchar* _tmp36_;
						Currency* _tmp37_;
						Currency* _tmp38_;
						_tmp36_ = name;
						_tmp37_ = abstract_currency_provider_get_currency ((AbstractCurrencyProvider*) self, _tmp36_);
						_tmp38_ = _tmp37_;
						_tmp32_ = _tmp38_ == NULL;
						_g_object_unref0 (_tmp38_);
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						CurrencyManager* _tmp39_;
						CurrencyManager* _tmp40_;
						const gchar* _tmp41_;
						_tmp39_ = abstract_currency_provider_get_currency_manager ((AbstractCurrencyProvider*) self);
						_tmp40_ = _tmp39_;
						_tmp41_ = name;
						_tmp31_ = currency_manager_has_known_currency (_tmp40_, _tmp41_);
					} else {
						_tmp31_ = FALSE;
					}
					if (_tmp31_) {
						Number* r = NULL;
						const gchar* _tmp42_;
						Number* _tmp43_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						Number* v = NULL;
						Number* _tmp46_;
						Number* _tmp47_;
						Number* _tmp48_;
						Currency* c = NULL;
						const gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						Number* _tmp53_;
						gchar** _tmp54_;
						gint _tmp54__length1;
						const gchar* _tmp55_;
						Currency* _tmp56_;
						Currency* _tmp57_;
						_tmp42_ = value;
						_tmp43_ = mp_set_from_string (_tmp42_, 10, TRUE);
						r = _tmp43_;
						_tmp44_ = name;
						_tmp45_ = value;
						g_debug ("unt-provider.vala:83: Registering %s with value '%s'\r\n", _tmp44_, _tmp45_);
						_tmp46_ = usd_rate;
						_tmp47_ = r;
						_tmp48_ = number_multiply (_tmp46_, _tmp47_);
						v = _tmp48_;
						_tmp49_ = name;
						_tmp50_ = abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self);
						_tmp51_ = _tmp50_;
						_tmp52_ = _tmp51_;
						_tmp53_ = v;
						_tmp54_ = tokens;
						_tmp54__length1 = tokens_length1;
						_tmp55_ = _tmp54_[date_index];
						_tmp56_ = abstract_currency_provider_register_currency ((AbstractCurrencyProvider*) self, _tmp49_, _tmp52_, _tmp53_, _tmp55_);
						_tmp57_ = _tmp56_;
						_g_free0 (_tmp52_);
						c = _tmp57_;
						_g_object_unref0 (c);
						_g_object_unref0 (v);
						_g_object_unref0 (r);
					}
					_g_free0 (value);
					_g_free0 (name);
				}
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = ABSTRACT_CURRENCY_PROVIDER_CLASS (un_currency_provider_parent_class)->do_load_rates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ABSTRACT_CURRENCY_PROVIDER, AbstractCurrencyProvider));
	_g_object_unref0 (usd_rate);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data);
	_g_object_unref0 (usd_currency);
	return result;
}

UnCurrencyProvider*
un_currency_provider_construct (GType object_type,
                                CurrencyManager* _currency_manager)
{
	UnCurrencyProvider * self = NULL;
	g_return_val_if_fail (_currency_manager != NULL, NULL);
	self = (UnCurrencyProvider*) g_object_new (object_type, "currency-manager", _currency_manager, "base-currency-symbol", "USD", NULL);
	currency_manager_add_provider (_currency_manager, (CurrencyProvider*) self);
	return self;
}

UnCurrencyProvider*
un_currency_provider_new (CurrencyManager* _currency_manager)
{
	return un_currency_provider_construct (TYPE_UN_CURRENCY_PROVIDER, _currency_manager);
}

static gchar*
un_currency_provider_real_get_rate_filepath (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-calculator", "un-daily.xls", NULL);
	result = _tmp1_;
	return result;
}

static gchar*
un_currency_provider_real_get_rate_source_url (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://exchange-api.gnome.org/unt/un-daily.xls");
	result = _tmp0_;
	return result;
}

static gchar*
un_currency_provider_real_get_attribution_link (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("https://treasury.un.org/operationalrates/OperationalRates.php");
	result = _tmp0_;
	return result;
}

static const gchar*
un_currency_provider_real_get_provider_name (AbstractCurrencyProvider* base)
{
	const gchar* result;
	UnCurrencyProvider* self;
	self = (UnCurrencyProvider*) base;
	result = _ ("United Nations Treasury");
	return result;
}

static gchar*
un_currency_provider_real_get_source_name (AbstractCurrencyProvider* base)
{
	gchar* result;
	UnCurrencyProvider* self;
	gchar* _tmp0_;
	self = (UnCurrencyProvider*) base;
	_tmp0_ = g_strdup ("UNT");
	result = _tmp0_;
	return result;
}

static void
un_currency_provider_class_init (UnCurrencyProviderClass * klass,
                                 gpointer klass_data)
{
	un_currency_provider_parent_class = g_type_class_peek_parent (klass);
	((AbstractCurrencyProviderClass *) klass)->parse_date = (GDateTime* (*) (AbstractCurrencyProvider*, const gchar*)) un_currency_provider_real_parse_date;
	((AbstractCurrencyProviderClass *) klass)->do_load_rates = (gboolean (*) (AbstractCurrencyProvider*)) un_currency_provider_real_do_load_rates;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_filepath = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_rate_filepath;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_rate_source_url = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_rate_source_url;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_attribution_link = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_attribution_link;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_provider_name = (const gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_provider_name;
	ABSTRACT_CURRENCY_PROVIDER_CLASS (klass)->get_source_name = (gchar* (*) (AbstractCurrencyProvider*)) un_currency_provider_real_get_source_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_un_currency_provider_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY] = g_param_spec_string ("rate-filepath", "rate-filepath", "rate-filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY] = g_param_spec_string ("rate-source-url", "rate-source-url", "rate-source-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY] = g_param_spec_string ("attribution-link", "attribution-link", "attribution-link", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY] = g_param_spec_string ("provider-name", "provider-name", "provider-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY, un_currency_provider_properties[UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
un_currency_provider_instance_init (UnCurrencyProvider * self,
                                    gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
un_currency_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnCurrencyProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) un_currency_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnCurrencyProvider), 0, (GInstanceInitFunc) un_currency_provider_instance_init, NULL };
	GType un_currency_provider_type_id;
	un_currency_provider_type_id = g_type_register_static (TYPE_ABSTRACT_CURRENCY_PROVIDER, "UnCurrencyProvider", &g_define_type_info, 0);
	return un_currency_provider_type_id;
}

GType
un_currency_provider_get_type (void)
{
	static gsize un_currency_provider_type_id__once = 0;
	if (g_once_init_enter (&un_currency_provider_type_id__once)) {
		GType un_currency_provider_type_id;
		un_currency_provider_type_id = un_currency_provider_get_type_once ();
		g_once_init_leave (&un_currency_provider_type_id__once, un_currency_provider_type_id);
	}
	return un_currency_provider_type_id__once;
}

static void
_vala_un_currency_provider_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	UnCurrencyProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UN_CURRENCY_PROVIDER, UnCurrencyProvider);
	switch (property_id) {
		case UN_CURRENCY_PROVIDER_RATE_FILEPATH_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_filepath ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_RATE_SOURCE_URL_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_rate_source_url ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_ATTRIBUTION_LINK_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_attribution_link ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_PROVIDER_NAME_PROPERTY:
		g_value_set_string (value, abstract_currency_provider_get_provider_name ((AbstractCurrencyProvider*) self));
		break;
		case UN_CURRENCY_PROVIDER_SOURCE_NAME_PROPERTY:
		g_value_take_string (value, abstract_currency_provider_get_source_name ((AbstractCurrencyProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

