
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in TopoShapeSolidPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of TopoShapeSolidPy
PyTypeObject TopoShapeSolidPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.TopoShape",     /*tp_name*/
    sizeof(TopoShapeSolidPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Part.Solid(shape): Create a solid out of shells of shape. If shape is a compsolid, the overall volume solid is created.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::TopoShapeSolidPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::TopoShapeSolidPy::GetterSetter,                     /*tp_getset */
    &Part::TopoShapePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::TopoShapeSolidPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of TopoShapeSolidPy
PyMethodDef TopoShapeSolidPy::Methods[] = {
    {"getMomentOfInertia",
        reinterpret_cast<PyCFunction>( staticCallback_getMomentOfInertia ),
        METH_VARARGS,
        "computes the moment of inertia of the material system about the axis A.\n"
        "getMomentOfInertia(point,direction) -> Float"
    },
    {"getRadiusOfGyration",
        reinterpret_cast<PyCFunction>( staticCallback_getRadiusOfGyration ),
        METH_VARARGS,
        "Returns the radius of gyration of the current system about the axis A.\n"
        "getRadiusOfGyration(point,direction) -> Float"
    },
    {"offsetFaces",
        reinterpret_cast<PyCFunction>( staticCallback_offsetFaces ),
        METH_VARARGS,
        "Extrude single faces of the solid.\n"
        "offsetFaces(facesTuple, offset) -> Solid\n"
        "or\n"
        "offsetFaces(dict) -> Solid\n"
        "--\n"
        "Example:\n"
        "solid.offsetFaces((solid.Faces[0],solid.Faces[1]), 1.5)\n"
        "\n"
        "solid.offsetFaces({solid.Faces[0]:1.0,solid.Faces[1]:2.0})"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of TopoShapeSolidPy
PyGetSetDef TopoShapeSolidPy::GetterSetter[] = {
    {"Mass",
        (getter) staticCallback_getMass,
        (setter) staticCallback_setMass,
        "Returns the mass of the current system.",
        nullptr
    },
    {"CenterOfMass",
        (getter) staticCallback_getCenterOfMass,
        (setter) staticCallback_setCenterOfMass,
        "Returns the center of mass of the current system.\n"
        "If the gravitational field is uniform, it is the center of gravity.\n"
        "The coordinates returned for the center of mass are expressed in the\n"
        "absolute Cartesian coordinate system.",
        nullptr
    },
    {"MatrixOfInertia",
        (getter) staticCallback_getMatrixOfInertia,
        (setter) staticCallback_setMatrixOfInertia,
        "Returns the matrix of inertia. It is a symmetrical matrix.\n"
        "The coefficients of the matrix are the quadratic moments of\n"
        "inertia.\n"
        "\n"
        " | Ixx Ixy Ixz 0 |\n"
        " | Ixy Iyy Iyz 0 |\n"
        " | Ixz Iyz Izz 0 |\n"
        " | 0   0   0   1 |\n"
        "\n"
        "The moments of inertia are denoted by Ixx, Iyy, Izz.\n"
        "The products of inertia are denoted by Ixy, Ixz, Iyz.\n"
        "The matrix of inertia is returned in the central coordinate\n"
        "system (G, Gx, Gy, Gz) where G is the centre of mass of the\n"
        "system and Gx, Gy, Gz the directions parallel to the X(1,0,0)\n"
        "Y(0,1,0) Z(0,0,1) directions of the absolute cartesian\n"
        "coordinate system.",
        nullptr
    },
    {"StaticMoments",
        (getter) staticCallback_getStaticMoments,
        (setter) staticCallback_setStaticMoments,
        "Returns Ix, Iy, Iz, the static moments of inertia of the\n"
        " current system; i.e. the moments of inertia about the\n"
        " three axes of the Cartesian coordinate system.",
        nullptr
    },
    {"PrincipalProperties",
        (getter) staticCallback_getPrincipalProperties,
        (setter) staticCallback_setPrincipalProperties,
        "Computes the principal properties of inertia of the current system.\n"
        " There is always a set of axes for which the products\n"
        " of inertia of a geometric system are equal to 0; i.e. the\n"
        " matrix of inertia of the system is diagonal. These axes\n"
        " are the principal axes of inertia. Their origin is\n"
        " coincident with the center of mass of the system. The\n"
        " associated moments are called the principal moments of inertia.\n"
        " This function computes the eigen values and the\n"
        " eigen vectors of the matrix of inertia of the system.",
        nullptr
    },
    {"OuterShell",
        (getter) staticCallback_getOuterShell,
        (setter) staticCallback_setOuterShell,
        "Returns the outer most shell of this solid or an null\n"
        "shape if the solid has no shells",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// getMomentOfInertia() callback and implementer
// PyObject*  TopoShapeSolidPy::getMomentOfInertia(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getMomentOfInertia (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getMomentOfInertia' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeSolidPy*>(self)->getMomentOfInertia(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getRadiusOfGyration() callback and implementer
// PyObject*  TopoShapeSolidPy::getRadiusOfGyration(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getRadiusOfGyration (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getRadiusOfGyration' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeSolidPy*>(self)->getRadiusOfGyration(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// offsetFaces() callback and implementer
// PyObject*  TopoShapeSolidPy::offsetFaces(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_offsetFaces (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'offsetFaces' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeSolidPy*>(self)->offsetFaces(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Mass() callback and implementer
// PyObject*  TopoShapeSolidPy::Mass(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Mass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Mass' of object 'TopoShape' is read-only");
    return -1;
}

// CenterOfMass() callback and implementer
// PyObject*  TopoShapeSolidPy::CenterOfMass(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getCenterOfMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getCenterOfMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CenterOfMass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setCenterOfMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CenterOfMass' of object 'TopoShape' is read-only");
    return -1;
}

// MatrixOfInertia() callback and implementer
// PyObject*  TopoShapeSolidPy::MatrixOfInertia(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getMatrixOfInertia (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getMatrixOfInertia());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MatrixOfInertia' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setMatrixOfInertia (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MatrixOfInertia' of object 'TopoShape' is read-only");
    return -1;
}

// StaticMoments() callback and implementer
// PyObject*  TopoShapeSolidPy::StaticMoments(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getStaticMoments (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getStaticMoments());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'StaticMoments' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setStaticMoments (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'StaticMoments' of object 'TopoShape' is read-only");
    return -1;
}

// PrincipalProperties() callback and implementer
// PyObject*  TopoShapeSolidPy::PrincipalProperties(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getPrincipalProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getPrincipalProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PrincipalProperties' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setPrincipalProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PrincipalProperties' of object 'TopoShape' is read-only");
    return -1;
}

// OuterShell() callback and implementer
// PyObject*  TopoShapeSolidPy::OuterShell(PyObject *args){};
// has to be implemented in TopoShapeSolidPyImp.cpp
PyObject * TopoShapeSolidPy::staticCallback_getOuterShell (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeSolidPy*>(self)->getOuterShell());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OuterShell' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeSolidPy::staticCallback_setOuterShell (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OuterShell' of object 'TopoShape' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
TopoShapeSolidPy::TopoShapeSolidPy(TopoShape *pcObject, PyTypeObject *T)
    : TopoShapePy(static_cast<TopoShapePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
TopoShapeSolidPy::~TopoShapeSolidPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// TopoShapeSolidPy representation
//--------------------------------------------------------------------------
PyObject *TopoShapeSolidPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// TopoShapeSolidPy Attributes
//--------------------------------------------------------------------------
PyObject *TopoShapeSolidPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return TopoShapePy::_getattr(attr);
}

int TopoShapeSolidPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return TopoShapePy::_setattr(attr, value);
}

TopoShape *TopoShapeSolidPy::getTopoShapePtr() const
{
    return static_cast<TopoShape *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in TopoShapeSolidPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *TopoShapeSolidPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of TopoShapeSolidPy and the Twin object
    return new TopoShapeSolidPy(new TopoShape);
}

// constructor method
int TopoShapeSolidPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string TopoShapeSolidPy::representation() const
{
    return {"<TopoShape object>"};
}

PyObject* TopoShapeSolidPy::getMomentOfInertia(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeSolidPy::getRadiusOfGyration(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeSolidPy::offsetFaces(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Object TopoShapeSolidPy::getMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeSolidPy::getCenterOfMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeSolidPy::getMatrixOfInertia() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeSolidPy::getStaticMoments() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict TopoShapeSolidPy::getPrincipalProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeSolidPy::getOuterShell() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *TopoShapeSolidPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int TopoShapeSolidPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



