
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in HLRBRep_AlgoPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of HLRBRep_AlgoPy
PyTypeObject HLRBRep_AlgoPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.HLRBRep_Algo",     /*tp_name*/
    sizeof(HLRBRep_AlgoPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Algo() -> HLRBRep_Algo\n"
    "\n"
    "A framework to compute a shape as seen in a projection\n"
    "plane. This is done by calculating the visible and the hidden parts\n"
    "of the shape. HLRBRep_Algo works with three types of entity:\n"
    "\n"
    "- shapes to be visualized\n"
    "- edges in these shapes (these edges are the basic entities which will be\n"
    "  visualized or hidden), and\n"
    "- faces in these shapes which hide the edges.\n"
    "\n"
    "HLRBRep_Algo is based on the principle of comparing each edge of the shape to\n"
    "be visualized with each of its faces, and calculating the visible and the\n"
    "hidden parts of each edge. For a given projection, HLRBRep_Algo calculates a\n"
    "set of lines characteristic of the object being represented. It is also used in\n"
    "conjunction with the HLRBRep_HLRToShape extraction utilities, which reconstruct\n"
    "a new, simplified shape from a selection of calculation results. This new shape\n"
    "is made up of edges, which represent the shape visualized in the\n"
    "projection. HLRBRep_Algo takes the shape itself into account whereas\n"
    "HLRBRep_PolyAlgo works with a polyhedral simplification of the shape. When you\n"
    "use HLRBRep_Algo, you obtain an exact result, whereas, when you use\n"
    "HLRBRep_PolyAlgo, you reduce computation time but obtain polygonal segments. In\n"
    "the case of complicated shapes, HLRBRep_Algo may be time-consuming. An\n"
    "HLRBRep_Algo object provides a framework for:\n"
    "\n"
    "- defining the point of view\n"
    "- identifying the shape or shapes to be visualized\n"
    "- calculating the outlines\n"
    "- calculating the visible and hidden lines of the shape. Warning\n"
    "- Superimposed lines are not eliminated by this algorithm.\n"
    "- There must be no unfinished objects inside the shape you wish to visualize.\n"
    "- Points are not treated.\n"
    "- Note that this is not the sort of algorithm used in generating shading, which\n"
    "  calculates the visible and hidden parts of each face in a shape to be\n"
    "  visualized by comparing each face in the shape with every other face in the\n"
    "  same shape.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::HLRBRep_AlgoPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::HLRBRep_AlgoPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::HLRBRep_AlgoPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of HLRBRep_AlgoPy
PyMethodDef HLRBRep_AlgoPy::Methods[] = {
    {"add",
        reinterpret_cast<PyCFunction>( staticCallback_add ),
        METH_VARARGS,
        "add(S, nbIso=0)\n"
        "\n"
        "Adds the shape S to this framework, and specifies the number of isoparameters\n"
        "nbiso desired in visualizing S.  You may add as many shapes as you wish.  Use\n"
        "the function add once for each shape."
    },
    {"remove",
        reinterpret_cast<PyCFunction>( staticCallback_remove ),
        METH_VARARGS,
        "remove(i)\n"
        "\n"
        "Remove the shape of index i from this framework."
    },
    {"index",
        reinterpret_cast<PyCFunction>( staticCallback_index ),
        METH_VARARGS,
        "index(S) ->  int\n"
        "\n"
        "Return the index of the Shape S and return 0 if the Shape S is not found."
    },
    {"outLinedShapeNullify",
        reinterpret_cast<PyCFunction>( staticCallback_outLinedShapeNullify ),
        METH_VARARGS,
        "outlinedShapeNullify()\n"
        "\n"
        "Nullify all the results of OutLiner from HLRTopoBRep."
    },
    {"setProjector",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_setProjector )),
        METH_VARARGS|METH_KEYWORDS,
        "setProjector(Origin=(0, 0, 0), ZDir=(0,0,0), XDir=(0,0,0), focus=NaN)\n"
        "\n"
        "Set the projector.  With focus left to NaN, an axonometric projector is\n"
        "created.  Otherwise, a perspective projector is created with focus focus."
    },
    {"nbShapes",
        reinterpret_cast<PyCFunction>( staticCallback_nbShapes ),
        METH_VARARGS,
        "nbShapes()\n"
        "\n"
        "Returns the number of shapes in the collection.  It does not modify the\n"
        "object's state and is used to retrieve the count of shapes."
    },
    {"showAll",
        reinterpret_cast<PyCFunction>( staticCallback_showAll ),
        METH_VARARGS,
        "showAll(i=-1)\n"
        "\n"
        "If i < 1, then set all the edges to visible.\n"
        "Otherwise, set to visible all the edges of the shape of index i."
    },
    {"hide",
        reinterpret_cast<PyCFunction>( staticCallback_hide ),
        METH_VARARGS,
        "hide(i=-1, j=-1)\n"
        "\n"
        "If i < 1, hide all of the datastructure.\n"
        "Otherwise, if j < 1, hide the shape of index i.\n"
        "Otherwise, hide the shape of index i by the shape of index j."
    },
    {"hideAll",
        reinterpret_cast<PyCFunction>( staticCallback_hideAll ),
        METH_VARARGS,
        "hideAll(i=-1)\n"
        "\n"
        "If i < 1, hide all the edges.\n"
        "Otherwise, hide all the edges of shape of index i."
    },
    {"partialHide",
        reinterpret_cast<PyCFunction>( staticCallback_partialHide ),
        METH_VARARGS,
        "partialHide()\n"
        "\n"
        "Own hiding of all the shapes of the DataStructure without hiding by each other."
    },
    {"select",
        reinterpret_cast<PyCFunction>( staticCallback_select ),
        METH_VARARGS,
        "select(i=-1)\n"
        "\n"
        "If i < 1, select all the DataStructure.\n"
        "Otherwise, only select the shape of index i."
    },
    {"selectEdge",
        reinterpret_cast<PyCFunction>( staticCallback_selectEdge ),
        METH_VARARGS,
        "selectEdge(i)\n"
        "\n"
        "Select only the edges of the shape of index i."
    },
    {"selectFace",
        reinterpret_cast<PyCFunction>( staticCallback_selectFace ),
        METH_VARARGS,
        "selectFace(i)\n"
        "		\n"
        "Select only the faces of the shape of index i."
    },
    {"initEdgeStatus",
        reinterpret_cast<PyCFunction>( staticCallback_initEdgeStatus ),
        METH_VARARGS,
        "initEdgeStatus()\n"
        "\n"
        "Init the status of the selected edges depending of the back faces of a closed\n"
        "shell."
    },
    {"update",
        reinterpret_cast<PyCFunction>( staticCallback_update ),
        METH_VARARGS,
        "update()\n"
        "		\n"
        "Update the DataStructure."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of HLRBRep_AlgoPy
PyGetSetDef HLRBRep_AlgoPy::GetterSetter[] = {
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// add() callback and implementer
// PyObject*  HLRBRep_AlgoPy::add(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_add (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'add' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->add(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// remove() callback and implementer
// PyObject*  HLRBRep_AlgoPy::remove(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_remove (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'remove' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->remove(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// index() callback and implementer
// PyObject*  HLRBRep_AlgoPy::index(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_index (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'index' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->index(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// outLinedShapeNullify() callback and implementer
// PyObject*  HLRBRep_AlgoPy::outLinedShapeNullify(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_outLinedShapeNullify (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'outLinedShapeNullify' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->outLinedShapeNullify(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setProjector() callback and implementer
// PyObject*  HLRBRep_AlgoPy::setProjector(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_setProjector (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setProjector' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->setProjector(args, kwd);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nbShapes() callback and implementer
// PyObject*  HLRBRep_AlgoPy::nbShapes(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_nbShapes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nbShapes' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->nbShapes(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// showAll() callback and implementer
// PyObject*  HLRBRep_AlgoPy::showAll(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_showAll (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'showAll' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->showAll(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hide() callback and implementer
// PyObject*  HLRBRep_AlgoPy::hide(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_hide (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hide' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->hide(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hideAll() callback and implementer
// PyObject*  HLRBRep_AlgoPy::hideAll(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_hideAll (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hideAll' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->hideAll(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// partialHide() callback and implementer
// PyObject*  HLRBRep_AlgoPy::partialHide(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_partialHide (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'partialHide' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->partialHide(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// select() callback and implementer
// PyObject*  HLRBRep_AlgoPy::select(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_select (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'select' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->select(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// selectEdge() callback and implementer
// PyObject*  HLRBRep_AlgoPy::selectEdge(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_selectEdge (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'selectEdge' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->selectEdge(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// selectFace() callback and implementer
// PyObject*  HLRBRep_AlgoPy::selectFace(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_selectFace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'selectFace' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->selectFace(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// initEdgeStatus() callback and implementer
// PyObject*  HLRBRep_AlgoPy::initEdgeStatus(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_initEdgeStatus (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'initEdgeStatus' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->initEdgeStatus(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// update() callback and implementer
// PyObject*  HLRBRep_AlgoPy::update(PyObject *args){};
// has to be implemented in HLRBRep_AlgoPyImp.cpp
PyObject * HLRBRep_AlgoPy::staticCallback_update (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'update' of 'Part.HLRBRep_Algo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_AlgoPy*>(self)->update(args);
        if (ret != nullptr)
            static_cast<HLRBRep_AlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
HLRBRep_AlgoPy::HLRBRep_AlgoPy(HLRBRep_Algo *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
HLRBRep_AlgoPy::~HLRBRep_AlgoPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// HLRBRep_AlgoPy representation
//--------------------------------------------------------------------------
PyObject *HLRBRep_AlgoPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// HLRBRep_AlgoPy Attributes
//--------------------------------------------------------------------------
PyObject *HLRBRep_AlgoPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int HLRBRep_AlgoPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

HLRBRep_Algo *HLRBRep_AlgoPy::getHLRBRep_AlgoPtr() const
{
    return static_cast<HLRBRep_Algo *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in HLRBRep_AlgoPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *HLRBRep_AlgoPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of HLRBRep_AlgoPy and the Twin object
    return new HLRBRep_AlgoPy(new HLRBRep_Algo);
}

// constructor method
int HLRBRep_AlgoPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string HLRBRep_AlgoPy::representation() const
{
    return {"<HLRBRep_Algo object>"};
}

PyObject* HLRBRep_AlgoPy::add(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::remove(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::index(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::outLinedShapeNullify(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::setProjector(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::nbShapes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::showAll(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::hide(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::hideAll(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::partialHide(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::select(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::selectEdge(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::selectFace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::initEdgeStatus(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_AlgoPy::update(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



PyObject *HLRBRep_AlgoPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int HLRBRep_AlgoPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



