const char FreeCADGuiInit[] ="#***************************************************************************\n"
"#*   Copyright (c) 2002,2003 Jürgen Riegel <juergen.riegel@web.de>         *\n"
"#*                                                                         *\n"
"#*   This file is part of the FreeCAD CAx development system.              *\n"
"#*                                                                         *\n"
"#*   This program is free software; you can redistribute it and/or modify  *\n"
"#*   it under the terms of the GNU Lesser General Public License (LGPL)    *\n"
"#*   as published by the Free Software Foundation; either version 2 of     *\n"
"#*   the License, or (at your option) any later version.                   *\n"
"#*   for detail see the LICENCE text file.                                 *\n"
"#*                                                                         *\n"
"#*   FreeCAD is distributed in the hope that it will be useful,            *\n"
"#*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
"#*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
"#*   GNU Lesser General Public License for more details.                   *\n"
"#*                                                                         *\n"
"#*   You should have received a copy of the GNU Library General Public     *\n"
"#*   License along with FreeCAD; if not, write to the Free Software        *\n"
"#*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *\n"
"#*   USA                                                                   *\n"
"#*                                                                         *\n"
"#***************************************************************************/\n"
"\n"
"# FreeCAD gui init module\n"
"#\n"
"# Gathering all the information to start FreeCAD\n"
"# This is the second one of three init scripts, the third one\n"
"# runs when the gui is up\n"
"\n"
"# imports the one and only\n"
"import FreeCAD, FreeCADGui\n"
"from enum import IntEnum\n"
"\n"
"# shortcuts\n"
"Gui = FreeCADGui\n"
"\n"
"# this is to keep old code working\n"
"Gui.listCommands = Gui.Command.listAll\n"
"Gui.isCommandActive = lambda cmd: Gui.Command.get(cmd).isActive()\n"
"\n"
"# The values must match with that of the C++ enum class ResolveMode\n"
"class ResolveMode(IntEnum):\n"
"    NoResolve = 0\n"
"    OldStyleElement = 1\n"
"    NewStyleElement = 2\n"
"    FollowLink = 3\n"
"\n"
"Gui.Selection.ResolveMode = ResolveMode\n"
"\n"
"# The values must match with that of the C++ enum class SelectionStyle\n"
"class SelectionStyle(IntEnum):\n"
"    NormalSelection = 0\n"
"    GreedySelection = 1\n"
"\n"
"Gui.Selection.SelectionStyle = SelectionStyle\n"
"\n"
"# Important definitions\n"
"class Workbench:\n"
"    \"\"\"The workbench base class.\"\"\"\n"
"    MenuText = \"\"\n"
"    ToolTip = \"\"\n"
"    Icon = None\n"
"\n"
"    def Initialize(self):\n"
"        \"\"\"Initializes this workbench.\"\"\"\n"
"        App.Console.PrintWarning(str(self) + \": Workbench.Initialize() not implemented in subclass!\")\n"
"    def ContextMenu(self, recipient):\n"
"        pass\n"
"    def appendToolbar(self,name,cmds):\n"
"        self.__Workbench__.appendToolbar(name, cmds)\n"
"    def removeToolbar(self,name):\n"
"        self.__Workbench__.removeToolbar(name)\n"
"    def listToolbars(self):\n"
"        return self.__Workbench__.listToolbars()\n"
"    def getToolbarItems(self):\n"
"        return self.__Workbench__.getToolbarItems()\n"
"    def appendCommandbar(self,name,cmds):\n"
"        self.__Workbench__.appendCommandbar(name, cmds)\n"
"    def removeCommandbar(self,name):\n"
"        self.__Workbench__.removeCommandbar(name)\n"
"    def listCommandbars(self):\n"
"        return self.__Workbench__.listCommandbars()\n"
"    def appendMenu(self,name,cmds):\n"
"        self.__Workbench__.appendMenu(name, cmds)\n"
"    def removeMenu(self,name):\n"
"        self.__Workbench__.removeMenu(name)\n"
"    def listMenus(self):\n"
"        return self.__Workbench__.listMenus()\n"
"    def appendContextMenu(self,name,cmds):\n"
"        self.__Workbench__.appendContextMenu(name, cmds)\n"
"    def removeContextMenu(self,name):\n"
"        self.__Workbench__.removeContextMenu(name)\n"
"    def reloadActive(self):\n"
"        self.__Workbench__.reloadActive()\n"
"    def name(self):\n"
"        return self.__Workbench__.name()\n"
"    def GetClassName(self):\n"
"        \"\"\"Return the name of the associated C++ class.\"\"\"\n"
"        # as default use this to simplify writing workbenches in Python\n"
"        return \"Gui::PythonWorkbench\"\n"
"\n"
"\n"
"class StandardWorkbench ( Workbench ):\n"
"    \"\"\"A workbench defines the tool bars, command bars, menus,\n"
"context menu and dockable windows of the main window.\n"
"    \"\"\"\n"
"    def Initialize(self):\n"
"        \"\"\"Initialize this workbench.\"\"\"\n"
"        # load the module\n"
"        Log (\'Init: Loading FreeCAD GUI\\n\')\n"
"    def GetClassName(self):\n"
"        \"\"\"Return the name of the associated C++ class.\"\"\"\n"
"        return \"Gui::StdWorkbench\"\n"
"\n"
"class NoneWorkbench ( Workbench ):\n"
"    \"\"\"An empty workbench.\"\"\"\n"
"    MenuText = \"<none>\"\n"
"    ToolTip = \"The default empty workbench\"\n"
"    def Initialize(self):\n"
"        \"\"\"Initialize this workbench.\"\"\"\n"
"        # load the module\n"
"        Log (\'Init: Loading FreeCAD GUI\\n\')\n"
"    def GetClassName(self):\n"
"        \"\"\"Return the name of the associated C++ class.\"\"\"\n"
"        return \"Gui::NoneWorkbench\"\n"
"\n"
"def InitApplications():\n"
"    import sys,os,traceback\n"
"    import io as cStringIO\n"
"\n"
"    # Searching modules dirs +++++++++++++++++++++++++++++++++++++++++++++++++++\n"
"    # (additional module paths are already cached)\n"
"    ModDirs = FreeCAD.__ModDirs__\n"
"    #print ModDirs\n"
"    Log(\'Init:   Searching modules...\\n\')\n"
"\n"
"    def RunInitGuiPy(Dir) -> bool:\n"
"        InstallFile = os.path.join(Dir,\"InitGui.py\")\n"
"        if os.path.exists(InstallFile):\n"
"            try:\n"
"                with open(InstallFile, \'rt\', encoding=\'utf-8\') as f:\n"
"                    exec(compile(f.read(), InstallFile, \'exec\'))\n"
"            except Exception as inst:\n"
"                Log(\'Init:      Initializing \' + Dir + \'... failed\\n\')\n"
"                Log(\'-\'*100+\'\\n\')\n"
"                Log(traceback.format_exc())\n"
"                Log(\'-\'*100+\'\\n\')\n"
"                Err(\'During initialization the error \"\' + str(inst) + \'\" occurred in \'\\\n"
"                    + InstallFile + \'\\n\')\n"
"                Err(\'Please look into the log file for further information\\n\')\n"
"            else:\n"
"                Log(\'Init:      Initializing \' + Dir + \'... done\\n\')\n"
"                return True\n"
"        else:\n"
"            Log(\'Init:      Initializing \' + Dir + \'(InitGui.py not found)... ignore\\n\')\n"
"        return False\n"
"\n"
"    def processMetadataFile(Dir, MetadataFile):\n"
"        meta = FreeCAD.Metadata(MetadataFile)\n"
"        if not meta.supportsCurrentFreeCAD():\n"
"            return None\n"
"        content = meta.Content\n"
"        if \"workbench\" in content:\n"
"            FreeCAD.Gui.addIconPath(Dir)\n"
"            workbenches = content[\"workbench\"]\n"
"            for workbench_metadata in workbenches:\n"
"                if not workbench_metadata.supportsCurrentFreeCAD():\n"
"                    return None\n"
"                subdirectory = workbench_metadata.Name\\\n"
"                    if not workbench_metadata.Subdirectory\\\n"
"                    else workbench_metadata.Subdirectory\n"
"                subdirectory = subdirectory.replace(\"/\",os.path.sep)\n"
"                subdirectory = os.path.join(Dir, subdirectory)\n"
"                ran_init = RunInitGuiPy(subdirectory)\n"
"\n"
"                if ran_init:\n"
"                    # Try to generate a new icon from the metadata-specified information\n"
"                    classname = workbench_metadata.Classname\n"
"                    if classname:\n"
"                        try:\n"
"                            wb_handle = FreeCAD.Gui.getWorkbench(classname)\n"
"                        except Exception:\n"
"                            Log(f\"Failed to get handle to {classname} -- no icon\\\n"
"                                can be generated,\\n check classname in package.xml\\n\")\n"
"                        else:\n"
"                            GeneratePackageIcon(dir, subdirectory, workbench_metadata,\n"
"                                                wb_handle)\n"
"\n"
"    def tryProcessMetadataFile(Dir, MetadataFile):\n"
"        try:\n"
"            processMetadataFile(Dir, MetadataFile)\n"
"        except Exception as exc:\n"
"            Err(str(exc))\n"
"\n"
"    for Dir in ModDirs:\n"
"        if (Dir != \'\') & (Dir != \'CVS\') & (Dir != \'__init__.py\'):\n"
"            stopFile = os.path.join(Dir, \"ADDON_DISABLED\")\n"
"            if os.path.exists(stopFile):\n"
"                Msg(f\'NOTICE: Addon \"{Dir}\" disabled by presence of ADDON_DISABLED stopfile\\n\')\n"
"                continue\n"
"            MetadataFile = os.path.join(Dir, \"package.xml\")\n"
"            if os.path.exists(MetadataFile):\n"
"                tryProcessMetadataFile(Dir, MetadataFile)\n"
"            else:\n"
"                RunInitGuiPy(Dir)\n"
"    Log(\"All modules with GUIs using InitGui.py are now initialized\\n\")\n"
"\n"
"    try:\n"
"        import pkgutil\n"
"        import importlib\n"
"        import freecad\n"
"        freecad.gui = FreeCADGui\n"
"        for _, freecad_module_name,\\\n"
"            freecad_module_ispkg in pkgutil.iter_modules(freecad.__path__, \"freecad.\"):\n"
"            # Check for a stopfile\n"
"            stopFile = os.path.join(FreeCAD.getUserAppDataDir(), \"Mod\",\n"
"                                    freecad_module_name[8:], \"ADDON_DISABLED\")\n"
"            if os.path.exists(stopFile):\n"
"                continue\n"
"\n"
"            # Make sure that package.xml (if present) does not exclude this version of FreeCAD\n"
"            MetadataFile = os.path.join(FreeCAD.getUserAppDataDir(), \"Mod\",\n"
"                                        freecad_module_name[8:], \"package.xml\")\n"
"            if os.path.exists(MetadataFile):\n"
"                meta = FreeCAD.Metadata(MetadataFile)\n"
"                if not meta.supportsCurrentFreeCAD():\n"
"                    continue\n"
"\n"
"            if freecad_module_ispkg:\n"
"                Log(\'Init: Initializing \' + freecad_module_name + \'\\n\')\n"
"                try:\n"
"                    freecad_module = importlib.import_module(freecad_module_name)\n"
"                    if any (module_name == \'init_gui\' for _, module_name,\n"
"                            ispkg in pkgutil.iter_modules(freecad_module.__path__)):\n"
"                        importlib.import_module(freecad_module_name + \'.init_gui\')\n"
"                        Log(\'Init: Initializing \' + freecad_module_name + \'... done\\n\')\n"
"                    else:\n"
"                        Log(\'Init: No init_gui module found in \' + freecad_module_name\\\n"
"                            + \', skipping\\n\')\n"
"                except Exception as inst:\n"
"                    Err(\'During initialization the error \"\' + str(inst) + \'\" occurred in \'\\\n"
"                        + freecad_module_name + \'\\n\')\n"
"                    Err(\'-\'*80+\'\\n\')\n"
"                    Err(traceback.format_exc())\n"
"                    Err(\'-\'*80+\'\\n\')\n"
"                    Log(\'Init:      Initializing \' + freecad_module_name + \'... failed\\n\')\n"
"                    Log(\'-\'*80+\'\\n\')\n"
"                    Log(traceback.format_exc())\n"
"                    Log(\'-\'*80+\'\\n\')\n"
"    except ImportError as inst:\n"
"        Err(\'During initialization the error \"\' + str(inst) + \'\" occurred\\n\')\n"
"\n"
"    Log(\"All modules with GUIs initialized using pkgutil are now initialized\\n\")\n"
"\n"
"def GeneratePackageIcon(dir:str, subdirectory:str, workbench_metadata:FreeCAD.Metadata,\n"
"                        wb_handle:Workbench) -> None:\n"
"    relative_filename = workbench_metadata.Icon\n"
"    if not relative_filename:\n"
"        # Although a required element, this content item does not have an icon. Just bail out\n"
"        return\n"
"    absolute_filename = os.path.join(subdirectory, relative_filename)\n"
"    if hasattr(wb_handle, \"Icon\") and wb_handle.Icon:\n"
"        Log(f\"Init:      Packaged workbench {workbench_metadata.Name} specified icon\\\n"
"            in class {workbench_metadata.Classname}\")\n"
"        Log(f\" ... replacing with icon from package.xml data.\\n\")\n"
"    wb_handle.__dict__[\"Icon\"] = absolute_filename\n"
"\n"
"\n"
"Log (\'Init: Running FreeCADGuiInit.py start script...\\n\')\n"
"\n"
"\n"
"\n"
"# init the gui\n"
"\n"
"# signal that the gui is up\n"
"App.GuiUp = 1\n"
"App.Gui = FreeCADGui\n"
"FreeCADGui.Workbench = Workbench\n"
"\n"
"Gui.addWorkbench(NoneWorkbench())\n"
"\n"
"# init modules\n"
"InitApplications()\n"
"\n"
"# set standard workbench (needed as fallback)\n"
"Gui.activateWorkbench(\"NoneWorkbench\")\n"
"\n"
"# Register .py, .FCScript and .FCMacro\n"
"FreeCAD.addImportType(\"Inventor V2.1 (*.iv *.IV)\",\"FreeCADGui\")\n"
"FreeCAD.addImportType(\"VRML V2.0 (*.wrl *.WRL *.vrml *.VRML *.wrz *.WRZ *.wrl.gz *.WRL.GZ)\",\"FreeCADGui\")\n"
"FreeCAD.addImportType(\"Python (*.py *.FCMacro *.FCScript *.fcmacro *.fcscript)\",\"FreeCADGui\")\n"
"FreeCAD.addExportType(\"Inventor V2.1 (*.iv)\",\"FreeCADGui\")\n"
"FreeCAD.addExportType(\"VRML V2.0 (*.wrl *.vrml *.wrz *.wrl.gz)\",\"FreeCADGui\")\n"
"FreeCAD.addExportType(\"X3D Extensible 3D (*.x3d *.x3dz)\",\"FreeCADGui\")\n"
"FreeCAD.addExportType(\"WebGL/X3D (*.xhtml)\",\"FreeCADGui\")\n"
"#FreeCAD.addExportType(\"IDTF (for 3D PDF) (*.idtf)\",\"FreeCADGui\")\n"
"#FreeCAD.addExportType(\"3D View (*.svg)\",\"FreeCADGui\")\n"
"FreeCAD.addExportType(\"Portable Document Format (*.pdf)\",\"FreeCADGui\")\n"
"\n"
"del InitApplications\n"
"del NoneWorkbench\n"
"del StandardWorkbench\n"
"\n"
"Log (\'Init: Running FreeCADGuiInit.py start script... done\\n\')\n"
;


