/*
 * Copyright (c) 2019, Alliance for Open Media. All rights reserved.
 *
 * This source code is subject to the terms of the BSD 2 Clause License and
 * the Alliance for Open Media Patent License 1.0. If the BSD 2 Clause License
 * was not distributed with this source code in the LICENSE file, you can
 * obtain it at www.aomedia.org/license/software. If the Alliance for Open
 * Media Patent License 1.0 was not distributed with this source code in the
 * PATENTS file, you can obtain it at www.aomedia.org/license/patent.
 */

#ifndef AOM_AV1_ENCODER_MISC_MODEL_WEIGHTS_H_
#define AOM_AV1_ENCODER_MISC_MODEL_WEIGHTS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "av1/encoder/ml.h"

#define MV_PREC_FEATURE_SIZE 18

#define NUM_DNN_LAYERS 1
#define NUM_DNN_FEATURES MV_PREC_FEATURE_SIZE
#define MV_PREC_LAYER_SIZE_0 32
#define NUM_LOGITS 1

static const float av1_mv_prec_mean[MV_PREC_FEATURE_SIZE] = {
  143.67358891063745f,
  141.6251917346238f,
  0.36313633945679064f,
  0.0028162791958822085f,
  0.000484820537626698f,
  0.002769969388939025f,
  0.0f,
  0.00031274626720947577f,
  0.00020578555375160075f,
  0.0007075246732697733f,
  0.000539641029909925f,
  0.0013939401375906984f,
  4.985394760423499f,
  4.985394760423499f,
  4.9992148717283085f,
  5.143739822380163f,
  5.518483124004564f,
  87.63597847427077f
};

static const float av1_mv_prec_std[MV_PREC_FEATURE_SIZE] = {
  66.86256140247244f,
  68.04472572607503f,
  13.23247674430399f,
  0.0029123438396921955f,
  0.0015331406169374737f,
  0.0029149813096313775f,
  1.0f,
  0.00047501102871357813f,
  0.00030025962993117947f,
  0.0009861163580391207f,
  0.0012157593528004055f,
  0.002004954948490521f,
  6.539447500484038f,
  6.539447500484038f,
  6.396589058279465f,
  3.4870155874262516f,
  3.8911353973740535f,
  112.07985259573601f
};

static const float av1_mv_prec_nn_weights_layer_0[] = { -0.13008492159557145f,
                                                        -0.1483527373474774f,
                                                        0.08112076098858864f,
                                                        -0.9582568679627453f,
                                                        -0.34794757171071206f,
                                                        0.6465225723304947f,
                                                        0.0f,
                                                        0.06754171885839604f,
                                                        0.27156803620541214f,
                                                        0.10635231245664407f,
                                                        -0.031183926995968583f,
                                                        0.048122572260291f,
                                                        -0.19498534230045128f,
                                                        -0.2614116319273316f,
                                                        -0.3223762845136331f,
                                                        -1.2063368350609205f,
                                                        -0.523333556911706f,
                                                        1.075632260890728f,
                                                        0.48989726814387946f,
                                                        -0.34816466111070477f,
                                                        0.41668357610256473f,
                                                        -1.0973562848791671f,
                                                        0.04183921854389494f,
                                                        -0.9123815389260476f,
                                                        0.0f,
                                                        0.859965047744027f,
                                                        0.1962095804679813f,
                                                        0.2606564339077058f,
                                                        0.26695868715184895f,
                                                        0.5319308568326692f,
                                                        -0.23717505799723165f,
                                                        -0.43127224481782567f,
                                                        -0.3214545776203726f,
                                                        0.5850852241402176f,
                                                        -0.26705531612587813f,
                                                        -0.5786016766610093f,
                                                        0.9360519909983003f,
                                                        0.20771329289016555f,
                                                        -0.027614159544811823f,
                                                        -1.175022807046164f,
                                                        -0.07578967497693835f,
                                                        0.6890172485324256f,
                                                        0.0f,
                                                        -0.008008338164988263f,
                                                        -0.08064800010158935f,
                                                        -0.22606910981666667f,
                                                        0.4541586669210879f,
                                                        0.07731527661370792f,
                                                        -0.6744475941247964f,
                                                        -0.2625842448396184f,
                                                        1.7018613444303785f,
                                                        -0.08622229073162656f,
                                                        0.041858142814941275f,
                                                        -0.24575964090386415f,
                                                        -0.046626044730994964f,
                                                        0.7608713064175202f,
                                                        -0.23330119070907146f,
                                                        -0.10115510984500826f,
                                                        0.9722537349192069f,
                                                        0.11718554254290829f,
                                                        0.0f,
                                                        0.2075123446014759f,
                                                        0.09465167310768637f,
                                                        0.7609896851963016f,
                                                        0.4441038581385328f,
                                                        0.26064144727430955f,
                                                        -0.14678625366485035f,
                                                        -0.03597014452200524f,
                                                        0.3128680867196166f,
                                                        1.102496797385966f,
                                                        0.06642253233084111f,
                                                        -1.2665494483407629f,
                                                        0.09049412632000911f,
                                                        -1.1160621999565095f,
                                                        0.043420275255913035f,
                                                        -0.8811412259978966f,
                                                        0.21076234632287777f,
                                                        0.16571534463543866f,
                                                        0.0f,
                                                        -0.7324075176473275f,
                                                        -0.3677622514459495f,
                                                        0.3273532243056415f,
                                                        0.22922161936797775f,
                                                        0.8204766691058087f,
                                                        0.02982161033720488f,
                                                        0.5266419954188112f,
                                                        -1.0032154963302191f,
                                                        0.7007602969763729f,
                                                        0.37196355167990885f,
                                                        -0.7608579453228548f,
                                                        0.08568111584781847f,
                                                        0.07011061059123677f,
                                                        0.3233263598082507f,
                                                        -0.08249928295410253f,
                                                        0.08220165761319252f,
                                                        0.22148722752246794f,
                                                        0.0f,
                                                        0.6122392701743506f,
                                                        -0.26429838296378333f,
                                                        0.31958081620005463f,
                                                        -0.006027177397853826f,
                                                        -0.3088310785887994f,
                                                        -0.5436192046707807f,
                                                        -0.011080356757423306f,
                                                        0.12632650770008413f,
                                                        -0.45097913215234525f,
                                                        1.8008072867127298f,
                                                        -0.7630029654575501f,
                                                        -0.4054774329826579f,
                                                        0.40386074452544535f,
                                                        -0.18541426257453025f,
                                                        0.2444879765079863f,
                                                        -0.6216724756115081f,
                                                        0.27030299321302f,
                                                        0.0f,
                                                        -0.6835848952967989f,
                                                        -0.7914184320964815f,
                                                        -0.6761595019582928f,
                                                        -1.009565565604081f,
                                                        -0.1904242439353305f,
                                                        0.4463417126318631f,
                                                        0.6025503823452971f,
                                                        0.5149990860115566f,
                                                        1.0242970663937634f,
                                                        0.037947306826401385f,
                                                        0.07039339786212848f,
                                                        0.14273796789711987f,
                                                        0.168103961425691f,
                                                        1.6596066376811978f,
                                                        0.19321092229384657f,
                                                        -0.3710750388148514f,
                                                        -0.01717015559410288f,
                                                        0.0f,
                                                        0.3005688477942597f,
                                                        0.23877080653829577f,
                                                        0.2718594552971173f,
                                                        0.3885402571589898f,
                                                        0.32999531945669247f,
                                                        -0.6134460954213243f,
                                                        -0.13972265462799183f,
                                                        -0.07180089575716991f,
                                                        -1.014572598188105f,
                                                        0.0717207322809836f,
                                                        0.34896157745155615f,
                                                        -0.27127687591403f,
                                                        -0.5058651212773623f,
                                                        -1.5442435628306925f,
                                                        -0.6399784724734707f,
                                                        0.6274301429074947f,
                                                        -0.4645750072767051f,
                                                        0.0f,
                                                        -0.2406726815244178f,
                                                        -0.06321214115916597f,
                                                        0.312856714253404f,
                                                        0.16459514124116134f,
                                                        0.3993579604809623f,
                                                        -0.15232044351561913f,
                                                        -0.5613743948568469f,
                                                        0.7219801372223262f,
                                                        0.2936857469624009f,
                                                        0.7823466656034087f,
                                                        -0.12416947814098349f,
                                                        -0.36413756654028345f,
                                                        -0.07992098796866462f,
                                                        -0.7395722879842416f,
                                                        0.8639913543220514f,
                                                        -0.311931773757945f,
                                                        -1.7308240470400613f,
                                                        0.0f,
                                                        0.394499716712104f,
                                                        0.6511462819539963f,
                                                        -0.0722425275974144f,
                                                        0.13490818194661386f,
                                                        0.055319135836378035f,
                                                        0.15389577508097013f,
                                                        0.28958598328870605f,
                                                        -0.14608429470539772f,
                                                        0.09488817462478298f,
                                                        -0.17231294096622088f,
                                                        0.6721115415911466f,
                                                        -0.05664621150536103f,
                                                        0.03291799673669331f,
                                                        0.02845382711057482f,
                                                        -0.9953563446999164f,
                                                        -0.17994298220605923f,
                                                        0.6560824519337476f,
                                                        0.0f,
                                                        -0.30990646375917935f,
                                                        0.17215517202874f,
                                                        0.2026816225170481f,
                                                        0.22011958747715601f,
                                                        0.3562520768889686f,
                                                        -0.18436559057189175f,
                                                        0.1733377147302066f,
                                                        0.02818276995640877f,
                                                        -0.29703005574859076f,
                                                        -0.3310652639215064f,
                                                        -1.6091173258529277f,
                                                        0.45461585790028003f,
                                                        -0.5078643334592593f,
                                                        -0.338997374732338f,
                                                        0.4688619590359733f,
                                                        0.627099126828289f,
                                                        -0.5249801376494249f,
                                                        0.0f,
                                                        0.34465498218272883f,
                                                        0.009891680630908135f,
                                                        -0.27244020967349f,
                                                        0.05404589867626979f,
                                                        -0.06220329325739666f,
                                                        -0.13365376464759104f,
                                                        -0.13098573553512366f,
                                                        0.11434198976289106f,
                                                        0.6740951247574676f,
                                                        1.3381727185724581f,
                                                        -1.4865773213251936f,
                                                        0.05809898701966341f,
                                                        0.25380780261023456f,
                                                        1.2716367496512722f,
                                                        0.1768290070780598f,
                                                        -0.07554828135356352f,
                                                        0.8180570085344856f,
                                                        0.0f,
                                                        1.0788448980077463f,
                                                        0.0651938742459459f,
                                                        0.3807672030015587f,
                                                        0.6144792680268445f,
                                                        0.011660612214908059f,
                                                        -0.018306023765580288f,
                                                        0.44140813809926516f,
                                                        -0.13411994195502386f,
                                                        0.15920368955127778f,
                                                        -0.19382358417849888f,
                                                        -0.08802147969690055f,
                                                        -0.019731052733814477f,
                                                        0.1104744229169665f,
                                                        -0.195834419735958f,
                                                        -0.5005295046454347f,
                                                        -0.17041241868229032f,
                                                        -0.471942117351489f,
                                                        0.0f,
                                                        -0.3599073304761372f,
                                                        -0.2745532782968519f,
                                                        -0.8323064841106417f,
                                                        -0.88355885384943f,
                                                        -0.02826466859020679f,
                                                        0.06977870308805256f,
                                                        0.11926112095374196f,
                                                        1.367382707959643f,
                                                        -0.06119843162964051f,
                                                        -0.5331395268889569f,
                                                        -1.2155531584240624f,
                                                        -0.01896651779524327f,
                                                        0.10591845408571081f,
                                                        -0.010632842156504733f,
                                                        0.6150787968629282f,
                                                        -0.4191690185896091f,
                                                        -0.9961718918346271f,
                                                        0.0f,
                                                        0.23370364516013867f,
                                                        0.4156033072362998f,
                                                        0.1261005546633433f,
                                                        0.0812413884532226f,
                                                        -0.008894337353937203f,
                                                        0.07984447025056046f,
                                                        -0.1258098052766725f,
                                                        -0.40245475467767916f,
                                                        1.78188906675019f,
                                                        -1.1544387954232302f,
                                                        -0.41768781481273387f,
                                                        0.6791211165341995f,
                                                        -0.4175127856183446f,
                                                        -0.07353219159767788f,
                                                        -0.2888813577574072f,
                                                        -0.7107767892597061f,
                                                        -1.0450031091195449f,
                                                        0.0f,
                                                        -0.9221599545079143f,
                                                        -0.6747876356740621f,
                                                        0.30241454354872105f,
                                                        0.4924965303373908f,
                                                        -0.14042722740054084f,
                                                        0.27744210409350445f,
                                                        -0.14788270997426836f,
                                                        -0.9081467469237995f,
                                                        -0.04513115674995093f,
                                                        -0.5254168669125793f,
                                                        -0.6999012037974789f,
                                                        0.434661246306547f,
                                                        -0.7193303957246092f,
                                                        -0.9117952623409744f,
                                                        -1.5097267865916142f,
                                                        -0.20779888103770922f,
                                                        0.4935562480901218f,
                                                        0.0f,
                                                        0.18303393908923593f,
                                                        0.34753722677570037f,
                                                        0.29291001533177663f,
                                                        0.3832351878354224f,
                                                        0.3295194956120599f,
                                                        -0.32398033003617527f,
                                                        -0.31570906736433746f,
                                                        0.23657779050372962f,
                                                        0.9510794465234161f,
                                                        -0.5122243902568278f,
                                                        0.08652112725315658f,
                                                        0.2246634353717998f,
                                                        -0.9032595595582497f,
                                                        -0.8936484034533545f,
                                                        0.6012969720865752f,
                                                        -0.6454216646117924f,
                                                        -1.1753786049658332f,
                                                        0.0f,
                                                        -0.4360545677728656f,
                                                        -0.6586237455328507f,
                                                        -0.34347301697886656f,
                                                        -0.8909724651992144f,
                                                        -0.24378721818350263f,
                                                        0.6179733359297576f,
                                                        0.0661661181742234f,
                                                        -0.14120142044993794f,
                                                        -0.07732699885498932f,
                                                        1.0221355882357506f,
                                                        0.44514798994115284f,
                                                        -0.7371569579959046f,
                                                        -0.7212499572378936f,
                                                        0.7453626921081045f,
                                                        0.5478757761345768f,
                                                        -0.39411232789985384f,
                                                        0.7200542656743857f,
                                                        0.0f,
                                                        -0.11790869453118827f,
                                                        -0.12317030713581928f,
                                                        -0.4207902738133338f,
                                                        0.15895105878327986f,
                                                        0.304261777102111f,
                                                        0.11450744587017621f,
                                                        -0.11470709991317944f,
                                                        0.5949222371739038f,
                                                        0.6549518619412444f,
                                                        -0.24390606570422838f,
                                                        -0.4212796009440803f,
                                                        -0.6269666206320964f,
                                                        -0.5421193969807078f,
                                                        -0.12297772128652287f,
                                                        0.021517257619930424f,
                                                        0.25462855095544523f,
                                                        -0.22107798187348246f,
                                                        0.0f,
                                                        0.5204516300095662f,
                                                        0.2837402841862462f,
                                                        0.11310823283285916f,
                                                        0.8944351685018025f,
                                                        0.17487203235834015f,
                                                        -0.5271221928634433f,
                                                        -0.19516594503423199f,
                                                        0.452456617580365f,
                                                        1.2456272242706414f,
                                                        0.24166615894862817f,
                                                        0.09411429305204502f,
                                                        -0.2730072283327243f,
                                                        -0.8129383770918172f,
                                                        -0.24093254193486136f,
                                                        0.5696499174142177f,
                                                        -0.11110805836073044f,
                                                        -0.3968204166235694f,
                                                        0.0f,
                                                        -0.04388165369378549f,
                                                        -0.005631266017272595f,
                                                        -0.02574211858479705f,
                                                        0.06230399626660669f,
                                                        0.17677671232932785f,
                                                        0.5172871274400965f,
                                                        0.4919150085620063f,
                                                        -1.597656637582941f,
                                                        0.02415185715719143f,
                                                        -0.17945446376668306f,
                                                        -0.39340600199798886f,
                                                        0.25013205256886845f,
                                                        0.05972330340308685f,
                                                        0.1359911505596489f,
                                                        -0.02341033271820833f,
                                                        0.15726074644063684f,
                                                        0.47512625913020357f,
                                                        0.0f,
                                                        0.7327341664835779f,
                                                        -0.3689092312320013f,
                                                        0.4571824787436036f,
                                                        0.6215465537945456f,
                                                        0.0944111296842023f,
                                                        -0.12571956176607574f,
                                                        -0.2507235674395462f,
                                                        -0.09579602654351593f,
                                                        1.4463357293728496f,
                                                        0.749153535856049f,
                                                        -0.5553955120807588f,
                                                        -0.09622771929369946f,
                                                        -0.2598697420394813f,
                                                        -0.964691815299676f,
                                                        -0.8289963178173902f,
                                                        0.7112949291983329f,
                                                        -0.8667009730492162f,
                                                        0.0f,
                                                        -0.48698304169042794f,
                                                        -0.18786095669893707f,
                                                        -0.11425249263203247f,
                                                        -0.3693391011684809f,
                                                        0.09933145842585253f,
                                                        0.2568559685298844f,
                                                        0.7048512233651738f,
                                                        0.6056238412407038f,
                                                        -0.4355558119826642f,
                                                        0.17318931883915484f,
                                                        0.6481333496429564f,
                                                        -0.45728823054344486f,
                                                        -0.006325004538589701f,
                                                        0.45609864075494927f,
                                                        -0.6199385981116988f,
                                                        0.035105808783046165f,
                                                        0.1203147963894839f,
                                                        0.0f,
                                                        0.383402190836527f,
                                                        0.048429009055370106f,
                                                        0.5887186439275204f,
                                                        -0.20538767641607814f,
                                                        -0.031237879611002117f,
                                                        0.3140759860883231f,
                                                        0.24447070584999556f,
                                                        0.7271263905705878f,
                                                        0.8432799162434237f,
                                                        -0.11530577554199217f,
                                                        -0.7781023892314718f,
                                                        0.05359488822710336f,
                                                        0.5624870388700809f,
                                                        0.5134656523208906f,
                                                        0.18304041423438375f,
                                                        -0.04237421156328257f,
                                                        -0.20759809886942207f,
                                                        0.0f,
                                                        -0.06249337454975615f,
                                                        0.10081284533873777f,
                                                        0.3894374350259183f,
                                                        1.518217777528342f,
                                                        -0.9100037950171563f,
                                                        0.17796906121831477f,
                                                        -0.2892167255357892f,
                                                        0.6117902467884032f,
                                                        0.13332120964959573f,
                                                        -0.3487155932849374f,
                                                        -0.32920583745734694f,
                                                        0.08242631209809854f,
                                                        -0.24920225708110588f,
                                                        0.8401757259392635f,
                                                        0.11729108681358365f,
                                                        0.11222925752499184f,
                                                        -0.027078490721459958f,
                                                        0.0f,
                                                        0.726132375517389f,
                                                        0.72220359881096f,
                                                        0.5721582611845177f,
                                                        0.15139162075524315f,
                                                        0.6676549461551197f,
                                                        -0.321449586554697f,
                                                        -0.10141104515219895f,
                                                        -0.09711123988777906f,
                                                        0.9623356184776928f,
                                                        -0.7941822373167173f,
                                                        -0.9373923554119346f,
                                                        0.4573241832354059f,
                                                        -0.42029139056126147f,
                                                        0.2675223459380999f,
                                                        -0.5487300191551386f,
                                                        0.2236621891916084f,
                                                        0.11692039230044018f,
                                                        0.0f,
                                                        0.1758399202780961f,
                                                        0.676447587678781f,
                                                        0.5945412815881029f,
                                                        0.5669863357359594f,
                                                        0.8433565415303922f,
                                                        -0.30300550790708036f,
                                                        -0.43332881999693673f,
                                                        -0.4996522695731392f,
                                                        -0.2084930815451962f,
                                                        0.27765278702463786f,
                                                        1.0886848763946915f,
                                                        -0.0739433655813831f,
                                                        -0.4762801579229192f,
                                                        -0.2490825339320731f,
                                                        -1.8820479350439439f,
                                                        -0.4251592225775914f,
                                                        -0.3992922365484464f,
                                                        0.0f,
                                                        0.19598917760218867f,
                                                        0.4860238022746914f,
                                                        0.3364528828641281f,
                                                        0.3350950865226741f,
                                                        0.2773654548632006f,
                                                        -0.30547262140782566f,
                                                        0.028649620490728344f,
                                                        -0.11763407628280315f,
                                                        0.6237318502627169f,
                                                        -0.3958952632477945f,
                                                        0.14797171297835243f,
                                                        0.45821729624747465f,
                                                        -0.8687137170773626f,
                                                        0.06989667196937126f,
                                                        -0.5752606929478727f,
                                                        0.16986945686358412f,
                                                        0.6925071596817824f,
                                                        0.0f,
                                                        0.4991250796183003f,
                                                        0.03424654896322111f,
                                                        0.6153698611882319f,
                                                        0.5070872444849457f,
                                                        0.43615747516328135f,
                                                        -0.7870352838659244f,
                                                        -0.6424101231965247f,
                                                        -0.7005774876651399f,
                                                        0.79983115431488f,
                                                        0.15720357955596242f,
                                                        -1.408372612176309f,
                                                        -0.039294695217213765f,
                                                        0.6979415372962309f,
                                                        0.27403316751965656f,
                                                        1.2844596102619275f,
                                                        -0.2781534150257364f,
                                                        0.3248437714908865f,
                                                        0.0f,
                                                        0.4364362371752831f,
                                                        -0.2548580911485434f,
                                                        -0.19578001373349452f,
                                                        -0.04597194387828005f,
                                                        -0.010035156855533233f,
                                                        0.0415941475251266f,
                                                        0.07929549739797387f,
                                                        -0.060629652912508866f,
                                                        0.5977303008711333f,
                                                        -1.4404008068066554f,
                                                        0.8555694790197376f,
                                                        -0.03693438534401856f,
                                                        0.17761411164512408f,
                                                        -0.11858304304109235f,
                                                        -1.4241324353471327f,
                                                        0.1533849765389186f,
                                                        0.7650643783126995f,
                                                        0.0f,
                                                        -0.0639949379280401f,
                                                        0.4288617817939563f,
                                                        0.4235508646885404f,
                                                        0.3419843254383798f,
                                                        -0.015992360660098768f,
                                                        -0.773247697505441f,
                                                        -0.4908452922015917f,
                                                        0.9868134897291486f,
                                                        -0.5078689994742608f,
                                                        1.05632043744864f,
                                                        -0.38867419409275117f,
                                                        -0.0065547696858664194f,
                                                        -0.3056003173415037f,
                                                        -0.333762331930102f,
                                                        0.4459671174011671f,
                                                        0.08219092584580244f,
                                                        -0.08099158579518179f,
                                                        0.0f,
                                                        -0.1568180656346373f,
                                                        -0.061962372393910135f,
                                                        0.14065868174859464f,
                                                        -0.055925712798972765f,
                                                        0.05136117465820622f,
                                                        0.0907831030477633f,
                                                        0.19518110495319604f,
                                                        -0.7470794578145956f,
                                                        1.5945999734733545f,
                                                        -0.4351697502345834f,
                                                        -0.33253649399571805f };

static const float av1_mv_prec_nn_bias_layer_0[] = {
  -0.651213833993862f,   -1.1243309933417809f,  -0.2123880023097051f,
  0.23095477452877616f,  -0.6668057665893545f,  0.3082268148379634f,
  -0.3344916753975844f,  -0.20920185606857844f, 0.6057933917964854f,
  0.5031857662559803f,   -1.5380096313468152f,  -0.4457245344804041f,
  1.82368055812373f,     0.7973912064077963f,   0.25706500555622913f,
  0.1394695119825382f,   0.4508811973450553f,   -0.5408959545111782f,
  1.064829233697863f,    0.3733268644246235f,   1.1173169029905483f,
  -0.2012817466400134f,  -0.16628447748302294f, 1.3086000088940826f,
  0.7267092979664235f,   -0.9097857006590555f,  -0.7564259343863077f,
  -0.49844128036716173f, -0.4675729246975423f,  -0.03626154526362181f,
  -0.41957330902404616f, -0.9658160514319954f
};

static const float av1_mv_prec_nn_weights_layer_1[] = {
  1.5017296484510276f,  1.044216918060133f,   -1.066541411740906f,
  -0.7762965171172661f, -0.9814396609661653f, 0.9334065847340715f,
  0.7117244268817873f,  -0.7695942296628597f, 0.7892157680137047f,
  -0.5786309358654476f, -2.4444494892027264f, 1.1666759262637185f,
  -0.9699580532370483f, 0.5849682956422552f,  -1.0372272986941953f,
  -0.5005014627824439f, 1.1816204711740521f,  -1.2204867615892114f,
  0.4510263977504913f,  0.35567865078585165f, -0.7811389330738839f,
  -0.6643977800301099f, -0.6283287371705794f, 0.790873821018048f,
  0.8861643352684585f,  0.6438840651522237f,  0.6677191546466089f,
  0.9703715021995785f,  1.250893534236489f,   0.7733742028067933f,
  -1.249673977776904f,  -1.2890127265725608f
};

static const float av1_mv_prec_nn_bias_layer_1[] = { -0.341771735378258f };

static const NN_CONFIG av1_mv_prec_dnn_config = {
  NUM_DNN_FEATURES,
  NUM_LOGITS,
  NUM_DNN_LAYERS,
  { MV_PREC_LAYER_SIZE_0 },
  {
      av1_mv_prec_nn_weights_layer_0,
      av1_mv_prec_nn_weights_layer_1,
  },
  {
      av1_mv_prec_nn_bias_layer_0,
      av1_mv_prec_nn_bias_layer_1,
  },
};
#undef NUM_DNN_LAYERS
#undef NUM_DNN_FEATURES
#undef NUM_LAYER_0_UNITS
#undef NUM_LOGITS

#ifdef __cplusplus
}  // extern "C"
#endif

#endif  // AOM_AV1_ENCODER_MISC_MODEL_WEIGHTS_H_
