struct ps_copy_common {
struct Samplers {
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 1:
   sColor0_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int a_src_rect = NULL_ATTRIB;
 int a_dst_rect = NULL_ATTRIB;
 int a_dst_texture_size = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("a_src_rect", name) == 0) { a_src_rect = index; return; }
  if (strcmp("a_dst_rect", name) == 0) { a_dst_rect = index; return; }
  if (strcmp("a_dst_texture_size", name) == 0) { a_dst_texture_size = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("a_src_rect", name) == 0) { return a_src_rect != NULL_ATTRIB ? a_src_rect : -1; }
  if (strcmp("a_dst_rect", name) == 0) { return a_dst_rect != NULL_ATTRIB ? a_dst_rect : -1; }
  if (strcmp("a_dst_texture_size", name) == 0) { return a_dst_texture_size != NULL_ATTRIB ? a_dst_texture_size : -1; }
  return -1;
 }
} attrib_locations;
sampler2D sColor0;
void bind_textures() {
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
}
};
struct ps_copy_vert : VertexShaderImpl, ps_copy_common {
private:
typedef ps_copy_vert Self;
vec2 aPosition;
vec4 a_src_rect;
vec4 a_dst_rect;
vec2 a_dst_texture_size;
vec2 v_uv;
ALWAYS_INLINE void main(void) {
 v_uv = mix((a_src_rect).sel(X,Y), (a_src_rect).sel(Z,W), (aPosition).sel(X,Y));
 vec2 pos = mix((a_dst_rect).sel(X,Y), (a_dst_rect).sel(Z,W), (aPosition).sel(X,Y));
 gl_Position = make_vec4(((pos)/((a_dst_texture_size)*(0.5f)))-(make_vec2(1.f, 1.f)), 0.f, 1.f);
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_attrib(self->a_src_rect, attribs[self->attrib_locations.a_src_rect], start, instance, count);
 load_attrib(self->a_dst_rect, attribs[self->attrib_locations.a_dst_rect], start, instance, count);
 load_attrib(self->a_dst_texture_size, attribs[self->attrib_locations.a_dst_texture_size], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar v_uv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->v_uv = get_nth(v_uv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
ps_copy_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct ps_copy_frag : FragmentShaderImpl, ps_copy_vert {
private:
typedef ps_copy_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
vec2 v_uv;
// sampler2D sColor0;
ALWAYS_INLINE void main(void) {
 oFragColor = texelFetch(sColor0, make_ivec2(v_uv), 0);
}
typedef ps_copy_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 v_uv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->v_uv = init_interp(init->v_uv, step->v_uv);
  self->interp_step.v_uv = step->v_uv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.v_uv = init_interp(init->v_uv, step->v_uv);
  self->v_uv = self->interp_perspective.v_uv * w;
  self->interp_step.v_uv = step->v_uv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  v_uv += interp_step.v_uv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.v_uv += interp_step.v_uv * chunks;
  v_uv = w * interp_perspective.v_uv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
ps_copy_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct ps_copy_program : ProgramImpl, ps_copy_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sColor0", name) == 0) { return 1; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "ps_copy"; }
static ProgramImpl* loader() { return new ps_copy_program; }
};

