struct cs_scale_TEXTURE_2D_common {
struct Samplers {
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 1:
   sColor0_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aScaleTargetRect = NULL_ATTRIB;
 int aScaleSourceRect = NULL_ATTRIB;
 int aSourceRectType = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aScaleTargetRect", name) == 0) { aScaleTargetRect = index; return; }
  if (strcmp("aScaleSourceRect", name) == 0) { aScaleSourceRect = index; return; }
  if (strcmp("aSourceRectType", name) == 0) { aSourceRectType = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aScaleTargetRect", name) == 0) { return aScaleTargetRect != NULL_ATTRIB ? aScaleTargetRect : -1; }
  if (strcmp("aScaleSourceRect", name) == 0) { return aScaleSourceRect != NULL_ATTRIB ? aScaleSourceRect : -1; }
  if (strcmp("aSourceRectType", name) == 0) { return aSourceRectType != NULL_ATTRIB ? aSourceRectType : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vUvRect;
sampler2D sColor0;
mat4_scalar uTransform;
void bind_textures() {
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
}
};
struct cs_scale_TEXTURE_2D_vert : VertexShaderImpl, cs_scale_TEXTURE_2D_common {
private:
typedef cs_scale_TEXTURE_2D_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
vec2 vUv;
// vec4_scalar vUvRect;
vec4_scalar aScaleTargetRect;
vec4_scalar aScaleSourceRect;
float aSourceRectType;
ALWAYS_INLINE void main(void) {
 vec2_scalar src_offset = (aScaleSourceRect).sel(X,Y);
 vec2_scalar src_size = ((aScaleSourceRect).sel(Z,W))-((aScaleSourceRect).sel(X,Y));
 vUvRect = make_vec4(min((aScaleSourceRect).sel(X,Y), (aScaleSourceRect).sel(Z,W)), max((aScaleSourceRect).sel(X,Y), (aScaleSourceRect).sel(Z,W)));
 vUv = (src_offset)+((src_size)*((aPosition).sel(X,Y)));
 if ((make_int(aSourceRectType))==(1)) {
  {
   vUvRect = make_vec4(((vUvRect).sel(X,Y))+(make_vec2(0.5f)), ((vUvRect).sel(Z,W))-(make_vec2(0.5f)));
   vec2_scalar texture_size = make_vec2(textureSize(sColor0, 0));
   vUvRect /= (texture_size).sel(X,Y,X,Y);
   vUv /= texture_size;
  }
 }
 vec2 pos = mix((aScaleTargetRect).sel(X,Y), (aScaleTargetRect).sel(Z,W), (aPosition).sel(X,Y));
 gl_Position = (uTransform)*(make_vec4(pos, 0.f, 1.f));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 case 2:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 case 2:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 1:
  assert(0); // sColor0
  break;
 case 2:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aScaleTargetRect, attribs[self->attrib_locations.aScaleTargetRect], start, instance, count);
 load_flat_attrib(self->aScaleSourceRect, attribs[self->attrib_locations.aScaleSourceRect], start, instance, count);
 load_flat_attrib(self->aSourceRectType, attribs[self->attrib_locations.aSourceRectType], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vUv;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vUv = get_nth(vUv, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_scale_TEXTURE_2D_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_scale_TEXTURE_2D_frag : FragmentShaderImpl, cs_scale_TEXTURE_2D_vert {
private:
typedef cs_scale_TEXTURE_2D_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
vec2 vUv;
// vec4_scalar vUvRect;
ALWAYS_INLINE void main(void) {
 vec2 st = clamp(vUv, (vUvRect).sel(X,Y), (vUvRect).sel(Z,W));
 oFragColor = texture(sColor0, (st).sel(X,Y));
}
void swgl_drawSpanRGBA8() {
 swgl_commitTextureLinearRGBA8(sColor0, vUv, vUvRect);
}
typedef cs_scale_TEXTURE_2D_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vUv;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vUv = init_interp(init->vUv, step->vUv);
  self->interp_step.vUv = step->vUv * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vUv = init_interp(init->vUv, step->vUv);
  self->vUv = self->interp_perspective.vUv * w;
  self->interp_step.vUv = step->vUv * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vUv += interp_step.vUv * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vUv += interp_step.vUv * chunks;
  vUv = w * interp_perspective.vUv;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_RGBA8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, RGBA8); }
public:
cs_scale_TEXTURE_2D_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_RGBA8_func = &draw_span_RGBA8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_scale_TEXTURE_2D_program : ProgramImpl, cs_scale_TEXTURE_2D_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sColor0", name) == 0) { return 1; }
 if (strcmp("uTransform", name) == 0) { return 2; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_scale_TEXTURE_2D"; }
static ProgramImpl* loader() { return new cs_scale_TEXTURE_2D_program; }
};

