/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozannotation_client_ffi_generated_h
#define mozannotation_client_ffi_generated_h

/* Generated with cbindgen:0.29.0 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "nsStringFwd.h"

struct AnnotationContents {
  enum class Tag {
    Empty,
    NSCStringPointer,
    CStringPointer,
    CString,
    ByteBuffer,
    OwnedByteBuffer,
  };

  struct ByteBuffer_Body {
    uint32_t _0;
  };

  struct OwnedByteBuffer_Body {
    uint32_t _0;
  };

  Tag tag;
  union {
    ByteBuffer_Body byte_buffer;
    OwnedByteBuffer_Body owned_byte_buffer;
  };
};

extern "C" {

/// Register a pointer to an nsCString string.
///
/// Returns the value of the previously registered annotation or null.
///
/// This function will be exposed to C++
const nsCString *mozannotation_register_nscstring(uint32_t id, const nsCString *address);

/// Create a copy of the provided string with a specified size that will be
/// owned by the crate, and register a pointer to it.
///
/// This function will be exposed to C++
void mozannotation_record_nscstring_from_raw_parts(uint32_t id,
                                                   const uint8_t *address,
                                                   uintptr_t size);

/// Register a pointer to a pointer to a nul-terminated string.
///
/// Returns the value of the previously registered annotation or null.
///
/// This function will be exposed to C++
const char *const *mozannotation_register_cstring_ptr(uint32_t id, const char *const *address);

/// Register a pointer to a nul-terminated string.
///
/// Returns the value of the previously registered annotation or null.
///
/// This function will be exposed to C++
const char *mozannotation_register_cstring(uint32_t id, const char *address);

/// Create a copy of the provided nul-terminated string which will be owned by
/// the crate, and register a pointer to it.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `address` must point to a valid nul-terminated C string.
void mozannotation_record_cstring(uint32_t id, const char *address);

/// Register a pointer to a fixed size buffer.
///
/// Returns the value of the previously registered annotation or null.
///
/// This function will be exposed to C++
const void *mozannotation_register_bytebuffer(uint32_t id, const void *address, uint32_t size);

/// Create a copy of the provided buffer which will be owned by the crate, and
/// register a pointer to it.
///
/// This function will be exposed to C++
void mozannotation_record_bytebuffer(uint32_t id, const void *address, uint32_t size);

/// Unregister a crash annotation. Returns the previously registered pointer or
/// null if none was present. Return null also if the crate owned the
/// annotations' buffer.
///
/// This function will be exposed to C++
const void *mozannotation_unregister(uint32_t id);

/// Returns the raw address of an annotation if it has been registered or NULL
/// if it hasn't.
///
/// This function will be exposed to C++
///
/// # Safety
///
/// `contents` must point to an object of type [`AnnotationContents`]
uintptr_t mozannotation_get_contents(uint32_t id, AnnotationContents *contents);

void mozannotation_clear_all();

}  // extern "C"

#endif  // mozannotation_client_ffi_generated_h
