/**
 * This file is auto-generated by CMake, do not edit directly.
 */

#ifndef F3DIGES_h
#define F3DIGES_h

#include "reader.h"

#include "F3DUtils.h"

#if 1
#include <vtkF3DOCCTReader.h>
#endif

#if 0
#include <.h>
#endif

#include <vtkVersion.h>
#include <vtksys/SystemTools.hxx>

class reader_IGES : public f3d::reader
{
public:
  reader_IGES()
  {
    this->ReaderOptions = { { "IGES.linear_deflection", "" }, { "IGES.angular_deflection", "" }, { "IGES.read_wire", "" }, { "IGES.relative_deflection", "" } };
  }

  /*
   * Get the name of this reader
   */
  const std::string getName() const override { return "IGES"; }

  /*
   * Get the short description of this reader
   */
  const std::string getShortDescription() const override { return "Initial Graphics Exchange Specification"; }

  /*
   * Get the extensions supported by this reader
   */
  const std::vector<std::string> getExtensions() const override
  {
    static const std::vector<std::string> ext = { "igs", "iges" };
    return ext;
  }

  /*
   * Get the mimetypes supported by this reader
   */
  const std::vector<std::string> getMimeTypes() const override
  {
    static const std::vector<std::string> types = { "model/iges" };
    return types;
  }

#if 0
  /*
   * Get the score of this reader.
   * The score is used in case several readers are able to read the file.
   * The reader having the highest score (from 0 to 100) is used to read the file.
   * Default is 50.
   */
  int getScore() const override
  {
    return ;
  }
#endif

#if 1
  /**
   * Return true if this reader can create a geometry reader
   * false otherwise
   */
  bool hasGeometryReader() override
  {
    return true;
  }

  /*
   * Create the geometry reader (VTK reader) for the given filename
   * The filename is collapsed as some VTK reader needs it to read reliably TODO add issue
   */
  vtkSmartPointer<vtkAlgorithm> createGeometryReader(const std::string& fileName) const override
  {
    vtkNew<vtkF3DOCCTReader> geomReader;
    geomReader->SetFileName(vtksys::SystemTools::CollapseFullPath(fileName).c_str());

    this->applyCustomReader(geomReader, fileName);

    return geomReader;
  }
#endif

#if 0
  /**
   * Return true if this reader can create a scene reader
   * false otherwise
   */
  bool hasSceneReader() override
  {
    return true;
  }

  /*
   * Create the scene reader (VTK importer) for the given filename
   * The filename is collapsed as some VTK reader needs it to read reliably TODO add issue
   */
  vtkSmartPointer<vtkImporter> createSceneReader(const std::string& fileName) const override
  {
    vtkNew<> importer;
    importer->SetFileName(vtksys::SystemTools::CollapseFullPath(fileName).c_str());

    this->applyCustomImporter(importer, fileName);

    return importer;
  }
#endif

#if 1
#include "/build/f3d/src/f3d-3.4.1/build/plugins/occt/IGES.inl"
#endif

};

#endif
