// GENERATED BY ISLE. DO NOT EDIT!
//
// Generated automatically from the instruction-selection DSL code in:
// - src/prelude.isle
// - src/prelude_lower.isle
// - src/isa/x64/inst.isle
// - src/isa/x64/lower.isle
// - /build/deno/src/deno/target/release/build/cranelift-codegen-b164f806920d4a8e/out/clif_lower.isle

use super::*;  // Pulls in all external types.
use std::marker::PhantomData;

/// Context during lowering: an implementation of this trait
/// must be provided with all external constructors and extractors.
/// A mutable borrow is passed along through all lowering logic.
pub trait Context {
    fn unit(&mut self, ) -> Unit;
    fn value_type(&mut self, arg0: Value) -> Type;
    fn u32_nonnegative(&mut self, arg0: u32) -> Option<u32>;
    fn offset32(&mut self, arg0: Offset32) -> i32;
    fn u32_lteq(&mut self, arg0: u32, arg1: u32) -> Option<Unit>;
    fn u8_lteq(&mut self, arg0: u8, arg1: u8) -> Option<Unit>;
    fn u8_lt(&mut self, arg0: u8, arg1: u8) -> Option<Unit>;
    fn u8_as_i8(&mut self, arg0: u8) -> i8;
    fn u8_as_u32(&mut self, arg0: u8) -> u32;
    fn u8_as_u64(&mut self, arg0: u8) -> u64;
    fn u16_as_i16(&mut self, arg0: u16) -> i16;
    fn u16_as_u32(&mut self, arg0: u16) -> u32;
    fn u16_as_u64(&mut self, arg0: u16) -> u64;
    fn u64_as_u8(&mut self, arg0: u64) -> u8;
    fn u64_as_u16(&mut self, arg0: u64) -> u16;
    fn u64_as_i64(&mut self, arg0: u64) -> i64;
    fn u8_try_from_u64(&mut self, arg0: u64) -> Option<u8>;
    fn u16_try_from_u64(&mut self, arg0: u64) -> Option<u16>;
    fn u32_try_from_u64(&mut self, arg0: u64) -> Option<u32>;
    fn u64_try_from_i64(&mut self, arg0: i64) -> Option<u64>;
    fn i8_try_from_u64(&mut self, arg0: u64) -> Option<i8>;
    fn i16_try_from_u64(&mut self, arg0: u64) -> Option<i16>;
    fn i32_try_from_u64(&mut self, arg0: u64) -> Option<i32>;
    fn u32_as_u64(&mut self, arg0: u32) -> u64;
    fn i32_as_i64(&mut self, arg0: i32) -> i64;
    fn i64_as_u64(&mut self, arg0: i64) -> u64;
    fn i64_neg(&mut self, arg0: i64) -> i64;
    fn i8_neg(&mut self, arg0: i8) -> i8;
    fn u128_as_u64(&mut self, arg0: u128) -> Option<u64>;
    fn u64_as_u32(&mut self, arg0: u64) -> Option<u32>;
    fn u32_as_u16(&mut self, arg0: u32) -> Option<u16>;
    fn i32_as_i8(&mut self, arg0: i32) -> Option<i8>;
    fn u64_as_i32(&mut self, arg0: u64) -> i32;
    fn u8_and(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_shl(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_shr(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u8_sub(&mut self, arg0: u8, arg1: u8) -> u8;
    fn u32_add(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u32_sub(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u32_and(&mut self, arg0: u32, arg1: u32) -> u32;
    fn u32_shl(&mut self, arg0: u32, arg1: u32) -> u32;
    fn s32_add_fallible(&mut self, arg0: i32, arg1: i32) -> Option<i32>;
    fn u64_add(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sub(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_mul(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_sdiv(&mut self, arg0: u64, arg1: u64) -> Option<u64>;
    fn u64_udiv(&mut self, arg0: u64, arg1: u64) -> Option<u64>;
    fn u64_and(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_or(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_xor(&mut self, arg0: u64, arg1: u64) -> u64;
    fn u64_shl(&mut self, arg0: u64, arg1: u64) -> u64;
    fn imm64_shl(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn imm64_ushr(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn imm64_sshr(&mut self, arg0: Type, arg1: Imm64, arg2: Imm64) -> Imm64;
    fn u64_not(&mut self, arg0: u64) -> u64;
    fn u64_eq(&mut self, arg0: u64, arg1: u64) -> bool;
    fn u64_le(&mut self, arg0: u64, arg1: u64) -> bool;
    fn u64_lt(&mut self, arg0: u64, arg1: u64) -> bool;
    fn i64_shr(&mut self, arg0: i64, arg1: i64) -> i64;
    fn i64_ctz(&mut self, arg0: i64) -> i64;
    fn i64_sextend_u64(&mut self, arg0: Type, arg1: u64) -> i64;
    fn i64_sextend_imm64(&mut self, arg0: Type, arg1: Imm64) -> i64;
    fn u64_uextend_imm64(&mut self, arg0: Type, arg1: Imm64) -> u64;
    fn imm64_icmp(&mut self, arg0: Type, arg1: &IntCC, arg2: Imm64, arg3: Imm64) -> Imm64;
    fn u64_is_zero(&mut self, arg0: u64) -> bool;
    fn i64_is_zero(&mut self, arg0: i64) -> bool;
    fn u64_is_odd(&mut self, arg0: u64) -> bool;
    fn u128_replicated_u64(&mut self, arg0: u128) -> Option<u64>;
    fn u64_replicated_u32(&mut self, arg0: u64) -> Option<u64>;
    fn u32_replicated_u16(&mut self, arg0: u64) -> Option<u64>;
    fn u16_replicated_u8(&mut self, arg0: u64) -> Option<u8>;
    fn f16_min(&mut self, arg0: Ieee16, arg1: Ieee16) -> Option<Ieee16>;
    fn f16_max(&mut self, arg0: Ieee16, arg1: Ieee16) -> Option<Ieee16>;
    fn f16_neg(&mut self, arg0: Ieee16) -> Ieee16;
    fn f16_abs(&mut self, arg0: Ieee16) -> Ieee16;
    fn f16_copysign(&mut self, arg0: Ieee16, arg1: Ieee16) -> Ieee16;
    fn f32_add(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_sub(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_mul(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_div(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_sqrt(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn f32_ceil(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn f32_floor(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn f32_trunc(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn f32_nearest(&mut self, arg0: Ieee32) -> Option<Ieee32>;
    fn f32_min(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_max(&mut self, arg0: Ieee32, arg1: Ieee32) -> Option<Ieee32>;
    fn f32_neg(&mut self, arg0: Ieee32) -> Ieee32;
    fn f32_abs(&mut self, arg0: Ieee32) -> Ieee32;
    fn f32_copysign(&mut self, arg0: Ieee32, arg1: Ieee32) -> Ieee32;
    fn f64_add(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_sub(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_mul(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_div(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_sqrt(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn f64_ceil(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn f64_floor(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn f64_trunc(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn f64_nearest(&mut self, arg0: Ieee64) -> Option<Ieee64>;
    fn f64_min(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_max(&mut self, arg0: Ieee64, arg1: Ieee64) -> Option<Ieee64>;
    fn f64_neg(&mut self, arg0: Ieee64) -> Ieee64;
    fn f64_abs(&mut self, arg0: Ieee64) -> Ieee64;
    fn f64_copysign(&mut self, arg0: Ieee64, arg1: Ieee64) -> Ieee64;
    fn f128_min(&mut self, arg0: Ieee128, arg1: Ieee128) -> Option<Ieee128>;
    fn f128_max(&mut self, arg0: Ieee128, arg1: Ieee128) -> Option<Ieee128>;
    fn f128_neg(&mut self, arg0: Ieee128) -> Ieee128;
    fn f128_abs(&mut self, arg0: Ieee128) -> Ieee128;
    fn f128_copysign(&mut self, arg0: Ieee128, arg1: Ieee128) -> Ieee128;
    fn ty_umin(&mut self, arg0: Type) -> u64;
    fn ty_umax(&mut self, arg0: Type) -> u64;
    fn ty_smin(&mut self, arg0: Type) -> u64;
    fn ty_smax(&mut self, arg0: Type) -> u64;
    fn ty_bits(&mut self, arg0: Type) -> u8;
    fn ty_bits_u16(&mut self, arg0: Type) -> u16;
    fn ty_bits_u64(&mut self, arg0: Type) -> u64;
    fn ty_mask(&mut self, arg0: Type) -> u64;
    fn ty_lane_mask(&mut self, arg0: Type) -> u64;
    fn ty_lane_count(&mut self, arg0: Type) -> u64;
    fn ty_bytes(&mut self, arg0: Type) -> u16;
    fn lane_type(&mut self, arg0: Type) -> Type;
    fn ty_half_lanes(&mut self, arg0: Type) -> Option<Type>;
    fn ty_half_width(&mut self, arg0: Type) -> Option<Type>;
    fn ty_equal(&mut self, arg0: Type, arg1: Type) -> bool;
    fn mem_flags_trusted(&mut self, ) -> MemFlags;
    fn intcc_swap_args(&mut self, arg0: &IntCC) -> IntCC;
    fn intcc_complement(&mut self, arg0: &IntCC) -> IntCC;
    fn intcc_without_eq(&mut self, arg0: &IntCC) -> IntCC;
    fn floatcc_swap_args(&mut self, arg0: &FloatCC) -> FloatCC;
    fn floatcc_complement(&mut self, arg0: &FloatCC) -> FloatCC;
    fn floatcc_unordered(&mut self, arg0: &FloatCC) -> bool;
    fn fits_in_16(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn lane_fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn fits_in_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32(&mut self, arg0: Type) -> Option<Type>;
    fn ty_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_scalar_64_extract(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_scalar_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_32_or_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_8_or_16(&mut self, arg0: Type) -> Option<Type>;
    fn ty_16_or_32(&mut self, arg0: Type) -> Option<Type>;
    fn int_fits_in_32(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int_ref_16_to_64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar(&mut self, arg0: Type) -> Option<Type>;
    fn ty_scalar_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_float_or_vec(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vector_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vector_not_float(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64_ctor(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn_vec64(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn_vec128(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec64_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_vec128_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_addr64(&mut self, arg0: Type) -> Option<Type>;
    fn not_vec32x2(&mut self, arg0: Type) -> Option<Type>;
    fn not_i64x2(&mut self, arg0: Type) -> Option<()>;
    fn u8_from_uimm8(&mut self, arg0: Uimm8) -> u8;
    fn u64_from_bool(&mut self, arg0: bool) -> u64;
    fn u64_from_imm64(&mut self, arg0: Imm64) -> u64;
    fn nonzero_u64_from_imm64(&mut self, arg0: Imm64) -> Option<u64>;
    fn imm64_power_of_two(&mut self, arg0: Imm64) -> Option<u64>;
    fn imm64(&mut self, arg0: u64) -> Imm64;
    fn imm64_masked(&mut self, arg0: Type, arg1: u64) -> Imm64;
    fn u16_from_ieee16(&mut self, arg0: Ieee16) -> u16;
    fn u32_from_ieee32(&mut self, arg0: Ieee32) -> u32;
    fn u64_from_ieee64(&mut self, arg0: Ieee64) -> u64;
    fn multi_lane(&mut self, arg0: Type) -> Option<(u32, u32)>;
    fn dynamic_lane(&mut self, arg0: Type) -> Option<(u32, u32)>;
    fn ty_dyn64_int(&mut self, arg0: Type) -> Option<Type>;
    fn ty_dyn128_int(&mut self, arg0: Type) -> Option<Type>;
    fn offset32_to_i32(&mut self, arg0: Offset32) -> i32;
    fn i32_to_offset32(&mut self, arg0: i32) -> Offset32;
    fn intcc_unsigned(&mut self, arg0: &IntCC) -> IntCC;
    fn signed_cond_code(&mut self, arg0: &IntCC) -> Option<IntCC>;
    fn trap_code_division_by_zero(&mut self, ) -> TrapCode;
    fn trap_code_integer_overflow(&mut self, ) -> TrapCode;
    fn trap_code_bad_conversion_to_integer(&mut self, ) -> TrapCode;
    fn range(&mut self, arg0: usize, arg1: usize) -> Range;
    fn range_view(&mut self, arg0: Range) -> RangeView;
    fn value_reg(&mut self, arg0: Reg) -> ValueRegs;
    fn writable_value_reg(&mut self, arg0: WritableReg) -> WritableValueRegs;
    fn value_regs(&mut self, arg0: Reg, arg1: Reg) -> ValueRegs;
    fn writable_value_regs(&mut self, arg0: WritableReg, arg1: WritableReg) -> WritableValueRegs;
    fn value_regs_invalid(&mut self, ) -> ValueRegs;
    fn output_none(&mut self, ) -> InstOutput;
    fn output(&mut self, arg0: ValueRegs) -> InstOutput;
    fn output_pair(&mut self, arg0: ValueRegs, arg1: ValueRegs) -> InstOutput;
    fn output_builder_new(&mut self, ) -> InstOutputBuilder;
    fn output_builder_push(&mut self, arg0: &InstOutputBuilder, arg1: ValueRegs) -> Unit;
    fn output_builder_finish(&mut self, arg0: &InstOutputBuilder) -> InstOutput;
    fn temp_writable_reg(&mut self, arg0: Type) -> WritableReg;
    fn is_valid_reg(&mut self, arg0: Reg) -> bool;
    fn invalid_reg(&mut self, ) -> Reg;
    fn mark_value_used(&mut self, arg0: Value) -> Unit;
    fn put_in_reg(&mut self, arg0: Value) -> Reg;
    fn put_in_regs(&mut self, arg0: Value) -> ValueRegs;
    fn ensure_in_vreg(&mut self, arg0: Reg, arg1: Type) -> Reg;
    fn value_regs_get(&mut self, arg0: ValueRegs, arg1: usize) -> Reg;
    fn value_regs_len(&mut self, arg0: ValueRegs) -> usize;
    fn preg_to_reg(&mut self, arg0: PReg) -> Reg;
    fn add_range_fact(&mut self, arg0: Reg, arg1: u16, arg2: u64, arg3: u64) -> Reg;
    fn single_target(&mut self, arg0: &MachLabelSlice) -> Option<MachLabel>;
    fn two_targets(&mut self, arg0: &MachLabelSlice) -> Option<(MachLabel, MachLabel)>;
    fn jump_table_targets(&mut self, arg0: &MachLabelSlice) -> Option<(MachLabel, BoxVecMachLabel)>;
    fn jump_table_size(&mut self, arg0: &BoxVecMachLabel) -> u32;
    fn value_list_slice(&mut self, arg0: ValueList) -> ValueSlice;
    fn value_slice_empty(&mut self, arg0: ValueSlice) -> Option<()>;
    fn value_slice_unwrap(&mut self, arg0: ValueSlice) -> Option<(Value, ValueSlice)>;
    fn value_slice_len(&mut self, arg0: ValueSlice) -> usize;
    fn value_slice_get(&mut self, arg0: ValueSlice, arg1: usize) -> Value;
    fn writable_reg_to_reg(&mut self, arg0: WritableReg) -> Reg;
    fn inst_results(&mut self, arg0: Inst) -> ValueSlice;
    fn value_is_unused(&mut self, arg0: Value) -> bool;
    fn first_result(&mut self, arg0: Inst) -> Option<Value>;
    fn inst_data(&mut self, arg0: Inst) -> InstructionData;
    fn def_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn i32_from_iconst(&mut self, arg0: Value) -> Option<i32>;
    fn i64_from_iconst(&mut self, arg0: Value) -> Option<i64>;
    fn zero_value(&mut self, arg0: Value) -> Option<Value>;
    fn is_sinkable_inst(&mut self, arg0: Value) -> Option<Inst>;
    fn maybe_uextend(&mut self, arg0: Value) -> Option<Value>;
    fn uimm8(&mut self, arg0: Imm64) -> Option<u8>;
    fn emit(&mut self, arg0: &MInst) -> Unit;
    fn sink_inst(&mut self, arg0: Inst) -> Unit;
    fn emit_u64_le_const(&mut self, arg0: u64) -> VCodeConstant;
    fn emit_u128_le_const(&mut self, arg0: u128) -> VCodeConstant;
    fn const_to_vconst(&mut self, arg0: Constant) -> VCodeConstant;
    fn tls_model(&mut self, arg0: Type) -> TlsModel;
    fn tls_model_is_elf_gd(&mut self, ) -> Option<Unit>;
    fn tls_model_is_macho(&mut self, ) -> Option<Unit>;
    fn tls_model_is_coff(&mut self, ) -> Option<Unit>;
    fn preserve_frame_pointers(&mut self, ) -> Option<Unit>;
    fn stack_switch_model(&mut self, ) -> Option<StackSwitchModel>;
    fn box_external_name(&mut self, arg0: ExternalName) -> BoxExternalName;
    fn func_ref_data(&mut self, arg0: FuncRef) -> (SigRef, ExternalName, RelocDistance);
    fn symbol_value_data(&mut self, arg0: GlobalValue) -> Option<(ExternalName, RelocDistance, i64)>;
    fn reloc_distance_near(&mut self, arg0: RelocDistance) -> Option<()>;
    fn vec_mask_from_immediate(&mut self, arg0: Immediate) -> Option<VecMask>;
    fn u128_from_immediate(&mut self, arg0: Immediate) -> Option<u128>;
    fn vconst_from_immediate(&mut self, arg0: Immediate) -> Option<VCodeConstant>;
    fn u128_from_constant(&mut self, arg0: Constant) -> Option<u128>;
    fn u64_from_constant(&mut self, arg0: Constant) -> Option<u64>;
    fn shuffle64_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8)>;
    fn shuffle32_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8, u8, u8)>;
    fn shuffle16_from_imm(&mut self, arg0: Immediate) -> Option<(u8, u8, u8, u8, u8, u8, u8, u8)>;
    fn only_writable_reg(&mut self, arg0: WritableValueRegs) -> Option<WritableReg>;
    fn writable_regs_get(&mut self, arg0: WritableValueRegs, arg1: usize) -> WritableReg;
    fn abi_num_args(&mut self, arg0: Sig) -> usize;
    fn abi_get_arg(&mut self, arg0: Sig, arg1: usize) -> ABIArg;
    fn abi_num_rets(&mut self, arg0: Sig) -> usize;
    fn abi_get_ret(&mut self, arg0: Sig, arg1: usize) -> ABIArg;
    fn abi_ret_arg(&mut self, arg0: Sig) -> Option<ABIArg>;
    fn abi_no_ret_arg(&mut self, arg0: Sig) -> Option<()>;
    fn abi_unwrap_ret_area_ptr(&mut self, ) -> Reg;
    fn abi_stackslot_addr(&mut self, arg0: WritableReg, arg1: StackSlot, arg2: Offset32) -> MInst;
    fn abi_dynamic_stackslot_addr(&mut self, arg0: WritableReg, arg1: DynamicStackSlot) -> MInst;
    fn abi_arg_only_slot(&mut self, arg0: &ABIArg) -> Option<ABIArgSlot>;
    fn abi_arg_implicit_pointer(&mut self, arg0: &ABIArg) -> Option<(ABIArgSlot, i64, Type)>;
    fn real_reg_to_reg(&mut self, arg0: RealReg) -> Reg;
    fn real_reg_to_writable_reg(&mut self, arg0: RealReg) -> WritableReg;
    fn gen_move(&mut self, arg0: Type, arg1: WritableReg, arg2: Reg) -> MInst;
    fn gen_return(&mut self, arg0: ValueSlice) -> Unit;
    fn gen_return_call(&mut self, arg0: SigRef, arg1: ExternalName, arg2: RelocDistance, arg3: ValueSlice) -> InstOutput;
    fn gen_return_call_indirect(&mut self, arg0: SigRef, arg1: Value, arg2: ValueSlice) -> InstOutput;
    fn safe_divisor_from_imm64(&mut self, arg0: Type, arg1: Imm64) -> Option<u64>;
    fn box_synthetic_amode(&mut self, arg0: &SyntheticAmode) -> BoxSyntheticAmode;
    fn operand_size_of_type_32_64(&mut self, arg0: Type) -> OperandSize;
    fn raw_operand_size_of_type(&mut self, arg0: Type) -> OperandSize;
    fn put_in_reg_mem_imm(&mut self, arg0: Value) -> RegMemImm;
    fn put_in_reg_mem(&mut self, arg0: Value) -> RegMem;
    fn synthetic_amode_to_reg_mem(&mut self, arg0: &SyntheticAmode) -> RegMem;
    fn amode_to_synthetic_amode(&mut self, arg0: &Amode) -> SyntheticAmode;
    fn sum_extend_fits_in_32_bits(&mut self, arg0: Type, arg1: Imm64, arg2: Offset32) -> Option<u32>;
    fn amode_offset(&mut self, arg0: &Amode, arg1: i32) -> Amode;
    fn zero_offset(&mut self, ) -> Offset32;
    fn intcc_to_cc(&mut self, arg0: &IntCC) -> CC;
    fn cc_invert(&mut self, arg0: &CC) -> CC;
    fn cc_nz_or_z(&mut self, arg0: &CC) -> Option<CC>;
    fn encode_fcmp_imm(&mut self, arg0: &FcmpImm) -> u8;
    fn encode_round_imm(&mut self, arg0: &RoundImm) -> u8;
    fn imm8_reg_to_imm8_gpr(&mut self, arg0: &Imm8Reg) -> Imm8Gpr;
    fn gpr_from_imm8_gpr(&mut self, arg0: &Imm8Gpr) -> Option<Gpr>;
    fn imm8_from_imm8_gpr(&mut self, arg0: &Imm8Gpr) -> Option<u8>;
    fn writable_gpr_to_reg(&mut self, arg0: WritableGpr) -> WritableReg;
    fn writable_xmm_to_reg(&mut self, arg0: WritableXmm) -> WritableReg;
    fn writable_reg_to_xmm(&mut self, arg0: WritableReg) -> WritableXmm;
    fn writable_xmm_to_xmm(&mut self, arg0: WritableXmm) -> Xmm;
    fn writable_gpr_to_gpr(&mut self, arg0: WritableGpr) -> Gpr;
    fn gpr_to_reg(&mut self, arg0: Gpr) -> Reg;
    fn gpr_to_gpr_mem(&mut self, arg0: Gpr) -> GprMem;
    fn gpr_to_gpr_mem_imm(&mut self, arg0: Gpr) -> GprMemImm;
    fn xmm_to_reg(&mut self, arg0: Xmm) -> Reg;
    fn xmm_to_xmm_mem_imm(&mut self, arg0: Xmm) -> XmmMemImm;
    fn xmm_mem_to_xmm_mem_imm(&mut self, arg0: &XmmMem) -> XmmMemImm;
    fn xmm_mem_to_xmm_mem_aligned(&mut self, arg0: &XmmMem) -> XmmMemAligned;
    fn xmm_mem_imm_to_xmm_mem_aligned_imm(&mut self, arg0: &XmmMemImm) -> XmmMemAlignedImm;
    fn temp_writable_gpr(&mut self, ) -> WritableGpr;
    fn temp_writable_xmm(&mut self, ) -> WritableXmm;
    fn reg_mem_to_xmm_mem(&mut self, arg0: &RegMem) -> XmmMem;
    fn reg_to_reg_mem_imm(&mut self, arg0: Reg) -> RegMemImm;
    fn gpr_mem_imm_new(&mut self, arg0: &RegMemImm) -> GprMemImm;
    fn xmm_mem_imm_new(&mut self, arg0: &RegMemImm) -> XmmMemImm;
    fn xmm_to_xmm_mem(&mut self, arg0: Xmm) -> XmmMem;
    fn xmm_mem_to_reg_mem(&mut self, arg0: &XmmMem) -> RegMem;
    fn gpr_mem_to_reg_mem(&mut self, arg0: &GprMem) -> RegMem;
    fn xmm_new(&mut self, arg0: Reg) -> Xmm;
    fn gpr_new(&mut self, arg0: Reg) -> Gpr;
    fn reg_mem_to_gpr_mem(&mut self, arg0: &RegMem) -> GprMem;
    fn reg_to_gpr_mem(&mut self, arg0: Reg) -> GprMem;
    fn put_in_xmm_mem(&mut self, arg0: Value) -> XmmMem;
    fn put_in_xmm_mem_imm(&mut self, arg0: Value) -> XmmMemImm;
    fn gpr_to_imm8_gpr(&mut self, arg0: Gpr) -> Imm8Gpr;
    fn imm8_to_imm8_gpr(&mut self, arg0: u8) -> Imm8Gpr;
    fn xmi_imm(&mut self, arg0: u32) -> XmmMemImm;
    fn type_register_class(&mut self, arg0: Type) -> Option<RegisterClass>;
    fn use_avx512vl(&mut self, ) -> bool;
    fn use_avx512dq(&mut self, ) -> bool;
    fn use_avx512f(&mut self, ) -> bool;
    fn use_avx512bitalg(&mut self, ) -> bool;
    fn use_avx512vbmi(&mut self, ) -> bool;
    fn use_lzcnt(&mut self, ) -> bool;
    fn use_bmi1(&mut self, ) -> bool;
    fn use_bmi2(&mut self, ) -> bool;
    fn use_popcnt(&mut self, ) -> bool;
    fn use_fma(&mut self, ) -> bool;
    fn use_ssse3(&mut self, ) -> bool;
    fn use_sse41(&mut self, ) -> bool;
    fn use_sse42(&mut self, ) -> bool;
    fn use_avx(&mut self, ) -> bool;
    fn use_avx2(&mut self, ) -> bool;
    fn use_cmpxchg16b(&mut self, ) -> bool;
    fn imm8_from_value(&mut self, arg0: Value) -> Option<Imm8Reg>;
    fn const_to_type_masked_imm8(&mut self, arg0: u64, arg1: Type) -> Imm8Gpr;
    fn shift_mask(&mut self, arg0: Type) -> u8;
    fn shift_amount_masked(&mut self, arg0: Type, arg1: Imm64) -> u8;
    fn simm32_from_value(&mut self, arg0: Value) -> Option<GprMemImm>;
    fn sinkable_load(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sinkable_load_exact(&mut self, arg0: Value) -> Option<SinkableLoad>;
    fn sink_load(&mut self, arg0: &SinkableLoad) -> SyntheticAmode;
    fn ext_mode(&mut self, arg0: u16, arg1: u16) -> ExtMode;
    fn gen_call(&mut self, arg0: SigRef, arg1: ExternalName, arg2: RelocDistance, arg3: ValueSlice) -> InstOutput;
    fn gen_call_indirect(&mut self, arg0: SigRef, arg1: Value, arg2: ValueSlice) -> InstOutput;
    fn writable_invalid_gpr(&mut self, ) -> WritableGpr;
    fn nonzero_u64_fits_in_u32(&mut self, arg0: u64) -> Option<u64>;
    fn ty_int_bool_or_ref(&mut self, arg0: Type) -> Option<()>;
    fn shuffle_0_31_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn shuffle_0_15_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn shuffle_16_31_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn perm_from_mask(&mut self, arg0: &VecMask) -> VCodeConstant;
    fn perm_from_mask_with_zeros(&mut self, arg0: &VecMask) -> Option<(VCodeConstant, VCodeConstant)>;
    fn const_to_synthetic_amode(&mut self, arg0: VCodeConstant) -> SyntheticAmode;
    fn preg_rbp(&mut self, ) -> PReg;
    fn preg_rsp(&mut self, ) -> PReg;
    fn preg_pinned(&mut self, ) -> PReg;
    fn libcall_1(&mut self, arg0: &LibCall, arg1: Reg) -> Reg;
    fn libcall_2(&mut self, arg0: &LibCall, arg1: Reg, arg2: Reg) -> Reg;
    fn libcall_3(&mut self, arg0: &LibCall, arg1: Reg, arg2: Reg, arg3: Reg) -> Reg;
    fn ishl_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ishl_i8x16_mask_table(&mut self, ) -> SyntheticAmode;
    fn ushr_i8x16_mask_for_const(&mut self, arg0: u32) -> SyntheticAmode;
    fn ushr_i8x16_mask_table(&mut self, ) -> SyntheticAmode;
    fn vconst_all_ones_or_all_zeros(&mut self, arg0: Constant) -> Option<()>;
    fn insert_i8x16_lane_hole(&mut self, arg0: u8) -> VCodeConstant;
    fn sse_insertps_lane_imm(&mut self, arg0: u8) -> u8;
    fn pblendw_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn palignr_imm_from_immediate(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshuflw_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshuflw_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufhw_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufhw_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufd_lhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn pshufd_rhs_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn shufps_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn shufps_rev_imm(&mut self, arg0: Immediate) -> Option<u8>;
    fn unpack_value_array_2(&mut self, arg0: &ValueArray2) -> (Value, Value);
    fn pack_value_array_2(&mut self, arg0: Value, arg1: Value) -> ValueArray2;
    fn unpack_value_array_3(&mut self, arg0: &ValueArray3) -> (Value, Value, Value);
    fn pack_value_array_3(&mut self, arg0: Value, arg1: Value, arg2: Value) -> ValueArray3;
    fn unpack_block_array_2(&mut self, arg0: &BlockArray2) -> (BlockCall, BlockCall);
    fn pack_block_array_2(&mut self, arg0: BlockCall, arg1: BlockCall) -> BlockArray2;
}

pub trait ContextIter {
    type Context;
    type Output;
    fn next(&mut self, ctx: &mut Self::Context) -> Option<Self::Output>;
    fn size_hint(&self) -> (usize, Option<usize>) { (0, None) }
}

pub trait IntoContextIter {
    type Context;
    type Output;
    type IntoIter: ContextIter<Context = Self::Context, Output = Self::Output>;
    fn into_context_iter(self) -> Self::IntoIter;
}

pub trait Length {
    fn len(&self) -> usize;
}

impl<T> Length for std::vec::Vec<T> {
    fn len(&self) -> usize {
        std::vec::Vec::len(self)
    }
}

pub struct ContextIterWrapper<I, C> {
    iter: I,
    _ctx: std::marker::PhantomData<C>,
}
impl<I: Default, C> Default for ContextIterWrapper<I, C> {
    fn default() -> Self {
        ContextIterWrapper {
            iter: I::default(),
            _ctx: std::marker::PhantomData
        }
    }
}
impl<I, C> std::ops::Deref for ContextIterWrapper<I, C> {
    type Target = I;
    fn deref(&self) -> &I {
        &self.iter
    }
}
impl<I, C> std::ops::DerefMut for ContextIterWrapper<I, C> {
    fn deref_mut(&mut self) -> &mut I {
        &mut self.iter
    }
}
impl<I: Iterator, C: Context> From<I> for ContextIterWrapper<I, C> {
    fn from(iter: I) -> Self {
        Self { iter, _ctx: std::marker::PhantomData }
    }
}
impl<I: Iterator, C: Context> ContextIter for ContextIterWrapper<I, C> {
    type Context = C;
    type Output = I::Item;
    fn next(&mut self, _ctx: &mut Self::Context) -> Option<Self::Output> {
        self.iter.next()
    }
    fn size_hint(&self) -> (usize, Option<usize>) {
        self.iter.size_hint()
    }
}
impl<I: IntoIterator, C: Context> IntoContextIter for ContextIterWrapper<I, C> {
    type Context = C;
    type Output = I::Item;
    type IntoIter = ContextIterWrapper<I::IntoIter, C>;
    fn into_context_iter(self) -> Self::IntoIter {
        ContextIterWrapper {
            iter: self.iter.into_iter(),
            _ctx: std::marker::PhantomData
        }
    }
}
impl<T, E: Extend<T>, C> Extend<T> for ContextIterWrapper<E, C> {
    fn extend<I: IntoIterator<Item = T>>(&mut self, iter: I) {
        self.iter.extend(iter);
    }
}
impl<L: Length, C> Length for ContextIterWrapper<L, C> {
    fn len(&self) -> usize {
        self.iter.len()
    }
}
           

/// Internal type MultiReg: defined at src/prelude_lower.isle line 20.
#[derive(Clone, Debug)]
pub enum MultiReg {
    Empty,
    One {
        a: Reg,
    },
    Two {
        a: Reg,
        b: Reg,
    },
    Three {
        a: Reg,
        b: Reg,
        c: Reg,
    },
    Four {
        a: Reg,
        b: Reg,
        c: Reg,
        d: Reg,
    },
}

/// Internal type SideEffectNoResult: defined at src/prelude_lower.isle line 400.
#[derive(Clone, Debug)]
pub enum SideEffectNoResult {
    Inst {
        inst: MInst,
    },
    Inst2 {
        inst1: MInst,
        inst2: MInst,
    },
    Inst3 {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
    },
}

/// Internal type ProducesFlags: defined at src/prelude_lower.isle line 446.
#[derive(Clone, Debug)]
pub enum ProducesFlags {
    AlreadyExistingFlags,
    ProducesFlagsSideEffect {
        inst: MInst,
    },
    ProducesFlagsTwiceSideEffect {
        inst1: MInst,
        inst2: MInst,
    },
    ProducesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ProducesFlagsReturnsResultWithConsumer {
        inst: MInst,
        result: Reg,
    },
}

/// Internal type ConsumesAndProducesFlags: defined at src/prelude_lower.isle line 465.
#[derive(Clone, Debug)]
pub enum ConsumesAndProducesFlags {
    SideEffect {
        inst: MInst,
    },
    ReturnsReg {
        inst: MInst,
        result: Reg,
    },
}

/// Internal type ConsumesFlags: defined at src/prelude_lower.isle line 473.
#[derive(Clone, Debug)]
pub enum ConsumesFlags {
    ConsumesFlagsSideEffect {
        inst: MInst,
    },
    ConsumesFlagsSideEffect2 {
        inst1: MInst,
        inst2: MInst,
    },
    ConsumesFlagsReturnsResultWithProducer {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsReturnsReg {
        inst: MInst,
        result: Reg,
    },
    ConsumesFlagsTwiceReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        result: ValueRegs,
    },
    ConsumesFlagsFourTimesReturnsValueRegs {
        inst1: MInst,
        inst2: MInst,
        inst3: MInst,
        inst4: MInst,
        result: ValueRegs,
    },
}

/// Internal type MInst: defined at src/isa/x64/inst.isle line 7.
#[derive(Clone)]
pub enum MInst {
    Nop {
        len: u8,
    },
    AluRmiR {
        size: OperandSize,
        op: AluRmiROpcode,
        src1: Gpr,
        src2: GprMemImm,
        dst: WritableGpr,
    },
    AluRM {
        size: OperandSize,
        op: AluRmiROpcode,
        src1_dst: SyntheticAmode,
        src2: Gpr,
        lock: bool,
    },
    AluRmRVex {
        size: OperandSize,
        op: AluRmROpcode,
        src1: Gpr,
        src2: GprMem,
        dst: WritableGpr,
    },
    AluConstOp {
        op: AluRmiROpcode,
        size: OperandSize,
        dst: WritableGpr,
    },
    UnaryRmR {
        size: OperandSize,
        op: UnaryRmROpcode,
        src: GprMem,
        dst: WritableGpr,
    },
    UnaryRmRVex {
        size: OperandSize,
        op: UnaryRmRVexOpcode,
        src: GprMem,
        dst: WritableGpr,
    },
    UnaryRmRImmVex {
        size: OperandSize,
        op: UnaryRmRImmVexOpcode,
        src: GprMem,
        dst: WritableGpr,
        imm: u8,
    },
    Not {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Neg {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Div {
        size: OperandSize,
        sign: DivSignedness,
        trap: TrapCode,
        divisor: GprMem,
        dividend_lo: Gpr,
        dividend_hi: Gpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
    },
    Div8 {
        sign: DivSignedness,
        trap: TrapCode,
        divisor: GprMem,
        dividend: Gpr,
        dst: WritableGpr,
    },
    Mul {
        size: OperandSize,
        signed: bool,
        src1: Gpr,
        src2: GprMem,
        dst_lo: WritableGpr,
        dst_hi: WritableGpr,
    },
    MulX {
        size: OperandSize,
        src1: Gpr,
        src2: GprMem,
        dst_lo: WritableGpr,
        dst_hi: WritableGpr,
    },
    Mul8 {
        signed: bool,
        src1: Gpr,
        src2: GprMem,
        dst: WritableGpr,
    },
    IMul {
        size: OperandSize,
        src1: Gpr,
        src2: GprMem,
        dst: WritableGpr,
    },
    IMulImm {
        size: OperandSize,
        src1: GprMem,
        src2: i32,
        dst: WritableGpr,
    },
    CheckedSRemSeq {
        size: OperandSize,
        dividend_lo: Gpr,
        dividend_hi: Gpr,
        divisor: Gpr,
        dst_quotient: WritableGpr,
        dst_remainder: WritableGpr,
    },
    CheckedSRemSeq8 {
        dividend: Gpr,
        divisor: Gpr,
        dst: WritableGpr,
    },
    SignExtendData {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Imm {
        dst_size: OperandSize,
        simm64: u64,
        dst: WritableGpr,
    },
    MovRR {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    MovFromPReg {
        src: PReg,
        dst: WritableGpr,
    },
    MovToPReg {
        src: Gpr,
        dst: PReg,
    },
    MovzxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    Mov64MR {
        src: SyntheticAmode,
        dst: WritableGpr,
    },
    LoadEffectiveAddress {
        addr: SyntheticAmode,
        dst: WritableGpr,
        size: OperandSize,
    },
    MovsxRmR {
        ext_mode: ExtMode,
        src: GprMem,
        dst: WritableGpr,
    },
    MovImmM {
        size: OperandSize,
        simm32: i32,
        dst: SyntheticAmode,
    },
    MovRM {
        size: OperandSize,
        src: Gpr,
        dst: SyntheticAmode,
    },
    ShiftR {
        size: OperandSize,
        kind: ShiftKind,
        src: Gpr,
        num_bits: Imm8Gpr,
        dst: WritableGpr,
    },
    XmmRmiReg {
        opcode: SseOpcode,
        src1: Xmm,
        src2: XmmMemAlignedImm,
        dst: WritableXmm,
    },
    CmpRmiR {
        size: OperandSize,
        opcode: CmpOpcode,
        src1: Gpr,
        src2: GprMemImm,
    },
    Setcc {
        cc: CC,
        dst: WritableGpr,
    },
    Bswap {
        size: OperandSize,
        src: Gpr,
        dst: WritableGpr,
    },
    Cmove {
        size: OperandSize,
        cc: CC,
        consequent: GprMem,
        alternative: Gpr,
        dst: WritableGpr,
    },
    XmmCmove {
        ty: Type,
        cc: CC,
        consequent: Xmm,
        alternative: Xmm,
        dst: WritableXmm,
    },
    Push64 {
        src: GprMemImm,
    },
    Pop64 {
        dst: WritableGpr,
    },
    StackProbeLoop {
        tmp: WritableReg,
        frame_size: u32,
        guard_size: u32,
    },
    XmmRmR {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMemAligned,
        dst: WritableXmm,
    },
    XmmRmRUnaligned {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
    },
    XmmRmRBlend {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMemAligned,
        mask: Xmm,
        dst: WritableXmm,
    },
    XmmRmiRVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMemImm,
        dst: WritableXmm,
    },
    XmmRmRImmVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmVexPinsr {
        op: AvxOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmRmRVex3 {
        op: AvxOpcode,
        src1: Xmm,
        src2: Xmm,
        src3: XmmMem,
        dst: WritableXmm,
    },
    XmmRmRBlendVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMem,
        mask: Xmm,
        dst: WritableXmm,
    },
    XmmUnaryRmRVex {
        op: AvxOpcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImmVex {
        op: AvxOpcode,
        src: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmMovRMVex {
        op: AvxOpcode,
        src: Xmm,
        dst: SyntheticAmode,
    },
    XmmMovRMImmVex {
        op: AvxOpcode,
        src: Xmm,
        dst: SyntheticAmode,
        imm: u8,
    },
    XmmToGprImmVex {
        op: AvxOpcode,
        src: Xmm,
        dst: WritableGpr,
        imm: u8,
    },
    GprToXmmVex {
        op: AvxOpcode,
        src: GprMem,
        dst: WritableXmm,
        src_size: OperandSize,
    },
    XmmToGprVex {
        op: AvxOpcode,
        src: Xmm,
        dst: WritableGpr,
        dst_size: OperandSize,
    },
    XmmCmpRmRVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: XmmMem,
    },
    XmmRmREvex {
        op: Avx512Opcode,
        src1: Xmm,
        src2: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImmEvex {
        op: Avx512Opcode,
        src: XmmMem,
        dst: WritableXmm,
        imm: u8,
    },
    XmmRmREvex3 {
        op: Avx512Opcode,
        src1: Xmm,
        src2: Xmm,
        src3: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmR {
        op: SseOpcode,
        src: XmmMemAligned,
        dst: WritableXmm,
    },
    XmmUnaryRmRUnaligned {
        op: SseOpcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmUnaryRmRImm {
        op: SseOpcode,
        src: XmmMemAligned,
        imm: u8,
        dst: WritableXmm,
    },
    XmmUnaryRmREvex {
        op: Avx512Opcode,
        src: XmmMem,
        dst: WritableXmm,
    },
    XmmMovRM {
        op: SseOpcode,
        src: Xmm,
        dst: SyntheticAmode,
    },
    XmmMovRMImm {
        op: SseOpcode,
        src: Xmm,
        dst: SyntheticAmode,
        imm: u8,
    },
    XmmToGpr {
        op: SseOpcode,
        src: Xmm,
        dst: WritableGpr,
        dst_size: OperandSize,
    },
    XmmToGprImm {
        op: SseOpcode,
        src: Xmm,
        dst: WritableGpr,
        imm: u8,
    },
    GprToXmm {
        op: SseOpcode,
        src: GprMem,
        dst: WritableXmm,
        src_size: OperandSize,
    },
    CvtIntToFloat {
        op: SseOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        src2_size: OperandSize,
    },
    CvtIntToFloatVex {
        op: AvxOpcode,
        src1: Xmm,
        src2: GprMem,
        dst: WritableXmm,
        src2_size: OperandSize,
    },
    CvtUint64ToFloatSeq {
        dst_size: OperandSize,
        src: Gpr,
        dst: WritableXmm,
        tmp_gpr1: WritableGpr,
        tmp_gpr2: WritableGpr,
    },
    CvtFloatToSintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: Xmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
    },
    CvtFloatToUintSeq {
        dst_size: OperandSize,
        src_size: OperandSize,
        is_saturating: bool,
        src: Xmm,
        dst: WritableGpr,
        tmp_gpr: WritableGpr,
        tmp_xmm: WritableXmm,
        tmp_xmm2: WritableXmm,
    },
    XmmMinMaxSeq {
        size: OperandSize,
        is_min: bool,
        lhs: Xmm,
        rhs: Xmm,
        dst: WritableXmm,
    },
    XmmCmpRmR {
        op: SseOpcode,
        src1: Xmm,
        src2: XmmMemAligned,
    },
    XmmRmRImm {
        op: SseOpcode,
        src1: Reg,
        src2: RegMem,
        dst: WritableReg,
        imm: u8,
        size: OperandSize,
    },
    CallKnown {
        info: BoxCallInfo,
    },
    CallUnknown {
        info: BoxCallIndInfo,
    },
    ReturnCallKnown {
        info: BoxReturnCallInfo,
    },
    ReturnCallUnknown {
        info: BoxReturnCallIndInfo,
    },
    Args {
        args: VecArgPair,
    },
    Rets {
        rets: VecRetPair,
    },
    Ret {
        stack_bytes_to_pop: u32,
    },
    StackSwitchBasic {
        store_context_ptr: Gpr,
        load_context_ptr: Gpr,
        in_payload0: Gpr,
        out_payload0: WritableGpr,
    },
    JmpKnown {
        dst: MachLabel,
    },
    JmpIf {
        cc: CC,
        taken: MachLabel,
    },
    JmpCond {
        cc: CC,
        taken: MachLabel,
        not_taken: MachLabel,
    },
    JmpTableSeq {
        idx: Reg,
        tmp1: WritableReg,
        tmp2: WritableReg,
        default_target: MachLabel,
        targets: BoxVecMachLabel,
    },
    JmpUnknown {
        target: RegMem,
    },
    TrapIf {
        cc: CC,
        trap_code: TrapCode,
    },
    TrapIfAnd {
        cc1: CC,
        cc2: CC,
        trap_code: TrapCode,
    },
    TrapIfOr {
        cc1: CC,
        cc2: CC,
        trap_code: TrapCode,
    },
    Hlt,
    Ud2 {
        trap_code: TrapCode,
    },
    LoadExtName {
        dst: WritableReg,
        name: BoxExternalName,
        offset: i64,
        distance: RelocDistance,
    },
    LockCmpxchg {
        ty: Type,
        replacement: Reg,
        expected: Reg,
        mem: SyntheticAmode,
        dst_old: WritableReg,
    },
    LockCmpxchg16b {
        replacement_low: Reg,
        replacement_high: Reg,
        expected_low: Reg,
        expected_high: Reg,
        mem: BoxSyntheticAmode,
        dst_old_low: WritableReg,
        dst_old_high: WritableReg,
    },
    LockXadd {
        size: OperandSize,
        operand: Reg,
        mem: SyntheticAmode,
        dst_old: WritableReg,
    },
    Xchg {
        size: OperandSize,
        operand: Reg,
        mem: SyntheticAmode,
        dst_old: WritableReg,
    },
    AtomicRmwSeq {
        ty: Type,
        op: AtomicRmwSeqOp,
        mem: SyntheticAmode,
        operand: Reg,
        temp: WritableReg,
        dst_old: WritableReg,
    },
    Atomic128RmwSeq {
        op: Atomic128RmwSeqOp,
        mem: BoxSyntheticAmode,
        operand_low: Reg,
        operand_high: Reg,
        temp_low: WritableReg,
        temp_high: WritableReg,
        dst_old_low: WritableReg,
        dst_old_high: WritableReg,
    },
    Atomic128XchgSeq {
        mem: SyntheticAmode,
        operand_low: Reg,
        operand_high: Reg,
        dst_old_low: WritableReg,
        dst_old_high: WritableReg,
    },
    Fence {
        kind: FenceKind,
    },
    XmmUninitializedValue {
        dst: WritableXmm,
    },
    ElfTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
    },
    MachOTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
    },
    CoffTlsGetAddr {
        symbol: ExternalName,
        dst: WritableGpr,
        tmp: WritableGpr,
    },
    Unwind {
        inst: UnwindInst,
    },
    DummyUse {
        reg: Reg,
    },
}

/// Internal type DivSignedness: defined at src/isa/x64/inst.isle line 822.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum DivSignedness {
    Signed,
    Unsigned,
}

/// Internal type AluRmROpcode: defined at src/isa/x64/inst.isle line 865.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AluRmROpcode {
    Andn,
    Sarx,
    Shrx,
    Shlx,
    Bzhi,
}

/// Internal type UnaryRmRVexOpcode: defined at src/isa/x64/inst.isle line 879.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryRmRVexOpcode {
    Blsi,
    Blsmsk,
    Blsr,
}

/// Internal type UnaryRmRImmVexOpcode: defined at src/isa/x64/inst.isle line 884.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum UnaryRmRImmVexOpcode {
    Rorx,
}

/// Internal type Amode: defined at src/isa/x64/inst.isle line 1132.
#[derive(Clone, Debug)]
pub enum Amode {
    ImmReg {
        simm32: i32,
        base: Reg,
        flags: MemFlags,
    },
    ImmRegRegShift {
        simm32: i32,
        base: Gpr,
        index: Gpr,
        shift: u8,
        flags: MemFlags,
    },
    RipRelative {
        target: MachLabel,
    },
}

/// Internal type AvxOpcode: defined at src/isa/x64/inst.isle line 1366.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AvxOpcode {
    Vfmadd213ss,
    Vfmadd213sd,
    Vfmadd213ps,
    Vfmadd213pd,
    Vfmadd132ss,
    Vfmadd132sd,
    Vfmadd132ps,
    Vfmadd132pd,
    Vfnmadd213ss,
    Vfnmadd213sd,
    Vfnmadd213ps,
    Vfnmadd213pd,
    Vfnmadd132ss,
    Vfnmadd132sd,
    Vfnmadd132ps,
    Vfnmadd132pd,
    Vfmsub213ss,
    Vfmsub213sd,
    Vfmsub213ps,
    Vfmsub213pd,
    Vfmsub132ss,
    Vfmsub132sd,
    Vfmsub132ps,
    Vfmsub132pd,
    Vfnmsub213ss,
    Vfnmsub213sd,
    Vfnmsub213ps,
    Vfnmsub213pd,
    Vfnmsub132ss,
    Vfnmsub132sd,
    Vfnmsub132ps,
    Vfnmsub132pd,
    Vcmpps,
    Vcmppd,
    Vpsrlw,
    Vpsrld,
    Vpsrlq,
    Vpaddb,
    Vpaddw,
    Vpaddd,
    Vpaddq,
    Vpaddsb,
    Vpaddsw,
    Vpaddusb,
    Vpaddusw,
    Vpsubb,
    Vpsubw,
    Vpsubd,
    Vpsubq,
    Vpsubsb,
    Vpsubsw,
    Vpsubusb,
    Vpsubusw,
    Vpavgb,
    Vpavgw,
    Vpand,
    Vandps,
    Vandpd,
    Vpor,
    Vorps,
    Vorpd,
    Vpxor,
    Vxorps,
    Vxorpd,
    Vpmullw,
    Vpmulld,
    Vpmulhw,
    Vpmulhd,
    Vpmulhrsw,
    Vpmulhuw,
    Vpmuldq,
    Vpmuludq,
    Vpunpckhwd,
    Vpunpcklwd,
    Vunpcklps,
    Vunpcklpd,
    Vunpckhps,
    Vandnps,
    Vandnpd,
    Vpandn,
    Vaddps,
    Vaddpd,
    Vsubps,
    Vsubpd,
    Vmulps,
    Vmulpd,
    Vdivps,
    Vdivpd,
    Vpcmpeqb,
    Vpcmpeqw,
    Vpcmpeqd,
    Vpcmpeqq,
    Vpcmpgtb,
    Vpcmpgtw,
    Vpcmpgtd,
    Vpcmpgtq,
    Vminps,
    Vminpd,
    Vmaxps,
    Vmaxpd,
    Vblendvpd,
    Vblendvps,
    Vpblendvb,
    Vmovlhps,
    Vpmaxsb,
    Vpmaxsw,
    Vpmaxsd,
    Vpminsb,
    Vpminsw,
    Vpminsd,
    Vpmaxub,
    Vpmaxuw,
    Vpmaxud,
    Vpminub,
    Vpminuw,
    Vpminud,
    Vpunpcklbw,
    Vpunpckhbw,
    Vpacksswb,
    Vpackssdw,
    Vpackuswb,
    Vpackusdw,
    Vpalignr,
    Vpinsrb,
    Vpinsrw,
    Vpinsrd,
    Vpinsrq,
    Vpmaddwd,
    Vpmaddubsw,
    Vinsertps,
    Vpshufb,
    Vshufps,
    Vpsllw,
    Vpslld,
    Vpsllq,
    Vpsraw,
    Vpsrad,
    Vpmovsxbw,
    Vpmovzxbw,
    Vpmovsxwd,
    Vpmovzxwd,
    Vpmovsxdq,
    Vpmovzxdq,
    Vaddss,
    Vaddsd,
    Vmulss,
    Vmulsd,
    Vsubss,
    Vsubsd,
    Vdivss,
    Vdivsd,
    Vpabsb,
    Vpabsw,
    Vpabsd,
    Vminss,
    Vminsd,
    Vmaxss,
    Vmaxsd,
    Vsqrtps,
    Vsqrtpd,
    Vroundps,
    Vroundpd,
    Vcvtdq2pd,
    Vcvtdq2ps,
    Vcvtpd2ps,
    Vcvtps2pd,
    Vcvttpd2dq,
    Vcvttps2dq,
    Vphaddw,
    Vphaddd,
    Vpunpckhdq,
    Vpunpckldq,
    Vpunpckhqdq,
    Vpunpcklqdq,
    Vpshuflw,
    Vpshufhw,
    Vpshufd,
    Vmovss,
    Vmovsd,
    Vmovups,
    Vmovupd,
    Vmovdqu,
    Vpextrb,
    Vpextrw,
    Vpextrd,
    Vpextrq,
    Vpblendw,
    Vmovddup,
    Vpbroadcastb,
    Vpbroadcastw,
    Vpbroadcastd,
    Vbroadcastss,
    Vmovd,
    Vmovq,
    Vmovmskps,
    Vmovmskpd,
    Vpmovmskb,
    Vcvtsi2ss,
    Vcvtsi2sd,
    Vcvtss2sd,
    Vcvtsd2ss,
    Vsqrtss,
    Vsqrtsd,
    Vroundss,
    Vroundsd,
    Vucomiss,
    Vucomisd,
    Vptest,
}

/// Internal type Avx512Opcode: defined at src/isa/x64/inst.isle line 1577.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum Avx512Opcode {
    Vcvtudq2ps,
    Vpabsq,
    Vpermi2b,
    Vpmullq,
    Vpopcntb,
    Vpsraq,
    VpsraqImm,
}

/// Internal type RegisterClass: defined at src/isa/x64/inst.isle line 1868.
#[derive(Clone, Debug)]
pub enum RegisterClass {
    Gpr {
        single_register: bool,
    },
    Xmm,
}

/// Internal type ExtendKind: defined at src/isa/x64/inst.isle line 2328.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ExtendKind {
    Sign,
    Zero,
}

/// Internal type ZeroCond: defined at src/isa/x64/inst.isle line 4974.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum ZeroCond {
    Zero,
    NonZero,
}

/// Internal type IcmpCondResult: defined at src/isa/x64/inst.isle line 5092.
#[derive(Clone, Debug)]
pub enum IcmpCondResult {
    Condition {
        producer: ProducesFlags,
        cc: CC,
    },
}

/// Internal type FcmpCondResult: defined at src/isa/x64/inst.isle line 5184.
#[derive(Clone, Debug)]
pub enum FcmpCondResult {
    Condition {
        producer: ProducesFlags,
        cc: CC,
    },
    AndCondition {
        producer: ProducesFlags,
        cc1: CC,
        cc2: CC,
    },
    OrCondition {
        producer: ProducesFlags,
        cc1: CC,
        cc2: CC,
    },
}

/// Internal type AtomicRmwSeqOp: defined at src/isa/x64/inst.isle line 5379.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum AtomicRmwSeqOp {
    And,
    Nand,
    Or,
    Xor,
    Umin,
    Umax,
    Smin,
    Smax,
}

/// Internal type Atomic128RmwSeqOp: defined at src/isa/x64/inst.isle line 5399.
#[derive(Copy, Clone, PartialEq, Eq, Debug)]
pub enum Atomic128RmwSeqOp {
    Add,
    Sub,
    And,
    Nand,
    Or,
    Xor,
    Umin,
    Umax,
    Smin,
    Smax,
}

// Generated as internal constructor for term ty_shift_mask.
pub fn constructor_ty_shift_mask<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> u64 {
    let v1 = C::lane_type(ctx, arg0);
    let v2 = C::ty_bits(ctx, v1);
    let v3 = C::u8_as_u64(ctx, v2);
    let v5 = C::u64_sub(ctx, v3, 0x1_u64);
    // Rule at src/prelude.isle line 470.
    return v5;
}

// Generated as internal constructor for term output_reg.
pub fn constructor_output_reg<C: Context>(
    ctx: &mut C,
    arg0: Reg,
) -> InstOutput {
    let v1 = C::value_reg(ctx, arg0);
    let v2 = C::output(ctx, v1);
    // Rule at src/prelude_lower.isle line 85.
    return v2;
}

// Generated as internal constructor for term output_value.
pub fn constructor_output_value<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> InstOutput {
    let v1 = C::put_in_regs(ctx, arg0);
    let v2 = C::output(ctx, v1);
    // Rule at src/prelude_lower.isle line 89.
    return v2;
}

// Generated as internal constructor for term temp_reg.
pub fn constructor_temp_reg<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> Reg {
    let v1 = C::temp_writable_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/prelude_lower.isle line 109.
    return v2;
}

// Generated as internal constructor for term value_regs_range.
pub fn constructor_value_regs_range<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
) -> Range {
    let v2 = C::value_regs_len(ctx, arg0);
    let v3 = C::range(ctx, 0x0_usize, v2);
    // Rule at src/prelude_lower.isle line 163.
    return v3;
}

// Generated as internal constructor for term lo_reg.
pub fn constructor_lo_reg<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> Reg {
    let v1 = C::put_in_regs(ctx, arg0);
    let v3 = C::value_regs_get(ctx, v1, 0x0_usize);
    // Rule at src/prelude_lower.isle line 174.
    return v3;
}

// Generated as internal constructor for term multi_reg_to_pair_and_single.
pub fn constructor_multi_reg_to_pair_and_single<C: Context>(
    ctx: &mut C,
    arg0: &MultiReg,
) -> InstOutput {
    if let &MultiReg::Three {
        a: v1,
        b: v2,
        c: v3,
    } = arg0 {
        let v4 = C::value_regs(ctx, v1, v2);
        let v5 = C::value_reg(ctx, v3);
        let v6 = C::output_pair(ctx, v4, v5);
        // Rule at src/prelude_lower.isle line 185.
        return v6;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "multi_reg_to_pair_and_single", "src/prelude_lower.isle line 184")
}

// Generated as internal constructor for term multi_reg_to_pair.
pub fn constructor_multi_reg_to_pair<C: Context>(
    ctx: &mut C,
    arg0: &MultiReg,
) -> InstOutput {
    if let &MultiReg::Two {
        a: v1,
        b: v2,
    } = arg0 {
        let v3 = C::value_regs(ctx, v1, v2);
        let v4 = C::output(ctx, v3);
        // Rule at src/prelude_lower.isle line 190.
        return v4;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "multi_reg_to_pair", "src/prelude_lower.isle line 189")
}

// Generated as internal constructor for term multi_reg_to_single.
pub fn constructor_multi_reg_to_single<C: Context>(
    ctx: &mut C,
    arg0: &MultiReg,
) -> InstOutput {
    if let &MultiReg::One {
        a: v1,
    } = arg0 {
        let v2 = C::value_reg(ctx, v1);
        let v3 = C::output(ctx, v2);
        // Rule at src/prelude_lower.isle line 195.
        return v3;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "multi_reg_to_single", "src/prelude_lower.isle line 194")
}

// Generated as internal constructor for term emit_side_effect.
pub fn constructor_emit_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> Unit {
    match arg0 {
        &SideEffectNoResult::Inst {
            inst: ref v1,
        } => {
            let v2 = C::emit(ctx, v1);
            // Rule at src/prelude_lower.isle line 412.
            return v2;
        }
        &SideEffectNoResult::Inst2 {
            inst1: ref v3,
            inst2: ref v4,
        } => {
            let v5 = C::emit(ctx, v3);
            let v6 = C::emit(ctx, v4);
            // Rule at src/prelude_lower.isle line 414.
            return v6;
        }
        &SideEffectNoResult::Inst3 {
            inst1: ref v7,
            inst2: ref v8,
            inst3: ref v9,
        } => {
            let v10 = C::emit(ctx, v7);
            let v11 = C::emit(ctx, v8);
            let v12 = C::emit(ctx, v9);
            // Rule at src/prelude_lower.isle line 417.
            return v12;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "emit_side_effect", "src/prelude_lower.isle line 411")
}

// Generated as internal constructor for term side_effect.
pub fn constructor_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
) -> InstOutput {
    let v1 = constructor_emit_side_effect(ctx, arg0);
    let v2 = C::output_none(ctx);
    // Rule at src/prelude_lower.isle line 427.
    return v2;
}

// Generated as internal constructor for term side_effect_concat.
pub fn constructor_side_effect_concat<C: Context>(
    ctx: &mut C,
    arg0: &SideEffectNoResult,
    arg1: &SideEffectNoResult,
) -> SideEffectNoResult {
    match arg0 {
        &SideEffectNoResult::Inst {
            inst: ref v1,
        } => {
            match arg1 {
                &SideEffectNoResult::Inst {
                    inst: ref v3,
                } => {
                    let v4 = SideEffectNoResult::Inst2 {
                        inst1: v1.clone(),
                        inst2: v3.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 432.
                    return v4;
                }
                &SideEffectNoResult::Inst2 {
                    inst1: ref v5,
                    inst2: ref v6,
                } => {
                    let v7 = SideEffectNoResult::Inst3 {
                        inst1: v1.clone(),
                        inst2: v5.clone(),
                        inst3: v6.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 434.
                    return v7;
                }
                _ => {}
            }
        }
        &SideEffectNoResult::Inst2 {
            inst1: ref v8,
            inst2: ref v9,
        } => {
            if let &SideEffectNoResult::Inst {
                inst: ref v3,
            } = arg1 {
                let v10 = SideEffectNoResult::Inst3 {
                    inst1: v8.clone(),
                    inst2: v9.clone(),
                    inst3: v3.clone(),
                };
                // Rule at src/prelude_lower.isle line 436.
                return v10;
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "side_effect_concat", "src/prelude_lower.isle line 431")
}

// Generated as internal constructor for term produces_flags_concat.
pub fn constructor_produces_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ProducesFlags,
) -> ProducesFlags {
    if let &ProducesFlags::ProducesFlagsSideEffect {
        inst: ref v1,
    } = arg0 {
        if let &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref v3,
        } = arg1 {
            let v4 = ProducesFlags::ProducesFlagsTwiceSideEffect {
                inst1: v1.clone(),
                inst2: v3.clone(),
            };
            // Rule at src/prelude_lower.isle line 461.
            return v4;
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "produces_flags_concat", "src/prelude_lower.isle line 460")
}

// Generated as internal constructor for term produces_flags_get_reg.
pub fn constructor_produces_flags_get_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> Reg {
    match arg0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            // Rule at src/prelude_lower.isle line 491.
            return v2;
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v3,
            result: v4,
        } => {
            // Rule at src/prelude_lower.isle line 492.
            return v4;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "produces_flags_get_reg", "src/prelude_lower.isle line 490")
}

// Generated as internal constructor for term produces_flags_ignore.
pub fn constructor_produces_flags_ignore<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
) -> ProducesFlags {
    match arg0 {
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            let v3 = ProducesFlags::ProducesFlagsSideEffect {
                inst: v1.clone(),
            };
            // Rule at src/prelude_lower.isle line 497.
            return v3;
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v4,
            result: v5,
        } => {
            let v6 = ProducesFlags::ProducesFlagsSideEffect {
                inst: v4.clone(),
            };
            // Rule at src/prelude_lower.isle line 499.
            return v6;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "produces_flags_ignore", "src/prelude_lower.isle line 496")
}

// Generated as internal constructor for term consumes_flags_concat.
pub fn constructor_consumes_flags_concat<C: Context>(
    ctx: &mut C,
    arg0: &ConsumesFlags,
    arg1: &ConsumesFlags,
) -> ConsumesFlags {
    match arg0 {
        &ConsumesFlags::ConsumesFlagsSideEffect {
            inst: ref v8,
        } => {
            if let &ConsumesFlags::ConsumesFlagsSideEffect {
                inst: ref v9,
            } = arg1 {
                let v10 = ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: v8.clone(),
                    inst2: v9.clone(),
                };
                // Rule at src/prelude_lower.isle line 512.
                return v10;
            }
        }
        &ConsumesFlags::ConsumesFlagsReturnsReg {
            inst: ref v1,
            result: v2,
        } => {
            if let &ConsumesFlags::ConsumesFlagsReturnsReg {
                inst: ref v4,
                result: v5,
            } = arg1 {
                let v6 = C::value_regs(ctx, v2, v5);
                let v7 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: v1.clone(),
                    inst2: v4.clone(),
                    result: v6,
                };
                // Rule at src/prelude_lower.isle line 506.
                return v7;
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "consumes_flags_concat", "src/prelude_lower.isle line 505")
}

// Generated as internal constructor for term with_flags.
pub fn constructor_with_flags<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> ValueRegs {
    match arg0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref v12,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref v13,
                    result: v14,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v16 = C::emit(ctx, v13);
                    let v17 = C::value_reg(ctx, v14);
                    // Rule at src/prelude_lower.isle line 543.
                    return v17;
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref v18,
                    inst2: ref v19,
                    result: v20,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v21 = C::emit(ctx, v18);
                    let v22 = C::emit(ctx, v19);
                    // Rule at src/prelude_lower.isle line 549.
                    return v20;
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref v23,
                    inst2: ref v24,
                    inst3: ref v25,
                    inst4: ref v26,
                    result: v27,
                } => {
                    let v15 = C::emit(ctx, v12);
                    let v28 = C::emit(ctx, v23);
                    let v29 = C::emit(ctx, v24);
                    let v30 = C::emit(ctx, v25);
                    let v31 = C::emit(ctx, v26);
                    // Rule at src/prelude_lower.isle line 561.
                    return v27;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsTwiceSideEffect {
            inst1: ref v32,
            inst2: ref v33,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsReturnsReg {
                    inst: ref v13,
                    result: v14,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v36 = C::emit(ctx, v13);
                    let v37 = C::value_reg(ctx, v14);
                    // Rule at src/prelude_lower.isle line 577.
                    return v37;
                }
                &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                    inst1: ref v18,
                    inst2: ref v19,
                    result: v20,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v38 = C::emit(ctx, v18);
                    let v39 = C::emit(ctx, v19);
                    // Rule at src/prelude_lower.isle line 584.
                    return v20;
                }
                &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                    inst1: ref v23,
                    inst2: ref v24,
                    inst3: ref v25,
                    inst4: ref v26,
                    result: v27,
                } => {
                    let v34 = C::emit(ctx, v32);
                    let v35 = C::emit(ctx, v33);
                    let v40 = C::emit(ctx, v23);
                    let v41 = C::emit(ctx, v24);
                    let v42 = C::emit(ctx, v25);
                    let v43 = C::emit(ctx, v26);
                    // Rule at src/prelude_lower.isle line 597.
                    return v27;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v1,
            result: v2,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect {
                    inst: ref v9,
                } => {
                    let v6 = C::emit(ctx, v1);
                    let v10 = C::emit(ctx, v9);
                    let v11 = C::value_reg(ctx, v2);
                    // Rule at src/prelude_lower.isle line 537.
                    return v11;
                }
                &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                    inst: ref v4,
                    result: v5,
                } => {
                    let v6 = C::emit(ctx, v1);
                    let v7 = C::emit(ctx, v4);
                    let v8 = C::value_regs(ctx, v2, v5);
                    // Rule at src/prelude_lower.isle line 529.
                    return v8;
                }
                _ => {}
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "with_flags", "src/prelude_lower.isle line 527")
}

// Generated as internal constructor for term with_flags_reg.
pub fn constructor_with_flags_reg<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> Reg {
    let v2 = constructor_with_flags(ctx, arg0, arg1);
    let v4 = C::value_regs_get(ctx, v2, 0x0_usize);
    // Rule at src/prelude_lower.isle line 615.
    return v4;
}

// Generated as internal constructor for term flags_to_producesflags.
pub fn constructor_flags_to_producesflags<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> ProducesFlags {
    let v1 = C::mark_value_used(ctx, arg0);
    // Rule at src/prelude_lower.isle line 622.
    return ProducesFlags::AlreadyExistingFlags;
}

// Generated as internal constructor for term with_flags_side_effect.
pub fn constructor_with_flags_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesFlags,
) -> SideEffectNoResult {
    match arg0 {
        &ProducesFlags::AlreadyExistingFlags => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect {
                    inst: ref v2,
                } => {
                    let v3 = SideEffectNoResult::Inst {
                        inst: v2.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 633.
                    return v3;
                }
                &ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: ref v4,
                    inst2: ref v5,
                } => {
                    let v6 = SideEffectNoResult::Inst2 {
                        inst1: v4.clone(),
                        inst2: v5.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 638.
                    return v6;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref v7,
        } => {
            match arg1 {
                &ConsumesFlags::ConsumesFlagsSideEffect {
                    inst: ref v2,
                } => {
                    let v8 = SideEffectNoResult::Inst2 {
                        inst1: v7.clone(),
                        inst2: v2.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 643.
                    return v8;
                }
                &ConsumesFlags::ConsumesFlagsSideEffect2 {
                    inst1: ref v4,
                    inst2: ref v5,
                } => {
                    let v9 = SideEffectNoResult::Inst3 {
                        inst1: v7.clone(),
                        inst2: v4.clone(),
                        inst3: v5.clone(),
                    };
                    // Rule at src/prelude_lower.isle line 648.
                    return v9;
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsTwiceSideEffect {
            inst1: ref v10,
            inst2: ref v11,
        } => {
            if let &ConsumesFlags::ConsumesFlagsSideEffect {
                inst: ref v2,
            } = arg1 {
                let v12 = SideEffectNoResult::Inst3 {
                    inst1: v10.clone(),
                    inst2: v11.clone(),
                    inst3: v2.clone(),
                };
                // Rule at src/prelude_lower.isle line 653.
                return v12;
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "with_flags_side_effect", "src/prelude_lower.isle line 631")
}

// Generated as internal constructor for term with_flags_chained.
pub fn constructor_with_flags_chained<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &ConsumesAndProducesFlags,
    arg2: &ConsumesFlags,
) -> MultiReg {
    match arg0 {
        &ProducesFlags::ProducesFlagsSideEffect {
            inst: ref v1,
        } => {
            match arg1 {
                &ConsumesAndProducesFlags::SideEffect {
                    inst: ref v3,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect {
                            inst: ref v5,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v8 = C::emit(ctx, v5);
                            // Rule at src/prelude_lower.isle line 662.
                            return MultiReg::Empty;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            // Rule at src/prelude_lower.isle line 670.
                            return MultiReg::Empty;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v16 = C::emit(ctx, v14);
                            let v17 = MultiReg::One {
                                a: v15,
                            };
                            // Rule at src/prelude_lower.isle line 679.
                            return v17;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0_usize);
                            let v26 = C::value_regs_get(ctx, v20, 0x1_usize);
                            let v27 = MultiReg::Two {
                                a: v24,
                                b: v26,
                            };
                            // Rule at src/prelude_lower.isle line 687.
                            return v27;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v7 = C::emit(ctx, v3);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0_usize);
                            let v38 = C::value_regs_get(ctx, v32, 0x1_usize);
                            let v39 = MultiReg::Two {
                                a: v37,
                                b: v38,
                            };
                            // Rule at src/prelude_lower.isle line 696.
                            return v39;
                        }
                        _ => {}
                    }
                }
                &ConsumesAndProducesFlags::ReturnsReg {
                    inst: ref v47,
                    result: v48,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect {
                            inst: ref v5,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v8 = C::emit(ctx, v5);
                            let v50 = MultiReg::One {
                                a: v48,
                            };
                            // Rule at src/prelude_lower.isle line 756.
                            return v50;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v50 = MultiReg::One {
                                a: v48,
                            };
                            // Rule at src/prelude_lower.isle line 764.
                            return v50;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v16 = C::emit(ctx, v14);
                            let v51 = MultiReg::Two {
                                a: v48,
                                b: v15,
                            };
                            // Rule at src/prelude_lower.isle line 773.
                            return v51;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0_usize);
                            let v26 = C::value_regs_get(ctx, v20, 0x1_usize);
                            let v52 = MultiReg::Three {
                                a: v48,
                                b: v24,
                                c: v26,
                            };
                            // Rule at src/prelude_lower.isle line 781.
                            return v52;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v6 = C::emit(ctx, v1);
                            let v49 = C::emit(ctx, v47);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0_usize);
                            let v38 = C::value_regs_get(ctx, v32, 0x1_usize);
                            let v53 = MultiReg::Three {
                                a: v48,
                                b: v37,
                                c: v38,
                            };
                            // Rule at src/prelude_lower.isle line 790.
                            return v53;
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsReg {
            inst: ref v40,
            result: v41,
        } => {
            match arg1 {
                &ConsumesAndProducesFlags::SideEffect {
                    inst: ref v3,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect {
                            inst: ref v5,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v8 = C::emit(ctx, v5);
                            let v43 = MultiReg::One {
                                a: v41,
                            };
                            // Rule at src/prelude_lower.isle line 709.
                            return v43;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v43 = MultiReg::One {
                                a: v41,
                            };
                            // Rule at src/prelude_lower.isle line 717.
                            return v43;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v16 = C::emit(ctx, v14);
                            let v44 = MultiReg::Two {
                                a: v41,
                                b: v15,
                            };
                            // Rule at src/prelude_lower.isle line 726.
                            return v44;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0_usize);
                            let v26 = C::value_regs_get(ctx, v20, 0x1_usize);
                            let v45 = MultiReg::Three {
                                a: v41,
                                b: v24,
                                c: v26,
                            };
                            // Rule at src/prelude_lower.isle line 734.
                            return v45;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v7 = C::emit(ctx, v3);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0_usize);
                            let v38 = C::value_regs_get(ctx, v32, 0x1_usize);
                            let v46 = MultiReg::Three {
                                a: v41,
                                b: v37,
                                c: v38,
                            };
                            // Rule at src/prelude_lower.isle line 743.
                            return v46;
                        }
                        _ => {}
                    }
                }
                &ConsumesAndProducesFlags::ReturnsReg {
                    inst: ref v47,
                    result: v48,
                } => {
                    match arg2 {
                        &ConsumesFlags::ConsumesFlagsSideEffect {
                            inst: ref v5,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v8 = C::emit(ctx, v5);
                            let v54 = MultiReg::Two {
                                a: v41,
                                b: v48,
                            };
                            // Rule at src/prelude_lower.isle line 803.
                            return v54;
                        }
                        &ConsumesFlags::ConsumesFlagsSideEffect2 {
                            inst1: ref v10,
                            inst2: ref v11,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v12 = C::emit(ctx, v10);
                            let v13 = C::emit(ctx, v11);
                            let v54 = MultiReg::Two {
                                a: v41,
                                b: v48,
                            };
                            // Rule at src/prelude_lower.isle line 811.
                            return v54;
                        }
                        &ConsumesFlags::ConsumesFlagsReturnsReg {
                            inst: ref v14,
                            result: v15,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v16 = C::emit(ctx, v14);
                            let v55 = MultiReg::Three {
                                a: v41,
                                b: v48,
                                c: v15,
                            };
                            // Rule at src/prelude_lower.isle line 820.
                            return v55;
                        }
                        &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                            inst1: ref v18,
                            inst2: ref v19,
                            result: v20,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v21 = C::emit(ctx, v18);
                            let v22 = C::emit(ctx, v19);
                            let v24 = C::value_regs_get(ctx, v20, 0x0_usize);
                            let v26 = C::value_regs_get(ctx, v20, 0x1_usize);
                            let v56 = MultiReg::Four {
                                a: v41,
                                b: v48,
                                c: v24,
                                d: v26,
                            };
                            // Rule at src/prelude_lower.isle line 828.
                            return v56;
                        }
                        &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                            inst1: ref v28,
                            inst2: ref v29,
                            inst3: ref v30,
                            inst4: ref v31,
                            result: v32,
                        } => {
                            let v42 = C::emit(ctx, v40);
                            let v49 = C::emit(ctx, v47);
                            let v33 = C::emit(ctx, v28);
                            let v34 = C::emit(ctx, v29);
                            let v35 = C::emit(ctx, v30);
                            let v36 = C::emit(ctx, v31);
                            let v37 = C::value_regs_get(ctx, v32, 0x0_usize);
                            let v38 = C::value_regs_get(ctx, v32, 0x1_usize);
                            let v57 = MultiReg::Four {
                                a: v41,
                                b: v48,
                                c: v37,
                                d: v38,
                            };
                            // Rule at src/prelude_lower.isle line 837.
                            return v57;
                        }
                        _ => {}
                    }
                }
                _ => {}
            }
        }
        &ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: ref v58,
            result: v59,
        } => {
            if let &ConsumesAndProducesFlags::ReturnsReg {
                inst: ref v47,
                result: v48,
            } = arg1 {
                match arg2 {
                    &ConsumesFlags::ConsumesFlagsSideEffect {
                        inst: ref v5,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v8 = C::emit(ctx, v5);
                        let v61 = MultiReg::Two {
                            a: v59,
                            b: v48,
                        };
                        // Rule at src/prelude_lower.isle line 849.
                        return v61;
                    }
                    &ConsumesFlags::ConsumesFlagsSideEffect2 {
                        inst1: ref v10,
                        inst2: ref v11,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v12 = C::emit(ctx, v10);
                        let v13 = C::emit(ctx, v11);
                        let v61 = MultiReg::Two {
                            a: v59,
                            b: v48,
                        };
                        // Rule at src/prelude_lower.isle line 857.
                        return v61;
                    }
                    &ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
                        inst: ref v63,
                        result: v64,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v65 = C::emit(ctx, v63);
                        let v66 = MultiReg::Three {
                            a: v59,
                            b: v48,
                            c: v64,
                        };
                        // Rule at src/prelude_lower.isle line 874.
                        return v66;
                    }
                    &ConsumesFlags::ConsumesFlagsReturnsReg {
                        inst: ref v14,
                        result: v15,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v16 = C::emit(ctx, v14);
                        let v62 = MultiReg::Three {
                            a: v59,
                            b: v48,
                            c: v15,
                        };
                        // Rule at src/prelude_lower.isle line 866.
                        return v62;
                    }
                    &ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                        inst1: ref v18,
                        inst2: ref v19,
                        result: v20,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v21 = C::emit(ctx, v18);
                        let v22 = C::emit(ctx, v19);
                        let v24 = C::value_regs_get(ctx, v20, 0x0_usize);
                        let v26 = C::value_regs_get(ctx, v20, 0x1_usize);
                        let v67 = MultiReg::Four {
                            a: v59,
                            b: v48,
                            c: v24,
                            d: v26,
                        };
                        // Rule at src/prelude_lower.isle line 882.
                        return v67;
                    }
                    &ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                        inst1: ref v28,
                        inst2: ref v29,
                        inst3: ref v30,
                        inst4: ref v31,
                        result: v32,
                    } => {
                        let v60 = C::emit(ctx, v58);
                        let v49 = C::emit(ctx, v47);
                        let v33 = C::emit(ctx, v28);
                        let v34 = C::emit(ctx, v29);
                        let v35 = C::emit(ctx, v30);
                        let v36 = C::emit(ctx, v31);
                        let v37 = C::value_regs_get(ctx, v32, 0x0_usize);
                        let v38 = C::value_regs_get(ctx, v32, 0x1_usize);
                        let v68 = MultiReg::Four {
                            a: v59,
                            b: v48,
                            c: v37,
                            d: v38,
                        };
                        // Rule at src/prelude_lower.isle line 891.
                        return v68;
                    }
                    _ => {}
                }
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "with_flags_chained", "src/prelude_lower.isle line 659")
}

// Generated as internal constructor for term lower_return.
pub fn constructor_lower_return<C: Context>(
    ctx: &mut C,
    arg0: ValueSlice,
) -> InstOutput {
    let v1 = C::gen_return(ctx, arg0);
    let v2 = C::output_none(ctx);
    // Rule at src/prelude_lower.isle line 1094.
    return v2;
}

// Generated as internal constructor for term operand_size_bits.
pub fn constructor_operand_size_bits<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
) -> u16 {
    match arg0 {
        &OperandSize::Size8 => {
            // Rule at src/isa/x64/inst.isle line 851.
            return 0x8_u16;
        }
        &OperandSize::Size16 => {
            // Rule at src/isa/x64/inst.isle line 852.
            return 0x10_u16;
        }
        &OperandSize::Size32 => {
            // Rule at src/isa/x64/inst.isle line 853.
            return 0x20_u16;
        }
        &OperandSize::Size64 => {
            // Rule at src/isa/x64/inst.isle line 854.
            return 0x40_u16;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "operand_size_bits", "src/isa/x64/inst.isle line 850")
}

// Generated as internal constructor for term reg_mem_to_reg_mem_imm.
pub fn constructor_reg_mem_to_reg_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &RegMem,
) -> RegMemImm {
    match arg0 {
        &RegMem::Reg {
            reg: v1,
        } => {
            let v2 = RegMemImm::Reg {
                reg: v1,
            };
            // Rule at src/isa/x64/inst.isle line 1105.
            return v2;
        }
        &RegMem::Mem {
            addr: ref v3,
        } => {
            let v4 = RegMemImm::Mem {
                addr: v3.clone(),
            };
            // Rule at src/isa/x64/inst.isle line 1107.
            return v4;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "reg_mem_to_reg_mem_imm", "src/isa/x64/inst.isle line 1104")
}

// Generated as internal constructor for term to_amode.
pub fn constructor_to_amode<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Amode {
    let v4 = C::def_inst(ctx, arg1);
    if let Some(v5) = v4 {
        let v6 = &C::inst_data(ctx, v5);
        if let &InstructionData::Binary {
            opcode: ref v7,
            args: ref v8,
        } = v6 {
            if let &Opcode::Iadd = v7 {
                let v9 = C::unpack_value_array_2(ctx, v8);
                let v12 = &constructor_to_amode_add(ctx, arg0, v9.0, v9.1, arg2);
                // Rule at src/isa/x64/inst.isle line 1224.
                return v12.clone();
            }
        }
    }
    let v3 = &constructor_amode_imm_reg(ctx, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 1222.
    return v3.clone();
}

// Generated as internal constructor for term to_amode_add.
pub fn constructor_to_amode_add<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Amode {
    let v38 = C::def_inst(ctx, arg2);
    if let Some(v39) = v38 {
        let v40 = &C::inst_data(ctx, v39);
        if let &InstructionData::Binary {
            opcode: ref v41,
            args: ref v42,
        } = v40 {
            if let &Opcode::Iadd = v41 {
                let v43 = C::unpack_value_array_2(ctx, v42);
                let v52 = C::i32_from_iconst(ctx, v43.0);
                if let Some(v53) = v52 {
                    let v7 = C::offset32_to_i32(ctx, arg3);
                    let v54 = C::s32_add_fallible(ctx, v7, v53);
                    if let Some(v55) = v54 {
                        let v56 = C::i32_to_offset32(ctx, v55);
                        let v57 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, arg1, v43.1, v56);
                        // Rule at src/isa/x64/inst.isle line 1262.
                        return v57.clone();
                    }
                }
                let v46 = C::i32_from_iconst(ctx, v43.1);
                if let Some(v47) = v46 {
                    let v7 = C::offset32_to_i32(ctx, arg3);
                    let v48 = C::s32_add_fallible(ctx, v7, v47);
                    if let Some(v49) = v48 {
                        let v50 = C::i32_to_offset32(ctx, v49);
                        let v51 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, arg1, v43.0, v50);
                        // Rule at src/isa/x64/inst.isle line 1259.
                        return v51.clone();
                    }
                }
            }
        }
    }
    let v18 = C::def_inst(ctx, arg1);
    if let Some(v19) = v18 {
        let v20 = &C::inst_data(ctx, v19);
        if let &InstructionData::Binary {
            opcode: ref v21,
            args: ref v22,
        } = v20 {
            if let &Opcode::Iadd = v21 {
                let v23 = C::unpack_value_array_2(ctx, v22);
                let v32 = C::i32_from_iconst(ctx, v23.0);
                if let Some(v33) = v32 {
                    let v7 = C::offset32_to_i32(ctx, arg3);
                    let v34 = C::s32_add_fallible(ctx, v7, v33);
                    if let Some(v35) = v34 {
                        let v36 = C::i32_to_offset32(ctx, v35);
                        let v37 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, v23.1, arg2, v36);
                        // Rule at src/isa/x64/inst.isle line 1256.
                        return v37.clone();
                    }
                }
                let v26 = C::i32_from_iconst(ctx, v23.1);
                if let Some(v27) = v26 {
                    let v7 = C::offset32_to_i32(ctx, arg3);
                    let v28 = C::s32_add_fallible(ctx, v7, v27);
                    if let Some(v29) = v28 {
                        let v30 = C::i32_to_offset32(ctx, v29);
                        let v31 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, v23.0, arg2, v30);
                        // Rule at src/isa/x64/inst.isle line 1253.
                        return v31.clone();
                    }
                }
            }
        }
    }
    let v12 = C::i32_from_iconst(ctx, arg1);
    if let Some(v13) = v12 {
        let v7 = C::offset32_to_i32(ctx, arg3);
        let v14 = C::s32_add_fallible(ctx, v7, v13);
        if let Some(v15) = v14 {
            let v16 = C::i32_to_offset32(ctx, v15);
            let v17 = &constructor_amode_imm_reg(ctx, arg0, arg2, v16);
            // Rule at src/isa/x64/inst.isle line 1250.
            return v17.clone();
        }
    }
    let v5 = C::i32_from_iconst(ctx, arg2);
    if let Some(v6) = v5 {
        let v7 = C::offset32_to_i32(ctx, arg3);
        let v8 = C::s32_add_fallible(ctx, v7, v6);
        if let Some(v9) = v8 {
            let v10 = C::i32_to_offset32(ctx, v9);
            let v11 = &constructor_amode_imm_reg(ctx, arg0, arg1, v10);
            // Rule at src/isa/x64/inst.isle line 1247.
            return v11.clone();
        }
    }
    let v4 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, arg1, arg2, arg3);
    // Rule at src/isa/x64/inst.isle line 1245.
    return v4.clone();
}

// Generated as internal constructor for term amode_imm_reg.
pub fn constructor_amode_imm_reg<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Offset32,
) -> Amode {
    let v6 = C::def_inst(ctx, arg1);
    if let Some(v7) = v6 {
        let v8 = &C::inst_data(ctx, v7);
        if let &InstructionData::Binary {
            opcode: ref v9,
            args: ref v10,
        } = v8 {
            if let &Opcode::Iadd = v9 {
                let v11 = C::unpack_value_array_2(ctx, v10);
                let v14 = &constructor_amode_imm_reg_reg_shift(ctx, arg0, v11.0, v11.1, arg2);
                // Rule at src/isa/x64/inst.isle line 1276.
                return v14.clone();
            }
        }
    }
    let v4 = C::put_in_reg(ctx, arg1);
    let v3 = C::offset32_to_i32(ctx, arg2);
    let v5 = Amode::ImmReg {
        simm32: v3,
        base: v4,
        flags: arg0,
    };
    // Rule at src/isa/x64/inst.isle line 1274.
    return v5;
}

// Generated as internal constructor for term amode_imm_reg_reg_shift.
pub fn constructor_amode_imm_reg_reg_shift<C: Context>(
    ctx: &mut C,
    arg0: MemFlags,
    arg1: Value,
    arg2: Value,
    arg3: Offset32,
) -> Amode {
    let v30 = C::def_inst(ctx, arg1);
    if let Some(v31) = v30 {
        let v32 = &C::inst_data(ctx, v31);
        if let &InstructionData::Binary {
            opcode: ref v33,
            args: ref v34,
        } = v32 {
            if let &Opcode::Ishl = v33 {
                let v35 = C::unpack_value_array_2(ctx, v34);
                let v38 = C::def_inst(ctx, v35.1);
                if let Some(v39) = v38 {
                    let v40 = &C::inst_data(ctx, v39);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v41,
                        imm: v42,
                    } = v40 {
                        if let &Opcode::Iconst = v41 {
                            let v43 = C::uimm8(ctx, v42);
                            if let Some(v44) = v43 {
                                let v45 = C::u8_as_u32(ctx, v44);
                                let v46 = C::u32_lteq(ctx, v45, 0x3_u32);
                                if let Some(v47) = v46 {
                                    let v48 = constructor_put_in_gpr(ctx, arg2);
                                    let v49 = constructor_put_in_gpr(ctx, v35.0);
                                    let v4 = C::offset32_to_i32(ctx, arg3);
                                    let v50 = Amode::ImmRegRegShift {
                                        simm32: v4,
                                        base: v48,
                                        index: v49,
                                        shift: v44,
                                        flags: arg0,
                                    };
                                    // Rule at src/isa/x64/inst.isle line 1293.
                                    return v50;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    let v9 = C::def_inst(ctx, arg2);
    if let Some(v10) = v9 {
        let v11 = &C::inst_data(ctx, v10);
        if let &InstructionData::Binary {
            opcode: ref v12,
            args: ref v13,
        } = v11 {
            if let &Opcode::Ishl = v12 {
                let v14 = C::unpack_value_array_2(ctx, v13);
                let v17 = C::def_inst(ctx, v14.1);
                if let Some(v18) = v17 {
                    let v19 = &C::inst_data(ctx, v18);
                    if let &InstructionData::UnaryImm {
                        opcode: ref v20,
                        imm: v21,
                    } = v19 {
                        if let &Opcode::Iconst = v20 {
                            let v22 = C::uimm8(ctx, v21);
                            if let Some(v23) = v22 {
                                let v24 = C::u8_as_u32(ctx, v23);
                                let v26 = C::u32_lteq(ctx, v24, 0x3_u32);
                                if let Some(v27) = v26 {
                                    let v5 = constructor_put_in_gpr(ctx, arg1);
                                    let v28 = constructor_put_in_gpr(ctx, v14.0);
                                    let v4 = C::offset32_to_i32(ctx, arg3);
                                    let v29 = Amode::ImmRegRegShift {
                                        simm32: v4,
                                        base: v5,
                                        index: v28,
                                        shift: v23,
                                        flags: arg0,
                                    };
                                    // Rule at src/isa/x64/inst.isle line 1290.
                                    return v29;
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    let v5 = constructor_put_in_gpr(ctx, arg1);
    let v6 = constructor_put_in_gpr(ctx, arg2);
    let v4 = C::offset32_to_i32(ctx, arg3);
    let v8 = Amode::ImmRegRegShift {
        simm32: v4,
        base: v5,
        index: v6,
        shift: 0x0_u8,
        flags: arg0,
    };
    // Rule at src/isa/x64/inst.isle line 1288.
    return v8;
}

// Generated as internal constructor for term put_masked_in_imm8_gpr.
pub fn constructor_put_masked_in_imm8_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
) -> Imm8Gpr {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        if let &InstructionData::UnaryImm {
            opcode: ref v4,
            imm: v5,
        } = v3 {
            if let &Opcode::Iconst = v4 {
                let v6 = C::u64_from_imm64(ctx, v5);
                let v8 = &C::const_to_type_masked_imm8(ctx, v6, arg1);
                // Rule at src/isa/x64/inst.isle line 1330.
                return v8.clone();
            }
        }
    }
    let v9 = C::fits_in_16(ctx, arg1);
    if let Some(v10) = v9 {
        let v12 = C::put_in_regs(ctx, arg0);
        let v14 = constructor_value_regs_get_gpr(ctx, v12, 0x0_usize);
        let v15 = C::shift_mask(ctx, v10);
        let v16 = C::u8_as_u32(ctx, v15);
        let v17 = RegMemImm::Imm {
            simm32: v16,
        };
        let v18 = &C::gpr_mem_imm_new(ctx, &v17);
        let v19 = constructor_x64_and(ctx, I64, v14, v18);
        let v20 = &C::gpr_to_imm8_gpr(ctx, v19);
        // Rule at src/isa/x64/inst.isle line 1332.
        return v20.clone();
    }
    let v12 = C::put_in_regs(ctx, arg0);
    let v14 = constructor_value_regs_get_gpr(ctx, v12, 0x0_usize);
    let v21 = &C::gpr_to_imm8_gpr(ctx, v14);
    // Rule at src/isa/x64/inst.isle line 1334.
    return v21.clone();
}

// Generated as internal constructor for term reg_to_gpr_mem_imm.
pub fn constructor_reg_to_gpr_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: Reg,
) -> GprMemImm {
    let v1 = C::gpr_new(ctx, arg0);
    let v2 = &C::gpr_to_gpr_mem_imm(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1770.
    return v2.clone();
}

// Generated as internal constructor for term put_in_gpr.
pub fn constructor_put_in_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> Gpr {
    let v1 = C::value_type(ctx, arg0);
    let v2 = &C::type_register_class(ctx, v1);
    if let Some(v3) = v2 {
        match v3 {
            &RegisterClass::Gpr {
                single_register: v4,
            } => {
                let v5 = C::put_in_reg(ctx, arg0);
                let v6 = C::gpr_new(ctx, v5);
                // Rule at src/isa/x64/inst.isle line 1781.
                return v6;
            }
            &RegisterClass::Xmm => {
                let v5 = C::put_in_reg(ctx, arg0);
                let v8 = C::xmm_new(ctx, v5);
                let v7 = C::ty_bits(ctx, v1);
                let v9 = constructor_bitcast_xmm_to_gpr(ctx, v7, v8);
                // Rule at src/isa/x64/inst.isle line 1788.
                return v9;
            }
            _ => {}
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "put_in_gpr", "src/isa/x64/inst.isle line 1778")
}

// Generated as internal constructor for term put_in_gpr_mem.
pub fn constructor_put_in_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> GprMem {
    let v1 = &C::put_in_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1797.
    return v2.clone();
}

// Generated as internal constructor for term put_in_gpr_mem_imm.
pub fn constructor_put_in_gpr_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> GprMemImm {
    let v1 = &C::put_in_reg_mem_imm(ctx, arg0);
    let v2 = &C::gpr_mem_imm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1804.
    return v2.clone();
}

// Generated as internal constructor for term put_in_xmm.
pub fn constructor_put_in_xmm<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> Xmm {
    let v1 = C::put_in_reg(ctx, arg0);
    let v2 = C::xmm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1811.
    return v2;
}

// Generated as internal constructor for term output_gpr.
pub fn constructor_output_gpr<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
) -> InstOutput {
    let v1 = C::gpr_to_reg(ctx, arg0);
    let v2 = constructor_output_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1830.
    return v2;
}

// Generated as internal constructor for term value_gprs.
pub fn constructor_value_gprs<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
) -> ValueRegs {
    let v2 = C::gpr_to_reg(ctx, arg0);
    let v3 = C::gpr_to_reg(ctx, arg1);
    let v4 = C::value_regs(ctx, v2, v3);
    // Rule at src/isa/x64/inst.isle line 1835.
    return v4;
}

// Generated as internal constructor for term output_xmm.
pub fn constructor_output_xmm<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
) -> InstOutput {
    let v1 = C::xmm_to_reg(ctx, arg0);
    let v2 = constructor_output_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1840.
    return v2;
}

// Generated as internal constructor for term value_regs_get_gpr.
pub fn constructor_value_regs_get_gpr<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: usize,
) -> Gpr {
    let v2 = C::value_regs_get(ctx, arg0, arg1);
    let v3 = C::gpr_new(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 1847.
    return v3;
}

// Generated as internal constructor for term lo_gpr.
pub fn constructor_lo_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> Gpr {
    let v1 = constructor_lo_reg(ctx, arg0);
    let v2 = C::gpr_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1860.
    return v2;
}

// Generated as internal constructor for term sink_load_to_gpr_mem_imm.
pub fn constructor_sink_load_to_gpr_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> GprMemImm {
    let v1 = &constructor_sink_load_to_reg_mem_imm(ctx, arg0);
    let v2 = &C::gpr_mem_imm_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 1999.
    return v2.clone();
}

// Generated as internal constructor for term sink_load_to_xmm_mem.
pub fn constructor_sink_load_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> XmmMem {
    let v1 = &constructor_sink_load_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2003.
    return v2.clone();
}

// Generated as internal constructor for term sink_load_to_reg_mem.
pub fn constructor_sink_load_to_reg_mem<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> RegMem {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMem::Mem {
        addr: v1.clone(),
    };
    // Rule at src/isa/x64/inst.isle line 2007.
    return v2;
}

// Generated as internal constructor for term sink_load_to_gpr_mem.
pub fn constructor_sink_load_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> GprMem {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMem::Mem {
        addr: v1.clone(),
    };
    let v3 = &C::reg_mem_to_gpr_mem(ctx, &v2);
    // Rule at src/isa/x64/inst.isle line 2010.
    return v3.clone();
}

// Generated as internal constructor for term sink_load_to_reg_mem_imm.
pub fn constructor_sink_load_to_reg_mem_imm<C: Context>(
    ctx: &mut C,
    arg0: &SinkableLoad,
) -> RegMemImm {
    let v1 = &C::sink_load(ctx, arg0);
    let v2 = RegMemImm::Mem {
        addr: v1.clone(),
    };
    // Rule at src/isa/x64/inst.isle line 2015.
    return v2;
}

// Generated as internal constructor for term xmm_uninit_value.
pub fn constructor_xmm_uninit_value<C: Context>(
    ctx: &mut C,
) -> Xmm {
    let v0 = C::temp_writable_xmm(ctx);
    let v1 = MInst::XmmUninitializedValue {
        dst: v0,
    };
    let v2 = C::emit(ctx, &v1);
    let v3 = C::writable_xmm_to_xmm(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 2027.
    return v3;
}

// Generated as internal constructor for term load_ext_name.
pub fn constructor_load_ext_name<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
    arg1: i64,
    arg2: RelocDistance,
) -> Reg {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = C::writable_gpr_to_reg(ctx, v3);
    let v5 = C::box_external_name(ctx, arg0);
    let v6 = MInst::LoadExtName {
        dst: v4,
        name: v5,
        offset: arg1,
        distance: arg2,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = constructor_writable_gpr_to_r_reg(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2034.
    return v8;
}

// Generated as internal constructor for term mov64_mr.
pub fn constructor_mov64_mr<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Reg {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::Mov64MR {
        src: arg0.clone(),
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = constructor_writable_gpr_to_r_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2041.
    return v4;
}

// Generated as internal constructor for term alu_rmi_r.
pub fn constructor_alu_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmiR {
        size: v5.clone(),
        op: arg1.clone(),
        src1: arg2,
        src2: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2048.
    return v8;
}

// Generated as internal constructor for term alu_rm_r_vex.
pub fn constructor_alu_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmROpcode,
    arg2: Gpr,
    arg3: &GprMem,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmRVex {
        size: v5.clone(),
        op: arg1.clone(),
        src1: arg2,
        src2: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2056.
    return v8;
}

// Generated as internal constructor for term xmm_rm_r.
pub fn constructor_xmm_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAligned,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmR {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2064.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_unaligned.
pub fn constructor_xmm_rm_r_unaligned<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmRUnaligned {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2071.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_blend.
pub fn constructor_xmm_rm_r_blend<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAligned,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRBlend {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        mask: arg3,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2078.
    return v7;
}

// Generated as internal constructor for term xmm_rmr_blend_vex.
pub fn constructor_xmm_rmr_blend_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRBlendVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        mask: arg3,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2085.
    return v7;
}

// Generated as internal constructor for term xmm_unary_rm_r_vex.
pub fn constructor_xmm_unary_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmRVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2092.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm_vex.
pub fn constructor_xmm_unary_rm_r_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImmVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2099.
    return v6;
}

// Generated as internal constructor for term xmm_rm_r_imm.
pub fn constructor_xmm_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Reg,
    arg2: &RegMem,
    arg3: u8,
    arg4: &OperandSize,
) -> Xmm {
    let v5 = C::temp_writable_xmm(ctx);
    let v6 = C::writable_xmm_to_reg(ctx, v5);
    let v7 = MInst::XmmRmRImm {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v6,
        imm: arg3,
        size: arg4.clone(),
    };
    let v8 = C::emit(ctx, &v7);
    let v9 = C::writable_xmm_to_xmm(ctx, v5);
    // Rule at src/isa/x64/inst.isle line 2106.
    return v9;
}

// Generated as internal constructor for term xmm_vex_pinsr.
pub fn constructor_xmm_vex_pinsr<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: u8,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmVexPinsr {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2118.
    return v7;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm.
pub fn constructor_xmm_unary_rm_r_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMemAligned,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImm {
        op: arg0.clone(),
        src: arg1.clone(),
        imm: arg2,
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2125.
    return v6;
}

// Generated as internal constructor for term xmm_unary_rm_r.
pub fn constructor_xmm_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMemAligned,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmR {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2132.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_unaligned.
pub fn constructor_xmm_unary_rm_r_unaligned<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmRUnaligned {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2139.
    return v5;
}

// Generated as internal constructor for term xmm_unary_rm_r_evex.
pub fn constructor_xmm_unary_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = C::temp_writable_xmm(ctx);
    let v3 = MInst::XmmUnaryRmREvex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_xmm_to_xmm(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2146.
    return v5;
}

// Generated as internal constructor for term xmm_rm_r_evex.
pub fn constructor_xmm_rm_r_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmREvex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2153.
    return v6;
}

// Generated as internal constructor for term xmm_unary_rm_r_imm_evex.
pub fn constructor_xmm_unary_rm_r_imm_evex<C: Context>(
    ctx: &mut C,
    arg0: &Avx512Opcode,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmUnaryRmRImmEvex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2163.
    return v6;
}

// Generated as internal constructor for term xmm_rmi_xmm.
pub fn constructor_xmm_rmi_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMemAlignedImm,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmiReg {
        opcode: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2170.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_imm.
pub fn constructor_xmm_to_gpr_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: u8,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprImm {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2180.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_imm_vex.
pub fn constructor_xmm_to_gpr_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: u8,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprImmVex {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        imm: arg2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2187.
    return v6;
}

// Generated as internal constructor for term gpr_to_xmm.
pub fn constructor_gpr_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::GprToXmm {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        src_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2194.
    return v6;
}

// Generated as internal constructor for term gpr_to_xmm_vex.
pub fn constructor_gpr_to_xmm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::GprToXmmVex {
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
        src_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2201.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr.
pub fn constructor_xmm_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGpr {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        dst_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2208.
    return v6;
}

// Generated as internal constructor for term xmm_to_gpr_vex.
pub fn constructor_xmm_to_gpr_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::XmmToGprVex {
        op: arg0.clone(),
        src: arg1,
        dst: v3,
        dst_size: arg2.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2215.
    return v6;
}

// Generated as internal constructor for term xmm_min_max_seq.
pub fn constructor_xmm_min_max_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Xmm,
    arg3: Xmm,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::XmmMinMaxSeq {
        size: v5.clone(),
        is_min: arg1,
        lhs: arg2,
        rhs: arg3,
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2222.
    return v8;
}

// Generated as internal constructor for term xmm_rmir_vex.
pub fn constructor_xmm_rmir_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMemImm,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = MInst::XmmRmiRVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2230.
    return v6;
}

// Generated as internal constructor for term xmm_rmr_imm_vex.
pub fn constructor_xmm_rmr_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: u8,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRImmVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2237.
    return v7;
}

// Generated as internal constructor for term xmm_rmr_vex3.
pub fn constructor_xmm_rmr_vex3<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmRVex3 {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2,
        src3: arg3.clone(),
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2244.
    return v7;
}

// Generated as internal constructor for term unary_rm_r.
pub fn constructor_unary_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmROpcode,
    arg1: Gpr,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v5 = MInst::UnaryRmR {
        size: arg2.clone(),
        op: arg0.clone(),
        src: v4.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2251.
    return v7;
}

// Generated as internal constructor for term unary_rm_r_vex.
pub fn constructor_unary_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmRVexOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::UnaryRmRVex {
        size: arg2.clone(),
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2258.
    return v6;
}

// Generated as internal constructor for term unary_rm_r_imm_vex.
pub fn constructor_unary_rm_r_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &UnaryRmRImmVexOpcode,
    arg1: &GprMem,
    arg2: &OperandSize,
    arg3: u8,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = MInst::UnaryRmRImmVex {
        size: arg2.clone(),
        op: arg0.clone(),
        src: arg1.clone(),
        dst: v4,
        imm: arg3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2265.
    return v7;
}

// Generated as internal constructor for term cvt_int_to_float.
pub fn constructor_cvt_int_to_float<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: &OperandSize,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::CvtIntToFloat {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        src2_size: arg3.clone(),
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2271.
    return v7;
}

// Generated as internal constructor for term cvt_int_to_float_vex.
pub fn constructor_cvt_int_to_float_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &GprMem,
    arg3: &OperandSize,
) -> Xmm {
    let v4 = C::temp_writable_xmm(ctx);
    let v5 = MInst::CvtIntToFloatVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v4,
        src2_size: arg3.clone(),
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2277.
    return v7;
}

// Generated as internal constructor for term cvt_u64_to_float_seq.
pub fn constructor_cvt_u64_to_float_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Xmm {
    let v2 = &C::raw_operand_size_of_type(ctx, arg0);
    let v3 = C::temp_writable_xmm(ctx);
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = MInst::CvtUint64ToFloatSeq {
        dst_size: v2.clone(),
        src: arg1,
        dst: v3,
        tmp_gpr1: v4,
        tmp_gpr2: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2283.
    return v8;
}

// Generated as internal constructor for term cvt_float_to_uint_seq.
pub fn constructor_cvt_float_to_uint_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: bool,
) -> Gpr {
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v2 = C::value_type(ctx, arg1);
    let v5 = &C::raw_operand_size_of_type(ctx, v2);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_xmm(ctx);
    let v8 = C::temp_writable_xmm(ctx);
    let v9 = C::temp_writable_gpr(ctx);
    let v10 = constructor_put_in_xmm(ctx, arg1);
    let v11 = MInst::CvtFloatToUintSeq {
        dst_size: v4.clone(),
        src_size: v5.clone(),
        is_saturating: arg2,
        src: v10,
        dst: v6,
        tmp_gpr: v9,
        tmp_xmm: v7,
        tmp_xmm2: v8,
    };
    let v12 = C::emit(ctx, &v11);
    let v13 = C::writable_gpr_to_gpr(ctx, v6);
    // Rule at src/isa/x64/inst.isle line 2292.
    return v13;
}

// Generated as internal constructor for term cvt_float_to_sint_seq.
pub fn constructor_cvt_float_to_sint_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Value,
    arg2: bool,
) -> Gpr {
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v2 = C::value_type(ctx, arg1);
    let v5 = &C::raw_operand_size_of_type(ctx, v2);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_xmm(ctx);
    let v8 = C::temp_writable_gpr(ctx);
    let v9 = constructor_put_in_xmm(ctx, arg1);
    let v10 = MInst::CvtFloatToSintSeq {
        dst_size: v4.clone(),
        src_size: v5.clone(),
        is_saturating: arg2,
        src: v9,
        dst: v6,
        tmp_gpr: v8,
        tmp_xmm: v7,
    };
    let v11 = C::emit(ctx, &v10);
    let v12 = C::writable_gpr_to_gpr(ctx, v6);
    // Rule at src/isa/x64/inst.isle line 2304.
    return v12;
}

// Generated as internal constructor for term mov_from_preg.
pub fn constructor_mov_from_preg<C: Context>(
    ctx: &mut C,
    arg0: PReg,
) -> Reg {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::MovFromPReg {
        src: arg0,
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = constructor_writable_gpr_to_r_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2316.
    return v4;
}

// Generated as internal constructor for term extend_to_gpr.
pub fn constructor_extend_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: Value,
    arg1: Type,
    arg2: &ExtendKind,
) -> Gpr {
    let v1 = C::value_type(ctx, arg0);
    if v1 == arg1 {
        let v4 = constructor_put_in_gpr(ctx, arg0);
        // Rule at src/isa/x64/inst.isle line 2364.
        return v4;
    }
    if v1 == I32 {
        if arg1 == I64 {
            if let &ExtendKind::Zero = arg2 {
                let v5 = constructor_value32_zeros_upper32(ctx, arg0);
                if v5 == true {
                    let v6 = C::put_in_reg(ctx, arg0);
                    let v10 = C::add_range_fact(ctx, v6, 0x40_u16, 0x0_u64, 0xffffffff_u64);
                    let v11 = C::gpr_new(ctx, v10);
                    // Rule at src/isa/x64/inst.isle line 2372.
                    return v11;
                }
            }
        }
    }
    let v12 = &C::sinkable_load_exact(ctx, arg0);
    if let Some(v13) = v12 {
        let v14 = &constructor_sink_load_to_gpr_mem(ctx, v13);
        let v15 = constructor_extend_to_gpr_types(ctx, v14, v1, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 2378.
        return v15;
    }
    let v16 = &constructor_put_in_gpr_mem(ctx, arg0);
    let v17 = constructor_extend_to_gpr_types(ctx, v16, v1, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2382.
    return v17;
}

// Generated as internal constructor for term extend_to_gpr_types.
pub fn constructor_extend_to_gpr_types<C: Context>(
    ctx: &mut C,
    arg0: &GprMem,
    arg1: Type,
    arg2: Type,
    arg3: &ExtendKind,
) -> Gpr {
    let v5 = &C::operand_size_of_type_32_64(ctx, arg2);
    let v6 = constructor_operand_size_bits(ctx, v5);
    let v4 = C::ty_bits_u16(ctx, arg1);
    let v7 = &C::ext_mode(ctx, v4, v6);
    let v8 = constructor_extend(ctx, arg3, arg2, v7, arg0);
    // Rule at src/isa/x64/inst.isle line 2387.
    return v8;
}

// Generated as internal constructor for term extend.
pub fn constructor_extend<C: Context>(
    ctx: &mut C,
    arg0: &ExtendKind,
    arg1: Type,
    arg2: &ExtMode,
    arg3: &GprMem,
) -> Gpr {
    match arg0 {
        &ExtendKind::Sign => {
            let v5 = constructor_x64_movsx(ctx, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 2406.
            return v5;
        }
        &ExtendKind::Zero => {
            let v4 = constructor_x64_movzx(ctx, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 2402.
            return v4;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "extend", "src/isa/x64/inst.isle line 2399")
}

// Generated as internal constructor for term value32_zeros_upper32.
pub fn constructor_value32_zeros_upper32<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> bool {
    let v1 = C::def_inst(ctx, arg0);
    if let Some(v2) = v1 {
        let v3 = &C::inst_data(ctx, v2);
        match v3 {
            &InstructionData::Binary {
                opcode: ref v4,
                args: ref v5,
            } => {
                match v4 {
                    &Opcode::Iadd => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2413.
                        return v9;
                    }
                    &Opcode::Isub => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2414.
                        return v9;
                    }
                    &Opcode::Imul => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2415.
                        return v9;
                    }
                    &Opcode::Band => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2416.
                        return v9;
                    }
                    &Opcode::Bor => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2417.
                        return v9;
                    }
                    &Opcode::Bxor => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2418.
                        return v9;
                    }
                    &Opcode::Ishl => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2419.
                        return v9;
                    }
                    &Opcode::Ushr => {
                        let v9 = true;
                        // Rule at src/isa/x64/inst.isle line 2420.
                        return v9;
                    }
                    _ => {}
                }
            }
            &InstructionData::Load {
                opcode: ref v10,
                arg: v11,
                flags: v12,
                offset: v13,
            } => {
                if let &Opcode::Uload32 = v10 {
                    let v9 = true;
                    // Rule at src/isa/x64/inst.isle line 2421.
                    return v9;
                }
            }
            _ => {}
        }
    }
    let v14 = false;
    // Rule at src/isa/x64/inst.isle line 2422.
    return v14;
}

// Generated as internal constructor for term vec_int_type.
pub fn constructor_vec_int_type<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> Type {
    let v1 = C::multi_lane(ctx, arg0);
    if let Some(v2) = v1 {
        match v2.0 {
            0x8_u32 => {
                if v2.1 == 0x10_u32 {
                    // Rule at src/isa/x64/inst.isle line 2428.
                    return I8X16;
                }
            }
            0x10_u32 => {
                if v2.1 == 0x8_u32 {
                    // Rule at src/isa/x64/inst.isle line 2429.
                    return I16X8;
                }
            }
            0x20_u32 => {
                if v2.1 == 0x4_u32 {
                    // Rule at src/isa/x64/inst.isle line 2430.
                    return I32X4;
                }
            }
            0x40_u32 => {
                if v2.1 == 0x2_u32 {
                    // Rule at src/isa/x64/inst.isle line 2431.
                    return I64X2;
                }
            }
            _ => {}
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "vec_int_type", "src/isa/x64/inst.isle line 2427")
}

// Generated as internal constructor for term x64_xor_vector.
pub fn constructor_x64_xor_vector<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        F16 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2435.
            return v3;
        }
        F32 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2436.
            return v3;
        }
        F64 => {
            let v4 = constructor_x64_xorpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2437.
            return v4;
        }
        F128 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2438.
            return v3;
        }
        F32X4 => {
            let v3 = constructor_x64_xorps(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2439.
            return v3;
        }
        F64X2 => {
            let v4 = constructor_x64_xorpd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 2440.
            return v4;
        }
        _ => {}
    }
    let v5 = C::multi_lane(ctx, arg0);
    if let Some(v6) = v5 {
        let v9 = constructor_x64_pxor(ctx, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 2441.
        return v9;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_xor_vector", "src/isa/x64/inst.isle line 2434")
}

// Generated as internal constructor for term vector_all_ones.
pub fn constructor_vector_all_ones<C: Context>(
    ctx: &mut C,
) -> Xmm {
    let v0 = constructor_xmm_uninit_value(ctx);
    let v1 = &C::xmm_to_xmm_mem(ctx, v0);
    let v2 = constructor_x64_pcmpeqd(ctx, v0, v1);
    // Rule at src/isa/x64/inst.isle line 2453.
    return v2;
}

// Generated as internal constructor for term mov_rmi_to_xmm.
pub fn constructor_mov_rmi_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &RegMemImm,
) -> XmmMemImm {
    match arg0 {
        &RegMemImm::Reg {
            reg: v4,
        } => {
            let v5 = &C::reg_to_gpr_mem(ctx, v4);
            let v6 = constructor_x64_movd_to_xmm(ctx, v5);
            let v7 = &C::xmm_to_xmm_mem_imm(ctx, v6);
            // Rule at src/isa/x64/inst.isle line 2461.
            return v7.clone();
        }
        &RegMemImm::Mem {
            addr: ref v1,
        } => {
            let v2 = &C::xmm_mem_imm_new(ctx, arg0);
            // Rule at src/isa/x64/inst.isle line 2459.
            return v2.clone();
        }
        &RegMemImm::Imm {
            simm32: v3,
        } => {
            let v2 = &C::xmm_mem_imm_new(ctx, arg0);
            // Rule at src/isa/x64/inst.isle line 2460.
            return v2.clone();
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "mov_rmi_to_xmm", "src/isa/x64/inst.isle line 2458")
}

// Generated as internal constructor for term x64_stack_switch_basic.
pub fn constructor_x64_stack_switch_basic<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: Gpr,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::StackSwitchBasic {
        store_context_ptr: arg0,
        load_context_ptr: arg1,
        in_payload0: arg2,
        out_payload0: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2474.
    return v6;
}

// Generated as internal constructor for term x64_load.
pub fn constructor_x64_load<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: &ExtKind,
) -> Reg {
    match arg0 {
        I64 => {
            let v11 = constructor_mov64_mr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 2491.
            return v11;
        }
        F32 => {
            let v12 = constructor_x64_movss_load(ctx, arg1);
            let v13 = C::xmm_to_reg(ctx, v12);
            // Rule at src/isa/x64/inst.isle line 2494.
            return v13;
        }
        F64 => {
            let v14 = constructor_x64_movsd_load(ctx, arg1);
            let v15 = C::xmm_to_reg(ctx, v14);
            // Rule at src/isa/x64/inst.isle line 2497.
            return v15;
        }
        F128 => {
            let v16 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg1);
            let v17 = constructor_x64_movdqu_load(ctx, v16);
            let v18 = C::xmm_to_reg(ctx, v17);
            // Rule at src/isa/x64/inst.isle line 2500.
            return v18;
        }
        F32X4 => {
            let v19 = constructor_x64_movups_load(ctx, arg1);
            let v20 = C::xmm_to_reg(ctx, v19);
            // Rule at src/isa/x64/inst.isle line 2503.
            return v20;
        }
        F64X2 => {
            let v21 = constructor_x64_movupd_load(ctx, arg1);
            let v22 = C::xmm_to_reg(ctx, v21);
            // Rule at src/isa/x64/inst.isle line 2506.
            return v22;
        }
        _ => {}
    }
    let v1 = C::fits_in_32(ctx, arg0);
    if let Some(v2) = v1 {
        if let &ExtKind::SignExtend = arg2 {
            let v5 = C::ty_bytes(ctx, v2);
            let v7 = &C::ext_mode(ctx, v5, 0x8_u16);
            let v8 = &constructor_synthetic_amode_to_gpr_mem(ctx, arg1);
            let v9 = constructor_x64_movsx(ctx, v7, v8);
            let v10 = C::gpr_to_reg(ctx, v9);
            // Rule at src/isa/x64/inst.isle line 2487.
            return v10;
        }
    }
    let v23 = C::multi_lane(ctx, arg0);
    if let Some(v24) = v23 {
        let v16 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg1);
        let v17 = constructor_x64_movdqu_load(ctx, v16);
        let v18 = C::xmm_to_reg(ctx, v17);
        // Rule at src/isa/x64/inst.isle line 2509.
        return v18;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_load", "src/isa/x64/inst.isle line 2485")
}

// Generated as internal constructor for term x64_mov.
pub fn constructor_x64_mov<C: Context>(
    ctx: &mut C,
    arg0: &Amode,
) -> Reg {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = constructor_mov64_mr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 2515.
    return v2;
}

// Generated as internal constructor for term x64_movzx.
pub fn constructor_x64_movzx<C: Context>(
    ctx: &mut C,
    arg0: &ExtMode,
    arg1: &GprMem,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::MovzxRmR {
        ext_mode: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2540.
    return v5;
}

// Generated as internal constructor for term x64_movsx.
pub fn constructor_x64_movsx<C: Context>(
    ctx: &mut C,
    arg0: &ExtMode,
    arg1: &GprMem,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::MovsxRmR {
        ext_mode: arg0.clone(),
        src: arg1.clone(),
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 2546.
    return v5;
}

// Generated as internal constructor for term x64_movss_load.
pub fn constructor_x64_movss_load<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovss, v2);
        // Rule at src/isa/x64/inst.isle line 2554.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movss, v2);
    // Rule at src/isa/x64/inst.isle line 2552.
    return v3;
}

// Generated as internal constructor for term x64_movss_store.
pub fn constructor_x64_movss_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovss, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2561.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2559.
    return v3.clone();
}

// Generated as internal constructor for term x64_movsd_load.
pub fn constructor_x64_movsd_load<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovsd, v2);
        // Rule at src/isa/x64/inst.isle line 2568.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movsd, v2);
    // Rule at src/isa/x64/inst.isle line 2566.
    return v3;
}

// Generated as internal constructor for term x64_movsd_store.
pub fn constructor_x64_movsd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovsd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2575.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2573.
    return v3.clone();
}

// Generated as internal constructor for term x64_movups_load.
pub fn constructor_x64_movups_load<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovups, v2);
        // Rule at src/isa/x64/inst.isle line 2582.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movups, v2);
    // Rule at src/isa/x64/inst.isle line 2580.
    return v3;
}

// Generated as internal constructor for term x64_movups_store.
pub fn constructor_x64_movups_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovups, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2589.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movups, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2587.
    return v3.clone();
}

// Generated as internal constructor for term x64_movupd_load.
pub fn constructor_x64_movupd_load<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovupd, v2);
        // Rule at src/isa/x64/inst.isle line 2596.
        return v6;
    }
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movupd, v2);
    // Rule at src/isa/x64/inst.isle line 2594.
    return v3;
}

// Generated as internal constructor for term x64_movupd_store.
pub fn constructor_x64_movupd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovupd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2603.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movupd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2601.
    return v3.clone();
}

// Generated as internal constructor for term x64_movd_to_gpr.
pub fn constructor_x64_movd_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovd, arg0, &OperandSize::Size32);
        // Rule at src/isa/x64/inst.isle line 2611.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movd, arg0, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 2609.
    return v3;
}

// Generated as internal constructor for term x64_movd_to_xmm.
pub fn constructor_x64_movd_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &GprMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_gpr_to_xmm_vex(ctx, &AvxOpcode::Vmovd, arg0, &OperandSize::Size32);
        // Rule at src/isa/x64/inst.isle line 2619.
        return v6;
    }
    let v3 = constructor_gpr_to_xmm(ctx, &SseOpcode::Movd, arg0, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 2617.
    return v3;
}

// Generated as internal constructor for term x64_movq_to_xmm.
pub fn constructor_x64_movq_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: &GprMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_gpr_to_xmm_vex(ctx, &AvxOpcode::Vmovq, arg0, &OperandSize::Size64);
        // Rule at src/isa/x64/inst.isle line 2627.
        return v6;
    }
    let v3 = constructor_gpr_to_xmm(ctx, &SseOpcode::Movq, arg0, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 2625.
    return v3;
}

// Generated as internal constructor for term x64_movq_to_gpr.
pub fn constructor_x64_movq_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovq, arg0, &OperandSize::Size64);
        // Rule at src/isa/x64/inst.isle line 2635.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movq, arg0, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 2633.
    return v3;
}

// Generated as internal constructor for term x64_movdqu_load.
pub fn constructor_x64_movdqu_load<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovdqu, arg0);
        // Rule at src/isa/x64/inst.isle line 2642.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movdqu, arg0);
    // Rule at src/isa/x64/inst.isle line 2640.
    return v2;
}

// Generated as internal constructor for term x64_movdqu_store.
pub fn constructor_x64_movdqu_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
) -> SideEffectNoResult {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_movrm_vex(ctx, &AvxOpcode::Vmovdqu, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 2649.
        return v6.clone();
    }
    let v3 = &constructor_xmm_movrm(ctx, &SseOpcode::Movdqu, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 2647.
    return v3.clone();
}

// Generated as internal constructor for term x64_pmovsxbw.
pub fn constructor_x64_pmovsxbw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxbw, arg0);
        // Rule at src/isa/x64/inst.isle line 2656.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxbw, arg0);
    // Rule at src/isa/x64/inst.isle line 2654.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxbw.
pub fn constructor_x64_pmovzxbw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxbw, arg0);
        // Rule at src/isa/x64/inst.isle line 2663.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxbw, arg0);
    // Rule at src/isa/x64/inst.isle line 2661.
    return v2;
}

// Generated as internal constructor for term x64_pmovsxwd.
pub fn constructor_x64_pmovsxwd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxwd, arg0);
        // Rule at src/isa/x64/inst.isle line 2670.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxwd, arg0);
    // Rule at src/isa/x64/inst.isle line 2668.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxwd.
pub fn constructor_x64_pmovzxwd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxwd, arg0);
        // Rule at src/isa/x64/inst.isle line 2677.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxwd, arg0);
    // Rule at src/isa/x64/inst.isle line 2675.
    return v2;
}

// Generated as internal constructor for term x64_pmovsxdq.
pub fn constructor_x64_pmovsxdq<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovsxdq, arg0);
        // Rule at src/isa/x64/inst.isle line 2684.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovsxdq, arg0);
    // Rule at src/isa/x64/inst.isle line 2682.
    return v2;
}

// Generated as internal constructor for term x64_pmovzxdq.
pub fn constructor_x64_pmovzxdq<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpmovzxdq, arg0);
        // Rule at src/isa/x64/inst.isle line 2691.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Pmovzxdq, arg0);
    // Rule at src/isa/x64/inst.isle line 2689.
    return v2;
}

// Generated as internal constructor for term x64_movrm.
pub fn constructor_x64_movrm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::MovRM {
        size: v3.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v5 = SideEffectNoResult::Inst {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 2698.
    return v5;
}

// Generated as internal constructor for term x64_movimm_m.
pub fn constructor_x64_movimm_m<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
    arg2: i32,
) -> SideEffectNoResult {
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::MovImmM {
        size: v3.clone(),
        simm32: arg2,
        dst: arg1.clone(),
    };
    let v5 = SideEffectNoResult::Inst {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 2703.
    return v5;
}

// Generated as internal constructor for term xmm_movrm.
pub fn constructor_xmm_movrm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
) -> SideEffectNoResult {
    let v3 = MInst::XmmMovRM {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v4 = SideEffectNoResult::Inst {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 2708.
    return v4;
}

// Generated as internal constructor for term xmm_movrm_imm.
pub fn constructor_xmm_movrm_imm<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
    arg3: u8,
) -> SideEffectNoResult {
    let v4 = MInst::XmmMovRMImm {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
        imm: arg3,
    };
    let v5 = SideEffectNoResult::Inst {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 2712.
    return v5;
}

// Generated as internal constructor for term xmm_movrm_vex.
pub fn constructor_xmm_movrm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
) -> SideEffectNoResult {
    let v3 = MInst::XmmMovRMVex {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
    };
    let v4 = SideEffectNoResult::Inst {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 2716.
    return v4;
}

// Generated as internal constructor for term xmm_movrm_imm_vex.
pub fn constructor_xmm_movrm_imm_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: &SyntheticAmode,
    arg2: Xmm,
    arg3: u8,
) -> SideEffectNoResult {
    let v4 = MInst::XmmMovRMImmVex {
        op: arg0.clone(),
        src: arg2,
        dst: arg1.clone(),
        imm: arg3,
    };
    let v5 = SideEffectNoResult::Inst {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 2720.
    return v5;
}

// Generated as internal constructor for term x64_xmm_load_const.
pub fn constructor_x64_xmm_load_const<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: VCodeConstant,
) -> Xmm {
    let v2 = &C::const_to_synthetic_amode(ctx, arg1);
    let v4 = constructor_x64_load(ctx, arg0, v2, &ExtKind::None);
    let v5 = C::xmm_new(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 2725.
    return v5;
}

// Generated as internal constructor for term x64_add.
pub fn constructor_x64_add<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Add, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2736.
    return v4;
}

// Generated as internal constructor for term x64_add_with_flags_paired.
pub fn constructor_x64_add_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Add,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2744.
    return v8;
}

// Generated as internal constructor for term x64_alurmi_with_flags_paired.
pub fn constructor_x64_alurmi_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: &AluRmiROpcode,
    arg1: Type,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ProducesFlags {
    let v2 = C::fits_in_64(ctx, arg1);
    if let Some(v3) = v2 {
        let v6 = C::temp_writable_gpr(ctx);
        let v7 = &C::raw_operand_size_of_type(ctx, v3);
        let v9 = constructor_writable_gpr_to_r_reg(ctx, v6);
        let v8 = MInst::AluRmiR {
            size: v7.clone(),
            op: arg0.clone(),
            src1: arg2,
            src2: arg3.clone(),
            dst: v6,
        };
        let v10 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
            inst: v8,
            result: v9,
        };
        // Rule at src/isa/x64/inst.isle line 2755.
        return v10;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_alurmi_with_flags_paired", "src/isa/x64/inst.isle line 2754")
}

// Generated as internal constructor for term x64_alurmi_flags_side_effect.
pub fn constructor_x64_alurmi_flags_side_effect<C: Context>(
    ctx: &mut C,
    arg0: &AluRmiROpcode,
    arg1: Type,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ProducesFlags {
    let v2 = C::fits_in_64(ctx, arg1);
    if let Some(v3) = v2 {
        let v6 = &C::raw_operand_size_of_type(ctx, v3);
        let v7 = C::temp_writable_gpr(ctx);
        let v8 = MInst::AluRmiR {
            size: v6.clone(),
            op: arg0.clone(),
            src1: arg2,
            src2: arg3.clone(),
            dst: v7,
        };
        let v9 = ProducesFlags::ProducesFlagsSideEffect {
            inst: v8,
        };
        // Rule at src/isa/x64/inst.isle line 2766.
        return v9;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_alurmi_flags_side_effect", "src/isa/x64/inst.isle line 2765")
}

// Generated as internal constructor for term x64_alurmi_with_flags_chained.
pub fn constructor_x64_alurmi_with_flags_chained<C: Context>(
    ctx: &mut C,
    arg0: &AluRmiROpcode,
    arg1: Type,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ConsumesAndProducesFlags {
    let v2 = C::fits_in_64(ctx, arg1);
    if let Some(v3) = v2 {
        let v6 = C::temp_writable_gpr(ctx);
        let v7 = &C::raw_operand_size_of_type(ctx, v3);
        let v9 = constructor_writable_gpr_to_r_reg(ctx, v6);
        let v8 = MInst::AluRmiR {
            size: v7.clone(),
            op: arg0.clone(),
            src1: arg2,
            src2: arg3.clone(),
            dst: v6,
        };
        let v10 = ConsumesAndProducesFlags::ReturnsReg {
            inst: v8,
            result: v9,
        };
        // Rule at src/isa/x64/inst.isle line 2776.
        return v10;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_alurmi_with_flags_chained", "src/isa/x64/inst.isle line 2775")
}

// Generated as internal constructor for term x64_adc_paired.
pub fn constructor_x64_adc_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ConsumesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Adc,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2788.
    return v8;
}

// Generated as internal constructor for term x64_sub.
pub fn constructor_x64_sub<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Sub, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2800.
    return v4;
}

// Generated as internal constructor for term x64_sub_with_flags_paired.
pub fn constructor_x64_sub_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Sub,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2808.
    return v8;
}

// Generated as internal constructor for term x64_sbb_paired.
pub fn constructor_x64_sbb_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ConsumesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::Sbb,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 2820.
    return v8;
}

// Generated as internal constructor for term x64_mul.
pub fn constructor_x64_mul<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Gpr,
    arg3: &GprMem,
) -> ValueRegs {
    if arg1 == false {
        let v12 = C::ty_32_or_64(ctx, arg0);
        if let Some(v13) = v12 {
            let v14 = C::use_bmi2(ctx);
            if v14 == true {
                let v4 = C::temp_writable_gpr(ctx);
                let v5 = C::temp_writable_gpr(ctx);
                let v15 = &C::raw_operand_size_of_type(ctx, v13);
                let v16 = MInst::MulX {
                    size: v15.clone(),
                    src1: arg2,
                    src2: arg3.clone(),
                    dst_lo: v4,
                    dst_hi: v5,
                };
                let v17 = C::emit(ctx, &v16);
                let v9 = C::writable_gpr_to_gpr(ctx, v4);
                let v10 = C::writable_gpr_to_gpr(ctx, v5);
                let v11 = constructor_value_gprs(ctx, v9, v10);
                // Rule at src/isa/x64/inst.isle line 2841.
                return v11;
            }
        }
    }
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = &C::raw_operand_size_of_type(ctx, arg0);
    let v7 = MInst::Mul {
        size: v6.clone(),
        signed: arg1,
        src1: arg2,
        src2: arg3.clone(),
        dst_lo: v4,
        dst_hi: v5,
    };
    let v8 = C::emit(ctx, &v7);
    let v9 = C::writable_gpr_to_gpr(ctx, v4);
    let v10 = C::writable_gpr_to_gpr(ctx, v5);
    let v11 = constructor_value_gprs(ctx, v9, v10);
    // Rule at src/isa/x64/inst.isle line 2833.
    return v11;
}

// Generated as internal constructor for term x64_mulx_hi.
pub fn constructor_x64_mulx_hi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> Gpr {
    let v1 = C::ty_32_or_64(ctx, arg0);
    if let Some(v2) = v1 {
        let v5 = C::temp_writable_gpr(ctx);
        let v6 = &C::raw_operand_size_of_type(ctx, v2);
        let v7 = C::writable_invalid_gpr(ctx);
        let v8 = MInst::MulX {
            size: v6.clone(),
            src1: arg1,
            src2: arg2.clone(),
            dst_lo: v7,
            dst_hi: v5,
        };
        let v9 = C::emit(ctx, &v8);
        let v10 = C::writable_gpr_to_gpr(ctx, v5);
        // Rule at src/isa/x64/inst.isle line 2850.
        return v10;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_mulx_hi", "src/isa/x64/inst.isle line 2849")
}

// Generated as internal constructor for term x64_mul8.
pub fn constructor_x64_mul8<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Gpr,
    arg2: &GprMem,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = MInst::Mul8 {
        signed: arg0,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2863.
    return v6;
}

// Generated as internal constructor for term x64_imul.
pub fn constructor_x64_imul<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = MInst::IMul {
        size: v4.clone(),
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2870.
    return v7;
}

// Generated as internal constructor for term x64_imul_imm.
pub fn constructor_x64_imul_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: i32,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = MInst::IMulImm {
        size: v4.clone(),
        src1: arg1.clone(),
        src2: arg2,
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 2878.
    return v7;
}

// Generated as internal constructor for term x64_mul8_with_flags_paired.
pub fn constructor_x64_mul8_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: bool,
    arg1: Gpr,
    arg2: &GprMem,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v5 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v4 = MInst::Mul8 {
        signed: arg0,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v6 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v4,
        result: v5,
    };
    // Rule at src/isa/x64/inst.isle line 2885.
    return v6;
}

// Generated as internal constructor for term x64_mul_lo_with_flags_paired.
pub fn constructor_x64_mul_lo_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: bool,
    arg2: Gpr,
    arg3: &GprMem,
) -> ProducesFlags {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = &C::raw_operand_size_of_type(ctx, arg0);
    let v8 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v7 = MInst::Mul {
        size: v6.clone(),
        signed: arg1,
        src1: arg2,
        src2: arg3.clone(),
        dst_lo: v4,
        dst_hi: v5,
    };
    let v9 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v7,
        result: v8,
    };
    // Rule at src/isa/x64/inst.isle line 2892.
    return v9;
}

// Generated as internal constructor for term x64_and.
pub fn constructor_x64_and<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::And, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2902.
    return v4;
}

// Generated as internal constructor for term x64_and_with_flags_paired.
pub fn constructor_x64_and_with_flags_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v6 = MInst::AluRmiR {
        size: v4.clone(),
        op: AluRmiROpcode::And,
        src1: arg1,
        src2: arg2.clone(),
        dst: v3,
    };
    let v7 = ProducesFlags::ProducesFlagsSideEffect {
        inst: v6,
    };
    // Rule at src/isa/x64/inst.isle line 2909.
    return v7;
}

// Generated as internal constructor for term x64_or.
pub fn constructor_x64_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Or, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2920.
    return v4;
}

// Generated as internal constructor for term x64_xor.
pub fn constructor_x64_xor<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> Gpr {
    let v4 = constructor_alu_rmi_r(ctx, arg0, &AluRmiROpcode::Xor, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2928.
    return v4;
}

// Generated as internal constructor for term x64_andn.
pub fn constructor_x64_andn<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &GprMem,
) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Andn, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 2935.
    return v4;
}

// Generated as internal constructor for term imm_i64.
pub fn constructor_imm_i64<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: i64,
) -> Reg {
    let v2 = C::i64_as_u64(ctx, arg1);
    let v3 = constructor_imm(ctx, arg0, v2);
    // Rule at src/isa/x64/inst.isle line 2942.
    return v3;
}

// Generated as internal constructor for term imm.
pub fn constructor_imm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: u64,
) -> Reg {
    match arg0 {
        I64 => {
            let v26 = C::nonzero_u64_fits_in_u32(ctx, arg1);
            if let Some(v27) = v26 {
                let v5 = C::temp_writable_gpr(ctx);
                let v29 = MInst::Imm {
                    dst_size: OperandSize::Size32,
                    simm64: v27,
                    dst: v5,
                };
                let v30 = C::emit(ctx, &v29);
                let v31 = constructor_writable_gpr_to_r_reg(ctx, v5);
                // Rule at src/isa/x64/inst.isle line 2977.
                return v31;
            }
        }
        F16 => {
            let v4 = C::u64_is_zero(ctx, arg1);
            match v4 {
                false => {
                    let v12 = constructor_imm(ctx, I16, arg1);
                    let v13 = C::gpr_new(ctx, v12);
                    let v14 = constructor_bitcast_gpr_to_xmm(ctx, 0x10_u8, v13);
                    let v15 = C::xmm_to_reg(ctx, v14);
                    // Rule at src/isa/x64/inst.isle line 2964.
                    return v15;
                }
                true => {
                    let v41 = constructor_xmm_zero(ctx, arg0);
                    let v42 = C::xmm_to_reg(ctx, v41);
                    // Rule at src/isa/x64/inst.isle line 2995.
                    return v42;
                }
                _ => {}
            }
        }
        F32 => {
            let v4 = C::u64_is_zero(ctx, arg1);
            match v4 {
                false => {
                    let v17 = constructor_imm(ctx, I32, arg1);
                    let v18 = &C::reg_to_gpr_mem(ctx, v17);
                    let v19 = constructor_x64_movd_to_xmm(ctx, v18);
                    let v20 = C::xmm_to_reg(ctx, v19);
                    // Rule at src/isa/x64/inst.isle line 2968.
                    return v20;
                }
                true => {
                    let v41 = constructor_xmm_zero(ctx, arg0);
                    let v42 = C::xmm_to_reg(ctx, v41);
                    // Rule at src/isa/x64/inst.isle line 2998.
                    return v42;
                }
                _ => {}
            }
        }
        F64 => {
            let v4 = C::u64_is_zero(ctx, arg1);
            match v4 {
                false => {
                    let v22 = constructor_imm(ctx, I64, arg1);
                    let v23 = &C::reg_to_gpr_mem(ctx, v22);
                    let v24 = constructor_x64_movq_to_xmm(ctx, v23);
                    let v25 = C::xmm_to_reg(ctx, v24);
                    // Rule at src/isa/x64/inst.isle line 2972.
                    return v25;
                }
                true => {
                    let v41 = constructor_xmm_zero(ctx, arg0);
                    let v42 = C::xmm_to_reg(ctx, v41);
                    // Rule at src/isa/x64/inst.isle line 3003.
                    return v42;
                }
                _ => {}
            }
        }
        _ => {}
    }
    let v1 = C::fits_in_64(ctx, arg0);
    if let Some(v2) = v1 {
        let v4 = C::u64_is_zero(ctx, arg1);
        match v4 {
            false => {
                let v5 = C::temp_writable_gpr(ctx);
                let v6 = &C::operand_size_of_type_32_64(ctx, v2);
                let v7 = MInst::Imm {
                    dst_size: v6.clone(),
                    simm64: arg1,
                    dst: v5,
                };
                let v8 = C::emit(ctx, &v7);
                let v9 = constructor_writable_gpr_to_r_reg(ctx, v5);
                // Rule at src/isa/x64/inst.isle line 2957.
                return v9;
            }
            true => {
                let v5 = C::temp_writable_gpr(ctx);
                let v6 = &C::operand_size_of_type_32_64(ctx, v2);
                let v33 = MInst::AluConstOp {
                    op: AluRmiROpcode::Xor,
                    size: v6.clone(),
                    dst: v5,
                };
                let v34 = C::emit(ctx, &v33);
                let v35 = C::writable_gpr_to_gpr(ctx, v5);
                let v36 = C::gpr_to_reg(ctx, v35);
                // Rule at src/isa/x64/inst.isle line 2983.
                return v36;
            }
            _ => {}
        }
    }
    if arg1 == 0x0_u64 {
        let v37 = C::multi_lane(ctx, arg0);
        if let Some(v38) = v37 {
            let v41 = constructor_xmm_zero(ctx, arg0);
            let v42 = C::xmm_to_reg(ctx, v41);
            // Rule at src/isa/x64/inst.isle line 2991.
            return v42;
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "imm", "src/isa/x64/inst.isle line 2954")
}

// Generated as internal constructor for term xmm_zero.
pub fn constructor_xmm_zero<C: Context>(
    ctx: &mut C,
    arg0: Type,
) -> Xmm {
    let v1 = constructor_xmm_uninit_value(ctx);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    let v3 = constructor_x64_xor_vector(ctx, arg0, v1, v2);
    // Rule at src/isa/x64/inst.isle line 3008.
    return v3;
}

// Generated as internal constructor for term shift_r.
pub fn constructor_shift_r<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &ShiftKind,
    arg2: Gpr,
    arg3: &Imm8Gpr,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::raw_operand_size_of_type(ctx, arg0);
    let v6 = MInst::ShiftR {
        size: v5.clone(),
        kind: arg1.clone(),
        src: arg2,
        num_bits: arg3.clone(),
        dst: v4,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 3014.
    return v8;
}

// Generated as internal constructor for term x64_rotl.
pub fn constructor_x64_rotl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::imm8_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = C::ty_bits(ctx, v6);
                let v12 = C::u8_sub(ctx, v11, v8);
                let v13 = constructor_x64_rorx(ctx, v6, v10, v12);
                // Rule at src/isa/x64/inst.isle line 3026.
                return v13;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::RotateLeft, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3024.
    return v4;
}

// Generated as internal constructor for term x64_rotr.
pub fn constructor_x64_rotr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::imm8_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_rorx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 3034.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::RotateRight, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3032.
    return v4;
}

// Generated as internal constructor for term x64_shl.
pub fn constructor_x64_shl<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_shlx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 3046.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftLeft, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3040.
    return v4;
}

// Generated as internal constructor for term x64_shr.
pub fn constructor_x64_shr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_shrx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 3055.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftRightLogical, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3052.
    return v4;
}

// Generated as internal constructor for term x64_sar.
pub fn constructor_x64_sar<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: &Imm8Gpr,
) -> Gpr {
    let v5 = C::ty_32_or_64(ctx, arg0);
    if let Some(v6) = v5 {
        let v7 = C::gpr_from_imm8_gpr(ctx, arg2);
        if let Some(v8) = v7 {
            let v9 = C::use_bmi2(ctx);
            if v9 == true {
                let v10 = &C::gpr_to_gpr_mem(ctx, arg1);
                let v11 = constructor_x64_sarx(ctx, v6, v10, v8);
                // Rule at src/isa/x64/inst.isle line 3064.
                return v11;
            }
        }
    }
    let v4 = constructor_shift_r(ctx, arg0, &ShiftKind::ShiftRightArithmetic, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3061.
    return v4;
}

// Generated as internal constructor for term x64_bzhi.
pub fn constructor_x64_bzhi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: Gpr,
) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Bzhi, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 3073.
    return v4;
}

// Generated as internal constructor for term x64_bswap.
pub fn constructor_x64_bswap<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::Bswap {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 3080.
    return v6;
}

// Generated as internal constructor for term cmp_rmi_r.
pub fn constructor_cmp_rmi_r<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &CmpOpcode,
    arg2: Gpr,
    arg3: &GprMemImm,
) -> ProducesFlags {
    let v4 = MInst::CmpRmiR {
        size: arg0.clone(),
        opcode: arg1.clone(),
        src1: arg2,
        src2: arg3.clone(),
    };
    let v5 = ProducesFlags::ProducesFlagsSideEffect {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 3088.
    return v5;
}

// Generated as internal constructor for term x64_cmp.
pub fn constructor_x64_cmp<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v4 = &constructor_cmp_rmi_r(ctx, arg0, &CmpOpcode::Cmp, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3097.
    return v4.clone();
}

// Generated as internal constructor for term x64_cmp_imm.
pub fn constructor_x64_cmp_imm<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Gpr,
    arg2: u32,
) -> ProducesFlags {
    let v3 = RegMemImm::Imm {
        simm32: arg2,
    };
    let v4 = &C::gpr_mem_imm_new(ctx, &v3);
    let v5 = &constructor_x64_cmp(ctx, arg0, arg1, v4);
    // Rule at src/isa/x64/inst.isle line 3102.
    return v5.clone();
}

// Generated as internal constructor for term xmm_cmp_rm_r.
pub fn constructor_xmm_cmp_rm_r<C: Context>(
    ctx: &mut C,
    arg0: &SseOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> ProducesFlags {
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg2);
    let v4 = MInst::XmmCmpRmR {
        op: arg0.clone(),
        src1: arg1,
        src2: v3.clone(),
    };
    let v5 = ProducesFlags::ProducesFlagsSideEffect {
        inst: v4,
    };
    // Rule at src/isa/x64/inst.isle line 3107.
    return v5;
}

// Generated as internal constructor for term xmm_cmp_rm_r_vex.
pub fn constructor_xmm_cmp_rm_r_vex<C: Context>(
    ctx: &mut C,
    arg0: &AvxOpcode,
    arg1: Xmm,
    arg2: &XmmMem,
) -> ProducesFlags {
    let v3 = MInst::XmmCmpRmRVex {
        op: arg0.clone(),
        src1: arg1,
        src2: arg2.clone(),
    };
    let v4 = ProducesFlags::ProducesFlagsSideEffect {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 3113.
    return v4;
}

// Generated as internal constructor for term x64_ucomis.
pub fn constructor_x64_ucomis<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> ProducesFlags {
    match arg0 {
        F32 => {
            let v7 = C::use_avx(ctx);
            if v7 == true {
                let v9 = &constructor_xmm_cmp_rm_r_vex(ctx, &AvxOpcode::Vucomiss, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 3123.
                return v9.clone();
            }
            let v4 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ucomiss, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3119.
            return v4.clone();
        }
        F64 => {
            let v7 = C::use_avx(ctx);
            if v7 == true {
                let v11 = &constructor_xmm_cmp_rm_r_vex(ctx, &AvxOpcode::Vucomisd, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 3126.
                return v11.clone();
            }
            let v6 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ucomisd, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3121.
            return v6.clone();
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_ucomis", "src/isa/x64/inst.isle line 3118")
}

// Generated as internal constructor for term x64_test.
pub fn constructor_x64_test<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Gpr,
    arg2: &GprMemImm,
) -> ProducesFlags {
    let v4 = &constructor_cmp_rmi_r(ctx, arg0, &CmpOpcode::Test, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 3132.
    return v4.clone();
}

// Generated as internal constructor for term x64_ptest.
pub fn constructor_x64_ptest<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> ProducesFlags {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &constructor_xmm_cmp_rm_r_vex(ctx, &AvxOpcode::Vptest, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 3139.
        return v6.clone();
    }
    let v3 = &constructor_xmm_cmp_rm_r(ctx, &SseOpcode::Ptest, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3137.
    return v3.clone();
}

// Generated as internal constructor for term cmove.
pub fn constructor_cmove<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &GprMem,
    arg3: Gpr,
) -> ConsumesFlags {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v6 = MInst::Cmove {
        size: v5.clone(),
        cc: arg1.clone(),
        consequent: arg2.clone(),
        alternative: arg3,
        dst: v4,
    };
    let v8 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 3147.
    return v8;
}

// Generated as internal constructor for term cmove_xmm.
pub fn constructor_cmove_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Xmm,
    arg3: Xmm,
) -> ConsumesFlags {
    let v4 = C::temp_writable_xmm(ctx);
    let v6 = constructor_writable_xmm_to_r_reg(ctx, v4);
    let v5 = MInst::XmmCmove {
        ty: arg0,
        cc: arg1.clone(),
        consequent: arg2,
        alternative: arg3,
        dst: v4,
    };
    let v7 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v5,
        result: v6,
    };
    // Rule at src/isa/x64/inst.isle line 3155.
    return v7;
}

// Generated as internal constructor for term cmove_from_values.
pub fn constructor_cmove_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: Value,
    arg3: Value,
) -> ConsumesFlags {
    let v1 = &C::type_register_class(ctx, arg0);
    if let Some(v2) = v1 {
        match v2 {
            &RegisterClass::Gpr {
                single_register: v3,
            } => {
                match v3 {
                    false => {
                        if arg0 == I128 {
                            let v7 = C::put_in_regs(ctx, arg2);
                            let v8 = C::put_in_regs(ctx, arg3);
                            let v9 = C::temp_writable_gpr(ctx);
                            let v10 = C::temp_writable_gpr(ctx);
                            let v13 = constructor_value_regs_get_gpr(ctx, v7, 0x0_usize);
                            let v14 = &C::gpr_to_gpr_mem(ctx, v13);
                            let v15 = constructor_value_regs_get_gpr(ctx, v8, 0x0_usize);
                            let v18 = constructor_value_regs_get_gpr(ctx, v7, 0x1_usize);
                            let v19 = &C::gpr_to_gpr_mem(ctx, v18);
                            let v20 = constructor_value_regs_get_gpr(ctx, v8, 0x1_usize);
                            let v22 = constructor_writable_gpr_to_r_reg(ctx, v9);
                            let v23 = constructor_writable_gpr_to_r_reg(ctx, v10);
                            let v24 = C::value_regs(ctx, v22, v23);
                            let v16 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v14.clone(),
                                alternative: v15,
                                dst: v9,
                            };
                            let v21 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v19.clone(),
                                alternative: v20,
                                dst: v10,
                            };
                            let v25 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
                                inst1: v16,
                                inst2: v21,
                                result: v24,
                            };
                            // Rule at src/isa/x64/inst.isle line 3165.
                            return v25;
                        }
                    }
                    true => {
                        let v26 = &constructor_put_in_gpr_mem(ctx, arg2);
                        let v27 = constructor_put_in_gpr(ctx, arg3);
                        let v28 = &constructor_cmove(ctx, arg0, arg1, v26, v27);
                        // Rule at src/isa/x64/inst.isle line 3186.
                        return v28.clone();
                    }
                    _ => {}
                }
            }
            &RegisterClass::Xmm => {
                let v29 = constructor_put_in_xmm(ctx, arg2);
                let v30 = constructor_put_in_xmm(ctx, arg3);
                let v31 = &constructor_cmove_xmm(ctx, arg0, arg1, v29, v30);
                // Rule at src/isa/x64/inst.isle line 3189.
                return v31.clone();
            }
            _ => {}
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "cmove_from_values", "src/isa/x64/inst.isle line 3164")
}

// Generated as internal constructor for term cmove_or.
pub fn constructor_cmove_or<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: &GprMem,
    arg4: Gpr,
) -> ConsumesFlags {
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v9 = C::writable_gpr_to_gpr(ctx, v6);
    let v11 = constructor_writable_gpr_to_value_regs(ctx, v5);
    let v8 = MInst::Cmove {
        size: v7.clone(),
        cc: arg1.clone(),
        consequent: arg3.clone(),
        alternative: arg4,
        dst: v6,
    };
    let v10 = MInst::Cmove {
        size: v7.clone(),
        cc: arg2.clone(),
        consequent: arg3.clone(),
        alternative: v9,
        dst: v5,
    };
    let v12 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: v8,
        inst2: v10,
        result: v11,
    };
    // Rule at src/isa/x64/inst.isle line 3196.
    return v12;
}

// Generated as internal constructor for term cmove_or_xmm.
pub fn constructor_cmove_or_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: Xmm,
    arg4: Xmm,
) -> ConsumesFlags {
    let v5 = C::temp_writable_xmm(ctx);
    let v6 = C::temp_writable_xmm(ctx);
    let v8 = C::writable_xmm_to_xmm(ctx, v6);
    let v10 = constructor_writable_xmm_to_value_regs(ctx, v5);
    let v7 = MInst::XmmCmove {
        ty: arg0,
        cc: arg1.clone(),
        consequent: arg3,
        alternative: arg4,
        dst: v6,
    };
    let v9 = MInst::XmmCmove {
        ty: arg0,
        cc: arg2.clone(),
        consequent: arg3,
        alternative: v8,
        dst: v5,
    };
    let v11 = ConsumesFlags::ConsumesFlagsTwiceReturnsValueRegs {
        inst1: v7,
        inst2: v9,
        result: v10,
    };
    // Rule at src/isa/x64/inst.isle line 3208.
    return v11;
}

// Generated as internal constructor for term cmove_or_from_values.
pub fn constructor_cmove_or_from_values<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &CC,
    arg2: &CC,
    arg3: Value,
    arg4: Value,
) -> ConsumesFlags {
    let v1 = &C::type_register_class(ctx, arg0);
    if let Some(v2) = v1 {
        match v2 {
            &RegisterClass::Gpr {
                single_register: v3,
            } => {
                match v3 {
                    false => {
                        if arg0 == I128 {
                            let v8 = C::put_in_regs(ctx, arg3);
                            let v9 = C::put_in_regs(ctx, arg4);
                            let v10 = C::temp_writable_gpr(ctx);
                            let v11 = C::temp_writable_gpr(ctx);
                            let v12 = C::temp_writable_gpr(ctx);
                            let v13 = C::temp_writable_gpr(ctx);
                            let v16 = constructor_value_regs_get_gpr(ctx, v8, 0x0_usize);
                            let v17 = &C::gpr_to_gpr_mem(ctx, v16);
                            let v18 = constructor_value_regs_get_gpr(ctx, v9, 0x0_usize);
                            let v20 = constructor_value_regs_get_gpr(ctx, v8, 0x0_usize);
                            let v21 = &C::gpr_to_gpr_mem(ctx, v20);
                            let v22 = C::writable_gpr_to_gpr(ctx, v12);
                            let v25 = constructor_value_regs_get_gpr(ctx, v8, 0x1_usize);
                            let v26 = &C::gpr_to_gpr_mem(ctx, v25);
                            let v27 = constructor_value_regs_get_gpr(ctx, v9, 0x1_usize);
                            let v29 = constructor_value_regs_get_gpr(ctx, v8, 0x1_usize);
                            let v30 = &C::gpr_to_gpr_mem(ctx, v29);
                            let v31 = C::writable_gpr_to_gpr(ctx, v13);
                            let v33 = constructor_writable_gpr_to_r_reg(ctx, v10);
                            let v34 = constructor_writable_gpr_to_r_reg(ctx, v11);
                            let v35 = C::value_regs(ctx, v33, v34);
                            let v19 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v17.clone(),
                                alternative: v18,
                                dst: v12,
                            };
                            let v23 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg2.clone(),
                                consequent: v21.clone(),
                                alternative: v22,
                                dst: v10,
                            };
                            let v28 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg1.clone(),
                                consequent: v26.clone(),
                                alternative: v27,
                                dst: v13,
                            };
                            let v32 = MInst::Cmove {
                                size: OperandSize::Size64,
                                cc: arg2.clone(),
                                consequent: v30.clone(),
                                alternative: v31,
                                dst: v11,
                            };
                            let v36 = ConsumesFlags::ConsumesFlagsFourTimesReturnsValueRegs {
                                inst1: v19,
                                inst2: v23,
                                inst3: v28,
                                inst4: v32,
                                result: v35,
                            };
                            // Rule at src/isa/x64/inst.isle line 3222.
                            return v36;
                        }
                    }
                    true => {
                        let v37 = &constructor_put_in_gpr_mem(ctx, arg3);
                        let v38 = constructor_put_in_gpr(ctx, arg4);
                        let v39 = &constructor_cmove_or(ctx, arg0, arg1, arg2, v37, v38);
                        // Rule at src/isa/x64/inst.isle line 3241.
                        return v39.clone();
                    }
                    _ => {}
                }
            }
            &RegisterClass::Xmm => {
                let v40 = constructor_put_in_xmm(ctx, arg3);
                let v41 = constructor_put_in_xmm(ctx, arg4);
                let v42 = &constructor_cmove_or_xmm(ctx, arg0, arg1, arg2, v40, v41);
                // Rule at src/isa/x64/inst.isle line 3244.
                return v42.clone();
            }
            _ => {}
        }
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "cmove_or_from_values", "src/isa/x64/inst.isle line 3221")
}

// Generated as internal constructor for term x64_setcc.
pub fn constructor_x64_setcc<C: Context>(
    ctx: &mut C,
    arg0: &CC,
) -> ConsumesFlags {
    let v1 = C::temp_writable_gpr(ctx);
    let v3 = constructor_writable_gpr_to_r_reg(ctx, v1);
    let v2 = MInst::Setcc {
        cc: arg0.clone(),
        dst: v1,
    };
    let v4 = ConsumesFlags::ConsumesFlagsReturnsReg {
        inst: v2,
        result: v3,
    };
    // Rule at src/isa/x64/inst.isle line 3249.
    return v4;
}

// Generated as internal constructor for term x64_setcc_paired.
pub fn constructor_x64_setcc_paired<C: Context>(
    ctx: &mut C,
    arg0: &CC,
) -> ConsumesFlags {
    let v1 = C::temp_writable_gpr(ctx);
    let v3 = constructor_writable_gpr_to_r_reg(ctx, v1);
    let v2 = MInst::Setcc {
        cc: arg0.clone(),
        dst: v1,
    };
    let v4 = ConsumesFlags::ConsumesFlagsReturnsResultWithProducer {
        inst: v2,
        result: v3,
    };
    // Rule at src/isa/x64/inst.isle line 3258.
    return v4;
}

// Generated as internal constructor for term x64_paddb.
pub fn constructor_x64_paddb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3268.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3266.
    return v4;
}

// Generated as internal constructor for term x64_paddw.
pub fn constructor_x64_paddw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3276.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3274.
    return v4;
}

// Generated as internal constructor for term x64_paddd.
pub fn constructor_x64_paddd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3284.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3282.
    return v4;
}

// Generated as internal constructor for term x64_paddq.
pub fn constructor_x64_paddq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3292.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3290.
    return v4;
}

// Generated as internal constructor for term x64_paddsb.
pub fn constructor_x64_paddsb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3300.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3298.
    return v4;
}

// Generated as internal constructor for term x64_paddsw.
pub fn constructor_x64_paddsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3308.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3306.
    return v4;
}

// Generated as internal constructor for term x64_phaddw.
pub fn constructor_x64_phaddw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vphaddw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3316.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Phaddw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3314.
    return v4;
}

// Generated as internal constructor for term x64_phaddd.
pub fn constructor_x64_phaddd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vphaddd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3324.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Phaddd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3322.
    return v4;
}

// Generated as internal constructor for term x64_paddusb.
pub fn constructor_x64_paddusb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddusb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3332.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddusb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3330.
    return v4;
}

// Generated as internal constructor for term x64_paddusw.
pub fn constructor_x64_paddusw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpaddusw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3340.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Paddusw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3338.
    return v4;
}

// Generated as internal constructor for term x64_psubb.
pub fn constructor_x64_psubb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3348.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3346.
    return v4;
}

// Generated as internal constructor for term x64_psubw.
pub fn constructor_x64_psubw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3356.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3354.
    return v4;
}

// Generated as internal constructor for term x64_psubd.
pub fn constructor_x64_psubd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3364.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3362.
    return v4;
}

// Generated as internal constructor for term x64_psubq.
pub fn constructor_x64_psubq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3372.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3370.
    return v4;
}

// Generated as internal constructor for term x64_psubsb.
pub fn constructor_x64_psubsb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3380.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3378.
    return v4;
}

// Generated as internal constructor for term x64_psubsw.
pub fn constructor_x64_psubsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3388.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3386.
    return v4;
}

// Generated as internal constructor for term x64_psubusb.
pub fn constructor_x64_psubusb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubusb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3396.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubusb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3394.
    return v4;
}

// Generated as internal constructor for term x64_psubusw.
pub fn constructor_x64_psubusw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsubusw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3404.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Psubusw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3402.
    return v4;
}

// Generated as internal constructor for term x64_pavgb.
pub fn constructor_x64_pavgb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpavgb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3412.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pavgb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3410.
    return v4;
}

// Generated as internal constructor for term x64_pavgw.
pub fn constructor_x64_pavgw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpavgw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3420.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pavgw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3418.
    return v4;
}

// Generated as internal constructor for term x64_pand.
pub fn constructor_x64_pand<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpand, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3428.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pand, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3426.
    return v4;
}

// Generated as internal constructor for term x64_andps.
pub fn constructor_x64_andps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3436.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3434.
    return v4;
}

// Generated as internal constructor for term x64_andpd.
pub fn constructor_x64_andpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3444.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3442.
    return v4;
}

// Generated as internal constructor for term x64_por.
pub fn constructor_x64_por<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpor, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3452.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Por, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3450.
    return v4;
}

// Generated as internal constructor for term x64_orps.
pub fn constructor_x64_orps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vorps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3460.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Orps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3458.
    return v4;
}

// Generated as internal constructor for term x64_orpd.
pub fn constructor_x64_orpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vorpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3468.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Orpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3466.
    return v4;
}

// Generated as internal constructor for term x64_pxor.
pub fn constructor_x64_pxor<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpxor, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3476.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pxor, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3474.
    return v4;
}

// Generated as internal constructor for term x64_xorps.
pub fn constructor_x64_xorps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vxorps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3484.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Xorps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3482.
    return v4;
}

// Generated as internal constructor for term x64_xorpd.
pub fn constructor_x64_xorpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vxorpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3492.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Xorpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3490.
    return v4;
}

// Generated as internal constructor for term x64_pmullw.
pub fn constructor_x64_pmullw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmullw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3500.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmullw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3498.
    return v4;
}

// Generated as internal constructor for term x64_pmulld.
pub fn constructor_x64_pmulld<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulld, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3508.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3506.
    return v4;
}

// Generated as internal constructor for term x64_pmulhw.
pub fn constructor_x64_pmulhw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3516.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3514.
    return v4;
}

// Generated as internal constructor for term x64_pmulhrsw.
pub fn constructor_x64_pmulhrsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhrsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3524.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhrsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3522.
    return v4;
}

// Generated as internal constructor for term x64_pmulhuw.
pub fn constructor_x64_pmulhuw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmulhuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3532.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmulhuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3530.
    return v4;
}

// Generated as internal constructor for term x64_pmuldq.
pub fn constructor_x64_pmuldq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmuldq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3540.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmuldq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3538.
    return v4;
}

// Generated as internal constructor for term x64_pmuludq.
pub fn constructor_x64_pmuludq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmuludq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3548.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmuludq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3546.
    return v4;
}

// Generated as internal constructor for term x64_punpckhwd.
pub fn constructor_x64_punpckhwd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3556.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3554.
    return v4;
}

// Generated as internal constructor for term x64_punpcklwd.
pub fn constructor_x64_punpcklwd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3564.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3562.
    return v4;
}

// Generated as internal constructor for term x64_punpckldq.
pub fn constructor_x64_punpckldq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckldq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3572.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckldq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3570.
    return v4;
}

// Generated as internal constructor for term x64_punpckhdq.
pub fn constructor_x64_punpckhdq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3580.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3578.
    return v4;
}

// Generated as internal constructor for term x64_punpcklqdq.
pub fn constructor_x64_punpcklqdq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklqdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3588.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklqdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3586.
    return v4;
}

// Generated as internal constructor for term x64_punpckhqdq.
pub fn constructor_x64_punpckhqdq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhqdq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3596.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhqdq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3594.
    return v4;
}

// Generated as internal constructor for term x64_unpcklps.
pub fn constructor_x64_unpcklps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vunpcklps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3604.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Unpcklps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3602.
    return v4;
}

// Generated as internal constructor for term x64_unpcklpd.
pub fn constructor_x64_unpcklpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vunpcklpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3612.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Unpcklpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3610.
    return v4;
}

// Generated as internal constructor for term x64_unpckhps.
pub fn constructor_x64_unpckhps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vunpckhps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3620.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Unpckhps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3618.
    return v4;
}

// Generated as internal constructor for term x64_andnps.
pub fn constructor_x64_andnps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandnps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3628.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andnps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3626.
    return v4;
}

// Generated as internal constructor for term x64_andnpd.
pub fn constructor_x64_andnpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vandnpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3636.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Andnpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3634.
    return v4;
}

// Generated as internal constructor for term x64_pandn.
pub fn constructor_x64_pandn<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpandn, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3644.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pandn, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3642.
    return v4;
}

// Generated as internal constructor for term x64_addss.
pub fn constructor_x64_addss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3652.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Addss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3650.
    return v3;
}

// Generated as internal constructor for term x64_addsd.
pub fn constructor_x64_addsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3660.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Addsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3658.
    return v3;
}

// Generated as internal constructor for term x64_addps.
pub fn constructor_x64_addps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3668.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Addps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3666.
    return v4;
}

// Generated as internal constructor for term x64_addpd.
pub fn constructor_x64_addpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vaddpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3676.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Addpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3674.
    return v4;
}

// Generated as internal constructor for term x64_subss.
pub fn constructor_x64_subss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3684.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Subss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3682.
    return v3;
}

// Generated as internal constructor for term x64_subsd.
pub fn constructor_x64_subsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3692.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Subsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3690.
    return v3;
}

// Generated as internal constructor for term x64_subps.
pub fn constructor_x64_subps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3700.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Subps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3698.
    return v4;
}

// Generated as internal constructor for term x64_subpd.
pub fn constructor_x64_subpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsubpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3708.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Subpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3706.
    return v4;
}

// Generated as internal constructor for term x64_mulss.
pub fn constructor_x64_mulss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3716.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Mulss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3714.
    return v3;
}

// Generated as internal constructor for term x64_mulsd.
pub fn constructor_x64_mulsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3724.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Mulsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3722.
    return v3;
}

// Generated as internal constructor for term x64_mulps.
pub fn constructor_x64_mulps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3732.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Mulps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3730.
    return v4;
}

// Generated as internal constructor for term x64_mulpd.
pub fn constructor_x64_mulpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmulpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3740.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Mulpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3738.
    return v4;
}

// Generated as internal constructor for term x64_divss.
pub fn constructor_x64_divss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3748.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Divss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3746.
    return v3;
}

// Generated as internal constructor for term x64_divsd.
pub fn constructor_x64_divsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 3756.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Divsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 3754.
    return v3;
}

// Generated as internal constructor for term x64_divps.
pub fn constructor_x64_divps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3764.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Divps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3762.
    return v4;
}

// Generated as internal constructor for term x64_divpd.
pub fn constructor_x64_divpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vdivpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3772.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Divpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3770.
    return v4;
}

// Generated as internal constructor for term x64_blendvpd.
pub fn constructor_x64_blendvpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vblendvpd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3780.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Blendvpd, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3778.
    return v5;
}

// Generated as internal constructor for term x64_blendvps.
pub fn constructor_x64_blendvps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vblendvps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3788.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Blendvps, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3786.
    return v5;
}

// Generated as internal constructor for term x64_pblendvb.
pub fn constructor_x64_pblendvb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: Xmm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = constructor_xmm_rmr_blend_vex(ctx, &AvxOpcode::Vpblendvb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3796.
        return v8;
    }
    let v4 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v5 = constructor_xmm_rm_r_blend(ctx, &SseOpcode::Pblendvb, arg0, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 3794.
    return v5;
}

// Generated as internal constructor for term x64_pblendw.
pub fn constructor_x64_pblendw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vpblendw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3804.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pblendw, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3802.
    return v7;
}

// Generated as internal constructor for term x64_movsd_regmove.
pub fn constructor_x64_movsd_regmove<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: Xmm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3819.
        return v8;
    }
    let v3 = &C::xmm_to_xmm_mem(ctx, arg1);
    let v4 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Movsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3817.
    return v4;
}

// Generated as internal constructor for term x64_movss_regmove.
pub fn constructor_x64_movss_regmove<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: Xmm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovss, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3826.
        return v8;
    }
    let v3 = &C::xmm_to_xmm_mem(ctx, arg1);
    let v4 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Movss, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3824.
    return v4;
}

// Generated as internal constructor for term x64_movlhps.
pub fn constructor_x64_movlhps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmovlhps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3834.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Movlhps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3832.
    return v4;
}

// Generated as internal constructor for term x64_pmaxs.
pub fn constructor_x64_pmaxs<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pmaxsb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3840.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pmaxsw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3841.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pmaxsd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3842.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pmaxs", "src/isa/x64/inst.isle line 3839")
}

// Generated as internal constructor for term x64_pmaxsb.
pub fn constructor_x64_pmaxsb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3846.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3845.
    return v4;
}

// Generated as internal constructor for term x64_pmaxsw.
pub fn constructor_x64_pmaxsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3851.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3850.
    return v4;
}

// Generated as internal constructor for term x64_pmaxsd.
pub fn constructor_x64_pmaxsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3856.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3855.
    return v4;
}

// Generated as internal constructor for term x64_pmins.
pub fn constructor_x64_pmins<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pminsb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3862.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pminsw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3863.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pminsd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3864.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pmins", "src/isa/x64/inst.isle line 3861")
}

// Generated as internal constructor for term x64_pminsb.
pub fn constructor_x64_pminsb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3868.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3867.
    return v4;
}

// Generated as internal constructor for term x64_pminsw.
pub fn constructor_x64_pminsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3873.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3872.
    return v4;
}

// Generated as internal constructor for term x64_pminsd.
pub fn constructor_x64_pminsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminsd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3878.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminsd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3877.
    return v4;
}

// Generated as internal constructor for term x64_pmaxu.
pub fn constructor_x64_pmaxu<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pmaxub(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3884.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pmaxuw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3885.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pmaxud(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3886.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pmaxu", "src/isa/x64/inst.isle line 3883")
}

// Generated as internal constructor for term x64_pmaxub.
pub fn constructor_x64_pmaxub<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxub, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3890.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxub, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3889.
    return v4;
}

// Generated as internal constructor for term x64_pmaxuw.
pub fn constructor_x64_pmaxuw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3895.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3894.
    return v4;
}

// Generated as internal constructor for term x64_pmaxud.
pub fn constructor_x64_pmaxud<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaxud, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3900.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaxud, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3899.
    return v4;
}

// Generated as internal constructor for term x64_pminu.
pub fn constructor_x64_pminu<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pminub(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3906.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pminuw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3907.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pminud(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 3908.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pminu", "src/isa/x64/inst.isle line 3905")
}

// Generated as internal constructor for term x64_pminub.
pub fn constructor_x64_pminub<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminub, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3912.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminub, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3911.
    return v4;
}

// Generated as internal constructor for term x64_pminuw.
pub fn constructor_x64_pminuw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminuw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3917.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminuw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3916.
    return v4;
}

// Generated as internal constructor for term x64_pminud.
pub fn constructor_x64_pminud<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpminud, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3922.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pminud, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3921.
    return v4;
}

// Generated as internal constructor for term x64_punpcklbw.
pub fn constructor_x64_punpcklbw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpcklbw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3930.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpcklbw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3928.
    return v4;
}

// Generated as internal constructor for term x64_punpckhbw.
pub fn constructor_x64_punpckhbw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpunpckhbw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3938.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Punpckhbw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3936.
    return v4;
}

// Generated as internal constructor for term x64_packsswb.
pub fn constructor_x64_packsswb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpacksswb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3946.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packsswb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3944.
    return v4;
}

// Generated as internal constructor for term x64_packssdw.
pub fn constructor_x64_packssdw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackssdw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3954.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packssdw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3952.
    return v4;
}

// Generated as internal constructor for term x64_packuswb.
pub fn constructor_x64_packuswb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackuswb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3962.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packuswb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3960.
    return v4;
}

// Generated as internal constructor for term x64_packusdw.
pub fn constructor_x64_packusdw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpackusdw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 3970.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Packusdw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 3968.
    return v4;
}

// Generated as internal constructor for term x64_palignr.
pub fn constructor_x64_palignr<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vpalignr, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 3982.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Palignr, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3976.
    return v7;
}

// Generated as internal constructor for term x64_cmpp.
pub fn constructor_x64_cmpp<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
    arg3: &FcmpImm,
) -> Xmm {
    match arg0 {
        F32X4 => {
            let v4 = constructor_x64_cmpps(ctx, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 3988.
            return v4;
        }
        F64X2 => {
            let v5 = constructor_x64_cmppd(ctx, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 3989.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_cmpp", "src/isa/x64/inst.isle line 3987")
}

// Generated as internal constructor for term x64_cmpps.
pub fn constructor_x64_cmpps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Xmm {
    let v9 = C::use_avx(ctx);
    if v9 == true {
        let v11 = C::encode_fcmp_imm(ctx, arg2);
        let v12 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vcmpps, arg0, arg1, v11);
        // Rule at src/isa/x64/inst.isle line 3998.
        return v12;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v6 = C::encode_fcmp_imm(ctx, arg2);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v8 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Cmpps, v4, v5, v6, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 3992.
    return v8;
}

// Generated as internal constructor for term x64_cmppd.
pub fn constructor_x64_cmppd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: &FcmpImm,
) -> Xmm {
    let v9 = C::use_avx(ctx);
    if v9 == true {
        let v11 = C::encode_fcmp_imm(ctx, arg2);
        let v12 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vcmppd, arg0, arg1, v11);
        // Rule at src/isa/x64/inst.isle line 4015.
        return v12;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v6 = C::encode_fcmp_imm(ctx, arg2);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v8 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Cmppd, v4, v5, v6, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4009.
    return v8;
}

// Generated as internal constructor for term x64_pinsrb.
pub fn constructor_x64_pinsrb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4030.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrb, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4024.
    return v7;
}

// Generated as internal constructor for term x64_pinsrw.
pub fn constructor_x64_pinsrw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4042.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrw, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4036.
    return v7;
}

// Generated as internal constructor for term x64_pinsrd.
pub fn constructor_x64_pinsrd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4054.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrd, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4048.
    return v7;
}

// Generated as internal constructor for term x64_pinsrq.
pub fn constructor_x64_pinsrq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &GprMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_vex_pinsr(ctx, &AvxOpcode::Vpinsrq, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4066.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::gpr_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Pinsrd, v4, v5, arg2, &OperandSize::Size64);
    // Rule at src/isa/x64/inst.isle line 4060.
    return v7;
}

// Generated as internal constructor for term x64_roundss.
pub fn constructor_x64_roundss<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: &RoundImm,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = C::encode_round_imm(ctx, arg1);
        let v11 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundss, arg0, v10);
        // Rule at src/isa/x64/inst.isle line 4091.
        return v11;
    }
    let v4 = constructor_put_xmm_mem_in_xmm(ctx, F32, arg0);
    let v5 = &constructor_xmm_to_xmm_mem_aligned(ctx, v4);
    let v6 = C::encode_round_imm(ctx, arg1);
    let v7 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundss, v5, v6);
    // Rule at src/isa/x64/inst.isle line 4089.
    return v7;
}

// Generated as internal constructor for term x64_roundsd.
pub fn constructor_x64_roundsd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: &RoundImm,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = C::encode_round_imm(ctx, arg1);
        let v11 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundsd, arg0, v10);
        // Rule at src/isa/x64/inst.isle line 4101.
        return v11;
    }
    let v4 = constructor_put_xmm_mem_in_xmm(ctx, F64, arg0);
    let v5 = &constructor_xmm_to_xmm_mem_aligned(ctx, v4);
    let v6 = C::encode_round_imm(ctx, arg1);
    let v7 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundsd, v5, v6);
    // Rule at src/isa/x64/inst.isle line 4099.
    return v7;
}

// Generated as internal constructor for term put_xmm_mem_in_xmm.
pub fn constructor_put_xmm_mem_in_xmm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &XmmMem,
) -> Xmm {
    let v2 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    match v2 {
        &RegMem::Reg {
            reg: v3,
        } => {
            let v4 = C::xmm_new(ctx, v3);
            // Rule at src/isa/x64/inst.isle line 4110.
            return v4;
        }
        &RegMem::Mem {
            addr: ref v5,
        } => {
            let v7 = constructor_x64_load(ctx, arg0, v5, &ExtKind::None);
            let v8 = C::xmm_new(ctx, v7);
            // Rule at src/isa/x64/inst.isle line 4113.
            return v8;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "put_xmm_mem_in_xmm", "src/isa/x64/inst.isle line 4109")
}

// Generated as internal constructor for term x64_roundps.
pub fn constructor_x64_roundps<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: &RoundImm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundps, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 4121.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundps, v3, v4);
    // Rule at src/isa/x64/inst.isle line 4119.
    return v5;
}

// Generated as internal constructor for term x64_roundpd.
pub fn constructor_x64_roundpd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: &RoundImm,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v8 = C::encode_round_imm(ctx, arg1);
        let v9 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vroundpd, arg0, v8);
        // Rule at src/isa/x64/inst.isle line 4129.
        return v9;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = C::encode_round_imm(ctx, arg1);
    let v5 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Roundpd, v3, v4);
    // Rule at src/isa/x64/inst.isle line 4127.
    return v5;
}

// Generated as internal constructor for term x64_pmaddwd.
pub fn constructor_x64_pmaddwd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaddwd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4137.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaddwd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4135.
    return v4;
}

// Generated as internal constructor for term x64_pmaddubsw.
pub fn constructor_x64_pmaddubsw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpmaddubsw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4144.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pmaddubsw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4142.
    return v4;
}

// Generated as internal constructor for term x64_insertps.
pub fn constructor_x64_insertps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vinsertps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4156.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Insertps, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4150.
    return v7;
}

// Generated as internal constructor for term x64_pshufd.
pub fn constructor_x64_pshufd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: u8,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshufd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4164.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshufd, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 4162.
    return v4;
}

// Generated as internal constructor for term x64_pshufb.
pub fn constructor_x64_pshufb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpshufb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4172.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pshufb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4170.
    return v4;
}

// Generated as internal constructor for term x64_pshuflw.
pub fn constructor_x64_pshuflw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: u8,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshuflw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4180.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshuflw, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 4178.
    return v4;
}

// Generated as internal constructor for term x64_pshufhw.
pub fn constructor_x64_pshufhw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: u8,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_unary_rm_r_imm_vex(ctx, &AvxOpcode::Vpshufhw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4188.
        return v7;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v4 = constructor_xmm_unary_rm_r_imm(ctx, &SseOpcode::Pshufhw, v3, arg1);
    // Rule at src/isa/x64/inst.isle line 4186.
    return v4;
}

// Generated as internal constructor for term x64_shufps.
pub fn constructor_x64_shufps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
    arg2: u8,
) -> Xmm {
    let v8 = C::use_avx(ctx);
    if v8 == true {
        let v10 = constructor_xmm_rmr_imm_vex(ctx, &AvxOpcode::Vshufps, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4200.
        return v10;
    }
    let v4 = C::xmm_to_reg(ctx, arg0);
    let v5 = &C::xmm_mem_to_reg_mem(ctx, arg1);
    let v7 = constructor_xmm_rm_r_imm(ctx, &SseOpcode::Shufps, v4, v5, arg2, &OperandSize::Size32);
    // Rule at src/isa/x64/inst.isle line 4194.
    return v7;
}

// Generated as internal constructor for term x64_pabsb.
pub fn constructor_x64_pabsb<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsb, arg0);
        // Rule at src/isa/x64/inst.isle line 4208.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsb, v2);
    // Rule at src/isa/x64/inst.isle line 4206.
    return v3;
}

// Generated as internal constructor for term x64_pabsw.
pub fn constructor_x64_pabsw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsw, arg0);
        // Rule at src/isa/x64/inst.isle line 4216.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsw, v2);
    // Rule at src/isa/x64/inst.isle line 4214.
    return v3;
}

// Generated as internal constructor for term x64_pabsd.
pub fn constructor_x64_pabsd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpabsd, arg0);
        // Rule at src/isa/x64/inst.isle line 4224.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Pabsd, v2);
    // Rule at src/isa/x64/inst.isle line 4222.
    return v3;
}

// Generated as internal constructor for term x64_vcvtudq2ps.
pub fn constructor_x64_vcvtudq2ps<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vcvtudq2ps, arg0);
    // Rule at src/isa/x64/inst.isle line 4230.
    return v2;
}

// Generated as internal constructor for term x64_vpabsq.
pub fn constructor_x64_vpabsq<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vpabsq, arg0);
    // Rule at src/isa/x64/inst.isle line 4235.
    return v2;
}

// Generated as internal constructor for term x64_vpopcntb.
pub fn constructor_x64_vpopcntb<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_evex(ctx, &Avx512Opcode::Vpopcntb, arg0);
    // Rule at src/isa/x64/inst.isle line 4240.
    return v2;
}

// Generated as internal constructor for term x64_vpmullq.
pub fn constructor_x64_vpmullq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v3 = constructor_xmm_rm_r_evex(ctx, &Avx512Opcode::Vpmullq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4247.
    return v3;
}

// Generated as internal constructor for term x64_vpermi2b.
pub fn constructor_x64_vpermi2b<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    let v3 = C::temp_writable_xmm(ctx);
    let v5 = MInst::XmmRmREvex3 {
        op: Avx512Opcode::Vpermi2b,
        src1: arg0,
        src2: arg1,
        src3: arg2.clone(),
        dst: v3,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_xmm_to_xmm(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 4256.
    return v7;
}

// Generated as internal constructor for term x64_psllw.
pub fn constructor_x64_psllw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsllw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4269.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psllw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4267.
    return v4;
}

// Generated as internal constructor for term x64_pslld.
pub fn constructor_x64_pslld<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpslld, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4277.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Pslld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4275.
    return v4;
}

// Generated as internal constructor for term x64_psllq.
pub fn constructor_x64_psllq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsllq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4285.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psllq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4283.
    return v4;
}

// Generated as internal constructor for term x64_psrlw.
pub fn constructor_x64_psrlw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrlw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4293.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrlw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4291.
    return v4;
}

// Generated as internal constructor for term x64_psrld.
pub fn constructor_x64_psrld<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrld, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4301.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrld, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4299.
    return v4;
}

// Generated as internal constructor for term x64_psrlq.
pub fn constructor_x64_psrlq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrlq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4309.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrlq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4307.
    return v4;
}

// Generated as internal constructor for term x64_psraw.
pub fn constructor_x64_psraw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsraw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4317.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psraw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4315.
    return v4;
}

// Generated as internal constructor for term x64_psrad.
pub fn constructor_x64_psrad<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMemImm,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpsrad, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4325.
        return v7;
    }
    let v3 = &C::xmm_mem_imm_to_xmm_mem_aligned_imm(ctx, arg1);
    let v4 = constructor_xmm_rmi_xmm(ctx, &SseOpcode::Psrad, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4323.
    return v4;
}

// Generated as internal constructor for term x64_vpsraq.
pub fn constructor_x64_vpsraq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v3 = constructor_xmm_rm_r_evex(ctx, &Avx512Opcode::Vpsraq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4331.
    return v3;
}

// Generated as internal constructor for term x64_vpsraq_imm.
pub fn constructor_x64_vpsraq_imm<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
    arg1: u8,
) -> Xmm {
    let v3 = constructor_xmm_unary_rm_r_imm_evex(ctx, &Avx512Opcode::VpsraqImm, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4336.
    return v3;
}

// Generated as internal constructor for term x64_pextrb.
pub fn constructor_x64_pextrb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: u8,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrb, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4343.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrb, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4341.
    return v3;
}

// Generated as internal constructor for term x64_pextrb_store.
pub fn constructor_x64_pextrb_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrb, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4350.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrb, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4348.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrw.
pub fn constructor_x64_pextrw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: u8,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrw, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4358.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrw, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4356.
    return v3;
}

// Generated as internal constructor for term x64_pextrw_store.
pub fn constructor_x64_pextrw_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrw, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4365.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrw, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4363.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrd.
pub fn constructor_x64_pextrd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: u8,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrd, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4373.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4371.
    return v3;
}

// Generated as internal constructor for term x64_pextrd_store.
pub fn constructor_x64_pextrd_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrd, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4380.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrd, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4378.
    return v4.clone();
}

// Generated as internal constructor for term x64_pextrq.
pub fn constructor_x64_pextrq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: u8,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_imm_vex(ctx, &AvxOpcode::Vpextrq, arg0, arg1);
        // Rule at src/isa/x64/inst.isle line 4388.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr_imm(ctx, &SseOpcode::Pextrq, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4386.
    return v3;
}

// Generated as internal constructor for term x64_pextrq_store.
pub fn constructor_x64_pextrq_store<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: Xmm,
    arg2: u8,
) -> SideEffectNoResult {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &constructor_xmm_movrm_imm_vex(ctx, &AvxOpcode::Vpextrq, arg0, arg1, arg2);
        // Rule at src/isa/x64/inst.isle line 4395.
        return v7.clone();
    }
    let v4 = &constructor_xmm_movrm_imm(ctx, &SseOpcode::Pextrq, arg0, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4393.
    return v4.clone();
}

// Generated as internal constructor for term x64_pmovmskb.
pub fn constructor_x64_pmovmskb<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Xmm,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vpmovmskb, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4403.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Pmovmskb, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4401.
    return v3;
}

// Generated as internal constructor for term x64_movmskps.
pub fn constructor_x64_movmskps<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Xmm,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovmskps, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4411.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movmskps, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4409.
    return v3;
}

// Generated as internal constructor for term x64_movmskpd.
pub fn constructor_x64_movmskpd<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Xmm,
) -> Gpr {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_to_gpr_vex(ctx, &AvxOpcode::Vmovmskpd, arg1, arg0);
        // Rule at src/isa/x64/inst.isle line 4419.
        return v6;
    }
    let v3 = constructor_xmm_to_gpr(ctx, &SseOpcode::Movmskpd, arg1, arg0);
    // Rule at src/isa/x64/inst.isle line 4417.
    return v3;
}

// Generated as internal constructor for term x64_not.
pub fn constructor_x64_not<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::Not {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4425.
    return v6;
}

// Generated as internal constructor for term x64_neg.
pub fn constructor_x64_neg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v4 = MInst::Neg {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4433.
    return v6;
}

// Generated as internal constructor for term x64_neg_paired.
pub fn constructor_x64_neg_paired<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v4 = MInst::Neg {
        size: v3.clone(),
        src: arg1,
        dst: v2,
    };
    let v6 = ProducesFlags::ProducesFlagsReturnsResultWithConsumer {
        inst: v4,
        result: v5,
    };
    // Rule at src/isa/x64/inst.isle line 4441.
    return v6;
}

// Generated as internal constructor for term x64_lea.
pub fn constructor_x64_lea<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &SyntheticAmode,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = MInst::LoadEffectiveAddress {
        addr: arg1.clone(),
        dst: v2,
        size: v3.clone(),
    };
    let v5 = C::emit(ctx, &v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 4451.
    return v6;
}

// Generated as internal constructor for term x64_ud2.
pub fn constructor_x64_ud2<C: Context>(
    ctx: &mut C,
    arg0: &TrapCode,
) -> SideEffectNoResult {
    let v1 = MInst::Ud2 {
        trap_code: arg0.clone(),
    };
    let v2 = SideEffectNoResult::Inst {
        inst: v1,
    };
    // Rule at src/isa/x64/inst.isle line 4458.
    return v2;
}

// Generated as internal constructor for term x64_hlt.
pub fn constructor_x64_hlt<C: Context>(
    ctx: &mut C,
) -> SideEffectNoResult {
    let v1 = SideEffectNoResult::Inst {
        inst: MInst::Hlt,
    };
    // Rule at src/isa/x64/inst.isle line 4463.
    return v1;
}

// Generated as internal constructor for term x64_lzcnt.
pub fn constructor_x64_lzcnt<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Lzcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4468.
    return v4;
}

// Generated as internal constructor for term x64_tzcnt.
pub fn constructor_x64_tzcnt<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Tzcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4473.
    return v4;
}

// Generated as internal constructor for term x64_bsr.
pub fn constructor_x64_bsr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v6 = MInst::UnaryRmR {
        size: v3.clone(),
        op: UnaryRmROpcode::Bsr,
        src: v5.clone(),
        dst: v2,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 4478.
    return v8;
}

// Generated as internal constructor for term bsr_or_else.
pub fn constructor_bsr_or_else<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
) -> Gpr {
    let v3 = &constructor_x64_bsr(ctx, arg0, arg1);
    let v4 = constructor_produces_flags_get_reg(ctx, v3);
    let v5 = C::gpr_new(ctx, v4);
    let v7 = &C::gpr_to_gpr_mem(ctx, arg2);
    let v8 = &constructor_cmove(ctx, arg0, &CC::Z, v7, v5);
    let v9 = &constructor_produces_flags_ignore(ctx, v3);
    let v10 = constructor_with_flags_reg(ctx, v9, v8);
    let v11 = C::gpr_new(ctx, v10);
    // Rule at src/isa/x64/inst.isle line 4487.
    return v11;
}

// Generated as internal constructor for term x64_bsf.
pub fn constructor_x64_bsf<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> ProducesFlags {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::gpr_to_gpr_mem(ctx, arg1);
    let v7 = constructor_writable_gpr_to_r_reg(ctx, v2);
    let v6 = MInst::UnaryRmR {
        size: v3.clone(),
        op: UnaryRmROpcode::Bsf,
        src: v5.clone(),
        dst: v2,
    };
    let v8 = ProducesFlags::ProducesFlagsReturnsReg {
        inst: v6,
        result: v7,
    };
    // Rule at src/isa/x64/inst.isle line 4498.
    return v8;
}

// Generated as internal constructor for term bsf_or_else.
pub fn constructor_bsf_or_else<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
) -> Gpr {
    let v3 = &constructor_x64_bsf(ctx, arg0, arg1);
    let v4 = constructor_produces_flags_get_reg(ctx, v3);
    let v5 = C::gpr_new(ctx, v4);
    let v7 = &C::gpr_to_gpr_mem(ctx, arg2);
    let v8 = &constructor_cmove(ctx, arg0, &CC::Z, v7, v5);
    let v9 = &constructor_produces_flags_ignore(ctx, v3);
    let v10 = constructor_with_flags_reg(ctx, v9, v8);
    let v11 = C::gpr_new(ctx, v10);
    // Rule at src/isa/x64/inst.isle line 4507.
    return v11;
}

// Generated as internal constructor for term x64_blsi.
pub fn constructor_x64_blsi<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsi, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4518.
    return v4;
}

// Generated as internal constructor for term x64_blsmsk.
pub fn constructor_x64_blsmsk<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsmsk, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4523.
    return v4;
}

// Generated as internal constructor for term x64_blsr.
pub fn constructor_x64_blsr<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r_vex(ctx, &UnaryRmRVexOpcode::Blsr, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4528.
    return v4;
}

// Generated as internal constructor for term x64_sarx.
pub fn constructor_x64_sarx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: Gpr,
) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Sarx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4533.
    return v4;
}

// Generated as internal constructor for term x64_shrx.
pub fn constructor_x64_shrx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: Gpr,
) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Shrx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4538.
    return v4;
}

// Generated as internal constructor for term x64_shlx.
pub fn constructor_x64_shlx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: Gpr,
) -> Gpr {
    let v4 = constructor_alu_rm_r_vex(ctx, arg0, &AluRmROpcode::Shlx, arg2, arg1);
    // Rule at src/isa/x64/inst.isle line 4543.
    return v4;
}

// Generated as internal constructor for term x64_rorx.
pub fn constructor_x64_rorx<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &GprMem,
    arg2: u8,
) -> Gpr {
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = constructor_unary_rm_r_imm_vex(ctx, &UnaryRmRImmVexOpcode::Rorx, arg1, v4, arg2);
    // Rule at src/isa/x64/inst.isle line 4548.
    return v5;
}

// Generated as internal constructor for term x64_popcnt.
pub fn constructor_x64_popcnt<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
) -> Gpr {
    let v3 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v4 = constructor_unary_rm_r(ctx, &UnaryRmROpcode::Popcnt, arg1, v3);
    // Rule at src/isa/x64/inst.isle line 4556.
    return v4;
}

// Generated as internal constructor for term x64_minss.
pub fn constructor_x64_minss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4563.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Minss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4561.
    return v3;
}

// Generated as internal constructor for term x64_minsd.
pub fn constructor_x64_minsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4571.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Minsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4569.
    return v3;
}

// Generated as internal constructor for term x64_minps.
pub fn constructor_x64_minps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4579.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Minps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4577.
    return v4;
}

// Generated as internal constructor for term x64_minpd.
pub fn constructor_x64_minpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vminpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4587.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Minpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4585.
    return v4;
}

// Generated as internal constructor for term x64_maxss.
pub fn constructor_x64_maxss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4595.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Maxss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4593.
    return v3;
}

// Generated as internal constructor for term x64_maxsd.
pub fn constructor_x64_maxsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4603.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Maxsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4601.
    return v3;
}

// Generated as internal constructor for term x64_maxps.
pub fn constructor_x64_maxps<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxps, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4611.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Maxps, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4609.
    return v4;
}

// Generated as internal constructor for term x64_maxpd.
pub fn constructor_x64_maxpd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vmaxpd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4619.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Maxpd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4617.
    return v4;
}

// Generated as internal constructor for term x64_vfmadd213.
pub fn constructor_x64_vfmadd213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4625.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4626.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4627.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4628.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfmadd213", "src/isa/x64/inst.isle line 4624")
}

// Generated as internal constructor for term x64_vfmadd132.
pub fn constructor_x64_vfmadd132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4632.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4633.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4634.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmadd132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4635.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfmadd132", "src/isa/x64/inst.isle line 4631")
}

// Generated as internal constructor for term x64_vfnmadd213.
pub fn constructor_x64_vfnmadd213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4639.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4640.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4641.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4642.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfnmadd213", "src/isa/x64/inst.isle line 4638")
}

// Generated as internal constructor for term x64_vfnmadd132.
pub fn constructor_x64_vfnmadd132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4646.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4647.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4648.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmadd132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4649.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfnmadd132", "src/isa/x64/inst.isle line 4645")
}

// Generated as internal constructor for term x64_vfmsub213.
pub fn constructor_x64_vfmsub213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4653.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4654.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4655.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4656.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfmsub213", "src/isa/x64/inst.isle line 4652")
}

// Generated as internal constructor for term x64_vfmsub132.
pub fn constructor_x64_vfmsub132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4660.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4661.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4662.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfmsub132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4663.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfmsub132", "src/isa/x64/inst.isle line 4659")
}

// Generated as internal constructor for term x64_vfnmsub213.
pub fn constructor_x64_vfnmsub213<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub213ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4667.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub213sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4668.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub213ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4669.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub213pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4670.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfnmsub213", "src/isa/x64/inst.isle line 4666")
}

// Generated as internal constructor for term x64_vfnmsub132.
pub fn constructor_x64_vfnmsub132<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: Xmm,
    arg3: &XmmMem,
) -> Xmm {
    match arg0 {
        F32 => {
            let v5 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub132ss, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4674.
            return v5;
        }
        F64 => {
            let v7 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub132sd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4675.
            return v7;
        }
        F32X4 => {
            let v9 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub132ps, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4676.
            return v9;
        }
        F64X2 => {
            let v11 = constructor_xmm_rmr_vex3(ctx, &AvxOpcode::Vfnmsub132pd, arg1, arg2, arg3);
            // Rule at src/isa/x64/inst.isle line 4677.
            return v11;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_vfnmsub132", "src/isa/x64/inst.isle line 4673")
}

// Generated as internal constructor for term x64_sqrtss.
pub fn constructor_x64_sqrtss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsqrtss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4693.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Sqrtss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4692.
    return v3;
}

// Generated as internal constructor for term x64_sqrtsd.
pub fn constructor_x64_sqrtsd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vsqrtsd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4702.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Sqrtsd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4701.
    return v3;
}

// Generated as internal constructor for term x64_sqrtps.
pub fn constructor_x64_sqrtps<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtps, arg0);
        // Rule at src/isa/x64/inst.isle line 4709.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Sqrtps, v2);
    // Rule at src/isa/x64/inst.isle line 4708.
    return v3;
}

// Generated as internal constructor for term x64_sqrtpd.
pub fn constructor_x64_sqrtpd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vsqrtpd, arg0);
        // Rule at src/isa/x64/inst.isle line 4716.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Sqrtpd, v2);
    // Rule at src/isa/x64/inst.isle line 4715.
    return v3;
}

// Generated as internal constructor for term x64_cvtss2sd.
pub fn constructor_x64_cvtss2sd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vcvtss2sd, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4725.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Cvtss2sd, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4724.
    return v3;
}

// Generated as internal constructor for term x64_cvtsd2ss.
pub fn constructor_x64_cvtsd2ss<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v7 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vcvtsd2ss, arg0, v6);
        // Rule at src/isa/x64/inst.isle line 4734.
        return v7;
    }
    let v3 = constructor_xmm_rm_r_unaligned(ctx, &SseOpcode::Cvtsd2ss, arg0, arg1);
    // Rule at src/isa/x64/inst.isle line 4733.
    return v3;
}

// Generated as internal constructor for term x64_cvtdq2ps.
pub fn constructor_x64_cvtdq2ps<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtdq2ps, arg0);
        // Rule at src/isa/x64/inst.isle line 4741.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtdq2ps, v2);
    // Rule at src/isa/x64/inst.isle line 4740.
    return v3;
}

// Generated as internal constructor for term x64_cvtps2pd.
pub fn constructor_x64_cvtps2pd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtps2pd, arg0);
        // Rule at src/isa/x64/inst.isle line 4748.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtps2pd, v2);
    // Rule at src/isa/x64/inst.isle line 4747.
    return v3;
}

// Generated as internal constructor for term x64_cvtpd2ps.
pub fn constructor_x64_cvtpd2ps<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtpd2ps, arg0);
        // Rule at src/isa/x64/inst.isle line 4755.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtpd2ps, v2);
    // Rule at src/isa/x64/inst.isle line 4754.
    return v3;
}

// Generated as internal constructor for term x64_cvtdq2pd.
pub fn constructor_x64_cvtdq2pd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvtdq2pd, arg0);
        // Rule at src/isa/x64/inst.isle line 4762.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvtdq2pd, v2);
    // Rule at src/isa/x64/inst.isle line 4761.
    return v3;
}

// Generated as internal constructor for term x64_cvtsi2ss.
pub fn constructor_x64_cvtsi2ss<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &GprMem,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v4 = &C::raw_operand_size_of_type(ctx, arg0);
        let v8 = constructor_cvt_int_to_float_vex(ctx, &AvxOpcode::Vcvtsi2ss, arg1, arg2, v4);
        // Rule at src/isa/x64/inst.isle line 4770.
        return v8;
    }
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_cvt_int_to_float(ctx, &SseOpcode::Cvtsi2ss, arg1, arg2, v4);
    // Rule at src/isa/x64/inst.isle line 4768.
    return v5;
}

// Generated as internal constructor for term x64_cvtsi2sd.
pub fn constructor_x64_cvtsi2sd<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &GprMem,
) -> Xmm {
    let v6 = C::use_avx(ctx);
    if v6 == true {
        let v4 = &C::raw_operand_size_of_type(ctx, arg0);
        let v8 = constructor_cvt_int_to_float_vex(ctx, &AvxOpcode::Vcvtsi2sd, arg1, arg2, v4);
        // Rule at src/isa/x64/inst.isle line 4778.
        return v8;
    }
    let v4 = &C::raw_operand_size_of_type(ctx, arg0);
    let v5 = constructor_cvt_int_to_float(ctx, &SseOpcode::Cvtsi2sd, arg1, arg2, v4);
    // Rule at src/isa/x64/inst.isle line 4776.
    return v5;
}

// Generated as internal constructor for term x64_cvttps2dq.
pub fn constructor_x64_cvttps2dq<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvttps2dq, arg0);
        // Rule at src/isa/x64/inst.isle line 4786.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvttps2dq, v2);
    // Rule at src/isa/x64/inst.isle line 4784.
    return v3;
}

// Generated as internal constructor for term x64_cvttpd2dq.
pub fn constructor_x64_cvttpd2dq<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v4 = C::use_avx(ctx);
    if v4 == true {
        let v6 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vcvttpd2dq, arg0);
        // Rule at src/isa/x64/inst.isle line 4794.
        return v6;
    }
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg0);
    let v3 = constructor_xmm_unary_rm_r(ctx, &SseOpcode::Cvttpd2dq, v2);
    // Rule at src/isa/x64/inst.isle line 4792.
    return v3;
}

// Generated as internal constructor for term x64_pcmpeq.
pub fn constructor_x64_pcmpeq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pcmpeqb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4800.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pcmpeqw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4801.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pcmpeqd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4802.
            return v5;
        }
        I64X2 => {
            let v6 = C::use_sse41(ctx);
            if v6 == true {
                let v7 = constructor_x64_pcmpeqq(ctx, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 4803.
                return v7;
            }
            let v5 = constructor_x64_pcmpeqd(ctx, arg1, arg2);
            let v8 = &C::xmm_to_xmm_mem(ctx, v5);
            let v10 = constructor_x64_pshufd(ctx, v8, 0xb1_u8);
            let v11 = &C::xmm_to_xmm_mem(ctx, v10);
            let v12 = constructor_x64_pand(ctx, v5, v11);
            // Rule at src/isa/x64/inst.isle line 4812.
            return v12;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pcmpeq", "src/isa/x64/inst.isle line 4799")
}

// Generated as internal constructor for term x64_pcmpeqb.
pub fn constructor_x64_pcmpeqb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4819.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4818.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqw.
pub fn constructor_x64_pcmpeqw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4824.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4823.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqd.
pub fn constructor_x64_pcmpeqd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4829.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4828.
    return v4;
}

// Generated as internal constructor for term x64_pcmpeqq.
pub fn constructor_x64_pcmpeqq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpeqq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4834.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpeqq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4833.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgt.
pub fn constructor_x64_pcmpgt<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Xmm,
    arg2: &XmmMem,
) -> Xmm {
    match arg0 {
        I8X16 => {
            let v3 = constructor_x64_pcmpgtb(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4840.
            return v3;
        }
        I16X8 => {
            let v4 = constructor_x64_pcmpgtw(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4841.
            return v4;
        }
        I32X4 => {
            let v5 = constructor_x64_pcmpgtd(ctx, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 4842.
            return v5;
        }
        I64X2 => {
            let v6 = C::use_sse42(ctx);
            if v6 == true {
                let v7 = constructor_x64_pcmpgtq(ctx, arg1, arg2);
                // Rule at src/isa/x64/inst.isle line 4846.
                return v7;
            }
            let v9 = C::emit_u128_le_const(ctx, 0x800000000000000080000000_u128);
            let v10 = &constructor_const_to_xmm_mem(ctx, v9);
            let v11 = constructor_x64_movdqu_load(ctx, v10);
            let v12 = &C::xmm_to_xmm_mem(ctx, arg1);
            let v13 = constructor_x64_pxor(ctx, v11, v12);
            let v14 = constructor_x64_pxor(ctx, v11, arg2);
            let v15 = &C::xmm_to_xmm_mem(ctx, v14);
            let v16 = constructor_x64_pcmpgtd(ctx, v13, v15);
            let v17 = &C::xmm_to_xmm_mem(ctx, v16);
            let v19 = constructor_x64_pshufd(ctx, v17, 0xa0_u8);
            let v20 = &C::xmm_to_xmm_mem(ctx, v16);
            let v22 = constructor_x64_pshufd(ctx, v20, 0xf5_u8);
            let v23 = &C::xmm_to_xmm_mem(ctx, v14);
            let v24 = constructor_x64_pcmpeqd(ctx, v13, v23);
            let v25 = &C::xmm_to_xmm_mem(ctx, v24);
            let v26 = constructor_x64_pshufd(ctx, v25, 0xf5_u8);
            let v27 = &C::xmm_to_xmm_mem(ctx, v26);
            let v28 = constructor_x64_pand(ctx, v19, v27);
            let v29 = &C::xmm_to_xmm_mem(ctx, v22);
            let v30 = constructor_x64_por(ctx, v28, v29);
            // Rule at src/isa/x64/inst.isle line 4875.
            return v30;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "x64_pcmpgt", "src/isa/x64/inst.isle line 4839")
}

// Generated as internal constructor for term x64_pcmpgtb.
pub fn constructor_x64_pcmpgtb<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtb, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4891.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtb, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4890.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtw.
pub fn constructor_x64_pcmpgtw<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtw, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4896.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtw, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4895.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtd.
pub fn constructor_x64_pcmpgtd<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtd, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4901.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtd, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4900.
    return v4;
}

// Generated as internal constructor for term x64_pcmpgtq.
pub fn constructor_x64_pcmpgtq<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
    arg1: &XmmMem,
) -> Xmm {
    let v5 = C::use_avx(ctx);
    if v5 == true {
        let v7 = &C::xmm_mem_to_xmm_mem_imm(ctx, arg1);
        let v8 = constructor_xmm_rmir_vex(ctx, &AvxOpcode::Vpcmpgtq, arg0, v7);
        // Rule at src/isa/x64/inst.isle line 4906.
        return v8;
    }
    let v3 = &C::xmm_mem_to_xmm_mem_aligned(ctx, arg1);
    let v4 = constructor_xmm_rm_r(ctx, &SseOpcode::Pcmpgtq, arg0, v3);
    // Rule at src/isa/x64/inst.isle line 4905.
    return v4;
}

// Generated as internal constructor for term alu_rm.
pub fn constructor_alu_rm<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AluRmiROpcode,
    arg2: &Amode,
    arg3: Gpr,
) -> SideEffectNoResult {
    let v4 = &C::operand_size_of_type_32_64(ctx, arg0);
    let v5 = &C::amode_to_synthetic_amode(ctx, arg2);
    let v6 = false;
    let v7 = MInst::AluRM {
        size: v4.clone(),
        op: arg1.clone(),
        src1_dst: v5.clone(),
        src2: arg3,
        lock: v6,
    };
    let v8 = SideEffectNoResult::Inst {
        inst: v7,
    };
    // Rule at src/isa/x64/inst.isle line 4912.
    return v8;
}

// Generated as internal constructor for term x64_add_mem.
pub fn constructor_x64_add_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Add, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4927.
    return v4.clone();
}

// Generated as internal constructor for term x64_sub_mem.
pub fn constructor_x64_sub_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Sub, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4931.
    return v4.clone();
}

// Generated as internal constructor for term x64_and_mem.
pub fn constructor_x64_and_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::And, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4935.
    return v4.clone();
}

// Generated as internal constructor for term x64_or_mem.
pub fn constructor_x64_or_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Or, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4939.
    return v4.clone();
}

// Generated as internal constructor for term x64_xor_mem.
pub fn constructor_x64_xor_mem<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &Amode,
    arg2: Gpr,
) -> SideEffectNoResult {
    let v4 = &constructor_alu_rm(ctx, arg0, &AluRmiROpcode::Xor, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 4943.
    return v4.clone();
}

// Generated as internal constructor for term trap_if.
pub fn constructor_trap_if<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &TrapCode,
) -> ConsumesFlags {
    let v2 = MInst::TrapIf {
        cc: arg0.clone(),
        trap_code: arg1.clone(),
    };
    let v3 = ConsumesFlags::ConsumesFlagsSideEffect {
        inst: v2,
    };
    // Rule at src/isa/x64/inst.isle line 4948.
    return v3;
}

// Generated as internal constructor for term trap_if_and.
pub fn constructor_trap_if_and<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &CC,
    arg2: &TrapCode,
) -> ConsumesFlags {
    let v3 = MInst::TrapIfAnd {
        cc1: arg0.clone(),
        cc2: arg1.clone(),
        trap_code: arg2.clone(),
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 4953.
    return v4;
}

// Generated as internal constructor for term trap_if_or.
pub fn constructor_trap_if_or<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: &CC,
    arg2: &TrapCode,
) -> ConsumesFlags {
    let v3 = MInst::TrapIfOr {
        cc1: arg0.clone(),
        cc2: arg1.clone(),
        trap_code: arg2.clone(),
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 4958.
    return v4;
}

// Generated as internal constructor for term trap_if_icmp.
pub fn constructor_trap_if_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: &TrapCode,
) -> SideEffectNoResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0 {
        let v4 = &constructor_trap_if(ctx, v2, arg1);
        let v5 = &constructor_with_flags_side_effect(ctx, v1, v4);
        // Rule at src/isa/x64/inst.isle line 4962.
        return v5.clone();
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "trap_if_icmp", "src/isa/x64/inst.isle line 4961")
}

// Generated as internal constructor for term trap_if_fcmp.
pub fn constructor_trap_if_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FcmpCondResult,
    arg1: &TrapCode,
) -> SideEffectNoResult {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v4 = &constructor_trap_if(ctx, v2, arg1);
            let v5 = &constructor_with_flags_side_effect(ctx, v1, v4);
            // Rule at src/isa/x64/inst.isle line 4966.
            return v5.clone();
        }
        &FcmpCondResult::AndCondition {
            producer: ref v6,
            cc1: ref v7,
            cc2: ref v8,
        } => {
            let v9 = &constructor_trap_if_and(ctx, v7, v8, arg1);
            let v10 = &constructor_with_flags_side_effect(ctx, v6, v9);
            // Rule at src/isa/x64/inst.isle line 4968.
            return v10.clone();
        }
        &FcmpCondResult::OrCondition {
            producer: ref v11,
            cc1: ref v12,
            cc2: ref v13,
        } => {
            let v14 = &constructor_trap_if_or(ctx, v12, v13, arg1);
            let v15 = &constructor_with_flags_side_effect(ctx, v11, v14);
            // Rule at src/isa/x64/inst.isle line 4970.
            return v15.clone();
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "trap_if_fcmp", "src/isa/x64/inst.isle line 4965")
}

// Generated as internal constructor for term zero_cond_to_cc.
pub fn constructor_zero_cond_to_cc<C: Context>(
    ctx: &mut C,
    arg0: &ZeroCond,
) -> CC {
    match arg0 {
        &ZeroCond::Zero => {
            // Rule at src/isa/x64/inst.isle line 4980.
            return CC::Z;
        }
        &ZeroCond::NonZero => {
            // Rule at src/isa/x64/inst.isle line 4981.
            return CC::NZ;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "zero_cond_to_cc", "src/isa/x64/inst.isle line 4979")
}

// Generated as internal constructor for term trap_if_val.
pub fn constructor_trap_if_val<C: Context>(
    ctx: &mut C,
    arg0: &ZeroCond,
    arg1: Value,
    arg2: &TrapCode,
) -> SideEffectNoResult {
    let v2 = C::value_type(ctx, arg1);
    if v2 == I128 {
        let v14 = C::put_in_regs(ctx, arg1);
        let v16 = constructor_value_regs_get_gpr(ctx, v14, 0x0_usize);
        let v17 = C::put_in_regs(ctx, arg1);
        let v19 = constructor_value_regs_get_gpr(ctx, v17, 0x1_usize);
        let v21 = &C::gpr_to_gpr_mem_imm(ctx, v16);
        let v22 = constructor_x64_or(ctx, I64, v19, v21);
        let v24 = &C::gpr_to_gpr_mem_imm(ctx, v22);
        let v25 = &constructor_x64_test(ctx, &OperandSize::Size64, v22, v24);
        let v26 = &constructor_zero_cond_to_cc(ctx, arg0);
        let v27 = &constructor_trap_if(ctx, v26, arg2);
        let v28 = &constructor_with_flags_side_effect(ctx, v25, v27);
        // Rule at src/isa/x64/inst.isle line 4990.
        return v28.clone();
    }
    let v3 = C::fits_in_64(ctx, v2);
    if let Some(v4) = v3 {
        let v6 = &C::raw_operand_size_of_type(ctx, v4);
        let v7 = C::put_in_reg(ctx, arg1);
        let v8 = C::gpr_new(ctx, v7);
        let v9 = &C::gpr_to_gpr_mem_imm(ctx, v8);
        let v10 = &constructor_x64_test(ctx, v6, v8, v9);
        let v11 = &constructor_zero_cond_to_cc(ctx, arg0);
        let v12 = &constructor_trap_if(ctx, v11, arg2);
        let v13 = &constructor_with_flags_side_effect(ctx, v10, v12);
        // Rule at src/isa/x64/inst.isle line 4984.
        return v13.clone();
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "trap_if_val", "src/isa/x64/inst.isle line 4983")
}

// Generated as internal constructor for term x64_movddup.
pub fn constructor_x64_movddup<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v3 = C::use_avx(ctx);
    if v3 == true {
        let v5 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vmovddup, arg0);
        // Rule at src/isa/x64/inst.isle line 5001.
        return v5;
    }
    let v2 = constructor_xmm_unary_rm_r_unaligned(ctx, &SseOpcode::Movddup, arg0);
    // Rule at src/isa/x64/inst.isle line 4999.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastb.
pub fn constructor_x64_vpbroadcastb<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastb, arg0);
    // Rule at src/isa/x64/inst.isle line 5007.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastw.
pub fn constructor_x64_vpbroadcastw<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastw, arg0);
    // Rule at src/isa/x64/inst.isle line 5012.
    return v2;
}

// Generated as internal constructor for term x64_vpbroadcastd.
pub fn constructor_x64_vpbroadcastd<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vpbroadcastd, arg0);
    // Rule at src/isa/x64/inst.isle line 5017.
    return v2;
}

// Generated as internal constructor for term x64_vbroadcastss.
pub fn constructor_x64_vbroadcastss<C: Context>(
    ctx: &mut C,
    arg0: &XmmMem,
) -> Xmm {
    let v2 = constructor_xmm_unary_rm_r_vex(ctx, &AvxOpcode::Vbroadcastss, arg0);
    // Rule at src/isa/x64/inst.isle line 5022.
    return v2;
}

// Generated as internal constructor for term jmp_known.
pub fn constructor_jmp_known<C: Context>(
    ctx: &mut C,
    arg0: MachLabel,
) -> SideEffectNoResult {
    let v1 = MInst::JmpKnown {
        dst: arg0,
    };
    let v2 = SideEffectNoResult::Inst {
        inst: v1,
    };
    // Rule at src/isa/x64/inst.isle line 5029.
    return v2;
}

// Generated as internal constructor for term jmp_if.
pub fn constructor_jmp_if<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: MachLabel,
) -> ConsumesFlags {
    let v2 = MInst::JmpIf {
        cc: arg0.clone(),
        taken: arg1,
    };
    let v3 = ConsumesFlags::ConsumesFlagsSideEffect {
        inst: v2,
    };
    // Rule at src/isa/x64/inst.isle line 5033.
    return v3;
}

// Generated as internal constructor for term jmp_cond.
pub fn constructor_jmp_cond<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: MachLabel,
    arg2: MachLabel,
) -> ConsumesFlags {
    let v3 = MInst::JmpCond {
        cc: arg0.clone(),
        taken: arg1,
        not_taken: arg2,
    };
    let v4 = ConsumesFlags::ConsumesFlagsSideEffect {
        inst: v3,
    };
    // Rule at src/isa/x64/inst.isle line 5038.
    return v4;
}

// Generated as internal constructor for term jmp_cond_icmp.
pub fn constructor_jmp_cond_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: MachLabel,
    arg2: MachLabel,
) -> SideEffectNoResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0 {
        let v5 = &constructor_jmp_cond(ctx, v2, arg1, arg2);
        let v6 = &constructor_with_flags_side_effect(ctx, v1, v5);
        // Rule at src/isa/x64/inst.isle line 5043.
        return v6.clone();
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "jmp_cond_icmp", "src/isa/x64/inst.isle line 5042")
}

// Generated as internal constructor for term jmp_cond_fcmp.
pub fn constructor_jmp_cond_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FcmpCondResult,
    arg1: MachLabel,
    arg2: MachLabel,
) -> SideEffectNoResult {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v5 = &constructor_jmp_cond(ctx, v2, arg1, arg2);
            let v6 = &constructor_with_flags_side_effect(ctx, v1, v5);
            // Rule at src/isa/x64/inst.isle line 5048.
            return v6.clone();
        }
        &FcmpCondResult::AndCondition {
            producer: ref v7,
            cc1: ref v8,
            cc2: ref v9,
        } => {
            let v10 = &C::cc_invert(ctx, v8);
            let v11 = &constructor_jmp_if(ctx, v10, arg2);
            let v12 = &C::cc_invert(ctx, v9);
            let v13 = &constructor_jmp_cond(ctx, v12, arg2, arg1);
            let v14 = &constructor_consumes_flags_concat(ctx, v11, v13);
            let v15 = &constructor_with_flags_side_effect(ctx, v7, v14);
            // Rule at src/isa/x64/inst.isle line 5050.
            return v15.clone();
        }
        &FcmpCondResult::OrCondition {
            producer: ref v16,
            cc1: ref v17,
            cc2: ref v18,
        } => {
            let v19 = &constructor_jmp_if(ctx, v17, arg1);
            let v20 = &constructor_jmp_cond(ctx, v18, arg1, arg2);
            let v21 = &constructor_consumes_flags_concat(ctx, v19, v20);
            let v22 = &constructor_with_flags_side_effect(ctx, v16, v21);
            // Rule at src/isa/x64/inst.isle line 5055.
            return v22.clone();
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "jmp_cond_fcmp", "src/isa/x64/inst.isle line 5047")
}

// Generated as internal constructor for term jmp_table_seq.
pub fn constructor_jmp_table_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: MachLabel,
    arg3: &BoxVecMachLabel,
) -> SideEffectNoResult {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::gpr_to_reg(ctx, arg1);
    let v7 = C::writable_gpr_to_reg(ctx, v4);
    let v8 = C::writable_gpr_to_reg(ctx, v5);
    let v9 = MInst::JmpTableSeq {
        idx: v6,
        tmp1: v7,
        tmp2: v8,
        default_target: arg2,
        targets: arg3.clone(),
    };
    let v10 = SideEffectNoResult::Inst {
        inst: v9,
    };
    // Rule at src/isa/x64/inst.isle line 5075.
    return v10;
}

// Generated as internal constructor for term icmp_cond_result.
pub fn constructor_icmp_cond_result<C: Context>(
    ctx: &mut C,
    arg0: &ProducesFlags,
    arg1: &CC,
) -> IcmpCondResult {
    let v2 = IcmpCondResult::Condition {
        producer: arg0.clone(),
        cc: arg1.clone(),
    };
    // Rule at src/isa/x64/inst.isle line 5095.
    return v2;
}

// Generated as internal constructor for term invert_icmp_cond_result.
pub fn constructor_invert_icmp_cond_result<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
) -> IcmpCondResult {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0 {
        let v3 = &C::cc_invert(ctx, v2);
        let v4 = &constructor_icmp_cond_result(ctx, v1, v3);
        // Rule at src/isa/x64/inst.isle line 5098.
        return v4.clone();
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "invert_icmp_cond_result", "src/isa/x64/inst.isle line 5097")
}

// Generated as internal constructor for term lower_icmp_bool.
pub fn constructor_lower_icmp_bool<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
) -> ValueRegs {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0 {
        let v3 = &constructor_x64_setcc(ctx, v2);
        let v4 = constructor_with_flags(ctx, v1, v3);
        // Rule at src/isa/x64/inst.isle line 5103.
        return v4;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "lower_icmp_bool", "src/isa/x64/inst.isle line 5102")
}

// Generated as internal constructor for term select_icmp.
pub fn constructor_select_icmp<C: Context>(
    ctx: &mut C,
    arg0: &IcmpCondResult,
    arg1: Value,
    arg2: Value,
) -> ValueRegs {
    if let &IcmpCondResult::Condition {
        producer: ref v1,
        cc: ref v2,
    } = arg0 {
        let v4 = C::value_type(ctx, arg1);
        let v5 = &C::type_register_class(ctx, v4);
        if let Some(v6) = v5 {
            if let &RegisterClass::Gpr {
                single_register: v7,
            } = v6 {
                if v7 == true {
                    let v9 = constructor_put_in_gpr(ctx, arg1);
                    let v10 = &C::gpr_to_gpr_mem(ctx, v9);
                    let v11 = constructor_put_in_gpr(ctx, arg2);
                    let v12 = &constructor_cmove(ctx, v4, v2, v10, v11);
                    let v13 = constructor_with_flags(ctx, v1, v12);
                    // Rule at src/isa/x64/inst.isle line 5112.
                    return v13;
                }
            }
        }
        let v14 = &constructor_cmove_from_values(ctx, v4, v2, arg1, arg2);
        let v15 = constructor_with_flags(ctx, v1, v14);
        // Rule at src/isa/x64/inst.isle line 5116.
        return v15;
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "select_icmp", "src/isa/x64/inst.isle line 5107")
}

// Generated as internal constructor for term emit_cmp.
pub fn constructor_emit_cmp<C: Context>(
    ctx: &mut C,
    arg0: &IntCC,
    arg1: Value,
    arg2: Value,
) -> IcmpCondResult {
    let v2 = C::value_type(ctx, arg1);
    if v2 == I128 {
        let v44 = C::put_in_regs(ctx, arg1);
        let v46 = constructor_value_regs_get_gpr(ctx, v44, 0x0_usize);
        let v47 = C::put_in_regs(ctx, arg1);
        let v49 = constructor_value_regs_get_gpr(ctx, v47, 0x1_usize);
        let v50 = C::put_in_regs(ctx, arg2);
        let v51 = constructor_value_regs_get_gpr(ctx, v50, 0x0_usize);
        let v52 = C::put_in_regs(ctx, arg2);
        let v53 = constructor_value_regs_get_gpr(ctx, v52, 0x1_usize);
        let v54 = &C::intcc_to_cc(ctx, arg0);
        let v55 = &constructor_emit_cmp_i128(ctx, v54, v49, v46, v53, v51);
        // Rule at src/isa/x64/inst.isle line 5147.
        return v55.clone();
    }
    let v29 = C::def_inst(ctx, arg1);
    if let Some(v30) = v29 {
        let v31 = &C::inst_data(ctx, v30);
        if let &InstructionData::UnaryImm {
            opcode: ref v32,
            imm: v33,
        } = v31 {
            if let &Opcode::Iconst = v32 {
                let v34 = C::u64_from_imm64(ctx, v33);
                if v34 == 0x0_u64 {
                    let v35 = C::value_type(ctx, arg2);
                    let v36 = &C::raw_operand_size_of_type(ctx, v35);
                    let v37 = C::put_in_reg(ctx, arg2);
                    let v38 = C::gpr_new(ctx, v37);
                    let v39 = &C::gpr_to_gpr_mem_imm(ctx, v38);
                    let v40 = &constructor_x64_test(ctx, v36, v38, v39);
                    let v41 = &C::intcc_swap_args(ctx, arg0);
                    let v42 = &C::intcc_to_cc(ctx, v41);
                    let v43 = &constructor_icmp_cond_result(ctx, v40, v42);
                    // Rule at src/isa/x64/inst.isle line 5140.
                    return v43.clone();
                }
            }
        }
    }
    let v17 = C::def_inst(ctx, arg2);
    if let Some(v18) = v17 {
        let v19 = &C::inst_data(ctx, v18);
        if let &InstructionData::UnaryImm {
            opcode: ref v20,
            imm: v21,
        } = v19 {
            if let &Opcode::Iconst = v20 {
                let v22 = C::u64_from_imm64(ctx, v21);
                if v22 == 0x0_u64 {
                    let v4 = &C::raw_operand_size_of_type(ctx, v2);
                    let v23 = C::put_in_reg(ctx, arg1);
                    let v24 = C::gpr_new(ctx, v23);
                    let v25 = &C::gpr_to_gpr_mem_imm(ctx, v24);
                    let v26 = &constructor_x64_test(ctx, v4, v24, v25);
                    let v27 = &C::intcc_to_cc(ctx, arg0);
                    let v28 = &constructor_icmp_cond_result(ctx, v26, v27);
                    // Rule at src/isa/x64/inst.isle line 5135.
                    return v28.clone();
                }
            }
        }
    }
    let v10 = &C::simm32_from_value(ctx, arg1);
    if let Some(v11) = v10 {
        let v4 = &C::raw_operand_size_of_type(ctx, v2);
        let v12 = constructor_put_in_gpr(ctx, arg2);
        let v13 = &constructor_x64_cmp(ctx, v4, v12, v11);
        let v14 = &C::intcc_swap_args(ctx, arg0);
        let v15 = &C::intcc_to_cc(ctx, v14);
        let v16 = &constructor_icmp_cond_result(ctx, v13, v15);
        // Rule at src/isa/x64/inst.isle line 5130.
        return v16.clone();
    }
    let v4 = &C::raw_operand_size_of_type(ctx, v2);
    let v5 = constructor_put_in_gpr(ctx, arg1);
    let v6 = &constructor_put_in_gpr_mem_imm(ctx, arg2);
    let v7 = &constructor_x64_cmp(ctx, v4, v5, v6);
    let v8 = &C::intcc_to_cc(ctx, arg0);
    let v9 = &constructor_icmp_cond_result(ctx, v7, v8);
    // Rule at src/isa/x64/inst.isle line 5123.
    return v9.clone();
}

// Generated as internal constructor for term emit_cmp_i128.
pub fn constructor_emit_cmp_i128<C: Context>(
    ctx: &mut C,
    arg0: &CC,
    arg1: Gpr,
    arg2: Gpr,
    arg3: Gpr,
    arg4: Gpr,
) -> IcmpCondResult {
    match arg0 {
        &CC::BE => {
            let v12 = &constructor_emit_cmp_i128(ctx, &CC::NB, arg3, arg4, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 5162.
            return v12.clone();
        }
        &CC::NBE => {
            let v10 = &constructor_emit_cmp_i128(ctx, &CC::B, arg3, arg4, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 5160.
            return v10.clone();
        }
        &CC::LE => {
            let v8 = &constructor_emit_cmp_i128(ctx, &CC::NL, arg3, arg4, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 5158.
            return v8.clone();
        }
        &CC::NLE => {
            let v6 = &constructor_emit_cmp_i128(ctx, &CC::L, arg3, arg4, arg1, arg2);
            // Rule at src/isa/x64/inst.isle line 5156.
            return v6.clone();
        }
        _ => {}
    }
    let v13 = &C::cc_nz_or_z(ctx, arg0);
    if let Some(v14) = v13 {
        let v16 = &C::gpr_to_gpr_mem_imm(ctx, arg4);
        let v17 = constructor_x64_xor(ctx, I64, arg2, v16);
        let v18 = C::gpr_to_reg(ctx, v17);
        let v19 = &C::gpr_to_gpr_mem_imm(ctx, arg3);
        let v20 = constructor_x64_xor(ctx, I64, arg1, v19);
        let v21 = C::gpr_to_reg(ctx, v20);
        let v23 = C::gpr_new(ctx, v18);
        let v24 = &constructor_reg_to_gpr_mem_imm(ctx, v21);
        let v25 = &constructor_x64_alurmi_flags_side_effect(ctx, &AluRmiROpcode::Or, I64, v23, v24);
        let v26 = &constructor_icmp_cond_result(ctx, v25, v14);
        // Rule at src/isa/x64/inst.isle line 5167.
        return v26.clone();
    }
    let v16 = &C::gpr_to_gpr_mem_imm(ctx, arg4);
    let v28 = &constructor_x64_cmp(ctx, &OperandSize::Size64, arg2, v16);
    let v30 = &C::gpr_to_gpr_mem_imm(ctx, arg3);
    let v31 = &constructor_x64_alurmi_flags_side_effect(ctx, &AluRmiROpcode::Sbb, I64, arg1, v30);
    let v32 = &constructor_produces_flags_concat(ctx, v28, v31);
    let v33 = &constructor_icmp_cond_result(ctx, v32, arg0);
    // Rule at src/isa/x64/inst.isle line 5177.
    return v33.clone();
}

// Generated as internal constructor for term lower_fcmp_bool.
pub fn constructor_lower_fcmp_bool<C: Context>(
    ctx: &mut C,
    arg0: &FcmpCondResult,
) -> ValueRegs {
    match arg0 {
        &FcmpCondResult::Condition {
            producer: ref v1,
            cc: ref v2,
        } => {
            let v3 = &constructor_x64_setcc(ctx, v2);
            let v4 = constructor_with_flags(ctx, v1, v3);
            // Rule at src/isa/x64/inst.isle line 5198.
            return v4;
        }
        &FcmpCondResult::AndCondition {
            producer: ref v5,
            cc1: ref v6,
            cc2: ref v7,
        } => {
            let v8 = &constructor_x64_setcc(ctx, v6);
            let v9 = &constructor_x64_setcc(ctx, v7);
            let v10 = &constructor_consumes_flags_concat(ctx, v8, v9);
            let v11 = constructor_with_flags(ctx, v5, v10);
            let v13 = constructor_value_regs_get_gpr(ctx, v11, 0x0_usize);
            let v15 = constructor_value_regs_get_gpr(ctx, v11, 0x1_usize);
            let v17 = &C::gpr_to_gpr_mem_imm(ctx, v15);
            let v18 = constructor_x64_and(ctx, I8, v13, v17);
            let v19 = C::gpr_to_reg(ctx, v18);
            let v20 = C::value_reg(ctx, v19);
            // Rule at src/isa/x64/inst.isle line 5201.
            return v20;
        }
        &FcmpCondResult::OrCondition {
            producer: ref v21,
            cc1: ref v22,
            cc2: ref v23,
        } => {
            let v24 = &constructor_x64_setcc(ctx, v22);
            let v25 = &constructor_x64_setcc(ctx, v23);
            let v26 = &constructor_consumes_flags_concat(ctx, v24, v25);
            let v27 = constructor_with_flags(ctx, v21, v26);
            let v28 = constructor_value_regs_get_gpr(ctx, v27, 0x0_usize);
            let v29 = constructor_value_regs_get_gpr(ctx, v27, 0x1_usize);
            let v30 = &C::gpr_to_gpr_mem_imm(ctx, v29);
            let v31 = constructor_x64_or(ctx, I8, v28, v30);
            let v32 = C::gpr_to_reg(ctx, v31);
            let v33 = C::value_reg(ctx, v32);
            // Rule at src/isa/x64/inst.isle line 5210.
            return v33;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "lower_fcmp_bool", "src/isa/x64/inst.isle line 5196")
}

// Generated as internal constructor for term emit_fcmp.
pub fn constructor_emit_fcmp<C: Context>(
    ctx: &mut C,
    arg0: &FloatCC,
    arg1: Value,
    arg2: Value,
) -> FcmpCondResult {
    match arg0 {
        &FloatCC::Equal => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v11 = FcmpCondResult::AndCondition {
                    producer: v8.clone(),
                    cc1: CC::NP,
                    cc2: CC::Z,
                };
                // Rule at src/isa/x64/inst.isle line 5237.
                return v11;
            }
        }
        &FloatCC::GreaterThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v20 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::NBE,
                };
                // Rule at src/isa/x64/inst.isle line 5253.
                return v20;
            }
        }
        &FloatCC::GreaterThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v22 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::NB,
                };
                // Rule at src/isa/x64/inst.isle line 5255.
                return v22;
            }
        }
        &FloatCC::LessThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v27 = constructor_put_in_xmm(ctx, arg2);
                let v28 = &C::put_in_xmm_mem(ctx, arg1);
                let v29 = &constructor_x64_ucomis(ctx, v4, v27, v28);
                let v30 = FcmpCondResult::Condition {
                    producer: v29.clone(),
                    cc: CC::NBE,
                };
                // Rule at src/isa/x64/inst.isle line 5265.
                return v30;
            }
        }
        &FloatCC::LessThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v27 = constructor_put_in_xmm(ctx, arg2);
                let v28 = &C::put_in_xmm_mem(ctx, arg1);
                let v29 = &constructor_x64_ucomis(ctx, v4, v27, v28);
                let v31 = FcmpCondResult::Condition {
                    producer: v29.clone(),
                    cc: CC::NB,
                };
                // Rule at src/isa/x64/inst.isle line 5268.
                return v31;
            }
        }
        &FloatCC::NotEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v14 = FcmpCondResult::OrCondition {
                    producer: v8.clone(),
                    cc1: CC::P,
                    cc2: CC::NZ,
                };
                // Rule at src/isa/x64/inst.isle line 5240.
                return v14;
            }
        }
        &FloatCC::Ordered => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v15 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::NP,
                };
                // Rule at src/isa/x64/inst.isle line 5245.
                return v15;
            }
        }
        &FloatCC::OrderedNotEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v17 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::NZ,
                };
                // Rule at src/isa/x64/inst.isle line 5249.
                return v17;
            }
        }
        &FloatCC::Unordered => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v16 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::P,
                };
                // Rule at src/isa/x64/inst.isle line 5247.
                return v16;
            }
        }
        &FloatCC::UnorderedOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v18 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::Z,
                };
                // Rule at src/isa/x64/inst.isle line 5251.
                return v18;
            }
        }
        &FloatCC::UnorderedOrGreaterThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v27 = constructor_put_in_xmm(ctx, arg2);
                let v28 = &C::put_in_xmm_mem(ctx, arg1);
                let v29 = &constructor_x64_ucomis(ctx, v4, v27, v28);
                let v32 = FcmpCondResult::Condition {
                    producer: v29.clone(),
                    cc: CC::B,
                };
                // Rule at src/isa/x64/inst.isle line 5271.
                return v32;
            }
        }
        &FloatCC::UnorderedOrGreaterThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v27 = constructor_put_in_xmm(ctx, arg2);
                let v28 = &C::put_in_xmm_mem(ctx, arg1);
                let v29 = &constructor_x64_ucomis(ctx, v4, v27, v28);
                let v33 = FcmpCondResult::Condition {
                    producer: v29.clone(),
                    cc: CC::BE,
                };
                // Rule at src/isa/x64/inst.isle line 5274.
                return v33;
            }
        }
        &FloatCC::UnorderedOrLessThan => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v24 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::B,
                };
                // Rule at src/isa/x64/inst.isle line 5257.
                return v24;
            }
        }
        &FloatCC::UnorderedOrLessThanOrEqual => {
            let v2 = C::value_type(ctx, arg1);
            let v3 = C::ty_scalar_float(ctx, v2);
            if let Some(v4) = v3 {
                let v6 = constructor_put_in_xmm(ctx, arg1);
                let v7 = &C::put_in_xmm_mem(ctx, arg2);
                let v8 = &constructor_x64_ucomis(ctx, v4, v6, v7);
                let v26 = FcmpCondResult::Condition {
                    producer: v8.clone(),
                    cc: CC::BE,
                };
                // Rule at src/isa/x64/inst.isle line 5259.
                return v26;
            }
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "emit_fcmp", "src/isa/x64/inst.isle line 5235")
}

// Generated as internal constructor for term x64_mfence.
pub fn constructor_x64_mfence<C: Context>(
    ctx: &mut C,
) -> SideEffectNoResult {
    let v1 = MInst::Fence {
        kind: FenceKind::MFence,
    };
    let v2 = SideEffectNoResult::Inst {
        inst: v1,
    };
    // Rule at src/isa/x64/inst.isle line 5287.
    return v2;
}

// Generated as internal constructor for term x64_cmpxchg.
pub fn constructor_x64_cmpxchg<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: Gpr,
    arg2: Gpr,
    arg3: &SyntheticAmode,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::gpr_to_reg(ctx, arg2);
    let v6 = C::gpr_to_reg(ctx, arg1);
    let v7 = C::writable_gpr_to_reg(ctx, v4);
    let v8 = MInst::LockCmpxchg {
        ty: arg0,
        replacement: v5,
        expected: v6,
        mem: arg3.clone(),
        dst_old: v7,
    };
    let v9 = C::emit(ctx, &v8);
    let v10 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 5291.
    return v10;
}

// Generated as internal constructor for term x64_cmpxchg16b.
pub fn constructor_x64_cmpxchg16b<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
    arg1: ValueRegs,
    arg2: &SyntheticAmode,
) -> ValueRegs {
    let v4 = constructor_value_regs_get_gpr(ctx, arg0, 0x0_usize);
    let v6 = constructor_value_regs_get_gpr(ctx, arg0, 0x1_usize);
    let v7 = constructor_value_regs_get_gpr(ctx, arg1, 0x0_usize);
    let v8 = constructor_value_regs_get_gpr(ctx, arg1, 0x1_usize);
    let v9 = C::temp_writable_gpr(ctx);
    let v10 = C::temp_writable_gpr(ctx);
    let v11 = C::gpr_to_reg(ctx, v7);
    let v12 = C::gpr_to_reg(ctx, v8);
    let v13 = C::gpr_to_reg(ctx, v4);
    let v14 = C::gpr_to_reg(ctx, v6);
    let v16 = C::writable_gpr_to_reg(ctx, v9);
    let v17 = C::writable_gpr_to_reg(ctx, v10);
    let v15 = &C::box_synthetic_amode(ctx, arg2);
    let v18 = MInst::LockCmpxchg16b {
        replacement_low: v11,
        replacement_high: v12,
        expected_low: v13,
        expected_high: v14,
        mem: v15.clone(),
        dst_old_low: v16,
        dst_old_high: v17,
    };
    let v19 = C::emit(ctx, &v18);
    let v20 = constructor_writable_gpr_to_r_reg(ctx, v9);
    let v21 = constructor_writable_gpr_to_r_reg(ctx, v10);
    let v22 = C::value_regs(ctx, v20, v21);
    // Rule at src/isa/x64/inst.isle line 5297.
    return v22;
}

// Generated as internal constructor for term x64_xadd.
pub fn constructor_x64_xadd<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = C::gpr_to_reg(ctx, arg2);
    let v5 = C::writable_gpr_to_reg(ctx, v3);
    let v6 = MInst::LockXadd {
        size: arg0.clone(),
        operand: v4,
        mem: arg1.clone(),
        dst_old: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 5308.
    return v8;
}

// Generated as internal constructor for term x64_xchg.
pub fn constructor_x64_xchg<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Gpr {
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = C::gpr_to_reg(ctx, arg2);
    let v5 = C::writable_gpr_to_reg(ctx, v3);
    let v6 = MInst::Xchg {
        size: arg0.clone(),
        operand: v4,
        mem: arg1.clone(),
        dst_old: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = C::writable_gpr_to_gpr(ctx, v3);
    // Rule at src/isa/x64/inst.isle line 5314.
    return v8;
}

// Generated as internal constructor for term lock_alu_rm.
pub fn constructor_lock_alu_rm<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &AluRmiROpcode,
    arg2: &SyntheticAmode,
    arg3: Gpr,
) -> Reg {
    let v4 = true;
    let v5 = MInst::AluRM {
        size: arg0.clone(),
        op: arg1.clone(),
        src1_dst: arg2.clone(),
        src2: arg3,
        lock: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::invalid_reg(ctx);
    // Rule at src/isa/x64/inst.isle line 5320.
    return v7;
}

// Generated as internal constructor for term x64_lock_add.
pub fn constructor_x64_lock_add<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Reg {
    let v4 = constructor_lock_alu_rm(ctx, arg0, &AluRmiROpcode::Add, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 5325.
    return v4;
}

// Generated as internal constructor for term x64_lock_sub.
pub fn constructor_x64_lock_sub<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Reg {
    let v4 = constructor_lock_alu_rm(ctx, arg0, &AluRmiROpcode::Sub, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 5329.
    return v4;
}

// Generated as internal constructor for term x64_lock_and.
pub fn constructor_x64_lock_and<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Reg {
    let v4 = constructor_lock_alu_rm(ctx, arg0, &AluRmiROpcode::And, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 5333.
    return v4;
}

// Generated as internal constructor for term x64_lock_or.
pub fn constructor_x64_lock_or<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Reg {
    let v4 = constructor_lock_alu_rm(ctx, arg0, &AluRmiROpcode::Or, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 5337.
    return v4;
}

// Generated as internal constructor for term x64_lock_xor.
pub fn constructor_x64_lock_xor<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: &SyntheticAmode,
    arg2: Gpr,
) -> Reg {
    let v4 = constructor_lock_alu_rm(ctx, arg0, &AluRmiROpcode::Xor, arg1, arg2);
    // Rule at src/isa/x64/inst.isle line 5341.
    return v4;
}

// Generated as internal constructor for term x64_atomic_rmw_seq.
pub fn constructor_x64_atomic_rmw_seq<C: Context>(
    ctx: &mut C,
    arg0: Type,
    arg1: &AtomicRmwSeqOp,
    arg2: &SyntheticAmode,
    arg3: Gpr,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::gpr_to_reg(ctx, arg3);
    let v7 = C::writable_gpr_to_reg(ctx, v5);
    let v8 = C::writable_gpr_to_reg(ctx, v4);
    let v9 = MInst::AtomicRmwSeq {
        ty: arg0,
        op: arg1.clone(),
        mem: arg2.clone(),
        operand: v6,
        temp: v7,
        dst_old: v8,
    };
    let v10 = C::emit(ctx, &v9);
    let v11 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 5345.
    return v11;
}

// Generated as internal constructor for term x64_atomic_128_rmw_seq.
pub fn constructor_x64_atomic_128_rmw_seq<C: Context>(
    ctx: &mut C,
    arg0: &AtomicRmwOp,
    arg1: &SyntheticAmode,
    arg2: ValueRegs,
) -> ValueRegs {
    if let &AtomicRmwOp::Xchg = arg0 {
        let v3 = C::temp_writable_gpr(ctx);
        let v4 = C::temp_writable_gpr(ctx);
        let v24 = constructor_value_regs_get_gpr(ctx, arg2, 0x0_usize);
        let v25 = constructor_value_regs_get_gpr(ctx, arg2, 0x1_usize);
        let v26 = C::gpr_to_reg(ctx, v24);
        let v27 = C::gpr_to_reg(ctx, v25);
        let v28 = C::writable_gpr_to_reg(ctx, v3);
        let v29 = C::writable_gpr_to_reg(ctx, v4);
        let v30 = MInst::Atomic128XchgSeq {
            mem: arg1.clone(),
            operand_low: v26,
            operand_high: v27,
            dst_old_low: v28,
            dst_old_high: v29,
        };
        let v31 = C::emit(ctx, &v30);
        let v32 = constructor_writable_gpr_to_r_reg(ctx, v3);
        let v33 = constructor_writable_gpr_to_r_reg(ctx, v4);
        let v34 = C::value_regs(ctx, v32, v33);
        // Rule at src/isa/x64/inst.isle line 5362.
        return v34;
    }
    let v3 = C::temp_writable_gpr(ctx);
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = C::temp_writable_gpr(ctx);
    let v8 = constructor_value_regs_get_gpr(ctx, arg2, 0x0_usize);
    let v10 = constructor_value_regs_get_gpr(ctx, arg2, 0x1_usize);
    let v11 = &constructor_atomic_128_rmw_seq_op(ctx, arg0);
    let v13 = C::gpr_to_reg(ctx, v8);
    let v14 = C::gpr_to_reg(ctx, v10);
    let v15 = C::writable_gpr_to_reg(ctx, v5);
    let v16 = C::writable_gpr_to_reg(ctx, v6);
    let v17 = C::writable_gpr_to_reg(ctx, v3);
    let v18 = C::writable_gpr_to_reg(ctx, v4);
    let v12 = &C::box_synthetic_amode(ctx, arg1);
    let v19 = MInst::Atomic128RmwSeq {
        op: v11.clone(),
        mem: v12.clone(),
        operand_low: v13,
        operand_high: v14,
        temp_low: v15,
        temp_high: v16,
        dst_old_low: v17,
        dst_old_high: v18,
    };
    let v20 = C::emit(ctx, &v19);
    let v21 = constructor_writable_gpr_to_r_reg(ctx, v3);
    let v22 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v23 = C::value_regs(ctx, v21, v22);
    // Rule at src/isa/x64/inst.isle line 5352.
    return v23;
}

// Generated as internal constructor for term x64_atomic_128_store_seq.
pub fn constructor_x64_atomic_128_store_seq<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
    arg1: ValueRegs,
) -> SideEffectNoResult {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = C::temp_writable_gpr(ctx);
    let v5 = constructor_value_regs_get_gpr(ctx, arg1, 0x0_usize);
    let v7 = constructor_value_regs_get_gpr(ctx, arg1, 0x1_usize);
    let v8 = C::gpr_to_reg(ctx, v5);
    let v9 = C::gpr_to_reg(ctx, v7);
    let v10 = C::writable_gpr_to_reg(ctx, v2);
    let v11 = C::writable_gpr_to_reg(ctx, v3);
    let v12 = MInst::Atomic128XchgSeq {
        mem: arg0.clone(),
        operand_low: v8,
        operand_high: v9,
        dst_old_low: v10,
        dst_old_high: v11,
    };
    let v13 = SideEffectNoResult::Inst {
        inst: v12,
    };
    // Rule at src/isa/x64/inst.isle line 5371.
    return v13;
}

// Generated as internal constructor for term atomic_rmw_seq_op.
pub fn constructor_atomic_rmw_seq_op<C: Context>(
    ctx: &mut C,
    arg0: &AtomicRmwOp,
) -> AtomicRmwSeqOp {
    match arg0 {
        &AtomicRmwOp::And => {
            // Rule at src/isa/x64/inst.isle line 5390.
            return AtomicRmwSeqOp::And;
        }
        &AtomicRmwOp::Nand => {
            // Rule at src/isa/x64/inst.isle line 5391.
            return AtomicRmwSeqOp::Nand;
        }
        &AtomicRmwOp::Or => {
            // Rule at src/isa/x64/inst.isle line 5392.
            return AtomicRmwSeqOp::Or;
        }
        &AtomicRmwOp::Smax => {
            // Rule at src/isa/x64/inst.isle line 5397.
            return AtomicRmwSeqOp::Smax;
        }
        &AtomicRmwOp::Smin => {
            // Rule at src/isa/x64/inst.isle line 5396.
            return AtomicRmwSeqOp::Smin;
        }
        &AtomicRmwOp::Umax => {
            // Rule at src/isa/x64/inst.isle line 5395.
            return AtomicRmwSeqOp::Umax;
        }
        &AtomicRmwOp::Umin => {
            // Rule at src/isa/x64/inst.isle line 5394.
            return AtomicRmwSeqOp::Umin;
        }
        &AtomicRmwOp::Xor => {
            // Rule at src/isa/x64/inst.isle line 5393.
            return AtomicRmwSeqOp::Xor;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "atomic_rmw_seq_op", "src/isa/x64/inst.isle line 5389")
}

// Generated as internal constructor for term atomic_128_rmw_seq_op.
pub fn constructor_atomic_128_rmw_seq_op<C: Context>(
    ctx: &mut C,
    arg0: &AtomicRmwOp,
) -> Atomic128RmwSeqOp {
    match arg0 {
        &AtomicRmwOp::Add => {
            // Rule at src/isa/x64/inst.isle line 5412.
            return Atomic128RmwSeqOp::Add;
        }
        &AtomicRmwOp::And => {
            // Rule at src/isa/x64/inst.isle line 5414.
            return Atomic128RmwSeqOp::And;
        }
        &AtomicRmwOp::Nand => {
            // Rule at src/isa/x64/inst.isle line 5415.
            return Atomic128RmwSeqOp::Nand;
        }
        &AtomicRmwOp::Or => {
            // Rule at src/isa/x64/inst.isle line 5416.
            return Atomic128RmwSeqOp::Or;
        }
        &AtomicRmwOp::Smax => {
            // Rule at src/isa/x64/inst.isle line 5421.
            return Atomic128RmwSeqOp::Smax;
        }
        &AtomicRmwOp::Smin => {
            // Rule at src/isa/x64/inst.isle line 5420.
            return Atomic128RmwSeqOp::Smin;
        }
        &AtomicRmwOp::Sub => {
            // Rule at src/isa/x64/inst.isle line 5413.
            return Atomic128RmwSeqOp::Sub;
        }
        &AtomicRmwOp::Umax => {
            // Rule at src/isa/x64/inst.isle line 5419.
            return Atomic128RmwSeqOp::Umax;
        }
        &AtomicRmwOp::Umin => {
            // Rule at src/isa/x64/inst.isle line 5418.
            return Atomic128RmwSeqOp::Umin;
        }
        &AtomicRmwOp::Xor => {
            // Rule at src/isa/x64/inst.isle line 5417.
            return Atomic128RmwSeqOp::Xor;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "atomic_128_rmw_seq_op", "src/isa/x64/inst.isle line 5411")
}

// Generated as internal constructor for term bitcast_xmm_to_gpr.
pub fn constructor_bitcast_xmm_to_gpr<C: Context>(
    ctx: &mut C,
    arg0: u8,
    arg1: Xmm,
) -> Gpr {
    match arg0 {
        0x10_u8 => {
            let v3 = constructor_x64_pextrw(ctx, arg1, 0x0_u8);
            // Rule at src/isa/x64/inst.isle line 5426.
            return v3;
        }
        0x20_u8 => {
            let v4 = constructor_x64_movd_to_gpr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 5428.
            return v4;
        }
        0x40_u8 => {
            let v5 = constructor_x64_movq_to_gpr(ctx, arg1);
            // Rule at src/isa/x64/inst.isle line 5430.
            return v5;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "bitcast_xmm_to_gpr", "src/isa/x64/inst.isle line 5425")
}

// Generated as internal constructor for term bitcast_xmm_to_gprs.
pub fn constructor_bitcast_xmm_to_gprs<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
) -> ValueRegs {
    let v1 = constructor_x64_movq_to_gpr(ctx, arg0);
    let v2 = C::gpr_to_reg(ctx, v1);
    let v3 = &C::xmm_to_xmm_mem(ctx, arg0);
    let v5 = constructor_x64_pshufd(ctx, v3, 0xee_u8);
    let v6 = constructor_x64_movq_to_gpr(ctx, v5);
    let v7 = C::gpr_to_reg(ctx, v6);
    let v8 = C::value_regs(ctx, v2, v7);
    // Rule at src/isa/x64/inst.isle line 5434.
    return v8;
}

// Generated as internal constructor for term bitcast_gpr_to_xmm.
pub fn constructor_bitcast_gpr_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: u8,
    arg1: Gpr,
) -> Xmm {
    match arg0 {
        0x10_u8 => {
            let v2 = constructor_xmm_uninit_value(ctx);
            let v3 = &C::gpr_to_gpr_mem(ctx, arg1);
            let v5 = constructor_x64_pinsrw(ctx, v2, v3, 0x0_u8);
            // Rule at src/isa/x64/inst.isle line 5438.
            return v5;
        }
        0x20_u8 => {
            let v6 = &C::gpr_to_gpr_mem(ctx, arg1);
            let v7 = constructor_x64_movd_to_xmm(ctx, v6);
            // Rule at src/isa/x64/inst.isle line 5440.
            return v7;
        }
        0x40_u8 => {
            let v6 = &C::gpr_to_gpr_mem(ctx, arg1);
            let v8 = constructor_x64_movq_to_xmm(ctx, v6);
            // Rule at src/isa/x64/inst.isle line 5442.
            return v8;
        }
        _ => {}
    }
    unreachable!("no rule matched for term {} at {}; should it be partial?", "bitcast_gpr_to_xmm", "src/isa/x64/inst.isle line 5437")
}

// Generated as internal constructor for term bitcast_gprs_to_xmm.
pub fn constructor_bitcast_gprs_to_xmm<C: Context>(
    ctx: &mut C,
    arg0: ValueRegs,
) -> Xmm {
    let v2 = constructor_value_regs_get_gpr(ctx, arg0, 0x0_usize);
    let v3 = &C::gpr_to_gpr_mem(ctx, v2);
    let v4 = constructor_x64_movq_to_xmm(ctx, v3);
    let v6 = constructor_value_regs_get_gpr(ctx, arg0, 0x1_usize);
    let v7 = &C::gpr_to_gpr_mem(ctx, v6);
    let v8 = constructor_x64_movq_to_xmm(ctx, v7);
    let v9 = &C::xmm_to_xmm_mem(ctx, v8);
    let v10 = constructor_x64_punpcklqdq(ctx, v4, v9);
    // Rule at src/isa/x64/inst.isle line 5446.
    return v10;
}

// Generated as internal constructor for term stack_addr_impl.
pub fn constructor_stack_addr_impl<C: Context>(
    ctx: &mut C,
    arg0: StackSlot,
    arg1: Offset32,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = C::writable_gpr_to_reg(ctx, v2);
    let v4 = &C::abi_stackslot_addr(ctx, v3, arg0, arg1);
    let v5 = C::emit(ctx, v4);
    let v6 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 5452.
    return v6;
}

// Generated as internal constructor for term x64_checked_srem_seq.
pub fn constructor_x64_checked_srem_seq<C: Context>(
    ctx: &mut C,
    arg0: &OperandSize,
    arg1: Gpr,
    arg2: Gpr,
    arg3: Gpr,
) -> ValueRegs {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = C::temp_writable_gpr(ctx);
    let v6 = MInst::CheckedSRemSeq {
        size: arg0.clone(),
        dividend_lo: arg1,
        dividend_hi: arg2,
        divisor: arg3,
        dst_quotient: v4,
        dst_remainder: v5,
    };
    let v7 = C::emit(ctx, &v6);
    let v8 = constructor_writable_gpr_to_r_reg(ctx, v4);
    let v9 = constructor_writable_gpr_to_r_reg(ctx, v5);
    let v10 = C::value_regs(ctx, v8, v9);
    // Rule at src/isa/x64/inst.isle line 5461.
    return v10;
}

// Generated as internal constructor for term x64_checked_srem_seq8.
pub fn constructor_x64_checked_srem_seq8<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::CheckedSRemSeq8 {
        dividend: arg0,
        divisor: arg1,
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 5468.
    return v5;
}

// Generated as internal constructor for term x64_div8.
pub fn constructor_x64_div8<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: &GprMem,
    arg2: &DivSignedness,
    arg3: &TrapCode,
) -> Gpr {
    let v4 = C::temp_writable_gpr(ctx);
    let v5 = MInst::Div8 {
        sign: arg2.clone(),
        trap: arg3.clone(),
        divisor: arg1.clone(),
        dividend: arg0,
        dst: v4,
    };
    let v6 = C::emit(ctx, &v5);
    let v7 = C::writable_gpr_to_gpr(ctx, v4);
    // Rule at src/isa/x64/inst.isle line 5475.
    return v7;
}

// Generated as internal constructor for term x64_div.
pub fn constructor_x64_div<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = C::temp_writable_gpr(ctx);
    let v7 = C::temp_writable_gpr(ctx);
    let v8 = MInst::Div {
        size: arg3.clone(),
        sign: arg4.clone(),
        trap: arg5.clone(),
        divisor: arg2.clone(),
        dividend_lo: arg0,
        dividend_hi: arg1,
        dst_quotient: v6,
        dst_remainder: v7,
    };
    let v9 = C::emit(ctx, &v8);
    let v10 = constructor_writable_gpr_to_r_reg(ctx, v6);
    let v11 = constructor_writable_gpr_to_r_reg(ctx, v7);
    let v12 = C::value_regs(ctx, v10, v11);
    // Rule at src/isa/x64/inst.isle line 5485.
    return v12;
}

// Generated as internal constructor for term x64_div_quotient.
pub fn constructor_x64_div_quotient<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = constructor_x64_div(ctx, arg0, arg1, arg2, arg3, arg4, arg5);
    let v8 = C::value_regs_get(ctx, v6, 0x0_usize);
    let v9 = C::value_reg(ctx, v8);
    // Rule at src/isa/x64/inst.isle line 5493.
    return v9;
}

// Generated as internal constructor for term x64_div_remainder.
pub fn constructor_x64_div_remainder<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: Gpr,
    arg2: &GprMem,
    arg3: &OperandSize,
    arg4: &DivSignedness,
    arg5: &TrapCode,
) -> ValueRegs {
    let v6 = constructor_x64_div(ctx, arg0, arg1, arg2, arg3, arg4, arg5);
    let v8 = C::value_regs_get(ctx, v6, 0x1_usize);
    let v9 = C::value_reg(ctx, v8);
    // Rule at src/isa/x64/inst.isle line 5498.
    return v9;
}

// Generated as internal constructor for term x64_sign_extend_data.
pub fn constructor_x64_sign_extend_data<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
    arg1: &OperandSize,
) -> Gpr {
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::SignExtendData {
        size: arg1.clone(),
        src: arg0,
        dst: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v2);
    // Rule at src/isa/x64/inst.isle line 5503.
    return v5;
}

// Generated as internal constructor for term read_pinned_gpr.
pub fn constructor_read_pinned_gpr<C: Context>(
    ctx: &mut C,
) -> Gpr {
    let v0 = C::preg_pinned(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    let v2 = C::gpr_new(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5511.
    return v2;
}

// Generated as internal constructor for term write_pinned_gpr.
pub fn constructor_write_pinned_gpr<C: Context>(
    ctx: &mut C,
    arg0: Gpr,
) -> SideEffectNoResult {
    let v1 = C::preg_pinned(ctx);
    let v2 = &constructor_mov_to_preg(ctx, v1, arg0);
    // Rule at src/isa/x64/inst.isle line 5515.
    return v2.clone();
}

// Generated as internal constructor for term elf_tls_get_addr.
pub fn constructor_elf_tls_get_addr<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::ElfTlsGetAddr {
        symbol: arg0,
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5557.
    return v4;
}

// Generated as internal constructor for term macho_tls_get_addr.
pub fn constructor_macho_tls_get_addr<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = MInst::MachOTlsGetAddr {
        symbol: arg0,
        dst: v1,
    };
    let v3 = C::emit(ctx, &v2);
    let v4 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5564.
    return v4;
}

// Generated as internal constructor for term coff_tls_get_addr.
pub fn constructor_coff_tls_get_addr<C: Context>(
    ctx: &mut C,
    arg0: ExternalName,
) -> Gpr {
    let v1 = C::temp_writable_gpr(ctx);
    let v2 = C::temp_writable_gpr(ctx);
    let v3 = MInst::CoffTlsGetAddr {
        symbol: arg0,
        dst: v1,
        tmp: v2,
    };
    let v4 = C::emit(ctx, &v3);
    let v5 = C::writable_gpr_to_gpr(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5571.
    return v5;
}

// Generated as internal constructor for term reg_to_xmm_mem.
pub fn constructor_reg_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: Reg,
) -> XmmMem {
    let v1 = C::xmm_new(ctx, arg0);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5657.
    return v2.clone();
}

// Generated as internal constructor for term xmm_to_reg_mem.
pub fn constructor_xmm_to_reg_mem<C: Context>(
    ctx: &mut C,
    arg0: Reg,
) -> XmmMem {
    let v1 = C::xmm_new(ctx, arg0);
    let v2 = C::xmm_to_reg(ctx, v1);
    let v3 = RegMem::Reg {
        reg: v2,
    };
    let v4 = &C::reg_mem_to_xmm_mem(ctx, &v3);
    // Rule at src/isa/x64/inst.isle line 5660.
    return v4.clone();
}

// Generated as internal constructor for term writable_gpr_to_r_reg.
pub fn constructor_writable_gpr_to_r_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> Reg {
    let v1 = C::writable_gpr_to_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5664.
    return v2;
}

// Generated as internal constructor for term writable_gpr_to_gpr_mem.
pub fn constructor_writable_gpr_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> GprMem {
    let v1 = C::writable_gpr_to_gpr(ctx, arg0);
    let v2 = &C::gpr_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5667.
    return v2.clone();
}

// Generated as internal constructor for term writable_gpr_to_value_regs.
pub fn constructor_writable_gpr_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableGpr,
) -> ValueRegs {
    let v1 = constructor_writable_gpr_to_r_reg(ctx, arg0);
    let v2 = C::value_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5670.
    return v2;
}

// Generated as internal constructor for term writable_xmm_to_r_reg.
pub fn constructor_writable_xmm_to_r_reg<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> Reg {
    let v1 = C::writable_xmm_to_reg(ctx, arg0);
    let v2 = C::writable_reg_to_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5673.
    return v2;
}

// Generated as internal constructor for term writable_xmm_to_xmm_mem.
pub fn constructor_writable_xmm_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> XmmMem {
    let v1 = C::writable_xmm_to_xmm(ctx, arg0);
    let v2 = &C::xmm_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5676.
    return v2.clone();
}

// Generated as internal constructor for term writable_xmm_to_value_regs.
pub fn constructor_writable_xmm_to_value_regs<C: Context>(
    ctx: &mut C,
    arg0: WritableXmm,
) -> ValueRegs {
    let v1 = constructor_writable_xmm_to_r_reg(ctx, arg0);
    let v2 = C::value_reg(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5679.
    return v2;
}

// Generated as internal constructor for term synthetic_amode_to_gpr_mem.
pub fn constructor_synthetic_amode_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> GprMem {
    let v1 = &C::synthetic_amode_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5689.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_gpr_mem.
pub fn constructor_amode_to_gpr_mem<C: Context>(
    ctx: &mut C,
    arg0: &Amode,
) -> GprMem {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_gpr_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5687.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_xmm_mem.
pub fn constructor_amode_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: &Amode,
) -> XmmMem {
    let v1 = &C::amode_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5692.
    return v2.clone();
}

// Generated as internal constructor for term synthetic_amode_to_xmm_mem.
pub fn constructor_synthetic_amode_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> XmmMem {
    let v1 = &C::synthetic_amode_to_reg_mem(ctx, arg0);
    let v2 = &C::reg_mem_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5695.
    return v2.clone();
}

// Generated as internal constructor for term const_to_xmm_mem.
pub fn constructor_const_to_xmm_mem<C: Context>(
    ctx: &mut C,
    arg0: VCodeConstant,
) -> XmmMem {
    let v1 = &C::const_to_synthetic_amode(ctx, arg0);
    let v2 = &constructor_synthetic_amode_to_xmm_mem(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5700.
    return v2.clone();
}

// Generated as internal constructor for term const_to_reg_mem.
pub fn constructor_const_to_reg_mem<C: Context>(
    ctx: &mut C,
    arg0: VCodeConstant,
) -> RegMem {
    let v1 = &C::const_to_synthetic_amode(ctx, arg0);
    let v2 = RegMem::Mem {
        addr: v1.clone(),
    };
    // Rule at src/isa/x64/inst.isle line 5702.
    return v2;
}

// Generated as internal constructor for term xmm_to_xmm_mem_aligned.
pub fn constructor_xmm_to_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: Xmm,
) -> XmmMemAligned {
    let v1 = &C::xmm_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5705.
    return v2.clone();
}

// Generated as internal constructor for term amode_to_xmm_mem_aligned.
pub fn constructor_amode_to_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: &Amode,
) -> XmmMemAligned {
    let v1 = &constructor_amode_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5707.
    return v2.clone();
}

// Generated as internal constructor for term synthetic_amode_to_xmm_mem_aligned.
pub fn constructor_synthetic_amode_to_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: &SyntheticAmode,
) -> XmmMemAligned {
    let v1 = &constructor_synthetic_amode_to_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5709.
    return v2.clone();
}

// Generated as internal constructor for term put_in_xmm_mem_aligned.
pub fn constructor_put_in_xmm_mem_aligned<C: Context>(
    ctx: &mut C,
    arg0: Value,
) -> XmmMemAligned {
    let v1 = &C::put_in_xmm_mem(ctx, arg0);
    let v2 = &C::xmm_mem_to_xmm_mem_aligned(ctx, v1);
    // Rule at src/isa/x64/inst.isle line 5711.
    return v2.clone();
}

// Generated as internal constructor for term mov_to_preg.
pub fn constructor_mov_to_preg<C: Context>(
    ctx: &mut C,
    arg0: PReg,
    arg1: Gpr,
) -> SideEffectNoResult {
    let v2 = MInst::MovToPReg {
        src: arg1,
        dst: arg0,
    };
    let v3 = SideEffectNoResult::Inst {
        inst: v2,
    };
    // Rule at src/isa/x64/inst.isle line 5714.
    return v3;
}

// Generated as internal constructor for term x64_rbp.
pub fn constructor_x64_rbp<C: Context>(
    ctx: &mut C,
) -> Reg {
    let v0 = C::preg_rbp(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 5727.
    return v1;
}

// Generated as internal constructor for term x64_rsp.
pub fn constructor_x64_rsp<C: Context>(
    ctx: &mut C,
) -> Reg {
    let v0 = C::preg_rsp(ctx);
    let v1 = constructor_mov_from_preg(ctx, v0);
    // Rule at src/isa/x64/inst.isle line 5731.
    return v1;
}

// Generated as internal constructor for term lower.
pub fn constructor_lower<C: Context>(
    ctx: &mut C,
    arg0: Inst,
) -> Option<InstOutput> {
    let v6 = &C::inst_data(ctx, arg0);
    match v6 {
        &InstructionData::AtomicCas {
            opcode: ref v2329,
            args: ref v2330,
            flags: v2331,
        } => {
            if let &Opcode::AtomicCas = v2329 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    if v3 == I128 {
                        let v2295 = C::use_cmpxchg16b(ctx);
                        if v2295 == true {
                            let v2332 = C::unpack_value_array_3(ctx, v2330);
                            let v2344 = C::put_in_regs(ctx, v2332.1);
                            let v2345 = C::put_in_regs(ctx, v2332.2);
                            let v2338 = C::zero_offset(ctx);
                            let v2339 = &constructor_to_amode(ctx, v2331, v2332.0, v2338);
                            let v2340 = &C::amode_to_synthetic_amode(ctx, v2339);
                            let v2346 = constructor_x64_cmpxchg16b(ctx, v2344, v2345, v2340);
                            let v2347 = C::output(ctx, v2346);
                            let v2348 = Some(v2347);
                            // Rule at src/isa/x64/lower.isle line 3389.
                            return v2348;
                        }
                    }
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v2287 = C::ty_int(ctx, v3);
                        if let Some(v2288) = v2287 {
                            let v2332 = C::unpack_value_array_3(ctx, v2330);
                            let v2336 = constructor_put_in_gpr(ctx, v2332.1);
                            let v2337 = constructor_put_in_gpr(ctx, v2332.2);
                            let v2338 = C::zero_offset(ctx);
                            let v2339 = &constructor_to_amode(ctx, v2331, v2332.0, v2338);
                            let v2340 = &C::amode_to_synthetic_amode(ctx, v2339);
                            let v2341 = constructor_x64_cmpxchg(ctx, v5, v2336, v2337, v2340);
                            let v2342 = constructor_output_gpr(ctx, v2341);
                            let v2343 = Some(v2342);
                            // Rule at src/isa/x64/lower.isle line 3386.
                            return v2343;
                        }
                    }
                }
            }
        }
        &InstructionData::AtomicRmw {
            opcode: ref v2349,
            args: ref v2350,
            flags: v2351,
            op: ref v2352,
        } => {
            if let &Opcode::AtomicRmw = v2349 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    if v3 == I128 {
                        let v2295 = C::use_cmpxchg16b(ctx);
                        if v2295 == true {
                            let v70 = C::zero_offset(ctx);
                            let v2353 = C::unpack_value_array_2(ctx, v2350);
                            let v2393 = &constructor_to_amode(ctx, v2351, v2353.0, v70);
                            let v2394 = &C::amode_to_synthetic_amode(ctx, v2393);
                            let v2395 = C::put_in_regs(ctx, v2353.1);
                            let v2396 = constructor_x64_atomic_128_rmw_seq(ctx, v2352, v2394, v2395);
                            let v2397 = C::output(ctx, v2396);
                            let v2398 = Some(v2397);
                            // Rule at src/isa/x64/lower.isle line 3442.
                            return v2398;
                        }
                    }
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        match v2352 {
                            &AtomicRmwOp::Add => {
                                let v2374 = C::ty_int(ctx, v5);
                                if let Some(v2375) = v2374 {
                                    let v2376 = C::value_is_unused(ctx, v2);
                                    if v2376 == true {
                                        let v2377 = &C::raw_operand_size_of_type(ctx, v2375);
                                        let v2289 = C::zero_offset(ctx);
                                        let v2353 = C::unpack_value_array_2(ctx, v2350);
                                        let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                        let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                        let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                        let v2378 = constructor_x64_lock_add(ctx, v2377, v2358, v2359);
                                        let v2379 = constructor_output_reg(ctx, v2378);
                                        let v2380 = Some(v2379);
                                        // Rule at src/isa/x64/lower.isle line 3415.
                                        return v2380;
                                    }
                                }
                                let v2287 = C::ty_int(ctx, v3);
                                if let Some(v2288) = v2287 {
                                    let v2363 = &C::raw_operand_size_of_type(ctx, v5);
                                    let v2289 = C::zero_offset(ctx);
                                    let v2353 = C::unpack_value_array_2(ctx, v2350);
                                    let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                    let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                    let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                    let v2364 = constructor_x64_xadd(ctx, v2363, v2358, v2359);
                                    let v2365 = constructor_output_gpr(ctx, v2364);
                                    let v2366 = Some(v2365);
                                    // Rule at src/isa/x64/lower.isle line 3402.
                                    return v2366;
                                }
                            }
                            &AtomicRmwOp::And => {
                                let v2374 = C::ty_int(ctx, v5);
                                if let Some(v2375) = v2374 {
                                    let v2376 = C::value_is_unused(ctx, v2);
                                    if v2376 == true {
                                        let v2377 = &C::raw_operand_size_of_type(ctx, v2375);
                                        let v2289 = C::zero_offset(ctx);
                                        let v2353 = C::unpack_value_array_2(ctx, v2350);
                                        let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                        let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                        let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                        let v2384 = constructor_x64_lock_and(ctx, v2377, v2358, v2359);
                                        let v2385 = constructor_output_reg(ctx, v2384);
                                        let v2386 = Some(v2385);
                                        // Rule at src/isa/x64/lower.isle line 3425.
                                        return v2386;
                                    }
                                }
                            }
                            &AtomicRmwOp::Or => {
                                let v2374 = C::ty_int(ctx, v5);
                                if let Some(v2375) = v2374 {
                                    let v2376 = C::value_is_unused(ctx, v2);
                                    if v2376 == true {
                                        let v2377 = &C::raw_operand_size_of_type(ctx, v2375);
                                        let v2289 = C::zero_offset(ctx);
                                        let v2353 = C::unpack_value_array_2(ctx, v2350);
                                        let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                        let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                        let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                        let v2387 = constructor_x64_lock_or(ctx, v2377, v2358, v2359);
                                        let v2388 = constructor_output_reg(ctx, v2387);
                                        let v2389 = Some(v2388);
                                        // Rule at src/isa/x64/lower.isle line 3430.
                                        return v2389;
                                    }
                                }
                            }
                            &AtomicRmwOp::Sub => {
                                let v2374 = C::ty_int(ctx, v5);
                                if let Some(v2375) = v2374 {
                                    let v2376 = C::value_is_unused(ctx, v2);
                                    if v2376 == true {
                                        let v2377 = &C::raw_operand_size_of_type(ctx, v2375);
                                        let v2289 = C::zero_offset(ctx);
                                        let v2353 = C::unpack_value_array_2(ctx, v2350);
                                        let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                        let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                        let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                        let v2381 = constructor_x64_lock_sub(ctx, v2377, v2358, v2359);
                                        let v2382 = constructor_output_reg(ctx, v2381);
                                        let v2383 = Some(v2382);
                                        // Rule at src/isa/x64/lower.isle line 3420.
                                        return v2383;
                                    }
                                }
                                let v2287 = C::ty_int(ctx, v3);
                                if let Some(v2288) = v2287 {
                                    let v2363 = &C::raw_operand_size_of_type(ctx, v5);
                                    let v2289 = C::zero_offset(ctx);
                                    let v2353 = C::unpack_value_array_2(ctx, v2350);
                                    let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                    let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                    let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                    let v2367 = constructor_x64_neg(ctx, v5, v2359);
                                    let v2368 = constructor_x64_xadd(ctx, v2363, v2358, v2367);
                                    let v2369 = constructor_output_gpr(ctx, v2368);
                                    let v2370 = Some(v2369);
                                    // Rule at src/isa/x64/lower.isle line 3405.
                                    return v2370;
                                }
                            }
                            &AtomicRmwOp::Xchg => {
                                let v2287 = C::ty_int(ctx, v3);
                                if let Some(v2288) = v2287 {
                                    let v2363 = &C::raw_operand_size_of_type(ctx, v5);
                                    let v2289 = C::zero_offset(ctx);
                                    let v2353 = C::unpack_value_array_2(ctx, v2350);
                                    let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                    let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                    let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                    let v2371 = constructor_x64_xchg(ctx, v2363, v2358, v2359);
                                    let v2372 = constructor_output_gpr(ctx, v2371);
                                    let v2373 = Some(v2372);
                                    // Rule at src/isa/x64/lower.isle line 3409.
                                    return v2373;
                                }
                            }
                            &AtomicRmwOp::Xor => {
                                let v2374 = C::ty_int(ctx, v5);
                                if let Some(v2375) = v2374 {
                                    let v2376 = C::value_is_unused(ctx, v2);
                                    if v2376 == true {
                                        let v2377 = &C::raw_operand_size_of_type(ctx, v2375);
                                        let v2289 = C::zero_offset(ctx);
                                        let v2353 = C::unpack_value_array_2(ctx, v2350);
                                        let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                                        let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                                        let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                                        let v2390 = constructor_x64_lock_xor(ctx, v2377, v2358, v2359);
                                        let v2391 = constructor_output_reg(ctx, v2390);
                                        let v2392 = Some(v2391);
                                        // Rule at src/isa/x64/lower.isle line 3435.
                                        return v2392;
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v2287 = C::ty_int(ctx, v3);
                        if let Some(v2288) = v2287 {
                            let v2356 = &constructor_atomic_rmw_seq_op(ctx, v2352);
                            let v2289 = C::zero_offset(ctx);
                            let v2353 = C::unpack_value_array_2(ctx, v2350);
                            let v2357 = &constructor_to_amode(ctx, v2351, v2353.0, v2289);
                            let v2358 = &C::amode_to_synthetic_amode(ctx, v2357);
                            let v2359 = constructor_put_in_gpr(ctx, v2353.1);
                            let v2360 = constructor_x64_atomic_rmw_seq(ctx, v5, v2356, v2358, v2359);
                            let v2361 = constructor_output_gpr(ctx, v2360);
                            let v2362 = Some(v2361);
                            // Rule at src/isa/x64/lower.isle line 3397.
                            return v2362;
                        }
                    }
                }
            }
        }
        &InstructionData::Binary {
            opcode: ref v57,
            args: ref v58,
        } => {
            match v57 {
                &Opcode::Swizzle => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                    let v3145 = C::emit_u128_le_const(ctx, 0x70707070707070707070707070707070_u128);
                    let v3146 = &constructor_const_to_xmm_mem(ctx, v3145);
                    let v3147 = constructor_x64_paddusb(ctx, v1725, v3146);
                    let v475 = constructor_put_in_xmm(ctx, v59.0);
                    let v3148 = C::xmm_to_reg(ctx, v3147);
                    let v3149 = &constructor_xmm_to_reg_mem(ctx, v3148);
                    let v3150 = &C::xmm_mem_to_reg_mem(ctx, v3149);
                    let v3151 = constructor_lower_pshufb(ctx, v475, v3150);
                    let v3152 = constructor_output_xmm(ctx, v3151);
                    let v3153 = Some(v3152);
                    // Rule at src/isa/x64/lower.isle line 4612.
                    return v3153;
                }
                &Opcode::X86Pshufb => {
                    let v719 = C::use_ssse3(ctx);
                    if v719 == true {
                        let v59 = C::unpack_value_array_2(ctx, v58);
                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                        let v3154 = constructor_x64_pshufb(ctx, v93, v94);
                        let v3155 = constructor_output_xmm(ctx, v3154);
                        let v3156 = Some(v3155);
                        // Rule at src/isa/x64/lower.isle line 4618.
                        return v3156;
                    }
                }
                &Opcode::Smin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1104 = C::ty_vec128(ctx, v3);
                        if let Some(v1105) = v1104 {
                            let v1109 = constructor_has_pmins(ctx, v1105);
                            if v1109 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1110 = constructor_x64_pmins(ctx, v1105, v93, v94);
                                let v1111 = constructor_output_xmm(ctx, v1110);
                                let v1112 = Some(v1111);
                                // Rule at src/isa/x64/lower.isle line 1784.
                                return v1112;
                            }
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v444 = &C::xmm_to_xmm_mem(ctx, v93);
                            let v1113 = constructor_x64_pcmpgt(ctx, v1105, v629, v444);
                            let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                            let v1114 = constructor_x64_pand(ctx, v1113, v446);
                            let v634 = &C::xmm_to_xmm_mem(ctx, v629);
                            let v1115 = constructor_x64_pandn(ctx, v1113, v634);
                            let v1116 = &C::xmm_to_xmm_mem(ctx, v1115);
                            let v1117 = constructor_x64_por(ctx, v1114, v1116);
                            let v1118 = constructor_output_xmm(ctx, v1117);
                            let v1119 = Some(v1118);
                            // Rule at src/isa/x64/lower.isle line 1788.
                            return v1119;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v1097 = constructor_cmp_and_choose(ctx, v5, &CC::L, v59.0, v59.1);
                            let v1098 = C::output(ctx, v1097);
                            let v1099 = Some(v1098);
                            // Rule at src/isa/x64/lower.isle line 1734.
                            return v1099;
                        }
                    }
                }
                &Opcode::Umin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1104 = C::ty_vec128(ctx, v3);
                        if let Some(v1105) = v1104 {
                            let v1144 = constructor_has_pminu(ctx, v1105);
                            if v1144 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1145 = constructor_x64_pminu(ctx, v1105, v93, v94);
                                let v1146 = constructor_output_xmm(ctx, v1145);
                                let v1147 = Some(v1146);
                                // Rule at src/isa/x64/lower.isle line 1836.
                                return v1147;
                            }
                        }
                        if v3 == I16X8 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v234 = constructor_x64_psubusw(ctx, v93, v94);
                            let v1148 = &C::xmm_to_xmm_mem(ctx, v234);
                            let v1149 = constructor_x64_psubw(ctx, v93, v1148);
                            let v1150 = constructor_output_xmm(ctx, v1149);
                            let v1151 = Some(v1150);
                            // Rule at src/isa/x64/lower.isle line 1842.
                            return v1151;
                        }
                        if let Some(v1105) = v1104 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v1129 = constructor_flip_high_bit_mask(ctx, v1105);
                            let v1130 = &C::xmm_to_xmm_mem(ctx, v1129);
                            let v1131 = constructor_x64_pxor(ctx, v93, v1130);
                            let v1132 = &C::xmm_to_xmm_mem(ctx, v1129);
                            let v1133 = constructor_x64_pxor(ctx, v629, v1132);
                            let v1152 = &C::xmm_to_xmm_mem(ctx, v1131);
                            let v1153 = constructor_x64_pcmpgt(ctx, v1105, v1133, v1152);
                            let v1136 = &C::xmm_to_xmm_mem(ctx, v93);
                            let v1154 = constructor_x64_pand(ctx, v1153, v1136);
                            let v1138 = &C::xmm_to_xmm_mem(ctx, v629);
                            let v1155 = constructor_x64_pandn(ctx, v1153, v1138);
                            let v1156 = &C::xmm_to_xmm_mem(ctx, v1155);
                            let v1157 = constructor_x64_por(ctx, v1154, v1156);
                            let v1158 = constructor_output_xmm(ctx, v1157);
                            let v1159 = Some(v1158);
                            // Rule at src/isa/x64/lower.isle line 1847.
                            return v1159;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v1089 = constructor_cmp_and_choose(ctx, v5, &CC::B, v59.0, v59.1);
                            let v1090 = C::output(ctx, v1089);
                            let v1091 = Some(v1090);
                            // Rule at src/isa/x64/lower.isle line 1728.
                            return v1091;
                        }
                    }
                }
                &Opcode::Smax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1104 = C::ty_vec128(ctx, v3);
                        if let Some(v1105) = v1104 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v1106 = constructor_lower_vec_smax(ctx, v1105, v93, v629);
                            let v1107 = constructor_output_xmm(ctx, v1106);
                            let v1108 = Some(v1107);
                            // Rule at src/isa/x64/lower.isle line 1764.
                            return v1108;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v1101 = constructor_cmp_and_choose(ctx, v5, &CC::NL, v59.0, v59.1);
                            let v1102 = C::output(ctx, v1101);
                            let v1103 = Some(v1102);
                            // Rule at src/isa/x64/lower.isle line 1737.
                            return v1103;
                        }
                    }
                }
                &Opcode::Umax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1104 = C::ty_vec128(ctx, v3);
                        if let Some(v1105) = v1104 {
                            let v1120 = constructor_has_pmaxu(ctx, v1105);
                            if v1120 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1121 = constructor_x64_pmaxu(ctx, v1105, v93, v94);
                                let v1122 = constructor_output_xmm(ctx, v1121);
                                let v1123 = Some(v1122);
                                // Rule at src/isa/x64/lower.isle line 1800.
                                return v1123;
                            }
                        }
                        if v3 == I16X8 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v444 = &C::xmm_to_xmm_mem(ctx, v93);
                            let v1124 = constructor_x64_psubusw(ctx, v629, v444);
                            let v1125 = &C::xmm_to_xmm_mem(ctx, v1124);
                            let v1126 = constructor_x64_paddw(ctx, v93, v1125);
                            let v1127 = constructor_output_xmm(ctx, v1126);
                            let v1128 = Some(v1127);
                            // Rule at src/isa/x64/lower.isle line 1806.
                            return v1128;
                        }
                        if let Some(v1105) = v1104 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v1129 = constructor_flip_high_bit_mask(ctx, v1105);
                            let v1130 = &C::xmm_to_xmm_mem(ctx, v1129);
                            let v1131 = constructor_x64_pxor(ctx, v93, v1130);
                            let v1132 = &C::xmm_to_xmm_mem(ctx, v1129);
                            let v1133 = constructor_x64_pxor(ctx, v629, v1132);
                            let v1134 = &C::xmm_to_xmm_mem(ctx, v1133);
                            let v1135 = constructor_x64_pcmpgt(ctx, v1105, v1131, v1134);
                            let v1136 = &C::xmm_to_xmm_mem(ctx, v93);
                            let v1137 = constructor_x64_pand(ctx, v1135, v1136);
                            let v1138 = &C::xmm_to_xmm_mem(ctx, v629);
                            let v1139 = constructor_x64_pandn(ctx, v1135, v1138);
                            let v1140 = &C::xmm_to_xmm_mem(ctx, v1139);
                            let v1141 = constructor_x64_por(ctx, v1137, v1140);
                            let v1142 = constructor_output_xmm(ctx, v1141);
                            let v1143 = Some(v1142);
                            // Rule at src/isa/x64/lower.isle line 1813.
                            return v1143;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v1093 = constructor_cmp_and_choose(ctx, v5, &CC::NB, v59.0, v59.1);
                            let v1094 = C::output(ctx, v1093);
                            let v1095 = Some(v1094);
                            // Rule at src/isa/x64/lower.isle line 1731.
                            return v1095;
                        }
                    }
                }
                &Opcode::AvgRound => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v560 = constructor_x64_pavgb(ctx, v93, v94);
                                        let v561 = constructor_output_xmm(ctx, v560);
                                        let v562 = Some(v561);
                                        // Rule at src/isa/x64/lower.isle line 991.
                                        return v562;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v563 = constructor_x64_pavgw(ctx, v93, v94);
                                        let v564 = constructor_output_xmm(ctx, v563);
                                        let v565 = Some(v564);
                                        // Rule at src/isa/x64/lower.isle line 995.
                                        return v565;
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::UaddSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v195 = constructor_x64_paddusb(ctx, v93, v94);
                                        let v196 = constructor_output_xmm(ctx, v195);
                                        let v197 = Some(v196);
                                        // Rule at src/isa/x64/lower.isle line 217.
                                        return v197;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v198 = constructor_x64_paddusw(ctx, v93, v94);
                                        let v199 = constructor_output_xmm(ctx, v198);
                                        let v200 = Some(v199);
                                        // Rule at src/isa/x64/lower.isle line 221.
                                        return v200;
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::SaddSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v189 = constructor_x64_paddsb(ctx, v93, v94);
                                        let v190 = constructor_output_xmm(ctx, v189);
                                        let v191 = Some(v190);
                                        // Rule at src/isa/x64/lower.isle line 207.
                                        return v191;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v192 = constructor_x64_paddsw(ctx, v93, v94);
                                        let v193 = constructor_output_xmm(ctx, v192);
                                        let v194 = Some(v193);
                                        // Rule at src/isa/x64/lower.isle line 211.
                                        return v194;
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::UsubSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v231 = constructor_x64_psubusb(ctx, v93, v94);
                                        let v232 = constructor_output_xmm(ctx, v231);
                                        let v233 = Some(v232);
                                        // Rule at src/isa/x64/lower.isle line 290.
                                        return v233;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v234 = constructor_x64_psubusw(ctx, v93, v94);
                                        let v235 = constructor_output_xmm(ctx, v234);
                                        let v236 = Some(v235);
                                        // Rule at src/isa/x64/lower.isle line 294.
                                        return v236;
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::SsubSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v225 = constructor_x64_psubsb(ctx, v93, v94);
                                        let v226 = constructor_output_xmm(ctx, v225);
                                        let v227 = Some(v226);
                                        // Rule at src/isa/x64/lower.isle line 280.
                                        return v227;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v228 = constructor_x64_psubsw(ctx, v93, v94);
                                        let v229 = constructor_output_xmm(ctx, v228);
                                        let v230 = Some(v229);
                                        // Rule at src/isa/x64/lower.isle line 284.
                                        return v230;
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::Iadd => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v120 = C::def_inst(ctx, v59.1);
                            if let Some(v121) = v120 {
                                let v122 = &C::inst_data(ctx, v121);
                                match v122 {
                                    &InstructionData::Binary {
                                        opcode: ref v123,
                                        args: ref v124,
                                    } => {
                                        if let &Opcode::Iconcat = v123 {
                                            let v107 = C::put_in_regs(ctx, v59.0);
                                            let v128 = C::put_in_regs(ctx, v59.0);
                                            let v129 = constructor_value_regs_get_gpr(ctx, v128, 0x0_usize);
                                            let v130 = C::put_in_regs(ctx, v59.0);
                                            let v131 = constructor_value_regs_get_gpr(ctx, v130, 0x1_usize);
                                            let v125 = C::unpack_value_array_2(ctx, v124);
                                            let v132 = &constructor_put_in_gpr_mem_imm(ctx, v125.0);
                                            let v133 = &constructor_put_in_gpr_mem_imm(ctx, v125.1);
                                            let v134 = constructor_iadd128(ctx, v129, v131, v132, v133);
                                            let v135 = C::output(ctx, v134);
                                            let v136 = Some(v135);
                                            // Rule at src/isa/x64/lower.isle line 106.
                                            return v136;
                                        }
                                    }
                                    &InstructionData::Unary {
                                        opcode: ref v137,
                                        arg: v138,
                                    } => {
                                        if let &Opcode::Uextend = v137 {
                                            let v139 = C::value_type(ctx, v138);
                                            if v139 == I64 {
                                                let v107 = C::put_in_regs(ctx, v59.0);
                                                let v128 = C::put_in_regs(ctx, v59.0);
                                                let v129 = constructor_value_regs_get_gpr(ctx, v128, 0x0_usize);
                                                let v130 = C::put_in_regs(ctx, v59.0);
                                                let v131 = constructor_value_regs_get_gpr(ctx, v130, 0x1_usize);
                                                let v140 = &constructor_put_in_gpr_mem_imm(ctx, v138);
                                                let v142 = RegMemImm::Imm {
                                                    simm32: 0x0_u32,
                                                };
                                                let v143 = &C::gpr_mem_imm_new(ctx, &v142);
                                                let v144 = constructor_iadd128(ctx, v129, v131, v140, v143);
                                                let v145 = C::output(ctx, v144);
                                                let v146 = Some(v145);
                                                // Rule at src/isa/x64/lower.isle line 109.
                                                return v146;
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v108 = C::put_in_regs(ctx, v59.1);
                            let v110 = constructor_value_regs_get_gpr(ctx, v107, 0x0_usize);
                            let v112 = constructor_value_regs_get_gpr(ctx, v107, 0x1_usize);
                            let v113 = constructor_value_regs_get_gpr(ctx, v108, 0x0_usize);
                            let v114 = &C::gpr_to_gpr_mem_imm(ctx, v113);
                            let v115 = constructor_value_regs_get_gpr(ctx, v108, 0x1_usize);
                            let v116 = &C::gpr_to_gpr_mem_imm(ctx, v115);
                            let v117 = constructor_iadd128(ctx, v110, v112, v114, v116);
                            let v118 = C::output(ctx, v117);
                            let v119 = Some(v118);
                            // Rule at src/isa/x64/lower.isle line 97.
                            return v119;
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v95 = constructor_x64_paddb(ctx, v93, v94);
                                        let v96 = constructor_output_xmm(ctx, v95);
                                        let v97 = Some(v96);
                                        // Rule at src/isa/x64/lower.isle line 80.
                                        return v97;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v98 = constructor_x64_paddw(ctx, v93, v94);
                                        let v99 = constructor_output_xmm(ctx, v98);
                                        let v100 = Some(v99);
                                        // Rule at src/isa/x64/lower.isle line 84.
                                        return v100;
                                    }
                                }
                                0x20_u32 => {
                                    if v90.1 == 0x4_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v101 = constructor_x64_paddd(ctx, v93, v94);
                                        let v102 = constructor_output_xmm(ctx, v101);
                                        let v103 = Some(v102);
                                        // Rule at src/isa/x64/lower.isle line 88.
                                        return v103;
                                    }
                                }
                                0x40_u32 => {
                                    if v90.1 == 0x2_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v104 = constructor_x64_paddq(ctx, v93, v94);
                                        let v105 = constructor_output_xmm(ctx, v104);
                                        let v106 = Some(v105);
                                        // Rule at src/isa/x64/lower.isle line 92.
                                        return v106;
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v85 = &constructor_sink_load_to_gpr_mem_imm(ctx, v83);
                                let v86 = constructor_x64_add(ctx, v5, v84, v85);
                                let v87 = constructor_output_gpr(ctx, v86);
                                let v88 = Some(v87);
                                // Rule at src/isa/x64/lower.isle line 74.
                                return v88;
                            }
                            let v76 = &C::sinkable_load(ctx, v59.1);
                            if let Some(v77) = v76 {
                                let v62 = constructor_put_in_gpr(ctx, v59.0);
                                let v78 = &constructor_sink_load_to_gpr_mem_imm(ctx, v77);
                                let v79 = constructor_x64_add(ctx, v5, v62, v78);
                                let v80 = constructor_output_gpr(ctx, v79);
                                let v81 = Some(v80);
                                // Rule at src/isa/x64/lower.isle line 71.
                                return v81;
                            }
                        }
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v70 = C::zero_offset(ctx);
                            let v69 = C::mem_flags_trusted(ctx);
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v71 = &constructor_to_amode_add(ctx, v69, v59.0, v59.1, v70);
                            let v72 = &C::amode_to_synthetic_amode(ctx, v71);
                            let v73 = constructor_x64_lea(ctx, v68, v72);
                            let v74 = constructor_output_gpr(ctx, v73);
                            let v75 = Some(v74);
                            // Rule at src/isa/x64/lower.isle line 65.
                            return v75;
                        }
                        let v55 = C::fits_in_16(ctx, v3);
                        if let Some(v56) = v55 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                            let v64 = constructor_x64_add(ctx, v56, v62, v63);
                            let v65 = constructor_output_gpr(ctx, v64);
                            let v66 = Some(v65);
                            // Rule at src/isa/x64/lower.isle line 54.
                            return v66;
                        }
                    }
                }
                &Opcode::Isub => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v120 = C::def_inst(ctx, v59.1);
                            if let Some(v121) = v120 {
                                let v122 = &C::inst_data(ctx, v121);
                                match v122 {
                                    &InstructionData::Binary {
                                        opcode: ref v123,
                                        args: ref v124,
                                    } => {
                                        if let &Opcode::Iconcat = v123 {
                                            let v107 = C::put_in_regs(ctx, v59.0);
                                            let v128 = C::put_in_regs(ctx, v59.0);
                                            let v129 = constructor_value_regs_get_gpr(ctx, v128, 0x0_usize);
                                            let v130 = C::put_in_regs(ctx, v59.0);
                                            let v131 = constructor_value_regs_get_gpr(ctx, v130, 0x1_usize);
                                            let v125 = C::unpack_value_array_2(ctx, v124);
                                            let v132 = &constructor_put_in_gpr_mem_imm(ctx, v125.0);
                                            let v133 = &constructor_put_in_gpr_mem_imm(ctx, v125.1);
                                            let v219 = constructor_isub128(ctx, v129, v131, v132, v133);
                                            let v220 = C::output(ctx, v219);
                                            let v221 = Some(v220);
                                            // Rule at src/isa/x64/lower.isle line 262.
                                            return v221;
                                        }
                                    }
                                    &InstructionData::Unary {
                                        opcode: ref v137,
                                        arg: v138,
                                    } => {
                                        if let &Opcode::Uextend = v137 {
                                            let v139 = C::value_type(ctx, v138);
                                            if v139 == I64 {
                                                let v107 = C::put_in_regs(ctx, v59.0);
                                                let v128 = C::put_in_regs(ctx, v59.0);
                                                let v129 = constructor_value_regs_get_gpr(ctx, v128, 0x0_usize);
                                                let v130 = C::put_in_regs(ctx, v59.0);
                                                let v131 = constructor_value_regs_get_gpr(ctx, v130, 0x1_usize);
                                                let v140 = &constructor_put_in_gpr_mem_imm(ctx, v138);
                                                let v142 = RegMemImm::Imm {
                                                    simm32: 0x0_u32,
                                                };
                                                let v143 = &C::gpr_mem_imm_new(ctx, &v142);
                                                let v222 = constructor_isub128(ctx, v129, v131, v140, v143);
                                                let v223 = C::output(ctx, v222);
                                                let v224 = Some(v223);
                                                // Rule at src/isa/x64/lower.isle line 265.
                                                return v224;
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v108 = C::put_in_regs(ctx, v59.1);
                            let v110 = constructor_value_regs_get_gpr(ctx, v107, 0x0_usize);
                            let v112 = constructor_value_regs_get_gpr(ctx, v107, 0x1_usize);
                            let v113 = constructor_value_regs_get_gpr(ctx, v108, 0x0_usize);
                            let v114 = &C::gpr_to_gpr_mem_imm(ctx, v113);
                            let v115 = constructor_value_regs_get_gpr(ctx, v108, 0x1_usize);
                            let v116 = &C::gpr_to_gpr_mem_imm(ctx, v115);
                            let v216 = constructor_isub128(ctx, v110, v112, v114, v116);
                            let v217 = C::output(ctx, v216);
                            let v218 = Some(v217);
                            // Rule at src/isa/x64/lower.isle line 253.
                            return v218;
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x8_u32 => {
                                    if v90.1 == 0x10_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v204 = constructor_x64_psubb(ctx, v93, v94);
                                        let v205 = constructor_output_xmm(ctx, v204);
                                        let v206 = Some(v205);
                                        // Rule at src/isa/x64/lower.isle line 236.
                                        return v206;
                                    }
                                }
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v207 = constructor_x64_psubw(ctx, v93, v94);
                                        let v208 = constructor_output_xmm(ctx, v207);
                                        let v209 = Some(v208);
                                        // Rule at src/isa/x64/lower.isle line 240.
                                        return v209;
                                    }
                                }
                                0x20_u32 => {
                                    if v90.1 == 0x4_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v210 = constructor_x64_psubd(ctx, v93, v94);
                                        let v211 = constructor_output_xmm(ctx, v210);
                                        let v212 = Some(v211);
                                        // Rule at src/isa/x64/lower.isle line 244.
                                        return v212;
                                    }
                                }
                                0x40_u32 => {
                                    if v90.1 == 0x2_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v213 = constructor_x64_psubq(ctx, v93, v94);
                                        let v214 = constructor_output_xmm(ctx, v213);
                                        let v215 = Some(v214);
                                        // Rule at src/isa/x64/lower.isle line 248.
                                        return v215;
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                            let v201 = constructor_x64_sub(ctx, v5, v62, v63);
                            let v202 = constructor_output_gpr(ctx, v201);
                            let v203 = Some(v202);
                            // Rule at src/isa/x64/lower.isle line 230.
                            return v203;
                        }
                    }
                }
                &Opcode::Imul => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v120 = C::def_inst(ctx, v59.1);
                            if let Some(v121) = v120 {
                                let v122 = &C::inst_data(ctx, v121);
                                match v122 {
                                    &InstructionData::Binary {
                                        opcode: ref v123,
                                        args: ref v124,
                                    } => {
                                        if let &Opcode::Iconcat = v123 {
                                            let v266 = C::def_inst(ctx, v59.0);
                                            if let Some(v267) = v266 {
                                                let v268 = &C::inst_data(ctx, v267);
                                                if let &InstructionData::Binary {
                                                    opcode: ref v603,
                                                    args: ref v604,
                                                } = v268 {
                                                    if let &Opcode::Iconcat = v603 {
                                                        let v605 = C::unpack_value_array_2(ctx, v604);
                                                        let v608 = constructor_put_in_gpr(ctx, v605.0);
                                                        let v609 = constructor_put_in_gpr(ctx, v605.1);
                                                        let v125 = C::unpack_value_array_2(ctx, v124);
                                                        let v610 = &constructor_put_in_gpr_mem(ctx, v125.0);
                                                        let v611 = &constructor_put_in_gpr_mem(ctx, v125.1);
                                                        let v612 = constructor_imul128(ctx, v608, v609, v610, v611);
                                                        let v613 = C::output(ctx, v612);
                                                        let v614 = Some(v613);
                                                        // Rule at src/isa/x64/lower.isle line 1039.
                                                        return v614;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    &InstructionData::Unary {
                                        opcode: ref v137,
                                        arg: v138,
                                    } => {
                                        match v137 {
                                            &Opcode::Uextend => {
                                                let v139 = C::value_type(ctx, v138);
                                                if v139 == I64 {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::Uextend = v269 {
                                                                let v615 = C::value_type(ctx, v270);
                                                                if v615 == I64 {
                                                                    let v281 = constructor_put_in_gpr(ctx, v270);
                                                                    let v591 = &constructor_put_in_gpr_mem(ctx, v138);
                                                                    let v172 = false;
                                                                    let v616 = constructor_x64_mul(ctx, I64, v172, v281, v591);
                                                                    let v617 = C::output(ctx, v616);
                                                                    let v618 = Some(v617);
                                                                    // Rule at src/isa/x64/lower.isle line 1081.
                                                                    return v618;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            &Opcode::Sextend => {
                                                let v139 = C::value_type(ctx, v138);
                                                if v139 == I64 {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::Sextend = v269 {
                                                                let v615 = C::value_type(ctx, v270);
                                                                if v615 == I64 {
                                                                    let v281 = constructor_put_in_gpr(ctx, v270);
                                                                    let v591 = &constructor_put_in_gpr_mem(ctx, v138);
                                                                    let v182 = true;
                                                                    let v619 = constructor_x64_mul(ctx, I64, v182, v281, v591);
                                                                    let v620 = C::output(ctx, v619);
                                                                    let v621 = Some(v620);
                                                                    // Rule at src/isa/x64/lower.isle line 1084.
                                                                    return v621;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            if v90.0 == 0x40_u32 {
                                if v90.1 == 0x2_u32 {
                                    let v463 = C::use_avx512vl(ctx);
                                    if v463 == true {
                                        let v647 = C::use_avx512dq(ctx);
                                        if v647 == true {
                                            let v59 = C::unpack_value_array_2(ctx, v58);
                                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                            let v648 = constructor_x64_vpmullq(ctx, v93, v94);
                                            let v649 = constructor_output_xmm(ctx, v648);
                                            let v650 = Some(v649);
                                            // Rule at src/isa/x64/lower.isle line 1115.
                                            return v650;
                                        }
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v108 = C::put_in_regs(ctx, v59.1);
                            let v110 = constructor_value_regs_get_gpr(ctx, v107, 0x0_usize);
                            let v112 = constructor_value_regs_get_gpr(ctx, v107, 0x1_usize);
                            let v113 = constructor_value_regs_get_gpr(ctx, v108, 0x0_usize);
                            let v598 = &C::gpr_to_gpr_mem(ctx, v113);
                            let v115 = constructor_value_regs_get_gpr(ctx, v108, 0x1_usize);
                            let v599 = &C::gpr_to_gpr_mem(ctx, v115);
                            let v600 = constructor_imul128(ctx, v110, v112, v598, v599);
                            let v601 = C::output(ctx, v600);
                            let v602 = Some(v601);
                            // Rule at src/isa/x64/lower.isle line 1030.
                            return v602;
                        }
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x10_u32 => {
                                    if v90.1 == 0x8_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v622 = constructor_x64_pmullw(ctx, v93, v94);
                                        let v623 = constructor_output_xmm(ctx, v622);
                                        let v624 = Some(v623);
                                        // Rule at src/isa/x64/lower.isle line 1092.
                                        return v624;
                                    }
                                }
                                0x20_u32 => {
                                    if v90.1 == 0x4_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v120 = C::def_inst(ctx, v59.1);
                                        if let Some(v121) = v120 {
                                            let v122 = &C::inst_data(ctx, v121);
                                            if let &InstructionData::Unary {
                                                opcode: ref v137,
                                                arg: v138,
                                            } = v122 {
                                                match v137 {
                                                    &Opcode::SwidenLow => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::SwidenLow = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x10_u32 {
                                                                            if v670.1 == 0x8_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x10_u32 {
                                                                                        if v674.1 == 0x8_u32 {
                                                                                            let v271 = constructor_put_in_xmm(ctx, v270);
                                                                                            let v677 = constructor_put_in_xmm(ctx, v138);
                                                                                            let v678 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v679 = constructor_x64_pmullw(ctx, v271, v678);
                                                                                            let v680 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v681 = constructor_x64_pmulhw(ctx, v271, v680);
                                                                                            let v682 = &C::xmm_to_xmm_mem(ctx, v681);
                                                                                            let v695 = constructor_x64_punpcklwd(ctx, v679, v682);
                                                                                            let v696 = constructor_output_xmm(ctx, v695);
                                                                                            let v697 = Some(v696);
                                                                                            // Rule at src/isa/x64/lower.isle line 1185.
                                                                                            return v697;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::SwidenHigh => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::SwidenHigh = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x10_u32 {
                                                                            if v670.1 == 0x8_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x10_u32 {
                                                                                        if v674.1 == 0x8_u32 {
                                                                                            let v271 = constructor_put_in_xmm(ctx, v270);
                                                                                            let v677 = constructor_put_in_xmm(ctx, v138);
                                                                                            let v678 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v679 = constructor_x64_pmullw(ctx, v271, v678);
                                                                                            let v680 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v681 = constructor_x64_pmulhw(ctx, v271, v680);
                                                                                            let v682 = &C::xmm_to_xmm_mem(ctx, v681);
                                                                                            let v683 = constructor_x64_punpckhwd(ctx, v679, v682);
                                                                                            let v684 = constructor_output_xmm(ctx, v683);
                                                                                            let v685 = Some(v684);
                                                                                            // Rule at src/isa/x64/lower.isle line 1162.
                                                                                            return v685;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenLow => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::UwidenLow = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x10_u32 {
                                                                            if v670.1 == 0x8_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x10_u32 {
                                                                                        if v674.1 == 0x8_u32 {
                                                                                            let v271 = constructor_put_in_xmm(ctx, v270);
                                                                                            let v677 = constructor_put_in_xmm(ctx, v138);
                                                                                            let v678 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v679 = constructor_x64_pmullw(ctx, v271, v678);
                                                                                            let v680 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v705 = constructor_x64_pmulhuw(ctx, v271, v680);
                                                                                            let v706 = &C::xmm_to_xmm_mem(ctx, v705);
                                                                                            let v713 = constructor_x64_punpcklwd(ctx, v679, v706);
                                                                                            let v714 = constructor_output_xmm(ctx, v713);
                                                                                            let v715 = Some(v714);
                                                                                            // Rule at src/isa/x64/lower.isle line 1230.
                                                                                            return v715;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenHigh => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::UwidenHigh = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x10_u32 {
                                                                            if v670.1 == 0x8_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x10_u32 {
                                                                                        if v674.1 == 0x8_u32 {
                                                                                            let v271 = constructor_put_in_xmm(ctx, v270);
                                                                                            let v677 = constructor_put_in_xmm(ctx, v138);
                                                                                            let v678 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v679 = constructor_x64_pmullw(ctx, v271, v678);
                                                                                            let v680 = &C::xmm_to_xmm_mem(ctx, v677);
                                                                                            let v705 = constructor_x64_pmulhuw(ctx, v271, v680);
                                                                                            let v706 = &C::xmm_to_xmm_mem(ctx, v705);
                                                                                            let v707 = constructor_x64_punpckhwd(ctx, v679, v706);
                                                                                            let v708 = constructor_output_xmm(ctx, v707);
                                                                                            let v709 = Some(v708);
                                                                                            // Rule at src/isa/x64/lower.isle line 1208.
                                                                                            return v709;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                        let v625 = C::use_sse41(ctx);
                                        if v625 == true {
                                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                            let v626 = constructor_x64_pmulld(ctx, v93, v94);
                                            let v627 = constructor_output_xmm(ctx, v626);
                                            let v628 = Some(v627);
                                            // Rule at src/isa/x64/lower.isle line 1095.
                                            return v628;
                                        }
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v629 = constructor_put_in_xmm(ctx, v59.1);
                                        let v444 = &C::xmm_to_xmm_mem(ctx, v93);
                                        let v631 = constructor_x64_pshufd(ctx, v444, 0x31_u8);
                                        let v632 = &C::xmm_to_xmm_mem(ctx, v629);
                                        let v633 = constructor_x64_pshufd(ctx, v632, 0x31_u8);
                                        let v634 = &C::xmm_to_xmm_mem(ctx, v629);
                                        let v635 = constructor_x64_pmuludq(ctx, v93, v634);
                                        let v636 = &C::xmm_to_xmm_mem(ctx, v635);
                                        let v638 = constructor_x64_pshufd(ctx, v636, 0x8_u8);
                                        let v639 = &C::xmm_to_xmm_mem(ctx, v633);
                                        let v640 = constructor_x64_pmuludq(ctx, v631, v639);
                                        let v641 = &C::xmm_to_xmm_mem(ctx, v640);
                                        let v642 = constructor_x64_pshufd(ctx, v641, 0x8_u8);
                                        let v643 = &C::xmm_to_xmm_mem(ctx, v642);
                                        let v644 = constructor_x64_punpckldq(ctx, v638, v643);
                                        let v645 = constructor_output_xmm(ctx, v644);
                                        let v646 = Some(v645);
                                        // Rule at src/isa/x64/lower.isle line 1102.
                                        return v646;
                                    }
                                }
                                0x40_u32 => {
                                    if v90.1 == 0x2_u32 {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v120 = C::def_inst(ctx, v59.1);
                                        if let Some(v121) = v120 {
                                            let v122 = &C::inst_data(ctx, v121);
                                            if let &InstructionData::Unary {
                                                opcode: ref v137,
                                                arg: v138,
                                            } = v122 {
                                                match v137 {
                                                    &Opcode::SwidenLow => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::SwidenLow = v269 {
                                                                    let v625 = C::use_sse41(ctx);
                                                                    if v625 == true {
                                                                        let v615 = C::value_type(ctx, v270);
                                                                        let v669 = C::multi_lane(ctx, v615);
                                                                        if let Some(v670) = v669 {
                                                                            if v670.0 == 0x20_u32 {
                                                                                if v670.1 == 0x4_u32 {
                                                                                    let v139 = C::value_type(ctx, v138);
                                                                                    let v673 = C::multi_lane(ctx, v139);
                                                                                    if let Some(v674) = v673 {
                                                                                        if v674.0 == 0x20_u32 {
                                                                                            if v674.1 == 0x4_u32 {
                                                                                                let v686 = &C::put_in_xmm_mem(ctx, v270);
                                                                                                let v699 = constructor_x64_pshufd(ctx, v686, 0x50_u8);
                                                                                                let v689 = &C::put_in_xmm_mem(ctx, v138);
                                                                                                let v700 = constructor_x64_pshufd(ctx, v689, 0x50_u8);
                                                                                                let v701 = &C::xmm_to_xmm_mem(ctx, v700);
                                                                                                let v702 = constructor_x64_pmuldq(ctx, v699, v701);
                                                                                                let v703 = constructor_output_xmm(ctx, v702);
                                                                                                let v704 = Some(v703);
                                                                                                // Rule at src/isa/x64/lower.isle line 1197.
                                                                                                return v704;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::SwidenHigh => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::SwidenHigh = v269 {
                                                                    let v625 = C::use_sse41(ctx);
                                                                    if v625 == true {
                                                                        let v615 = C::value_type(ctx, v270);
                                                                        let v669 = C::multi_lane(ctx, v615);
                                                                        if let Some(v670) = v669 {
                                                                            if v670.0 == 0x20_u32 {
                                                                                if v670.1 == 0x4_u32 {
                                                                                    let v139 = C::value_type(ctx, v138);
                                                                                    let v673 = C::multi_lane(ctx, v139);
                                                                                    if let Some(v674) = v673 {
                                                                                        if v674.0 == 0x20_u32 {
                                                                                            if v674.1 == 0x4_u32 {
                                                                                                let v686 = &C::put_in_xmm_mem(ctx, v270);
                                                                                                let v688 = constructor_x64_pshufd(ctx, v686, 0xfa_u8);
                                                                                                let v689 = &C::put_in_xmm_mem(ctx, v138);
                                                                                                let v690 = constructor_x64_pshufd(ctx, v689, 0xfa_u8);
                                                                                                let v691 = &C::xmm_to_xmm_mem(ctx, v690);
                                                                                                let v692 = constructor_x64_pmuldq(ctx, v688, v691);
                                                                                                let v693 = constructor_output_xmm(ctx, v692);
                                                                                                let v694 = Some(v693);
                                                                                                // Rule at src/isa/x64/lower.isle line 1174.
                                                                                                return v694;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenLow => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::UwidenLow = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x20_u32 {
                                                                            if v670.1 == 0x4_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x20_u32 {
                                                                                        if v674.1 == 0x4_u32 {
                                                                                            let v686 = &C::put_in_xmm_mem(ctx, v270);
                                                                                            let v699 = constructor_x64_pshufd(ctx, v686, 0x50_u8);
                                                                                            let v689 = &C::put_in_xmm_mem(ctx, v138);
                                                                                            let v700 = constructor_x64_pshufd(ctx, v689, 0x50_u8);
                                                                                            let v701 = &C::xmm_to_xmm_mem(ctx, v700);
                                                                                            let v716 = constructor_x64_pmuludq(ctx, v699, v701);
                                                                                            let v717 = constructor_output_xmm(ctx, v716);
                                                                                            let v718 = Some(v717);
                                                                                            // Rule at src/isa/x64/lower.isle line 1242.
                                                                                            return v718;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    &Opcode::UwidenHigh => {
                                                        let v266 = C::def_inst(ctx, v59.0);
                                                        if let Some(v267) = v266 {
                                                            let v268 = &C::inst_data(ctx, v267);
                                                            if let &InstructionData::Unary {
                                                                opcode: ref v269,
                                                                arg: v270,
                                                            } = v268 {
                                                                if let &Opcode::UwidenHigh = v269 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    let v669 = C::multi_lane(ctx, v615);
                                                                    if let Some(v670) = v669 {
                                                                        if v670.0 == 0x20_u32 {
                                                                            if v670.1 == 0x4_u32 {
                                                                                let v139 = C::value_type(ctx, v138);
                                                                                let v673 = C::multi_lane(ctx, v139);
                                                                                if let Some(v674) = v673 {
                                                                                    if v674.0 == 0x20_u32 {
                                                                                        if v674.1 == 0x4_u32 {
                                                                                            let v686 = &C::put_in_xmm_mem(ctx, v270);
                                                                                            let v688 = constructor_x64_pshufd(ctx, v686, 0xfa_u8);
                                                                                            let v689 = &C::put_in_xmm_mem(ctx, v138);
                                                                                            let v690 = constructor_x64_pshufd(ctx, v689, 0xfa_u8);
                                                                                            let v691 = &C::xmm_to_xmm_mem(ctx, v690);
                                                                                            let v710 = constructor_x64_pmuludq(ctx, v688, v691);
                                                                                            let v711 = constructor_output_xmm(ctx, v710);
                                                                                            let v712 = Some(v711);
                                                                                            // Rule at src/isa/x64/lower.isle line 1220.
                                                                                            return v712;
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v629 = constructor_put_in_xmm(ctx, v59.1);
                                        let v652 = &C::xmi_imm(ctx, 0x20_u32);
                                        let v653 = constructor_x64_psrlq(ctx, v93, v652);
                                        let v632 = &C::xmm_to_xmm_mem(ctx, v629);
                                        let v654 = constructor_x64_pmuludq(ctx, v653, v632);
                                        let v655 = &C::xmi_imm(ctx, 0x20_u32);
                                        let v656 = constructor_x64_psrlq(ctx, v629, v655);
                                        let v657 = &C::xmm_to_xmm_mem(ctx, v656);
                                        let v658 = constructor_x64_pmuludq(ctx, v93, v657);
                                        let v659 = &C::xmm_to_xmm_mem(ctx, v658);
                                        let v660 = constructor_x64_paddq(ctx, v654, v659);
                                        let v661 = &C::xmi_imm(ctx, 0x20_u32);
                                        let v662 = constructor_x64_psllq(ctx, v660, v661);
                                        let v663 = &C::xmm_to_xmm_mem(ctx, v629);
                                        let v664 = constructor_x64_pmuludq(ctx, v93, v663);
                                        let v665 = &C::xmm_to_xmm_mem(ctx, v662);
                                        let v666 = constructor_x64_paddq(ctx, v664, v665);
                                        let v667 = constructor_output_xmm(ctx, v666);
                                        let v668 = Some(v667);
                                        // Rule at src/isa/x64/lower.isle line 1140.
                                        return v668;
                                    }
                                }
                                _ => {}
                            }
                        }
                        if v3 == I16 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v120 = C::def_inst(ctx, v59.1);
                            if let Some(v121) = v120 {
                                let v122 = &C::inst_data(ctx, v121);
                                if let &InstructionData::Unary {
                                    opcode: ref v137,
                                    arg: v138,
                                } = v122 {
                                    match v137 {
                                        &Opcode::Uextend => {
                                            let v266 = C::def_inst(ctx, v59.0);
                                            if let Some(v267) = v266 {
                                                let v268 = &C::inst_data(ctx, v267);
                                                if let &InstructionData::Unary {
                                                    opcode: ref v269,
                                                    arg: v270,
                                                } = v268 {
                                                    if let &Opcode::Uextend = v269 {
                                                        let v281 = constructor_put_in_gpr(ctx, v270);
                                                        let v591 = &constructor_put_in_gpr_mem(ctx, v138);
                                                        let v172 = false;
                                                        let v595 = constructor_x64_mul8(ctx, v172, v281, v591);
                                                        let v596 = constructor_output_gpr(ctx, v595);
                                                        let v597 = Some(v596);
                                                        // Rule at src/isa/x64/lower.isle line 1025.
                                                        return v597;
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Sextend => {
                                            let v266 = C::def_inst(ctx, v59.0);
                                            if let Some(v267) = v266 {
                                                let v268 = &C::inst_data(ctx, v267);
                                                if let &InstructionData::Unary {
                                                    opcode: ref v269,
                                                    arg: v270,
                                                } = v268 {
                                                    if let &Opcode::Sextend = v269 {
                                                        let v281 = constructor_put_in_gpr(ctx, v270);
                                                        let v591 = &constructor_put_in_gpr_mem(ctx, v138);
                                                        let v182 = true;
                                                        let v592 = constructor_x64_mul8(ctx, v182, v281, v591);
                                                        let v593 = constructor_output_gpr(ctx, v592);
                                                        let v594 = Some(v593);
                                                        // Rule at src/isa/x64/lower.isle line 1023.
                                                        return v594;
                                                    }
                                                }
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                            }
                        }
                        let v573 = C::ty_int_ref_16_to_64(ctx, v3);
                        if let Some(v574) = v573 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v586 = C::i32_from_iconst(ctx, v59.0);
                            if let Some(v587) = v586 {
                                let v293 = &constructor_put_in_gpr_mem(ctx, v59.1);
                                let v588 = constructor_x64_imul_imm(ctx, v574, v293, v587);
                                let v589 = constructor_output_gpr(ctx, v588);
                                let v590 = Some(v589);
                                // Rule at src/isa/x64/lower.isle line 1017.
                                return v590;
                            }
                            let v581 = C::i32_from_iconst(ctx, v59.1);
                            if let Some(v582) = v581 {
                                let v287 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                let v583 = constructor_x64_imul_imm(ctx, v574, v287, v582);
                                let v584 = constructor_output_gpr(ctx, v583);
                                let v585 = Some(v584);
                                // Rule at src/isa/x64/lower.isle line 1015.
                                return v585;
                            }
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v569 = &constructor_sink_load_to_gpr_mem(ctx, v83);
                                let v578 = constructor_x64_imul(ctx, v574, v84, v569);
                                let v579 = constructor_output_gpr(ctx, v578);
                                let v580 = Some(v579);
                                // Rule at src/isa/x64/lower.isle line 1011.
                                return v580;
                            }
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                            let v575 = constructor_x64_imul(ctx, v574, v62, v173);
                            let v576 = constructor_output_gpr(ctx, v575);
                            let v577 = Some(v576);
                            // Rule at src/isa/x64/lower.isle line 1009.
                            return v577;
                        }
                        if v3 == I8 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v569 = &constructor_sink_load_to_gpr_mem(ctx, v83);
                                let v172 = false;
                                let v570 = constructor_x64_mul8(ctx, v172, v84, v569);
                                let v571 = constructor_output_gpr(ctx, v570);
                                let v572 = Some(v571);
                                // Rule at src/isa/x64/lower.isle line 1006.
                                return v572;
                            }
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                            let v172 = false;
                            let v566 = constructor_x64_mul8(ctx, v172, v62, v173);
                            let v567 = constructor_output_gpr(ctx, v566);
                            let v568 = Some(v567);
                            // Rule at src/isa/x64/lower.isle line 1005.
                            return v568;
                        }
                    }
                }
                &Opcode::Umulhi => {
                    let v304 = C::use_bmi2(ctx);
                    if v304 == true {
                        let v59 = C::unpack_value_array_2(ctx, v58);
                        let v2806 = C::value_type(ctx, v59.0);
                        let v2987 = C::ty_32_or_64(ctx, v2806);
                        if let Some(v2988) = v2987 {
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                            let v2989 = constructor_x64_mulx_hi(ctx, v2988, v62, v173);
                            let v2990 = constructor_output_gpr(ctx, v2989);
                            let v2991 = Some(v2990);
                            // Rule at src/isa/x64/lower.isle line 4425.
                            return v2991;
                        }
                    }
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    let v2981 = C::ty_int_ref_16_to_64(ctx, v2806);
                    if let Some(v2982) = v2981 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v172 = false;
                        let v2983 = constructor_x64_mul(ctx, v2982, v172, v62, v173);
                        let v2984 = constructor_value_regs_get_gpr(ctx, v2983, 0x1_usize);
                        let v2985 = constructor_output_gpr(ctx, v2984);
                        let v2986 = Some(v2985);
                        // Rule at src/isa/x64/lower.isle line 4418.
                        return v2986;
                    }
                    if v2806 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v172 = false;
                        let v566 = constructor_x64_mul8(ctx, v172, v62, v173);
                        let v2977 = &C::imm8_to_imm8_gpr(ctx, 0x8_u8);
                        let v2978 = constructor_x64_shr(ctx, I16, v566, v2977);
                        let v2979 = constructor_output_gpr(ctx, v2978);
                        let v2980 = Some(v2979);
                        // Rule at src/isa/x64/lower.isle line 4415.
                        return v2980;
                    }
                }
                &Opcode::Smulhi => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    let v2981 = C::ty_int_ref_16_to_64(ctx, v2806);
                    if let Some(v2982) = v2981 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v182 = true;
                        let v2996 = constructor_x64_mul(ctx, v2982, v182, v62, v173);
                        let v2997 = constructor_value_regs_get_gpr(ctx, v2996, 0x1_usize);
                        let v2998 = constructor_output_gpr(ctx, v2997);
                        let v2999 = Some(v2998);
                        // Rule at src/isa/x64/lower.isle line 4434.
                        return v2999;
                    }
                    if v2806 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v182 = true;
                        let v2992 = constructor_x64_mul8(ctx, v182, v62, v173);
                        let v2977 = &C::imm8_to_imm8_gpr(ctx, 0x8_u8);
                        let v2993 = constructor_x64_sar(ctx, I16, v2992, v2977);
                        let v2994 = constructor_output_gpr(ctx, v2993);
                        let v2995 = Some(v2994);
                        // Rule at src/isa/x64/lower.isle line 4431.
                        return v2995;
                    }
                }
                &Opcode::SqmulRoundSat => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I16X8 {
                        let v719 = C::use_ssse3(ctx);
                        if v719 == true {
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v629 = constructor_put_in_xmm(ctx, v59.1);
                            let v3361 = C::emit_u128_le_const(ctx, 0x80008000800080008000800080008000_u128);
                            let v3362 = &constructor_const_to_xmm_mem(ctx, v3361);
                            let v632 = &C::xmm_to_xmm_mem(ctx, v629);
                            let v3363 = constructor_x64_pmulhrsw(ctx, v93, v632);
                            let v3364 = constructor_x64_pcmpeqw(ctx, v3363, v3362);
                            let v3365 = &C::xmm_to_xmm_mem(ctx, v3364);
                            let v3366 = constructor_x64_pxor(ctx, v3363, v3365);
                            let v3367 = constructor_output_xmm(ctx, v3366);
                            let v3368 = Some(v3367);
                            // Rule at src/isa/x64/lower.isle line 4910.
                            return v3368;
                        }
                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                        let v629 = constructor_put_in_xmm(ctx, v59.1);
                        let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                        let v3369 = constructor_x64_pmullw(ctx, v93, v1838);
                        let v632 = &C::xmm_to_xmm_mem(ctx, v629);
                        let v3370 = constructor_x64_pmulhw(ctx, v93, v632);
                        let v3371 = &C::xmm_to_xmm_mem(ctx, v3370);
                        let v3372 = constructor_x64_punpcklwd(ctx, v3369, v3371);
                        let v3373 = &C::xmm_to_xmm_mem(ctx, v3370);
                        let v3374 = constructor_x64_punpckhwd(ctx, v3369, v3373);
                        let v3376 = C::emit_u128_le_const(ctx, 0x4000000040000000400000004000_u128);
                        let v3377 = &constructor_const_to_xmm_mem(ctx, v3376);
                        let v3378 = constructor_x64_movdqu_load(ctx, v3377);
                        let v3379 = &C::xmm_to_xmm_mem(ctx, v3378);
                        let v3380 = constructor_x64_paddd(ctx, v3372, v3379);
                        let v3381 = &C::xmm_to_xmm_mem(ctx, v3378);
                        let v3382 = constructor_x64_paddd(ctx, v3374, v3381);
                        let v3384 = &C::xmi_imm(ctx, 0xf_u32);
                        let v3385 = constructor_x64_psrad(ctx, v3380, v3384);
                        let v3386 = &C::xmi_imm(ctx, 0xf_u32);
                        let v3387 = constructor_x64_psrad(ctx, v3382, v3386);
                        let v3388 = &C::xmm_to_xmm_mem(ctx, v3387);
                        let v3389 = constructor_x64_packssdw(ctx, v3385, v3388);
                        let v3390 = constructor_output_xmm(ctx, v3389);
                        let v3391 = Some(v3390);
                        // Rule at src/isa/x64/lower.isle line 4926.
                        return v3391;
                    }
                }
                &Opcode::X86Pmulhrsw => {
                    let v719 = C::use_ssse3(ctx);
                    if v719 == true {
                        let v59 = C::unpack_value_array_2(ctx, v58);
                        let v2806 = C::value_type(ctx, v59.0);
                        if v2806 == I16X8 {
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v3392 = constructor_x64_pmulhrsw(ctx, v93, v94);
                            let v3393 = constructor_output_xmm(ctx, v3392);
                            let v3394 = Some(v3393);
                            // Rule at src/isa/x64/lower.isle line 4952.
                            return v3394;
                        }
                    }
                }
                &Opcode::Udiv => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I8 {
                        let v2911 = constructor_extend_to_gpr(ctx, v59.0, I32, &ExtendKind::Zero);
                        let v490 = constructor_put_in_gpr(ctx, v59.1);
                        let v2912 = &C::gpr_to_gpr_mem(ctx, v490);
                        let v2915 = constructor_x64_div8(ctx, v2911, v2912, &DivSignedness::Unsigned, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                        let v2916 = constructor_output_gpr(ctx, v2915);
                        let v2917 = Some(v2916);
                        // Rule at src/isa/x64/lower.isle line 4294.
                        return v2917;
                    }
                    let v2918 = C::fits_in_64(ctx, v2806);
                    if let Some(v2919) = v2918 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v16 = constructor_imm(ctx, I64, 0x0_u64);
                        let v2920 = C::gpr_new(ctx, v16);
                        let v2921 = constructor_put_in_gpr(ctx, v59.1);
                        let v2922 = &C::gpr_to_gpr_mem(ctx, v2921);
                        let v2923 = &C::raw_operand_size_of_type(ctx, v2919);
                        let v2924 = constructor_x64_div_quotient(ctx, v62, v2920, v2922, v2923, &DivSignedness::Unsigned, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                        let v2925 = C::output(ctx, v2924);
                        let v2926 = Some(v2925);
                        // Rule at src/isa/x64/lower.isle line 4303.
                        return v2926;
                    }
                }
                &Opcode::Sdiv => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v2928 = constructor_x64_sign_extend_data(ctx, v62, &OperandSize::Size8);
                        let v2929 = constructor_nonzero_sdiv_divisor(ctx, I8, v59.1);
                        let v2930 = &C::reg_to_gpr_mem(ctx, v2929);
                        let v2933 = constructor_x64_div8(ctx, v2928, v2930, &DivSignedness::Signed, &TrapCode::INTEGER_OVERFLOW);
                        let v2934 = constructor_output_gpr(ctx, v2933);
                        let v2935 = Some(v2934);
                        // Rule at src/isa/x64/lower.isle line 4313.
                        return v2935;
                    }
                    let v2918 = C::fits_in_64(ctx, v2806);
                    if let Some(v2919) = v2918 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v2936 = &C::raw_operand_size_of_type(ctx, v2919);
                        let v2937 = constructor_x64_sign_extend_data(ctx, v62, v2936);
                        let v2938 = constructor_nonzero_sdiv_divisor(ctx, v2919, v59.1);
                        let v2939 = &C::reg_to_gpr_mem(ctx, v2938);
                        let v2940 = constructor_x64_div_quotient(ctx, v62, v2937, v2939, v2936, &DivSignedness::Signed, &TrapCode::INTEGER_OVERFLOW);
                        let v2941 = C::output(ctx, v2940);
                        let v2942 = Some(v2941);
                        // Rule at src/isa/x64/lower.isle line 4319.
                        return v2942;
                    }
                }
                &Opcode::Urem => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I8 {
                        let v2911 = constructor_extend_to_gpr(ctx, v59.0, I32, &ExtendKind::Zero);
                        let v490 = constructor_put_in_gpr(ctx, v59.1);
                        let v2912 = &C::gpr_to_gpr_mem(ctx, v490);
                        let v2915 = constructor_x64_div8(ctx, v2911, v2912, &DivSignedness::Unsigned, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                        let v1676 = Imm8Reg::Imm8 {
                            imm: 0x8_u8,
                        };
                        let v2943 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                        let v2944 = constructor_x64_shr(ctx, I64, v2915, v2943);
                        let v2945 = constructor_output_gpr(ctx, v2944);
                        let v2946 = Some(v2945);
                        // Rule at src/isa/x64/lower.isle line 4352.
                        return v2946;
                    }
                    let v2918 = C::fits_in_64(ctx, v2806);
                    if let Some(v2919) = v2918 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v16 = constructor_imm(ctx, I64, 0x0_u64);
                        let v2920 = C::gpr_new(ctx, v16);
                        let v2921 = constructor_put_in_gpr(ctx, v59.1);
                        let v2922 = &C::gpr_to_gpr_mem(ctx, v2921);
                        let v2923 = &C::raw_operand_size_of_type(ctx, v2919);
                        let v2947 = constructor_x64_div_remainder(ctx, v62, v2920, v2922, v2923, &DivSignedness::Unsigned, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                        let v2948 = C::output(ctx, v2947);
                        let v2949 = Some(v2948);
                        // Rule at src/isa/x64/lower.isle line 4361.
                        return v2949;
                    }
                }
                &Opcode::Srem => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v120 = C::def_inst(ctx, v59.1);
                    if let Some(v121) = v120 {
                        let v122 = &C::inst_data(ctx, v121);
                        if let &InstructionData::UnaryImm {
                            opcode: ref v461,
                            imm: v462,
                        } = v122 {
                            if let &Opcode::Iconst = v461 {
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == I8 {
                                    let v2950 = C::safe_divisor_from_imm64(ctx, I8, v462);
                                    if let Some(v2951) = v2950 {
                                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                                        let v2928 = constructor_x64_sign_extend_data(ctx, v62, &OperandSize::Size8);
                                        let v2952 = constructor_imm(ctx, I8, v2951);
                                        let v2953 = &C::reg_to_gpr_mem(ctx, v2952);
                                        let v2954 = constructor_x64_div8(ctx, v2928, v2953, &DivSignedness::Signed, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                                        let v1676 = Imm8Reg::Imm8 {
                                            imm: 0x8_u8,
                                        };
                                        let v2955 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                                        let v2956 = constructor_x64_shr(ctx, I64, v2954, v2955);
                                        let v2957 = constructor_output_gpr(ctx, v2956);
                                        let v2958 = Some(v2957);
                                        // Rule at src/isa/x64/lower.isle line 4376.
                                        return v2958;
                                    }
                                }
                                let v2959 = C::safe_divisor_from_imm64(ctx, v2806, v462);
                                if let Some(v2960) = v2959 {
                                    let v62 = constructor_put_in_gpr(ctx, v59.0);
                                    let v2961 = &C::raw_operand_size_of_type(ctx, v2806);
                                    let v2962 = constructor_x64_sign_extend_data(ctx, v62, v2961);
                                    let v2963 = constructor_imm(ctx, v2806, v2960);
                                    let v2964 = &C::reg_to_gpr_mem(ctx, v2963);
                                    let v2965 = constructor_x64_div_remainder(ctx, v62, v2962, v2964, v2961, &DivSignedness::Signed, &TrapCode::INTEGER_DIVISION_BY_ZERO);
                                    let v2966 = C::output(ctx, v2965);
                                    let v2967 = Some(v2966);
                                    // Rule at src/isa/x64/lower.isle line 4385.
                                    return v2967;
                                }
                            }
                        }
                    }
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v2928 = constructor_x64_sign_extend_data(ctx, v62, &OperandSize::Size8);
                        let v2968 = constructor_put_in_gpr(ctx, v59.1);
                        let v2969 = constructor_x64_checked_srem_seq8(ctx, v2928, v2968);
                        let v1676 = Imm8Reg::Imm8 {
                            imm: 0x8_u8,
                        };
                        let v2943 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                        let v2970 = constructor_x64_shr(ctx, I64, v2969, v2943);
                        let v2971 = constructor_output_gpr(ctx, v2970);
                        let v2972 = Some(v2971);
                        // Rule at src/isa/x64/lower.isle line 4398.
                        return v2972;
                    }
                    let v62 = constructor_put_in_gpr(ctx, v59.0);
                    let v2961 = &C::raw_operand_size_of_type(ctx, v2806);
                    let v2962 = constructor_x64_sign_extend_data(ctx, v62, v2961);
                    let v2921 = constructor_put_in_gpr(ctx, v59.1);
                    let v2973 = constructor_x64_checked_srem_seq(ctx, v2961, v62, v2962, v2921);
                    let v2974 = C::value_regs_get(ctx, v2973, 0x1_usize);
                    let v2975 = constructor_output_reg(ctx, v2974);
                    let v2976 = Some(v2975);
                    // Rule at src/isa/x64/lower.isle line 4404.
                    return v2976;
                }
                &Opcode::UaddOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v148 = C::fits_in_64(ctx, v147);
                    if let Some(v149) = v148 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                        let v152 = constructor_construct_overflow_op_alu(ctx, v149, &CC::B, &AluRmiROpcode::Add, v62, v63);
                        let v153 = Some(v152);
                        // Rule at src/isa/x64/lower.isle line 158.
                        return v153;
                    }
                    if v147 == I128 {
                        let v155 = constructor_construct_overflow_op_alu_128(ctx, &CC::B, &AluRmiROpcode::Add, &AluRmiROpcode::Adc, v59.0, v59.1);
                        let v156 = Some(v155);
                        // Rule at src/isa/x64/lower.isle line 162.
                        return v156;
                    }
                }
                &Opcode::SaddOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v148 = C::fits_in_64(ctx, v147);
                    if let Some(v149) = v148 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                        let v158 = constructor_construct_overflow_op_alu(ctx, v149, &CC::O, &AluRmiROpcode::Add, v62, v63);
                        let v159 = Some(v158);
                        // Rule at src/isa/x64/lower.isle line 167.
                        return v159;
                    }
                    if v147 == I128 {
                        let v160 = constructor_construct_overflow_op_alu_128(ctx, &CC::O, &AluRmiROpcode::Add, &AluRmiROpcode::Adc, v59.0, v59.1);
                        let v161 = Some(v160);
                        // Rule at src/isa/x64/lower.isle line 170.
                        return v161;
                    }
                }
                &Opcode::UsubOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v148 = C::fits_in_64(ctx, v147);
                    if let Some(v149) = v148 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                        let v163 = constructor_construct_overflow_op_alu(ctx, v149, &CC::B, &AluRmiROpcode::Sub, v62, v63);
                        let v164 = Some(v163);
                        // Rule at src/isa/x64/lower.isle line 175.
                        return v164;
                    }
                    if v147 == I128 {
                        let v166 = constructor_construct_overflow_op_alu_128(ctx, &CC::B, &AluRmiROpcode::Sub, &AluRmiROpcode::Sbb, v59.0, v59.1);
                        let v167 = Some(v166);
                        // Rule at src/isa/x64/lower.isle line 178.
                        return v167;
                    }
                }
                &Opcode::SsubOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v148 = C::fits_in_64(ctx, v147);
                    if let Some(v149) = v148 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                        let v168 = constructor_construct_overflow_op_alu(ctx, v149, &CC::O, &AluRmiROpcode::Sub, v62, v63);
                        let v169 = Some(v168);
                        // Rule at src/isa/x64/lower.isle line 183.
                        return v169;
                    }
                    if v147 == I128 {
                        let v170 = constructor_construct_overflow_op_alu_128(ctx, &CC::O, &AluRmiROpcode::Sub, &AluRmiROpcode::Sbb, v59.0, v59.1);
                        let v171 = Some(v170);
                        // Rule at src/isa/x64/lower.isle line 186.
                        return v171;
                    }
                }
                &Opcode::UmulOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v177 = C::ty_int_ref_16_to_64(ctx, v147);
                    if let Some(v178) = v177 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v172 = false;
                        let v179 = &constructor_x64_mul_lo_with_flags_paired(ctx, v178, v172, v62, v173);
                        let v180 = constructor_construct_overflow_op(ctx, &CC::O, v179);
                        let v181 = Some(v180);
                        // Rule at src/isa/x64/lower.isle line 194.
                        return v181;
                    }
                    if v147 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v172 = false;
                        let v174 = &constructor_x64_mul8_with_flags_paired(ctx, v172, v62, v173);
                        let v175 = constructor_construct_overflow_op(ctx, &CC::O, v174);
                        let v176 = Some(v175);
                        // Rule at src/isa/x64/lower.isle line 191.
                        return v176;
                    }
                }
                &Opcode::SmulOverflow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v147 = C::value_type(ctx, v59.1);
                    let v177 = C::ty_int_ref_16_to_64(ctx, v147);
                    if let Some(v178) = v177 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v182 = true;
                        let v186 = &constructor_x64_mul_lo_with_flags_paired(ctx, v178, v182, v62, v173);
                        let v187 = constructor_construct_overflow_op(ctx, &CC::O, v186);
                        let v188 = Some(v187);
                        // Rule at src/isa/x64/lower.isle line 202.
                        return v188;
                    }
                    if v147 == I8 {
                        let v62 = constructor_put_in_gpr(ctx, v59.0);
                        let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                        let v182 = true;
                        let v183 = &constructor_x64_mul8_with_flags_paired(ctx, v182, v62, v173);
                        let v184 = constructor_construct_overflow_op(ctx, &CC::O, v183);
                        let v185 = Some(v184);
                        // Rule at src/isa/x64/lower.isle line 199.
                        return v185;
                    }
                }
                &Opcode::Band => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v285 = constructor_val_minus_one(ctx, v59.1);
                            if let Some(v286) = v285 {
                                let v304 = C::use_bmi2(ctx);
                                if v304 == true {
                                    let v305 = C::def_inst(ctx, v286);
                                    if let Some(v306) = v305 {
                                        let v307 = &C::inst_data(ctx, v306);
                                        if let &InstructionData::Binary {
                                            opcode: ref v308,
                                            args: ref v309,
                                        } = v307 {
                                            if let &Opcode::Ishl = v308 {
                                                let v310 = C::unpack_value_array_2(ctx, v309);
                                                let v313 = C::def_inst(ctx, v310.0);
                                                if let Some(v314) = v313 {
                                                    let v315 = &C::inst_data(ctx, v314);
                                                    if let &InstructionData::UnaryImm {
                                                        opcode: ref v316,
                                                        imm: v317,
                                                    } = v315 {
                                                        if let &Opcode::Iconst = v316 {
                                                            let v318 = C::u64_from_imm64(ctx, v317);
                                                            if v318 == 0x1_u64 {
                                                                let v287 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                                                let v319 = constructor_put_in_gpr(ctx, v310.1);
                                                                let v320 = C::ty_bits(ctx, v68);
                                                                let v321 = C::u8_as_u32(ctx, v320);
                                                                let v323 = C::u32_sub(ctx, v321, 0x1_u32);
                                                                let v324 = RegMemImm::Imm {
                                                                    simm32: v323,
                                                                };
                                                                let v325 = &C::gpr_mem_imm_new(ctx, &v324);
                                                                let v326 = constructor_x64_and(ctx, v68, v319, v325);
                                                                let v327 = constructor_x64_bzhi(ctx, v68, v287, v326);
                                                                let v328 = constructor_output_gpr(ctx, v327);
                                                                let v329 = Some(v328);
                                                                // Rule at src/isa/x64/lower.isle line 417.
                                                                return v329;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            let v275 = C::use_bmi1(ctx);
                            if v275 == true {
                                let v120 = C::def_inst(ctx, v59.1);
                                if let Some(v121) = v120 {
                                    let v122 = &C::inst_data(ctx, v121);
                                    if let &InstructionData::Unary {
                                        opcode: ref v137,
                                        arg: v138,
                                    } = v122 {
                                        if let &Opcode::Ineg = v137 {
                                            if v59.0 == v138 {
                                                let v287 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                                let v301 = constructor_x64_blsi(ctx, v68, v287);
                                                let v302 = constructor_output_gpr(ctx, v301);
                                                let v303 = Some(v302);
                                                // Rule at src/isa/x64/lower.isle line 404.
                                                return v303;
                                            }
                                        }
                                    }
                                }
                                let v266 = C::def_inst(ctx, v59.0);
                                if let Some(v267) = v266 {
                                    let v268 = &C::inst_data(ctx, v267);
                                    if let &InstructionData::Unary {
                                        opcode: ref v269,
                                        arg: v270,
                                    } = v268 {
                                        if let &Opcode::Ineg = v269 {
                                            if v59.1 == v270 {
                                                let v297 = &constructor_put_in_gpr_mem(ctx, v270);
                                                let v298 = constructor_x64_blsi(ctx, v68, v297);
                                                let v299 = constructor_output_gpr(ctx, v298);
                                                let v300 = Some(v299);
                                                // Rule at src/isa/x64/lower.isle line 401.
                                                return v300;
                                            }
                                        }
                                    }
                                }
                                let v291 = constructor_val_minus_one(ctx, v59.0);
                                if let Some(v292) = v291 {
                                    if v59.1 == v292 {
                                        let v293 = &constructor_put_in_gpr_mem(ctx, v59.1);
                                        let v294 = constructor_x64_blsr(ctx, v68, v293);
                                        let v295 = constructor_output_gpr(ctx, v294);
                                        let v296 = Some(v295);
                                        // Rule at src/isa/x64/lower.isle line 394.
                                        return v296;
                                    }
                                }
                                if let Some(v286) = v285 {
                                    if v59.0 == v286 {
                                        let v287 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                        let v288 = constructor_x64_blsr(ctx, v68, v287);
                                        let v289 = constructor_output_gpr(ctx, v288);
                                        let v290 = Some(v289);
                                        // Rule at src/isa/x64/lower.isle line 390.
                                        return v290;
                                    }
                                }
                            }
                        }
                        let v237 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v238) = v237 {
                            let v275 = C::use_bmi1(ctx);
                            if v275 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v266 = C::def_inst(ctx, v59.0);
                                if let Some(v267) = v266 {
                                    let v268 = &C::inst_data(ctx, v267);
                                    if let &InstructionData::Unary {
                                        opcode: ref v269,
                                        arg: v270,
                                    } = v268 {
                                        if let &Opcode::Bnot = v269 {
                                            let v281 = constructor_put_in_gpr(ctx, v270);
                                            let v173 = &constructor_put_in_gpr_mem(ctx, v59.1);
                                            let v282 = constructor_x64_andn(ctx, v3, v281, v173);
                                            let v283 = constructor_output_gpr(ctx, v282);
                                            let v284 = Some(v283);
                                            // Rule at src/isa/x64/lower.isle line 378.
                                            return v284;
                                        }
                                    }
                                }
                                let v120 = C::def_inst(ctx, v59.1);
                                if let Some(v121) = v120 {
                                    let v122 = &C::inst_data(ctx, v121);
                                    if let &InstructionData::Unary {
                                        opcode: ref v137,
                                        arg: v138,
                                    } = v122 {
                                        if let &Opcode::Bnot = v137 {
                                            let v276 = constructor_put_in_gpr(ctx, v138);
                                            let v277 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                            let v278 = constructor_x64_andn(ctx, v3, v276, v277);
                                            let v279 = constructor_output_gpr(ctx, v278);
                                            let v280 = Some(v279);
                                            // Rule at src/isa/x64/lower.isle line 373.
                                            return v280;
                                        }
                                    }
                                }
                            }
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v266 = C::def_inst(ctx, v59.0);
                            if let Some(v267) = v266 {
                                let v268 = &C::inst_data(ctx, v267);
                                if let &InstructionData::Unary {
                                    opcode: ref v269,
                                    arg: v270,
                                } = v268 {
                                    if let &Opcode::Bnot = v269 {
                                        let v271 = constructor_put_in_xmm(ctx, v270);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v272 = constructor_sse_and_not(ctx, v3, v271, v94);
                                        let v273 = constructor_output_xmm(ctx, v272);
                                        let v274 = Some(v273);
                                        // Rule at src/isa/x64/lower.isle line 370.
                                        return v274;
                                    }
                                }
                            }
                            let v120 = C::def_inst(ctx, v59.1);
                            if let Some(v121) = v120 {
                                let v122 = &C::inst_data(ctx, v121);
                                if let &InstructionData::Unary {
                                    opcode: ref v137,
                                    arg: v138,
                                } = v122 {
                                    if let &Opcode::Bnot = v137 {
                                        let v261 = constructor_put_in_xmm(ctx, v138);
                                        let v262 = &C::put_in_xmm_mem(ctx, v59.0);
                                        let v263 = constructor_sse_and_not(ctx, v3, v261, v262);
                                        let v264 = constructor_output_xmm(ctx, v263);
                                        let v265 = Some(v264);
                                        // Rule at src/isa/x64/lower.isle line 368.
                                        return v265;
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v108 = C::put_in_regs(ctx, v59.1);
                            let v258 = constructor_and_i128(ctx, v107, v108);
                            let v259 = C::output(ctx, v258);
                            let v260 = Some(v259);
                            // Rule at src/isa/x64/lower.isle line 349.
                            return v260;
                        }
                        if let Some(v90) = v89 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v255 = constructor_sse_and(ctx, v3, v93, v94);
                            let v256 = constructor_output_xmm(ctx, v255);
                            let v257 = Some(v256);
                            // Rule at src/isa/x64/lower.isle line 332.
                            return v257;
                        }
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v252 = constructor_sse_and(ctx, v251, v93, v94);
                            let v253 = constructor_output_xmm(ctx, v252);
                            let v254 = Some(v253);
                            // Rule at src/isa/x64/lower.isle line 320.
                            return v254;
                        }
                        if let Some(v238) = v237 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v245 = &C::simm32_from_value(ctx, v59.0);
                            if let Some(v246) = v245 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v247 = constructor_x64_and(ctx, v3, v84, v246);
                                let v248 = constructor_output_gpr(ctx, v247);
                                let v249 = Some(v248);
                                // Rule at src/isa/x64/lower.isle line 314.
                                return v249;
                            }
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v85 = &constructor_sink_load_to_gpr_mem_imm(ctx, v83);
                                let v242 = constructor_x64_and(ctx, v3, v84, v85);
                                let v243 = constructor_output_gpr(ctx, v242);
                                let v244 = Some(v243);
                                // Rule at src/isa/x64/lower.isle line 310.
                                return v244;
                            }
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                            let v239 = constructor_x64_and(ctx, v3, v62, v63);
                            let v240 = constructor_output_gpr(ctx, v239);
                            let v241 = Some(v240);
                            // Rule at src/isa/x64/lower.isle line 303.
                            return v241;
                        }
                    }
                }
                &Opcode::Bor => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v108 = C::put_in_regs(ctx, v59.1);
                            let v345 = constructor_or_i128(ctx, v107, v108);
                            let v346 = C::output(ctx, v345);
                            let v347 = Some(v346);
                            // Rule at src/isa/x64/lower.isle line 471.
                            return v347;
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v342 = constructor_sse_or(ctx, v3, v93, v94);
                            let v343 = constructor_output_xmm(ctx, v342);
                            let v344 = Some(v343);
                            // Rule at src/isa/x64/lower.isle line 456.
                            return v344;
                        }
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v339 = constructor_sse_or(ctx, v251, v93, v94);
                            let v340 = constructor_output_xmm(ctx, v339);
                            let v341 = Some(v340);
                            // Rule at src/isa/x64/lower.isle line 444.
                            return v341;
                        }
                        let v237 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v238) = v237 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v245 = &C::simm32_from_value(ctx, v59.0);
                            if let Some(v246) = v245 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v336 = constructor_x64_or(ctx, v3, v84, v246);
                                let v337 = constructor_output_gpr(ctx, v336);
                                let v338 = Some(v337);
                                // Rule at src/isa/x64/lower.isle line 438.
                                return v338;
                            }
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v85 = &constructor_sink_load_to_gpr_mem_imm(ctx, v83);
                                let v333 = constructor_x64_or(ctx, v3, v84, v85);
                                let v334 = constructor_output_gpr(ctx, v333);
                                let v335 = Some(v334);
                                // Rule at src/isa/x64/lower.isle line 434.
                                return v335;
                            }
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                            let v330 = constructor_x64_or(ctx, v3, v62, v63);
                            let v331 = constructor_output_gpr(ctx, v330);
                            let v332 = Some(v331);
                            // Rule at src/isa/x64/lower.isle line 427.
                            return v332;
                        }
                    }
                }
                &Opcode::Bxor => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v275 = C::use_bmi1(ctx);
                            if v275 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v291 = constructor_val_minus_one(ctx, v59.0);
                                if let Some(v292) = v291 {
                                    if v59.1 == v292 {
                                        let v293 = &constructor_put_in_gpr_mem(ctx, v59.1);
                                        let v378 = constructor_x64_blsmsk(ctx, v68, v293);
                                        let v379 = constructor_output_gpr(ctx, v378);
                                        let v380 = Some(v379);
                                        // Rule at src/isa/x64/lower.isle line 522.
                                        return v380;
                                    }
                                }
                                let v285 = constructor_val_minus_one(ctx, v59.1);
                                if let Some(v286) = v285 {
                                    if v59.0 == v286 {
                                        let v287 = &constructor_put_in_gpr_mem(ctx, v59.0);
                                        let v375 = constructor_x64_blsmsk(ctx, v68, v287);
                                        let v376 = constructor_output_gpr(ctx, v375);
                                        let v377 = Some(v376);
                                        // Rule at src/isa/x64/lower.isle line 518.
                                        return v377;
                                    }
                                }
                            }
                        }
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v363 = constructor_value_regs_get_gpr(ctx, v107, 0x0_usize);
                            let v364 = constructor_value_regs_get_gpr(ctx, v107, 0x1_usize);
                            let v365 = C::put_in_regs(ctx, v59.1);
                            let v366 = constructor_value_regs_get_gpr(ctx, v365, 0x0_usize);
                            let v367 = constructor_value_regs_get_gpr(ctx, v365, 0x1_usize);
                            let v368 = &C::gpr_to_gpr_mem_imm(ctx, v366);
                            let v369 = constructor_x64_xor(ctx, I64, v363, v368);
                            let v370 = &C::gpr_to_gpr_mem_imm(ctx, v367);
                            let v371 = constructor_x64_xor(ctx, I64, v364, v370);
                            let v372 = constructor_value_gprs(ctx, v369, v371);
                            let v373 = C::output(ctx, v372);
                            let v374 = Some(v373);
                            // Rule at src/isa/x64/lower.isle line 506.
                            return v374;
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v360 = constructor_x64_xor_vector(ctx, v3, v93, v94);
                            let v361 = constructor_output_xmm(ctx, v360);
                            let v362 = Some(v361);
                            // Rule at src/isa/x64/lower.isle line 501.
                            return v362;
                        }
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v93 = constructor_put_in_xmm(ctx, v59.0);
                            let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                            let v357 = constructor_x64_xor_vector(ctx, v251, v93, v94);
                            let v358 = constructor_output_xmm(ctx, v357);
                            let v359 = Some(v358);
                            // Rule at src/isa/x64/lower.isle line 496.
                            return v359;
                        }
                        let v237 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v238) = v237 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v245 = &C::simm32_from_value(ctx, v59.0);
                            if let Some(v246) = v245 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v354 = constructor_x64_xor(ctx, v3, v84, v246);
                                let v355 = constructor_output_gpr(ctx, v354);
                                let v356 = Some(v355);
                                // Rule at src/isa/x64/lower.isle line 490.
                                return v356;
                            }
                            let v82 = &C::sinkable_load(ctx, v59.0);
                            if let Some(v83) = v82 {
                                let v84 = constructor_put_in_gpr(ctx, v59.1);
                                let v85 = &constructor_sink_load_to_gpr_mem_imm(ctx, v83);
                                let v351 = constructor_x64_xor(ctx, v3, v84, v85);
                                let v352 = constructor_output_gpr(ctx, v351);
                                let v353 = Some(v352);
                                // Rule at src/isa/x64/lower.isle line 486.
                                return v353;
                            }
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v63 = &constructor_put_in_gpr_mem_imm(ctx, v59.1);
                            let v348 = constructor_x64_xor(ctx, v3, v62, v63);
                            let v349 = constructor_output_gpr(ctx, v348);
                            let v350 = Some(v349);
                            // Rule at src/isa/x64/lower.isle line 479.
                            return v350;
                        }
                    }
                }
                &Opcode::Rotl => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v500 = constructor_lo_gpr(ctx, v59.1);
                            let v501 = constructor_shl_i128(ctx, v107, v500);
                            let v503 = constructor_imm(ctx, I64, 0x80_u64);
                            let v504 = C::gpr_new(ctx, v503);
                            let v505 = &C::gpr_to_gpr_mem_imm(ctx, v500);
                            let v506 = constructor_x64_sub(ctx, I64, v504, v505);
                            let v507 = constructor_shr_i128(ctx, v107, v506);
                            let v508 = constructor_or_i128(ctx, v501, v507);
                            let v509 = C::output(ctx, v508);
                            let v510 = Some(v509);
                            // Rule at src/isa/x64/lower.isle line 928.
                            return v510;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v381 = &constructor_put_masked_in_imm8_gpr(ctx, v59.1, v5);
                            let v497 = constructor_x64_rotl(ctx, v5, v62, v381);
                            let v498 = constructor_output_gpr(ctx, v497);
                            let v499 = Some(v498);
                            // Rule at src/isa/x64/lower.isle line 922.
                            return v499;
                        }
                    }
                }
                &Opcode::Rotr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v107 = C::put_in_regs(ctx, v59.0);
                            let v500 = constructor_lo_gpr(ctx, v59.1);
                            let v514 = constructor_shr_i128(ctx, v107, v500);
                            let v503 = constructor_imm(ctx, I64, 0x80_u64);
                            let v504 = C::gpr_new(ctx, v503);
                            let v505 = &C::gpr_to_gpr_mem_imm(ctx, v500);
                            let v506 = constructor_x64_sub(ctx, I64, v504, v505);
                            let v515 = constructor_shl_i128(ctx, v107, v506);
                            let v516 = constructor_or_i128(ctx, v514, v515);
                            let v517 = C::output(ctx, v516);
                            let v518 = Some(v517);
                            // Rule at src/isa/x64/lower.isle line 949.
                            return v518;
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v381 = &constructor_put_masked_in_imm8_gpr(ctx, v59.1, v5);
                            let v511 = constructor_x64_rotr(ctx, v5, v62, v381);
                            let v512 = constructor_output_gpr(ctx, v511);
                            let v513 = Some(v512);
                            // Rule at src/isa/x64/lower.isle line 943.
                            return v513;
                        }
                    }
                }
                &Opcode::Ishl => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v385 = constructor_lo_gpr(ctx, v59.1);
                                let v128 = C::put_in_regs(ctx, v59.0);
                                let v386 = constructor_shl_i128(ctx, v128, v385);
                                let v387 = C::output(ctx, v386);
                                let v388 = Some(v387);
                                // Rule at src/isa/x64/lower.isle line 570.
                                return v388;
                            }
                            I8X16 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v389 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v390 = constructor_put_in_xmm(ctx, v59.0);
                                let v391 = &constructor_mov_rmi_to_xmm(ctx, v389);
                                let v392 = constructor_x64_psllw(ctx, v390, v391);
                                let v393 = &constructor_ishl_i8x16_mask(ctx, v389);
                                let v396 = constructor_x64_load(ctx, I8X16, v393, &ExtKind::None);
                                let v397 = RegMem::Reg {
                                    reg: v396,
                                };
                                let v398 = &C::reg_mem_to_xmm_mem(ctx, &v397);
                                let v399 = constructor_sse_and(ctx, I8X16, v392, v398);
                                let v400 = constructor_output_xmm(ctx, v399);
                                let v401 = Some(v400);
                                // Rule at src/isa/x64/lower.isle line 582.
                                return v401;
                            }
                            I16X8 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v404 = constructor_x64_psllw(ctx, v93, v403);
                                let v405 = constructor_output_xmm(ctx, v404);
                                let v406 = Some(v405);
                                // Rule at src/isa/x64/lower.isle line 627.
                                return v406;
                            }
                            I32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v407 = constructor_x64_pslld(ctx, v93, v403);
                                let v408 = constructor_output_xmm(ctx, v407);
                                let v409 = Some(v408);
                                // Rule at src/isa/x64/lower.isle line 630.
                                return v409;
                            }
                            I64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v410 = constructor_x64_psllq(ctx, v93, v403);
                                let v411 = constructor_output_xmm(ctx, v410);
                                let v412 = Some(v411);
                                // Rule at src/isa/x64/lower.isle line 633.
                                return v412;
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v62 = constructor_put_in_gpr(ctx, v59.0);
                            let v381 = &constructor_put_masked_in_imm8_gpr(ctx, v59.1, v5);
                            let v382 = constructor_x64_shl(ctx, v5, v62, v381);
                            let v383 = constructor_output_gpr(ctx, v382);
                            let v384 = Some(v383);
                            // Rule at src/isa/x64/lower.isle line 531.
                            return v384;
                        }
                    }
                }
                &Opcode::Ushr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v385 = constructor_lo_gpr(ctx, v59.1);
                                let v128 = C::put_in_regs(ctx, v59.0);
                                let v418 = constructor_shr_i128(ctx, v128, v385);
                                let v419 = C::output(ctx, v418);
                                let v420 = Some(v419);
                                // Rule at src/isa/x64/lower.isle line 677.
                                return v420;
                            }
                            I8X16 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v389 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v390 = constructor_put_in_xmm(ctx, v59.0);
                                let v391 = &constructor_mov_rmi_to_xmm(ctx, v389);
                                let v421 = constructor_x64_psrlw(ctx, v390, v391);
                                let v422 = &constructor_ushr_i8x16_mask(ctx, v389);
                                let v423 = &constructor_synthetic_amode_to_xmm_mem(ctx, v422);
                                let v424 = constructor_sse_and(ctx, I8X16, v421, v423);
                                let v425 = constructor_output_xmm(ctx, v424);
                                let v426 = Some(v425);
                                // Rule at src/isa/x64/lower.isle line 687.
                                return v426;
                            }
                            I16X8 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v427 = constructor_x64_psrlw(ctx, v93, v403);
                                let v428 = constructor_output_xmm(ctx, v427);
                                let v429 = Some(v428);
                                // Rule at src/isa/x64/lower.isle line 733.
                                return v429;
                            }
                            I32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v430 = constructor_x64_psrld(ctx, v93, v403);
                                let v431 = constructor_output_xmm(ctx, v430);
                                let v432 = Some(v431);
                                // Rule at src/isa/x64/lower.isle line 736.
                                return v432;
                            }
                            I64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v433 = constructor_x64_psrlq(ctx, v93, v403);
                                let v434 = constructor_output_xmm(ctx, v433);
                                let v435 = Some(v434);
                                // Rule at src/isa/x64/lower.isle line 739.
                                return v435;
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v414 = constructor_extend_to_gpr(ctx, v59.0, v5, &ExtendKind::Zero);
                            let v381 = &constructor_put_masked_in_imm8_gpr(ctx, v59.1, v5);
                            let v415 = constructor_x64_shr(ctx, v5, v414, v381);
                            let v416 = constructor_output_gpr(ctx, v415);
                            let v417 = Some(v416);
                            // Rule at src/isa/x64/lower.isle line 640.
                            return v417;
                        }
                    }
                }
                &Opcode::Sshr => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v385 = constructor_lo_gpr(ctx, v59.1);
                                let v128 = C::put_in_regs(ctx, v59.0);
                                let v441 = constructor_sar_i128(ctx, v128, v385);
                                let v442 = C::output(ctx, v441);
                                let v443 = Some(v442);
                                // Rule at src/isa/x64/lower.isle line 789.
                                return v443;
                            }
                            I8X16 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v444 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v445 = constructor_x64_punpcklbw(ctx, v93, v444);
                                let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v447 = constructor_x64_punpckhbw(ctx, v93, v446);
                                let v147 = C::value_type(ctx, v59.1);
                                let v448 = &constructor_sshr_i8x16_bigger_shift(ctx, v147, v402);
                                let v449 = constructor_x64_psraw(ctx, v445, v448);
                                let v450 = constructor_x64_psraw(ctx, v447, v448);
                                let v451 = &C::xmm_to_xmm_mem(ctx, v450);
                                let v452 = constructor_x64_packsswb(ctx, v449, v451);
                                let v453 = constructor_output_xmm(ctx, v452);
                                let v454 = Some(v453);
                                // Rule at src/isa/x64/lower.isle line 810.
                                return v454;
                            }
                            I16X8 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v455 = constructor_x64_psraw(ctx, v93, v403);
                                let v456 = constructor_output_xmm(ctx, v455);
                                let v457 = Some(v456);
                                // Rule at src/isa/x64/lower.isle line 839.
                                return v457;
                            }
                            I32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v402 = &constructor_mask_xmm_shift(ctx, v3, v59.1);
                                let v403 = &constructor_mov_rmi_to_xmm(ctx, v402);
                                let v458 = constructor_x64_psrad(ctx, v93, v403);
                                let v459 = constructor_output_xmm(ctx, v458);
                                let v460 = Some(v459);
                                // Rule at src/isa/x64/lower.isle line 842.
                                return v460;
                            }
                            I64X2 => {
                                let v463 = C::use_avx512vl(ctx);
                                if v463 == true {
                                    let v464 = C::use_avx512f(ctx);
                                    if v464 == true {
                                        let v59 = C::unpack_value_array_2(ctx, v58);
                                        let v120 = C::def_inst(ctx, v59.1);
                                        if let Some(v121) = v120 {
                                            let v122 = &C::inst_data(ctx, v121);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v461,
                                                imm: v462,
                                            } = v122 {
                                                if let &Opcode::Iconst = v461 {
                                                    let v465 = &C::put_in_xmm_mem(ctx, v59.0);
                                                    let v466 = C::shift_amount_masked(ctx, v3, v462);
                                                    let v467 = constructor_x64_vpsraq_imm(ctx, v465, v466);
                                                    let v468 = constructor_output_xmm(ctx, v467);
                                                    let v469 = Some(v468);
                                                    // Rule at src/isa/x64/lower.isle line 848.
                                                    return v469;
                                                }
                                            }
                                        }
                                        let v84 = constructor_put_in_gpr(ctx, v59.1);
                                        let v470 = C::shift_mask(ctx, v3);
                                        let v471 = C::u8_as_u32(ctx, v470);
                                        let v472 = RegMemImm::Imm {
                                            simm32: v471,
                                        };
                                        let v473 = &C::gpr_mem_imm_new(ctx, &v472);
                                        let v474 = constructor_x64_and(ctx, I64, v84, v473);
                                        let v475 = constructor_put_in_xmm(ctx, v59.0);
                                        let v476 = &C::gpr_to_gpr_mem(ctx, v474);
                                        let v477 = constructor_x64_movd_to_xmm(ctx, v476);
                                        let v478 = &C::xmm_to_xmm_mem(ctx, v477);
                                        let v479 = constructor_x64_vpsraq(ctx, v475, v478);
                                        let v480 = constructor_output_xmm(ctx, v479);
                                        let v481 = Some(v480);
                                        // Rule at src/isa/x64/lower.isle line 853.
                                        return v481;
                                    }
                                }
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v120 = C::def_inst(ctx, v59.1);
                                if let Some(v121) = v120 {
                                    let v122 = &C::inst_data(ctx, v121);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v461,
                                        imm: v462,
                                    } = v122 {
                                        if let &Opcode::Iconst = v461 {
                                            let v482 = C::u64_from_imm64(ctx, v462);
                                            let v483 = C::u64_as_u32(ctx, v482);
                                            if let Some(v484) = v483 {
                                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                                let v486 = C::u32_and(ctx, v484, 0x3f_u32);
                                                let v487 = constructor_lower_i64x2_sshr_imm(ctx, v93, v486);
                                                let v488 = constructor_output_xmm(ctx, v487);
                                                let v489 = Some(v488);
                                                // Rule at src/isa/x64/lower.isle line 859.
                                                return v489;
                                            }
                                        }
                                    }
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v490 = constructor_put_in_gpr(ctx, v59.1);
                                let v491 = RegMemImm::Imm {
                                    simm32: 0x3f_u32,
                                };
                                let v492 = &C::gpr_mem_imm_new(ctx, &v491);
                                let v493 = constructor_x64_and(ctx, I64, v490, v492);
                                let v494 = constructor_lower_i64x2_sshr_gpr(ctx, v93, v493);
                                let v495 = constructor_output_xmm(ctx, v494);
                                let v496 = Some(v495);
                                // Rule at src/isa/x64/lower.isle line 862.
                                return v496;
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v59 = C::unpack_value_array_2(ctx, v58);
                            let v437 = constructor_extend_to_gpr(ctx, v59.0, v5, &ExtendKind::Sign);
                            let v381 = &constructor_put_masked_in_imm8_gpr(ctx, v59.1, v5);
                            let v438 = constructor_x64_sar(ctx, v5, v437, v381);
                            let v439 = constructor_output_gpr(ctx, v438);
                            let v440 = Some(v439);
                            // Rule at src/isa/x64/lower.isle line 752.
                            return v440;
                        }
                    }
                }
                &Opcode::Fadd => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1742 = constructor_x64_addss(ctx, v1725, v1741);
                                    let v1743 = constructor_output_xmm(ctx, v1742);
                                    let v1744 = Some(v1743);
                                    // Rule at src/isa/x64/lower.isle line 2597.
                                    return v1744;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1729 = constructor_x64_addss(ctx, v93, v94);
                                let v1730 = constructor_output_xmm(ctx, v1729);
                                let v1731 = Some(v1730);
                                // Rule at src/isa/x64/lower.isle line 2586.
                                return v1731;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1745 = constructor_x64_addsd(ctx, v1725, v1741);
                                    let v1746 = constructor_output_xmm(ctx, v1745);
                                    let v1747 = Some(v1746);
                                    // Rule at src/isa/x64/lower.isle line 2599.
                                    return v1747;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1732 = constructor_x64_addsd(ctx, v93, v94);
                                let v1733 = constructor_output_xmm(ctx, v1732);
                                let v1734 = Some(v1733);
                                // Rule at src/isa/x64/lower.isle line 2588.
                                return v1734;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1748 = constructor_x64_addps(ctx, v1725, v1741);
                                    let v1749 = constructor_output_xmm(ctx, v1748);
                                    let v1750 = Some(v1749);
                                    // Rule at src/isa/x64/lower.isle line 2601.
                                    return v1750;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1735 = constructor_x64_addps(ctx, v93, v94);
                                let v1736 = constructor_output_xmm(ctx, v1735);
                                let v1737 = Some(v1736);
                                // Rule at src/isa/x64/lower.isle line 2590.
                                return v1737;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1751 = constructor_x64_addpd(ctx, v1725, v1741);
                                    let v1752 = constructor_output_xmm(ctx, v1751);
                                    let v1753 = Some(v1752);
                                    // Rule at src/isa/x64/lower.isle line 2603.
                                    return v1753;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1738 = constructor_x64_addpd(ctx, v93, v94);
                                let v1739 = constructor_output_xmm(ctx, v1738);
                                let v1740 = Some(v1739);
                                // Rule at src/isa/x64/lower.isle line 2592.
                                return v1740;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fsub => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1754 = constructor_x64_subss(ctx, v93, v94);
                                let v1755 = constructor_output_xmm(ctx, v1754);
                                let v1756 = Some(v1755);
                                // Rule at src/isa/x64/lower.isle line 2608.
                                return v1756;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1757 = constructor_x64_subsd(ctx, v93, v94);
                                let v1758 = constructor_output_xmm(ctx, v1757);
                                let v1759 = Some(v1758);
                                // Rule at src/isa/x64/lower.isle line 2610.
                                return v1759;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1760 = constructor_x64_subps(ctx, v93, v94);
                                let v1761 = constructor_output_xmm(ctx, v1760);
                                let v1762 = Some(v1761);
                                // Rule at src/isa/x64/lower.isle line 2612.
                                return v1762;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1763 = constructor_x64_subpd(ctx, v93, v94);
                                let v1764 = constructor_output_xmm(ctx, v1763);
                                let v1765 = Some(v1764);
                                // Rule at src/isa/x64/lower.isle line 2614.
                                return v1765;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmul => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1778 = constructor_x64_mulss(ctx, v1725, v1741);
                                    let v1779 = constructor_output_xmm(ctx, v1778);
                                    let v1780 = Some(v1779);
                                    // Rule at src/isa/x64/lower.isle line 2630.
                                    return v1780;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1766 = constructor_x64_mulss(ctx, v93, v94);
                                let v1767 = constructor_output_xmm(ctx, v1766);
                                let v1768 = Some(v1767);
                                // Rule at src/isa/x64/lower.isle line 2619.
                                return v1768;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1781 = constructor_x64_mulsd(ctx, v1725, v1741);
                                    let v1782 = constructor_output_xmm(ctx, v1781);
                                    let v1783 = Some(v1782);
                                    // Rule at src/isa/x64/lower.isle line 2632.
                                    return v1783;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1769 = constructor_x64_mulsd(ctx, v93, v94);
                                let v1770 = constructor_output_xmm(ctx, v1769);
                                let v1771 = Some(v1770);
                                // Rule at src/isa/x64/lower.isle line 2621.
                                return v1771;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1784 = constructor_x64_mulps(ctx, v1725, v1741);
                                    let v1785 = constructor_output_xmm(ctx, v1784);
                                    let v1786 = Some(v1785);
                                    // Rule at src/isa/x64/lower.isle line 2634.
                                    return v1786;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1772 = constructor_x64_mulps(ctx, v93, v94);
                                let v1773 = constructor_output_xmm(ctx, v1772);
                                let v1774 = Some(v1773);
                                // Rule at src/isa/x64/lower.isle line 2623.
                                return v1774;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v82 = &C::sinkable_load(ctx, v59.0);
                                if let Some(v83) = v82 {
                                    let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                    let v1741 = &constructor_sink_load_to_xmm_mem(ctx, v83);
                                    let v1787 = constructor_x64_mulpd(ctx, v1725, v1741);
                                    let v1788 = constructor_output_xmm(ctx, v1787);
                                    let v1789 = Some(v1788);
                                    // Rule at src/isa/x64/lower.isle line 2636.
                                    return v1789;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1775 = constructor_x64_mulpd(ctx, v93, v94);
                                let v1776 = constructor_output_xmm(ctx, v1775);
                                let v1777 = Some(v1776);
                                // Rule at src/isa/x64/lower.isle line 2625.
                                return v1777;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fdiv => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1790 = constructor_x64_divss(ctx, v93, v94);
                                let v1791 = constructor_output_xmm(ctx, v1790);
                                let v1792 = Some(v1791);
                                // Rule at src/isa/x64/lower.isle line 2641.
                                return v1792;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1793 = constructor_x64_divsd(ctx, v93, v94);
                                let v1794 = constructor_output_xmm(ctx, v1793);
                                let v1795 = Some(v1794);
                                // Rule at src/isa/x64/lower.isle line 2643.
                                return v1795;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1796 = constructor_x64_divps(ctx, v93, v94);
                                let v1797 = constructor_output_xmm(ctx, v1796);
                                let v1798 = Some(v1797);
                                // Rule at src/isa/x64/lower.isle line 2645.
                                return v1798;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                let v1799 = constructor_x64_divpd(ctx, v93, v94);
                                let v1800 = constructor_output_xmm(ctx, v1799);
                                let v1801 = Some(v1800);
                                // Rule at src/isa/x64/lower.isle line 2647.
                                return v1801;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fcopysign => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == F32 {
                                    let v2870 = constructor_imm(ctx, F32, 0x80000000_u64);
                                    let v2871 = C::xmm_new(ctx, v2870);
                                    let v2872 = &C::put_in_xmm_mem(ctx, v59.0);
                                    let v2873 = constructor_x64_andnps(ctx, v2871, v2872);
                                    let v2874 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2875 = constructor_x64_andps(ctx, v2871, v2874);
                                    let v2876 = &C::xmm_to_xmm_mem(ctx, v2875);
                                    let v2877 = constructor_x64_orps(ctx, v2873, v2876);
                                    let v2878 = constructor_output_xmm(ctx, v2877);
                                    let v2879 = Some(v2878);
                                    // Rule at src/isa/x64/lower.isle line 4194.
                                    return v2879;
                                }
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == F64 {
                                    let v2880 = constructor_imm(ctx, F64, 0x8000000000000000_u64);
                                    let v2881 = C::xmm_new(ctx, v2880);
                                    let v2872 = &C::put_in_xmm_mem(ctx, v59.0);
                                    let v2882 = constructor_x64_andnpd(ctx, v2881, v2872);
                                    let v2874 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2883 = constructor_x64_andpd(ctx, v2881, v2874);
                                    let v2884 = &C::xmm_to_xmm_mem(ctx, v2883);
                                    let v2885 = constructor_x64_orpd(ctx, v2882, v2884);
                                    let v2886 = constructor_output_xmm(ctx, v2885);
                                    let v2887 = Some(v2886);
                                    // Rule at src/isa/x64/lower.isle line 4200.
                                    return v2887;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmin => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v182 = true;
                                let v1832 = constructor_xmm_min_max_seq(ctx, F32, v182, v93, v629);
                                let v1833 = constructor_output_xmm(ctx, v1832);
                                let v1834 = Some(v1833);
                                // Rule at src/isa/x64/lower.isle line 2678.
                                return v1834;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v182 = true;
                                let v1835 = constructor_xmm_min_max_seq(ctx, F64, v182, v93, v629);
                                let v1836 = constructor_output_xmm(ctx, v1835);
                                let v1837 = Some(v1836);
                                // Rule at src/isa/x64/lower.isle line 2680.
                                return v1837;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v1839 = constructor_x64_minps(ctx, v93, v1838);
                                let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v1840 = constructor_x64_minps(ctx, v629, v446);
                                let v1841 = &C::xmm_to_xmm_mem(ctx, v1840);
                                let v1842 = constructor_x64_orps(ctx, v1839, v1841);
                                let v1843 = &C::xmm_to_xmm_mem(ctx, v1840);
                                let v1844 = constructor_x64_cmpps(ctx, v1842, v1843, &FcmpImm::Unordered);
                                let v1845 = &C::xmm_to_xmm_mem(ctx, v1844);
                                let v1846 = constructor_x64_orps(ctx, v1842, v1845);
                                let v1848 = &C::xmi_imm(ctx, 0xa_u32);
                                let v1849 = constructor_x64_psrld(ctx, v1844, v1848);
                                let v1850 = &C::xmm_to_xmm_mem(ctx, v1846);
                                let v1851 = constructor_x64_andnps(ctx, v1849, v1850);
                                let v1852 = constructor_output_xmm(ctx, v1851);
                                let v1853 = Some(v1852);
                                // Rule at src/isa/x64/lower.isle line 2695.
                                return v1853;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v1854 = constructor_x64_minpd(ctx, v93, v1838);
                                let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v1855 = constructor_x64_minpd(ctx, v629, v446);
                                let v1856 = &C::xmm_to_xmm_mem(ctx, v1855);
                                let v1857 = constructor_x64_orpd(ctx, v1854, v1856);
                                let v1858 = &C::xmm_to_xmm_mem(ctx, v1855);
                                let v1859 = constructor_x64_cmppd(ctx, v1854, v1858, &FcmpImm::Unordered);
                                let v1860 = &C::xmm_to_xmm_mem(ctx, v1859);
                                let v1861 = constructor_x64_orpd(ctx, v1857, v1860);
                                let v1863 = &C::xmi_imm(ctx, 0xd_u32);
                                let v1864 = constructor_x64_psrlq(ctx, v1859, v1863);
                                let v1865 = &C::xmm_to_xmm_mem(ctx, v1861);
                                let v1866 = constructor_x64_andnpd(ctx, v1864, v1865);
                                let v1867 = constructor_output_xmm(ctx, v1866);
                                let v1868 = Some(v1867);
                                // Rule at src/isa/x64/lower.isle line 2740.
                                return v1868;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fmax => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v172 = false;
                                let v1869 = constructor_xmm_min_max_seq(ctx, F32, v172, v93, v629);
                                let v1870 = constructor_output_xmm(ctx, v1869);
                                let v1871 = Some(v1870);
                                // Rule at src/isa/x64/lower.isle line 2754.
                                return v1871;
                            }
                            F64 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v172 = false;
                                let v1872 = constructor_xmm_min_max_seq(ctx, F64, v172, v93, v629);
                                let v1873 = constructor_output_xmm(ctx, v1872);
                                let v1874 = Some(v1873);
                                // Rule at src/isa/x64/lower.isle line 2756.
                                return v1874;
                            }
                            F32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v1875 = constructor_x64_maxps(ctx, v93, v1838);
                                let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v1876 = constructor_x64_maxps(ctx, v629, v446);
                                let v1877 = &C::xmm_to_xmm_mem(ctx, v1876);
                                let v1878 = constructor_x64_xorps(ctx, v1875, v1877);
                                let v1879 = &C::xmm_to_xmm_mem(ctx, v1878);
                                let v1880 = constructor_x64_orps(ctx, v1875, v1879);
                                let v1881 = &C::xmm_to_xmm_mem(ctx, v1878);
                                let v1882 = constructor_x64_subps(ctx, v1880, v1881);
                                let v1883 = &C::xmm_to_xmm_mem(ctx, v1880);
                                let v1884 = constructor_x64_cmpps(ctx, v1880, v1883, &FcmpImm::Unordered);
                                let v1885 = &C::xmi_imm(ctx, 0xa_u32);
                                let v1886 = constructor_x64_psrld(ctx, v1884, v1885);
                                let v1887 = &C::xmm_to_xmm_mem(ctx, v1882);
                                let v1888 = constructor_x64_andnps(ctx, v1886, v1887);
                                let v1889 = constructor_output_xmm(ctx, v1888);
                                let v1890 = Some(v1889);
                                // Rule at src/isa/x64/lower.isle line 2762.
                                return v1890;
                            }
                            F64X2 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v1891 = constructor_x64_maxpd(ctx, v93, v1838);
                                let v446 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v1892 = constructor_x64_maxpd(ctx, v629, v446);
                                let v1893 = &C::xmm_to_xmm_mem(ctx, v1892);
                                let v1894 = constructor_x64_xorpd(ctx, v1891, v1893);
                                let v1895 = &C::xmm_to_xmm_mem(ctx, v1894);
                                let v1896 = constructor_x64_orpd(ctx, v1891, v1895);
                                let v1897 = &C::xmm_to_xmm_mem(ctx, v1894);
                                let v1898 = constructor_x64_subpd(ctx, v1896, v1897);
                                let v1899 = &C::xmm_to_xmm_mem(ctx, v1896);
                                let v1900 = constructor_x64_cmppd(ctx, v1896, v1899, &FcmpImm::Unordered);
                                let v1901 = &C::xmi_imm(ctx, 0xd_u32);
                                let v1902 = constructor_x64_psrlq(ctx, v1900, v1901);
                                let v1903 = &C::xmm_to_xmm_mem(ctx, v1898);
                                let v1904 = constructor_x64_andnpd(ctx, v1902, v1903);
                                let v1905 = constructor_output_xmm(ctx, v1904);
                                let v1906 = Some(v1905);
                                // Rule at src/isa/x64/lower.isle line 2807.
                                return v1906;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Snarrow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == I16X8 {
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2807 = constructor_x64_packsswb(ctx, v93, v94);
                                    let v2808 = constructor_output_xmm(ctx, v2807);
                                    let v2809 = Some(v2808);
                                    // Rule at src/isa/x64/lower.isle line 4078.
                                    return v2809;
                                }
                            }
                            I16X8 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == I32X4 {
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2810 = constructor_x64_packssdw(ctx, v93, v94);
                                    let v2811 = constructor_output_xmm(ctx, v2810);
                                    let v2812 = Some(v2811);
                                    // Rule at src/isa/x64/lower.isle line 4081.
                                    return v2812;
                                }
                            }
                            I32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v120 = C::def_inst(ctx, v59.1);
                                if let Some(v121) = v120 {
                                    let v122 = &C::inst_data(ctx, v121);
                                    if let &InstructionData::UnaryConst {
                                        opcode: ref v2816,
                                        constant_handle: v2817,
                                    } = v122 {
                                        if let &Opcode::Vconst = v2816 {
                                            let v266 = C::def_inst(ctx, v59.0);
                                            if let Some(v267) = v266 {
                                                let v268 = &C::inst_data(ctx, v267);
                                                if let &InstructionData::Unary {
                                                    opcode: ref v269,
                                                    arg: v270,
                                                } = v268 {
                                                    match v269 {
                                                        &Opcode::FcvtToSintSat => {
                                                            let v2813 = C::first_result(ctx, v267);
                                                            if let Some(v2814) = v2813 {
                                                                let v2815 = C::value_type(ctx, v2814);
                                                                if v2815 == I64X2 {
                                                                    let v2818 = C::u128_from_constant(ctx, v2817);
                                                                    if let Some(v2819) = v2818 {
                                                                        if v2819 == 0x0_u128 {
                                                                            let v271 = constructor_put_in_xmm(ctx, v270);
                                                                            let v2820 = &C::xmm_to_xmm_mem(ctx, v271);
                                                                            let v2821 = constructor_x64_cmppd(ctx, v271, v2820, &FcmpImm::Equal);
                                                                            let v2823 = C::emit_u128_le_const(ctx, 0x41dfffffffc0000041dfffffffc00000_u128);
                                                                            let v2824 = &constructor_const_to_xmm_mem(ctx, v2823);
                                                                            let v2825 = constructor_x64_andps(ctx, v2821, v2824);
                                                                            let v2826 = &C::xmm_to_xmm_mem(ctx, v2825);
                                                                            let v2827 = constructor_x64_minpd(ctx, v271, v2826);
                                                                            let v2828 = &C::xmm_to_xmm_mem(ctx, v2827);
                                                                            let v2829 = constructor_x64_cvttpd2dq(ctx, v2828);
                                                                            let v2830 = constructor_output_xmm(ctx, v2829);
                                                                            let v2831 = Some(v2830);
                                                                            // Rule at src/isa/x64/lower.isle line 4090.
                                                                            return v2831;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        &Opcode::X86Cvtt2dq => {
                                                            let v2813 = C::first_result(ctx, v267);
                                                            if let Some(v2814) = v2813 {
                                                                let v2815 = C::value_type(ctx, v2814);
                                                                if v2815 == I64X2 {
                                                                    let v2818 = C::u128_from_constant(ctx, v2817);
                                                                    if let Some(v2819) = v2818 {
                                                                        if v2819 == 0x0_u128 {
                                                                            let v686 = &C::put_in_xmm_mem(ctx, v270);
                                                                            let v2832 = constructor_x64_cvttpd2dq(ctx, v686);
                                                                            let v2833 = constructor_output_xmm(ctx, v2832);
                                                                            let v2834 = Some(v2833);
                                                                            // Rule at src/isa/x64/lower.isle line 4114.
                                                                            return v2834;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        _ => {}
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Unarrow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == I16X8 {
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2835 = constructor_x64_packuswb(ctx, v93, v94);
                                    let v2836 = constructor_output_xmm(ctx, v2835);
                                    let v2837 = Some(v2836);
                                    // Rule at src/isa/x64/lower.isle line 4120.
                                    return v2837;
                                }
                            }
                            I16X8 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2806 = C::value_type(ctx, v59.0);
                                if v2806 == I32X4 {
                                    let v625 = C::use_sse41(ctx);
                                    if v625 == true {
                                        let v93 = constructor_put_in_xmm(ctx, v59.0);
                                        let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                        let v2838 = constructor_x64_packusdw(ctx, v93, v94);
                                        let v2839 = constructor_output_xmm(ctx, v2838);
                                        let v2840 = Some(v2839);
                                        // Rule at src/isa/x64/lower.isle line 4123.
                                        return v2840;
                                    }
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v2841 = constructor_unarrow_i32x4_lanes_to_low_u16_lanes(ctx, v93);
                                    let v2842 = constructor_put_in_xmm(ctx, v59.1);
                                    let v2843 = constructor_unarrow_i32x4_lanes_to_low_u16_lanes(ctx, v2842);
                                    let v2844 = &C::xmm_to_xmm_mem(ctx, v2843);
                                    let v2845 = constructor_x64_punpcklqdq(ctx, v2841, v2844);
                                    let v2846 = constructor_output_xmm(ctx, v2845);
                                    let v2847 = Some(v2846);
                                    // Rule at src/isa/x64/lower.isle line 4133.
                                    return v2847;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Uunarrow => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v120 = C::def_inst(ctx, v59.1);
                    if let Some(v121) = v120 {
                        let v122 = &C::inst_data(ctx, v121);
                        if let &InstructionData::UnaryConst {
                            opcode: ref v2816,
                            constant_handle: v2817,
                        } = v122 {
                            if let &Opcode::Vconst = v2816 {
                                let v266 = C::def_inst(ctx, v59.0);
                                if let Some(v267) = v266 {
                                    let v268 = &C::inst_data(ctx, v267);
                                    if let &InstructionData::Unary {
                                        opcode: ref v269,
                                        arg: v270,
                                    } = v268 {
                                        if let &Opcode::FcvtToUintSat = v269 {
                                            let v615 = C::value_type(ctx, v270);
                                            if v615 == F64X2 {
                                                let v2818 = C::u128_from_constant(ctx, v2817);
                                                if let Some(v2819) = v2818 {
                                                    if v2819 == 0x0_u128 {
                                                        let v271 = constructor_put_in_xmm(ctx, v270);
                                                        let v2473 = constructor_xmm_zero(ctx, F64X2);
                                                        let v3395 = &C::xmm_to_xmm_mem(ctx, v2473);
                                                        let v3396 = constructor_x64_maxpd(ctx, v271, v3395);
                                                        let v3398 = C::emit_u128_le_const(ctx, 0x41efffffffe0000041efffffffe00000_u128);
                                                        let v3399 = &constructor_const_to_xmm_mem(ctx, v3398);
                                                        let v3400 = constructor_x64_minpd(ctx, v3396, v3399);
                                                        let v3401 = C::xmm_to_reg(ctx, v3400);
                                                        let v3402 = &constructor_xmm_to_reg_mem(ctx, v3401);
                                                        let v3403 = &C::xmm_mem_to_reg_mem(ctx, v3402);
                                                        let v3404 = constructor_x64_round(ctx, F64X2, v3403, &RoundImm::RoundZero);
                                                        let v3405 = C::emit_u128_le_const(ctx, 0x43300000000000004330000000000000_u128);
                                                        let v3406 = &constructor_const_to_xmm_mem(ctx, v3405);
                                                        let v3407 = constructor_x64_addpd(ctx, v3404, v3406);
                                                        let v3408 = &C::xmm_to_xmm_mem(ctx, v2473);
                                                        let v3409 = constructor_x64_shufps(ctx, v3407, v3408, 0x88_u8);
                                                        let v3410 = constructor_output_xmm(ctx, v3409);
                                                        let v3411 = Some(v3410);
                                                        // Rule at src/isa/x64/lower.isle line 4970.
                                                        return v3411;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                &Opcode::IaddPairwise => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v2623 = C::emit_u128_le_const(ctx, 0xff00ff00ff00ff00ff00ff00ff00ff_u128);
                                let v2624 = &constructor_const_to_xmm_mem(ctx, v2623);
                                let v2625 = constructor_x64_movdqu_load(ctx, v2624);
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v2626 = constructor_put_in_xmm(ctx, v59.0);
                                let v2627 = &C::xmm_to_xmm_mem(ctx, v2625);
                                let v2628 = constructor_x64_pand(ctx, v2626, v2627);
                                let v2629 = constructor_put_in_xmm(ctx, v59.1);
                                let v2630 = &C::xmm_to_xmm_mem(ctx, v2625);
                                let v2631 = constructor_x64_pand(ctx, v2629, v2630);
                                let v2632 = &C::xmm_to_xmm_mem(ctx, v2631);
                                let v2633 = constructor_x64_packuswb(ctx, v2628, v2632);
                                let v2634 = constructor_put_in_xmm(ctx, v59.0);
                                let v2636 = &C::xmi_imm(ctx, 0x8_u32);
                                let v2637 = constructor_x64_psrlw(ctx, v2634, v2636);
                                let v2638 = constructor_put_in_xmm(ctx, v59.1);
                                let v2639 = &C::xmi_imm(ctx, 0x8_u32);
                                let v2640 = constructor_x64_psrlw(ctx, v2638, v2639);
                                let v2641 = &C::xmm_to_xmm_mem(ctx, v2640);
                                let v2642 = constructor_x64_packuswb(ctx, v2637, v2641);
                                let v2643 = &C::xmm_to_xmm_mem(ctx, v2642);
                                let v2644 = constructor_x64_paddb(ctx, v2633, v2643);
                                let v2645 = constructor_output_xmm(ctx, v2644);
                                let v2646 = Some(v2645);
                                // Rule at src/isa/x64/lower.isle line 3867.
                                return v2646;
                            }
                            I16X8 => {
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v59 = C::unpack_value_array_2(ctx, v58);
                                    let v120 = C::def_inst(ctx, v59.1);
                                    if let Some(v121) = v120 {
                                        let v122 = &C::inst_data(ctx, v121);
                                        if let &InstructionData::Unary {
                                            opcode: ref v137,
                                            arg: v138,
                                        } = v122 {
                                            match v137 {
                                                &Opcode::SwidenHigh => {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::SwidenLow = v269 {
                                                                if v138 == v270 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    if v615 == I8X16 {
                                                                        let v2686 = C::emit_u128_le_const(ctx, 0x1010101010101010101010101010101_u128);
                                                                        let v2687 = constructor_x64_xmm_load_const(ctx, I8X16, v2686);
                                                                        let v2688 = &C::put_in_xmm_mem(ctx, v270);
                                                                        let v2689 = constructor_x64_pmaddubsw(ctx, v2687, v2688);
                                                                        let v2690 = constructor_output_xmm(ctx, v2689);
                                                                        let v2691 = Some(v2690);
                                                                        // Rule at src/isa/x64/lower.isle line 3929.
                                                                        return v2691;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                &Opcode::UwidenHigh => {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::UwidenLow = v269 {
                                                                if v138 == v270 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    if v615 == I8X16 {
                                                                        let v2686 = C::emit_u128_le_const(ctx, 0x1010101010101010101010101010101_u128);
                                                                        let v2699 = &constructor_const_to_xmm_mem(ctx, v2686);
                                                                        let v2695 = constructor_put_in_xmm(ctx, v270);
                                                                        let v2700 = constructor_x64_pmaddubsw(ctx, v2695, v2699);
                                                                        let v2701 = constructor_output_xmm(ctx, v2700);
                                                                        let v2702 = Some(v2701);
                                                                        // Rule at src/isa/x64/lower.isle line 3947.
                                                                        return v2702;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                _ => {}
                                            }
                                        }
                                    }
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2647 = constructor_x64_phaddw(ctx, v93, v94);
                                    let v2648 = constructor_output_xmm(ctx, v2647);
                                    let v2649 = Some(v2648);
                                    // Rule at src/isa/x64/lower.isle line 3883.
                                    return v2649;
                                }
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v444 = &C::xmm_to_xmm_mem(ctx, v93);
                                let v2651 = constructor_x64_pshuflw(ctx, v444, 0xe8_u8);
                                let v2652 = &C::xmm_to_xmm_mem(ctx, v2651);
                                let v2653 = constructor_x64_pshufhw(ctx, v2652, 0xe8_u8);
                                let v2654 = &C::xmm_to_xmm_mem(ctx, v2653);
                                let v2655 = constructor_x64_pshufd(ctx, v2654, 0xe8_u8);
                                let v2656 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v2657 = constructor_x64_pshuflw(ctx, v2656, 0xe8_u8);
                                let v2658 = &C::xmm_to_xmm_mem(ctx, v2657);
                                let v2659 = constructor_x64_pshufhw(ctx, v2658, 0xe8_u8);
                                let v2660 = &C::xmm_to_xmm_mem(ctx, v2659);
                                let v2661 = constructor_x64_pshufd(ctx, v2660, 0xe8_u8);
                                let v2662 = &C::xmm_to_xmm_mem(ctx, v2661);
                                let v2663 = constructor_x64_punpcklqdq(ctx, v2655, v2662);
                                let v2664 = &C::xmi_imm(ctx, 0x10_u32);
                                let v2665 = constructor_x64_psrad(ctx, v93, v2664);
                                let v2666 = &C::xmi_imm(ctx, 0x10_u32);
                                let v2667 = constructor_x64_psrad(ctx, v629, v2666);
                                let v2668 = &C::xmm_to_xmm_mem(ctx, v2667);
                                let v2669 = constructor_x64_packssdw(ctx, v2665, v2668);
                                let v2670 = &C::xmm_to_xmm_mem(ctx, v2669);
                                let v2671 = constructor_x64_paddw(ctx, v2663, v2670);
                                let v2672 = constructor_output_xmm(ctx, v2671);
                                let v2673 = Some(v2672);
                                // Rule at src/isa/x64/lower.isle line 3887.
                                return v2673;
                            }
                            I32X4 => {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v120 = C::def_inst(ctx, v59.1);
                                if let Some(v121) = v120 {
                                    let v122 = &C::inst_data(ctx, v121);
                                    match v122 {
                                        &InstructionData::Binary {
                                            opcode: ref v123,
                                            args: ref v124,
                                        } => {
                                            if let &Opcode::Imul = v123 {
                                                let v266 = C::def_inst(ctx, v59.0);
                                                if let Some(v267) = v266 {
                                                    let v268 = &C::inst_data(ctx, v267);
                                                    if let &InstructionData::Binary {
                                                        opcode: ref v603,
                                                        args: ref v604,
                                                    } = v268 {
                                                        if let &Opcode::Imul = v603 {
                                                            let v605 = C::unpack_value_array_2(ctx, v604);
                                                            let v2716 = C::def_inst(ctx, v605.0);
                                                            if let Some(v2717) = v2716 {
                                                                let v2718 = &C::inst_data(ctx, v2717);
                                                                if let &InstructionData::Unary {
                                                                    opcode: ref v2719,
                                                                    arg: v2720,
                                                                } = v2718 {
                                                                    if let &Opcode::SwidenLow = v2719 {
                                                                        let v2721 = C::def_inst(ctx, v605.1);
                                                                        if let Some(v2722) = v2721 {
                                                                            let v2723 = &C::inst_data(ctx, v2722);
                                                                            if let &InstructionData::Unary {
                                                                                opcode: ref v2724,
                                                                                arg: v2725,
                                                                            } = v2723 {
                                                                                if let &Opcode::SwidenLow = v2724 {
                                                                                    let v125 = C::unpack_value_array_2(ctx, v124);
                                                                                    let v2726 = C::def_inst(ctx, v125.0);
                                                                                    if let Some(v2727) = v2726 {
                                                                                        let v2728 = &C::inst_data(ctx, v2727);
                                                                                        if let &InstructionData::Unary {
                                                                                            opcode: ref v2729,
                                                                                            arg: v2730,
                                                                                        } = v2728 {
                                                                                            if let &Opcode::SwidenHigh = v2729 {
                                                                                                if v2720 == v2730 {
                                                                                                    let v2731 = C::def_inst(ctx, v125.1);
                                                                                                    if let Some(v2732) = v2731 {
                                                                                                        let v2733 = &C::inst_data(ctx, v2732);
                                                                                                        if let &InstructionData::Unary {
                                                                                                            opcode: ref v2734,
                                                                                                            arg: v2735,
                                                                                                        } = v2733 {
                                                                                                            if let &Opcode::SwidenHigh = v2734 {
                                                                                                                if v2725 == v2735 {
                                                                                                                    let v2736 = constructor_put_in_xmm(ctx, v2720);
                                                                                                                    let v2737 = &C::put_in_xmm_mem(ctx, v2725);
                                                                                                                    let v2738 = constructor_x64_pmaddwd(ctx, v2736, v2737);
                                                                                                                    let v2739 = constructor_output_xmm(ctx, v2738);
                                                                                                                    let v2740 = Some(v2739);
                                                                                                                    // Rule at src/isa/x64/lower.isle line 3970.
                                                                                                                    return v2740;
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &InstructionData::Unary {
                                            opcode: ref v137,
                                            arg: v138,
                                        } => {
                                            match v137 {
                                                &Opcode::SwidenHigh => {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::SwidenLow = v269 {
                                                                if v138 == v270 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    if v615 == I16X8 {
                                                                        let v2693 = C::emit_u128_le_const(ctx, 0x10001000100010001000100010001_u128);
                                                                        let v2694 = &constructor_const_to_xmm_mem(ctx, v2693);
                                                                        let v2695 = constructor_put_in_xmm(ctx, v270);
                                                                        let v2696 = constructor_x64_pmaddwd(ctx, v2695, v2694);
                                                                        let v2697 = constructor_output_xmm(ctx, v2696);
                                                                        let v2698 = Some(v2697);
                                                                        // Rule at src/isa/x64/lower.isle line 3939.
                                                                        return v2698;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                &Opcode::UwidenHigh => {
                                                    let v266 = C::def_inst(ctx, v59.0);
                                                    if let Some(v267) = v266 {
                                                        let v268 = &C::inst_data(ctx, v267);
                                                        if let &InstructionData::Unary {
                                                            opcode: ref v269,
                                                            arg: v270,
                                                        } = v268 {
                                                            if let &Opcode::UwidenLow = v269 {
                                                                if v138 == v270 {
                                                                    let v615 = C::value_type(ctx, v270);
                                                                    if v615 == I16X8 {
                                                                        let v2704 = C::emit_u128_le_const(ctx, 0x80008000800080008000800080008000_u128);
                                                                        let v2705 = &constructor_const_to_xmm_mem(ctx, v2704);
                                                                        let v2695 = constructor_put_in_xmm(ctx, v270);
                                                                        let v2706 = constructor_x64_pxor(ctx, v2695, v2705);
                                                                        let v2707 = C::emit_u128_le_const(ctx, 0x10001000100010001000100010001_u128);
                                                                        let v2708 = &constructor_const_to_xmm_mem(ctx, v2707);
                                                                        let v2709 = constructor_x64_pmaddwd(ctx, v2706, v2708);
                                                                        let v2711 = C::emit_u128_le_const(ctx, 0x10000000100000001000000010000_u128);
                                                                        let v2712 = &constructor_const_to_xmm_mem(ctx, v2711);
                                                                        let v2713 = constructor_x64_paddd(ctx, v2709, v2712);
                                                                        let v2714 = constructor_output_xmm(ctx, v2713);
                                                                        let v2715 = Some(v2714);
                                                                        // Rule at src/isa/x64/lower.isle line 3956.
                                                                        return v2715;
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                _ => {}
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v93 = constructor_put_in_xmm(ctx, v59.0);
                                    let v94 = &C::put_in_xmm_mem(ctx, v59.1);
                                    let v2674 = constructor_x64_phaddd(ctx, v93, v94);
                                    let v2675 = constructor_output_xmm(ctx, v2674);
                                    let v2676 = Some(v2675);
                                    // Rule at src/isa/x64/lower.isle line 3913.
                                    return v2676;
                                }
                                let v93 = constructor_put_in_xmm(ctx, v59.0);
                                let v629 = constructor_put_in_xmm(ctx, v59.1);
                                let v1838 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v2678 = constructor_x64_shufps(ctx, v93, v1838, 0x88_u8);
                                let v632 = &C::xmm_to_xmm_mem(ctx, v629);
                                let v2680 = constructor_x64_shufps(ctx, v93, v632, 0xdd_u8);
                                let v2681 = &C::xmm_to_xmm_mem(ctx, v2680);
                                let v2682 = constructor_x64_paddd(ctx, v2678, v2681);
                                let v2683 = constructor_output_xmm(ctx, v2682);
                                let v2684 = Some(v2683);
                                // Rule at src/isa/x64/lower.isle line 3917.
                                return v2684;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::X86Pmaddubsw => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v719 = C::use_ssse3(ctx);
                            if v719 == true {
                                let v59 = C::unpack_value_array_2(ctx, v58);
                                let v1725 = constructor_put_in_xmm(ctx, v59.1);
                                let v262 = &C::put_in_xmm_mem(ctx, v59.0);
                                let v1726 = constructor_x64_pmaddubsw(ctx, v1725, v262);
                                let v1727 = constructor_output_xmm(ctx, v1726);
                                let v1728 = Some(v1727);
                                // Rule at src/isa/x64/lower.isle line 2580.
                                return v1728;
                            }
                        }
                    }
                }
                &Opcode::Iconcat => {
                    let v59 = C::unpack_value_array_2(ctx, v58);
                    let v2806 = C::value_type(ctx, v59.0);
                    if v2806 == I64 {
                        let v3340 = C::put_in_reg(ctx, v59.0);
                        let v3341 = C::put_in_reg(ctx, v59.1);
                        let v3342 = C::value_regs(ctx, v3340, v3341);
                        let v3343 = C::output(ctx, v3342);
                        let v3344 = Some(v3343);
                        // Rule at src/isa/x64/lower.isle line 4886.
                        return v3344;
                    }
                }
                _ => {}
            }
        }
        &InstructionData::BinaryImm8 {
            opcode: ref v3157,
            arg: v3158,
            imm: v3159,
        } => {
            if let &Opcode::Extractlane = v3157 {
                if v3159 == 0x0 {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v3160 = constructor_output_value(ctx, v3158);
                            let v3161 = Some(v3160);
                            // Rule at src/isa/x64/lower.isle line 4641.
                            return v3161;
                        }
                    }
                }
                let v3162 = C::value_type(ctx, v3158);
                match v3162 {
                    I8X16 => {
                        let v625 = C::use_sse41(ctx);
                        if v625 == true {
                            let v3171 = constructor_put_in_xmm(ctx, v3158);
                            let v3163 = C::u8_from_uimm8(ctx, v3159);
                            let v3172 = constructor_x64_pextrb(ctx, v3171, v3163);
                            let v3173 = constructor_output_gpr(ctx, v3172);
                            let v3174 = Some(v3173);
                            // Rule at src/isa/x64/lower.isle line 4656.
                            return v3174;
                        }
                        let v3163 = C::u8_from_uimm8(ctx, v3159);
                        let v3175 = C::u8_and(ctx, v3163, 0x1_u8);
                        match v3175 {
                            0x0_u8 => {
                                let v3171 = constructor_put_in_xmm(ctx, v3158);
                                let v3176 = C::u8_shr(ctx, v3163, 0x1_u8);
                                let v3177 = constructor_x64_pextrw(ctx, v3171, v3176);
                                let v3182 = constructor_output_gpr(ctx, v3177);
                                let v3183 = Some(v3182);
                                // Rule at src/isa/x64/lower.isle line 4667.
                                return v3183;
                            }
                            0x1_u8 => {
                                let v3171 = constructor_put_in_xmm(ctx, v3158);
                                let v3176 = C::u8_shr(ctx, v3163, 0x1_u8);
                                let v3177 = constructor_x64_pextrw(ctx, v3171, v3176);
                                let v1676 = Imm8Reg::Imm8 {
                                    imm: 0x8_u8,
                                };
                                let v3178 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                                let v3179 = constructor_x64_shr(ctx, I16, v3177, v3178);
                                let v3180 = constructor_output_gpr(ctx, v3179);
                                let v3181 = Some(v3180);
                                // Rule at src/isa/x64/lower.isle line 4660.
                                return v3181;
                            }
                            _ => {}
                        }
                    }
                    I16X8 => {
                        let v3171 = constructor_put_in_xmm(ctx, v3158);
                        let v3163 = C::u8_from_uimm8(ctx, v3159);
                        let v3184 = constructor_x64_pextrw(ctx, v3171, v3163);
                        let v3185 = constructor_output_gpr(ctx, v3184);
                        let v3186 = Some(v3185);
                        // Rule at src/isa/x64/lower.isle line 4672.
                        return v3186;
                    }
                    I32X4 => {
                        let v625 = C::use_sse41(ctx);
                        if v625 == true {
                            let v3171 = constructor_put_in_xmm(ctx, v3158);
                            let v3163 = C::u8_from_uimm8(ctx, v3159);
                            let v3187 = constructor_x64_pextrd(ctx, v3171, v3163);
                            let v3188 = constructor_output_gpr(ctx, v3187);
                            let v3189 = Some(v3188);
                            // Rule at src/isa/x64/lower.isle line 4676.
                            return v3189;
                        }
                        if v3159 == 0x0 {
                            let v3171 = constructor_put_in_xmm(ctx, v3158);
                            let v3190 = constructor_x64_movd_to_gpr(ctx, v3171);
                            let v3191 = constructor_output_gpr(ctx, v3190);
                            let v3192 = Some(v3191);
                            // Rule at src/isa/x64/lower.isle line 4679.
                            return v3192;
                        }
                        let v3164 = &C::put_in_xmm_mem(ctx, v3158);
                        let v3163 = C::u8_from_uimm8(ctx, v3159);
                        let v3165 = constructor_x64_pshufd(ctx, v3164, v3163);
                        let v3193 = constructor_x64_movd_to_gpr(ctx, v3165);
                        let v3194 = constructor_output_gpr(ctx, v3193);
                        let v3195 = Some(v3194);
                        // Rule at src/isa/x64/lower.isle line 4681.
                        return v3195;
                    }
                    I64X2 => {
                        let v625 = C::use_sse41(ctx);
                        if v625 == true {
                            let v3171 = constructor_put_in_xmm(ctx, v3158);
                            let v3163 = C::u8_from_uimm8(ctx, v3159);
                            let v3196 = constructor_x64_pextrq(ctx, v3171, v3163);
                            let v3197 = constructor_output_gpr(ctx, v3196);
                            let v3198 = Some(v3197);
                            // Rule at src/isa/x64/lower.isle line 4685.
                            return v3198;
                        }
                        match v3159 {
                            0x0 => {
                                let v3171 = constructor_put_in_xmm(ctx, v3158);
                                let v3199 = constructor_x64_movq_to_gpr(ctx, v3171);
                                let v3200 = constructor_output_gpr(ctx, v3199);
                                let v3201 = Some(v3200);
                                // Rule at src/isa/x64/lower.isle line 4688.
                                return v3201;
                            }
                            0x1 => {
                                let v3164 = &C::put_in_xmm_mem(ctx, v3158);
                                let v3202 = constructor_x64_pshufd(ctx, v3164, 0xe_u8);
                                let v3203 = constructor_x64_movq_to_gpr(ctx, v3202);
                                let v3204 = constructor_output_gpr(ctx, v3203);
                                let v3205 = Some(v3204);
                                // Rule at src/isa/x64/lower.isle line 4690.
                                return v3205;
                            }
                            _ => {}
                        }
                    }
                    F32X4 => {
                        let v3164 = &C::put_in_xmm_mem(ctx, v3158);
                        let v3163 = C::u8_from_uimm8(ctx, v3159);
                        let v3165 = constructor_x64_pshufd(ctx, v3164, v3163);
                        let v3166 = constructor_output_xmm(ctx, v3165);
                        let v3167 = Some(v3166);
                        // Rule at src/isa/x64/lower.isle line 4645.
                        return v3167;
                    }
                    F64X2 => {
                        if v3159 == 0x1 {
                            let v3164 = &C::put_in_xmm_mem(ctx, v3158);
                            let v3168 = constructor_x64_pshufd(ctx, v3164, 0xee_u8);
                            let v3169 = constructor_output_xmm(ctx, v3168);
                            let v3170 = Some(v3169);
                            // Rule at src/isa/x64/lower.isle line 4649.
                            return v3170;
                        }
                    }
                    _ => {}
                }
            }
        }
        &InstructionData::Call {
            opcode: ref v2399,
            args: v2400,
            func_ref: v2401,
        } => {
            match v2399 {
                &Opcode::Call => {
                    let v2403 = C::func_ref_data(ctx, v2401);
                    let v2402 = C::value_list_slice(ctx, v2400);
                    let v2407 = C::gen_call(ctx, v2403.0, v2403.1, v2403.2, v2402);
                    let v2408 = Some(v2407);
                    // Rule at src/isa/x64/lower.isle line 3448.
                    return v2408;
                }
                &Opcode::ReturnCall => {
                    let v2403 = C::func_ref_data(ctx, v2401);
                    let v2402 = C::value_list_slice(ctx, v2400);
                    let v2419 = C::gen_return_call(ctx, v2403.0, v2403.1, v2403.2, v2402);
                    let v2420 = Some(v2419);
                    // Rule at src/isa/x64/lower.isle line 3456.
                    return v2420;
                }
                _ => {}
            }
        }
        &InstructionData::CallIndirect {
            opcode: ref v2409,
            args: v2410,
            sig_ref: v2411,
        } => {
            match v2409 {
                &Opcode::CallIndirect => {
                    let v2412 = C::value_list_slice(ctx, v2410);
                    let v2413 = C::value_slice_unwrap(ctx, v2412);
                    if let Some(v2414) = v2413 {
                        let v2417 = C::gen_call_indirect(ctx, v2411, v2414.0, v2414.1);
                        let v2418 = Some(v2417);
                        // Rule at src/isa/x64/lower.isle line 3451.
                        return v2418;
                    }
                }
                &Opcode::ReturnCallIndirect => {
                    let v2412 = C::value_list_slice(ctx, v2410);
                    let v2413 = C::value_slice_unwrap(ctx, v2412);
                    if let Some(v2414) = v2413 {
                        let v2421 = C::gen_return_call_indirect(ctx, v2411, v2414.0, v2414.1);
                        let v2422 = Some(v2421);
                        // Rule at src/isa/x64/lower.isle line 3459.
                        return v2422;
                    }
                }
                _ => {}
            }
        }
        &InstructionData::CondTrap {
            opcode: ref v1165,
            arg: v1166,
            code: ref v1167,
        } => {
            match v1165 {
                &Opcode::Trapz => {
                    let v1172 = C::def_inst(ctx, v1166);
                    if let Some(v1173) = v1172 {
                        let v1174 = &C::inst_data(ctx, v1173);
                        if let &InstructionData::IntCompare {
                            opcode: ref v1175,
                            args: ref v1176,
                            cond: ref v1177,
                        } = v1174 {
                            if let &Opcode::Icmp = v1175 {
                                let v1181 = &C::intcc_complement(ctx, v1177);
                                let v1178 = C::unpack_value_array_2(ctx, v1176);
                                let v1182 = &constructor_emit_cmp(ctx, v1181, v1178.0, v1178.1);
                                let v1183 = &constructor_trap_if_icmp(ctx, v1182, v1167);
                                let v1184 = constructor_side_effect(ctx, v1183);
                                let v1185 = Some(v1184);
                                // Rule at src/isa/x64/lower.isle line 1870.
                                return v1185;
                            }
                        }
                    }
                    let v1169 = &constructor_trap_if_val(ctx, &ZeroCond::Zero, v1166, v1167);
                    let v1170 = constructor_side_effect(ctx, v1169);
                    let v1171 = Some(v1170);
                    // Rule at src/isa/x64/lower.isle line 1867.
                    return v1171;
                }
                &Opcode::Trapnz => {
                    let v1172 = C::def_inst(ctx, v1166);
                    if let Some(v1173) = v1172 {
                        let v1174 = &C::inst_data(ctx, v1173);
                        if let &InstructionData::IntCompare {
                            opcode: ref v1175,
                            args: ref v1176,
                            cond: ref v1177,
                        } = v1174 {
                            if let &Opcode::Icmp = v1175 {
                                let v1178 = C::unpack_value_array_2(ctx, v1176);
                                let v1190 = &constructor_emit_cmp(ctx, v1177, v1178.0, v1178.1);
                                let v1191 = &constructor_trap_if_icmp(ctx, v1190, v1167);
                                let v1192 = constructor_side_effect(ctx, v1191);
                                let v1193 = Some(v1192);
                                // Rule at src/isa/x64/lower.isle line 1878.
                                return v1193;
                            }
                        }
                    }
                    let v1187 = &constructor_trap_if_val(ctx, &ZeroCond::NonZero, v1166, v1167);
                    let v1188 = constructor_side_effect(ctx, v1187);
                    let v1189 = Some(v1188);
                    // Rule at src/isa/x64/lower.isle line 1875.
                    return v1189;
                }
                _ => {}
            }
        }
        &InstructionData::FloatCompare {
            opcode: ref v1390,
            args: ref v1391,
            cond: ref v1392,
        } => {
            if let &Opcode::Fcmp = v1390 {
                match v1392 {
                    &FloatCC::Equal => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1408 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::Equal);
                            let v1409 = constructor_output_xmm(ctx, v1408);
                            let v1410 = Some(v1409);
                            // Rule at src/isa/x64/lower.isle line 2111.
                            return v1410;
                        }
                    }
                    &FloatCC::GreaterThan => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1439 = constructor_put_in_xmm(ctx, v1393.1);
                            let v1440 = &C::put_in_xmm_mem(ctx, v1393.0);
                            let v1441 = constructor_x64_cmpp(ctx, v1404, v1439, v1440, &FcmpImm::LessThan);
                            let v1442 = constructor_output_xmm(ctx, v1441);
                            let v1443 = Some(v1442);
                            // Rule at src/isa/x64/lower.isle line 2131.
                            return v1443;
                        }
                    }
                    &FloatCC::GreaterThanOrEqual => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1439 = constructor_put_in_xmm(ctx, v1393.1);
                            let v1440 = &C::put_in_xmm_mem(ctx, v1393.0);
                            let v1444 = constructor_x64_cmpp(ctx, v1404, v1439, v1440, &FcmpImm::LessThanOrEqual);
                            let v1445 = constructor_output_xmm(ctx, v1444);
                            let v1446 = Some(v1445);
                            // Rule at src/isa/x64/lower.isle line 2133.
                            return v1446;
                        }
                    }
                    &FloatCC::LessThan => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1416 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::LessThan);
                            let v1417 = constructor_output_xmm(ctx, v1416);
                            let v1418 = Some(v1417);
                            // Rule at src/isa/x64/lower.isle line 2115.
                            return v1418;
                        }
                    }
                    &FloatCC::LessThanOrEqual => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1420 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::LessThanOrEqual);
                            let v1421 = constructor_output_xmm(ctx, v1420);
                            let v1422 = Some(v1421);
                            // Rule at src/isa/x64/lower.isle line 2117.
                            return v1422;
                        }
                    }
                    &FloatCC::NotEqual => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1412 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::NotEqual);
                            let v1413 = constructor_output_xmm(ctx, v1412);
                            let v1414 = Some(v1413);
                            // Rule at src/isa/x64/lower.isle line 2113.
                            return v1414;
                        }
                    }
                    &FloatCC::Ordered => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1424 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::Ordered);
                            let v1425 = constructor_output_xmm(ctx, v1424);
                            let v1426 = Some(v1425);
                            // Rule at src/isa/x64/lower.isle line 2119.
                            return v1426;
                        }
                    }
                    &FloatCC::Unordered => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1428 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::Unordered);
                            let v1429 = constructor_output_xmm(ctx, v1428);
                            let v1430 = Some(v1429);
                            // Rule at src/isa/x64/lower.isle line 2121.
                            return v1430;
                        }
                    }
                    &FloatCC::UnorderedOrGreaterThan => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1432 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::UnorderedOrGreaterThan);
                            let v1433 = constructor_output_xmm(ctx, v1432);
                            let v1434 = Some(v1433);
                            // Rule at src/isa/x64/lower.isle line 2123.
                            return v1434;
                        }
                    }
                    &FloatCC::UnorderedOrGreaterThanOrEqual => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1405 = constructor_put_in_xmm(ctx, v1393.0);
                            let v1406 = &C::put_in_xmm_mem(ctx, v1393.1);
                            let v1436 = constructor_x64_cmpp(ctx, v1404, v1405, v1406, &FcmpImm::UnorderedOrGreaterThanOrEqual);
                            let v1437 = constructor_output_xmm(ctx, v1436);
                            let v1438 = Some(v1437);
                            // Rule at src/isa/x64/lower.isle line 2125.
                            return v1438;
                        }
                    }
                    &FloatCC::UnorderedOrLessThan => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1439 = constructor_put_in_xmm(ctx, v1393.1);
                            let v1440 = &C::put_in_xmm_mem(ctx, v1393.0);
                            let v1447 = constructor_x64_cmpp(ctx, v1404, v1439, v1440, &FcmpImm::UnorderedOrGreaterThan);
                            let v1448 = constructor_output_xmm(ctx, v1447);
                            let v1449 = Some(v1448);
                            // Rule at src/isa/x64/lower.isle line 2135.
                            return v1449;
                        }
                    }
                    &FloatCC::UnorderedOrLessThanOrEqual => {
                        let v1393 = C::unpack_value_array_2(ctx, v1391);
                        let v1396 = C::value_type(ctx, v1393.0);
                        let v1403 = C::ty_vec128(ctx, v1396);
                        if let Some(v1404) = v1403 {
                            let v1439 = constructor_put_in_xmm(ctx, v1393.1);
                            let v1440 = &C::put_in_xmm_mem(ctx, v1393.0);
                            let v1450 = constructor_x64_cmpp(ctx, v1404, v1439, v1440, &FcmpImm::UnorderedOrGreaterThanOrEqual);
                            let v1451 = constructor_output_xmm(ctx, v1450);
                            let v1452 = Some(v1451);
                            // Rule at src/isa/x64/lower.isle line 2137.
                            return v1452;
                        }
                    }
                    _ => {}
                }
                let v1393 = C::unpack_value_array_2(ctx, v1391);
                let v1396 = C::value_type(ctx, v1393.0);
                let v1397 = C::ty_scalar_float(ctx, v1396);
                if let Some(v1398) = v1397 {
                    let v1399 = &constructor_emit_fcmp(ctx, v1392, v1393.0, v1393.1);
                    let v1400 = constructor_lower_fcmp_bool(ctx, v1399);
                    let v1401 = C::output(ctx, v1400);
                    let v1402 = Some(v1401);
                    // Rule at src/isa/x64/lower.isle line 2104.
                    return v1402;
                }
            }
        }
        &InstructionData::FuncAddr {
            opcode: ref v2260,
            func_ref: v2261,
        } => {
            if let &Opcode::FuncAddr = v2260 {
                let v2262 = C::func_ref_data(ctx, v2261);
                let v2267 = constructor_load_ext_name(ctx, v2262.1, 0_i64, v2262.2);
                let v2268 = constructor_output_reg(ctx, v2267);
                let v2269 = Some(v2268);
                // Rule at src/isa/x64/lower.isle line 3344.
                return v2269;
            }
        }
        &InstructionData::IntAddTrap {
            opcode: ref v1194,
            args: ref v1195,
            code: ref v1196,
        } => {
            if let &Opcode::UaddOverflowTrap = v1194 {
                let v1 = C::first_result(ctx, arg0);
                if let Some(v2) = v1 {
                    let v3 = C::value_type(ctx, v2);
                    let v4 = C::fits_in_64(ctx, v3);
                    if let Some(v5) = v4 {
                        let v1197 = C::unpack_value_array_2(ctx, v1195);
                        let v1215 = &C::sinkable_load(ctx, v1197.0);
                        if let Some(v1216) = v1215 {
                            let v1209 = constructor_put_in_gpr(ctx, v1197.1);
                            let v1217 = &constructor_sink_load_to_gpr_mem_imm(ctx, v1216);
                            let v1218 = &constructor_x64_add_with_flags_paired(ctx, v5, v1209, v1217);
                            let v1203 = &constructor_trap_if(ctx, &CC::B, v1196);
                            let v1219 = constructor_with_flags(ctx, v1218, v1203);
                            let v1220 = C::output(ctx, v1219);
                            let v1221 = Some(v1220);
                            // Rule at src/isa/x64/lower.isle line 1897.
                            return v1221;
                        }
                        let v1207 = &C::simm32_from_value(ctx, v1197.0);
                        if let Some(v1208) = v1207 {
                            let v1209 = constructor_put_in_gpr(ctx, v1197.1);
                            let v1210 = &constructor_x64_add_with_flags_paired(ctx, v5, v1209, v1208);
                            let v1211 = &constructor_trap_if(ctx, &CC::B, v1196);
                            let v1212 = constructor_with_flags(ctx, v1210, v1211);
                            let v1213 = C::output(ctx, v1212);
                            let v1214 = Some(v1213);
                            // Rule at src/isa/x64/lower.isle line 1891.
                            return v1214;
                        }
                        let v1200 = constructor_put_in_gpr(ctx, v1197.0);
                        let v1201 = &constructor_put_in_gpr_mem_imm(ctx, v1197.1);
                        let v1202 = &constructor_x64_add_with_flags_paired(ctx, v5, v1200, v1201);
                        let v1203 = &constructor_trap_if(ctx, &CC::B, v1196);
                        let v1204 = constructor_with_flags(ctx, v1202, v1203);
                        let v1205 = C::output(ctx, v1204);
                        let v1206 = Some(v1205);
                        // Rule at src/isa/x64/lower.isle line 1883.
                        return v1206;
                    }
                }
            }
        }
        &InstructionData::IntCompare {
            opcode: ref v1227,
            args: ref v1228,
            cond: ref v1229,
        } => {
            if let &Opcode::Icmp = v1227 {
                match v1229 {
                    &IntCC::Equal => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1292 = &C::put_in_xmm_mem(ctx, v1230.1);
                            let v1293 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1292);
                            let v1294 = constructor_output_xmm(ctx, v1293);
                            let v1295 = Some(v1294);
                            // Rule at src/isa/x64/lower.isle line 1954.
                            return v1295;
                        }
                    }
                    &IntCC::NotEqual => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1292 = &C::put_in_xmm_mem(ctx, v1230.1);
                            let v1293 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1292);
                            let v1296 = constructor_vector_all_ones(ctx);
                            let v1297 = &C::xmm_to_xmm_mem(ctx, v1296);
                            let v1298 = constructor_x64_pxor(ctx, v1293, v1297);
                            let v1299 = constructor_output_xmm(ctx, v1298);
                            let v1300 = Some(v1299);
                            // Rule at src/isa/x64/lower.isle line 1959.
                            return v1300;
                        }
                    }
                    &IntCC::SignedGreaterThan => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v1230 = C::unpack_value_array_2(ctx, v1228);
                                let v1253 = C::def_inst(ctx, v1230.0);
                                if let Some(v1254) = v1253 {
                                    let v1255 = &C::inst_data(ctx, v1254);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v1256,
                                        imm: v1257,
                                    } = v1255 {
                                        if let &Opcode::Iconst = v1256 {
                                            let v1258 = C::u64_from_imm64(ctx, v1257);
                                            if v1258 == 0x0_u64 {
                                                let v1259 = C::value_type(ctx, v1230.1);
                                                match v1259 {
                                                    I32 => {
                                                        let v1260 = constructor_put_in_gpr(ctx, v1230.1);
                                                        let v1274 = Imm8Reg::Imm8 {
                                                            imm: 0x1f_u8,
                                                        };
                                                        let v1275 = &C::imm8_reg_to_imm8_gpr(ctx, &v1274);
                                                        let v1279 = constructor_x64_shr(ctx, I32, v1260, v1275);
                                                        let v1280 = constructor_output_gpr(ctx, v1279);
                                                        let v1281 = Some(v1280);
                                                        // Rule at src/isa/x64/lower.isle line 1938.
                                                        return v1281;
                                                    }
                                                    I64 => {
                                                        let v1260 = constructor_put_in_gpr(ctx, v1230.1);
                                                        let v1248 = Imm8Reg::Imm8 {
                                                            imm: 0x3f_u8,
                                                        };
                                                        let v1249 = &C::imm8_reg_to_imm8_gpr(ctx, &v1248);
                                                        let v1261 = constructor_x64_shr(ctx, I64, v1260, v1249);
                                                        let v1262 = constructor_output_gpr(ctx, v1261);
                                                        let v1263 = Some(v1262);
                                                        // Rule at src/isa/x64/lower.isle line 1922.
                                                        return v1263;
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1292 = &C::put_in_xmm_mem(ctx, v1230.1);
                            let v1301 = constructor_x64_pcmpgt(ctx, v1290, v1291, v1292);
                            let v1302 = constructor_output_xmm(ctx, v1301);
                            let v1303 = Some(v1302);
                            // Rule at src/isa/x64/lower.isle line 1966.
                            return v1303;
                        }
                    }
                    &IntCC::SignedGreaterThanOrEqual => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v1230 = C::unpack_value_array_2(ctx, v1228);
                                let v1233 = C::value_type(ctx, v1230.0);
                                match v1233 {
                                    I32 => {
                                        let v1240 = C::def_inst(ctx, v1230.1);
                                        if let Some(v1241) = v1240 {
                                            let v1242 = &C::inst_data(ctx, v1241);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v1243,
                                                imm: v1244,
                                            } = v1242 {
                                                if let &Opcode::Iconst = v1243 {
                                                    let v1245 = C::u64_from_imm64(ctx, v1244);
                                                    if v1245 == 0x0_u64 {
                                                        let v1246 = constructor_put_in_gpr(ctx, v1230.0);
                                                        let v1269 = constructor_x64_not(ctx, I64, v1246);
                                                        let v1274 = Imm8Reg::Imm8 {
                                                            imm: 0x1f_u8,
                                                        };
                                                        let v1282 = &C::imm8_reg_to_imm8_gpr(ctx, &v1274);
                                                        let v1286 = constructor_x64_shr(ctx, I32, v1269, v1282);
                                                        let v1287 = constructor_output_gpr(ctx, v1286);
                                                        let v1288 = Some(v1287);
                                                        // Rule at src/isa/x64/lower.isle line 1946.
                                                        return v1288;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    I64 => {
                                        let v1240 = C::def_inst(ctx, v1230.1);
                                        if let Some(v1241) = v1240 {
                                            let v1242 = &C::inst_data(ctx, v1241);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v1243,
                                                imm: v1244,
                                            } = v1242 {
                                                if let &Opcode::Iconst = v1243 {
                                                    let v1245 = C::u64_from_imm64(ctx, v1244);
                                                    if v1245 == 0x0_u64 {
                                                        let v1246 = constructor_put_in_gpr(ctx, v1230.0);
                                                        let v1269 = constructor_x64_not(ctx, I64, v1246);
                                                        let v1248 = Imm8Reg::Imm8 {
                                                            imm: 0x3f_u8,
                                                        };
                                                        let v1265 = &C::imm8_reg_to_imm8_gpr(ctx, &v1248);
                                                        let v1270 = constructor_x64_shr(ctx, I64, v1269, v1265);
                                                        let v1271 = constructor_output_gpr(ctx, v1270);
                                                        let v1272 = Some(v1271);
                                                        // Rule at src/isa/x64/lower.isle line 1930.
                                                        return v1272;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1341 = constructor_has_pmaxs(ctx, v1290);
                            if v1341 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1342 = &C::put_in_xmm_mem(ctx, v1230.1);
                                let v1343 = constructor_x64_pmaxs(ctx, v1290, v1321, v1342);
                                let v1344 = &C::xmm_to_xmm_mem(ctx, v1343);
                                let v1345 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1344);
                                let v1346 = constructor_output_xmm(ctx, v1345);
                                let v1347 = Some(v1346);
                                // Rule at src/isa/x64/lower.isle line 2016.
                                return v1347;
                            }
                            let v1304 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1305 = &C::put_in_xmm_mem(ctx, v1230.0);
                            let v1306 = constructor_x64_pcmpgt(ctx, v1290, v1304, v1305);
                            let v1296 = constructor_vector_all_ones(ctx);
                            let v1297 = &C::xmm_to_xmm_mem(ctx, v1296);
                            let v1348 = constructor_x64_pxor(ctx, v1306, v1297);
                            let v1349 = constructor_output_xmm(ctx, v1348);
                            let v1350 = Some(v1349);
                            // Rule at src/isa/x64/lower.isle line 2022.
                            return v1350;
                        }
                    }
                    &IntCC::SignedLessThan => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v1230 = C::unpack_value_array_2(ctx, v1228);
                                let v1233 = C::value_type(ctx, v1230.0);
                                match v1233 {
                                    I32 => {
                                        let v1240 = C::def_inst(ctx, v1230.1);
                                        if let Some(v1241) = v1240 {
                                            let v1242 = &C::inst_data(ctx, v1241);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v1243,
                                                imm: v1244,
                                            } = v1242 {
                                                if let &Opcode::Iconst = v1243 {
                                                    let v1245 = C::u64_from_imm64(ctx, v1244);
                                                    if v1245 == 0x0_u64 {
                                                        let v1246 = constructor_put_in_gpr(ctx, v1230.0);
                                                        let v1274 = Imm8Reg::Imm8 {
                                                            imm: 0x1f_u8,
                                                        };
                                                        let v1275 = &C::imm8_reg_to_imm8_gpr(ctx, &v1274);
                                                        let v1276 = constructor_x64_shr(ctx, I32, v1246, v1275);
                                                        let v1277 = constructor_output_gpr(ctx, v1276);
                                                        let v1278 = Some(v1277);
                                                        // Rule at src/isa/x64/lower.isle line 1934.
                                                        return v1278;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    I64 => {
                                        let v1240 = C::def_inst(ctx, v1230.1);
                                        if let Some(v1241) = v1240 {
                                            let v1242 = &C::inst_data(ctx, v1241);
                                            if let &InstructionData::UnaryImm {
                                                opcode: ref v1243,
                                                imm: v1244,
                                            } = v1242 {
                                                if let &Opcode::Iconst = v1243 {
                                                    let v1245 = C::u64_from_imm64(ctx, v1244);
                                                    if v1245 == 0x0_u64 {
                                                        let v1246 = constructor_put_in_gpr(ctx, v1230.0);
                                                        let v1248 = Imm8Reg::Imm8 {
                                                            imm: 0x3f_u8,
                                                        };
                                                        let v1249 = &C::imm8_reg_to_imm8_gpr(ctx, &v1248);
                                                        let v1250 = constructor_x64_shr(ctx, I64, v1246, v1249);
                                                        let v1251 = constructor_output_gpr(ctx, v1250);
                                                        let v1252 = Some(v1251);
                                                        // Rule at src/isa/x64/lower.isle line 1918.
                                                        return v1252;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1304 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1305 = &C::put_in_xmm_mem(ctx, v1230.0);
                            let v1306 = constructor_x64_pcmpgt(ctx, v1290, v1304, v1305);
                            let v1307 = constructor_output_xmm(ctx, v1306);
                            let v1308 = Some(v1307);
                            // Rule at src/isa/x64/lower.isle line 1971.
                            return v1308;
                        }
                    }
                    &IntCC::SignedLessThanOrEqual => {
                        let v1 = C::first_result(ctx, arg0);
                        if let Some(v2) = v1 {
                            let v3 = C::value_type(ctx, v2);
                            if v3 == I8 {
                                let v1230 = C::unpack_value_array_2(ctx, v1228);
                                let v1253 = C::def_inst(ctx, v1230.0);
                                if let Some(v1254) = v1253 {
                                    let v1255 = &C::inst_data(ctx, v1254);
                                    if let &InstructionData::UnaryImm {
                                        opcode: ref v1256,
                                        imm: v1257,
                                    } = v1255 {
                                        if let &Opcode::Iconst = v1256 {
                                            let v1258 = C::u64_from_imm64(ctx, v1257);
                                            if v1258 == 0x0_u64 {
                                                let v1259 = C::value_type(ctx, v1230.1);
                                                match v1259 {
                                                    I32 => {
                                                        let v1260 = constructor_put_in_gpr(ctx, v1230.1);
                                                        let v1264 = constructor_x64_not(ctx, I64, v1260);
                                                        let v1274 = Imm8Reg::Imm8 {
                                                            imm: 0x1f_u8,
                                                        };
                                                        let v1282 = &C::imm8_reg_to_imm8_gpr(ctx, &v1274);
                                                        let v1283 = constructor_x64_shr(ctx, I32, v1264, v1282);
                                                        let v1284 = constructor_output_gpr(ctx, v1283);
                                                        let v1285 = Some(v1284);
                                                        // Rule at src/isa/x64/lower.isle line 1942.
                                                        return v1285;
                                                    }
                                                    I64 => {
                                                        let v1260 = constructor_put_in_gpr(ctx, v1230.1);
                                                        let v1264 = constructor_x64_not(ctx, I64, v1260);
                                                        let v1248 = Imm8Reg::Imm8 {
                                                            imm: 0x3f_u8,
                                                        };
                                                        let v1265 = &C::imm8_reg_to_imm8_gpr(ctx, &v1248);
                                                        let v1266 = constructor_x64_shr(ctx, I64, v1264, v1265);
                                                        let v1267 = constructor_output_gpr(ctx, v1266);
                                                        let v1268 = Some(v1267);
                                                        // Rule at src/isa/x64/lower.isle line 1926.
                                                        return v1268;
                                                    }
                                                    _ => {}
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1351 = constructor_has_pmins(ctx, v1290);
                            if v1351 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1342 = &C::put_in_xmm_mem(ctx, v1230.1);
                                let v1352 = constructor_x64_pmins(ctx, v1290, v1321, v1342);
                                let v1353 = &C::xmm_to_xmm_mem(ctx, v1352);
                                let v1354 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1353);
                                let v1355 = constructor_output_xmm(ctx, v1354);
                                let v1356 = Some(v1355);
                                // Rule at src/isa/x64/lower.isle line 2028.
                                return v1356;
                            }
                            let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1292 = &C::put_in_xmm_mem(ctx, v1230.1);
                            let v1301 = constructor_x64_pcmpgt(ctx, v1290, v1291, v1292);
                            let v1296 = constructor_vector_all_ones(ctx);
                            let v1297 = &C::xmm_to_xmm_mem(ctx, v1296);
                            let v1357 = constructor_x64_pxor(ctx, v1301, v1297);
                            let v1358 = constructor_output_xmm(ctx, v1357);
                            let v1359 = Some(v1358);
                            // Rule at src/isa/x64/lower.isle line 2033.
                            return v1359;
                        }
                    }
                    &IntCC::UnsignedGreaterThan => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1309 = constructor_has_pmaxu(ctx, v1290);
                            if v1309 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1310 = constructor_put_in_xmm(ctx, v1230.1);
                                let v1311 = &C::xmm_to_xmm_mem(ctx, v1310);
                                let v1312 = constructor_x64_pmaxu(ctx, v1290, v1291, v1311);
                                let v1313 = &C::xmm_to_xmm_mem(ctx, v1310);
                                let v1314 = constructor_x64_pcmpeq(ctx, v1290, v1312, v1313);
                                let v1315 = constructor_vector_all_ones(ctx);
                                let v1316 = &C::xmm_to_xmm_mem(ctx, v1315);
                                let v1317 = constructor_x64_pxor(ctx, v1314, v1316);
                                let v1318 = constructor_output_xmm(ctx, v1317);
                                let v1319 = Some(v1318);
                                // Rule at src/isa/x64/lower.isle line 1978.
                                return v1319;
                            }
                            let v1320 = constructor_flip_high_bit_mask(ctx, v1290);
                            let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1322 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1323 = constructor_x64_pxor(ctx, v1321, v1322);
                            let v1324 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1325 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1326 = constructor_x64_pxor(ctx, v1324, v1325);
                            let v1327 = &C::xmm_to_xmm_mem(ctx, v1326);
                            let v1328 = constructor_x64_pcmpgt(ctx, v1290, v1323, v1327);
                            let v1329 = constructor_output_xmm(ctx, v1328);
                            let v1330 = Some(v1329);
                            // Rule at src/isa/x64/lower.isle line 1988.
                            return v1330;
                        }
                    }
                    &IntCC::UnsignedGreaterThanOrEqual => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1309 = constructor_has_pmaxu(ctx, v1290);
                            if v1309 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1342 = &C::put_in_xmm_mem(ctx, v1230.1);
                                let v1360 = constructor_x64_pmaxu(ctx, v1290, v1321, v1342);
                                let v1361 = &C::xmm_to_xmm_mem(ctx, v1360);
                                let v1362 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1361);
                                let v1363 = constructor_output_xmm(ctx, v1362);
                                let v1364 = Some(v1363);
                                // Rule at src/isa/x64/lower.isle line 2038.
                                return v1364;
                            }
                        }
                        if v1233 == I16X8 {
                            let v1304 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1305 = &C::put_in_xmm_mem(ctx, v1230.0);
                            let v1365 = constructor_x64_psubusw(ctx, v1304, v1305);
                            let v1366 = constructor_xmm_zero(ctx, I16X8);
                            let v1367 = &C::xmm_to_xmm_mem(ctx, v1366);
                            let v1368 = constructor_x64_pcmpeqw(ctx, v1365, v1367);
                            let v1369 = constructor_output_xmm(ctx, v1368);
                            let v1370 = Some(v1369);
                            // Rule at src/isa/x64/lower.isle line 2044.
                            return v1370;
                        }
                        if let Some(v1290) = v1289 {
                            let v1320 = constructor_flip_high_bit_mask(ctx, v1290);
                            let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1322 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1323 = constructor_x64_pxor(ctx, v1321, v1322);
                            let v1324 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1325 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1326 = constructor_x64_pxor(ctx, v1324, v1325);
                            let v1337 = &C::xmm_to_xmm_mem(ctx, v1323);
                            let v1338 = constructor_x64_pcmpgt(ctx, v1290, v1326, v1337);
                            let v1371 = constructor_vector_all_ones(ctx);
                            let v1372 = &C::xmm_to_xmm_mem(ctx, v1371);
                            let v1373 = constructor_x64_pxor(ctx, v1338, v1372);
                            let v1374 = constructor_output_xmm(ctx, v1373);
                            let v1375 = Some(v1374);
                            // Rule at src/isa/x64/lower.isle line 2050.
                            return v1375;
                        }
                    }
                    &IntCC::UnsignedLessThan => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1331 = constructor_has_pminu(ctx, v1290);
                            if v1331 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1310 = constructor_put_in_xmm(ctx, v1230.1);
                                let v1311 = &C::xmm_to_xmm_mem(ctx, v1310);
                                let v1332 = constructor_x64_pminu(ctx, v1290, v1291, v1311);
                                let v1313 = &C::xmm_to_xmm_mem(ctx, v1310);
                                let v1333 = constructor_x64_pcmpeq(ctx, v1290, v1332, v1313);
                                let v1315 = constructor_vector_all_ones(ctx);
                                let v1316 = &C::xmm_to_xmm_mem(ctx, v1315);
                                let v1334 = constructor_x64_pxor(ctx, v1333, v1316);
                                let v1335 = constructor_output_xmm(ctx, v1334);
                                let v1336 = Some(v1335);
                                // Rule at src/isa/x64/lower.isle line 1996.
                                return v1336;
                            }
                            let v1320 = constructor_flip_high_bit_mask(ctx, v1290);
                            let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1322 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1323 = constructor_x64_pxor(ctx, v1321, v1322);
                            let v1324 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1325 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1326 = constructor_x64_pxor(ctx, v1324, v1325);
                            let v1337 = &C::xmm_to_xmm_mem(ctx, v1323);
                            let v1338 = constructor_x64_pcmpgt(ctx, v1290, v1326, v1337);
                            let v1339 = constructor_output_xmm(ctx, v1338);
                            let v1340 = Some(v1339);
                            // Rule at src/isa/x64/lower.isle line 2007.
                            return v1340;
                        }
                    }
                    &IntCC::UnsignedLessThanOrEqual => {
                        let v1230 = C::unpack_value_array_2(ctx, v1228);
                        let v1233 = C::value_type(ctx, v1230.0);
                        let v1289 = C::ty_vec128(ctx, v1233);
                        if let Some(v1290) = v1289 {
                            let v1331 = constructor_has_pminu(ctx, v1290);
                            if v1331 == true {
                                let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                                let v1342 = &C::put_in_xmm_mem(ctx, v1230.1);
                                let v1376 = constructor_x64_pminu(ctx, v1290, v1321, v1342);
                                let v1377 = &C::xmm_to_xmm_mem(ctx, v1376);
                                let v1378 = constructor_x64_pcmpeq(ctx, v1290, v1291, v1377);
                                let v1379 = constructor_output_xmm(ctx, v1378);
                                let v1380 = Some(v1379);
                                // Rule at src/isa/x64/lower.isle line 2061.
                                return v1380;
                            }
                        }
                        if v1233 == I16X8 {
                            let v1291 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1292 = &C::put_in_xmm_mem(ctx, v1230.1);
                            let v1381 = constructor_x64_psubusw(ctx, v1291, v1292);
                            let v1382 = constructor_xmm_zero(ctx, I8X16);
                            let v1383 = &C::xmm_to_xmm_mem(ctx, v1382);
                            let v1384 = constructor_x64_pcmpeqw(ctx, v1381, v1383);
                            let v1385 = constructor_output_xmm(ctx, v1384);
                            let v1386 = Some(v1385);
                            // Rule at src/isa/x64/lower.isle line 2068.
                            return v1386;
                        }
                        if let Some(v1290) = v1289 {
                            let v1320 = constructor_flip_high_bit_mask(ctx, v1290);
                            let v1321 = constructor_put_in_xmm(ctx, v1230.0);
                            let v1322 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1323 = constructor_x64_pxor(ctx, v1321, v1322);
                            let v1324 = constructor_put_in_xmm(ctx, v1230.1);
                            let v1325 = &C::xmm_to_xmm_mem(ctx, v1320);
                            let v1326 = constructor_x64_pxor(ctx, v1324, v1325);
                            let v1327 = &C::xmm_to_xmm_mem(ctx, v1326);
                            let v1328 = constructor_x64_pcmpgt(ctx, v1290, v1323, v1327);
                            let v1371 = constructor_vector_all_ones(ctx);
                            let v1372 = &C::xmm_to_xmm_mem(ctx, v1371);
                            let v1387 = constructor_x64_pxor(ctx, v1328, v1372);
                            let v1388 = constructor_output_xmm(ctx, v1387);
                            let v1389 = Some(v1388);
                            // Rule at src/isa/x64/lower.isle line 2076.
                            return v1389;
                        }
                    }
                    _ => {}
                }
                let v1230 = C::unpack_value_array_2(ctx, v1228);
                let v1233 = C::value_type(ctx, v1230.0);
                if v1233 == I128 {
                    let v1236 = &constructor_emit_cmp(ctx, v1229, v1230.0, v1230.1);
                    let v1237 = constructor_lower_icmp_bool(ctx, v1236);
                    let v1238 = C::output(ctx, v1237);
                    let v1239 = Some(v1238);
                    // Rule at src/isa/x64/lower.isle line 1914.
                    return v1239;
                }
                let v1234 = C::fits_in_64(ctx, v1233);
                if let Some(v1235) = v1234 {
                    let v1236 = &constructor_emit_cmp(ctx, v1229, v1230.0, v1230.1);
                    let v1237 = constructor_lower_icmp_bool(ctx, v1236);
                    let v1238 = C::output(ctx, v1237);
                    let v1239 = Some(v1238);
                    // Rule at src/isa/x64/lower.isle line 1911.
                    return v1239;
                }
            }
        }
        &InstructionData::Load {
            opcode: ref v1992,
            arg: v1993,
            flags: v1994,
            offset: v1995,
        } => {
            match v1992 {
                &Opcode::Load => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F16 => {
                                let v2032 = constructor_xmm_uninit_value(ctx);
                                let v1999 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2000 = &constructor_amode_to_gpr_mem(ctx, v1999);
                                let v2034 = constructor_x64_pinsrw(ctx, v2032, v2000, 0x0_u8);
                                let v2035 = constructor_output_xmm(ctx, v2034);
                                let v2036 = Some(v2035);
                                // Rule at src/isa/x64/lower.isle line 2999.
                                return v2036;
                            }
                            F32 => {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2037 = &C::amode_to_synthetic_amode(ctx, v2006);
                                let v2038 = constructor_x64_movss_load(ctx, v2037);
                                let v2039 = constructor_output_xmm(ctx, v2038);
                                let v2040 = Some(v2039);
                                // Rule at src/isa/x64/lower.isle line 3001.
                                return v2040;
                            }
                            F64 => {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2037 = &C::amode_to_synthetic_amode(ctx, v2006);
                                let v2041 = constructor_x64_movsd_load(ctx, v2037);
                                let v2042 = constructor_output_xmm(ctx, v2041);
                                let v2043 = Some(v2042);
                                // Rule at src/isa/x64/lower.isle line 3003.
                                return v2043;
                            }
                            F128 => {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2045 = constructor_x64_movdqu_load(ctx, v2044);
                                let v2046 = constructor_output_xmm(ctx, v2045);
                                let v2047 = Some(v2046);
                                // Rule at src/isa/x64/lower.isle line 3005.
                                return v2047;
                            }
                            F32X4 => {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2037 = &C::amode_to_synthetic_amode(ctx, v2006);
                                let v2048 = constructor_x64_movups_load(ctx, v2037);
                                let v2049 = constructor_output_xmm(ctx, v2048);
                                let v2050 = Some(v2049);
                                // Rule at src/isa/x64/lower.isle line 3007.
                                return v2050;
                            }
                            F64X2 => {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2037 = &C::amode_to_synthetic_amode(ctx, v2006);
                                let v2051 = constructor_x64_movupd_load(ctx, v2037);
                                let v2052 = constructor_output_xmm(ctx, v2051);
                                let v2053 = Some(v2052);
                                // Rule at src/isa/x64/lower.isle line 3009.
                                return v2053;
                            }
                            _ => {}
                        }
                        let v2004 = C::ty_int_ref_64(ctx, v3);
                        if let Some(v2005) = v2004 {
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2007 = constructor_x64_mov(ctx, v2006);
                            let v2008 = constructor_output_reg(ctx, v2007);
                            let v2009 = Some(v2008);
                            // Rule at src/isa/x64/lower.isle line 2977.
                            return v2009;
                        }
                        let v1104 = C::ty_vec128(ctx, v3);
                        if let Some(v1105) = v1104 {
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                            let v2045 = constructor_x64_movdqu_load(ctx, v2044);
                            let v2046 = constructor_output_xmm(ctx, v2045);
                            let v2047 = Some(v2046);
                            // Rule at src/isa/x64/lower.isle line 3011.
                            return v2047;
                        }
                        if v3 == I128 {
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2055 = &C::amode_offset(ctx, v2006, 8_i32);
                            let v2056 = constructor_x64_mov(ctx, v2006);
                            let v2057 = constructor_x64_mov(ctx, v2055);
                            let v2058 = C::value_regs(ctx, v2056, v2057);
                            let v2059 = C::output(ctx, v2058);
                            let v2060 = Some(v2059);
                            // Rule at src/isa/x64/lower.isle line 3015.
                            return v2060;
                        }
                        let v1701 = C::fits_in_32(ctx, v3);
                        if let Some(v1702) = v1701 {
                            let v1989 = &C::type_register_class(ctx, v3);
                            if let Some(v1990) = v1989 {
                                if let &RegisterClass::Gpr {
                                    single_register: v1991,
                                } = v1990 {
                                    let v1996 = C::ty_bits_u16(ctx, v1702);
                                    let v1998 = &C::ext_mode(ctx, v1996, 0x40_u16);
                                    let v1999 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                    let v2000 = &constructor_amode_to_gpr_mem(ctx, v1999);
                                    let v2001 = constructor_x64_movzx(ctx, v1998, v2000);
                                    let v2002 = constructor_output_gpr(ctx, v2001);
                                    let v2003 = Some(v2002);
                                    // Rule at src/isa/x64/lower.isle line 2973.
                                    return v2003;
                                }
                            }
                        }
                    }
                }
                &Opcode::Uload8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2012 = constructor_x64_movzx(ctx, &ExtMode::BQ, v2011);
                                let v2013 = constructor_output_gpr(ctx, v2012);
                                let v2014 = Some(v2013);
                                // Rule at src/isa/x64/lower.isle line 2982.
                                return v2014;
                            }
                        }
                    }
                }
                &Opcode::Sload8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2015 = constructor_x64_movsx(ctx, &ExtMode::BQ, v2011);
                                let v2016 = constructor_output_gpr(ctx, v2015);
                                let v2017 = Some(v2016);
                                // Rule at src/isa/x64/lower.isle line 2984.
                                return v2017;
                            }
                        }
                    }
                }
                &Opcode::Uload16 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2019 = constructor_x64_movzx(ctx, &ExtMode::WQ, v2011);
                                let v2020 = constructor_output_gpr(ctx, v2019);
                                let v2021 = Some(v2020);
                                // Rule at src/isa/x64/lower.isle line 2986.
                                return v2021;
                            }
                        }
                    }
                }
                &Opcode::Sload16 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2022 = constructor_x64_movsx(ctx, &ExtMode::WQ, v2011);
                                let v2023 = constructor_output_gpr(ctx, v2022);
                                let v2024 = Some(v2023);
                                // Rule at src/isa/x64/lower.isle line 2988.
                                return v2024;
                            }
                        }
                    }
                }
                &Opcode::Uload32 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2026 = constructor_x64_movzx(ctx, &ExtMode::LQ, v2011);
                                let v2027 = constructor_output_gpr(ctx, v2026);
                                let v2028 = Some(v2027);
                                // Rule at src/isa/x64/lower.isle line 2990.
                                return v2028;
                            }
                        }
                    }
                }
                &Opcode::Sload32 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            if let &RegisterClass::Gpr {
                                single_register: v1991,
                            } = v1990 {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                                let v2029 = constructor_x64_movsx(ctx, &ExtMode::LQ, v2011);
                                let v2030 = constructor_output_gpr(ctx, v2029);
                                let v2031 = Some(v2030);
                                // Rule at src/isa/x64/lower.isle line 2992.
                                return v2031;
                            }
                        }
                    }
                }
                &Opcode::Uload8x8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2064 = constructor_x64_pmovzxbw(ctx, v2044);
                                let v2065 = constructor_output_xmm(ctx, v2064);
                                let v2066 = Some(v2065);
                                // Rule at src/isa/x64/lower.isle line 3028.
                                return v2066;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2083 = constructor_lower_uwiden_low(ctx, I16X8, v2079);
                            let v2084 = constructor_output_xmm(ctx, v2083);
                            let v2085 = Some(v2084);
                            // Rule at src/isa/x64/lower.isle line 3046.
                            return v2085;
                        }
                    }
                }
                &Opcode::Sload8x8 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I16X8 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2061 = constructor_x64_pmovsxbw(ctx, v2044);
                                let v2062 = constructor_output_xmm(ctx, v2061);
                                let v2063 = Some(v2062);
                                // Rule at src/isa/x64/lower.isle line 3025.
                                return v2063;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2080 = constructor_lower_swiden_low(ctx, I16X8, v2079);
                            let v2081 = constructor_output_xmm(ctx, v2080);
                            let v2082 = Some(v2081);
                            // Rule at src/isa/x64/lower.isle line 3044.
                            return v2082;
                        }
                    }
                }
                &Opcode::Uload16x4 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2070 = constructor_x64_pmovzxwd(ctx, v2044);
                                let v2071 = constructor_output_xmm(ctx, v2070);
                                let v2072 = Some(v2071);
                                // Rule at src/isa/x64/lower.isle line 3034.
                                return v2072;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2089 = constructor_lower_uwiden_low(ctx, I32X4, v2079);
                            let v2090 = constructor_output_xmm(ctx, v2089);
                            let v2091 = Some(v2090);
                            // Rule at src/isa/x64/lower.isle line 3050.
                            return v2091;
                        }
                    }
                }
                &Opcode::Sload16x4 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2067 = constructor_x64_pmovsxwd(ctx, v2044);
                                let v2068 = constructor_output_xmm(ctx, v2067);
                                let v2069 = Some(v2068);
                                // Rule at src/isa/x64/lower.isle line 3031.
                                return v2069;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2086 = constructor_lower_swiden_low(ctx, I32X4, v2079);
                            let v2087 = constructor_output_xmm(ctx, v2086);
                            let v2088 = Some(v2087);
                            // Rule at src/isa/x64/lower.isle line 3048.
                            return v2088;
                        }
                    }
                }
                &Opcode::Uload32x2 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I64X2 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2076 = constructor_x64_pmovzxdq(ctx, v2044);
                                let v2077 = constructor_output_xmm(ctx, v2076);
                                let v2078 = Some(v2077);
                                // Rule at src/isa/x64/lower.isle line 3040.
                                return v2078;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2095 = constructor_lower_uwiden_low(ctx, I64X2, v2079);
                            let v2096 = constructor_output_xmm(ctx, v2095);
                            let v2097 = Some(v2096);
                            // Rule at src/isa/x64/lower.isle line 3054.
                            return v2097;
                        }
                    }
                }
                &Opcode::Sload32x2 => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I64X2 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                                let v2044 = &constructor_amode_to_xmm_mem(ctx, v2006);
                                let v2073 = constructor_x64_pmovsxdq(ctx, v2044);
                                let v2074 = constructor_output_xmm(ctx, v2073);
                                let v2075 = Some(v2074);
                                // Rule at src/isa/x64/lower.isle line 3037.
                                return v2075;
                            }
                            let v2006 = &constructor_to_amode(ctx, v1994, v1993, v1995);
                            let v2011 = &constructor_amode_to_gpr_mem(ctx, v2006);
                            let v2079 = constructor_x64_movq_to_xmm(ctx, v2011);
                            let v2092 = constructor_lower_swiden_low(ctx, I64X2, v2079);
                            let v2093 = constructor_output_xmm(ctx, v2092);
                            let v2094 = Some(v2093);
                            // Rule at src/isa/x64/lower.isle line 3052.
                            return v2094;
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::LoadNoOffset {
            opcode: ref v2280,
            arg: v2281,
            flags: v2282,
        } => {
            match v2280 {
                &Opcode::Bitcast => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v1989 = &C::type_register_class(ctx, v3);
                        if let Some(v1990) = v1989 {
                            match v1990 {
                                &RegisterClass::Gpr {
                                    single_register: v1991,
                                } => {
                                    let v2848 = C::value_type(ctx, v2281);
                                    let v2849 = &C::type_register_class(ctx, v2848);
                                    if let Some(v2850) = v2849 {
                                        if let &RegisterClass::Gpr {
                                            single_register: v2856,
                                        } = v2850 {
                                            let v2868 = constructor_output_value(ctx, v2281);
                                            let v2869 = Some(v2868);
                                            // Rule at src/isa/x64/lower.isle line 4183.
                                            return v2869;
                                        }
                                    }
                                }
                                &RegisterClass::Xmm => {
                                    let v2848 = C::value_type(ctx, v2281);
                                    let v2849 = &C::type_register_class(ctx, v2848);
                                    if let Some(v2850) = v2849 {
                                        if let &RegisterClass::Xmm = v2850 {
                                            let v2868 = constructor_output_value(ctx, v2281);
                                            let v2869 = Some(v2868);
                                            // Rule at src/isa/x64/lower.isle line 4188.
                                            return v2869;
                                        }
                                    }
                                    if v2848 == I128 {
                                        let v2864 = C::put_in_regs(ctx, v2281);
                                        let v2865 = constructor_bitcast_gprs_to_xmm(ctx, v2864);
                                        let v2866 = constructor_output_xmm(ctx, v2865);
                                        let v2867 = Some(v2866);
                                        // Rule at src/isa/x64/lower.isle line 4179.
                                        return v2867;
                                    }
                                }
                                _ => {}
                            }
                        }
                        let v2848 = C::value_type(ctx, v2281);
                        let v2849 = &C::type_register_class(ctx, v2848);
                        if let Some(v2850) = v2849 {
                            match v2850 {
                                &RegisterClass::Gpr {
                                    single_register: v2856,
                                } => {
                                    if let Some(v1990) = v1989 {
                                        if let &RegisterClass::Xmm = v1990 {
                                            let v4 = C::fits_in_64(ctx, v3);
                                            if let Some(v5) = v4 {
                                                let v2857 = constructor_put_in_gpr(ctx, v2281);
                                                let v2851 = C::ty_bits(ctx, v5);
                                                let v2858 = constructor_bitcast_gpr_to_xmm(ctx, v2851, v2857);
                                                let v2859 = constructor_output_xmm(ctx, v2858);
                                                let v2860 = Some(v2859);
                                                // Rule at src/isa/x64/lower.isle line 4173.
                                                return v2860;
                                            }
                                        }
                                    }
                                }
                                &RegisterClass::Xmm => {
                                    if v3 == I128 {
                                        let v2852 = constructor_put_in_xmm(ctx, v2281);
                                        let v2861 = constructor_bitcast_xmm_to_gprs(ctx, v2852);
                                        let v2862 = C::output(ctx, v2861);
                                        let v2863 = Some(v2862);
                                        // Rule at src/isa/x64/lower.isle line 4176.
                                        return v2863;
                                    }
                                    if let Some(v1990) = v1989 {
                                        if let &RegisterClass::Gpr {
                                            single_register: v1991,
                                        } = v1990 {
                                            let v4 = C::fits_in_64(ctx, v3);
                                            if let Some(v5) = v4 {
                                                let v2852 = constructor_put_in_xmm(ctx, v2281);
                                                let v2851 = C::ty_bits(ctx, v5);
                                                let v2853 = constructor_bitcast_xmm_to_gpr(ctx, v2851, v2852);
                                                let v2854 = constructor_output_gpr(ctx, v2853);
                                                let v2855 = Some(v2854);
                                                // Rule at src/isa/x64/lower.isle line 4170.
                                                return v2855;
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                }
                &Opcode::AtomicLoad => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I64 => {
                                let v70 = C::zero_offset(ctx);
                                let v2283 = &constructor_to_amode(ctx, v2282, v2281, v70);
                                let v2284 = constructor_x64_mov(ctx, v2283);
                                let v2285 = constructor_output_reg(ctx, v2284);
                                let v2286 = Some(v2285);
                                // Rule at src/isa/x64/lower.isle line 3360.
                                return v2286;
                            }
                            I128 => {
                                let v2295 = C::use_cmpxchg16b(ctx);
                                if v2295 == true {
                                    let v2296 = constructor_imm(ctx, I64, 0x0_u64);
                                    let v16 = constructor_imm(ctx, I64, 0x0_u64);
                                    let v2297 = C::value_regs(ctx, v2296, v16);
                                    let v2298 = constructor_imm(ctx, I64, 0x0_u64);
                                    let v529 = constructor_imm(ctx, I64, 0x0_u64);
                                    let v2299 = C::value_regs(ctx, v2298, v529);
                                    let v2300 = C::zero_offset(ctx);
                                    let v2301 = &constructor_to_amode(ctx, v2282, v2281, v2300);
                                    let v2302 = &C::amode_to_synthetic_amode(ctx, v2301);
                                    let v2303 = constructor_x64_cmpxchg16b(ctx, v2297, v2299, v2302);
                                    let v2304 = C::output(ctx, v2303);
                                    let v2305 = Some(v2304);
                                    // Rule at src/isa/x64/lower.isle line 3365.
                                    return v2305;
                                }
                            }
                            _ => {}
                        }
                        let v1701 = C::fits_in_32(ctx, v3);
                        if let Some(v1702) = v1701 {
                            let v2287 = C::ty_int(ctx, v3);
                            if let Some(v2288) = v2287 {
                                let v1996 = C::ty_bits_u16(ctx, v1702);
                                let v1998 = &C::ext_mode(ctx, v1996, 0x40_u16);
                                let v2289 = C::zero_offset(ctx);
                                let v2290 = &constructor_to_amode(ctx, v2282, v2281, v2289);
                                let v2291 = &constructor_amode_to_gpr_mem(ctx, v2290);
                                let v2292 = constructor_x64_movzx(ctx, v1998, v2291);
                                let v2293 = constructor_output_gpr(ctx, v2292);
                                let v2294 = Some(v2293);
                                // Rule at src/isa/x64/lower.isle line 3362.
                                return v2294;
                            }
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::MultiAry {
            opcode: ref v1222,
            args: v1223,
        } => {
            if let &Opcode::Return = v1222 {
                let v1224 = C::value_list_slice(ctx, v1223);
                let v1225 = constructor_lower_return(ctx, v1224);
                let v1226 = Some(v1225);
                // Rule at src/isa/x64/lower.isle line 1906.
                return v1226;
            }
        }
        &InstructionData::NullAry {
            opcode: ref v1721,
        } => {
            match v1721 {
                &Opcode::Debugtrap => {
                    let v1722 = &constructor_x64_hlt(ctx);
                    let v1723 = constructor_side_effect(ctx, v1722);
                    let v1724 = Some(v1723);
                    // Rule at src/isa/x64/lower.isle line 2575.
                    return v1724;
                }
                &Opcode::GetPinnedReg => {
                    let v3000 = constructor_read_pinned_gpr(ctx);
                    let v3001 = constructor_output_gpr(ctx, v3000);
                    let v3002 = Some(v3001);
                    // Rule at src/isa/x64/lower.isle line 4439.
                    return v3002;
                }
                &Opcode::GetFramePointer => {
                    let v2430 = constructor_x64_rbp(ctx);
                    let v2431 = constructor_output_reg(ctx, v2430);
                    let v2432 = Some(v2431);
                    // Rule at src/isa/x64/lower.isle line 3474.
                    return v2432;
                }
                &Opcode::GetStackPointer => {
                    let v2433 = constructor_x64_rsp(ctx);
                    let v2434 = constructor_output_reg(ctx, v2433);
                    let v2435 = Some(v2434);
                    // Rule at src/isa/x64/lower.isle line 3477.
                    return v2435;
                }
                &Opcode::GetReturnAddress => {
                    let v2430 = constructor_x64_rbp(ctx);
                    let v69 = C::mem_flags_trusted(ctx);
                    let v2436 = Amode::ImmReg {
                        simm32: 8_i32,
                        base: v2430,
                        flags: v69,
                    };
                    let v2437 = &C::amode_to_synthetic_amode(ctx, &v2436);
                    let v2438 = constructor_x64_load(ctx, I64, v2437, &ExtKind::None);
                    let v2439 = constructor_output_reg(ctx, v2438);
                    let v2440 = Some(v2439);
                    // Rule at src/isa/x64/lower.isle line 3480.
                    return v2440;
                }
                &Opcode::Nop => {
                    let v3412 = C::invalid_reg(ctx);
                    let v3413 = constructor_output_reg(ctx, v3412);
                    let v3414 = Some(v3413);
                    // Rule at src/isa/x64/lower.isle line 4998.
                    return v3414;
                }
                &Opcode::Fence => {
                    let v2257 = &constructor_x64_mfence(ctx);
                    let v2258 = constructor_side_effect(ctx, v2257);
                    let v2259 = Some(v2258);
                    // Rule at src/isa/x64/lower.isle line 3339.
                    return v2259;
                }
                _ => {}
            }
        }
        &InstructionData::Shuffle {
            opcode: ref v3015,
            args: ref v3016,
            imm: v3017,
        } => {
            if let &Opcode::Shuffle = v3015 {
                let v625 = C::use_sse41(ctx);
                if v625 == true {
                    let v3021 = C::pblendw_imm(ctx, v3017);
                    if let Some(v3022) = v3021 {
                        let v3018 = C::unpack_value_array_2(ctx, v3016);
                        let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                        let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                        let v3025 = constructor_x64_pblendw(ctx, v3023, v3024, v3022);
                        let v3026 = constructor_output_xmm(ctx, v3025);
                        let v3027 = Some(v3026);
                        // Rule at src/isa/x64/lower.isle line 4463.
                        return v3027;
                    }
                }
                let v719 = C::use_ssse3(ctx);
                if v719 == true {
                    let v3028 = C::palignr_imm_from_immediate(ctx, v3017);
                    if let Some(v3029) = v3028 {
                        let v3018 = C::unpack_value_array_2(ctx, v3016);
                        let v3030 = constructor_put_in_xmm(ctx, v3018.1);
                        let v3031 = &C::put_in_xmm_mem(ctx, v3018.0);
                        let v3032 = constructor_x64_palignr(ctx, v3030, v3031, v3029);
                        let v3033 = constructor_output_xmm(ctx, v3032);
                        let v3034 = Some(v3033);
                        // Rule at src/isa/x64/lower.isle line 4474.
                        return v3034;
                    }
                }
                let v3035 = C::pshuflw_lhs_imm(ctx, v3017);
                if let Some(v3036) = v3035 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3037 = &C::put_in_xmm_mem(ctx, v3018.0);
                    let v3038 = constructor_x64_pshuflw(ctx, v3037, v3036);
                    let v3039 = constructor_output_xmm(ctx, v3038);
                    let v3040 = Some(v3039);
                    // Rule at src/isa/x64/lower.isle line 4486.
                    return v3040;
                }
                let v3041 = C::pshuflw_rhs_imm(ctx, v3017);
                if let Some(v3042) = v3041 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3043 = &C::put_in_xmm_mem(ctx, v3018.1);
                    let v3044 = constructor_x64_pshuflw(ctx, v3043, v3042);
                    let v3045 = constructor_output_xmm(ctx, v3044);
                    let v3046 = Some(v3045);
                    // Rule at src/isa/x64/lower.isle line 4488.
                    return v3046;
                }
                let v3047 = C::pshufhw_lhs_imm(ctx, v3017);
                if let Some(v3048) = v3047 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3037 = &C::put_in_xmm_mem(ctx, v3018.0);
                    let v3049 = constructor_x64_pshufhw(ctx, v3037, v3048);
                    let v3050 = constructor_output_xmm(ctx, v3049);
                    let v3051 = Some(v3050);
                    // Rule at src/isa/x64/lower.isle line 4490.
                    return v3051;
                }
                let v3052 = C::pshufhw_rhs_imm(ctx, v3017);
                if let Some(v3053) = v3052 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3043 = &C::put_in_xmm_mem(ctx, v3018.1);
                    let v3054 = constructor_x64_pshufhw(ctx, v3043, v3053);
                    let v3055 = constructor_output_xmm(ctx, v3054);
                    let v3056 = Some(v3055);
                    // Rule at src/isa/x64/lower.isle line 4492.
                    return v3056;
                }
                let v3057 = C::pshufd_lhs_imm(ctx, v3017);
                if let Some(v3058) = v3057 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3037 = &C::put_in_xmm_mem(ctx, v3018.0);
                    let v3059 = constructor_x64_pshufd(ctx, v3037, v3058);
                    let v3060 = constructor_output_xmm(ctx, v3059);
                    let v3061 = Some(v3060);
                    // Rule at src/isa/x64/lower.isle line 4509.
                    return v3061;
                }
                let v3062 = C::pshufd_rhs_imm(ctx, v3017);
                if let Some(v3063) = v3062 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3043 = &C::put_in_xmm_mem(ctx, v3018.1);
                    let v3064 = constructor_x64_pshufd(ctx, v3043, v3063);
                    let v3065 = constructor_output_xmm(ctx, v3064);
                    let v3066 = Some(v3065);
                    // Rule at src/isa/x64/lower.isle line 4511.
                    return v3066;
                }
                let v3067 = C::u128_from_immediate(ctx, v3017);
                if let Some(v3068) = v3067 {
                    match v3068 {
                        0x0_u128 => {
                            if v719 == true {
                                let v3018 = C::unpack_value_array_2(ctx, v3016);
                                let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                                let v725 = constructor_xmm_zero(ctx, I8X16);
                                let v2796 = &C::xmm_to_xmm_mem(ctx, v725);
                                let v3093 = constructor_x64_pshufb(ctx, v3023, v2796);
                                let v3094 = constructor_output_xmm(ctx, v3093);
                                let v3095 = Some(v3094);
                                // Rule at src/isa/x64/lower.isle line 4548.
                                return v3095;
                            }
                        }
                        0x17071606150514041303120211011000_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3072 = constructor_x64_punpcklbw(ctx, v3023, v3024);
                            let v3073 = constructor_output_xmm(ctx, v3072);
                            let v3074 = Some(v3073);
                            // Rule at src/isa/x64/lower.isle line 4522.
                            return v3074;
                        }
                        0x17160706151405041312030211100100_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3078 = constructor_x64_punpcklwd(ctx, v3023, v3024);
                            let v3079 = constructor_output_xmm(ctx, v3078);
                            let v3080 = Some(v3079);
                            // Rule at src/isa/x64/lower.isle line 4528.
                            return v3080;
                        }
                        0x17161514070605041312111003020100_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3084 = constructor_x64_punpckldq(ctx, v3023, v3024);
                            let v3085 = constructor_output_xmm(ctx, v3084);
                            let v3086 = Some(v3085);
                            // Rule at src/isa/x64/lower.isle line 4534.
                            return v3086;
                        }
                        0x17161514131211100706050403020100_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3090 = constructor_x64_punpcklqdq(ctx, v3023, v3024);
                            let v3091 = constructor_output_xmm(ctx, v3090);
                            let v3092 = Some(v3091);
                            // Rule at src/isa/x64/lower.isle line 4540.
                            return v3092;
                        }
                        0x1f0f1e0e1d0d1c0c1b0b1a0a19091808_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3069 = constructor_x64_punpckhbw(ctx, v3023, v3024);
                            let v3070 = constructor_output_xmm(ctx, v3069);
                            let v3071 = Some(v3070);
                            // Rule at src/isa/x64/lower.isle line 4520.
                            return v3071;
                        }
                        0x1f1e0f0e1d1c0d0c1b1a0b0a19180908_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3075 = constructor_x64_punpckhwd(ctx, v3023, v3024);
                            let v3076 = constructor_output_xmm(ctx, v3075);
                            let v3077 = Some(v3076);
                            // Rule at src/isa/x64/lower.isle line 4526.
                            return v3077;
                        }
                        0x1f1e1d1c0f0e0d0c1b1a19180b0a0908_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3081 = constructor_x64_punpckhdq(ctx, v3023, v3024);
                            let v3082 = constructor_output_xmm(ctx, v3081);
                            let v3083 = Some(v3082);
                            // Rule at src/isa/x64/lower.isle line 4532.
                            return v3083;
                        }
                        0x1f1e1d1c1b1a19180f0e0d0c0b0a0908_u128 => {
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3087 = constructor_x64_punpckhqdq(ctx, v3023, v3024);
                            let v3088 = constructor_output_xmm(ctx, v3087);
                            let v3089 = Some(v3088);
                            // Rule at src/isa/x64/lower.isle line 4538.
                            return v3089;
                        }
                        _ => {}
                    }
                }
                let v3096 = C::shufps_imm(ctx, v3017);
                if let Some(v3097) = v3096 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                    let v3024 = &C::put_in_xmm_mem(ctx, v3018.1);
                    let v3098 = constructor_x64_shufps(ctx, v3023, v3024, v3097);
                    let v3099 = constructor_output_xmm(ctx, v3098);
                    let v3100 = Some(v3099);
                    // Rule at src/isa/x64/lower.isle line 4562.
                    return v3100;
                }
                let v3101 = C::shufps_rev_imm(ctx, v3017);
                if let Some(v3102) = v3101 {
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3030 = constructor_put_in_xmm(ctx, v3018.1);
                    let v3031 = &C::put_in_xmm_mem(ctx, v3018.0);
                    let v3103 = constructor_x64_shufps(ctx, v3030, v3031, v3102);
                    let v3104 = constructor_output_xmm(ctx, v3103);
                    let v3105 = Some(v3104);
                    // Rule at src/isa/x64/lower.isle line 4564.
                    return v3105;
                }
                let v3106 = &C::vec_mask_from_immediate(ctx, v3017);
                if let Some(v3107) = v3106 {
                    if v719 == true {
                        let v3018 = C::unpack_value_array_2(ctx, v3016);
                        if v3018.0 == v3018.1 {
                            let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3108 = C::shuffle_0_31_mask(ctx, v3107);
                            let v3109 = &constructor_const_to_xmm_mem(ctx, v3108);
                            let v3110 = constructor_x64_pshufb(ctx, v3023, v3109);
                            let v3111 = constructor_output_xmm(ctx, v3110);
                            let v3112 = Some(v3111);
                            // Rule at src/isa/x64/lower.isle line 4577.
                            return v3112;
                        }
                    }
                    let v463 = C::use_avx512vl(ctx);
                    if v463 == true {
                        let v3117 = C::use_avx512vbmi(ctx);
                        if v3117 == true {
                            let v3113 = C::perm_from_mask_with_zeros(ctx, v3107);
                            if let Some(v3114) = v3113 {
                                let v3118 = constructor_x64_xmm_load_const(ctx, I8X16, v3114.0);
                                let v3018 = C::unpack_value_array_2(ctx, v3016);
                                let v3119 = constructor_put_in_xmm(ctx, v3018.0);
                                let v3120 = &C::put_in_xmm_mem(ctx, v3018.1);
                                let v3121 = constructor_x64_vpermi2b(ctx, v3118, v3119, v3120);
                                let v3122 = &constructor_const_to_xmm_mem(ctx, v3114.1);
                                let v3123 = constructor_x64_andps(ctx, v3121, v3122);
                                let v3124 = constructor_output_xmm(ctx, v3123);
                                let v3125 = Some(v3124);
                                // Rule at src/isa/x64/lower.isle line 4584.
                                return v3125;
                            }
                            let v3126 = C::perm_from_mask(ctx, v3107);
                            let v3127 = constructor_x64_xmm_load_const(ctx, I8X16, v3126);
                            let v3018 = C::unpack_value_array_2(ctx, v3016);
                            let v3128 = constructor_put_in_xmm(ctx, v3018.0);
                            let v3129 = &C::put_in_xmm_mem(ctx, v3018.1);
                            let v3130 = constructor_x64_vpermi2b(ctx, v3127, v3128, v3129);
                            let v3131 = constructor_output_xmm(ctx, v3130);
                            let v3132 = Some(v3131);
                            // Rule at src/isa/x64/lower.isle line 4591.
                            return v3132;
                        }
                    }
                    let v3018 = C::unpack_value_array_2(ctx, v3016);
                    let v3023 = constructor_put_in_xmm(ctx, v3018.0);
                    let v3133 = C::shuffle_0_15_mask(ctx, v3107);
                    let v3134 = &constructor_const_to_reg_mem(ctx, v3133);
                    let v3135 = constructor_lower_pshufb(ctx, v3023, v3134);
                    let v3136 = constructor_put_in_xmm(ctx, v3018.1);
                    let v3137 = C::shuffle_16_31_mask(ctx, v3107);
                    let v3138 = &constructor_const_to_reg_mem(ctx, v3137);
                    let v3139 = constructor_lower_pshufb(ctx, v3136, v3138);
                    let v3140 = &C::xmm_to_xmm_mem(ctx, v3139);
                    let v3141 = constructor_x64_por(ctx, v3135, v3140);
                    let v3142 = constructor_output_xmm(ctx, v3141);
                    let v3143 = Some(v3142);
                    // Rule at src/isa/x64/lower.isle line 4599.
                    return v3143;
                }
            }
        }
        &InstructionData::StackLoad {
            opcode: ref v2905,
            stack_slot: v2906,
            offset: v2907,
        } => {
            if let &Opcode::StackAddr = v2905 {
                let v2908 = constructor_stack_addr_impl(ctx, v2906, v2907);
                let v2909 = constructor_output_gpr(ctx, v2908);
                let v2910 = Some(v2909);
                // Rule at src/isa/x64/lower.isle line 4280.
                return v2910;
            }
        }
        &InstructionData::Store {
            opcode: ref v2098,
            args: ref v2099,
            flags: v2100,
            offset: v2101,
        } => {
            match v2098 {
                &Opcode::Store => {
                    let v2102 = C::unpack_value_array_2(ctx, v2099);
                    let v2105 = C::value_type(ctx, v2102.0);
                    let v2125 = C::fits_in_64(ctx, v2105);
                    if let Some(v2126) = v2125 {
                        let v2127 = C::i32_from_iconst(ctx, v2102.0);
                        if let Some(v2128) = v2127 {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2129 = &constructor_x64_movimm_m(ctx, v2126, v2110, v2128);
                            let v2130 = constructor_side_effect(ctx, v2129);
                            let v2131 = Some(v2130);
                            // Rule at src/isa/x64/lower.isle line 3079.
                            return v2131;
                        }
                    }
                    let v2170 = C::def_inst(ctx, v2102.0);
                    if let Some(v2171) = v2170 {
                        let v2172 = C::first_result(ctx, v2171);
                        if let Some(v2173) = v2172 {
                            let v2175 = &C::inst_data(ctx, v2171);
                            match v2175 {
                                &InstructionData::Binary {
                                    opcode: ref v2201,
                                    args: ref v2202,
                                } => {
                                    match v2201 {
                                        &Opcode::Iadd => {
                                            let v2174 = C::value_type(ctx, v2173);
                                            let v2199 = C::ty_32_or_64(ctx, v2174);
                                            if let Some(v2200) = v2199 {
                                                let v2203 = C::unpack_value_array_2(ctx, v2202);
                                                let v2206 = &C::sinkable_load(ctx, v2203.0);
                                                if let Some(v2207) = v2206 {
                                                    let v2208 = C::def_inst(ctx, v2203.0);
                                                    if let Some(v2209) = v2208 {
                                                        let v2210 = &C::inst_data(ctx, v2209);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2211,
                                                            arg: v2212,
                                                            flags: v2213,
                                                            offset: v2214,
                                                        } = v2210 {
                                                            if let &Opcode::Load = v2211 {
                                                                if v2100 == v2213 {
                                                                    if v2101 == v2214 {
                                                                        if v2102.1 == v2212 {
                                                                            let v2215 = &constructor_sink_load_to_reg_mem_imm(ctx, v2207);
                                                                            let v2216 = &constructor_to_amode(ctx, v2213, v2212, v2214);
                                                                            let v2217 = constructor_put_in_gpr(ctx, v2203.1);
                                                                            let v2218 = &constructor_x64_add_mem(ctx, v2200, v2216, v2217);
                                                                            let v2219 = constructor_side_effect(ctx, v2218);
                                                                            let v2220 = Some(v2219);
                                                                            // Rule at src/isa/x64/lower.isle line 3212.
                                                                            return v2220;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v2221 = &C::sinkable_load(ctx, v2203.1);
                                                if let Some(v2222) = v2221 {
                                                    let v2223 = C::def_inst(ctx, v2203.1);
                                                    if let Some(v2224) = v2223 {
                                                        let v2225 = &C::inst_data(ctx, v2224);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2226,
                                                            arg: v2227,
                                                            flags: v2228,
                                                            offset: v2229,
                                                        } = v2225 {
                                                            if let &Opcode::Load = v2226 {
                                                                if v2100 == v2228 {
                                                                    if v2101 == v2229 {
                                                                        if v2102.1 == v2227 {
                                                                            let v2230 = &constructor_sink_load_to_reg_mem_imm(ctx, v2222);
                                                                            let v2231 = &constructor_to_amode(ctx, v2228, v2227, v2229);
                                                                            let v2232 = constructor_put_in_gpr(ctx, v2203.0);
                                                                            let v2233 = &constructor_x64_add_mem(ctx, v2200, v2231, v2232);
                                                                            let v2234 = constructor_side_effect(ctx, v2233);
                                                                            let v2235 = Some(v2234);
                                                                            // Rule at src/isa/x64/lower.isle line 3226.
                                                                            return v2235;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Isub => {
                                            let v2174 = C::value_type(ctx, v2173);
                                            let v2199 = C::ty_32_or_64(ctx, v2174);
                                            if let Some(v2200) = v2199 {
                                                let v2203 = C::unpack_value_array_2(ctx, v2202);
                                                let v2206 = &C::sinkable_load(ctx, v2203.0);
                                                if let Some(v2207) = v2206 {
                                                    let v2208 = C::def_inst(ctx, v2203.0);
                                                    if let Some(v2209) = v2208 {
                                                        let v2210 = &C::inst_data(ctx, v2209);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2211,
                                                            arg: v2212,
                                                            flags: v2213,
                                                            offset: v2214,
                                                        } = v2210 {
                                                            if let &Opcode::Load = v2211 {
                                                                if v2100 == v2213 {
                                                                    if v2101 == v2214 {
                                                                        if v2102.1 == v2212 {
                                                                            let v2215 = &constructor_sink_load_to_reg_mem_imm(ctx, v2207);
                                                                            let v2216 = &constructor_to_amode(ctx, v2213, v2212, v2214);
                                                                            let v2217 = constructor_put_in_gpr(ctx, v2203.1);
                                                                            let v2236 = &constructor_x64_sub_mem(ctx, v2200, v2216, v2217);
                                                                            let v2237 = constructor_side_effect(ctx, v2236);
                                                                            let v2238 = Some(v2237);
                                                                            // Rule at src/isa/x64/lower.isle line 3240.
                                                                            return v2238;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Band => {
                                            let v2174 = C::value_type(ctx, v2173);
                                            let v2199 = C::ty_32_or_64(ctx, v2174);
                                            if let Some(v2200) = v2199 {
                                                let v2203 = C::unpack_value_array_2(ctx, v2202);
                                                let v2206 = &C::sinkable_load(ctx, v2203.0);
                                                if let Some(v2207) = v2206 {
                                                    let v2208 = C::def_inst(ctx, v2203.0);
                                                    if let Some(v2209) = v2208 {
                                                        let v2210 = &C::inst_data(ctx, v2209);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2211,
                                                            arg: v2212,
                                                            flags: v2213,
                                                            offset: v2214,
                                                        } = v2210 {
                                                            if let &Opcode::Load = v2211 {
                                                                if v2100 == v2213 {
                                                                    if v2101 == v2214 {
                                                                        if v2102.1 == v2212 {
                                                                            let v2215 = &constructor_sink_load_to_reg_mem_imm(ctx, v2207);
                                                                            let v2216 = &constructor_to_amode(ctx, v2213, v2212, v2214);
                                                                            let v2217 = constructor_put_in_gpr(ctx, v2203.1);
                                                                            let v2239 = &constructor_x64_and_mem(ctx, v2200, v2216, v2217);
                                                                            let v2240 = constructor_side_effect(ctx, v2239);
                                                                            let v2241 = Some(v2240);
                                                                            // Rule at src/isa/x64/lower.isle line 3254.
                                                                            return v2241;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v2221 = &C::sinkable_load(ctx, v2203.1);
                                                if let Some(v2222) = v2221 {
                                                    let v2223 = C::def_inst(ctx, v2203.1);
                                                    if let Some(v2224) = v2223 {
                                                        let v2225 = &C::inst_data(ctx, v2224);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2226,
                                                            arg: v2227,
                                                            flags: v2228,
                                                            offset: v2229,
                                                        } = v2225 {
                                                            if let &Opcode::Load = v2226 {
                                                                if v2100 == v2228 {
                                                                    if v2101 == v2229 {
                                                                        if v2102.1 == v2227 {
                                                                            let v2230 = &constructor_sink_load_to_reg_mem_imm(ctx, v2222);
                                                                            let v2231 = &constructor_to_amode(ctx, v2228, v2227, v2229);
                                                                            let v2232 = constructor_put_in_gpr(ctx, v2203.0);
                                                                            let v2242 = &constructor_x64_and_mem(ctx, v2200, v2231, v2232);
                                                                            let v2243 = constructor_side_effect(ctx, v2242);
                                                                            let v2244 = Some(v2243);
                                                                            // Rule at src/isa/x64/lower.isle line 3268.
                                                                            return v2244;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Bor => {
                                            let v2174 = C::value_type(ctx, v2173);
                                            let v2199 = C::ty_32_or_64(ctx, v2174);
                                            if let Some(v2200) = v2199 {
                                                let v2203 = C::unpack_value_array_2(ctx, v2202);
                                                let v2206 = &C::sinkable_load(ctx, v2203.0);
                                                if let Some(v2207) = v2206 {
                                                    let v2208 = C::def_inst(ctx, v2203.0);
                                                    if let Some(v2209) = v2208 {
                                                        let v2210 = &C::inst_data(ctx, v2209);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2211,
                                                            arg: v2212,
                                                            flags: v2213,
                                                            offset: v2214,
                                                        } = v2210 {
                                                            if let &Opcode::Load = v2211 {
                                                                if v2100 == v2213 {
                                                                    if v2101 == v2214 {
                                                                        if v2102.1 == v2212 {
                                                                            let v2215 = &constructor_sink_load_to_reg_mem_imm(ctx, v2207);
                                                                            let v2216 = &constructor_to_amode(ctx, v2213, v2212, v2214);
                                                                            let v2217 = constructor_put_in_gpr(ctx, v2203.1);
                                                                            let v2245 = &constructor_x64_or_mem(ctx, v2200, v2216, v2217);
                                                                            let v2246 = constructor_side_effect(ctx, v2245);
                                                                            let v2247 = Some(v2246);
                                                                            // Rule at src/isa/x64/lower.isle line 3282.
                                                                            return v2247;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v2221 = &C::sinkable_load(ctx, v2203.1);
                                                if let Some(v2222) = v2221 {
                                                    let v2223 = C::def_inst(ctx, v2203.1);
                                                    if let Some(v2224) = v2223 {
                                                        let v2225 = &C::inst_data(ctx, v2224);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2226,
                                                            arg: v2227,
                                                            flags: v2228,
                                                            offset: v2229,
                                                        } = v2225 {
                                                            if let &Opcode::Load = v2226 {
                                                                if v2100 == v2228 {
                                                                    if v2101 == v2229 {
                                                                        if v2102.1 == v2227 {
                                                                            let v2230 = &constructor_sink_load_to_reg_mem_imm(ctx, v2222);
                                                                            let v2231 = &constructor_to_amode(ctx, v2228, v2227, v2229);
                                                                            let v2232 = constructor_put_in_gpr(ctx, v2203.0);
                                                                            let v2248 = &constructor_x64_or_mem(ctx, v2200, v2231, v2232);
                                                                            let v2249 = constructor_side_effect(ctx, v2248);
                                                                            let v2250 = Some(v2249);
                                                                            // Rule at src/isa/x64/lower.isle line 3296.
                                                                            return v2250;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        &Opcode::Bxor => {
                                            let v2174 = C::value_type(ctx, v2173);
                                            let v2199 = C::ty_32_or_64(ctx, v2174);
                                            if let Some(v2200) = v2199 {
                                                let v2203 = C::unpack_value_array_2(ctx, v2202);
                                                let v2206 = &C::sinkable_load(ctx, v2203.0);
                                                if let Some(v2207) = v2206 {
                                                    let v2208 = C::def_inst(ctx, v2203.0);
                                                    if let Some(v2209) = v2208 {
                                                        let v2210 = &C::inst_data(ctx, v2209);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2211,
                                                            arg: v2212,
                                                            flags: v2213,
                                                            offset: v2214,
                                                        } = v2210 {
                                                            if let &Opcode::Load = v2211 {
                                                                if v2100 == v2213 {
                                                                    if v2101 == v2214 {
                                                                        if v2102.1 == v2212 {
                                                                            let v2215 = &constructor_sink_load_to_reg_mem_imm(ctx, v2207);
                                                                            let v2216 = &constructor_to_amode(ctx, v2213, v2212, v2214);
                                                                            let v2217 = constructor_put_in_gpr(ctx, v2203.1);
                                                                            let v2251 = &constructor_x64_xor_mem(ctx, v2200, v2216, v2217);
                                                                            let v2252 = constructor_side_effect(ctx, v2251);
                                                                            let v2253 = Some(v2252);
                                                                            // Rule at src/isa/x64/lower.isle line 3310.
                                                                            return v2253;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                let v2221 = &C::sinkable_load(ctx, v2203.1);
                                                if let Some(v2222) = v2221 {
                                                    let v2223 = C::def_inst(ctx, v2203.1);
                                                    if let Some(v2224) = v2223 {
                                                        let v2225 = &C::inst_data(ctx, v2224);
                                                        if let &InstructionData::Load {
                                                            opcode: ref v2226,
                                                            arg: v2227,
                                                            flags: v2228,
                                                            offset: v2229,
                                                        } = v2225 {
                                                            if let &Opcode::Load = v2226 {
                                                                if v2100 == v2228 {
                                                                    if v2101 == v2229 {
                                                                        if v2102.1 == v2227 {
                                                                            let v2230 = &constructor_sink_load_to_reg_mem_imm(ctx, v2222);
                                                                            let v2231 = &constructor_to_amode(ctx, v2228, v2227, v2229);
                                                                            let v2232 = constructor_put_in_gpr(ctx, v2203.0);
                                                                            let v2254 = &constructor_x64_xor_mem(ctx, v2200, v2231, v2232);
                                                                            let v2255 = constructor_side_effect(ctx, v2254);
                                                                            let v2256 = Some(v2255);
                                                                            // Rule at src/isa/x64/lower.isle line 3324.
                                                                            return v2256;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        _ => {}
                                    }
                                }
                                &InstructionData::BinaryImm8 {
                                    opcode: ref v2176,
                                    arg: v2177,
                                    imm: v2178,
                                } => {
                                    if let &Opcode::Extractlane = v2176 {
                                        let v2174 = C::value_type(ctx, v2173);
                                        match v2174 {
                                            I8 => {
                                                let v625 = C::use_sse41(ctx);
                                                if v625 == true {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                    let v2187 = &constructor_x64_pextrb_store(ctx, v2110, v2180, v2179);
                                                    let v2188 = constructor_side_effect(ctx, v2187);
                                                    let v2189 = Some(v2188);
                                                    // Rule at src/isa/x64/lower.isle line 3180.
                                                    return v2189;
                                                }
                                            }
                                            I16 => {
                                                let v625 = C::use_sse41(ctx);
                                                if v625 == true {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                    let v2190 = &constructor_x64_pextrw_store(ctx, v2110, v2180, v2179);
                                                    let v2191 = constructor_side_effect(ctx, v2190);
                                                    let v2192 = Some(v2191);
                                                    // Rule at src/isa/x64/lower.isle line 3187.
                                                    return v2192;
                                                }
                                            }
                                            I32 => {
                                                let v625 = C::use_sse41(ctx);
                                                if v625 == true {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                    let v2193 = &constructor_x64_pextrd_store(ctx, v2110, v2180, v2179);
                                                    let v2194 = constructor_side_effect(ctx, v2193);
                                                    let v2195 = Some(v2194);
                                                    // Rule at src/isa/x64/lower.isle line 3194.
                                                    return v2195;
                                                }
                                            }
                                            I64 => {
                                                let v625 = C::use_sse41(ctx);
                                                if v625 == true {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                    let v2196 = &constructor_x64_pextrq_store(ctx, v2110, v2180, v2179);
                                                    let v2197 = constructor_side_effect(ctx, v2196);
                                                    let v2198 = Some(v2197);
                                                    // Rule at src/isa/x64/lower.isle line 3201.
                                                    return v2198;
                                                }
                                            }
                                            F32 => {
                                                let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                if v2179 == 0x0_u8 {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2181 = &constructor_x64_movss_store(ctx, v2110, v2180);
                                                    let v2182 = constructor_side_effect(ctx, v2181);
                                                    let v2183 = Some(v2182);
                                                    // Rule at src/isa/x64/lower.isle line 3168.
                                                    return v2183;
                                                }
                                            }
                                            F64 => {
                                                let v2179 = C::u8_from_uimm8(ctx, v2178);
                                                if v2179 == 0x0_u8 {
                                                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                                    let v2180 = constructor_put_in_xmm(ctx, v2177);
                                                    let v2184 = &constructor_x64_movsd_store(ctx, v2110, v2180);
                                                    let v2185 = constructor_side_effect(ctx, v2184);
                                                    let v2186 = Some(v2185);
                                                    // Rule at src/isa/x64/lower.isle line 3174.
                                                    return v2186;
                                                }
                                            }
                                            _ => {}
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                    }
                    match v2105 {
                        I128 => {
                            let v2158 = C::put_in_regs(ctx, v2102.0);
                            let v2159 = constructor_value_regs_get_gpr(ctx, v2158, 0x0_usize);
                            let v2160 = constructor_value_regs_get_gpr(ctx, v2158, 0x1_usize);
                            let v2161 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2162 = &C::amode_offset(ctx, v2161, 8_i32);
                            let v2163 = &C::amode_to_synthetic_amode(ctx, v2161);
                            let v2164 = &constructor_x64_movrm(ctx, I64, v2163, v2159);
                            let v2165 = &C::amode_to_synthetic_amode(ctx, v2162);
                            let v2166 = &constructor_x64_movrm(ctx, I64, v2165, v2160);
                            let v2167 = &constructor_side_effect_concat(ctx, v2164, v2166);
                            let v2168 = constructor_side_effect(ctx, v2167);
                            let v2169 = Some(v2168);
                            // Rule at src/isa/x64/lower.isle line 3149.
                            return v2169;
                        }
                        F16 => {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                                let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                                let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                                let v2138 = &constructor_x64_pextrw_store(ctx, v2110, v2133, 0x0_u8);
                                let v2139 = constructor_side_effect(ctx, v2138);
                                let v2140 = Some(v2139);
                                // Rule at src/isa/x64/lower.isle line 3092.
                                return v2140;
                            }
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2134 = constructor_bitcast_xmm_to_gpr(ctx, 0x10_u8, v2133);
                            let v2135 = &constructor_x64_movrm(ctx, I16, v2110, v2134);
                            let v2136 = constructor_side_effect(ctx, v2135);
                            let v2137 = Some(v2136);
                            // Rule at src/isa/x64/lower.isle line 3085.
                            return v2137;
                        }
                        F32 => {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2141 = &constructor_x64_movss_store(ctx, v2110, v2133);
                            let v2142 = constructor_side_effect(ctx, v2141);
                            let v2143 = Some(v2142);
                            // Rule at src/isa/x64/lower.isle line 3101.
                            return v2143;
                        }
                        F64 => {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2144 = &constructor_x64_movsd_store(ctx, v2110, v2133);
                            let v2145 = constructor_side_effect(ctx, v2144);
                            let v2146 = Some(v2145);
                            // Rule at src/isa/x64/lower.isle line 3109.
                            return v2146;
                        }
                        F128 => {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2147 = &constructor_x64_movdqu_store(ctx, v2110, v2133);
                            let v2148 = constructor_side_effect(ctx, v2147);
                            let v2149 = Some(v2148);
                            // Rule at src/isa/x64/lower.isle line 3117.
                            return v2149;
                        }
                        F32X4 => {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2150 = &constructor_x64_movups_store(ctx, v2110, v2133);
                            let v2151 = constructor_side_effect(ctx, v2150);
                            let v2152 = Some(v2151);
                            // Rule at src/isa/x64/lower.isle line 3125.
                            return v2152;
                        }
                        F64X2 => {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                            let v2153 = &constructor_x64_movupd_store(ctx, v2110, v2133);
                            let v2154 = constructor_side_effect(ctx, v2153);
                            let v2155 = Some(v2154);
                            // Rule at src/isa/x64/lower.isle line 3133.
                            return v2155;
                        }
                        _ => {}
                    }
                    let v2156 = C::ty_vec128_int(ctx, v2105);
                    if let Some(v2157) = v2156 {
                        let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                        let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                        let v2133 = constructor_put_in_xmm(ctx, v2102.0);
                        let v2147 = &constructor_x64_movdqu_store(ctx, v2110, v2133);
                        let v2148 = constructor_side_effect(ctx, v2147);
                        let v2149 = Some(v2148);
                        // Rule at src/isa/x64/lower.isle line 3141.
                        return v2149;
                    }
                    let v2106 = &C::type_register_class(ctx, v2105);
                    if let Some(v2107) = v2106 {
                        if let &RegisterClass::Gpr {
                            single_register: v2108,
                        } = v2107 {
                            let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                            let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                            let v2111 = constructor_put_in_gpr(ctx, v2102.0);
                            let v2112 = &constructor_x64_movrm(ctx, v2105, v2110, v2111);
                            let v2113 = constructor_side_effect(ctx, v2112);
                            let v2114 = Some(v2113);
                            // Rule at src/isa/x64/lower.isle line 3060.
                            return v2114;
                        }
                    }
                }
                &Opcode::Istore8 => {
                    let v2102 = C::unpack_value_array_2(ctx, v2099);
                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                    let v2111 = constructor_put_in_gpr(ctx, v2102.0);
                    let v2116 = &constructor_x64_movrm(ctx, I8, v2110, v2111);
                    let v2117 = constructor_side_effect(ctx, v2116);
                    let v2118 = Some(v2117);
                    // Rule at src/isa/x64/lower.isle line 3068.
                    return v2118;
                }
                &Opcode::Istore16 => {
                    let v2102 = C::unpack_value_array_2(ctx, v2099);
                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                    let v2111 = constructor_put_in_gpr(ctx, v2102.0);
                    let v2119 = &constructor_x64_movrm(ctx, I16, v2110, v2111);
                    let v2120 = constructor_side_effect(ctx, v2119);
                    let v2121 = Some(v2120);
                    // Rule at src/isa/x64/lower.isle line 3071.
                    return v2121;
                }
                &Opcode::Istore32 => {
                    let v2102 = C::unpack_value_array_2(ctx, v2099);
                    let v2109 = &constructor_to_amode(ctx, v2100, v2102.1, v2101);
                    let v2110 = &C::amode_to_synthetic_amode(ctx, v2109);
                    let v2111 = constructor_put_in_gpr(ctx, v2102.0);
                    let v2122 = &constructor_x64_movrm(ctx, I32, v2110, v2111);
                    let v2123 = constructor_side_effect(ctx, v2122);
                    let v2124 = Some(v2123);
                    // Rule at src/isa/x64/lower.isle line 3074.
                    return v2124;
                }
                _ => {}
            }
        }
        &InstructionData::StoreNoOffset {
            opcode: ref v2306,
            args: ref v2307,
            flags: v2308,
        } => {
            if let &Opcode::AtomicStore = v2306 {
                let v2295 = C::use_cmpxchg16b(ctx);
                if v2295 == true {
                    let v2309 = C::unpack_value_array_2(ctx, v2307);
                    let v2312 = C::value_type(ctx, v2309.0);
                    if v2312 == I128 {
                        let v70 = C::zero_offset(ctx);
                        let v2317 = &constructor_to_amode(ctx, v2308, v2309.1, v70);
                        let v2318 = &C::amode_to_synthetic_amode(ctx, v2317);
                        let v2325 = C::put_in_regs(ctx, v2309.0);
                        let v2326 = &constructor_x64_atomic_128_store_seq(ctx, v2318, v2325);
                        let v2327 = constructor_side_effect(ctx, v2326);
                        let v2328 = Some(v2327);
                        // Rule at src/isa/x64/lower.isle line 3380.
                        return v2328;
                    }
                }
                let v2309 = C::unpack_value_array_2(ctx, v2307);
                let v2312 = C::value_type(ctx, v2309.0);
                let v2313 = C::fits_in_64(ctx, v2312);
                if let Some(v2314) = v2313 {
                    let v2315 = C::ty_int(ctx, v2312);
                    if let Some(v2316) = v2315 {
                        let v70 = C::zero_offset(ctx);
                        let v2317 = &constructor_to_amode(ctx, v2308, v2309.1, v70);
                        let v2318 = &C::amode_to_synthetic_amode(ctx, v2317);
                        let v2319 = constructor_put_in_gpr(ctx, v2309.0);
                        let v2320 = &constructor_x64_movrm(ctx, v2314, v2318, v2319);
                        let v2321 = &constructor_x64_mfence(ctx);
                        let v2322 = &constructor_side_effect_concat(ctx, v2320, v2321);
                        let v2323 = constructor_side_effect(ctx, v2322);
                        let v2324 = Some(v2323);
                        // Rule at src/isa/x64/lower.isle line 3373.
                        return v2324;
                    }
                }
            }
        }
        &InstructionData::Ternary {
            opcode: ref v870,
            args: ref v871,
        } => {
            match v870 {
                &Opcode::StackSwitch => {
                    let v2423 = &C::stack_switch_model(ctx);
                    if let Some(v2424) = v2423 {
                        if let &StackSwitchModel::Basic = v2424 {
                            let v872 = C::unpack_value_array_3(ctx, v871);
                            let v936 = constructor_put_in_gpr(ctx, v872.0);
                            let v2425 = constructor_put_in_gpr(ctx, v872.1);
                            let v2426 = constructor_put_in_gpr(ctx, v872.2);
                            let v2427 = constructor_x64_stack_switch_basic(ctx, v936, v2425, v2426);
                            let v2428 = constructor_output_gpr(ctx, v2427);
                            let v2429 = Some(v2428);
                            // Rule at src/isa/x64/lower.isle line 3465.
                            return v2429;
                        }
                    }
                }
                &Opcode::Select => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v872 = C::unpack_value_array_3(ctx, v871);
                        let v1453 = C::maybe_uextend(ctx, v872.0);
                        if let Some(v1454) = v1453 {
                            let v1455 = C::def_inst(ctx, v1454);
                            if let Some(v1456) = v1455 {
                                let v1457 = &C::inst_data(ctx, v1456);
                                match v1457 {
                                    &InstructionData::FloatCompare {
                                        opcode: ref v1458,
                                        args: ref v1459,
                                        cond: ref v1460,
                                    } => {
                                        if let &Opcode::Fcmp = v1458 {
                                            match v1460 {
                                                &FloatCC::Equal => {
                                                    let v1461 = C::unpack_value_array_2(ctx, v1459);
                                                    let v1468 = &constructor_emit_fcmp(ctx, &FloatCC::NotEqual, v1461.0, v1461.1);
                                                    let v3 = C::value_type(ctx, v2);
                                                    let v1469 = constructor_lower_select_fcmp(ctx, v3, v1468, v872.2, v872.1);
                                                    let v1470 = Some(v1469);
                                                    // Rule at src/isa/x64/lower.isle line 2157.
                                                    return v1470;
                                                }
                                                &FloatCC::LessThan => {
                                                    let v3 = C::value_type(ctx, v2);
                                                    match v3 {
                                                        F32 => {
                                                            let v1461 = C::unpack_value_array_2(ctx, v1459);
                                                            if v872.1 == v1461.1 {
                                                                if v872.2 == v1461.0 {
                                                                    let v1505 = constructor_put_in_xmm(ctx, v1461.1);
                                                                    let v1506 = &C::put_in_xmm_mem(ctx, v1461.0);
                                                                    let v1507 = constructor_x64_maxss(ctx, v1505, v1506);
                                                                    let v1508 = constructor_output_xmm(ctx, v1507);
                                                                    let v1509 = Some(v1508);
                                                                    // Rule at src/isa/x64/lower.isle line 2199.
                                                                    return v1509;
                                                                }
                                                            }
                                                            if v872.1 == v1461.0 {
                                                                if v872.2 == v1461.1 {
                                                                    let v1497 = constructor_put_in_xmm(ctx, v1461.0);
                                                                    let v1498 = &C::put_in_xmm_mem(ctx, v1461.1);
                                                                    let v1499 = constructor_x64_minss(ctx, v1497, v1498);
                                                                    let v1500 = constructor_output_xmm(ctx, v1499);
                                                                    let v1501 = Some(v1500);
                                                                    // Rule at src/isa/x64/lower.isle line 2195.
                                                                    return v1501;
                                                                }
                                                            }
                                                        }
                                                        F64 => {
                                                            let v1461 = C::unpack_value_array_2(ctx, v1459);
                                                            if v872.1 == v1461.1 {
                                                                if v872.2 == v1461.0 {
                                                                    let v1505 = constructor_put_in_xmm(ctx, v1461.1);
                                                                    let v1506 = &C::put_in_xmm_mem(ctx, v1461.0);
                                                                    let v1510 = constructor_x64_maxsd(ctx, v1505, v1506);
                                                                    let v1511 = constructor_output_xmm(ctx, v1510);
                                                                    let v1512 = Some(v1511);
                                                                    // Rule at src/isa/x64/lower.isle line 2201.
                                                                    return v1512;
                                                                }
                                                            }
                                                            if v872.1 == v1461.0 {
                                                                if v872.2 == v1461.1 {
                                                                    let v1497 = constructor_put_in_xmm(ctx, v1461.0);
                                                                    let v1498 = &C::put_in_xmm_mem(ctx, v1461.1);
                                                                    let v1502 = constructor_x64_minsd(ctx, v1497, v1498);
                                                                    let v1503 = constructor_output_xmm(ctx, v1502);
                                                                    let v1504 = Some(v1503);
                                                                    // Rule at src/isa/x64/lower.isle line 2197.
                                                                    return v1504;
                                                                }
                                                            }
                                                        }
                                                        _ => {}
                                                    }
                                                }
                                                _ => {}
                                            }
                                            let v1461 = C::unpack_value_array_2(ctx, v1459);
                                            let v1464 = &constructor_emit_fcmp(ctx, v1460, v1461.0, v1461.1);
                                            let v3 = C::value_type(ctx, v2);
                                            let v1465 = constructor_lower_select_fcmp(ctx, v3, v1464, v872.1, v872.2);
                                            let v1466 = Some(v1465);
                                            // Rule at src/isa/x64/lower.isle line 2155.
                                            return v1466;
                                        }
                                    }
                                    &InstructionData::IntCompare {
                                        opcode: ref v1471,
                                        args: ref v1472,
                                        cond: ref v1473,
                                    } => {
                                        if let &Opcode::Icmp = v1471 {
                                            let v1474 = C::unpack_value_array_2(ctx, v1472);
                                            let v1477 = &constructor_emit_cmp(ctx, v1473, v1474.0, v1474.1);
                                            let v3 = C::value_type(ctx, v2);
                                            let v1478 = constructor_lower_select_icmp(ctx, v3, v1477, v872.1, v872.2);
                                            let v1479 = Some(v1478);
                                            // Rule at src/isa/x64/lower.isle line 2171.
                                            return v1479;
                                        }
                                    }
                                    _ => {}
                                }
                            }
                        }
                        let v1480 = C::value_type(ctx, v872.0);
                        let v1481 = C::fits_in_64(ctx, v1480);
                        if let Some(v1482) = v1481 {
                            let v1483 = &C::raw_operand_size_of_type(ctx, v1482);
                            let v1484 = constructor_put_in_gpr(ctx, v872.0);
                            let v1485 = &C::gpr_to_gpr_mem_imm(ctx, v1484);
                            let v1486 = &constructor_x64_test(ctx, v1483, v1484, v1485);
                            let v3 = C::value_type(ctx, v2);
                            let v1488 = &constructor_cmove_from_values(ctx, v3, &CC::NZ, v872.1, v872.2);
                            let v1489 = constructor_with_flags(ctx, v1486, v1488);
                            let v1490 = C::output(ctx, v1489);
                            let v1491 = Some(v1490);
                            // Rule at src/isa/x64/lower.isle line 2177.
                            return v1491;
                        }
                        if v1480 == I128 {
                            let v925 = C::put_in_regs(ctx, v872.0);
                            let v1493 = &constructor_cmp_zero_i128(ctx, &CC::Z, v925);
                            let v1494 = constructor_select_icmp(ctx, v1493, v872.1, v872.2);
                            let v1495 = C::output(ctx, v1494);
                            let v1496 = Some(v1495);
                            // Rule at src/isa/x64/lower.isle line 2184.
                            return v1496;
                        }
                    }
                }
                &Opcode::SelectSpectreGuard => {
                    let v872 = C::unpack_value_array_3(ctx, v871);
                    let v894 = C::def_inst(ctx, v872.0);
                    if let Some(v895) = v894 {
                        let v896 = &C::inst_data(ctx, v895);
                        if let &InstructionData::IntCompare {
                            opcode: ref v2441,
                            args: ref v2442,
                            cond: ref v2443,
                        } = v896 {
                            if let &Opcode::Icmp = v2441 {
                                let v2444 = C::unpack_value_array_2(ctx, v2442);
                                let v2447 = &constructor_emit_cmp(ctx, v2443, v2444.0, v2444.1);
                                let v2448 = constructor_select_icmp(ctx, v2447, v872.1, v872.2);
                                let v2449 = C::output(ctx, v2448);
                                let v2450 = Some(v2449);
                                // Rule at src/isa/x64/lower.isle line 3550.
                                return v2450;
                            }
                        }
                    }
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1480 = C::value_type(ctx, v872.0);
                        let v1481 = C::fits_in_64(ctx, v1480);
                        if let Some(v1482) = v1481 {
                            let v1483 = &C::raw_operand_size_of_type(ctx, v1482);
                            let v1484 = constructor_put_in_gpr(ctx, v872.0);
                            let v1485 = &C::gpr_to_gpr_mem_imm(ctx, v1484);
                            let v1486 = &constructor_x64_test(ctx, v1483, v1484, v1485);
                            let v3 = C::value_type(ctx, v2);
                            let v1488 = &constructor_cmove_from_values(ctx, v3, &CC::NZ, v872.1, v872.2);
                            let v1489 = constructor_with_flags(ctx, v1486, v1488);
                            let v1490 = C::output(ctx, v1489);
                            let v1491 = Some(v1490);
                            // Rule at src/isa/x64/lower.isle line 3553.
                            return v1491;
                        }
                        if v1480 == I128 {
                            let v925 = C::put_in_regs(ctx, v872.0);
                            let v1493 = &constructor_cmp_zero_i128(ctx, &CC::Z, v925);
                            let v1494 = constructor_select_icmp(ctx, v1493, v872.1, v872.2);
                            let v1495 = C::output(ctx, v1494);
                            let v1496 = Some(v1495);
                            // Rule at src/isa/x64/lower.isle line 3558.
                            return v1496;
                        }
                    }
                }
                &Opcode::Bitselect => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v872 = C::unpack_value_array_3(ctx, v871);
                            let v876 = constructor_put_in_xmm(ctx, v872.0);
                            let v889 = &C::put_in_xmm_mem(ctx, v872.1);
                            let v947 = constructor_sse_and(ctx, v251, v876, v889);
                            let v948 = constructor_put_in_xmm(ctx, v872.0);
                            let v949 = constructor_vector_all_ones(ctx);
                            let v950 = &C::xmm_to_xmm_mem(ctx, v949);
                            let v951 = constructor_x64_xor_vector(ctx, v251, v948, v950);
                            let v952 = &C::put_in_xmm_mem(ctx, v872.2);
                            let v953 = constructor_sse_and(ctx, v251, v951, v952);
                            let v954 = &C::xmm_to_xmm_mem(ctx, v953);
                            let v955 = constructor_sse_or(ctx, v251, v947, v954);
                            let v956 = constructor_output_xmm(ctx, v955);
                            let v957 = Some(v956);
                            // Rule at src/isa/x64/lower.isle line 1527.
                            return v957;
                        }
                        let v934 = C::ty_int_ref_scalar_64_extract(ctx, v3);
                        if let Some(v935) = v934 {
                            let v872 = C::unpack_value_array_3(ctx, v871);
                            let v936 = constructor_put_in_gpr(ctx, v872.0);
                            let v937 = &constructor_put_in_gpr_mem_imm(ctx, v872.1);
                            let v938 = constructor_x64_and(ctx, v935, v936, v937);
                            let v939 = constructor_put_in_gpr(ctx, v872.0);
                            let v940 = constructor_x64_not(ctx, v935, v939);
                            let v941 = &constructor_put_in_gpr_mem_imm(ctx, v872.2);
                            let v942 = constructor_x64_and(ctx, v935, v940, v941);
                            let v943 = &C::gpr_to_gpr_mem_imm(ctx, v942);
                            let v944 = constructor_x64_or(ctx, v935, v938, v943);
                            let v945 = constructor_output_gpr(ctx, v944);
                            let v946 = Some(v945);
                            // Rule at src/isa/x64/lower.isle line 1522.
                            return v946;
                        }
                        match v3 {
                            I128 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v925 = C::put_in_regs(ctx, v872.0);
                                let v926 = C::put_in_regs(ctx, v872.1);
                                let v927 = constructor_and_i128(ctx, v925, v926);
                                let v928 = constructor_i128_not(ctx, v872.0);
                                let v929 = C::put_in_regs(ctx, v872.2);
                                let v930 = constructor_and_i128(ctx, v928, v929);
                                let v931 = constructor_or_i128(ctx, v927, v930);
                                let v932 = C::output(ctx, v931);
                                let v933 = Some(v932);
                                // Rule at src/isa/x64/lower.isle line 1517.
                                return v933;
                            }
                            F32X4 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v894 = C::def_inst(ctx, v872.0);
                                if let Some(v895) = v894 {
                                    let v896 = &C::inst_data(ctx, v895);
                                    if let &InstructionData::LoadNoOffset {
                                        opcode: ref v897,
                                        arg: v898,
                                        flags: v899,
                                    } = v896 {
                                        if let &Opcode::Bitcast = v897 {
                                            let v900 = C::def_inst(ctx, v898);
                                            if let Some(v901) = v900 {
                                                let v902 = &C::inst_data(ctx, v901);
                                                if let &InstructionData::FloatCompare {
                                                    opcode: ref v903,
                                                    args: ref v904,
                                                    cond: ref v905,
                                                } = v902 {
                                                    if let &Opcode::Fcmp = v903 {
                                                        if let &FloatCC::LessThan = v905 {
                                                            let v906 = C::unpack_value_array_2(ctx, v904);
                                                            if v872.1 == v906.1 {
                                                                if v872.2 == v906.0 {
                                                                    let v917 = constructor_put_in_xmm(ctx, v906.1);
                                                                    let v918 = &C::put_in_xmm_mem(ctx, v906.0);
                                                                    let v919 = constructor_x64_maxps(ctx, v917, v918);
                                                                    let v920 = constructor_output_xmm(ctx, v919);
                                                                    let v921 = Some(v920);
                                                                    // Rule at src/isa/x64/lower.isle line 1510.
                                                                    return v921;
                                                                }
                                                            }
                                                            if v872.1 == v906.0 {
                                                                if v872.2 == v906.1 {
                                                                    let v909 = constructor_put_in_xmm(ctx, v906.0);
                                                                    let v910 = &C::put_in_xmm_mem(ctx, v906.1);
                                                                    let v911 = constructor_x64_minps(ctx, v909, v910);
                                                                    let v912 = constructor_output_xmm(ctx, v911);
                                                                    let v913 = Some(v912);
                                                                    // Rule at src/isa/x64/lower.isle line 1505.
                                                                    return v913;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            F64X2 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v894 = C::def_inst(ctx, v872.0);
                                if let Some(v895) = v894 {
                                    let v896 = &C::inst_data(ctx, v895);
                                    if let &InstructionData::LoadNoOffset {
                                        opcode: ref v897,
                                        arg: v898,
                                        flags: v899,
                                    } = v896 {
                                        if let &Opcode::Bitcast = v897 {
                                            let v900 = C::def_inst(ctx, v898);
                                            if let Some(v901) = v900 {
                                                let v902 = &C::inst_data(ctx, v901);
                                                if let &InstructionData::FloatCompare {
                                                    opcode: ref v903,
                                                    args: ref v904,
                                                    cond: ref v905,
                                                } = v902 {
                                                    if let &Opcode::Fcmp = v903 {
                                                        if let &FloatCC::LessThan = v905 {
                                                            let v906 = C::unpack_value_array_2(ctx, v904);
                                                            if v872.1 == v906.1 {
                                                                if v872.2 == v906.0 {
                                                                    let v917 = constructor_put_in_xmm(ctx, v906.1);
                                                                    let v918 = &C::put_in_xmm_mem(ctx, v906.0);
                                                                    let v922 = constructor_x64_maxpd(ctx, v917, v918);
                                                                    let v923 = constructor_output_xmm(ctx, v922);
                                                                    let v924 = Some(v923);
                                                                    // Rule at src/isa/x64/lower.isle line 1512.
                                                                    return v924;
                                                                }
                                                            }
                                                            if v872.1 == v906.0 {
                                                                if v872.2 == v906.1 {
                                                                    let v909 = constructor_put_in_xmm(ctx, v906.0);
                                                                    let v910 = &C::put_in_xmm_mem(ctx, v906.1);
                                                                    let v914 = constructor_x64_minpd(ctx, v909, v910);
                                                                    let v915 = constructor_output_xmm(ctx, v914);
                                                                    let v916 = Some(v915);
                                                                    // Rule at src/isa/x64/lower.isle line 1507.
                                                                    return v916;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            let v625 = C::use_sse41(ctx);
                            if v625 == true {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v886 = constructor_all_ones_or_all_zeros(ctx, v872.0);
                                if let Some(v887) = v886 {
                                    let v888 = constructor_put_in_xmm(ctx, v872.2);
                                    let v889 = &C::put_in_xmm_mem(ctx, v872.1);
                                    let v890 = constructor_put_in_xmm(ctx, v872.0);
                                    let v891 = constructor_x64_pblendvb(ctx, v888, v889, v890);
                                    let v892 = constructor_output_xmm(ctx, v891);
                                    let v893 = Some(v892);
                                    // Rule at src/isa/x64/lower.isle line 1483.
                                    return v893;
                                }
                            }
                            let v872 = C::unpack_value_array_3(ctx, v871);
                            let v876 = constructor_put_in_xmm(ctx, v872.0);
                            let v877 = constructor_put_in_xmm(ctx, v872.1);
                            let v878 = &C::xmm_to_xmm_mem(ctx, v876);
                            let v879 = constructor_sse_and(ctx, v3, v877, v878);
                            let v880 = &C::put_in_xmm_mem(ctx, v872.2);
                            let v881 = constructor_sse_and_not(ctx, v3, v876, v880);
                            let v882 = &C::xmm_to_xmm_mem(ctx, v879);
                            let v883 = constructor_sse_or(ctx, v3, v881, v882);
                            let v884 = constructor_output_xmm(ctx, v883);
                            let v885 = Some(v884);
                            // Rule at src/isa/x64/lower.isle line 1469.
                            return v885;
                        }
                    }
                }
                &Opcode::X86Blendv => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v872 = C::unpack_value_array_3(ctx, v871);
                                    let v888 = constructor_put_in_xmm(ctx, v872.2);
                                    let v889 = &C::put_in_xmm_mem(ctx, v872.1);
                                    let v890 = constructor_put_in_xmm(ctx, v872.0);
                                    let v891 = constructor_x64_pblendvb(ctx, v888, v889, v890);
                                    let v892 = constructor_output_xmm(ctx, v891);
                                    let v893 = Some(v892);
                                    // Rule at src/isa/x64/lower.isle line 1535.
                                    return v893;
                                }
                            }
                            I32X4 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v872 = C::unpack_value_array_3(ctx, v871);
                                    let v888 = constructor_put_in_xmm(ctx, v872.2);
                                    let v889 = &C::put_in_xmm_mem(ctx, v872.1);
                                    let v890 = constructor_put_in_xmm(ctx, v872.0);
                                    let v958 = constructor_x64_blendvps(ctx, v888, v889, v890);
                                    let v959 = constructor_output_xmm(ctx, v958);
                                    let v960 = Some(v959);
                                    // Rule at src/isa/x64/lower.isle line 1540.
                                    return v960;
                                }
                            }
                            I64X2 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v872 = C::unpack_value_array_3(ctx, v871);
                                    let v888 = constructor_put_in_xmm(ctx, v872.2);
                                    let v889 = &C::put_in_xmm_mem(ctx, v872.1);
                                    let v890 = constructor_put_in_xmm(ctx, v872.0);
                                    let v961 = constructor_x64_blendvpd(ctx, v888, v889, v890);
                                    let v962 = constructor_output_xmm(ctx, v961);
                                    let v963 = Some(v962);
                                    // Rule at src/isa/x64/lower.isle line 1545.
                                    return v963;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fma => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1977 = C::use_fma(ctx);
                        if v1977 == true {
                            let v872 = C::unpack_value_array_3(ctx, v871);
                            let v1981 = C::def_inst(ctx, v872.2);
                            if let Some(v1982) = v1981 {
                                let v1983 = &C::inst_data(ctx, v1982);
                                if let &InstructionData::Unary {
                                    opcode: ref v1984,
                                    arg: v1985,
                                } = v1983 {
                                    if let &Opcode::Fneg = v1984 {
                                        let v3 = C::value_type(ctx, v2);
                                        let v1986 = constructor_fmsub(ctx, v3, v872.0, v872.1, v1985);
                                        let v1987 = constructor_output_xmm(ctx, v1986);
                                        let v1988 = Some(v1987);
                                        // Rule at src/isa/x64/lower.isle line 2934.
                                        return v1988;
                                    }
                                }
                            }
                            let v3 = C::value_type(ctx, v2);
                            let v1978 = constructor_fmadd(ctx, v3, v872.0, v872.1, v872.2);
                            let v1979 = constructor_output_xmm(ctx, v1978);
                            let v1980 = Some(v1979);
                            // Rule at src/isa/x64/lower.isle line 2903.
                            return v1980;
                        }
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v1908 = C::put_in_reg(ctx, v872.0);
                                let v1909 = C::put_in_reg(ctx, v872.1);
                                let v1910 = C::put_in_reg(ctx, v872.2);
                                let v1911 = C::libcall_3(ctx, &LibCall::FmaF32, v1908, v1909, v1910);
                                let v1912 = constructor_output_reg(ctx, v1911);
                                let v1913 = Some(v1912);
                                // Rule at src/isa/x64/lower.isle line 2858.
                                return v1913;
                            }
                            F64 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v1908 = C::put_in_reg(ctx, v872.0);
                                let v1909 = C::put_in_reg(ctx, v872.1);
                                let v1910 = C::put_in_reg(ctx, v872.2);
                                let v1915 = C::libcall_3(ctx, &LibCall::FmaF64, v1908, v1909, v1910);
                                let v1916 = constructor_output_reg(ctx, v1915);
                                let v1917 = Some(v1916);
                                // Rule at src/isa/x64/lower.isle line 2860.
                                return v1917;
                            }
                            F32X4 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v876 = constructor_put_in_xmm(ctx, v872.0);
                                let v877 = constructor_put_in_xmm(ctx, v872.1);
                                let v1918 = constructor_put_in_xmm(ctx, v872.2);
                                let v1919 = C::xmm_to_reg(ctx, v876);
                                let v1920 = C::xmm_to_reg(ctx, v877);
                                let v1921 = C::xmm_to_reg(ctx, v1918);
                                let v1922 = C::libcall_3(ctx, &LibCall::FmaF32, v1919, v1920, v1921);
                                let v1923 = C::xmm_new(ctx, v1922);
                                let v1924 = &C::xmm_to_xmm_mem(ctx, v876);
                                let v1925 = constructor_x64_pshufd(ctx, v1924, 0x1_u8);
                                let v1926 = C::xmm_to_reg(ctx, v1925);
                                let v1927 = &C::xmm_to_xmm_mem(ctx, v877);
                                let v1928 = constructor_x64_pshufd(ctx, v1927, 0x1_u8);
                                let v1929 = C::xmm_to_reg(ctx, v1928);
                                let v1930 = &C::xmm_to_xmm_mem(ctx, v1918);
                                let v1931 = constructor_x64_pshufd(ctx, v1930, 0x1_u8);
                                let v1932 = C::xmm_to_reg(ctx, v1931);
                                let v1933 = C::libcall_3(ctx, &LibCall::FmaF32, v1926, v1929, v1932);
                                let v1934 = C::xmm_new(ctx, v1933);
                                let v1935 = &C::xmm_to_xmm_mem(ctx, v876);
                                let v1936 = constructor_x64_pshufd(ctx, v1935, 0x2_u8);
                                let v1937 = C::xmm_to_reg(ctx, v1936);
                                let v1938 = &C::xmm_to_xmm_mem(ctx, v877);
                                let v1939 = constructor_x64_pshufd(ctx, v1938, 0x2_u8);
                                let v1940 = C::xmm_to_reg(ctx, v1939);
                                let v1941 = &C::xmm_to_xmm_mem(ctx, v1918);
                                let v1942 = constructor_x64_pshufd(ctx, v1941, 0x2_u8);
                                let v1943 = C::xmm_to_reg(ctx, v1942);
                                let v1944 = C::libcall_3(ctx, &LibCall::FmaF32, v1937, v1940, v1943);
                                let v1945 = C::xmm_new(ctx, v1944);
                                let v1946 = &C::xmm_to_xmm_mem(ctx, v876);
                                let v1947 = constructor_x64_pshufd(ctx, v1946, 0x3_u8);
                                let v1948 = C::xmm_to_reg(ctx, v1947);
                                let v1949 = &C::xmm_to_xmm_mem(ctx, v877);
                                let v1950 = constructor_x64_pshufd(ctx, v1949, 0x3_u8);
                                let v1951 = C::xmm_to_reg(ctx, v1950);
                                let v1952 = &C::xmm_to_xmm_mem(ctx, v1918);
                                let v1953 = constructor_x64_pshufd(ctx, v1952, 0x3_u8);
                                let v1954 = C::xmm_to_reg(ctx, v1953);
                                let v1955 = C::libcall_3(ctx, &LibCall::FmaF32, v1948, v1951, v1954);
                                let v1956 = C::xmm_new(ctx, v1955);
                                let v1957 = constructor_f32x4_insertlane(ctx, v1923, v1934, 0x1_u8);
                                let v1958 = constructor_f32x4_insertlane(ctx, v1957, v1945, 0x2_u8);
                                let v1959 = constructor_f32x4_insertlane(ctx, v1958, v1956, 0x3_u8);
                                let v1960 = constructor_output_xmm(ctx, v1959);
                                let v1961 = Some(v1960);
                                // Rule at src/isa/x64/lower.isle line 2863.
                                return v1961;
                            }
                            F64X2 => {
                                let v872 = C::unpack_value_array_3(ctx, v871);
                                let v876 = constructor_put_in_xmm(ctx, v872.0);
                                let v877 = constructor_put_in_xmm(ctx, v872.1);
                                let v1918 = constructor_put_in_xmm(ctx, v872.2);
                                let v1919 = C::xmm_to_reg(ctx, v876);
                                let v1920 = C::xmm_to_reg(ctx, v877);
                                let v1921 = C::xmm_to_reg(ctx, v1918);
                                let v1962 = C::libcall_3(ctx, &LibCall::FmaF64, v1919, v1920, v1921);
                                let v1963 = C::xmm_new(ctx, v1962);
                                let v1924 = &C::xmm_to_xmm_mem(ctx, v876);
                                let v1965 = constructor_x64_pshufd(ctx, v1924, 0xee_u8);
                                let v1966 = C::xmm_to_reg(ctx, v1965);
                                let v1927 = &C::xmm_to_xmm_mem(ctx, v877);
                                let v1967 = constructor_x64_pshufd(ctx, v1927, 0xee_u8);
                                let v1968 = C::xmm_to_reg(ctx, v1967);
                                let v1930 = &C::xmm_to_xmm_mem(ctx, v1918);
                                let v1969 = constructor_x64_pshufd(ctx, v1930, 0xee_u8);
                                let v1970 = C::xmm_to_reg(ctx, v1969);
                                let v1971 = C::libcall_3(ctx, &LibCall::FmaF64, v1966, v1968, v1970);
                                let v1972 = C::xmm_new(ctx, v1971);
                                let v1973 = &C::xmm_to_xmm_mem(ctx, v1972);
                                let v1974 = constructor_x64_movlhps(ctx, v1963, v1973);
                                let v1975 = constructor_output_xmm(ctx, v1974);
                                let v1976 = Some(v1975);
                                // Rule at src/isa/x64/lower.isle line 2887.
                                return v1976;
                            }
                            _ => {}
                        }
                    }
                }
                _ => {}
            }
        }
        &InstructionData::TernaryImm8 {
            opcode: ref v964,
            args: ref v965,
            imm: v966,
        } => {
            if let &Opcode::Insertlane = v964 {
                let v625 = C::use_sse41(ctx);
                if v625 == true {
                    let v971 = C::u8_from_uimm8(ctx, v966);
                    if v971 == 0x1_u8 {
                        let v967 = C::unpack_value_array_2(ctx, v965);
                        let v1055 = C::def_inst(ctx, v967.0);
                        if let Some(v1056) = v1055 {
                            let v1057 = C::first_result(ctx, v1056);
                            if let Some(v1058) = v1057 {
                                let v1059 = C::value_type(ctx, v1058);
                                if v1059 == I64X2 {
                                    let v1060 = &C::inst_data(ctx, v1056);
                                    if let &InstructionData::Unary {
                                        opcode: ref v1061,
                                        arg: v1062,
                                    } = v1060 {
                                        if let &Opcode::Splat = v1061 {
                                            let v1064 = constructor_put_in_gpr(ctx, v1062);
                                            let v1065 = constructor_bitcast_gpr_to_xmm(ctx, 0x40_u8, v1064);
                                            let v1066 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                            let v1068 = constructor_x64_pinsrq(ctx, v1065, v1066, 0x1_u8);
                                            let v1069 = constructor_output_xmm(ctx, v1068);
                                            let v1070 = Some(v1069);
                                            // Rule at src/isa/x64/lower.isle line 1647.
                                            return v1070;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    let v967 = C::unpack_value_array_2(ctx, v965);
                    let v970 = C::value_type(ctx, v967.0);
                    match v970 {
                        I8X16 => {
                            let v977 = &C::sinkable_load_exact(ctx, v967.1);
                            if let Some(v978) = v977 {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v979 = &constructor_sink_load_to_gpr_mem(ctx, v978);
                                let v980 = constructor_x64_pinsrb(ctx, v972, v979, v971);
                                let v981 = constructor_output_xmm(ctx, v980);
                                let v982 = Some(v981);
                                // Rule at src/isa/x64/lower.isle line 1555.
                                return v982;
                            }
                            let v972 = constructor_put_in_xmm(ctx, v967.0);
                            let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                            let v974 = constructor_x64_pinsrb(ctx, v972, v973, v971);
                            let v975 = constructor_output_xmm(ctx, v974);
                            let v976 = Some(v975);
                            // Rule at src/isa/x64/lower.isle line 1552.
                            return v976;
                        }
                        I32X4 => {
                            let v972 = constructor_put_in_xmm(ctx, v967.0);
                            let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                            let v1013 = constructor_x64_pinsrd(ctx, v972, v973, v971);
                            let v1014 = constructor_output_xmm(ctx, v1013);
                            let v1015 = Some(v1014);
                            // Rule at src/isa/x64/lower.isle line 1607.
                            return v1015;
                        }
                        I64X2 => {
                            let v972 = constructor_put_in_xmm(ctx, v967.0);
                            let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                            let v1044 = constructor_x64_pinsrq(ctx, v972, v973, v971);
                            let v1045 = constructor_output_xmm(ctx, v1044);
                            let v1046 = Some(v1045);
                            // Rule at src/isa/x64/lower.isle line 1636.
                            return v1046;
                        }
                        F32X4 => {
                            let v1071 = &C::sinkable_load(ctx, v967.1);
                            if let Some(v1072) = v1071 {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v1073 = &constructor_sink_load_to_xmm_mem(ctx, v1072);
                                let v1074 = C::sse_insertps_lane_imm(ctx, v971);
                                let v1075 = constructor_x64_insertps(ctx, v972, v1073, v1074);
                                let v1076 = constructor_output_xmm(ctx, v1075);
                                let v1077 = Some(v1076);
                                // Rule at src/isa/x64/lower.isle line 1653.
                                return v1077;
                            }
                        }
                        _ => {}
                    }
                }
                let v967 = C::unpack_value_array_2(ctx, v965);
                let v970 = C::value_type(ctx, v967.0);
                match v970 {
                    I8X16 => {
                        let v972 = constructor_put_in_xmm(ctx, v967.0);
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        let v983 = C::insert_i8x16_lane_hole(ctx, v971);
                        let v984 = &constructor_const_to_xmm_mem(ctx, v983);
                        let v985 = constructor_x64_pand(ctx, v972, v984);
                        let v987 = &constructor_put_in_gpr_mem(ctx, v967.1);
                        let v988 = constructor_x64_movzx(ctx, &ExtMode::BL, v987);
                        let v991 = C::u8_and(ctx, v971, 0x3_u8);
                        let v992 = C::u8_shl(ctx, v991, 0x3_u8);
                        let v993 = Imm8Reg::Imm8 {
                            imm: v992,
                        };
                        let v994 = &C::imm8_reg_to_imm8_gpr(ctx, &v993);
                        let v995 = constructor_x64_shl(ctx, I32, v988, v994);
                        let v996 = &C::gpr_to_gpr_mem(ctx, v995);
                        let v997 = constructor_x64_movd_to_xmm(ctx, v996);
                        let v998 = &C::xmm_to_xmm_mem(ctx, v997);
                        let v1000 = C::u8_shr(ctx, v971, 0x2_u8);
                        let v1001 = constructor_insert_i8x16_lane_pshufd_imm(ctx, v1000);
                        let v1002 = constructor_x64_pshufd(ctx, v998, v1001);
                        let v1003 = &C::xmm_to_xmm_mem(ctx, v1002);
                        let v1004 = constructor_x64_por(ctx, v985, v1003);
                        let v1005 = constructor_output_xmm(ctx, v1004);
                        let v1006 = Some(v1005);
                        // Rule at src/isa/x64/lower.isle line 1583.
                        return v1006;
                    }
                    I16X8 => {
                        let v977 = &C::sinkable_load_exact(ctx, v967.1);
                        if let Some(v978) = v977 {
                            let v972 = constructor_put_in_xmm(ctx, v967.0);
                            let v979 = &constructor_sink_load_to_gpr_mem(ctx, v978);
                            let v971 = C::u8_from_uimm8(ctx, v966);
                            let v1010 = constructor_x64_pinsrw(ctx, v972, v979, v971);
                            let v1011 = constructor_output_xmm(ctx, v1010);
                            let v1012 = Some(v1011);
                            // Rule at src/isa/x64/lower.isle line 1603.
                            return v1012;
                        }
                        let v972 = constructor_put_in_xmm(ctx, v967.0);
                        let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        let v1007 = constructor_x64_pinsrw(ctx, v972, v973, v971);
                        let v1008 = constructor_output_xmm(ctx, v1007);
                        let v1009 = Some(v1008);
                        // Rule at src/isa/x64/lower.isle line 1601.
                        return v1009;
                    }
                    I32X4 => {
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        match v971 {
                            0x0_u8 => {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1016 = constructor_x64_movd_to_xmm(ctx, v973);
                                let v1017 = constructor_x64_movss_regmove(ctx, v972, v1016);
                                let v1018 = constructor_output_xmm(ctx, v1017);
                                let v1019 = Some(v1018);
                                // Rule at src/isa/x64/lower.isle line 1611.
                                return v1019;
                            }
                            0x1_u8 => {
                                let v1020 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1021 = constructor_x64_movd_to_xmm(ctx, v1020);
                                let v1022 = constructor_put_in_xmm(ctx, v967.0);
                                let v1023 = &C::xmm_to_xmm_mem(ctx, v1022);
                                let v1024 = constructor_x64_punpcklqdq(ctx, v1021, v1023);
                                let v1025 = &C::xmm_to_xmm_mem(ctx, v1022);
                                let v1027 = constructor_x64_shufps(ctx, v1024, v1025, 0xe2_u8);
                                let v1028 = constructor_output_xmm(ctx, v1027);
                                let v1029 = Some(v1028);
                                // Rule at src/isa/x64/lower.isle line 1616.
                                return v1029;
                            }
                            0x2_u8 => {
                                let v1020 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1021 = constructor_x64_movd_to_xmm(ctx, v1020);
                                let v1022 = constructor_put_in_xmm(ctx, v967.0);
                                let v1023 = &C::xmm_to_xmm_mem(ctx, v1022);
                                let v1031 = constructor_x64_shufps(ctx, v1021, v1023, 0x30_u8);
                                let v1032 = &C::xmm_to_xmm_mem(ctx, v1031);
                                let v1034 = constructor_x64_shufps(ctx, v1022, v1032, 0x84_u8);
                                let v1035 = constructor_output_xmm(ctx, v1034);
                                let v1036 = Some(v1035);
                                // Rule at src/isa/x64/lower.isle line 1623.
                                return v1036;
                            }
                            0x3_u8 => {
                                let v1020 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1021 = constructor_x64_movd_to_xmm(ctx, v1020);
                                let v1022 = constructor_put_in_xmm(ctx, v967.0);
                                let v1023 = &C::xmm_to_xmm_mem(ctx, v1022);
                                let v1038 = constructor_x64_shufps(ctx, v1021, v1023, 0xe4_u8);
                                let v1039 = &C::xmm_to_xmm_mem(ctx, v1038);
                                let v1041 = constructor_x64_shufps(ctx, v1022, v1039, 0x24_u8);
                                let v1042 = constructor_output_xmm(ctx, v1041);
                                let v1043 = Some(v1042);
                                // Rule at src/isa/x64/lower.isle line 1630.
                                return v1043;
                            }
                            _ => {}
                        }
                    }
                    I64X2 => {
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        match v971 {
                            0x0_u8 => {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1047 = constructor_x64_movq_to_xmm(ctx, v973);
                                let v1048 = constructor_x64_movsd_regmove(ctx, v972, v1047);
                                let v1049 = constructor_output_xmm(ctx, v1048);
                                let v1050 = Some(v1049);
                                // Rule at src/isa/x64/lower.isle line 1639.
                                return v1050;
                            }
                            0x1_u8 => {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v973 = &constructor_put_in_gpr_mem(ctx, v967.1);
                                let v1047 = constructor_x64_movq_to_xmm(ctx, v973);
                                let v1051 = &C::xmm_to_xmm_mem(ctx, v1047);
                                let v1052 = constructor_x64_punpcklqdq(ctx, v972, v1051);
                                let v1053 = constructor_output_xmm(ctx, v1052);
                                let v1054 = Some(v1053);
                                // Rule at src/isa/x64/lower.isle line 1641.
                                return v1054;
                            }
                            _ => {}
                        }
                    }
                    F32X4 => {
                        let v972 = constructor_put_in_xmm(ctx, v967.0);
                        let v1078 = constructor_put_in_xmm(ctx, v967.1);
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        let v1079 = constructor_f32x4_insertlane(ctx, v972, v1078, v971);
                        let v1080 = constructor_output_xmm(ctx, v1079);
                        let v1081 = Some(v1080);
                        // Rule at src/isa/x64/lower.isle line 1656.
                        return v1081;
                    }
                    F64X2 => {
                        let v971 = C::u8_from_uimm8(ctx, v966);
                        match v971 {
                            0x0_u8 => {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v1078 = constructor_put_in_xmm(ctx, v967.1);
                                let v1082 = constructor_x64_movsd_regmove(ctx, v972, v1078);
                                let v1083 = constructor_output_xmm(ctx, v1082);
                                let v1084 = Some(v1083);
                                // Rule at src/isa/x64/lower.isle line 1701.
                                return v1084;
                            }
                            0x1_u8 => {
                                let v972 = constructor_put_in_xmm(ctx, v967.0);
                                let v1085 = &C::put_in_xmm_mem(ctx, v967.1);
                                let v1086 = constructor_x64_movlhps(ctx, v972, v1085);
                                let v1087 = constructor_output_xmm(ctx, v1086);
                                let v1088 = Some(v1087);
                                // Rule at src/isa/x64/lower.isle line 1709.
                                return v1088;
                            }
                            _ => {}
                        }
                    }
                    _ => {}
                }
            }
        }
        &InstructionData::Trap {
            opcode: ref v1160,
            code: ref v1161,
        } => {
            if let &Opcode::Trap = v1160 {
                let v1162 = &constructor_x64_ud2(ctx, v1161);
                let v1163 = constructor_side_effect(ctx, v1162);
                let v1164 = Some(v1163);
                // Rule at src/isa/x64/lower.isle line 1862.
                return v1164;
            }
        }
        &InstructionData::Unary {
            opcode: ref v519,
            arg: v520,
        } => {
            match v519 {
                &Opcode::Splat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            match v90.0 {
                                0x20_u32 => {
                                    if v90.1 == 0x4_u32 {
                                        let v3210 = &C::sinkable_load(ctx, v520);
                                        if let Some(v3211) = v3210 {
                                            let v3291 = C::use_avx(ctx);
                                            if v3291 == true {
                                                let v3292 = &constructor_sink_load_to_xmm_mem(ctx, v3211);
                                                let v3293 = constructor_x64_vbroadcastss(ctx, v3292);
                                                let v3294 = constructor_output_xmm(ctx, v3293);
                                                let v3295 = Some(v3294);
                                                // Rule at src/isa/x64/lower.isle line 4792.
                                                return v3295;
                                            }
                                            let v3214 = &C::sink_load(ctx, v3211);
                                            let v3215 = constructor_x64_movss_load(ctx, v3214);
                                            let v3287 = &C::xmm_to_xmm_mem(ctx, v3215);
                                            let v3288 = constructor_x64_shufps(ctx, v3215, v3287, 0x0_u8);
                                            let v3289 = constructor_output_xmm(ctx, v3288);
                                            let v3290 = Some(v3289);
                                            // Rule at src/isa/x64/lower.isle line 4789.
                                            return v3290;
                                        }
                                    }
                                }
                                0x40_u32 => {
                                    if v90.1 == 0x2_u32 {
                                        let v719 = C::use_ssse3(ctx);
                                        if v719 == true {
                                            let v3210 = &C::sinkable_load(ctx, v520);
                                            if let Some(v3211) = v3210 {
                                                let v3292 = &constructor_sink_load_to_xmm_mem(ctx, v3211);
                                                let v3305 = constructor_x64_movddup(ctx, v3292);
                                                let v3306 = constructor_output_xmm(ctx, v3305);
                                                let v3307 = Some(v3306);
                                                // Rule at src/isa/x64/lower.isle line 4803.
                                                return v3307;
                                            }
                                        }
                                    }
                                }
                                _ => {}
                            }
                        }
                        match v3 {
                            I8X16 => {
                                let v3245 = &C::sinkable_load_exact(ctx, v520);
                                if let Some(v3246) = v3245 {
                                    let v3240 = C::use_avx2(ctx);
                                    if v3240 == true {
                                        let v3252 = &constructor_sink_load_to_xmm_mem(ctx, v3246);
                                        let v3253 = constructor_x64_vpbroadcastb(ctx, v3252);
                                        let v3254 = constructor_output_xmm(ctx, v3253);
                                        let v3255 = Some(v3254);
                                        // Rule at src/isa/x64/lower.isle line 4740.
                                        return v3255;
                                    }
                                    let v625 = C::use_sse41(ctx);
                                    if v625 == true {
                                        let v719 = C::use_ssse3(ctx);
                                        if v719 == true {
                                            let v2032 = constructor_xmm_uninit_value(ctx);
                                            let v3247 = &constructor_sink_load_to_gpr_mem(ctx, v3246);
                                            let v3248 = constructor_x64_pinsrb(ctx, v2032, v3247, 0x0_u8);
                                            let v1382 = constructor_xmm_zero(ctx, I8X16);
                                            let v1383 = &C::xmm_to_xmm_mem(ctx, v1382);
                                            let v3249 = constructor_x64_pshufb(ctx, v3248, v1383);
                                            let v3250 = constructor_output_xmm(ctx, v3249);
                                            let v3251 = Some(v3250);
                                            // Rule at src/isa/x64/lower.isle line 4736.
                                            return v3251;
                                        }
                                    }
                                }
                                let v3240 = C::use_avx2(ctx);
                                if v3240 == true {
                                    let v521 = constructor_put_in_gpr(ctx, v520);
                                    let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                    let v3241 = &C::xmm_to_xmm_mem(ctx, v3234);
                                    let v3242 = constructor_x64_vpbroadcastb(ctx, v3241);
                                    let v3243 = constructor_output_xmm(ctx, v3242);
                                    let v3244 = Some(v3243);
                                    // Rule at src/isa/x64/lower.isle line 4733.
                                    return v3244;
                                }
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v521 = constructor_put_in_gpr(ctx, v520);
                                    let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                    let v3235 = constructor_xmm_zero(ctx, I8X16);
                                    let v3236 = &C::xmm_to_xmm_mem(ctx, v3235);
                                    let v3237 = constructor_x64_pshufb(ctx, v3234, v3236);
                                    let v3238 = constructor_output_xmm(ctx, v3237);
                                    let v3239 = Some(v3238);
                                    // Rule at src/isa/x64/lower.isle line 4730.
                                    return v3239;
                                }
                                let v3223 = &constructor_put_in_gpr_mem(ctx, v520);
                                let v3224 = constructor_x64_movd_to_xmm(ctx, v3223);
                                let v3225 = &C::xmm_to_xmm_mem(ctx, v3224);
                                let v3226 = constructor_x64_punpcklbw(ctx, v3224, v3225);
                                let v3227 = &C::xmm_to_xmm_mem(ctx, v3226);
                                let v3228 = constructor_x64_pshuflw(ctx, v3227, 0x0_u8);
                                let v3229 = &C::xmm_to_xmm_mem(ctx, v3228);
                                let v3230 = constructor_x64_pshufd(ctx, v3229, 0x0_u8);
                                let v3231 = constructor_output_xmm(ctx, v3230);
                                let v3232 = Some(v3231);
                                // Rule at src/isa/x64/lower.isle line 4727.
                                return v3232;
                            }
                            I16X8 => {
                                let v3245 = &C::sinkable_load_exact(ctx, v520);
                                if let Some(v3246) = v3245 {
                                    let v3240 = C::use_avx2(ctx);
                                    if v3240 == true {
                                        let v3252 = &constructor_sink_load_to_xmm_mem(ctx, v3246);
                                        let v3271 = constructor_x64_vpbroadcastw(ctx, v3252);
                                        let v3272 = constructor_output_xmm(ctx, v3271);
                                        let v3273 = Some(v3272);
                                        // Rule at src/isa/x64/lower.isle line 4756.
                                        return v3273;
                                    }
                                    let v2032 = constructor_xmm_uninit_value(ctx);
                                    let v3247 = &constructor_sink_load_to_gpr_mem(ctx, v3246);
                                    let v3264 = constructor_x64_pinsrw(ctx, v2032, v3247, 0x0_u8);
                                    let v3265 = &C::xmm_to_xmm_mem(ctx, v3264);
                                    let v3266 = constructor_x64_pshuflw(ctx, v3265, 0x0_u8);
                                    let v3267 = &C::xmm_to_xmm_mem(ctx, v3266);
                                    let v3268 = constructor_x64_pshufd(ctx, v3267, 0x0_u8);
                                    let v3269 = constructor_output_xmm(ctx, v3268);
                                    let v3270 = Some(v3269);
                                    // Rule at src/isa/x64/lower.isle line 4754.
                                    return v3270;
                                }
                                let v3240 = C::use_avx2(ctx);
                                if v3240 == true {
                                    let v521 = constructor_put_in_gpr(ctx, v520);
                                    let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                    let v3241 = &C::xmm_to_xmm_mem(ctx, v3234);
                                    let v3261 = constructor_x64_vpbroadcastw(ctx, v3241);
                                    let v3262 = constructor_output_xmm(ctx, v3261);
                                    let v3263 = Some(v3262);
                                    // Rule at src/isa/x64/lower.isle line 4751.
                                    return v3263;
                                }
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                let v3241 = &C::xmm_to_xmm_mem(ctx, v3234);
                                let v3256 = constructor_x64_pshuflw(ctx, v3241, 0x0_u8);
                                let v3257 = &C::xmm_to_xmm_mem(ctx, v3256);
                                let v3258 = constructor_x64_pshufd(ctx, v3257, 0x0_u8);
                                let v3259 = constructor_output_xmm(ctx, v3258);
                                let v3260 = Some(v3259);
                                // Rule at src/isa/x64/lower.isle line 4749.
                                return v3260;
                            }
                            I32X4 => {
                                let v3240 = C::use_avx2(ctx);
                                if v3240 == true {
                                    let v521 = constructor_put_in_gpr(ctx, v520);
                                    let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                    let v3241 = &C::xmm_to_xmm_mem(ctx, v3234);
                                    let v3277 = constructor_x64_vpbroadcastd(ctx, v3241);
                                    let v3278 = constructor_output_xmm(ctx, v3277);
                                    let v3279 = Some(v3278);
                                    // Rule at src/isa/x64/lower.isle line 4766.
                                    return v3279;
                                }
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v3234 = constructor_bitcast_gpr_to_xmm(ctx, 0x20_u8, v521);
                                let v3241 = &C::xmm_to_xmm_mem(ctx, v3234);
                                let v3274 = constructor_x64_pshufd(ctx, v3241, 0x0_u8);
                                let v3275 = constructor_output_xmm(ctx, v3274);
                                let v3276 = Some(v3275);
                                // Rule at src/isa/x64/lower.isle line 4764.
                                return v3276;
                            }
                            I64X2 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v3296 = constructor_bitcast_gpr_to_xmm(ctx, 0x40_u8, v521);
                                let v3297 = &C::xmm_to_xmm_mem(ctx, v3296);
                                let v3299 = constructor_x64_pshufd(ctx, v3297, 0x44_u8);
                                let v3300 = constructor_output_xmm(ctx, v3299);
                                let v3301 = Some(v3300);
                                // Rule at src/isa/x64/lower.isle line 4799.
                                return v3301;
                            }
                            F32X4 => {
                                let v3240 = C::use_avx2(ctx);
                                if v3240 == true {
                                    let v720 = &C::put_in_xmm_mem(ctx, v520);
                                    let v3284 = constructor_x64_vbroadcastss(ctx, v720);
                                    let v3285 = constructor_output_xmm(ctx, v3284);
                                    let v3286 = Some(v3285);
                                    // Rule at src/isa/x64/lower.isle line 4776.
                                    return v3286;
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v3280 = constructor_put_in_xmm(ctx, v520);
                                let v538 = &C::put_in_xmm_mem(ctx, v520);
                                let v3281 = constructor_x64_shufps(ctx, v3280, v538, 0x0_u8);
                                let v3282 = constructor_output_xmm(ctx, v3281);
                                let v3283 = Some(v3282);
                                // Rule at src/isa/x64/lower.isle line 4773.
                                return v3283;
                            }
                            F64X2 => {
                                let v720 = &C::put_in_xmm_mem(ctx, v520);
                                let v3302 = constructor_x64_pshufd(ctx, v720, 0x44_u8);
                                let v3303 = constructor_output_xmm(ctx, v3302);
                                let v3304 = Some(v3303);
                                // Rule at src/isa/x64/lower.isle line 4801.
                                return v3304;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::SetPinnedReg => {
                    let v521 = constructor_put_in_gpr(ctx, v520);
                    let v3003 = &constructor_write_pinned_gpr(ctx, v521);
                    let v3004 = constructor_side_effect(ctx, v3003);
                    let v3005 = Some(v3004);
                    // Rule at src/isa/x64/lower.isle line 4444.
                    return v3005;
                }
                &Opcode::VanyTrue => {
                    let v625 = C::use_sse41(ctx);
                    if v625 == true {
                        let v724 = constructor_put_in_xmm(ctx, v520);
                        let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                        let v3308 = &constructor_x64_ptest(ctx, v724, v1822);
                        let v3309 = &constructor_x64_setcc(ctx, &CC::NZ);
                        let v3310 = constructor_with_flags(ctx, v3308, v3309);
                        let v3311 = C::output(ctx, v3310);
                        let v3312 = Some(v3311);
                        // Rule at src/isa/x64/lower.isle line 4809.
                        return v3312;
                    }
                    let v3313 = &constructor_emit_vany_true(ctx, v520);
                    let v3314 = constructor_lower_icmp_bool(ctx, v3313);
                    let v3315 = C::output(ctx, v3314);
                    let v3316 = Some(v3315);
                    // Rule at src/isa/x64/lower.isle line 4818.
                    return v3316;
                }
                &Opcode::VallTrue => {
                    let v3317 = &constructor_emit_vall_true(ctx, v520);
                    let v3318 = constructor_lower_icmp_bool(ctx, v3317);
                    let v3319 = C::output(ctx, v3318);
                    let v3320 = Some(v3319);
                    // Rule at src/isa/x64/lower.isle line 4832.
                    return v3320;
                }
                &Opcode::VhighBits => {
                    let v853 = C::value_type(ctx, v520);
                    let v3321 = C::multi_lane(ctx, v853);
                    if let Some(v3322) = v3321 {
                        match v3322.0 {
                            0x8_u32 => {
                                if v3322.1 == 0x10_u32 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v3326 = constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v724);
                                    let v3327 = constructor_output_gpr(ctx, v3326);
                                    let v3328 = Some(v3327);
                                    // Rule at src/isa/x64/lower.isle line 4863.
                                    return v3328;
                                }
                            }
                            0x10_u32 => {
                                if v3322.1 == 0x8_u32 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                    let v3335 = constructor_x64_packsswb(ctx, v724, v1822);
                                    let v3336 = constructor_x64_pmovmskb(ctx, &OperandSize::Size32, v3335);
                                    let v1676 = Imm8Reg::Imm8 {
                                        imm: 0x8_u8,
                                    };
                                    let v2943 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                                    let v3337 = constructor_x64_shr(ctx, I64, v3336, v2943);
                                    let v3338 = constructor_output_gpr(ctx, v3337);
                                    let v3339 = Some(v3338);
                                    // Rule at src/isa/x64/lower.isle line 4878.
                                    return v3339;
                                }
                            }
                            0x20_u32 => {
                                if v3322.1 == 0x4_u32 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v3329 = constructor_x64_movmskps(ctx, &OperandSize::Size32, v724);
                                    let v3330 = constructor_output_gpr(ctx, v3329);
                                    let v3331 = Some(v3330);
                                    // Rule at src/isa/x64/lower.isle line 4866.
                                    return v3331;
                                }
                            }
                            0x40_u32 => {
                                if v3322.1 == 0x2_u32 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v3332 = constructor_x64_movmskpd(ctx, &OperandSize::Size32, v724);
                                    let v3333 = constructor_output_gpr(ctx, v3332);
                                    let v3334 = Some(v3333);
                                    // Rule at src/isa/x64/lower.isle line 4869.
                                    return v3334;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Ineg => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8X16 => {
                                let v536 = constructor_imm(ctx, I8X16, 0x0_u64);
                                let v537 = C::xmm_new(ctx, v536);
                                let v538 = &C::put_in_xmm_mem(ctx, v520);
                                let v539 = constructor_x64_psubb(ctx, v537, v538);
                                let v540 = constructor_output_xmm(ctx, v539);
                                let v541 = Some(v540);
                                // Rule at src/isa/x64/lower.isle line 977.
                                return v541;
                            }
                            I16X8 => {
                                let v543 = constructor_imm(ctx, I16X8, 0x0_u64);
                                let v544 = C::xmm_new(ctx, v543);
                                let v538 = &C::put_in_xmm_mem(ctx, v520);
                                let v545 = constructor_x64_psubw(ctx, v544, v538);
                                let v546 = constructor_output_xmm(ctx, v545);
                                let v547 = Some(v546);
                                // Rule at src/isa/x64/lower.isle line 980.
                                return v547;
                            }
                            I32X4 => {
                                let v549 = constructor_imm(ctx, I32X4, 0x0_u64);
                                let v550 = C::xmm_new(ctx, v549);
                                let v538 = &C::put_in_xmm_mem(ctx, v520);
                                let v551 = constructor_x64_psubd(ctx, v550, v538);
                                let v552 = constructor_output_xmm(ctx, v551);
                                let v553 = Some(v552);
                                // Rule at src/isa/x64/lower.isle line 983.
                                return v553;
                            }
                            I64X2 => {
                                let v555 = constructor_imm(ctx, I64X2, 0x0_u64);
                                let v556 = C::xmm_new(ctx, v555);
                                let v538 = &C::put_in_xmm_mem(ctx, v520);
                                let v557 = constructor_x64_psubq(ctx, v556, v538);
                                let v558 = constructor_output_xmm(ctx, v557);
                                let v559 = Some(v558);
                                // Rule at src/isa/x64/lower.isle line 986.
                                return v559;
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v522 = constructor_x64_neg(ctx, v5, v521);
                            let v523 = constructor_output_gpr(ctx, v522);
                            let v524 = Some(v523);
                            // Rule at src/isa/x64/lower.isle line 963.
                            return v524;
                        }
                        if v3 == I128 {
                            let v525 = C::put_in_regs(ctx, v520);
                            let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                            let v527 = constructor_value_regs_get_gpr(ctx, v525, 0x1_usize);
                            let v528 = &constructor_x64_neg_paired(ctx, I64, v526);
                            let v529 = constructor_imm(ctx, I64, 0x0_u64);
                            let v530 = C::gpr_new(ctx, v529);
                            let v531 = &C::gpr_to_gpr_mem_imm(ctx, v527);
                            let v532 = &constructor_x64_sbb_paired(ctx, I64, v530, v531);
                            let v533 = constructor_with_flags(ctx, v528, v532);
                            let v534 = C::output(ctx, v533);
                            let v535 = Some(v534);
                            // Rule at src/isa/x64/lower.isle line 966.
                            return v535;
                        }
                    }
                }
                &Opcode::Iabs => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                let v525 = C::put_in_regs(ctx, v520);
                                let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                                let v527 = constructor_value_regs_get_gpr(ctx, v525, 0x1_usize);
                                let v528 = &constructor_x64_neg_paired(ctx, I64, v526);
                                let v529 = constructor_imm(ctx, I64, 0x0_u64);
                                let v786 = &constructor_reg_to_gpr_mem_imm(ctx, v529);
                                let v787 = &constructor_x64_adc_paired(ctx, I64, v527, v786);
                                let v788 = constructor_with_flags(ctx, v528, v787);
                                let v789 = C::value_regs_get(ctx, v788, 0x1_usize);
                                let v790 = C::gpr_new(ctx, v789);
                                let v791 = &constructor_x64_neg_paired(ctx, I64, v790);
                                let v792 = &constructor_produces_flags_ignore(ctx, v791);
                                let v793 = &C::gpr_to_gpr_mem(ctx, v526);
                                let v794 = C::value_regs_get(ctx, v788, 0x0_usize);
                                let v795 = C::gpr_new(ctx, v794);
                                let v796 = &constructor_cmove(ctx, I64, &CC::S, v793, v795);
                                let v797 = &C::gpr_to_gpr_mem(ctx, v527);
                                let v798 = constructor_produces_flags_get_reg(ctx, v791);
                                let v799 = C::gpr_new(ctx, v798);
                                let v800 = &constructor_cmove(ctx, I64, &CC::S, v797, v799);
                                let v801 = &constructor_consumes_flags_concat(ctx, v796, v800);
                                let v802 = constructor_with_flags(ctx, v792, v801);
                                let v803 = C::output(ctx, v802);
                                let v804 = Some(v803);
                                // Rule at src/isa/x64/lower.isle line 1337.
                                return v804;
                            }
                            I8X16 => {
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v720 = &C::put_in_xmm_mem(ctx, v520);
                                    let v721 = constructor_x64_pabsb(ctx, v720);
                                    let v722 = constructor_output_xmm(ctx, v721);
                                    let v723 = Some(v722);
                                    // Rule at src/isa/x64/lower.isle line 1253.
                                    return v723;
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v725 = constructor_xmm_zero(ctx, I8X16);
                                let v726 = &C::xmm_to_xmm_mem(ctx, v724);
                                let v727 = constructor_x64_psubb(ctx, v725, v726);
                                let v728 = &C::xmm_to_xmm_mem(ctx, v727);
                                let v729 = constructor_x64_pminub(ctx, v724, v728);
                                let v730 = constructor_output_xmm(ctx, v729);
                                let v731 = Some(v730);
                                // Rule at src/isa/x64/lower.isle line 1260.
                                return v731;
                            }
                            I16X8 => {
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v720 = &C::put_in_xmm_mem(ctx, v520);
                                    let v732 = constructor_x64_pabsw(ctx, v720);
                                    let v733 = constructor_output_xmm(ctx, v732);
                                    let v734 = Some(v733);
                                    // Rule at src/isa/x64/lower.isle line 1267.
                                    return v734;
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v735 = constructor_xmm_zero(ctx, I16X8);
                                let v726 = &C::xmm_to_xmm_mem(ctx, v724);
                                let v736 = constructor_x64_psubw(ctx, v735, v726);
                                let v737 = &C::xmm_to_xmm_mem(ctx, v736);
                                let v738 = constructor_x64_pmaxsw(ctx, v724, v737);
                                let v739 = constructor_output_xmm(ctx, v738);
                                let v740 = Some(v739);
                                // Rule at src/isa/x64/lower.isle line 1271.
                                return v740;
                            }
                            I32X4 => {
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v720 = &C::put_in_xmm_mem(ctx, v520);
                                    let v741 = constructor_x64_pabsd(ctx, v720);
                                    let v742 = constructor_output_xmm(ctx, v741);
                                    let v743 = Some(v742);
                                    // Rule at src/isa/x64/lower.isle line 1278.
                                    return v743;
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v745 = &C::xmi_imm(ctx, 0x1f_u32);
                                let v746 = constructor_x64_psrad(ctx, v724, v745);
                                let v747 = &C::xmm_to_xmm_mem(ctx, v746);
                                let v748 = constructor_x64_pxor(ctx, v724, v747);
                                let v749 = &C::xmm_to_xmm_mem(ctx, v746);
                                let v750 = constructor_x64_psubd(ctx, v748, v749);
                                let v751 = constructor_output_xmm(ctx, v750);
                                let v752 = Some(v751);
                                // Rule at src/isa/x64/lower.isle line 1288.
                                return v752;
                            }
                            I64X2 => {
                                let v463 = C::use_avx512vl(ctx);
                                if v463 == true {
                                    let v464 = C::use_avx512f(ctx);
                                    if v464 == true {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v753 = constructor_x64_vpabsq(ctx, v720);
                                        let v754 = constructor_output_xmm(ctx, v753);
                                        let v755 = Some(v754);
                                        // Rule at src/isa/x64/lower.isle line 1297.
                                        return v755;
                                    }
                                }
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v756 = constructor_imm(ctx, I64X2, 0x0_u64);
                                    let v757 = C::xmm_new(ctx, v756);
                                    let v758 = &C::xmm_to_xmm_mem(ctx, v724);
                                    let v759 = constructor_x64_psubq(ctx, v757, v758);
                                    let v760 = &C::xmm_to_xmm_mem(ctx, v724);
                                    let v761 = constructor_x64_blendvpd(ctx, v759, v760, v759);
                                    let v762 = constructor_output_xmm(ctx, v761);
                                    let v763 = Some(v762);
                                    // Rule at src/isa/x64/lower.isle line 1306.
                                    return v763;
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v764 = RegMemImm::Imm {
                                    simm32: 0x1f_u32,
                                };
                                let v765 = &C::xmm_mem_imm_new(ctx, &v764);
                                let v766 = constructor_x64_psrad(ctx, v724, v765);
                                let v767 = &C::xmm_to_xmm_mem(ctx, v766);
                                let v769 = constructor_x64_pshufd(ctx, v767, 0xf5_u8);
                                let v770 = &C::xmm_to_xmm_mem(ctx, v769);
                                let v771 = constructor_x64_pxor(ctx, v724, v770);
                                let v772 = &C::xmm_to_xmm_mem(ctx, v769);
                                let v773 = constructor_x64_psubq(ctx, v771, v772);
                                let v774 = constructor_output_xmm(ctx, v773);
                                let v775 = Some(v774);
                                // Rule at src/isa/x64/lower.isle line 1315.
                                return v775;
                            }
                            _ => {}
                        }
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v776 = &constructor_x64_neg_paired(ctx, v5, v521);
                            let v777 = constructor_produces_flags_get_reg(ctx, v776);
                            let v778 = C::gpr_new(ctx, v777);
                            let v780 = &C::gpr_to_gpr_mem(ctx, v521);
                            let v781 = &constructor_cmove(ctx, v5, &CC::S, v780, v778);
                            let v782 = &constructor_produces_flags_ignore(ctx, v776);
                            let v783 = constructor_with_flags_reg(ctx, v782, v781);
                            let v784 = constructor_output_reg(ctx, v783);
                            let v785 = Some(v784);
                            // Rule at src/isa/x64/lower.isle line 1324.
                            return v785;
                        }
                    }
                }
                &Opcode::Bnot => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I128 {
                            let v860 = constructor_i128_not(ctx, v520);
                            let v861 = C::output(ctx, v860);
                            let v862 = Some(v861);
                            // Rule at src/isa/x64/lower.isle line 1454.
                            return v862;
                        }
                        let v89 = C::multi_lane(ctx, v3);
                        if let Some(v90) = v89 {
                            let v724 = constructor_put_in_xmm(ctx, v520);
                            let v817 = constructor_vector_all_ones(ctx);
                            let v863 = &C::xmm_to_xmm_mem(ctx, v817);
                            let v867 = constructor_x64_xor_vector(ctx, v3, v724, v863);
                            let v868 = constructor_output_xmm(ctx, v867);
                            let v869 = Some(v868);
                            // Rule at src/isa/x64/lower.isle line 1464.
                            return v869;
                        }
                        let v237 = C::ty_int_ref_scalar_64(ctx, v3);
                        if let Some(v238) = v237 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v857 = constructor_x64_not(ctx, v3, v521);
                            let v858 = constructor_output_gpr(ctx, v857);
                            let v859 = Some(v858);
                            // Rule at src/isa/x64/lower.isle line 1439.
                            return v859;
                        }
                        let v250 = C::ty_scalar_float(ctx, v3);
                        if let Some(v251) = v250 {
                            let v724 = constructor_put_in_xmm(ctx, v520);
                            let v817 = constructor_vector_all_ones(ctx);
                            let v863 = &C::xmm_to_xmm_mem(ctx, v817);
                            let v864 = constructor_x64_xor_vector(ctx, v251, v724, v863);
                            let v865 = constructor_output_xmm(ctx, v864);
                            let v866 = Some(v865);
                            // Rule at src/isa/x64/lower.isle line 1459.
                            return v866;
                        }
                    }
                }
                &Opcode::Bitrev => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I8 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1654 = constructor_do_bitrev8(ctx, I32, v521);
                                let v1655 = constructor_output_gpr(ctx, v1654);
                                let v1656 = Some(v1655);
                                // Rule at src/isa/x64/lower.isle line 2433.
                                return v1656;
                            }
                            I16 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1657 = constructor_do_bitrev16(ctx, I32, v521);
                                let v1658 = constructor_output_gpr(ctx, v1657);
                                let v1659 = Some(v1658);
                                // Rule at src/isa/x64/lower.isle line 2436.
                                return v1659;
                            }
                            I32 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1660 = constructor_do_bitrev32(ctx, I32, v521);
                                let v1661 = constructor_output_gpr(ctx, v1660);
                                let v1662 = Some(v1661);
                                // Rule at src/isa/x64/lower.isle line 2439.
                                return v1662;
                            }
                            I64 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1663 = constructor_do_bitrev64(ctx, I64, v521);
                                let v1664 = constructor_output_gpr(ctx, v1663);
                                let v1665 = Some(v1664);
                                // Rule at src/isa/x64/lower.isle line 2442.
                                return v1665;
                            }
                            I128 => {
                                let v525 = C::put_in_regs(ctx, v520);
                                let v1529 = constructor_value_regs_get_gpr(ctx, v525, 0x1_usize);
                                let v1666 = constructor_do_bitrev64(ctx, I64, v1529);
                                let v1667 = C::gpr_to_reg(ctx, v1666);
                                let v1668 = C::put_in_regs(ctx, v520);
                                let v1669 = constructor_value_regs_get_gpr(ctx, v1668, 0x0_usize);
                                let v1670 = constructor_do_bitrev64(ctx, I64, v1669);
                                let v1671 = C::gpr_to_reg(ctx, v1670);
                                let v1672 = C::value_regs(ctx, v1667, v1671);
                                let v1673 = C::output(ctx, v1672);
                                let v1674 = Some(v1673);
                                // Rule at src/isa/x64/lower.isle line 2445.
                                return v1674;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Clz => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v1513 = constructor_do_clz(ctx, v68, v68, v521);
                            let v1514 = constructor_output_gpr(ctx, v1513);
                            let v1515 = Some(v1514);
                            // Rule at src/isa/x64/lower.isle line 2206.
                            return v1515;
                        }
                        let v1516 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1517) = v1516 {
                            let v1518 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Zero);
                            let v1519 = constructor_do_clz(ctx, I64, I64, v1518);
                            let v1521 = C::ty_bits(ctx, v1517);
                            let v1522 = C::u8_as_u32(ctx, v1521);
                            let v1523 = C::u32_sub(ctx, 0x40_u32, v1522);
                            let v1524 = RegMemImm::Imm {
                                simm32: v1523,
                            };
                            let v1525 = &C::gpr_mem_imm_new(ctx, &v1524);
                            let v1526 = constructor_x64_sub(ctx, I64, v1519, v1525);
                            let v1527 = constructor_output_gpr(ctx, v1526);
                            let v1528 = Some(v1527);
                            // Rule at src/isa/x64/lower.isle line 2209.
                            return v1528;
                        }
                        if v3 == I128 {
                            let v525 = C::put_in_regs(ctx, v520);
                            let v1529 = constructor_value_regs_get_gpr(ctx, v525, 0x1_usize);
                            let v1530 = constructor_do_clz(ctx, I64, I64, v1529);
                            let v1531 = C::put_in_regs(ctx, v520);
                            let v1532 = constructor_value_regs_get_gpr(ctx, v1531, 0x0_usize);
                            let v1533 = constructor_do_clz(ctx, I64, I64, v1532);
                            let v1534 = RegMemImm::Imm {
                                simm32: 0x40_u32,
                            };
                            let v1535 = &C::gpr_mem_imm_new(ctx, &v1534);
                            let v1536 = constructor_x64_add(ctx, I64, v1533, v1535);
                            let v1538 = &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, v1530, 0x40_u32);
                            let v1539 = &C::gpr_to_gpr_mem(ctx, v1530);
                            let v1540 = &constructor_cmove(ctx, I64, &CC::NZ, v1539, v1536);
                            let v1541 = constructor_with_flags_reg(ctx, v1538, v1540);
                            let v1542 = C::gpr_new(ctx, v1541);
                            let v1543 = C::gpr_to_reg(ctx, v1542);
                            let v1544 = constructor_imm(ctx, I64, 0x0_u64);
                            let v1545 = C::value_regs(ctx, v1543, v1544);
                            let v1546 = C::output(ctx, v1545);
                            let v1547 = Some(v1546);
                            // Rule at src/isa/x64/lower.isle line 2215.
                            return v1547;
                        }
                    }
                }
                &Opcode::Ctz => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v1548 = constructor_do_ctz(ctx, v68, v68, v521);
                            let v1549 = constructor_output_gpr(ctx, v1548);
                            let v1550 = Some(v1549);
                            // Rule at src/isa/x64/lower.isle line 2246.
                            return v1550;
                        }
                        let v1516 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1517) = v1516 {
                            let v1551 = constructor_extend_to_gpr(ctx, v520, I32, &ExtendKind::Zero);
                            let v1521 = C::ty_bits(ctx, v1517);
                            let v1522 = C::u8_as_u32(ctx, v1521);
                            let v1552 = C::u32_shl(ctx, 0x1_u32, v1522);
                            let v1553 = RegMemImm::Imm {
                                simm32: v1552,
                            };
                            let v1554 = &C::gpr_mem_imm_new(ctx, &v1553);
                            let v1555 = constructor_x64_or(ctx, I32, v1551, v1554);
                            let v1556 = constructor_do_ctz(ctx, I32, v1517, v1555);
                            let v1557 = constructor_output_gpr(ctx, v1556);
                            let v1558 = Some(v1557);
                            // Rule at src/isa/x64/lower.isle line 2249.
                            return v1558;
                        }
                        if v3 == I128 {
                            let v525 = C::put_in_regs(ctx, v520);
                            let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                            let v1559 = constructor_do_ctz(ctx, I64, I64, v526);
                            let v1531 = C::put_in_regs(ctx, v520);
                            let v1560 = constructor_value_regs_get_gpr(ctx, v1531, 0x1_usize);
                            let v1561 = constructor_do_ctz(ctx, I64, I64, v1560);
                            let v1534 = RegMemImm::Imm {
                                simm32: 0x40_u32,
                            };
                            let v1535 = &C::gpr_mem_imm_new(ctx, &v1534);
                            let v1562 = constructor_x64_add(ctx, I64, v1561, v1535);
                            let v1563 = &constructor_x64_cmp_imm(ctx, &OperandSize::Size64, v1559, 0x40_u32);
                            let v1564 = &C::gpr_to_gpr_mem(ctx, v1562);
                            let v1565 = &constructor_cmove(ctx, I64, &CC::Z, v1564, v1559);
                            let v1566 = constructor_with_flags_reg(ctx, v1563, v1565);
                            let v1567 = C::gpr_new(ctx, v1566);
                            let v1568 = C::gpr_to_reg(ctx, v1567);
                            let v1544 = constructor_imm(ctx, I64, 0x0_u64);
                            let v1569 = C::value_regs(ctx, v1568, v1544);
                            let v1570 = C::output(ctx, v1569);
                            let v1571 = Some(v1570);
                            // Rule at src/isa/x64/lower.isle line 2254.
                            return v1571;
                        }
                    }
                }
                &Opcode::Bswap => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1676 = Imm8Reg::Imm8 {
                                    imm: 0x8_u8,
                                };
                                let v1677 = &C::imm8_reg_to_imm8_gpr(ctx, &v1676);
                                let v1678 = constructor_x64_rotl(ctx, I16, v521, v1677);
                                let v1679 = constructor_output_gpr(ctx, v1678);
                                let v1680 = Some(v1679);
                                // Rule at src/isa/x64/lower.isle line 2512.
                                return v1680;
                            }
                            I32 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1681 = constructor_x64_bswap(ctx, I32, v521);
                                let v1682 = constructor_output_gpr(ctx, v1681);
                                let v1683 = Some(v1682);
                                // Rule at src/isa/x64/lower.isle line 2515.
                                return v1683;
                            }
                            I64 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1684 = constructor_x64_bswap(ctx, I64, v521);
                                let v1685 = constructor_output_gpr(ctx, v1684);
                                let v1686 = Some(v1685);
                                // Rule at src/isa/x64/lower.isle line 2518.
                                return v1686;
                            }
                            I128 => {
                                let v525 = C::put_in_regs(ctx, v520);
                                let v1529 = constructor_value_regs_get_gpr(ctx, v525, 0x1_usize);
                                let v1687 = constructor_x64_bswap(ctx, I64, v1529);
                                let v1688 = C::gpr_to_reg(ctx, v1687);
                                let v1668 = C::put_in_regs(ctx, v520);
                                let v1669 = constructor_value_regs_get_gpr(ctx, v1668, 0x0_usize);
                                let v1689 = constructor_x64_bswap(ctx, I64, v1669);
                                let v1690 = C::gpr_to_reg(ctx, v1689);
                                let v1691 = C::value_regs(ctx, v1688, v1690);
                                let v1692 = C::output(ctx, v1691);
                                let v1693 = Some(v1692);
                                // Rule at src/isa/x64/lower.isle line 2521.
                                return v1693;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Popcnt => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v1572 = C::use_popcnt(ctx);
                        if v1572 == true {
                            let v3 = C::value_type(ctx, v2);
                            let v67 = C::ty_32_or_64(ctx, v3);
                            if let Some(v68) = v67 {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v1573 = constructor_x64_popcnt(ctx, v68, v521);
                                let v1574 = constructor_output_gpr(ctx, v1573);
                                let v1575 = Some(v1574);
                                // Rule at src/isa/x64/lower.isle line 2280.
                                return v1575;
                            }
                            let v1516 = C::ty_8_or_16(ctx, v3);
                            if let Some(v1517) = v1516 {
                                let v1551 = constructor_extend_to_gpr(ctx, v520, I32, &ExtendKind::Zero);
                                let v1576 = constructor_x64_popcnt(ctx, I32, v1551);
                                let v1577 = constructor_output_gpr(ctx, v1576);
                                let v1578 = Some(v1577);
                                // Rule at src/isa/x64/lower.isle line 2284.
                                return v1578;
                            }
                        }
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I128 => {
                                if v1572 == true {
                                    let v525 = C::put_in_regs(ctx, v520);
                                    let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                                    let v1579 = constructor_x64_popcnt(ctx, I64, v526);
                                    let v1531 = C::put_in_regs(ctx, v520);
                                    let v1560 = constructor_value_regs_get_gpr(ctx, v1531, 0x1_usize);
                                    let v1580 = constructor_x64_popcnt(ctx, I64, v1560);
                                    let v1581 = &C::gpr_to_gpr_mem_imm(ctx, v1580);
                                    let v1582 = constructor_x64_add(ctx, I64, v1579, v1581);
                                    let v1583 = C::gpr_to_reg(ctx, v1582);
                                    let v1584 = constructor_imm(ctx, I64, 0x0_u64);
                                    let v1585 = C::value_regs(ctx, v1583, v1584);
                                    let v1586 = C::output(ctx, v1585);
                                    let v1587 = Some(v1586);
                                    // Rule at src/isa/x64/lower.isle line 2288.
                                    return v1587;
                                }
                                let v525 = C::put_in_regs(ctx, v520);
                                let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                                let v1594 = constructor_do_popcnt(ctx, I64, v526);
                                let v1531 = C::put_in_regs(ctx, v520);
                                let v1560 = constructor_value_regs_get_gpr(ctx, v1531, 0x1_usize);
                                let v1595 = constructor_do_popcnt(ctx, I64, v1560);
                                let v1596 = &C::gpr_to_gpr_mem_imm(ctx, v1595);
                                let v1597 = constructor_x64_add(ctx, I64, v1594, v1596);
                                let v1598 = C::gpr_to_reg(ctx, v1597);
                                let v1584 = constructor_imm(ctx, I64, 0x0_u64);
                                let v1599 = C::value_regs(ctx, v1598, v1584);
                                let v1600 = C::output(ctx, v1599);
                                let v1601 = Some(v1600);
                                // Rule at src/isa/x64/lower.isle line 2304.
                                return v1601;
                            }
                            I8X16 => {
                                let v463 = C::use_avx512vl(ctx);
                                if v463 == true {
                                    let v1602 = C::use_avx512bitalg(ctx);
                                    if v1602 == true {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v1603 = constructor_x64_vpopcntb(ctx, v720);
                                        let v1604 = constructor_output_xmm(ctx, v1603);
                                        let v1605 = Some(v1604);
                                        // Rule at src/isa/x64/lower.isle line 2377.
                                        return v1605;
                                    }
                                }
                                let v719 = C::use_ssse3(ctx);
                                if v719 == true {
                                    let v1607 = C::emit_u128_le_const(ctx, 0xf0f0f0f0f0f0f0f0f0f0f0f0f0f0f0f_u128);
                                    let v1608 = &constructor_const_to_xmm_mem(ctx, v1607);
                                    let v1609 = constructor_put_in_xmm(ctx, v520);
                                    let v1610 = constructor_sse_and(ctx, I8X16, v1609, v1608);
                                    let v1611 = constructor_put_in_xmm(ctx, v520);
                                    let v1613 = &C::xmi_imm(ctx, 0x4_u32);
                                    let v1614 = constructor_x64_psrlw(ctx, v1611, v1613);
                                    let v1615 = constructor_sse_and(ctx, I8X16, v1614, v1608);
                                    let v1617 = C::emit_u128_le_const(ctx, 0x4030302030202010302020102010100_u128);
                                    let v1618 = constructor_x64_xmm_load_const(ctx, I8X16, v1617);
                                    let v1619 = &C::xmm_to_xmm_mem(ctx, v1610);
                                    let v1620 = constructor_x64_pshufb(ctx, v1618, v1619);
                                    let v1621 = &C::xmm_to_xmm_mem(ctx, v1615);
                                    let v1622 = constructor_x64_pshufb(ctx, v1618, v1621);
                                    let v1623 = &C::xmm_to_xmm_mem(ctx, v1622);
                                    let v1624 = constructor_x64_paddb(ctx, v1620, v1623);
                                    let v1625 = constructor_output_xmm(ctx, v1624);
                                    let v1626 = Some(v1625);
                                    // Rule at src/isa/x64/lower.isle line 2403.
                                    return v1626;
                                }
                                let v1628 = C::emit_u128_le_const(ctx, 0x77777777777777777777777777777777_u128);
                                let v1629 = &constructor_const_to_xmm_mem(ctx, v1628);
                                let v1609 = constructor_put_in_xmm(ctx, v520);
                                let v1630 = &C::xmi_imm(ctx, 0x1_u32);
                                let v1631 = constructor_x64_psrlq(ctx, v1609, v1630);
                                let v1632 = constructor_x64_pand(ctx, v1631, v1629);
                                let v1633 = &C::xmm_to_xmm_mem(ctx, v1632);
                                let v1634 = constructor_x64_psubb(ctx, v1609, v1633);
                                let v1635 = &C::xmi_imm(ctx, 0x1_u32);
                                let v1636 = constructor_x64_psrlq(ctx, v1632, v1635);
                                let v1637 = constructor_x64_pand(ctx, v1636, v1629);
                                let v1638 = &C::xmm_to_xmm_mem(ctx, v1637);
                                let v1639 = constructor_x64_psubb(ctx, v1634, v1638);
                                let v1640 = &C::xmi_imm(ctx, 0x1_u32);
                                let v1641 = constructor_x64_psrlq(ctx, v1637, v1640);
                                let v1642 = constructor_x64_pand(ctx, v1641, v1629);
                                let v1643 = &C::xmm_to_xmm_mem(ctx, v1642);
                                let v1644 = constructor_x64_psubb(ctx, v1639, v1643);
                                let v1645 = &C::xmi_imm(ctx, 0x4_u32);
                                let v1646 = constructor_x64_psrlw(ctx, v1644, v1645);
                                let v1647 = &C::xmm_to_xmm_mem(ctx, v1646);
                                let v1648 = constructor_x64_paddb(ctx, v1644, v1647);
                                let v1649 = C::emit_u128_le_const(ctx, 0xf0f0f0f0f0f0f0f0f0f0f0f0f0f0f0f_u128);
                                let v1650 = &constructor_const_to_xmm_mem(ctx, v1649);
                                let v1651 = constructor_x64_pand(ctx, v1648, v1650);
                                let v1652 = constructor_output_xmm(ctx, v1651);
                                let v1653 = Some(v1652);
                                // Rule at src/isa/x64/lower.isle line 2419.
                                return v1653;
                            }
                            _ => {}
                        }
                        let v67 = C::ty_32_or_64(ctx, v3);
                        if let Some(v68) = v67 {
                            let v521 = constructor_put_in_gpr(ctx, v520);
                            let v1588 = constructor_do_popcnt(ctx, v68, v521);
                            let v1589 = constructor_output_gpr(ctx, v1588);
                            let v1590 = Some(v1589);
                            // Rule at src/isa/x64/lower.isle line 2294.
                            return v1590;
                        }
                        let v1516 = C::ty_8_or_16(ctx, v3);
                        if let Some(v1517) = v1516 {
                            let v1551 = constructor_extend_to_gpr(ctx, v520, I32, &ExtendKind::Zero);
                            let v1591 = constructor_do_popcnt(ctx, I32, v1551);
                            let v1592 = constructor_output_gpr(ctx, v1591);
                            let v1593 = Some(v1592);
                            // Rule at src/isa/x64/lower.isle line 2299.
                            return v1593;
                        }
                    }
                }
                &Opcode::Sqrt => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v1803 = constructor_xmm_zero(ctx, F32X4);
                                let v1804 = &C::put_in_xmm_mem(ctx, v520);
                                let v1805 = constructor_x64_sqrtss(ctx, v1803, v1804);
                                let v1806 = constructor_output_xmm(ctx, v1805);
                                let v1807 = Some(v1806);
                                // Rule at src/isa/x64/lower.isle line 2651.
                                return v1807;
                            }
                            F64 => {
                                let v1809 = constructor_xmm_zero(ctx, F64X2);
                                let v1804 = &C::put_in_xmm_mem(ctx, v520);
                                let v1810 = constructor_x64_sqrtsd(ctx, v1809, v1804);
                                let v1811 = constructor_output_xmm(ctx, v1810);
                                let v1812 = Some(v1811);
                                // Rule at src/isa/x64/lower.isle line 2653.
                                return v1812;
                            }
                            F32X4 => {
                                let v720 = &C::put_in_xmm_mem(ctx, v520);
                                let v1813 = constructor_x64_sqrtps(ctx, v720);
                                let v1814 = constructor_output_xmm(ctx, v1813);
                                let v1815 = Some(v1814);
                                // Rule at src/isa/x64/lower.isle line 2655.
                                return v1815;
                            }
                            F64X2 => {
                                let v720 = &C::put_in_xmm_mem(ctx, v520);
                                let v1816 = constructor_x64_sqrtpd(ctx, v720);
                                let v1817 = constructor_output_xmm(ctx, v1816);
                                let v1818 = Some(v1817);
                                // Rule at src/isa/x64/lower.isle line 2657.
                                return v1818;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fneg => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v830 = constructor_imm(ctx, F32, 0x80000000_u64);
                                let v831 = &constructor_reg_to_xmm_mem(ctx, v830);
                                let v832 = constructor_x64_xorps(ctx, v724, v831);
                                let v833 = constructor_output_xmm(ctx, v832);
                                let v834 = Some(v833);
                                // Rule at src/isa/x64/lower.isle line 1377.
                                return v834;
                            }
                            F64 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v836 = constructor_imm(ctx, F64, 0x8000000000000000_u64);
                                let v837 = &constructor_reg_to_xmm_mem(ctx, v836);
                                let v838 = constructor_x64_xorpd(ctx, v724, v837);
                                let v839 = constructor_output_xmm(ctx, v838);
                                let v840 = Some(v839);
                                // Rule at src/isa/x64/lower.isle line 1380.
                                return v840;
                            }
                            F32X4 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v817 = constructor_vector_all_ones(ctx);
                                let v841 = &C::xmi_imm(ctx, 0x1f_u32);
                                let v842 = constructor_x64_pslld(ctx, v817, v841);
                                let v843 = &C::xmm_to_xmm_mem(ctx, v842);
                                let v844 = constructor_x64_xorps(ctx, v724, v843);
                                let v845 = constructor_output_xmm(ctx, v844);
                                let v846 = Some(v845);
                                // Rule at src/isa/x64/lower.isle line 1383.
                                return v846;
                            }
                            F64X2 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v817 = constructor_vector_all_ones(ctx);
                                let v847 = &C::xmi_imm(ctx, 0x3f_u32);
                                let v848 = constructor_x64_psllq(ctx, v817, v847);
                                let v849 = &C::xmm_to_xmm_mem(ctx, v848);
                                let v850 = constructor_x64_xorpd(ctx, v724, v849);
                                let v851 = constructor_output_xmm(ctx, v850);
                                let v852 = Some(v851);
                                // Rule at src/isa/x64/lower.isle line 1387.
                                return v852;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Fabs => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v806 = constructor_imm(ctx, F32, 0x7fffffff_u64);
                                let v807 = &constructor_reg_to_xmm_mem(ctx, v806);
                                let v808 = constructor_x64_andps(ctx, v724, v807);
                                let v809 = constructor_output_xmm(ctx, v808);
                                let v810 = Some(v809);
                                // Rule at src/isa/x64/lower.isle line 1359.
                                return v810;
                            }
                            F64 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v812 = constructor_imm(ctx, F64, 0x7fffffffffffffff_u64);
                                let v813 = &constructor_reg_to_xmm_mem(ctx, v812);
                                let v814 = constructor_x64_andpd(ctx, v724, v813);
                                let v815 = constructor_output_xmm(ctx, v814);
                                let v816 = Some(v815);
                                // Rule at src/isa/x64/lower.isle line 1362.
                                return v816;
                            }
                            F32X4 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v817 = constructor_vector_all_ones(ctx);
                                let v818 = &C::xmi_imm(ctx, 0x1_u32);
                                let v819 = constructor_x64_psrld(ctx, v817, v818);
                                let v820 = &C::xmm_to_xmm_mem(ctx, v819);
                                let v821 = constructor_x64_andps(ctx, v724, v820);
                                let v822 = constructor_output_xmm(ctx, v821);
                                let v823 = Some(v822);
                                // Rule at src/isa/x64/lower.isle line 1366.
                                return v823;
                            }
                            F64X2 => {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v817 = constructor_vector_all_ones(ctx);
                                let v818 = &C::xmi_imm(ctx, 0x1_u32);
                                let v824 = constructor_x64_psrlq(ctx, v817, v818);
                                let v825 = &C::xmm_to_xmm_mem(ctx, v824);
                                let v826 = constructor_x64_andpd(ctx, v724, v825);
                                let v827 = constructor_output_xmm(ctx, v826);
                                let v828 = Some(v827);
                                // Rule at src/isa/x64/lower.isle line 1371.
                                return v828;
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Ceil => {
                    let v2888 = &C::put_in_reg_mem(ctx, v520);
                    let v853 = C::value_type(ctx, v520);
                    let v2890 = constructor_x64_round(ctx, v853, v2888, &RoundImm::RoundUp);
                    let v2891 = constructor_output_xmm(ctx, v2890);
                    let v2892 = Some(v2891);
                    // Rule at src/isa/x64/lower.isle line 4260.
                    return v2892;
                }
                &Opcode::Floor => {
                    let v2888 = &C::put_in_reg_mem(ctx, v520);
                    let v853 = C::value_type(ctx, v520);
                    let v2894 = constructor_x64_round(ctx, v853, v2888, &RoundImm::RoundDown);
                    let v2895 = constructor_output_xmm(ctx, v2894);
                    let v2896 = Some(v2895);
                    // Rule at src/isa/x64/lower.isle line 4265.
                    return v2896;
                }
                &Opcode::Trunc => {
                    let v2888 = &C::put_in_reg_mem(ctx, v520);
                    let v853 = C::value_type(ctx, v520);
                    let v2902 = constructor_x64_round(ctx, v853, v2888, &RoundImm::RoundZero);
                    let v2903 = constructor_output_xmm(ctx, v2902);
                    let v2904 = Some(v2903);
                    // Rule at src/isa/x64/lower.isle line 4275.
                    return v2904;
                }
                &Opcode::Nearest => {
                    let v2888 = &C::put_in_reg_mem(ctx, v520);
                    let v853 = C::value_type(ctx, v520);
                    let v2898 = constructor_x64_round(ctx, v853, v2888, &RoundImm::RoundNearest);
                    let v2899 = constructor_output_xmm(ctx, v2898);
                    let v2900 = Some(v2899);
                    // Rule at src/isa/x64/lower.isle line 4270.
                    return v2900;
                }
                &Opcode::ScalarToVector => {
                    let v3210 = &C::sinkable_load(ctx, v520);
                    if let Some(v3211) = v3210 {
                        let v853 = C::value_type(ctx, v520);
                        let v3218 = C::ty_64(ctx, v853);
                        if let Some(v3219) = v3218 {
                            let v3214 = &C::sink_load(ctx, v3211);
                            let v3220 = constructor_x64_movsd_load(ctx, v3214);
                            let v3221 = constructor_output_xmm(ctx, v3220);
                            let v3222 = Some(v3221);
                            // Rule at src/isa/x64/lower.isle line 4711.
                            return v3222;
                        }
                        let v3212 = C::ty_32(ctx, v853);
                        if let Some(v3213) = v3212 {
                            let v3214 = &C::sink_load(ctx, v3211);
                            let v3215 = constructor_x64_movss_load(ctx, v3214);
                            let v3216 = constructor_output_xmm(ctx, v3215);
                            let v3217 = Some(v3216);
                            // Rule at src/isa/x64/lower.isle line 4709.
                            return v3217;
                        }
                    }
                    let v853 = C::value_type(ctx, v520);
                    let v2565 = C::ty_scalar_float(ctx, v853);
                    if let Some(v2566) = v2565 {
                        let v1717 = constructor_output_value(ctx, v520);
                        let v1718 = Some(v1717);
                        // Rule at src/isa/x64/lower.isle line 4699.
                        return v1718;
                    }
                    let v521 = constructor_put_in_gpr(ctx, v520);
                    let v3206 = C::ty_bits(ctx, v853);
                    let v3207 = constructor_bitcast_gpr_to_xmm(ctx, v3206, v521);
                    let v3208 = constructor_output_xmm(ctx, v3207);
                    let v3209 = Some(v3208);
                    // Rule at src/isa/x64/lower.isle line 4704.
                    return v3209;
                }
                &Opcode::Bmask => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v525 = C::put_in_regs(ctx, v520);
                        let v3 = C::value_type(ctx, v2);
                        let v853 = C::value_type(ctx, v520);
                        let v854 = constructor_lower_bmask(ctx, v3, v853, v525);
                        let v855 = C::output(ctx, v854);
                        let v856 = Some(v855);
                        // Rule at src/isa/x64/lower.isle line 1432.
                        return v856;
                    }
                }
                &Opcode::Ireduce => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        let v4 = C::fits_in_64(ctx, v3);
                        if let Some(v5) = v4 {
                            let v525 = C::put_in_regs(ctx, v520);
                            let v526 = constructor_value_regs_get_gpr(ctx, v525, 0x0_usize);
                            let v1719 = constructor_output_gpr(ctx, v526);
                            let v1720 = Some(v1719);
                            // Rule at src/isa/x64/lower.isle line 2570.
                            return v1720;
                        }
                        let v853 = C::value_type(ctx, v520);
                        if v3 == v853 {
                            let v1717 = constructor_output_value(ctx, v520);
                            let v1718 = Some(v1717);
                            // Rule at src/isa/x64/lower.isle line 2564.
                            return v1718;
                        }
                    }
                }
                &Opcode::SwidenLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I8X16 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2741 = constructor_x64_pmovsxbw(ctx, v720);
                                        let v2742 = constructor_output_xmm(ctx, v2741);
                                        let v2743 = Some(v2742);
                                        // Rule at src/isa/x64/lower.isle line 3979.
                                        return v2743;
                                    }
                                }
                            }
                            I32X4 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I16X8 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2744 = constructor_x64_pmovsxwd(ctx, v720);
                                        let v2745 = constructor_output_xmm(ctx, v2744);
                                        let v2746 = Some(v2745);
                                        // Rule at src/isa/x64/lower.isle line 3982.
                                        return v2746;
                                    }
                                }
                            }
                            I64X2 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I32X4 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2747 = constructor_x64_pmovsxdq(ctx, v720);
                                        let v2748 = constructor_output_xmm(ctx, v2747);
                                        let v2749 = Some(v2748);
                                        // Rule at src/isa/x64/lower.isle line 3985.
                                        return v2749;
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v724 = constructor_put_in_xmm(ctx, v520);
                        let v2750 = constructor_lower_swiden_low(ctx, v3, v724);
                        let v2751 = constructor_output_xmm(ctx, v2750);
                        let v2752 = Some(v2751);
                        // Rule at src/isa/x64/lower.isle line 3989.
                        return v2752;
                    }
                }
                &Opcode::SwidenHigh => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I8X16 {
                                    let v625 = C::use_sse41(ctx);
                                    if v625 == true {
                                        let v719 = C::use_ssse3(ctx);
                                        if v719 == true {
                                            let v724 = constructor_put_in_xmm(ctx, v520);
                                            let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                            let v2753 = constructor_x64_palignr(ctx, v724, v1822, 0x8_u8);
                                            let v2754 = &C::xmm_to_xmm_mem(ctx, v2753);
                                            let v2755 = constructor_x64_pmovsxbw(ctx, v2754);
                                            let v2756 = constructor_output_xmm(ctx, v2755);
                                            let v2757 = Some(v2756);
                                            // Rule at src/isa/x64/lower.isle line 4012.
                                            return v2757;
                                        }
                                    }
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                    let v2766 = constructor_x64_punpckhbw(ctx, v724, v1822);
                                    let v2767 = &C::xmi_imm(ctx, 0x8_u32);
                                    let v2768 = constructor_x64_psraw(ctx, v2766, v2767);
                                    let v2769 = constructor_output_xmm(ctx, v2768);
                                    let v2770 = Some(v2769);
                                    // Rule at src/isa/x64/lower.isle line 4028.
                                    return v2770;
                                }
                            }
                            I32X4 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I16X8 {
                                    let v625 = C::use_sse41(ctx);
                                    if v625 == true {
                                        let v719 = C::use_ssse3(ctx);
                                        if v719 == true {
                                            let v724 = constructor_put_in_xmm(ctx, v520);
                                            let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                            let v2753 = constructor_x64_palignr(ctx, v724, v1822, 0x8_u8);
                                            let v2754 = &C::xmm_to_xmm_mem(ctx, v2753);
                                            let v2758 = constructor_x64_pmovsxwd(ctx, v2754);
                                            let v2759 = constructor_output_xmm(ctx, v2758);
                                            let v2760 = Some(v2759);
                                            // Rule at src/isa/x64/lower.isle line 4017.
                                            return v2760;
                                        }
                                    }
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                    let v2771 = constructor_x64_punpckhwd(ctx, v724, v1822);
                                    let v2549 = &C::xmi_imm(ctx, 0x10_u32);
                                    let v2772 = constructor_x64_psrad(ctx, v2771, v2549);
                                    let v2773 = constructor_output_xmm(ctx, v2772);
                                    let v2774 = Some(v2773);
                                    // Rule at src/isa/x64/lower.isle line 4031.
                                    return v2774;
                                }
                            }
                            I64X2 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I32X4 {
                                    let v625 = C::use_sse41(ctx);
                                    if v625 == true {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2761 = constructor_x64_pshufd(ctx, v720, 0xee_u8);
                                        let v2762 = &C::xmm_to_xmm_mem(ctx, v2761);
                                        let v2763 = constructor_x64_pmovsxdq(ctx, v2762);
                                        let v2764 = constructor_output_xmm(ctx, v2763);
                                        let v2765 = Some(v2764);
                                        // Rule at src/isa/x64/lower.isle line 4022.
                                        return v2765;
                                    }
                                    let v720 = &C::put_in_xmm_mem(ctx, v520);
                                    let v2776 = constructor_x64_pshufd(ctx, v720, 0xe_u8);
                                    let v2777 = constructor_xmm_zero(ctx, I32X4);
                                    let v2778 = &C::xmm_to_xmm_mem(ctx, v2776);
                                    let v2779 = constructor_x64_pcmpgtd(ctx, v2777, v2778);
                                    let v2780 = &C::xmm_to_xmm_mem(ctx, v2779);
                                    let v2781 = constructor_x64_punpckldq(ctx, v2776, v2780);
                                    let v2782 = constructor_output_xmm(ctx, v2781);
                                    let v2783 = Some(v2782);
                                    // Rule at src/isa/x64/lower.isle line 4036.
                                    return v2783;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::UwidenLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I8X16 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2784 = constructor_x64_pmovzxbw(ctx, v720);
                                        let v2785 = constructor_output_xmm(ctx, v2784);
                                        let v2786 = Some(v2785);
                                        // Rule at src/isa/x64/lower.isle line 4044.
                                        return v2786;
                                    }
                                }
                            }
                            I32X4 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I16X8 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2787 = constructor_x64_pmovzxwd(ctx, v720);
                                        let v2788 = constructor_output_xmm(ctx, v2787);
                                        let v2789 = Some(v2788);
                                        // Rule at src/isa/x64/lower.isle line 4047.
                                        return v2789;
                                    }
                                }
                            }
                            I64X2 => {
                                let v625 = C::use_sse41(ctx);
                                if v625 == true {
                                    let v853 = C::value_type(ctx, v520);
                                    if v853 == I32X4 {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2790 = constructor_x64_pmovzxdq(ctx, v720);
                                        let v2791 = constructor_output_xmm(ctx, v2790);
                                        let v2792 = Some(v2791);
                                        // Rule at src/isa/x64/lower.isle line 4050.
                                        return v2792;
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v724 = constructor_put_in_xmm(ctx, v520);
                        let v2793 = constructor_lower_uwiden_low(ctx, v3, v724);
                        let v2794 = constructor_output_xmm(ctx, v2793);
                        let v2795 = Some(v2794);
                        // Rule at src/isa/x64/lower.isle line 4054.
                        return v2795;
                    }
                }
                &Opcode::UwidenHigh => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I16X8 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I8X16 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v725 = constructor_xmm_zero(ctx, I8X16);
                                    let v2796 = &C::xmm_to_xmm_mem(ctx, v725);
                                    let v2797 = constructor_x64_punpckhbw(ctx, v724, v2796);
                                    let v2798 = constructor_output_xmm(ctx, v2797);
                                    let v2799 = Some(v2798);
                                    // Rule at src/isa/x64/lower.isle line 4069.
                                    return v2799;
                                }
                            }
                            I32X4 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I16X8 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v725 = constructor_xmm_zero(ctx, I8X16);
                                    let v2796 = &C::xmm_to_xmm_mem(ctx, v725);
                                    let v2800 = constructor_x64_punpckhwd(ctx, v724, v2796);
                                    let v2801 = constructor_output_xmm(ctx, v2800);
                                    let v2802 = Some(v2801);
                                    // Rule at src/isa/x64/lower.isle line 4071.
                                    return v2802;
                                }
                            }
                            I64X2 => {
                                let v853 = C::value_type(ctx, v520);
                                if v853 == I32X4 {
                                    let v724 = constructor_put_in_xmm(ctx, v520);
                                    let v2594 = constructor_xmm_zero(ctx, F32X4);
                                    let v2595 = &C::xmm_to_xmm_mem(ctx, v2594);
                                    let v2803 = constructor_x64_unpckhps(ctx, v724, v2595);
                                    let v2804 = constructor_output_xmm(ctx, v2803);
                                    let v2805 = Some(v2804);
                                    // Rule at src/isa/x64/lower.isle line 4073.
                                    return v2805;
                                }
                            }
                            _ => {}
                        }
                    }
                }
                &Opcode::Uextend => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I64 => {
                                let v1518 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Zero);
                                let v1699 = constructor_output_gpr(ctx, v1518);
                                let v1700 = Some(v1699);
                                // Rule at src/isa/x64/lower.isle line 2533.
                                return v1700;
                            }
                            I128 => {
                                let v1518 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Zero);
                                let v1694 = C::gpr_to_reg(ctx, v1518);
                                let v1695 = constructor_imm(ctx, I64, 0x0_u64);
                                let v1696 = C::value_regs(ctx, v1694, v1695);
                                let v1697 = C::output(ctx, v1696);
                                let v1698 = Some(v1697);
                                // Rule at src/isa/x64/lower.isle line 2529.
                                return v1698;
                            }
                            _ => {}
                        }
                        let v1701 = C::fits_in_32(ctx, v3);
                        if let Some(v1702) = v1701 {
                            let v1551 = constructor_extend_to_gpr(ctx, v520, I32, &ExtendKind::Zero);
                            let v1703 = constructor_output_gpr(ctx, v1551);
                            let v1704 = Some(v1703);
                            // Rule at src/isa/x64/lower.isle line 2538.
                            return v1704;
                        }
                    }
                }
                &Opcode::Sextend => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            I64 => {
                                let v1705 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Sign);
                                let v1712 = constructor_output_gpr(ctx, v1705);
                                let v1713 = Some(v1712);
                                // Rule at src/isa/x64/lower.isle line 2553.
                                return v1713;
                            }
                            I128 => {
                                let v1705 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Sign);
                                let v1248 = Imm8Reg::Imm8 {
                                    imm: 0x3f_u8,
                                };
                                let v1249 = &C::imm8_reg_to_imm8_gpr(ctx, &v1248);
                                let v1706 = constructor_x64_sar(ctx, I64, v1705, v1249);
                                let v1707 = C::gpr_to_reg(ctx, v1705);
                                let v1708 = C::gpr_to_reg(ctx, v1706);
                                let v1709 = C::value_regs(ctx, v1707, v1708);
                                let v1710 = C::output(ctx, v1709);
                                let v1711 = Some(v1710);
                                // Rule at src/isa/x64/lower.isle line 2547.
                                return v1711;
                            }
                            _ => {}
                        }
                        let v1701 = C::fits_in_32(ctx, v3);
                        if let Some(v1702) = v1701 {
                            let v1714 = constructor_extend_to_gpr(ctx, v520, I32, &ExtendKind::Sign);
                            let v1715 = constructor_output_gpr(ctx, v1714);
                            let v1716 = Some(v1715);
                            // Rule at src/isa/x64/lower.isle line 2558.
                            return v1716;
                        }
                    }
                }
                &Opcode::Fpromote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F64 {
                            let v1809 = constructor_xmm_zero(ctx, F64X2);
                            let v1804 = &C::put_in_xmm_mem(ctx, v520);
                            let v1819 = constructor_x64_cvtss2sd(ctx, v1809, v1804);
                            let v1820 = constructor_output_xmm(ctx, v1819);
                            let v1821 = Some(v1820);
                            // Rule at src/isa/x64/lower.isle line 2661.
                            return v1821;
                        }
                    }
                }
                &Opcode::Fdemote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F32 {
                            let v1803 = constructor_xmm_zero(ctx, F32X4);
                            let v1804 = &C::put_in_xmm_mem(ctx, v520);
                            let v1826 = constructor_x64_cvtsd2ss(ctx, v1803, v1804);
                            let v1827 = constructor_output_xmm(ctx, v1826);
                            let v1828 = Some(v1827);
                            // Rule at src/isa/x64/lower.isle line 2669.
                            return v1828;
                        }
                    }
                }
                &Opcode::Fvdemote => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F32X4 {
                            let v720 = &C::put_in_xmm_mem(ctx, v520);
                            let v1829 = constructor_x64_cvtpd2ps(ctx, v720);
                            let v1830 = constructor_output_xmm(ctx, v1829);
                            let v1831 = Some(v1830);
                            // Rule at src/isa/x64/lower.isle line 2673.
                            return v1831;
                        }
                    }
                }
                &Opcode::FvpromoteLow => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == F64X2 {
                            let v724 = constructor_put_in_xmm(ctx, v520);
                            let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                            let v1823 = constructor_x64_cvtps2pd(ctx, v1822);
                            let v1824 = constructor_output_xmm(ctx, v1823);
                            let v1825 = Some(v1824);
                            // Rule at src/isa/x64/lower.isle line 2665.
                            return v1825;
                        }
                    }
                }
                &Opcode::FcvtToUint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v853 = C::value_type(ctx, v520);
                        let v2565 = C::ty_scalar_float(ctx, v853);
                        if let Some(v2566) = v2565 {
                            let v3 = C::value_type(ctx, v2);
                            let v172 = false;
                            let v2567 = constructor_cvt_float_to_uint_seq(ctx, v3, v520, v172);
                            let v2568 = constructor_output_gpr(ctx, v2567);
                            let v2569 = Some(v2568);
                            // Rule at src/isa/x64/lower.isle line 3731.
                            return v2569;
                        }
                    }
                }
                &Opcode::FcvtToSint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v853 = C::value_type(ctx, v520);
                        let v2565 = C::ty_scalar_float(ctx, v853);
                        if let Some(v2566) = v2565 {
                            let v3 = C::value_type(ctx, v2);
                            let v172 = false;
                            let v2573 = constructor_cvt_float_to_sint_seq(ctx, v3, v520, v172);
                            let v2574 = constructor_output_gpr(ctx, v2573);
                            let v2575 = Some(v2574);
                            // Rule at src/isa/x64/lower.isle line 3737.
                            return v2575;
                        }
                    }
                }
                &Opcode::FcvtToUintSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v853 = C::value_type(ctx, v520);
                            if v853 == F32X4 {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v2594 = constructor_xmm_zero(ctx, F32X4);
                                let v2595 = &C::xmm_to_xmm_mem(ctx, v2594);
                                let v2596 = constructor_x64_maxps(ctx, v724, v2595);
                                let v2597 = &C::xmm_to_xmm_mem(ctx, v2594);
                                let v2598 = constructor_x64_pcmpeqd(ctx, v2594, v2597);
                                let v2599 = &C::xmi_imm(ctx, 0x1_u32);
                                let v2600 = constructor_x64_psrld(ctx, v2598, v2599);
                                let v2601 = &C::xmm_to_xmm_mem(ctx, v2600);
                                let v2602 = constructor_x64_cvtdq2ps(ctx, v2601);
                                let v2603 = &C::xmm_to_xmm_mem(ctx, v2596);
                                let v2604 = constructor_x64_cvttps2dq(ctx, v2603);
                                let v2605 = &C::xmm_to_xmm_mem(ctx, v2602);
                                let v2606 = constructor_x64_subps(ctx, v2596, v2605);
                                let v2607 = &C::xmm_to_xmm_mem(ctx, v2606);
                                let v2608 = constructor_x64_cmpps(ctx, v2602, v2607, &FcmpImm::LessThanOrEqual);
                                let v2609 = &C::xmm_to_xmm_mem(ctx, v2606);
                                let v2610 = constructor_x64_cvttps2dq(ctx, v2609);
                                let v2611 = &C::xmm_to_xmm_mem(ctx, v2608);
                                let v2612 = constructor_x64_pxor(ctx, v2610, v2611);
                                let v2613 = constructor_xmm_zero(ctx, I32X4);
                                let v2614 = constructor_lower_vec_smax(ctx, I32X4, v2612, v2613);
                                let v2615 = &C::xmm_to_xmm_mem(ctx, v2604);
                                let v2616 = constructor_x64_paddd(ctx, v2614, v2615);
                                let v2617 = constructor_output_xmm(ctx, v2616);
                                let v2618 = Some(v2617);
                                // Rule at src/isa/x64/lower.isle line 3815.
                                return v2618;
                            }
                        }
                        let v853 = C::value_type(ctx, v520);
                        let v2565 = C::ty_scalar_float(ctx, v853);
                        if let Some(v2566) = v2565 {
                            let v182 = true;
                            let v2570 = constructor_cvt_float_to_uint_seq(ctx, v3, v520, v182);
                            let v2571 = constructor_output_gpr(ctx, v2570);
                            let v2572 = Some(v2571);
                            // Rule at src/isa/x64/lower.isle line 3734.
                            return v2572;
                        }
                    }
                }
                &Opcode::FcvtToSintSat => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v853 = C::value_type(ctx, v520);
                            if v853 == F32X4 {
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v1822 = &C::xmm_to_xmm_mem(ctx, v724);
                                let v2579 = constructor_x64_cmpps(ctx, v724, v1822, &FcmpImm::Equal);
                                let v2580 = &C::xmm_to_xmm_mem(ctx, v2579);
                                let v2581 = constructor_x64_andps(ctx, v724, v2580);
                                let v2582 = &C::xmm_to_xmm_mem(ctx, v2581);
                                let v2583 = constructor_x64_pxor(ctx, v2579, v2582);
                                let v2584 = &C::xmm_to_xmm_mem(ctx, v2581);
                                let v2585 = constructor_x64_cvttps2dq(ctx, v2584);
                                let v2586 = &C::xmm_to_xmm_mem(ctx, v2583);
                                let v2587 = constructor_x64_pand(ctx, v2585, v2586);
                                let v2588 = &C::xmi_imm(ctx, 0x1f_u32);
                                let v2589 = constructor_x64_psrad(ctx, v2587, v2588);
                                let v2590 = &C::xmm_to_xmm_mem(ctx, v2585);
                                let v2591 = constructor_x64_pxor(ctx, v2589, v2590);
                                let v2592 = constructor_output_xmm(ctx, v2591);
                                let v2593 = Some(v2592);
                                // Rule at src/isa/x64/lower.isle line 3744.
                                return v2593;
                            }
                        }
                        let v853 = C::value_type(ctx, v520);
                        let v2565 = C::ty_scalar_float(ctx, v853);
                        if let Some(v2566) = v2565 {
                            let v182 = true;
                            let v2576 = constructor_cvt_float_to_sint_seq(ctx, v3, v520, v182);
                            let v2577 = constructor_output_gpr(ctx, v2576);
                            let v2578 = Some(v2577);
                            // Rule at src/isa/x64/lower.isle line 3740.
                            return v2578;
                        }
                    }
                }
                &Opcode::X86Cvtt2dq => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        if v3 == I32X4 {
                            let v853 = C::value_type(ctx, v520);
                            if v853 == F32X4 {
                                let v720 = &C::put_in_xmm_mem(ctx, v520);
                                let v2619 = constructor_x64_cvttps2dq(ctx, v720);
                                let v2620 = constructor_output_xmm(ctx, v2619);
                                let v2621 = Some(v2620);
                                // Rule at src/isa/x64/lower.isle line 3862.
                                return v2621;
                            }
                        }
                    }
                }
                &Opcode::FcvtFromUint => {
                    let v1 = C::first_result(ctx, arg0);
                    if let Some(v2) = v1 {
                        let v3 = C::value_type(ctx, v2);
                        match v3 {
                            F32 => {
                                let v853 = C::value_type(ctx, v520);
                                let v2495 = C::fits_in_32(ctx, v853);
                                if let Some(v2496) = v2495 {
                                    let v2497 = C::ty_int(ctx, v2496);
                                    if let Some(v2498) = v2497 {
                                        let v1803 = constructor_xmm_zero(ctx, F32X4);
                                        let v2499 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Zero);
                                        let v2500 = &C::gpr_to_gpr_mem(ctx, v2499);
                                        let v2501 = constructor_x64_cvtsi2ss(ctx, I64, v1803, v2500);
                                        let v2502 = constructor_output_xmm(ctx, v2501);
                                        let v2503 = Some(v2502);
                                        // Rule at src/isa/x64/lower.isle line 3619.
                                        return v2503;
                                    }
                                }
                            }
                            F64 => {
                                let v853 = C::value_type(ctx, v520);
                                let v2495 = C::fits_in_32(ctx, v853);
                                if let Some(v2496) = v2495 {
                                    let v2497 = C::ty_int(ctx, v2496);
                                    if let Some(v2498) = v2497 {
                                        let v1809 = constructor_xmm_zero(ctx, F64X2);
                                        let v2499 = constructor_extend_to_gpr(ctx, v520, I64, &ExtendKind::Zero);
                                        let v2500 = &C::gpr_to_gpr_mem(ctx, v2499);
                                        let v2504 = constructor_x64_cvtsi2sd(ctx, I64, v1809, v2500);
                                        let v2505 = constructor_output_xmm(ctx, v2504);
                                        let v2506 = Some(v2505);
                                        // Rule at src/isa/x64/lower.isle line 3622.
                                        return v2506;
                                    }
                                }
                            }
                            F32X4 => {
                                let v463 = C::use_avx512vl(ctx);
                                if v463 == true {
                                    let v464 = C::use_avx512f(ctx);
                                    if v464 == true {
                                        let v720 = &C::put_in_xmm_mem(ctx, v520);
                                        let v2543 = constructor_x64_vcvtudq2ps(ctx, v720);
                                        let v2544 = constructor_output_xmm(ctx, v2543);
                                        let v2545 = Some(v2544);
                                        // Rule at src/isa/x64/lower.isle line 3679.
                                        return v2545;
                                    }
                                }
                                let v724 = constructor_put_in_xmm(ctx, v520);
                                let v2547 = &C::xmi_imm(ctx, 0x10_u32);
                                let v2548 = constructor_x64_pslld(ctx, v724, v2547);
                                let v2549 = &C::xmi_imm(ctx, 0x10_u32);
                                let v2550 = constructor_x64_psrld(ctx, v2548, v2549);
                                let v2551 = &C::xmm_to_xmm_mem(ctx, v2550);
                                let v2552 = constructor_x64_psubd(ctx, v724, v2551);
                                let v2553 = &C::xmm_to_xmm_mem(ctx, v2550);
                                let v2554 = constructor_x64_cvtdq2ps(ctx, v2553);
                                let v2555 = &C::xmi_imm(ctx, 0x1_u32);
                                let v2556 = constructor_x64_psrld(ctx, v2552, v2555);
                                let v2557 = &C::xmm_to_xmm_mem(ctx, v2556);
                                let v2558 = constructor_x64_cvtdq2ps(ctx, v2557);
                                let v2559 = &C::xmm_to_xmm_mem(ctx, v2558);
                                let v2560 = constructor_x64_addps(ctx, v2558, v2559);
                                let v2561 = &C::xmm_to_xmm_mem(ctx, v2554);
                                let v2562 = constructor_x64_addps(ctx, v2560, v2561);
                                let v2563 = constructor_output_xmm(ctx, v2562);
                                let v2564 = Some(v2563);
                                // Rule at src/isa/x64/lower.isle line 3707.
                                return v2564;
                            }
                            F64X2 => {
                                let v2485 = C::def_inst(ctx, v520);
                                if let Some(v2486) = v2485 {
                                    let v2487 = &C::inst_data(ctx, v2486);
                                    if let &InstructionData::Unary {
                                        opcode: ref v2488,
                                        arg: v2489,
                                    } = v2487 {
                                        if let &Opcode::UwidenLow = v2488 {
                                            let v2490 = C::value_type(ctx, v2489);
                                            if v2490 == I32X4 {
                                                let v2534 = C::emit_u128_le_const(ctx, 0x4330000043300000_u128);
                                                let v2535 = &constructor_const_to_xmm_mem(ctx, v2534);
                                                let v2536 = constructor_put_in_xmm(ctx, v2489);
                                                let v2537 = constructor_x64_unpcklps(ctx, v2536, v2535);
                                                let v2538 = C::emit_u128_le_const(ctx, 0x43300000000000004330000000000000_u128);
                                                let v2539 = &constructor_const_to_xmm_mem(ctx, v2538);
                                                let v2540 = constructor_x64_subpd(ctx, v2537, v2539);
                                                let v2541 = constructor_output_xmm(ctx, v2540);
                                                let v2542 = Some(v2541);
                                                // Rule at src/isa/x64/lower.isle line 3671.
                                                return v2542;
                                            }
                                        }
                                    }
                                }
                            }
                            _ => {}
                        }
                        let v853 = C::value_type(ctx, v520);
                        match v853 {
                            I64 => {
                                let v521 = constructor_put_in_gpr(ctx, v520);
                                let v2507 = constructor_cvt_u64_to_float_seq(ctx, v3, v521);
                                let v2508 = constructor_output_xmm(ctx, v2507);
                                let v2509 = Some(v2508);
                                // Rule at src/isa/x64/lower.isle line 3625.
                                return v2509;
                            }
                            I64X2 => {
                                if v3 == F64X2 {
                                    let v2511 = C::emit_u128_le_const(ctx, 0xffffffff00000000ffffffff_u128);
                                    let v2512 = &constructor_const_to_xmm_mem(ctx, v2511);
                                    let v2514 = C::emit_u128_le_const(ctx, 0x43300000000000004330000000000000_u128);
                                    let v2515 = &constructor_const_to_xmm_mem(ctx, v2514);
                                