// Code generated via go generate from gen_properties.go. DO NOT EDIT.

package uniseg

// lineBreakCodePoints are taken from
// https://www.unicode.org/Public/15.0.0/ucd/LineBreak.txt
// and
// https://unicode.org/Public/15.0.0/ucd/emoji/emoji-data.txt
// ("Extended_Pictographic" only)
// on September 5, 2023. See https://www.unicode.org/license.html for the Unicode
// license agreement.
var lineBreakCodePoints = [][4]int{
	{0x0000, 0x0008, prCM, gcCc},     //     [9] <control-0000>..<control-0008>
	{0x0009, 0x0009, prBA, gcCc},     //         <control-0009>
	{0x000A, 0x000A, prLF, gcCc},     //         <control-000A>
	{0x000B, 0x000C, prBK, gcCc},     //     [2] <control-000B>..<control-000C>
	{0x000D, 0x000D, prCR, gcCc},     //         <control-000D>
	{0x000E, 0x001F, prCM, gcCc},     //    [18] <control-000E>..<control-001F>
	{0x0020, 0x0020, prSP, gcZs},     //         SPACE
	{0x0021, 0x0021, prEX, gcPo},     //         EXCLAMATION MARK
	{0x0022, 0x0022, prQU, gcPo},     //         QUOTATION MARK
	{0x0023, 0x0023, prAL, gcPo},     //         NUMBER SIGN
	{0x0024, 0x0024, prPR, gcSc},     //         DOLLAR SIGN
	{0x0025, 0x0025, prPO, gcPo},     //         PERCENT SIGN
	{0x0026, 0x0026, prAL, gcPo},     //         AMPERSAND
	{0x0027, 0x0027, prQU, gcPo},     //         APOSTROPHE
	{0x0028, 0x0028, prOP, gcPs},     //         LEFT PARENTHESIS
	{0x0029, 0x0029, prCP, gcPe},     //         RIGHT PARENTHESIS
	{0x002A, 0x002A, prAL, gcPo},     //         ASTERISK
	{0x002B, 0x002B, prPR, gcSm},     //         PLUS SIGN
	{0x002C, 0x002C, prIS, gcPo},     //         COMMA
	{0x002D, 0x002D, prHY, gcPd},     //         HYPHEN-MINUS
	{0x002E, 0x002E, prIS, gcPo},     //         FULL STOP
	{0x002F, 0x002F, prSY, gcPo},     //         SOLIDUS
	{0x0030, 0x0039, prNU, gcNd},     //    [10] DIGIT ZERO..DIGIT NINE
	{0x003A, 0x003B, prIS, gcPo},     //     [2] COLON..SEMICOLON
	{0x003C, 0x003E, prAL, gcSm},     //     [3] LESS-THAN SIGN..GREATER-THAN SIGN
	{0x003F, 0x003F, prEX, gcPo},     //         QUESTION MARK
	{0x0040, 0x0040, prAL, gcPo},     //         COMMERCIAL AT
	{0x0041, 0x005A, prAL, gcLu},     //    [26] LATIN CAPITAL LETTER A..LATIN CAPITAL LETTER Z
	{0x005B, 0x005B, prOP, gcPs},     //         LEFT SQUARE BRACKET
	{0x005C, 0x005C, prPR, gcPo},     //         REVERSE SOLIDUS
	{0x005D, 0x005D, prCP, gcPe},     //         RIGHT SQUARE BRACKET
	{0x005E, 0x005E, prAL, gcSk},     //         CIRCUMFLEX ACCENT
	{0x005F, 0x005F, prAL, gcPc},     //         LOW LINE
	{0x0060, 0x0060, prAL, gcSk},     //         GRAVE ACCENT
	{0x0061, 0x007A, prAL, gcLl},     //    [26] LATIN SMALL LETTER A..LATIN SMALL LETTER Z
	{0x007B, 0x007B, prOP, gcPs},     //         LEFT CURLY BRACKET
	{0x007C, 0x007C, prBA, gcSm},     //         VERTICAL LINE
	{0x007D, 0x007D, prCL, gcPe},     //         RIGHT CURLY BRACKET
	{0x007E, 0x007E, prAL, gcSm},     //         TILDE
	{0x007F, 0x007F, prCM, gcCc},     //         <control-007F>
	{0x0080, 0x0084, prCM, gcCc},     //     [5] <control-0080>..<control-0084>
	{0x0085, 0x0085, prNL, gcCc},     //         <control-0085>
	{0x0086, 0x009F, prCM, gcCc},     //    [26] <control-0086>..<control-009F>
	{0x00A0, 0x00A0, prGL, gcZs},     //         NO-BREAK SPACE
	{0x00A1, 0x00A1, prOP, gcPo},     //         INVERTED EXCLAMATION MARK
	{0x00A2, 0x00A2, prPO, gcSc},     //         CENT SIGN
	{0x00A3, 0x00A5, prPR, gcSc},     //     [3] POUND SIGN..YEN SIGN
	{0x00A6, 0x00A6, prAL, gcSo},     //         BROKEN BAR
	{0x00A7, 0x00A7, prAI, gcPo},     //         SECTION SIGN
	{0x00A8, 0x00A8, prAI, gcSk},     //         DIAERESIS
	{0x00A9, 0x00A9, prAL, gcSo},     //         COPYRIGHT SIGN
	{0x00AA, 0x00AA, prAI, gcLo},     //         FEMININE ORDINAL INDICATOR
	{0x00AB, 0x00AB, prQU, gcPi},     //         LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00AC, 0x00AC, prAL, gcSm},     //         NOT SIGN
	{0x00AD, 0x00AD, prBA, gcCf},     //         SOFT HYPHEN
	{0x00AE, 0x00AE, prAL, gcSo},     //         REGISTERED SIGN
	{0x00AF, 0x00AF, prAL, gcSk},     //         MACRON
	{0x00B0, 0x00B0, prPO, gcSo},     //         DEGREE SIGN
	{0x00B1, 0x00B1, prPR, gcSm},     //         PLUS-MINUS SIGN
	{0x00B2, 0x00B3, prAI, gcNo},     //     [2] SUPERSCRIPT TWO..SUPERSCRIPT THREE
	{0x00B4, 0x00B4, prBB, gcSk},     //         ACUTE ACCENT
	{0x00B5, 0x00B5, prAL, gcLl},     //         MICRO SIGN
	{0x00B6, 0x00B7, prAI, gcPo},     //     [2] PILCROW SIGN..MIDDLE DOT
	{0x00B8, 0x00B8, prAI, gcSk},     //         CEDILLA
	{0x00B9, 0x00B9, prAI, gcNo},     //         SUPERSCRIPT ONE
	{0x00BA, 0x00BA, prAI, gcLo},     //         MASCULINE ORDINAL INDICATOR
	{0x00BB, 0x00BB, prQU, gcPf},     //         RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	{0x00BC, 0x00BE, prAI, gcNo},     //     [3] VULGAR FRACTION ONE QUARTER..VULGAR FRACTION THREE QUARTERS
	{0x00BF, 0x00BF, prOP, gcPo},     //         INVERTED QUESTION MARK
	{0x00C0, 0x00D6, prAL, gcLu},     //    [23] LATIN CAPITAL LETTER A WITH GRAVE..LATIN CAPITAL LETTER O WITH DIAERESIS
	{0x00D7, 0x00D7, prAI, gcSm},     //         MULTIPLICATION SIGN
	{0x00D8, 0x00F6, prAL, gcLC},     //    [31] LATIN CAPITAL LETTER O WITH STROKE..LATIN SMALL LETTER O WITH DIAERESIS
	{0x00F7, 0x00F7, prAI, gcSm},     //         DIVISION SIGN
	{0x00F8, 0x00FF, prAL, gcLl},     //     [8] LATIN SMALL LETTER O WITH STROKE..LATIN SMALL LETTER Y WITH DIAERESIS
	{0x0100, 0x017F, prAL, gcLC},     //   [128] LATIN CAPITAL LETTER A WITH MACRON..LATIN SMALL LETTER LONG S
	{0x0180, 0x01BA, prAL, gcLC},     //    [59] LATIN SMALL LETTER B WITH STROKE..LATIN SMALL LETTER EZH WITH TAIL
	{0x01BB, 0x01BB, prAL, gcLo},     //         LATIN LETTER TWO WITH STROKE
	{0x01BC, 0x01BF, prAL, gcLC},     //     [4] LATIN CAPITAL LETTER TONE FIVE..LATIN LETTER WYNN
	{0x01C0, 0x01C3, prAL, gcLo},     //     [4] LATIN LETTER DENTAL CLICK..LATIN LETTER RETROFLEX CLICK
	{0x01C4, 0x024F, prAL, gcLC},     //   [140] LATIN CAPITAL LETTER DZ WITH CARON..LATIN SMALL LETTER Y WITH STROKE
	{0x0250, 0x0293, prAL, gcLl},     //    [68] LATIN SMALL LETTER TURNED A..LATIN SMALL LETTER EZH WITH CURL
	{0x0294, 0x0294, prAL, gcLo},     //         LATIN LETTER GLOTTAL STOP
	{0x0295, 0x02AF, prAL, gcLl},     //    [27] LATIN LETTER PHARYNGEAL VOICED FRICATIVE..LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
	{0x02B0, 0x02C1, prAL, gcLm},     //    [18] MODIFIER LETTER SMALL H..MODIFIER LETTER REVERSED GLOTTAL STOP
	{0x02C2, 0x02C5, prAL, gcSk},     //     [4] MODIFIER LETTER LEFT ARROWHEAD..MODIFIER LETTER DOWN ARROWHEAD
	{0x02C6, 0x02C6, prAL, gcLm},     //         MODIFIER LETTER CIRCUMFLEX ACCENT
	{0x02C7, 0x02C7, prAI, gcLm},     //         CARON
	{0x02C8, 0x02C8, prBB, gcLm},     //         MODIFIER LETTER VERTICAL LINE
	{0x02C9, 0x02CB, prAI, gcLm},     //     [3] MODIFIER LETTER MACRON..MODIFIER LETTER GRAVE ACCENT
	{0x02CC, 0x02CC, prBB, gcLm},     //         MODIFIER LETTER LOW VERTICAL LINE
	{0x02CD, 0x02CD, prAI, gcLm},     //         MODIFIER LETTER LOW MACRON
	{0x02CE, 0x02CF, prAL, gcLm},     //     [2] MODIFIER LETTER LOW GRAVE ACCENT..MODIFIER LETTER LOW ACUTE ACCENT
	{0x02D0, 0x02D0, prAI, gcLm},     //         MODIFIER LETTER TRIANGULAR COLON
	{0x02D1, 0x02D1, prAL, gcLm},     //         MODIFIER LETTER HALF TRIANGULAR COLON
	{0x02D2, 0x02D7, prAL, gcSk},     //     [6] MODIFIER LETTER CENTRED RIGHT HALF RING..MODIFIER LETTER MINUS SIGN
	{0x02D8, 0x02DB, prAI, gcSk},     //     [4] BREVE..OGONEK
	{0x02DC, 0x02DC, prAL, gcSk},     //         SMALL TILDE
	{0x02DD, 0x02DD, prAI, gcSk},     //         DOUBLE ACUTE ACCENT
	{0x02DE, 0x02DE, prAL, gcSk},     //         MODIFIER LETTER RHOTIC HOOK
	{0x02DF, 0x02DF, prBB, gcSk},     //         MODIFIER LETTER CROSS ACCENT
	{0x02E0, 0x02E4, prAL, gcLm},     //     [5] MODIFIER LETTER SMALL GAMMA..MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
	{0x02E5, 0x02EB, prAL, gcSk},     //     [7] MODIFIER LETTER EXTRA-HIGH TONE BAR..MODIFIER LETTER YANG DEPARTING TONE MARK
	{0x02EC, 0x02EC, prAL, gcLm},     //         MODIFIER LETTER VOICING
	{0x02ED, 0x02ED, prAL, gcSk},     //         MODIFIER LETTER UNASPIRATED
	{0x02EE, 0x02EE, prAL, gcLm},     //         MODIFIER LETTER DOUBLE APOSTROPHE
	{0x02EF, 0x02FF, prAL, gcSk},     //    [17] MODIFIER LETTER LOW DOWN ARROWHEAD..MODIFIER LETTER LOW LEFT ARROW
	{0x0300, 0x034E, prCM, gcMn},     //    [79] COMBINING GRAVE ACCENT..COMBINING UPWARDS ARROW BELOW
	{0x034F, 0x034F, prGL, gcMn},     //         COMBINING GRAPHEME JOINER
	{0x0350, 0x035B, prCM, gcMn},     //    [12] COMBINING RIGHT ARROWHEAD ABOVE..COMBINING ZIGZAG ABOVE
	{0x035C, 0x0362, prGL, gcMn},     //     [7] COMBINING DOUBLE BREVE BELOW..COMBINING DOUBLE RIGHTWARDS ARROW BELOW
	{0x0363, 0x036F, prCM, gcMn},     //    [13] COMBINING LATIN SMALL LETTER A..COMBINING LATIN SMALL LETTER X
	{0x0370, 0x0373, prAL, gcLC},     //     [4] GREEK CAPITAL LETTER HETA..GREEK SMALL LETTER ARCHAIC SAMPI
	{0x0374, 0x0374, prAL, gcLm},     //         GREEK NUMERAL SIGN
	{0x0375, 0x0375, prAL, gcSk},     //         GREEK LOWER NUMERAL SIGN
	{0x0376, 0x0377, prAL, gcLC},     //     [2] GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA..GREEK SMALL LETTER PAMPHYLIAN DIGAMMA
	{0x037A, 0x037A, prAL, gcLm},     //         GREEK YPOGEGRAMMENI
	{0x037B, 0x037D, prAL, gcLl},     //     [3] GREEK SMALL REVERSED LUNATE SIGMA SYMBOL..GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL
	{0x037E, 0x037E, prIS, gcPo},     //         GREEK QUESTION MARK
	{0x037F, 0x037F, prAL, gcLu},     //         GREEK CAPITAL LETTER YOT
	{0x0384, 0x0385, prAL, gcSk},     //     [2] GREEK TONOS..GREEK DIALYTIKA TONOS
	{0x0386, 0x0386, prAL, gcLu},     //         GREEK CAPITAL LETTER ALPHA WITH TONOS
	{0x0387, 0x0387, prAL, gcPo},     //         GREEK ANO TELEIA
	{0x0388, 0x038A, prAL, gcLu},     //     [3] GREEK CAPITAL LETTER EPSILON WITH TONOS..GREEK CAPITAL LETTER IOTA WITH TONOS
	{0x038C, 0x038C, prAL, gcLu},     //         GREEK CAPITAL LETTER OMICRON WITH TONOS
	{0x038E, 0x03A1, prAL, gcLC},     //    [20] GREEK CAPITAL LETTER UPSILON WITH TONOS..GREEK CAPITAL LETTER RHO
	{0x03A3, 0x03F5, prAL, gcLC},     //    [83] GREEK CAPITAL LETTER SIGMA..GREEK LUNATE EPSILON SYMBOL
	{0x03F6, 0x03F6, prAL, gcSm},     //         GREEK REVERSED LUNATE EPSILON SYMBOL
	{0x03F7, 0x03FF, prAL, gcLC},     //     [9] GREEK CAPITAL LETTER SHO..GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL
	{0x0400, 0x0481, prAL, gcLC},     //   [130] CYRILLIC CAPITAL LETTER IE WITH GRAVE..CYRILLIC SMALL LETTER KOPPA
	{0x0482, 0x0482, prAL, gcSo},     //         CYRILLIC THOUSANDS SIGN
	{0x0483, 0x0487, prCM, gcMn},     //     [5] COMBINING CYRILLIC TITLO..COMBINING CYRILLIC POKRYTIE
	{0x0488, 0x0489, prCM, gcMe},     //     [2] COMBINING CYRILLIC HUNDRED THOUSANDS SIGN..COMBINING CYRILLIC MILLIONS SIGN
	{0x048A, 0x04FF, prAL, gcLC},     //   [118] CYRILLIC CAPITAL LETTER SHORT I WITH TAIL..CYRILLIC SMALL LETTER HA WITH STROKE
	{0x0500, 0x052F, prAL, gcLC},     //    [48] CYRILLIC CAPITAL LETTER KOMI DE..CYRILLIC SMALL LETTER EL WITH DESCENDER
	{0x0531, 0x0556, prAL, gcLu},     //    [38] ARMENIAN CAPITAL LETTER AYB..ARMENIAN CAPITAL LETTER FEH
	{0x0559, 0x0559, prAL, gcLm},     //         ARMENIAN MODIFIER LETTER LEFT HALF RING
	{0x055A, 0x055F, prAL, gcPo},     //     [6] ARMENIAN APOSTROPHE..ARMENIAN ABBREVIATION MARK
	{0x0560, 0x0588, prAL, gcLl},     //    [41] ARMENIAN SMALL LETTER TURNED AYB..ARMENIAN SMALL LETTER YI WITH STROKE
	{0x0589, 0x0589, prIS, gcPo},     //         ARMENIAN FULL STOP
	{0x058A, 0x058A, prBA, gcPd},     //         ARMENIAN HYPHEN
	{0x058D, 0x058E, prAL, gcSo},     //     [2] RIGHT-FACING ARMENIAN ETERNITY SIGN..LEFT-FACING ARMENIAN ETERNITY SIGN
	{0x058F, 0x058F, prPR, gcSc},     //         ARMENIAN DRAM SIGN
	{0x0591, 0x05BD, prCM, gcMn},     //    [45] HEBREW ACCENT ETNAHTA..HEBREW POINT METEG
	{0x05BE, 0x05BE, prBA, gcPd},     //         HEBREW PUNCTUATION MAQAF
	{0x05BF, 0x05BF, prCM, gcMn},     //         HEBREW POINT RAFE
	{0x05C0, 0x05C0, prAL, gcPo},     //         HEBREW PUNCTUATION PASEQ
	{0x05C1, 0x05C2, prCM, gcMn},     //     [2] HEBREW POINT SHIN DOT..HEBREW POINT SIN DOT
	{0x05C3, 0x05C3, prAL, gcPo},     //         HEBREW PUNCTUATION SOF PASUQ
	{0x05C4, 0x05C5, prCM, gcMn},     //     [2] HEBREW MARK UPPER DOT..HEBREW MARK LOWER DOT
	{0x05C6, 0x05C6, prEX, gcPo},     //         HEBREW PUNCTUATION NUN HAFUKHA
	{0x05C7, 0x05C7, prCM, gcMn},     //         HEBREW POINT QAMATS QATAN
	{0x05D0, 0x05EA, prHL, gcLo},     //    [27] HEBREW LETTER ALEF..HEBREW LETTER TAV
	{0x05EF, 0x05F2, prHL, gcLo},     //     [4] HEBREW YOD TRIANGLE..HEBREW LIGATURE YIDDISH DOUBLE YOD
	{0x05F3, 0x05F4, prAL, gcPo},     //     [2] HEBREW PUNCTUATION GERESH..HEBREW PUNCTUATION GERSHAYIM
	{0x0600, 0x0605, prAL, gcCf},     //     [6] ARABIC NUMBER SIGN..ARABIC NUMBER MARK ABOVE
	{0x0606, 0x0608, prAL, gcSm},     //     [3] ARABIC-INDIC CUBE ROOT..ARABIC RAY
	{0x0609, 0x060A, prPO, gcPo},     //     [2] ARABIC-INDIC PER MILLE SIGN..ARABIC-INDIC PER TEN THOUSAND SIGN
	{0x060B, 0x060B, prPO, gcSc},     //         AFGHANI SIGN
	{0x060C, 0x060D, prIS, gcPo},     //     [2] ARABIC COMMA..ARABIC DATE SEPARATOR
	{0x060E, 0x060F, prAL, gcSo},     //     [2] ARABIC POETIC VERSE SIGN..ARABIC SIGN MISRA
	{0x0610, 0x061A, prCM, gcMn},     //    [11] ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM..ARABIC SMALL KASRA
	{0x061B, 0x061B, prEX, gcPo},     //         ARABIC SEMICOLON
	{0x061C, 0x061C, prCM, gcCf},     //         ARABIC LETTER MARK
	{0x061D, 0x061F, prEX, gcPo},     //     [3] ARABIC END OF TEXT MARK..ARABIC QUESTION MARK
	{0x0620, 0x063F, prAL, gcLo},     //    [32] ARABIC LETTER KASHMIRI YEH..ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE
	{0x0640, 0x0640, prAL, gcLm},     //         ARABIC TATWEEL
	{0x0641, 0x064A, prAL, gcLo},     //    [10] ARABIC LETTER FEH..ARABIC LETTER YEH
	{0x064B, 0x065F, prCM, gcMn},     //    [21] ARABIC FATHATAN..ARABIC WAVY HAMZA BELOW
	{0x0660, 0x0669, prNU, gcNd},     //    [10] ARABIC-INDIC DIGIT ZERO..ARABIC-INDIC DIGIT NINE
	{0x066A, 0x066A, prPO, gcPo},     //         ARABIC PERCENT SIGN
	{0x066B, 0x066C, prNU, gcPo},     //     [2] ARABIC DECIMAL SEPARATOR..ARABIC THOUSANDS SEPARATOR
	{0x066D, 0x066D, prAL, gcPo},     //         ARABIC FIVE POINTED STAR
	{0x066E, 0x066F, prAL, gcLo},     //     [2] ARABIC LETTER DOTLESS BEH..ARABIC LETTER DOTLESS QAF
	{0x0670, 0x0670, prCM, gcMn},     //         ARABIC LETTER SUPERSCRIPT ALEF
	{0x0671, 0x06D3, prAL, gcLo},     //    [99] ARABIC LETTER ALEF WASLA..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
	{0x06D4, 0x06D4, prEX, gcPo},     //         ARABIC FULL STOP
	{0x06D5, 0x06D5, prAL, gcLo},     //         ARABIC LETTER AE
	{0x06D6, 0x06DC, prCM, gcMn},     //     [7] ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA..ARABIC SMALL HIGH SEEN
	{0x06DD, 0x06DD, prAL, gcCf},     //         ARABIC END OF AYAH
	{0x06DE, 0x06DE, prAL, gcSo},     //         ARABIC START OF RUB EL HIZB
	{0x06DF, 0x06E4, prCM, gcMn},     //     [6] ARABIC SMALL HIGH ROUNDED ZERO..ARABIC SMALL HIGH MADDA
	{0x06E5, 0x06E6, prAL, gcLm},     //     [2] ARABIC SMALL WAW..ARABIC SMALL YEH
	{0x06E7, 0x06E8, prCM, gcMn},     //     [2] ARABIC SMALL HIGH YEH..ARABIC SMALL HIGH NOON
	{0x06E9, 0x06E9, prAL, gcSo},     //         ARABIC PLACE OF SAJDAH
	{0x06EA, 0x06ED, prCM, gcMn},     //     [4] ARABIC EMPTY CENTRE LOW STOP..ARABIC SMALL LOW MEEM
	{0x06EE, 0x06EF, prAL, gcLo},     //     [2] ARABIC LETTER DAL WITH INVERTED V..ARABIC LETTER REH WITH INVERTED V
	{0x06F0, 0x06F9, prNU, gcNd},     //    [10] EXTENDED ARABIC-INDIC DIGIT ZERO..EXTENDED ARABIC-INDIC DIGIT NINE
	{0x06FA, 0x06FC, prAL, gcLo},     //     [3] ARABIC LETTER SHEEN WITH DOT BELOW..ARABIC LETTER GHAIN WITH DOT BELOW
	{0x06FD, 0x06FE, prAL, gcSo},     //     [2] ARABIC SIGN SINDHI AMPERSAND..ARABIC SIGN SINDHI POSTPOSITION MEN
	{0x06FF, 0x06FF, prAL, gcLo},     //         ARABIC LETTER HEH WITH INVERTED V
	{0x0700, 0x070D, prAL, gcPo},     //    [14] SYRIAC END OF PARAGRAPH..SYRIAC HARKLEAN ASTERISCUS
	{0x070F, 0x070F, prAL, gcCf},     //         SYRIAC ABBREVIATION MARK
	{0x0710, 0x0710, prAL, gcLo},     //         SYRIAC LETTER ALAPH
	{0x0711, 0x0711, prCM, gcMn},     //         SYRIAC LETTER SUPERSCRIPT ALAPH
	{0x0712, 0x072F, prAL, gcLo},     //    [30] SYRIAC LETTER BETH..SYRIAC LETTER PERSIAN DHALATH
	{0x0730, 0x074A, prCM, gcMn},     //    [27] SYRIAC PTHAHA ABOVE..SYRIAC BARREKH
	{0x074D, 0x074F, prAL, gcLo},     //     [3] SYRIAC LETTER SOGDIAN ZHAIN..SYRIAC LETTER SOGDIAN FE
	{0x0750, 0x077F, prAL, gcLo},     //    [48] ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW..ARABIC LETTER KAF WITH TWO DOTS ABOVE
	{0x0780, 0x07A5, prAL, gcLo},     //    [38] THAANA LETTER HAA..THAANA LETTER WAAVU
	{0x07A6, 0x07B0, prCM, gcMn},     //    [11] THAANA ABAFILI..THAANA SUKUN
	{0x07B1, 0x07B1, prAL, gcLo},     //         THAANA LETTER NAA
	{0x07C0, 0x07C9, prNU, gcNd},     //    [10] NKO DIGIT ZERO..NKO DIGIT NINE
	{0x07CA, 0x07EA, prAL, gcLo},     //    [33] NKO LETTER A..NKO LETTER JONA RA
	{0x07EB, 0x07F3, prCM, gcMn},     //     [9] NKO COMBINING SHORT HIGH TONE..NKO COMBINING DOUBLE DOT ABOVE
	{0x07F4, 0x07F5, prAL, gcLm},     //     [2] NKO HIGH TONE APOSTROPHE..NKO LOW TONE APOSTROPHE
	{0x07F6, 0x07F6, prAL, gcSo},     //         NKO SYMBOL OO DENNEN
	{0x07F7, 0x07F7, prAL, gcPo},     //         NKO SYMBOL GBAKURUNEN
	{0x07F8, 0x07F8, prIS, gcPo},     //         NKO COMMA
	{0x07F9, 0x07F9, prEX, gcPo},     //         NKO EXCLAMATION MARK
	{0x07FA, 0x07FA, prAL, gcLm},     //         NKO LAJANYALAN
	{0x07FD, 0x07FD, prCM, gcMn},     //         NKO DANTAYALAN
	{0x07FE, 0x07FF, prPR, gcSc},     //     [2] NKO DOROME SIGN..NKO TAMAN SIGN
	{0x0800, 0x0815, prAL, gcLo},     //    [22] SAMARITAN LETTER ALAF..SAMARITAN LETTER TAAF
	{0x0816, 0x0819, prCM, gcMn},     //     [4] SAMARITAN MARK IN..SAMARITAN MARK DAGESH
	{0x081A, 0x081A, prAL, gcLm},     //         SAMARITAN MODIFIER LETTER EPENTHETIC YUT
	{0x081B, 0x0823, prCM, gcMn},     //     [9] SAMARITAN MARK EPENTHETIC YUT..SAMARITAN VOWEL SIGN A
	{0x0824, 0x0824, prAL, gcLm},     //         SAMARITAN MODIFIER LETTER SHORT A
	{0x0825, 0x0827, prCM, gcMn},     //     [3] SAMARITAN VOWEL SIGN SHORT A..SAMARITAN VOWEL SIGN U
	{0x0828, 0x0828, prAL, gcLm},     //         SAMARITAN MODIFIER LETTER I
	{0x0829, 0x082D, prCM, gcMn},     //     [5] SAMARITAN VOWEL SIGN LONG I..SAMARITAN MARK NEQUDAA
	{0x0830, 0x083E, prAL, gcPo},     //    [15] SAMARITAN PUNCTUATION NEQUDAA..SAMARITAN PUNCTUATION ANNAAU
	{0x0840, 0x0858, prAL, gcLo},     //    [25] MANDAIC LETTER HALQA..MANDAIC LETTER AIN
	{0x0859, 0x085B, prCM, gcMn},     //     [3] MANDAIC AFFRICATION MARK..MANDAIC GEMINATION MARK
	{0x085E, 0x085E, prAL, gcPo},     //         MANDAIC PUNCTUATION
	{0x0860, 0x086A, prAL, gcLo},     //    [11] SYRIAC LETTER MALAYALAM NGA..SYRIAC LETTER MALAYALAM SSA
	{0x0870, 0x0887, prAL, gcLo},     //    [24] ARABIC LETTER ALEF WITH ATTACHED FATHA..ARABIC BASELINE ROUND DOT
	{0x0888, 0x0888, prAL, gcSk},     //         ARABIC RAISED ROUND DOT
	{0x0889, 0x088E, prAL, gcLo},     //     [6] ARABIC LETTER NOON WITH INVERTED SMALL V..ARABIC VERTICAL TAIL
	{0x0890, 0x0891, prAL, gcCf},     //     [2] ARABIC POUND MARK ABOVE..ARABIC PIASTRE MARK ABOVE
	{0x0898, 0x089F, prCM, gcMn},     //     [8] ARABIC SMALL HIGH WORD AL-JUZ..ARABIC HALF MADDA OVER MADDA
	{0x08A0, 0x08C8, prAL, gcLo},     //    [41] ARABIC LETTER BEH WITH SMALL V BELOW..ARABIC LETTER GRAF
	{0x08C9, 0x08C9, prAL, gcLm},     //         ARABIC SMALL FARSI YEH
	{0x08CA, 0x08E1, prCM, gcMn},     //    [24] ARABIC SMALL HIGH FARSI YEH..ARABIC SMALL HIGH SIGN SAFHA
	{0x08E2, 0x08E2, prAL, gcCf},     //         ARABIC DISPUTED END OF AYAH
	{0x08E3, 0x08FF, prCM, gcMn},     //    [29] ARABIC TURNED DAMMA BELOW..ARABIC MARK SIDEWAYS NOON GHUNNA
	{0x0900, 0x0902, prCM, gcMn},     //     [3] DEVANAGARI SIGN INVERTED CANDRABINDU..DEVANAGARI SIGN ANUSVARA
	{0x0903, 0x0903, prCM, gcMc},     //         DEVANAGARI SIGN VISARGA
	{0x0904, 0x0939, prAL, gcLo},     //    [54] DEVANAGARI LETTER SHORT A..DEVANAGARI LETTER HA
	{0x093A, 0x093A, prCM, gcMn},     //         DEVANAGARI VOWEL SIGN OE
	{0x093B, 0x093B, prCM, gcMc},     //         DEVANAGARI VOWEL SIGN OOE
	{0x093C, 0x093C, prCM, gcMn},     //         DEVANAGARI SIGN NUKTA
	{0x093D, 0x093D, prAL, gcLo},     //         DEVANAGARI SIGN AVAGRAHA
	{0x093E, 0x0940, prCM, gcMc},     //     [3] DEVANAGARI VOWEL SIGN AA..DEVANAGARI VOWEL SIGN II
	{0x0941, 0x0948, prCM, gcMn},     //     [8] DEVANAGARI VOWEL SIGN U..DEVANAGARI VOWEL SIGN AI
	{0x0949, 0x094C, prCM, gcMc},     //     [4] DEVANAGARI VOWEL SIGN CANDRA O..DEVANAGARI VOWEL SIGN AU
	{0x094D, 0x094D, prCM, gcMn},     //         DEVANAGARI SIGN VIRAMA
	{0x094E, 0x094F, prCM, gcMc},     //     [2] DEVANAGARI VOWEL SIGN PRISHTHAMATRA E..DEVANAGARI VOWEL SIGN AW
	{0x0950, 0x0950, prAL, gcLo},     //         DEVANAGARI OM
	{0x0951, 0x0957, prCM, gcMn},     //     [7] DEVANAGARI STRESS SIGN UDATTA..DEVANAGARI VOWEL SIGN UUE
	{0x0958, 0x0961, prAL, gcLo},     //    [10] DEVANAGARI LETTER QA..DEVANAGARI LETTER VOCALIC LL
	{0x0962, 0x0963, prCM, gcMn},     //     [2] DEVANAGARI VOWEL SIGN VOCALIC L..DEVANAGARI VOWEL SIGN VOCALIC LL
	{0x0964, 0x0965, prBA, gcPo},     //     [2] DEVANAGARI DANDA..DEVANAGARI DOUBLE DANDA
	{0x0966, 0x096F, prNU, gcNd},     //    [10] DEVANAGARI DIGIT ZERO..DEVANAGARI DIGIT NINE
	{0x0970, 0x0970, prAL, gcPo},     //         DEVANAGARI ABBREVIATION SIGN
	{0x0971, 0x0971, prAL, gcLm},     //         DEVANAGARI SIGN HIGH SPACING DOT
	{0x0972, 0x097F, prAL, gcLo},     //    [14] DEVANAGARI LETTER CANDRA A..DEVANAGARI LETTER BBA
	{0x0980, 0x0980, prAL, gcLo},     //         BENGALI ANJI
	{0x0981, 0x0981, prCM, gcMn},     //         BENGALI SIGN CANDRABINDU
	{0x0982, 0x0983, prCM, gcMc},     //     [2] BENGALI SIGN ANUSVARA..BENGALI SIGN VISARGA
	{0x0985, 0x098C, prAL, gcLo},     //     [8] BENGALI LETTER A..BENGALI LETTER VOCALIC L
	{0x098F, 0x0990, prAL, gcLo},     //     [2] BENGALI LETTER E..BENGALI LETTER AI
	{0x0993, 0x09A8, prAL, gcLo},     //    [22] BENGALI LETTER O..BENGALI LETTER NA
	{0x09AA, 0x09B0, prAL, gcLo},     //     [7] BENGALI LETTER PA..BENGALI LETTER RA
	{0x09B2, 0x09B2, prAL, gcLo},     //         BENGALI LETTER LA
	{0x09B6, 0x09B9, prAL, gcLo},     //     [4] BENGALI LETTER SHA..BENGALI LETTER HA
	{0x09BC, 0x09BC, prCM, gcMn},     //         BENGALI SIGN NUKTA
	{0x09BD, 0x09BD, prAL, gcLo},     //         BENGALI SIGN AVAGRAHA
	{0x09BE, 0x09C0, prCM, gcMc},     //     [3] BENGALI VOWEL SIGN AA..BENGALI VOWEL SIGN II
	{0x09C1, 0x09C4, prCM, gcMn},     //     [4] BENGALI VOWEL SIGN U..BENGALI VOWEL SIGN VOCALIC RR
	{0x09C7, 0x09C8, prCM, gcMc},     //     [2] BENGALI VOWEL SIGN E..BENGALI VOWEL SIGN AI
	{0x09CB, 0x09CC, prCM, gcMc},     //     [2] BENGALI VOWEL SIGN O..BENGALI VOWEL SIGN AU
	{0x09CD, 0x09CD, prCM, gcMn},     //         BENGALI SIGN VIRAMA
	{0x09CE, 0x09CE, prAL, gcLo},     //         BENGALI LETTER KHANDA TA
	{0x09D7, 0x09D7, prCM, gcMc},     //         BENGALI AU LENGTH MARK
	{0x09DC, 0x09DD, prAL, gcLo},     //     [2] BENGALI LETTER RRA..BENGALI LETTER RHA
	{0x09DF, 0x09E1, prAL, gcLo},     //     [3] BENGALI LETTER YYA..BENGALI LETTER VOCALIC LL
	{0x09E2, 0x09E3, prCM, gcMn},     //     [2] BENGALI VOWEL SIGN VOCALIC L..BENGALI VOWEL SIGN VOCALIC LL
	{0x09E6, 0x09EF, prNU, gcNd},     //    [10] BENGALI DIGIT ZERO..BENGALI DIGIT NINE
	{0x09F0, 0x09F1, prAL, gcLo},     //     [2] BENGALI LETTER RA WITH MIDDLE DIAGONAL..BENGALI LETTER RA WITH LOWER DIAGONAL
	{0x09F2, 0x09F3, prPO, gcSc},     //     [2] BENGALI RUPEE MARK..BENGALI RUPEE SIGN
	{0x09F4, 0x09F8, prAL, gcNo},     //     [5] BENGALI CURRENCY NUMERATOR ONE..BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR
	{0x09F9, 0x09F9, prPO, gcNo},     //         BENGALI CURRENCY DENOMINATOR SIXTEEN
	{0x09FA, 0x09FA, prAL, gcSo},     //         BENGALI ISSHAR
	{0x09FB, 0x09FB, prPR, gcSc},     //         BENGALI GANDA MARK
	{0x09FC, 0x09FC, prAL, gcLo},     //         BENGALI LETTER VEDIC ANUSVARA
	{0x09FD, 0x09FD, prAL, gcPo},     //         BENGALI ABBREVIATION SIGN
	{0x09FE, 0x09FE, prCM, gcMn},     //         BENGALI SANDHI MARK
	{0x0A01, 0x0A02, prCM, gcMn},     //     [2] GURMUKHI SIGN ADAK BINDI..GURMUKHI SIGN BINDI
	{0x0A03, 0x0A03, prCM, gcMc},     //         GURMUKHI SIGN VISARGA
	{0x0A05, 0x0A0A, prAL, gcLo},     //     [6] GURMUKHI LETTER A..GURMUKHI LETTER UU
	{0x0A0F, 0x0A10, prAL, gcLo},     //     [2] GURMUKHI LETTER EE..GURMUKHI LETTER AI
	{0x0A13, 0x0A28, prAL, gcLo},     //    [22] GURMUKHI LETTER OO..GURMUKHI LETTER NA
	{0x0A2A, 0x0A30, prAL, gcLo},     //     [7] GURMUKHI LETTER PA..GURMUKHI LETTER RA
	{0x0A32, 0x0A33, prAL, gcLo},     //     [2] GURMUKHI LETTER LA..GURMUKHI LETTER LLA
	{0x0A35, 0x0A36, prAL, gcLo},     //     [2] GURMUKHI LETTER VA..GURMUKHI LETTER SHA
	{0x0A38, 0x0A39, prAL, gcLo},     //     [2] GURMUKHI LETTER SA..GURMUKHI LETTER HA
	{0x0A3C, 0x0A3C, prCM, gcMn},     //         GURMUKHI SIGN NUKTA
	{0x0A3E, 0x0A40, prCM, gcMc},     //     [3] GURMUKHI VOWEL SIGN AA..GURMUKHI VOWEL SIGN II
	{0x0A41, 0x0A42, prCM, gcMn},     //     [2] GURMUKHI VOWEL SIGN U..GURMUKHI VOWEL SIGN UU
	{0x0A47, 0x0A48, prCM, gcMn},     //     [2] GURMUKHI VOWEL SIGN EE..GURMUKHI VOWEL SIGN AI
	{0x0A4B, 0x0A4D, prCM, gcMn},     //     [3] GURMUKHI VOWEL SIGN OO..GURMUKHI SIGN VIRAMA
	{0x0A51, 0x0A51, prCM, gcMn},     //         GURMUKHI SIGN UDAAT
	{0x0A59, 0x0A5C, prAL, gcLo},     //     [4] GURMUKHI LETTER KHHA..GURMUKHI LETTER RRA
	{0x0A5E, 0x0A5E, prAL, gcLo},     //         GURMUKHI LETTER FA
	{0x0A66, 0x0A6F, prNU, gcNd},     //    [10] GURMUKHI DIGIT ZERO..GURMUKHI DIGIT NINE
	{0x0A70, 0x0A71, prCM, gcMn},     //     [2] GURMUKHI TIPPI..GURMUKHI ADDAK
	{0x0A72, 0x0A74, prAL, gcLo},     //     [3] GURMUKHI IRI..GURMUKHI EK ONKAR
	{0x0A75, 0x0A75, prCM, gcMn},     //         GURMUKHI SIGN YAKASH
	{0x0A76, 0x0A76, prAL, gcPo},     //         GURMUKHI ABBREVIATION SIGN
	{0x0A81, 0x0A82, prCM, gcMn},     //     [2] GUJARATI SIGN CANDRABINDU..GUJARATI SIGN ANUSVARA
	{0x0A83, 0x0A83, prCM, gcMc},     //         GUJARATI SIGN VISARGA
	{0x0A85, 0x0A8D, prAL, gcLo},     //     [9] GUJARATI LETTER A..GUJARATI VOWEL CANDRA E
	{0x0A8F, 0x0A91, prAL, gcLo},     //     [3] GUJARATI LETTER E..GUJARATI VOWEL CANDRA O
	{0x0A93, 0x0AA8, prAL, gcLo},     //    [22] GUJARATI LETTER O..GUJARATI LETTER NA
	{0x0AAA, 0x0AB0, prAL, gcLo},     //     [7] GUJARATI LETTER PA..GUJARATI LETTER RA
	{0x0AB2, 0x0AB3, prAL, gcLo},     //     [2] GUJARATI LETTER LA..GUJARATI LETTER LLA
	{0x0AB5, 0x0AB9, prAL, gcLo},     //     [5] GUJARATI LETTER VA..GUJARATI LETTER HA
	{0x0ABC, 0x0ABC, prCM, gcMn},     //         GUJARATI SIGN NUKTA
	{0x0ABD, 0x0ABD, prAL, gcLo},     //         GUJARATI SIGN AVAGRAHA
	{0x0ABE, 0x0AC0, prCM, gcMc},     //     [3] GUJARATI VOWEL SIGN AA..GUJARATI VOWEL SIGN II
	{0x0AC1, 0x0AC5, prCM, gcMn},     //     [5] GUJARATI VOWEL SIGN U..GUJARATI VOWEL SIGN CANDRA E
	{0x0AC7, 0x0AC8, prCM, gcMn},     //     [2] GUJARATI VOWEL SIGN E..GUJARATI VOWEL SIGN AI
	{0x0AC9, 0x0AC9, prCM, gcMc},     //         GUJARATI VOWEL SIGN CANDRA O
	{0x0ACB, 0x0ACC, prCM, gcMc},     //     [2] GUJARATI VOWEL SIGN O..GUJARATI VOWEL SIGN AU
	{0x0ACD, 0x0ACD, prCM, gcMn},     //         GUJARATI SIGN VIRAMA
	{0x0AD0, 0x0AD0, prAL, gcLo},     //         GUJARATI OM
	{0x0AE0, 0x0AE1, prAL, gcLo},     //     [2] GUJARATI LETTER VOCALIC RR..GUJARATI LETTER VOCALIC LL
	{0x0AE2, 0x0AE3, prCM, gcMn},     //     [2] GUJARATI VOWEL SIGN VOCALIC L..GUJARATI VOWEL SIGN VOCALIC LL
	{0x0AE6, 0x0AEF, prNU, gcNd},     //    [10] GUJARATI DIGIT ZERO..GUJARATI DIGIT NINE
	{0x0AF0, 0x0AF0, prAL, gcPo},     //         GUJARATI ABBREVIATION SIGN
	{0x0AF1, 0x0AF1, prPR, gcSc},     //         GUJARATI RUPEE SIGN
	{0x0AF9, 0x0AF9, prAL, gcLo},     //         GUJARATI LETTER ZHA
	{0x0AFA, 0x0AFF, prCM, gcMn},     //     [6] GUJARATI SIGN SUKUN..GUJARATI SIGN TWO-CIRCLE NUKTA ABOVE
	{0x0B01, 0x0B01, prCM, gcMn},     //         ORIYA SIGN CANDRABINDU
	{0x0B02, 0x0B03, prCM, gcMc},     //     [2] ORIYA SIGN ANUSVARA..ORIYA SIGN VISARGA
	{0x0B05, 0x0B0C, prAL, gcLo},     //     [8] ORIYA LETTER A..ORIYA LETTER VOCALIC L
	{0x0B0F, 0x0B10, prAL, gcLo},     //     [2] ORIYA LETTER E..ORIYA LETTER AI
	{0x0B13, 0x0B28, prAL, gcLo},     //    [22] ORIYA LETTER O..ORIYA LETTER NA
	{0x0B2A, 0x0B30, prAL, gcLo},     //     [7] ORIYA LETTER PA..ORIYA LETTER RA
	{0x0B32, 0x0B33, prAL, gcLo},     //     [2] ORIYA LETTER LA..ORIYA LETTER LLA
	{0x0B35, 0x0B39, prAL, gcLo},     //     [5] ORIYA LETTER VA..ORIYA LETTER HA
	{0x0B3C, 0x0B3C, prCM, gcMn},     //         ORIYA SIGN NUKTA
	{0x0B3D, 0x0B3D, prAL, gcLo},     //         ORIYA SIGN AVAGRAHA
	{0x0B3E, 0x0B3E, prCM, gcMc},     //         ORIYA VOWEL SIGN AA
	{0x0B3F, 0x0B3F, prCM, gcMn},     //         ORIYA VOWEL SIGN I
	{0x0B40, 0x0B40, prCM, gcMc},     //         ORIYA VOWEL SIGN II
	{0x0B41, 0x0B44, prCM, gcMn},     //     [4] ORIYA VOWEL SIGN U..ORIYA VOWEL SIGN VOCALIC RR
	{0x0B47, 0x0B48, prCM, gcMc},     //     [2] ORIYA VOWEL SIGN E..ORIYA VOWEL SIGN AI
	{0x0B4B, 0x0B4C, prCM, gcMc},     //     [2] ORIYA VOWEL SIGN O..ORIYA VOWEL SIGN AU
	{0x0B4D, 0x0B4D, prCM, gcMn},     //         ORIYA SIGN VIRAMA
	{0x0B55, 0x0B56, prCM, gcMn},     //     [2] ORIYA SIGN OVERLINE..ORIYA AI LENGTH MARK
	{0x0B57, 0x0B57, prCM, gcMc},     //         ORIYA AU LENGTH MARK
	{0x0B5C, 0x0B5D, prAL, gcLo},     //     [2] ORIYA LETTER RRA..ORIYA LETTER RHA
	{0x0B5F, 0x0B61, prAL, gcLo},     //     [3] ORIYA LETTER YYA..ORIYA LETTER VOCALIC LL
	{0x0B62, 0x0B63, prCM, gcMn},     //     [2] ORIYA VOWEL SIGN VOCALIC L..ORIYA VOWEL SIGN VOCALIC LL
	{0x0B66, 0x0B6F, prNU, gcNd},     //    [10] ORIYA DIGIT ZERO..ORIYA DIGIT NINE
	{0x0B70, 0x0B70, prAL, gcSo},     //         ORIYA ISSHAR
	{0x0B71, 0x0B71, prAL, gcLo},     //         ORIYA LETTER WA
	{0x0B72, 0x0B77, prAL, gcNo},     //     [6] ORIYA FRACTION ONE QUARTER..ORIYA FRACTION THREE SIXTEENTHS
	{0x0B82, 0x0B82, prCM, gcMn},     //         TAMIL SIGN ANUSVARA
	{0x0B83, 0x0B83, prAL, gcLo},     //         TAMIL SIGN VISARGA
	{0x0B85, 0x0B8A, prAL, gcLo},     //     [6] TAMIL LETTER A..TAMIL LETTER UU
	{0x0B8E, 0x0B90, prAL, gcLo},     //     [3] TAMIL LETTER E..TAMIL LETTER AI
	{0x0B92, 0x0B95, prAL, gcLo},     //     [4] TAMIL LETTER O..TAMIL LETTER KA
	{0x0B99, 0x0B9A, prAL, gcLo},     //     [2] TAMIL LETTER NGA..TAMIL LETTER CA
	{0x0B9C, 0x0B9C, prAL, gcLo},     //         TAMIL LETTER JA
	{0x0B9E, 0x0B9F, prAL, gcLo},     //     [2] TAMIL LETTER NYA..TAMIL LETTER TTA
	{0x0BA3, 0x0BA4, prAL, gcLo},     //     [2] TAMIL LETTER NNA..TAMIL LETTER TA
	{0x0BA8, 0x0BAA, prAL, gcLo},     //     [3] TAMIL LETTER NA..TAMIL LETTER PA
	{0x0BAE, 0x0BB9, prAL, gcLo},     //    [12] TAMIL LETTER MA..TAMIL LETTER HA
	{0x0BBE, 0x0BBF, prCM, gcMc},     //     [2] TAMIL VOWEL SIGN AA..TAMIL VOWEL SIGN I
	{0x0BC0, 0x0BC0, prCM, gcMn},     //         TAMIL VOWEL SIGN II
	{0x0BC1, 0x0BC2, prCM, gcMc},     //     [2] TAMIL VOWEL SIGN U..TAMIL VOWEL SIGN UU
	{0x0BC6, 0x0BC8, prCM, gcMc},     //     [3] TAMIL VOWEL SIGN E..TAMIL VOWEL SIGN AI
	{0x0BCA, 0x0BCC, prCM, gcMc},     //     [3] TAMIL VOWEL SIGN O..TAMIL VOWEL SIGN AU
	{0x0BCD, 0x0BCD, prCM, gcMn},     //         TAMIL SIGN VIRAMA
	{0x0BD0, 0x0BD0, prAL, gcLo},     //         TAMIL OM
	{0x0BD7, 0x0BD7, prCM, gcMc},     //         TAMIL AU LENGTH MARK
	{0x0BE6, 0x0BEF, prNU, gcNd},     //    [10] TAMIL DIGIT ZERO..TAMIL DIGIT NINE
	{0x0BF0, 0x0BF2, prAL, gcNo},     //     [3] TAMIL NUMBER TEN..TAMIL NUMBER ONE THOUSAND
	{0x0BF3, 0x0BF8, prAL, gcSo},     //     [6] TAMIL DAY SIGN..TAMIL AS ABOVE SIGN
	{0x0BF9, 0x0BF9, prPR, gcSc},     //         TAMIL RUPEE SIGN
	{0x0BFA, 0x0BFA, prAL, gcSo},     //         TAMIL NUMBER SIGN
	{0x0C00, 0x0C00, prCM, gcMn},     //         TELUGU SIGN COMBINING CANDRABINDU ABOVE
	{0x0C01, 0x0C03, prCM, gcMc},     //     [3] TELUGU SIGN CANDRABINDU..TELUGU SIGN VISARGA
	{0x0C04, 0x0C04, prCM, gcMn},     //         TELUGU SIGN COMBINING ANUSVARA ABOVE
	{0x0C05, 0x0C0C, prAL, gcLo},     //     [8] TELUGU LETTER A..TELUGU LETTER VOCALIC L
	{0x0C0E, 0x0C10, prAL, gcLo},     //     [3] TELUGU LETTER E..TELUGU LETTER AI
	{0x0C12, 0x0C28, prAL, gcLo},     //    [23] TELUGU LETTER O..TELUGU LETTER NA
	{0x0C2A, 0x0C39, prAL, gcLo},     //    [16] TELUGU LETTER PA..TELUGU LETTER HA
	{0x0C3C, 0x0C3C, prCM, gcMn},     //         TELUGU SIGN NUKTA
	{0x0C3D, 0x0C3D, prAL, gcLo},     //         TELUGU SIGN AVAGRAHA
	{0x0C3E, 0x0C40, prCM, gcMn},     //     [3] TELUGU VOWEL SIGN AA..TELUGU VOWEL SIGN II
	{0x0C41, 0x0C44, prCM, gcMc},     //     [4] TELUGU VOWEL SIGN U..TELUGU VOWEL SIGN VOCALIC RR
	{0x0C46, 0x0C48, prCM, gcMn},     //     [3] TELUGU VOWEL SIGN E..TELUGU VOWEL SIGN AI
	{0x0C4A, 0x0C4D, prCM, gcMn},     //     [4] TELUGU VOWEL SIGN O..TELUGU SIGN VIRAMA
	{0x0C55, 0x0C56, prCM, gcMn},     //     [2] TELUGU LENGTH MARK..TELUGU AI LENGTH MARK
	{0x0C58, 0x0C5A, prAL, gcLo},     //     [3] TELUGU LETTER TSA..TELUGU LETTER RRRA
	{0x0C5D, 0x0C5D, prAL, gcLo},     //         TELUGU LETTER NAKAARA POLLU
	{0x0C60, 0x0C61, prAL, gcLo},     //     [2] TELUGU LETTER VOCALIC RR..TELUGU LETTER VOCALIC LL
	{0x0C62, 0x0C63, prCM, gcMn},     //     [2] TELUGU VOWEL SIGN VOCALIC L..TELUGU VOWEL SIGN VOCALIC LL
	{0x0C66, 0x0C6F, prNU, gcNd},     //    [10] TELUGU DIGIT ZERO..TELUGU DIGIT NINE
	{0x0C77, 0x0C77, prBB, gcPo},     //         TELUGU SIGN SIDDHAM
	{0x0C78, 0x0C7E, prAL, gcNo},     //     [7] TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR..TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR
	{0x0C7F, 0x0C7F, prAL, gcSo},     //         TELUGU SIGN TUUMU
	{0x0C80, 0x0C80, prAL, gcLo},     //         KANNADA SIGN SPACING CANDRABINDU
	{0x0C81, 0x0C81, prCM, gcMn},     //         KANNADA SIGN CANDRABINDU
	{0x0C82, 0x0C83, prCM, gcMc},     //     [2] KANNADA SIGN ANUSVARA..KANNADA SIGN VISARGA
	{0x0C84, 0x0C84, prBB, gcPo},     //         KANNADA SIGN SIDDHAM
	{0x0C85, 0x0C8C, prAL, gcLo},     //     [8] KANNADA LETTER A..KANNADA LETTER VOCALIC L
	{0x0C8E, 0x0C90, prAL, gcLo},     //     [3] KANNADA LETTER E..KANNADA LETTER AI
	{0x0C92, 0x0CA8, prAL, gcLo},     //    [23] KANNADA LETTER O..KANNADA LETTER NA
	{0x0CAA, 0x0CB3, prAL, gcLo},     //    [10] KANNADA LETTER PA..KANNADA LETTER LLA
	{0x0CB5, 0x0CB9, prAL, gcLo},     //     [5] KANNADA LETTER VA..KANNADA LETTER HA
	{0x0CBC, 0x0CBC, prCM, gcMn},     //         KANNADA SIGN NUKTA
	{0x0CBD, 0x0CBD, prAL, gcLo},     //         KANNADA SIGN AVAGRAHA
	{0x0CBE, 0x0CBE, prCM, gcMc},     //         KANNADA VOWEL SIGN AA
	{0x0CBF, 0x0CBF, prCM, gcMn},     //         KANNADA VOWEL SIGN I
	{0x0CC0, 0x0CC4, prCM, gcMc},     //     [5] KANNADA VOWEL SIGN II..KANNADA VOWEL SIGN VOCALIC RR
	{0x0CC6, 0x0CC6, prCM, gcMn},     //         KANNADA VOWEL SIGN E
	{0x0CC7, 0x0CC8, prCM, gcMc},     //     [2] KANNADA VOWEL SIGN EE..KANNADA VOWEL SIGN AI
	{0x0CCA, 0x0CCB, prCM, gcMc},     //     [2] KANNADA VOWEL SIGN O..KANNADA VOWEL SIGN OO
	{0x0CCC, 0x0CCD, prCM, gcMn},     //     [2] KANNADA VOWEL SIGN AU..KANNADA SIGN VIRAMA
	{0x0CD5, 0x0CD6, prCM, gcMc},     //     [2] KANNADA LENGTH MARK..KANNADA AI LENGTH MARK
	{0x0CDD, 0x0CDE, prAL, gcLo},     //     [2] KANNADA LETTER NAKAARA POLLU..KANNADA LETTER FA
	{0x0CE0, 0x0CE1, prAL, gcLo},     //     [2] KANNADA LETTER VOCALIC RR..KANNADA LETTER VOCALIC LL
	{0x0CE2, 0x0CE3, prCM, gcMn},     //     [2] KANNADA VOWEL SIGN VOCALIC L..KANNADA VOWEL SIGN VOCALIC LL
	{0x0CE6, 0x0CEF, prNU, gcNd},     //    [10] KANNADA DIGIT ZERO..KANNADA DIGIT NINE
	{0x0CF1, 0x0CF2, prAL, gcLo},     //     [2] KANNADA SIGN JIHVAMULIYA..KANNADA SIGN UPADHMANIYA
	{0x0CF3, 0x0CF3, prCM, gcMc},     //         KANNADA SIGN COMBINING ANUSVARA ABOVE RIGHT
	{0x0D00, 0x0D01, prCM, gcMn},     //     [2] MALAYALAM SIGN COMBINING ANUSVARA ABOVE..MALAYALAM SIGN CANDRABINDU
	{0x0D02, 0x0D03, prCM, gcMc},     //     [2] MALAYALAM SIGN ANUSVARA..MALAYALAM SIGN VISARGA
	{0x0D04, 0x0D0C, prAL, gcLo},     //     [9] MALAYALAM LETTER VEDIC ANUSVARA..MALAYALAM LETTER VOCALIC L
	{0x0D0E, 0x0D10, prAL, gcLo},     //     [3] MALAYALAM LETTER E..MALAYALAM LETTER AI
	{0x0D12, 0x0D3A, prAL, gcLo},     //    [41] MALAYALAM LETTER O..MALAYALAM LETTER TTTA
	{0x0D3B, 0x0D3C, prCM, gcMn},     //     [2] MALAYALAM SIGN VERTICAL BAR VIRAMA..MALAYALAM SIGN CIRCULAR VIRAMA
	{0x0D3D, 0x0D3D, prAL, gcLo},     //         MALAYALAM SIGN AVAGRAHA
	{0x0D3E, 0x0D40, prCM, gcMc},     //     [3] MALAYALAM VOWEL SIGN AA..MALAYALAM VOWEL SIGN II
	{0x0D41, 0x0D44, prCM, gcMn},     //     [4] MALAYALAM VOWEL SIGN U..MALAYALAM VOWEL SIGN VOCALIC RR
	{0x0D46, 0x0D48, prCM, gcMc},     //     [3] MALAYALAM VOWEL SIGN E..MALAYALAM VOWEL SIGN AI
	{0x0D4A, 0x0D4C, prCM, gcMc},     //     [3] MALAYALAM VOWEL SIGN O..MALAYALAM VOWEL SIGN AU
	{0x0D4D, 0x0D4D, prCM, gcMn},     //         MALAYALAM SIGN VIRAMA
	{0x0D4E, 0x0D4E, prAL, gcLo},     //         MALAYALAM LETTER DOT REPH
	{0x0D4F, 0x0D4F, prAL, gcSo},     //         MALAYALAM SIGN PARA
	{0x0D54, 0x0D56, prAL, gcLo},     //     [3] MALAYALAM LETTER CHILLU M..MALAYALAM LETTER CHILLU LLL
	{0x0D57, 0x0D57, prCM, gcMc},     //         MALAYALAM AU LENGTH MARK
	{0x0D58, 0x0D5E, prAL, gcNo},     //     [7] MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH..MALAYALAM FRACTION ONE FIFTH
	{0x0D5F, 0x0D61, prAL, gcLo},     //     [3] MALAYALAM LETTER ARCHAIC II..MALAYALAM LETTER VOCALIC LL
	{0x0D62, 0x0D63, prCM, gcMn},     //     [2] MALAYALAM VOWEL SIGN VOCALIC L..MALAYALAM VOWEL SIGN VOCALIC LL
	{0x0D66, 0x0D6F, prNU, gcNd},     //    [10] MALAYALAM DIGIT ZERO..MALAYALAM DIGIT NINE
	{0x0D70, 0x0D78, prAL, gcNo},     //     [9] MALAYALAM NUMBER TEN..MALAYALAM FRACTION THREE SIXTEENTHS
	{0x0D79, 0x0D79, prPO, gcSo},     //         MALAYALAM DATE MARK
	{0x0D7A, 0x0D7F, prAL, gcLo},     //     [6] MALAYALAM LETTER CHILLU NN..MALAYALAM LETTER CHILLU K
	{0x0D81, 0x0D81, prCM, gcMn},     //         SINHALA SIGN CANDRABINDU
	{0x0D82, 0x0D83, prCM, gcMc},     //     [2] SINHALA SIGN ANUSVARAYA..SINHALA SIGN VISARGAYA
	{0x0D85, 0x0D96, prAL, gcLo},     //    [18] SINHALA LETTER AYANNA..SINHALA LETTER AUYANNA
	{0x0D9A, 0x0DB1, prAL, gcLo},     //    [24] SINHALA LETTER ALPAPRAANA KAYANNA..SINHALA LETTER DANTAJA NAYANNA
	{0x0DB3, 0x0DBB, prAL, gcLo},     //     [9] SINHALA LETTER SANYAKA DAYANNA..SINHALA LETTER RAYANNA
	{0x0DBD, 0x0DBD, prAL, gcLo},     //         SINHALA LETTER DANTAJA LAYANNA
	{0x0DC0, 0x0DC6, prAL, gcLo},     //     [7] SINHALA LETTER VAYANNA..SINHALA LETTER FAYANNA
	{0x0DCA, 0x0DCA, prCM, gcMn},     //         SINHALA SIGN AL-LAKUNA
	{0x0DCF, 0x0DD1, prCM, gcMc},     //     [3] SINHALA VOWEL SIGN AELA-PILLA..SINHALA VOWEL SIGN DIGA AEDA-PILLA
	{0x0DD2, 0x0DD4, prCM, gcMn},     //     [3] SINHALA VOWEL SIGN KETTI IS-PILLA..SINHALA VOWEL SIGN KETTI PAA-PILLA
	{0x0DD6, 0x0DD6, prCM, gcMn},     //         SINHALA VOWEL SIGN DIGA PAA-PILLA
	{0x0DD8, 0x0DDF, prCM, gcMc},     //     [8] SINHALA VOWEL SIGN GAETTA-PILLA..SINHALA VOWEL SIGN GAYANUKITTA
	{0x0DE6, 0x0DEF, prNU, gcNd},     //    [10] SINHALA LITH DIGIT ZERO..SINHALA LITH DIGIT NINE
	{0x0DF2, 0x0DF3, prCM, gcMc},     //     [2] SINHALA VOWEL SIGN DIGA GAETTA-PILLA..SINHALA VOWEL SIGN DIGA GAYANUKITTA
	{0x0DF4, 0x0DF4, prAL, gcPo},     //         SINHALA PUNCTUATION KUNDDALIYA
	{0x0E01, 0x0E30, prSA, gcLo},     //    [48] THAI CHARACTER KO KAI..THAI CHARACTER SARA A
	{0x0E31, 0x0E31, prSA, gcMn},     //         THAI CHARACTER MAI HAN-AKAT
	{0x0E32, 0x0E33, prSA, gcLo},     //     [2] THAI CHARACTER SARA AA..THAI CHARACTER SARA AM
	{0x0E34, 0x0E3A, prSA, gcMn},     //     [7] THAI CHARACTER SARA I..THAI CHARACTER PHINTHU
	{0x0E3F, 0x0E3F, prPR, gcSc},     //         THAI CURRENCY SYMBOL BAHT
	{0x0E40, 0x0E45, prSA, gcLo},     //     [6] THAI CHARACTER SARA E..THAI CHARACTER LAKKHANGYAO
	{0x0E46, 0x0E46, prSA, gcLm},     //         THAI CHARACTER MAIYAMOK
	{0x0E47, 0x0E4E, prSA, gcMn},     //     [8] THAI CHARACTER MAITAIKHU..THAI CHARACTER YAMAKKAN
	{0x0E4F, 0x0E4F, prAL, gcPo},     //         THAI CHARACTER FONGMAN
	{0x0E50, 0x0E59, prNU, gcNd},     //    [10] THAI DIGIT ZERO..THAI DIGIT NINE
	{0x0E5A, 0x0E5B, prBA, gcPo},     //     [2] THAI CHARACTER ANGKHANKHU..THAI CHARACTER KHOMUT
	{0x0E81, 0x0E82, prSA, gcLo},     //     [2] LAO LETTER KO..LAO LETTER KHO SUNG
	{0x0E84, 0x0E84, prSA, gcLo},     //         LAO LETTER KHO TAM
	{0x0E86, 0x0E8A, prSA, gcLo},     //     [5] LAO LETTER PALI GHA..LAO LETTER SO TAM
	{0x0E8C, 0x0EA3, prSA, gcLo},     //    [24] LAO LETTER PALI JHA..LAO LETTER LO LING
	{0x0EA5, 0x0EA5, prSA, gcLo},     //         LAO LETTER LO LOOT
	{0x0EA7, 0x0EB0, prSA, gcLo},     //    [10] LAO LETTER WO..LAO VOWEL SIGN A
	{0x0EB1, 0x0EB1, prSA, gcMn},     //         LAO VOWEL SIGN MAI KAN
	{0x0EB2, 0x0EB3, prSA, gcLo},     //     [2] LAO VOWEL SIGN AA..LAO VOWEL SIGN AM
	{0x0EB4, 0x0EBC, prSA, gcMn},     //     [9] LAO VOWEL SIGN I..LAO SEMIVOWEL SIGN LO
	{0x0EBD, 0x0EBD, prSA, gcLo},     //         LAO SEMIVOWEL SIGN NYO
	{0x0EC0, 0x0EC4, prSA, gcLo},     //     [5] LAO VOWEL SIGN E..LAO VOWEL SIGN AI
	{0x0EC6, 0x0EC6, prSA, gcLm},     //         LAO KO LA
	{0x0EC8, 0x0ECE, prSA, gcMn},     //     [7] LAO TONE MAI EK..LAO YAMAKKAN
	{0x0ED0, 0x0ED9, prNU, gcNd},     //    [10] LAO DIGIT ZERO..LAO DIGIT NINE
	{0x0EDC, 0x0EDF, prSA, gcLo},     //     [4] LAO HO NO..LAO LETTER KHMU NYO
	{0x0F00, 0x0F00, prAL, gcLo},     //         TIBETAN SYLLABLE OM
	{0x0F01, 0x0F03, prBB, gcSo},     //     [3] TIBETAN MARK GTER YIG MGO TRUNCATED A..TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
	{0x0F04, 0x0F04, prBB, gcPo},     //         TIBETAN MARK INITIAL YIG MGO MDUN MA
	{0x0F05, 0x0F05, prAL, gcPo},     //         TIBETAN MARK CLOSING YIG MGO SGAB MA
	{0x0F06, 0x0F07, prBB, gcPo},     //     [2] TIBETAN MARK CARET YIG MGO PHUR SHAD MA..TIBETAN MARK YIG MGO TSHEG SHAD MA
	{0x0F08, 0x0F08, prGL, gcPo},     //         TIBETAN MARK SBRUL SHAD
	{0x0F09, 0x0F0A, prBB, gcPo},     //     [2] TIBETAN MARK BSKUR YIG MGO..TIBETAN MARK BKA- SHOG YIG MGO
	{0x0F0B, 0x0F0B, prBA, gcPo},     //         TIBETAN MARK INTERSYLLABIC TSHEG
	{0x0F0C, 0x0F0C, prGL, gcPo},     //         TIBETAN MARK DELIMITER TSHEG BSTAR
	{0x0F0D, 0x0F11, prEX, gcPo},     //     [5] TIBETAN MARK SHAD..TIBETAN MARK RIN CHEN SPUNGS SHAD
	{0x0F12, 0x0F12, prGL, gcPo},     //         TIBETAN MARK RGYA GRAM SHAD
	{0x0F13, 0x0F13, prAL, gcSo},     //         TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
	{0x0F14, 0x0F14, prEX, gcPo},     //         TIBETAN MARK GTER TSHEG
	{0x0F15, 0x0F17, prAL, gcSo},     //     [3] TIBETAN LOGOTYPE SIGN CHAD RTAGS..TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
	{0x0F18, 0x0F19, prCM, gcMn},     //     [2] TIBETAN ASTROLOGICAL SIGN -KHYUD PA..TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
	{0x0F1A, 0x0F1F, prAL, gcSo},     //     [6] TIBETAN SIGN RDEL DKAR GCIG..TIBETAN SIGN RDEL DKAR RDEL NAG
	{0x0F20, 0x0F29, prNU, gcNd},     //    [10] TIBETAN DIGIT ZERO..TIBETAN DIGIT NINE
	{0x0F2A, 0x0F33, prAL, gcNo},     //    [10] TIBETAN DIGIT HALF ONE..TIBETAN DIGIT HALF ZERO
	{0x0F34, 0x0F34, prBA, gcSo},     //         TIBETAN MARK BSDUS RTAGS
	{0x0F35, 0x0F35, prCM, gcMn},     //         TIBETAN MARK NGAS BZUNG NYI ZLA
	{0x0F36, 0x0F36, prAL, gcSo},     //         TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
	{0x0F37, 0x0F37, prCM, gcMn},     //         TIBETAN MARK NGAS BZUNG SGOR RTAGS
	{0x0F38, 0x0F38, prAL, gcSo},     //         TIBETAN MARK CHE MGO
	{0x0F39, 0x0F39, prCM, gcMn},     //         TIBETAN MARK TSA -PHRU
	{0x0F3A, 0x0F3A, prOP, gcPs},     //         TIBETAN MARK GUG RTAGS GYON
	{0x0F3B, 0x0F3B, prCL, gcPe},     //         TIBETAN MARK GUG RTAGS GYAS
	{0x0F3C, 0x0F3C, prOP, gcPs},     //         TIBETAN MARK ANG KHANG GYON
	{0x0F3D, 0x0F3D, prCL, gcPe},     //         TIBETAN MARK ANG KHANG GYAS
	{0x0F3E, 0x0F3F, prCM, gcMc},     //     [2] TIBETAN SIGN YAR TSHES..TIBETAN SIGN MAR TSHES
	{0x0F40, 0x0F47, prAL, gcLo},     //     [8] TIBETAN LETTER KA..TIBETAN LETTER JA
	{0x0F49, 0x0F6C, prAL, gcLo},     //    [36] TIBETAN LETTER NYA..TIBETAN LETTER RRA
	{0x0F71, 0x0F7E, prCM, gcMn},     //    [14] TIBETAN VOWEL SIGN AA..TIBETAN SIGN RJES SU NGA RO
	{0x0F7F, 0x0F7F, prBA, gcMc},     //         TIBETAN SIGN RNAM BCAD
	{0x0F80, 0x0F84, prCM, gcMn},     //     [5] TIBETAN VOWEL SIGN REVERSED I..TIBETAN MARK HALANTA
	{0x0F85, 0x0F85, prBA, gcPo},     //         TIBETAN MARK PALUTA
	{0x0F86, 0x0F87, prCM, gcMn},     //     [2] TIBETAN SIGN LCI RTAGS..TIBETAN SIGN YANG RTAGS
	{0x0F88, 0x0F8C, prAL, gcLo},     //     [5] TIBETAN SIGN LCE TSA CAN..TIBETAN SIGN INVERTED MCHU CAN
	{0x0F8D, 0x0F97, prCM, gcMn},     //    [11] TIBETAN SUBJOINED SIGN LCE TSA CAN..TIBETAN SUBJOINED LETTER JA
	{0x0F99, 0x0FBC, prCM, gcMn},     //    [36] TIBETAN SUBJOINED LETTER NYA..TIBETAN SUBJOINED LETTER FIXED-FORM RA
	{0x0FBE, 0x0FBF, prBA, gcSo},     //     [2] TIBETAN KU RU KHA..TIBETAN KU RU KHA BZHI MIG CAN
	{0x0FC0, 0x0FC5, prAL, gcSo},     //     [6] TIBETAN CANTILLATION SIGN HEAVY BEAT..TIBETAN SYMBOL RDO RJE
	{0x0FC6, 0x0FC6, prCM, gcMn},     //         TIBETAN SYMBOL PADMA GDAN
	{0x0FC7, 0x0FCC, prAL, gcSo},     //     [6] TIBETAN SYMBOL RDO RJE RGYA GRAM..TIBETAN SYMBOL NOR BU BZHI -KHYIL
	{0x0FCE, 0x0FCF, prAL, gcSo},     //     [2] TIBETAN SIGN RDEL NAG RDEL DKAR..TIBETAN SIGN RDEL NAG GSUM
	{0x0FD0, 0x0FD1, prBB, gcPo},     //     [2] TIBETAN MARK BSKA- SHOG GI MGO RGYAN..TIBETAN MARK MNYAM YIG GI MGO RGYAN
	{0x0FD2, 0x0FD2, prBA, gcPo},     //         TIBETAN MARK NYIS TSHEG
	{0x0FD3, 0x0FD3, prBB, gcPo},     //         TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA
	{0x0FD4, 0x0FD4, prAL, gcPo},     //         TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA
	{0x0FD5, 0x0FD8, prAL, gcSo},     //     [4] RIGHT-FACING SVASTI SIGN..LEFT-FACING SVASTI SIGN WITH DOTS
	{0x0FD9, 0x0FDA, prGL, gcPo},     //     [2] TIBETAN MARK LEADING MCHAN RTAGS..TIBETAN MARK TRAILING MCHAN RTAGS
	{0x1000, 0x102A, prSA, gcLo},     //    [43] MYANMAR LETTER KA..MYANMAR LETTER AU
	{0x102B, 0x102C, prSA, gcMc},     //     [2] MYANMAR VOWEL SIGN TALL AA..MYANMAR VOWEL SIGN AA
	{0x102D, 0x1030, prSA, gcMn},     //     [4] MYANMAR VOWEL SIGN I..MYANMAR VOWEL SIGN UU
	{0x1031, 0x1031, prSA, gcMc},     //         MYANMAR VOWEL SIGN E
	{0x1032, 0x1037, prSA, gcMn},     //     [6] MYANMAR VOWEL SIGN AI..MYANMAR SIGN DOT BELOW
	{0x1038, 0x1038, prSA, gcMc},     //         MYANMAR SIGN VISARGA
	{0x1039, 0x103A, prSA, gcMn},     //     [2] MYANMAR SIGN VIRAMA..MYANMAR SIGN ASAT
	{0x103B, 0x103C, prSA, gcMc},     //     [2] MYANMAR CONSONANT SIGN MEDIAL YA..MYANMAR CONSONANT SIGN MEDIAL RA
	{0x103D, 0x103E, prSA, gcMn},     //     [2] MYANMAR CONSONANT SIGN MEDIAL WA..MYANMAR CONSONANT SIGN MEDIAL HA
	{0x103F, 0x103F, prSA, gcLo},     //         MYANMAR LETTER GREAT SA
	{0x1040, 0x1049, prNU, gcNd},     //    [10] MYANMAR DIGIT ZERO..MYANMAR DIGIT NINE
	{0x104A, 0x104B, prBA, gcPo},     //     [2] MYANMAR SIGN LITTLE SECTION..MYANMAR SIGN SECTION
	{0x104C, 0x104F, prAL, gcPo},     //     [4] MYANMAR SYMBOL LOCATIVE..MYANMAR SYMBOL GENITIVE
	{0x1050, 0x1055, prSA, gcLo},     //     [6] MYANMAR LETTER SHA..MYANMAR LETTER VOCALIC LL
	{0x1056, 0x1057, prSA, gcMc},     //     [2] MYANMAR VOWEL SIGN VOCALIC R..MYANMAR VOWEL SIGN VOCALIC RR
	{0x1058, 0x1059, prSA, gcMn},     //     [2] MYANMAR VOWEL SIGN VOCALIC L..MYANMAR VOWEL SIGN VOCALIC LL
	{0x105A, 0x105D, prSA, gcLo},     //     [4] MYANMAR LETTER MON NGA..MYANMAR LETTER MON BBE
	{0x105E, 0x1060, prSA, gcMn},     //     [3] MYANMAR CONSONANT SIGN MON MEDIAL NA..MYANMAR CONSONANT SIGN MON MEDIAL LA
	{0x1061, 0x1061, prSA, gcLo},     //         MYANMAR LETTER SGAW KAREN SHA
	{0x1062, 0x1064, prSA, gcMc},     //     [3] MYANMAR VOWEL SIGN SGAW KAREN EU..MYANMAR TONE MARK SGAW KAREN KE PHO
	{0x1065, 0x1066, prSA, gcLo},     //     [2] MYANMAR LETTER WESTERN PWO KAREN THA..MYANMAR LETTER WESTERN PWO KAREN PWA
	{0x1067, 0x106D, prSA, gcMc},     //     [7] MYANMAR VOWEL SIGN WESTERN PWO KAREN EU..MYANMAR SIGN WESTERN PWO KAREN TONE-5
	{0x106E, 0x1070, prSA, gcLo},     //     [3] MYANMAR LETTER EASTERN PWO KAREN NNA..MYANMAR LETTER EASTERN PWO KAREN GHWA
	{0x1071, 0x1074, prSA, gcMn},     //     [4] MYANMAR VOWEL SIGN GEBA KAREN I..MYANMAR VOWEL SIGN KAYAH EE
	{0x1075, 0x1081, prSA, gcLo},     //    [13] MYANMAR LETTER SHAN KA..MYANMAR LETTER SHAN HA
	{0x1082, 0x1082, prSA, gcMn},     //         MYANMAR CONSONANT SIGN SHAN MEDIAL WA
	{0x1083, 0x1084, prSA, gcMc},     //     [2] MYANMAR VOWEL SIGN SHAN AA..MYANMAR VOWEL SIGN SHAN E
	{0x1085, 0x1086, prSA, gcMn},     //     [2] MYANMAR VOWEL SIGN SHAN E ABOVE..MYANMAR VOWEL SIGN SHAN FINAL Y
	{0x1087, 0x108C, prSA, gcMc},     //     [6] MYANMAR SIGN SHAN TONE-2..MYANMAR SIGN SHAN COUNCIL TONE-3
	{0x108D, 0x108D, prSA, gcMn},     //         MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE
	{0x108E, 0x108E, prSA, gcLo},     //         MYANMAR LETTER RUMAI PALAUNG FA
	{0x108F, 0x108F, prSA, gcMc},     //         MYANMAR SIGN RUMAI PALAUNG TONE-5
	{0x1090, 0x1099, prNU, gcNd},     //    [10] MYANMAR SHAN DIGIT ZERO..MYANMAR SHAN DIGIT NINE
	{0x109A, 0x109C, prSA, gcMc},     //     [3] MYANMAR SIGN KHAMTI TONE-1..MYANMAR VOWEL SIGN AITON A
	{0x109D, 0x109D, prSA, gcMn},     //         MYANMAR VOWEL SIGN AITON AI
	{0x109E, 0x109F, prSA, gcSo},     //     [2] MYANMAR SYMBOL SHAN ONE..MYANMAR SYMBOL SHAN EXCLAMATION
	{0x10A0, 0x10C5, prAL, gcLu},     //    [38] GEORGIAN CAPITAL LETTER AN..GEORGIAN CAPITAL LETTER HOE
	{0x10C7, 0x10C7, prAL, gcLu},     //         GEORGIAN CAPITAL LETTER YN
	{0x10CD, 0x10CD, prAL, gcLu},     //         GEORGIAN CAPITAL LETTER AEN
	{0x10D0, 0x10FA, prAL, gcLl},     //    [43] GEORGIAN LETTER AN..GEORGIAN LETTER AIN
	{0x10FB, 0x10FB, prAL, gcPo},     //         GEORGIAN PARAGRAPH SEPARATOR
	{0x10FC, 0x10FC, prAL, gcLm},     //         MODIFIER LETTER GEORGIAN NAR
	{0x10FD, 0x10FF, prAL, gcLl},     //     [3] GEORGIAN LETTER AEN..GEORGIAN LETTER LABIAL SIGN
	{0x1100, 0x115F, prJL, gcLo},     //    [96] HANGUL CHOSEONG KIYEOK..HANGUL CHOSEONG FILLER
	{0x1160, 0x11A7, prJV, gcLo},     //    [72] HANGUL JUNGSEONG FILLER..HANGUL JUNGSEONG O-YAE
	{0x11A8, 0x11FF, prJT, gcLo},     //    [88] HANGUL JONGSEONG KIYEOK..HANGUL JONGSEONG SSANGNIEUN
	{0x1200, 0x1248, prAL, gcLo},     //    [73] ETHIOPIC SYLLABLE HA..ETHIOPIC SYLLABLE QWA
	{0x124A, 0x124D, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE QWI..ETHIOPIC SYLLABLE QWE
	{0x1250, 0x1256, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE QHA..ETHIOPIC SYLLABLE QHO
	{0x1258, 0x1258, prAL, gcLo},     //         ETHIOPIC SYLLABLE QHWA
	{0x125A, 0x125D, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE QHWI..ETHIOPIC SYLLABLE QHWE
	{0x1260, 0x1288, prAL, gcLo},     //    [41] ETHIOPIC SYLLABLE BA..ETHIOPIC SYLLABLE XWA
	{0x128A, 0x128D, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE XWI..ETHIOPIC SYLLABLE XWE
	{0x1290, 0x12B0, prAL, gcLo},     //    [33] ETHIOPIC SYLLABLE NA..ETHIOPIC SYLLABLE KWA
	{0x12B2, 0x12B5, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE KWI..ETHIOPIC SYLLABLE KWE
	{0x12B8, 0x12BE, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE KXA..ETHIOPIC SYLLABLE KXO
	{0x12C0, 0x12C0, prAL, gcLo},     //         ETHIOPIC SYLLABLE KXWA
	{0x12C2, 0x12C5, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE KXWI..ETHIOPIC SYLLABLE KXWE
	{0x12C8, 0x12D6, prAL, gcLo},     //    [15] ETHIOPIC SYLLABLE WA..ETHIOPIC SYLLABLE PHARYNGEAL O
	{0x12D8, 0x1310, prAL, gcLo},     //    [57] ETHIOPIC SYLLABLE ZA..ETHIOPIC SYLLABLE GWA
	{0x1312, 0x1315, prAL, gcLo},     //     [4] ETHIOPIC SYLLABLE GWI..ETHIOPIC SYLLABLE GWE
	{0x1318, 0x135A, prAL, gcLo},     //    [67] ETHIOPIC SYLLABLE GGA..ETHIOPIC SYLLABLE FYA
	{0x135D, 0x135F, prCM, gcMn},     //     [3] ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK..ETHIOPIC COMBINING GEMINATION MARK
	{0x1360, 0x1360, prAL, gcPo},     //         ETHIOPIC SECTION MARK
	{0x1361, 0x1361, prBA, gcPo},     //         ETHIOPIC WORDSPACE
	{0x1362, 0x1368, prAL, gcPo},     //     [7] ETHIOPIC FULL STOP..ETHIOPIC PARAGRAPH SEPARATOR
	{0x1369, 0x137C, prAL, gcNo},     //    [20] ETHIOPIC DIGIT ONE..ETHIOPIC NUMBER TEN THOUSAND
	{0x1380, 0x138F, prAL, gcLo},     //    [16] ETHIOPIC SYLLABLE SEBATBEIT MWA..ETHIOPIC SYLLABLE PWE
	{0x1390, 0x1399, prAL, gcSo},     //    [10] ETHIOPIC TONAL MARK YIZET..ETHIOPIC TONAL MARK KURT
	{0x13A0, 0x13F5, prAL, gcLu},     //    [86] CHEROKEE LETTER A..CHEROKEE LETTER MV
	{0x13F8, 0x13FD, prAL, gcLl},     //     [6] CHEROKEE SMALL LETTER YE..CHEROKEE SMALL LETTER MV
	{0x1400, 0x1400, prBA, gcPd},     //         CANADIAN SYLLABICS HYPHEN
	{0x1401, 0x166C, prAL, gcLo},     //   [620] CANADIAN SYLLABICS E..CANADIAN SYLLABICS CARRIER TTSA
	{0x166D, 0x166D, prAL, gcSo},     //         CANADIAN SYLLABICS CHI SIGN
	{0x166E, 0x166E, prAL, gcPo},     //         CANADIAN SYLLABICS FULL STOP
	{0x166F, 0x167F, prAL, gcLo},     //    [17] CANADIAN SYLLABICS QAI..CANADIAN SYLLABICS BLACKFOOT W
	{0x1680, 0x1680, prBA, gcZs},     //         OGHAM SPACE MARK
	{0x1681, 0x169A, prAL, gcLo},     //    [26] OGHAM LETTER BEITH..OGHAM LETTER PEITH
	{0x169B, 0x169B, prOP, gcPs},     //         OGHAM FEATHER MARK
	{0x169C, 0x169C, prCL, gcPe},     //         OGHAM REVERSED FEATHER MARK
	{0x16A0, 0x16EA, prAL, gcLo},     //    [75] RUNIC LETTER FEHU FEOH FE F..RUNIC LETTER X
	{0x16EB, 0x16ED, prBA, gcPo},     //     [3] RUNIC SINGLE PUNCTUATION..RUNIC CROSS PUNCTUATION
	{0x16EE, 0x16F0, prAL, gcNl},     //     [3] RUNIC ARLAUG SYMBOL..RUNIC BELGTHOR SYMBOL
	{0x16F1, 0x16F8, prAL, gcLo},     //     [8] RUNIC LETTER K..RUNIC LETTER FRANKS CASKET AESC
	{0x1700, 0x1711, prAL, gcLo},     //    [18] TAGALOG LETTER A..TAGALOG LETTER HA
	{0x1712, 0x1714, prCM, gcMn},     //     [3] TAGALOG VOWEL SIGN I..TAGALOG SIGN VIRAMA
	{0x1715, 0x1715, prCM, gcMc},     //         TAGALOG SIGN PAMUDPOD
	{0x171F, 0x171F, prAL, gcLo},     //         TAGALOG LETTER ARCHAIC RA
	{0x1720, 0x1731, prAL, gcLo},     //    [18] HANUNOO LETTER A..HANUNOO LETTER HA
	{0x1732, 0x1733, prCM, gcMn},     //     [2] HANUNOO VOWEL SIGN I..HANUNOO VOWEL SIGN U
	{0x1734, 0x1734, prCM, gcMc},     //         HANUNOO SIGN PAMUDPOD
	{0x1735, 0x1736, prBA, gcPo},     //     [2] PHILIPPINE SINGLE PUNCTUATION..PHILIPPINE DOUBLE PUNCTUATION
	{0x1740, 0x1751, prAL, gcLo},     //    [18] BUHID LETTER A..BUHID LETTER HA
	{0x1752, 0x1753, prCM, gcMn},     //     [2] BUHID VOWEL SIGN I..BUHID VOWEL SIGN U
	{0x1760, 0x176C, prAL, gcLo},     //    [13] TAGBANWA LETTER A..TAGBANWA LETTER YA
	{0x176E, 0x1770, prAL, gcLo},     //     [3] TAGBANWA LETTER LA..TAGBANWA LETTER SA
	{0x1772, 0x1773, prCM, gcMn},     //     [2] TAGBANWA VOWEL SIGN I..TAGBANWA VOWEL SIGN U
	{0x1780, 0x17B3, prSA, gcLo},     //    [52] KHMER LETTER KA..KHMER INDEPENDENT VOWEL QAU
	{0x17B4, 0x17B5, prSA, gcMn},     //     [2] KHMER VOWEL INHERENT AQ..KHMER VOWEL INHERENT AA
	{0x17B6, 0x17B6, prSA, gcMc},     //         KHMER VOWEL SIGN AA
	{0x17B7, 0x17BD, prSA, gcMn},     //     [7] KHMER VOWEL SIGN I..KHMER VOWEL SIGN UA
	{0x17BE, 0x17C5, prSA, gcMc},     //     [8] KHMER VOWEL SIGN OE..KHMER VOWEL SIGN AU
	{0x17C6, 0x17C6, prSA, gcMn},     //         KHMER SIGN NIKAHIT
	{0x17C7, 0x17C8, prSA, gcMc},     //     [2] KHMER SIGN REAHMUK..KHMER SIGN YUUKALEAPINTU
	{0x17C9, 0x17D3, prSA, gcMn},     //    [11] KHMER SIGN MUUSIKATOAN..KHMER SIGN BATHAMASAT
	{0x17D4, 0x17D5, prBA, gcPo},     //     [2] KHMER SIGN KHAN..KHMER SIGN BARIYOOSAN
	{0x17D6, 0x17D6, prNS, gcPo},     //         KHMER SIGN CAMNUC PII KUUH
	{0x17D7, 0x17D7, prSA, gcLm},     //         KHMER SIGN LEK TOO
	{0x17D8, 0x17D8, prBA, gcPo},     //         KHMER SIGN BEYYAL
	{0x17D9, 0x17D9, prAL, gcPo},     //         KHMER SIGN PHNAEK MUAN
	{0x17DA, 0x17DA, prBA, gcPo},     //         KHMER SIGN KOOMUUT
	{0x17DB, 0x17DB, prPR, gcSc},     //         KHMER CURRENCY SYMBOL RIEL
	{0x17DC, 0x17DC, prSA, gcLo},     //         KHMER SIGN AVAKRAHASANYA
	{0x17DD, 0x17DD, prSA, gcMn},     //         KHMER SIGN ATTHACAN
	{0x17E0, 0x17E9, prNU, gcNd},     //    [10] KHMER DIGIT ZERO..KHMER DIGIT NINE
	{0x17F0, 0x17F9, prAL, gcNo},     //    [10] KHMER SYMBOL LEK ATTAK SON..KHMER SYMBOL LEK ATTAK PRAM-BUON
	{0x1800, 0x1801, prAL, gcPo},     //     [2] MONGOLIAN BIRGA..MONGOLIAN ELLIPSIS
	{0x1802, 0x1803, prEX, gcPo},     //     [2] MONGOLIAN COMMA..MONGOLIAN FULL STOP
	{0x1804, 0x1805, prBA, gcPo},     //     [2] MONGOLIAN COLON..MONGOLIAN FOUR DOTS
	{0x1806, 0x1806, prBB, gcPd},     //         MONGOLIAN TODO SOFT HYPHEN
	{0x1807, 0x1807, prAL, gcPo},     //         MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER
	{0x1808, 0x1809, prEX, gcPo},     //     [2] MONGOLIAN MANCHU COMMA..MONGOLIAN MANCHU FULL STOP
	{0x180A, 0x180A, prAL, gcPo},     //         MONGOLIAN NIRUGU
	{0x180B, 0x180D, prCM, gcMn},     //     [3] MONGOLIAN FREE VARIATION SELECTOR ONE..MONGOLIAN FREE VARIATION SELECTOR THREE
	{0x180E, 0x180E, prGL, gcCf},     //         MONGOLIAN VOWEL SEPARATOR
	{0x180F, 0x180F, prCM, gcMn},     //         MONGOLIAN FREE VARIATION SELECTOR FOUR
	{0x1810, 0x1819, prNU, gcNd},     //    [10] MONGOLIAN DIGIT ZERO..MONGOLIAN DIGIT NINE
	{0x1820, 0x1842, prAL, gcLo},     //    [35] MONGOLIAN LETTER A..MONGOLIAN LETTER CHI
	{0x1843, 0x1843, prAL, gcLm},     //         MONGOLIAN LETTER TODO LONG VOWEL SIGN
	{0x1844, 0x1878, prAL, gcLo},     //    [53] MONGOLIAN LETTER TODO E..MONGOLIAN LETTER CHA WITH TWO DOTS
	{0x1880, 0x1884, prAL, gcLo},     //     [5] MONGOLIAN LETTER ALI GALI ANUSVARA ONE..MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
	{0x1885, 0x1886, prCM, gcMn},     //     [2] MONGOLIAN LETTER ALI GALI BALUDA..MONGOLIAN LETTER ALI GALI THREE BALUDA
	{0x1887, 0x18A8, prAL, gcLo},     //    [34] MONGOLIAN LETTER ALI GALI A..MONGOLIAN LETTER MANCHU ALI GALI BHA
	{0x18A9, 0x18A9, prCM, gcMn},     //         MONGOLIAN LETTER ALI GALI DAGALGA
	{0x18AA, 0x18AA, prAL, gcLo},     //         MONGOLIAN LETTER MANCHU ALI GALI LHA
	{0x18B0, 0x18F5, prAL, gcLo},     //    [70] CANADIAN SYLLABICS OY..CANADIAN SYLLABICS CARRIER DENTAL S
	{0x1900, 0x191E, prAL, gcLo},     //    [31] LIMBU VOWEL-CARRIER LETTER..LIMBU LETTER TRA
	{0x1920, 0x1922, prCM, gcMn},     //     [3] LIMBU VOWEL SIGN A..LIMBU VOWEL SIGN U
	{0x1923, 0x1926, prCM, gcMc},     //     [4] LIMBU VOWEL SIGN EE..LIMBU VOWEL SIGN AU
	{0x1927, 0x1928, prCM, gcMn},     //     [2] LIMBU VOWEL SIGN E..LIMBU VOWEL SIGN O
	{0x1929, 0x192B, prCM, gcMc},     //     [3] LIMBU SUBJOINED LETTER YA..LIMBU SUBJOINED LETTER WA
	{0x1930, 0x1931, prCM, gcMc},     //     [2] LIMBU SMALL LETTER KA..LIMBU SMALL LETTER NGA
	{0x1932, 0x1932, prCM, gcMn},     //         LIMBU SMALL LETTER ANUSVARA
	{0x1933, 0x1938, prCM, gcMc},     //     [6] LIMBU SMALL LETTER TA..LIMBU SMALL LETTER LA
	{0x1939, 0x193B, prCM, gcMn},     //     [3] LIMBU SIGN MUKPHRENG..LIMBU SIGN SA-I
	{0x1940, 0x1940, prAL, gcSo},     //         LIMBU SIGN LOO
	{0x1944, 0x1945, prEX, gcPo},     //     [2] LIMBU EXCLAMATION MARK..LIMBU QUESTION MARK
	{0x1946, 0x194F, prNU, gcNd},     //    [10] LIMBU DIGIT ZERO..LIMBU DIGIT NINE
	{0x1950, 0x196D, prSA, gcLo},     //    [30] TAI LE LETTER KA..TAI LE LETTER AI
	{0x1970, 0x1974, prSA, gcLo},     //     [5] TAI LE LETTER TONE-2..TAI LE LETTER TONE-6
	{0x1980, 0x19AB, prSA, gcLo},     //    [44] NEW TAI LUE LETTER HIGH QA..NEW TAI LUE LETTER LOW SUA
	{0x19B0, 0x19C9, prSA, gcLo},     //    [26] NEW TAI LUE VOWEL SIGN VOWEL SHORTENER..NEW TAI LUE TONE MARK-2
	{0x19D0, 0x19D9, prNU, gcNd},     //    [10] NEW TAI LUE DIGIT ZERO..NEW TAI LUE DIGIT NINE
	{0x19DA, 0x19DA, prSA, gcNo},     //         NEW TAI LUE THAM DIGIT ONE
	{0x19DE, 0x19DF, prSA, gcSo},     //     [2] NEW TAI LUE SIGN LAE..NEW TAI LUE SIGN LAEV
	{0x19E0, 0x19FF, prAL, gcSo},     //    [32] KHMER SYMBOL PATHAMASAT..KHMER SYMBOL DAP-PRAM ROC
	{0x1A00, 0x1A16, prAL, gcLo},     //    [23] BUGINESE LETTER KA..BUGINESE LETTER HA
	{0x1A17, 0x1A18, prCM, gcMn},     //     [2] BUGINESE VOWEL SIGN I..BUGINESE VOWEL SIGN U
	{0x1A19, 0x1A1A, prCM, gcMc},     //     [2] BUGINESE VOWEL SIGN E..BUGINESE VOWEL SIGN O
	{0x1A1B, 0x1A1B, prCM, gcMn},     //         BUGINESE VOWEL SIGN AE
	{0x1A1E, 0x1A1F, prAL, gcPo},     //     [2] BUGINESE PALLAWA..BUGINESE END OF SECTION
	{0x1A20, 0x1A54, prSA, gcLo},     //    [53] TAI THAM LETTER HIGH KA..TAI THAM LETTER GREAT SA
	{0x1A55, 0x1A55, prSA, gcMc},     //         TAI THAM CONSONANT SIGN MEDIAL RA
	{0x1A56, 0x1A56, prSA, gcMn},     //         TAI THAM CONSONANT SIGN MEDIAL LA
	{0x1A57, 0x1A57, prSA, gcMc},     //         TAI THAM CONSONANT SIGN LA TANG LAI
	{0x1A58, 0x1A5E, prSA, gcMn},     //     [7] TAI THAM SIGN MAI KANG LAI..TAI THAM CONSONANT SIGN SA
	{0x1A60, 0x1A60, prSA, gcMn},     //         TAI THAM SIGN SAKOT
	{0x1A61, 0x1A61, prSA, gcMc},     //         TAI THAM VOWEL SIGN A
	{0x1A62, 0x1A62, prSA, gcMn},     //         TAI THAM VOWEL SIGN MAI SAT
	{0x1A63, 0x1A64, prSA, gcMc},     //     [2] TAI THAM VOWEL SIGN AA..TAI THAM VOWEL SIGN TALL AA
	{0x1A65, 0x1A6C, prSA, gcMn},     //     [8] TAI THAM VOWEL SIGN I..TAI THAM VOWEL SIGN OA BELOW
	{0x1A6D, 0x1A72, prSA, gcMc},     //     [6] TAI THAM VOWEL SIGN OY..TAI THAM VOWEL SIGN THAM AI
	{0x1A73, 0x1A7C, prSA, gcMn},     //    [10] TAI THAM VOWEL SIGN OA ABOVE..TAI THAM SIGN KHUEN-LUE KARAN
	{0x1A7F, 0x1A7F, prCM, gcMn},     //         TAI THAM COMBINING CRYPTOGRAMMIC DOT
	{0x1A80, 0x1A89, prNU, gcNd},     //    [10] TAI THAM HORA DIGIT ZERO..TAI THAM HORA DIGIT NINE
	{0x1A90, 0x1A99, prNU, gcNd},     //    [10] TAI THAM THAM DIGIT ZERO..TAI THAM THAM DIGIT NINE
	{0x1AA0, 0x1AA6, prSA, gcPo},     //     [7] TAI THAM SIGN WIANG..TAI THAM SIGN REVERSED ROTATED RANA
	{0x1AA7, 0x1AA7, prSA, gcLm},     //         TAI THAM SIGN MAI YAMOK
	{0x1AA8, 0x1AAD, prSA, gcPo},     //     [6] TAI THAM SIGN KAAN..TAI THAM SIGN CAANG
	{0x1AB0, 0x1ABD, prCM, gcMn},     //    [14] COMBINING DOUBLED CIRCUMFLEX ACCENT..COMBINING PARENTHESES BELOW
	{0x1ABE, 0x1ABE, prCM, gcMe},     //         COMBINING PARENTHESES OVERLAY
	{0x1ABF, 0x1ACE, prCM, gcMn},     //    [16] COMBINING LATIN SMALL LETTER W BELOW..COMBINING LATIN SMALL LETTER INSULAR T
	{0x1B00, 0x1B03, prCM, gcMn},     //     [4] BALINESE SIGN ULU RICEM..BALINESE SIGN SURANG
	{0x1B04, 0x1B04, prCM, gcMc},     //         BALINESE SIGN BISAH
	{0x1B05, 0x1B33, prAL, gcLo},     //    [47] BALINESE LETTER AKARA..BALINESE LETTER HA
	{0x1B34, 0x1B34, prCM, gcMn},     //         BALINESE SIGN REREKAN
	{0x1B35, 0x1B35, prCM, gcMc},     //         BALINESE VOWEL SIGN TEDUNG
	{0x1B36, 0x1B3A, prCM, gcMn},     //     [5] BALINESE VOWEL SIGN ULU..BALINESE VOWEL SIGN RA REPA
	{0x1B3B, 0x1B3B, prCM, gcMc},     //         BALINESE VOWEL SIGN RA REPA TEDUNG
	{0x1B3C, 0x1B3C, prCM, gcMn},     //         BALINESE VOWEL SIGN LA LENGA
	{0x1B3D, 0x1B41, prCM, gcMc},     //     [5] BALINESE VOWEL SIGN LA LENGA TEDUNG..BALINESE VOWEL SIGN TALING REPA TEDUNG
	{0x1B42, 0x1B42, prCM, gcMn},     //         BALINESE VOWEL SIGN PEPET
	{0x1B43, 0x1B44, prCM, gcMc},     //     [2] BALINESE VOWEL SIGN PEPET TEDUNG..BALINESE ADEG ADEG
	{0x1B45, 0x1B4C, prAL, gcLo},     //     [8] BALINESE LETTER KAF SASAK..BALINESE LETTER ARCHAIC JNYA
	{0x1B50, 0x1B59, prNU, gcNd},     //    [10] BALINESE DIGIT ZERO..BALINESE DIGIT NINE
	{0x1B5A, 0x1B5B, prBA, gcPo},     //     [2] BALINESE PANTI..BALINESE PAMADA
	{0x1B5C, 0x1B5C, prAL, gcPo},     //         BALINESE WINDU
	{0x1B5D, 0x1B60, prBA, gcPo},     //     [4] BALINESE CARIK PAMUNGKAH..BALINESE PAMENENG
	{0x1B61, 0x1B6A, prAL, gcSo},     //    [10] BALINESE MUSICAL SYMBOL DONG..BALINESE MUSICAL SYMBOL DANG GEDE
	{0x1B6B, 0x1B73, prCM, gcMn},     //     [9] BALINESE MUSICAL SYMBOL COMBINING TEGEH..BALINESE MUSICAL SYMBOL COMBINING GONG
	{0x1B74, 0x1B7C, prAL, gcSo},     //     [9] BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG..BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING
	{0x1B7D, 0x1B7E, prBA, gcPo},     //     [2] BALINESE PANTI LANTANG..BALINESE PAMADA LANTANG
	{0x1B80, 0x1B81, prCM, gcMn},     //     [2] SUNDANESE SIGN PANYECEK..SUNDANESE SIGN PANGLAYAR
	{0x1B82, 0x1B82, prCM, gcMc},     //         SUNDANESE SIGN PANGWISAD
	{0x1B83, 0x1BA0, prAL, gcLo},     //    [30] SUNDANESE LETTER A..SUNDANESE LETTER HA
	{0x1BA1, 0x1BA1, prCM, gcMc},     //         SUNDANESE CONSONANT SIGN PAMINGKAL
	{0x1BA2, 0x1BA5, prCM, gcMn},     //     [4] SUNDANESE CONSONANT SIGN PANYAKRA..SUNDANESE VOWEL SIGN PANYUKU
	{0x1BA6, 0x1BA7, prCM, gcMc},     //     [2] SUNDANESE VOWEL SIGN PANAELAENG..SUNDANESE VOWEL SIGN PANOLONG
	{0x1BA8, 0x1BA9, prCM, gcMn},     //     [2] SUNDANESE VOWEL SIGN PAMEPET..SUNDANESE VOWEL SIGN PANEULEUNG
	{0x1BAA, 0x1BAA, prCM, gcMc},     //         SUNDANESE SIGN PAMAAEH
	{0x1BAB, 0x1BAD, prCM, gcMn},     //     [3] SUNDANESE SIGN VIRAMA..SUNDANESE CONSONANT SIGN PASANGAN WA
	{0x1BAE, 0x1BAF, prAL, gcLo},     //     [2] SUNDANESE LETTER KHA..SUNDANESE LETTER SYA
	{0x1BB0, 0x1BB9, prNU, gcNd},     //    [10] SUNDANESE DIGIT ZERO..SUNDANESE DIGIT NINE
	{0x1BBA, 0x1BBF, prAL, gcLo},     //     [6] SUNDANESE AVAGRAHA..SUNDANESE LETTER FINAL M
	{0x1BC0, 0x1BE5, prAL, gcLo},     //    [38] BATAK LETTER A..BATAK LETTER U
	{0x1BE6, 0x1BE6, prCM, gcMn},     //         BATAK SIGN TOMPI
	{0x1BE7, 0x1BE7, prCM, gcMc},     //         BATAK VOWEL SIGN E
	{0x1BE8, 0x1BE9, prCM, gcMn},     //     [2] BATAK VOWEL SIGN PAKPAK E..BATAK VOWEL SIGN EE
	{0x1BEA, 0x1BEC, prCM, gcMc},     //     [3] BATAK VOWEL SIGN I..BATAK VOWEL SIGN O
	{0x1BED, 0x1BED, prCM, gcMn},     //         BATAK VOWEL SIGN KARO O
	{0x1BEE, 0x1BEE, prCM, gcMc},     //         BATAK VOWEL SIGN U
	{0x1BEF, 0x1BF1, prCM, gcMn},     //     [3] BATAK VOWEL SIGN U FOR SIMALUNGUN SA..BATAK CONSONANT SIGN H
	{0x1BF2, 0x1BF3, prCM, gcMc},     //     [2] BATAK PANGOLAT..BATAK PANONGONAN
	{0x1BFC, 0x1BFF, prAL, gcPo},     //     [4] BATAK SYMBOL BINDU NA METEK..BATAK SYMBOL BINDU PANGOLAT
	{0x1C00, 0x1C23, prAL, gcLo},     //    [36] LEPCHA LETTER KA..LEPCHA LETTER A
	{0x1C24, 0x1C2B, prCM, gcMc},     //     [8] LEPCHA SUBJOINED LETTER YA..LEPCHA VOWEL SIGN UU
	{0x1C2C, 0x1C33, prCM, gcMn},     //     [8] LEPCHA VOWEL SIGN E..LEPCHA CONSONANT SIGN T
	{0x1C34, 0x1C35, prCM, gcMc},     //     [2] LEPCHA CONSONANT SIGN NYIN-DO..LEPCHA CONSONANT SIGN KANG
	{0x1C36, 0x1C37, prCM, gcMn},     //     [2] LEPCHA SIGN RAN..LEPCHA SIGN NUKTA
	{0x1C3B, 0x1C3F, prBA, gcPo},     //     [5] LEPCHA PUNCTUATION TA-ROL..LEPCHA PUNCTUATION TSHOOK
	{0x1C40, 0x1C49, prNU, gcNd},     //    [10] LEPCHA DIGIT ZERO..LEPCHA DIGIT NINE
	{0x1C4D, 0x1C4F, prAL, gcLo},     //     [3] LEPCHA LETTER TTA..LEPCHA LETTER DDA
	{0x1C50, 0x1C59, prNU, gcNd},     //    [10] OL CHIKI DIGIT ZERO..OL CHIKI DIGIT NINE
	{0x1C5A, 0x1C77, prAL, gcLo},     //    [30] OL CHIKI LETTER LA..OL CHIKI LETTER OH
	{0x1C78, 0x1C7D, prAL, gcLm},     //     [6] OL CHIKI MU TTUDDAG..OL CHIKI AHAD
	{0x1C7E, 0x1C7F, prBA, gcPo},     //     [2] OL CHIKI PUNCTUATION MUCAAD..OL CHIKI PUNCTUATION DOUBLE MUCAAD
	{0x1C80, 0x1C88, prAL, gcLl},     //     [9] CYRILLIC SMALL LETTER ROUNDED VE..CYRILLIC SMALL LETTER UNBLENDED UK
	{0x1C90, 0x1CBA, prAL, gcLu},     //    [43] GEORGIAN MTAVRULI CAPITAL LETTER AN..GEORGIAN MTAVRULI CAPITAL LETTER AIN
	{0x1CBD, 0x1CBF, prAL, gcLu},     //     [3] GEORGIAN MTAVRULI CAPITAL LETTER AEN..GEORGIAN MTAVRULI CAPITAL LETTER LABIAL SIGN
	{0x1CC0, 0x1CC7, prAL, gcPo},     //     [8] SUNDANESE PUNCTUATION BINDU SURYA..SUNDANESE PUNCTUATION BINDU BA SATANGA
	{0x1CD0, 0x1CD2, prCM, gcMn},     //     [3] VEDIC TONE KARSHANA..VEDIC TONE PRENKHA
	{0x1CD3, 0x1CD3, prAL, gcPo},     //         VEDIC SIGN NIHSHVASA
	{0x1CD4, 0x1CE0, prCM, gcMn},     //    [13] VEDIC SIGN YAJURVEDIC MIDLINE SVARITA..VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA
	{0x1CE1, 0x1CE1, prCM, gcMc},     //         VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA
	{0x1CE2, 0x1CE8, prCM, gcMn},     //     [7] VEDIC SIGN VISARGA SVARITA..VEDIC SIGN VISARGA ANUDATTA WITH TAIL
	{0x1CE9, 0x1CEC, prAL, gcLo},     //     [4] VEDIC SIGN ANUSVARA ANTARGOMUKHA..VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL
	{0x1CED, 0x1CED, prCM, gcMn},     //         VEDIC SIGN TIRYAK
	{0x1CEE, 0x1CF3, prAL, gcLo},     //     [6] VEDIC SIGN HEXIFORM LONG ANUSVARA..VEDIC SIGN ROTATED ARDHAVISARGA
	{0x1CF4, 0x1CF4, prCM, gcMn},     //         VEDIC TONE CANDRA ABOVE
	{0x1CF5, 0x1CF6, prAL, gcLo},     //     [2] VEDIC SIGN JIHVAMULIYA..VEDIC SIGN UPADHMANIYA
	{0x1CF7, 0x1CF7, prCM, gcMc},     //         VEDIC SIGN ATIKRAMA
	{0x1CF8, 0x1CF9, prCM, gcMn},     //     [2] VEDIC TONE RING ABOVE..VEDIC TONE DOUBLE RING ABOVE
	{0x1CFA, 0x1CFA, prAL, gcLo},     //         VEDIC SIGN DOUBLE ANUSVARA ANTARGOMUKHA
	{0x1D00, 0x1D2B, prAL, gcLl},     //    [44] LATIN LETTER SMALL CAPITAL A..CYRILLIC LETTER SMALL CAPITAL EL
	{0x1D2C, 0x1D6A, prAL, gcLm},     //    [63] MODIFIER LETTER CAPITAL A..GREEK SUBSCRIPT SMALL LETTER CHI
	{0x1D6B, 0x1D77, prAL, gcLl},     //    [13] LATIN SMALL LETTER UE..LATIN SMALL LETTER TURNED G
	{0x1D78, 0x1D78, prAL, gcLm},     //         MODIFIER LETTER CYRILLIC EN
	{0x1D79, 0x1D7F, prAL, gcLl},     //     [7] LATIN SMALL LETTER INSULAR G..LATIN SMALL LETTER UPSILON WITH STROKE
	{0x1D80, 0x1D9A, prAL, gcLl},     //    [27] LATIN SMALL LETTER B WITH PALATAL HOOK..LATIN SMALL LETTER EZH WITH RETROFLEX HOOK
	{0x1D9B, 0x1DBF, prAL, gcLm},     //    [37] MODIFIER LETTER SMALL TURNED ALPHA..MODIFIER LETTER SMALL THETA
	{0x1DC0, 0x1DCC, prCM, gcMn},     //    [13] COMBINING DOTTED GRAVE ACCENT..COMBINING MACRON-BREVE
	{0x1DCD, 0x1DCD, prGL, gcMn},     //         COMBINING DOUBLE CIRCUMFLEX ABOVE
	{0x1DCE, 0x1DFB, prCM, gcMn},     //    [46] COMBINING OGONEK ABOVE..COMBINING DELETION MARK
	{0x1DFC, 0x1DFC, prGL, gcMn},     //         COMBINING DOUBLE INVERTED BREVE BELOW
	{0x1DFD, 0x1DFF, prCM, gcMn},     //     [3] COMBINING ALMOST EQUAL TO BELOW..COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW
	{0x1E00, 0x1EFF, prAL, gcLC},     //   [256] LATIN CAPITAL LETTER A WITH RING BELOW..LATIN SMALL LETTER Y WITH LOOP
	{0x1F00, 0x1F15, prAL, gcLC},     //    [22] GREEK SMALL LETTER ALPHA WITH PSILI..GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F18, 0x1F1D, prAL, gcLu},     //     [6] GREEK CAPITAL LETTER EPSILON WITH PSILI..GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
	{0x1F20, 0x1F45, prAL, gcLC},     //    [38] GREEK SMALL LETTER ETA WITH PSILI..GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F48, 0x1F4D, prAL, gcLu},     //     [6] GREEK CAPITAL LETTER OMICRON WITH PSILI..GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
	{0x1F50, 0x1F57, prAL, gcLl},     //     [8] GREEK SMALL LETTER UPSILON WITH PSILI..GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
	{0x1F59, 0x1F59, prAL, gcLu},     //         GREEK CAPITAL LETTER UPSILON WITH DASIA
	{0x1F5B, 0x1F5B, prAL, gcLu},     //         GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
	{0x1F5D, 0x1F5D, prAL, gcLu},     //         GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
	{0x1F5F, 0x1F7D, prAL, gcLC},     //    [31] GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI..GREEK SMALL LETTER OMEGA WITH OXIA
	{0x1F80, 0x1FB4, prAL, gcLC},     //    [53] GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI..GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
	{0x1FB6, 0x1FBC, prAL, gcLC},     //     [7] GREEK SMALL LETTER ALPHA WITH PERISPOMENI..GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
	{0x1FBD, 0x1FBD, prAL, gcSk},     //         GREEK KORONIS
	{0x1FBE, 0x1FBE, prAL, gcLl},     //         GREEK PROSGEGRAMMENI
	{0x1FBF, 0x1FC1, prAL, gcSk},     //     [3] GREEK PSILI..GREEK DIALYTIKA AND PERISPOMENI
	{0x1FC2, 0x1FC4, prAL, gcLl},     //     [3] GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
	{0x1FC6, 0x1FCC, prAL, gcLC},     //     [7] GREEK SMALL LETTER ETA WITH PERISPOMENI..GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
	{0x1FCD, 0x1FCF, prAL, gcSk},     //     [3] GREEK PSILI AND VARIA..GREEK PSILI AND PERISPOMENI
	{0x1FD0, 0x1FD3, prAL, gcLl},     //     [4] GREEK SMALL LETTER IOTA WITH VRACHY..GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
	{0x1FD6, 0x1FDB, prAL, gcLC},     //     [6] GREEK SMALL LETTER IOTA WITH PERISPOMENI..GREEK CAPITAL LETTER IOTA WITH OXIA
	{0x1FDD, 0x1FDF, prAL, gcSk},     //     [3] GREEK DASIA AND VARIA..GREEK DASIA AND PERISPOMENI
	{0x1FE0, 0x1FEC, prAL, gcLC},     //    [13] GREEK SMALL LETTER UPSILON WITH VRACHY..GREEK CAPITAL LETTER RHO WITH DASIA
	{0x1FED, 0x1FEF, prAL, gcSk},     //     [3] GREEK DIALYTIKA AND VARIA..GREEK VARIA
	{0x1FF2, 0x1FF4, prAL, gcLl},     //     [3] GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI..GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
	{0x1FF6, 0x1FFC, prAL, gcLC},     //     [7] GREEK SMALL LETTER OMEGA WITH PERISPOMENI..GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
	{0x1FFD, 0x1FFD, prBB, gcSk},     //         GREEK OXIA
	{0x1FFE, 0x1FFE, prAL, gcSk},     //         GREEK DASIA
	{0x2000, 0x2006, prBA, gcZs},     //     [7] EN QUAD..SIX-PER-EM SPACE
	{0x2007, 0x2007, prGL, gcZs},     //         FIGURE SPACE
	{0x2008, 0x200A, prBA, gcZs},     //     [3] PUNCTUATION SPACE..HAIR SPACE
	{0x200B, 0x200B, prZW, gcCf},     //         ZERO WIDTH SPACE
	{0x200C, 0x200C, prCM, gcCf},     //         ZERO WIDTH NON-JOINER
	{0x200D, 0x200D, prZWJ, gcCf},    //         ZERO WIDTH JOINER
	{0x200E, 0x200F, prCM, gcCf},     //     [2] LEFT-TO-RIGHT MARK..RIGHT-TO-LEFT MARK
	{0x2010, 0x2010, prBA, gcPd},     //         HYPHEN
	{0x2011, 0x2011, prGL, gcPd},     //         NON-BREAKING HYPHEN
	{0x2012, 0x2013, prBA, gcPd},     //     [2] FIGURE DASH..EN DASH
	{0x2014, 0x2014, prB2, gcPd},     //         EM DASH
	{0x2015, 0x2015, prAI, gcPd},     //         HORIZONTAL BAR
	{0x2016, 0x2016, prAI, gcPo},     //         DOUBLE VERTICAL LINE
	{0x2017, 0x2017, prAL, gcPo},     //         DOUBLE LOW LINE
	{0x2018, 0x2018, prQU, gcPi},     //         LEFT SINGLE QUOTATION MARK
	{0x2019, 0x2019, prQU, gcPf},     //         RIGHT SINGLE QUOTATION MARK
	{0x201A, 0x201A, prOP, gcPs},     //         SINGLE LOW-9 QUOTATION MARK
	{0x201B, 0x201C, prQU, gcPi},     //     [2] SINGLE HIGH-REVERSED-9 QUOTATION MARK..LEFT DOUBLE QUOTATION MARK
	{0x201D, 0x201D, prQU, gcPf},     //         RIGHT DOUBLE QUOTATION MARK
	{0x201E, 0x201E, prOP, gcPs},     //         DOUBLE LOW-9 QUOTATION MARK
	{0x201F, 0x201F, prQU, gcPi},     //         DOUBLE HIGH-REVERSED-9 QUOTATION MARK
	{0x2020, 0x2021, prAI, gcPo},     //     [2] DAGGER..DOUBLE DAGGER
	{0x2022, 0x2023, prAL, gcPo},     //     [2] BULLET..TRIANGULAR BULLET
	{0x2024, 0x2026, prIN, gcPo},     //     [3] ONE DOT LEADER..HORIZONTAL ELLIPSIS
	{0x2027, 0x2027, prBA, gcPo},     //         HYPHENATION POINT
	{0x2028, 0x2028, prBK, gcZl},     //         LINE SEPARATOR
	{0x2029, 0x2029, prBK, gcZp},     //         PARAGRAPH SEPARATOR
	{0x202A, 0x202E, prCM, gcCf},     //     [5] LEFT-TO-RIGHT EMBEDDING..RIGHT-TO-LEFT OVERRIDE
	{0x202F, 0x202F, prGL, gcZs},     //         NARROW NO-BREAK SPACE
	{0x2030, 0x2037, prPO, gcPo},     //     [8] PER MILLE SIGN..REVERSED TRIPLE PRIME
	{0x2038, 0x2038, prAL, gcPo},     //         CARET
	{0x2039, 0x2039, prQU, gcPi},     //         SINGLE LEFT-POINTING ANGLE QUOTATION MARK
	{0x203A, 0x203A, prQU, gcPf},     //         SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
	{0x203B, 0x203B, prAI, gcPo},     //         REFERENCE MARK
	{0x203C, 0x203D, prNS, gcPo},     //     [2] DOUBLE EXCLAMATION MARK..INTERROBANG
	{0x203E, 0x203E, prAL, gcPo},     //         OVERLINE
	{0x203F, 0x2040, prAL, gcPc},     //     [2] UNDERTIE..CHARACTER TIE
	{0x2041, 0x2043, prAL, gcPo},     //     [3] CARET INSERTION POINT..HYPHEN BULLET
	{0x2044, 0x2044, prIS, gcSm},     //         FRACTION SLASH
	{0x2045, 0x2045, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH QUILL
	{0x2046, 0x2046, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH QUILL
	{0x2047, 0x2049, prNS, gcPo},     //     [3] DOUBLE QUESTION MARK..EXCLAMATION QUESTION MARK
	{0x204A, 0x2051, prAL, gcPo},     //     [8] TIRONIAN SIGN ET..TWO ASTERISKS ALIGNED VERTICALLY
	{0x2052, 0x2052, prAL, gcSm},     //         COMMERCIAL MINUS SIGN
	{0x2053, 0x2053, prAL, gcPo},     //         SWUNG DASH
	{0x2054, 0x2054, prAL, gcPc},     //         INVERTED UNDERTIE
	{0x2055, 0x2055, prAL, gcPo},     //         FLOWER PUNCTUATION MARK
	{0x2056, 0x2056, prBA, gcPo},     //         THREE DOT PUNCTUATION
	{0x2057, 0x2057, prPO, gcPo},     //         QUADRUPLE PRIME
	{0x2058, 0x205B, prBA, gcPo},     //     [4] FOUR DOT PUNCTUATION..FOUR DOT MARK
	{0x205C, 0x205C, prAL, gcPo},     //         DOTTED CROSS
	{0x205D, 0x205E, prBA, gcPo},     //     [2] TRICOLON..VERTICAL FOUR DOTS
	{0x205F, 0x205F, prBA, gcZs},     //         MEDIUM MATHEMATICAL SPACE
	{0x2060, 0x2060, prWJ, gcCf},     //         WORD JOINER
	{0x2061, 0x2064, prAL, gcCf},     //     [4] FUNCTION APPLICATION..INVISIBLE PLUS
	{0x2066, 0x206F, prCM, gcCf},     //    [10] LEFT-TO-RIGHT ISOLATE..NOMINAL DIGIT SHAPES
	{0x2070, 0x2070, prAL, gcNo},     //         SUPERSCRIPT ZERO
	{0x2071, 0x2071, prAL, gcLm},     //         SUPERSCRIPT LATIN SMALL LETTER I
	{0x2074, 0x2074, prAI, gcNo},     //         SUPERSCRIPT FOUR
	{0x2075, 0x2079, prAL, gcNo},     //     [5] SUPERSCRIPT FIVE..SUPERSCRIPT NINE
	{0x207A, 0x207C, prAL, gcSm},     //     [3] SUPERSCRIPT PLUS SIGN..SUPERSCRIPT EQUALS SIGN
	{0x207D, 0x207D, prOP, gcPs},     //         SUPERSCRIPT LEFT PARENTHESIS
	{0x207E, 0x207E, prCL, gcPe},     //         SUPERSCRIPT RIGHT PARENTHESIS
	{0x207F, 0x207F, prAI, gcLm},     //         SUPERSCRIPT LATIN SMALL LETTER N
	{0x2080, 0x2080, prAL, gcNo},     //         SUBSCRIPT ZERO
	{0x2081, 0x2084, prAI, gcNo},     //     [4] SUBSCRIPT ONE..SUBSCRIPT FOUR
	{0x2085, 0x2089, prAL, gcNo},     //     [5] SUBSCRIPT FIVE..SUBSCRIPT NINE
	{0x208A, 0x208C, prAL, gcSm},     //     [3] SUBSCRIPT PLUS SIGN..SUBSCRIPT EQUALS SIGN
	{0x208D, 0x208D, prOP, gcPs},     //         SUBSCRIPT LEFT PARENTHESIS
	{0x208E, 0x208E, prCL, gcPe},     //         SUBSCRIPT RIGHT PARENTHESIS
	{0x2090, 0x209C, prAL, gcLm},     //    [13] LATIN SUBSCRIPT SMALL LETTER A..LATIN SUBSCRIPT SMALL LETTER T
	{0x20A0, 0x20A6, prPR, gcSc},     //     [7] EURO-CURRENCY SIGN..NAIRA SIGN
	{0x20A7, 0x20A7, prPO, gcSc},     //         PESETA SIGN
	{0x20A8, 0x20B5, prPR, gcSc},     //    [14] RUPEE SIGN..CEDI SIGN
	{0x20B6, 0x20B6, prPO, gcSc},     //         LIVRE TOURNOIS SIGN
	{0x20B7, 0x20BA, prPR, gcSc},     //     [4] SPESMILO SIGN..TURKISH LIRA SIGN
	{0x20BB, 0x20BB, prPO, gcSc},     //         NORDIC MARK SIGN
	{0x20BC, 0x20BD, prPR, gcSc},     //     [2] MANAT SIGN..RUBLE SIGN
	{0x20BE, 0x20BE, prPO, gcSc},     //         LARI SIGN
	{0x20BF, 0x20BF, prPR, gcSc},     //         BITCOIN SIGN
	{0x20C0, 0x20C0, prPO, gcSc},     //         SOM SIGN
	{0x20C1, 0x20CF, prPR, gcCn},     //    [15] <reserved-20C1>..<reserved-20CF>
	{0x20D0, 0x20DC, prCM, gcMn},     //    [13] COMBINING LEFT HARPOON ABOVE..COMBINING FOUR DOTS ABOVE
	{0x20DD, 0x20E0, prCM, gcMe},     //     [4] COMBINING ENCLOSING CIRCLE..COMBINING ENCLOSING CIRCLE BACKSLASH
	{0x20E1, 0x20E1, prCM, gcMn},     //         COMBINING LEFT RIGHT ARROW ABOVE
	{0x20E2, 0x20E4, prCM, gcMe},     //     [3] COMBINING ENCLOSING SCREEN..COMBINING ENCLOSING UPWARD POINTING TRIANGLE
	{0x20E5, 0x20F0, prCM, gcMn},     //    [12] COMBINING REVERSE SOLIDUS OVERLAY..COMBINING ASTERISK ABOVE
	{0x2100, 0x2101, prAL, gcSo},     //     [2] ACCOUNT OF..ADDRESSED TO THE SUBJECT
	{0x2102, 0x2102, prAL, gcLu},     //         DOUBLE-STRUCK CAPITAL C
	{0x2103, 0x2103, prPO, gcSo},     //         DEGREE CELSIUS
	{0x2104, 0x2104, prAL, gcSo},     //         CENTRE LINE SYMBOL
	{0x2105, 0x2105, prAI, gcSo},     //         CARE OF
	{0x2106, 0x2106, prAL, gcSo},     //         CADA UNA
	{0x2107, 0x2107, prAL, gcLu},     //         EULER CONSTANT
	{0x2108, 0x2108, prAL, gcSo},     //         SCRUPLE
	{0x2109, 0x2109, prPO, gcSo},     //         DEGREE FAHRENHEIT
	{0x210A, 0x2112, prAL, gcLC},     //     [9] SCRIPT SMALL G..SCRIPT CAPITAL L
	{0x2113, 0x2113, prAI, gcLl},     //         SCRIPT SMALL L
	{0x2114, 0x2114, prAL, gcSo},     //         L B BAR SYMBOL
	{0x2115, 0x2115, prAL, gcLu},     //         DOUBLE-STRUCK CAPITAL N
	{0x2116, 0x2116, prPR, gcSo},     //         NUMERO SIGN
	{0x2117, 0x2117, prAL, gcSo},     //         SOUND RECORDING COPYRIGHT
	{0x2118, 0x2118, prAL, gcSm},     //         SCRIPT CAPITAL P
	{0x2119, 0x211D, prAL, gcLu},     //     [5] DOUBLE-STRUCK CAPITAL P..DOUBLE-STRUCK CAPITAL R
	{0x211E, 0x2120, prAL, gcSo},     //     [3] PRESCRIPTION TAKE..SERVICE MARK
	{0x2121, 0x2122, prAI, gcSo},     //     [2] TELEPHONE SIGN..TRADE MARK SIGN
	{0x2123, 0x2123, prAL, gcSo},     //         VERSICLE
	{0x2124, 0x2124, prAL, gcLu},     //         DOUBLE-STRUCK CAPITAL Z
	{0x2125, 0x2125, prAL, gcSo},     //         OUNCE SIGN
	{0x2126, 0x2126, prAL, gcLu},     //         OHM SIGN
	{0x2127, 0x2127, prAL, gcSo},     //         INVERTED OHM SIGN
	{0x2128, 0x2128, prAL, gcLu},     //         BLACK-LETTER CAPITAL Z
	{0x2129, 0x2129, prAL, gcSo},     //         TURNED GREEK SMALL LETTER IOTA
	{0x212A, 0x212A, prAL, gcLu},     //         KELVIN SIGN
	{0x212B, 0x212B, prAI, gcLu},     //         ANGSTROM SIGN
	{0x212C, 0x212D, prAL, gcLu},     //     [2] SCRIPT CAPITAL B..BLACK-LETTER CAPITAL C
	{0x212E, 0x212E, prAL, gcSo},     //         ESTIMATED SYMBOL
	{0x212F, 0x2134, prAL, gcLC},     //     [6] SCRIPT SMALL E..SCRIPT SMALL O
	{0x2135, 0x2138, prAL, gcLo},     //     [4] ALEF SYMBOL..DALET SYMBOL
	{0x2139, 0x2139, prAL, gcLl},     //         INFORMATION SOURCE
	{0x213A, 0x213B, prAL, gcSo},     //     [2] ROTATED CAPITAL Q..FACSIMILE SIGN
	{0x213C, 0x213F, prAL, gcLC},     //     [4] DOUBLE-STRUCK SMALL PI..DOUBLE-STRUCK CAPITAL PI
	{0x2140, 0x2144, prAL, gcSm},     //     [5] DOUBLE-STRUCK N-ARY SUMMATION..TURNED SANS-SERIF CAPITAL Y
	{0x2145, 0x2149, prAL, gcLC},     //     [5] DOUBLE-STRUCK ITALIC CAPITAL D..DOUBLE-STRUCK ITALIC SMALL J
	{0x214A, 0x214A, prAL, gcSo},     //         PROPERTY LINE
	{0x214B, 0x214B, prAL, gcSm},     //         TURNED AMPERSAND
	{0x214C, 0x214D, prAL, gcSo},     //     [2] PER SIGN..AKTIESELSKAB
	{0x214E, 0x214E, prAL, gcLl},     //         TURNED SMALL F
	{0x214F, 0x214F, prAL, gcSo},     //         SYMBOL FOR SAMARITAN SOURCE
	{0x2150, 0x2153, prAL, gcNo},     //     [4] VULGAR FRACTION ONE SEVENTH..VULGAR FRACTION ONE THIRD
	{0x2154, 0x2155, prAI, gcNo},     //     [2] VULGAR FRACTION TWO THIRDS..VULGAR FRACTION ONE FIFTH
	{0x2156, 0x215A, prAL, gcNo},     //     [5] VULGAR FRACTION TWO FIFTHS..VULGAR FRACTION FIVE SIXTHS
	{0x215B, 0x215B, prAI, gcNo},     //         VULGAR FRACTION ONE EIGHTH
	{0x215C, 0x215D, prAL, gcNo},     //     [2] VULGAR FRACTION THREE EIGHTHS..VULGAR FRACTION FIVE EIGHTHS
	{0x215E, 0x215E, prAI, gcNo},     //         VULGAR FRACTION SEVEN EIGHTHS
	{0x215F, 0x215F, prAL, gcNo},     //         FRACTION NUMERATOR ONE
	{0x2160, 0x216B, prAI, gcNl},     //    [12] ROMAN NUMERAL ONE..ROMAN NUMERAL TWELVE
	{0x216C, 0x216F, prAL, gcNl},     //     [4] ROMAN NUMERAL FIFTY..ROMAN NUMERAL ONE THOUSAND
	{0x2170, 0x2179, prAI, gcNl},     //    [10] SMALL ROMAN NUMERAL ONE..SMALL ROMAN NUMERAL TEN
	{0x217A, 0x2182, prAL, gcNl},     //     [9] SMALL ROMAN NUMERAL ELEVEN..ROMAN NUMERAL TEN THOUSAND
	{0x2183, 0x2184, prAL, gcLC},     //     [2] ROMAN NUMERAL REVERSED ONE HUNDRED..LATIN SMALL LETTER REVERSED C
	{0x2185, 0x2188, prAL, gcNl},     //     [4] ROMAN NUMERAL SIX LATE FORM..ROMAN NUMERAL ONE HUNDRED THOUSAND
	{0x2189, 0x2189, prAI, gcNo},     //         VULGAR FRACTION ZERO THIRDS
	{0x218A, 0x218B, prAL, gcSo},     //     [2] TURNED DIGIT TWO..TURNED DIGIT THREE
	{0x2190, 0x2194, prAI, gcSm},     //     [5] LEFTWARDS ARROW..LEFT RIGHT ARROW
	{0x2195, 0x2199, prAI, gcSo},     //     [5] UP DOWN ARROW..SOUTH WEST ARROW
	{0x219A, 0x219B, prAL, gcSm},     //     [2] LEFTWARDS ARROW WITH STROKE..RIGHTWARDS ARROW WITH STROKE
	{0x219C, 0x219F, prAL, gcSo},     //     [4] LEFTWARDS WAVE ARROW..UPWARDS TWO HEADED ARROW
	{0x21A0, 0x21A0, prAL, gcSm},     //         RIGHTWARDS TWO HEADED ARROW
	{0x21A1, 0x21A2, prAL, gcSo},     //     [2] DOWNWARDS TWO HEADED ARROW..LEFTWARDS ARROW WITH TAIL
	{0x21A3, 0x21A3, prAL, gcSm},     //         RIGHTWARDS ARROW WITH TAIL
	{0x21A4, 0x21A5, prAL, gcSo},     //     [2] LEFTWARDS ARROW FROM BAR..UPWARDS ARROW FROM BAR
	{0x21A6, 0x21A6, prAL, gcSm},     //         RIGHTWARDS ARROW FROM BAR
	{0x21A7, 0x21AD, prAL, gcSo},     //     [7] DOWNWARDS ARROW FROM BAR..LEFT RIGHT WAVE ARROW
	{0x21AE, 0x21AE, prAL, gcSm},     //         LEFT RIGHT ARROW WITH STROKE
	{0x21AF, 0x21CD, prAL, gcSo},     //    [31] DOWNWARDS ZIGZAG ARROW..LEFTWARDS DOUBLE ARROW WITH STROKE
	{0x21CE, 0x21CF, prAL, gcSm},     //     [2] LEFT RIGHT DOUBLE ARROW WITH STROKE..RIGHTWARDS DOUBLE ARROW WITH STROKE
	{0x21D0, 0x21D1, prAL, gcSo},     //     [2] LEFTWARDS DOUBLE ARROW..UPWARDS DOUBLE ARROW
	{0x21D2, 0x21D2, prAI, gcSm},     //         RIGHTWARDS DOUBLE ARROW
	{0x21D3, 0x21D3, prAL, gcSo},     //         DOWNWARDS DOUBLE ARROW
	{0x21D4, 0x21D4, prAI, gcSm},     //         LEFT RIGHT DOUBLE ARROW
	{0x21D5, 0x21F3, prAL, gcSo},     //    [31] UP DOWN DOUBLE ARROW..UP DOWN WHITE ARROW
	{0x21F4, 0x21FF, prAL, gcSm},     //    [12] RIGHT ARROW WITH SMALL CIRCLE..LEFT RIGHT OPEN-HEADED ARROW
	{0x2200, 0x2200, prAI, gcSm},     //         FOR ALL
	{0x2201, 0x2201, prAL, gcSm},     //         COMPLEMENT
	{0x2202, 0x2203, prAI, gcSm},     //     [2] PARTIAL DIFFERENTIAL..THERE EXISTS
	{0x2204, 0x2206, prAL, gcSm},     //     [3] THERE DOES NOT EXIST..INCREMENT
	{0x2207, 0x2208, prAI, gcSm},     //     [2] NABLA..ELEMENT OF
	{0x2209, 0x220A, prAL, gcSm},     //     [2] NOT AN ELEMENT OF..SMALL ELEMENT OF
	{0x220B, 0x220B, prAI, gcSm},     //         CONTAINS AS MEMBER
	{0x220C, 0x220E, prAL, gcSm},     //     [3] DOES NOT CONTAIN AS MEMBER..END OF PROOF
	{0x220F, 0x220F, prAI, gcSm},     //         N-ARY PRODUCT
	{0x2210, 0x2210, prAL, gcSm},     //         N-ARY COPRODUCT
	{0x2211, 0x2211, prAI, gcSm},     //         N-ARY SUMMATION
	{0x2212, 0x2213, prPR, gcSm},     //     [2] MINUS SIGN..MINUS-OR-PLUS SIGN
	{0x2214, 0x2214, prAL, gcSm},     //         DOT PLUS
	{0x2215, 0x2215, prAI, gcSm},     //         DIVISION SLASH
	{0x2216, 0x2219, prAL, gcSm},     //     [4] SET MINUS..BULLET OPERATOR
	{0x221A, 0x221A, prAI, gcSm},     //         SQUARE ROOT
	{0x221B, 0x221C, prAL, gcSm},     //     [2] CUBE ROOT..FOURTH ROOT
	{0x221D, 0x2220, prAI, gcSm},     //     [4] PROPORTIONAL TO..ANGLE
	{0x2221, 0x2222, prAL, gcSm},     //     [2] MEASURED ANGLE..SPHERICAL ANGLE
	{0x2223, 0x2223, prAI, gcSm},     //         DIVIDES
	{0x2224, 0x2224, prAL, gcSm},     //         DOES NOT DIVIDE
	{0x2225, 0x2225, prAI, gcSm},     //         PARALLEL TO
	{0x2226, 0x2226, prAL, gcSm},     //         NOT PARALLEL TO
	{0x2227, 0x222C, prAI, gcSm},     //     [6] LOGICAL AND..DOUBLE INTEGRAL
	{0x222D, 0x222D, prAL, gcSm},     //         TRIPLE INTEGRAL
	{0x222E, 0x222E, prAI, gcSm},     //         CONTOUR INTEGRAL
	{0x222F, 0x2233, prAL, gcSm},     //     [5] SURFACE INTEGRAL..ANTICLOCKWISE CONTOUR INTEGRAL
	{0x2234, 0x2237, prAI, gcSm},     //     [4] THEREFORE..PROPORTION
	{0x2238, 0x223B, prAL, gcSm},     //     [4] DOT MINUS..HOMOTHETIC
	{0x223C, 0x223D, prAI, gcSm},     //     [2] TILDE OPERATOR..REVERSED TILDE
	{0x223E, 0x2247, prAL, gcSm},     //    [10] INVERTED LAZY S..NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
	{0x2248, 0x2248, prAI, gcSm},     //         ALMOST EQUAL TO
	{0x2249, 0x224B, prAL, gcSm},     //     [3] NOT ALMOST EQUAL TO..TRIPLE TILDE
	{0x224C, 0x224C, prAI, gcSm},     //         ALL EQUAL TO
	{0x224D, 0x2251, prAL, gcSm},     //     [5] EQUIVALENT TO..GEOMETRICALLY EQUAL TO
	{0x2252, 0x2252, prAI, gcSm},     //         APPROXIMATELY EQUAL TO OR THE IMAGE OF
	{0x2253, 0x225F, prAL, gcSm},     //    [13] IMAGE OF OR APPROXIMATELY EQUAL TO..QUESTIONED EQUAL TO
	{0x2260, 0x2261, prAI, gcSm},     //     [2] NOT EQUAL TO..IDENTICAL TO
	{0x2262, 0x2263, prAL, gcSm},     //     [2] NOT IDENTICAL TO..STRICTLY EQUIVALENT TO
	{0x2264, 0x2267, prAI, gcSm},     //     [4] LESS-THAN OR EQUAL TO..GREATER-THAN OVER EQUAL TO
	{0x2268, 0x2269, prAL, gcSm},     //     [2] LESS-THAN BUT NOT EQUAL TO..GREATER-THAN BUT NOT EQUAL TO
	{0x226A, 0x226B, prAI, gcSm},     //     [2] MUCH LESS-THAN..MUCH GREATER-THAN
	{0x226C, 0x226D, prAL, gcSm},     //     [2] BETWEEN..NOT EQUIVALENT TO
	{0x226E, 0x226F, prAI, gcSm},     //     [2] NOT LESS-THAN..NOT GREATER-THAN
	{0x2270, 0x2281, prAL, gcSm},     //    [18] NEITHER LESS-THAN NOR EQUAL TO..DOES NOT SUCCEED
	{0x2282, 0x2283, prAI, gcSm},     //     [2] SUBSET OF..SUPERSET OF
	{0x2284, 0x2285, prAL, gcSm},     //     [2] NOT A SUBSET OF..NOT A SUPERSET OF
	{0x2286, 0x2287, prAI, gcSm},     //     [2] SUBSET OF OR EQUAL TO..SUPERSET OF OR EQUAL TO
	{0x2288, 0x2294, prAL, gcSm},     //    [13] NEITHER A SUBSET OF NOR EQUAL TO..SQUARE CUP
	{0x2295, 0x2295, prAI, gcSm},     //         CIRCLED PLUS
	{0x2296, 0x2298, prAL, gcSm},     //     [3] CIRCLED MINUS..CIRCLED DIVISION SLASH
	{0x2299, 0x2299, prAI, gcSm},     //         CIRCLED DOT OPERATOR
	{0x229A, 0x22A4, prAL, gcSm},     //    [11] CIRCLED RING OPERATOR..DOWN TACK
	{0x22A5, 0x22A5, prAI, gcSm},     //         UP TACK
	{0x22A6, 0x22BE, prAL, gcSm},     //    [25] ASSERTION..RIGHT ANGLE WITH ARC
	{0x22BF, 0x22BF, prAI, gcSm},     //         RIGHT TRIANGLE
	{0x22C0, 0x22EE, prAL, gcSm},     //    [47] N-ARY LOGICAL AND..VERTICAL ELLIPSIS
	{0x22EF, 0x22EF, prIN, gcSm},     //         MIDLINE HORIZONTAL ELLIPSIS
	{0x22F0, 0x22FF, prAL, gcSm},     //    [16] UP RIGHT DIAGONAL ELLIPSIS..Z NOTATION BAG MEMBERSHIP
	{0x2300, 0x2307, prAL, gcSo},     //     [8] DIAMETER SIGN..WAVY LINE
	{0x2308, 0x2308, prOP, gcPs},     //         LEFT CEILING
	{0x2309, 0x2309, prCL, gcPe},     //         RIGHT CEILING
	{0x230A, 0x230A, prOP, gcPs},     //         LEFT FLOOR
	{0x230B, 0x230B, prCL, gcPe},     //         RIGHT FLOOR
	{0x230C, 0x2311, prAL, gcSo},     //     [6] BOTTOM RIGHT CROP..SQUARE LOZENGE
	{0x2312, 0x2312, prAI, gcSo},     //         ARC
	{0x2313, 0x2319, prAL, gcSo},     //     [7] SEGMENT..TURNED NOT SIGN
	{0x231A, 0x231B, prID, gcSo},     //     [2] WATCH..HOURGLASS
	{0x231C, 0x231F, prAL, gcSo},     //     [4] TOP LEFT CORNER..BOTTOM RIGHT CORNER
	{0x2320, 0x2321, prAL, gcSm},     //     [2] TOP HALF INTEGRAL..BOTTOM HALF INTEGRAL
	{0x2322, 0x2328, prAL, gcSo},     //     [7] FROWN..KEYBOARD
	{0x2329, 0x2329, prOP, gcPs},     //         LEFT-POINTING ANGLE BRACKET
	{0x232A, 0x232A, prCL, gcPe},     //         RIGHT-POINTING ANGLE BRACKET
	{0x232B, 0x237B, prAL, gcSo},     //    [81] ERASE TO THE LEFT..NOT CHECK MARK
	{0x237C, 0x237C, prAL, gcSm},     //         RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
	{0x237D, 0x239A, prAL, gcSo},     //    [30] SHOULDERED OPEN BOX..CLEAR SCREEN SYMBOL
	{0x239B, 0x23B3, prAL, gcSm},     //    [25] LEFT PARENTHESIS UPPER HOOK..SUMMATION BOTTOM
	{0x23B4, 0x23DB, prAL, gcSo},     //    [40] TOP SQUARE BRACKET..FUSE
	{0x23DC, 0x23E1, prAL, gcSm},     //     [6] TOP PARENTHESIS..BOTTOM TORTOISE SHELL BRACKET
	{0x23E2, 0x23EF, prAL, gcSo},     //    [14] WHITE TRAPEZIUM..BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR
	{0x23F0, 0x23F3, prID, gcSo},     //     [4] ALARM CLOCK..HOURGLASS WITH FLOWING SAND
	{0x23F4, 0x23FF, prAL, gcSo},     //    [12] BLACK MEDIUM LEFT-POINTING TRIANGLE..OBSERVER EYE SYMBOL
	{0x2400, 0x2426, prAL, gcSo},     //    [39] SYMBOL FOR NULL..SYMBOL FOR SUBSTITUTE FORM TWO
	{0x2440, 0x244A, prAL, gcSo},     //    [11] OCR HOOK..OCR DOUBLE BACKSLASH
	{0x2460, 0x249B, prAI, gcNo},     //    [60] CIRCLED DIGIT ONE..NUMBER TWENTY FULL STOP
	{0x249C, 0x24E9, prAI, gcSo},     //    [78] PARENTHESIZED LATIN SMALL LETTER A..CIRCLED LATIN SMALL LETTER Z
	{0x24EA, 0x24FE, prAI, gcNo},     //    [21] CIRCLED DIGIT ZERO..DOUBLE CIRCLED NUMBER TEN
	{0x24FF, 0x24FF, prAL, gcNo},     //         NEGATIVE CIRCLED DIGIT ZERO
	{0x2500, 0x254B, prAI, gcSo},     //    [76] BOX DRAWINGS LIGHT HORIZONTAL..BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
	{0x254C, 0x254F, prAL, gcSo},     //     [4] BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL..BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL
	{0x2550, 0x2574, prAI, gcSo},     //    [37] BOX DRAWINGS DOUBLE HORIZONTAL..BOX DRAWINGS LIGHT LEFT
	{0x2575, 0x257F, prAL, gcSo},     //    [11] BOX DRAWINGS LIGHT UP..BOX DRAWINGS HEAVY UP AND LIGHT DOWN
	{0x2580, 0x258F, prAI, gcSo},     //    [16] UPPER HALF BLOCK..LEFT ONE EIGHTH BLOCK
	{0x2590, 0x2591, prAL, gcSo},     //     [2] RIGHT HALF BLOCK..LIGHT SHADE
	{0x2592, 0x2595, prAI, gcSo},     //     [4] MEDIUM SHADE..RIGHT ONE EIGHTH BLOCK
	{0x2596, 0x259F, prAL, gcSo},     //    [10] QUADRANT LOWER LEFT..QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
	{0x25A0, 0x25A1, prAI, gcSo},     //     [2] BLACK SQUARE..WHITE SQUARE
	{0x25A2, 0x25A2, prAL, gcSo},     //         WHITE SQUARE WITH ROUNDED CORNERS
	{0x25A3, 0x25A9, prAI, gcSo},     //     [7] WHITE SQUARE CONTAINING BLACK SMALL SQUARE..SQUARE WITH DIAGONAL CROSSHATCH FILL
	{0x25AA, 0x25B1, prAL, gcSo},     //     [8] BLACK SMALL SQUARE..WHITE PARALLELOGRAM
	{0x25B2, 0x25B3, prAI, gcSo},     //     [2] BLACK UP-POINTING TRIANGLE..WHITE UP-POINTING TRIANGLE
	{0x25B4, 0x25B5, prAL, gcSo},     //     [2] BLACK UP-POINTING SMALL TRIANGLE..WHITE UP-POINTING SMALL TRIANGLE
	{0x25B6, 0x25B6, prAI, gcSo},     //         BLACK RIGHT-POINTING TRIANGLE
	{0x25B7, 0x25B7, prAI, gcSm},     //         WHITE RIGHT-POINTING TRIANGLE
	{0x25B8, 0x25BB, prAL, gcSo},     //     [4] BLACK RIGHT-POINTING SMALL TRIANGLE..WHITE RIGHT-POINTING POINTER
	{0x25BC, 0x25BD, prAI, gcSo},     //     [2] BLACK DOWN-POINTING TRIANGLE..WHITE DOWN-POINTING TRIANGLE
	{0x25BE, 0x25BF, prAL, gcSo},     //     [2] BLACK DOWN-POINTING SMALL TRIANGLE..WHITE DOWN-POINTING SMALL TRIANGLE
	{0x25C0, 0x25C0, prAI, gcSo},     //         BLACK LEFT-POINTING TRIANGLE
	{0x25C1, 0x25C1, prAI, gcSm},     //         WHITE LEFT-POINTING TRIANGLE
	{0x25C2, 0x25C5, prAL, gcSo},     //     [4] BLACK LEFT-POINTING SMALL TRIANGLE..WHITE LEFT-POINTING POINTER
	{0x25C6, 0x25C8, prAI, gcSo},     //     [3] BLACK DIAMOND..WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
	{0x25C9, 0x25CA, prAL, gcSo},     //     [2] FISHEYE..LOZENGE
	{0x25CB, 0x25CB, prAI, gcSo},     //         WHITE CIRCLE
	{0x25CC, 0x25CD, prAL, gcSo},     //     [2] DOTTED CIRCLE..CIRCLE WITH VERTICAL FILL
	{0x25CE, 0x25D1, prAI, gcSo},     //     [4] BULLSEYE..CIRCLE WITH RIGHT HALF BLACK
	{0x25D2, 0x25E1, prAL, gcSo},     //    [16] CIRCLE WITH LOWER HALF BLACK..LOWER HALF CIRCLE
	{0x25E2, 0x25E5, prAI, gcSo},     //     [4] BLACK LOWER RIGHT TRIANGLE..BLACK UPPER RIGHT TRIANGLE
	{0x25E6, 0x25EE, prAL, gcSo},     //     [9] WHITE BULLET..UP-POINTING TRIANGLE WITH RIGHT HALF BLACK
	{0x25EF, 0x25EF, prAI, gcSo},     //         LARGE CIRCLE
	{0x25F0, 0x25F7, prAL, gcSo},     //     [8] WHITE SQUARE WITH UPPER LEFT QUADRANT..WHITE CIRCLE WITH UPPER RIGHT QUADRANT
	{0x25F8, 0x25FF, prAL, gcSm},     //     [8] UPPER LEFT TRIANGLE..LOWER RIGHT TRIANGLE
	{0x2600, 0x2603, prID, gcSo},     //     [4] BLACK SUN WITH RAYS..SNOWMAN
	{0x2604, 0x2604, prAL, gcSo},     //         COMET
	{0x2605, 0x2606, prAI, gcSo},     //     [2] BLACK STAR..WHITE STAR
	{0x2607, 0x2608, prAL, gcSo},     //     [2] LIGHTNING..THUNDERSTORM
	{0x2609, 0x2609, prAI, gcSo},     //         SUN
	{0x260A, 0x260D, prAL, gcSo},     //     [4] ASCENDING NODE..OPPOSITION
	{0x260E, 0x260F, prAI, gcSo},     //     [2] BLACK TELEPHONE..WHITE TELEPHONE
	{0x2610, 0x2613, prAL, gcSo},     //     [4] BALLOT BOX..SALTIRE
	{0x2614, 0x2615, prID, gcSo},     //     [2] UMBRELLA WITH RAIN DROPS..HOT BEVERAGE
	{0x2616, 0x2617, prAI, gcSo},     //     [2] WHITE SHOGI PIECE..BLACK SHOGI PIECE
	{0x2618, 0x2618, prID, gcSo},     //         SHAMROCK
	{0x2619, 0x2619, prAL, gcSo},     //         REVERSED ROTATED FLORAL HEART BULLET
	{0x261A, 0x261C, prID, gcSo},     //     [3] BLACK LEFT POINTING INDEX..WHITE LEFT POINTING INDEX
	{0x261D, 0x261D, prEB, gcSo},     //         WHITE UP POINTING INDEX
	{0x261E, 0x261F, prID, gcSo},     //     [2] WHITE RIGHT POINTING INDEX..WHITE DOWN POINTING INDEX
	{0x2620, 0x2638, prAL, gcSo},     //    [25] SKULL AND CROSSBONES..WHEEL OF DHARMA
	{0x2639, 0x263B, prID, gcSo},     //     [3] WHITE FROWNING FACE..BLACK SMILING FACE
	{0x263C, 0x263F, prAL, gcSo},     //     [4] WHITE SUN WITH RAYS..MERCURY
	{0x2640, 0x2640, prAI, gcSo},     //         FEMALE SIGN
	{0x2641, 0x2641, prAL, gcSo},     //         EARTH
	{0x2642, 0x2642, prAI, gcSo},     //         MALE SIGN
	{0x2643, 0x265F, prAL, gcSo},     //    [29] JUPITER..BLACK CHESS PAWN
	{0x2660, 0x2661, prAI, gcSo},     //     [2] BLACK SPADE SUIT..WHITE HEART SUIT
	{0x2662, 0x2662, prAL, gcSo},     //         WHITE DIAMOND SUIT
	{0x2663, 0x2665, prAI, gcSo},     //     [3] BLACK CLUB SUIT..BLACK HEART SUIT
	{0x2666, 0x2666, prAL, gcSo},     //         BLACK DIAMOND SUIT
	{0x2667, 0x2667, prAI, gcSo},     //         WHITE CLUB SUIT
	{0x2668, 0x2668, prID, gcSo},     //         HOT SPRINGS
	{0x2669, 0x266A, prAI, gcSo},     //     [2] QUARTER NOTE..EIGHTH NOTE
	{0x266B, 0x266B, prAL, gcSo},     //         BEAMED EIGHTH NOTES
	{0x266C, 0x266D, prAI, gcSo},     //     [2] BEAMED SIXTEENTH NOTES..MUSIC FLAT SIGN
	{0x266E, 0x266E, prAL, gcSo},     //         MUSIC NATURAL SIGN
	{0x266F, 0x266F, prAI, gcSm},     //         MUSIC SHARP SIGN
	{0x2670, 0x267E, prAL, gcSo},     //    [15] WEST SYRIAC CROSS..PERMANENT PAPER SIGN
	{0x267F, 0x267F, prID, gcSo},     //         WHEELCHAIR SYMBOL
	{0x2680, 0x269D, prAL, gcSo},     //    [30] DIE FACE-1..OUTLINED WHITE STAR
	{0x269E, 0x269F, prAI, gcSo},     //     [2] THREE LINES CONVERGING RIGHT..THREE LINES CONVERGING LEFT
	{0x26A0, 0x26BC, prAL, gcSo},     //    [29] WARNING SIGN..SESQUIQUADRATE
	{0x26BD, 0x26C8, prID, gcSo},     //    [12] SOCCER BALL..THUNDER CLOUD AND RAIN
	{0x26C9, 0x26CC, prAI, gcSo},     //     [4] TURNED WHITE SHOGI PIECE..CROSSING LANES
	{0x26CD, 0x26CD, prID, gcSo},     //         DISABLED CAR
	{0x26CE, 0x26CE, prAL, gcSo},     //         OPHIUCHUS
	{0x26CF, 0x26D1, prID, gcSo},     //     [3] PICK..HELMET WITH WHITE CROSS
	{0x26D2, 0x26D2, prAI, gcSo},     //         CIRCLED CROSSING LANES
	{0x26D3, 0x26D4, prID, gcSo},     //     [2] CHAINS..NO ENTRY
	{0x26D5, 0x26D7, prAI, gcSo},     //     [3] ALTERNATE ONE-WAY LEFT WAY TRAFFIC..WHITE TWO-WAY LEFT WAY TRAFFIC
	{0x26D8, 0x26D9, prID, gcSo},     //     [2] BLACK LEFT LANE MERGE..WHITE LEFT LANE MERGE
	{0x26DA, 0x26DB, prAI, gcSo},     //     [2] DRIVE SLOW SIGN..HEAVY WHITE DOWN-POINTING TRIANGLE
	{0x26DC, 0x26DC, prID, gcSo},     //         LEFT CLOSED ENTRY
	{0x26DD, 0x26DE, prAI, gcSo},     //     [2] SQUARED SALTIRE..FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE
	{0x26DF, 0x26E1, prID, gcSo},     //     [3] BLACK TRUCK..RESTRICTED LEFT ENTRY-2
	{0x26E2, 0x26E2, prAL, gcSo},     //         ASTRONOMICAL SYMBOL FOR URANUS
	{0x26E3, 0x26E3, prAI, gcSo},     //         HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE
	{0x26E4, 0x26E7, prAL, gcSo},     //     [4] PENTAGRAM..INVERTED PENTAGRAM
	{0x26E8, 0x26E9, prAI, gcSo},     //     [2] BLACK CROSS ON SHIELD..SHINTO SHRINE
	{0x26EA, 0x26EA, prID, gcSo},     //         CHURCH
	{0x26EB, 0x26F0, prAI, gcSo},     //     [6] CASTLE..MOUNTAIN
	{0x26F1, 0x26F5, prID, gcSo},     //     [5] UMBRELLA ON GROUND..SAILBOAT
	{0x26F6, 0x26F6, prAI, gcSo},     //         SQUARE FOUR CORNERS
	{0x26F7, 0x26F8, prID, gcSo},     //     [2] SKIER..ICE SKATE
	{0x26F9, 0x26F9, prEB, gcSo},     //         PERSON WITH BALL
	{0x26FA, 0x26FA, prID, gcSo},     //         TENT
	{0x26FB, 0x26FC, prAI, gcSo},     //     [2] JAPANESE BANK SYMBOL..HEADSTONE GRAVEYARD SYMBOL
	{0x26FD, 0x26FF, prID, gcSo},     //     [3] FUEL PUMP..WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE
	{0x2700, 0x2704, prID, gcSo},     //     [5] BLACK SAFETY SCISSORS..WHITE SCISSORS
	{0x2705, 0x2707, prAL, gcSo},     //     [3] WHITE HEAVY CHECK MARK..TAPE DRIVE
	{0x2708, 0x2709, prID, gcSo},     //     [2] AIRPLANE..ENVELOPE
	{0x270A, 0x270D, prEB, gcSo},     //     [4] RAISED FIST..WRITING HAND
	{0x270E, 0x2756, prAL, gcSo},     //    [73] LOWER RIGHT PENCIL..BLACK DIAMOND MINUS WHITE X
	{0x2757, 0x2757, prAI, gcSo},     //         HEAVY EXCLAMATION MARK SYMBOL
	{0x2758, 0x275A, prAL, gcSo},     //     [3] LIGHT VERTICAL BAR..HEAVY VERTICAL BAR
	{0x275B, 0x2760, prQU, gcSo},     //     [6] HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT..HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT
	{0x2761, 0x2761, prAL, gcSo},     //         CURVED STEM PARAGRAPH SIGN ORNAMENT
	{0x2762, 0x2763, prEX, gcSo},     //     [2] HEAVY EXCLAMATION MARK ORNAMENT..HEAVY HEART EXCLAMATION MARK ORNAMENT
	{0x2764, 0x2764, prID, gcSo},     //         HEAVY BLACK HEART
	{0x2765, 0x2767, prAL, gcSo},     //     [3] ROTATED HEAVY BLACK HEART BULLET..ROTATED FLORAL HEART BULLET
	{0x2768, 0x2768, prOP, gcPs},     //         MEDIUM LEFT PARENTHESIS ORNAMENT
	{0x2769, 0x2769, prCL, gcPe},     //         MEDIUM RIGHT PARENTHESIS ORNAMENT
	{0x276A, 0x276A, prOP, gcPs},     //         MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
	{0x276B, 0x276B, prCL, gcPe},     //         MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
	{0x276C, 0x276C, prOP, gcPs},     //         MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x276D, 0x276D, prCL, gcPe},     //         MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x276E, 0x276E, prOP, gcPs},     //         HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x276F, 0x276F, prCL, gcPe},     //         HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
	{0x2770, 0x2770, prOP, gcPs},     //         HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
	{0x2771, 0x2771, prCL, gcPe},     //         HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
	{0x2772, 0x2772, prOP, gcPs},     //         LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
	{0x2773, 0x2773, prCL, gcPe},     //         LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
	{0x2774, 0x2774, prOP, gcPs},     //         MEDIUM LEFT CURLY BRACKET ORNAMENT
	{0x2775, 0x2775, prCL, gcPe},     //         MEDIUM RIGHT CURLY BRACKET ORNAMENT
	{0x2776, 0x2793, prAI, gcNo},     //    [30] DINGBAT NEGATIVE CIRCLED DIGIT ONE..DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
	{0x2794, 0x27BF, prAL, gcSo},     //    [44] HEAVY WIDE-HEADED RIGHTWARDS ARROW..DOUBLE CURLY LOOP
	{0x27C0, 0x27C4, prAL, gcSm},     //     [5] THREE DIMENSIONAL ANGLE..OPEN SUPERSET
	{0x27C5, 0x27C5, prOP, gcPs},     //         LEFT S-SHAPED BAG DELIMITER
	{0x27C6, 0x27C6, prCL, gcPe},     //         RIGHT S-SHAPED BAG DELIMITER
	{0x27C7, 0x27E5, prAL, gcSm},     //    [31] OR WITH DOT INSIDE..WHITE SQUARE WITH RIGHTWARDS TICK
	{0x27E6, 0x27E6, prOP, gcPs},     //         MATHEMATICAL LEFT WHITE SQUARE BRACKET
	{0x27E7, 0x27E7, prCL, gcPe},     //         MATHEMATICAL RIGHT WHITE SQUARE BRACKET
	{0x27E8, 0x27E8, prOP, gcPs},     //         MATHEMATICAL LEFT ANGLE BRACKET
	{0x27E9, 0x27E9, prCL, gcPe},     //         MATHEMATICAL RIGHT ANGLE BRACKET
	{0x27EA, 0x27EA, prOP, gcPs},     //         MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
	{0x27EB, 0x27EB, prCL, gcPe},     //         MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
	{0x27EC, 0x27EC, prOP, gcPs},     //         MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET
	{0x27ED, 0x27ED, prCL, gcPe},     //         MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET
	{0x27EE, 0x27EE, prOP, gcPs},     //         MATHEMATICAL LEFT FLATTENED PARENTHESIS
	{0x27EF, 0x27EF, prCL, gcPe},     //         MATHEMATICAL RIGHT FLATTENED PARENTHESIS
	{0x27F0, 0x27FF, prAL, gcSm},     //    [16] UPWARDS QUADRUPLE ARROW..LONG RIGHTWARDS SQUIGGLE ARROW
	{0x2800, 0x28FF, prAL, gcSo},     //   [256] BRAILLE PATTERN BLANK..BRAILLE PATTERN DOTS-12345678
	{0x2900, 0x297F, prAL, gcSm},     //   [128] RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE..DOWN FISH TAIL
	{0x2980, 0x2982, prAL, gcSm},     //     [3] TRIPLE VERTICAL BAR DELIMITER..Z NOTATION TYPE COLON
	{0x2983, 0x2983, prOP, gcPs},     //         LEFT WHITE CURLY BRACKET
	{0x2984, 0x2984, prCL, gcPe},     //         RIGHT WHITE CURLY BRACKET
	{0x2985, 0x2985, prOP, gcPs},     //         LEFT WHITE PARENTHESIS
	{0x2986, 0x2986, prCL, gcPe},     //         RIGHT WHITE PARENTHESIS
	{0x2987, 0x2987, prOP, gcPs},     //         Z NOTATION LEFT IMAGE BRACKET
	{0x2988, 0x2988, prCL, gcPe},     //         Z NOTATION RIGHT IMAGE BRACKET
	{0x2989, 0x2989, prOP, gcPs},     //         Z NOTATION LEFT BINDING BRACKET
	{0x298A, 0x298A, prCL, gcPe},     //         Z NOTATION RIGHT BINDING BRACKET
	{0x298B, 0x298B, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH UNDERBAR
	{0x298C, 0x298C, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH UNDERBAR
	{0x298D, 0x298D, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x298E, 0x298E, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x298F, 0x298F, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
	{0x2990, 0x2990, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
	{0x2991, 0x2991, prOP, gcPs},     //         LEFT ANGLE BRACKET WITH DOT
	{0x2992, 0x2992, prCL, gcPe},     //         RIGHT ANGLE BRACKET WITH DOT
	{0x2993, 0x2993, prOP, gcPs},     //         LEFT ARC LESS-THAN BRACKET
	{0x2994, 0x2994, prCL, gcPe},     //         RIGHT ARC GREATER-THAN BRACKET
	{0x2995, 0x2995, prOP, gcPs},     //         DOUBLE LEFT ARC GREATER-THAN BRACKET
	{0x2996, 0x2996, prCL, gcPe},     //         DOUBLE RIGHT ARC LESS-THAN BRACKET
	{0x2997, 0x2997, prOP, gcPs},     //         LEFT BLACK TORTOISE SHELL BRACKET
	{0x2998, 0x2998, prCL, gcPe},     //         RIGHT BLACK TORTOISE SHELL BRACKET
	{0x2999, 0x29D7, prAL, gcSm},     //    [63] DOTTED FENCE..BLACK HOURGLASS
	{0x29D8, 0x29D8, prOP, gcPs},     //         LEFT WIGGLY FENCE
	{0x29D9, 0x29D9, prCL, gcPe},     //         RIGHT WIGGLY FENCE
	{0x29DA, 0x29DA, prOP, gcPs},     //         LEFT DOUBLE WIGGLY FENCE
	{0x29DB, 0x29DB, prCL, gcPe},     //         RIGHT DOUBLE WIGGLY FENCE
	{0x29DC, 0x29FB, prAL, gcSm},     //    [32] INCOMPLETE INFINITY..TRIPLE PLUS
	{0x29FC, 0x29FC, prOP, gcPs},     //         LEFT-POINTING CURVED ANGLE BRACKET
	{0x29FD, 0x29FD, prCL, gcPe},     //         RIGHT-POINTING CURVED ANGLE BRACKET
	{0x29FE, 0x29FF, prAL, gcSm},     //     [2] TINY..MINY
	{0x2A00, 0x2AFF, prAL, gcSm},     //   [256] N-ARY CIRCLED DOT OPERATOR..N-ARY WHITE VERTICAL BAR
	{0x2B00, 0x2B2F, prAL, gcSo},     //    [48] NORTH EAST WHITE ARROW..WHITE VERTICAL ELLIPSE
	{0x2B30, 0x2B44, prAL, gcSm},     //    [21] LEFT ARROW WITH SMALL CIRCLE..RIGHTWARDS ARROW THROUGH SUPERSET
	{0x2B45, 0x2B46, prAL, gcSo},     //     [2] LEFTWARDS QUADRUPLE ARROW..RIGHTWARDS QUADRUPLE ARROW
	{0x2B47, 0x2B4C, prAL, gcSm},     //     [6] REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW..RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR
	{0x2B4D, 0x2B54, prAL, gcSo},     //     [8] DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW..WHITE RIGHT-POINTING PENTAGON
	{0x2B55, 0x2B59, prAI, gcSo},     //     [5] HEAVY LARGE CIRCLE..HEAVY CIRCLED SALTIRE
	{0x2B5A, 0x2B73, prAL, gcSo},     //    [26] SLANTED NORTH ARROW WITH HOOKED HEAD..DOWNWARDS TRIANGLE-HEADED ARROW TO BAR
	{0x2B76, 0x2B95, prAL, gcSo},     //    [32] NORTH WEST TRIANGLE-HEADED ARROW TO BAR..RIGHTWARDS BLACK ARROW
	{0x2B97, 0x2BFF, prAL, gcSo},     //   [105] SYMBOL FOR TYPE A ELECTRONICS..HELLSCHREIBER PAUSE SYMBOL
	{0x2C00, 0x2C5F, prAL, gcLC},     //    [96] GLAGOLITIC CAPITAL LETTER AZU..GLAGOLITIC SMALL LETTER CAUDATE CHRIVI
	{0x2C60, 0x2C7B, prAL, gcLC},     //    [28] LATIN CAPITAL LETTER L WITH DOUBLE BAR..LATIN LETTER SMALL CAPITAL TURNED E
	{0x2C7C, 0x2C7D, prAL, gcLm},     //     [2] LATIN SUBSCRIPT SMALL LETTER J..MODIFIER LETTER CAPITAL V
	{0x2C7E, 0x2C7F, prAL, gcLu},     //     [2] LATIN CAPITAL LETTER S WITH SWASH TAIL..LATIN CAPITAL LETTER Z WITH SWASH TAIL
	{0x2C80, 0x2CE4, prAL, gcLC},     //   [101] COPTIC CAPITAL LETTER ALFA..COPTIC SYMBOL KAI
	{0x2CE5, 0x2CEA, prAL, gcSo},     //     [6] COPTIC SYMBOL MI RO..COPTIC SYMBOL SHIMA SIMA
	{0x2CEB, 0x2CEE, prAL, gcLC},     //     [4] COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI..COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA
	{0x2CEF, 0x2CF1, prCM, gcMn},     //     [3] COPTIC COMBINING NI ABOVE..COPTIC COMBINING SPIRITUS LENIS
	{0x2CF2, 0x2CF3, prAL, gcLC},     //     [2] COPTIC CAPITAL LETTER BOHAIRIC KHEI..COPTIC SMALL LETTER BOHAIRIC KHEI
	{0x2CF9, 0x2CF9, prEX, gcPo},     //         COPTIC OLD NUBIAN FULL STOP
	{0x2CFA, 0x2CFC, prBA, gcPo},     //     [3] COPTIC OLD NUBIAN DIRECT QUESTION MARK..COPTIC OLD NUBIAN VERSE DIVIDER
	{0x2CFD, 0x2CFD, prAL, gcNo},     //         COPTIC FRACTION ONE HALF
	{0x2CFE, 0x2CFE, prEX, gcPo},     //         COPTIC FULL STOP
	{0x2CFF, 0x2CFF, prBA, gcPo},     //         COPTIC MORPHOLOGICAL DIVIDER
	{0x2D00, 0x2D25, prAL, gcLl},     //    [38] GEORGIAN SMALL LETTER AN..GEORGIAN SMALL LETTER HOE
	{0x2D27, 0x2D27, prAL, gcLl},     //         GEORGIAN SMALL LETTER YN
	{0x2D2D, 0x2D2D, prAL, gcLl},     //         GEORGIAN SMALL LETTER AEN
	{0x2D30, 0x2D67, prAL, gcLo},     //    [56] TIFINAGH LETTER YA..TIFINAGH LETTER YO
	{0x2D6F, 0x2D6F, prAL, gcLm},     //         TIFINAGH MODIFIER LETTER LABIALIZATION MARK
	{0x2D70, 0x2D70, prBA, gcPo},     //         TIFINAGH SEPARATOR MARK
	{0x2D7F, 0x2D7F, prCM, gcMn},     //         TIFINAGH CONSONANT JOINER
	{0x2D80, 0x2D96, prAL, gcLo},     //    [23] ETHIOPIC SYLLABLE LOA..ETHIOPIC SYLLABLE GGWE
	{0x2DA0, 0x2DA6, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE SSA..ETHIOPIC SYLLABLE SSO
	{0x2DA8, 0x2DAE, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE CCA..ETHIOPIC SYLLABLE CCO
	{0x2DB0, 0x2DB6, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE ZZA..ETHIOPIC SYLLABLE ZZO
	{0x2DB8, 0x2DBE, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE CCHA..ETHIOPIC SYLLABLE CCHO
	{0x2DC0, 0x2DC6, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE QYA..ETHIOPIC SYLLABLE QYO
	{0x2DC8, 0x2DCE, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE KYA..ETHIOPIC SYLLABLE KYO
	{0x2DD0, 0x2DD6, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE XYA..ETHIOPIC SYLLABLE XYO
	{0x2DD8, 0x2DDE, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE GYA..ETHIOPIC SYLLABLE GYO
	{0x2DE0, 0x2DFF, prCM, gcMn},     //    [32] COMBINING CYRILLIC LETTER BE..COMBINING CYRILLIC LETTER IOTIFIED BIG YUS
	{0x2E00, 0x2E01, prQU, gcPo},     //     [2] RIGHT ANGLE SUBSTITUTION MARKER..RIGHT ANGLE DOTTED SUBSTITUTION MARKER
	{0x2E02, 0x2E02, prQU, gcPi},     //         LEFT SUBSTITUTION BRACKET
	{0x2E03, 0x2E03, prQU, gcPf},     //         RIGHT SUBSTITUTION BRACKET
	{0x2E04, 0x2E04, prQU, gcPi},     //         LEFT DOTTED SUBSTITUTION BRACKET
	{0x2E05, 0x2E05, prQU, gcPf},     //         RIGHT DOTTED SUBSTITUTION BRACKET
	{0x2E06, 0x2E08, prQU, gcPo},     //     [3] RAISED INTERPOLATION MARKER..DOTTED TRANSPOSITION MARKER
	{0x2E09, 0x2E09, prQU, gcPi},     //         LEFT TRANSPOSITION BRACKET
	{0x2E0A, 0x2E0A, prQU, gcPf},     //         RIGHT TRANSPOSITION BRACKET
	{0x2E0B, 0x2E0B, prQU, gcPo},     //         RAISED SQUARE
	{0x2E0C, 0x2E0C, prQU, gcPi},     //         LEFT RAISED OMISSION BRACKET
	{0x2E0D, 0x2E0D, prQU, gcPf},     //         RIGHT RAISED OMISSION BRACKET
	{0x2E0E, 0x2E15, prBA, gcPo},     //     [8] EDITORIAL CORONIS..UPWARDS ANCORA
	{0x2E16, 0x2E16, prAL, gcPo},     //         DOTTED RIGHT-POINTING ANGLE
	{0x2E17, 0x2E17, prBA, gcPd},     //         DOUBLE OBLIQUE HYPHEN
	{0x2E18, 0x2E18, prOP, gcPo},     //         INVERTED INTERROBANG
	{0x2E19, 0x2E19, prBA, gcPo},     //         PALM BRANCH
	{0x2E1A, 0x2E1A, prAL, gcPd},     //         HYPHEN WITH DIAERESIS
	{0x2E1B, 0x2E1B, prAL, gcPo},     //         TILDE WITH RING ABOVE
	{0x2E1C, 0x2E1C, prQU, gcPi},     //         LEFT LOW PARAPHRASE BRACKET
	{0x2E1D, 0x2E1D, prQU, gcPf},     //         RIGHT LOW PARAPHRASE BRACKET
	{0x2E1E, 0x2E1F, prAL, gcPo},     //     [2] TILDE WITH DOT ABOVE..TILDE WITH DOT BELOW
	{0x2E20, 0x2E20, prQU, gcPi},     //         LEFT VERTICAL BAR WITH QUILL
	{0x2E21, 0x2E21, prQU, gcPf},     //         RIGHT VERTICAL BAR WITH QUILL
	{0x2E22, 0x2E22, prOP, gcPs},     //         TOP LEFT HALF BRACKET
	{0x2E23, 0x2E23, prCL, gcPe},     //         TOP RIGHT HALF BRACKET
	{0x2E24, 0x2E24, prOP, gcPs},     //         BOTTOM LEFT HALF BRACKET
	{0x2E25, 0x2E25, prCL, gcPe},     //         BOTTOM RIGHT HALF BRACKET
	{0x2E26, 0x2E26, prOP, gcPs},     //         LEFT SIDEWAYS U BRACKET
	{0x2E27, 0x2E27, prCL, gcPe},     //         RIGHT SIDEWAYS U BRACKET
	{0x2E28, 0x2E28, prOP, gcPs},     //         LEFT DOUBLE PARENTHESIS
	{0x2E29, 0x2E29, prCL, gcPe},     //         RIGHT DOUBLE PARENTHESIS
	{0x2E2A, 0x2E2D, prBA, gcPo},     //     [4] TWO DOTS OVER ONE DOT PUNCTUATION..FIVE DOT MARK
	{0x2E2E, 0x2E2E, prEX, gcPo},     //         REVERSED QUESTION MARK
	{0x2E2F, 0x2E2F, prAL, gcLm},     //         VERTICAL TILDE
	{0x2E30, 0x2E31, prBA, gcPo},     //     [2] RING POINT..WORD SEPARATOR MIDDLE DOT
	{0x2E32, 0x2E32, prAL, gcPo},     //         TURNED COMMA
	{0x2E33, 0x2E34, prBA, gcPo},     //     [2] RAISED DOT..RAISED COMMA
	{0x2E35, 0x2E39, prAL, gcPo},     //     [5] TURNED SEMICOLON..TOP HALF SECTION SIGN
	{0x2E3A, 0x2E3B, prB2, gcPd},     //     [2] TWO-EM DASH..THREE-EM DASH
	{0x2E3C, 0x2E3E, prBA, gcPo},     //     [3] STENOGRAPHIC FULL STOP..WIGGLY VERTICAL LINE
	{0x2E3F, 0x2E3F, prAL, gcPo},     //         CAPITULUM
	{0x2E40, 0x2E40, prBA, gcPd},     //         DOUBLE HYPHEN
	{0x2E41, 0x2E41, prBA, gcPo},     //         REVERSED COMMA
	{0x2E42, 0x2E42, prOP, gcPs},     //         DOUBLE LOW-REVERSED-9 QUOTATION MARK
	{0x2E43, 0x2E4A, prBA, gcPo},     //     [8] DASH WITH LEFT UPTURN..DOTTED SOLIDUS
	{0x2E4B, 0x2E4B, prAL, gcPo},     //         TRIPLE DAGGER
	{0x2E4C, 0x2E4C, prBA, gcPo},     //         MEDIEVAL COMMA
	{0x2E4D, 0x2E4D, prAL, gcPo},     //         PARAGRAPHUS MARK
	{0x2E4E, 0x2E4F, prBA, gcPo},     //     [2] PUNCTUS ELEVATUS MARK..CORNISH VERSE DIVIDER
	{0x2E50, 0x2E51, prAL, gcSo},     //     [2] CROSS PATTY WITH RIGHT CROSSBAR..CROSS PATTY WITH LEFT CROSSBAR
	{0x2E52, 0x2E52, prAL, gcPo},     //         TIRONIAN SIGN CAPITAL ET
	{0x2E53, 0x2E54, prEX, gcPo},     //     [2] MEDIEVAL EXCLAMATION MARK..MEDIEVAL QUESTION MARK
	{0x2E55, 0x2E55, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH STROKE
	{0x2E56, 0x2E56, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH STROKE
	{0x2E57, 0x2E57, prOP, gcPs},     //         LEFT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E58, 0x2E58, prCL, gcPe},     //         RIGHT SQUARE BRACKET WITH DOUBLE STROKE
	{0x2E59, 0x2E59, prOP, gcPs},     //         TOP HALF LEFT PARENTHESIS
	{0x2E5A, 0x2E5A, prCL, gcPe},     //         TOP HALF RIGHT PARENTHESIS
	{0x2E5B, 0x2E5B, prOP, gcPs},     //         BOTTOM HALF LEFT PARENTHESIS
	{0x2E5C, 0x2E5C, prCL, gcPe},     //         BOTTOM HALF RIGHT PARENTHESIS
	{0x2E5D, 0x2E5D, prBA, gcPd},     //         OBLIQUE HYPHEN
	{0x2E80, 0x2E99, prID, gcSo},     //    [26] CJK RADICAL REPEAT..CJK RADICAL RAP
	{0x2E9B, 0x2EF3, prID, gcSo},     //    [89] CJK RADICAL CHOKE..CJK RADICAL C-SIMPLIFIED TURTLE
	{0x2F00, 0x2FD5, prID, gcSo},     //   [214] KANGXI RADICAL ONE..KANGXI RADICAL FLUTE
	{0x2FF0, 0x2FFB, prID, gcSo},     //    [12] IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT..IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
	{0x3000, 0x3000, prBA, gcZs},     //         IDEOGRAPHIC SPACE
	{0x3001, 0x3002, prCL, gcPo},     //     [2] IDEOGRAPHIC COMMA..IDEOGRAPHIC FULL STOP
	{0x3003, 0x3003, prID, gcPo},     //         DITTO MARK
	{0x3004, 0x3004, prID, gcSo},     //         JAPANESE INDUSTRIAL STANDARD SYMBOL
	{0x3005, 0x3005, prNS, gcLm},     //         IDEOGRAPHIC ITERATION MARK
	{0x3006, 0x3006, prID, gcLo},     //         IDEOGRAPHIC CLOSING MARK
	{0x3007, 0x3007, prID, gcNl},     //         IDEOGRAPHIC NUMBER ZERO
	{0x3008, 0x3008, prOP, gcPs},     //         LEFT ANGLE BRACKET
	{0x3009, 0x3009, prCL, gcPe},     //         RIGHT ANGLE BRACKET
	{0x300A, 0x300A, prOP, gcPs},     //         LEFT DOUBLE ANGLE BRACKET
	{0x300B, 0x300B, prCL, gcPe},     //         RIGHT DOUBLE ANGLE BRACKET
	{0x300C, 0x300C, prOP, gcPs},     //         LEFT CORNER BRACKET
	{0x300D, 0x300D, prCL, gcPe},     //         RIGHT CORNER BRACKET
	{0x300E, 0x300E, prOP, gcPs},     //         LEFT WHITE CORNER BRACKET
	{0x300F, 0x300F, prCL, gcPe},     //         RIGHT WHITE CORNER BRACKET
	{0x3010, 0x3010, prOP, gcPs},     //         LEFT BLACK LENTICULAR BRACKET
	{0x3011, 0x3011, prCL, gcPe},     //         RIGHT BLACK LENTICULAR BRACKET
	{0x3012, 0x3013, prID, gcSo},     //     [2] POSTAL MARK..GETA MARK
	{0x3014, 0x3014, prOP, gcPs},     //         LEFT TORTOISE SHELL BRACKET
	{0x3015, 0x3015, prCL, gcPe},     //         RIGHT TORTOISE SHELL BRACKET
	{0x3016, 0x3016, prOP, gcPs},     //         LEFT WHITE LENTICULAR BRACKET
	{0x3017, 0x3017, prCL, gcPe},     //         RIGHT WHITE LENTICULAR BRACKET
	{0x3018, 0x3018, prOP, gcPs},     //         LEFT WHITE TORTOISE SHELL BRACKET
	{0x3019, 0x3019, prCL, gcPe},     //         RIGHT WHITE TORTOISE SHELL BRACKET
	{0x301A, 0x301A, prOP, gcPs},     //         LEFT WHITE SQUARE BRACKET
	{0x301B, 0x301B, prCL, gcPe},     //         RIGHT WHITE SQUARE BRACKET
	{0x301C, 0x301C, prNS, gcPd},     //         WAVE DASH
	{0x301D, 0x301D, prOP, gcPs},     //         REVERSED DOUBLE PRIME QUOTATION MARK
	{0x301E, 0x301F, prCL, gcPe},     //     [2] DOUBLE PRIME QUOTATION MARK..LOW DOUBLE PRIME QUOTATION MARK
	{0x3020, 0x3020, prID, gcSo},     //         POSTAL MARK FACE
	{0x3021, 0x3029, prID, gcNl},     //     [9] HANGZHOU NUMERAL ONE..HANGZHOU NUMERAL NINE
	{0x302A, 0x302D, prCM, gcMn},     //     [4] IDEOGRAPHIC LEVEL TONE MARK..IDEOGRAPHIC ENTERING TONE MARK
	{0x302E, 0x302F, prCM, gcMc},     //     [2] HANGUL SINGLE DOT TONE MARK..HANGUL DOUBLE DOT TONE MARK
	{0x3030, 0x3030, prID, gcPd},     //         WAVY DASH
	{0x3031, 0x3034, prID, gcLm},     //     [4] VERTICAL KANA REPEAT MARK..VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF
	{0x3035, 0x3035, prCM, gcLm},     //         VERTICAL KANA REPEAT MARK LOWER HALF
	{0x3036, 0x3037, prID, gcSo},     //     [2] CIRCLED POSTAL MARK..IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
	{0x3038, 0x303A, prID, gcNl},     //     [3] HANGZHOU NUMERAL TEN..HANGZHOU NUMERAL THIRTY
	{0x303B, 0x303B, prNS, gcLm},     //         VERTICAL IDEOGRAPHIC ITERATION MARK
	{0x303C, 0x303C, prNS, gcLo},     //         MASU MARK
	{0x303D, 0x303D, prID, gcPo},     //         PART ALTERNATION MARK
	{0x303E, 0x303F, prID, gcSo},     //     [2] IDEOGRAPHIC VARIATION INDICATOR..IDEOGRAPHIC HALF FILL SPACE
	{0x3041, 0x3041, prCJ, gcLo},     //         HIRAGANA LETTER SMALL A
	{0x3042, 0x3042, prID, gcLo},     //         HIRAGANA LETTER A
	{0x3043, 0x3043, prCJ, gcLo},     //         HIRAGANA LETTER SMALL I
	{0x3044, 0x3044, prID, gcLo},     //         HIRAGANA LETTER I
	{0x3045, 0x3045, prCJ, gcLo},     //         HIRAGANA LETTER SMALL U
	{0x3046, 0x3046, prID, gcLo},     //         HIRAGANA LETTER U
	{0x3047, 0x3047, prCJ, gcLo},     //         HIRAGANA LETTER SMALL E
	{0x3048, 0x3048, prID, gcLo},     //         HIRAGANA LETTER E
	{0x3049, 0x3049, prCJ, gcLo},     //         HIRAGANA LETTER SMALL O
	{0x304A, 0x3062, prID, gcLo},     //    [25] HIRAGANA LETTER O..HIRAGANA LETTER DI
	{0x3063, 0x3063, prCJ, gcLo},     //         HIRAGANA LETTER SMALL TU
	{0x3064, 0x3082, prID, gcLo},     //    [31] HIRAGANA LETTER TU..HIRAGANA LETTER MO
	{0x3083, 0x3083, prCJ, gcLo},     //         HIRAGANA LETTER SMALL YA
	{0x3084, 0x3084, prID, gcLo},     //         HIRAGANA LETTER YA
	{0x3085, 0x3085, prCJ, gcLo},     //         HIRAGANA LETTER SMALL YU
	{0x3086, 0x3086, prID, gcLo},     //         HIRAGANA LETTER YU
	{0x3087, 0x3087, prCJ, gcLo},     //         HIRAGANA LETTER SMALL YO
	{0x3088, 0x308D, prID, gcLo},     //     [6] HIRAGANA LETTER YO..HIRAGANA LETTER RO
	{0x308E, 0x308E, prCJ, gcLo},     //         HIRAGANA LETTER SMALL WA
	{0x308F, 0x3094, prID, gcLo},     //     [6] HIRAGANA LETTER WA..HIRAGANA LETTER VU
	{0x3095, 0x3096, prCJ, gcLo},     //     [2] HIRAGANA LETTER SMALL KA..HIRAGANA LETTER SMALL KE
	{0x3099, 0x309A, prCM, gcMn},     //     [2] COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK..COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{0x309B, 0x309C, prNS, gcSk},     //     [2] KATAKANA-HIRAGANA VOICED SOUND MARK..KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
	{0x309D, 0x309E, prNS, gcLm},     //     [2] HIRAGANA ITERATION MARK..HIRAGANA VOICED ITERATION MARK
	{0x309F, 0x309F, prID, gcLo},     //         HIRAGANA DIGRAPH YORI
	{0x30A0, 0x30A0, prNS, gcPd},     //         KATAKANA-HIRAGANA DOUBLE HYPHEN
	{0x30A1, 0x30A1, prCJ, gcLo},     //         KATAKANA LETTER SMALL A
	{0x30A2, 0x30A2, prID, gcLo},     //         KATAKANA LETTER A
	{0x30A3, 0x30A3, prCJ, gcLo},     //         KATAKANA LETTER SMALL I
	{0x30A4, 0x30A4, prID, gcLo},     //         KATAKANA LETTER I
	{0x30A5, 0x30A5, prCJ, gcLo},     //         KATAKANA LETTER SMALL U
	{0x30A6, 0x30A6, prID, gcLo},     //         KATAKANA LETTER U
	{0x30A7, 0x30A7, prCJ, gcLo},     //         KATAKANA LETTER SMALL E
	{0x30A8, 0x30A8, prID, gcLo},     //         KATAKANA LETTER E
	{0x30A9, 0x30A9, prCJ, gcLo},     //         KATAKANA LETTER SMALL O
	{0x30AA, 0x30C2, prID, gcLo},     //    [25] KATAKANA LETTER O..KATAKANA LETTER DI
	{0x30C3, 0x30C3, prCJ, gcLo},     //         KATAKANA LETTER SMALL TU
	{0x30C4, 0x30E2, prID, gcLo},     //    [31] KATAKANA LETTER TU..KATAKANA LETTER MO
	{0x30E3, 0x30E3, prCJ, gcLo},     //         KATAKANA LETTER SMALL YA
	{0x30E4, 0x30E4, prID, gcLo},     //         KATAKANA LETTER YA
	{0x30E5, 0x30E5, prCJ, gcLo},     //         KATAKANA LETTER SMALL YU
	{0x30E6, 0x30E6, prID, gcLo},     //         KATAKANA LETTER YU
	{0x30E7, 0x30E7, prCJ, gcLo},     //         KATAKANA LETTER SMALL YO
	{0x30E8, 0x30ED, prID, gcLo},     //     [6] KATAKANA LETTER YO..KATAKANA LETTER RO
	{0x30EE, 0x30EE, prCJ, gcLo},     //         KATAKANA LETTER SMALL WA
	{0x30EF, 0x30F4, prID, gcLo},     //     [6] KATAKANA LETTER WA..KATAKANA LETTER VU
	{0x30F5, 0x30F6, prCJ, gcLo},     //     [2] KATAKANA LETTER SMALL KA..KATAKANA LETTER SMALL KE
	{0x30F7, 0x30FA, prID, gcLo},     //     [4] KATAKANA LETTER VA..KATAKANA LETTER VO
	{0x30FB, 0x30FB, prNS, gcPo},     //         KATAKANA MIDDLE DOT
	{0x30FC, 0x30FC, prCJ, gcLm},     //         KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{0x30FD, 0x30FE, prNS, gcLm},     //     [2] KATAKANA ITERATION MARK..KATAKANA VOICED ITERATION MARK
	{0x30FF, 0x30FF, prID, gcLo},     //         KATAKANA DIGRAPH KOTO
	{0x3105, 0x312F, prID, gcLo},     //    [43] BOPOMOFO LETTER B..BOPOMOFO LETTER NN
	{0x3131, 0x318E, prID, gcLo},     //    [94] HANGUL LETTER KIYEOK..HANGUL LETTER ARAEAE
	{0x3190, 0x3191, prID, gcSo},     //     [2] IDEOGRAPHIC ANNOTATION LINKING MARK..IDEOGRAPHIC ANNOTATION REVERSE MARK
	{0x3192, 0x3195, prID, gcNo},     //     [4] IDEOGRAPHIC ANNOTATION ONE MARK..IDEOGRAPHIC ANNOTATION FOUR MARK
	{0x3196, 0x319F, prID, gcSo},     //    [10] IDEOGRAPHIC ANNOTATION TOP MARK..IDEOGRAPHIC ANNOTATION MAN MARK
	{0x31A0, 0x31BF, prID, gcLo},     //    [32] BOPOMOFO LETTER BU..BOPOMOFO LETTER AH
	{0x31C0, 0x31E3, prID, gcSo},     //    [36] CJK STROKE T..CJK STROKE Q
	{0x31F0, 0x31FF, prCJ, gcLo},     //    [16] KATAKANA LETTER SMALL KU..KATAKANA LETTER SMALL RO
	{0x3200, 0x321E, prID, gcSo},     //    [31] PARENTHESIZED HANGUL KIYEOK..PARENTHESIZED KOREAN CHARACTER O HU
	{0x3220, 0x3229, prID, gcNo},     //    [10] PARENTHESIZED IDEOGRAPH ONE..PARENTHESIZED IDEOGRAPH TEN
	{0x322A, 0x3247, prID, gcSo},     //    [30] PARENTHESIZED IDEOGRAPH MOON..CIRCLED IDEOGRAPH KOTO
	{0x3248, 0x324F, prAI, gcNo},     //     [8] CIRCLED NUMBER TEN ON BLACK SQUARE..CIRCLED NUMBER EIGHTY ON BLACK SQUARE
	{0x3250, 0x3250, prID, gcSo},     //         PARTNERSHIP SIGN
	{0x3251, 0x325F, prID, gcNo},     //    [15] CIRCLED NUMBER TWENTY ONE..CIRCLED NUMBER THIRTY FIVE
	{0x3260, 0x327F, prID, gcSo},     //    [32] CIRCLED HANGUL KIYEOK..KOREAN STANDARD SYMBOL
	{0x3280, 0x3289, prID, gcNo},     //    [10] CIRCLED IDEOGRAPH ONE..CIRCLED IDEOGRAPH TEN
	{0x328A, 0x32B0, prID, gcSo},     //    [39] CIRCLED IDEOGRAPH MOON..CIRCLED IDEOGRAPH NIGHT
	{0x32B1, 0x32BF, prID, gcNo},     //    [15] CIRCLED NUMBER THIRTY SIX..CIRCLED NUMBER FIFTY
	{0x32C0, 0x32FF, prID, gcSo},     //    [64] IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY..SQUARE ERA NAME REIWA
	{0x3300, 0x33FF, prID, gcSo},     //   [256] SQUARE APAATO..SQUARE GAL
	{0x3400, 0x4DBF, prID, gcLo},     //  [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF
	{0x4DC0, 0x4DFF, prAL, gcSo},     //    [64] HEXAGRAM FOR THE CREATIVE HEAVEN..HEXAGRAM FOR BEFORE COMPLETION
	{0x4E00, 0x9FFF, prID, gcLo},     // [20992] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFF
	{0xA000, 0xA014, prID, gcLo},     //    [21] YI SYLLABLE IT..YI SYLLABLE E
	{0xA015, 0xA015, prNS, gcLm},     //         YI SYLLABLE WU
	{0xA016, 0xA48C, prID, gcLo},     //  [1143] YI SYLLABLE BIT..YI SYLLABLE YYR
	{0xA490, 0xA4C6, prID, gcSo},     //    [55] YI RADICAL QOT..YI RADICAL KE
	{0xA4D0, 0xA4F7, prAL, gcLo},     //    [40] LISU LETTER BA..LISU LETTER OE
	{0xA4F8, 0xA4FD, prAL, gcLm},     //     [6] LISU LETTER TONE MYA TI..LISU LETTER TONE MYA JEU
	{0xA4FE, 0xA4FF, prBA, gcPo},     //     [2] LISU PUNCTUATION COMMA..LISU PUNCTUATION FULL STOP
	{0xA500, 0xA60B, prAL, gcLo},     //   [268] VAI SYLLABLE EE..VAI SYLLABLE NG
	{0xA60C, 0xA60C, prAL, gcLm},     //         VAI SYLLABLE LENGTHENER
	{0xA60D, 0xA60D, prBA, gcPo},     //         VAI COMMA
	{0xA60E, 0xA60E, prEX, gcPo},     //         VAI FULL STOP
	{0xA60F, 0xA60F, prBA, gcPo},     //         VAI QUESTION MARK
	{0xA610, 0xA61F, prAL, gcLo},     //    [16] VAI SYLLABLE NDOLE FA..VAI SYMBOL JONG
	{0xA620, 0xA629, prNU, gcNd},     //    [10] VAI DIGIT ZERO..VAI DIGIT NINE
	{0xA62A, 0xA62B, prAL, gcLo},     //     [2] VAI SYLLABLE NDOLE MA..VAI SYLLABLE NDOLE DO
	{0xA640, 0xA66D, prAL, gcLC},     //    [46] CYRILLIC CAPITAL LETTER ZEMLYA..CYRILLIC SMALL LETTER DOUBLE MONOCULAR O
	{0xA66E, 0xA66E, prAL, gcLo},     //         CYRILLIC LETTER MULTIOCULAR O
	{0xA66F, 0xA66F, prCM, gcMn},     //         COMBINING CYRILLIC VZMET
	{0xA670, 0xA672, prCM, gcMe},     //     [3] COMBINING CYRILLIC TEN MILLIONS SIGN..COMBINING CYRILLIC THOUSAND MILLIONS SIGN
	{0xA673, 0xA673, prAL, gcPo},     //         SLAVONIC ASTERISK
	{0xA674, 0xA67D, prCM, gcMn},     //    [10] COMBINING CYRILLIC LETTER UKRAINIAN IE..COMBINING CYRILLIC PAYEROK
	{0xA67E, 0xA67E, prAL, gcPo},     //         CYRILLIC KAVYKA
	{0xA67F, 0xA67F, prAL, gcLm},     //         CYRILLIC PAYEROK
	{0xA680, 0xA69B, prAL, gcLC},     //    [28] CYRILLIC CAPITAL LETTER DWE..CYRILLIC SMALL LETTER CROSSED O
	{0xA69C, 0xA69D, prAL, gcLm},     //     [2] MODIFIER LETTER CYRILLIC HARD SIGN..MODIFIER LETTER CYRILLIC SOFT SIGN
	{0xA69E, 0xA69F, prCM, gcMn},     //     [2] COMBINING CYRILLIC LETTER EF..COMBINING CYRILLIC LETTER IOTIFIED E
	{0xA6A0, 0xA6E5, prAL, gcLo},     //    [70] BAMUM LETTER A..BAMUM LETTER KI
	{0xA6E6, 0xA6EF, prAL, gcNl},     //    [10] BAMUM LETTER MO..BAMUM LETTER KOGHOM
	{0xA6F0, 0xA6F1, prCM, gcMn},     //     [2] BAMUM COMBINING MARK KOQNDON..BAMUM COMBINING MARK TUKWENTIS
	{0xA6F2, 0xA6F2, prAL, gcPo},     //         BAMUM NJAEMLI
	{0xA6F3, 0xA6F7, prBA, gcPo},     //     [5] BAMUM FULL STOP..BAMUM QUESTION MARK
	{0xA700, 0xA716, prAL, gcSk},     //    [23] MODIFIER LETTER CHINESE TONE YIN PING..MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR
	{0xA717, 0xA71F, prAL, gcLm},     //     [9] MODIFIER LETTER DOT VERTICAL BAR..MODIFIER LETTER LOW INVERTED EXCLAMATION MARK
	{0xA720, 0xA721, prAL, gcSk},     //     [2] MODIFIER LETTER STRESS AND HIGH TONE..MODIFIER LETTER STRESS AND LOW TONE
	{0xA722, 0xA76F, prAL, gcLC},     //    [78] LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF..LATIN SMALL LETTER CON
	{0xA770, 0xA770, prAL, gcLm},     //         MODIFIER LETTER US
	{0xA771, 0xA787, prAL, gcLC},     //    [23] LATIN SMALL LETTER DUM..LATIN SMALL LETTER INSULAR T
	{0xA788, 0xA788, prAL, gcLm},     //         MODIFIER LETTER LOW CIRCUMFLEX ACCENT
	{0xA789, 0xA78A, prAL, gcSk},     //     [2] MODIFIER LETTER COLON..MODIFIER LETTER SHORT EQUALS SIGN
	{0xA78B, 0xA78E, prAL, gcLC},     //     [4] LATIN CAPITAL LETTER SALTILLO..LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT
	{0xA78F, 0xA78F, prAL, gcLo},     //         LATIN LETTER SINOLOGICAL DOT
	{0xA790, 0xA7CA, prAL, gcLC},     //    [59] LATIN CAPITAL LETTER N WITH DESCENDER..LATIN SMALL LETTER S WITH SHORT STROKE OVERLAY
	{0xA7D0, 0xA7D1, prAL, gcLC},     //     [2] LATIN CAPITAL LETTER CLOSED INSULAR G..LATIN SMALL LETTER CLOSED INSULAR G
	{0xA7D3, 0xA7D3, prAL, gcLl},     //         LATIN SMALL LETTER DOUBLE THORN
	{0xA7D5, 0xA7D9, prAL, gcLC},     //     [5] LATIN SMALL LETTER DOUBLE WYNN..LATIN SMALL LETTER SIGMOID S
	{0xA7F2, 0xA7F4, prAL, gcLm},     //     [3] MODIFIER LETTER CAPITAL C..MODIFIER LETTER CAPITAL Q
	{0xA7F5, 0xA7F6, prAL, gcLC},     //     [2] LATIN CAPITAL LETTER REVERSED HALF H..LATIN SMALL LETTER REVERSED HALF H
	{0xA7F7, 0xA7F7, prAL, gcLo},     //         LATIN EPIGRAPHIC LETTER SIDEWAYS I
	{0xA7F8, 0xA7F9, prAL, gcLm},     //     [2] MODIFIER LETTER CAPITAL H WITH STROKE..MODIFIER LETTER SMALL LIGATURE OE
	{0xA7FA, 0xA7FA, prAL, gcLl},     //         LATIN LETTER SMALL CAPITAL TURNED M
	{0xA7FB, 0xA7FF, prAL, gcLo},     //     [5] LATIN EPIGRAPHIC LETTER REVERSED F..LATIN EPIGRAPHIC LETTER ARCHAIC M
	{0xA800, 0xA801, prAL, gcLo},     //     [2] SYLOTI NAGRI LETTER A..SYLOTI NAGRI LETTER I
	{0xA802, 0xA802, prCM, gcMn},     //         SYLOTI NAGRI SIGN DVISVARA
	{0xA803, 0xA805, prAL, gcLo},     //     [3] SYLOTI NAGRI LETTER U..SYLOTI NAGRI LETTER O
	{0xA806, 0xA806, prCM, gcMn},     //         SYLOTI NAGRI SIGN HASANTA
	{0xA807, 0xA80A, prAL, gcLo},     //     [4] SYLOTI NAGRI LETTER KO..SYLOTI NAGRI LETTER GHO
	{0xA80B, 0xA80B, prCM, gcMn},     //         SYLOTI NAGRI SIGN ANUSVARA
	{0xA80C, 0xA822, prAL, gcLo},     //    [23] SYLOTI NAGRI LETTER CO..SYLOTI NAGRI LETTER HO
	{0xA823, 0xA824, prCM, gcMc},     //     [2] SYLOTI NAGRI VOWEL SIGN A..SYLOTI NAGRI VOWEL SIGN I
	{0xA825, 0xA826, prCM, gcMn},     //     [2] SYLOTI NAGRI VOWEL SIGN U..SYLOTI NAGRI VOWEL SIGN E
	{0xA827, 0xA827, prCM, gcMc},     //         SYLOTI NAGRI VOWEL SIGN OO
	{0xA828, 0xA82B, prAL, gcSo},     //     [4] SYLOTI NAGRI POETRY MARK-1..SYLOTI NAGRI POETRY MARK-4
	{0xA82C, 0xA82C, prCM, gcMn},     //         SYLOTI NAGRI SIGN ALTERNATE HASANTA
	{0xA830, 0xA835, prAL, gcNo},     //     [6] NORTH INDIC FRACTION ONE QUARTER..NORTH INDIC FRACTION THREE SIXTEENTHS
	{0xA836, 0xA837, prAL, gcSo},     //     [2] NORTH INDIC QUARTER MARK..NORTH INDIC PLACEHOLDER MARK
	{0xA838, 0xA838, prPO, gcSc},     //         NORTH INDIC RUPEE MARK
	{0xA839, 0xA839, prAL, gcSo},     //         NORTH INDIC QUANTITY MARK
	{0xA840, 0xA873, prAL, gcLo},     //    [52] PHAGS-PA LETTER KA..PHAGS-PA LETTER CANDRABINDU
	{0xA874, 0xA875, prBB, gcPo},     //     [2] PHAGS-PA SINGLE HEAD MARK..PHAGS-PA DOUBLE HEAD MARK
	{0xA876, 0xA877, prEX, gcPo},     //     [2] PHAGS-PA MARK SHAD..PHAGS-PA MARK DOUBLE SHAD
	{0xA880, 0xA881, prCM, gcMc},     //     [2] SAURASHTRA SIGN ANUSVARA..SAURASHTRA SIGN VISARGA
	{0xA882, 0xA8B3, prAL, gcLo},     //    [50] SAURASHTRA LETTER A..SAURASHTRA LETTER LLA
	{0xA8B4, 0xA8C3, prCM, gcMc},     //    [16] SAURASHTRA CONSONANT SIGN HAARU..SAURASHTRA VOWEL SIGN AU
	{0xA8C4, 0xA8C5, prCM, gcMn},     //     [2] SAURASHTRA SIGN VIRAMA..SAURASHTRA SIGN CANDRABINDU
	{0xA8CE, 0xA8CF, prBA, gcPo},     //     [2] SAURASHTRA DANDA..SAURASHTRA DOUBLE DANDA
	{0xA8D0, 0xA8D9, prNU, gcNd},     //    [10] SAURASHTRA DIGIT ZERO..SAURASHTRA DIGIT NINE
	{0xA8E0, 0xA8F1, prCM, gcMn},     //    [18] COMBINING DEVANAGARI DIGIT ZERO..COMBINING DEVANAGARI SIGN AVAGRAHA
	{0xA8F2, 0xA8F7, prAL, gcLo},     //     [6] DEVANAGARI SIGN SPACING CANDRABINDU..DEVANAGARI SIGN CANDRABINDU AVAGRAHA
	{0xA8F8, 0xA8FA, prAL, gcPo},     //     [3] DEVANAGARI SIGN PUSHPIKA..DEVANAGARI CARET
	{0xA8FB, 0xA8FB, prAL, gcLo},     //         DEVANAGARI HEADSTROKE
	{0xA8FC, 0xA8FC, prBB, gcPo},     //         DEVANAGARI SIGN SIDDHAM
	{0xA8FD, 0xA8FE, prAL, gcLo},     //     [2] DEVANAGARI JAIN OM..DEVANAGARI LETTER AY
	{0xA8FF, 0xA8FF, prCM, gcMn},     //         DEVANAGARI VOWEL SIGN AY
	{0xA900, 0xA909, prNU, gcNd},     //    [10] KAYAH LI DIGIT ZERO..KAYAH LI DIGIT NINE
	{0xA90A, 0xA925, prAL, gcLo},     //    [28] KAYAH LI LETTER KA..KAYAH LI LETTER OO
	{0xA926, 0xA92D, prCM, gcMn},     //     [8] KAYAH LI VOWEL UE..KAYAH LI TONE CALYA PLOPHU
	{0xA92E, 0xA92F, prBA, gcPo},     //     [2] KAYAH LI SIGN CWI..KAYAH LI SIGN SHYA
	{0xA930, 0xA946, prAL, gcLo},     //    [23] REJANG LETTER KA..REJANG LETTER A
	{0xA947, 0xA951, prCM, gcMn},     //    [11] REJANG VOWEL SIGN I..REJANG CONSONANT SIGN R
	{0xA952, 0xA953, prCM, gcMc},     //     [2] REJANG CONSONANT SIGN H..REJANG VIRAMA
	{0xA95F, 0xA95F, prAL, gcPo},     //         REJANG SECTION MARK
	{0xA960, 0xA97C, prJL, gcLo},     //    [29] HANGUL CHOSEONG TIKEUT-MIEUM..HANGUL CHOSEONG SSANGYEORINHIEUH
	{0xA980, 0xA982, prCM, gcMn},     //     [3] JAVANESE SIGN PANYANGGA..JAVANESE SIGN LAYAR
	{0xA983, 0xA983, prCM, gcMc},     //         JAVANESE SIGN WIGNYAN
	{0xA984, 0xA9B2, prAL, gcLo},     //    [47] JAVANESE LETTER A..JAVANESE LETTER HA
	{0xA9B3, 0xA9B3, prCM, gcMn},     //         JAVANESE SIGN CECAK TELU
	{0xA9B4, 0xA9B5, prCM, gcMc},     //     [2] JAVANESE VOWEL SIGN TARUNG..JAVANESE VOWEL SIGN TOLONG
	{0xA9B6, 0xA9B9, prCM, gcMn},     //     [4] JAVANESE VOWEL SIGN WULU..JAVANESE VOWEL SIGN SUKU MENDUT
	{0xA9BA, 0xA9BB, prCM, gcMc},     //     [2] JAVANESE VOWEL SIGN TALING..JAVANESE VOWEL SIGN DIRGA MURE
	{0xA9BC, 0xA9BD, prCM, gcMn},     //     [2] JAVANESE VOWEL SIGN PEPET..JAVANESE CONSONANT SIGN KERET
	{0xA9BE, 0xA9C0, prCM, gcMc},     //     [3] JAVANESE CONSONANT SIGN PENGKAL..JAVANESE PANGKON
	{0xA9C1, 0xA9C6, prAL, gcPo},     //     [6] JAVANESE LEFT RERENGGAN..JAVANESE PADA WINDU
	{0xA9C7, 0xA9C9, prBA, gcPo},     //     [3] JAVANESE PADA PANGKAT..JAVANESE PADA LUNGSI
	{0xA9CA, 0xA9CD, prAL, gcPo},     //     [4] JAVANESE PADA ADEG..JAVANESE TURNED PADA PISELEH
	{0xA9CF, 0xA9CF, prAL, gcLm},     //         JAVANESE PANGRANGKEP
	{0xA9D0, 0xA9D9, prNU, gcNd},     //    [10] JAVANESE DIGIT ZERO..JAVANESE DIGIT NINE
	{0xA9DE, 0xA9DF, prAL, gcPo},     //     [2] JAVANESE PADA TIRTA TUMETES..JAVANESE PADA ISEN-ISEN
	{0xA9E0, 0xA9E4, prSA, gcLo},     //     [5] MYANMAR LETTER SHAN GHA..MYANMAR LETTER SHAN BHA
	{0xA9E5, 0xA9E5, prSA, gcMn},     //         MYANMAR SIGN SHAN SAW
	{0xA9E6, 0xA9E6, prSA, gcLm},     //         MYANMAR MODIFIER LETTER SHAN REDUPLICATION
	{0xA9E7, 0xA9EF, prSA, gcLo},     //     [9] MYANMAR LETTER TAI LAING NYA..MYANMAR LETTER TAI LAING NNA
	{0xA9F0, 0xA9F9, prNU, gcNd},     //    [10] MYANMAR TAI LAING DIGIT ZERO..MYANMAR TAI LAING DIGIT NINE
	{0xA9FA, 0xA9FE, prSA, gcLo},     //     [5] MYANMAR LETTER TAI LAING LLA..MYANMAR LETTER TAI LAING BHA
	{0xAA00, 0xAA28, prAL, gcLo},     //    [41] CHAM LETTER A..CHAM LETTER HA
	{0xAA29, 0xAA2E, prCM, gcMn},     //     [6] CHAM VOWEL SIGN AA..CHAM VOWEL SIGN OE
	{0xAA2F, 0xAA30, prCM, gcMc},     //     [2] CHAM VOWEL SIGN O..CHAM VOWEL SIGN AI
	{0xAA31, 0xAA32, prCM, gcMn},     //     [2] CHAM VOWEL SIGN AU..CHAM VOWEL SIGN UE
	{0xAA33, 0xAA34, prCM, gcMc},     //     [2] CHAM CONSONANT SIGN YA..CHAM CONSONANT SIGN RA
	{0xAA35, 0xAA36, prCM, gcMn},     //     [2] CHAM CONSONANT SIGN LA..CHAM CONSONANT SIGN WA
	{0xAA40, 0xAA42, prAL, gcLo},     //     [3] CHAM LETTER FINAL K..CHAM LETTER FINAL NG
	{0xAA43, 0xAA43, prCM, gcMn},     //         CHAM CONSONANT SIGN FINAL NG
	{0xAA44, 0xAA4B, prAL, gcLo},     //     [8] CHAM LETTER FINAL CH..CHAM LETTER FINAL SS
	{0xAA4C, 0xAA4C, prCM, gcMn},     //         CHAM CONSONANT SIGN FINAL M
	{0xAA4D, 0xAA4D, prCM, gcMc},     //         CHAM CONSONANT SIGN FINAL H
	{0xAA50, 0xAA59, prNU, gcNd},     //    [10] CHAM DIGIT ZERO..CHAM DIGIT NINE
	{0xAA5C, 0xAA5C, prAL, gcPo},     //         CHAM PUNCTUATION SPIRAL
	{0xAA5D, 0xAA5F, prBA, gcPo},     //     [3] CHAM PUNCTUATION DANDA..CHAM PUNCTUATION TRIPLE DANDA
	{0xAA60, 0xAA6F, prSA, gcLo},     //    [16] MYANMAR LETTER KHAMTI GA..MYANMAR LETTER KHAMTI FA
	{0xAA70, 0xAA70, prSA, gcLm},     //         MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION
	{0xAA71, 0xAA76, prSA, gcLo},     //     [6] MYANMAR LETTER KHAMTI XA..MYANMAR LOGOGRAM KHAMTI HM
	{0xAA77, 0xAA79, prSA, gcSo},     //     [3] MYANMAR SYMBOL AITON EXCLAMATION..MYANMAR SYMBOL AITON TWO
	{0xAA7A, 0xAA7A, prSA, gcLo},     //         MYANMAR LETTER AITON RA
	{0xAA7B, 0xAA7B, prSA, gcMc},     //         MYANMAR SIGN PAO KAREN TONE
	{0xAA7C, 0xAA7C, prSA, gcMn},     //         MYANMAR SIGN TAI LAING TONE-2
	{0xAA7D, 0xAA7D, prSA, gcMc},     //         MYANMAR SIGN TAI LAING TONE-5
	{0xAA7E, 0xAA7F, prSA, gcLo},     //     [2] MYANMAR LETTER SHWE PALAUNG CHA..MYANMAR LETTER SHWE PALAUNG SHA
	{0xAA80, 0xAAAF, prSA, gcLo},     //    [48] TAI VIET LETTER LOW KO..TAI VIET LETTER HIGH O
	{0xAAB0, 0xAAB0, prSA, gcMn},     //         TAI VIET MAI KANG
	{0xAAB1, 0xAAB1, prSA, gcLo},     //         TAI VIET VOWEL AA
	{0xAAB2, 0xAAB4, prSA, gcMn},     //     [3] TAI VIET VOWEL I..TAI VIET VOWEL U
	{0xAAB5, 0xAAB6, prSA, gcLo},     //     [2] TAI VIET VOWEL E..TAI VIET VOWEL O
	{0xAAB7, 0xAAB8, prSA, gcMn},     //     [2] TAI VIET MAI KHIT..TAI VIET VOWEL IA
	{0xAAB9, 0xAABD, prSA, gcLo},     //     [5] TAI VIET VOWEL UEA..TAI VIET VOWEL AN
	{0xAABE, 0xAABF, prSA, gcMn},     //     [2] TAI VIET VOWEL AM..TAI VIET TONE MAI EK
	{0xAAC0, 0xAAC0, prSA, gcLo},     //         TAI VIET TONE MAI NUENG
	{0xAAC1, 0xAAC1, prSA, gcMn},     //         TAI VIET TONE MAI THO
	{0xAAC2, 0xAAC2, prSA, gcLo},     //         TAI VIET TONE MAI SONG
	{0xAADB, 0xAADC, prSA, gcLo},     //     [2] TAI VIET SYMBOL KON..TAI VIET SYMBOL NUENG
	{0xAADD, 0xAADD, prSA, gcLm},     //         TAI VIET SYMBOL SAM
	{0xAADE, 0xAADF, prSA, gcPo},     //     [2] TAI VIET SYMBOL HO HOI..TAI VIET SYMBOL KOI KOI
	{0xAAE0, 0xAAEA, prAL, gcLo},     //    [11] MEETEI MAYEK LETTER E..MEETEI MAYEK LETTER SSA
	{0xAAEB, 0xAAEB, prCM, gcMc},     //         MEETEI MAYEK VOWEL SIGN II
	{0xAAEC, 0xAAED, prCM, gcMn},     //     [2] MEETEI MAYEK VOWEL SIGN UU..MEETEI MAYEK VOWEL SIGN AAI
	{0xAAEE, 0xAAEF, prCM, gcMc},     //     [2] MEETEI MAYEK VOWEL SIGN AU..MEETEI MAYEK VOWEL SIGN AAU
	{0xAAF0, 0xAAF1, prBA, gcPo},     //     [2] MEETEI MAYEK CHEIKHAN..MEETEI MAYEK AHANG KHUDAM
	{0xAAF2, 0xAAF2, prAL, gcLo},     //         MEETEI MAYEK ANJI
	{0xAAF3, 0xAAF4, prAL, gcLm},     //     [2] MEETEI MAYEK SYLLABLE REPETITION MARK..MEETEI MAYEK WORD REPETITION MARK
	{0xAAF5, 0xAAF5, prCM, gcMc},     //         MEETEI MAYEK VOWEL SIGN VISARGA
	{0xAAF6, 0xAAF6, prCM, gcMn},     //         MEETEI MAYEK VIRAMA
	{0xAB01, 0xAB06, prAL, gcLo},     //     [6] ETHIOPIC SYLLABLE TTHU..ETHIOPIC SYLLABLE TTHO
	{0xAB09, 0xAB0E, prAL, gcLo},     //     [6] ETHIOPIC SYLLABLE DDHU..ETHIOPIC SYLLABLE DDHO
	{0xAB11, 0xAB16, prAL, gcLo},     //     [6] ETHIOPIC SYLLABLE DZU..ETHIOPIC SYLLABLE DZO
	{0xAB20, 0xAB26, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE CCHHA..ETHIOPIC SYLLABLE CCHHO
	{0xAB28, 0xAB2E, prAL, gcLo},     //     [7] ETHIOPIC SYLLABLE BBA..ETHIOPIC SYLLABLE BBO
	{0xAB30, 0xAB5A, prAL, gcLl},     //    [43] LATIN SMALL LETTER BARRED ALPHA..LATIN SMALL LETTER Y WITH SHORT RIGHT LEG
	{0xAB5B, 0xAB5B, prAL, gcSk},     //         MODIFIER BREVE WITH INVERTED BREVE
	{0xAB5C, 0xAB5F, prAL, gcLm},     //     [4] MODIFIER LETTER SMALL HENG..MODIFIER LETTER SMALL U WITH LEFT HOOK
	{0xAB60, 0xAB68, prAL, gcLl},     //     [9] LATIN SMALL LETTER SAKHA YAT..LATIN SMALL LETTER TURNED R WITH MIDDLE TILDE
	{0xAB69, 0xAB69, prAL, gcLm},     //         MODIFIER LETTER SMALL TURNED W
	{0xAB6A, 0xAB6B, prAL, gcSk},     //     [2] MODIFIER LETTER LEFT TACK..MODIFIER LETTER RIGHT TACK
	{0xAB70, 0xABBF, prAL, gcLl},     //    [80] CHEROKEE SMALL LETTER A..CHEROKEE SMALL LETTER YA
	{0xABC0, 0xABE2, prAL, gcLo},     //    [35] MEETEI MAYEK LETTER KOK..MEETEI MAYEK LETTER I LONSUM
	{0xABE3, 0xABE4, prCM, gcMc},     //     [2] MEETEI MAYEK VOWEL SIGN ONAP..MEETEI MAYEK VOWEL SIGN INAP
	{0xABE5, 0xABE5, prCM, gcMn},     //         MEETEI MAYEK VOWEL SIGN ANAP
	{0xABE6, 0xABE7, prCM, gcMc},     //     [2] MEETEI MAYEK VOWEL SIGN YENAP..MEETEI MAYEK VOWEL SIGN SOUNAP
	{0xABE8, 0xABE8, prCM, gcMn},     //         MEETEI MAYEK VOWEL SIGN UNAP
	{0xABE9, 0xABEA, prCM, gcMc},     //     [2] MEETEI MAYEK VOWEL SIGN CHEINAP..MEETEI MAYEK VOWEL SIGN NUNG
	{0xABEB, 0xABEB, prBA, gcPo},     //         MEETEI MAYEK CHEIKHEI
	{0xABEC, 0xABEC, prCM, gcMc},     //         MEETEI MAYEK LUM IYEK
	{0xABED, 0xABED, prCM, gcMn},     //         MEETEI MAYEK APUN IYEK
	{0xABF0, 0xABF9, prNU, gcNd},     //    [10] MEETEI MAYEK DIGIT ZERO..MEETEI MAYEK DIGIT NINE
	{0xAC00, 0xAC00, prH2, gcLo},     //         HANGUL SYLLABLE GA
	{0xAC01, 0xAC1B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GAG..HANGUL SYLLABLE GAH
	{0xAC1C, 0xAC1C, prH2, gcLo},     //         HANGUL SYLLABLE GAE
	{0xAC1D, 0xAC37, prH3, gcLo},     //    [27] HANGUL SYLLABLE GAEG..HANGUL SYLLABLE GAEH
	{0xAC38, 0xAC38, prH2, gcLo},     //         HANGUL SYLLABLE GYA
	{0xAC39, 0xAC53, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYAG..HANGUL SYLLABLE GYAH
	{0xAC54, 0xAC54, prH2, gcLo},     //         HANGUL SYLLABLE GYAE
	{0xAC55, 0xAC6F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYAEG..HANGUL SYLLABLE GYAEH
	{0xAC70, 0xAC70, prH2, gcLo},     //         HANGUL SYLLABLE GEO
	{0xAC71, 0xAC8B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GEOG..HANGUL SYLLABLE GEOH
	{0xAC8C, 0xAC8C, prH2, gcLo},     //         HANGUL SYLLABLE GE
	{0xAC8D, 0xACA7, prH3, gcLo},     //    [27] HANGUL SYLLABLE GEG..HANGUL SYLLABLE GEH
	{0xACA8, 0xACA8, prH2, gcLo},     //         HANGUL SYLLABLE GYEO
	{0xACA9, 0xACC3, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYEOG..HANGUL SYLLABLE GYEOH
	{0xACC4, 0xACC4, prH2, gcLo},     //         HANGUL SYLLABLE GYE
	{0xACC5, 0xACDF, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYEG..HANGUL SYLLABLE GYEH
	{0xACE0, 0xACE0, prH2, gcLo},     //         HANGUL SYLLABLE GO
	{0xACE1, 0xACFB, prH3, gcLo},     //    [27] HANGUL SYLLABLE GOG..HANGUL SYLLABLE GOH
	{0xACFC, 0xACFC, prH2, gcLo},     //         HANGUL SYLLABLE GWA
	{0xACFD, 0xAD17, prH3, gcLo},     //    [27] HANGUL SYLLABLE GWAG..HANGUL SYLLABLE GWAH
	{0xAD18, 0xAD18, prH2, gcLo},     //         HANGUL SYLLABLE GWAE
	{0xAD19, 0xAD33, prH3, gcLo},     //    [27] HANGUL SYLLABLE GWAEG..HANGUL SYLLABLE GWAEH
	{0xAD34, 0xAD34, prH2, gcLo},     //         HANGUL SYLLABLE GOE
	{0xAD35, 0xAD4F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GOEG..HANGUL SYLLABLE GOEH
	{0xAD50, 0xAD50, prH2, gcLo},     //         HANGUL SYLLABLE GYO
	{0xAD51, 0xAD6B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYOG..HANGUL SYLLABLE GYOH
	{0xAD6C, 0xAD6C, prH2, gcLo},     //         HANGUL SYLLABLE GU
	{0xAD6D, 0xAD87, prH3, gcLo},     //    [27] HANGUL SYLLABLE GUG..HANGUL SYLLABLE GUH
	{0xAD88, 0xAD88, prH2, gcLo},     //         HANGUL SYLLABLE GWEO
	{0xAD89, 0xADA3, prH3, gcLo},     //    [27] HANGUL SYLLABLE GWEOG..HANGUL SYLLABLE GWEOH
	{0xADA4, 0xADA4, prH2, gcLo},     //         HANGUL SYLLABLE GWE
	{0xADA5, 0xADBF, prH3, gcLo},     //    [27] HANGUL SYLLABLE GWEG..HANGUL SYLLABLE GWEH
	{0xADC0, 0xADC0, prH2, gcLo},     //         HANGUL SYLLABLE GWI
	{0xADC1, 0xADDB, prH3, gcLo},     //    [27] HANGUL SYLLABLE GWIG..HANGUL SYLLABLE GWIH
	{0xADDC, 0xADDC, prH2, gcLo},     //         HANGUL SYLLABLE GYU
	{0xADDD, 0xADF7, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYUG..HANGUL SYLLABLE GYUH
	{0xADF8, 0xADF8, prH2, gcLo},     //         HANGUL SYLLABLE GEU
	{0xADF9, 0xAE13, prH3, gcLo},     //    [27] HANGUL SYLLABLE GEUG..HANGUL SYLLABLE GEUH
	{0xAE14, 0xAE14, prH2, gcLo},     //         HANGUL SYLLABLE GYI
	{0xAE15, 0xAE2F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GYIG..HANGUL SYLLABLE GYIH
	{0xAE30, 0xAE30, prH2, gcLo},     //         HANGUL SYLLABLE GI
	{0xAE31, 0xAE4B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GIG..HANGUL SYLLABLE GIH
	{0xAE4C, 0xAE4C, prH2, gcLo},     //         HANGUL SYLLABLE GGA
	{0xAE4D, 0xAE67, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGAG..HANGUL SYLLABLE GGAH
	{0xAE68, 0xAE68, prH2, gcLo},     //         HANGUL SYLLABLE GGAE
	{0xAE69, 0xAE83, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGAEG..HANGUL SYLLABLE GGAEH
	{0xAE84, 0xAE84, prH2, gcLo},     //         HANGUL SYLLABLE GGYA
	{0xAE85, 0xAE9F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYAG..HANGUL SYLLABLE GGYAH
	{0xAEA0, 0xAEA0, prH2, gcLo},     //         HANGUL SYLLABLE GGYAE
	{0xAEA1, 0xAEBB, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYAEG..HANGUL SYLLABLE GGYAEH
	{0xAEBC, 0xAEBC, prH2, gcLo},     //         HANGUL SYLLABLE GGEO
	{0xAEBD, 0xAED7, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGEOG..HANGUL SYLLABLE GGEOH
	{0xAED8, 0xAED8, prH2, gcLo},     //         HANGUL SYLLABLE GGE
	{0xAED9, 0xAEF3, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGEG..HANGUL SYLLABLE GGEH
	{0xAEF4, 0xAEF4, prH2, gcLo},     //         HANGUL SYLLABLE GGYEO
	{0xAEF5, 0xAF0F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYEOG..HANGUL SYLLABLE GGYEOH
	{0xAF10, 0xAF10, prH2, gcLo},     //         HANGUL SYLLABLE GGYE
	{0xAF11, 0xAF2B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYEG..HANGUL SYLLABLE GGYEH
	{0xAF2C, 0xAF2C, prH2, gcLo},     //         HANGUL SYLLABLE GGO
	{0xAF2D, 0xAF47, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGOG..HANGUL SYLLABLE GGOH
	{0xAF48, 0xAF48, prH2, gcLo},     //         HANGUL SYLLABLE GGWA
	{0xAF49, 0xAF63, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGWAG..HANGUL SYLLABLE GGWAH
	{0xAF64, 0xAF64, prH2, gcLo},     //         HANGUL SYLLABLE GGWAE
	{0xAF65, 0xAF7F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGWAEG..HANGUL SYLLABLE GGWAEH
	{0xAF80, 0xAF80, prH2, gcLo},     //         HANGUL SYLLABLE GGOE
	{0xAF81, 0xAF9B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGOEG..HANGUL SYLLABLE GGOEH
	{0xAF9C, 0xAF9C, prH2, gcLo},     //         HANGUL SYLLABLE GGYO
	{0xAF9D, 0xAFB7, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYOG..HANGUL SYLLABLE GGYOH
	{0xAFB8, 0xAFB8, prH2, gcLo},     //         HANGUL SYLLABLE GGU
	{0xAFB9, 0xAFD3, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGUG..HANGUL SYLLABLE GGUH
	{0xAFD4, 0xAFD4, prH2, gcLo},     //         HANGUL SYLLABLE GGWEO
	{0xAFD5, 0xAFEF, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGWEOG..HANGUL SYLLABLE GGWEOH
	{0xAFF0, 0xAFF0, prH2, gcLo},     //         HANGUL SYLLABLE GGWE
	{0xAFF1, 0xB00B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGWEG..HANGUL SYLLABLE GGWEH
	{0xB00C, 0xB00C, prH2, gcLo},     //         HANGUL SYLLABLE GGWI
	{0xB00D, 0xB027, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGWIG..HANGUL SYLLABLE GGWIH
	{0xB028, 0xB028, prH2, gcLo},     //         HANGUL SYLLABLE GGYU
	{0xB029, 0xB043, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYUG..HANGUL SYLLABLE GGYUH
	{0xB044, 0xB044, prH2, gcLo},     //         HANGUL SYLLABLE GGEU
	{0xB045, 0xB05F, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGEUG..HANGUL SYLLABLE GGEUH
	{0xB060, 0xB060, prH2, gcLo},     //         HANGUL SYLLABLE GGYI
	{0xB061, 0xB07B, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGYIG..HANGUL SYLLABLE GGYIH
	{0xB07C, 0xB07C, prH2, gcLo},     //         HANGUL SYLLABLE GGI
	{0xB07D, 0xB097, prH3, gcLo},     //    [27] HANGUL SYLLABLE GGIG..HANGUL SYLLABLE GGIH
	{0xB098, 0xB098, prH2, gcLo},     //         HANGUL SYLLABLE NA
	{0xB099, 0xB0B3, prH3, gcLo},     //    [27] HANGUL SYLLABLE NAG..HANGUL SYLLABLE NAH
	{0xB0B4, 0xB0B4, prH2, gcLo},     //         HANGUL SYLLABLE NAE
	{0xB0B5, 0xB0CF, prH3, gcLo},     //    [27] HANGUL SYLLABLE NAEG..HANGUL SYLLABLE NAEH
	{0xB0D0, 0xB0D0, prH2, gcLo},     //         HANGUL SYLLABLE NYA
	{0xB0D1, 0xB0EB, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYAG..HANGUL SYLLABLE NYAH
	{0xB0EC, 0xB0EC, prH2, gcLo},     //         HANGUL SYLLABLE NYAE
	{0xB0ED, 0xB107, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYAEG..HANGUL SYLLABLE NYAEH
	{0xB108, 0xB108, prH2, gcLo},     //         HANGUL SYLLABLE NEO
	{0xB109, 0xB123, prH3, gcLo},     //    [27] HANGUL SYLLABLE NEOG..HANGUL SYLLABLE NEOH
	{0xB124, 0xB124, prH2, gcLo},     //         HANGUL SYLLABLE NE
	{0xB125, 0xB13F, prH3, gcLo},     //    [27] HANGUL SYLLABLE NEG..HANGUL SYLLABLE NEH
	{0xB140, 0xB140, prH2, gcLo},     //         HANGUL SYLLABLE NYEO
	{0xB141, 0xB15B, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYEOG..HANGUL SYLLABLE NYEOH
	{0xB15C, 0xB15C, prH2, gcLo},     //         HANGUL SYLLABLE NYE
	{0xB15D, 0xB177, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYEG..HANGUL SYLLABLE NYEH
	{0xB178, 0xB178, prH2, gcLo},     //         HANGUL SYLLABLE NO
	{0xB179, 0xB193, prH3, gcLo},     //    [27] HANGUL SYLLABLE NOG..HANGUL SYLLABLE NOH
	{0xB194, 0xB194, prH2, gcLo},     //         HANGUL SYLLABLE NWA
	{0xB195, 0xB1AF, prH3, gcLo},     //    [27] HANGUL SYLLABLE NWAG..HANGUL SYLLABLE NWAH
	{0xB1B0, 0xB1B0, prH2, gcLo},     //         HANGUL SYLLABLE NWAE
	{0xB1B1, 0xB1CB, prH3, gcLo},     //    [27] HANGUL SYLLABLE NWAEG..HANGUL SYLLABLE NWAEH
	{0xB1CC, 0xB1CC, prH2, gcLo},     //         HANGUL SYLLABLE NOE
	{0xB1CD, 0xB1E7, prH3, gcLo},     //    [27] HANGUL SYLLABLE NOEG..HANGUL SYLLABLE NOEH
	{0xB1E8, 0xB1E8, prH2, gcLo},     //         HANGUL SYLLABLE NYO
	{0xB1E9, 0xB203, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYOG..HANGUL SYLLABLE NYOH
	{0xB204, 0xB204, prH2, gcLo},     //         HANGUL SYLLABLE NU
	{0xB205, 0xB21F, prH3, gcLo},     //    [27] HANGUL SYLLABLE NUG..HANGUL SYLLABLE NUH
	{0xB220, 0xB220, prH2, gcLo},     //         HANGUL SYLLABLE NWEO
	{0xB221, 0xB23B, prH3, gcLo},     //    [27] HANGUL SYLLABLE NWEOG..HANGUL SYLLABLE NWEOH
	{0xB23C, 0xB23C, prH2, gcLo},     //         HANGUL SYLLABLE NWE
	{0xB23D, 0xB257, prH3, gcLo},     //    [27] HANGUL SYLLABLE NWEG..HANGUL SYLLABLE NWEH
	{0xB258, 0xB258, prH2, gcLo},     //         HANGUL SYLLABLE NWI
	{0xB259, 0xB273, prH3, gcLo},     //    [27] HANGUL SYLLABLE NWIG..HANGUL SYLLABLE NWIH
	{0xB274, 0xB274, prH2, gcLo},     //         HANGUL SYLLABLE NYU
	{0xB275, 0xB28F, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYUG..HANGUL SYLLABLE NYUH
	{0xB290, 0xB290, prH2, gcLo},     //         HANGUL SYLLABLE NEU
	{0xB291, 0xB2AB, prH3, gcLo},     //    [27] HANGUL SYLLABLE NEUG..HANGUL SYLLABLE NEUH
	{0xB2AC, 0xB2AC, prH2, gcLo},     //         HANGUL SYLLABLE NYI
	{0xB2AD, 0xB2C7, prH3, gcLo},     //    [27] HANGUL SYLLABLE NYIG..HANGUL SYLLABLE NYIH
	{0xB2C8, 0xB2C8, prH2, gcLo},     //         HANGUL SYLLABLE NI
	{0xB2C9, 0xB2E3, prH3, gcLo},     //    [27] HANGUL SYLLABLE NIG..HANGUL SYLLABLE NIH
	{0xB2E4, 0xB2E4, prH2, gcLo},     //         HANGUL SYLLABLE DA
	{0xB2E5, 0xB2FF, prH3, gcLo},     //    [27] HANGUL SYLLABLE DAG..HANGUL SYLLABLE DAH
	{0xB300, 0xB300, prH2, gcLo},     //         HANGUL SYLLABLE DAE
	{0xB301, 0xB31B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DAEG..HANGUL SYLLABLE DAEH
	{0xB31C, 0xB31C, prH2, gcLo},     //         HANGUL SYLLABLE DYA
	{0xB31D, 0xB337, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYAG..HANGUL SYLLABLE DYAH
	{0xB338, 0xB338, prH2, gcLo},     //         HANGUL SYLLABLE DYAE
	{0xB339, 0xB353, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYAEG..HANGUL SYLLABLE DYAEH
	{0xB354, 0xB354, prH2, gcLo},     //         HANGUL SYLLABLE DEO
	{0xB355, 0xB36F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DEOG..HANGUL SYLLABLE DEOH
	{0xB370, 0xB370, prH2, gcLo},     //         HANGUL SYLLABLE DE
	{0xB371, 0xB38B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DEG..HANGUL SYLLABLE DEH
	{0xB38C, 0xB38C, prH2, gcLo},     //         HANGUL SYLLABLE DYEO
	{0xB38D, 0xB3A7, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYEOG..HANGUL SYLLABLE DYEOH
	{0xB3A8, 0xB3A8, prH2, gcLo},     //         HANGUL SYLLABLE DYE
	{0xB3A9, 0xB3C3, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYEG..HANGUL SYLLABLE DYEH
	{0xB3C4, 0xB3C4, prH2, gcLo},     //         HANGUL SYLLABLE DO
	{0xB3C5, 0xB3DF, prH3, gcLo},     //    [27] HANGUL SYLLABLE DOG..HANGUL SYLLABLE DOH
	{0xB3E0, 0xB3E0, prH2, gcLo},     //         HANGUL SYLLABLE DWA
	{0xB3E1, 0xB3FB, prH3, gcLo},     //    [27] HANGUL SYLLABLE DWAG..HANGUL SYLLABLE DWAH
	{0xB3FC, 0xB3FC, prH2, gcLo},     //         HANGUL SYLLABLE DWAE
	{0xB3FD, 0xB417, prH3, gcLo},     //    [27] HANGUL SYLLABLE DWAEG..HANGUL SYLLABLE DWAEH
	{0xB418, 0xB418, prH2, gcLo},     //         HANGUL SYLLABLE DOE
	{0xB419, 0xB433, prH3, gcLo},     //    [27] HANGUL SYLLABLE DOEG..HANGUL SYLLABLE DOEH
	{0xB434, 0xB434, prH2, gcLo},     //         HANGUL SYLLABLE DYO
	{0xB435, 0xB44F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYOG..HANGUL SYLLABLE DYOH
	{0xB450, 0xB450, prH2, gcLo},     //         HANGUL SYLLABLE DU
	{0xB451, 0xB46B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DUG..HANGUL SYLLABLE DUH
	{0xB46C, 0xB46C, prH2, gcLo},     //         HANGUL SYLLABLE DWEO
	{0xB46D, 0xB487, prH3, gcLo},     //    [27] HANGUL SYLLABLE DWEOG..HANGUL SYLLABLE DWEOH
	{0xB488, 0xB488, prH2, gcLo},     //         HANGUL SYLLABLE DWE
	{0xB489, 0xB4A3, prH3, gcLo},     //    [27] HANGUL SYLLABLE DWEG..HANGUL SYLLABLE DWEH
	{0xB4A4, 0xB4A4, prH2, gcLo},     //         HANGUL SYLLABLE DWI
	{0xB4A5, 0xB4BF, prH3, gcLo},     //    [27] HANGUL SYLLABLE DWIG..HANGUL SYLLABLE DWIH
	{0xB4C0, 0xB4C0, prH2, gcLo},     //         HANGUL SYLLABLE DYU
	{0xB4C1, 0xB4DB, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYUG..HANGUL SYLLABLE DYUH
	{0xB4DC, 0xB4DC, prH2, gcLo},     //         HANGUL SYLLABLE DEU
	{0xB4DD, 0xB4F7, prH3, gcLo},     //    [27] HANGUL SYLLABLE DEUG..HANGUL SYLLABLE DEUH
	{0xB4F8, 0xB4F8, prH2, gcLo},     //         HANGUL SYLLABLE DYI
	{0xB4F9, 0xB513, prH3, gcLo},     //    [27] HANGUL SYLLABLE DYIG..HANGUL SYLLABLE DYIH
	{0xB514, 0xB514, prH2, gcLo},     //         HANGUL SYLLABLE DI
	{0xB515, 0xB52F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DIG..HANGUL SYLLABLE DIH
	{0xB530, 0xB530, prH2, gcLo},     //         HANGUL SYLLABLE DDA
	{0xB531, 0xB54B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDAG..HANGUL SYLLABLE DDAH
	{0xB54C, 0xB54C, prH2, gcLo},     //         HANGUL SYLLABLE DDAE
	{0xB54D, 0xB567, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDAEG..HANGUL SYLLABLE DDAEH
	{0xB568, 0xB568, prH2, gcLo},     //         HANGUL SYLLABLE DDYA
	{0xB569, 0xB583, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYAG..HANGUL SYLLABLE DDYAH
	{0xB584, 0xB584, prH2, gcLo},     //         HANGUL SYLLABLE DDYAE
	{0xB585, 0xB59F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYAEG..HANGUL SYLLABLE DDYAEH
	{0xB5A0, 0xB5A0, prH2, gcLo},     //         HANGUL SYLLABLE DDEO
	{0xB5A1, 0xB5BB, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDEOG..HANGUL SYLLABLE DDEOH
	{0xB5BC, 0xB5BC, prH2, gcLo},     //         HANGUL SYLLABLE DDE
	{0xB5BD, 0xB5D7, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDEG..HANGUL SYLLABLE DDEH
	{0xB5D8, 0xB5D8, prH2, gcLo},     //         HANGUL SYLLABLE DDYEO
	{0xB5D9, 0xB5F3, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYEOG..HANGUL SYLLABLE DDYEOH
	{0xB5F4, 0xB5F4, prH2, gcLo},     //         HANGUL SYLLABLE DDYE
	{0xB5F5, 0xB60F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYEG..HANGUL SYLLABLE DDYEH
	{0xB610, 0xB610, prH2, gcLo},     //         HANGUL SYLLABLE DDO
	{0xB611, 0xB62B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDOG..HANGUL SYLLABLE DDOH
	{0xB62C, 0xB62C, prH2, gcLo},     //         HANGUL SYLLABLE DDWA
	{0xB62D, 0xB647, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDWAG..HANGUL SYLLABLE DDWAH
	{0xB648, 0xB648, prH2, gcLo},     //         HANGUL SYLLABLE DDWAE
	{0xB649, 0xB663, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDWAEG..HANGUL SYLLABLE DDWAEH
	{0xB664, 0xB664, prH2, gcLo},     //         HANGUL SYLLABLE DDOE
	{0xB665, 0xB67F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDOEG..HANGUL SYLLABLE DDOEH
	{0xB680, 0xB680, prH2, gcLo},     //         HANGUL SYLLABLE DDYO
	{0xB681, 0xB69B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYOG..HANGUL SYLLABLE DDYOH
	{0xB69C, 0xB69C, prH2, gcLo},     //         HANGUL SYLLABLE DDU
	{0xB69D, 0xB6B7, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDUG..HANGUL SYLLABLE DDUH
	{0xB6B8, 0xB6B8, prH2, gcLo},     //         HANGUL SYLLABLE DDWEO
	{0xB6B9, 0xB6D3, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDWEOG..HANGUL SYLLABLE DDWEOH
	{0xB6D4, 0xB6D4, prH2, gcLo},     //         HANGUL SYLLABLE DDWE
	{0xB6D5, 0xB6EF, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDWEG..HANGUL SYLLABLE DDWEH
	{0xB6F0, 0xB6F0, prH2, gcLo},     //         HANGUL SYLLABLE DDWI
	{0xB6F1, 0xB70B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDWIG..HANGUL SYLLABLE DDWIH
	{0xB70C, 0xB70C, prH2, gcLo},     //         HANGUL SYLLABLE DDYU
	{0xB70D, 0xB727, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYUG..HANGUL SYLLABLE DDYUH
	{0xB728, 0xB728, prH2, gcLo},     //         HANGUL SYLLABLE DDEU
	{0xB729, 0xB743, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDEUG..HANGUL SYLLABLE DDEUH
	{0xB744, 0xB744, prH2, gcLo},     //         HANGUL SYLLABLE DDYI
	{0xB745, 0xB75F, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDYIG..HANGUL SYLLABLE DDYIH
	{0xB760, 0xB760, prH2, gcLo},     //         HANGUL SYLLABLE DDI
	{0xB761, 0xB77B, prH3, gcLo},     //    [27] HANGUL SYLLABLE DDIG..HANGUL SYLLABLE DDIH
	{0xB77C, 0xB77C, prH2, gcLo},     //         HANGUL SYLLABLE RA
	{0xB77D, 0xB797, prH3, gcLo},     //    [27] HANGUL SYLLABLE RAG..HANGUL SYLLABLE RAH
	{0xB798, 0xB798, prH2, gcLo},     //         HANGUL SYLLABLE RAE
	{0xB799, 0xB7B3, prH3, gcLo},     //    [27] HANGUL SYLLABLE RAEG..HANGUL SYLLABLE RAEH
	{0xB7B4, 0xB7B4, prH2, gcLo},     //         HANGUL SYLLABLE RYA
	{0xB7B5, 0xB7CF, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYAG..HANGUL SYLLABLE RYAH
	{0xB7D0, 0xB7D0, prH2, gcLo},     //         HANGUL SYLLABLE RYAE
	{0xB7D1, 0xB7EB, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYAEG..HANGUL SYLLABLE RYAEH
	{0xB7EC, 0xB7EC, prH2, gcLo},     //         HANGUL SYLLABLE REO
	{0xB7ED, 0xB807, prH3, gcLo},     //    [27] HANGUL SYLLABLE REOG..HANGUL SYLLABLE REOH
	{0xB808, 0xB808, prH2, gcLo},     //         HANGUL SYLLABLE RE
	{0xB809, 0xB823, prH3, gcLo},     //    [27] HANGUL SYLLABLE REG..HANGUL SYLLABLE REH
	{0xB824, 0xB824, prH2, gcLo},     //         HANGUL SYLLABLE RYEO
	{0xB825, 0xB83F, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYEOG..HANGUL SYLLABLE RYEOH
	{0xB840, 0xB840, prH2, gcLo},     //         HANGUL SYLLABLE RYE
	{0xB841, 0xB85B, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYEG..HANGUL SYLLABLE RYEH
	{0xB85C, 0xB85C, prH2, gcLo},     //         HANGUL SYLLABLE RO
	{0xB85D, 0xB877, prH3, gcLo},     //    [27] HANGUL SYLLABLE ROG..HANGUL SYLLABLE ROH
	{0xB878, 0xB878, prH2, gcLo},     //         HANGUL SYLLABLE RWA
	{0xB879, 0xB893, prH3, gcLo},     //    [27] HANGUL SYLLABLE RWAG..HANGUL SYLLABLE RWAH
	{0xB894, 0xB894, prH2, gcLo},     //         HANGUL SYLLABLE RWAE
	{0xB895, 0xB8AF, prH3, gcLo},     //    [27] HANGUL SYLLABLE RWAEG..HANGUL SYLLABLE RWAEH
	{0xB8B0, 0xB8B0, prH2, gcLo},     //         HANGUL SYLLABLE ROE
	{0xB8B1, 0xB8CB, prH3, gcLo},     //    [27] HANGUL SYLLABLE ROEG..HANGUL SYLLABLE ROEH
	{0xB8CC, 0xB8CC, prH2, gcLo},     //         HANGUL SYLLABLE RYO
	{0xB8CD, 0xB8E7, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYOG..HANGUL SYLLABLE RYOH
	{0xB8E8, 0xB8E8, prH2, gcLo},     //         HANGUL SYLLABLE RU
	{0xB8E9, 0xB903, prH3, gcLo},     //    [27] HANGUL SYLLABLE RUG..HANGUL SYLLABLE RUH
	{0xB904, 0xB904, prH2, gcLo},     //         HANGUL SYLLABLE RWEO
	{0xB905, 0xB91F, prH3, gcLo},     //    [27] HANGUL SYLLABLE RWEOG..HANGUL SYLLABLE RWEOH
	{0xB920, 0xB920, prH2, gcLo},     //         HANGUL SYLLABLE RWE
	{0xB921, 0xB93B, prH3, gcLo},     //    [27] HANGUL SYLLABLE RWEG..HANGUL SYLLABLE RWEH
	{0xB93C, 0xB93C, prH2, gcLo},     //         HANGUL SYLLABLE RWI
	{0xB93D, 0xB957, prH3, gcLo},     //    [27] HANGUL SYLLABLE RWIG..HANGUL SYLLABLE RWIH
	{0xB958, 0xB958, prH2, gcLo},     //         HANGUL SYLLABLE RYU
	{0xB959, 0xB973, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYUG..HANGUL SYLLABLE RYUH
	{0xB974, 0xB974, prH2, gcLo},     //         HANGUL SYLLABLE REU
	{0xB975, 0xB98F, prH3, gcLo},     //    [27] HANGUL SYLLABLE REUG..HANGUL SYLLABLE REUH
	{0xB990, 0xB990, prH2, gcLo},     //         HANGUL SYLLABLE RYI
	{0xB991, 0xB9AB, prH3, gcLo},     //    [27] HANGUL SYLLABLE RYIG..HANGUL SYLLABLE RYIH
	{0xB9AC, 0xB9AC, prH2, gcLo},     //         HANGUL SYLLABLE RI
	{0xB9AD, 0xB9C7, prH3, gcLo},     //    [27] HANGUL SYLLABLE RIG..HANGUL SYLLABLE RIH
	{0xB9C8, 0xB9C8, prH2, gcLo},     //         HANGUL SYLLABLE MA
	{0xB9C9, 0xB9E3, prH3, gcLo},     //    [27] HANGUL SYLLABLE MAG..HANGUL SYLLABLE MAH
	{0xB9E4, 0xB9E4, prH2, gcLo},     //         HANGUL SYLLABLE MAE
	{0xB9E5, 0xB9FF, prH3, gcLo},     //    [27] HANGUL SYLLABLE MAEG..HANGUL SYLLABLE MAEH
	{0xBA00, 0xBA00, prH2, gcLo},     //         HANGUL SYLLABLE MYA
	{0xBA01, 0xBA1B, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYAG..HANGUL SYLLABLE MYAH
	{0xBA1C, 0xBA1C, prH2, gcLo},     //         HANGUL SYLLABLE MYAE
	{0xBA1D, 0xBA37, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYAEG..HANGUL SYLLABLE MYAEH
	{0xBA38, 0xBA38, prH2, gcLo},     //         HANGUL SYLLABLE MEO
	{0xBA39, 0xBA53, prH3, gcLo},     //    [27] HANGUL SYLLABLE MEOG..HANGUL SYLLABLE MEOH
	{0xBA54, 0xBA54, prH2, gcLo},     //         HANGUL SYLLABLE ME
	{0xBA55, 0xBA6F, prH3, gcLo},     //    [27] HANGUL SYLLABLE MEG..HANGUL SYLLABLE MEH
	{0xBA70, 0xBA70, prH2, gcLo},     //         HANGUL SYLLABLE MYEO
	{0xBA71, 0xBA8B, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYEOG..HANGUL SYLLABLE MYEOH
	{0xBA8C, 0xBA8C, prH2, gcLo},     //         HANGUL SYLLABLE MYE
	{0xBA8D, 0xBAA7, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYEG..HANGUL SYLLABLE MYEH
	{0xBAA8, 0xBAA8, prH2, gcLo},     //         HANGUL SYLLABLE MO
	{0xBAA9, 0xBAC3, prH3, gcLo},     //    [27] HANGUL SYLLABLE MOG..HANGUL SYLLABLE MOH
	{0xBAC4, 0xBAC4, prH2, gcLo},     //         HANGUL SYLLABLE MWA
	{0xBAC5, 0xBADF, prH3, gcLo},     //    [27] HANGUL SYLLABLE MWAG..HANGUL SYLLABLE MWAH
	{0xBAE0, 0xBAE0, prH2, gcLo},     //         HANGUL SYLLABLE MWAE
	{0xBAE1, 0xBAFB, prH3, gcLo},     //    [27] HANGUL SYLLABLE MWAEG..HANGUL SYLLABLE MWAEH
	{0xBAFC, 0xBAFC, prH2, gcLo},     //         HANGUL SYLLABLE MOE
	{0xBAFD, 0xBB17, prH3, gcLo},     //    [27] HANGUL SYLLABLE MOEG..HANGUL SYLLABLE MOEH
	{0xBB18, 0xBB18, prH2, gcLo},     //         HANGUL SYLLABLE MYO
	{0xBB19, 0xBB33, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYOG..HANGUL SYLLABLE MYOH
	{0xBB34, 0xBB34, prH2, gcLo},     //         HANGUL SYLLABLE MU
	{0xBB35, 0xBB4F, prH3, gcLo},     //    [27] HANGUL SYLLABLE MUG..HANGUL SYLLABLE MUH
	{0xBB50, 0xBB50, prH2, gcLo},     //         HANGUL SYLLABLE MWEO
	{0xBB51, 0xBB6B, prH3, gcLo},     //    [27] HANGUL SYLLABLE MWEOG..HANGUL SYLLABLE MWEOH
	{0xBB6C, 0xBB6C, prH2, gcLo},     //         HANGUL SYLLABLE MWE
	{0xBB6D, 0xBB87, prH3, gcLo},     //    [27] HANGUL SYLLABLE MWEG..HANGUL SYLLABLE MWEH
	{0xBB88, 0xBB88, prH2, gcLo},     //         HANGUL SYLLABLE MWI
	{0xBB89, 0xBBA3, prH3, gcLo},     //    [27] HANGUL SYLLABLE MWIG..HANGUL SYLLABLE MWIH
	{0xBBA4, 0xBBA4, prH2, gcLo},     //         HANGUL SYLLABLE MYU
	{0xBBA5, 0xBBBF, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYUG..HANGUL SYLLABLE MYUH
	{0xBBC0, 0xBBC0, prH2, gcLo},     //         HANGUL SYLLABLE MEU
	{0xBBC1, 0xBBDB, prH3, gcLo},     //    [27] HANGUL SYLLABLE MEUG..HANGUL SYLLABLE MEUH
	{0xBBDC, 0xBBDC, prH2, gcLo},     //         HANGUL SYLLABLE MYI
	{0xBBDD, 0xBBF7, prH3, gcLo},     //    [27] HANGUL SYLLABLE MYIG..HANGUL SYLLABLE MYIH
	{0xBBF8, 0xBBF8, prH2, gcLo},     //         HANGUL SYLLABLE MI
	{0xBBF9, 0xBC13, prH3, gcLo},     //    [27] HANGUL SYLLABLE MIG..HANGUL SYLLABLE MIH
	{0xBC14, 0xBC14, prH2, gcLo},     //         HANGUL SYLLABLE BA
	{0xBC15, 0xBC2F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BAG..HANGUL SYLLABLE BAH
	{0xBC30, 0xBC30, prH2, gcLo},     //         HANGUL SYLLABLE BAE
	{0xBC31, 0xBC4B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BAEG..HANGUL SYLLABLE BAEH
	{0xBC4C, 0xBC4C, prH2, gcLo},     //         HANGUL SYLLABLE BYA
	{0xBC4D, 0xBC67, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYAG..HANGUL SYLLABLE BYAH
	{0xBC68, 0xBC68, prH2, gcLo},     //         HANGUL SYLLABLE BYAE
	{0xBC69, 0xBC83, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYAEG..HANGUL SYLLABLE BYAEH
	{0xBC84, 0xBC84, prH2, gcLo},     //         HANGUL SYLLABLE BEO
	{0xBC85, 0xBC9F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BEOG..HANGUL SYLLABLE BEOH
	{0xBCA0, 0xBCA0, prH2, gcLo},     //         HANGUL SYLLABLE BE
	{0xBCA1, 0xBCBB, prH3, gcLo},     //    [27] HANGUL SYLLABLE BEG..HANGUL SYLLABLE BEH
	{0xBCBC, 0xBCBC, prH2, gcLo},     //         HANGUL SYLLABLE BYEO
	{0xBCBD, 0xBCD7, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYEOG..HANGUL SYLLABLE BYEOH
	{0xBCD8, 0xBCD8, prH2, gcLo},     //         HANGUL SYLLABLE BYE
	{0xBCD9, 0xBCF3, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYEG..HANGUL SYLLABLE BYEH
	{0xBCF4, 0xBCF4, prH2, gcLo},     //         HANGUL SYLLABLE BO
	{0xBCF5, 0xBD0F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BOG..HANGUL SYLLABLE BOH
	{0xBD10, 0xBD10, prH2, gcLo},     //         HANGUL SYLLABLE BWA
	{0xBD11, 0xBD2B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BWAG..HANGUL SYLLABLE BWAH
	{0xBD2C, 0xBD2C, prH2, gcLo},     //         HANGUL SYLLABLE BWAE
	{0xBD2D, 0xBD47, prH3, gcLo},     //    [27] HANGUL SYLLABLE BWAEG..HANGUL SYLLABLE BWAEH
	{0xBD48, 0xBD48, prH2, gcLo},     //         HANGUL SYLLABLE BOE
	{0xBD49, 0xBD63, prH3, gcLo},     //    [27] HANGUL SYLLABLE BOEG..HANGUL SYLLABLE BOEH
	{0xBD64, 0xBD64, prH2, gcLo},     //         HANGUL SYLLABLE BYO
	{0xBD65, 0xBD7F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYOG..HANGUL SYLLABLE BYOH
	{0xBD80, 0xBD80, prH2, gcLo},     //         HANGUL SYLLABLE BU
	{0xBD81, 0xBD9B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BUG..HANGUL SYLLABLE BUH
	{0xBD9C, 0xBD9C, prH2, gcLo},     //         HANGUL SYLLABLE BWEO
	{0xBD9D, 0xBDB7, prH3, gcLo},     //    [27] HANGUL SYLLABLE BWEOG..HANGUL SYLLABLE BWEOH
	{0xBDB8, 0xBDB8, prH2, gcLo},     //         HANGUL SYLLABLE BWE
	{0xBDB9, 0xBDD3, prH3, gcLo},     //    [27] HANGUL SYLLABLE BWEG..HANGUL SYLLABLE BWEH
	{0xBDD4, 0xBDD4, prH2, gcLo},     //         HANGUL SYLLABLE BWI
	{0xBDD5, 0xBDEF, prH3, gcLo},     //    [27] HANGUL SYLLABLE BWIG..HANGUL SYLLABLE BWIH
	{0xBDF0, 0xBDF0, prH2, gcLo},     //         HANGUL SYLLABLE BYU
	{0xBDF1, 0xBE0B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYUG..HANGUL SYLLABLE BYUH
	{0xBE0C, 0xBE0C, prH2, gcLo},     //         HANGUL SYLLABLE BEU
	{0xBE0D, 0xBE27, prH3, gcLo},     //    [27] HANGUL SYLLABLE BEUG..HANGUL SYLLABLE BEUH
	{0xBE28, 0xBE28, prH2, gcLo},     //         HANGUL SYLLABLE BYI
	{0xBE29, 0xBE43, prH3, gcLo},     //    [27] HANGUL SYLLABLE BYIG..HANGUL SYLLABLE BYIH
	{0xBE44, 0xBE44, prH2, gcLo},     //         HANGUL SYLLABLE BI
	{0xBE45, 0xBE5F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BIG..HANGUL SYLLABLE BIH
	{0xBE60, 0xBE60, prH2, gcLo},     //         HANGUL SYLLABLE BBA
	{0xBE61, 0xBE7B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBAG..HANGUL SYLLABLE BBAH
	{0xBE7C, 0xBE7C, prH2, gcLo},     //         HANGUL SYLLABLE BBAE
	{0xBE7D, 0xBE97, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBAEG..HANGUL SYLLABLE BBAEH
	{0xBE98, 0xBE98, prH2, gcLo},     //         HANGUL SYLLABLE BBYA
	{0xBE99, 0xBEB3, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYAG..HANGUL SYLLABLE BBYAH
	{0xBEB4, 0xBEB4, prH2, gcLo},     //         HANGUL SYLLABLE BBYAE
	{0xBEB5, 0xBECF, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYAEG..HANGUL SYLLABLE BBYAEH
	{0xBED0, 0xBED0, prH2, gcLo},     //         HANGUL SYLLABLE BBEO
	{0xBED1, 0xBEEB, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBEOG..HANGUL SYLLABLE BBEOH
	{0xBEEC, 0xBEEC, prH2, gcLo},     //         HANGUL SYLLABLE BBE
	{0xBEED, 0xBF07, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBEG..HANGUL SYLLABLE BBEH
	{0xBF08, 0xBF08, prH2, gcLo},     //         HANGUL SYLLABLE BBYEO
	{0xBF09, 0xBF23, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYEOG..HANGUL SYLLABLE BBYEOH
	{0xBF24, 0xBF24, prH2, gcLo},     //         HANGUL SYLLABLE BBYE
	{0xBF25, 0xBF3F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYEG..HANGUL SYLLABLE BBYEH
	{0xBF40, 0xBF40, prH2, gcLo},     //         HANGUL SYLLABLE BBO
	{0xBF41, 0xBF5B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBOG..HANGUL SYLLABLE BBOH
	{0xBF5C, 0xBF5C, prH2, gcLo},     //         HANGUL SYLLABLE BBWA
	{0xBF5D, 0xBF77, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBWAG..HANGUL SYLLABLE BBWAH
	{0xBF78, 0xBF78, prH2, gcLo},     //         HANGUL SYLLABLE BBWAE
	{0xBF79, 0xBF93, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBWAEG..HANGUL SYLLABLE BBWAEH
	{0xBF94, 0xBF94, prH2, gcLo},     //         HANGUL SYLLABLE BBOE
	{0xBF95, 0xBFAF, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBOEG..HANGUL SYLLABLE BBOEH
	{0xBFB0, 0xBFB0, prH2, gcLo},     //         HANGUL SYLLABLE BBYO
	{0xBFB1, 0xBFCB, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYOG..HANGUL SYLLABLE BBYOH
	{0xBFCC, 0xBFCC, prH2, gcLo},     //         HANGUL SYLLABLE BBU
	{0xBFCD, 0xBFE7, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBUG..HANGUL SYLLABLE BBUH
	{0xBFE8, 0xBFE8, prH2, gcLo},     //         HANGUL SYLLABLE BBWEO
	{0xBFE9, 0xC003, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBWEOG..HANGUL SYLLABLE BBWEOH
	{0xC004, 0xC004, prH2, gcLo},     //         HANGUL SYLLABLE BBWE
	{0xC005, 0xC01F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBWEG..HANGUL SYLLABLE BBWEH
	{0xC020, 0xC020, prH2, gcLo},     //         HANGUL SYLLABLE BBWI
	{0xC021, 0xC03B, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBWIG..HANGUL SYLLABLE BBWIH
	{0xC03C, 0xC03C, prH2, gcLo},     //         HANGUL SYLLABLE BBYU
	{0xC03D, 0xC057, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYUG..HANGUL SYLLABLE BBYUH
	{0xC058, 0xC058, prH2, gcLo},     //         HANGUL SYLLABLE BBEU
	{0xC059, 0xC073, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBEUG..HANGUL SYLLABLE BBEUH
	{0xC074, 0xC074, prH2, gcLo},     //         HANGUL SYLLABLE BBYI
	{0xC075, 0xC08F, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBYIG..HANGUL SYLLABLE BBYIH
	{0xC090, 0xC090, prH2, gcLo},     //         HANGUL SYLLABLE BBI
	{0xC091, 0xC0AB, prH3, gcLo},     //    [27] HANGUL SYLLABLE BBIG..HANGUL SYLLABLE BBIH
	{0xC0AC, 0xC0AC, prH2, gcLo},     //         HANGUL SYLLABLE SA
	{0xC0AD, 0xC0C7, prH3, gcLo},     //    [27] HANGUL SYLLABLE SAG..HANGUL SYLLABLE SAH
	{0xC0C8, 0xC0C8, prH2, gcLo},     //         HANGUL SYLLABLE SAE
	{0xC0C9, 0xC0E3, prH3, gcLo},     //    [27] HANGUL SYLLABLE SAEG..HANGUL SYLLABLE SAEH
	{0xC0E4, 0xC0E4, prH2, gcLo},     //         HANGUL SYLLABLE SYA
	{0xC0E5, 0xC0FF, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYAG..HANGUL SYLLABLE SYAH
	{0xC100, 0xC100, prH2, gcLo},     //         HANGUL SYLLABLE SYAE
	{0xC101, 0xC11B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYAEG..HANGUL SYLLABLE SYAEH
	{0xC11C, 0xC11C, prH2, gcLo},     //         HANGUL SYLLABLE SEO
	{0xC11D, 0xC137, prH3, gcLo},     //    [27] HANGUL SYLLABLE SEOG..HANGUL SYLLABLE SEOH
	{0xC138, 0xC138, prH2, gcLo},     //         HANGUL SYLLABLE SE
	{0xC139, 0xC153, prH3, gcLo},     //    [27] HANGUL SYLLABLE SEG..HANGUL SYLLABLE SEH
	{0xC154, 0xC154, prH2, gcLo},     //         HANGUL SYLLABLE SYEO
	{0xC155, 0xC16F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYEOG..HANGUL SYLLABLE SYEOH
	{0xC170, 0xC170, prH2, gcLo},     //         HANGUL SYLLABLE SYE
	{0xC171, 0xC18B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYEG..HANGUL SYLLABLE SYEH
	{0xC18C, 0xC18C, prH2, gcLo},     //         HANGUL SYLLABLE SO
	{0xC18D, 0xC1A7, prH3, gcLo},     //    [27] HANGUL SYLLABLE SOG..HANGUL SYLLABLE SOH
	{0xC1A8, 0xC1A8, prH2, gcLo},     //         HANGUL SYLLABLE SWA
	{0xC1A9, 0xC1C3, prH3, gcLo},     //    [27] HANGUL SYLLABLE SWAG..HANGUL SYLLABLE SWAH
	{0xC1C4, 0xC1C4, prH2, gcLo},     //         HANGUL SYLLABLE SWAE
	{0xC1C5, 0xC1DF, prH3, gcLo},     //    [27] HANGUL SYLLABLE SWAEG..HANGUL SYLLABLE SWAEH
	{0xC1E0, 0xC1E0, prH2, gcLo},     //         HANGUL SYLLABLE SOE
	{0xC1E1, 0xC1FB, prH3, gcLo},     //    [27] HANGUL SYLLABLE SOEG..HANGUL SYLLABLE SOEH
	{0xC1FC, 0xC1FC, prH2, gcLo},     //         HANGUL SYLLABLE SYO
	{0xC1FD, 0xC217, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYOG..HANGUL SYLLABLE SYOH
	{0xC218, 0xC218, prH2, gcLo},     //         HANGUL SYLLABLE SU
	{0xC219, 0xC233, prH3, gcLo},     //    [27] HANGUL SYLLABLE SUG..HANGUL SYLLABLE SUH
	{0xC234, 0xC234, prH2, gcLo},     //         HANGUL SYLLABLE SWEO
	{0xC235, 0xC24F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SWEOG..HANGUL SYLLABLE SWEOH
	{0xC250, 0xC250, prH2, gcLo},     //         HANGUL SYLLABLE SWE
	{0xC251, 0xC26B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SWEG..HANGUL SYLLABLE SWEH
	{0xC26C, 0xC26C, prH2, gcLo},     //         HANGUL SYLLABLE SWI
	{0xC26D, 0xC287, prH3, gcLo},     //    [27] HANGUL SYLLABLE SWIG..HANGUL SYLLABLE SWIH
	{0xC288, 0xC288, prH2, gcLo},     //         HANGUL SYLLABLE SYU
	{0xC289, 0xC2A3, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYUG..HANGUL SYLLABLE SYUH
	{0xC2A4, 0xC2A4, prH2, gcLo},     //         HANGUL SYLLABLE SEU
	{0xC2A5, 0xC2BF, prH3, gcLo},     //    [27] HANGUL SYLLABLE SEUG..HANGUL SYLLABLE SEUH
	{0xC2C0, 0xC2C0, prH2, gcLo},     //         HANGUL SYLLABLE SYI
	{0xC2C1, 0xC2DB, prH3, gcLo},     //    [27] HANGUL SYLLABLE SYIG..HANGUL SYLLABLE SYIH
	{0xC2DC, 0xC2DC, prH2, gcLo},     //         HANGUL SYLLABLE SI
	{0xC2DD, 0xC2F7, prH3, gcLo},     //    [27] HANGUL SYLLABLE SIG..HANGUL SYLLABLE SIH
	{0xC2F8, 0xC2F8, prH2, gcLo},     //         HANGUL SYLLABLE SSA
	{0xC2F9, 0xC313, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSAG..HANGUL SYLLABLE SSAH
	{0xC314, 0xC314, prH2, gcLo},     //         HANGUL SYLLABLE SSAE
	{0xC315, 0xC32F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSAEG..HANGUL SYLLABLE SSAEH
	{0xC330, 0xC330, prH2, gcLo},     //         HANGUL SYLLABLE SSYA
	{0xC331, 0xC34B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYAG..HANGUL SYLLABLE SSYAH
	{0xC34C, 0xC34C, prH2, gcLo},     //         HANGUL SYLLABLE SSYAE
	{0xC34D, 0xC367, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYAEG..HANGUL SYLLABLE SSYAEH
	{0xC368, 0xC368, prH2, gcLo},     //         HANGUL SYLLABLE SSEO
	{0xC369, 0xC383, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSEOG..HANGUL SYLLABLE SSEOH
	{0xC384, 0xC384, prH2, gcLo},     //         HANGUL SYLLABLE SSE
	{0xC385, 0xC39F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSEG..HANGUL SYLLABLE SSEH
	{0xC3A0, 0xC3A0, prH2, gcLo},     //         HANGUL SYLLABLE SSYEO
	{0xC3A1, 0xC3BB, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYEOG..HANGUL SYLLABLE SSYEOH
	{0xC3BC, 0xC3BC, prH2, gcLo},     //         HANGUL SYLLABLE SSYE
	{0xC3BD, 0xC3D7, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYEG..HANGUL SYLLABLE SSYEH
	{0xC3D8, 0xC3D8, prH2, gcLo},     //         HANGUL SYLLABLE SSO
	{0xC3D9, 0xC3F3, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSOG..HANGUL SYLLABLE SSOH
	{0xC3F4, 0xC3F4, prH2, gcLo},     //         HANGUL SYLLABLE SSWA
	{0xC3F5, 0xC40F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSWAG..HANGUL SYLLABLE SSWAH
	{0xC410, 0xC410, prH2, gcLo},     //         HANGUL SYLLABLE SSWAE
	{0xC411, 0xC42B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSWAEG..HANGUL SYLLABLE SSWAEH
	{0xC42C, 0xC42C, prH2, gcLo},     //         HANGUL SYLLABLE SSOE
	{0xC42D, 0xC447, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSOEG..HANGUL SYLLABLE SSOEH
	{0xC448, 0xC448, prH2, gcLo},     //         HANGUL SYLLABLE SSYO
	{0xC449, 0xC463, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYOG..HANGUL SYLLABLE SSYOH
	{0xC464, 0xC464, prH2, gcLo},     //         HANGUL SYLLABLE SSU
	{0xC465, 0xC47F, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSUG..HANGUL SYLLABLE SSUH
	{0xC480, 0xC480, prH2, gcLo},     //         HANGUL SYLLABLE SSWEO
	{0xC481, 0xC49B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSWEOG..HANGUL SYLLABLE SSWEOH
	{0xC49C, 0xC49C, prH2, gcLo},     //         HANGUL SYLLABLE SSWE
	{0xC49D, 0xC4B7, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSWEG..HANGUL SYLLABLE SSWEH
	{0xC4B8, 0xC4B8, prH2, gcLo},     //         HANGUL SYLLABLE SSWI
	{0xC4B9, 0xC4D3, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSWIG..HANGUL SYLLABLE SSWIH
	{0xC4D4, 0xC4D4, prH2, gcLo},     //         HANGUL SYLLABLE SSYU
	{0xC4D5, 0xC4EF, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYUG..HANGUL SYLLABLE SSYUH
	{0xC4F0, 0xC4F0, prH2, gcLo},     //         HANGUL SYLLABLE SSEU
	{0xC4F1, 0xC50B, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSEUG..HANGUL SYLLABLE SSEUH
	{0xC50C, 0xC50C, prH2, gcLo},     //         HANGUL SYLLABLE SSYI
	{0xC50D, 0xC527, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSYIG..HANGUL SYLLABLE SSYIH
	{0xC528, 0xC528, prH2, gcLo},     //         HANGUL SYLLABLE SSI
	{0xC529, 0xC543, prH3, gcLo},     //    [27] HANGUL SYLLABLE SSIG..HANGUL SYLLABLE SSIH
	{0xC544, 0xC544, prH2, gcLo},     //         HANGUL SYLLABLE A
	{0xC545, 0xC55F, prH3, gcLo},     //    [27] HANGUL SYLLABLE AG..HANGUL SYLLABLE AH
	{0xC560, 0xC560, prH2, gcLo},     //         HANGUL SYLLABLE AE
	{0xC561, 0xC57B, prH3, gcLo},     //    [27] HANGUL SYLLABLE AEG..HANGUL SYLLABLE AEH
	{0xC57C, 0xC57C, prH2, gcLo},     //         HANGUL SYLLABLE YA
	{0xC57D, 0xC597, prH3, gcLo},     //    [27] HANGUL SYLLABLE YAG..HANGUL SYLLABLE YAH
	{0xC598, 0xC598, prH2, gcLo},     //         HANGUL SYLLABLE YAE
	{0xC599, 0xC5B3, prH3, gcLo},     //    [27] HANGUL SYLLABLE YAEG..HANGUL SYLLABLE YAEH
	{0xC5B4, 0xC5B4, prH2, gcLo},     //         HANGUL SYLLABLE EO
	{0xC5B5, 0xC5CF, prH3, gcLo},     //    [27] HANGUL SYLLABLE EOG..HANGUL SYLLABLE EOH
	{0xC5D0, 0xC5D0, prH2, gcLo},     //         HANGUL SYLLABLE E
	{0xC5D1, 0xC5EB, prH3, gcLo},     //    [27] HANGUL SYLLABLE EG..HANGUL SYLLABLE EH
	{0xC5EC, 0xC5EC, prH2, gcLo},     //         HANGUL SYLLABLE YEO
	{0xC5ED, 0xC607, prH3, gcLo},     //    [27] HANGUL SYLLABLE YEOG..HANGUL SYLLABLE YEOH
	{0xC608, 0xC608, prH2, gcLo},     //         HANGUL SYLLABLE YE
	{0xC609, 0xC623, prH3, gcLo},     //    [27] HANGUL SYLLABLE YEG..HANGUL SYLLABLE YEH
	{0xC624, 0xC624, prH2, gcLo},     //         HANGUL SYLLABLE O
	{0xC625, 0xC63F, prH3, gcLo},     //    [27] HANGUL SYLLABLE OG..HANGUL SYLLABLE OH
	{0xC640, 0xC640, prH2, gcLo},     //         HANGUL SYLLABLE WA
	{0xC641, 0xC65B, prH3, gcLo},     //    [27] HANGUL SYLLABLE WAG..HANGUL SYLLABLE WAH
	{0xC65C, 0xC65C, prH2, gcLo},     //         HANGUL SYLLABLE WAE
	{0xC65D, 0xC677, prH3, gcLo},     //    [27] HANGUL SYLLABLE WAEG..HANGUL SYLLABLE WAEH
	{0xC678, 0xC678, prH2, gcLo},     //         HANGUL SYLLABLE OE
	{0xC679, 0xC693, prH3, gcLo},     //    [27] HANGUL SYLLABLE OEG..HANGUL SYLLABLE OEH
	{0xC694, 0xC694, prH2, gcLo},     //         HANGUL SYLLABLE YO
	{0xC695, 0xC6AF, prH3, gcLo},     //    [27] HANGUL SYLLABLE YOG..HANGUL SYLLABLE YOH
	{0xC6B0, 0xC6B0, prH2, gcLo},     //         HANGUL SYLLABLE U
	{0xC6B1, 0xC6CB, prH3, gcLo},     //    [27] HANGUL SYLLABLE UG..HANGUL SYLLABLE UH
	{0xC6CC, 0xC6CC, prH2, gcLo},     //         HANGUL SYLLABLE WEO
	{0xC6CD, 0xC6E7, prH3, gcLo},     //    [27] HANGUL SYLLABLE WEOG..HANGUL SYLLABLE WEOH
	{0xC6E8, 0xC6E8, prH2, gcLo},     //         HANGUL SYLLABLE WE
	{0xC6E9, 0xC703, prH3, gcLo},     //    [27] HANGUL SYLLABLE WEG..HANGUL SYLLABLE WEH
	{0xC704, 0xC704, prH2, gcLo},     //         HANGUL SYLLABLE WI
	{0xC705, 0xC71F, prH3, gcLo},     //    [27] HANGUL SYLLABLE WIG..HANGUL SYLLABLE WIH
	{0xC720, 0xC720, prH2, gcLo},     //         HANGUL SYLLABLE YU
	{0xC721, 0xC73B, prH3, gcLo},     //    [27] HANGUL SYLLABLE YUG..HANGUL SYLLABLE YUH
	{0xC73C, 0xC73C, prH2, gcLo},     //         HANGUL SYLLABLE EU
	{0xC73D, 0xC757, prH3, gcLo},     //    [27] HANGUL SYLLABLE EUG..HANGUL SYLLABLE EUH
	{0xC758, 0xC758, prH2, gcLo},     //         HANGUL SYLLABLE YI
	{0xC759, 0xC773, prH3, gcLo},     //    [27] HANGUL SYLLABLE YIG..HANGUL SYLLABLE YIH
	{0xC774, 0xC774, prH2, gcLo},     //         HANGUL SYLLABLE I
	{0xC775, 0xC78F, prH3, gcLo},     //    [27] HANGUL SYLLABLE IG..HANGUL SYLLABLE IH
	{0xC790, 0xC790, prH2, gcLo},     //         HANGUL SYLLABLE JA
	{0xC791, 0xC7AB, prH3, gcLo},     //    [27] HANGUL SYLLABLE JAG..HANGUL SYLLABLE JAH
	{0xC7AC, 0xC7AC, prH2, gcLo},     //         HANGUL SYLLABLE JAE
	{0xC7AD, 0xC7C7, prH3, gcLo},     //    [27] HANGUL SYLLABLE JAEG..HANGUL SYLLABLE JAEH
	{0xC7C8, 0xC7C8, prH2, gcLo},     //         HANGUL SYLLABLE JYA
	{0xC7C9, 0xC7E3, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYAG..HANGUL SYLLABLE JYAH
	{0xC7E4, 0xC7E4, prH2, gcLo},     //         HANGUL SYLLABLE JYAE
	{0xC7E5, 0xC7FF, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYAEG..HANGUL SYLLABLE JYAEH
	{0xC800, 0xC800, prH2, gcLo},     //         HANGUL SYLLABLE JEO
	{0xC801, 0xC81B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JEOG..HANGUL SYLLABLE JEOH
	{0xC81C, 0xC81C, prH2, gcLo},     //         HANGUL SYLLABLE JE
	{0xC81D, 0xC837, prH3, gcLo},     //    [27] HANGUL SYLLABLE JEG..HANGUL SYLLABLE JEH
	{0xC838, 0xC838, prH2, gcLo},     //         HANGUL SYLLABLE JYEO
	{0xC839, 0xC853, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYEOG..HANGUL SYLLABLE JYEOH
	{0xC854, 0xC854, prH2, gcLo},     //         HANGUL SYLLABLE JYE
	{0xC855, 0xC86F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYEG..HANGUL SYLLABLE JYEH
	{0xC870, 0xC870, prH2, gcLo},     //         HANGUL SYLLABLE JO
	{0xC871, 0xC88B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JOG..HANGUL SYLLABLE JOH
	{0xC88C, 0xC88C, prH2, gcLo},     //         HANGUL SYLLABLE JWA
	{0xC88D, 0xC8A7, prH3, gcLo},     //    [27] HANGUL SYLLABLE JWAG..HANGUL SYLLABLE JWAH
	{0xC8A8, 0xC8A8, prH2, gcLo},     //         HANGUL SYLLABLE JWAE
	{0xC8A9, 0xC8C3, prH3, gcLo},     //    [27] HANGUL SYLLABLE JWAEG..HANGUL SYLLABLE JWAEH
	{0xC8C4, 0xC8C4, prH2, gcLo},     //         HANGUL SYLLABLE JOE
	{0xC8C5, 0xC8DF, prH3, gcLo},     //    [27] HANGUL SYLLABLE JOEG..HANGUL SYLLABLE JOEH
	{0xC8E0, 0xC8E0, prH2, gcLo},     //         HANGUL SYLLABLE JYO
	{0xC8E1, 0xC8FB, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYOG..HANGUL SYLLABLE JYOH
	{0xC8FC, 0xC8FC, prH2, gcLo},     //         HANGUL SYLLABLE JU
	{0xC8FD, 0xC917, prH3, gcLo},     //    [27] HANGUL SYLLABLE JUG..HANGUL SYLLABLE JUH
	{0xC918, 0xC918, prH2, gcLo},     //         HANGUL SYLLABLE JWEO
	{0xC919, 0xC933, prH3, gcLo},     //    [27] HANGUL SYLLABLE JWEOG..HANGUL SYLLABLE JWEOH
	{0xC934, 0xC934, prH2, gcLo},     //         HANGUL SYLLABLE JWE
	{0xC935, 0xC94F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JWEG..HANGUL SYLLABLE JWEH
	{0xC950, 0xC950, prH2, gcLo},     //         HANGUL SYLLABLE JWI
	{0xC951, 0xC96B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JWIG..HANGUL SYLLABLE JWIH
	{0xC96C, 0xC96C, prH2, gcLo},     //         HANGUL SYLLABLE JYU
	{0xC96D, 0xC987, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYUG..HANGUL SYLLABLE JYUH
	{0xC988, 0xC988, prH2, gcLo},     //         HANGUL SYLLABLE JEU
	{0xC989, 0xC9A3, prH3, gcLo},     //    [27] HANGUL SYLLABLE JEUG..HANGUL SYLLABLE JEUH
	{0xC9A4, 0xC9A4, prH2, gcLo},     //         HANGUL SYLLABLE JYI
	{0xC9A5, 0xC9BF, prH3, gcLo},     //    [27] HANGUL SYLLABLE JYIG..HANGUL SYLLABLE JYIH
	{0xC9C0, 0xC9C0, prH2, gcLo},     //         HANGUL SYLLABLE JI
	{0xC9C1, 0xC9DB, prH3, gcLo},     //    [27] HANGUL SYLLABLE JIG..HANGUL SYLLABLE JIH
	{0xC9DC, 0xC9DC, prH2, gcLo},     //         HANGUL SYLLABLE JJA
	{0xC9DD, 0xC9F7, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJAG..HANGUL SYLLABLE JJAH
	{0xC9F8, 0xC9F8, prH2, gcLo},     //         HANGUL SYLLABLE JJAE
	{0xC9F9, 0xCA13, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJAEG..HANGUL SYLLABLE JJAEH
	{0xCA14, 0xCA14, prH2, gcLo},     //         HANGUL SYLLABLE JJYA
	{0xCA15, 0xCA2F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYAG..HANGUL SYLLABLE JJYAH
	{0xCA30, 0xCA30, prH2, gcLo},     //         HANGUL SYLLABLE JJYAE
	{0xCA31, 0xCA4B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYAEG..HANGUL SYLLABLE JJYAEH
	{0xCA4C, 0xCA4C, prH2, gcLo},     //         HANGUL SYLLABLE JJEO
	{0xCA4D, 0xCA67, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJEOG..HANGUL SYLLABLE JJEOH
	{0xCA68, 0xCA68, prH2, gcLo},     //         HANGUL SYLLABLE JJE
	{0xCA69, 0xCA83, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJEG..HANGUL SYLLABLE JJEH
	{0xCA84, 0xCA84, prH2, gcLo},     //         HANGUL SYLLABLE JJYEO
	{0xCA85, 0xCA9F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYEOG..HANGUL SYLLABLE JJYEOH
	{0xCAA0, 0xCAA0, prH2, gcLo},     //         HANGUL SYLLABLE JJYE
	{0xCAA1, 0xCABB, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYEG..HANGUL SYLLABLE JJYEH
	{0xCABC, 0xCABC, prH2, gcLo},     //         HANGUL SYLLABLE JJO
	{0xCABD, 0xCAD7, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJOG..HANGUL SYLLABLE JJOH
	{0xCAD8, 0xCAD8, prH2, gcLo},     //         HANGUL SYLLABLE JJWA
	{0xCAD9, 0xCAF3, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJWAG..HANGUL SYLLABLE JJWAH
	{0xCAF4, 0xCAF4, prH2, gcLo},     //         HANGUL SYLLABLE JJWAE
	{0xCAF5, 0xCB0F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJWAEG..HANGUL SYLLABLE JJWAEH
	{0xCB10, 0xCB10, prH2, gcLo},     //         HANGUL SYLLABLE JJOE
	{0xCB11, 0xCB2B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJOEG..HANGUL SYLLABLE JJOEH
	{0xCB2C, 0xCB2C, prH2, gcLo},     //         HANGUL SYLLABLE JJYO
	{0xCB2D, 0xCB47, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYOG..HANGUL SYLLABLE JJYOH
	{0xCB48, 0xCB48, prH2, gcLo},     //         HANGUL SYLLABLE JJU
	{0xCB49, 0xCB63, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJUG..HANGUL SYLLABLE JJUH
	{0xCB64, 0xCB64, prH2, gcLo},     //         HANGUL SYLLABLE JJWEO
	{0xCB65, 0xCB7F, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJWEOG..HANGUL SYLLABLE JJWEOH
	{0xCB80, 0xCB80, prH2, gcLo},     //         HANGUL SYLLABLE JJWE
	{0xCB81, 0xCB9B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJWEG..HANGUL SYLLABLE JJWEH
	{0xCB9C, 0xCB9C, prH2, gcLo},     //         HANGUL SYLLABLE JJWI
	{0xCB9D, 0xCBB7, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJWIG..HANGUL SYLLABLE JJWIH
	{0xCBB8, 0xCBB8, prH2, gcLo},     //         HANGUL SYLLABLE JJYU
	{0xCBB9, 0xCBD3, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYUG..HANGUL SYLLABLE JJYUH
	{0xCBD4, 0xCBD4, prH2, gcLo},     //         HANGUL SYLLABLE JJEU
	{0xCBD5, 0xCBEF, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJEUG..HANGUL SYLLABLE JJEUH
	{0xCBF0, 0xCBF0, prH2, gcLo},     //         HANGUL SYLLABLE JJYI
	{0xCBF1, 0xCC0B, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJYIG..HANGUL SYLLABLE JJYIH
	{0xCC0C, 0xCC0C, prH2, gcLo},     //         HANGUL SYLLABLE JJI
	{0xCC0D, 0xCC27, prH3, gcLo},     //    [27] HANGUL SYLLABLE JJIG..HANGUL SYLLABLE JJIH
	{0xCC28, 0xCC28, prH2, gcLo},     //         HANGUL SYLLABLE CA
	{0xCC29, 0xCC43, prH3, gcLo},     //    [27] HANGUL SYLLABLE CAG..HANGUL SYLLABLE CAH
	{0xCC44, 0xCC44, prH2, gcLo},     //         HANGUL SYLLABLE CAE
	{0xCC45, 0xCC5F, prH3, gcLo},     //    [27] HANGUL SYLLABLE CAEG..HANGUL SYLLABLE CAEH
	{0xCC60, 0xCC60, prH2, gcLo},     //         HANGUL SYLLABLE CYA
	{0xCC61, 0xCC7B, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYAG..HANGUL SYLLABLE CYAH
	{0xCC7C, 0xCC7C, prH2, gcLo},     //         HANGUL SYLLABLE CYAE
	{0xCC7D, 0xCC97, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYAEG..HANGUL SYLLABLE CYAEH
	{0xCC98, 0xCC98, prH2, gcLo},     //         HANGUL SYLLABLE CEO
	{0xCC99, 0xCCB3, prH3, gcLo},     //    [27] HANGUL SYLLABLE CEOG..HANGUL SYLLABLE CEOH
	{0xCCB4, 0xCCB4, prH2, gcLo},     //         HANGUL SYLLABLE CE
	{0xCCB5, 0xCCCF, prH3, gcLo},     //    [27] HANGUL SYLLABLE CEG..HANGUL SYLLABLE CEH
	{0xCCD0, 0xCCD0, prH2, gcLo},     //         HANGUL SYLLABLE CYEO
	{0xCCD1, 0xCCEB, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYEOG..HANGUL SYLLABLE CYEOH
	{0xCCEC, 0xCCEC, prH2, gcLo},     //         HANGUL SYLLABLE CYE
	{0xCCED, 0xCD07, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYEG..HANGUL SYLLABLE CYEH
	{0xCD08, 0xCD08, prH2, gcLo},     //         HANGUL SYLLABLE CO
	{0xCD09, 0xCD23, prH3, gcLo},     //    [27] HANGUL SYLLABLE COG..HANGUL SYLLABLE COH
	{0xCD24, 0xCD24, prH2, gcLo},     //         HANGUL SYLLABLE CWA
	{0xCD25, 0xCD3F, prH3, gcLo},     //    [27] HANGUL SYLLABLE CWAG..HANGUL SYLLABLE CWAH
	{0xCD40, 0xCD40, prH2, gcLo},     //         HANGUL SYLLABLE CWAE
	{0xCD41, 0xCD5B, prH3, gcLo},     //    [27] HANGUL SYLLABLE CWAEG..HANGUL SYLLABLE CWAEH
	{0xCD5C, 0xCD5C, prH2, gcLo},     //         HANGUL SYLLABLE COE
	{0xCD5D, 0xCD77, prH3, gcLo},     //    [27] HANGUL SYLLABLE COEG..HANGUL SYLLABLE COEH
	{0xCD78, 0xCD78, prH2, gcLo},     //         HANGUL SYLLABLE CYO
	{0xCD79, 0xCD93, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYOG..HANGUL SYLLABLE CYOH
	{0xCD94, 0xCD94, prH2, gcLo},     //         HANGUL SYLLABLE CU
	{0xCD95, 0xCDAF, prH3, gcLo},     //    [27] HANGUL SYLLABLE CUG..HANGUL SYLLABLE CUH
	{0xCDB0, 0xCDB0, prH2, gcLo},     //         HANGUL SYLLABLE CWEO
	{0xCDB1, 0xCDCB, prH3, gcLo},     //    [27] HANGUL SYLLABLE CWEOG..HANGUL SYLLABLE CWEOH
	{0xCDCC, 0xCDCC, prH2, gcLo},     //         HANGUL SYLLABLE CWE
	{0xCDCD, 0xCDE7, prH3, gcLo},     //    [27] HANGUL SYLLABLE CWEG..HANGUL SYLLABLE CWEH
	{0xCDE8, 0xCDE8, prH2, gcLo},     //         HANGUL SYLLABLE CWI
	{0xCDE9, 0xCE03, prH3, gcLo},     //    [27] HANGUL SYLLABLE CWIG..HANGUL SYLLABLE CWIH
	{0xCE04, 0xCE04, prH2, gcLo},     //         HANGUL SYLLABLE CYU
	{0xCE05, 0xCE1F, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYUG..HANGUL SYLLABLE CYUH
	{0xCE20, 0xCE20, prH2, gcLo},     //         HANGUL SYLLABLE CEU
	{0xCE21, 0xCE3B, prH3, gcLo},     //    [27] HANGUL SYLLABLE CEUG..HANGUL SYLLABLE CEUH
	{0xCE3C, 0xCE3C, prH2, gcLo},     //         HANGUL SYLLABLE CYI
	{0xCE3D, 0xCE57, prH3, gcLo},     //    [27] HANGUL SYLLABLE CYIG..HANGUL SYLLABLE CYIH
	{0xCE58, 0xCE58, prH2, gcLo},     //         HANGUL SYLLABLE CI
	{0xCE59, 0xCE73, prH3, gcLo},     //    [27] HANGUL SYLLABLE CIG..HANGUL SYLLABLE CIH
	{0xCE74, 0xCE74, prH2, gcLo},     //         HANGUL SYLLABLE KA
	{0xCE75, 0xCE8F, prH3, gcLo},     //    [27] HANGUL SYLLABLE KAG..HANGUL SYLLABLE KAH
	{0xCE90, 0xCE90, prH2, gcLo},     //         HANGUL SYLLABLE KAE
	{0xCE91, 0xCEAB, prH3, gcLo},     //    [27] HANGUL SYLLABLE KAEG..HANGUL SYLLABLE KAEH
	{0xCEAC, 0xCEAC, prH2, gcLo},     //         HANGUL SYLLABLE KYA
	{0xCEAD, 0xCEC7, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYAG..HANGUL SYLLABLE KYAH
	{0xCEC8, 0xCEC8, prH2, gcLo},     //         HANGUL SYLLABLE KYAE
	{0xCEC9, 0xCEE3, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYAEG..HANGUL SYLLABLE KYAEH
	{0xCEE4, 0xCEE4, prH2, gcLo},     //         HANGUL SYLLABLE KEO
	{0xCEE5, 0xCEFF, prH3, gcLo},     //    [27] HANGUL SYLLABLE KEOG..HANGUL SYLLABLE KEOH
	{0xCF00, 0xCF00, prH2, gcLo},     //         HANGUL SYLLABLE KE
	{0xCF01, 0xCF1B, prH3, gcLo},     //    [27] HANGUL SYLLABLE KEG..HANGUL SYLLABLE KEH
	{0xCF1C, 0xCF1C, prH2, gcLo},     //         HANGUL SYLLABLE KYEO
	{0xCF1D, 0xCF37, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYEOG..HANGUL SYLLABLE KYEOH
	{0xCF38, 0xCF38, prH2, gcLo},     //         HANGUL SYLLABLE KYE
	{0xCF39, 0xCF53, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYEG..HANGUL SYLLABLE KYEH
	{0xCF54, 0xCF54, prH2, gcLo},     //         HANGUL SYLLABLE KO
	{0xCF55, 0xCF6F, prH3, gcLo},     //    [27] HANGUL SYLLABLE KOG..HANGUL SYLLABLE KOH
	{0xCF70, 0xCF70, prH2, gcLo},     //         HANGUL SYLLABLE KWA
	{0xCF71, 0xCF8B, prH3, gcLo},     //    [27] HANGUL SYLLABLE KWAG..HANGUL SYLLABLE KWAH
	{0xCF8C, 0xCF8C, prH2, gcLo},     //         HANGUL SYLLABLE KWAE
	{0xCF8D, 0xCFA7, prH3, gcLo},     //    [27] HANGUL SYLLABLE KWAEG..HANGUL SYLLABLE KWAEH
	{0xCFA8, 0xCFA8, prH2, gcLo},     //         HANGUL SYLLABLE KOE
	{0xCFA9, 0xCFC3, prH3, gcLo},     //    [27] HANGUL SYLLABLE KOEG..HANGUL SYLLABLE KOEH
	{0xCFC4, 0xCFC4, prH2, gcLo},     //         HANGUL SYLLABLE KYO
	{0xCFC5, 0xCFDF, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYOG..HANGUL SYLLABLE KYOH
	{0xCFE0, 0xCFE0, prH2, gcLo},     //         HANGUL SYLLABLE KU
	{0xCFE1, 0xCFFB, prH3, gcLo},     //    [27] HANGUL SYLLABLE KUG..HANGUL SYLLABLE KUH
	{0xCFFC, 0xCFFC, prH2, gcLo},     //         HANGUL SYLLABLE KWEO
	{0xCFFD, 0xD017, prH3, gcLo},     //    [27] HANGUL SYLLABLE KWEOG..HANGUL SYLLABLE KWEOH
	{0xD018, 0xD018, prH2, gcLo},     //         HANGUL SYLLABLE KWE
	{0xD019, 0xD033, prH3, gcLo},     //    [27] HANGUL SYLLABLE KWEG..HANGUL SYLLABLE KWEH
	{0xD034, 0xD034, prH2, gcLo},     //         HANGUL SYLLABLE KWI
	{0xD035, 0xD04F, prH3, gcLo},     //    [27] HANGUL SYLLABLE KWIG..HANGUL SYLLABLE KWIH
	{0xD050, 0xD050, prH2, gcLo},     //         HANGUL SYLLABLE KYU
	{0xD051, 0xD06B, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYUG..HANGUL SYLLABLE KYUH
	{0xD06C, 0xD06C, prH2, gcLo},     //         HANGUL SYLLABLE KEU
	{0xD06D, 0xD087, prH3, gcLo},     //    [27] HANGUL SYLLABLE KEUG..HANGUL SYLLABLE KEUH
	{0xD088, 0xD088, prH2, gcLo},     //         HANGUL SYLLABLE KYI
	{0xD089, 0xD0A3, prH3, gcLo},     //    [27] HANGUL SYLLABLE KYIG..HANGUL SYLLABLE KYIH
	{0xD0A4, 0xD0A4, prH2, gcLo},     //         HANGUL SYLLABLE KI
	{0xD0A5, 0xD0BF, prH3, gcLo},     //    [27] HANGUL SYLLABLE KIG..HANGUL SYLLABLE KIH
	{0xD0C0, 0xD0C0, prH2, gcLo},     //         HANGUL SYLLABLE TA
	{0xD0C1, 0xD0DB, prH3, gcLo},     //    [27] HANGUL SYLLABLE TAG..HANGUL SYLLABLE TAH
	{0xD0DC, 0xD0DC, prH2, gcLo},     //         HANGUL SYLLABLE TAE
	{0xD0DD, 0xD0F7, prH3, gcLo},     //    [27] HANGUL SYLLABLE TAEG..HANGUL SYLLABLE TAEH
	{0xD0F8, 0xD0F8, prH2, gcLo},     //         HANGUL SYLLABLE TYA
	{0xD0F9, 0xD113, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYAG..HANGUL SYLLABLE TYAH
	{0xD114, 0xD114, prH2, gcLo},     //         HANGUL SYLLABLE TYAE
	{0xD115, 0xD12F, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYAEG..HANGUL SYLLABLE TYAEH
	{0xD130, 0xD130, prH2, gcLo},     //         HANGUL SYLLABLE TEO
	{0xD131, 0xD14B, prH3, gcLo},     //    [27] HANGUL SYLLABLE TEOG..HANGUL SYLLABLE TEOH
	{0xD14C, 0xD14C, prH2, gcLo},     //         HANGUL SYLLABLE TE
	{0xD14D, 0xD167, prH3, gcLo},     //    [27] HANGUL SYLLABLE TEG..HANGUL SYLLABLE TEH
	{0xD168, 0xD168, prH2, gcLo},     //         HANGUL SYLLABLE TYEO
	{0xD169, 0xD183, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYEOG..HANGUL SYLLABLE TYEOH
	{0xD184, 0xD184, prH2, gcLo},     //         HANGUL SYLLABLE TYE
	{0xD185, 0xD19F, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYEG..HANGUL SYLLABLE TYEH
	{0xD1A0, 0xD1A0, prH2, gcLo},     //         HANGUL SYLLABLE TO
	{0xD1A1, 0xD1BB, prH3, gcLo},     //    [27] HANGUL SYLLABLE TOG..HANGUL SYLLABLE TOH
	{0xD1BC, 0xD1BC, prH2, gcLo},     //         HANGUL SYLLABLE TWA
	{0xD1BD, 0xD1D7, prH3, gcLo},     //    [27] HANGUL SYLLABLE TWAG..HANGUL SYLLABLE TWAH
	{0xD1D8, 0xD1D8, prH2, gcLo},     //         HANGUL SYLLABLE TWAE
	{0xD1D9, 0xD1F3, prH3, gcLo},     //    [27] HANGUL SYLLABLE TWAEG..HANGUL SYLLABLE TWAEH
	{0xD1F4, 0xD1F4, prH2, gcLo},     //         HANGUL SYLLABLE TOE
	{0xD1F5, 0xD20F, prH3, gcLo},     //    [27] HANGUL SYLLABLE TOEG..HANGUL SYLLABLE TOEH
	{0xD210, 0xD210, prH2, gcLo},     //         HANGUL SYLLABLE TYO
	{0xD211, 0xD22B, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYOG..HANGUL SYLLABLE TYOH
	{0xD22C, 0xD22C, prH2, gcLo},     //         HANGUL SYLLABLE TU
	{0xD22D, 0xD247, prH3, gcLo},     //    [27] HANGUL SYLLABLE TUG..HANGUL SYLLABLE TUH
	{0xD248, 0xD248, prH2, gcLo},     //         HANGUL SYLLABLE TWEO
	{0xD249, 0xD263, prH3, gcLo},     //    [27] HANGUL SYLLABLE TWEOG..HANGUL SYLLABLE TWEOH
	{0xD264, 0xD264, prH2, gcLo},     //         HANGUL SYLLABLE TWE
	{0xD265, 0xD27F, prH3, gcLo},     //    [27] HANGUL SYLLABLE TWEG..HANGUL SYLLABLE TWEH
	{0xD280, 0xD280, prH2, gcLo},     //         HANGUL SYLLABLE TWI
	{0xD281, 0xD29B, prH3, gcLo},     //    [27] HANGUL SYLLABLE TWIG..HANGUL SYLLABLE TWIH
	{0xD29C, 0xD29C, prH2, gcLo},     //         HANGUL SYLLABLE TYU
	{0xD29D, 0xD2B7, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYUG..HANGUL SYLLABLE TYUH
	{0xD2B8, 0xD2B8, prH2, gcLo},     //         HANGUL SYLLABLE TEU
	{0xD2B9, 0xD2D3, prH3, gcLo},     //    [27] HANGUL SYLLABLE TEUG..HANGUL SYLLABLE TEUH
	{0xD2D4, 0xD2D4, prH2, gcLo},     //         HANGUL SYLLABLE TYI
	{0xD2D5, 0xD2EF, prH3, gcLo},     //    [27] HANGUL SYLLABLE TYIG..HANGUL SYLLABLE TYIH
	{0xD2F0, 0xD2F0, prH2, gcLo},     //         HANGUL SYLLABLE TI
	{0xD2F1, 0xD30B, prH3, gcLo},     //    [27] HANGUL SYLLABLE TIG..HANGUL SYLLABLE TIH
	{0xD30C, 0xD30C, prH2, gcLo},     //         HANGUL SYLLABLE PA
	{0xD30D, 0xD327, prH3, gcLo},     //    [27] HANGUL SYLLABLE PAG..HANGUL SYLLABLE PAH
	{0xD328, 0xD328, prH2, gcLo},     //         HANGUL SYLLABLE PAE
	{0xD329, 0xD343, prH3, gcLo},     //    [27] HANGUL SYLLABLE PAEG..HANGUL SYLLABLE PAEH
	{0xD344, 0xD344, prH2, gcLo},     //         HANGUL SYLLABLE PYA
	{0xD345, 0xD35F, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYAG..HANGUL SYLLABLE PYAH
	{0xD360, 0xD360, prH2, gcLo},     //         HANGUL SYLLABLE PYAE
	{0xD361, 0xD37B, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYAEG..HANGUL SYLLABLE PYAEH
	{0xD37C, 0xD37C, prH2, gcLo},     //         HANGUL SYLLABLE PEO
	{0xD37D, 0xD397, prH3, gcLo},     //    [27] HANGUL SYLLABLE PEOG..HANGUL SYLLABLE PEOH
	{0xD398, 0xD398, prH2, gcLo},     //         HANGUL SYLLABLE PE
	{0xD399, 0xD3B3, prH3, gcLo},     //    [27] HANGUL SYLLABLE PEG..HANGUL SYLLABLE PEH
	{0xD3B4, 0xD3B4, prH2, gcLo},     //         HANGUL SYLLABLE PYEO
	{0xD3B5, 0xD3CF, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYEOG..HANGUL SYLLABLE PYEOH
	{0xD3D0, 0xD3D0, prH2, gcLo},     //         HANGUL SYLLABLE PYE
	{0xD3D1, 0xD3EB, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYEG..HANGUL SYLLABLE PYEH
	{0xD3EC, 0xD3EC, prH2, gcLo},     //         HANGUL SYLLABLE PO
	{0xD3ED, 0xD407, prH3, gcLo},     //    [27] HANGUL SYLLABLE POG..HANGUL SYLLABLE POH
	{0xD408, 0xD408, prH2, gcLo},     //         HANGUL SYLLABLE PWA
	{0xD409, 0xD423, prH3, gcLo},     //    [27] HANGUL SYLLABLE PWAG..HANGUL SYLLABLE PWAH
	{0xD424, 0xD424, prH2, gcLo},     //         HANGUL SYLLABLE PWAE
	{0xD425, 0xD43F, prH3, gcLo},     //    [27] HANGUL SYLLABLE PWAEG..HANGUL SYLLABLE PWAEH
	{0xD440, 0xD440, prH2, gcLo},     //         HANGUL SYLLABLE POE
	{0xD441, 0xD45B, prH3, gcLo},     //    [27] HANGUL SYLLABLE POEG..HANGUL SYLLABLE POEH
	{0xD45C, 0xD45C, prH2, gcLo},     //         HANGUL SYLLABLE PYO
	{0xD45D, 0xD477, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYOG..HANGUL SYLLABLE PYOH
	{0xD478, 0xD478, prH2, gcLo},     //         HANGUL SYLLABLE PU
	{0xD479, 0xD493, prH3, gcLo},     //    [27] HANGUL SYLLABLE PUG..HANGUL SYLLABLE PUH
	{0xD494, 0xD494, prH2, gcLo},     //         HANGUL SYLLABLE PWEO
	{0xD495, 0xD4AF, prH3, gcLo},     //    [27] HANGUL SYLLABLE PWEOG..HANGUL SYLLABLE PWEOH
	{0xD4B0, 0xD4B0, prH2, gcLo},     //         HANGUL SYLLABLE PWE
	{0xD4B1, 0xD4CB, prH3, gcLo},     //    [27] HANGUL SYLLABLE PWEG..HANGUL SYLLABLE PWEH
	{0xD4CC, 0xD4CC, prH2, gcLo},     //         HANGUL SYLLABLE PWI
	{0xD4CD, 0xD4E7, prH3, gcLo},     //    [27] HANGUL SYLLABLE PWIG..HANGUL SYLLABLE PWIH
	{0xD4E8, 0xD4E8, prH2, gcLo},     //         HANGUL SYLLABLE PYU
	{0xD4E9, 0xD503, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYUG..HANGUL SYLLABLE PYUH
	{0xD504, 0xD504, prH2, gcLo},     //         HANGUL SYLLABLE PEU
	{0xD505, 0xD51F, prH3, gcLo},     //    [27] HANGUL SYLLABLE PEUG..HANGUL SYLLABLE PEUH
	{0xD520, 0xD520, prH2, gcLo},     //         HANGUL SYLLABLE PYI
	{0xD521, 0xD53B, prH3, gcLo},     //    [27] HANGUL SYLLABLE PYIG..HANGUL SYLLABLE PYIH
	{0xD53C, 0xD53C, prH2, gcLo},     //         HANGUL SYLLABLE PI
	{0xD53D, 0xD557, prH3, gcLo},     //    [27] HANGUL SYLLABLE PIG..HANGUL SYLLABLE PIH
	{0xD558, 0xD558, prH2, gcLo},     //         HANGUL SYLLABLE HA
	{0xD559, 0xD573, prH3, gcLo},     //    [27] HANGUL SYLLABLE HAG..HANGUL SYLLABLE HAH
	{0xD574, 0xD574, prH2, gcLo},     //         HANGUL SYLLABLE HAE
	{0xD575, 0xD58F, prH3, gcLo},     //    [27] HANGUL SYLLABLE HAEG..HANGUL SYLLABLE HAEH
	{0xD590, 0xD590, prH2, gcLo},     //         HANGUL SYLLABLE HYA
	{0xD591, 0xD5AB, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYAG..HANGUL SYLLABLE HYAH
	{0xD5AC, 0xD5AC, prH2, gcLo},     //         HANGUL SYLLABLE HYAE
	{0xD5AD, 0xD5C7, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYAEG..HANGUL SYLLABLE HYAEH
	{0xD5C8, 0xD5C8, prH2, gcLo},     //         HANGUL SYLLABLE HEO
	{0xD5C9, 0xD5E3, prH3, gcLo},     //    [27] HANGUL SYLLABLE HEOG..HANGUL SYLLABLE HEOH
	{0xD5E4, 0xD5E4, prH2, gcLo},     //         HANGUL SYLLABLE HE
	{0xD5E5, 0xD5FF, prH3, gcLo},     //    [27] HANGUL SYLLABLE HEG..HANGUL SYLLABLE HEH
	{0xD600, 0xD600, prH2, gcLo},     //         HANGUL SYLLABLE HYEO
	{0xD601, 0xD61B, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYEOG..HANGUL SYLLABLE HYEOH
	{0xD61C, 0xD61C, prH2, gcLo},     //         HANGUL SYLLABLE HYE
	{0xD61D, 0xD637, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYEG..HANGUL SYLLABLE HYEH
	{0xD638, 0xD638, prH2, gcLo},     //         HANGUL SYLLABLE HO
	{0xD639, 0xD653, prH3, gcLo},     //    [27] HANGUL SYLLABLE HOG..HANGUL SYLLABLE HOH
	{0xD654, 0xD654, prH2, gcLo},     //         HANGUL SYLLABLE HWA
	{0xD655, 0xD66F, prH3, gcLo},     //    [27] HANGUL SYLLABLE HWAG..HANGUL SYLLABLE HWAH
	{0xD670, 0xD670, prH2, gcLo},     //         HANGUL SYLLABLE HWAE
	{0xD671, 0xD68B, prH3, gcLo},     //    [27] HANGUL SYLLABLE HWAEG..HANGUL SYLLABLE HWAEH
	{0xD68C, 0xD68C, prH2, gcLo},     //         HANGUL SYLLABLE HOE
	{0xD68D, 0xD6A7, prH3, gcLo},     //    [27] HANGUL SYLLABLE HOEG..HANGUL SYLLABLE HOEH
	{0xD6A8, 0xD6A8, prH2, gcLo},     //         HANGUL SYLLABLE HYO
	{0xD6A9, 0xD6C3, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYOG..HANGUL SYLLABLE HYOH
	{0xD6C4, 0xD6C4, prH2, gcLo},     //         HANGUL SYLLABLE HU
	{0xD6C5, 0xD6DF, prH3, gcLo},     //    [27] HANGUL SYLLABLE HUG..HANGUL SYLLABLE HUH
	{0xD6E0, 0xD6E0, prH2, gcLo},     //         HANGUL SYLLABLE HWEO
	{0xD6E1, 0xD6FB, prH3, gcLo},     //    [27] HANGUL SYLLABLE HWEOG..HANGUL SYLLABLE HWEOH
	{0xD6FC, 0xD6FC, prH2, gcLo},     //         HANGUL SYLLABLE HWE
	{0xD6FD, 0xD717, prH3, gcLo},     //    [27] HANGUL SYLLABLE HWEG..HANGUL SYLLABLE HWEH
	{0xD718, 0xD718, prH2, gcLo},     //         HANGUL SYLLABLE HWI
	{0xD719, 0xD733, prH3, gcLo},     //    [27] HANGUL SYLLABLE HWIG..HANGUL SYLLABLE HWIH
	{0xD734, 0xD734, prH2, gcLo},     //         HANGUL SYLLABLE HYU
	{0xD735, 0xD74F, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYUG..HANGUL SYLLABLE HYUH
	{0xD750, 0xD750, prH2, gcLo},     //         HANGUL SYLLABLE HEU
	{0xD751, 0xD76B, prH3, gcLo},     //    [27] HANGUL SYLLABLE HEUG..HANGUL SYLLABLE HEUH
	{0xD76C, 0xD76C, prH2, gcLo},     //         HANGUL SYLLABLE HYI
	{0xD76D, 0xD787, prH3, gcLo},     //    [27] HANGUL SYLLABLE HYIG..HANGUL SYLLABLE HYIH
	{0xD788, 0xD788, prH2, gcLo},     //         HANGUL SYLLABLE HI
	{0xD789, 0xD7A3, prH3, gcLo},     //    [27] HANGUL SYLLABLE HIG..HANGUL SYLLABLE HIH
	{0xD7B0, 0xD7C6, prJV, gcLo},     //    [23] HANGUL JUNGSEONG O-YEO..HANGUL JUNGSEONG ARAEA-E
	{0xD7CB, 0xD7FB, prJT, gcLo},     //    [49] HANGUL JONGSEONG NIEUN-RIEUL..HANGUL JONGSEONG PHIEUPH-THIEUTH
	{0xD800, 0xDB7F, prSG, gcCs},     //   [896] <surrogate-D800>..<surrogate-DB7F>
	{0xDB80, 0xDBFF, prSG, gcCs},     //   [128] <surrogate-DB80>..<surrogate-DBFF>
	{0xDC00, 0xDFFF, prSG, gcCs},     //  [1024] <surrogate-DC00>..<surrogate-DFFF>
	{0xE000, 0xF8FF, prXX, gcCo},     //  [6400] <private-use-E000>..<private-use-F8FF>
	{0xF900, 0xFA6D, prID, gcLo},     //   [366] CJK COMPATIBILITY IDEOGRAPH-F900..CJK COMPATIBILITY IDEOGRAPH-FA6D
	{0xFA6E, 0xFA6F, prID, gcCn},     //     [2] <reserved-FA6E>..<reserved-FA6F>
	{0xFA70, 0xFAD9, prID, gcLo},     //   [106] CJK COMPATIBILITY IDEOGRAPH-FA70..CJK COMPATIBILITY IDEOGRAPH-FAD9
	{0xFADA, 0xFAFF, prID, gcCn},     //    [38] <reserved-FADA>..<reserved-FAFF>
	{0xFB00, 0xFB06, prAL, gcLl},     //     [7] LATIN SMALL LIGATURE FF..LATIN SMALL LIGATURE ST
	{0xFB13, 0xFB17, prAL, gcLl},     //     [5] ARMENIAN SMALL LIGATURE MEN NOW..ARMENIAN SMALL LIGATURE MEN XEH
	{0xFB1D, 0xFB1D, prHL, gcLo},     //         HEBREW LETTER YOD WITH HIRIQ
	{0xFB1E, 0xFB1E, prCM, gcMn},     //         HEBREW POINT JUDEO-SPANISH VARIKA
	{0xFB1F, 0xFB28, prHL, gcLo},     //    [10] HEBREW LIGATURE YIDDISH YOD YOD PATAH..HEBREW LETTER WIDE TAV
	{0xFB29, 0xFB29, prAL, gcSm},     //         HEBREW LETTER ALTERNATIVE PLUS SIGN
	{0xFB2A, 0xFB36, prHL, gcLo},     //    [13] HEBREW LETTER SHIN WITH SHIN DOT..HEBREW LETTER ZAYIN WITH DAGESH
	{0xFB38, 0xFB3C, prHL, gcLo},     //     [5] HEBREW LETTER TET WITH DAGESH..HEBREW LETTER LAMED WITH DAGESH
	{0xFB3E, 0xFB3E, prHL, gcLo},     //         HEBREW LETTER MEM WITH DAGESH
	{0xFB40, 0xFB41, prHL, gcLo},     //     [2] HEBREW LETTER NUN WITH DAGESH..HEBREW LETTER SAMEKH WITH DAGESH
	{0xFB43, 0xFB44, prHL, gcLo},     //     [2] HEBREW LETTER FINAL PE WITH DAGESH..HEBREW LETTER PE WITH DAGESH
	{0xFB46, 0xFB4F, prHL, gcLo},     //    [10] HEBREW LETTER TSADI WITH DAGESH..HEBREW LIGATURE ALEF LAMED
	{0xFB50, 0xFBB1, prAL, gcLo},     //    [98] ARABIC LETTER ALEF WASLA ISOLATED FORM..ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
	{0xFBB2, 0xFBC2, prAL, gcSk},     //    [17] ARABIC SYMBOL DOT ABOVE..ARABIC SYMBOL WASLA ABOVE
	{0xFBD3, 0xFD3D, prAL, gcLo},     //   [363] ARABIC LETTER NG ISOLATED FORM..ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
	{0xFD3E, 0xFD3E, prCL, gcPe},     //         ORNATE LEFT PARENTHESIS
	{0xFD3F, 0xFD3F, prOP, gcPs},     //         ORNATE RIGHT PARENTHESIS
	{0xFD40, 0xFD4F, prAL, gcSo},     //    [16] ARABIC LIGATURE RAHIMAHU ALLAAH..ARABIC LIGATURE RAHIMAHUM ALLAAH
	{0xFD50, 0xFD8F, prAL, gcLo},     //    [64] ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM..ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
	{0xFD92, 0xFDC7, prAL, gcLo},     //    [54] ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM..ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
	{0xFDCF, 0xFDCF, prAL, gcSo},     //         ARABIC LIGATURE SALAAMUHU ALAYNAA
	{0xFDF0, 0xFDFB, prAL, gcLo},     //    [12] ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM..ARABIC LIGATURE JALLAJALALOUHOU
	{0xFDFC, 0xFDFC, prPO, gcSc},     //         RIAL SIGN
	{0xFDFD, 0xFDFF, prAL, gcSo},     //     [3] ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM..ARABIC LIGATURE AZZA WA JALL
	{0xFE00, 0xFE0F, prCM, gcMn},     //    [16] VARIATION SELECTOR-1..VARIATION SELECTOR-16
	{0xFE10, 0xFE10, prIS, gcPo},     //         PRESENTATION FORM FOR VERTICAL COMMA
	{0xFE11, 0xFE12, prCL, gcPo},     //     [2] PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA..PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP
	{0xFE13, 0xFE14, prIS, gcPo},     //     [2] PRESENTATION FORM FOR VERTICAL COLON..PRESENTATION FORM FOR VERTICAL SEMICOLON
	{0xFE15, 0xFE16, prEX, gcPo},     //     [2] PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK..PRESENTATION FORM FOR VERTICAL QUESTION MARK
	{0xFE17, 0xFE17, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET
	{0xFE18, 0xFE18, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET
	{0xFE19, 0xFE19, prIN, gcPo},     //         PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS
	{0xFE20, 0xFE2F, prCM, gcMn},     //    [16] COMBINING LIGATURE LEFT HALF..COMBINING CYRILLIC TITLO RIGHT HALF
	{0xFE30, 0xFE30, prID, gcPo},     //         PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
	{0xFE31, 0xFE32, prID, gcPd},     //     [2] PRESENTATION FORM FOR VERTICAL EM DASH..PRESENTATION FORM FOR VERTICAL EN DASH
	{0xFE33, 0xFE34, prID, gcPc},     //     [2] PRESENTATION FORM FOR VERTICAL LOW LINE..PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
	{0xFE35, 0xFE35, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
	{0xFE36, 0xFE36, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
	{0xFE37, 0xFE37, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
	{0xFE38, 0xFE38, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
	{0xFE39, 0xFE39, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
	{0xFE3A, 0xFE3A, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
	{0xFE3B, 0xFE3B, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
	{0xFE3C, 0xFE3C, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
	{0xFE3D, 0xFE3D, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
	{0xFE3E, 0xFE3E, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
	{0xFE3F, 0xFE3F, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
	{0xFE40, 0xFE40, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
	{0xFE41, 0xFE41, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
	{0xFE42, 0xFE42, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
	{0xFE43, 0xFE43, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
	{0xFE44, 0xFE44, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
	{0xFE45, 0xFE46, prID, gcPo},     //     [2] SESAME DOT..WHITE SESAME DOT
	{0xFE47, 0xFE47, prOP, gcPs},     //         PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
	{0xFE48, 0xFE48, prCL, gcPe},     //         PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
	{0xFE49, 0xFE4C, prID, gcPo},     //     [4] DASHED OVERLINE..DOUBLE WAVY OVERLINE
	{0xFE4D, 0xFE4F, prID, gcPc},     //     [3] DASHED LOW LINE..WAVY LOW LINE
	{0xFE50, 0xFE50, prCL, gcPo},     //         SMALL COMMA
	{0xFE51, 0xFE51, prID, gcPo},     //         SMALL IDEOGRAPHIC COMMA
	{0xFE52, 0xFE52, prCL, gcPo},     //         SMALL FULL STOP
	{0xFE54, 0xFE55, prNS, gcPo},     //     [2] SMALL SEMICOLON..SMALL COLON
	{0xFE56, 0xFE57, prEX, gcPo},     //     [2] SMALL QUESTION MARK..SMALL EXCLAMATION MARK
	{0xFE58, 0xFE58, prID, gcPd},     //         SMALL EM DASH
	{0xFE59, 0xFE59, prOP, gcPs},     //         SMALL LEFT PARENTHESIS
	{0xFE5A, 0xFE5A, prCL, gcPe},     //         SMALL RIGHT PARENTHESIS
	{0xFE5B, 0xFE5B, prOP, gcPs},     //         SMALL LEFT CURLY BRACKET
	{0xFE5C, 0xFE5C, prCL, gcPe},     //         SMALL RIGHT CURLY BRACKET
	{0xFE5D, 0xFE5D, prOP, gcPs},     //         SMALL LEFT TORTOISE SHELL BRACKET
	{0xFE5E, 0xFE5E, prCL, gcPe},     //         SMALL RIGHT TORTOISE SHELL BRACKET
	{0xFE5F, 0xFE61, prID, gcPo},     //     [3] SMALL NUMBER SIGN..SMALL ASTERISK
	{0xFE62, 0xFE62, prID, gcSm},     //         SMALL PLUS SIGN
	{0xFE63, 0xFE63, prID, gcPd},     //         SMALL HYPHEN-MINUS
	{0xFE64, 0xFE66, prID, gcSm},     //     [3] SMALL LESS-THAN SIGN..SMALL EQUALS SIGN
	{0xFE68, 0xFE68, prID, gcPo},     //         SMALL REVERSE SOLIDUS
	{0xFE69, 0xFE69, prPR, gcSc},     //         SMALL DOLLAR SIGN
	{0xFE6A, 0xFE6A, prPO, gcPo},     //         SMALL PERCENT SIGN
	{0xFE6B, 0xFE6B, prID, gcPo},     //         SMALL COMMERCIAL AT
	{0xFE70, 0xFE74, prAL, gcLo},     //     [5] ARABIC FATHATAN ISOLATED FORM..ARABIC KASRATAN ISOLATED FORM
	{0xFE76, 0xFEFC, prAL, gcLo},     //   [135] ARABIC FATHA ISOLATED FORM..ARABIC LIGATURE LAM WITH ALEF FINAL FORM
	{0xFEFF, 0xFEFF, prWJ, gcCf},     //         ZERO WIDTH NO-BREAK SPACE
	{0xFF01, 0xFF01, prEX, gcPo},     //         FULLWIDTH EXCLAMATION MARK
	{0xFF02, 0xFF03, prID, gcPo},     //     [2] FULLWIDTH QUOTATION MARK..FULLWIDTH NUMBER SIGN
	{0xFF04, 0xFF04, prPR, gcSc},     //         FULLWIDTH DOLLAR SIGN
	{0xFF05, 0xFF05, prPO, gcPo},     //         FULLWIDTH PERCENT SIGN
	{0xFF06, 0xFF07, prID, gcPo},     //     [2] FULLWIDTH AMPERSAND..FULLWIDTH APOSTROPHE
	{0xFF08, 0xFF08, prOP, gcPs},     //         FULLWIDTH LEFT PARENTHESIS
	{0xFF09, 0xFF09, prCL, gcPe},     //         FULLWIDTH RIGHT PARENTHESIS
	{0xFF0A, 0xFF0A, prID, gcPo},     //         FULLWIDTH ASTERISK
	{0xFF0B, 0xFF0B, prID, gcSm},     //         FULLWIDTH PLUS SIGN
	{0xFF0C, 0xFF0C, prCL, gcPo},     //         FULLWIDTH COMMA
	{0xFF0D, 0xFF0D, prID, gcPd},     //         FULLWIDTH HYPHEN-MINUS
	{0xFF0E, 0xFF0E, prCL, gcPo},     //         FULLWIDTH FULL STOP
	{0xFF0F, 0xFF0F, prID, gcPo},     //         FULLWIDTH SOLIDUS
	{0xFF10, 0xFF19, prID, gcNd},     //    [10] FULLWIDTH DIGIT ZERO..FULLWIDTH DIGIT NINE
	{0xFF1A, 0xFF1B, prNS, gcPo},     //     [2] FULLWIDTH COLON..FULLWIDTH SEMICOLON
	{0xFF1C, 0xFF1E, prID, gcSm},     //     [3] FULLWIDTH LESS-THAN SIGN..FULLWIDTH GREATER-THAN SIGN
	{0xFF1F, 0xFF1F, prEX, gcPo},     //         FULLWIDTH QUESTION MARK
	{0xFF20, 0xFF20, prID, gcPo},     //         FULLWIDTH COMMERCIAL AT
	{0xFF21, 0xFF3A, prID, gcLu},     //    [26] FULLWIDTH LATIN CAPITAL LETTER A..FULLWIDTH LATIN CAPITAL LETTER Z
	{0xFF3B, 0xFF3B, prOP, gcPs},     //         FULLWIDTH LEFT SQUARE BRACKET
	{0xFF3C, 0xFF3C, prID, gcPo},     //         FULLWIDTH REVERSE SOLIDUS
	{0xFF3D, 0xFF3D, prCL, gcPe},     //         FULLWIDTH RIGHT SQUARE BRACKET
	{0xFF3E, 0xFF3E, prID, gcSk},     //         FULLWIDTH CIRCUMFLEX ACCENT
	{0xFF3F, 0xFF3F, prID, gcPc},     //         FULLWIDTH LOW LINE
	{0xFF40, 0xFF40, prID, gcSk},     //         FULLWIDTH GRAVE ACCENT
	{0xFF41, 0xFF5A, prID, gcLl},     //    [26] FULLWIDTH LATIN SMALL LETTER A..FULLWIDTH LATIN SMALL LETTER Z
	{0xFF5B, 0xFF5B, prOP, gcPs},     //         FULLWIDTH LEFT CURLY BRACKET
	{0xFF5C, 0xFF5C, prID, gcSm},     //         FULLWIDTH VERTICAL LINE
	{0xFF5D, 0xFF5D, prCL, gcPe},     //         FULLWIDTH RIGHT CURLY BRACKET
	{0xFF5E, 0xFF5E, prID, gcSm},     //         FULLWIDTH TILDE
	{0xFF5F, 0xFF5F, prOP, gcPs},     //         FULLWIDTH LEFT WHITE PARENTHESIS
	{0xFF60, 0xFF60, prCL, gcPe},     //         FULLWIDTH RIGHT WHITE PARENTHESIS
	{0xFF61, 0xFF61, prCL, gcPo},     //         HALFWIDTH IDEOGRAPHIC FULL STOP
	{0xFF62, 0xFF62, prOP, gcPs},     //         HALFWIDTH LEFT CORNER BRACKET
	{0xFF63, 0xFF63, prCL, gcPe},     //         HALFWIDTH RIGHT CORNER BRACKET
	{0xFF64, 0xFF64, prCL, gcPo},     //         HALFWIDTH IDEOGRAPHIC COMMA
	{0xFF65, 0xFF65, prNS, gcPo},     //         HALFWIDTH KATAKANA MIDDLE DOT
	{0xFF66, 0xFF66, prID, gcLo},     //         HALFWIDTH KATAKANA LETTER WO
	{0xFF67, 0xFF6F, prCJ, gcLo},     //     [9] HALFWIDTH KATAKANA LETTER SMALL A..HALFWIDTH KATAKANA LETTER SMALL TU
	{0xFF70, 0xFF70, prCJ, gcLm},     //         HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
	{0xFF71, 0xFF9D, prID, gcLo},     //    [45] HALFWIDTH KATAKANA LETTER A..HALFWIDTH KATAKANA LETTER N
	{0xFF9E, 0xFF9F, prNS, gcLm},     //     [2] HALFWIDTH KATAKANA VOICED SOUND MARK..HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
	{0xFFA0, 0xFFBE, prID, gcLo},     //    [31] HALFWIDTH HANGUL FILLER..HALFWIDTH HANGUL LETTER HIEUH
	{0xFFC2, 0xFFC7, prID, gcLo},     //     [6] HALFWIDTH HANGUL LETTER A..HALFWIDTH HANGUL LETTER E
	{0xFFCA, 0xFFCF, prID, gcLo},     //     [6] HALFWIDTH HANGUL LETTER YEO..HALFWIDTH HANGUL LETTER OE
	{0xFFD2, 0xFFD7, prID, gcLo},     //     [6] HALFWIDTH HANGUL LETTER YO..HALFWIDTH HANGUL LETTER YU
	{0xFFDA, 0xFFDC, prID, gcLo},     //     [3] HALFWIDTH HANGUL LETTER EU..HALFWIDTH HANGUL LETTER I
	{0xFFE0, 0xFFE0, prPO, gcSc},     //         FULLWIDTH CENT SIGN
	{0xFFE1, 0xFFE1, prPR, gcSc},     //         FULLWIDTH POUND SIGN
	{0xFFE2, 0xFFE2, prID, gcSm},     //         FULLWIDTH NOT SIGN
	{0xFFE3, 0xFFE3, prID, gcSk},     //         FULLWIDTH MACRON
	{0xFFE4, 0xFFE4, prID, gcSo},     //         FULLWIDTH BROKEN BAR
	{0xFFE5, 0xFFE6, prPR, gcSc},     //     [2] FULLWIDTH YEN SIGN..FULLWIDTH WON SIGN
	{0xFFE8, 0xFFE8, prAL, gcSo},     //         HALFWIDTH FORMS LIGHT VERTICAL
	{0xFFE9, 0xFFEC, prAL, gcSm},     //     [4] HALFWIDTH LEFTWARDS ARROW..HALFWIDTH DOWNWARDS ARROW
	{0xFFED, 0xFFEE, prAL, gcSo},     //     [2] HALFWIDTH BLACK SQUARE..HALFWIDTH WHITE CIRCLE
	{0xFFF9, 0xFFFB, prCM, gcCf},     //     [3] INTERLINEAR ANNOTATION ANCHOR..INTERLINEAR ANNOTATION TERMINATOR
	{0xFFFC, 0xFFFC, prCB, gcSo},     //         OBJECT REPLACEMENT CHARACTER
	{0xFFFD, 0xFFFD, prAI, gcSo},     //         REPLACEMENT CHARACTER
	{0x10000, 0x1000B, prAL, gcLo},   //    [12] LINEAR B SYLLABLE B008 A..LINEAR B SYLLABLE B046 JE
	{0x1000D, 0x10026, prAL, gcLo},   //    [26] LINEAR B SYLLABLE B036 JO..LINEAR B SYLLABLE B032 QO
	{0x10028, 0x1003A, prAL, gcLo},   //    [19] LINEAR B SYLLABLE B060 RA..LINEAR B SYLLABLE B042 WO
	{0x1003C, 0x1003D, prAL, gcLo},   //     [2] LINEAR B SYLLABLE B017 ZA..LINEAR B SYLLABLE B074 ZE
	{0x1003F, 0x1004D, prAL, gcLo},   //    [15] LINEAR B SYLLABLE B020 ZO..LINEAR B SYLLABLE B091 TWO
	{0x10050, 0x1005D, prAL, gcLo},   //    [14] LINEAR B SYMBOL B018..LINEAR B SYMBOL B089
	{0x10080, 0x100FA, prAL, gcLo},   //   [123] LINEAR B IDEOGRAM B100 MAN..LINEAR B IDEOGRAM VESSEL B305
	{0x10100, 0x10102, prBA, gcPo},   //     [3] AEGEAN WORD SEPARATOR LINE..AEGEAN CHECK MARK
	{0x10107, 0x10133, prAL, gcNo},   //    [45] AEGEAN NUMBER ONE..AEGEAN NUMBER NINETY THOUSAND
	{0x10137, 0x1013F, prAL, gcSo},   //     [9] AEGEAN WEIGHT BASE UNIT..AEGEAN MEASURE THIRD SUBUNIT
	{0x10140, 0x10174, prAL, gcNl},   //    [53] GREEK ACROPHONIC ATTIC ONE QUARTER..GREEK ACROPHONIC STRATIAN FIFTY MNAS
	{0x10175, 0x10178, prAL, gcNo},   //     [4] GREEK ONE HALF SIGN..GREEK THREE QUARTERS SIGN
	{0x10179, 0x10189, prAL, gcSo},   //    [17] GREEK YEAR SIGN..GREEK TRYBLION BASE SIGN
	{0x1018A, 0x1018B, prAL, gcNo},   //     [2] GREEK ZERO SIGN..GREEK ONE QUARTER SIGN
	{0x1018C, 0x1018E, prAL, gcSo},   //     [3] GREEK SINUSOID SIGN..NOMISMA SIGN
	{0x10190, 0x1019C, prAL, gcSo},   //    [13] ROMAN SEXTANS SIGN..ASCIA SYMBOL
	{0x101A0, 0x101A0, prAL, gcSo},   //         GREEK SYMBOL TAU RHO
	{0x101D0, 0x101FC, prAL, gcSo},   //    [45] PHAISTOS DISC SIGN PEDESTRIAN..PHAISTOS DISC SIGN WAVY BAND
	{0x101FD, 0x101FD, prCM, gcMn},   //         PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE
	{0x10280, 0x1029C, prAL, gcLo},   //    [29] LYCIAN LETTER A..LYCIAN LETTER X
	{0x102A0, 0x102D0, prAL, gcLo},   //    [49] CARIAN LETTER A..CARIAN LETTER UUU3
	{0x102E0, 0x102E0, prCM, gcMn},   //         COPTIC EPACT THOUSANDS MARK
	{0x102E1, 0x102FB, prAL, gcNo},   //    [27] COPTIC EPACT DIGIT ONE..COPTIC EPACT NUMBER NINE HUNDRED
	{0x10300, 0x1031F, prAL, gcLo},   //    [32] OLD ITALIC LETTER A..OLD ITALIC LETTER ESS
	{0x10320, 0x10323, prAL, gcNo},   //     [4] OLD ITALIC NUMERAL ONE..OLD ITALIC NUMERAL FIFTY
	{0x1032D, 0x1032F, prAL, gcLo},   //     [3] OLD ITALIC LETTER YE..OLD ITALIC LETTER SOUTHERN TSE
	{0x10330, 0x10340, prAL, gcLo},   //    [17] GOTHIC LETTER AHSA..GOTHIC LETTER PAIRTHRA
	{0x10341, 0x10341, prAL, gcNl},   //         GOTHIC LETTER NINETY
	{0x10342, 0x10349, prAL, gcLo},   //     [8] GOTHIC LETTER RAIDA..GOTHIC LETTER OTHAL
	{0x1034A, 0x1034A, prAL, gcNl},   //         GOTHIC LETTER NINE HUNDRED
	{0x10350, 0x10375, prAL, gcLo},   //    [38] OLD PERMIC LETTER AN..OLD PERMIC LETTER IA
	{0x10376, 0x1037A, prCM, gcMn},   //     [5] COMBINING OLD PERMIC LETTER AN..COMBINING OLD PERMIC LETTER SII
	{0x10380, 0x1039D, prAL, gcLo},   //    [30] UGARITIC LETTER ALPA..UGARITIC LETTER SSU
	{0x1039F, 0x1039F, prBA, gcPo},   //         UGARITIC WORD DIVIDER
	{0x103A0, 0x103C3, prAL, gcLo},   //    [36] OLD PERSIAN SIGN A..OLD PERSIAN SIGN HA
	{0x103C8, 0x103CF, prAL, gcLo},   //     [8] OLD PERSIAN SIGN AURAMAZDAA..OLD PERSIAN SIGN BUUMISH
	{0x103D0, 0x103D0, prBA, gcPo},   //         OLD PERSIAN WORD DIVIDER
	{0x103D1, 0x103D5, prAL, gcNl},   //     [5] OLD PERSIAN NUMBER ONE..OLD PERSIAN NUMBER HUNDRED
	{0x10400, 0x1044F, prAL, gcLC},   //    [80] DESERET CAPITAL LETTER LONG I..DESERET SMALL LETTER EW
	{0x10450, 0x1047F, prAL, gcLo},   //    [48] SHAVIAN LETTER PEEP..SHAVIAN LETTER YEW
	{0x10480, 0x1049D, prAL, gcLo},   //    [30] OSMANYA LETTER ALEF..OSMANYA LETTER OO
	{0x104A0, 0x104A9, prNU, gcNd},   //    [10] OSMANYA DIGIT ZERO..OSMANYA DIGIT NINE
	{0x104B0, 0x104D3, prAL, gcLu},   //    [36] OSAGE CAPITAL LETTER A..OSAGE CAPITAL LETTER ZHA
	{0x104D8, 0x104FB, prAL, gcLl},   //    [36] OSAGE SMALL LETTER A..OSAGE SMALL LETTER ZHA
	{0x10500, 0x10527, prAL, gcLo},   //    [40] ELBASAN LETTER A..ELBASAN LETTER KHE
	{0x10530, 0x10563, prAL, gcLo},   //    [52] CAUCASIAN ALBANIAN LETTER ALT..CAUCASIAN ALBANIAN LETTER KIW
	{0x1056F, 0x1056F, prAL, gcPo},   //         CAUCASIAN ALBANIAN CITATION MARK
	{0x10570, 0x1057A, prAL, gcLu},   //    [11] VITHKUQI CAPITAL LETTER A..VITHKUQI CAPITAL LETTER GA
	{0x1057C, 0x1058A, prAL, gcLu},   //    [15] VITHKUQI CAPITAL LETTER HA..VITHKUQI CAPITAL LETTER RE
	{0x1058C, 0x10592, prAL, gcLu},   //     [7] VITHKUQI CAPITAL LETTER SE..VITHKUQI CAPITAL LETTER XE
	{0x10594, 0x10595, prAL, gcLu},   //     [2] VITHKUQI CAPITAL LETTER Y..VITHKUQI CAPITAL LETTER ZE
	{0x10597, 0x105A1, prAL, gcLl},   //    [11] VITHKUQI SMALL LETTER A..VITHKUQI SMALL LETTER GA
	{0x105A3, 0x105B1, prAL, gcLl},   //    [15] VITHKUQI SMALL LETTER HA..VITHKUQI SMALL LETTER RE
	{0x105B3, 0x105B9, prAL, gcLl},   //     [7] VITHKUQI SMALL LETTER SE..VITHKUQI SMALL LETTER XE
	{0x105BB, 0x105BC, prAL, gcLl},   //     [2] VITHKUQI SMALL LETTER Y..VITHKUQI SMALL LETTER ZE
	{0x10600, 0x10736, prAL, gcLo},   //   [311] LINEAR A SIGN AB001..LINEAR A SIGN A664
	{0x10740, 0x10755, prAL, gcLo},   //    [22] LINEAR A SIGN A701 A..LINEAR A SIGN A732 JE
	{0x10760, 0x10767, prAL, gcLo},   //     [8] LINEAR A SIGN A800..LINEAR A SIGN A807
	{0x10780, 0x10785, prAL, gcLm},   //     [6] MODIFIER LETTER SMALL CAPITAL AA..MODIFIER LETTER SMALL B WITH HOOK
	{0x10787, 0x107B0, prAL, gcLm},   //    [42] MODIFIER LETTER SMALL DZ DIGRAPH..MODIFIER LETTER SMALL V WITH RIGHT HOOK
	{0x107B2, 0x107BA, prAL, gcLm},   //     [9] MODIFIER LETTER SMALL CAPITAL Y..MODIFIER LETTER SMALL S WITH CURL
	{0x10800, 0x10805, prAL, gcLo},   //     [6] CYPRIOT SYLLABLE A..CYPRIOT SYLLABLE JA
	{0x10808, 0x10808, prAL, gcLo},   //         CYPRIOT SYLLABLE JO
	{0x1080A, 0x10835, prAL, gcLo},   //    [44] CYPRIOT SYLLABLE KA..CYPRIOT SYLLABLE WO
	{0x10837, 0x10838, prAL, gcLo},   //     [2] CYPRIOT SYLLABLE XA..CYPRIOT SYLLABLE XE
	{0x1083C, 0x1083C, prAL, gcLo},   //         CYPRIOT SYLLABLE ZA
	{0x1083F, 0x1083F, prAL, gcLo},   //         CYPRIOT SYLLABLE ZO
	{0x10840, 0x10855, prAL, gcLo},   //    [22] IMPERIAL ARAMAIC LETTER ALEPH..IMPERIAL ARAMAIC LETTER TAW
	{0x10857, 0x10857, prBA, gcPo},   //         IMPERIAL ARAMAIC SECTION SIGN
	{0x10858, 0x1085F, prAL, gcNo},   //     [8] IMPERIAL ARAMAIC NUMBER ONE..IMPERIAL ARAMAIC NUMBER TEN THOUSAND
	{0x10860, 0x10876, prAL, gcLo},   //    [23] PALMYRENE LETTER ALEPH..PALMYRENE LETTER TAW
	{0x10877, 0x10878, prAL, gcSo},   //     [2] PALMYRENE LEFT-POINTING FLEURON..PALMYRENE RIGHT-POINTING FLEURON
	{0x10879, 0x1087F, prAL, gcNo},   //     [7] PALMYRENE NUMBER ONE..PALMYRENE NUMBER TWENTY
	{0x10880, 0x1089E, prAL, gcLo},   //    [31] NABATAEAN LETTER FINAL ALEPH..NABATAEAN LETTER TAW
	{0x108A7, 0x108AF, prAL, gcNo},   //     [9] NABATAEAN NUMBER ONE..NABATAEAN NUMBER ONE HUNDRED
	{0x108E0, 0x108F2, prAL, gcLo},   //    [19] HATRAN LETTER ALEPH..HATRAN LETTER QOPH
	{0x108F4, 0x108F5, prAL, gcLo},   //     [2] HATRAN LETTER SHIN..HATRAN LETTER TAW
	{0x108FB, 0x108FF, prAL, gcNo},   //     [5] HATRAN NUMBER ONE..HATRAN NUMBER ONE HUNDRED
	{0x10900, 0x10915, prAL, gcLo},   //    [22] PHOENICIAN LETTER ALF..PHOENICIAN LETTER TAU
	{0x10916, 0x1091B, prAL, gcNo},   //     [6] PHOENICIAN NUMBER ONE..PHOENICIAN NUMBER THREE
	{0x1091F, 0x1091F, prBA, gcPo},   //         PHOENICIAN WORD SEPARATOR
	{0x10920, 0x10939, prAL, gcLo},   //    [26] LYDIAN LETTER A..LYDIAN LETTER C
	{0x1093F, 0x1093F, prAL, gcPo},   //         LYDIAN TRIANGULAR MARK
	{0x10980, 0x1099F, prAL, gcLo},   //    [32] MEROITIC HIEROGLYPHIC LETTER A..MEROITIC HIEROGLYPHIC SYMBOL VIDJ-2
	{0x109A0, 0x109B7, prAL, gcLo},   //    [24] MEROITIC CURSIVE LETTER A..MEROITIC CURSIVE LETTER DA
	{0x109BC, 0x109BD, prAL, gcNo},   //     [2] MEROITIC CURSIVE FRACTION ELEVEN TWELFTHS..MEROITIC CURSIVE FRACTION ONE HALF
	{0x109BE, 0x109BF, prAL, gcLo},   //     [2] MEROITIC CURSIVE LOGOGRAM RMT..MEROITIC CURSIVE LOGOGRAM IMN
	{0x109C0, 0x109CF, prAL, gcNo},   //    [16] MEROITIC CURSIVE NUMBER ONE..MEROITIC CURSIVE NUMBER SEVENTY
	{0x109D2, 0x109FF, prAL, gcNo},   //    [46] MEROITIC CURSIVE NUMBER ONE HUNDRED..MEROITIC CURSIVE FRACTION TEN TWELFTHS
	{0x10A00, 0x10A00, prAL, gcLo},   //         KHAROSHTHI LETTER A
	{0x10A01, 0x10A03, prCM, gcMn},   //     [3] KHAROSHTHI VOWEL SIGN I..KHAROSHTHI VOWEL SIGN VOCALIC R
	{0x10A05, 0x10A06, prCM, gcMn},   //     [2] KHAROSHTHI VOWEL SIGN E..KHAROSHTHI VOWEL SIGN O
	{0x10A0C, 0x10A0F, prCM, gcMn},   //     [4] KHAROSHTHI VOWEL LENGTH MARK..KHAROSHTHI SIGN VISARGA
	{0x10A10, 0x10A13, prAL, gcLo},   //     [4] KHAROSHTHI LETTER KA..KHAROSHTHI LETTER GHA
	{0x10A15, 0x10A17, prAL, gcLo},   //     [3] KHAROSHTHI LETTER CA..KHAROSHTHI LETTER JA
	{0x10A19, 0x10A35, prAL, gcLo},   //    [29] KHAROSHTHI LETTER NYA..KHAROSHTHI LETTER VHA
	{0x10A38, 0x10A3A, prCM, gcMn},   //     [3] KHAROSHTHI SIGN BAR ABOVE..KHAROSHTHI SIGN DOT BELOW
	{0x10A3F, 0x10A3F, prCM, gcMn},   //         KHAROSHTHI VIRAMA
	{0x10A40, 0x10A48, prAL, gcNo},   //     [9] KHAROSHTHI DIGIT ONE..KHAROSHTHI FRACTION ONE HALF
	{0x10A50, 0x10A57, prBA, gcPo},   //     [8] KHAROSHTHI PUNCTUATION DOT..KHAROSHTHI PUNCTUATION DOUBLE DANDA
	{0x10A58, 0x10A58, prAL, gcPo},   //         KHAROSHTHI PUNCTUATION LINES
	{0x10A60, 0x10A7C, prAL, gcLo},   //    [29] OLD SOUTH ARABIAN LETTER HE..OLD SOUTH ARABIAN LETTER THETH
	{0x10A7D, 0x10A7E, prAL, gcNo},   //     [2] OLD SOUTH ARABIAN NUMBER ONE..OLD SOUTH ARABIAN NUMBER FIFTY
	{0x10A7F, 0x10A7F, prAL, gcPo},   //         OLD SOUTH ARABIAN NUMERIC INDICATOR
	{0x10A80, 0x10A9C, prAL, gcLo},   //    [29] OLD NORTH ARABIAN LETTER HEH..OLD NORTH ARABIAN LETTER ZAH
	{0x10A9D, 0x10A9F, prAL, gcNo},   //     [3] OLD NORTH ARABIAN NUMBER ONE..OLD NORTH ARABIAN NUMBER TWENTY
	{0x10AC0, 0x10AC7, prAL, gcLo},   //     [8] MANICHAEAN LETTER ALEPH..MANICHAEAN LETTER WAW
	{0x10AC8, 0x10AC8, prAL, gcSo},   //         MANICHAEAN SIGN UD
	{0x10AC9, 0x10AE4, prAL, gcLo},   //    [28] MANICHAEAN LETTER ZAYIN..MANICHAEAN LETTER TAW
	{0x10AE5, 0x10AE6, prCM, gcMn},   //     [2] MANICHAEAN ABBREVIATION MARK ABOVE..MANICHAEAN ABBREVIATION MARK BELOW
	{0x10AEB, 0x10AEF, prAL, gcNo},   //     [5] MANICHAEAN NUMBER ONE..MANICHAEAN NUMBER ONE HUNDRED
	{0x10AF0, 0x10AF5, prBA, gcPo},   //     [6] MANICHAEAN PUNCTUATION STAR..MANICHAEAN PUNCTUATION TWO DOTS
	{0x10AF6, 0x10AF6, prIN, gcPo},   //         MANICHAEAN PUNCTUATION LINE FILLER
	{0x10B00, 0x10B35, prAL, gcLo},   //    [54] AVESTAN LETTER A..AVESTAN LETTER HE
	{0x10B39, 0x10B3F, prBA, gcPo},   //     [7] AVESTAN ABBREVIATION MARK..LARGE ONE RING OVER TWO RINGS PUNCTUATION
	{0x10B40, 0x10B55, prAL, gcLo},   //    [22] INSCRIPTIONAL PARTHIAN LETTER ALEPH..INSCRIPTIONAL PARTHIAN LETTER TAW
	{0x10B58, 0x10B5F, prAL, gcNo},   //     [8] INSCRIPTIONAL PARTHIAN NUMBER ONE..INSCRIPTIONAL PARTHIAN NUMBER ONE THOUSAND
	{0x10B60, 0x10B72, prAL, gcLo},   //    [19] INSCRIPTIONAL PAHLAVI LETTER ALEPH..INSCRIPTIONAL PAHLAVI LETTER TAW
	{0x10B78, 0x10B7F, prAL, gcNo},   //     [8] INSCRIPTIONAL PAHLAVI NUMBER ONE..INSCRIPTIONAL PAHLAVI NUMBER ONE THOUSAND
	{0x10B80, 0x10B91, prAL, gcLo},   //    [18] PSALTER PAHLAVI LETTER ALEPH..PSALTER PAHLAVI LETTER TAW
	{0x10B99, 0x10B9C, prAL, gcPo},   //     [4] PSALTER PAHLAVI SECTION MARK..PSALTER PAHLAVI FOUR DOTS WITH DOT
	{0x10BA9, 0x10BAF, prAL, gcNo},   //     [7] PSALTER PAHLAVI NUMBER ONE..PSALTER PAHLAVI NUMBER ONE HUNDRED
	{0x10C00, 0x10C48, prAL, gcLo},   //    [73] OLD TURKIC LETTER ORKHON A..OLD TURKIC LETTER ORKHON BASH
	{0x10C80, 0x10CB2, prAL, gcLu},   //    [51] OLD HUNGARIAN CAPITAL LETTER A..OLD HUNGARIAN CAPITAL LETTER US
	{0x10CC0, 0x10CF2, prAL, gcLl},   //    [51] OLD HUNGARIAN SMALL LETTER A..OLD HUNGARIAN SMALL LETTER US
	{0x10CFA, 0x10CFF, prAL, gcNo},   //     [6] OLD HUNGARIAN NUMBER ONE..OLD HUNGARIAN NUMBER ONE THOUSAND
	{0x10D00, 0x10D23, prAL, gcLo},   //    [36] HANIFI ROHINGYA LETTER A..HANIFI ROHINGYA MARK NA KHONNA
	{0x10D24, 0x10D27, prCM, gcMn},   //     [4] HANIFI ROHINGYA SIGN HARBAHAY..HANIFI ROHINGYA SIGN TASSI
	{0x10D30, 0x10D39, prNU, gcNd},   //    [10] HANIFI ROHINGYA DIGIT ZERO..HANIFI ROHINGYA DIGIT NINE
	{0x10E60, 0x10E7E, prAL, gcNo},   //    [31] RUMI DIGIT ONE..RUMI FRACTION TWO THIRDS
	{0x10E80, 0x10EA9, prAL, gcLo},   //    [42] YEZIDI LETTER ELIF..YEZIDI LETTER ET
	{0x10EAB, 0x10EAC, prCM, gcMn},   //     [2] YEZIDI COMBINING HAMZA MARK..YEZIDI COMBINING MADDA MARK
	{0x10EAD, 0x10EAD, prBA, gcPd},   //         YEZIDI HYPHENATION MARK
	{0x10EB0, 0x10EB1, prAL, gcLo},   //     [2] YEZIDI LETTER LAM WITH DOT ABOVE..YEZIDI LETTER YOT WITH CIRCUMFLEX ABOVE
	{0x10EFD, 0x10EFF, prCM, gcMn},   //     [3] ARABIC SMALL LOW WORD SAKTA..ARABIC SMALL LOW WORD MADDA
	{0x10F00, 0x10F1C, prAL, gcLo},   //    [29] OLD SOGDIAN LETTER ALEPH..OLD SOGDIAN LETTER FINAL TAW WITH VERTICAL TAIL
	{0x10F1D, 0x10F26, prAL, gcNo},   //    [10] OLD SOGDIAN NUMBER ONE..OLD SOGDIAN FRACTION ONE HALF
	{0x10F27, 0x10F27, prAL, gcLo},   //         OLD SOGDIAN LIGATURE AYIN-DALETH
	{0x10F30, 0x10F45, prAL, gcLo},   //    [22] SOGDIAN LETTER ALEPH..SOGDIAN INDEPENDENT SHIN
	{0x10F46, 0x10F50, prCM, gcMn},   //    [11] SOGDIAN COMBINING DOT BELOW..SOGDIAN COMBINING STROKE BELOW
	{0x10F51, 0x10F54, prAL, gcNo},   //     [4] SOGDIAN NUMBER ONE..SOGDIAN NUMBER ONE HUNDRED
	{0x10F55, 0x10F59, prAL, gcPo},   //     [5] SOGDIAN PUNCTUATION TWO VERTICAL BARS..SOGDIAN PUNCTUATION HALF CIRCLE WITH DOT
	{0x10F70, 0x10F81, prAL, gcLo},   //    [18] OLD UYGHUR LETTER ALEPH..OLD UYGHUR LETTER LESH
	{0x10F82, 0x10F85, prCM, gcMn},   //     [4] OLD UYGHUR COMBINING DOT ABOVE..OLD UYGHUR COMBINING TWO DOTS BELOW
	{0x10F86, 0x10F89, prAL, gcPo},   //     [4] OLD UYGHUR PUNCTUATION BAR..OLD UYGHUR PUNCTUATION FOUR DOTS
	{0x10FB0, 0x10FC4, prAL, gcLo},   //    [21] CHORASMIAN LETTER ALEPH..CHORASMIAN LETTER TAW
	{0x10FC5, 0x10FCB, prAL, gcNo},   //     [7] CHORASMIAN NUMBER ONE..CHORASMIAN NUMBER ONE HUNDRED
	{0x10FE0, 0x10FF6, prAL, gcLo},   //    [23] ELYMAIC LETTER ALEPH..ELYMAIC LIGATURE ZAYIN-YODH
	{0x11000, 0x11000, prCM, gcMc},   //         BRAHMI SIGN CANDRABINDU
	{0x11001, 0x11001, prCM, gcMn},   //         BRAHMI SIGN ANUSVARA
	{0x11002, 0x11002, prCM, gcMc},   //         BRAHMI SIGN VISARGA
	{0x11003, 0x11037, prAL, gcLo},   //    [53] BRAHMI SIGN JIHVAMULIYA..BRAHMI LETTER OLD TAMIL NNNA
	{0x11038, 0x11046, prCM, gcMn},   //    [15] BRAHMI VOWEL SIGN AA..BRAHMI VIRAMA
	{0x11047, 0x11048, prBA, gcPo},   //     [2] BRAHMI DANDA..BRAHMI DOUBLE DANDA
	{0x11049, 0x1104D, prAL, gcPo},   //     [5] BRAHMI PUNCTUATION DOT..BRAHMI PUNCTUATION LOTUS
	{0x11052, 0x11065, prAL, gcNo},   //    [20] BRAHMI NUMBER ONE..BRAHMI NUMBER ONE THOUSAND
	{0x11066, 0x1106F, prNU, gcNd},   //    [10] BRAHMI DIGIT ZERO..BRAHMI DIGIT NINE
	{0x11070, 0x11070, prCM, gcMn},   //         BRAHMI SIGN OLD TAMIL VIRAMA
	{0x11071, 0x11072, prAL, gcLo},   //     [2] BRAHMI LETTER OLD TAMIL SHORT E..BRAHMI LETTER OLD TAMIL SHORT O
	{0x11073, 0x11074, prCM, gcMn},   //     [2] BRAHMI VOWEL SIGN OLD TAMIL SHORT E..BRAHMI VOWEL SIGN OLD TAMIL SHORT O
	{0x11075, 0x11075, prAL, gcLo},   //         BRAHMI LETTER OLD TAMIL LLA
	{0x1107F, 0x1107F, prCM, gcMn},   //         BRAHMI NUMBER JOINER
	{0x11080, 0x11081, prCM, gcMn},   //     [2] KAITHI SIGN CANDRABINDU..KAITHI SIGN ANUSVARA
	{0x11082, 0x11082, prCM, gcMc},   //         KAITHI SIGN VISARGA
	{0x11083, 0x110AF, prAL, gcLo},   //    [45] KAITHI LETTER A..KAITHI LETTER HA
	{0x110B0, 0x110B2, prCM, gcMc},   //     [3] KAITHI VOWEL SIGN AA..KAITHI VOWEL SIGN II
	{0x110B3, 0x110B6, prCM, gcMn},   //     [4] KAITHI VOWEL SIGN U..KAITHI VOWEL SIGN AI
	{0x110B7, 0x110B8, prCM, gcMc},   //     [2] KAITHI VOWEL SIGN O..KAITHI VOWEL SIGN AU
	{0x110B9, 0x110BA, prCM, gcMn},   //     [2] KAITHI SIGN VIRAMA..KAITHI SIGN NUKTA
	{0x110BB, 0x110BC, prAL, gcPo},   //     [2] KAITHI ABBREVIATION SIGN..KAITHI ENUMERATION SIGN
	{0x110BD, 0x110BD, prAL, gcCf},   //         KAITHI NUMBER SIGN
	{0x110BE, 0x110C1, prBA, gcPo},   //     [4] KAITHI SECTION MARK..KAITHI DOUBLE DANDA
	{0x110C2, 0x110C2, prCM, gcMn},   //         KAITHI VOWEL SIGN VOCALIC R
	{0x110CD, 0x110CD, prAL, gcCf},   //         KAITHI NUMBER SIGN ABOVE
	{0x110D0, 0x110E8, prAL, gcLo},   //    [25] SORA SOMPENG LETTER SAH..SORA SOMPENG LETTER MAE
	{0x110F0, 0x110F9, prNU, gcNd},   //    [10] SORA SOMPENG DIGIT ZERO..SORA SOMPENG DIGIT NINE
	{0x11100, 0x11102, prCM, gcMn},   //     [3] CHAKMA SIGN CANDRABINDU..CHAKMA SIGN VISARGA
	{0x11103, 0x11126, prAL, gcLo},   //    [36] CHAKMA LETTER AA..CHAKMA LETTER HAA
	{0x11127, 0x1112B, prCM, gcMn},   //     [5] CHAKMA VOWEL SIGN A..CHAKMA VOWEL SIGN UU
	{0x1112C, 0x1112C, prCM, gcMc},   //         CHAKMA VOWEL SIGN E
	{0x1112D, 0x11134, prCM, gcMn},   //     [8] CHAKMA VOWEL SIGN AI..CHAKMA MAAYYAA
	{0x11136, 0x1113F, prNU, gcNd},   //    [10] CHAKMA DIGIT ZERO..CHAKMA DIGIT NINE
	{0x11140, 0x11143, prBA, gcPo},   //     [4] CHAKMA SECTION MARK..CHAKMA QUESTION MARK
	{0x11144, 0x11144, prAL, gcLo},   //         CHAKMA LETTER LHAA
	{0x11145, 0x11146, prCM, gcMc},   //     [2] CHAKMA VOWEL SIGN AA..CHAKMA VOWEL SIGN EI
	{0x11147, 0x11147, prAL, gcLo},   //         CHAKMA LETTER VAA
	{0x11150, 0x11172, prAL, gcLo},   //    [35] MAHAJANI LETTER A..MAHAJANI LETTER RRA
	{0x11173, 0x11173, prCM, gcMn},   //         MAHAJANI SIGN NUKTA
	{0x11174, 0x11174, prAL, gcPo},   //         MAHAJANI ABBREVIATION SIGN
	{0x11175, 0x11175, prBB, gcPo},   //         MAHAJANI SECTION MARK
	{0x11176, 0x11176, prAL, gcLo},   //         MAHAJANI LIGATURE SHRI
	{0x11180, 0x11181, prCM, gcMn},   //     [2] SHARADA SIGN CANDRABINDU..SHARADA SIGN ANUSVARA
	{0x11182, 0x11182, prCM, gcMc},   //         SHARADA SIGN VISARGA
	{0x11183, 0x111B2, prAL, gcLo},   //    [48] SHARADA LETTER A..SHARADA LETTER HA
	{0x111B3, 0x111B5, prCM, gcMc},   //     [3] SHARADA VOWEL SIGN AA..SHARADA VOWEL SIGN II
	{0x111B6, 0x111BE, prCM, gcMn},   //     [9] SHARADA VOWEL SIGN U..SHARADA VOWEL SIGN O
	{0x111BF, 0x111C0, prCM, gcMc},   //     [2] SHARADA VOWEL SIGN AU..SHARADA SIGN VIRAMA
	{0x111C1, 0x111C4, prAL, gcLo},   //     [4] SHARADA SIGN AVAGRAHA..SHARADA OM
	{0x111C5, 0x111C6, prBA, gcPo},   //     [2] SHARADA DANDA..SHARADA DOUBLE DANDA
	{0x111C7, 0x111C7, prAL, gcPo},   //         SHARADA ABBREVIATION SIGN
	{0x111C8, 0x111C8, prBA, gcPo},   //         SHARADA SEPARATOR
	{0x111C9, 0x111CC, prCM, gcMn},   //     [4] SHARADA SANDHI MARK..SHARADA EXTRA SHORT VOWEL MARK
	{0x111CD, 0x111CD, prAL, gcPo},   //         SHARADA SUTRA MARK
	{0x111CE, 0x111CE, prCM, gcMc},   //         SHARADA VOWEL SIGN PRISHTHAMATRA E
	{0x111CF, 0x111CF, prCM, gcMn},   //         SHARADA SIGN INVERTED CANDRABINDU
	{0x111D0, 0x111D9, prNU, gcNd},   //    [10] SHARADA DIGIT ZERO..SHARADA DIGIT NINE
	{0x111DA, 0x111DA, prAL, gcLo},   //         SHARADA EKAM
	{0x111DB, 0x111DB, prBB, gcPo},   //         SHARADA SIGN SIDDHAM
	{0x111DC, 0x111DC, prAL, gcLo},   //         SHARADA HEADSTROKE
	{0x111DD, 0x111DF, prBA, gcPo},   //     [3] SHARADA CONTINUATION SIGN..SHARADA SECTION MARK-2
	{0x111E1, 0x111F4, prAL, gcNo},   //    [20] SINHALA ARCHAIC DIGIT ONE..SINHALA ARCHAIC NUMBER ONE THOUSAND
	{0x11200, 0x11211, prAL, gcLo},   //    [18] KHOJKI LETTER A..KHOJKI LETTER JJA
	{0x11213, 0x1122B, prAL, gcLo},   //    [25] KHOJKI LETTER NYA..KHOJKI LETTER LLA
	{0x1122C, 0x1122E, prCM, gcMc},   //     [3] KHOJKI VOWEL SIGN AA..KHOJKI VOWEL SIGN II
	{0x1122F, 0x11231, prCM, gcMn},   //     [3] KHOJKI VOWEL SIGN U..KHOJKI VOWEL SIGN AI
	{0x11232, 0x11233, prCM, gcMc},   //     [2] KHOJKI VOWEL SIGN O..KHOJKI VOWEL SIGN AU
	{0x11234, 0x11234, prCM, gcMn},   //         KHOJKI SIGN ANUSVARA
	{0x11235, 0x11235, prCM, gcMc},   //         KHOJKI SIGN VIRAMA
	{0x11236, 0x11237, prCM, gcMn},   //     [2] KHOJKI SIGN NUKTA..KHOJKI SIGN SHADDA
	{0x11238, 0x11239, prBA, gcPo},   //     [2] KHOJKI DANDA..KHOJKI DOUBLE DANDA
	{0x1123A, 0x1123A, prAL, gcPo},   //         KHOJKI WORD SEPARATOR
	{0x1123B, 0x1123C, prBA, gcPo},   //     [2] KHOJKI SECTION MARK..KHOJKI DOUBLE SECTION MARK
	{0x1123D, 0x1123D, prAL, gcPo},   //         KHOJKI ABBREVIATION SIGN
	{0x1123E, 0x1123E, prCM, gcMn},   //         KHOJKI SIGN SUKUN
	{0x1123F, 0x11240, prAL, gcLo},   //     [2] KHOJKI LETTER QA..KHOJKI LETTER SHORT I
	{0x11241, 0x11241, prCM, gcMn},   //         KHOJKI VOWEL SIGN VOCALIC R
	{0x11280, 0x11286, prAL, gcLo},   //     [7] MULTANI LETTER A..MULTANI LETTER GA
	{0x11288, 0x11288, prAL, gcLo},   //         MULTANI LETTER GHA
	{0x1128A, 0x1128D, prAL, gcLo},   //     [4] MULTANI LETTER CA..MULTANI LETTER JJA
	{0x1128F, 0x1129D, prAL, gcLo},   //    [15] MULTANI LETTER NYA..MULTANI LETTER BA
	{0x1129F, 0x112A8, prAL, gcLo},   //    [10] MULTANI LETTER BHA..MULTANI LETTER RHA
	{0x112A9, 0x112A9, prBA, gcPo},   //         MULTANI SECTION MARK
	{0x112B0, 0x112DE, prAL, gcLo},   //    [47] KHUDAWADI LETTER A..KHUDAWADI LETTER HA
	{0x112DF, 0x112DF, prCM, gcMn},   //         KHUDAWADI SIGN ANUSVARA
	{0x112E0, 0x112E2, prCM, gcMc},   //     [3] KHUDAWADI VOWEL SIGN AA..KHUDAWADI VOWEL SIGN II
	{0x112E3, 0x112EA, prCM, gcMn},   //     [8] KHUDAWADI VOWEL SIGN U..KHUDAWADI SIGN VIRAMA
	{0x112F0, 0x112F9, prNU, gcNd},   //    [10] KHUDAWADI DIGIT ZERO..KHUDAWADI DIGIT NINE
	{0x11300, 0x11301, prCM, gcMn},   //     [2] GRANTHA SIGN COMBINING ANUSVARA ABOVE..GRANTHA SIGN CANDRABINDU
	{0x11302, 0x11303, prCM, gcMc},   //     [2] GRANTHA SIGN ANUSVARA..GRANTHA SIGN VISARGA
	{0x11305, 0x1130C, prAL, gcLo},   //     [8] GRANTHA LETTER A..GRANTHA LETTER VOCALIC L
	{0x1130F, 0x11310, prAL, gcLo},   //     [2] GRANTHA LETTER EE..GRANTHA LETTER AI
	{0x11313, 0x11328, prAL, gcLo},   //    [22] GRANTHA LETTER OO..GRANTHA LETTER NA
	{0x1132A, 0x11330, prAL, gcLo},   //     [7] GRANTHA LETTER PA..GRANTHA LETTER RA
	{0x11332, 0x11333, prAL, gcLo},   //     [2] GRANTHA LETTER LA..GRANTHA LETTER LLA
	{0x11335, 0x11339, prAL, gcLo},   //     [5] GRANTHA LETTER VA..GRANTHA LETTER HA
	{0x1133B, 0x1133C, prCM, gcMn},   //     [2] COMBINING BINDU BELOW..GRANTHA SIGN NUKTA
	{0x1133D, 0x1133D, prAL, gcLo},   //         GRANTHA SIGN AVAGRAHA
	{0x1133E, 0x1133F, prCM, gcMc},   //     [2] GRANTHA VOWEL SIGN AA..GRANTHA VOWEL SIGN I
	{0x11340, 0x11340, prCM, gcMn},   //         GRANTHA VOWEL SIGN II
	{0x11341, 0x11344, prCM, gcMc},   //     [4] GRANTHA VOWEL SIGN U..GRANTHA VOWEL SIGN VOCALIC RR
	{0x11347, 0x11348, prCM, gcMc},   //     [2] GRANTHA VOWEL SIGN EE..GRANTHA VOWEL SIGN AI
	{0x1134B, 0x1134D, prCM, gcMc},   //     [3] GRANTHA VOWEL SIGN OO..GRANTHA SIGN VIRAMA
	{0x11350, 0x11350, prAL, gcLo},   //         GRANTHA OM
	{0x11357, 0x11357, prCM, gcMc},   //         GRANTHA AU LENGTH MARK
	{0x1135D, 0x11361, prAL, gcLo},   //     [5] GRANTHA SIGN PLUTA..GRANTHA LETTER VOCALIC LL
	{0x11362, 0x11363, prCM, gcMc},   //     [2] GRANTHA VOWEL SIGN VOCALIC L..GRANTHA VOWEL SIGN VOCALIC LL
	{0x11366, 0x1136C, prCM, gcMn},   //     [7] COMBINING GRANTHA DIGIT ZERO..COMBINING GRANTHA DIGIT SIX
	{0x11370, 0x11374, prCM, gcMn},   //     [5] COMBINING GRANTHA LETTER A..COMBINING GRANTHA LETTER PA
	{0x11400, 0x11434, prAL, gcLo},   //    [53] NEWA LETTER A..NEWA LETTER HA
	{0x11435, 0x11437, prCM, gcMc},   //     [3] NEWA VOWEL SIGN AA..NEWA VOWEL SIGN II
	{0x11438, 0x1143F, prCM, gcMn},   //     [8] NEWA VOWEL SIGN U..NEWA VOWEL SIGN AI
	{0x11440, 0x11441, prCM, gcMc},   //     [2] NEWA VOWEL SIGN O..NEWA VOWEL SIGN AU
	{0x11442, 0x11444, prCM, gcMn},   //     [3] NEWA SIGN VIRAMA..NEWA SIGN ANUSVARA
	{0x11445, 0x11445, prCM, gcMc},   //         NEWA SIGN VISARGA
	{0x11446, 0x11446, prCM, gcMn},   //         NEWA SIGN NUKTA
	{0x11447, 0x1144A, prAL, gcLo},   //     [4] NEWA SIGN AVAGRAHA..NEWA SIDDHI
	{0x1144B, 0x1144E, prBA, gcPo},   //     [4] NEWA DANDA..NEWA GAP FILLER
	{0x1144F, 0x1144F, prAL, gcPo},   //         NEWA ABBREVIATION SIGN
	{0x11450, 0x11459, prNU, gcNd},   //    [10] NEWA DIGIT ZERO..NEWA DIGIT NINE
	{0x1145A, 0x1145B, prBA, gcPo},   //     [2] NEWA DOUBLE COMMA..NEWA PLACEHOLDER MARK
	{0x1145D, 0x1145D, prAL, gcPo},   //         NEWA INSERTION SIGN
	{0x1145E, 0x1145E, prCM, gcMn},   //         NEWA SANDHI MARK
	{0x1145F, 0x11461, prAL, gcLo},   //     [3] NEWA LETTER VEDIC ANUSVARA..NEWA SIGN UPADHMANIYA
	{0x11480, 0x114AF, prAL, gcLo},   //    [48] TIRHUTA ANJI..TIRHUTA LETTER HA
	{0x114B0, 0x114B2, prCM, gcMc},   //     [3] TIRHUTA VOWEL SIGN AA..TIRHUTA VOWEL SIGN II
	{0x114B3, 0x114B8, prCM, gcMn},   //     [6] TIRHUTA VOWEL SIGN U..TIRHUTA VOWEL SIGN VOCALIC LL
	{0x114B9, 0x114B9, prCM, gcMc},   //         TIRHUTA VOWEL SIGN E
	{0x114BA, 0x114BA, prCM, gcMn},   //         TIRHUTA VOWEL SIGN SHORT E
	{0x114BB, 0x114BE, prCM, gcMc},   //     [4] TIRHUTA VOWEL SIGN AI..TIRHUTA VOWEL SIGN AU
	{0x114BF, 0x114C0, prCM, gcMn},   //     [2] TIRHUTA SIGN CANDRABINDU..TIRHUTA SIGN ANUSVARA
	{0x114C1, 0x114C1, prCM, gcMc},   //         TIRHUTA SIGN VISARGA
	{0x114C2, 0x114C3, prCM, gcMn},   //     [2] TIRHUTA SIGN VIRAMA..TIRHUTA SIGN NUKTA
	{0x114C4, 0x114C5, prAL, gcLo},   //     [2] TIRHUTA SIGN AVAGRAHA..TIRHUTA GVANG
	{0x114C6, 0x114C6, prAL, gcPo},   //         TIRHUTA ABBREVIATION SIGN
	{0x114C7, 0x114C7, prAL, gcLo},   //         TIRHUTA OM
	{0x114D0, 0x114D9, prNU, gcNd},   //    [10] TIRHUTA DIGIT ZERO..TIRHUTA DIGIT NINE
	{0x11580, 0x115AE, prAL, gcLo},   //    [47] SIDDHAM LETTER A..SIDDHAM LETTER HA
	{0x115AF, 0x115B1, prCM, gcMc},   //     [3] SIDDHAM VOWEL SIGN AA..SIDDHAM VOWEL SIGN II
	{0x115B2, 0x115B5, prCM, gcMn},   //     [4] SIDDHAM VOWEL SIGN U..SIDDHAM VOWEL SIGN VOCALIC RR
	{0x115B8, 0x115BB, prCM, gcMc},   //     [4] SIDDHAM VOWEL SIGN E..SIDDHAM VOWEL SIGN AU
	{0x115BC, 0x115BD, prCM, gcMn},   //     [2] SIDDHAM SIGN CANDRABINDU..SIDDHAM SIGN ANUSVARA
	{0x115BE, 0x115BE, prCM, gcMc},   //         SIDDHAM SIGN VISARGA
	{0x115BF, 0x115C0, prCM, gcMn},   //     [2] SIDDHAM SIGN VIRAMA..SIDDHAM SIGN NUKTA
	{0x115C1, 0x115C1, prBB, gcPo},   //         SIDDHAM SIGN SIDDHAM
	{0x115C2, 0x115C3, prBA, gcPo},   //     [2] SIDDHAM DANDA..SIDDHAM DOUBLE DANDA
	{0x115C4, 0x115C5, prEX, gcPo},   //     [2] SIDDHAM SEPARATOR DOT..SIDDHAM SEPARATOR BAR
	{0x115C6, 0x115C8, prAL, gcPo},   //     [3] SIDDHAM REPETITION MARK-1..SIDDHAM REPETITION MARK-3
	{0x115C9, 0x115D7, prBA, gcPo},   //    [15] SIDDHAM END OF TEXT MARK..SIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURES
	{0x115D8, 0x115DB, prAL, gcLo},   //     [4] SIDDHAM LETTER THREE-CIRCLE ALTERNATE I..SIDDHAM LETTER ALTERNATE U
	{0x115DC, 0x115DD, prCM, gcMn},   //     [2] SIDDHAM VOWEL SIGN ALTERNATE U..SIDDHAM VOWEL SIGN ALTERNATE UU
	{0x11600, 0x1162F, prAL, gcLo},   //    [48] MODI LETTER A..MODI LETTER LLA
	{0x11630, 0x11632, prCM, gcMc},   //     [3] MODI VOWEL SIGN AA..MODI VOWEL SIGN II
	{0x11633, 0x1163A, prCM, gcMn},   //     [8] MODI VOWEL SIGN U..MODI VOWEL SIGN AI
	{0x1163B, 0x1163C, prCM, gcMc},   //     [2] MODI VOWEL SIGN O..MODI VOWEL SIGN AU
	{0x1163D, 0x1163D, prCM, gcMn},   //         MODI SIGN ANUSVARA
	{0x1163E, 0x1163E, prCM, gcMc},   //         MODI SIGN VISARGA
	{0x1163F, 0x11640, prCM, gcMn},   //     [2] MODI SIGN VIRAMA..MODI SIGN ARDHACANDRA
	{0x11641, 0x11642, prBA, gcPo},   //     [2] MODI DANDA..MODI DOUBLE DANDA
	{0x11643, 0x11643, prAL, gcPo},   //         MODI ABBREVIATION SIGN
	{0x11644, 0x11644, prAL, gcLo},   //         MODI SIGN HUVA
	{0x11650, 0x11659, prNU, gcNd},   //    [10] MODI DIGIT ZERO..MODI DIGIT NINE
	{0x11660, 0x1166C, prBB, gcPo},   //    [13] MONGOLIAN BIRGA WITH ORNAMENT..MONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENT
	{0x11680, 0x116AA, prAL, gcLo},   //    [43] TAKRI LETTER A..TAKRI LETTER RRA
	{0x116AB, 0x116AB, prCM, gcMn},   //         TAKRI SIGN ANUSVARA
	{0x116AC, 0x116AC, prCM, gcMc},   //         TAKRI SIGN VISARGA
	{0x116AD, 0x116AD, prCM, gcMn},   //         TAKRI VOWEL SIGN AA
	{0x116AE, 0x116AF, prCM, gcMc},   //     [2] TAKRI VOWEL SIGN I..TAKRI VOWEL SIGN II
	{0x116B0, 0x116B5, prCM, gcMn},   //     [6] TAKRI VOWEL SIGN U..TAKRI VOWEL SIGN AU
	{0x116B6, 0x116B6, prCM, gcMc},   //         TAKRI SIGN VIRAMA
	{0x116B7, 0x116B7, prCM, gcMn},   //         TAKRI SIGN NUKTA
	{0x116B8, 0x116B8, prAL, gcLo},   //         TAKRI LETTER ARCHAIC KHA
	{0x116B9, 0x116B9, prAL, gcPo},   //         TAKRI ABBREVIATION SIGN
	{0x116C0, 0x116C9, prNU, gcNd},   //    [10] TAKRI DIGIT ZERO..TAKRI DIGIT NINE
	{0x11700, 0x1171A, prSA, gcLo},   //    [27] AHOM LETTER KA..AHOM LETTER ALTERNATE BA
	{0x1171D, 0x1171F, prSA, gcMn},   //     [3] AHOM CONSONANT SIGN MEDIAL LA..AHOM CONSONANT SIGN MEDIAL LIGATING RA
	{0x11720, 0x11721, prSA, gcMc},   //     [2] AHOM VOWEL SIGN A..AHOM VOWEL SIGN AA
	{0x11722, 0x11725, prSA, gcMn},   //     [4] AHOM VOWEL SIGN I..AHOM VOWEL SIGN UU
	{0x11726, 0x11726, prSA, gcMc},   //         AHOM VOWEL SIGN E
	{0x11727, 0x1172B, prSA, gcMn},   //     [5] AHOM VOWEL SIGN AW..AHOM SIGN KILLER
	{0x11730, 0x11739, prNU, gcNd},   //    [10] AHOM DIGIT ZERO..AHOM DIGIT NINE
	{0x1173A, 0x1173B, prSA, gcNo},   //     [2] AHOM NUMBER TEN..AHOM NUMBER TWENTY
	{0x1173C, 0x1173E, prBA, gcPo},   //     [3] AHOM SIGN SMALL SECTION..AHOM SIGN RULAI
	{0x1173F, 0x1173F, prSA, gcSo},   //         AHOM SYMBOL VI
	{0x11740, 0x11746, prSA, gcLo},   //     [7] AHOM LETTER CA..AHOM LETTER LLA
	{0x11800, 0x1182B, prAL, gcLo},   //    [44] DOGRA LETTER A..DOGRA LETTER RRA
	{0x1182C, 0x1182E, prCM, gcMc},   //     [3] DOGRA VOWEL SIGN AA..DOGRA VOWEL SIGN II
	{0x1182F, 0x11837, prCM, gcMn},   //     [9] DOGRA VOWEL SIGN U..DOGRA SIGN ANUSVARA
	{0x11838, 0x11838, prCM, gcMc},   //         DOGRA SIGN VISARGA
	{0x11839, 0x1183A, prCM, gcMn},   //     [2] DOGRA SIGN VIRAMA..DOGRA SIGN NUKTA
	{0x1183B, 0x1183B, prAL, gcPo},   //         DOGRA ABBREVIATION SIGN
	{0x118A0, 0x118DF, prAL, gcLC},   //    [64] WARANG CITI CAPITAL LETTER NGAA..WARANG CITI SMALL LETTER VIYO
	{0x118E0, 0x118E9, prNU, gcNd},   //    [10] WARANG CITI DIGIT ZERO..WARANG CITI DIGIT NINE
	{0x118EA, 0x118F2, prAL, gcNo},   //     [9] WARANG CITI NUMBER TEN..WARANG CITI NUMBER NINETY
	{0x118FF, 0x118FF, prAL, gcLo},   //         WARANG CITI OM
	{0x11900, 0x11906, prAL, gcLo},   //     [7] DIVES AKURU LETTER A..DIVES AKURU LETTER E
	{0x11909, 0x11909, prAL, gcLo},   //         DIVES AKURU LETTER O
	{0x1190C, 0x11913, prAL, gcLo},   //     [8] DIVES AKURU LETTER KA..DIVES AKURU LETTER JA
	{0x11915, 0x11916, prAL, gcLo},   //     [2] DIVES AKURU LETTER NYA..DIVES AKURU LETTER TTA
	{0x11918, 0x1192F, prAL, gcLo},   //    [24] DIVES AKURU LETTER DDA..DIVES AKURU LETTER ZA
	{0x11930, 0x11935, prCM, gcMc},   //     [6] DIVES AKURU VOWEL SIGN AA..DIVES AKURU VOWEL SIGN E
	{0x11937, 0x11938, prCM, gcMc},   //     [2] DIVES AKURU VOWEL SIGN AI..DIVES AKURU VOWEL SIGN O
	{0x1193B, 0x1193C, prCM, gcMn},   //     [2] DIVES AKURU SIGN ANUSVARA..DIVES AKURU SIGN CANDRABINDU
	{0x1193D, 0x1193D, prCM, gcMc},   //         DIVES AKURU SIGN HALANTA
	{0x1193E, 0x1193E, prCM, gcMn},   //         DIVES AKURU VIRAMA
	{0x1193F, 0x1193F, prAL, gcLo},   //         DIVES AKURU PREFIXED NASAL SIGN
	{0x11940, 0x11940, prCM, gcMc},   //         DIVES AKURU MEDIAL YA
	{0x11941, 0x11941, prAL, gcLo},   //         DIVES AKURU INITIAL RA
	{0x11942, 0x11942, prCM, gcMc},   //         DIVES AKURU MEDIAL RA
	{0x11943, 0x11943, prCM, gcMn},   //         DIVES AKURU SIGN NUKTA
	{0x11944, 0x11946, prBA, gcPo},   //     [3] DIVES AKURU DOUBLE DANDA..DIVES AKURU END OF TEXT MARK
	{0x11950, 0x11959, prNU, gcNd},   //    [10] DIVES AKURU DIGIT ZERO..DIVES AKURU DIGIT NINE
	{0x119A0, 0x119A7, prAL, gcLo},   //     [8] NANDINAGARI LETTER A..NANDINAGARI LETTER VOCALIC RR
	{0x119AA, 0x119D0, prAL, gcLo},   //    [39] NANDINAGARI LETTER E..NANDINAGARI LETTER RRA
	{0x119D1, 0x119D3, prCM, gcMc},   //     [3] NANDINAGARI VOWEL SIGN AA..NANDINAGARI VOWEL SIGN II
	{0x119D4, 0x119D7, prCM, gcMn},   //     [4] NANDINAGARI VOWEL SIGN U..NANDINAGARI VOWEL SIGN VOCALIC RR
	{0x119DA, 0x119DB, prCM, gcMn},   //     [2] NANDINAGARI VOWEL SIGN E..NANDINAGARI VOWEL SIGN AI
	{0x119DC, 0x119DF, prCM, gcMc},   //     [4] NANDINAGARI VOWEL SIGN O..NANDINAGARI SIGN VISARGA
	{0x119E0, 0x119E0, prCM, gcMn},   //         NANDINAGARI SIGN VIRAMA
	{0x119E1, 0x119E1, prAL, gcLo},   //         NANDINAGARI SIGN AVAGRAHA
	{0x119E2, 0x119E2, prBB, gcPo},   //         NANDINAGARI SIGN SIDDHAM
	{0x119E3, 0x119E3, prAL, gcLo},   //         NANDINAGARI HEADSTROKE
	{0x119E4, 0x119E4, prCM, gcMc},   //         NANDINAGARI VOWEL SIGN PRISHTHAMATRA E
	{0x11A00, 0x11A00, prAL, gcLo},   //         ZANABAZAR SQUARE LETTER A
	{0x11A01, 0x11A0A, prCM, gcMn},   //    [10] ZANABAZAR SQUARE VOWEL SIGN I..ZANABAZAR SQUARE VOWEL LENGTH MARK
	{0x11A0B, 0x11A32, prAL, gcLo},   //    [40] ZANABAZAR SQUARE LETTER KA..ZANABAZAR SQUARE LETTER KSSA
	{0x11A33, 0x11A38, prCM, gcMn},   //     [6] ZANABAZAR SQUARE FINAL CONSONANT MARK..ZANABAZAR SQUARE SIGN ANUSVARA
	{0x11A39, 0x11A39, prCM, gcMc},   //         ZANABAZAR SQUARE SIGN VISARGA
	{0x11A3A, 0x11A3A, prAL, gcLo},   //         ZANABAZAR SQUARE CLUSTER-INITIAL LETTER RA
	{0x11A3B, 0x11A3E, prCM, gcMn},   //     [4] ZANABAZAR SQUARE CLUSTER-FINAL LETTER YA..ZANABAZAR SQUARE CLUSTER-FINAL LETTER VA
	{0x11A3F, 0x11A3F, prBB, gcPo},   //         ZANABAZAR SQUARE INITIAL HEAD MARK
	{0x11A40, 0x11A40, prAL, gcPo},   //         ZANABAZAR SQUARE CLOSING HEAD MARK
	{0x11A41, 0x11A44, prBA, gcPo},   //     [4] ZANABAZAR SQUARE MARK TSHEG..ZANABAZAR SQUARE MARK LONG TSHEG
	{0x11A45, 0x11A45, prBB, gcPo},   //         ZANABAZAR SQUARE INITIAL DOUBLE-LINED HEAD MARK
	{0x11A46, 0x11A46, prAL, gcPo},   //         ZANABAZAR SQUARE CLOSING DOUBLE-LINED HEAD MARK
	{0x11A47, 0x11A47, prCM, gcMn},   //         ZANABAZAR SQUARE SUBJOINER
	{0x11A50, 0x11A50, prAL, gcLo},   //         SOYOMBO LETTER A
	{0x11A51, 0x11A56, prCM, gcMn},   //     [6] SOYOMBO VOWEL SIGN I..SOYOMBO VOWEL SIGN OE
	{0x11A57, 0x11A58, prCM, gcMc},   //     [2] SOYOMBO VOWEL SIGN AI..SOYOMBO VOWEL SIGN AU
	{0x11A59, 0x11A5B, prCM, gcMn},   //     [3] SOYOMBO VOWEL SIGN VOCALIC R..SOYOMBO VOWEL LENGTH MARK
	{0x11A5C, 0x11A89, prAL, gcLo},   //    [46] SOYOMBO LETTER KA..SOYOMBO CLUSTER-INITIAL LETTER SA
	{0x11A8A, 0x11A96, prCM, gcMn},   //    [13] SOYOMBO FINAL CONSONANT SIGN G..SOYOMBO SIGN ANUSVARA
	{0x11A97, 0x11A97, prCM, gcMc},   //         SOYOMBO SIGN VISARGA
	{0x11A98, 0x11A99, prCM, gcMn},   //     [2] SOYOMBO GEMINATION MARK..SOYOMBO SUBJOINER
	{0x11A9A, 0x11A9C, prBA, gcPo},   //     [3] SOYOMBO MARK TSHEG..SOYOMBO MARK DOUBLE SHAD
	{0x11A9D, 0x11A9D, prAL, gcLo},   //         SOYOMBO MARK PLUTA
	{0x11A9E, 0x11AA0, prBB, gcPo},   //     [3] SOYOMBO HEAD MARK WITH MOON AND SUN AND TRIPLE FLAME..SOYOMBO HEAD MARK WITH MOON AND SUN
	{0x11AA1, 0x11AA2, prBA, gcPo},   //     [2] SOYOMBO TERMINAL MARK-1..SOYOMBO TERMINAL MARK-2
	{0x11AB0, 0x11ABF, prAL, gcLo},   //    [16] CANADIAN SYLLABICS NATTILIK HI..CANADIAN SYLLABICS SPA
	{0x11AC0, 0x11AF8, prAL, gcLo},   //    [57] PAU CIN HAU LETTER PA..PAU CIN HAU GLOTTAL STOP FINAL
	{0x11B00, 0x11B09, prBB, gcPo},   //    [10] DEVANAGARI HEAD MARK..DEVANAGARI SIGN MINDU
	{0x11C00, 0x11C08, prAL, gcLo},   //     [9] BHAIKSUKI LETTER A..BHAIKSUKI LETTER VOCALIC L
	{0x11C0A, 0x11C2E, prAL, gcLo},   //    [37] BHAIKSUKI LETTER E..BHAIKSUKI LETTER HA
	{0x11C2F, 0x11C2F, prCM, gcMc},   //         BHAIKSUKI VOWEL SIGN AA
	{0x11C30, 0x11C36, prCM, gcMn},   //     [7] BHAIKSUKI VOWEL SIGN I..BHAIKSUKI VOWEL SIGN VOCALIC L
	{0x11C38, 0x11C3D, prCM, gcMn},   //     [6] BHAIKSUKI VOWEL SIGN E..BHAIKSUKI SIGN ANUSVARA
	{0x11C3E, 0x11C3E, prCM, gcMc},   //         BHAIKSUKI SIGN VISARGA
	{0x11C3F, 0x11C3F, prCM, gcMn},   //         BHAIKSUKI SIGN VIRAMA
	{0x11C40, 0x11C40, prAL, gcLo},   //         BHAIKSUKI SIGN AVAGRAHA
	{0x11C41, 0x11C45, prBA, gcPo},   //     [5] BHAIKSUKI DANDA..BHAIKSUKI GAP FILLER-2
	{0x11C50, 0x11C59, prNU, gcNd},   //    [10] BHAIKSUKI DIGIT ZERO..BHAIKSUKI DIGIT NINE
	{0x11C5A, 0x11C6C, prAL, gcNo},   //    [19] BHAIKSUKI NUMBER ONE..BHAIKSUKI HUNDREDS UNIT MARK
	{0x11C70, 0x11C70, prBB, gcPo},   //         MARCHEN HEAD MARK
	{0x11C71, 0x11C71, prEX, gcPo},   //         MARCHEN MARK SHAD
	{0x11C72, 0x11C8F, prAL, gcLo},   //    [30] MARCHEN LETTER KA..MARCHEN LETTER A
	{0x11C92, 0x11CA7, prCM, gcMn},   //    [22] MARCHEN SUBJOINED LETTER KA..MARCHEN SUBJOINED LETTER ZA
	{0x11CA9, 0x11CA9, prCM, gcMc},   //         MARCHEN SUBJOINED LETTER YA
	{0x11CAA, 0x11CB0, prCM, gcMn},   //     [7] MARCHEN SUBJOINED LETTER RA..MARCHEN VOWEL SIGN AA
	{0x11CB1, 0x11CB1, prCM, gcMc},   //         MARCHEN VOWEL SIGN I
	{0x11CB2, 0x11CB3, prCM, gcMn},   //     [2] MARCHEN VOWEL SIGN U..MARCHEN VOWEL SIGN E
	{0x11CB4, 0x11CB4, prCM, gcMc},   //         MARCHEN VOWEL SIGN O
	{0x11CB5, 0x11CB6, prCM, gcMn},   //     [2] MARCHEN SIGN ANUSVARA..MARCHEN SIGN CANDRABINDU
	{0x11D00, 0x11D06, prAL, gcLo},   //     [7] MASARAM GONDI LETTER A..MASARAM GONDI LETTER E
	{0x11D08, 0x11D09, prAL, gcLo},   //     [2] MASARAM GONDI LETTER AI..MASARAM GONDI LETTER O
	{0x11D0B, 0x11D30, prAL, gcLo},   //    [38] MASARAM GONDI LETTER AU..MASARAM GONDI LETTER TRA
	{0x11D31, 0x11D36, prCM, gcMn},   //     [6] MASARAM GONDI VOWEL SIGN AA..MASARAM GONDI VOWEL SIGN VOCALIC R
	{0x11D3A, 0x11D3A, prCM, gcMn},   //         MASARAM GONDI VOWEL SIGN E
	{0x11D3C, 0x11D3D, prCM, gcMn},   //     [2] MASARAM GONDI VOWEL SIGN AI..MASARAM GONDI VOWEL SIGN O
	{0x11D3F, 0x11D45, prCM, gcMn},   //     [7] MASARAM GONDI VOWEL SIGN AU..MASARAM GONDI VIRAMA
	{0x11D46, 0x11D46, prAL, gcLo},   //         MASARAM GONDI REPHA
	{0x11D47, 0x11D47, prCM, gcMn},   //         MASARAM GONDI RA-KARA
	{0x11D50, 0x11D59, prNU, gcNd},   //    [10] MASARAM GONDI DIGIT ZERO..MASARAM GONDI DIGIT NINE
	{0x11D60, 0x11D65, prAL, gcLo},   //     [6] GUNJALA GONDI LETTER A..GUNJALA GONDI LETTER UU
	{0x11D67, 0x11D68, prAL, gcLo},   //     [2] GUNJALA GONDI LETTER EE..GUNJALA GONDI LETTER AI
	{0x11D6A, 0x11D89, prAL, gcLo},   //    [32] GUNJALA GONDI LETTER OO..GUNJALA GONDI LETTER SA
	{0x11D8A, 0x11D8E, prCM, gcMc},   //     [5] GUNJALA GONDI VOWEL SIGN AA..GUNJALA GONDI VOWEL SIGN UU
	{0x11D90, 0x11D91, prCM, gcMn},   //     [2] GUNJALA GONDI VOWEL SIGN EE..GUNJALA GONDI VOWEL SIGN AI
	{0x11D93, 0x11D94, prCM, gcMc},   //     [2] GUNJALA GONDI VOWEL SIGN OO..GUNJALA GONDI VOWEL SIGN AU
	{0x11D95, 0x11D95, prCM, gcMn},   //         GUNJALA GONDI SIGN ANUSVARA
	{0x11D96, 0x11D96, prCM, gcMc},   //         GUNJALA GONDI SIGN VISARGA
	{0x11D97, 0x11D97, prCM, gcMn},   //         GUNJALA GONDI VIRAMA
	{0x11D98, 0x11D98, prAL, gcLo},   //         GUNJALA GONDI OM
	{0x11DA0, 0x11DA9, prNU, gcNd},   //    [10] GUNJALA GONDI DIGIT ZERO..GUNJALA GONDI DIGIT NINE
	{0x11EE0, 0x11EF2, prAL, gcLo},   //    [19] MAKASAR LETTER KA..MAKASAR ANGKA
	{0x11EF3, 0x11EF4, prCM, gcMn},   //     [2] MAKASAR VOWEL SIGN I..MAKASAR VOWEL SIGN U
	{0x11EF5, 0x11EF6, prCM, gcMc},   //     [2] MAKASAR VOWEL SIGN E..MAKASAR VOWEL SIGN O
	{0x11EF7, 0x11EF8, prAL, gcPo},   //     [2] MAKASAR PASSIMBANG..MAKASAR END OF SECTION
	{0x11F00, 0x11F01, prCM, gcMn},   //     [2] KAWI SIGN CANDRABINDU..KAWI SIGN ANUSVARA
	{0x11F02, 0x11F02, prAL, gcLo},   //         KAWI SIGN REPHA
	{0x11F03, 0x11F03, prCM, gcMc},   //         KAWI SIGN VISARGA
	{0x11F04, 0x11F10, prAL, gcLo},   //    [13] KAWI LETTER A..KAWI LETTER O
	{0x11F12, 0x11F33, prAL, gcLo},   //    [34] KAWI LETTER KA..KAWI LETTER JNYA
	{0x11F34, 0x11F35, prCM, gcMc},   //     [2] KAWI VOWEL SIGN AA..KAWI VOWEL SIGN ALTERNATE AA
	{0x11F36, 0x11F3A, prCM, gcMn},   //     [5] KAWI VOWEL SIGN I..KAWI VOWEL SIGN VOCALIC R
	{0x11F3E, 0x11F3F, prCM, gcMc},   //     [2] KAWI VOWEL SIGN E..KAWI VOWEL SIGN AI
	{0x11F40, 0x11F40, prCM, gcMn},   //         KAWI VOWEL SIGN EU
	{0x11F41, 0x11F41, prCM, gcMc},   //         KAWI SIGN KILLER
	{0x11F42, 0x11F42, prCM, gcMn},   //         KAWI CONJOINER
	{0x11F43, 0x11F44, prBA, gcPo},   //     [2] KAWI DANDA..KAWI DOUBLE DANDA
	{0x11F45, 0x11F4F, prID, gcPo},   //    [11] KAWI PUNCTUATION SECTION MARKER..KAWI PUNCTUATION CLOSING SPIRAL
	{0x11F50, 0x11F59, prNU, gcNd},   //    [10] KAWI DIGIT ZERO..KAWI DIGIT NINE
	{0x11FB0, 0x11FB0, prAL, gcLo},   //         LISU LETTER YHA
	{0x11FC0, 0x11FD4, prAL, gcNo},   //    [21] TAMIL FRACTION ONE THREE-HUNDRED-AND-TWENTIETH..TAMIL FRACTION DOWNSCALING FACTOR KIIZH
	{0x11FD5, 0x11FDC, prAL, gcSo},   //     [8] TAMIL SIGN NEL..TAMIL SIGN MUKKURUNI
	{0x11FDD, 0x11FE0, prPO, gcSc},   //     [4] TAMIL SIGN KAACU..TAMIL SIGN VARAAKAN
	{0x11FE1, 0x11FF1, prAL, gcSo},   //    [17] TAMIL SIGN PAARAM..TAMIL SIGN VAKAIYARAA
	{0x11FFF, 0x11FFF, prBA, gcPo},   //         TAMIL PUNCTUATION END OF TEXT
	{0x12000, 0x12399, prAL, gcLo},   //   [922] CUNEIFORM SIGN A..CUNEIFORM SIGN U U
	{0x12400, 0x1246E, prAL, gcNl},   //   [111] CUNEIFORM NUMERIC SIGN TWO ASH..CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM
	{0x12470, 0x12474, prBA, gcPo},   //     [5] CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER..CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLON
	{0x12480, 0x12543, prAL, gcLo},   //   [196] CUNEIFORM SIGN AB TIMES NUN TENU..CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU
	{0x12F90, 0x12FF0, prAL, gcLo},   //    [97] CYPRO-MINOAN SIGN CM001..CYPRO-MINOAN SIGN CM114
	{0x12FF1, 0x12FF2, prAL, gcPo},   //     [2] CYPRO-MINOAN SIGN CM301..CYPRO-MINOAN SIGN CM302
	{0x13000, 0x13257, prAL, gcLo},   //   [600] EGYPTIAN HIEROGLYPH A001..EGYPTIAN HIEROGLYPH O006
	{0x13258, 0x1325A, prOP, gcLo},   //     [3] EGYPTIAN HIEROGLYPH O006A..EGYPTIAN HIEROGLYPH O006C
	{0x1325B, 0x1325D, prCL, gcLo},   //     [3] EGYPTIAN HIEROGLYPH O006D..EGYPTIAN HIEROGLYPH O006F
	{0x1325E, 0x13281, prAL, gcLo},   //    [36] EGYPTIAN HIEROGLYPH O007..EGYPTIAN HIEROGLYPH O033
	{0x13282, 0x13282, prCL, gcLo},   //         EGYPTIAN HIEROGLYPH O033A
	{0x13283, 0x13285, prAL, gcLo},   //     [3] EGYPTIAN HIEROGLYPH O034..EGYPTIAN HIEROGLYPH O036
	{0x13286, 0x13286, prOP, gcLo},   //         EGYPTIAN HIEROGLYPH O036A
	{0x13287, 0x13287, prCL, gcLo},   //         EGYPTIAN HIEROGLYPH O036B
	{0x13288, 0x13288, prOP, gcLo},   //         EGYPTIAN HIEROGLYPH O036C
	{0x13289, 0x13289, prCL, gcLo},   //         EGYPTIAN HIEROGLYPH O036D
	{0x1328A, 0x13378, prAL, gcLo},   //   [239] EGYPTIAN HIEROGLYPH O037..EGYPTIAN HIEROGLYPH V011
	{0x13379, 0x13379, prOP, gcLo},   //         EGYPTIAN HIEROGLYPH V011A
	{0x1337A, 0x1337B, prCL, gcLo},   //     [2] EGYPTIAN HIEROGLYPH V011B..EGYPTIAN HIEROGLYPH V011C
	{0x1337C, 0x1342F, prAL, gcLo},   //   [180] EGYPTIAN HIEROGLYPH V012..EGYPTIAN HIEROGLYPH V011D
	{0x13430, 0x13436, prGL, gcCf},   //     [7] EGYPTIAN HIEROGLYPH VERTICAL JOINER..EGYPTIAN HIEROGLYPH OVERLAY MIDDLE
	{0x13437, 0x13437, prOP, gcCf},   //         EGYPTIAN HIEROGLYPH BEGIN SEGMENT
	{0x13438, 0x13438, prCL, gcCf},   //         EGYPTIAN HIEROGLYPH END SEGMENT
	{0x13439, 0x1343B, prGL, gcCf},   //     [3] EGYPTIAN HIEROGLYPH INSERT AT MIDDLE..EGYPTIAN HIEROGLYPH INSERT AT BOTTOM
	{0x1343C, 0x1343C, prOP, gcCf},   //         EGYPTIAN HIEROGLYPH BEGIN ENCLOSURE
	{0x1343D, 0x1343D, prCL, gcCf},   //         EGYPTIAN HIEROGLYPH END ENCLOSURE
	{0x1343E, 0x1343E, prOP, gcCf},   //         EGYPTIAN HIEROGLYPH BEGIN WALLED ENCLOSURE
	{0x1343F, 0x1343F, prCL, gcCf},   //         EGYPTIAN HIEROGLYPH END WALLED ENCLOSURE
	{0x13440, 0x13440, prCM, gcMn},   //         EGYPTIAN HIEROGLYPH MIRROR HORIZONTALLY
	{0x13441, 0x13446, prAL, gcLo},   //     [6] EGYPTIAN HIEROGLYPH FULL BLANK..EGYPTIAN HIEROGLYPH WIDE LOST SIGN
	{0x13447, 0x13455, prCM, gcMn},   //    [15] EGYPTIAN HIEROGLYPH MODIFIER DAMAGED AT TOP START..EGYPTIAN HIEROGLYPH MODIFIER DAMAGED
	{0x14400, 0x145CD, prAL, gcLo},   //   [462] ANATOLIAN HIEROGLYPH A001..ANATOLIAN HIEROGLYPH A409
	{0x145CE, 0x145CE, prOP, gcLo},   //         ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARK
	{0x145CF, 0x145CF, prCL, gcLo},   //         ANATOLIAN HIEROGLYPH A410A END LOGOGRAM MARK
	{0x145D0, 0x14646, prAL, gcLo},   //   [119] ANATOLIAN HIEROGLYPH A411..ANATOLIAN HIEROGLYPH A530
	{0x16800, 0x16A38, prAL, gcLo},   //   [569] BAMUM LETTER PHASE-A NGKUE MFON..BAMUM LETTER PHASE-F VUEQ
	{0x16A40, 0x16A5E, prAL, gcLo},   //    [31] MRO LETTER TA..MRO LETTER TEK
	{0x16A60, 0x16A69, prNU, gcNd},   //    [10] MRO DIGIT ZERO..MRO DIGIT NINE
	{0x16A6E, 0x16A6F, prBA, gcPo},   //     [2] MRO DANDA..MRO DOUBLE DANDA
	{0x16A70, 0x16ABE, prAL, gcLo},   //    [79] TANGSA LETTER OZ..TANGSA LETTER ZA
	{0x16AC0, 0x16AC9, prNU, gcNd},   //    [10] TANGSA DIGIT ZERO..TANGSA DIGIT NINE
	{0x16AD0, 0x16AED, prAL, gcLo},   //    [30] BASSA VAH LETTER ENNI..BASSA VAH LETTER I
	{0x16AF0, 0x16AF4, prCM, gcMn},   //     [5] BASSA VAH COMBINING HIGH TONE..BASSA VAH COMBINING HIGH-LOW TONE
	{0x16AF5, 0x16AF5, prBA, gcPo},   //         BASSA VAH FULL STOP
	{0x16B00, 0x16B2F, prAL, gcLo},   //    [48] PAHAWH HMONG VOWEL KEEB..PAHAWH HMONG CONSONANT CAU
	{0x16B30, 0x16B36, prCM, gcMn},   //     [7] PAHAWH HMONG MARK CIM TUB..PAHAWH HMONG MARK CIM TAUM
	{0x16B37, 0x16B39, prBA, gcPo},   //     [3] PAHAWH HMONG SIGN VOS THOM..PAHAWH HMONG SIGN CIM CHEEM
	{0x16B3A, 0x16B3B, prAL, gcPo},   //     [2] PAHAWH HMONG SIGN VOS THIAB..PAHAWH HMONG SIGN VOS FEEM
	{0x16B3C, 0x16B3F, prAL, gcSo},   //     [4] PAHAWH HMONG SIGN XYEEM NTXIV..PAHAWH HMONG SIGN XYEEM FAIB
	{0x16B40, 0x16B43, prAL, gcLm},   //     [4] PAHAWH HMONG SIGN VOS SEEV..PAHAWH HMONG SIGN IB YAM
	{0x16B44, 0x16B44, prBA, gcPo},   //         PAHAWH HMONG SIGN XAUS
	{0x16B45, 0x16B45, prAL, gcSo},   //         PAHAWH HMONG SIGN CIM TSOV ROG
	{0x16B50, 0x16B59, prNU, gcNd},   //    [10] PAHAWH HMONG DIGIT ZERO..PAHAWH HMONG DIGIT NINE
	{0x16B5B, 0x16B61, prAL, gcNo},   //     [7] PAHAWH HMONG NUMBER TENS..PAHAWH HMONG NUMBER TRILLIONS
	{0x16B63, 0x16B77, prAL, gcLo},   //    [21] PAHAWH HMONG SIGN VOS LUB..PAHAWH HMONG SIGN CIM NRES TOS
	{0x16B7D, 0x16B8F, prAL, gcLo},   //    [19] PAHAWH HMONG CLAN SIGN TSHEEJ..PAHAWH HMONG CLAN SIGN VWJ
	{0x16E40, 0x16E7F, prAL, gcLC},   //    [64] MEDEFAIDRIN CAPITAL LETTER M..MEDEFAIDRIN SMALL LETTER Y
	{0x16E80, 0x16E96, prAL, gcNo},   //    [23] MEDEFAIDRIN DIGIT ZERO..MEDEFAIDRIN DIGIT THREE ALTERNATE FORM
	{0x16E97, 0x16E98, prBA, gcPo},   //     [2] MEDEFAIDRIN COMMA..MEDEFAIDRIN FULL STOP
	{0x16E99, 0x16E9A, prAL, gcPo},   //     [2] MEDEFAIDRIN SYMBOL AIVA..MEDEFAIDRIN EXCLAMATION OH
	{0x16F00, 0x16F4A, prAL, gcLo},   //    [75] MIAO LETTER PA..MIAO LETTER RTE
	{0x16F4F, 0x16F4F, prCM, gcMn},   //         MIAO SIGN CONSONANT MODIFIER BAR
	{0x16F50, 0x16F50, prAL, gcLo},   //         MIAO LETTER NASALIZATION
	{0x16F51, 0x16F87, prCM, gcMc},   //    [55] MIAO SIGN ASPIRATION..MIAO VOWEL SIGN UI
	{0x16F8F, 0x16F92, prCM, gcMn},   //     [4] MIAO TONE RIGHT..MIAO TONE BELOW
	{0x16F93, 0x16F9F, prAL, gcLm},   //    [13] MIAO LETTER TONE-2..MIAO LETTER REFORMED TONE-8
	{0x16FE0, 0x16FE1, prNS, gcLm},   //     [2] TANGUT ITERATION MARK..NUSHU ITERATION MARK
	{0x16FE2, 0x16FE2, prNS, gcPo},   //         OLD CHINESE HOOK MARK
	{0x16FE3, 0x16FE3, prNS, gcLm},   //         OLD CHINESE ITERATION MARK
	{0x16FE4, 0x16FE4, prGL, gcMn},   //         KHITAN SMALL SCRIPT FILLER
	{0x16FF0, 0x16FF1, prCM, gcMc},   //     [2] VIETNAMESE ALTERNATE READING MARK CA..VIETNAMESE ALTERNATE READING MARK NHAY
	{0x17000, 0x187F7, prID, gcLo},   //  [6136] TANGUT IDEOGRAPH-17000..TANGUT IDEOGRAPH-187F7
	{0x18800, 0x18AFF, prID, gcLo},   //   [768] TANGUT COMPONENT-001..TANGUT COMPONENT-768
	{0x18B00, 0x18CD5, prAL, gcLo},   //   [470] KHITAN SMALL SCRIPT CHARACTER-18B00..KHITAN SMALL SCRIPT CHARACTER-18CD5
	{0x18D00, 0x18D08, prID, gcLo},   //     [9] TANGUT IDEOGRAPH-18D00..TANGUT IDEOGRAPH-18D08
	{0x1AFF0, 0x1AFF3, prAL, gcLm},   //     [4] KATAKANA LETTER MINNAN TONE-2..KATAKANA LETTER MINNAN TONE-5
	{0x1AFF5, 0x1AFFB, prAL, gcLm},   //     [7] KATAKANA LETTER MINNAN TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-5
	{0x1AFFD, 0x1AFFE, prAL, gcLm},   //     [2] KATAKANA LETTER MINNAN NASALIZED TONE-7..KATAKANA LETTER MINNAN NASALIZED TONE-8
	{0x1B000, 0x1B0FF, prID, gcLo},   //   [256] KATAKANA LETTER ARCHAIC E..HENTAIGANA LETTER RE-2
	{0x1B100, 0x1B122, prID, gcLo},   //    [35] HENTAIGANA LETTER RE-3..KATAKANA LETTER ARCHAIC WU
	{0x1B132, 0x1B132, prCJ, gcLo},   //         HIRAGANA LETTER SMALL KO
	{0x1B150, 0x1B152, prCJ, gcLo},   //     [3] HIRAGANA LETTER SMALL WI..HIRAGANA LETTER SMALL WO
	{0x1B155, 0x1B155, prCJ, gcLo},   //         KATAKANA LETTER SMALL KO
	{0x1B164, 0x1B167, prCJ, gcLo},   //     [4] KATAKANA LETTER SMALL WI..KATAKANA LETTER SMALL N
	{0x1B170, 0x1B2FB, prID, gcLo},   //   [396] NUSHU CHARACTER-1B170..NUSHU CHARACTER-1B2FB
	{0x1BC00, 0x1BC6A, prAL, gcLo},   //   [107] DUPLOYAN LETTER H..DUPLOYAN LETTER VOCALIC M
	{0x1BC70, 0x1BC7C, prAL, gcLo},   //    [13] DUPLOYAN AFFIX LEFT HORIZONTAL SECANT..DUPLOYAN AFFIX ATTACHED TANGENT HOOK
	{0x1BC80, 0x1BC88, prAL, gcLo},   //     [9] DUPLOYAN AFFIX HIGH ACUTE..DUPLOYAN AFFIX HIGH VERTICAL
	{0x1BC90, 0x1BC99, prAL, gcLo},   //    [10] DUPLOYAN AFFIX LOW ACUTE..DUPLOYAN AFFIX LOW ARROW
	{0x1BC9C, 0x1BC9C, prAL, gcSo},   //         DUPLOYAN SIGN O WITH CROSS
	{0x1BC9D, 0x1BC9E, prCM, gcMn},   //     [2] DUPLOYAN THICK LETTER SELECTOR..DUPLOYAN DOUBLE MARK
	{0x1BC9F, 0x1BC9F, prBA, gcPo},   //         DUPLOYAN PUNCTUATION CHINOOK FULL STOP
	{0x1BCA0, 0x1BCA3, prCM, gcCf},   //     [4] SHORTHAND FORMAT LETTER OVERLAP..SHORTHAND FORMAT UP STEP
	{0x1CF00, 0x1CF2D, prCM, gcMn},   //    [46] ZNAMENNY COMBINING MARK GORAZDO NIZKO S KRYZHEM ON LEFT..ZNAMENNY COMBINING MARK KRYZH ON LEFT
	{0x1CF30, 0x1CF46, prCM, gcMn},   //    [23] ZNAMENNY COMBINING TONAL RANGE MARK MRACHNO..ZNAMENNY PRIZNAK MODIFIER ROG
	{0x1CF50, 0x1CFC3, prAL, gcSo},   //   [116] ZNAMENNY NEUME KRYUK..ZNAMENNY NEUME PAUK
	{0x1D000, 0x1D0F5, prAL, gcSo},   //   [246] BYZANTINE MUSICAL SYMBOL PSILI..BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
	{0x1D100, 0x1D126, prAL, gcSo},   //    [39] MUSICAL SYMBOL SINGLE BARLINE..MUSICAL SYMBOL DRUM CLEF-2
	{0x1D129, 0x1D164, prAL, gcSo},   //    [60] MUSICAL SYMBOL MULTIPLE MEASURE REST..MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
	{0x1D165, 0x1D166, prCM, gcMc},   //     [2] MUSICAL SYMBOL COMBINING STEM..MUSICAL SYMBOL COMBINING SPRECHGESANG STEM
	{0x1D167, 0x1D169, prCM, gcMn},   //     [3] MUSICAL SYMBOL COMBINING TREMOLO-1..MUSICAL SYMBOL COMBINING TREMOLO-3
	{0x1D16A, 0x1D16C, prAL, gcSo},   //     [3] MUSICAL SYMBOL FINGERED TREMOLO-1..MUSICAL SYMBOL FINGERED TREMOLO-3
	{0x1D16D, 0x1D172, prCM, gcMc},   //     [6] MUSICAL SYMBOL COMBINING AUGMENTATION DOT..MUSICAL SYMBOL COMBINING FLAG-5
	{0x1D173, 0x1D17A, prCM, gcCf},   //     [8] MUSICAL SYMBOL BEGIN BEAM..MUSICAL SYMBOL END PHRASE
	{0x1D17B, 0x1D182, prCM, gcMn},   //     [8] MUSICAL SYMBOL COMBINING ACCENT..MUSICAL SYMBOL COMBINING LOURE
	{0x1D183, 0x1D184, prAL, gcSo},   //     [2] MUSICAL SYMBOL ARPEGGIATO UP..MUSICAL SYMBOL ARPEGGIATO DOWN
	{0x1D185, 0x1D18B, prCM, gcMn},   //     [7] MUSICAL SYMBOL COMBINING DOIT..MUSICAL SYMBOL COMBINING TRIPLE TONGUE
	{0x1D18C, 0x1D1A9, prAL, gcSo},   //    [30] MUSICAL SYMBOL RINFORZANDO..MUSICAL SYMBOL DEGREE SLASH
	{0x1D1AA, 0x1D1AD, prCM, gcMn},   //     [4] MUSICAL SYMBOL COMBINING DOWN BOW..MUSICAL SYMBOL COMBINING SNAP PIZZICATO
	{0x1D1AE, 0x1D1EA, prAL, gcSo},   //    [61] MUSICAL SYMBOL PEDAL MARK..MUSICAL SYMBOL KORON
	{0x1D200, 0x1D241, prAL, gcSo},   //    [66] GREEK VOCAL NOTATION SYMBOL-1..GREEK INSTRUMENTAL NOTATION SYMBOL-54
	{0x1D242, 0x1D244, prCM, gcMn},   //     [3] COMBINING GREEK MUSICAL TRISEME..COMBINING GREEK MUSICAL PENTASEME
	{0x1D245, 0x1D245, prAL, gcSo},   //         GREEK MUSICAL LEIMMA
	{0x1D2C0, 0x1D2D3, prAL, gcNo},   //    [20] KAKTOVIK NUMERAL ZERO..KAKTOVIK NUMERAL NINETEEN
	{0x1D2E0, 0x1D2F3, prAL, gcNo},   //    [20] MAYAN NUMERAL ZERO..MAYAN NUMERAL NINETEEN
	{0x1D300, 0x1D356, prAL, gcSo},   //    [87] MONOGRAM FOR EARTH..TETRAGRAM FOR FOSTERING
	{0x1D360, 0x1D378, prAL, gcNo},   //    [25] COUNTING ROD UNIT DIGIT ONE..TALLY MARK FIVE
	{0x1D400, 0x1D454, prAL, gcLC},   //    [85] MATHEMATICAL BOLD CAPITAL A..MATHEMATICAL ITALIC SMALL G
	{0x1D456, 0x1D49C, prAL, gcLC},   //    [71] MATHEMATICAL ITALIC SMALL I..MATHEMATICAL SCRIPT CAPITAL A
	{0x1D49E, 0x1D49F, prAL, gcLu},   //     [2] MATHEMATICAL SCRIPT CAPITAL C..MATHEMATICAL SCRIPT CAPITAL D
	{0x1D4A2, 0x1D4A2, prAL, gcLu},   //         MATHEMATICAL SCRIPT CAPITAL G
	{0x1D4A5, 0x1D4A6, prAL, gcLu},   //     [2] MATHEMATICAL SCRIPT CAPITAL J..MATHEMATICAL SCRIPT CAPITAL K
	{0x1D4A9, 0x1D4AC, prAL, gcLu},   //     [4] MATHEMATICAL SCRIPT CAPITAL N..MATHEMATICAL SCRIPT CAPITAL Q
	{0x1D4AE, 0x1D4B9, prAL, gcLC},   //    [12] MATHEMATICAL SCRIPT CAPITAL S..MATHEMATICAL SCRIPT SMALL D
	{0x1D4BB, 0x1D4BB, prAL, gcLl},   //         MATHEMATICAL SCRIPT SMALL F
	{0x1D4BD, 0x1D4C3, prAL, gcLl},   //     [7] MATHEMATICAL SCRIPT SMALL H..MATHEMATICAL SCRIPT SMALL N
	{0x1D4C5, 0x1D505, prAL, gcLC},   //    [65] MATHEMATICAL SCRIPT SMALL P..MATHEMATICAL FRAKTUR CAPITAL B
	{0x1D507, 0x1D50A, prAL, gcLu},   //     [4] MATHEMATICAL FRAKTUR CAPITAL D..MATHEMATICAL FRAKTUR CAPITAL G
	{0x1D50D, 0x1D514, prAL, gcLu},   //     [8] MATHEMATICAL FRAKTUR CAPITAL J..MATHEMATICAL FRAKTUR CAPITAL Q
	{0x1D516, 0x1D51C, prAL, gcLu},   //     [7] MATHEMATICAL FRAKTUR CAPITAL S..MATHEMATICAL FRAKTUR CAPITAL Y
	{0x1D51E, 0x1D539, prAL, gcLC},   //    [28] MATHEMATICAL FRAKTUR SMALL A..MATHEMATICAL DOUBLE-STRUCK CAPITAL B
	{0x1D53B, 0x1D53E, prAL, gcLu},   //     [4] MATHEMATICAL DOUBLE-STRUCK CAPITAL D..MATHEMATICAL DOUBLE-STRUCK CAPITAL G
	{0x1D540, 0x1D544, prAL, gcLu},   //     [5] MATHEMATICAL DOUBLE-STRUCK CAPITAL I..MATHEMATICAL DOUBLE-STRUCK CAPITAL M
	{0x1D546, 0x1D546, prAL, gcLu},   //         MATHEMATICAL DOUBLE-STRUCK CAPITAL O
	{0x1D54A, 0x1D550, prAL, gcLu},   //     [7] MATHEMATICAL DOUBLE-STRUCK CAPITAL S..MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
	{0x1D552, 0x1D6A5, prAL, gcLC},   //   [340] MATHEMATICAL DOUBLE-STRUCK SMALL A..MATHEMATICAL ITALIC SMALL DOTLESS J
	{0x1D6A8, 0x1D6C0, prAL, gcLu},   //    [25] MATHEMATICAL BOLD CAPITAL ALPHA..MATHEMATICAL BOLD CAPITAL OMEGA
	{0x1D6C1, 0x1D6C1, prAL, gcSm},   //         MATHEMATICAL BOLD NABLA
	{0x1D6C2, 0x1D6DA, prAL, gcLl},   //    [25] MATHEMATICAL BOLD SMALL ALPHA..MATHEMATICAL BOLD SMALL OMEGA
	{0x1D6DB, 0x1D6DB, prAL, gcSm},   //         MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
	{0x1D6DC, 0x1D6FA, prAL, gcLC},   //    [31] MATHEMATICAL BOLD EPSILON SYMBOL..MATHEMATICAL ITALIC CAPITAL OMEGA
	{0x1D6FB, 0x1D6FB, prAL, gcSm},   //         MATHEMATICAL ITALIC NABLA
	{0x1D6FC, 0x1D714, prAL, gcLl},   //    [25] MATHEMATICAL ITALIC SMALL ALPHA..MATHEMATICAL ITALIC SMALL OMEGA
	{0x1D715, 0x1D715, prAL, gcSm},   //         MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
	{0x1D716, 0x1D734, prAL, gcLC},   //    [31] MATHEMATICAL ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
	{0x1D735, 0x1D735, prAL, gcSm},   //         MATHEMATICAL BOLD ITALIC NABLA
	{0x1D736, 0x1D74E, prAL, gcLl},   //    [25] MATHEMATICAL BOLD ITALIC SMALL ALPHA..MATHEMATICAL BOLD ITALIC SMALL OMEGA
	{0x1D74F, 0x1D74F, prAL, gcSm},   //         MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
	{0x1D750, 0x1D76E, prAL, gcLC},   //    [31] MATHEMATICAL BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
	{0x1D76F, 0x1D76F, prAL, gcSm},   //         MATHEMATICAL SANS-SERIF BOLD NABLA
	{0x1D770, 0x1D788, prAL, gcLl},   //    [25] MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
	{0x1D789, 0x1D789, prAL, gcSm},   //         MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
	{0x1D78A, 0x1D7A8, prAL, gcLC},   //    [31] MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL..MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
	{0x1D7A9, 0x1D7A9, prAL, gcSm},   //         MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
	{0x1D7AA, 0x1D7C2, prAL, gcLl},   //    [25] MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA..MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
	{0x1D7C3, 0x1D7C3, prAL, gcSm},   //         MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
	{0x1D7C4, 0x1D7CB, prAL, gcLC},   //     [8] MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL..MATHEMATICAL BOLD SMALL DIGAMMA
	{0x1D7CE, 0x1D7FF, prNU, gcNd},   //    [50] MATHEMATICAL BOLD DIGIT ZERO..MATHEMATICAL MONOSPACE DIGIT NINE
	{0x1D800, 0x1D9FF, prAL, gcSo},   //   [512] SIGNWRITING HAND-FIST INDEX..SIGNWRITING HEAD
	{0x1DA00, 0x1DA36, prCM, gcMn},   //    [55] SIGNWRITING HEAD RIM..SIGNWRITING AIR SUCKING IN
	{0x1DA37, 0x1DA3A, prAL, gcSo},   //     [4] SIGNWRITING AIR BLOW SMALL ROTATIONS..SIGNWRITING BREATH EXHALE
	{0x1DA3B, 0x1DA6C, prCM, gcMn},   //    [50] SIGNWRITING MOUTH CLOSED NEUTRAL..SIGNWRITING EXCITEMENT
	{0x1DA6D, 0x1DA74, prAL, gcSo},   //     [8] SIGNWRITING SHOULDER HIP SPINE..SIGNWRITING TORSO-FLOORPLANE TWISTING
	{0x1DA75, 0x1DA75, prCM, gcMn},   //         SIGNWRITING UPPER BODY TILTING FROM HIP JOINTS
	{0x1DA76, 0x1DA83, prAL, gcSo},   //    [14] SIGNWRITING LIMB COMBINATION..SIGNWRITING LOCATION DEPTH
	{0x1DA84, 0x1DA84, prCM, gcMn},   //         SIGNWRITING LOCATION HEAD NECK
	{0x1DA85, 0x1DA86, prAL, gcSo},   //     [2] SIGNWRITING LOCATION TORSO..SIGNWRITING LOCATION LIMBS DIGITS
	{0x1DA87, 0x1DA8A, prBA, gcPo},   //     [4] SIGNWRITING COMMA..SIGNWRITING COLON
	{0x1DA8B, 0x1DA8B, prAL, gcPo},   //         SIGNWRITING PARENTHESIS
	{0x1DA9B, 0x1DA9F, prCM, gcMn},   //     [5] SIGNWRITING FILL MODIFIER-2..SIGNWRITING FILL MODIFIER-6
	{0x1DAA1, 0x1DAAF, prCM, gcMn},   //    [15] SIGNWRITING ROTATION MODIFIER-2..SIGNWRITING ROTATION MODIFIER-16
	{0x1DF00, 0x1DF09, prAL, gcLl},   //    [10] LATIN SMALL LETTER FENG DIGRAPH WITH TRILL..LATIN SMALL LETTER T WITH HOOK AND RETROFLEX HOOK
	{0x1DF0A, 0x1DF0A, prAL, gcLo},   //         LATIN LETTER RETROFLEX CLICK WITH RETROFLEX HOOK
	{0x1DF0B, 0x1DF1E, prAL, gcLl},   //    [20] LATIN SMALL LETTER ESH WITH DOUBLE BAR..LATIN SMALL LETTER S WITH CURL
	{0x1DF25, 0x1DF2A, prAL, gcLl},   //     [6] LATIN SMALL LETTER D WITH MID-HEIGHT LEFT HOOK..LATIN SMALL LETTER T WITH MID-HEIGHT LEFT HOOK
	{0x1E000, 0x1E006, prCM, gcMn},   //     [7] COMBINING GLAGOLITIC LETTER AZU..COMBINING GLAGOLITIC LETTER ZHIVETE
	{0x1E008, 0x1E018, prCM, gcMn},   //    [17] COMBINING GLAGOLITIC LETTER ZEMLJA..COMBINING GLAGOLITIC LETTER HERU
	{0x1E01B, 0x1E021, prCM, gcMn},   //     [7] COMBINING GLAGOLITIC LETTER SHTA..COMBINING GLAGOLITIC LETTER YATI
	{0x1E023, 0x1E024, prCM, gcMn},   //     [2] COMBINING GLAGOLITIC LETTER YU..COMBINING GLAGOLITIC LETTER SMALL YUS
	{0x1E026, 0x1E02A, prCM, gcMn},   //     [5] COMBINING GLAGOLITIC LETTER YO..COMBINING GLAGOLITIC LETTER FITA
	{0x1E030, 0x1E06D, prAL, gcLm},   //    [62] MODIFIER LETTER CYRILLIC SMALL A..MODIFIER LETTER CYRILLIC SMALL STRAIGHT U WITH STROKE
	{0x1E08F, 0x1E08F, prCM, gcMn},   //         COMBINING CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
	{0x1E100, 0x1E12C, prAL, gcLo},   //    [45] NYIAKENG PUACHUE HMONG LETTER MA..NYIAKENG PUACHUE HMONG LETTER W
	{0x1E130, 0x1E136, prCM, gcMn},   //     [7] NYIAKENG PUACHUE HMONG TONE-B..NYIAKENG PUACHUE HMONG TONE-D
	{0x1E137, 0x1E13D, prAL, gcLm},   //     [7] NYIAKENG PUACHUE HMONG SIGN FOR PERSON..NYIAKENG PUACHUE HMONG SYLLABLE LENGTHENER
	{0x1E140, 0x1E149, prNU, gcNd},   //    [10] NYIAKENG PUACHUE HMONG DIGIT ZERO..NYIAKENG PUACHUE HMONG DIGIT NINE
	{0x1E14E, 0x1E14E, prAL, gcLo},   //         NYIAKENG PUACHUE HMONG LOGOGRAM NYAJ
	{0x1E14F, 0x1E14F, prAL, gcSo},   //         NYIAKENG PUACHUE HMONG CIRCLED CA
	{0x1E290, 0x1E2AD, prAL, gcLo},   //    [30] TOTO LETTER PA..TOTO LETTER A
	{0x1E2AE, 0x1E2AE, prCM, gcMn},   //         TOTO SIGN RISING TONE
	{0x1E2C0, 0x1E2EB, prAL, gcLo},   //    [44] WANCHO LETTER AA..WANCHO LETTER YIH
	{0x1E2EC, 0x1E2EF, prCM, gcMn},   //     [4] WANCHO TONE TUP..WANCHO TONE KOINI
	{0x1E2F0, 0x1E2F9, prNU, gcNd},   //    [10] WANCHO DIGIT ZERO..WANCHO DIGIT NINE
	{0x1E2FF, 0x1E2FF, prPR, gcSc},   //         WANCHO NGUN SIGN
	{0x1E4D0, 0x1E4EA, prAL, gcLo},   //    [27] NAG MUNDARI LETTER O..NAG MUNDARI LETTER ELL
	{0x1E4EB, 0x1E4EB, prAL, gcLm},   //         NAG MUNDARI SIGN OJOD
	{0x1E4EC, 0x1E4EF, prCM, gcMn},   //     [4] NAG MUNDARI SIGN MUHOR..NAG MUNDARI SIGN SUTUH
	{0x1E4F0, 0x1E4F9, prNU, gcNd},   //    [10] NAG MUNDARI DIGIT ZERO..NAG MUNDARI DIGIT NINE
	{0x1E7E0, 0x1E7E6, prAL, gcLo},   //     [7] ETHIOPIC SYLLABLE HHYA..ETHIOPIC SYLLABLE HHYO
	{0x1E7E8, 0x1E7EB, prAL, gcLo},   //     [4] ETHIOPIC SYLLABLE GURAGE HHWA..ETHIOPIC SYLLABLE HHWE
	{0x1E7ED, 0x1E7EE, prAL, gcLo},   //     [2] ETHIOPIC SYLLABLE GURAGE MWI..ETHIOPIC SYLLABLE GURAGE MWEE
	{0x1E7F0, 0x1E7FE, prAL, gcLo},   //    [15] ETHIOPIC SYLLABLE GURAGE QWI..ETHIOPIC SYLLABLE GURAGE PWEE
	{0x1E800, 0x1E8C4, prAL, gcLo},   //   [197] MENDE KIKAKUI SYLLABLE M001 KI..MENDE KIKAKUI SYLLABLE M060 NYON
	{0x1E8C7, 0x1E8CF, prAL, gcNo},   //     [9] MENDE KIKAKUI DIGIT ONE..MENDE KIKAKUI DIGIT NINE
	{0x1E8D0, 0x1E8D6, prCM, gcMn},   //     [7] MENDE KIKAKUI COMBINING NUMBER TEENS..MENDE KIKAKUI COMBINING NUMBER MILLIONS
	{0x1E900, 0x1E943, prAL, gcLC},   //    [68] ADLAM CAPITAL LETTER ALIF..ADLAM SMALL LETTER SHA
	{0x1E944, 0x1E94A, prCM, gcMn},   //     [7] ADLAM ALIF LENGTHENER..ADLAM NUKTA
	{0x1E94B, 0x1E94B, prAL, gcLm},   //         ADLAM NASALIZATION MARK
	{0x1E950, 0x1E959, prNU, gcNd},   //    [10] ADLAM DIGIT ZERO..ADLAM DIGIT NINE
	{0x1E95E, 0x1E95F, prOP, gcPo},   //     [2] ADLAM INITIAL EXCLAMATION MARK..ADLAM INITIAL QUESTION MARK
	{0x1EC71, 0x1ECAB, prAL, gcNo},   //    [59] INDIC SIYAQ NUMBER ONE..INDIC SIYAQ NUMBER PREFIXED NINE
	{0x1ECAC, 0x1ECAC, prPO, gcSo},   //         INDIC SIYAQ PLACEHOLDER
	{0x1ECAD, 0x1ECAF, prAL, gcNo},   //     [3] INDIC SIYAQ FRACTION ONE QUARTER..INDIC SIYAQ FRACTION THREE QUARTERS
	{0x1ECB0, 0x1ECB0, prPO, gcSc},   //         INDIC SIYAQ RUPEE MARK
	{0x1ECB1, 0x1ECB4, prAL, gcNo},   //     [4] INDIC SIYAQ NUMBER ALTERNATE ONE..INDIC SIYAQ ALTERNATE LAKH MARK
	{0x1ED01, 0x1ED2D, prAL, gcNo},   //    [45] OTTOMAN SIYAQ NUMBER ONE..OTTOMAN SIYAQ NUMBER NINETY THOUSAND
	{0x1ED2E, 0x1ED2E, prAL, gcSo},   //         OTTOMAN SIYAQ MARRATAN
	{0x1ED2F, 0x1ED3D, prAL, gcNo},   //    [15] OTTOMAN SIYAQ ALTERNATE NUMBER TWO..OTTOMAN SIYAQ FRACTION ONE SIXTH
	{0x1EE00, 0x1EE03, prAL, gcLo},   //     [4] ARABIC MATHEMATICAL ALEF..ARABIC MATHEMATICAL DAL
	{0x1EE05, 0x1EE1F, prAL, gcLo},   //    [27] ARABIC MATHEMATICAL WAW..ARABIC MATHEMATICAL DOTLESS QAF
	{0x1EE21, 0x1EE22, prAL, gcLo},   //     [2] ARABIC MATHEMATICAL INITIAL BEH..ARABIC MATHEMATICAL INITIAL JEEM
	{0x1EE24, 0x1EE24, prAL, gcLo},   //         ARABIC MATHEMATICAL INITIAL HEH
	{0x1EE27, 0x1EE27, prAL, gcLo},   //         ARABIC MATHEMATICAL INITIAL HAH
	{0x1EE29, 0x1EE32, prAL, gcLo},   //    [10] ARABIC MATHEMATICAL INITIAL YEH..ARABIC MATHEMATICAL INITIAL QAF
	{0x1EE34, 0x1EE37, prAL, gcLo},   //     [4] ARABIC MATHEMATICAL INITIAL SHEEN..ARABIC MATHEMATICAL INITIAL KHAH
	{0x1EE39, 0x1EE39, prAL, gcLo},   //         ARABIC MATHEMATICAL INITIAL DAD
	{0x1EE3B, 0x1EE3B, prAL, gcLo},   //         ARABIC MATHEMATICAL INITIAL GHAIN
	{0x1EE42, 0x1EE42, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED JEEM
	{0x1EE47, 0x1EE47, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED HAH
	{0x1EE49, 0x1EE49, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED YEH
	{0x1EE4B, 0x1EE4B, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED LAM
	{0x1EE4D, 0x1EE4F, prAL, gcLo},   //     [3] ARABIC MATHEMATICAL TAILED NOON..ARABIC MATHEMATICAL TAILED AIN
	{0x1EE51, 0x1EE52, prAL, gcLo},   //     [2] ARABIC MATHEMATICAL TAILED SAD..ARABIC MATHEMATICAL TAILED QAF
	{0x1EE54, 0x1EE54, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED SHEEN
	{0x1EE57, 0x1EE57, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED KHAH
	{0x1EE59, 0x1EE59, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED DAD
	{0x1EE5B, 0x1EE5B, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED GHAIN
	{0x1EE5D, 0x1EE5D, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED DOTLESS NOON
	{0x1EE5F, 0x1EE5F, prAL, gcLo},   //         ARABIC MATHEMATICAL TAILED DOTLESS QAF
	{0x1EE61, 0x1EE62, prAL, gcLo},   //     [2] ARABIC MATHEMATICAL STRETCHED BEH..ARABIC MATHEMATICAL STRETCHED JEEM
	{0x1EE64, 0x1EE64, prAL, gcLo},   //         ARABIC MATHEMATICAL STRETCHED HEH
	{0x1EE67, 0x1EE6A, prAL, gcLo},   //     [4] ARABIC MATHEMATICAL STRETCHED HAH..ARABIC MATHEMATICAL STRETCHED KAF
	{0x1EE6C, 0x1EE72, prAL, gcLo},   //     [7] ARABIC MATHEMATICAL STRETCHED MEEM..ARABIC MATHEMATICAL STRETCHED QAF
	{0x1EE74, 0x1EE77, prAL, gcLo},   //     [4] ARABIC MATHEMATICAL STRETCHED SHEEN..ARABIC MATHEMATICAL STRETCHED KHAH
	{0x1EE79, 0x1EE7C, prAL, gcLo},   //     [4] ARABIC MATHEMATICAL STRETCHED DAD..ARABIC MATHEMATICAL STRETCHED DOTLESS BEH
	{0x1EE7E, 0x1EE7E, prAL, gcLo},   //         ARABIC MATHEMATICAL STRETCHED DOTLESS FEH
	{0x1EE80, 0x1EE89, prAL, gcLo},   //    [10] ARABIC MATHEMATICAL LOOPED ALEF..ARABIC MATHEMATICAL LOOPED YEH
	{0x1EE8B, 0x1EE9B, prAL, gcLo},   //    [17] ARABIC MATHEMATICAL LOOPED LAM..ARABIC MATHEMATICAL LOOPED GHAIN
	{0x1EEA1, 0x1EEA3, prAL, gcLo},   //     [3] ARABIC MATHEMATICAL DOUBLE-STRUCK BEH..ARABIC MATHEMATICAL DOUBLE-STRUCK DAL
	{0x1EEA5, 0x1EEA9, prAL, gcLo},   //     [5] ARABIC MATHEMATICAL DOUBLE-STRUCK WAW..ARABIC MATHEMATICAL DOUBLE-STRUCK YEH
	{0x1EEAB, 0x1EEBB, prAL, gcLo},   //    [17] ARABIC MATHEMATICAL DOUBLE-STRUCK LAM..ARABIC MATHEMATICAL DOUBLE-STRUCK GHAIN
	{0x1EEF0, 0x1EEF1, prAL, gcSm},   //     [2] ARABIC MATHEMATICAL OPERATOR MEEM WITH HAH WITH TATWEEL..ARABIC MATHEMATICAL OPERATOR HAH WITH DAL
	{0x1F000, 0x1F02B, prID, gcSo},   //    [44] MAHJONG TILE EAST WIND..MAHJONG TILE BACK
	{0x1F02C, 0x1F02F, prID, gcCn},   //     [4] <reserved-1F02C>..<reserved-1F02F>
	{0x1F030, 0x1F093, prID, gcSo},   //   [100] DOMINO TILE HORIZONTAL BACK..DOMINO TILE VERTICAL-06-06
	{0x1F094, 0x1F09F, prID, gcCn},   //    [12] <reserved-1F094>..<reserved-1F09F>
	{0x1F0A0, 0x1F0AE, prID, gcSo},   //    [15] PLAYING CARD BACK..PLAYING CARD KING OF SPADES
	{0x1F0AF, 0x1F0B0, prID, gcCn},   //     [2] <reserved-1F0AF>..<reserved-1F0B0>
	{0x1F0B1, 0x1F0BF, prID, gcSo},   //    [15] PLAYING CARD ACE OF HEARTS..PLAYING CARD RED JOKER
	{0x1F0C0, 0x1F0C0, prID, gcCn},   //         <reserved-1F0C0>
	{0x1F0C1, 0x1F0CF, prID, gcSo},   //    [15] PLAYING CARD ACE OF DIAMONDS..PLAYING CARD BLACK JOKER
	{0x1F0D0, 0x1F0D0, prID, gcCn},   //         <reserved-1F0D0>
	{0x1F0D1, 0x1F0F5, prID, gcSo},   //    [37] PLAYING CARD ACE OF CLUBS..PLAYING CARD TRUMP-21
	{0x1F0F6, 0x1F0FF, prID, gcCn},   //    [10] <reserved-1F0F6>..<reserved-1F0FF>
	{0x1F100, 0x1F10C, prAI, gcNo},   //    [13] DIGIT ZERO FULL STOP..DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO
	{0x1F10D, 0x1F10F, prID, gcSo},   //     [3] CIRCLED ZERO WITH SLASH..CIRCLED DOLLAR SIGN WITH OVERLAID BACKSLASH
	{0x1F110, 0x1F12D, prAI, gcSo},   //    [30] PARENTHESIZED LATIN CAPITAL LETTER A..CIRCLED CD
	{0x1F12E, 0x1F12F, prAL, gcSo},   //     [2] CIRCLED WZ..COPYLEFT SYMBOL
	{0x1F130, 0x1F169, prAI, gcSo},   //    [58] SQUARED LATIN CAPITAL LETTER A..NEGATIVE CIRCLED LATIN CAPITAL LETTER Z
	{0x1F16A, 0x1F16C, prAL, gcSo},   //     [3] RAISED MC SIGN..RAISED MR SIGN
	{0x1F16D, 0x1F16F, prID, gcSo},   //     [3] CIRCLED CC..CIRCLED HUMAN FIGURE
	{0x1F170, 0x1F1AC, prAI, gcSo},   //    [61] NEGATIVE SQUARED LATIN CAPITAL LETTER A..SQUARED VOD
	{0x1F1AD, 0x1F1AD, prID, gcSo},   //         MASK WORK SYMBOL
	{0x1F1AE, 0x1F1E5, prID, gcCn},   //    [56] <reserved-1F1AE>..<reserved-1F1E5>
	{0x1F1E6, 0x1F1FF, prRI, gcSo},   //    [26] REGIONAL INDICATOR SYMBOL LETTER A..REGIONAL INDICATOR SYMBOL LETTER Z
	{0x1F200, 0x1F202, prID, gcSo},   //     [3] SQUARE HIRAGANA HOKA..SQUARED KATAKANA SA
	{0x1F203, 0x1F20F, prID, gcCn},   //    [13] <reserved-1F203>..<reserved-1F20F>
	{0x1F210, 0x1F23B, prID, gcSo},   //    [44] SQUARED CJK UNIFIED IDEOGRAPH-624B..SQUARED CJK UNIFIED IDEOGRAPH-914D
	{0x1F23C, 0x1F23F, prID, gcCn},   //     [4] <reserved-1F23C>..<reserved-1F23F>
	{0x1F240, 0x1F248, prID, gcSo},   //     [9] TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-672C..TORTOISE SHELL BRACKETED CJK UNIFIED IDEOGRAPH-6557
	{0x1F249, 0x1F24F, prID, gcCn},   //     [7] <reserved-1F249>..<reserved-1F24F>
	{0x1F250, 0x1F251, prID, gcSo},   //     [2] CIRCLED IDEOGRAPH ADVANTAGE..CIRCLED IDEOGRAPH ACCEPT
	{0x1F252, 0x1F25F, prID, gcCn},   //    [14] <reserved-1F252>..<reserved-1F25F>
	{0x1F260, 0x1F265, prID, gcSo},   //     [6] ROUNDED SYMBOL FOR FU..ROUNDED SYMBOL FOR CAI
	{0x1F266, 0x1F2FF, prID, gcCn},   //   [154] <reserved-1F266>..<reserved-1F2FF>
	{0x1F300, 0x1F384, prID, gcSo},   //   [133] CYCLONE..CHRISTMAS TREE
	{0x1F385, 0x1F385, prEB, gcSo},   //         FATHER CHRISTMAS
	{0x1F386, 0x1F39B, prID, gcSo},   //    [22] FIREWORKS..CONTROL KNOBS
	{0x1F39C, 0x1F39D, prAL, gcSo},   //     [2] BEAMED ASCENDING MUSICAL NOTES..BEAMED DESCENDING MUSICAL NOTES
	{0x1F39E, 0x1F3B4, prID, gcSo},   //    [23] FILM FRAMES..FLOWER PLAYING CARDS
	{0x1F3B5, 0x1F3B6, prAL, gcSo},   //     [2] MUSICAL NOTE..MULTIPLE MUSICAL NOTES
	{0x1F3B7, 0x1F3BB, prID, gcSo},   //     [5] SAXOPHONE..VIOLIN
	{0x1F3BC, 0x1F3BC, prAL, gcSo},   //         MUSICAL SCORE
	{0x1F3BD, 0x1F3C1, prID, gcSo},   //     [5] RUNNING SHIRT WITH SASH..CHEQUERED FLAG
	{0x1F3C2, 0x1F3C4, prEB, gcSo},   //     [3] SNOWBOARDER..SURFER
	{0x1F3C5, 0x1F3C6, prID, gcSo},   //     [2] SPORTS MEDAL..TROPHY
	{0x1F3C7, 0x1F3C7, prEB, gcSo},   //         HORSE RACING
	{0x1F3C8, 0x1F3C9, prID, gcSo},   //     [2] AMERICAN FOOTBALL..RUGBY FOOTBALL
	{0x1F3CA, 0x1F3CC, prEB, gcSo},   //     [3] SWIMMER..GOLFER
	{0x1F3CD, 0x1F3FA, prID, gcSo},   //    [46] RACING MOTORCYCLE..AMPHORA
	{0x1F3FB, 0x1F3FF, prEM, gcSk},   //     [5] EMOJI MODIFIER FITZPATRICK TYPE-1-2..EMOJI MODIFIER FITZPATRICK TYPE-6
	{0x1F400, 0x1F441, prID, gcSo},   //    [66] RAT..EYE
	{0x1F442, 0x1F443, prEB, gcSo},   //     [2] EAR..NOSE
	{0x1F444, 0x1F445, prID, gcSo},   //     [2] MOUTH..TONGUE
	{0x1F446, 0x1F450, prEB, gcSo},   //    [11] WHITE UP POINTING BACKHAND INDEX..OPEN HANDS SIGN
	{0x1F451, 0x1F465, prID, gcSo},   //    [21] CROWN..BUSTS IN SILHOUETTE
	{0x1F466, 0x1F478, prEB, gcSo},   //    [19] BOY..PRINCESS
	{0x1F479, 0x1F47B, prID, gcSo},   //     [3] JAPANESE OGRE..GHOST
	{0x1F47C, 0x1F47C, prEB, gcSo},   //         BABY ANGEL
	{0x1F47D, 0x1F480, prID, gcSo},   //     [4] EXTRATERRESTRIAL ALIEN..SKULL
	{0x1F481, 0x1F483, prEB, gcSo},   //     [3] INFORMATION DESK PERSON..DANCER
	{0x1F484, 0x1F484, prID, gcSo},   //         LIPSTICK
	{0x1F485, 0x1F487, prEB, gcSo},   //     [3] NAIL POLISH..HAIRCUT
	{0x1F488, 0x1F48E, prID, gcSo},   //     [7] BARBER POLE..GEM STONE
	{0x1F48F, 0x1F48F, prEB, gcSo},   //         KISS
	{0x1F490, 0x1F490, prID, gcSo},   //         BOUQUET
	{0x1F491, 0x1F491, prEB, gcSo},   //         COUPLE WITH HEART
	{0x1F492, 0x1F49F, prID, gcSo},   //    [14] WEDDING..HEART DECORATION
	{0x1F4A0, 0x1F4A0, prAL, gcSo},   //         DIAMOND SHAPE WITH A DOT INSIDE
	{0x1F4A1, 0x1F4A1, prID, gcSo},   //         ELECTRIC LIGHT BULB
	{0x1F4A2, 0x1F4A2, prAL, gcSo},   //         ANGER SYMBOL
	{0x1F4A3, 0x1F4A3, prID, gcSo},   //         BOMB
	{0x1F4A4, 0x1F4A4, prAL, gcSo},   //         SLEEPING SYMBOL
	{0x1F4A5, 0x1F4A9, prID, gcSo},   //     [5] COLLISION SYMBOL..PILE OF POO
	{0x1F4AA, 0x1F4AA, prEB, gcSo},   //         FLEXED BICEPS
	{0x1F4AB, 0x1F4AE, prID, gcSo},   //     [4] DIZZY SYMBOL..WHITE FLOWER
	{0x1F4AF, 0x1F4AF, prAL, gcSo},   //         HUNDRED POINTS SYMBOL
	{0x1F4B0, 0x1F4B0, prID, gcSo},   //         MONEY BAG
	{0x1F4B1, 0x1F4B2, prAL, gcSo},   //     [2] CURRENCY EXCHANGE..HEAVY DOLLAR SIGN
	{0x1F4B3, 0x1F4FF, prID, gcSo},   //    [77] CREDIT CARD..PRAYER BEADS
	{0x1F500, 0x1F506, prAL, gcSo},   //     [7] TWISTED RIGHTWARDS ARROWS..HIGH BRIGHTNESS SYMBOL
	{0x1F507, 0x1F516, prID, gcSo},   //    [16] SPEAKER WITH CANCELLATION STROKE..BOOKMARK
	{0x1F517, 0x1F524, prAL, gcSo},   //    [14] LINK SYMBOL..INPUT SYMBOL FOR LATIN LETTERS
	{0x1F525, 0x1F531, prID, gcSo},   //    [13] FIRE..TRIDENT EMBLEM
	{0x1F532, 0x1F549, prAL, gcSo},   //    [24] BLACK SQUARE BUTTON..OM SYMBOL
	{0x1F54A, 0x1F573, prID, gcSo},   //    [42] DOVE OF PEACE..HOLE
	{0x1F574, 0x1F575, prEB, gcSo},   //     [2] MAN IN BUSINESS SUIT LEVITATING..SLEUTH OR SPY
	{0x1F576, 0x1F579, prID, gcSo},   //     [4] DARK SUNGLASSES..JOYSTICK
	{0x1F57A, 0x1F57A, prEB, gcSo},   //         MAN DANCING
	{0x1F57B, 0x1F58F, prID, gcSo},   //    [21] LEFT HAND TELEPHONE RECEIVER..TURNED OK HAND SIGN
	{0x1F590, 0x1F590, prEB, gcSo},   //         RAISED HAND WITH FINGERS SPLAYED
	{0x1F591, 0x1F594, prID, gcSo},   //     [4] REVERSED RAISED HAND WITH FINGERS SPLAYED..REVERSED VICTORY HAND
	{0x1F595, 0x1F596, prEB, gcSo},   //     [2] REVERSED HAND WITH MIDDLE FINGER EXTENDED..RAISED HAND WITH PART BETWEEN MIDDLE AND RING FINGERS
	{0x1F597, 0x1F5D3, prID, gcSo},   //    [61] WHITE DOWN POINTING LEFT HAND INDEX..SPIRAL CALENDAR PAD
	{0x1F5D4, 0x1F5DB, prAL, gcSo},   //     [8] DESKTOP WINDOW..DECREASE FONT SIZE SYMBOL
	{0x1F5DC, 0x1F5F3, prID, gcSo},   //    [24] COMPRESSION..BALLOT BOX WITH BALLOT
	{0x1F5F4, 0x1F5F9, prAL, gcSo},   //     [6] BALLOT SCRIPT X..BALLOT BOX WITH BOLD CHECK
	{0x1F5FA, 0x1F5FF, prID, gcSo},   //     [6] WORLD MAP..MOYAI
	{0x1F600, 0x1F644, prID, gcSo},   //    [69] GRINNING FACE..FACE WITH ROLLING EYES
	{0x1F645, 0x1F647, prEB, gcSo},   //     [3] FACE WITH NO GOOD GESTURE..PERSON BOWING DEEPLY
	{0x1F648, 0x1F64A, prID, gcSo},   //     [3] SEE-NO-EVIL MONKEY..SPEAK-NO-EVIL MONKEY
	{0x1F64B, 0x1F64F, prEB, gcSo},   //     [5] HAPPY PERSON RAISING ONE HAND..PERSON WITH FOLDED HANDS
	{0x1F650, 0x1F675, prAL, gcSo},   //    [38] NORTH WEST POINTING LEAF..SWASH AMPERSAND ORNAMENT
	{0x1F676, 0x1F678, prQU, gcSo},   //     [3] SANS-SERIF HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT..SANS-SERIF HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT
	{0x1F679, 0x1F67B, prNS, gcSo},   //     [3] HEAVY INTERROBANG ORNAMENT..HEAVY SANS-SERIF INTERROBANG ORNAMENT
	{0x1F67C, 0x1F67F, prAL, gcSo},   //     [4] VERY HEAVY SOLIDUS..REVERSE CHECKER BOARD
	{0x1F680, 0x1F6A2, prID, gcSo},   //    [35] ROCKET..SHIP
	{0x1F6A3, 0x1F6A3, prEB, gcSo},   //         ROWBOAT
	{0x1F6A4, 0x1F6B3, prID, gcSo},   //    [16] SPEEDBOAT..NO BICYCLES
	{0x1F6B4, 0x1F6B6, prEB, gcSo},   //     [3] BICYCLIST..PEDESTRIAN
	{0x1F6B7, 0x1F6BF, prID, gcSo},   //     [9] NO PEDESTRIANS..SHOWER
	{0x1F6C0, 0x1F6C0, prEB, gcSo},   //         BATH
	{0x1F6C1, 0x1F6CB, prID, gcSo},   //    [11] BATHTUB..COUCH AND LAMP
	{0x1F6CC, 0x1F6CC, prEB, gcSo},   //         SLEEPING ACCOMMODATION
	{0x1F6CD, 0x1F6D7, prID, gcSo},   //    [11] SHOPPING BAGS..ELEVATOR
	{0x1F6D8, 0x1F6DB, prID, gcCn},   //     [4] <reserved-1F6D8>..<reserved-1F6DB>
	{0x1F6DC, 0x1F6EC, prID, gcSo},   //    [17] WIRELESS..AIRPLANE ARRIVING
	{0x1F6ED, 0x1F6EF, prID, gcCn},   //     [3] <reserved-1F6ED>..<reserved-1F6EF>
	{0x1F6F0, 0x1F6FC, prID, gcSo},   //    [13] SATELLITE..ROLLER SKATE
	{0x1F6FD, 0x1F6FF, prID, gcCn},   //     [3] <reserved-1F6FD>..<reserved-1F6FF>
	{0x1F700, 0x1F773, prAL, gcSo},   //   [116] ALCHEMICAL SYMBOL FOR QUINTESSENCE..ALCHEMICAL SYMBOL FOR HALF OUNCE
	{0x1F774, 0x1F776, prID, gcSo},   //     [3] LOT OF FORTUNE..LUNAR ECLIPSE
	{0x1F777, 0x1F77A, prID, gcCn},   //     [4] <reserved-1F777>..<reserved-1F77A>
	{0x1F77B, 0x1F77F, prID, gcSo},   //     [5] HAUMEA..ORCUS
	{0x1F780, 0x1F7D4, prAL, gcSo},   //    [85] BLACK LEFT-POINTING ISOSCELES RIGHT TRIANGLE..HEAVY TWELVE POINTED PINWHEEL STAR
	{0x1F7D5, 0x1F7D9, prID, gcSo},   //     [5] CIRCLED TRIANGLE..NINE POINTED WHITE STAR
	{0x1F7DA, 0x1F7DF, prID, gcCn},   //     [6] <reserved-1F7DA>..<reserved-1F7DF>
	{0x1F7E0, 0x1F7EB, prID, gcSo},   //    [12] LARGE ORANGE CIRCLE..LARGE BROWN SQUARE
	{0x1F7EC, 0x1F7EF, prID, gcCn},   //     [4] <reserved-1F7EC>..<reserved-1F7EF>
	{0x1F7F0, 0x1F7F0, prID, gcSo},   //         HEAVY EQUALS SIGN
	{0x1F7F1, 0x1F7FF, prID, gcCn},   //    [15] <reserved-1F7F1>..<reserved-1F7FF>
	{0x1F800, 0x1F80B, prAL, gcSo},   //    [12] LEFTWARDS ARROW WITH SMALL TRIANGLE ARROWHEAD..DOWNWARDS ARROW WITH LARGE TRIANGLE ARROWHEAD
	{0x1F80C, 0x1F80F, prID, gcCn},   //     [4] <reserved-1F80C>..<reserved-1F80F>
	{0x1F810, 0x1F847, prAL, gcSo},   //    [56] LEFTWARDS ARROW WITH SMALL EQUILATERAL ARROWHEAD..DOWNWARDS HEAVY ARROW
	{0x1F848, 0x1F84F, prID, gcCn},   //     [8] <reserved-1F848>..<reserved-1F84F>
	{0x1F850, 0x1F859, prAL, gcSo},   //    [10] LEFTWARDS SANS-SERIF ARROW..UP DOWN SANS-SERIF ARROW
	{0x1F85A, 0x1F85F, prID, gcCn},   //     [6] <reserved-1F85A>..<reserved-1F85F>
	{0x1F860, 0x1F887, prAL, gcSo},   //    [40] WIDE-HEADED LEFTWARDS LIGHT BARB ARROW..WIDE-HEADED SOUTH WEST VERY HEAVY BARB ARROW
	{0x1F888, 0x1F88F, prID, gcCn},   //     [8] <reserved-1F888>..<reserved-1F88F>
	{0x1F890, 0x1F8AD, prAL, gcSo},   //    [30] LEFTWARDS TRIANGLE ARROWHEAD..WHITE ARROW SHAFT WIDTH TWO THIRDS
	{0x1F8AE, 0x1F8AF, prID, gcCn},   //     [2] <reserved-1F8AE>..<reserved-1F8AF>
	{0x1F8B0, 0x1F8B1, prID, gcSo},   //     [2] ARROW POINTING UPWARDS THEN NORTH WEST..ARROW POINTING RIGHTWARDS THEN CURVING SOUTH WEST
	{0x1F8B2, 0x1F8FF, prID, gcCn},   //    [78] <reserved-1F8B2>..<reserved-1F8FF>
	{0x1F900, 0x1F90B, prAL, gcSo},   //    [12] CIRCLED CROSS FORMEE WITH FOUR DOTS..DOWNWARD FACING NOTCHED HOOK WITH DOT
	{0x1F90C, 0x1F90C, prEB, gcSo},   //         PINCHED FINGERS
	{0x1F90D, 0x1F90E, prID, gcSo},   //     [2] WHITE HEART..BROWN HEART
	{0x1F90F, 0x1F90F, prEB, gcSo},   //         PINCHING HAND
	{0x1F910, 0x1F917, prID, gcSo},   //     [8] ZIPPER-MOUTH FACE..HUGGING FACE
	{0x1F918, 0x1F91F, prEB, gcSo},   //     [8] SIGN OF THE HORNS..I LOVE YOU HAND SIGN
	{0x1F920, 0x1F925, prID, gcSo},   //     [6] FACE WITH COWBOY HAT..LYING FACE
	{0x1F926, 0x1F926, prEB, gcSo},   //         FACE PALM
	{0x1F927, 0x1F92F, prID, gcSo},   //     [9] SNEEZING FACE..SHOCKED FACE WITH EXPLODING HEAD
	{0x1F930, 0x1F939, prEB, gcSo},   //    [10] PREGNANT WOMAN..JUGGLING
	{0x1F93A, 0x1F93B, prID, gcSo},   //     [2] FENCER..MODERN PENTATHLON
	{0x1F93C, 0x1F93E, prEB, gcSo},   //     [3] WRESTLERS..HANDBALL
	{0x1F93F, 0x1F976, prID, gcSo},   //    [56] DIVING MASK..FREEZING FACE
	{0x1F977, 0x1F977, prEB, gcSo},   //         NINJA
	{0x1F978, 0x1F9B4, prID, gcSo},   //    [61] DISGUISED FACE..BONE
	{0x1F9B5, 0x1F9B6, prEB, gcSo},   //     [2] LEG..FOOT
	{0x1F9B7, 0x1F9B7, prID, gcSo},   //         TOOTH
	{0x1F9B8, 0x1F9B9, prEB, gcSo},   //     [2] SUPERHERO..SUPERVILLAIN
	{0x1F9BA, 0x1F9BA, prID, gcSo},   //         SAFETY VEST
	{0x1F9BB, 0x1F9BB, prEB, gcSo},   //         EAR WITH HEARING AID
	{0x1F9BC, 0x1F9CC, prID, gcSo},   //    [17] MOTORIZED WHEELCHAIR..TROLL
	{0x1F9CD, 0x1F9CF, prEB, gcSo},   //     [3] STANDING PERSON..DEAF PERSON
	{0x1F9D0, 0x1F9D0, prID, gcSo},   //         FACE WITH MONOCLE
	{0x1F9D1, 0x1F9DD, prEB, gcSo},   //    [13] ADULT..ELF
	{0x1F9DE, 0x1F9FF, prID, gcSo},   //    [34] GENIE..NAZAR AMULET
	{0x1FA00, 0x1FA53, prAL, gcSo},   //    [84] NEUTRAL CHESS KING..BLACK CHESS KNIGHT-BISHOP
	{0x1FA54, 0x1FA5F, prID, gcCn},   //    [12] <reserved-1FA54>..<reserved-1FA5F>
	{0x1FA60, 0x1FA6D, prID, gcSo},   //    [14] XIANGQI RED GENERAL..XIANGQI BLACK SOLDIER
	{0x1FA6E, 0x1FA6F, prID, gcCn},   //     [2] <reserved-1FA6E>..<reserved-1FA6F>
	{0x1FA70, 0x1FA7C, prID, gcSo},   //    [13] BALLET SHOES..CRUTCH
	{0x1FA7D, 0x1FA7F, prID, gcCn},   //     [3] <reserved-1FA7D>..<reserved-1FA7F>
	{0x1FA80, 0x1FA88, prID, gcSo},   //     [9] YO-YO..FLUTE
	{0x1FA89, 0x1FA8F, prID, gcCn},   //     [7] <reserved-1FA89>..<reserved-1FA8F>
	{0x1FA90, 0x1FABD, prID, gcSo},   //    [46] RINGED PLANET..WING
	{0x1FABE, 0x1FABE, prID, gcCn},   //         <reserved-1FABE>
	{0x1FABF, 0x1FAC2, prID, gcSo},   //     [4] GOOSE..PEOPLE HUGGING
	{0x1FAC3, 0x1FAC5, prEB, gcSo},   //     [3] PREGNANT MAN..PERSON WITH CROWN
	{0x1FAC6, 0x1FACD, prID, gcCn},   //     [8] <reserved-1FAC6>..<reserved-1FACD>
	{0x1FACE, 0x1FADB, prID, gcSo},   //    [14] MOOSE..PEA POD
	{0x1FADC, 0x1FADF, prID, gcCn},   //     [4] <reserved-1FADC>..<reserved-1FADF>
	{0x1FAE0, 0x1FAE8, prID, gcSo},   //     [9] MELTING FACE..SHAKING FACE
	{0x1FAE9, 0x1FAEF, prID, gcCn},   //     [7] <reserved-1FAE9>..<reserved-1FAEF>
	{0x1FAF0, 0x1FAF8, prEB, gcSo},   //     [9] HAND WITH INDEX FINGER AND THUMB CROSSED..RIGHTWARDS PUSHING HAND
	{0x1FAF9, 0x1FAFF, prID, gcCn},   //     [7] <reserved-1FAF9>..<reserved-1FAFF>
	{0x1FB00, 0x1FB92, prAL, gcSo},   //   [147] BLOCK SEXTANT-1..UPPER HALF INVERSE MEDIUM SHADE AND LOWER HALF BLOCK
	{0x1FB94, 0x1FBCA, prAL, gcSo},   //    [55] LEFT HALF INVERSE MEDIUM SHADE AND RIGHT HALF BLOCK..WHITE UP-POINTING CHEVRON
	{0x1FBF0, 0x1FBF9, prNU, gcNd},   //    [10] SEGMENTED DIGIT ZERO..SEGMENTED DIGIT NINE
	{0x1FC00, 0x1FFFD, prID, gcCn},   //  [1022] <reserved-1FC00>..<reserved-1FFFD>
	{0x20000, 0x2A6DF, prID, gcLo},   // [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF
	{0x2A6E0, 0x2A6FF, prID, gcCn},   //    [32] <reserved-2A6E0>..<reserved-2A6FF>
	{0x2A700, 0x2B739, prID, gcLo},   //  [4154] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B739
	{0x2B73A, 0x2B73F, prID, gcCn},   //     [6] <reserved-2B73A>..<reserved-2B73F>
	{0x2B740, 0x2B81D, prID, gcLo},   //   [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D
	{0x2B81E, 0x2B81F, prID, gcCn},   //     [2] <reserved-2B81E>..<reserved-2B81F>
	{0x2B820, 0x2CEA1, prID, gcLo},   //  [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1
	{0x2CEA2, 0x2CEAF, prID, gcCn},   //    [14] <reserved-2CEA2>..<reserved-2CEAF>
	{0x2CEB0, 0x2EBE0, prID, gcLo},   //  [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0
	{0x2EBE1, 0x2F7FF, prID, gcCn},   //  [3103] <reserved-2EBE1>..<reserved-2F7FF>
	{0x2F800, 0x2FA1D, prID, gcLo},   //   [542] CJK COMPATIBILITY IDEOGRAPH-2F800..CJK COMPATIBILITY IDEOGRAPH-2FA1D
	{0x2FA1E, 0x2FA1F, prID, gcCn},   //     [2] <reserved-2FA1E>..<reserved-2FA1F>
	{0x2FA20, 0x2FFFD, prID, gcCn},   //  [1502] <reserved-2FA20>..<reserved-2FFFD>
	{0x30000, 0x3134A, prID, gcLo},   //  [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A
	{0x3134B, 0x3134F, prID, gcCn},   //     [5] <reserved-3134B>..<reserved-3134F>
	{0x31350, 0x323AF, prID, gcLo},   //  [4192] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-323AF
	{0x323B0, 0x3FFFD, prID, gcCn},   // [56398] <reserved-323B0>..<reserved-3FFFD>
	{0xE0001, 0xE0001, prCM, gcCf},   //         LANGUAGE TAG
	{0xE0020, 0xE007F, prCM, gcCf},   //    [96] TAG SPACE..CANCEL TAG
	{0xE0100, 0xE01EF, prCM, gcMn},   //   [240] VARIATION SELECTOR-17..VARIATION SELECTOR-256
	{0xF0000, 0xFFFFD, prXX, gcCo},   // [65534] <private-use-F0000>..<private-use-FFFFD>
	{0x100000, 0x10FFFD, prXX, gcCo}, // [65534] <private-use-100000>..<private-use-10FFFD>
}
