// ui/gfx/mojom/swap_timings.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/gfx/mojom/swap_timings.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/gfx/mojom/swap_timings.mojom-params-data.h"
#include "ui/gfx/mojom/swap_timings.mojom-shared-message-ids.h"

#include "ui/gfx/mojom/swap_timings.mojom-import-headers.h"
#include "ui/gfx/mojom/swap_timings.mojom-test-utils.h"


namespace gfx::mojom {
SwapTimings::SwapTimings()
    : swap_start(),
      swap_end() {}

SwapTimings::SwapTimings(
    ::base::TimeTicks swap_start_in,
    ::base::TimeTicks swap_end_in)
    : swap_start(std::move(swap_start_in)),
      swap_end(std::move(swap_end_in)) {}

SwapTimings::~SwapTimings() = default;

void SwapTimings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_start"), this->swap_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_end"), this->swap_end,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SwapTimings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // gfx::mojom


namespace mojo {


// static
bool StructTraits<::gfx::mojom::SwapTimings::DataView, ::gfx::mojom::SwapTimingsPtr>::Read(
    ::gfx::mojom::SwapTimings::DataView input,
    ::gfx::mojom::SwapTimingsPtr* output) {
  bool success = true;
  ::gfx::mojom::SwapTimingsPtr result(::gfx::mojom::SwapTimings::New());
  
      if (success && !input.ReadSwapStart(&result->swap_start))
        success = false;
      if (success && !input.ReadSwapEnd(&result->swap_end))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gfx::mojom {




}  // gfx::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif