// ui/gfx/mojom/native_handle_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_
#define UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/gfx/mojom/native_handle_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace gfx::mojom {
class NativePixmapPlaneDataView;

class NativePixmapHandleDataView;

class GpuMemoryBufferPlatformHandleDataView;


}  // gfx::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapPlaneDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapPlane_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::NativePixmapHandleDataView> {
  using Data = ::gfx::mojom::internal::NativePixmapHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferPlatformHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


class NativePixmapPlaneDataView {
 public:
  NativePixmapPlaneDataView() = default;

  NativePixmapPlaneDataView(
      internal::NativePixmapPlane_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t stride() const {
    return data_->stride;
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t size() const {
    return data_->size;
  }
  mojo::PlatformHandle TakeBufferHandle() {
    mojo::PlatformHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::PlatformHandle>(
            &data_->buffer_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NativePixmapPlane_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NativePixmapHandleDataView {
 public:
  NativePixmapHandleDataView() = default;

  NativePixmapHandleDataView(
      internal::NativePixmapHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPlanesDataView(
      mojo::ArrayDataView<NativePixmapPlaneDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlanes(UserType* output) {
    
    auto* pointer = data_->planes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::gfx::mojom::NativePixmapPlaneDataView>>(
        pointer, output, message_);
  }
  uint64_t modifier() const {
    return data_->modifier;
  }
  bool supports_zero_copy_webgpu_import() const {
    return data_->supports_zero_copy_webgpu_import;
  }
 private:
  internal::NativePixmapHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GpuMemoryBufferPlatformHandleDataView {
 public:
  using Tag = internal::GpuMemoryBufferPlatformHandle_Data::GpuMemoryBufferPlatformHandle_Tag;

  GpuMemoryBufferPlatformHandleDataView() = default;

  GpuMemoryBufferPlatformHandleDataView(
      internal::GpuMemoryBufferPlatformHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_shared_memory_handle() const { return data_->tag == Tag::kSharedMemoryHandle; }
  inline void GetSharedMemoryHandleDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemoryHandle(UserType* output) const {
    
    CHECK(is_shared_memory_handle());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_shared_memory_handle.Get(), output, message_);
  }
  bool is_native_pixmap_handle() const { return data_->tag == Tag::kNativePixmapHandle; }
  inline void GetNativePixmapHandleDataView(
      NativePixmapHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadNativePixmapHandle(UserType* output) const {
    
    CHECK(is_native_pixmap_handle());
    return mojo::internal::Deserialize<::gfx::mojom::NativePixmapHandleDataView>(
        data_->data.f_native_pixmap_handle.Get(), output, message_);
  }

 private:
  internal::GpuMemoryBufferPlatformHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // gfx::mojom

#endif  // UI_GFX_MOJOM_NATIVE_HANDLE_TYPES_MOJOM_DATA_VIEW_H_