// ui/display/mojom/screen_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/display/mojom/screen_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/display/mojom/screen_info.mojom-params-data.h"
namespace display {
namespace mojom {

namespace internal {


// static
bool ScreenInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenInfo_Data* object =
      static_cast<const ScreenInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_color_spaces, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_color_spaces, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rect, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->available_rect, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->available_rect, validation_context))
    return false;


  if (!::display::mojom::internal::ScreenOrientation_Data
        ::Validate(object->orientation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

ScreenInfo_Data::ScreenInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace display