// ui/accessibility/mojom/ax_updates_and_events.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_DATA_VIEW_H_
#define UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/accessibility/mojom/ax_updates_and_events.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"


namespace ax::mojom {
class AXUpdatesAndEventsDataView;



}  // ax::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXUpdatesAndEventsDataView> {
  using Data = ::ax::mojom::internal::AXUpdatesAndEvents_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ax::mojom {


class AXUpdatesAndEventsDataView {
 public:
  AXUpdatesAndEventsDataView() = default;

  AXUpdatesAndEventsDataView(
      internal::AXUpdatesAndEvents_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTreeIdDataView(
      ::ax::mojom::AXTreeIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTreeId(UserType* output) {
    
    auto* pointer = !data_->tree_id.is_null() ? &data_->tree_id : nullptr;
    return mojo::internal::Deserialize<::ax::mojom::AXTreeIDDataView>(
        pointer, output, message_);
  }
  inline void GetUpdatesDataView(
      mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdates(UserType* output) {
    
    auto* pointer = data_->updates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXTreeUpdateDataView>>(
        pointer, output, message_);
  }
  inline void GetEventsDataView(
      mojo::ArrayDataView<::ax::mojom::AXEventDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvents(UserType* output) {
    
    auto* pointer = data_->events.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::ax::mojom::AXEventDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AXUpdatesAndEvents_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ax::mojom

#endif  // UI_ACCESSIBILITY_MOJOM_AX_UPDATES_AND_EVENTS_MOJOM_DATA_VIEW_H_