// third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* RequestDigitalIdentityStatusToStringHelper(RequestDigitalIdentityStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestDigitalIdentityStatus::kSuccess:
      return "kSuccess";
    case RequestDigitalIdentityStatus::kError:
      return "kError";
    case RequestDigitalIdentityStatus::kErrorTooManyRequests:
      return "kErrorTooManyRequests";
    case RequestDigitalIdentityStatus::kErrorCanceled:
      return "kErrorCanceled";
    case RequestDigitalIdentityStatus::kErrorNoRequests:
      return "kErrorNoRequests";
    case RequestDigitalIdentityStatus::kErrorNoTransientUserActivation:
      return "kErrorNoTransientUserActivation";
    case RequestDigitalIdentityStatus::kErrorInvalidJson:
      return "kErrorInvalidJson";
    default:
      return nullptr;
  }
}

std::string RequestDigitalIdentityStatusToString(RequestDigitalIdentityStatus value) {
  const char *str = RequestDigitalIdentityStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestDigitalIdentityStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestDigitalIdentityStatus value) {
  return os << RequestDigitalIdentityStatusToString(value);
}

namespace internal {


// static
bool DigitalCredentialGetRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalCredentialGetRequest_Data* object =
      static_cast<const DigitalCredentialGetRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

DigitalCredentialGetRequest_Data::DigitalCredentialGetRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalCredentialCreateRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalCredentialCreateRequest_Data* object =
      static_cast<const DigitalCredentialCreateRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

DigitalCredentialCreateRequest_Data::DigitalCredentialCreateRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalIdentityRequest_Get_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalIdentityRequest_Get_Params_Data* object =
      static_cast<const DigitalIdentityRequest_Get_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->digital_credential_requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& digital_credential_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->digital_credential_requests, validation_context,
                                         &digital_credential_requests_validate_params)) {
    return false;
  }

  return true;
}

DigitalIdentityRequest_Get_Params_Data::DigitalIdentityRequest_Get_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalIdentityRequest_Get_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalIdentityRequest_Get_ResponseParams_Data* object =
      static_cast<const DigitalIdentityRequest_Get_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::RequestDigitalIdentityStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->token, validation_context))
    return false;

  return true;
}

DigitalIdentityRequest_Get_ResponseParams_Data::DigitalIdentityRequest_Get_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalIdentityRequest_Create_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalIdentityRequest_Create_Params_Data* object =
      static_cast<const DigitalIdentityRequest_Create_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->digital_credential_requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& digital_credential_requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->digital_credential_requests, validation_context,
                                         &digital_credential_requests_validate_params)) {
    return false;
  }

  return true;
}

DigitalIdentityRequest_Create_Params_Data::DigitalIdentityRequest_Create_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalIdentityRequest_Create_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalIdentityRequest_Create_ResponseParams_Data* object =
      static_cast<const DigitalIdentityRequest_Create_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::RequestDigitalIdentityStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->token, validation_context))
    return false;

  return true;
}

DigitalIdentityRequest_Create_ResponseParams_Data::DigitalIdentityRequest_Create_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DigitalIdentityRequest_Abort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DigitalIdentityRequest_Abort_Params_Data* object =
      static_cast<const DigitalIdentityRequest_Abort_Params_Data*>(data);

  return true;
}

DigitalIdentityRequest_Abort_Params_Data::DigitalIdentityRequest_Abort_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::RequestDigitalIdentityStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::RequestDigitalIdentityStatus value) {
  return std::move(context).WriteString(::blink::mojom::RequestDigitalIdentityStatusToString(value));
}

} // namespace perfetto