// third_party/blink/public/mojom/navigation/renderer_content_settings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_RENDERER_CONTENT_SETTINGS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_RENDERER_CONTENT_SETTINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/renderer_content_settings.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {








class BLINK_COMMON_EXPORT RendererContentSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RendererContentSettings, T>::value>;
  using DataView = RendererContentSettingsDataView;
  using Data_ = internal::RendererContentSettings_Data;

  template <typename... Args>
  static RendererContentSettingsPtr New(Args&&... args) {
    return RendererContentSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RendererContentSettingsPtr From(const U& u) {
    return mojo::TypeConverter<RendererContentSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RendererContentSettings>::Convert(*this);
  }


  RendererContentSettings();

  RendererContentSettings(
      bool allow_script,
      bool allow_image,
      bool allow_popup,
      bool allow_mixed_content,
      bool allow_controlled_frame);


  ~RendererContentSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RendererContentSettingsPtr>
  RendererContentSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererContentSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererContentSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RendererContentSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RendererContentSettings_UnserializedMessageContext<
            UserType, RendererContentSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RendererContentSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RendererContentSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RendererContentSettings_UnserializedMessageContext<
            UserType, RendererContentSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RendererContentSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool allow_script;
  
  bool allow_image;
  
  bool allow_popup;
  
  bool allow_mixed_content;
  
  bool allow_controlled_frame;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RendererContentSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RendererContentSettingsPtr RendererContentSettings::Clone() const {
  return New(
      mojo::Clone(allow_script),
      mojo::Clone(allow_image),
      mojo::Clone(allow_popup),
      mojo::Clone(allow_mixed_content),
      mojo::Clone(allow_controlled_frame)
  );
}

template <typename T, RendererContentSettings::EnableIfSame<T>*>
bool RendererContentSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_script, other_struct.allow_script))
    return false;
  if (!mojo::Equals(this->allow_image, other_struct.allow_image))
    return false;
  if (!mojo::Equals(this->allow_popup, other_struct.allow_popup))
    return false;
  if (!mojo::Equals(this->allow_mixed_content, other_struct.allow_mixed_content))
    return false;
  if (!mojo::Equals(this->allow_controlled_frame, other_struct.allow_controlled_frame))
    return false;
  return true;
}

template <typename T, RendererContentSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allow_script < rhs.allow_script)
    return true;
  if (rhs.allow_script < lhs.allow_script)
    return false;
  if (lhs.allow_image < rhs.allow_image)
    return true;
  if (rhs.allow_image < lhs.allow_image)
    return false;
  if (lhs.allow_popup < rhs.allow_popup)
    return true;
  if (rhs.allow_popup < lhs.allow_popup)
    return false;
  if (lhs.allow_mixed_content < rhs.allow_mixed_content)
    return true;
  if (rhs.allow_mixed_content < lhs.allow_mixed_content)
    return false;
  if (lhs.allow_controlled_frame < rhs.allow_controlled_frame)
    return true;
  if (rhs.allow_controlled_frame < lhs.allow_controlled_frame)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RendererContentSettings::DataView,
                                         ::blink::mojom::RendererContentSettingsPtr> {
  static bool IsNull(const ::blink::mojom::RendererContentSettingsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RendererContentSettingsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::RendererContentSettings::allow_script) allow_script(
      const ::blink::mojom::RendererContentSettingsPtr& input) {
    return input->allow_script;
  }

  static decltype(::blink::mojom::RendererContentSettings::allow_image) allow_image(
      const ::blink::mojom::RendererContentSettingsPtr& input) {
    return input->allow_image;
  }

  static decltype(::blink::mojom::RendererContentSettings::allow_popup) allow_popup(
      const ::blink::mojom::RendererContentSettingsPtr& input) {
    return input->allow_popup;
  }

  static decltype(::blink::mojom::RendererContentSettings::allow_mixed_content) allow_mixed_content(
      const ::blink::mojom::RendererContentSettingsPtr& input) {
    return input->allow_mixed_content;
  }

  static decltype(::blink::mojom::RendererContentSettings::allow_controlled_frame) allow_controlled_frame(
      const ::blink::mojom::RendererContentSettingsPtr& input) {
    return input->allow_controlled_frame;
  }

  static bool Read(::blink::mojom::RendererContentSettings::DataView input, ::blink::mojom::RendererContentSettingsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_RENDERER_CONTENT_SETTINGS_MOJOM_H_