// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_cloud_identifier.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_handle.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-forward.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_permission_mode.mojom-forward.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FileSystemAccessDirectoryEntriesListenerProxy;

template <typename ImplRefTraits>
class FileSystemAccessDirectoryEntriesListenerStub;

class FileSystemAccessDirectoryEntriesListenerRequestValidator;


class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListener
    : public FileSystemAccessDirectoryEntriesListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessDirectoryEntriesListener";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessDirectoryEntriesListenerInterfaceBase;
  using Proxy_ = FileSystemAccessDirectoryEntriesListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessDirectoryEntriesListenerStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessDirectoryEntriesListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReadDirectoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReadDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessDirectoryEntriesListener() = default;

  virtual void DidReadDirectory(::blink::mojom::FileSystemAccessErrorPtr result, std::vector<FileSystemAccessEntryPtr> entries, bool has_more_entries) = 0;
};

class FileSystemAccessDirectoryHandleProxy;

template <typename ImplRefTraits>
class FileSystemAccessDirectoryHandleStub;

class FileSystemAccessDirectoryHandleRequestValidator;
class FileSystemAccessDirectoryHandleResponseValidator;


class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandle
    : public FileSystemAccessDirectoryHandleInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessDirectoryHandle";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessDirectoryHandleInterfaceBase;
  using Proxy_ = FileSystemAccessDirectoryHandleProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessDirectoryHandleStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessDirectoryHandleRequestValidator;
  using ResponseValidator_ = FileSystemAccessDirectoryHandleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPermissionStatusMinVersion = 0,
    kRequestPermissionMinVersion = 0,
    kGetFileMinVersion = 0,
    kGetDirectoryMinVersion = 0,
    kGetEntriesMinVersion = 0,
    kRenameMinVersion = 0,
    kMoveMinVersion = 0,
    kRemoveMinVersion = 0,
    kRemoveEntryMinVersion = 0,
    kResolveMinVersion = 0,
    kTransferMinVersion = 0,
    kGetUniqueIdMinVersion = 0,
    kGetCloudIdentifiersMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPermissionStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestPermission_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Rename_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Move_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resolve_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Transfer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetUniqueId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetCloudIdentifiers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessDirectoryHandle() = default;

  using GetPermissionStatusCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;
  using GetPermissionStatusMojoCallback = base::OnceCallback<void(::blink::mojom::PermissionStatus)>;

  virtual void GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) = 0;

  using RequestPermissionCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::blink::mojom::PermissionStatus)>;
  using RequestPermissionMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::blink::mojom::PermissionStatus)>;

  virtual void RequestPermission(::blink::mojom::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) = 0;

  using GetFileCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>)>;
  using GetFileMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>)>;

  virtual void GetFile(const std::string& basename, bool create, GetFileCallback callback) = 0;

  using GetDirectoryCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>)>;
  using GetDirectoryMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>)>;

  virtual void GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) = 0;

  virtual void GetEntries(::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> listener) = 0;

  using RenameCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;
  using RenameMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;

  virtual void Rename(const std::string& new_entry_name, RenameCallback callback) = 0;

  using MoveCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;
  using MoveMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;

  virtual void Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, MoveCallback callback) = 0;

  using RemoveCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;
  using RemoveMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;

  virtual void Remove(bool recurse, RemoveCallback callback) = 0;

  using RemoveEntryCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;
  using RemoveEntryMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr)>;

  virtual void RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) = 0;

  using ResolveCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, const std::optional<std::vector<std::string>>&)>;
  using ResolveMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, const std::optional<std::vector<std::string>>&)>;

  virtual void Resolve(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ResolveCallback callback) = 0;

  virtual void Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) = 0;

  using GetUniqueIdCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, const std::string&)>;
  using GetUniqueIdMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, const std::string&)>;

  virtual void GetUniqueId(GetUniqueIdCallback callback) = 0;

  using GetCloudIdentifiersCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>)>;
  using GetCloudIdentifiersMojoCallback = base::OnceCallback<void(::blink::mojom::FileSystemAccessErrorPtr, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>)>;

  virtual void GetCloudIdentifiers(GetCloudIdentifiersCallback callback) = 0;
};



class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListenerProxy
    : public FileSystemAccessDirectoryEntriesListener {
 public:
  using InterfaceType = FileSystemAccessDirectoryEntriesListener;

  explicit FileSystemAccessDirectoryEntriesListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReadDirectory(::blink::mojom::FileSystemAccessErrorPtr result, std::vector<FileSystemAccessEntryPtr> entries, bool has_more_entries) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleProxy
    : public FileSystemAccessDirectoryHandle {
 public:
  using InterfaceType = FileSystemAccessDirectoryHandle;

  explicit FileSystemAccessDirectoryHandleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) final;
  
  void RequestPermission(::blink::mojom::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) final;
  
  void GetFile(const std::string& basename, bool create, GetFileCallback callback) final;
  
  void GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) final;
  
  void GetEntries(::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> listener) final;
  
  void Rename(const std::string& new_entry_name, RenameCallback callback) final;
  
  void Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, MoveCallback callback) final;
  
  void Remove(bool recurse, RemoveCallback callback) final;
  
  void RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) final;
  
  void Resolve(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ResolveCallback callback) final;
  
  void Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) final;
  
  void GetUniqueId(GetUniqueIdCallback callback) final;
  
  void GetCloudIdentifiers(GetCloudIdentifiersCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListenerStubDispatch {
 public:
  static bool Accept(FileSystemAccessDirectoryEntriesListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessDirectoryEntriesListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessDirectoryEntriesListener>>
class FileSystemAccessDirectoryEntriesListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessDirectoryEntriesListenerStub() = default;
  ~FileSystemAccessDirectoryEntriesListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessDirectoryEntriesListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessDirectoryEntriesListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleStubDispatch {
 public:
  static bool Accept(FileSystemAccessDirectoryHandle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessDirectoryHandle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessDirectoryHandle>>
class FileSystemAccessDirectoryHandleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessDirectoryHandleStub() = default;
  ~FileSystemAccessDirectoryHandleStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessDirectoryHandleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessDirectoryHandleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_COMMON_EXPORT FileSystemAccessHandle {
 public:
  using DataView = FileSystemAccessHandleDataView;
  using Data_ = internal::FileSystemAccessHandle_Data;
  using Tag = Data_::FileSystemAccessHandle_Tag;

  template <typename... Args>
  static FileSystemAccessHandlePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |file|.
  static FileSystemAccessHandlePtr NewFile(
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value);
  // Construct an instance holding |directory|.
  static FileSystemAccessHandlePtr NewDirectory(
      ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value);

  template <typename U>
  static FileSystemAccessHandlePtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessHandle>::Convert(*this);
  }
  ~FileSystemAccessHandle();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  FileSystemAccessHandle(const FileSystemAccessHandle& other) = delete;
  FileSystemAccessHandle& operator=(const FileSystemAccessHandle& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FileSystemAccessHandlePtr>
  FileSystemAccessHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessHandle>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FileSystemAccessHandle>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_file() const { return tag_ == Tag::kFile; }
  const ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>& get_file() const {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>& get_file() {
    CHECK(tag_ == Tag::kFile);
    return data_.file;
  }
  void set_file(::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file);

  bool is_directory() const { return tag_ == Tag::kDirectory; }
  const ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>& get_directory() const {
    CHECK(tag_ == Tag::kDirectory);
    return data_.directory;
  }
  ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>& get_directory() {
    CHECK(tag_ == Tag::kDirectory);
    return data_.directory;
  }
  void set_directory(::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessHandle::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FileSystemAccessHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
        ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDirectory)>,
        ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> file;
    ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> directory;
  };

  FileSystemAccessHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kFile)>,
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle> value);
  FileSystemAccessHandle(
      std::in_place_index_t<static_cast<size_t>(Tag::kDirectory)>,
      ::mojo::PendingRemote<FileSystemAccessDirectoryHandle> value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT FileSystemAccessEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileSystemAccessEntry, T>::value>;
  using DataView = FileSystemAccessEntryDataView;
  using Data_ = internal::FileSystemAccessEntry_Data;

  template <typename... Args>
  static FileSystemAccessEntryPtr New(Args&&... args) {
    return FileSystemAccessEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileSystemAccessEntryPtr From(const U& u) {
    return mojo::TypeConverter<FileSystemAccessEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileSystemAccessEntry>::Convert(*this);
  }


  FileSystemAccessEntry();

  FileSystemAccessEntry(
      FileSystemAccessHandlePtr entry_handle,
      const std::string& name);

FileSystemAccessEntry(const FileSystemAccessEntry&) = delete;
FileSystemAccessEntry& operator=(const FileSystemAccessEntry&) = delete;

  ~FileSystemAccessEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileSystemAccessEntryPtr>
  FileSystemAccessEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileSystemAccessEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileSystemAccessEntry_UnserializedMessageContext<
            UserType, FileSystemAccessEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileSystemAccessEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileSystemAccessEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileSystemAccessEntry_UnserializedMessageContext<
            UserType, FileSystemAccessEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileSystemAccessEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  FileSystemAccessHandlePtr entry_handle;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileSystemAccessEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
FileSystemAccessHandlePtr FileSystemAccessHandle::Clone() const {
  switch (tag_) {
    case Tag::kFile:
      return NewFile(
          mojo::Clone(data_.file));
    case Tag::kDirectory:
      return NewDirectory(
          mojo::Clone(data_.directory));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FileSystemAccessHandle>::value>::type*>
bool FileSystemAccessHandle::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFile:
      return mojo::Equals(data_.file, other.data_.file);
    case Tag::kDirectory:
      return mojo::Equals(data_.directory, other.data_.directory);
  }

  return false;
}
template <typename StructPtrType>
FileSystemAccessEntryPtr FileSystemAccessEntry::Clone() const {
  return New(
      mojo::Clone(entry_handle),
      mojo::Clone(name)
  );
}

template <typename T, FileSystemAccessEntry::EnableIfSame<T>*>
bool FileSystemAccessEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->entry_handle, other_struct.entry_handle))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, FileSystemAccessEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.entry_handle < rhs.entry_handle)
    return true;
  if (rhs.entry_handle < lhs.entry_handle)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FileSystemAccessEntry::DataView,
                                         ::blink::mojom::FileSystemAccessEntryPtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessEntryPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::FileSystemAccessEntry::entry_handle)& entry_handle(
       ::blink::mojom::FileSystemAccessEntryPtr& input) {
    return input->entry_handle;
  }

  static const decltype(::blink::mojom::FileSystemAccessEntry::name)& name(
      const ::blink::mojom::FileSystemAccessEntryPtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::FileSystemAccessEntry::DataView input, ::blink::mojom::FileSystemAccessEntryPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::FileSystemAccessHandle::DataView,
                                        ::blink::mojom::FileSystemAccessHandlePtr> {
  static bool IsNull(const ::blink::mojom::FileSystemAccessHandlePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FileSystemAccessHandlePtr* output) { output->reset(); }

  static ::blink::mojom::FileSystemAccessHandle::Tag GetTag(const ::blink::mojom::FileSystemAccessHandlePtr& input) {
    return input->which();
  }

  static  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>& file( ::blink::mojom::FileSystemAccessHandlePtr& input) {
    return input->get_file();
  }

  static  ::mojo::PendingRemote<::blink::mojom::FileSystemAccessDirectoryHandle>& directory( ::blink::mojom::FileSystemAccessHandlePtr& input) {
    return input->get_directory();
  }

  static bool Read(::blink::mojom::FileSystemAccessHandle::DataView input, ::blink::mojom::FileSystemAccessHandlePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_H_