// third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace blink::mojom {
class CredentialInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::CredentialInfoDataView> {
  using Data = ::blink::mojom::internal::CredentialInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class CredentialType : int32_t {
  
  EMPTY = 0,
  
  PASSWORD = 1,
  
  FEDERATED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CredentialType value);
inline bool IsKnownEnumValue(CredentialType value) {
  return internal::CredentialType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CredentialMediationRequirement : int32_t {
  
  kSilent = 0,
  
  kOptional = 1,
  
  kRequired = 2,
  
  kConditional = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CredentialMediationRequirement value);
inline bool IsKnownEnumValue(CredentialMediationRequirement value) {
  return internal::CredentialMediationRequirement_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CredentialManagerError : int32_t {
  
  SUCCESS = 0,
  
  PENDING_REQUEST = 1,
  
  PASSWORD_STORE_UNAVAILABLE = 2,
  
  UNKNOWN = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CredentialManagerError value);
inline bool IsKnownEnumValue(CredentialManagerError value) {
  return internal::CredentialManagerError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CredentialManagerInterfaceBase {};

using CredentialManagerPtrDataView =
    mojo::InterfacePtrDataView<CredentialManagerInterfaceBase>;
using CredentialManagerRequestDataView =
    mojo::InterfaceRequestDataView<CredentialManagerInterfaceBase>;
using CredentialManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CredentialManagerInterfaceBase>;
using CredentialManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CredentialManagerInterfaceBase>;


class CredentialInfoDataView {
 public:
  CredentialInfoDataView() = default;

  CredentialInfoDataView(
      internal::CredentialInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::CredentialType>(
        data_value, output);
  }
  CredentialType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::CredentialType>(data_->type));
  }
  inline void GetIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetPasswordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPassword(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `password` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPassword` instead "
    "of `ReadPassword if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->password.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetFederationDataView(
      ::url::mojom::SchemeHostPortDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFederation(UserType* output) {
    
    auto* pointer = data_->federation.Get();
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        pointer, output, message_);
  }
 private:
  internal::CredentialInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CREDENTIALMANAGEMENT_CREDENTIAL_MANAGER_MOJOM_DATA_VIEW_H_