// third_party/blink/public/mojom/blob/data_element.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/blob/data_element.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/blob/data_element.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DataElementBytesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementBytesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementBytes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->length = Traits::length(input);

    decltype(Traits::embedded_data(input)) in_embedded_data = Traits::embedded_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->embedded_data)::BaseType>
        embedded_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& embedded_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_embedded_data,
      embedded_data_fragment,
      &embedded_data_validate_params);

    fragment->embedded_data.Set(
        embedded_data_fragment.is_null() ? nullptr : embedded_data_fragment.data());

    decltype(Traits::data(input)) in_data = Traits::data(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BytesProviderInterfaceBase>>(
      in_data,
      &fragment->data,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in DataElementBytes struct");
  }

  static bool Deserialize(::blink::mojom::internal::DataElementBytes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DataElementBytesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DataElementFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in DataElementFile struct");

    fragment->offset = Traits::offset(input);

    fragment->length = Traits::length(input);

    decltype(Traits::expected_modification_time(input)) in_expected_modification_time = Traits::expected_modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_modification_time)::BaseType> expected_modification_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expected_modification_time,
      expected_modification_time_fragment);

    fragment->expected_modification_time.Set(
        expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DataElementFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DataElementFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DataElementBlobDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DataElementBlobDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DataElementBlob_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::blob(input)) in_blob = Traits::blob(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob,
      &fragment->blob,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blob)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in DataElementBlob struct");

    fragment->offset = Traits::offset(input);

    fragment->length = Traits::length(input);
  }

  static bool Deserialize(::blink::mojom::internal::DataElementBlob_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DataElementBlobDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DataElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DataElementDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DataElement_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::DataElementDataView::Tag::kBytes: {
    decltype(Traits::bytes(input))
    in_bytes = Traits::bytes(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_bytes)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementBytesDataView>(
  in_bytes,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null bytes in DataElement union");
    fragment->data.f_bytes.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DataElementDataView::Tag::kFile: {
    decltype(Traits::file(input))
    in_file = Traits::file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementFileDataView>(
  in_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null file in DataElement union");
    fragment->data.f_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::DataElementDataView::Tag::kBlob: {
    decltype(Traits::blob(input))
    in_blob = Traits::blob(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_blob)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::DataElementBlobDataView>(
  in_blob,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null blob in DataElement union");
    fragment->data.f_blob.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::DataElement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DataElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void DataElementBytesDataView::GetEmbeddedDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->embedded_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void DataElementFileDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DataElementFileDataView::GetExpectedModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expected_modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}




inline void DataElementDataView::GetBytesDataView(
    DataElementBytesDataView* output) const {
  CHECK(is_bytes());
  *output = DataElementBytesDataView(data_->data.f_bytes.Get(), message_);
}
inline void DataElementDataView::GetFileDataView(
    DataElementFileDataView* output) const {
  CHECK(is_file());
  *output = DataElementFileDataView(data_->data.f_file.Get(), message_);
}
inline void DataElementDataView::GetBlobDataView(
    DataElementBlobDataView* output) const {
  CHECK(is_blob());
  *output = DataElementBlobDataView(data_->data.f_blob.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLOB_DATA_ELEMENT_MOJOM_SHARED_H_