// services/viz/public/mojom/compositing/surface_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/surface_info.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "services/viz/public/mojom/compositing/surface_info.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::SurfaceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::SurfaceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::SurfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::surface_id(input)) in_surface_id = Traits::surface_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->surface_id)::BaseType> surface_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_surface_id,
      surface_id_fragment);

    fragment->surface_id.Set(
        surface_id_fragment.is_null() ? nullptr : surface_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->surface_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_id in SurfaceInfo struct");

    fragment->device_scale_factor = Traits::device_scale_factor(input);

    decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size_in_pixels,
      size_in_pixels_fragment);

    fragment->size_in_pixels.Set(
        size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size_in_pixels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size_in_pixels in SurfaceInfo struct");
  }

  static bool Deserialize(::viz::mojom::internal::SurfaceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::SurfaceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void SurfaceInfoDataView::GetSurfaceIdDataView(
    ::viz::mojom::SurfaceIdDataView* output) {
  auto pointer = data_->surface_id.Get();
  *output = ::viz::mojom::SurfaceIdDataView(pointer, message_);
}
inline void SurfaceInfoDataView::GetSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_SURFACE_INFO_MOJOM_SHARED_H_