// services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-test-utils.h"


namespace viz::mojom {
FrameCountingPerSinkData::FrameCountingPerSinkData()
    : is_root(),
      debug_label(),
      start_bucket(),
      presented_frames() {}

FrameCountingPerSinkData::FrameCountingPerSinkData(
    bool is_root_in,
    const std::string& debug_label_in,
    uint16_t start_bucket_in,
    std::vector<uint16_t> presented_frames_in)
    : is_root(std::move(is_root_in)),
      debug_label(std::move(debug_label_in)),
      start_bucket(std::move(start_bucket_in)),
      presented_frames(std::move(presented_frames_in)) {}

FrameCountingPerSinkData::~FrameCountingPerSinkData() = default;

void FrameCountingPerSinkData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_root"), this->is_root,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_label"), this->debug_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_bucket"), this->start_bucket,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "presented_frames"), this->presented_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameCountingPerSinkData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FrameCountingData::FrameCountingData()
    : per_sink_data() {}

FrameCountingData::FrameCountingData(
    std::vector<FrameCountingPerSinkDataPtr> per_sink_data_in)
    : per_sink_data(std::move(per_sink_data_in)) {}

FrameCountingData::~FrameCountingData() = default;

void FrameCountingData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "per_sink_data"), this->per_sink_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FrameCountingPerSinkDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameCountingData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OverdrawData::OverdrawData()
    : average_overdraws() {}

OverdrawData::OverdrawData(
    std::vector<float> average_overdraws_in)
    : average_overdraws(std::move(average_overdraws_in)) {}

OverdrawData::~OverdrawData() = default;

void OverdrawData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "average_overdraws"), this->average_overdraws,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OverdrawData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

FrameSinksMetricsRecorder::IPCStableHashFunction FrameSinksMetricsRecorder::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinksMetricsRecorder>(message.name())) {
    case messages::FrameSinksMetricsRecorder::kStartFrameCounting: {
      return &FrameSinksMetricsRecorder::StartFrameCounting_Sym::IPCStableHash;
    }
    case messages::FrameSinksMetricsRecorder::kStopFrameCounting: {
      return &FrameSinksMetricsRecorder::StopFrameCounting_Sym::IPCStableHash;
    }
    case messages::FrameSinksMetricsRecorder::kStartOverdrawTracking: {
      return &FrameSinksMetricsRecorder::StartOverdrawTracking_Sym::IPCStableHash;
    }
    case messages::FrameSinksMetricsRecorder::kStopOverdrawTracking: {
      return &FrameSinksMetricsRecorder::StopOverdrawTracking_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinksMetricsRecorder::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinksMetricsRecorder>(message.name())) {
      case messages::FrameSinksMetricsRecorder::kStartFrameCounting:
            return "Receive viz::mojom::FrameSinksMetricsRecorder::StartFrameCounting";
      case messages::FrameSinksMetricsRecorder::kStopFrameCounting:
            return "Receive viz::mojom::FrameSinksMetricsRecorder::StopFrameCounting";
      case messages::FrameSinksMetricsRecorder::kStartOverdrawTracking:
            return "Receive viz::mojom::FrameSinksMetricsRecorder::StartOverdrawTracking";
      case messages::FrameSinksMetricsRecorder::kStopOverdrawTracking:
            return "Receive viz::mojom::FrameSinksMetricsRecorder::StopOverdrawTracking";
    }
  } else {
    switch (static_cast<messages::FrameSinksMetricsRecorder>(message.name())) {
      case messages::FrameSinksMetricsRecorder::kStartFrameCounting:
            return "Receive reply viz::mojom::FrameSinksMetricsRecorder::StartFrameCounting";
      case messages::FrameSinksMetricsRecorder::kStopFrameCounting:
            return "Receive reply viz::mojom::FrameSinksMetricsRecorder::StopFrameCounting";
      case messages::FrameSinksMetricsRecorder::kStartOverdrawTracking:
            return "Receive reply viz::mojom::FrameSinksMetricsRecorder::StartOverdrawTracking";
      case messages::FrameSinksMetricsRecorder::kStopOverdrawTracking:
            return "Receive reply viz::mojom::FrameSinksMetricsRecorder::StopOverdrawTracking";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinksMetricsRecorder::StartFrameCounting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7878518;  // IPCStableHash for viz::mojom::FrameSinksMetricsRecorder::StartFrameCounting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinksMetricsRecorder::StopFrameCounting_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf19a0d63;  // IPCStableHash for viz::mojom::FrameSinksMetricsRecorder::StopFrameCounting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinksMetricsRecorder::StartOverdrawTracking_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ba31713;  // IPCStableHash for viz::mojom::FrameSinksMetricsRecorder::StartOverdrawTracking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinksMetricsRecorder::StopOverdrawTracking_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa3132983;  // IPCStableHash for viz::mojom::FrameSinksMetricsRecorder::StopOverdrawTracking
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback(
      FrameSinksMetricsRecorder::StopFrameCountingCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback(const FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback&) = delete;
  FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback& operator=(const FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinksMetricsRecorder::StopFrameCountingCallback callback_;
};

class FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback(
      FrameSinksMetricsRecorder::StopOverdrawTrackingCallback callback
      ) : callback_(std::move(callback)) {
  }

  FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback(const FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback&) = delete;
  FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback& operator=(const FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FrameSinksMetricsRecorder::StopOverdrawTrackingCallback callback_;
};

FrameSinksMetricsRecorderProxy::FrameSinksMetricsRecorderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinksMetricsRecorderProxy::StartFrameCounting(
    ::base::TimeTicks in_start_time, ::base::TimeDelta in_bucket_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinksMetricsRecorder::StartFrameCounting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("start_time"), in_start_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_size"), in_bucket_size,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStartFrameCounting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StartFrameCounting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->start_time)::BaseType> start_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_start_time,
    start_time_fragment);

  params->start_time.Set(
      start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->start_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null start_time in FrameSinksMetricsRecorder.StartFrameCounting request");
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_size)::BaseType> bucket_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_bucket_size,
    bucket_size_fragment);

  params->bucket_size.Set(
      bucket_size_fragment.is_null() ? nullptr : bucket_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_size in FrameSinksMetricsRecorder.StartFrameCounting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StartFrameCounting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinksMetricsRecorderProxy::StopFrameCounting(
    StopFrameCountingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinksMetricsRecorder::StopFrameCounting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStopFrameCounting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StopFrameCounting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StopFrameCounting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FrameSinksMetricsRecorderProxy::StartOverdrawTracking(
    const ::viz::FrameSinkId& in_root_frame_sink_id, ::base::TimeDelta in_bucket_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinksMetricsRecorder::StartOverdrawTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_frame_sink_id"), in_root_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_size"), in_bucket_size,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStartOverdrawTracking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StartOverdrawTracking_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_frame_sink_id)::BaseType> root_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_root_frame_sink_id,
    root_frame_sink_id_fragment);

  params->root_frame_sink_id.Set(
      root_frame_sink_id_fragment.is_null() ? nullptr : root_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_frame_sink_id in FrameSinksMetricsRecorder.StartOverdrawTracking request");
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_size)::BaseType> bucket_size_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_bucket_size,
    bucket_size_fragment);

  params->bucket_size.Set(
      bucket_size_fragment.is_null() ? nullptr : bucket_size_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bucket_size.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bucket_size in FrameSinksMetricsRecorder.StartOverdrawTracking request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StartOverdrawTracking");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinksMetricsRecorderProxy::StopOverdrawTracking(
    const ::viz::FrameSinkId& in_root_frame_sink_id, StopOverdrawTrackingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinksMetricsRecorder::StopOverdrawTracking", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("root_frame_sink_id"), in_root_frame_sink_id,
                        "<value of type const ::viz::FrameSinkId&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStopOverdrawTracking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StopOverdrawTracking_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->root_frame_sink_id)::BaseType> root_frame_sink_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView>(
    in_root_frame_sink_id,
    root_frame_sink_id_fragment);

  params->root_frame_sink_id.Set(
      root_frame_sink_id_fragment.is_null() ? nullptr : root_frame_sink_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->root_frame_sink_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null root_frame_sink_id in FrameSinksMetricsRecorder.StopOverdrawTracking request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StopOverdrawTracking");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinksMetricsRecorder::StopFrameCountingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder> proxy(
        new FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinksMetricsRecorder::StopFrameCountingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      FrameCountingDataPtr in_data);
};

bool FrameSinksMetricsRecorder_StopFrameCounting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinksMetricsRecorder_StopFrameCounting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinksMetricsRecorder_StopFrameCounting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinksMetricsRecorder.1
  bool success = true;
  FrameCountingDataPtr p_data{};
  FrameSinksMetricsRecorder_StopFrameCounting_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinksMetricsRecorder::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder::Run(
    FrameCountingDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::FrameSinksMetricsRecorder::StopFrameCounting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type FrameCountingDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStopFrameCounting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StopFrameCounting_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameCountingDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StopFrameCounting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FrameSinksMetricsRecorder::StopOverdrawTrackingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder> proxy(
        new FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameSinksMetricsRecorder::StopOverdrawTrackingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      OverdrawDataPtr in_data);
};

bool FrameSinksMetricsRecorder_StopOverdrawTracking_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FrameSinksMetricsRecorder_StopOverdrawTracking_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameSinksMetricsRecorder_StopOverdrawTracking_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FrameSinksMetricsRecorder.3
  bool success = true;
  OverdrawDataPtr p_data{};
  FrameSinksMetricsRecorder_StopOverdrawTracking_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameSinksMetricsRecorder::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder::Run(
    OverdrawDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply viz::mojom::FrameSinksMetricsRecorder::StopOverdrawTracking", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type OverdrawDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinksMetricsRecorder::kStopOverdrawTracking), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinksMetricsRecorder_StopOverdrawTracking_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::OverdrawDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinksMetricsRecorder::Name_);
  message.set_method_name("StopOverdrawTracking");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameSinksMetricsRecorderStubDispatch::Accept(
    FrameSinksMetricsRecorder* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinksMetricsRecorder>(message->header()->name)) {
    case messages::FrameSinksMetricsRecorder::kStartFrameCounting: {
      DCHECK(message->is_serialized());
      internal::FrameSinksMetricsRecorder_StartFrameCounting_Params_Data* params =
          reinterpret_cast<internal::FrameSinksMetricsRecorder_StartFrameCounting_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinksMetricsRecorder.0
      bool success = true;
      ::base::TimeTicks p_start_time{};
      ::base::TimeDelta p_bucket_size{};
      FrameSinksMetricsRecorder_StartFrameCounting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadBucketSize(&p_bucket_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinksMetricsRecorder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartFrameCounting(        
        std::move(p_start_time), 
        std::move(p_bucket_size));
      return true;
    }
    case messages::FrameSinksMetricsRecorder::kStopFrameCounting: {
      break;
    }
    case messages::FrameSinksMetricsRecorder::kStartOverdrawTracking: {
      DCHECK(message->is_serialized());
      internal::FrameSinksMetricsRecorder_StartOverdrawTracking_Params_Data* params =
          reinterpret_cast<internal::FrameSinksMetricsRecorder_StartOverdrawTracking_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FrameSinksMetricsRecorder.2
      bool success = true;
      ::viz::FrameSinkId p_root_frame_sink_id{};
      ::base::TimeDelta p_bucket_size{};
      FrameSinksMetricsRecorder_StartOverdrawTracking_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootFrameSinkId(&p_root_frame_sink_id))
        success = false;
      if (success && !input_data_view.ReadBucketSize(&p_bucket_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinksMetricsRecorder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartOverdrawTracking(        
        std::move(p_root_frame_sink_id), 
        std::move(p_bucket_size));
      return true;
    }
    case messages::FrameSinksMetricsRecorder::kStopOverdrawTracking: {
      break;
    }
  }
  return false;
}

// static
bool FrameSinksMetricsRecorderStubDispatch::AcceptWithResponder(
    FrameSinksMetricsRecorder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinksMetricsRecorder>(message->header()->name)) {
    case messages::FrameSinksMetricsRecorder::kStartFrameCounting: {
      break;
    }
    case messages::FrameSinksMetricsRecorder::kStopFrameCounting: {
      internal::FrameSinksMetricsRecorder_StopFrameCounting_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinksMetricsRecorder_StopFrameCounting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinksMetricsRecorder.1
      bool success = true;
      FrameSinksMetricsRecorder_StopFrameCounting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinksMetricsRecorder::Name_, 1, false);
        return false;
      }
      auto callback =
          FrameSinksMetricsRecorder_StopFrameCounting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopFrameCounting(std::move(callback));
      return true;
    }
    case messages::FrameSinksMetricsRecorder::kStartOverdrawTracking: {
      break;
    }
    case messages::FrameSinksMetricsRecorder::kStopOverdrawTracking: {
      internal::FrameSinksMetricsRecorder_StopOverdrawTracking_Params_Data* params =
          reinterpret_cast<
              internal::FrameSinksMetricsRecorder_StopOverdrawTracking_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FrameSinksMetricsRecorder.3
      bool success = true;
      ::viz::FrameSinkId p_root_frame_sink_id{};
      FrameSinksMetricsRecorder_StopOverdrawTracking_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRootFrameSinkId(&p_root_frame_sink_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinksMetricsRecorder::Name_, 3, false);
        return false;
      }
      auto callback =
          FrameSinksMetricsRecorder_StopOverdrawTracking_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopOverdrawTracking(        
        std::move(p_root_frame_sink_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinksMetricsRecorderValidationInfo[] = {
    {base::to_underlying(messages::FrameSinksMetricsRecorder::kStartFrameCounting),
     { &internal::FrameSinksMetricsRecorder_StartFrameCounting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinksMetricsRecorder::kStopFrameCounting),
     { &internal::FrameSinksMetricsRecorder_StopFrameCounting_Params_Data::Validate,
      &internal::FrameSinksMetricsRecorder_StopFrameCounting_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::FrameSinksMetricsRecorder::kStartOverdrawTracking),
     { &internal::FrameSinksMetricsRecorder_StartOverdrawTracking_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinksMetricsRecorder::kStopOverdrawTracking),
     { &internal::FrameSinksMetricsRecorder_StopOverdrawTracking_Params_Data::Validate,
      &internal::FrameSinksMetricsRecorder_StopOverdrawTracking_ResponseParams_Data::Validate}},
};

bool FrameSinksMetricsRecorderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::viz::mojom::FrameSinksMetricsRecorder::Name_,
    kFrameSinksMetricsRecorderValidationInfo);
}

bool FrameSinksMetricsRecorderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::viz::mojom::FrameSinksMetricsRecorder::Name_,
    kFrameSinksMetricsRecorderValidationInfo);

}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::FrameCountingPerSinkData::DataView, ::viz::mojom::FrameCountingPerSinkDataPtr>::Read(
    ::viz::mojom::FrameCountingPerSinkData::DataView input,
    ::viz::mojom::FrameCountingPerSinkDataPtr* output) {
  bool success = true;
  ::viz::mojom::FrameCountingPerSinkDataPtr result(::viz::mojom::FrameCountingPerSinkData::New());
  
      if (success)
        result->is_root = input.is_root();
      if (success && !input.ReadDebugLabel(&result->debug_label))
        success = false;
      if (success)
        result->start_bucket = input.start_bucket();
      if (success && !input.ReadPresentedFrames(&result->presented_frames))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::FrameCountingData::DataView, ::viz::mojom::FrameCountingDataPtr>::Read(
    ::viz::mojom::FrameCountingData::DataView input,
    ::viz::mojom::FrameCountingDataPtr* output) {
  bool success = true;
  ::viz::mojom::FrameCountingDataPtr result(::viz::mojom::FrameCountingData::New());
  
      if (success && !input.ReadPerSinkData(&result->per_sink_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::OverdrawData::DataView, ::viz::mojom::OverdrawDataPtr>::Read(
    ::viz::mojom::OverdrawData::DataView input,
    ::viz::mojom::OverdrawDataPtr* output) {
  bool success = true;
  ::viz::mojom::OverdrawDataPtr result(::viz::mojom::OverdrawData::New());
  
      if (success && !input.ReadAverageOverdraws(&result->average_overdraws))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void FrameSinksMetricsRecorderInterceptorForTesting::StartFrameCounting(::base::TimeTicks start_time, ::base::TimeDelta bucket_size) {
  GetForwardingInterface()->StartFrameCounting(
    std::move(start_time)
    , 
    std::move(bucket_size)
    );
}
void FrameSinksMetricsRecorderInterceptorForTesting::StopFrameCounting(StopFrameCountingCallback callback) {
  GetForwardingInterface()->StopFrameCounting(std::move(callback));
}
void FrameSinksMetricsRecorderInterceptorForTesting::StartOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, ::base::TimeDelta bucket_size) {
  GetForwardingInterface()->StartOverdrawTracking(
    std::move(root_frame_sink_id)
    , 
    std::move(bucket_size)
    );
}
void FrameSinksMetricsRecorderInterceptorForTesting::StopOverdrawTracking(const ::viz::FrameSinkId& root_frame_sink_id, StopOverdrawTrackingCallback callback) {
  GetForwardingInterface()->StopOverdrawTracking(
    std::move(root_frame_sink_id)
    , std::move(callback));
}
FrameSinksMetricsRecorderAsyncWaiter::FrameSinksMetricsRecorderAsyncWaiter(
    FrameSinksMetricsRecorder* proxy) : proxy_(proxy) {}

FrameSinksMetricsRecorderAsyncWaiter::~FrameSinksMetricsRecorderAsyncWaiter() = default;


void FrameSinksMetricsRecorderAsyncWaiter::StopFrameCounting(
    FrameCountingDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->StopFrameCounting(
      base::BindOnce(
          [](base::RunLoop* loop,
             FrameCountingDataPtr* out_data
,
             FrameCountingDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

FrameCountingDataPtr FrameSinksMetricsRecorderAsyncWaiter::StopFrameCounting(
    ) {
  FrameCountingDataPtr async_wait_result;
  StopFrameCounting(&async_wait_result);
  return async_wait_result;
}

void FrameSinksMetricsRecorderAsyncWaiter::StopOverdrawTracking(
    const ::viz::FrameSinkId& root_frame_sink_id, OverdrawDataPtr* out_data) {
  base::RunLoop loop;
  proxy_->StopOverdrawTracking(
      std::move(root_frame_sink_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             OverdrawDataPtr* out_data
,
             OverdrawDataPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

OverdrawDataPtr FrameSinksMetricsRecorderAsyncWaiter::StopOverdrawTracking(
    const ::viz::FrameSinkId& root_frame_sink_id) {
  OverdrawDataPtr async_wait_result;
  StopOverdrawTracking(std::move(root_frame_sink_id),&async_wait_result);
  return async_wait_result;
}






}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif