// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-features.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-forward.h"  // IWYU pragma: export
#include "media/capture/mojom/video_capture_buffer.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/token.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/viz/public/cpp/compositing/video_capture_target_mojom_traits.h"




namespace viz::mojom {

class FrameSinkVideoConsumerFrameCallbacksProxy;

template <typename ImplRefTraits>
class FrameSinkVideoConsumerFrameCallbacksStub;

class FrameSinkVideoConsumerFrameCallbacksRequestValidator;


class FrameSinkVideoConsumerFrameCallbacks
    : public FrameSinkVideoConsumerFrameCallbacksInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkVideoConsumerFrameCallbacks";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkVideoConsumerFrameCallbacksInterfaceBase;
  using Proxy_ = FrameSinkVideoConsumerFrameCallbacksProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoConsumerFrameCallbacksStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoConsumerFrameCallbacksRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDoneMinVersion = 0,
    kProvideFeedbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Done_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProvideFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkVideoConsumerFrameCallbacks() = default;

  virtual void Done() = 0;

  virtual void ProvideFeedback(const ::media::VideoCaptureFeedback& feedback) = 0;
};

class FrameSinkVideoConsumerProxy;

template <typename ImplRefTraits>
class FrameSinkVideoConsumerStub;

class FrameSinkVideoConsumerRequestValidator;


class FrameSinkVideoConsumer
    : public FrameSinkVideoConsumerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkVideoConsumer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkVideoConsumerInterfaceBase;
  using Proxy_ = FrameSinkVideoConsumerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoConsumerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoConsumerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFrameCapturedMinVersion = 0,
    kOnNewSubCaptureTargetVersionMinVersion = 0,
    kOnFrameWithEmptyRegionCaptureMinVersion = 0,
    kOnStoppedMinVersion = 0,
    kOnLogMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFrameCaptured_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNewSubCaptureTargetVersion_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFrameWithEmptyRegionCapture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkVideoConsumer() = default;

  virtual void OnFrameCaptured(::media::mojom::VideoBufferHandlePtr data, ::media::mojom::VideoFrameInfoPtr info, const ::gfx::Rect& content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> callbacks) = 0;

  virtual void OnNewSubCaptureTargetVersion(uint32_t sub_capture_target_version) = 0;

  virtual void OnFrameWithEmptyRegionCapture() = 0;

  virtual void OnStopped() = 0;

  virtual void OnLog(const std::string& message) = 0;
};

class FrameSinkVideoCapturerProxy;

template <typename ImplRefTraits>
class FrameSinkVideoCapturerStub;

class FrameSinkVideoCapturerRequestValidator;


class FrameSinkVideoCapturer
    : public FrameSinkVideoCapturerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkVideoCapturer";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkVideoCapturerInterfaceBase;
  using Proxy_ = FrameSinkVideoCapturerProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoCapturerStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoCapturerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetFormatMinVersion = 0,
    kSetMinCapturePeriodMinVersion = 0,
    kSetMinSizeChangePeriodMinVersion = 0,
    kSetResolutionConstraintsMinVersion = 0,
    kSetAutoThrottlingEnabledMinVersion = 0,
    kSetAnimationFpsLockInMinVersion = 0,
    kChangeTargetMinVersion = 0,
    kStartMinVersion = 0,
    kStopMinVersion = 0,
    kRequestRefreshFrameMinVersion = 0,
    kCreateOverlayMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetFormat_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMinCapturePeriod_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMinSizeChangePeriod_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetResolutionConstraints_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAutoThrottlingEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAnimationFpsLockIn_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ChangeTarget_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestRefreshFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateOverlay_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkVideoCapturer() = default;

  virtual void SetFormat(::media::VideoPixelFormat format) = 0;

  virtual void SetMinCapturePeriod(::base::TimeDelta min_period) = 0;

  virtual void SetMinSizeChangePeriod(::base::TimeDelta min_period) = 0;

  virtual void SetResolutionConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool use_fixed_aspect_ratio) = 0;

  virtual void SetAutoThrottlingEnabled(bool enabled) = 0;

  virtual void SetAnimationFpsLockIn(bool enabled, float majority_damaged_pixel_min_ratio) = 0;

  virtual void ChangeTarget(const std::optional<::viz::VideoCaptureTarget>& target, uint32_t sub_capture_target_version) = 0;

  virtual void Start(::mojo::PendingRemote<FrameSinkVideoConsumer> consumer, BufferFormatPreference buffer_format_preference) = 0;

  virtual void Stop() = 0;

  virtual void RequestRefreshFrame() = 0;

  virtual void CreateOverlay(int32_t stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> receiver) = 0;
};

class FrameSinkVideoCaptureOverlayProxy;

template <typename ImplRefTraits>
class FrameSinkVideoCaptureOverlayStub;

class FrameSinkVideoCaptureOverlayRequestValidator;


class FrameSinkVideoCaptureOverlay
    : public FrameSinkVideoCaptureOverlayInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "viz.mojom.FrameSinkVideoCaptureOverlay";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameSinkVideoCaptureOverlayInterfaceBase;
  using Proxy_ = FrameSinkVideoCaptureOverlayProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkVideoCaptureOverlayStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkVideoCaptureOverlayRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetImageAndBoundsMinVersion = 0,
    kSetBoundsMinVersion = 0,
    kOnCapturedMouseEventMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetImageAndBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCapturedMouseEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameSinkVideoCaptureOverlay() = default;

  virtual void SetImageAndBounds(const ::SkBitmap& image, const ::gfx::RectF& bounds) = 0;

  virtual void SetBounds(const ::gfx::RectF& bounds) = 0;

  virtual void OnCapturedMouseEvent(const ::gfx::Point& coordinates) = 0;
};



class  FrameSinkVideoConsumerFrameCallbacksProxy
    : public FrameSinkVideoConsumerFrameCallbacks {
 public:
  using InterfaceType = FrameSinkVideoConsumerFrameCallbacks;

  explicit FrameSinkVideoConsumerFrameCallbacksProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Done() final;
  
  void ProvideFeedback(const ::media::VideoCaptureFeedback& feedback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoConsumerProxy
    : public FrameSinkVideoConsumer {
 public:
  using InterfaceType = FrameSinkVideoConsumer;

  explicit FrameSinkVideoConsumerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFrameCaptured(::media::mojom::VideoBufferHandlePtr data, ::media::mojom::VideoFrameInfoPtr info, const ::gfx::Rect& content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> callbacks) final;
  
  void OnNewSubCaptureTargetVersion(uint32_t sub_capture_target_version) final;
  
  void OnFrameWithEmptyRegionCapture() final;
  
  void OnStopped() final;
  
  void OnLog(const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoCapturerProxy
    : public FrameSinkVideoCapturer {
 public:
  using InterfaceType = FrameSinkVideoCapturer;

  explicit FrameSinkVideoCapturerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetFormat(::media::VideoPixelFormat format) final;
  
  void SetMinCapturePeriod(::base::TimeDelta min_period) final;
  
  void SetMinSizeChangePeriod(::base::TimeDelta min_period) final;
  
  void SetResolutionConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool use_fixed_aspect_ratio) final;
  
  void SetAutoThrottlingEnabled(bool enabled) final;
  
  void SetAnimationFpsLockIn(bool enabled, float majority_damaged_pixel_min_ratio) final;
  
  void ChangeTarget(const std::optional<::viz::VideoCaptureTarget>& target, uint32_t sub_capture_target_version) final;
  
  void Start(::mojo::PendingRemote<FrameSinkVideoConsumer> consumer, BufferFormatPreference buffer_format_preference) final;
  
  void Stop() final;
  
  void RequestRefreshFrame() final;
  
  void CreateOverlay(int32_t stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  FrameSinkVideoCaptureOverlayProxy
    : public FrameSinkVideoCaptureOverlay {
 public:
  using InterfaceType = FrameSinkVideoCaptureOverlay;

  explicit FrameSinkVideoCaptureOverlayProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetImageAndBounds(const ::SkBitmap& image, const ::gfx::RectF& bounds) final;
  
  void SetBounds(const ::gfx::RectF& bounds) final;
  
  void OnCapturedMouseEvent(const ::gfx::Point& coordinates) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FrameSinkVideoConsumerFrameCallbacksStubDispatch {
 public:
  static bool Accept(FrameSinkVideoConsumerFrameCallbacks* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoConsumerFrameCallbacks* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoConsumerFrameCallbacks>>
class FrameSinkVideoConsumerFrameCallbacksStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoConsumerFrameCallbacksStub() = default;
  ~FrameSinkVideoConsumerFrameCallbacksStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerFrameCallbacksStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerFrameCallbacksStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoConsumerStubDispatch {
 public:
  static bool Accept(FrameSinkVideoConsumer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoConsumer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoConsumer>>
class FrameSinkVideoConsumerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoConsumerStub() = default;
  ~FrameSinkVideoConsumerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoConsumerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoCapturerStubDispatch {
 public:
  static bool Accept(FrameSinkVideoCapturer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoCapturer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoCapturer>>
class FrameSinkVideoCapturerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoCapturerStub() = default;
  ~FrameSinkVideoCapturerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCapturerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCapturerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoCaptureOverlayStubDispatch {
 public:
  static bool Accept(FrameSinkVideoCaptureOverlay* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkVideoCaptureOverlay* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkVideoCaptureOverlay>>
class FrameSinkVideoCaptureOverlayStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkVideoCaptureOverlayStub() = default;
  ~FrameSinkVideoCaptureOverlayStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCaptureOverlayStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkVideoCaptureOverlayStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FrameSinkVideoConsumerFrameCallbacksRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoConsumerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoCapturerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  FrameSinkVideoCaptureOverlayRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  VideoCaptureSubTarget {
 public:
  using DataView = VideoCaptureSubTargetDataView;
  using Data_ = internal::VideoCaptureSubTarget_Data;
  using Tag = Data_::VideoCaptureSubTarget_Tag;

  template <typename... Args>
  static VideoCaptureSubTargetPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |subtree_capture_id|.
  static VideoCaptureSubTargetPtr NewSubtreeCaptureId(
      const ::viz::SubtreeCaptureId& value);
  // Construct an instance holding |region_capture_crop_id|.
  static VideoCaptureSubTargetPtr NewRegionCaptureCropId(
      const ::base::Token& value);

  template <typename U>
  static VideoCaptureSubTargetPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureSubTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureSubTarget>::Convert(*this);
  }
  ~VideoCaptureSubTarget();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  VideoCaptureSubTarget(const VideoCaptureSubTarget& other) = delete;
  VideoCaptureSubTarget& operator=(const VideoCaptureSubTarget& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = VideoCaptureSubTargetPtr>
  VideoCaptureSubTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoCaptureSubTarget>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, VideoCaptureSubTarget>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_subtree_capture_id() const { return tag_ == Tag::kSubtreeCaptureId; }
  const ::viz::SubtreeCaptureId& get_subtree_capture_id() const {
    CHECK(tag_ == Tag::kSubtreeCaptureId);
    return data_.subtree_capture_id;
  }
  ::viz::SubtreeCaptureId& get_subtree_capture_id() {
    CHECK(tag_ == Tag::kSubtreeCaptureId);
    return data_.subtree_capture_id;
  }
  void set_subtree_capture_id(const ::viz::SubtreeCaptureId& subtree_capture_id);

  bool is_region_capture_crop_id() const { return tag_ == Tag::kRegionCaptureCropId; }
  const ::base::Token& get_region_capture_crop_id() const {
    CHECK(tag_ == Tag::kRegionCaptureCropId);
    return data_.region_capture_crop_id;
  }
  ::base::Token& get_region_capture_crop_id() {
    CHECK(tag_ == Tag::kRegionCaptureCropId);
    return data_.region_capture_crop_id;
  }
  void set_region_capture_crop_id(const ::base::Token& region_capture_crop_id);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureSubTarget::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<VideoCaptureSubTarget::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSubtreeCaptureId)>,
        const ::viz::SubtreeCaptureId& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRegionCaptureCropId)>,
        const ::base::Token& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::viz::SubtreeCaptureId subtree_capture_id;
    ::base::Token region_capture_crop_id;
  };

  VideoCaptureSubTarget(
      std::in_place_index_t<static_cast<size_t>(Tag::kSubtreeCaptureId)>,
      const ::viz::SubtreeCaptureId& value);
  VideoCaptureSubTarget(
      std::in_place_index_t<static_cast<size_t>(Tag::kRegionCaptureCropId)>,
      const ::base::Token& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  VideoCaptureTarget {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoCaptureTarget, T>::value>;
  using DataView = VideoCaptureTargetDataView;
  using Data_ = internal::VideoCaptureTarget_Data;

  template <typename... Args>
  static VideoCaptureTargetPtr New(Args&&... args) {
    return VideoCaptureTargetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoCaptureTargetPtr From(const U& u) {
    return mojo::TypeConverter<VideoCaptureTargetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoCaptureTarget>::Convert(*this);
  }


  VideoCaptureTarget();

  VideoCaptureTarget(
      const ::viz::FrameSinkId& frame_sink_id,
      const ::viz::VideoCaptureSubTarget& sub_target);


  ~VideoCaptureTarget();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoCaptureTargetPtr>
  VideoCaptureTargetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureTarget::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoCaptureTarget::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoCaptureTarget::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoCaptureTarget_UnserializedMessageContext<
            UserType, VideoCaptureTarget::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoCaptureTarget::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoCaptureTarget::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoCaptureTarget_UnserializedMessageContext<
            UserType, VideoCaptureTarget::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoCaptureTarget::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::FrameSinkId frame_sink_id;
  
  ::viz::VideoCaptureSubTarget sub_target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoCaptureTarget::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
VideoCaptureSubTargetPtr VideoCaptureSubTarget::Clone() const {
  switch (tag_) {
    case Tag::kSubtreeCaptureId:
      return NewSubtreeCaptureId(
          mojo::Clone(data_.subtree_capture_id));
    case Tag::kRegionCaptureCropId:
      return NewRegionCaptureCropId(
          mojo::Clone(data_.region_capture_crop_id));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, VideoCaptureSubTarget>::value>::type*>
bool VideoCaptureSubTarget::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSubtreeCaptureId:
      return mojo::Equals(data_.subtree_capture_id, other.data_.subtree_capture_id);
    case Tag::kRegionCaptureCropId:
      return mojo::Equals(data_.region_capture_crop_id, other.data_.region_capture_crop_id);
  }

  return false;
}
template <typename StructPtrType>
VideoCaptureTargetPtr VideoCaptureTarget::Clone() const {
  return New(
      mojo::Clone(frame_sink_id),
      mojo::Clone(sub_target)
  );
}

template <typename T, VideoCaptureTarget::EnableIfSame<T>*>
bool VideoCaptureTarget::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_sink_id, other_struct.frame_sink_id))
    return false;
  if (!mojo::Equals(this->sub_target, other_struct.sub_target))
    return false;
  return true;
}

template <typename T, VideoCaptureTarget::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_sink_id < rhs.frame_sink_id)
    return true;
  if (rhs.frame_sink_id < lhs.frame_sink_id)
    return false;
  if (lhs.sub_target < rhs.sub_target)
    return true;
  if (rhs.sub_target < lhs.sub_target)
    return false;
  return false;
}


}  // viz::mojom

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::VideoCaptureTarget::DataView,
                                         ::viz::mojom::VideoCaptureTargetPtr> {
  static bool IsNull(const ::viz::mojom::VideoCaptureTargetPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::VideoCaptureTargetPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::VideoCaptureTarget::frame_sink_id)& frame_sink_id(
      const ::viz::mojom::VideoCaptureTargetPtr& input) {
    return input->frame_sink_id;
  }

  static const decltype(::viz::mojom::VideoCaptureTarget::sub_target)& sub_target(
      const ::viz::mojom::VideoCaptureTargetPtr& input) {
    return input->sub_target;
  }

  static bool Read(::viz::mojom::VideoCaptureTarget::DataView input, ::viz::mojom::VideoCaptureTargetPtr* output);
};


template <>
struct  UnionTraits<::viz::mojom::VideoCaptureSubTarget::DataView,
                                        ::viz::mojom::VideoCaptureSubTargetPtr> {
  static bool IsNull(const ::viz::mojom::VideoCaptureSubTargetPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::VideoCaptureSubTargetPtr* output) { output->reset(); }

  static ::viz::mojom::VideoCaptureSubTarget::Tag GetTag(const ::viz::mojom::VideoCaptureSubTargetPtr& input) {
    return input->which();
  }

  static const ::viz::SubtreeCaptureId& subtree_capture_id(const ::viz::mojom::VideoCaptureSubTargetPtr& input) {
    return input->get_subtree_capture_id();
  }

  static const ::base::Token& region_capture_crop_id(const ::viz::mojom::VideoCaptureSubTargetPtr& input) {
    return input->get_region_capture_crop_id();
  }

  static bool Read(::viz::mojom::VideoCaptureSubTarget::DataView input, ::viz::mojom::VideoCaptureSubTargetPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_H_