// services/network/public/mojom/ssl_config.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ssl_config.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ssl_config.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ssl_config.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class SSLConfigClientProxy;

template <typename ImplRefTraits>
class SSLConfigClientStub;

class SSLConfigClientRequestValidator;


class BLINK_PLATFORM_EXPORT SSLConfigClient
    : public SSLConfigClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SSLConfigClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SSLConfigClientInterfaceBase;
  using Proxy_ = SSLConfigClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SSLConfigClientStub<ImplRefTraits>;

  using RequestValidator_ = SSLConfigClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSSLConfigUpdatedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSSLConfigUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SSLConfigClient() = default;

  virtual void OnSSLConfigUpdated(SSLConfigPtr ssl_config) = 0;
};



class BLINK_PLATFORM_EXPORT SSLConfigClientProxy
    : public SSLConfigClient {
 public:
  using InterfaceType = SSLConfigClient;

  explicit SSLConfigClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSSLConfigUpdated(SSLConfigPtr ssl_config) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT SSLConfigClientStubDispatch {
 public:
  static bool Accept(SSLConfigClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SSLConfigClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SSLConfigClient>>
class SSLConfigClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SSLConfigClientStub() = default;
  ~SSLConfigClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLConfigClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLConfigClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SSLConfigClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT SSLConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SSLConfig, T>::value>;
  using DataView = SSLConfigDataView;
  using Data_ = internal::SSLConfig_Data;

  template <typename... Args>
  static SSLConfigPtr New(Args&&... args) {
    return SSLConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SSLConfigPtr From(const U& u) {
    return mojo::TypeConverter<SSLConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SSLConfig>::Convert(*this);
  }


  SSLConfig();

  SSLConfig(
      bool rev_checking_enabled,
      bool rev_checking_required_local_anchors,
      bool sha1_local_anchors_enabled,
      SSLVersion version_min,
      SSLVersion version_max,
      ::blink::Vector<uint16_t> disabled_cipher_suites,
      ::blink::Vector<::blink::String> client_cert_pooling_policy,
      bool post_quantum_key_agreement_enabled,
      bool ech_enabled,
      ::blink::Vector<::blink::Vector<uint8_t>> trust_anchor_ids);


  ~SSLConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SSLConfigPtr>
  SSLConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SSLConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SSLConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SSLConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SSLConfig_UnserializedMessageContext<
            UserType, SSLConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SSLConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SSLConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SSLConfig_UnserializedMessageContext<
            UserType, SSLConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SSLConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool rev_checking_enabled;
  
  bool rev_checking_required_local_anchors;
  
  bool sha1_local_anchors_enabled;
  
  SSLVersion version_min;
  
  SSLVersion version_max;
  
  ::blink::Vector<uint16_t> disabled_cipher_suites;
  
  ::blink::Vector<::blink::String> client_cert_pooling_policy;
  
  bool post_quantum_key_agreement_enabled;
  
  bool ech_enabled;
  
  ::blink::Vector<::blink::Vector<uint8_t>> trust_anchor_ids;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SSLConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SSLConfigPtr SSLConfig::Clone() const {
  return New(
      mojo::Clone(rev_checking_enabled),
      mojo::Clone(rev_checking_required_local_anchors),
      mojo::Clone(sha1_local_anchors_enabled),
      mojo::Clone(version_min),
      mojo::Clone(version_max),
      mojo::Clone(disabled_cipher_suites),
      mojo::Clone(client_cert_pooling_policy),
      mojo::Clone(post_quantum_key_agreement_enabled),
      mojo::Clone(ech_enabled),
      mojo::Clone(trust_anchor_ids)
  );
}

template <typename T, SSLConfig::EnableIfSame<T>*>
bool SSLConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rev_checking_enabled, other_struct.rev_checking_enabled))
    return false;
  if (!mojo::Equals(this->rev_checking_required_local_anchors, other_struct.rev_checking_required_local_anchors))
    return false;
  if (!mojo::Equals(this->sha1_local_anchors_enabled, other_struct.sha1_local_anchors_enabled))
    return false;
  if (!mojo::Equals(this->version_min, other_struct.version_min))
    return false;
  if (!mojo::Equals(this->version_max, other_struct.version_max))
    return false;
  if (!mojo::Equals(this->disabled_cipher_suites, other_struct.disabled_cipher_suites))
    return false;
  if (!mojo::Equals(this->client_cert_pooling_policy, other_struct.client_cert_pooling_policy))
    return false;
  if (!mojo::Equals(this->post_quantum_key_agreement_enabled, other_struct.post_quantum_key_agreement_enabled))
    return false;
  if (!mojo::Equals(this->ech_enabled, other_struct.ech_enabled))
    return false;
  if (!mojo::Equals(this->trust_anchor_ids, other_struct.trust_anchor_ids))
    return false;
  return true;
}

template <typename T, SSLConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rev_checking_enabled < rhs.rev_checking_enabled)
    return true;
  if (rhs.rev_checking_enabled < lhs.rev_checking_enabled)
    return false;
  if (lhs.rev_checking_required_local_anchors < rhs.rev_checking_required_local_anchors)
    return true;
  if (rhs.rev_checking_required_local_anchors < lhs.rev_checking_required_local_anchors)
    return false;
  if (lhs.sha1_local_anchors_enabled < rhs.sha1_local_anchors_enabled)
    return true;
  if (rhs.sha1_local_anchors_enabled < lhs.sha1_local_anchors_enabled)
    return false;
  if (lhs.version_min < rhs.version_min)
    return true;
  if (rhs.version_min < lhs.version_min)
    return false;
  if (lhs.version_max < rhs.version_max)
    return true;
  if (rhs.version_max < lhs.version_max)
    return false;
  if (lhs.disabled_cipher_suites < rhs.disabled_cipher_suites)
    return true;
  if (rhs.disabled_cipher_suites < lhs.disabled_cipher_suites)
    return false;
  if (lhs.client_cert_pooling_policy < rhs.client_cert_pooling_policy)
    return true;
  if (rhs.client_cert_pooling_policy < lhs.client_cert_pooling_policy)
    return false;
  if (lhs.post_quantum_key_agreement_enabled < rhs.post_quantum_key_agreement_enabled)
    return true;
  if (rhs.post_quantum_key_agreement_enabled < lhs.post_quantum_key_agreement_enabled)
    return false;
  if (lhs.ech_enabled < rhs.ech_enabled)
    return true;
  if (rhs.ech_enabled < lhs.ech_enabled)
    return false;
  if (lhs.trust_anchor_ids < rhs.trust_anchor_ids)
    return true;
  if (rhs.trust_anchor_ids < lhs.trust_anchor_ids)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SSLConfig::DataView,
                                         ::network::mojom::blink::SSLConfigPtr> {
  static bool IsNull(const ::network::mojom::blink::SSLConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SSLConfigPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::SSLConfig::rev_checking_enabled) rev_checking_enabled(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->rev_checking_enabled;
  }

  static decltype(::network::mojom::blink::SSLConfig::rev_checking_required_local_anchors) rev_checking_required_local_anchors(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->rev_checking_required_local_anchors;
  }

  static decltype(::network::mojom::blink::SSLConfig::sha1_local_anchors_enabled) sha1_local_anchors_enabled(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->sha1_local_anchors_enabled;
  }

  static decltype(::network::mojom::blink::SSLConfig::version_min) version_min(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->version_min;
  }

  static decltype(::network::mojom::blink::SSLConfig::version_max) version_max(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->version_max;
  }

  static const decltype(::network::mojom::blink::SSLConfig::disabled_cipher_suites)& disabled_cipher_suites(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->disabled_cipher_suites;
  }

  static const decltype(::network::mojom::blink::SSLConfig::client_cert_pooling_policy)& client_cert_pooling_policy(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->client_cert_pooling_policy;
  }

  static decltype(::network::mojom::blink::SSLConfig::post_quantum_key_agreement_enabled) post_quantum_key_agreement_enabled(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->post_quantum_key_agreement_enabled;
  }

  static decltype(::network::mojom::blink::SSLConfig::ech_enabled) ech_enabled(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->ech_enabled;
  }

  static const decltype(::network::mojom::blink::SSLConfig::trust_anchor_ids)& trust_anchor_ids(
      const ::network::mojom::blink::SSLConfigPtr& input) {
    return input->trust_anchor_ids;
  }

  static bool Read(::network::mojom::blink::SSLConfig::DataView input, ::network::mojom::blink::SSLConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_BLINK_H_