// services/network/public/mojom/source_location.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SOURCE_LOCATION_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SOURCE_LOCATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/source_location.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/source_location.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/source_location.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>








namespace network::mojom {





class  SourceLocation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SourceLocation, T>::value>;
  using DataView = SourceLocationDataView;
  using Data_ = internal::SourceLocation_Data;

  template <typename... Args>
  static SourceLocationPtr New(Args&&... args) {
    return SourceLocationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SourceLocationPtr From(const U& u) {
    return mojo::TypeConverter<SourceLocationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SourceLocation>::Convert(*this);
  }


  SourceLocation();

  SourceLocation(
      const std::string& url,
      uint32_t line,
      uint32_t column);


  ~SourceLocation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SourceLocationPtr>
  SourceLocationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceLocation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SourceLocation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SourceLocation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SourceLocation_UnserializedMessageContext<
            UserType, SourceLocation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SourceLocation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SourceLocation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SourceLocation_UnserializedMessageContext<
            UserType, SourceLocation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SourceLocation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string url;
  
  uint32_t line;
  
  uint32_t column;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SourceLocation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
SourceLocationPtr SourceLocation::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(line),
      mojo::Clone(column)
  );
}

template <typename T, SourceLocation::EnableIfSame<T>*>
bool SourceLocation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->line, other_struct.line))
    return false;
  if (!mojo::Equals(this->column, other_struct.column))
    return false;
  return true;
}

template <typename T, SourceLocation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.line < rhs.line)
    return true;
  if (rhs.line < lhs.line)
    return false;
  if (lhs.column < rhs.column)
    return true;
  if (rhs.column < lhs.column)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SourceLocation::DataView,
                                         ::network::mojom::SourceLocationPtr> {
  static bool IsNull(const ::network::mojom::SourceLocationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SourceLocationPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SourceLocation::url)& url(
      const ::network::mojom::SourceLocationPtr& input) {
    return input->url;
  }

  static decltype(::network::mojom::SourceLocation::line) line(
      const ::network::mojom::SourceLocationPtr& input) {
    return input->line;
  }

  static decltype(::network::mojom::SourceLocation::column) column(
      const ::network::mojom::SourceLocationPtr& input) {
    return input->column;
  }

  static bool Read(::network::mojom::SourceLocation::DataView input, ::network::mojom::SourceLocationPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SOURCE_LOCATION_MOJOM_H_