// services/network/public/mojom/shared_storage.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_storage.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_storage.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/shared_storage.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/shared_storage_mojom_traits.h"




namespace network::mojom {







class  LockName {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LockName, T>::value>;
  using DataView = LockNameDataView;
  using Data_ = internal::LockName_Data;

  template <typename... Args>
  static LockNamePtr New(Args&&... args) {
    return LockNamePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LockNamePtr From(const U& u) {
    return mojo::TypeConverter<LockNamePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LockName>::Convert(*this);
  }


  LockName();

  explicit LockName(
      const std::string& data);


  ~LockName();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LockNamePtr>
  LockNamePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LockName::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LockName::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LockName::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LockName::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LockName::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LockName::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LockName_UnserializedMessageContext<
            UserType, LockName::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LockName::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LockName::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LockName_UnserializedMessageContext<
            UserType, LockName::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LockName::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LockName::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LockName::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LockName::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LockName::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  SharedStorageClearMethod {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageClearMethod, T>::value>;
  using DataView = SharedStorageClearMethodDataView;
  using Data_ = internal::SharedStorageClearMethod_Data;

  template <typename... Args>
  static SharedStorageClearMethodPtr New(Args&&... args) {
    return SharedStorageClearMethodPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageClearMethodPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageClearMethodPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageClearMethod>::Convert(*this);
  }


  SharedStorageClearMethod();


  ~SharedStorageClearMethod();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageClearMethodPtr>
  SharedStorageClearMethodPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageClearMethod::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageClearMethod::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageClearMethod::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageClearMethod_UnserializedMessageContext<
            UserType, SharedStorageClearMethod::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageClearMethod::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageClearMethod::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageClearMethod_UnserializedMessageContext<
            UserType, SharedStorageClearMethod::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageClearMethod::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }


  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageClearMethod::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  SharedStorageModifierMethod {
 public:
  using DataView = SharedStorageModifierMethodDataView;
  using Data_ = internal::SharedStorageModifierMethod_Data;
  using Tag = Data_::SharedStorageModifierMethod_Tag;

  template <typename... Args>
  static SharedStorageModifierMethodPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |set_method|.
  static SharedStorageModifierMethodPtr NewSetMethod(
      SharedStorageSetMethodPtr value);
  // Construct an instance holding |append_method|.
  static SharedStorageModifierMethodPtr NewAppendMethod(
      SharedStorageAppendMethodPtr value);
  // Construct an instance holding |delete_method|.
  static SharedStorageModifierMethodPtr NewDeleteMethod(
      SharedStorageDeleteMethodPtr value);
  // Construct an instance holding |clear_method|.
  static SharedStorageModifierMethodPtr NewClearMethod(
      SharedStorageClearMethodPtr value);

  template <typename U>
  static SharedStorageModifierMethodPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageModifierMethodPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageModifierMethod>::Convert(*this);
  }
  ~SharedStorageModifierMethod();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SharedStorageModifierMethod(const SharedStorageModifierMethod& other) = delete;
  SharedStorageModifierMethod& operator=(const SharedStorageModifierMethod& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SharedStorageModifierMethodPtr>
  SharedStorageModifierMethodPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SharedStorageModifierMethod>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SharedStorageModifierMethod>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_set_method() const { return tag_ == Tag::kSetMethod; }
  const SharedStorageSetMethodPtr& get_set_method() const {
    CHECK(tag_ == Tag::kSetMethod);
    return data_.set_method;
  }
  SharedStorageSetMethodPtr& get_set_method() {
    CHECK(tag_ == Tag::kSetMethod);
    return data_.set_method;
  }
  void set_set_method(SharedStorageSetMethodPtr set_method);

  bool is_append_method() const { return tag_ == Tag::kAppendMethod; }
  const SharedStorageAppendMethodPtr& get_append_method() const {
    CHECK(tag_ == Tag::kAppendMethod);
    return data_.append_method;
  }
  SharedStorageAppendMethodPtr& get_append_method() {
    CHECK(tag_ == Tag::kAppendMethod);
    return data_.append_method;
  }
  void set_append_method(SharedStorageAppendMethodPtr append_method);

  bool is_delete_method() const { return tag_ == Tag::kDeleteMethod; }
  const SharedStorageDeleteMethodPtr& get_delete_method() const {
    CHECK(tag_ == Tag::kDeleteMethod);
    return data_.delete_method;
  }
  SharedStorageDeleteMethodPtr& get_delete_method() {
    CHECK(tag_ == Tag::kDeleteMethod);
    return data_.delete_method;
  }
  void set_delete_method(SharedStorageDeleteMethodPtr delete_method);

  bool is_clear_method() const { return tag_ == Tag::kClearMethod; }
  const SharedStorageClearMethodPtr& get_clear_method() const {
    CHECK(tag_ == Tag::kClearMethod);
    return data_.clear_method;
  }
  SharedStorageClearMethodPtr& get_clear_method() {
    CHECK(tag_ == Tag::kClearMethod);
    return data_.clear_method;
  }
  void set_clear_method(SharedStorageClearMethodPtr clear_method);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageModifierMethod::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SharedStorageModifierMethod::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSetMethod)>,
        SharedStorageSetMethodPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAppendMethod)>,
        SharedStorageAppendMethodPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDeleteMethod)>,
        SharedStorageDeleteMethodPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kClearMethod)>,
        SharedStorageClearMethodPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    SharedStorageSetMethodPtr set_method;
    SharedStorageAppendMethodPtr append_method;
    SharedStorageDeleteMethodPtr delete_method;
    SharedStorageClearMethodPtr clear_method;
  };

  SharedStorageModifierMethod(
      std::in_place_index_t<static_cast<size_t>(Tag::kSetMethod)>,
      SharedStorageSetMethodPtr value);
  SharedStorageModifierMethod(
      std::in_place_index_t<static_cast<size_t>(Tag::kAppendMethod)>,
      SharedStorageAppendMethodPtr value);
  SharedStorageModifierMethod(
      std::in_place_index_t<static_cast<size_t>(Tag::kDeleteMethod)>,
      SharedStorageDeleteMethodPtr value);
  SharedStorageModifierMethod(
      std::in_place_index_t<static_cast<size_t>(Tag::kClearMethod)>,
      SharedStorageClearMethodPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  SharedStorageKeyArgument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageKeyArgument, T>::value>;
  using DataView = SharedStorageKeyArgumentDataView;
  using Data_ = internal::SharedStorageKeyArgument_Data;

  template <typename... Args>
  static SharedStorageKeyArgumentPtr New(Args&&... args) {
    return SharedStorageKeyArgumentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageKeyArgumentPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageKeyArgumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageKeyArgument>::Convert(*this);
  }


  SharedStorageKeyArgument();

  explicit SharedStorageKeyArgument(
      const ::std::u16string& data);


  ~SharedStorageKeyArgument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageKeyArgumentPtr>
  SharedStorageKeyArgumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageKeyArgument::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageKeyArgument::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageKeyArgument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageKeyArgument_UnserializedMessageContext<
            UserType, SharedStorageKeyArgument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageKeyArgument::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageKeyArgument::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageKeyArgument_UnserializedMessageContext<
            UserType, SharedStorageKeyArgument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageKeyArgument::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageKeyArgument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedStorageValueArgument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageValueArgument, T>::value>;
  using DataView = SharedStorageValueArgumentDataView;
  using Data_ = internal::SharedStorageValueArgument_Data;

  template <typename... Args>
  static SharedStorageValueArgumentPtr New(Args&&... args) {
    return SharedStorageValueArgumentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageValueArgumentPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageValueArgumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageValueArgument>::Convert(*this);
  }


  SharedStorageValueArgument();

  explicit SharedStorageValueArgument(
      const ::std::u16string& data);


  ~SharedStorageValueArgument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageValueArgumentPtr>
  SharedStorageValueArgumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageValueArgument::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageValueArgument::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageValueArgument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageValueArgument_UnserializedMessageContext<
            UserType, SharedStorageValueArgument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageValueArgument::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageValueArgument::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageValueArgument_UnserializedMessageContext<
            UserType, SharedStorageValueArgument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageValueArgument::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageValueArgument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SharedStorageSetMethod {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageSetMethod, T>::value>;
  using DataView = SharedStorageSetMethodDataView;
  using Data_ = internal::SharedStorageSetMethod_Data;

  template <typename... Args>
  static SharedStorageSetMethodPtr New(Args&&... args) {
    return SharedStorageSetMethodPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageSetMethodPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageSetMethodPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageSetMethod>::Convert(*this);
  }


  SharedStorageSetMethod();

  SharedStorageSetMethod(
      const ::std::u16string& key,
      const ::std::u16string& value,
      bool ignore_if_present);


  ~SharedStorageSetMethod();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageSetMethodPtr>
  SharedStorageSetMethodPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageSetMethod::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageSetMethod::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageSetMethod::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageSetMethod_UnserializedMessageContext<
            UserType, SharedStorageSetMethod::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageSetMethod::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageSetMethod::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageSetMethod_UnserializedMessageContext<
            UserType, SharedStorageSetMethod::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageSetMethod::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string key;
  
  ::std::u16string value;
  
  bool ignore_if_present;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageSetMethod::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedStorageAppendMethod {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageAppendMethod, T>::value>;
  using DataView = SharedStorageAppendMethodDataView;
  using Data_ = internal::SharedStorageAppendMethod_Data;

  template <typename... Args>
  static SharedStorageAppendMethodPtr New(Args&&... args) {
    return SharedStorageAppendMethodPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageAppendMethodPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageAppendMethodPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageAppendMethod>::Convert(*this);
  }


  SharedStorageAppendMethod();

  SharedStorageAppendMethod(
      const ::std::u16string& key,
      const ::std::u16string& value);


  ~SharedStorageAppendMethod();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageAppendMethodPtr>
  SharedStorageAppendMethodPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageAppendMethod::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageAppendMethod::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageAppendMethod::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageAppendMethod_UnserializedMessageContext<
            UserType, SharedStorageAppendMethod::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageAppendMethod::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageAppendMethod::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageAppendMethod_UnserializedMessageContext<
            UserType, SharedStorageAppendMethod::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageAppendMethod::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string key;
  
  ::std::u16string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageAppendMethod::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedStorageDeleteMethod {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageDeleteMethod, T>::value>;
  using DataView = SharedStorageDeleteMethodDataView;
  using Data_ = internal::SharedStorageDeleteMethod_Data;

  template <typename... Args>
  static SharedStorageDeleteMethodPtr New(Args&&... args) {
    return SharedStorageDeleteMethodPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageDeleteMethodPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageDeleteMethodPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageDeleteMethod>::Convert(*this);
  }


  SharedStorageDeleteMethod();

  explicit SharedStorageDeleteMethod(
      const ::std::u16string& key);


  ~SharedStorageDeleteMethod();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageDeleteMethodPtr>
  SharedStorageDeleteMethodPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageDeleteMethod::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageDeleteMethod::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageDeleteMethod::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageDeleteMethod_UnserializedMessageContext<
            UserType, SharedStorageDeleteMethod::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageDeleteMethod::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageDeleteMethod::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageDeleteMethod_UnserializedMessageContext<
            UserType, SharedStorageDeleteMethod::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageDeleteMethod::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SharedStorageModifierMethodWithOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageModifierMethodWithOptions, T>::value>;
  using DataView = SharedStorageModifierMethodWithOptionsDataView;
  using Data_ = internal::SharedStorageModifierMethodWithOptions_Data;

  template <typename... Args>
  static SharedStorageModifierMethodWithOptionsPtr New(Args&&... args) {
    return SharedStorageModifierMethodWithOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageModifierMethodWithOptionsPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageModifierMethodWithOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageModifierMethodWithOptions>::Convert(*this);
  }


  SharedStorageModifierMethodWithOptions();

  SharedStorageModifierMethodWithOptions(
      SharedStorageModifierMethodPtr method,
      const std::optional<::std::string>& with_lock);

SharedStorageModifierMethodWithOptions(const SharedStorageModifierMethodWithOptions&) = delete;
SharedStorageModifierMethodWithOptions& operator=(const SharedStorageModifierMethodWithOptions&) = delete;

  ~SharedStorageModifierMethodWithOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageModifierMethodWithOptionsPtr>
  SharedStorageModifierMethodWithOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageModifierMethodWithOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageModifierMethodWithOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageModifierMethodWithOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageModifierMethodWithOptions_UnserializedMessageContext<
            UserType, SharedStorageModifierMethodWithOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageModifierMethodWithOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageModifierMethodWithOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageModifierMethodWithOptions_UnserializedMessageContext<
            UserType, SharedStorageModifierMethodWithOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageModifierMethodWithOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  SharedStorageModifierMethodPtr method;
  
  std::optional<::std::string> with_lock;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SharedStorageBatchUpdateMethodsArgument {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedStorageBatchUpdateMethodsArgument, T>::value>;
  using DataView = SharedStorageBatchUpdateMethodsArgumentDataView;
  using Data_ = internal::SharedStorageBatchUpdateMethodsArgument_Data;

  template <typename... Args>
  static SharedStorageBatchUpdateMethodsArgumentPtr New(Args&&... args) {
    return SharedStorageBatchUpdateMethodsArgumentPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedStorageBatchUpdateMethodsArgumentPtr From(const U& u) {
    return mojo::TypeConverter<SharedStorageBatchUpdateMethodsArgumentPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedStorageBatchUpdateMethodsArgument>::Convert(*this);
  }


  SharedStorageBatchUpdateMethodsArgument();

  explicit SharedStorageBatchUpdateMethodsArgument(
      std::vector<SharedStorageModifierMethodWithOptionsPtr> data);

SharedStorageBatchUpdateMethodsArgument(const SharedStorageBatchUpdateMethodsArgument&) = delete;
SharedStorageBatchUpdateMethodsArgument& operator=(const SharedStorageBatchUpdateMethodsArgument&) = delete;

  ~SharedStorageBatchUpdateMethodsArgument();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedStorageBatchUpdateMethodsArgumentPtr>
  SharedStorageBatchUpdateMethodsArgumentPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageBatchUpdateMethodsArgument::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedStorageBatchUpdateMethodsArgument::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedStorageBatchUpdateMethodsArgument::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedStorageBatchUpdateMethodsArgument_UnserializedMessageContext<
            UserType, SharedStorageBatchUpdateMethodsArgument::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SharedStorageBatchUpdateMethodsArgument::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SharedStorageBatchUpdateMethodsArgument::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedStorageBatchUpdateMethodsArgument_UnserializedMessageContext<
            UserType, SharedStorageBatchUpdateMethodsArgument::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedStorageBatchUpdateMethodsArgument::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<SharedStorageModifierMethodWithOptionsPtr> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SharedStorageModifierMethodPtr SharedStorageModifierMethod::Clone() const {
  switch (tag_) {
    case Tag::kSetMethod:
      return NewSetMethod(
          mojo::Clone(data_.set_method));
    case Tag::kAppendMethod:
      return NewAppendMethod(
          mojo::Clone(data_.append_method));
    case Tag::kDeleteMethod:
      return NewDeleteMethod(
          mojo::Clone(data_.delete_method));
    case Tag::kClearMethod:
      return NewClearMethod(
          mojo::Clone(data_.clear_method));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SharedStorageModifierMethod>::value>::type*>
bool SharedStorageModifierMethod::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSetMethod:
      return mojo::Equals(data_.set_method, other.data_.set_method);
    case Tag::kAppendMethod:
      return mojo::Equals(data_.append_method, other.data_.append_method);
    case Tag::kDeleteMethod:
      return mojo::Equals(data_.delete_method, other.data_.delete_method);
    case Tag::kClearMethod:
      return mojo::Equals(data_.clear_method, other.data_.clear_method);
  }

  return false;
}
template <typename StructPtrType>
SharedStorageKeyArgumentPtr SharedStorageKeyArgument::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, SharedStorageKeyArgument::EnableIfSame<T>*>
bool SharedStorageKeyArgument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SharedStorageKeyArgument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageValueArgumentPtr SharedStorageValueArgument::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, SharedStorageValueArgument::EnableIfSame<T>*>
bool SharedStorageValueArgument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SharedStorageValueArgument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
LockNamePtr LockName::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, LockName::EnableIfSame<T>*>
bool LockName::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, LockName::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageSetMethodPtr SharedStorageSetMethod::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value),
      mojo::Clone(ignore_if_present)
  );
}

template <typename T, SharedStorageSetMethod::EnableIfSame<T>*>
bool SharedStorageSetMethod::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->ignore_if_present, other_struct.ignore_if_present))
    return false;
  return true;
}

template <typename T, SharedStorageSetMethod::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.ignore_if_present < rhs.ignore_if_present)
    return true;
  if (rhs.ignore_if_present < lhs.ignore_if_present)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageAppendMethodPtr SharedStorageAppendMethod::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, SharedStorageAppendMethod::EnableIfSame<T>*>
bool SharedStorageAppendMethod::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, SharedStorageAppendMethod::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageDeleteMethodPtr SharedStorageDeleteMethod::Clone() const {
  return New(
      mojo::Clone(key)
  );
}

template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>*>
bool SharedStorageDeleteMethod::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  return true;
}

template <typename T, SharedStorageDeleteMethod::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageClearMethodPtr SharedStorageClearMethod::Clone() const {
  return New(
  );
}

template <typename T, SharedStorageClearMethod::EnableIfSame<T>*>
bool SharedStorageClearMethod::Equals(const T& other_struct) const {
  return true;
}

template <typename T, SharedStorageClearMethod::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
SharedStorageModifierMethodWithOptionsPtr SharedStorageModifierMethodWithOptions::Clone() const {
  return New(
      mojo::Clone(method),
      mojo::Clone(with_lock)
  );
}

template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>*>
bool SharedStorageModifierMethodWithOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->with_lock, other_struct.with_lock))
    return false;
  return true;
}

template <typename T, SharedStorageModifierMethodWithOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.method < rhs.method)
    return true;
  if (rhs.method < lhs.method)
    return false;
  if (lhs.with_lock < rhs.with_lock)
    return true;
  if (rhs.with_lock < lhs.with_lock)
    return false;
  return false;
}
template <typename StructPtrType>
SharedStorageBatchUpdateMethodsArgumentPtr SharedStorageBatchUpdateMethodsArgument::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>*>
bool SharedStorageBatchUpdateMethodsArgument::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, SharedStorageBatchUpdateMethodsArgument::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::SharedStorageKeyArgument::DataView,
                                         ::network::mojom::SharedStorageKeyArgumentPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageKeyArgumentPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageKeyArgumentPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageKeyArgument::data)& data(
      const ::network::mojom::SharedStorageKeyArgumentPtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::SharedStorageKeyArgument::DataView input, ::network::mojom::SharedStorageKeyArgumentPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageValueArgument::DataView,
                                         ::network::mojom::SharedStorageValueArgumentPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageValueArgumentPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageValueArgumentPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageValueArgument::data)& data(
      const ::network::mojom::SharedStorageValueArgumentPtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::SharedStorageValueArgument::DataView input, ::network::mojom::SharedStorageValueArgumentPtr* output);
};


template <>
struct  StructTraits<::network::mojom::LockName::DataView,
                                         ::network::mojom::LockNamePtr> {
  static bool IsNull(const ::network::mojom::LockNamePtr& input) { return !input; }
  static void SetToNull(::network::mojom::LockNamePtr* output) { output->reset(); }

  static const decltype(::network::mojom::LockName::data)& data(
      const ::network::mojom::LockNamePtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::LockName::DataView input, ::network::mojom::LockNamePtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageSetMethod::DataView,
                                         ::network::mojom::SharedStorageSetMethodPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageSetMethodPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageSetMethodPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageSetMethod::key)& key(
      const ::network::mojom::SharedStorageSetMethodPtr& input) {
    return input->key;
  }

  static const decltype(::network::mojom::SharedStorageSetMethod::value)& value(
      const ::network::mojom::SharedStorageSetMethodPtr& input) {
    return input->value;
  }

  static decltype(::network::mojom::SharedStorageSetMethod::ignore_if_present) ignore_if_present(
      const ::network::mojom::SharedStorageSetMethodPtr& input) {
    return input->ignore_if_present;
  }

  static bool Read(::network::mojom::SharedStorageSetMethod::DataView input, ::network::mojom::SharedStorageSetMethodPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageAppendMethod::DataView,
                                         ::network::mojom::SharedStorageAppendMethodPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageAppendMethodPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageAppendMethodPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageAppendMethod::key)& key(
      const ::network::mojom::SharedStorageAppendMethodPtr& input) {
    return input->key;
  }

  static const decltype(::network::mojom::SharedStorageAppendMethod::value)& value(
      const ::network::mojom::SharedStorageAppendMethodPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::SharedStorageAppendMethod::DataView input, ::network::mojom::SharedStorageAppendMethodPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageDeleteMethod::DataView,
                                         ::network::mojom::SharedStorageDeleteMethodPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageDeleteMethodPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageDeleteMethodPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageDeleteMethod::key)& key(
      const ::network::mojom::SharedStorageDeleteMethodPtr& input) {
    return input->key;
  }

  static bool Read(::network::mojom::SharedStorageDeleteMethod::DataView input, ::network::mojom::SharedStorageDeleteMethodPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageClearMethod::DataView,
                                         ::network::mojom::SharedStorageClearMethodPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageClearMethodPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageClearMethodPtr* output) { output->reset(); }

  static bool Read(::network::mojom::SharedStorageClearMethod::DataView input, ::network::mojom::SharedStorageClearMethodPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageModifierMethodWithOptions::DataView,
                                         ::network::mojom::SharedStorageModifierMethodWithOptionsPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageModifierMethodWithOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageModifierMethodWithOptionsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageModifierMethodWithOptions::method)& method(
      const ::network::mojom::SharedStorageModifierMethodWithOptionsPtr& input) {
    return input->method;
  }

  static const decltype(::network::mojom::SharedStorageModifierMethodWithOptions::with_lock)& with_lock(
      const ::network::mojom::SharedStorageModifierMethodWithOptionsPtr& input) {
    return input->with_lock;
  }

  static bool Read(::network::mojom::SharedStorageModifierMethodWithOptions::DataView input, ::network::mojom::SharedStorageModifierMethodWithOptionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::SharedStorageBatchUpdateMethodsArgument::DataView,
                                         ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr* output) { output->reset(); }

  static const decltype(::network::mojom::SharedStorageBatchUpdateMethodsArgument::data)& data(
      const ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr& input) {
    return input->data;
  }

  static bool Read(::network::mojom::SharedStorageBatchUpdateMethodsArgument::DataView input, ::network::mojom::SharedStorageBatchUpdateMethodsArgumentPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::SharedStorageModifierMethod::DataView,
                                        ::network::mojom::SharedStorageModifierMethodPtr> {
  static bool IsNull(const ::network::mojom::SharedStorageModifierMethodPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SharedStorageModifierMethodPtr* output) { output->reset(); }

  static ::network::mojom::SharedStorageModifierMethod::Tag GetTag(const ::network::mojom::SharedStorageModifierMethodPtr& input) {
    return input->which();
  }

  static const ::network::mojom::SharedStorageSetMethodPtr& set_method(const ::network::mojom::SharedStorageModifierMethodPtr& input) {
    return input->get_set_method();
  }

  static const ::network::mojom::SharedStorageAppendMethodPtr& append_method(const ::network::mojom::SharedStorageModifierMethodPtr& input) {
    return input->get_append_method();
  }

  static const ::network::mojom::SharedStorageDeleteMethodPtr& delete_method(const ::network::mojom::SharedStorageModifierMethodPtr& input) {
    return input->get_delete_method();
  }

  static const ::network::mojom::SharedStorageClearMethodPtr& clear_method(const ::network::mojom::SharedStorageModifierMethodPtr& input) {
    return input->get_clear_method();
  }

  static bool Read(::network::mojom::SharedStorageModifierMethod::DataView input, ::network::mojom::SharedStorageModifierMethodPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_H_