// services/network/public/mojom/oblivious_http_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "services/network/public/mojom/oblivious_http_request.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ObliviousHttpRequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpRequestBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::content(input)) in_content = Traits::content(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content)::BaseType> content_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_content,
      content_fragment);

    fragment->content.Set(
        content_fragment.is_null() ? nullptr : content_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content in ObliviousHttpRequestBody struct");

    decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_type)::BaseType> content_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_content_type,
      content_type_fragment);

    fragment->content_type.Set(
        content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->content_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_type in ObliviousHttpRequestBody struct");
  }

  static bool Deserialize(::network::mojom::internal::ObliviousHttpRequestBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ObliviousHttpRequestBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ObliviousHttpResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->response_code = Traits::response_code(input);

    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers,
      headers_fragment);

    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->headers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in ObliviousHttpResponse struct");

    decltype(Traits::response_body(input)) in_response_body = Traits::response_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_body)::BaseType> response_body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_response_body,
      response_body_fragment);

    fragment->response_body.Set(
        response_body_fragment.is_null() ? nullptr : response_body_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->response_body.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response_body in ObliviousHttpResponse struct");
  }

  static bool Deserialize(::network::mojom::internal::ObliviousHttpResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ObliviousHttpResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ObliviousHttpPaddingParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpPaddingParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpPaddingParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->add_exponential_pad = Traits::add_exponential_pad(input);

    fragment->exponential_mean = Traits::exponential_mean(input);

    fragment->pad_to_next_power_of_two = Traits::pad_to_next_power_of_two(input);
  }

  static bool Deserialize(::network::mojom::internal::ObliviousHttpPaddingParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ObliviousHttpPaddingParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ObliviousHttpRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ObliviousHttpRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ObliviousHttpRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::relay_url(input)) in_relay_url = Traits::relay_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relay_url)::BaseType> relay_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_relay_url,
      relay_url_fragment);

    fragment->relay_url.Set(
        relay_url_fragment.is_null() ? nullptr : relay_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relay_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relay_url in ObliviousHttpRequest struct");

    decltype(Traits::traffic_annotation(input)) in_traffic_annotation = Traits::traffic_annotation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->traffic_annotation)::BaseType> traffic_annotation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation,
      traffic_annotation_fragment);

    fragment->traffic_annotation.Set(
        traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->traffic_annotation.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in ObliviousHttpRequest struct");

    decltype(Traits::timeout_duration(input)) in_timeout_duration = Traits::timeout_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timeout_duration)::BaseType> timeout_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_timeout_duration,
      timeout_duration_fragment);

    fragment->timeout_duration.Set(
        timeout_duration_fragment.is_null() ? nullptr : timeout_duration_fragment.data());

    decltype(Traits::key_config(input)) in_key_config = Traits::key_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_config)::BaseType> key_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key_config,
      key_config_fragment);

    fragment->key_config.Set(
        key_config_fragment.is_null() ? nullptr : key_config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_config in ObliviousHttpRequest struct");

    decltype(Traits::resource_url(input)) in_resource_url = Traits::resource_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->resource_url)::BaseType> resource_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_resource_url,
      resource_url_fragment);

    fragment->resource_url.Set(
        resource_url_fragment.is_null() ? nullptr : resource_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->resource_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_url in ObliviousHttpRequest struct");

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in ObliviousHttpRequest struct");

    decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_body)::BaseType> request_body_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ObliviousHttpRequestBodyDataView>(
      in_request_body,
      request_body_fragment);

    fragment->request_body.Set(
        request_body_fragment.is_null() ? nullptr : request_body_fragment.data());

    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
      in_trust_token_params,
      trust_token_params_fragment);

    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());

    decltype(Traits::padding_params(input)) in_padding_params = Traits::padding_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->padding_params)::BaseType> padding_params_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ObliviousHttpPaddingParametersDataView>(
      in_padding_params,
      padding_params_fragment);

    fragment->padding_params.Set(
        padding_params_fragment.is_null() ? nullptr : padding_params_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ObliviousHttpRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ObliviousHttpRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ObliviousHttpCompletionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::ObliviousHttpCompletionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::ObliviousHttpCompletionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kNetError: {
    decltype(Traits::net_error(input))
    in_net_error = Traits::net_error(input);
    fragment->data.f_net_error = in_net_error;
    break;
  }
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kOuterResponseErrorCode: {
    decltype(Traits::outer_response_error_code(input))
    in_outer_response_error_code = Traits::outer_response_error_code(input);
    fragment->data.f_outer_response_error_code = in_outer_response_error_code;
    break;
  }
  case ::network::mojom::ObliviousHttpCompletionResultDataView::Tag::kInnerResponse: {
    decltype(Traits::inner_response(input))
    in_inner_response = Traits::inner_response(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_inner_response)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::ObliviousHttpResponseDataView>(
  in_inner_response,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null inner_response in ObliviousHttpCompletionResult union");
    fragment->data.f_inner_response.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::ObliviousHttpCompletionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ObliviousHttpCompletionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ObliviousHttpRequestBodyDataView::GetContentDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->content.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void ObliviousHttpRequestBodyDataView::GetContentTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ObliviousHttpResponseDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}
inline void ObliviousHttpResponseDataView::GetResponseBodyDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->response_body.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}




inline void ObliviousHttpRequestDataView::GetRelayUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->relay_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetTimeoutDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetKeyConfigDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key_config.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetResourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->resource_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetRequestBodyDataView(
    ObliviousHttpRequestBodyDataView* output) {
  auto pointer = data_->request_body.Get();
  *output = ObliviousHttpRequestBodyDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}
inline void ObliviousHttpRequestDataView::GetPaddingParamsDataView(
    ObliviousHttpPaddingParametersDataView* output) {
  auto pointer = data_->padding_params.Get();
  *output = ObliviousHttpPaddingParametersDataView(pointer, message_);
}


inline void ObliviousHttpCompletionResultDataView::GetInnerResponseDataView(
    ObliviousHttpResponseDataView* output) const {
  CHECK(is_inner_response());
  *output = ObliviousHttpResponseDataView(data_->data.f_inner_response.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_OBLIVIOUS_HTTP_REQUEST_MOJOM_SHARED_H_