// services/network/public/mojom/network_service.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data>;

  GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data();
  ~GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data() = delete;
};
static_assert(sizeof(GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data) == 8,
              "Bad sizeof(GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data)");
class  NetworkService_SetParams_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::NetworkServiceParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetParams_Params_Data>;

  NetworkService_SetParams_Params_Data();
  ~NetworkService_SetParams_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetParams_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetParams_Params_Data)");
class  NetworkService_StartNetLog_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;
  uint64_t max_total_size;
  int32_t capture_mode;
  uint8_t pad2_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> constants;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> duration;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_StartNetLog_Params_Data>;

  NetworkService_StartNetLog_Params_Data();
  ~NetworkService_StartNetLog_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_StartNetLog_Params_Data) == 48,
              "Bad sizeof(NetworkService_StartNetLog_Params_Data)");
class  NetworkService_AttachNetLogProxy_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data proxy_source;
  mojo::internal::Handle_Data proxy_sink;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_AttachNetLogProxy_Params_Data>;

  NetworkService_AttachNetLogProxy_Params_Data();
  ~NetworkService_AttachNetLogProxy_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_AttachNetLogProxy_Params_Data) == 24,
              "Bad sizeof(NetworkService_AttachNetLogProxy_Params_Data)");
class  NetworkService_SetSSLKeyLogFile_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetSSLKeyLogFile_Params_Data>;

  NetworkService_SetSSLKeyLogFile_Params_Data();
  ~NetworkService_SetSSLKeyLogFile_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetSSLKeyLogFile_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetSSLKeyLogFile_Params_Data)");
class  NetworkService_CreateNetworkContext_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data context;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::network::mojom::internal::NetworkContextParams_Data> params;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_CreateNetworkContext_Params_Data>;

  NetworkService_CreateNetworkContext_Params_Data();
  ~NetworkService_CreateNetworkContext_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_CreateNetworkContext_Params_Data) == 24,
              "Bad sizeof(NetworkService_CreateNetworkContext_Params_Data)");
class  NetworkService_ConfigureStubHostResolver_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t insecure_dns_client_enabled : 1;
  uint8_t happy_eyeballs_v3_enabled : 1;
  uint8_t additional_dns_types_enabled : 1;
  uint8_t pad2_[3];
  int32_t secure_dns_mode;
  mojo::internal::Pointer<::network::mojom::internal::DnsOverHttpsConfig_Data> dns_over_https_config;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ConfigureStubHostResolver_Params_Data>;

  NetworkService_ConfigureStubHostResolver_Params_Data();
  ~NetworkService_ConfigureStubHostResolver_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_ConfigureStubHostResolver_Params_Data) == 24,
              "Bad sizeof(NetworkService_ConfigureStubHostResolver_Params_Data)");
class  NetworkService_DisableQuic_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_DisableQuic_Params_Data>;

  NetworkService_DisableQuic_Params_Data();
  ~NetworkService_DisableQuic_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_DisableQuic_Params_Data) == 8,
              "Bad sizeof(NetworkService_DisableQuic_Params_Data)");
class  NetworkService_SetUpHttpAuth_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HttpAuthStaticParams_Data> http_auth_static_params;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetUpHttpAuth_Params_Data>;

  NetworkService_SetUpHttpAuth_Params_Data();
  ~NetworkService_SetUpHttpAuth_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetUpHttpAuth_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetUpHttpAuth_Params_Data)");
class  NetworkService_ConfigureHttpAuthPrefs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HttpAuthDynamicParams_Data> http_auth_dynamic_params;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ConfigureHttpAuthPrefs_Params_Data>;

  NetworkService_ConfigureHttpAuthPrefs_Params_Data();
  ~NetworkService_ConfigureHttpAuthPrefs_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_ConfigureHttpAuthPrefs_Params_Data) == 16,
              "Bad sizeof(NetworkService_ConfigureHttpAuthPrefs_Params_Data)");
class  NetworkService_SetRawHeadersAccess_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t process_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Origin_Data>>> origins;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetRawHeadersAccess_Params_Data>;

  NetworkService_SetRawHeadersAccess_Params_Data();
  ~NetworkService_SetRawHeadersAccess_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetRawHeadersAccess_Params_Data) == 24,
              "Bad sizeof(NetworkService_SetRawHeadersAccess_Params_Data)");
class  NetworkService_SetMaxConnectionsPerProxyChain_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t max_connections;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetMaxConnectionsPerProxyChain_Params_Data>;

  NetworkService_SetMaxConnectionsPerProxyChain_Params_Data();
  ~NetworkService_SetMaxConnectionsPerProxyChain_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetMaxConnectionsPerProxyChain_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetMaxConnectionsPerProxyChain_Params_Data)");
class  NetworkService_GetNetworkChangeManager_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data network_change_manager;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_GetNetworkChangeManager_Params_Data>;

  NetworkService_GetNetworkChangeManager_Params_Data();
  ~NetworkService_GetNetworkChangeManager_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_GetNetworkChangeManager_Params_Data) == 16,
              "Bad sizeof(NetworkService_GetNetworkChangeManager_Params_Data)");
class  NetworkService_GetNetworkQualityEstimatorManager_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_GetNetworkQualityEstimatorManager_Params_Data>;

  NetworkService_GetNetworkQualityEstimatorManager_Params_Data();
  ~NetworkService_GetNetworkQualityEstimatorManager_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_GetNetworkQualityEstimatorManager_Params_Data) == 16,
              "Bad sizeof(NetworkService_GetNetworkQualityEstimatorManager_Params_Data)");
class  NetworkService_GetDnsConfigChangeManager_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_GetDnsConfigChangeManager_Params_Data>;

  NetworkService_GetDnsConfigChangeManager_Params_Data();
  ~NetworkService_GetDnsConfigChangeManager_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_GetDnsConfigChangeManager_Params_Data) == 16,
              "Bad sizeof(NetworkService_GetDnsConfigChangeManager_Params_Data)");
class  NetworkService_GetNetworkList_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t policy;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_GetNetworkList_Params_Data>;

  NetworkService_GetNetworkList_Params_Data();
  ~NetworkService_GetNetworkList_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_GetNetworkList_Params_Data) == 16,
              "Bad sizeof(NetworkService_GetNetworkList_Params_Data)");
class  NetworkService_GetNetworkList_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::NetworkInterface_Data>>> networks;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_GetNetworkList_ResponseParams_Data>;

  NetworkService_GetNetworkList_ResponseParams_Data();
  ~NetworkService_GetNetworkList_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_GetNetworkList_ResponseParams_Data) == 16,
              "Bad sizeof(NetworkService_GetNetworkList_ResponseParams_Data)");
class  NetworkService_OnTrustStoreChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_OnTrustStoreChanged_Params_Data>;

  NetworkService_OnTrustStoreChanged_Params_Data();
  ~NetworkService_OnTrustStoreChanged_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_OnTrustStoreChanged_Params_Data) == 8,
              "Bad sizeof(NetworkService_OnTrustStoreChanged_Params_Data)");
class  NetworkService_OnClientCertStoreChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_OnClientCertStoreChanged_Params_Data>;

  NetworkService_OnClientCertStoreChanged_Params_Data();
  ~NetworkService_OnClientCertStoreChanged_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_OnClientCertStoreChanged_Params_Data) == 8,
              "Bad sizeof(NetworkService_OnClientCertStoreChanged_Params_Data)");
class  NetworkService_SetEncryptionKey_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> encryption_key;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetEncryptionKey_Params_Data>;

  NetworkService_SetEncryptionKey_Params_Data();
  ~NetworkService_SetEncryptionKey_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetEncryptionKey_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetEncryptionKey_Params_Data)");
class  NetworkService_OnMemoryPressure_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t memory_pressure_level;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_OnMemoryPressure_Params_Data>;

  NetworkService_OnMemoryPressure_Params_Data();
  ~NetworkService_OnMemoryPressure_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_OnMemoryPressure_Params_Data) == 16,
              "Bad sizeof(NetworkService_OnMemoryPressure_Params_Data)");
class  NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data>;

  NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data();
  ~NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data) == 16,
              "Bad sizeof(NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data)");
class  NetworkService_SetTrustTokenKeyCommitments_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> raw_commitments;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetTrustTokenKeyCommitments_Params_Data>;

  NetworkService_SetTrustTokenKeyCommitments_Params_Data();
  ~NetworkService_SetTrustTokenKeyCommitments_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetTrustTokenKeyCommitments_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetTrustTokenKeyCommitments_Params_Data)");
class  NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data>;

  NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data();
  ~NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data) == 8,
              "Bad sizeof(NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data)");
class  NetworkService_ClearSCTAuditingCache_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ClearSCTAuditingCache_Params_Data>;

  NetworkService_ClearSCTAuditingCache_Params_Data();
  ~NetworkService_ClearSCTAuditingCache_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_ClearSCTAuditingCache_Params_Data) == 8,
              "Bad sizeof(NetworkService_ClearSCTAuditingCache_Params_Data)");
class  NetworkService_ConfigureSCTAuditing_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::SCTAuditingConfiguration_Data> configuration;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ConfigureSCTAuditing_Params_Data>;

  NetworkService_ConfigureSCTAuditing_Params_Data();
  ~NetworkService_ConfigureSCTAuditing_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_ConfigureSCTAuditing_Params_Data) == 16,
              "Bad sizeof(NetworkService_ConfigureSCTAuditing_Params_Data)");
class  NetworkService_UpdateCtLogList_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CTLogInfo_Data>>> log_list;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateCtLogList_Params_Data>;

  NetworkService_UpdateCtLogList_Params_Data();
  ~NetworkService_UpdateCtLogList_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateCtLogList_Params_Data) == 16,
              "Bad sizeof(NetworkService_UpdateCtLogList_Params_Data)");
class  NetworkService_UpdateCtLogList_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateCtLogList_ResponseParams_Data>;

  NetworkService_UpdateCtLogList_ResponseParams_Data();
  ~NetworkService_UpdateCtLogList_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateCtLogList_ResponseParams_Data) == 8,
              "Bad sizeof(NetworkService_UpdateCtLogList_ResponseParams_Data)");
class  NetworkService_UpdateCtKnownPopularSCTs_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>>>> sct_hashes;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateCtKnownPopularSCTs_Params_Data>;

  NetworkService_UpdateCtKnownPopularSCTs_Params_Data();
  ~NetworkService_UpdateCtKnownPopularSCTs_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateCtKnownPopularSCTs_Params_Data) == 16,
              "Bad sizeof(NetworkService_UpdateCtKnownPopularSCTs_Params_Data)");
class  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data>;

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data();
  ~NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data) == 8,
              "Bad sizeof(NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data)");
class  NetworkService_SetCtEnforcementEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetCtEnforcementEnabled_Params_Data>;

  NetworkService_SetCtEnforcementEnabled_Params_Data();
  ~NetworkService_SetCtEnforcementEnabled_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetCtEnforcementEnabled_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetCtEnforcementEnabled_Params_Data)");
class  NetworkService_SetCtEnforcementEnabled_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetCtEnforcementEnabled_ResponseParams_Data>;

  NetworkService_SetCtEnforcementEnabled_ResponseParams_Data();
  ~NetworkService_SetCtEnforcementEnabled_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_SetCtEnforcementEnabled_ResponseParams_Data) == 8,
              "Bad sizeof(NetworkService_SetCtEnforcementEnabled_ResponseParams_Data)");
class  NetworkService_UpdateKeyPinsList_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::PinList_Data> pin_list;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> update_time;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateKeyPinsList_Params_Data>;

  NetworkService_UpdateKeyPinsList_Params_Data();
  ~NetworkService_UpdateKeyPinsList_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateKeyPinsList_Params_Data) == 24,
              "Bad sizeof(NetworkService_UpdateKeyPinsList_Params_Data)");
class  NetworkService_BindTestInterfaceForTesting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_BindTestInterfaceForTesting_Params_Data>;

  NetworkService_BindTestInterfaceForTesting_Params_Data();
  ~NetworkService_BindTestInterfaceForTesting_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_BindTestInterfaceForTesting_Params_Data) == 16,
              "Bad sizeof(NetworkService_BindTestInterfaceForTesting_Params_Data)");
class  NetworkService_SetFirstPartySets_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::GlobalFirstPartySets_Data> sets;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetFirstPartySets_Params_Data>;

  NetworkService_SetFirstPartySets_Params_Data();
  ~NetworkService_SetFirstPartySets_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetFirstPartySets_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetFirstPartySets_Params_Data)");
class  NetworkService_SetExplicitlyAllowedPorts_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint16_t>> ports;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetExplicitlyAllowedPorts_Params_Data>;

  NetworkService_SetExplicitlyAllowedPorts_Params_Data();
  ~NetworkService_SetExplicitlyAllowedPorts_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetExplicitlyAllowedPorts_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetExplicitlyAllowedPorts_Params_Data)");
class  NetworkService_UpdateMaskedDomainList_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> default_file;
  uint64_t default_file_size;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> regular_browsing_file;
  uint64_t regular_browsing_file_size;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateMaskedDomainList_Params_Data>;

  NetworkService_UpdateMaskedDomainList_Params_Data();
  ~NetworkService_UpdateMaskedDomainList_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateMaskedDomainList_Params_Data) == 40,
              "Bad sizeof(NetworkService_UpdateMaskedDomainList_Params_Data)");
class  NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> registry;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data>;

  NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data();
  ~NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data) == 16,
              "Bad sizeof(NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data)");
class  NetworkService_ParseHeaders_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ParseHeaders_Params_Data>;

  NetworkService_ParseHeaders_Params_Data();
  ~NetworkService_ParseHeaders_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_ParseHeaders_Params_Data) == 24,
              "Bad sizeof(NetworkService_ParseHeaders_Params_Data)");
class  NetworkService_ParseHeaders_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::ParsedHeaders_Data> parsed_headers;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_ParseHeaders_ResponseParams_Data>;

  NetworkService_ParseHeaders_ResponseParams_Data();
  ~NetworkService_ParseHeaders_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_ParseHeaders_ResponseParams_Data) == 16,
              "Bad sizeof(NetworkService_ParseHeaders_ResponseParams_Data)");
class  NetworkService_EnableDataUseUpdates_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_EnableDataUseUpdates_Params_Data>;

  NetworkService_EnableDataUseUpdates_Params_Data();
  ~NetworkService_EnableDataUseUpdates_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_EnableDataUseUpdates_Params_Data) == 16,
              "Bad sizeof(NetworkService_EnableDataUseUpdates_Params_Data)");
class  NetworkService_SetIPv6ReachabilityOverride_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t reachability_override : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetIPv6ReachabilityOverride_Params_Data>;

  NetworkService_SetIPv6ReachabilityOverride_Params_Data();
  ~NetworkService_SetIPv6ReachabilityOverride_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetIPv6ReachabilityOverride_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetIPv6ReachabilityOverride_Params_Data)");
class  NetworkService_SetGssapiLibraryLoadObserver_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data gssapi_library_load_observer;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetGssapiLibraryLoadObserver_Params_Data>;

  NetworkService_SetGssapiLibraryLoadObserver_Params_Data();
  ~NetworkService_SetGssapiLibraryLoadObserver_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetGssapiLibraryLoadObserver_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetGssapiLibraryLoadObserver_Params_Data)");
class  NetworkService_SetNetworkAnnotationMonitor_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data remote;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetNetworkAnnotationMonitor_Params_Data>;

  NetworkService_SetNetworkAnnotationMonitor_Params_Data();
  ~NetworkService_SetNetworkAnnotationMonitor_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetNetworkAnnotationMonitor_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetNetworkAnnotationMonitor_Params_Data)");
class  NetworkService_SetTpcdMetadataGrants_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::content_settings::mojom::internal::ContentSettingPatternSource_Data>>> settings;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetTpcdMetadataGrants_Params_Data>;

  NetworkService_SetTpcdMetadataGrants_Params_Data();
  ~NetworkService_SetTpcdMetadataGrants_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetTpcdMetadataGrants_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetTpcdMetadataGrants_Params_Data)");
class  NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> content_encoding_types;
  mojo::internal::Handle_Data source_body;
  mojo::internal::Handle_Data dest_body;
  mojo::internal::Interface_Data source_url_loader;
  mojo::internal::Handle_Data source_url_loader_client;
  mojo::internal::Handle_Data dest_url_loader;
  mojo::internal::Interface_Data dest_url_loader_client;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data>;

  NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data();
  ~NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data) == 48,
              "Bad sizeof(NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data)");
class  NetworkService_DecodeContentEncoding_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> content_encoding_types;
  mojo::internal::Handle_Data source_body;
  mojo::internal::Handle_Data dest_body;

 private:
  friend class mojo::internal::MessageFragment<NetworkService_DecodeContentEncoding_Params_Data>;

  NetworkService_DecodeContentEncoding_Params_Data();
  ~NetworkService_DecodeContentEncoding_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_DecodeContentEncoding_Params_Data) == 24,
              "Bad sizeof(NetworkService_DecodeContentEncoding_Params_Data)");
class  NetworkService_DecodeContentEncoding_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_DecodeContentEncoding_ResponseParams_Data>;

  NetworkService_DecodeContentEncoding_ResponseParams_Data();
  ~NetworkService_DecodeContentEncoding_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetworkService_DecodeContentEncoding_ResponseParams_Data) == 16,
              "Bad sizeof(NetworkService_DecodeContentEncoding_ResponseParams_Data)");
class  NetworkService_SetTLS13EarlyDataEnabled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enabled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<NetworkService_SetTLS13EarlyDataEnabled_Params_Data>;

  NetworkService_SetTLS13EarlyDataEnabled_Params_Data();
  ~NetworkService_SetTLS13EarlyDataEnabled_Params_Data() = delete;
};
static_assert(sizeof(NetworkService_SetTLS13EarlyDataEnabled_Params_Data) == 16,
              "Bad sizeof(NetworkService_SetTLS13EarlyDataEnabled_Params_Data)");

}  // namespace internal


class GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_ParamsDataView {
 public:
  GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_ParamsDataView() = default;

  GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_ParamsDataView(
      internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data* data_ = nullptr;
};


class NetworkService_SetParams_ParamsDataView {
 public:
  NetworkService_SetParams_ParamsDataView() = default;

  NetworkService_SetParams_ParamsDataView(
      internal::NetworkService_SetParams_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      NetworkServiceParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::network::mojom::NetworkServiceParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetParams_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_StartNetLog_ParamsDataView {
 public:
  NetworkService_StartNetLog_ParamsDataView() = default;

  NetworkService_StartNetLog_ParamsDataView(
      internal::NetworkService_StartNetLog_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  uint64_t max_total_size() const {
    return data_->max_total_size;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCaptureMode(UserType* output) const {
    auto data_value = data_->capture_mode;
    return mojo::internal::Deserialize<::network::mojom::NetLogCaptureMode>(
        data_value, output);
  }
  ::network::mojom::NetLogCaptureMode capture_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::NetLogCaptureMode>(data_->capture_mode));
  }
  inline void GetConstantsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConstants(UserType* output) {
    
    auto* pointer = data_->constants.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `duration` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDuration` instead "
    "of `ReadDuration if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_StartNetLog_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_AttachNetLogProxy_ParamsDataView {
 public:
  NetworkService_AttachNetLogProxy_ParamsDataView() = default;

  NetworkService_AttachNetLogProxy_ParamsDataView(
      internal::NetworkService_AttachNetLogProxy_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeProxySource() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::NetLogProxySourceInterfaceBase>>(
            &data_->proxy_source, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeProxySink() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetLogProxySinkInterfaceBase>>(
            &data_->proxy_sink, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_AttachNetLogProxy_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetSSLKeyLogFile_ParamsDataView {
 public:
  NetworkService_SetSSLKeyLogFile_ParamsDataView() = default;

  NetworkService_SetSSLKeyLogFile_ParamsDataView(
      internal::NetworkService_SetSSLKeyLogFile_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetSSLKeyLogFile_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_CreateNetworkContext_ParamsDataView {
 public:
  NetworkService_CreateNetworkContext_ParamsDataView() = default;

  NetworkService_CreateNetworkContext_ParamsDataView(
      internal::NetworkService_CreateNetworkContext_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeContext() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkContextInterfaceBase>>(
            &data_->context, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetParamsDataView(
      ::network::mojom::NetworkContextParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::network::mojom::NetworkContextParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_CreateNetworkContext_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_ConfigureStubHostResolver_ParamsDataView {
 public:
  NetworkService_ConfigureStubHostResolver_ParamsDataView() = default;

  NetworkService_ConfigureStubHostResolver_ParamsDataView(
      internal::NetworkService_ConfigureStubHostResolver_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool insecure_dns_client_enabled() const {
    return data_->insecure_dns_client_enabled;
  }
  bool happy_eyeballs_v3_enabled() const {
    return data_->happy_eyeballs_v3_enabled;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSecureDnsMode(UserType* output) const {
    auto data_value = data_->secure_dns_mode;
    return mojo::internal::Deserialize<::network::mojom::SecureDnsMode>(
        data_value, output);
  }
  ::network::mojom::SecureDnsMode secure_dns_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SecureDnsMode>(data_->secure_dns_mode));
  }
  inline void GetDnsOverHttpsConfigDataView(
      ::network::mojom::DnsOverHttpsConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDnsOverHttpsConfig(UserType* output) {
    
    auto* pointer = data_->dns_over_https_config.Get();
    return mojo::internal::Deserialize<::network::mojom::DnsOverHttpsConfigDataView>(
        pointer, output, message_);
  }
  bool additional_dns_types_enabled() const {
    return data_->additional_dns_types_enabled;
  }
 private:
  internal::NetworkService_ConfigureStubHostResolver_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_DisableQuic_ParamsDataView {
 public:
  NetworkService_DisableQuic_ParamsDataView() = default;

  NetworkService_DisableQuic_ParamsDataView(
      internal::NetworkService_DisableQuic_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_DisableQuic_Params_Data* data_ = nullptr;
};


class NetworkService_SetUpHttpAuth_ParamsDataView {
 public:
  NetworkService_SetUpHttpAuth_ParamsDataView() = default;

  NetworkService_SetUpHttpAuth_ParamsDataView(
      internal::NetworkService_SetUpHttpAuth_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHttpAuthStaticParamsDataView(
      HttpAuthStaticParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpAuthStaticParams(UserType* output) {
    
    auto* pointer = data_->http_auth_static_params.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpAuthStaticParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetUpHttpAuth_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_ConfigureHttpAuthPrefs_ParamsDataView {
 public:
  NetworkService_ConfigureHttpAuthPrefs_ParamsDataView() = default;

  NetworkService_ConfigureHttpAuthPrefs_ParamsDataView(
      internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHttpAuthDynamicParamsDataView(
      HttpAuthDynamicParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpAuthDynamicParams(UserType* output) {
    
    auto* pointer = data_->http_auth_dynamic_params.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpAuthDynamicParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetRawHeadersAccess_ParamsDataView {
 public:
  NetworkService_SetRawHeadersAccess_ParamsDataView() = default;

  NetworkService_SetRawHeadersAccess_ParamsDataView(
      internal::NetworkService_SetRawHeadersAccess_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetOriginsDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigins(UserType* output) {
    
    auto* pointer = data_->origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetRawHeadersAccess_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetMaxConnectionsPerProxyChain_ParamsDataView {
 public:
  NetworkService_SetMaxConnectionsPerProxyChain_ParamsDataView() = default;

  NetworkService_SetMaxConnectionsPerProxyChain_ParamsDataView(
      internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t max_connections() const {
    return data_->max_connections;
  }
 private:
  internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data* data_ = nullptr;
};


class NetworkService_GetNetworkChangeManager_ParamsDataView {
 public:
  NetworkService_GetNetworkChangeManager_ParamsDataView() = default;

  NetworkService_GetNetworkChangeManager_ParamsDataView(
      internal::NetworkService_GetNetworkChangeManager_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeNetworkChangeManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkChangeManagerInterfaceBase>>(
            &data_->network_change_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_GetNetworkChangeManager_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_GetNetworkQualityEstimatorManager_ParamsDataView {
 public:
  NetworkService_GetNetworkQualityEstimatorManager_ParamsDataView() = default;

  NetworkService_GetNetworkQualityEstimatorManager_ParamsDataView(
      internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkQualityEstimatorManagerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_GetDnsConfigChangeManager_ParamsDataView {
 public:
  NetworkService_GetDnsConfigChangeManager_ParamsDataView() = default;

  NetworkService_GetDnsConfigChangeManager_ParamsDataView(
      internal::NetworkService_GetDnsConfigChangeManager_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::DnsConfigChangeManagerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_GetDnsConfigChangeManager_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_GetNetworkList_ParamsDataView {
 public:
  NetworkService_GetNetworkList_ParamsDataView() = default;

  NetworkService_GetNetworkList_ParamsDataView(
      internal::NetworkService_GetNetworkList_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t policy() const {
    return data_->policy;
  }
 private:
  internal::NetworkService_GetNetworkList_Params_Data* data_ = nullptr;
};


class NetworkService_GetNetworkList_ResponseParamsDataView {
 public:
  NetworkService_GetNetworkList_ResponseParamsDataView() = default;

  NetworkService_GetNetworkList_ResponseParamsDataView(
      internal::NetworkService_GetNetworkList_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNetworksDataView(
      mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworks(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>, UserType>(),
    "Attempting to read the optional `networks` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetworks` instead "
    "of `ReadNetworks if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->networks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_GetNetworkList_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_OnTrustStoreChanged_ParamsDataView {
 public:
  NetworkService_OnTrustStoreChanged_ParamsDataView() = default;

  NetworkService_OnTrustStoreChanged_ParamsDataView(
      internal::NetworkService_OnTrustStoreChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_OnTrustStoreChanged_Params_Data* data_ = nullptr;
};


class NetworkService_OnClientCertStoreChanged_ParamsDataView {
 public:
  NetworkService_OnClientCertStoreChanged_ParamsDataView() = default;

  NetworkService_OnClientCertStoreChanged_ParamsDataView(
      internal::NetworkService_OnClientCertStoreChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_OnClientCertStoreChanged_Params_Data* data_ = nullptr;
};


class NetworkService_SetEncryptionKey_ParamsDataView {
 public:
  NetworkService_SetEncryptionKey_ParamsDataView() = default;

  NetworkService_SetEncryptionKey_ParamsDataView(
      internal::NetworkService_SetEncryptionKey_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEncryptionKeyDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncryptionKey(UserType* output) {
    
    auto* pointer = data_->encryption_key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetEncryptionKey_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_OnMemoryPressure_ParamsDataView {
 public:
  NetworkService_OnMemoryPressure_ParamsDataView() = default;

  NetworkService_OnMemoryPressure_ParamsDataView(
      internal::NetworkService_OnMemoryPressure_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMemoryPressureLevel(UserType* output) const {
    auto data_value = data_->memory_pressure_level;
    return mojo::internal::Deserialize<::mojo_base::mojom::MemoryPressureLevel>(
        data_value, output);
  }
  ::mojo_base::mojom::MemoryPressureLevel memory_pressure_level() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::MemoryPressureLevel>(data_->memory_pressure_level));
  }
 private:
  internal::NetworkService_OnMemoryPressure_Params_Data* data_ = nullptr;
};


class NetworkService_OnPeerToPeerConnectionsCountChange_ParamsDataView {
 public:
  NetworkService_OnPeerToPeerConnectionsCountChange_ParamsDataView() = default;

  NetworkService_OnPeerToPeerConnectionsCountChange_ParamsDataView(
      internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t count() const {
    return data_->count;
  }
 private:
  internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* data_ = nullptr;
};


class NetworkService_SetTrustTokenKeyCommitments_ParamsDataView {
 public:
  NetworkService_SetTrustTokenKeyCommitments_ParamsDataView() = default;

  NetworkService_SetTrustTokenKeyCommitments_ParamsDataView(
      internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRawCommitmentsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawCommitments(UserType* output) {
    
    auto* pointer = data_->raw_commitments.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetTrustTokenKeyCommitments_ResponseParamsDataView {
 public:
  NetworkService_SetTrustTokenKeyCommitments_ResponseParamsDataView() = default;

  NetworkService_SetTrustTokenKeyCommitments_ResponseParamsDataView(
      internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* data_ = nullptr;
};


class NetworkService_ClearSCTAuditingCache_ParamsDataView {
 public:
  NetworkService_ClearSCTAuditingCache_ParamsDataView() = default;

  NetworkService_ClearSCTAuditingCache_ParamsDataView(
      internal::NetworkService_ClearSCTAuditingCache_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_ClearSCTAuditingCache_Params_Data* data_ = nullptr;
};


class NetworkService_ConfigureSCTAuditing_ParamsDataView {
 public:
  NetworkService_ConfigureSCTAuditing_ParamsDataView() = default;

  NetworkService_ConfigureSCTAuditing_ParamsDataView(
      internal::NetworkService_ConfigureSCTAuditing_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetConfigurationDataView(
      SCTAuditingConfigurationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfiguration(UserType* output) {
    
    auto* pointer = data_->configuration.Get();
    return mojo::internal::Deserialize<::network::mojom::SCTAuditingConfigurationDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_ConfigureSCTAuditing_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_UpdateCtLogList_ParamsDataView {
 public:
  NetworkService_UpdateCtLogList_ParamsDataView() = default;

  NetworkService_UpdateCtLogList_ParamsDataView(
      internal::NetworkService_UpdateCtLogList_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLogListDataView(
      mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogList(UserType* output) {
    
    auto* pointer = data_->log_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_UpdateCtLogList_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_UpdateCtLogList_ResponseParamsDataView {
 public:
  NetworkService_UpdateCtLogList_ResponseParamsDataView() = default;

  NetworkService_UpdateCtLogList_ResponseParamsDataView(
      internal::NetworkService_UpdateCtLogList_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_UpdateCtLogList_ResponseParams_Data* data_ = nullptr;
};


class NetworkService_UpdateCtKnownPopularSCTs_ParamsDataView {
 public:
  NetworkService_UpdateCtKnownPopularSCTs_ParamsDataView() = default;

  NetworkService_UpdateCtKnownPopularSCTs_ParamsDataView(
      internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSctHashesDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSctHashes(UserType* output) {
    
    auto* pointer = data_->sct_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsDataView {
 public:
  NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsDataView() = default;

  NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsDataView(
      internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data* data_ = nullptr;
};


class NetworkService_SetCtEnforcementEnabled_ParamsDataView {
 public:
  NetworkService_SetCtEnforcementEnabled_ParamsDataView() = default;

  NetworkService_SetCtEnforcementEnabled_ParamsDataView(
      internal::NetworkService_SetCtEnforcementEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::NetworkService_SetCtEnforcementEnabled_Params_Data* data_ = nullptr;
};


class NetworkService_SetCtEnforcementEnabled_ResponseParamsDataView {
 public:
  NetworkService_SetCtEnforcementEnabled_ResponseParamsDataView() = default;

  NetworkService_SetCtEnforcementEnabled_ResponseParamsDataView(
      internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data* data_ = nullptr;
};


class NetworkService_UpdateKeyPinsList_ParamsDataView {
 public:
  NetworkService_UpdateKeyPinsList_ParamsDataView() = default;

  NetworkService_UpdateKeyPinsList_ParamsDataView(
      internal::NetworkService_UpdateKeyPinsList_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPinListDataView(
      ::network::mojom::PinListDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPinList(UserType* output) {
    
    auto* pointer = data_->pin_list.Get();
    return mojo::internal::Deserialize<::network::mojom::PinListDataView>(
        pointer, output, message_);
  }
  inline void GetUpdateTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateTime(UserType* output) {
    
    auto* pointer = data_->update_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_UpdateKeyPinsList_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_BindTestInterfaceForTesting_ParamsDataView {
 public:
  NetworkService_BindTestInterfaceForTesting_ParamsDataView() = default;

  NetworkService_BindTestInterfaceForTesting_ParamsDataView(
      internal::NetworkService_BindTestInterfaceForTesting_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkServiceTestInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_BindTestInterfaceForTesting_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetFirstPartySets_ParamsDataView {
 public:
  NetworkService_SetFirstPartySets_ParamsDataView() = default;

  NetworkService_SetFirstPartySets_ParamsDataView(
      internal::NetworkService_SetFirstPartySets_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSetsDataView(
      ::network::mojom::GlobalFirstPartySetsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSets(UserType* output) {
    
    auto* pointer = data_->sets.Get();
    return mojo::internal::Deserialize<::network::mojom::GlobalFirstPartySetsDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetFirstPartySets_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetExplicitlyAllowedPorts_ParamsDataView {
 public:
  NetworkService_SetExplicitlyAllowedPorts_ParamsDataView() = default;

  NetworkService_SetExplicitlyAllowedPorts_ParamsDataView(
      internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPortsDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPorts(UserType* output) {
    
    auto* pointer = data_->ports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_UpdateMaskedDomainList_ParamsDataView {
 public:
  NetworkService_UpdateMaskedDomainList_ParamsDataView() = default;

  NetworkService_UpdateMaskedDomainList_ParamsDataView(
      internal::NetworkService_UpdateMaskedDomainList_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDefaultFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultFile(UserType* output) {
    
    auto* pointer = data_->default_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  uint64_t default_file_size() const {
    return data_->default_file_size;
  }
  inline void GetRegularBrowsingFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegularBrowsingFile(UserType* output) {
    
    auto* pointer = data_->regular_browsing_file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, message_);
  }
  uint64_t regular_browsing_file_size() const {
    return data_->regular_browsing_file_size;
  }
 private:
  internal::NetworkService_UpdateMaskedDomainList_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsDataView {
 public:
  NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsDataView() = default;

  NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsDataView(
      internal::NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRegistryDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRegistry(UserType* output) {
    
    auto* pointer = data_->registry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_ParseHeaders_ParamsDataView {
 public:
  NetworkService_ParseHeaders_ParamsDataView() = default;

  NetworkService_ParseHeaders_ParamsDataView(
      internal::NetworkService_ParseHeaders_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpResponseHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpResponseHeadersDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_ParseHeaders_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_ParseHeaders_ResponseParamsDataView {
 public:
  NetworkService_ParseHeaders_ResponseParamsDataView() = default;

  NetworkService_ParseHeaders_ResponseParamsDataView(
      internal::NetworkService_ParseHeaders_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParsedHeadersDataView(
      ::network::mojom::ParsedHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsedHeaders(UserType* output) {
    
    auto* pointer = data_->parsed_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::ParsedHeadersDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_ParseHeaders_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_EnableDataUseUpdates_ParamsDataView {
 public:
  NetworkService_EnableDataUseUpdates_ParamsDataView() = default;

  NetworkService_EnableDataUseUpdates_ParamsDataView(
      internal::NetworkService_EnableDataUseUpdates_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::NetworkService_EnableDataUseUpdates_Params_Data* data_ = nullptr;
};


class NetworkService_SetIPv6ReachabilityOverride_ParamsDataView {
 public:
  NetworkService_SetIPv6ReachabilityOverride_ParamsDataView() = default;

  NetworkService_SetIPv6ReachabilityOverride_ParamsDataView(
      internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool reachability_override() const {
    return data_->reachability_override;
  }
 private:
  internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data* data_ = nullptr;
};


class NetworkService_SetGssapiLibraryLoadObserver_ParamsDataView {
 public:
  NetworkService_SetGssapiLibraryLoadObserver_ParamsDataView() = default;

  NetworkService_SetGssapiLibraryLoadObserver_ParamsDataView(
      internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeGssapiLibraryLoadObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::GssapiLibraryLoadObserverInterfaceBase>>(
            &data_->gssapi_library_load_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetNetworkAnnotationMonitor_ParamsDataView {
 public:
  NetworkService_SetNetworkAnnotationMonitor_ParamsDataView() = default;

  NetworkService_SetNetworkAnnotationMonitor_ParamsDataView(
      internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::NetworkAnnotationMonitorInterfaceBase>>(
            &data_->remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_SetTpcdMetadataGrants_ParamsDataView {
 public:
  NetworkService_SetTpcdMetadataGrants_ParamsDataView() = default;

  NetworkService_SetTpcdMetadataGrants_ParamsDataView(
      internal::NetworkService_SetTpcdMetadataGrants_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSettingsDataView(
      mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkService_SetTpcdMetadataGrants_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsDataView {
 public:
  NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsDataView() = default;

  NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsDataView(
      internal::NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentEncodingTypesDataView(
      mojo::ArrayDataView<::network::mojom::SourceType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentEncodingTypes(UserType* output) {
    
    auto* pointer = data_->content_encoding_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeSourceBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->source_body, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeDestBody() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->dest_body, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSourceUrlLoader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderInterfaceBase>>(
            &data_->source_url_loader, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSourceUrlLoaderClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
            &data_->source_url_loader_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDestUrlLoader() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderInterfaceBase>>(
            &data_->dest_url_loader, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDestUrlLoaderClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderClientInterfaceBase>>(
            &data_->dest_url_loader_client, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_DecodeContentEncoding_ParamsDataView {
 public:
  NetworkService_DecodeContentEncoding_ParamsDataView() = default;

  NetworkService_DecodeContentEncoding_ParamsDataView(
      internal::NetworkService_DecodeContentEncoding_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentEncodingTypesDataView(
      mojo::ArrayDataView<::network::mojom::SourceType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentEncodingTypes(UserType* output) {
    
    auto* pointer = data_->content_encoding_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        pointer, output, message_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeSourceBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->source_body, &result, message_);
    DCHECK(ret);
    return result;
  }
  mojo::ScopedDataPipeProducerHandle TakeDestBody() {
    mojo::ScopedDataPipeProducerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeProducerHandle>(
            &data_->dest_body, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::NetworkService_DecodeContentEncoding_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkService_DecodeContentEncoding_ResponseParamsDataView {
 public:
  NetworkService_DecodeContentEncoding_ResponseParamsDataView() = default;

  NetworkService_DecodeContentEncoding_ResponseParamsDataView(
      internal::NetworkService_DecodeContentEncoding_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t error_code() const {
    return data_->error_code;
  }
 private:
  internal::NetworkService_DecodeContentEncoding_ResponseParams_Data* data_ = nullptr;
};


class NetworkService_SetTLS13EarlyDataEnabled_ParamsDataView {
 public:
  NetworkService_SetTLS13EarlyDataEnabled_ParamsDataView() = default;

  NetworkService_SetTLS13EarlyDataEnabled_ParamsDataView(
      internal::NetworkService_SetTLS13EarlyDataEnabled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enabled() const {
    return data_->enabled;
  }
 private:
  internal::NetworkService_SetTLS13EarlyDataEnabled_Params_Data* data_ = nullptr;
};



inline void NetworkService_SetParams_ParamsDataView::GetParamsDataView(
    NetworkServiceParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = NetworkServiceParamsDataView(pointer, message_);
}


inline void NetworkService_StartNetLog_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void NetworkService_StartNetLog_ParamsDataView::GetConstantsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->constants.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}
inline void NetworkService_StartNetLog_ParamsDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void NetworkService_SetSSLKeyLogFile_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void NetworkService_CreateNetworkContext_ParamsDataView::GetParamsDataView(
    ::network::mojom::NetworkContextParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::network::mojom::NetworkContextParamsDataView(pointer, message_);
}


inline void NetworkService_ConfigureStubHostResolver_ParamsDataView::GetDnsOverHttpsConfigDataView(
    ::network::mojom::DnsOverHttpsConfigDataView* output) {
  auto pointer = data_->dns_over_https_config.Get();
  *output = ::network::mojom::DnsOverHttpsConfigDataView(pointer, message_);
}




inline void NetworkService_SetUpHttpAuth_ParamsDataView::GetHttpAuthStaticParamsDataView(
    HttpAuthStaticParamsDataView* output) {
  auto pointer = data_->http_auth_static_params.Get();
  *output = HttpAuthStaticParamsDataView(pointer, message_);
}


inline void NetworkService_ConfigureHttpAuthPrefs_ParamsDataView::GetHttpAuthDynamicParamsDataView(
    HttpAuthDynamicParamsDataView* output) {
  auto pointer = data_->http_auth_dynamic_params.Get();
  *output = HttpAuthDynamicParamsDataView(pointer, message_);
}


inline void NetworkService_SetRawHeadersAccess_ParamsDataView::GetOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}












inline void NetworkService_GetNetworkList_ResponseParamsDataView::GetNetworksDataView(
    mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>* output) {
  auto pointer = data_->networks.Get();
  *output = mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>(pointer, message_);
}






inline void NetworkService_SetEncryptionKey_ParamsDataView::GetEncryptionKeyDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->encryption_key.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}






inline void NetworkService_SetTrustTokenKeyCommitments_ParamsDataView::GetRawCommitmentsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->raw_commitments.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void NetworkService_ConfigureSCTAuditing_ParamsDataView::GetConfigurationDataView(
    SCTAuditingConfigurationDataView* output) {
  auto pointer = data_->configuration.Get();
  *output = SCTAuditingConfigurationDataView(pointer, message_);
}


inline void NetworkService_UpdateCtLogList_ParamsDataView::GetLogListDataView(
    mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>* output) {
  auto pointer = data_->log_list.Get();
  *output = mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>(pointer, message_);
}




inline void NetworkService_UpdateCtKnownPopularSCTs_ParamsDataView::GetSctHashesDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->sct_hashes.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}








inline void NetworkService_UpdateKeyPinsList_ParamsDataView::GetPinListDataView(
    ::network::mojom::PinListDataView* output) {
  auto pointer = data_->pin_list.Get();
  *output = ::network::mojom::PinListDataView(pointer, message_);
}
inline void NetworkService_UpdateKeyPinsList_ParamsDataView::GetUpdateTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->update_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}




inline void NetworkService_SetFirstPartySets_ParamsDataView::GetSetsDataView(
    ::network::mojom::GlobalFirstPartySetsDataView* output) {
  auto pointer = data_->sets.Get();
  *output = ::network::mojom::GlobalFirstPartySetsDataView(pointer, message_);
}


inline void NetworkService_SetExplicitlyAllowedPorts_ParamsDataView::GetPortsDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->ports.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}


inline void NetworkService_UpdateMaskedDomainList_ParamsDataView::GetDefaultFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->default_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}
inline void NetworkService_UpdateMaskedDomainList_ParamsDataView::GetRegularBrowsingFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->regular_browsing_file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, message_);
}


inline void NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsDataView::GetRegistryDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->registry.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}


inline void NetworkService_ParseHeaders_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void NetworkService_ParseHeaders_ParamsDataView::GetHeadersDataView(
    ::network::mojom::HttpResponseHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpResponseHeadersDataView(pointer, message_);
}


inline void NetworkService_ParseHeaders_ResponseParamsDataView::GetParsedHeadersDataView(
    ::network::mojom::ParsedHeadersDataView* output) {
  auto pointer = data_->parsed_headers.Get();
  *output = ::network::mojom::ParsedHeadersDataView(pointer, message_);
}










inline void NetworkService_SetTpcdMetadataGrants_ParamsDataView::GetSettingsDataView(
    mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->settings.Get();
  *output = mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>(pointer, message_);
}


inline void NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsDataView::GetContentEncodingTypesDataView(
    mojo::ArrayDataView<::network::mojom::SourceType>* output) {
  auto pointer = data_->content_encoding_types.Get();
  *output = mojo::ArrayDataView<::network::mojom::SourceType>(pointer, message_);
}


inline void NetworkService_DecodeContentEncoding_ParamsDataView::GetContentEncodingTypesDataView(
    mojo::ArrayDataView<::network::mojom::SourceType>* output) {
  auto pointer = data_->content_encoding_types.Get();
  *output = mojo::ArrayDataView<::network::mojom::SourceType>(pointer, message_);
}







}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_PARAMS_DATA_H_