// services/network/public/mojom/integrity_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/integrity_policy.mojom-shared-internal.h"


namespace network::mojom {
class IntegrityPolicyDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::IntegrityPolicyDataView> {
  using Data = ::network::mojom::internal::IntegrityPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class IntegrityPolicy_Destination : int32_t {
  
  kScript = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, IntegrityPolicy_Destination value);
inline bool IsKnownEnumValue(IntegrityPolicy_Destination value) {
  return internal::IntegrityPolicy_Destination_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IntegrityPolicy_Source : int32_t {
  
  kInline = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, IntegrityPolicy_Source value);
inline bool IsKnownEnumValue(IntegrityPolicy_Source value) {
  return internal::IntegrityPolicy_Source_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class IntegrityPolicyDataView {
 public:
  IntegrityPolicyDataView() = default;

  IntegrityPolicyDataView(
      internal::IntegrityPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBlockedDestinationsDataView(
      mojo::ArrayDataView<IntegrityPolicy_Destination>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedDestinations(UserType* output) {
    
    auto* pointer = data_->blocked_destinations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityPolicy_Destination>>(
        pointer, output, message_);
  }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<IntegrityPolicy_Source>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityPolicy_Source>>(
        pointer, output, message_);
  }
  inline void GetEndpointsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoints(UserType* output) {
    
    auto* pointer = data_->endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetParsingErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsingErrors(UserType* output) {
    
    auto* pointer = data_->parsing_errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::IntegrityPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_INTEGRITY_POLICY_MOJOM_DATA_VIEW_H_