// services/network/public/mojom/first_party_sets.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/first_party_sets.mojom-shared-internal.h"
#include "mojo/public/mojom/base/version.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"




#include "services/network/public/mojom/first_party_sets.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::SiteType>
    : public mojo::internal::EnumHashImpl<::network::mojom::SiteType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SiteType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SiteType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SiteType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FirstPartySetEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::primary(input)) in_primary = Traits::primary(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary)::BaseType> primary_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_primary,
      primary_fragment);

    fragment->primary.Set(
        primary_fragment.is_null() ? nullptr : primary_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary in FirstPartySetEntry struct");

    
    mojo::internal::Serialize<::network::mojom::SiteType>(
      Traits::site_type(input),
      &fragment->site_type);
  }

  static bool Deserialize(::network::mojom::internal::FirstPartySetEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FirstPartySetEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FirstPartySetMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_entry(input)) in_frame_entry = Traits::frame_entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_entry)::BaseType> frame_entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView>(
      in_frame_entry,
      frame_entry_fragment);

    fragment->frame_entry.Set(
        frame_entry_fragment.is_null() ? nullptr : frame_entry_fragment.data());

    decltype(Traits::top_frame_entry(input)) in_top_frame_entry = Traits::top_frame_entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_entry)::BaseType> top_frame_entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView>(
      in_top_frame_entry,
      top_frame_entry_fragment);

    fragment->top_frame_entry.Set(
        top_frame_entry_fragment.is_null() ? nullptr : top_frame_entry_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::FirstPartySetMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FirstPartySetMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FirstPartySetEntryOverrideDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetEntryOverrideDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetEntryOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::entry(input)) in_entry = Traits::entry(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->entry)::BaseType> entry_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::FirstPartySetEntryDataView>(
      in_entry,
      entry_fragment);

    fragment->entry.Set(
        entry_fragment.is_null() ? nullptr : entry_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::FirstPartySetEntryOverride_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FirstPartySetEntryOverrideDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FirstPartySetsContextConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetsContextConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetsContextConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::customizations(input)) in_customizations = Traits::customizations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->customizations)::BaseType>
        customizations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& customizations_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryOverrideDataView>>(
      in_customizations,
      customizations_fragment,
      &customizations_validate_params);

    fragment->customizations.Set(
        customizations_fragment.is_null() ? nullptr : customizations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->customizations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null customizations in FirstPartySetsContextConfig struct");

    decltype(Traits::aliases(input)) in_aliases = Traits::aliases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aliases)::BaseType>
        aliases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>>(
      in_aliases,
      aliases_fragment,
      &aliases_validate_params);

    fragment->aliases.Set(
        aliases_fragment.is_null() ? nullptr : aliases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aliases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aliases in FirstPartySetsContextConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::FirstPartySetsContextConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FirstPartySetsContextConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::FirstPartySetsCacheFilterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::FirstPartySetsCacheFilterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::FirstPartySetsCacheFilter_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::filter(input)) in_filter = Traits::filter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filter)::BaseType>
        filter_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& filter_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>>(
      in_filter,
      filter_fragment,
      &filter_validate_params);

    fragment->filter.Set(
        filter_fragment.is_null() ? nullptr : filter_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->filter.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null filter in FirstPartySetsCacheFilter struct");

    fragment->browser_run_id = Traits::browser_run_id(input);
  }

  static bool Deserialize(::network::mojom::internal::FirstPartySetsCacheFilter_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::FirstPartySetsCacheFilterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::GlobalFirstPartySetsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::GlobalFirstPartySetsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::GlobalFirstPartySets_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::public_sets_version(input)) in_public_sets_version = Traits::public_sets_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->public_sets_version)::BaseType> public_sets_version_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::VersionDataView>(
      in_public_sets_version,
      public_sets_version_fragment);

    fragment->public_sets_version.Set(
        public_sets_version_fragment.is_null() ? nullptr : public_sets_version_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->public_sets_version.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null public_sets_version in GlobalFirstPartySets struct");

    decltype(Traits::sets(input)) in_sets = Traits::sets(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sets)::BaseType>
        sets_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sets_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::FirstPartySetEntryDataView>>(
      in_sets,
      sets_fragment,
      &sets_validate_params);

    fragment->sets.Set(
        sets_fragment.is_null() ? nullptr : sets_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sets.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sets in GlobalFirstPartySets struct");

    decltype(Traits::aliases(input)) in_aliases = Traits::aliases(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aliases)::BaseType>
        aliases_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& aliases_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>>(
      in_aliases,
      aliases_fragment,
      &aliases_validate_params);

    fragment->aliases.Set(
        aliases_fragment.is_null() ? nullptr : aliases_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aliases.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aliases in GlobalFirstPartySets struct");

    decltype(Traits::manual_config(input)) in_manual_config = Traits::manual_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manual_config)::BaseType> manual_config_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::FirstPartySetsContextConfigDataView>(
      in_manual_config,
      manual_config_fragment);

    fragment->manual_config.Set(
        manual_config_fragment.is_null() ? nullptr : manual_config_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->manual_config.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null manual_config in GlobalFirstPartySets struct");
  }

  static bool Deserialize(::network::mojom::internal::GlobalFirstPartySets_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::GlobalFirstPartySetsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void FirstPartySetEntryDataView::GetPrimaryDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->primary.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}


inline void FirstPartySetMetadataDataView::GetFrameEntryDataView(
    FirstPartySetEntryDataView* output) {
  auto pointer = data_->frame_entry.Get();
  *output = FirstPartySetEntryDataView(pointer, message_);
}
inline void FirstPartySetMetadataDataView::GetTopFrameEntryDataView(
    FirstPartySetEntryDataView* output) {
  auto pointer = data_->top_frame_entry.Get();
  *output = FirstPartySetEntryDataView(pointer, message_);
}


inline void FirstPartySetEntryOverrideDataView::GetEntryDataView(
    FirstPartySetEntryDataView* output) {
  auto pointer = data_->entry.Get();
  *output = FirstPartySetEntryDataView(pointer, message_);
}


inline void FirstPartySetsContextConfigDataView::GetCustomizationsDataView(
    mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryOverrideDataView>* output) {
  auto pointer = data_->customizations.Get();
  *output = mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryOverrideDataView>(pointer, message_);
}
inline void FirstPartySetsContextConfigDataView::GetAliasesDataView(
    mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>* output) {
  auto pointer = data_->aliases.Get();
  *output = mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>(pointer, message_);
}


inline void FirstPartySetsCacheFilterDataView::GetFilterDataView(
    mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>* output) {
  auto pointer = data_->filter.Get();
  *output = mojo::MapDataView<::network::mojom::SchemefulSiteDataView, int64_t>(pointer, message_);
}


inline void GlobalFirstPartySetsDataView::GetPublicSetsVersionDataView(
    ::mojo_base::mojom::VersionDataView* output) {
  auto pointer = data_->public_sets_version.Get();
  *output = ::mojo_base::mojom::VersionDataView(pointer, message_);
}
inline void GlobalFirstPartySetsDataView::GetSetsDataView(
    mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryDataView>* output) {
  auto pointer = data_->sets.Get();
  *output = mojo::MapDataView<::network::mojom::SchemefulSiteDataView, FirstPartySetEntryDataView>(pointer, message_);
}
inline void GlobalFirstPartySetsDataView::GetAliasesDataView(
    mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>* output) {
  auto pointer = data_->aliases.Get();
  *output = mojo::MapDataView<::network::mojom::SchemefulSiteDataView, ::network::mojom::SchemefulSiteDataView>(pointer, message_);
}
inline void GlobalFirstPartySetsDataView::GetManualConfigDataView(
    FirstPartySetsContextConfigDataView* output) {
  auto pointer = data_->manual_config.Get();
  *output = FirstPartySetsContextConfigDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SiteType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SiteType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_FIRST_PARTY_SETS_MOJOM_SHARED_H_