// services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-params-data.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink-import-headers.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy()
    : value(CrossOriginEmbedderPolicyValue::kNone),
      reporting_endpoint(),
      report_only_value(CrossOriginEmbedderPolicyValue::kNone),
      report_only_reporting_endpoint() {}

CrossOriginEmbedderPolicy::CrossOriginEmbedderPolicy(
    CrossOriginEmbedderPolicyValue value_in,
    const ::blink::String& reporting_endpoint_in,
    CrossOriginEmbedderPolicyValue report_only_value_in,
    const ::blink::String& report_only_reporting_endpoint_in)
    : value(std::move(value_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      report_only_value(std::move(report_only_value_in)),
      report_only_reporting_endpoint(std::move(report_only_reporting_endpoint_in)) {}

CrossOriginEmbedderPolicy::~CrossOriginEmbedderPolicy() = default;

void CrossOriginEmbedderPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginEmbedderPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_value"), this->report_only_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CrossOriginEmbedderPolicyValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only_reporting_endpoint"), this->report_only_reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CrossOriginEmbedderPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CrossOriginEmbedderPolicyReporter::IPCStableHashFunction CrossOriginEmbedderPolicyReporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CrossOriginEmbedderPolicyReporter>(message.name())) {
    case messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport: {
      return &CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport_Sym::IPCStableHash;
    }
    case messages::CrossOriginEmbedderPolicyReporter::kClone: {
      return &CrossOriginEmbedderPolicyReporter::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CrossOriginEmbedderPolicyReporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CrossOriginEmbedderPolicyReporter>(message.name())) {
      case messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport:
            return "Receive network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport";
      case messages::CrossOriginEmbedderPolicyReporter::kClone:
            return "Receive network::mojom::CrossOriginEmbedderPolicyReporter::Clone";
    }
  } else {
    switch (static_cast<messages::CrossOriginEmbedderPolicyReporter>(message.name())) {
      case messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport:
            return "Receive reply network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport";
      case messages::CrossOriginEmbedderPolicyReporter::kClone:
            return "Receive reply network::mojom::CrossOriginEmbedderPolicyReporter::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc62f5061;  // IPCStableHash for network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CrossOriginEmbedderPolicyReporter::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdb636aed;  // IPCStableHash for network::mojom::CrossOriginEmbedderPolicyReporter::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CrossOriginEmbedderPolicyReporterProxy::CrossOriginEmbedderPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CrossOriginEmbedderPolicyReporterProxy::QueueCorpViolationReport(
    const ::blink::KURL& in_blocked_url, ::network::mojom::blink::RequestDestination in_destination, bool in_report_only) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CrossOriginEmbedderPolicyReporter::QueueCorpViolationReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blocked_url"), in_blocked_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type ::network::mojom::blink::RequestDestination>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_only"), in_report_only,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->blocked_url)::BaseType> blocked_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_blocked_url,
    blocked_url_fragment);

  params->blocked_url.Set(
      blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->blocked_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null blocked_url in CrossOriginEmbedderPolicyReporter.QueueCorpViolationReport request");

  
  mojo::internal::Serialize<::network::mojom::RequestDestination>(
    in_destination,
    &params->destination);

  params->report_only = in_report_only;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("QueueCorpViolationReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CrossOriginEmbedderPolicyReporterProxy::Clone(
    ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::CrossOriginEmbedderPolicyReporter::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CrossOriginEmbedderPolicyReporter::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in CrossOriginEmbedderPolicyReporter.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CrossOriginEmbedderPolicyReporter::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::Accept(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CrossOriginEmbedderPolicyReporter>(message->header()->name)) {
    case messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport: {
      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CrossOriginEmbedderPolicyReporter.0
      bool success = true;
      ::blink::KURL p_blocked_url{};
      ::network::mojom::blink::RequestDestination p_destination{};
      bool p_report_only{};
      CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBlockedUrl(&p_blocked_url))
        success = false;
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success)
        p_report_only = input_data_view.report_only();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueCorpViolationReport(        
        std::move(p_blocked_url), 
        std::move(p_destination), 
        std::move(p_report_only));
      return true;
    }
    case messages::CrossOriginEmbedderPolicyReporter::kClone: {
      DCHECK(message->is_serialized());
      internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data* params =
          reinterpret_cast<internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CrossOriginEmbedderPolicyReporter.1
      bool success = true;
      ::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> p_receiver{};
      CrossOriginEmbedderPolicyReporter_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CrossOriginEmbedderPolicyReporter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool CrossOriginEmbedderPolicyReporterStubDispatch::AcceptWithResponder(
    CrossOriginEmbedderPolicyReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CrossOriginEmbedderPolicyReporter>(message->header()->name)) {
    case messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport: {
      break;
    }
    case messages::CrossOriginEmbedderPolicyReporter::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCrossOriginEmbedderPolicyReporterValidationInfo[] = {
    {base::to_underlying(messages::CrossOriginEmbedderPolicyReporter::kQueueCorpViolationReport),
     { &internal::CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CrossOriginEmbedderPolicyReporter::kClone),
     { &internal::CrossOriginEmbedderPolicyReporter_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CrossOriginEmbedderPolicyReporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::network::mojom::blink::CrossOriginEmbedderPolicyReporter::Name_,
    kCrossOriginEmbedderPolicyReporterValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CrossOriginEmbedderPolicy::DataView, ::network::mojom::blink::CrossOriginEmbedderPolicyPtr>::Read(
    ::network::mojom::blink::CrossOriginEmbedderPolicy::DataView input,
    ::network::mojom::blink::CrossOriginEmbedderPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::CrossOriginEmbedderPolicyPtr result(::network::mojom::blink::CrossOriginEmbedderPolicy::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadReportOnlyValue(&result->report_only_value))
        success = false;
      if (success && !input.ReadReportOnlyReportingEndpoint(&result->report_only_reporting_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void CrossOriginEmbedderPolicyReporterInterceptorForTesting::QueueCorpViolationReport(const ::blink::KURL& blocked_url, ::network::mojom::blink::RequestDestination destination, bool report_only) {
  GetForwardingInterface()->QueueCorpViolationReport(
    std::move(blocked_url)
    , 
    std::move(destination)
    , 
    std::move(report_only)
    );
}
void CrossOriginEmbedderPolicyReporterInterceptorForTesting::Clone(::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
CrossOriginEmbedderPolicyReporterAsyncWaiter::CrossOriginEmbedderPolicyReporterAsyncWaiter(
    CrossOriginEmbedderPolicyReporter* proxy) : proxy_(proxy) {}

CrossOriginEmbedderPolicyReporterAsyncWaiter::~CrossOriginEmbedderPolicyReporterAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif