// services/network/public/mojom/content_security_policy.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/content_security_policy.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/integrity_algorithm.mojom-shared.h"
#include "services/network/public/mojom/integrity_metadata.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"


namespace network::mojom {
class ContentSecurityPolicyHeaderDataView;

class CSPSourceDataView;

class CSPSourceListDataView;

class CSPTrustedTypesDataView;

class ContentSecurityPolicyDataView;

class CSPViolationDataView;

class AllowCSPFromHeaderValueDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ContentSecurityPolicyHeaderDataView> {
  using Data = ::network::mojom::internal::ContentSecurityPolicyHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPSourceDataView> {
  using Data = ::network::mojom::internal::CSPSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPSourceListDataView> {
  using Data = ::network::mojom::internal::CSPSourceList_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPTrustedTypesDataView> {
  using Data = ::network::mojom::internal::CSPTrustedTypes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ContentSecurityPolicyDataView> {
  using Data = ::network::mojom::internal::ContentSecurityPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CSPViolationDataView> {
  using Data = ::network::mojom::internal::CSPViolation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::AllowCSPFromHeaderValueDataView> {
  using Data = ::network::mojom::internal::AllowCSPFromHeaderValue_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ContentSecurityPolicyType : int32_t {
  
  kReport = 0,
  
  kEnforce = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ContentSecurityPolicyType value);
inline bool IsKnownEnumValue(ContentSecurityPolicyType value) {
  return internal::ContentSecurityPolicyType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentSecurityPolicySource : int32_t {
  
  kHTTP = 0,
  
  kMeta = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ContentSecurityPolicySource value);
inline bool IsKnownEnumValue(ContentSecurityPolicySource value) {
  return internal::ContentSecurityPolicySource_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPDisposition : int32_t {
  
  CHECK = 0,
  
  DO_NOT_CHECK = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CSPDisposition value);
inline bool IsKnownEnumValue(CSPDisposition value) {
  return internal::CSPDisposition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPDirectiveName : int32_t {
  
  Unknown = 0,
  
  BaseURI = 1,
  
  BlockAllMixedContent = 2,
  
  ChildSrc = 3,
  
  ConnectSrc = 4,
  
  DefaultSrc = 5,
  
  FencedFrameSrc = 6,
  
  FontSrc = 7,
  
  FormAction = 8,
  
  FrameAncestors = 9,
  
  FrameSrc = 10,
  
  ImgSrc = 11,
  
  ManifestSrc = 12,
  
  MediaSrc = 13,
  
  ObjectSrc = 14,
  
  ReportTo = 15,
  
  ReportURI = 16,
  
  RequireTrustedTypesFor = 17,
  
  Sandbox = 18,
  
  ScriptSrc = 19,
  
  ScriptSrcV2 = 20,
  
  ScriptSrcAttr = 21,
  
  ScriptSrcElem = 22,
  
  StyleSrc = 23,
  
  StyleSrcAttr = 24,
  
  StyleSrcElem = 25,
  
  TreatAsPublicAddress = 26,
  
  TrustedTypes = 27,
  
  UpgradeInsecureRequests = 28,
  
  WorkerSrc = 29,
  kMinValue = 0,
  kMaxValue = 29,
};

 std::ostream& operator<<(std::ostream& os, CSPDirectiveName value);
inline bool IsKnownEnumValue(CSPDirectiveName value) {
  return internal::CSPDirectiveName_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CSPRequireTrustedTypesFor : int32_t {
  
  None = 0,
  
  Script = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CSPRequireTrustedTypesFor value);
inline bool IsKnownEnumValue(CSPRequireTrustedTypesFor value) {
  return internal::CSPRequireTrustedTypesFor_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ContentSecurityPolicyHeaderDataView {
 public:
  ContentSecurityPolicyHeaderDataView() = default;

  ContentSecurityPolicyHeaderDataView(
      internal::ContentSecurityPolicyHeader_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHeaderValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaderValue(UserType* output) {
    
    auto* pointer = data_->header_value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyType>(
        data_value, output);
  }
  ContentSecurityPolicyType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContentSecurityPolicyType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicySource>(
        data_value, output);
  }
  ContentSecurityPolicySource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContentSecurityPolicySource>(data_->source));
  }
 private:
  internal::ContentSecurityPolicyHeader_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSPSourceDataView {
 public:
  CSPSourceDataView() = default;

  CSPSourceDataView(
      internal::CSPSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t port() const {
    return data_->port;
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_host_wildcard() const {
    return data_->is_host_wildcard;
  }
  bool is_port_wildcard() const {
    return data_->is_port_wildcard;
  }
 private:
  internal::CSPSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSPSourceListDataView {
 public:
  CSPSourceListDataView() = default;

  CSPSourceListDataView(
      internal::CSPSourceList_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<CSPSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CSPSourceDataView>>(
        pointer, output, message_);
  }
  inline void GetNoncesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonces(UserType* output) {
    
    auto* pointer = data_->nonces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetHashesDataView(
      mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHashes(UserType* output) {
    
    auto* pointer = data_->hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
        pointer, output, message_);
  }
  inline void GetUrlHashesDataView(
      mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlHashes(UserType* output) {
    
    auto* pointer = data_->url_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
        pointer, output, message_);
  }
  inline void GetEvalHashesDataView(
      mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvalHashes(UserType* output) {
    
    auto* pointer = data_->eval_hashes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
        pointer, output, message_);
  }
  bool allow_self() const {
    return data_->allow_self;
  }
  bool allow_star() const {
    return data_->allow_star;
  }
  bool allow_inline() const {
    return data_->allow_inline;
  }
  bool allow_inline_speculation_rules() const {
    return data_->allow_inline_speculation_rules;
  }
  bool allow_eval() const {
    return data_->allow_eval;
  }
  bool allow_wasm_eval() const {
    return data_->allow_wasm_eval;
  }
  bool allow_wasm_unsafe_eval() const {
    return data_->allow_wasm_unsafe_eval;
  }
  bool allow_dynamic() const {
    return data_->allow_dynamic;
  }
  bool allow_dynamic_url() const {
    return data_->allow_dynamic_url;
  }
  bool allow_unsafe_hashes() const {
    return data_->allow_unsafe_hashes;
  }
  bool report_sample() const {
    return data_->report_sample;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReportHashAlgorithm(UserType* output) const {
    if (!data_->report_hash_algorithm_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::network::mojom::IntegrityAlgorithm>(
        data_->report_hash_algorithm_$value, &output->emplace());
  }
  std::optional<::network::mojom::IntegrityAlgorithm> report_hash_algorithm() const {
    if (!data_->report_hash_algorithm_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IntegrityAlgorithm>(data_->report_hash_algorithm_$value));
  }
 private:
  internal::CSPSourceList_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSPTrustedTypesDataView {
 public:
  CSPTrustedTypesDataView() = default;

  CSPTrustedTypesDataView(
      internal::CSPTrustedTypes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadList(UserType* output) {
    
    auto* pointer = data_->list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool allow_any() const {
    return data_->allow_any;
  }
  bool allow_duplicates() const {
    return data_->allow_duplicates;
  }
 private:
  internal::CSPTrustedTypes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentSecurityPolicyDataView {
 public:
  ContentSecurityPolicyDataView() = default;

  ContentSecurityPolicyDataView(
      internal::ContentSecurityPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSelfOriginDataView(
      CSPSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelfOrigin(UserType* output) {
    
    auto* pointer = data_->self_origin.Get();
    return mojo::internal::Deserialize<::network::mojom::CSPSourceDataView>(
        pointer, output, message_);
  }
  inline void GetRawDirectivesDataView(
      mojo::MapDataView<CSPDirectiveName, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawDirectives(UserType* output) {
    
    auto* pointer = data_->raw_directives.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetDirectivesDataView(
      mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectives(UserType* output) {
    
    auto* pointer = data_->directives.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, ::network::mojom::CSPSourceListDataView>>(
        pointer, output, message_);
  }
  bool upgrade_insecure_requests() const {
    return data_->upgrade_insecure_requests;
  }
  bool treat_as_public_address() const {
    return data_->treat_as_public_address;
  }
  bool block_all_mixed_content() const {
    return data_->block_all_mixed_content;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSandbox(UserType* output) const {
    auto data_value = data_->sandbox;
    return mojo::internal::Deserialize<::network::mojom::WebSandboxFlags>(
        data_value, output);
  }
  ::network::mojom::WebSandboxFlags sandbox() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::WebSandboxFlags>(data_->sandbox));
  }
  inline void GetHeaderDataView(
      ContentSecurityPolicyHeaderDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyHeaderDataView>(
        pointer, output, message_);
  }
  bool use_reporting_api() const {
    return data_->use_reporting_api;
  }
  inline void GetReportEndpointsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportEndpoints(UserType* output) {
    
    auto* pointer = data_->report_endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequireTrustedTypesFor(UserType* output) const {
    auto data_value = data_->require_trusted_types_for;
    return mojo::internal::Deserialize<::network::mojom::CSPRequireTrustedTypesFor>(
        data_value, output);
  }
  CSPRequireTrustedTypesFor require_trusted_types_for() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CSPRequireTrustedTypesFor>(data_->require_trusted_types_for));
  }
  inline void GetTrustedTypesDataView(
      CSPTrustedTypesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CSPTrustedTypesDataView, UserType>(),
    "Attempting to read the optional `trusted_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedTypes` instead "
    "of `ReadTrustedTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_types.Get();
    return mojo::internal::Deserialize<::network::mojom::CSPTrustedTypesDataView>(
        pointer, output, message_);
  }
  inline void GetParsingErrorsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParsingErrors(UserType* output) {
    
    auto* pointer = data_->parsing_errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ContentSecurityPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSPViolationDataView {
 public:
  CSPViolationDataView() = default;

  CSPViolationDataView(
      internal::CSPViolation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirective(UserType* output) {
    
    auto* pointer = data_->directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEffectiveDirectiveDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveDirective(UserType* output) {
    
    auto* pointer = data_->effective_directive.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetConsoleMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConsoleMessage(UserType* output) {
    
    auto* pointer = data_->console_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBlockedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlockedUrl(UserType* output) {
    
    auto* pointer = data_->blocked_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReportEndpointsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportEndpoints(UserType* output) {
    
    auto* pointer = data_->report_endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool use_reporting_api() const {
    return data_->use_reporting_api;
  }
  inline void GetHeaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::ContentSecurityPolicyType>(
        data_value, output);
  }
  ContentSecurityPolicyType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ContentSecurityPolicyType>(data_->type));
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
 private:
  internal::CSPViolation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AllowCSPFromHeaderValueDataView {
 public:
  using Tag = internal::AllowCSPFromHeaderValue_Data::AllowCSPFromHeaderValue_Tag;

  AllowCSPFromHeaderValueDataView() = default;

  AllowCSPFromHeaderValueDataView(
      internal::AllowCSPFromHeaderValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_allow_star() const { return data_->tag == Tag::kAllowStar; }
  bool allow_star() const {
    CHECK(is_allow_star());
    return data_->data.f_allow_star;
  }
  bool is_origin() const { return data_->tag == Tag::kOrigin; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) const {
    
    CHECK(is_origin());
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        data_->data.f_origin.Get(), output, message_);
  }
  bool is_error_message() const { return data_->tag == Tag::kErrorMessage; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) const {
    
    CHECK(is_error_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error_message.Get(), output, message_);
  }

 private:
  internal::AllowCSPFromHeaderValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_DATA_VIEW_H_