// services/device/public/mojom/wake_lock_context.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/wake_lock_context.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/wake_lock_context.mojom-params-data.h"
#include "services/device/public/mojom/wake_lock_context.mojom-shared-message-ids.h"

#include "services/device/public/mojom/wake_lock_context.mojom-blink-import-headers.h"
#include "services/device/public/mojom/wake_lock_context.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

WakeLockContext::IPCStableHashFunction WakeLockContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WakeLockContext>(message.name())) {
    case messages::WakeLockContext::kGetWakeLock: {
      return &WakeLockContext::GetWakeLock_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WakeLockContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WakeLockContext>(message.name())) {
      case messages::WakeLockContext::kGetWakeLock:
            return "Receive device::mojom::WakeLockContext::GetWakeLock";
    }
  } else {
    switch (static_cast<messages::WakeLockContext>(message.name())) {
      case messages::WakeLockContext::kGetWakeLock:
            return "Receive reply device::mojom::WakeLockContext::GetWakeLock";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WakeLockContext::GetWakeLock_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42165fb8;  // IPCStableHash for device::mojom::WakeLockContext::GetWakeLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WakeLockContextProxy::WakeLockContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockContextProxy::GetWakeLock(
    ::device::mojom::blink::WakeLockType in_type, ::device::mojom::blink::WakeLockReason in_reason, const ::blink::String& in_description, ::mojo::PendingReceiver<::device::mojom::blink::WakeLock> in_wake_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockContext::GetWakeLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::blink::WakeLockType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::device::mojom::blink::WakeLockReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wake_lock"), in_wake_lock,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::WakeLock>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockContext::kGetWakeLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockContext_GetWakeLock_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
    in_type,
    &params->type);

  
  mojo::internal::Serialize<::device::mojom::WakeLockReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_description,
    description_fragment);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in WakeLockContext.GetWakeLock request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockInterfaceBase>>(
    in_wake_lock,
    &params->wake_lock,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->wake_lock)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid wake_lock in WakeLockContext.GetWakeLock request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockContext::Name_);
  message.set_method_name("GetWakeLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WakeLockContextStubDispatch::Accept(
    WakeLockContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WakeLockContext>(message->header()->name)) {
    case messages::WakeLockContext::kGetWakeLock: {
      DCHECK(message->is_serialized());
      internal::WakeLockContext_GetWakeLock_Params_Data* params =
          reinterpret_cast<internal::WakeLockContext_GetWakeLock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WakeLockContext.0
      bool success = true;
      ::device::mojom::blink::WakeLockType p_type{};
      ::device::mojom::blink::WakeLockReason p_reason{};
      ::blink::String p_description{};
      ::mojo::PendingReceiver<::device::mojom::blink::WakeLock> p_wake_lock{};
      WakeLockContext_GetWakeLock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success) {
        p_wake_lock =
            input_data_view.TakeWakeLock<decltype(p_wake_lock)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLock(        
        std::move(p_type), 
        std::move(p_reason), 
        std::move(p_description), 
        std::move(p_wake_lock));
      return true;
    }
  }
  return false;
}

// static
bool WakeLockContextStubDispatch::AcceptWithResponder(
    WakeLockContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WakeLockContext>(message->header()->name)) {
    case messages::WakeLockContext::kGetWakeLock: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWakeLockContextValidationInfo[] = {
    {base::to_underlying(messages::WakeLockContext::kGetWakeLock),
     { &internal::WakeLockContext_GetWakeLock_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WakeLockContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::blink::WakeLockContext::Name_,
    kWakeLockContextValidationInfo);
}



}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void WakeLockContextInterceptorForTesting::GetWakeLock(::device::mojom::blink::WakeLockType type, ::device::mojom::blink::WakeLockReason reason, const ::blink::String& description, ::mojo::PendingReceiver<::device::mojom::blink::WakeLock> wake_lock) {
  GetForwardingInterface()->GetWakeLock(
    std::move(type)
    , 
    std::move(reason)
    , 
    std::move(description)
    , 
    std::move(wake_lock)
    );
}
WakeLockContextAsyncWaiter::WakeLockContextAsyncWaiter(
    WakeLockContext* proxy) : proxy_(proxy) {}

WakeLockContextAsyncWaiter::~WakeLockContextAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif