// services/device/public/mojom/pressure_manager.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/device/public/mojom/pressure_manager.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/pressure_manager.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* PressureManagerAddClientResultToStringHelper(PressureManagerAddClientResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PressureManagerAddClientResult::kNotSupported:
      return "kNotSupported";
    case PressureManagerAddClientResult::kOk:
      return "kOk";
    default:
      return nullptr;
  }
}

std::string PressureManagerAddClientResultToString(PressureManagerAddClientResult value) {
  const char *str = PressureManagerAddClientResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PressureManagerAddClientResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PressureManagerAddClientResult value) {
  return os << PressureManagerAddClientResultToString(value);
}

namespace internal {


// static
bool VirtualPressureSourceMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VirtualPressureSourceMetadata_Data* object =
      static_cast<const VirtualPressureSourceMetadata_Data*>(data);

  return true;
}

VirtualPressureSourceMetadata_Data::VirtualPressureSourceMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_AddVirtualPressureSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_AddVirtualPressureSource_Params_Data* object =
      static_cast<const PressureManager_AddVirtualPressureSource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;


  if (!::device::mojom::internal::PressureSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

PressureManager_AddVirtualPressureSource_Params_Data::PressureManager_AddVirtualPressureSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_AddVirtualPressureSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_AddVirtualPressureSource_ResponseParams_Data* object =
      static_cast<const PressureManager_AddVirtualPressureSource_ResponseParams_Data*>(data);

  return true;
}

PressureManager_AddVirtualPressureSource_ResponseParams_Data::PressureManager_AddVirtualPressureSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_RemoveVirtualPressureSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_RemoveVirtualPressureSource_Params_Data* object =
      static_cast<const PressureManager_RemoveVirtualPressureSource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;


  if (!::device::mojom::internal::PressureSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

PressureManager_RemoveVirtualPressureSource_Params_Data::PressureManager_RemoveVirtualPressureSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_RemoveVirtualPressureSource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_RemoveVirtualPressureSource_ResponseParams_Data* object =
      static_cast<const PressureManager_RemoveVirtualPressureSource_ResponseParams_Data*>(data);

  return true;
}

PressureManager_RemoveVirtualPressureSource_ResponseParams_Data::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_UpdateVirtualPressureSourceData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_UpdateVirtualPressureSourceData_Params_Data* object =
      static_cast<const PressureManager_UpdateVirtualPressureSourceData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;


  if (!::device::mojom::internal::PressureSource_Data
        ::Validate(object->source, validation_context))
    return false;


  if (!::device::mojom::internal::PressureState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

PressureManager_UpdateVirtualPressureSourceData_Params_Data::PressureManager_UpdateVirtualPressureSourceData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data* object =
      static_cast<const PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data*>(data);

  return true;
}

PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data::PressureManager_UpdateVirtualPressureSourceData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_AddClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_AddClient_Params_Data* object =
      static_cast<const PressureManager_AddClient_Params_Data*>(data);


  if (!::device::mojom::internal::PressureSource_Data
        ::Validate(object->source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PressureManager_AddClient_Params_Data::PressureManager_AddClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureManager_AddClient_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureManager_AddClient_ResponseParams_Data* object =
      static_cast<const PressureManager_AddClient_ResponseParams_Data*>(data);


  if (!::device::mojom::internal::PressureManagerAddClientResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

PressureManager_AddClient_ResponseParams_Data::PressureManager_AddClient_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PressureClient_OnPressureUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PressureClient_OnPressureUpdated_Params_Data* object =
      static_cast<const PressureClient_OnPressureUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update, validation_context))
    return false;

  return true;
}

PressureClient_OnPressureUpdated_Params_Data::PressureClient_OnPressureUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::PressureManagerAddClientResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::PressureManagerAddClientResult value) {
  return std::move(context).WriteString(::device::mojom::PressureManagerAddClientResultToString(value));
}

} // namespace perfetto