// services/device/public/mojom/geolocation_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geolocation_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation_internals.mojom-params-data.h"
#include "services/device/public/mojom/geolocation_internals.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geolocation_internals.mojom-import-headers.h"
#include "services/device/public/mojom/geolocation_internals.mojom-test-utils.h"


namespace device::mojom {
AccessPointData::AccessPointData()
    : mac_address(),
      radio_signal_strength(kInvalidRadioSignalStrength),
      channel(kInvalidChannel),
      signal_to_noise(kInvalidSignalToNoise),
      timestamp() {}

AccessPointData::AccessPointData(
    const std::string& mac_address_in,
    int32_t radio_signal_strength_in,
    int32_t channel_in,
    int32_t signal_to_noise_in,
    std::optional<::base::Time> timestamp_in)
    : mac_address(std::move(mac_address_in)),
      radio_signal_strength(std::move(radio_signal_strength_in)),
      channel(std::move(channel_in)),
      signal_to_noise(std::move(signal_to_noise_in)),
      timestamp(std::move(timestamp_in)) {}

AccessPointData::~AccessPointData() = default;

void AccessPointData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mac_address"), this->mac_address,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "radio_signal_strength"), this->radio_signal_strength,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "channel"), this->channel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signal_to_noise"), this->signal_to_noise,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AccessPointData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkLocationDiagnostics::NetworkLocationDiagnostics()
    : access_point_data(),
      wifi_timestamp() {}

NetworkLocationDiagnostics::NetworkLocationDiagnostics(
    std::vector<AccessPointDataPtr> access_point_data_in,
    std::optional<::base::Time> wifi_timestamp_in)
    : access_point_data(std::move(access_point_data_in)),
      wifi_timestamp(std::move(wifi_timestamp_in)) {}

NetworkLocationDiagnostics::~NetworkLocationDiagnostics() = default;

void NetworkLocationDiagnostics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_point_data"), this->access_point_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AccessPointDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wifi_timestamp"), this->wifi_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkLocationDiagnostics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PositionCacheDiagnostics::PositionCacheDiagnostics()
    : cache_size(0U),
      last_hit(),
      last_miss(),
      hit_rate(),
      last_network_result() {}

PositionCacheDiagnostics::PositionCacheDiagnostics(
    uint32_t cache_size_in,
    std::optional<::base::Time> last_hit_in,
    std::optional<::base::Time> last_miss_in,
    std::optional<double> hit_rate_in,
    ::device::mojom::GeopositionResultPtr last_network_result_in)
    : cache_size(std::move(cache_size_in)),
      last_hit(std::move(last_hit_in)),
      last_miss(std::move(last_miss_in)),
      hit_rate(std::move(hit_rate_in)),
      last_network_result(std::move(last_network_result_in)) {}

PositionCacheDiagnostics::~PositionCacheDiagnostics() = default;

void PositionCacheDiagnostics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cache_size"), this->cache_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_hit"), this->last_hit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_miss"), this->last_miss,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_rate"), this->hit_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_network_result"), this->last_network_result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::device::mojom::GeopositionResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PositionCacheDiagnostics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WifiPollingPolicyDiagnostics::WifiPollingPolicyDiagnostics()
    : interval_start(),
      interval_duration(),
      polling_interval(),
      default_interval(),
      no_change_interval(),
      two_no_change_interval(),
      no_wifi_interval() {}

WifiPollingPolicyDiagnostics::WifiPollingPolicyDiagnostics(
    std::optional<::base::Time> interval_start_in,
    ::base::TimeDelta interval_duration_in,
    ::base::TimeDelta polling_interval_in,
    ::base::TimeDelta default_interval_in,
    ::base::TimeDelta no_change_interval_in,
    ::base::TimeDelta two_no_change_interval_in,
    ::base::TimeDelta no_wifi_interval_in)
    : interval_start(std::move(interval_start_in)),
      interval_duration(std::move(interval_duration_in)),
      polling_interval(std::move(polling_interval_in)),
      default_interval(std::move(default_interval_in)),
      no_change_interval(std::move(no_change_interval_in)),
      two_no_change_interval(std::move(two_no_change_interval_in)),
      no_wifi_interval(std::move(no_wifi_interval_in)) {}

WifiPollingPolicyDiagnostics::~WifiPollingPolicyDiagnostics() = default;

void WifiPollingPolicyDiagnostics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interval_start"), this->interval_start,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interval_duration"), this->interval_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "polling_interval"), this->polling_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_interval"), this->default_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_change_interval"), this->no_change_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "two_no_change_interval"), this->two_no_change_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_wifi_interval"), this->no_wifi_interval,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WifiPollingPolicyDiagnostics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GeolocationDiagnostics::GeolocationDiagnostics()
    : provider_state(),
      network_location_diagnostics(),
      position_cache_diagnostics(),
      wifi_polling_policy_diagnostics(),
      location_provider_manager_mode() {}

GeolocationDiagnostics::GeolocationDiagnostics(
    GeolocationDiagnostics::ProviderState provider_state_in,
    NetworkLocationDiagnosticsPtr network_location_diagnostics_in,
    PositionCacheDiagnosticsPtr position_cache_diagnostics_in,
    WifiPollingPolicyDiagnosticsPtr wifi_polling_policy_diagnostics_in,
    std::optional<LocationProviderManagerMode> location_provider_manager_mode_in)
    : provider_state(std::move(provider_state_in)),
      network_location_diagnostics(std::move(network_location_diagnostics_in)),
      position_cache_diagnostics(std::move(position_cache_diagnostics_in)),
      wifi_polling_policy_diagnostics(std::move(wifi_polling_policy_diagnostics_in)),
      location_provider_manager_mode(std::move(location_provider_manager_mode_in)) {}

GeolocationDiagnostics::~GeolocationDiagnostics() = default;

void GeolocationDiagnostics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_state"), this->provider_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GeolocationDiagnostics::ProviderState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_location_diagnostics"), this->network_location_diagnostics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NetworkLocationDiagnosticsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "position_cache_diagnostics"), this->position_cache_diagnostics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PositionCacheDiagnosticsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wifi_polling_policy_diagnostics"), this->wifi_polling_policy_diagnostics,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WifiPollingPolicyDiagnosticsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location_provider_manager_mode"), this->location_provider_manager_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<LocationProviderManagerMode>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GeolocationDiagnostics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkLocationResponse::NetworkLocationResponse()
    : latitude(),
      longitude(),
      accuracy() {}

NetworkLocationResponse::NetworkLocationResponse(
    double latitude_in,
    double longitude_in,
    std::optional<double> accuracy_in)
    : latitude(std::move(latitude_in)),
      longitude(std::move(longitude_in)),
      accuracy(std::move(accuracy_in)) {}

NetworkLocationResponse::~NetworkLocationResponse() = default;

void NetworkLocationResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "latitude"), this->latitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "longitude"), this->longitude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accuracy"), this->accuracy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkLocationResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

GeolocationInternalsObserver::IPCStableHashFunction GeolocationInternalsObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GeolocationInternalsObserver>(message.name())) {
    case messages::GeolocationInternalsObserver::kOnDiagnosticsChanged: {
      return &GeolocationInternalsObserver::OnDiagnosticsChanged_Sym::IPCStableHash;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationRequested: {
      return &GeolocationInternalsObserver::OnNetworkLocationRequested_Sym::IPCStableHash;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationReceived: {
      return &GeolocationInternalsObserver::OnNetworkLocationReceived_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GeolocationInternalsObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GeolocationInternalsObserver>(message.name())) {
      case messages::GeolocationInternalsObserver::kOnDiagnosticsChanged:
            return "Receive device::mojom::GeolocationInternalsObserver::OnDiagnosticsChanged";
      case messages::GeolocationInternalsObserver::kOnNetworkLocationRequested:
            return "Receive device::mojom::GeolocationInternalsObserver::OnNetworkLocationRequested";
      case messages::GeolocationInternalsObserver::kOnNetworkLocationReceived:
            return "Receive device::mojom::GeolocationInternalsObserver::OnNetworkLocationReceived";
    }
  } else {
    switch (static_cast<messages::GeolocationInternalsObserver>(message.name())) {
      case messages::GeolocationInternalsObserver::kOnDiagnosticsChanged:
            return "Receive reply device::mojom::GeolocationInternalsObserver::OnDiagnosticsChanged";
      case messages::GeolocationInternalsObserver::kOnNetworkLocationRequested:
            return "Receive reply device::mojom::GeolocationInternalsObserver::OnNetworkLocationRequested";
      case messages::GeolocationInternalsObserver::kOnNetworkLocationReceived:
            return "Receive reply device::mojom::GeolocationInternalsObserver::OnNetworkLocationReceived";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GeolocationInternalsObserver::OnDiagnosticsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b893ac8;  // IPCStableHash for device::mojom::GeolocationInternalsObserver::OnDiagnosticsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GeolocationInternalsObserver::OnNetworkLocationRequested_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4486b7b7;  // IPCStableHash for device::mojom::GeolocationInternalsObserver::OnNetworkLocationRequested
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GeolocationInternalsObserver::OnNetworkLocationReceived_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0368d3a6;  // IPCStableHash for device::mojom::GeolocationInternalsObserver::OnNetworkLocationReceived
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GeolocationInternalsObserverProxy::GeolocationInternalsObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationInternalsObserverProxy::OnDiagnosticsChanged(
    GeolocationDiagnosticsPtr in_diagnostics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationInternalsObserver::OnDiagnosticsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("diagnostics"), in_diagnostics,
                        "<value of type GeolocationDiagnosticsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationInternalsObserver::kOnDiagnosticsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->diagnostics)::BaseType> diagnostics_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::GeolocationDiagnosticsDataView>(
    in_diagnostics,
    diagnostics_fragment);

  params->diagnostics.Set(
      diagnostics_fragment.is_null() ? nullptr : diagnostics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->diagnostics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null diagnostics in GeolocationInternalsObserver.OnDiagnosticsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationInternalsObserver::Name_);
  message.set_method_name("OnDiagnosticsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationInternalsObserverProxy::OnNetworkLocationRequested(
    std::vector<AccessPointDataPtr> in_access_point_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationInternalsObserver::OnNetworkLocationRequested", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_point_data"), in_access_point_data,
                        "<value of type std::vector<AccessPointDataPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationInternalsObserver::kOnNetworkLocationRequested), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access_point_data)::BaseType>
      access_point_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& access_point_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::AccessPointDataDataView>>(
    in_access_point_data,
    access_point_data_fragment,
    &access_point_data_validate_params);

  params->access_point_data.Set(
      access_point_data_fragment.is_null() ? nullptr : access_point_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_point_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_point_data in GeolocationInternalsObserver.OnNetworkLocationRequested request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationInternalsObserver::Name_);
  message.set_method_name("OnNetworkLocationRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationInternalsObserverProxy::OnNetworkLocationReceived(
    NetworkLocationResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationInternalsObserver::OnNetworkLocationReceived", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type NetworkLocationResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationInternalsObserver::kOnNetworkLocationReceived), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NetworkLocationResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationInternalsObserver::Name_);
  message.set_method_name("OnNetworkLocationReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GeolocationInternalsObserverStubDispatch::Accept(
    GeolocationInternalsObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GeolocationInternalsObserver>(message->header()->name)) {
    case messages::GeolocationInternalsObserver::kOnDiagnosticsChanged: {
      DCHECK(message->is_serialized());
      internal::GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data* params =
          reinterpret_cast<internal::GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationInternalsObserver.0
      bool success = true;
      GeolocationDiagnosticsPtr p_diagnostics{};
      GeolocationInternalsObserver_OnDiagnosticsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDiagnostics(&p_diagnostics))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationInternalsObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDiagnosticsChanged(        
        std::move(p_diagnostics));
      return true;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationRequested: {
      DCHECK(message->is_serialized());
      internal::GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data* params =
          reinterpret_cast<internal::GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationInternalsObserver.1
      bool success = true;
      std::vector<AccessPointDataPtr> p_access_point_data{};
      GeolocationInternalsObserver_OnNetworkLocationRequested_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessPointData(&p_access_point_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationInternalsObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkLocationRequested(        
        std::move(p_access_point_data));
      return true;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationReceived: {
      DCHECK(message->is_serialized());
      internal::GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data* params =
          reinterpret_cast<internal::GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationInternalsObserver.2
      bool success = true;
      NetworkLocationResponsePtr p_response{};
      GeolocationInternalsObserver_OnNetworkLocationReceived_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationInternalsObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkLocationReceived(        
        std::move(p_response));
      return true;
    }
  }
  return false;
}

// static
bool GeolocationInternalsObserverStubDispatch::AcceptWithResponder(
    GeolocationInternalsObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GeolocationInternalsObserver>(message->header()->name)) {
    case messages::GeolocationInternalsObserver::kOnDiagnosticsChanged: {
      break;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationRequested: {
      break;
    }
    case messages::GeolocationInternalsObserver::kOnNetworkLocationReceived: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGeolocationInternalsObserverValidationInfo[] = {
    {base::to_underlying(messages::GeolocationInternalsObserver::kOnDiagnosticsChanged),
     { &internal::GeolocationInternalsObserver_OnDiagnosticsChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GeolocationInternalsObserver::kOnNetworkLocationRequested),
     { &internal::GeolocationInternalsObserver_OnNetworkLocationRequested_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::GeolocationInternalsObserver::kOnNetworkLocationReceived),
     { &internal::GeolocationInternalsObserver_OnNetworkLocationReceived_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GeolocationInternalsObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::GeolocationInternalsObserver::Name_,
    kGeolocationInternalsObserverValidationInfo);
}

// The declaration includes the definition on other builds.

GeolocationInternals::IPCStableHashFunction GeolocationInternals::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GeolocationInternals>(message.name())) {
    case messages::GeolocationInternals::kAddInternalsObserver: {
      return &GeolocationInternals::AddInternalsObserver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GeolocationInternals::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GeolocationInternals>(message.name())) {
      case messages::GeolocationInternals::kAddInternalsObserver:
            return "Receive device::mojom::GeolocationInternals::AddInternalsObserver";
    }
  } else {
    switch (static_cast<messages::GeolocationInternals>(message.name())) {
      case messages::GeolocationInternals::kAddInternalsObserver:
            return "Receive reply device::mojom::GeolocationInternals::AddInternalsObserver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GeolocationInternals::AddInternalsObserver_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xad184f4b;  // IPCStableHash for device::mojom::GeolocationInternals::AddInternalsObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GeolocationInternals_AddInternalsObserver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GeolocationInternals_AddInternalsObserver_ForwardToCallback(
      GeolocationInternals::AddInternalsObserverCallback callback
      ) : callback_(std::move(callback)) {
  }

  GeolocationInternals_AddInternalsObserver_ForwardToCallback(const GeolocationInternals_AddInternalsObserver_ForwardToCallback&) = delete;
  GeolocationInternals_AddInternalsObserver_ForwardToCallback& operator=(const GeolocationInternals_AddInternalsObserver_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GeolocationInternals::AddInternalsObserverCallback callback_;
};

GeolocationInternalsProxy::GeolocationInternalsProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationInternalsProxy::AddInternalsObserver(
    ::mojo::PendingRemote<GeolocationInternalsObserver> in_observer, AddInternalsObserverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationInternals::AddInternalsObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<GeolocationInternalsObserver>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationInternals::kAddInternalsObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationInternals_AddInternalsObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::GeolocationInternalsObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in GeolocationInternals.AddInternalsObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationInternals::Name_);
  message.set_method_name("AddInternalsObserver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GeolocationInternals_AddInternalsObserver_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GeolocationInternals_AddInternalsObserver_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GeolocationInternals::AddInternalsObserverCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GeolocationInternals_AddInternalsObserver_ProxyToResponder> proxy(
        new GeolocationInternals_AddInternalsObserver_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GeolocationInternals_AddInternalsObserver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GeolocationInternals_AddInternalsObserver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GeolocationInternals_AddInternalsObserver_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GeolocationInternals::AddInternalsObserverCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      GeolocationDiagnosticsPtr in_diagnostics);
};

bool GeolocationInternals_AddInternalsObserver_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GeolocationInternals_AddInternalsObserver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GeolocationInternals_AddInternalsObserver_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GeolocationInternals.0
  bool success = true;
  GeolocationDiagnosticsPtr p_diagnostics{};
  GeolocationInternals_AddInternalsObserver_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDiagnostics(&p_diagnostics))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GeolocationInternals::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_diagnostics));
  }
  return true;
}

void GeolocationInternals_AddInternalsObserver_ProxyToResponder::Run(
    GeolocationDiagnosticsPtr in_diagnostics) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::GeolocationInternals::AddInternalsObserver", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("diagnostics"), in_diagnostics,
                        "<value of type GeolocationDiagnosticsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationInternals::kAddInternalsObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationInternals_AddInternalsObserver_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->diagnostics)::BaseType> diagnostics_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::GeolocationDiagnosticsDataView>(
    in_diagnostics,
    diagnostics_fragment);

  params->diagnostics.Set(
      diagnostics_fragment.is_null() ? nullptr : diagnostics_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationInternals::Name_);
  message.set_method_name("AddInternalsObserver");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GeolocationInternalsStubDispatch::Accept(
    GeolocationInternals* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GeolocationInternals>(message->header()->name)) {
    case messages::GeolocationInternals::kAddInternalsObserver: {
      break;
    }
  }
  return false;
}

// static
bool GeolocationInternalsStubDispatch::AcceptWithResponder(
    GeolocationInternals* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GeolocationInternals>(message->header()->name)) {
    case messages::GeolocationInternals::kAddInternalsObserver: {
      internal::GeolocationInternals_AddInternalsObserver_Params_Data* params =
          reinterpret_cast<
              internal::GeolocationInternals_AddInternalsObserver_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GeolocationInternals.0
      bool success = true;
      ::mojo::PendingRemote<GeolocationInternalsObserver> p_observer{};
      GeolocationInternals_AddInternalsObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationInternals::Name_, 0, false);
        return false;
      }
      auto callback =
          GeolocationInternals_AddInternalsObserver_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddInternalsObserver(        
        std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGeolocationInternalsValidationInfo[] = {
    {base::to_underlying(messages::GeolocationInternals::kAddInternalsObserver),
     { &internal::GeolocationInternals_AddInternalsObserver_Params_Data::Validate,
      &internal::GeolocationInternals_AddInternalsObserver_ResponseParams_Data::Validate}},
};

bool GeolocationInternalsRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::GeolocationInternals::Name_,
    kGeolocationInternalsValidationInfo);
}

bool GeolocationInternalsResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::device::mojom::GeolocationInternals::Name_,
    kGeolocationInternalsValidationInfo);

}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::AccessPointData::DataView, ::device::mojom::AccessPointDataPtr>::Read(
    ::device::mojom::AccessPointData::DataView input,
    ::device::mojom::AccessPointDataPtr* output) {
  bool success = true;
  ::device::mojom::AccessPointDataPtr result(::device::mojom::AccessPointData::New());
  
      if (success && !input.ReadMacAddress(&result->mac_address))
        success = false;
      if (success)
        result->radio_signal_strength = input.radio_signal_strength();
      if (success)
        result->channel = input.channel();
      if (success)
        result->signal_to_noise = input.signal_to_noise();
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NetworkLocationDiagnostics::DataView, ::device::mojom::NetworkLocationDiagnosticsPtr>::Read(
    ::device::mojom::NetworkLocationDiagnostics::DataView input,
    ::device::mojom::NetworkLocationDiagnosticsPtr* output) {
  bool success = true;
  ::device::mojom::NetworkLocationDiagnosticsPtr result(::device::mojom::NetworkLocationDiagnostics::New());
  
      if (success && !input.ReadAccessPointData(&result->access_point_data))
        success = false;
      if (success && !input.ReadWifiTimestamp(&result->wifi_timestamp))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::PositionCacheDiagnostics::DataView, ::device::mojom::PositionCacheDiagnosticsPtr>::Read(
    ::device::mojom::PositionCacheDiagnostics::DataView input,
    ::device::mojom::PositionCacheDiagnosticsPtr* output) {
  bool success = true;
  ::device::mojom::PositionCacheDiagnosticsPtr result(::device::mojom::PositionCacheDiagnostics::New());
  
      if (success)
        result->cache_size = input.cache_size();
      if (success && !input.ReadLastHit(&result->last_hit))
        success = false;
      if (success && !input.ReadLastMiss(&result->last_miss))
        success = false;
      if (success) {
        result->hit_rate = input.hit_rate();
      }
      if (success && !input.ReadLastNetworkResult(&result->last_network_result))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::WifiPollingPolicyDiagnostics::DataView, ::device::mojom::WifiPollingPolicyDiagnosticsPtr>::Read(
    ::device::mojom::WifiPollingPolicyDiagnostics::DataView input,
    ::device::mojom::WifiPollingPolicyDiagnosticsPtr* output) {
  bool success = true;
  ::device::mojom::WifiPollingPolicyDiagnosticsPtr result(::device::mojom::WifiPollingPolicyDiagnostics::New());
  
      if (success && !input.ReadIntervalStart(&result->interval_start))
        success = false;
      if (success && !input.ReadIntervalDuration(&result->interval_duration))
        success = false;
      if (success && !input.ReadPollingInterval(&result->polling_interval))
        success = false;
      if (success && !input.ReadDefaultInterval(&result->default_interval))
        success = false;
      if (success && !input.ReadNoChangeInterval(&result->no_change_interval))
        success = false;
      if (success && !input.ReadTwoNoChangeInterval(&result->two_no_change_interval))
        success = false;
      if (success && !input.ReadNoWifiInterval(&result->no_wifi_interval))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::GeolocationDiagnostics::DataView, ::device::mojom::GeolocationDiagnosticsPtr>::Read(
    ::device::mojom::GeolocationDiagnostics::DataView input,
    ::device::mojom::GeolocationDiagnosticsPtr* output) {
  bool success = true;
  ::device::mojom::GeolocationDiagnosticsPtr result(::device::mojom::GeolocationDiagnostics::New());
  
      if (success && !input.ReadProviderState(&result->provider_state))
        success = false;
      if (success && !input.ReadNetworkLocationDiagnostics(&result->network_location_diagnostics))
        success = false;
      if (success && !input.ReadPositionCacheDiagnostics(&result->position_cache_diagnostics))
        success = false;
      if (success && !input.ReadWifiPollingPolicyDiagnostics(&result->wifi_polling_policy_diagnostics))
        success = false;
      if (success && !input.ReadLocationProviderManagerMode(&result->location_provider_manager_mode)) {
        success = false;
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NetworkLocationResponse::DataView, ::device::mojom::NetworkLocationResponsePtr>::Read(
    ::device::mojom::NetworkLocationResponse::DataView input,
    ::device::mojom::NetworkLocationResponsePtr* output) {
  bool success = true;
  ::device::mojom::NetworkLocationResponsePtr result(::device::mojom::NetworkLocationResponse::New());
  
      if (success)
        result->latitude = input.latitude();
      if (success)
        result->longitude = input.longitude();
      if (success) {
        result->accuracy = input.accuracy();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void GeolocationInternalsObserverInterceptorForTesting::OnDiagnosticsChanged(GeolocationDiagnosticsPtr diagnostics) {
  GetForwardingInterface()->OnDiagnosticsChanged(
    std::move(diagnostics)
    );
}
void GeolocationInternalsObserverInterceptorForTesting::OnNetworkLocationRequested(std::vector<AccessPointDataPtr> access_point_data) {
  GetForwardingInterface()->OnNetworkLocationRequested(
    std::move(access_point_data)
    );
}
void GeolocationInternalsObserverInterceptorForTesting::OnNetworkLocationReceived(NetworkLocationResponsePtr response) {
  GetForwardingInterface()->OnNetworkLocationReceived(
    std::move(response)
    );
}
GeolocationInternalsObserverAsyncWaiter::GeolocationInternalsObserverAsyncWaiter(
    GeolocationInternalsObserver* proxy) : proxy_(proxy) {}

GeolocationInternalsObserverAsyncWaiter::~GeolocationInternalsObserverAsyncWaiter() = default;





void GeolocationInternalsInterceptorForTesting::AddInternalsObserver(::mojo::PendingRemote<GeolocationInternalsObserver> observer, AddInternalsObserverCallback callback) {
  GetForwardingInterface()->AddInternalsObserver(
    std::move(observer)
    , std::move(callback));
}
GeolocationInternalsAsyncWaiter::GeolocationInternalsAsyncWaiter(
    GeolocationInternals* proxy) : proxy_(proxy) {}

GeolocationInternalsAsyncWaiter::~GeolocationInternalsAsyncWaiter() = default;


void GeolocationInternalsAsyncWaiter::AddInternalsObserver(
    ::mojo::PendingRemote<GeolocationInternalsObserver> observer, GeolocationDiagnosticsPtr* out_diagnostics) {
  base::RunLoop loop;
  proxy_->AddInternalsObserver(
      std::move(observer),
      base::BindOnce(
          [](base::RunLoop* loop,
             GeolocationDiagnosticsPtr* out_diagnostics
,
             GeolocationDiagnosticsPtr diagnostics) {*out_diagnostics = std::move(diagnostics);
            loop->Quit();
          },
          &loop,
          out_diagnostics));
  loop.Run();
}

GeolocationDiagnosticsPtr GeolocationInternalsAsyncWaiter::AddInternalsObserver(
    ::mojo::PendingRemote<GeolocationInternalsObserver> observer) {
  GeolocationDiagnosticsPtr async_wait_result;
  AddInternalsObserver(std::move(observer),&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif