// qtwebengine/browser/qtwebchannel.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "qtwebengine/browser/qtwebchannel.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "qtwebengine/browser/qtwebchannel.mojom-params-data.h"
#include "qtwebengine/browser/qtwebchannel.mojom-shared-message-ids.h"

#include "qtwebengine/browser/qtwebchannel.mojom-import-headers.h"
#include "qtwebengine/browser/qtwebchannel.mojom-test-utils.h"


namespace qtwebchannel::mojom {
// The declaration includes the definition on other builds.

WebChannelTransportRender::IPCStableHashFunction WebChannelTransportRender::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebChannelTransportRender>(message.name())) {
    case messages::WebChannelTransportRender::kSetWorldId: {
      return &WebChannelTransportRender::SetWorldId_Sym::IPCStableHash;
    }
    case messages::WebChannelTransportRender::kResetWorldId: {
      return &WebChannelTransportRender::ResetWorldId_Sym::IPCStableHash;
    }
    case messages::WebChannelTransportRender::kDispatchWebChannelMessage: {
      return &WebChannelTransportRender::DispatchWebChannelMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebChannelTransportRender::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebChannelTransportRender>(message.name())) {
      case messages::WebChannelTransportRender::kSetWorldId:
            return "Receive qtwebchannel::mojom::WebChannelTransportRender::SetWorldId";
      case messages::WebChannelTransportRender::kResetWorldId:
            return "Receive qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId";
      case messages::WebChannelTransportRender::kDispatchWebChannelMessage:
            return "Receive qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage";
    }
  } else {
    switch (static_cast<messages::WebChannelTransportRender>(message.name())) {
      case messages::WebChannelTransportRender::kSetWorldId:
            return "Receive reply qtwebchannel::mojom::WebChannelTransportRender::SetWorldId";
      case messages::WebChannelTransportRender::kResetWorldId:
            return "Receive reply qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId";
      case messages::WebChannelTransportRender::kDispatchWebChannelMessage:
            return "Receive reply qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebChannelTransportRender::SetWorldId_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc12b959e;  // IPCStableHash for qtwebchannel::mojom::WebChannelTransportRender::SetWorldId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebChannelTransportRender::ResetWorldId_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a498885;  // IPCStableHash for qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebChannelTransportRender::DispatchWebChannelMessage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x534cbf54;  // IPCStableHash for qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebChannelTransportRenderProxy::WebChannelTransportRenderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportRenderProxy::SetWorldId(
    uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebchannel::mojom::WebChannelTransportRender::SetWorldId", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worldId"), in_worldId,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebChannelTransportRender::kSetWorldId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebchannel::mojom::internal::WebChannelTransportRender_SetWorldId_Params_Data> params(
          message);
  params.Allocate();

  params->worldId = in_worldId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("SetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebChannelTransportRenderProxy::ResetWorldId(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send qtwebchannel::mojom::WebChannelTransportRender::ResetWorldId");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebChannelTransportRender::kResetWorldId), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebchannel::mojom::internal::WebChannelTransportRender_ResetWorldId_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("ResetWorldId");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebChannelTransportRenderProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson, uint32_t in_worldId) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebchannel::mojom::WebChannelTransportRender::DispatchWebChannelMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binaryJson"), in_binaryJson,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("worldId"), in_worldId,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebChannelTransportRender::kDispatchWebChannelMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebchannel::mojom::internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binaryJson)::BaseType>
      binaryJson_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& binaryJson_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_binaryJson,
    binaryJson_fragment,
    &binaryJson_validate_params);

  params->binaryJson.Set(
      binaryJson_fragment.is_null() ? nullptr : binaryJson_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->binaryJson.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null binaryJson in WebChannelTransportRender.DispatchWebChannelMessage request");

  params->worldId = in_worldId;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportRender::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebChannelTransportRenderStubDispatch::Accept(
    WebChannelTransportRender* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebChannelTransportRender>(message->header()->name)) {
    case messages::WebChannelTransportRender::kSetWorldId: {
      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_SetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_SetWorldId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebChannelTransportRender.0
      bool success = true;
      uint32_t p_worldId{};
      WebChannelTransportRender_SetWorldId_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWorldId(        
        std::move(p_worldId));
      return true;
    }
    case messages::WebChannelTransportRender::kResetWorldId: {
      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_ResetWorldId_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_ResetWorldId_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebChannelTransportRender.1
      bool success = true;
      WebChannelTransportRender_ResetWorldId_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetWorldId(        );
      return true;
    }
    case messages::WebChannelTransportRender::kDispatchWebChannelMessage: {
      DCHECK(message->is_serialized());
      internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebChannelTransportRender.2
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      uint32_t p_worldId{};
      WebChannelTransportRender_DispatchWebChannelMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      if (success)
        p_worldId = input_data_view.worldId();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportRender::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchWebChannelMessage(        
        std::move(p_binaryJson), 
        std::move(p_worldId));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportRenderStubDispatch::AcceptWithResponder(
    WebChannelTransportRender* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebChannelTransportRender>(message->header()->name)) {
    case messages::WebChannelTransportRender::kSetWorldId: {
      break;
    }
    case messages::WebChannelTransportRender::kResetWorldId: {
      break;
    }
    case messages::WebChannelTransportRender::kDispatchWebChannelMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebChannelTransportRenderValidationInfo[] = {
    {base::to_underlying(messages::WebChannelTransportRender::kSetWorldId),
     { &internal::WebChannelTransportRender_SetWorldId_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebChannelTransportRender::kResetWorldId),
     { &internal::WebChannelTransportRender_ResetWorldId_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::WebChannelTransportRender::kDispatchWebChannelMessage),
     { &internal::WebChannelTransportRender_DispatchWebChannelMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebChannelTransportRenderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebchannel::mojom::WebChannelTransportRender::Name_,
    kWebChannelTransportRenderValidationInfo);
}

// The declaration includes the definition on other builds.

WebChannelTransportHost::IPCStableHashFunction WebChannelTransportHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebChannelTransportHost>(message.name())) {
    case messages::WebChannelTransportHost::kDispatchWebChannelMessage: {
      return &WebChannelTransportHost::DispatchWebChannelMessage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebChannelTransportHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebChannelTransportHost>(message.name())) {
      case messages::WebChannelTransportHost::kDispatchWebChannelMessage:
            return "Receive qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage";
    }
  } else {
    switch (static_cast<messages::WebChannelTransportHost>(message.name())) {
      case messages::WebChannelTransportHost::kDispatchWebChannelMessage:
            return "Receive reply qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebChannelTransportHost::DispatchWebChannelMessage_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ba9583a;  // IPCStableHash for qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebChannelTransportHostProxy::WebChannelTransportHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebChannelTransportHostProxy::DispatchWebChannelMessage(
    const std::vector<uint8_t>& in_binaryJson) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send qtwebchannel::mojom::WebChannelTransportHost::DispatchWebChannelMessage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("binaryJson"), in_binaryJson,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebChannelTransportHost::kDispatchWebChannelMessage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::qtwebchannel::mojom::internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->binaryJson)::BaseType>
      binaryJson_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& binaryJson_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_binaryJson,
    binaryJson_fragment,
    &binaryJson_validate_params);

  params->binaryJson.Set(
      binaryJson_fragment.is_null() ? nullptr : binaryJson_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->binaryJson.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null binaryJson in WebChannelTransportHost.DispatchWebChannelMessage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebChannelTransportHost::Name_);
  message.set_method_name("DispatchWebChannelMessage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebChannelTransportHostStubDispatch::Accept(
    WebChannelTransportHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebChannelTransportHost>(message->header()->name)) {
    case messages::WebChannelTransportHost::kDispatchWebChannelMessage: {
      DCHECK(message->is_serialized());
      internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data* params =
          reinterpret_cast<internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebChannelTransportHost.0
      bool success = true;
      std::vector<uint8_t> p_binaryJson{};
      WebChannelTransportHost_DispatchWebChannelMessage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBinaryJson(&p_binaryJson))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebChannelTransportHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchWebChannelMessage(        
        std::move(p_binaryJson));
      return true;
    }
  }
  return false;
}

// static
bool WebChannelTransportHostStubDispatch::AcceptWithResponder(
    WebChannelTransportHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebChannelTransportHost>(message->header()->name)) {
    case messages::WebChannelTransportHost::kDispatchWebChannelMessage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kWebChannelTransportHostValidationInfo[] = {
    {base::to_underlying(messages::WebChannelTransportHost::kDispatchWebChannelMessage),
     { &internal::WebChannelTransportHost_DispatchWebChannelMessage_Params_Data::Validate,
      nullptr /* no response */}},
};

bool WebChannelTransportHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::qtwebchannel::mojom::WebChannelTransportHost::Name_,
    kWebChannelTransportHostValidationInfo);
}



}  // qtwebchannel::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace qtwebchannel::mojom {


void WebChannelTransportRenderInterceptorForTesting::SetWorldId(uint32_t worldId) {
  GetForwardingInterface()->SetWorldId(
    std::move(worldId)
    );
}
void WebChannelTransportRenderInterceptorForTesting::ResetWorldId() {
  GetForwardingInterface()->ResetWorldId();
}
void WebChannelTransportRenderInterceptorForTesting::DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson, uint32_t worldId) {
  GetForwardingInterface()->DispatchWebChannelMessage(
    std::move(binaryJson)
    , 
    std::move(worldId)
    );
}
WebChannelTransportRenderAsyncWaiter::WebChannelTransportRenderAsyncWaiter(
    WebChannelTransportRender* proxy) : proxy_(proxy) {}

WebChannelTransportRenderAsyncWaiter::~WebChannelTransportRenderAsyncWaiter() = default;





void WebChannelTransportHostInterceptorForTesting::DispatchWebChannelMessage(const std::vector<uint8_t>& binaryJson) {
  GetForwardingInterface()->DispatchWebChannelMessage(
    std::move(binaryJson)
    );
}
WebChannelTransportHostAsyncWaiter::WebChannelTransportHostAsyncWaiter(
    WebChannelTransportHost* proxy) : proxy_(proxy) {}

WebChannelTransportHostAsyncWaiter::~WebChannelTransportHostAsyncWaiter() = default;







}  // qtwebchannel::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif