// media/mojo/mojom/media_metrics_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/media_metrics_provider.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_metrics_provider.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_metrics_provider.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/media_types.mojom.h"
#include "media/mojo/mojom/video_decode_stats_recorder.mojom-forward.h"
#include "media/mojo/mojom/playback_events_recorder.mojom-forward.h"
#include "media/mojo/mojom/watch_time_recorder.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace media::mojom {

class MediaMetricsProviderProxy;

template <typename ImplRefTraits>
class MediaMetricsProviderStub;

class MediaMetricsProviderRequestValidator;


class MediaMetricsProvider
    : public MediaMetricsProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media.mojom.MediaMetricsProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaMetricsProviderInterfaceBase;
  using Proxy_ = MediaMetricsProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaMetricsProviderStub<ImplRefTraits>;

  using RequestValidator_ = MediaMetricsProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeMinVersion = 0,
    kOnStartedMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnFallbackMinVersion = 0,
    kSetHasPlayedMinVersion = 0,
    kSetHaveEnoughMinVersion = 0,
    kSetIsEMEMinVersion = 0,
    kSetTimeToMetadataMinVersion = 0,
    kSetTimeToFirstFrameMinVersion = 0,
    kSetTimeToPlayReadyMinVersion = 0,
    kSetRendererTypeMinVersion = 0,
    kSetDemuxerTypeMinVersion = 0,
    kSetKeySystemMinVersion = 0,
    kSetHasWaitingForKeyMinVersion = 0,
    kSetIsHardwareSecureMinVersion = 0,
    kSetContainerNameMinVersion = 0,
    kAcquireWatchTimeRecorderMinVersion = 0,
    kAcquireVideoDecodeStatsRecorderMinVersion = 0,
    kAcquirePlaybackEventsRecorderMinVersion = 0,
    kSetHasAudioMinVersion = 0,
    kSetHasVideoMinVersion = 0,
    kSetVideoPipelineInfoMinVersion = 0,
    kSetAudioPipelineInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasPlayed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHaveEnough_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsEME_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTimeToMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTimeToFirstFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTimeToPlayReady_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRendererType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDemuxerType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetKeySystem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasWaitingForKey_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsHardwareSecure_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetContainerName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcquireWatchTimeRecorder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcquireVideoDecodeStatsRecorder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcquirePlaybackEventsRecorder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasAudio_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasVideo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetVideoPipelineInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAudioPipelineInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaMetricsProvider() = default;

  virtual void Initialize(bool is_mse, MediaURLScheme url_scheme, ::media::mojom::MediaStreamType stream_type) = 0;

  virtual void OnStarted(const ::media::PipelineStatus& status) = 0;

  virtual void OnError(const ::media::PipelineStatus& status) = 0;

  virtual void OnFallback(const ::media::PipelineStatus& status) = 0;

  virtual void SetHasPlayed() = 0;

  virtual void SetHaveEnough() = 0;

  virtual void SetIsEME() = 0;

  virtual void SetTimeToMetadata(::base::TimeDelta elapsed) = 0;

  virtual void SetTimeToFirstFrame(::base::TimeDelta elapsed) = 0;

  virtual void SetTimeToPlayReady(::base::TimeDelta elapsed) = 0;

  virtual void SetRendererType(::media::RendererType renderer_type) = 0;

  virtual void SetDemuxerType(::media::DemuxerType demuxer_type) = 0;

  virtual void SetKeySystem(const std::string& key_system) = 0;

  virtual void SetHasWaitingForKey() = 0;

  virtual void SetIsHardwareSecure() = 0;

  virtual void SetContainerName(::media::container_names::MediaContainerName container_name) = 0;

  virtual void AcquireWatchTimeRecorder(::media::mojom::PlaybackPropertiesPtr properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> recorder) = 0;

  virtual void AcquireVideoDecodeStatsRecorder(::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> recorder) = 0;

  virtual void AcquirePlaybackEventsRecorder(::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> receiver) = 0;

  virtual void SetHasAudio(::media::AudioCodec codec) = 0;

  virtual void SetHasVideo(::media::VideoCodec codec) = 0;

  virtual void SetVideoPipelineInfo(const ::media::VideoPipelineInfo& info) = 0;

  virtual void SetAudioPipelineInfo(const ::media::AudioPipelineInfo& info) = 0;
};



class  MediaMetricsProviderProxy
    : public MediaMetricsProvider {
 public:
  using InterfaceType = MediaMetricsProvider;

  explicit MediaMetricsProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Initialize(bool is_mse, MediaURLScheme url_scheme, ::media::mojom::MediaStreamType stream_type) final;
  
  void OnStarted(const ::media::PipelineStatus& status) final;
  
  void OnError(const ::media::PipelineStatus& status) final;
  
  void OnFallback(const ::media::PipelineStatus& status) final;
  
  void SetHasPlayed() final;
  
  void SetHaveEnough() final;
  
  void SetIsEME() final;
  
  void SetTimeToMetadata(::base::TimeDelta elapsed) final;
  
  void SetTimeToFirstFrame(::base::TimeDelta elapsed) final;
  
  void SetTimeToPlayReady(::base::TimeDelta elapsed) final;
  
  void SetRendererType(::media::RendererType renderer_type) final;
  
  void SetDemuxerType(::media::DemuxerType demuxer_type) final;
  
  void SetKeySystem(const std::string& key_system) final;
  
  void SetHasWaitingForKey() final;
  
  void SetIsHardwareSecure() final;
  
  void SetContainerName(::media::container_names::MediaContainerName container_name) final;
  
  void AcquireWatchTimeRecorder(::media::mojom::PlaybackPropertiesPtr properties, ::mojo::PendingReceiver<::media::mojom::WatchTimeRecorder> recorder) final;
  
  void AcquireVideoDecodeStatsRecorder(::mojo::PendingReceiver<::media::mojom::VideoDecodeStatsRecorder> recorder) final;
  
  void AcquirePlaybackEventsRecorder(::mojo::PendingReceiver<::media::mojom::PlaybackEventsRecorder> receiver) final;
  
  void SetHasAudio(::media::AudioCodec codec) final;
  
  void SetHasVideo(::media::VideoCodec codec) final;
  
  void SetVideoPipelineInfo(const ::media::VideoPipelineInfo& info) final;
  
  void SetAudioPipelineInfo(const ::media::AudioPipelineInfo& info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaMetricsProviderStubDispatch {
 public:
  static bool Accept(MediaMetricsProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaMetricsProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaMetricsProvider>>
class MediaMetricsProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaMetricsProviderStub() = default;
  ~MediaMetricsProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaMetricsProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaMetricsProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaMetricsProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_MEDIA_METRICS_PROVIDER_MOJOM_H_