// media/mojo/mojom/content_decryption_module.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/content_decryption_module.mojom-shared-internal.h"
#include "media/mojo/mojom/decryptor.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "media/mojo/mojom/content_decryption_module.mojom-data-view.h"




namespace std {

template <>
struct hash<::media::mojom::CdmKeyStatus>
    : public mojo::internal::EnumHashImpl<::media::mojom::CdmKeyStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmKeyStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::CdmKeyStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::CdmKeyStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key_system(input)) in_key_system = Traits::key_system(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_system)::BaseType> key_system_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key_system,
      key_system_fragment);

    fragment->key_system.Set(
        key_system_fragment.is_null() ? nullptr : key_system_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_system.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_system in CdmConfig struct");

    fragment->allow_distinctive_identifier = Traits::allow_distinctive_identifier(input);

    fragment->allow_persistent_state = Traits::allow_persistent_state(input);

    fragment->use_hw_secure_codecs = Traits::use_hw_secure_codecs(input);
  }

  static bool Deserialize(::media::mojom::internal::CdmConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmPromiseResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmPromiseResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmPromiseResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->success = Traits::success(input);

    
    mojo::internal::Serialize<::media::mojom::CdmPromiseResult_Exception>(
      Traits::exception(input),
      &fragment->exception);

    fragment->system_code = Traits::system_code(input);

    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message,
      error_message_fragment);

    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in CdmPromiseResult struct");
  }

  static bool Deserialize(::media::mojom::internal::CdmPromiseResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmPromiseResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmKeyInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmKeyInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmKeyInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key_id(input)) in_key_id = Traits::key_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_id)::BaseType>
        key_id_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& key_id_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_key_id,
      key_id_fragment,
      &key_id_validate_params);

    fragment->key_id.Set(
        key_id_fragment.is_null() ? nullptr : key_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_id in CdmKeyInformation struct");

    
    mojo::internal::Serialize<::media::mojom::CdmKeyStatus>(
      Traits::status(input),
      &fragment->status);

    fragment->system_code = Traits::system_code(input);
  }

  static bool Deserialize(::media::mojom::internal::CdmKeyInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmKeyInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CdmContextDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CdmContextDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CdmContext_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cdm_id(input)) in_cdm_id = Traits::cdm_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cdm_id)::BaseType> cdm_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cdm_id,
      cdm_id_fragment);

    fragment->cdm_id.Set(
        cdm_id_fragment.is_null() ? nullptr : cdm_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cdm_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_id in CdmContext struct");

    decltype(Traits::decryptor(input)) in_decryptor = Traits::decryptor(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::DecryptorInterfaceBase>>(
      in_decryptor,
      &fragment->decryptor,
      &fragment.message());
  }

  static bool Deserialize(::media::mojom::internal::CdmContext_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CdmContextDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void CdmConfigDataView::GetKeySystemDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key_system.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CdmPromiseResultDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CdmKeyInformationDataView::GetKeyIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->key_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void CdmContextDataView::GetCdmIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->cdm_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::CdmKeyStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::CdmKeyStatus value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_CONTENT_DECRYPTION_MODULE_MOJOM_SHARED_H_