// media/mojo/mojom/cdm_context_for_oopvd.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-params-data.h"
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-import-headers.h"
#include "media/mojo/mojom/cdm_context_for_oopvd.mojom-test-utils.h"
#include "media/mojo/mojom/video_decoder_config_mojom_traits.h"


namespace media::mojom {
// The declaration includes the definition on other builds.

CdmContextEventCallback::IPCStableHashFunction CdmContextEventCallback::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
    case messages::CdmContextEventCallback::kEventCallback: {
      return &CdmContextEventCallback::EventCallback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmContextEventCallback::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
      case messages::CdmContextEventCallback::kEventCallback:
            return "Receive media::mojom::CdmContextEventCallback::EventCallback";
    }
  } else {
    switch (static_cast<messages::CdmContextEventCallback>(message.name())) {
      case messages::CdmContextEventCallback::kEventCallback:
            return "Receive reply media::mojom::CdmContextEventCallback::EventCallback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmContextEventCallback::EventCallback_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x27340f8d;  // IPCStableHash for media::mojom::CdmContextEventCallback::EventCallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CdmContextEventCallbackProxy::CdmContextEventCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmContextEventCallbackProxy::EventCallback(
    CdmContextEvent in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextEventCallback::EventCallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type CdmContextEvent>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextEventCallback::kEventCallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextEventCallback_EventCallback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::CdmContextEvent>(
    in_event,
    &params->event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextEventCallback::Name_);
  message.set_method_name("EventCallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CdmContextEventCallbackStubDispatch::Accept(
    CdmContextEventCallback* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmContextEventCallback>(message->header()->name)) {
    case messages::CdmContextEventCallback::kEventCallback: {
      DCHECK(message->is_serialized());
      internal::CdmContextEventCallback_EventCallback_Params_Data* params =
          reinterpret_cast<internal::CdmContextEventCallback_EventCallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CdmContextEventCallback.0
      bool success = true;
      CdmContextEvent p_event{};
      CdmContextEventCallback_EventCallback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextEventCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EventCallback(        
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool CdmContextEventCallbackStubDispatch::AcceptWithResponder(
    CdmContextEventCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmContextEventCallback>(message->header()->name)) {
    case messages::CdmContextEventCallback::kEventCallback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmContextEventCallbackValidationInfo[] = {
    {base::to_underlying(messages::CdmContextEventCallback::kEventCallback),
     { &internal::CdmContextEventCallback_EventCallback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmContextEventCallbackRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::CdmContextEventCallback::Name_,
    kCdmContextEventCallbackValidationInfo);
}

// The declaration includes the definition on other builds.

CdmContextForOOPVD::IPCStableHashFunction CdmContextForOOPVD::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CdmContextForOOPVD>(message.name())) {
    case messages::CdmContextForOOPVD::kGetHwKeyData: {
      return &CdmContextForOOPVD::GetHwKeyData_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kRegisterEventCallback: {
      return &CdmContextForOOPVD::RegisterEventCallback_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kGetHwConfigData: {
      return &CdmContextForOOPVD::GetHwConfigData_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kGetScreenResolutions: {
      return &CdmContextForOOPVD::GetScreenResolutions_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kAllocateSecureBuffer: {
      return &CdmContextForOOPVD::AllocateSecureBuffer_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kParseEncryptedSliceHeader: {
      return &CdmContextForOOPVD::ParseEncryptedSliceHeader_Sym::IPCStableHash;
    }
    case messages::CdmContextForOOPVD::kDecryptVideoBuffer: {
      return &CdmContextForOOPVD::DecryptVideoBuffer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CdmContextForOOPVD::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CdmContextForOOPVD>(message.name())) {
      case messages::CdmContextForOOPVD::kGetHwKeyData:
            return "Receive media::mojom::CdmContextForOOPVD::GetHwKeyData";
      case messages::CdmContextForOOPVD::kRegisterEventCallback:
            return "Receive media::mojom::CdmContextForOOPVD::RegisterEventCallback";
      case messages::CdmContextForOOPVD::kGetHwConfigData:
            return "Receive media::mojom::CdmContextForOOPVD::GetHwConfigData";
      case messages::CdmContextForOOPVD::kGetScreenResolutions:
            return "Receive media::mojom::CdmContextForOOPVD::GetScreenResolutions";
      case messages::CdmContextForOOPVD::kAllocateSecureBuffer:
            return "Receive media::mojom::CdmContextForOOPVD::AllocateSecureBuffer";
      case messages::CdmContextForOOPVD::kParseEncryptedSliceHeader:
            return "Receive media::mojom::CdmContextForOOPVD::ParseEncryptedSliceHeader";
      case messages::CdmContextForOOPVD::kDecryptVideoBuffer:
            return "Receive media::mojom::CdmContextForOOPVD::DecryptVideoBuffer";
    }
  } else {
    switch (static_cast<messages::CdmContextForOOPVD>(message.name())) {
      case messages::CdmContextForOOPVD::kGetHwKeyData:
            return "Receive reply media::mojom::CdmContextForOOPVD::GetHwKeyData";
      case messages::CdmContextForOOPVD::kRegisterEventCallback:
            return "Receive reply media::mojom::CdmContextForOOPVD::RegisterEventCallback";
      case messages::CdmContextForOOPVD::kGetHwConfigData:
            return "Receive reply media::mojom::CdmContextForOOPVD::GetHwConfigData";
      case messages::CdmContextForOOPVD::kGetScreenResolutions:
            return "Receive reply media::mojom::CdmContextForOOPVD::GetScreenResolutions";
      case messages::CdmContextForOOPVD::kAllocateSecureBuffer:
            return "Receive reply media::mojom::CdmContextForOOPVD::AllocateSecureBuffer";
      case messages::CdmContextForOOPVD::kParseEncryptedSliceHeader:
            return "Receive reply media::mojom::CdmContextForOOPVD::ParseEncryptedSliceHeader";
      case messages::CdmContextForOOPVD::kDecryptVideoBuffer:
            return "Receive reply media::mojom::CdmContextForOOPVD::DecryptVideoBuffer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CdmContextForOOPVD::GetHwKeyData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xac1e1f3f;  // IPCStableHash for media::mojom::CdmContextForOOPVD::GetHwKeyData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::RegisterEventCallback_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x82efc44f;  // IPCStableHash for media::mojom::CdmContextForOOPVD::RegisterEventCallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::GetHwConfigData_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef418213;  // IPCStableHash for media::mojom::CdmContextForOOPVD::GetHwConfigData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::GetScreenResolutions_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96e98265;  // IPCStableHash for media::mojom::CdmContextForOOPVD::GetScreenResolutions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::AllocateSecureBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc6a8e4b7;  // IPCStableHash for media::mojom::CdmContextForOOPVD::AllocateSecureBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::ParseEncryptedSliceHeader_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1104b61;  // IPCStableHash for media::mojom::CdmContextForOOPVD::ParseEncryptedSliceHeader
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CdmContextForOOPVD::DecryptVideoBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87de69f0;  // IPCStableHash for media::mojom::CdmContextForOOPVD::DecryptVideoBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CdmContextForOOPVD_GetHwKeyData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_GetHwKeyData_ForwardToCallback(
      CdmContextForOOPVD::GetHwKeyDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_GetHwKeyData_ForwardToCallback(const CdmContextForOOPVD_GetHwKeyData_ForwardToCallback&) = delete;
  CdmContextForOOPVD_GetHwKeyData_ForwardToCallback& operator=(const CdmContextForOOPVD_GetHwKeyData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::GetHwKeyDataCallback callback_;
};

class CdmContextForOOPVD_GetHwConfigData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_GetHwConfigData_ForwardToCallback(
      CdmContextForOOPVD::GetHwConfigDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_GetHwConfigData_ForwardToCallback(const CdmContextForOOPVD_GetHwConfigData_ForwardToCallback&) = delete;
  CdmContextForOOPVD_GetHwConfigData_ForwardToCallback& operator=(const CdmContextForOOPVD_GetHwConfigData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::GetHwConfigDataCallback callback_;
};

class CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback(
      CdmContextForOOPVD::GetScreenResolutionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback(const CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback&) = delete;
  CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback& operator=(const CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::GetScreenResolutionsCallback callback_;
};

class CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback(
      CdmContextForOOPVD::AllocateSecureBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback(const CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback&) = delete;
  CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback& operator=(const CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::AllocateSecureBufferCallback callback_;
};

class CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback(
      CdmContextForOOPVD::ParseEncryptedSliceHeaderCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback(const CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback&) = delete;
  CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback& operator=(const CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::ParseEncryptedSliceHeaderCallback callback_;
};

class CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback(
      CdmContextForOOPVD::DecryptVideoBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback(const CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback&) = delete;
  CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback& operator=(const CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CdmContextForOOPVD::DecryptVideoBufferCallback callback_;
};

CdmContextForOOPVDProxy::CdmContextForOOPVDProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmContextForOOPVDProxy::GetHwKeyData(
    ::media::mojom::DecryptConfigPtr in_decrypt_config, const std::vector<uint8_t>& in_hw_identifier, GetHwKeyDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextForOOPVD::GetHwKeyData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decrypt_config"), in_decrypt_config,
                        "<value of type ::media::mojom::DecryptConfigPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hw_identifier"), in_hw_identifier,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetHwKeyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetHwKeyData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->decrypt_config)::BaseType> decrypt_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::DecryptConfigDataView>(
    in_decrypt_config,
    decrypt_config_fragment);

  params->decrypt_config.Set(
      decrypt_config_fragment.is_null() ? nullptr : decrypt_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->decrypt_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null decrypt_config in CdmContextForOOPVD.GetHwKeyData request");
  mojo::internal::MessageFragment<
      typename decltype(params->hw_identifier)::BaseType>
      hw_identifier_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& hw_identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_hw_identifier,
    hw_identifier_fragment,
    &hw_identifier_validate_params);

  params->hw_identifier.Set(
      hw_identifier_fragment.is_null() ? nullptr : hw_identifier_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hw_identifier.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hw_identifier in CdmContextForOOPVD.GetHwKeyData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetHwKeyData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_GetHwKeyData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmContextForOOPVDProxy::RegisterEventCallback(
    ::mojo::PendingRemote<CdmContextEventCallback> in_callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextForOOPVD::RegisterEventCallback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("callback"), in_callback,
                        "<value of type ::mojo::PendingRemote<CdmContextEventCallback>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kRegisterEventCallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_RegisterEventCallback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::CdmContextEventCallbackInterfaceBase>>(
    in_callback,
    &params->callback,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->callback)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid callback in CdmContextForOOPVD.RegisterEventCallback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("RegisterEventCallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CdmContextForOOPVDProxy::GetHwConfigData(
    GetHwConfigDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::CdmContextForOOPVD::GetHwConfigData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetHwConfigData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetHwConfigData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetHwConfigData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_GetHwConfigData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmContextForOOPVDProxy::GetScreenResolutions(
    GetScreenResolutionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media::mojom::CdmContextForOOPVD::GetScreenResolutions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetScreenResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetScreenResolutions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetScreenResolutions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmContextForOOPVDProxy::AllocateSecureBuffer(
    uint32_t in_size, AllocateSecureBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextForOOPVD::AllocateSecureBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kAllocateSecureBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_AllocateSecureBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("AllocateSecureBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmContextForOOPVDProxy::ParseEncryptedSliceHeader(
    uint64_t in_secure_handle, uint32_t in_offset, const std::vector<uint8_t>& in_stream_data, ParseEncryptedSliceHeaderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextForOOPVD::ParseEncryptedSliceHeader", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_handle"), in_secure_handle,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_data"), in_stream_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kParseEncryptedSliceHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data> params(
          message);
  params.Allocate();

  params->secure_handle = in_secure_handle;

  params->offset = in_offset;
  mojo::internal::MessageFragment<
      typename decltype(params->stream_data)::BaseType>
      stream_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& stream_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_stream_data,
    stream_data_fragment,
    &stream_data_validate_params);

  params->stream_data.Set(
      stream_data_fragment.is_null() ? nullptr : stream_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->stream_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null stream_data in CdmContextForOOPVD.ParseEncryptedSliceHeader request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("ParseEncryptedSliceHeader");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CdmContextForOOPVDProxy::DecryptVideoBuffer(
    ::media::mojom::DecoderBufferPtr in_buffer, const std::vector<uint8_t>& in_bytes, DecryptVideoBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::mojom::CdmContextForOOPVD::DecryptVideoBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kDecryptVideoBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_DecryptVideoBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->buffer)>
      buffer_fragment(params.message());
  buffer_fragment.Claim(&params->buffer);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_buffer,
    buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in CdmContextForOOPVD.DecryptVideoBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bytes,
    bytes_fragment,
    &bytes_validate_params);

  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bytes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bytes in CdmContextForOOPVD.DecryptVideoBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("DecryptVideoBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class CdmContextForOOPVD_GetHwKeyData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::GetHwKeyDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_GetHwKeyData_ProxyToResponder> proxy(
        new CdmContextForOOPVD_GetHwKeyData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_GetHwKeyData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_GetHwKeyData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_GetHwKeyData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::GetHwKeyDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DecryptStatus in_status, const std::vector<uint8_t>& in_key_data);
};

bool CdmContextForOOPVD_GetHwKeyData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.0
  bool success = true;
  DecryptStatus p_status{};
  std::vector<uint8_t> p_key_data{};
  CdmContextForOOPVD_GetHwKeyData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadKeyData(&p_key_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_key_data));
  }
  return true;
}

void CdmContextForOOPVD_GetHwKeyData_ProxyToResponder::Run(
    DecryptStatus in_status, const std::vector<uint8_t>& in_key_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::GetHwKeyData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type DecryptStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_data"), in_key_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetHwKeyData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::DecryptStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->key_data)::BaseType>
      key_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_key_data,
    key_data_fragment,
    &key_data_validate_params);

  params->key_data.Set(
      key_data_fragment.is_null() ? nullptr : key_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetHwKeyData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmContextForOOPVD_GetHwConfigData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::GetHwConfigDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_GetHwConfigData_ProxyToResponder> proxy(
        new CdmContextForOOPVD_GetHwConfigData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_GetHwConfigData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_GetHwConfigData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_GetHwConfigData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::GetHwConfigDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<uint8_t>& in_config_data);
};

bool CdmContextForOOPVD_GetHwConfigData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.2
  bool success = true;
  bool p_success{};
  std::vector<uint8_t> p_config_data{};
  CdmContextForOOPVD_GetHwConfigData_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadConfigData(&p_config_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_config_data));
  }
  return true;
}

void CdmContextForOOPVD_GetHwConfigData_ProxyToResponder::Run(
    bool in_success, const std::vector<uint8_t>& in_config_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::GetHwConfigData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("config_data"), in_config_data,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetHwConfigData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->config_data)::BaseType>
      config_data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& config_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_config_data,
    config_data_fragment,
    &config_data_validate_params);

  params->config_data.Set(
      config_data_fragment.is_null() ? nullptr : config_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->config_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null config_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetHwConfigData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::GetScreenResolutionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder> proxy(
        new CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::GetScreenResolutionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::gfx::Size>& in_resolutions);
};

bool CdmContextForOOPVD_GetScreenResolutions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.3
  bool success = true;
  std::vector<::gfx::Size> p_resolutions{};
  CdmContextForOOPVD_GetScreenResolutions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResolutions(&p_resolutions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_resolutions));
  }
  return true;
}

void CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder::Run(
    const std::vector<::gfx::Size>& in_resolutions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::GetScreenResolutions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("resolutions"), in_resolutions,
                        "<value of type const std::vector<::gfx::Size>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kGetScreenResolutions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->resolutions)::BaseType>
      resolutions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& resolutions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
    in_resolutions,
    resolutions_fragment,
    &resolutions_validate_params);

  params->resolutions.Set(
      resolutions_fragment.is_null() ? nullptr : resolutions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->resolutions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null resolutions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("GetScreenResolutions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::AllocateSecureBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder> proxy(
        new CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::AllocateSecureBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PlatformHandle in_secure_buffer);
};

bool CdmContextForOOPVD_AllocateSecureBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.4
  bool success = true;
  ::mojo::PlatformHandle p_secure_buffer{};
  CdmContextForOOPVD_AllocateSecureBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_secure_buffer = input_data_view.TakeSecureBuffer();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_secure_buffer));
  }
  return true;
}

void CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder::Run(
    ::mojo::PlatformHandle in_secure_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::AllocateSecureBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_buffer"), in_secure_buffer,
                        "<value of type ::mojo::PlatformHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kAllocateSecureBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::PlatformHandle>(
    in_secure_buffer,
    &params->secure_buffer,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("AllocateSecureBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::ParseEncryptedSliceHeaderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder> proxy(
        new CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::ParseEncryptedSliceHeaderCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<uint8_t>& in_slice_header);
};

bool CdmContextForOOPVD_ParseEncryptedSliceHeader_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.5
  bool success = true;
  bool p_success{};
  std::vector<uint8_t> p_slice_header{};
  CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadSliceHeader(&p_slice_header))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_slice_header));
  }
  return true;
}

void CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder::Run(
    bool in_success, const std::vector<uint8_t>& in_slice_header) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::ParseEncryptedSliceHeader", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("slice_header"), in_slice_header,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kParseEncryptedSliceHeader), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->slice_header)::BaseType>
      slice_header_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& slice_header_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_slice_header,
    slice_header_fragment,
    &slice_header_validate_params);

  params->slice_header.Set(
      slice_header_fragment.is_null() ? nullptr : slice_header_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->slice_header.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null slice_header in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("ParseEncryptedSliceHeader");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CdmContextForOOPVD::DecryptVideoBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder> proxy(
        new CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CdmContextForOOPVD::DecryptVideoBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DecryptStatus in_status, ::media::mojom::DecoderBufferPtr in_decoder_buffer, const std::vector<uint8_t>& in_bytes);
};

bool CdmContextForOOPVD_DecryptVideoBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CdmContextForOOPVD.6
  bool success = true;
  DecryptStatus p_status{};
  ::media::mojom::DecoderBufferPtr p_decoder_buffer{};
  std::vector<uint8_t> p_bytes{};
  CdmContextForOOPVD_DecryptVideoBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDecoderBuffer(&p_decoder_buffer))
    success = false;
  if (success && !input_data_view.ReadBytes(&p_bytes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CdmContextForOOPVD::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_decoder_buffer), 
std::move(p_bytes));
  }
  return true;
}

void CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder::Run(
    DecryptStatus in_status, ::media::mojom::DecoderBufferPtr in_decoder_buffer, const std::vector<uint8_t>& in_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::mojom::CdmContextForOOPVD::DecryptVideoBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type DecryptStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("decoder_buffer"), in_decoder_buffer,
                        "<value of type ::media::mojom::DecoderBufferPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CdmContextForOOPVD::kDecryptVideoBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::mojom::internal::CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::DecryptStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<decltype(params->decoder_buffer)>
      decoder_buffer_fragment(params.message());
  decoder_buffer_fragment.Claim(&params->decoder_buffer);
  
  mojo::internal::Serialize<::media::mojom::DecoderBufferDataView>(
    in_decoder_buffer,
    decoder_buffer_fragment,
    true);
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bytes,
    bytes_fragment,
    &bytes_validate_params);

  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bytes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bytes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmContextForOOPVD::Name_);
  message.set_method_name("DecryptVideoBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CdmContextForOOPVDStubDispatch::Accept(
    CdmContextForOOPVD* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CdmContextForOOPVD>(message->header()->name)) {
    case messages::CdmContextForOOPVD::kGetHwKeyData: {
      break;
    }
    case messages::CdmContextForOOPVD::kRegisterEventCallback: {
      DCHECK(message->is_serialized());
      internal::CdmContextForOOPVD_RegisterEventCallback_Params_Data* params =
          reinterpret_cast<internal::CdmContextForOOPVD_RegisterEventCallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.1
      bool success = true;
      ::mojo::PendingRemote<CdmContextEventCallback> p_callback{};
      CdmContextForOOPVD_RegisterEventCallback_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_callback =
            input_data_view.TakeCallback<decltype(p_callback)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterEventCallback(        
        std::move(p_callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kGetHwConfigData: {
      break;
    }
    case messages::CdmContextForOOPVD::kGetScreenResolutions: {
      break;
    }
    case messages::CdmContextForOOPVD::kAllocateSecureBuffer: {
      break;
    }
    case messages::CdmContextForOOPVD::kParseEncryptedSliceHeader: {
      break;
    }
    case messages::CdmContextForOOPVD::kDecryptVideoBuffer: {
      break;
    }
  }
  return false;
}

// static
bool CdmContextForOOPVDStubDispatch::AcceptWithResponder(
    CdmContextForOOPVD* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CdmContextForOOPVD>(message->header()->name)) {
    case messages::CdmContextForOOPVD::kGetHwKeyData: {
      internal::CdmContextForOOPVD_GetHwKeyData_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_GetHwKeyData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.0
      bool success = true;
      ::media::mojom::DecryptConfigPtr p_decrypt_config{};
      std::vector<uint8_t> p_hw_identifier{};
      CdmContextForOOPVD_GetHwKeyData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDecryptConfig(&p_decrypt_config))
        success = false;
      if (success && !input_data_view.ReadHwIdentifier(&p_hw_identifier))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 0, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_GetHwKeyData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHwKeyData(        
        std::move(p_decrypt_config), 
        std::move(p_hw_identifier), std::move(callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kRegisterEventCallback: {
      break;
    }
    case messages::CdmContextForOOPVD::kGetHwConfigData: {
      internal::CdmContextForOOPVD_GetHwConfigData_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_GetHwConfigData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.2
      bool success = true;
      CdmContextForOOPVD_GetHwConfigData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 2, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_GetHwConfigData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHwConfigData(std::move(callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kGetScreenResolutions: {
      internal::CdmContextForOOPVD_GetScreenResolutions_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_GetScreenResolutions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.3
      bool success = true;
      CdmContextForOOPVD_GetScreenResolutions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 3, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_GetScreenResolutions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetScreenResolutions(std::move(callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kAllocateSecureBuffer: {
      internal::CdmContextForOOPVD_AllocateSecureBuffer_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_AllocateSecureBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.4
      bool success = true;
      uint32_t p_size{};
      CdmContextForOOPVD_AllocateSecureBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_size = input_data_view.size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 4, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_AllocateSecureBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AllocateSecureBuffer(        
        std::move(p_size), std::move(callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kParseEncryptedSliceHeader: {
      internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.5
      bool success = true;
      uint64_t p_secure_handle{};
      uint32_t p_offset{};
      std::vector<uint8_t> p_stream_data{};
      CdmContextForOOPVD_ParseEncryptedSliceHeader_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_secure_handle = input_data_view.secure_handle();
      if (success)
        p_offset = input_data_view.offset();
      if (success && !input_data_view.ReadStreamData(&p_stream_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 5, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_ParseEncryptedSliceHeader_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseEncryptedSliceHeader(        
        std::move(p_secure_handle), 
        std::move(p_offset), 
        std::move(p_stream_data), std::move(callback));
      return true;
    }
    case messages::CdmContextForOOPVD::kDecryptVideoBuffer: {
      internal::CdmContextForOOPVD_DecryptVideoBuffer_Params_Data* params =
          reinterpret_cast<
              internal::CdmContextForOOPVD_DecryptVideoBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CdmContextForOOPVD.6
      bool success = true;
      ::media::mojom::DecoderBufferPtr p_buffer{};
      std::vector<uint8_t> p_bytes{};
      CdmContextForOOPVD_DecryptVideoBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (success && !input_data_view.ReadBytes(&p_bytes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmContextForOOPVD::Name_, 6, false);
        return false;
      }
      auto callback =
          CdmContextForOOPVD_DecryptVideoBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecryptVideoBuffer(        
        std::move(p_buffer), 
        std::move(p_bytes), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmContextForOOPVDValidationInfo[] = {
    {base::to_underlying(messages::CdmContextForOOPVD::kGetHwKeyData),
     { &internal::CdmContextForOOPVD_GetHwKeyData_Params_Data::Validate,
      &internal::CdmContextForOOPVD_GetHwKeyData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmContextForOOPVD::kRegisterEventCallback),
     { &internal::CdmContextForOOPVD_RegisterEventCallback_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::CdmContextForOOPVD::kGetHwConfigData),
     { &internal::CdmContextForOOPVD_GetHwConfigData_Params_Data::Validate,
      &internal::CdmContextForOOPVD_GetHwConfigData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmContextForOOPVD::kGetScreenResolutions),
     { &internal::CdmContextForOOPVD_GetScreenResolutions_Params_Data::Validate,
      &internal::CdmContextForOOPVD_GetScreenResolutions_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmContextForOOPVD::kAllocateSecureBuffer),
     { &internal::CdmContextForOOPVD_AllocateSecureBuffer_Params_Data::Validate,
      &internal::CdmContextForOOPVD_AllocateSecureBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmContextForOOPVD::kParseEncryptedSliceHeader),
     { &internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_Params_Data::Validate,
      &internal::CdmContextForOOPVD_ParseEncryptedSliceHeader_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::CdmContextForOOPVD::kDecryptVideoBuffer),
     { &internal::CdmContextForOOPVD_DecryptVideoBuffer_Params_Data::Validate,
      &internal::CdmContextForOOPVD_DecryptVideoBuffer_ResponseParams_Data::Validate}},
};

bool CdmContextForOOPVDRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::media::mojom::CdmContextForOOPVD::Name_,
    kCdmContextForOOPVDValidationInfo);
}

bool CdmContextForOOPVDResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGeneric(
    message,
    ::media::mojom::CdmContextForOOPVD::Name_,
    kCdmContextForOOPVDValidationInfo);

}


}  // media::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::mojom {


void CdmContextEventCallbackInterceptorForTesting::EventCallback(CdmContextEvent event) {
  GetForwardingInterface()->EventCallback(
    std::move(event)
    );
}
CdmContextEventCallbackAsyncWaiter::CdmContextEventCallbackAsyncWaiter(
    CdmContextEventCallback* proxy) : proxy_(proxy) {}

CdmContextEventCallbackAsyncWaiter::~CdmContextEventCallbackAsyncWaiter() = default;





void CdmContextForOOPVDInterceptorForTesting::GetHwKeyData(::media::mojom::DecryptConfigPtr decrypt_config, const std::vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) {
  GetForwardingInterface()->GetHwKeyData(
    std::move(decrypt_config)
    , 
    std::move(hw_identifier)
    , std::move(callback));
}
void CdmContextForOOPVDInterceptorForTesting::RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) {
  GetForwardingInterface()->RegisterEventCallback(
    std::move(callback)
    );
}
void CdmContextForOOPVDInterceptorForTesting::GetHwConfigData(GetHwConfigDataCallback callback) {
  GetForwardingInterface()->GetHwConfigData(std::move(callback));
}
void CdmContextForOOPVDInterceptorForTesting::GetScreenResolutions(GetScreenResolutionsCallback callback) {
  GetForwardingInterface()->GetScreenResolutions(std::move(callback));
}
void CdmContextForOOPVDInterceptorForTesting::AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) {
  GetForwardingInterface()->AllocateSecureBuffer(
    std::move(size)
    , std::move(callback));
}
void CdmContextForOOPVDInterceptorForTesting::ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) {
  GetForwardingInterface()->ParseEncryptedSliceHeader(
    std::move(secure_handle)
    , 
    std::move(offset)
    , 
    std::move(stream_data)
    , std::move(callback));
}
void CdmContextForOOPVDInterceptorForTesting::DecryptVideoBuffer(::media::mojom::DecoderBufferPtr buffer, const std::vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) {
  GetForwardingInterface()->DecryptVideoBuffer(
    std::move(buffer)
    , 
    std::move(bytes)
    , std::move(callback));
}
CdmContextForOOPVDAsyncWaiter::CdmContextForOOPVDAsyncWaiter(
    CdmContextForOOPVD* proxy) : proxy_(proxy) {}

CdmContextForOOPVDAsyncWaiter::~CdmContextForOOPVDAsyncWaiter() = default;


void CdmContextForOOPVDAsyncWaiter::GetHwKeyData(
    ::media::mojom::DecryptConfigPtr decrypt_config, const std::vector<uint8_t>& hw_identifier, DecryptStatus* out_status, std::vector<uint8_t>* out_key_data) {
  base::RunLoop loop;
  proxy_->GetHwKeyData(
      std::move(decrypt_config),
      std::move(hw_identifier),
      base::BindOnce(
          [](base::RunLoop* loop,
             DecryptStatus* out_status
,
             std::vector<uint8_t>* out_key_data
,
             DecryptStatus status,
             const std::vector<uint8_t>& key_data) {*out_status = std::move(status);*out_key_data = std::move(key_data);
            loop->Quit();
          },
          &loop,
          out_status,
          out_key_data));
  loop.Run();
}



void CdmContextForOOPVDAsyncWaiter::GetHwConfigData(
    bool* out_success, std::vector<uint8_t>* out_config_data) {
  base::RunLoop loop;
  proxy_->GetHwConfigData(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<uint8_t>* out_config_data
,
             bool success,
             const std::vector<uint8_t>& config_data) {*out_success = std::move(success);*out_config_data = std::move(config_data);
            loop->Quit();
          },
          &loop,
          out_success,
          out_config_data));
  loop.Run();
}



void CdmContextForOOPVDAsyncWaiter::GetScreenResolutions(
    std::vector<::gfx::Size>* out_resolutions) {
  base::RunLoop loop;
  proxy_->GetScreenResolutions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::gfx::Size>* out_resolutions
,
             const std::vector<::gfx::Size>& resolutions) {*out_resolutions = std::move(resolutions);
            loop->Quit();
          },
          &loop,
          out_resolutions));
  loop.Run();
}

std::vector<::gfx::Size> CdmContextForOOPVDAsyncWaiter::GetScreenResolutions(
    ) {
  std::vector<::gfx::Size> async_wait_result;
  GetScreenResolutions(&async_wait_result);
  return async_wait_result;
}

void CdmContextForOOPVDAsyncWaiter::AllocateSecureBuffer(
    uint32_t size, ::mojo::PlatformHandle* out_secure_buffer) {
  base::RunLoop loop;
  proxy_->AllocateSecureBuffer(
      std::move(size),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PlatformHandle* out_secure_buffer
,
             ::mojo::PlatformHandle secure_buffer) {*out_secure_buffer = std::move(secure_buffer);
            loop->Quit();
          },
          &loop,
          out_secure_buffer));
  loop.Run();
}

::mojo::PlatformHandle CdmContextForOOPVDAsyncWaiter::AllocateSecureBuffer(
    uint32_t size) {
  ::mojo::PlatformHandle async_wait_result;
  AllocateSecureBuffer(std::move(size),&async_wait_result);
  return async_wait_result;
}

void CdmContextForOOPVDAsyncWaiter::ParseEncryptedSliceHeader(
    uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, bool* out_success, std::vector<uint8_t>* out_slice_header) {
  base::RunLoop loop;
  proxy_->ParseEncryptedSliceHeader(
      std::move(secure_handle),
      std::move(offset),
      std::move(stream_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::vector<uint8_t>* out_slice_header
,
             bool success,
             const std::vector<uint8_t>& slice_header) {*out_success = std::move(success);*out_slice_header = std::move(slice_header);
            loop->Quit();
          },
          &loop,
          out_success,
          out_slice_header));
  loop.Run();
}



void CdmContextForOOPVDAsyncWaiter::DecryptVideoBuffer(
    ::media::mojom::DecoderBufferPtr buffer, const std::vector<uint8_t>& bytes, DecryptStatus* out_status, ::media::mojom::DecoderBufferPtr* out_decoder_buffer, std::vector<uint8_t>* out_bytes) {
  base::RunLoop loop;
  proxy_->DecryptVideoBuffer(
      std::move(buffer),
      std::move(bytes),
      base::BindOnce(
          [](base::RunLoop* loop,
             DecryptStatus* out_status
,
             ::media::mojom::DecoderBufferPtr* out_decoder_buffer
,
             std::vector<uint8_t>* out_bytes
,
             DecryptStatus status,
             ::media::mojom::DecoderBufferPtr decoder_buffer,
             const std::vector<uint8_t>& bytes) {*out_status = std::move(status);*out_decoder_buffer = std::move(decoder_buffer);*out_bytes = std::move(bytes);
            loop->Quit();
          },
          &loop,
          out_status,
          out_decoder_buffer,
          out_bytes));
  loop.Run();
}








}  // media::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif