// media/mojo/mojom/audio_data.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_DATA_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_AUDIO_DATA_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_data.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {








class  AudioDataS16 {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDataS16, T>::value>;
  using DataView = AudioDataS16DataView;
  using Data_ = internal::AudioDataS16_Data;

  template <typename... Args>
  static AudioDataS16Ptr New(Args&&... args) {
    return AudioDataS16Ptr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDataS16Ptr From(const U& u) {
    return mojo::TypeConverter<AudioDataS16Ptr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDataS16>::Convert(*this);
  }


  AudioDataS16();

  AudioDataS16(
      int32_t channel_count,
      int32_t sample_rate,
      int32_t frame_count,
      ::blink::Vector<int16_t> data);


  ~AudioDataS16();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDataS16Ptr>
  AudioDataS16Ptr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDataS16::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDataS16::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDataS16::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDataS16_UnserializedMessageContext<
            UserType, AudioDataS16::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioDataS16::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioDataS16::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDataS16_UnserializedMessageContext<
            UserType, AudioDataS16::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDataS16::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t channel_count;
  
  int32_t sample_rate;
  
  int32_t frame_count;
  
  ::blink::Vector<int16_t> data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDataS16::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AudioDataS16Ptr AudioDataS16::Clone() const {
  return New(
      mojo::Clone(channel_count),
      mojo::Clone(sample_rate),
      mojo::Clone(frame_count),
      mojo::Clone(data)
  );
}

template <typename T, AudioDataS16::EnableIfSame<T>*>
bool AudioDataS16::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->channel_count, other_struct.channel_count))
    return false;
  if (!mojo::Equals(this->sample_rate, other_struct.sample_rate))
    return false;
  if (!mojo::Equals(this->frame_count, other_struct.frame_count))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, AudioDataS16::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.channel_count < rhs.channel_count)
    return true;
  if (rhs.channel_count < lhs.channel_count)
    return false;
  if (lhs.sample_rate < rhs.sample_rate)
    return true;
  if (rhs.sample_rate < lhs.sample_rate)
    return false;
  if (lhs.frame_count < rhs.frame_count)
    return true;
  if (rhs.frame_count < lhs.frame_count)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::media::mojom::blink::AudioDataS16::DataView,
                                         ::media::mojom::blink::AudioDataS16Ptr> {
  static bool IsNull(const ::media::mojom::blink::AudioDataS16Ptr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::AudioDataS16Ptr* output) { output->reset(); }

  static decltype(::media::mojom::blink::AudioDataS16::channel_count) channel_count(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->channel_count;
  }

  static decltype(::media::mojom::blink::AudioDataS16::sample_rate) sample_rate(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->sample_rate;
  }

  static decltype(::media::mojom::blink::AudioDataS16::frame_count) frame_count(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->frame_count;
  }

  static const decltype(::media::mojom::blink::AudioDataS16::data)& data(
      const ::media::mojom::blink::AudioDataS16Ptr& input) {
    return input->data;
  }

  static bool Read(::media::mojom::blink::AudioDataS16::DataView input, ::media::mojom::blink::AudioDataS16Ptr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_AUDIO_DATA_MOJOM_BLINK_H_