// gpu/ipc/common/vulkan_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_info.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_types.mojom-shared.h"




#include "gpu/ipc/common/vulkan_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VulkanPhysicalDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VulkanPhysicalDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::properties(input)) in_properties = Traits::properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->properties)::BaseType> properties_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDevicePropertiesDataView>(
      in_properties,
      properties_fragment);

    fragment->properties.Set(
        properties_fragment.is_null() ? nullptr : properties_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->properties.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in VulkanPhysicalDeviceInfo struct");

    decltype(Traits::extensions(input)) in_extensions = Traits::extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensions)::BaseType>
        extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
      in_extensions,
      extensions_fragment,
      &extensions_validate_params);

    fragment->extensions.Set(
        extensions_fragment.is_null() ? nullptr : extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extensions in VulkanPhysicalDeviceInfo struct");

    decltype(Traits::features(input)) in_features = Traits::features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->features)::BaseType> features_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceFeaturesDataView>(
      in_features,
      features_fragment);

    fragment->features.Set(
        features_fragment.is_null() ? nullptr : features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in VulkanPhysicalDeviceInfo struct");

    fragment->feature_sampler_ycbcr_conversion = Traits::feature_sampler_ycbcr_conversion(input);

    fragment->feature_protected_memory = Traits::feature_protected_memory(input);

    decltype(Traits::queue_families(input)) in_queue_families = Traits::queue_families(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->queue_families)::BaseType>
        queue_families_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& queue_families_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>>(
      in_queue_families,
      queue_families_fragment,
      &queue_families_validate_params);

    fragment->queue_families.Set(
        queue_families_fragment.is_null() ? nullptr : queue_families_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->queue_families.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null queue_families in VulkanPhysicalDeviceInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VulkanPhysicalDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VulkanPhysicalDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VulkanInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VulkanInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VulkanInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->api_version = Traits::api_version(input);

    fragment->used_api_version = Traits::used_api_version(input);

    decltype(Traits::instance_extensions(input)) in_instance_extensions = Traits::instance_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_extensions)::BaseType>
        instance_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& instance_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>>(
      in_instance_extensions,
      instance_extensions_fragment,
      &instance_extensions_validate_params);

    fragment->instance_extensions.Set(
        instance_extensions_fragment.is_null() ? nullptr : instance_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_extensions in VulkanInfo struct");

    decltype(Traits::enabled_instance_extensions(input)) in_enabled_instance_extensions = Traits::enabled_instance_extensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enabled_instance_extensions)::BaseType>
        enabled_instance_extensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enabled_instance_extensions_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_enabled_instance_extensions,
      enabled_instance_extensions_fragment,
      &enabled_instance_extensions_validate_params);

    fragment->enabled_instance_extensions.Set(
        enabled_instance_extensions_fragment.is_null() ? nullptr : enabled_instance_extensions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->enabled_instance_extensions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null enabled_instance_extensions in VulkanInfo struct");

    decltype(Traits::instance_layers(input)) in_instance_layers = Traits::instance_layers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->instance_layers)::BaseType>
        instance_layers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& instance_layers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>>(
      in_instance_layers,
      instance_layers_fragment,
      &instance_layers_validate_params);

    fragment->instance_layers.Set(
        instance_layers_fragment.is_null() ? nullptr : instance_layers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->instance_layers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null instance_layers in VulkanInfo struct");

    decltype(Traits::physical_devices(input)) in_physical_devices = Traits::physical_devices(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->physical_devices)::BaseType>
        physical_devices_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& physical_devices_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gpu::mojom::VulkanPhysicalDeviceInfoDataView>>(
      in_physical_devices,
      physical_devices_fragment,
      &physical_devices_validate_params);

    fragment->physical_devices.Set(
        physical_devices_fragment.is_null() ? nullptr : physical_devices_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->physical_devices.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null physical_devices in VulkanInfo struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VulkanInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VulkanInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void VulkanPhysicalDeviceInfoDataView::GetPropertiesDataView(
    ::gpu::mojom::VkPhysicalDevicePropertiesDataView* output) {
  auto pointer = data_->properties.Get();
  *output = ::gpu::mojom::VkPhysicalDevicePropertiesDataView(pointer, message_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetExtensionsDataView(
    mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output) {
  auto pointer = data_->extensions.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>(pointer, message_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetFeaturesDataView(
    ::gpu::mojom::VkPhysicalDeviceFeaturesDataView* output) {
  auto pointer = data_->features.Get();
  *output = ::gpu::mojom::VkPhysicalDeviceFeaturesDataView(pointer, message_);
}
inline void VulkanPhysicalDeviceInfoDataView::GetQueueFamiliesDataView(
    mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>* output) {
  auto pointer = data_->queue_families.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkQueueFamilyPropertiesDataView>(pointer, message_);
}


inline void VulkanInfoDataView::GetInstanceExtensionsDataView(
    mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>* output) {
  auto pointer = data_->instance_extensions.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkExtensionPropertiesDataView>(pointer, message_);
}
inline void VulkanInfoDataView::GetEnabledInstanceExtensionsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->enabled_instance_extensions.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void VulkanInfoDataView::GetInstanceLayersDataView(
    mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>* output) {
  auto pointer = data_->instance_layers.Get();
  *output = mojo::ArrayDataView<::gpu::mojom::VkLayerPropertiesDataView>(pointer, message_);
}
inline void VulkanInfoDataView::GetPhysicalDevicesDataView(
    mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>* output) {
  auto pointer = data_->physical_devices.Get();
  *output = mojo::ArrayDataView<VulkanPhysicalDeviceInfoDataView>(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // GPU_IPC_COMMON_VULKAN_INFO_MOJOM_SHARED_H_