// gpu/ipc/common/device_perf_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "gpu/ipc/common/device_perf_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/device_perf_info.mojom-params-data.h"
namespace gpu {
namespace mojom {

NOINLINE static const char* Direct3DFeatureLevelToStringHelper(Direct3DFeatureLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Direct3DFeatureLevel::k1_0_Generic:
      return "k1_0_Generic";
    case Direct3DFeatureLevel::k1_0_Core:
      return "k1_0_Core";
    case Direct3DFeatureLevel::k9_1:
      return "k9_1";
    case Direct3DFeatureLevel::k9_2:
      return "k9_2";
    case Direct3DFeatureLevel::k9_3:
      return "k9_3";
    case Direct3DFeatureLevel::k10_0:
      return "k10_0";
    case Direct3DFeatureLevel::k10_1:
      return "k10_1";
    case Direct3DFeatureLevel::k11_0:
      return "k11_0";
    case Direct3DFeatureLevel::k11_1:
      return "k11_1";
    case Direct3DFeatureLevel::k12_0:
      return "k12_0";
    case Direct3DFeatureLevel::k12_1:
      return "k12_1";
    case Direct3DFeatureLevel::k12_2:
      return "k12_2";
    default:
      return nullptr;
  }
}

std::string Direct3DFeatureLevelToString(Direct3DFeatureLevel value) {
  const char *str = Direct3DFeatureLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Direct3DFeatureLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Direct3DFeatureLevel value) {
  return os << Direct3DFeatureLevelToString(value);
}

NOINLINE static const char* HasDiscreteGpuToStringHelper(HasDiscreteGpu value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case HasDiscreteGpu::kUnknown:
      return "kUnknown";
    case HasDiscreteGpu::kNo:
      return "kNo";
    case HasDiscreteGpu::kYes:
      return "kYes";
    default:
      return nullptr;
  }
}

std::string HasDiscreteGpuToString(HasDiscreteGpu value) {
  const char *str = HasDiscreteGpuToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown HasDiscreteGpu value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, HasDiscreteGpu value) {
  return os << HasDiscreteGpuToString(value);
}

namespace internal {


// static
bool DevicePerfInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePerfInfo_Data* object =
      static_cast<const DevicePerfInfo_Data*>(data);

  return true;
}

DevicePerfInfo_Data::DevicePerfInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gpu

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::Direct3DFeatureLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::Direct3DFeatureLevel value) {
  return std::move(context).WriteString(::gpu::mojom::Direct3DFeatureLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::gpu::mojom::HasDiscreteGpu>::WriteIntoTrace(
   perfetto::TracedValue context, ::gpu::mojom::HasDiscreteGpu value) {
  return std::move(context).WriteString(::gpu::mojom::HasDiscreteGpuToString(value));
}

} // namespace perfetto