// extensions/common/mojom/message_port.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "extensions/common/mojom/message_port.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/message_port.mojom-params-data.h"
namespace extensions {
namespace mojom {

NOINLINE static const char* SerializationFormatToStringHelper(SerializationFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SerializationFormat::kStructuredCloned:
      return "kStructuredCloned";
    case SerializationFormat::kJson:
      return "kJson";
    default:
      return nullptr;
  }
}

std::string SerializationFormatToString(SerializationFormat value) {
  const char *str = SerializationFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SerializationFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SerializationFormat value) {
  return os << SerializationFormatToString(value);
}

NOINLINE static const char* ChannelTypeToStringHelper(ChannelType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ChannelType::kSendMessage:
      return "kSendMessage";
    case ChannelType::kSendRequest:
      return "kSendRequest";
    case ChannelType::kConnect:
      return "kConnect";
    case ChannelType::kNative:
      return "kNative";
    default:
      return nullptr;
  }
}

std::string ChannelTypeToString(ChannelType value) {
  const char *str = ChannelTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ChannelType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ChannelType value) {
  return os << ChannelTypeToString(value);
}

NOINLINE static const char* MessagingEndpointTypeToStringHelper(MessagingEndpointType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MessagingEndpointType::kExtension:
      return "kExtension";
    case MessagingEndpointType::kWebPage:
      return "kWebPage";
    case MessagingEndpointType::kContentScript:
      return "kContentScript";
    case MessagingEndpointType::kUserScript:
      return "kUserScript";
    case MessagingEndpointType::kNativeApp:
      return "kNativeApp";
    default:
      return nullptr;
  }
}

std::string MessagingEndpointTypeToString(MessagingEndpointType value) {
  const char *str = MessagingEndpointTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MessagingEndpointType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MessagingEndpointType value) {
  return os << MessagingEndpointTypeToString(value);
}

namespace internal {


// static
bool PortId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PortId_Data* object =
      static_cast<const PortId_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->context_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->context_id, validation_context))
    return false;


  if (!::extensions::mojom::internal::SerializationFormat_Data
        ::Validate(object->serialization_format, validation_context))
    return false;

  return true;
}

PortId_Data::PortId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagingEndpoint_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagingEndpoint_Data* object =
      static_cast<const MessagingEndpoint_Data*>(data);


  if (!::extensions::mojom::internal::MessagingEndpointType_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& extension_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->extension_id, validation_context,
                                         &extension_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& native_app_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->native_app_name, validation_context,
                                         &native_app_name_validate_params)) {
    return false;
  }

  return true;
}

MessagingEndpoint_Data::MessagingEndpoint_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TabConnectionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TabConnectionInfo_Data* object =
      static_cast<const TabConnectionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tab, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->tab, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& document_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->document_id, validation_context,
                                         &document_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_lifecycle, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& document_lifecycle_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->document_lifecycle, validation_context,
                                         &document_lifecycle_validate_params)) {
    return false;
  }

  return true;
}

TabConnectionInfo_Data::TabConnectionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ExternalConnectionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExternalConnectionInfo_Data* object =
      static_cast<const ExternalConnectionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_endpoint, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_endpoint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& target_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->target_id, validation_context,
                                         &target_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  return true;
}

ExternalConnectionInfo_Data::ExternalConnectionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Message_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Message_Data* object =
      static_cast<const Message_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }


  if (!::extensions::mojom::internal::SerializationFormat_Data
        ::Validate(object->format, validation_context))
    return false;

  return true;
}

Message_Data::Message_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagePort_DispatchDisconnect_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagePort_DispatchDisconnect_Params_Data* object =
      static_cast<const MessagePort_DispatchDisconnect_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error, validation_context,
                                         &error_validate_params)) {
    return false;
  }

  return true;
}

MessagePort_DispatchDisconnect_Params_Data::MessagePort_DispatchDisconnect_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagePort_DeliverMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagePort_DeliverMessage_Params_Data* object =
      static_cast<const MessagePort_DeliverMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

MessagePort_DeliverMessage_Params_Data::MessagePort_DeliverMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagePortHost_ClosePort_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagePortHost_ClosePort_Params_Data* object =
      static_cast<const MessagePortHost_ClosePort_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

MessagePortHost_ClosePort_Params_Data::MessagePortHost_ClosePort_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagePortHost_PostMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagePortHost_PostMessage_Params_Data* object =
      static_cast<const MessagePortHost_PostMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

MessagePortHost_PostMessage_Params_Data::MessagePortHost_PostMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MessagePortHost_ResponsePending_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MessagePortHost_ResponsePending_Params_Data* object =
      static_cast<const MessagePortHost_ResponsePending_Params_Data*>(data);

  return true;
}

MessagePortHost_ResponsePending_Params_Data::MessagePortHost_ResponsePending_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace extensions

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::SerializationFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::SerializationFormat value) {
  return std::move(context).WriteString(::extensions::mojom::SerializationFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::ChannelType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::ChannelType value) {
  return std::move(context).WriteString(::extensions::mojom::ChannelTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::extensions::mojom::MessagingEndpointType>::WriteIntoTrace(
   perfetto::TracedValue context, ::extensions::mojom::MessagingEndpointType value) {
  return std::move(context).WriteString(::extensions::mojom::MessagingEndpointTypeToString(value));
}

} // namespace perfetto