// extensions/common/mojom/frame.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "extensions/common/mojom/frame.mojom-shared-internal.h"
#include "mojo/public/mojom/base/uuid.mojom-shared.h"
#include "extensions/common/mojom/code_injection.mojom-shared.h"
#include "extensions/common/mojom/context_type.mojom-shared.h"
#include "extensions/common/mojom/extra_response_data.mojom-shared.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "extensions/common/mojom/injection_type.mojom-shared.h"
#include "extensions/common/mojom/extension_id.mojom-shared.h"
#include "extensions/common/mojom/match_origin_as_fallback.mojom-shared.h"
#include "extensions/common/mojom/message_port.mojom-shared.h"
#include "extensions/common/mojom/run_location.mojom-shared.h"
#include "extensions/common/mojom/stack_frame.mojom-shared.h"
#include "extensions/common/mojom/view_type.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"


namespace extensions::mojom {
class ExecuteCodeParamsDataView;

class RequestParamsDataView;



}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::ExecuteCodeParamsDataView> {
  using Data = ::extensions::mojom::internal::ExecuteCodeParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::RequestParamsDataView> {
  using Data = ::extensions::mojom::internal::RequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class LocalFrameInterfaceBase {};

using LocalFramePtrDataView =
    mojo::InterfacePtrDataView<LocalFrameInterfaceBase>;
using LocalFrameRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameInterfaceBase>;
using LocalFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameInterfaceBase>;
class LocalFrameHostInterfaceBase {};

using LocalFrameHostPtrDataView =
    mojo::InterfacePtrDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalFrameHostInterfaceBase>;
using LocalFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalFrameHostInterfaceBase>;


class ExecuteCodeParamsDataView {
 public:
  ExecuteCodeParamsDataView() = default;

  ExecuteCodeParamsDataView(
      internal::ExecuteCodeParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostIdDataView(
      ::extensions::mojom::HostIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostId(UserType* output) {
    
    auto* pointer = data_->host_id.Get();
    return mojo::internal::Deserialize<::extensions::mojom::HostIDDataView>(
        pointer, output, message_);
  }
  inline void GetInjectionDataView(
      ::extensions::mojom::CodeInjectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInjection(UserType* output) {
    
    auto* pointer = !data_->injection.is_null() ? &data_->injection : nullptr;
    return mojo::internal::Deserialize<::extensions::mojom::CodeInjectionDataView>(
        pointer, output, message_);
  }
  inline void GetWebviewSrcDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebviewSrc(UserType* output) {
    
    auto* pointer = data_->webview_src.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMatchOriginAsFallbackBehavior(UserType* output) const {
    auto data_value = data_->match_origin_as_fallback_behavior;
    return mojo::internal::Deserialize<::extensions::mojom::MatchOriginAsFallbackBehavior>(
        data_value, output);
  }
  ::extensions::mojom::MatchOriginAsFallbackBehavior match_origin_as_fallback_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::MatchOriginAsFallbackBehavior>(data_->match_origin_as_fallback_behavior));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRunAt(UserType* output) const {
    auto data_value = data_->run_at;
    return mojo::internal::Deserialize<::extensions::mojom::RunLocation>(
        data_value, output);
  }
  ::extensions::mojom::RunLocation run_at() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::RunLocation>(data_->run_at));
  }
  bool is_web_view() const {
    return data_->is_web_view;
  }
 private:
  internal::ExecuteCodeParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestParamsDataView {
 public:
  RequestParamsDataView() = default;

  RequestParamsDataView(
      internal::RequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetArgumentsDataView(
      ::mojo_base::mojom::ListValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArguments(UserType* output) {
    
    auto* pointer = data_->arguments.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ListValueDataView>(
        pointer, output, message_);
  }
  inline void GetExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadContextType(UserType* output) const {
    auto data_value = data_->context_type;
    return mojo::internal::Deserialize<::extensions::mojom::ContextType>(
        data_value, output);
  }
  ::extensions::mojom::ContextType context_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ContextType>(data_->context_type));
  }
  int32_t request_id() const {
    return data_->request_id;
  }
  bool has_callback() const {
    return data_->has_callback;
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  int32_t worker_thread_id() const {
    return data_->worker_thread_id;
  }
  int64_t service_worker_version_id() const {
    return data_->service_worker_version_id;
  }
  inline void GetJsCallstackDataView(
      mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsCallstack(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>, UserType>(),
    "Attempting to read the optional `js_callstack` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadJsCallstack` instead "
    "of `ReadJsCallstack if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->js_callstack.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::StackFrameDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_FRAME_MOJOM_DATA_VIEW_H_