// extensions/common/mojom/code_injection.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_DATA_VIEW_H_
#define EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "extensions/common/mojom/code_injection.mojom-shared-internal.h"
#include "extensions/common/mojom/css_origin.mojom-shared.h"
#include "extensions/common/mojom/execution_world.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_evaluation_params.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace extensions::mojom {
class JSSourceDataView;

class CSSSourceDataView;

class JSInjectionDataView;

class CSSInjectionDataView;

class CodeInjectionDataView;


}  // extensions::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::JSSourceDataView> {
  using Data = ::extensions::mojom::internal::JSSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CSSSourceDataView> {
  using Data = ::extensions::mojom::internal::CSSSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::JSInjectionDataView> {
  using Data = ::extensions::mojom::internal::JSInjection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CSSInjectionDataView> {
  using Data = ::extensions::mojom::internal::CSSInjection_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::CodeInjectionDataView> {
  using Data = ::extensions::mojom::internal::CodeInjection_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {


enum class CSSInjection_Operation : int32_t {
  
  kAdd = 0,
  
  kRemove = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CSSInjection_Operation value);
inline bool IsKnownEnumValue(CSSInjection_Operation value) {
  return internal::CSSInjection_Operation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class JSSourceDataView {
 public:
  JSSourceDataView() = default;

  JSSourceDataView(
      internal::JSSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScriptUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptUrl(UserType* output) {
    
    auto* pointer = data_->script_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::JSSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSSSourceDataView {
 public:
  CSSSourceDataView() = default;

  CSSSourceDataView(
      internal::CSSSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKey` instead "
    "of `ReadKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::CSSSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class JSInjectionDataView {
 public:
  JSInjectionDataView() = default;

  JSInjectionDataView(
      internal::JSInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<JSSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::JSSourceDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWorld(UserType* output) const {
    auto data_value = data_->world;
    return mojo::internal::Deserialize<::extensions::mojom::ExecutionWorld>(
        data_value, output);
  }
  ::extensions::mojom::ExecutionWorld world() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ExecutionWorld>(data_->world));
  }
  inline void GetWorldIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldId` instead "
    "of `ReadWorldId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWantsResult(UserType* output) const {
    auto data_value = data_->wants_result;
    return mojo::internal::Deserialize<::blink::mojom::WantResultOption>(
        data_value, output);
  }
  ::blink::mojom::WantResultOption wants_result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::WantResultOption>(data_->wants_result));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUserGesture(UserType* output) const {
    auto data_value = data_->user_gesture;
    return mojo::internal::Deserialize<::blink::mojom::UserActivationOption>(
        data_value, output);
  }
  ::blink::mojom::UserActivationOption user_gesture() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::UserActivationOption>(data_->user_gesture));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWaitForPromise(UserType* output) const {
    auto data_value = data_->wait_for_promise;
    return mojo::internal::Deserialize<::blink::mojom::PromiseResultOption>(
        data_value, output);
  }
  ::blink::mojom::PromiseResultOption wait_for_promise() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PromiseResultOption>(data_->wait_for_promise));
  }
 private:
  internal::JSInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CSSInjectionDataView {
 public:
  CSSInjectionDataView() = default;

  CSSInjectionDataView(
      internal::CSSInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourcesDataView(
      mojo::ArrayDataView<CSSSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSources(UserType* output) {
    
    auto* pointer = data_->sources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::extensions::mojom::CSSSourceDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCssOrigin(UserType* output) const {
    auto data_value = data_->css_origin;
    return mojo::internal::Deserialize<::extensions::mojom::CSSOrigin>(
        data_value, output);
  }
  ::extensions::mojom::CSSOrigin css_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::CSSOrigin>(data_->css_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOperation(UserType* output) const {
    auto data_value = data_->operation;
    return mojo::internal::Deserialize<::extensions::mojom::CSSInjection_Operation>(
        data_value, output);
  }
  CSSInjection_Operation operation() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::CSSInjection_Operation>(data_->operation));
  }
 private:
  internal::CSSInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CodeInjectionDataView {
 public:
  using Tag = internal::CodeInjection_Data::CodeInjection_Tag;

  CodeInjectionDataView() = default;

  CodeInjectionDataView(
      internal::CodeInjection_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_css() const { return data_->tag == Tag::kCss; }
  inline void GetCssDataView(
      CSSInjectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadCss(UserType* output) const {
    
    CHECK(is_css());
    return mojo::internal::Deserialize<::extensions::mojom::CSSInjectionDataView>(
        data_->data.f_css.Get(), output, message_);
  }
  bool is_js() const { return data_->tag == Tag::kJs; }
  inline void GetJsDataView(
      JSInjectionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadJs(UserType* output) const {
    
    CHECK(is_js());
    return mojo::internal::Deserialize<::extensions::mojom::JSInjectionDataView>(
        data_->data.f_js.Get(), output, message_);
  }

 private:
  internal::CodeInjection_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // extensions::mojom

#endif  // EXTENSIONS_COMMON_MOJOM_CODE_INJECTION_MOJOM_DATA_VIEW_H_