// device/vr/public/mojom/xr_session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_session.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "device/vr/public/mojom/xr_session.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::device::mojom::RequestSessionError>
    : public mojo::internal::EnumHashImpl<::device::mojom::RequestSessionError> {};

template <>
struct hash<::device::mojom::XRSessionFeature>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionFeature> {};

template <>
struct hash<::device::mojom::XRSessionMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionMode> {};

template <>
struct hash<::device::mojom::XRDepthUsage>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDepthUsage> {};

template <>
struct hash<::device::mojom::XRDepthDataFormat>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDepthDataFormat> {};

template <>
struct hash<::device::mojom::XRDepthType>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDepthType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::RequestSessionError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::RequestSessionError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRSessionFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRSessionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDepthUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRDepthUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDepthDataFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRDepthDataFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDepthType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRDepthType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTrackedImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_bitmap,
      bitmap_fragment);

    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bitmap.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmap in XRTrackedImage struct");

    decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size_in_pixels,
      size_in_pixels_fragment);

    fragment->size_in_pixels.Set(
        size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size_in_pixels.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size_in_pixels in XRTrackedImage struct");

    fragment->width_in_meters = Traits::width_in_meters(input);
  }

  static bool Deserialize(::device::mojom::internal::XRTrackedImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRTrackedImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::usage_preferences(input)) in_usage_preferences = Traits::usage_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage_preferences)::BaseType>
        usage_preferences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& usage_preferences_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthUsage_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthUsage>>(
      in_usage_preferences,
      usage_preferences_fragment,
      &usage_preferences_validate_params);

    fragment->usage_preferences.Set(
        usage_preferences_fragment.is_null() ? nullptr : usage_preferences_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usage_preferences.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_preferences in XRDepthOptions struct");

    decltype(Traits::data_format_preferences(input)) in_data_format_preferences = Traits::data_format_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_format_preferences)::BaseType>
        data_format_preferences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_format_preferences_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthDataFormat_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthDataFormat>>(
      in_data_format_preferences,
      data_format_preferences_fragment,
      &data_format_preferences_validate_params);

    fragment->data_format_preferences.Set(
        data_format_preferences_fragment.is_null() ? nullptr : data_format_preferences_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data_format_preferences.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_format_preferences in XRDepthOptions struct");

    decltype(Traits::depth_type_request(input)) in_depth_type_request = Traits::depth_type_request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->depth_type_request)::BaseType>
        depth_type_request_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& depth_type_request_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthType_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthType>>(
      in_depth_type_request,
      depth_type_request_fragment,
      &depth_type_request_validate_params);

    fragment->depth_type_request.Set(
        depth_type_request_fragment.is_null() ? nullptr : depth_type_request_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->depth_type_request.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null depth_type_request in XRDepthOptions struct");

    fragment->match_depth_view = Traits::match_depth_view(input);
  }

  static bool Deserialize(::device::mojom::internal::XRDepthOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSessionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::XRSessionMode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->required_features)::BaseType>
        required_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
      in_required_features,
      required_features_fragment,
      &required_features_validate_params);

    fragment->required_features.Set(
        required_features_fragment.is_null() ? nullptr : required_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->required_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null required_features in XRSessionOptions struct");

    decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_features)::BaseType>
        optional_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
      in_optional_features,
      optional_features_fragment,
      &optional_features_validate_params);

    fragment->optional_features.Set(
        optional_features_fragment.is_null() ? nullptr : optional_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->optional_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null optional_features in XRSessionOptions struct");

    decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracked_images)::BaseType>
        tracked_images_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
      in_tracked_images,
      tracked_images_fragment,
      &tracked_images_validate_params);

    fragment->tracked_images.Set(
        tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tracked_images.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tracked_images in XRSessionOptions struct");

    decltype(Traits::depth_options(input)) in_depth_options = Traits::depth_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->depth_options)::BaseType> depth_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::XRDepthOptionsDataView>(
      in_depth_options,
      depth_options_fragment);

    fragment->depth_options.Set(
        depth_options_fragment.is_null() ? nullptr : depth_options_fragment.data());

    fragment->trace_id = Traits::trace_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRSessionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrFrameStatisticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrFrameStatisticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrFrameStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->trace_id = Traits::trace_id(input);

    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_duration,
      duration_fragment);

    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duration in XrFrameStatistics struct");

    fragment->num_frames = Traits::num_frames(input);

    fragment->dropped_frames = Traits::dropped_frames(input);

    decltype(Traits::frame_data_time(input)) in_frame_data_time = Traits::frame_data_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_data_time)::BaseType> frame_data_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_frame_data_time,
      frame_data_time_fragment);

    fragment->frame_data_time.Set(
        frame_data_time_fragment.is_null() ? nullptr : frame_data_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_data_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_data_time in XrFrameStatistics struct");

    decltype(Traits::page_animation_frame_time(input)) in_page_animation_frame_time = Traits::page_animation_frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_animation_frame_time)::BaseType> page_animation_frame_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_page_animation_frame_time,
      page_animation_frame_time_fragment);

    fragment->page_animation_frame_time.Set(
        page_animation_frame_time_fragment.is_null() ? nullptr : page_animation_frame_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_animation_frame_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_animation_frame_time in XrFrameStatistics struct");

    decltype(Traits::submit_frame_time(input)) in_submit_frame_time = Traits::submit_frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->submit_frame_time)::BaseType> submit_frame_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_submit_frame_time,
      submit_frame_time_fragment);

    fragment->submit_frame_time.Set(
        submit_frame_time_fragment.is_null() ? nullptr : submit_frame_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->submit_frame_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null submit_frame_time in XrFrameStatistics struct");
  }

  static bool Deserialize(::device::mojom::internal::XrFrameStatistics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XrFrameStatisticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrLogMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrLogMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrLogMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->trace_id = Traits::trace_id(input);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in XrLogMessage struct");
  }

  static bool Deserialize(::device::mojom::internal::XrLogMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XrLogMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void XRTrackedImageDataView::GetBitmapDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void XRTrackedImageDataView::GetSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void XRDepthOptionsDataView::GetUsagePreferencesDataView(
    mojo::ArrayDataView<XRDepthUsage>* output) {
  auto pointer = data_->usage_preferences.Get();
  *output = mojo::ArrayDataView<XRDepthUsage>(pointer, message_);
}
inline void XRDepthOptionsDataView::GetDataFormatPreferencesDataView(
    mojo::ArrayDataView<XRDepthDataFormat>* output) {
  auto pointer = data_->data_format_preferences.Get();
  *output = mojo::ArrayDataView<XRDepthDataFormat>(pointer, message_);
}
inline void XRDepthOptionsDataView::GetDepthTypeRequestDataView(
    mojo::ArrayDataView<XRDepthType>* output) {
  auto pointer = data_->depth_type_request.Get();
  *output = mojo::ArrayDataView<XRDepthType>(pointer, message_);
}


inline void XRSessionOptionsDataView::GetRequiredFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->required_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetOptionalFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->optional_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetTrackedImagesDataView(
    mojo::ArrayDataView<XRTrackedImageDataView>* output) {
  auto pointer = data_->tracked_images.Get();
  *output = mojo::ArrayDataView<XRTrackedImageDataView>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetDepthOptionsDataView(
    XRDepthOptionsDataView* output) {
  auto pointer = data_->depth_options.Get();
  *output = XRDepthOptionsDataView(pointer, message_);
}


inline void XrFrameStatisticsDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetFrameDataTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->frame_data_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetPageAnimationFrameTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->page_animation_frame_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetSubmitFrameTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->submit_frame_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void XrLogMessageDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::RequestSessionError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::RequestSessionError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRSessionFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRSessionFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRSessionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRSessionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRDepthUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRDepthUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRDepthDataFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRDepthDataFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRDepthType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRDepthType value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_