// content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/auction_shared_storage_host.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

NOINLINE static const char* AuctionWorkletFunctionToStringHelper(AuctionWorkletFunction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuctionWorkletFunction::kBidderGenerateBid:
      return "kBidderGenerateBid";
    case AuctionWorkletFunction::kBidderReportWin:
      return "kBidderReportWin";
    case AuctionWorkletFunction::kSellerScoreAd:
      return "kSellerScoreAd";
    case AuctionWorkletFunction::kSellerReportResult:
      return "kSellerReportResult";
    default:
      return nullptr;
  }
}

std::string AuctionWorkletFunctionToString(AuctionWorkletFunction value) {
  const char *str = AuctionWorkletFunctionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuctionWorkletFunction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuctionWorkletFunction value) {
  return os << AuctionWorkletFunctionToString(value);
}

namespace internal {


// static
bool AuctionSharedStorageHost_SharedStorageUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionSharedStorageHost_SharedStorageUpdate_Params_Data* object =
      static_cast<const AuctionSharedStorageHost_SharedStorageUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method_with_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->method_with_options, validation_context))
    return false;


  if (!::auction_worklet::mojom::internal::AuctionWorkletFunction_Data
        ::Validate(object->source_auction_worklet_function, validation_context))
    return false;

  return true;
}

AuctionSharedStorageHost_SharedStorageUpdate_Params_Data::AuctionSharedStorageHost_SharedStorageUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data* object =
      static_cast<const AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->methods_with_options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->methods_with_options, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->with_lock, validation_context))
    return false;


  if (!::auction_worklet::mojom::internal::AuctionWorkletFunction_Data
        ::Validate(object->source_auction_worklet_function, validation_context))
    return false;

  return true;
}

AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data::AuctionSharedStorageHost_SharedStorageBatchUpdate_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::AuctionWorkletFunction>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::AuctionWorkletFunction value) {
  return std::move(context).WriteString(::auction_worklet::mojom::AuctionWorkletFunctionToString(value));
}

} // namespace perfetto